/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.NERClassifierCombiner;
import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.io.FileSequentialCollection;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationPipeline;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.AnnotatorFactory;
import edu.stanford.nlp.pipeline.AnnotatorPool;
import edu.stanford.nlp.pipeline.CharniakParserAnnotator;
import edu.stanford.nlp.pipeline.CleanXmlAnnotator;
import edu.stanford.nlp.pipeline.DeterministicCorefAnnotator;
import edu.stanford.nlp.pipeline.GenderAnnotator;
import edu.stanford.nlp.pipeline.MorphaAnnotator;
import edu.stanford.nlp.pipeline.NERCombinerAnnotator;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.PTBTokenizerAnnotator;
import edu.stanford.nlp.pipeline.ParserAnnotator;
import edu.stanford.nlp.pipeline.RegexNERAnnotator;
import edu.stanford.nlp.pipeline.Requirement;
import edu.stanford.nlp.pipeline.TextOutputter;
import edu.stanford.nlp.pipeline.TrueCaseAnnotator;
import edu.stanford.nlp.pipeline.WhitespaceTokenizerAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.TreePrint;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.StanfordRedwoodConfiguration;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class StanfordCoreNLP
extends AnnotationPipeline {
    public static final String STANFORD_TOKENIZE = "tokenize";
    public static final String STANFORD_CLEAN_XML = "cleanxml";
    public static final String STANFORD_SSPLIT = "ssplit";
    public static final String STANFORD_POS = "pos";
    public static final String STANFORD_LEMMA = "lemma";
    public static final String STANFORD_NER = "ner";
    public static final String STANFORD_REGEXNER = "regexner";
    public static final String STANFORD_GENDER = "gender";
    private static final String STANFORD_NFL_TOKENIZE = "nfltokenize";
    public static final String STANFORD_NFL = "nfl";
    public static final String STANFORD_TRUECASE = "truecase";
    public static final String STANFORD_PARSE = "parse";
    public static final String STANFORD_DETERMINISTIC_COREF = "dcoref";
    public static final String POS_TAGGING = "pos parse";
    public static final String CUSTOM_ANNOTATOR_PREFIX = "customAnnotatorClass.";
    private static final String PROPS_SUFFIX = ".properties";
    public static final String NEWLINE_SPLITTER_PROPERTY = "ssplit.eolonly";
    public static final String DEFAULT_OUTPUT_FORMAT = StanfordCoreNLP.isXMLOutputPresent() ? "xml" : "text";
    private TreePrint constituentTreePrinter;
    private TreePrint dependencyTreePrinter;
    private GrammaticalStructureFactory gsf;
    private int numWords;
    private static AnnotatorPool pool = null;
    private Properties properties;

    public StanfordCoreNLP() {
        this((Properties)null);
    }

    public StanfordCoreNLP(Properties props) {
        this(props, props == null || PropertiesUtils.getBool(props, "enforceRequirements", true));
    }

    public StanfordCoreNLP(Properties props, boolean enforceRequirements) {
        this.construct(props, enforceRequirements);
    }

    public StanfordCoreNLP(String propsFileNamePrefix) {
        this(propsFileNamePrefix, true);
    }

    public StanfordCoreNLP(String propsFileNamePrefix, boolean enforceRequirements) {
        Properties props = StanfordCoreNLP.loadProperties(propsFileNamePrefix);
        if (props == null) {
            throw new RuntimeIOException("ERROR: cannot find properties file \"" + propsFileNamePrefix + "\" in the classpath!");
        }
        this.construct(props, enforceRequirements);
    }

    private static String getRequiredProperty(Properties props, String name) {
        String val = props.getProperty(name);
        if (val == null) {
            System.err.println("Missing property \"" + name + "\"!");
            StanfordCoreNLP.printRequiredProperties(System.err);
            throw new RuntimeException("Missing property: \"" + name + '\"');
        }
        return val;
    }

    private static Properties loadPropertiesFromClasspath() {
        List<String> validNames = Arrays.asList("StanfordCoreNLP", "edu.stanford.nlp.pipeline.StanfordCoreNLP");
        for (String name : validNames) {
            Properties props = StanfordCoreNLP.loadProperties(name);
            if (props == null) continue;
            return props;
        }
        throw new RuntimeException("ERROR: Could not find properties file in the classpath!");
    }

    private static Properties loadProperties(String name) {
        return StanfordCoreNLP.loadProperties(name, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String name, ClassLoader loader) {
        if (name.endsWith(PROPS_SUFFIX)) {
            name = name.substring(0, name.length() - PROPS_SUFFIX.length());
        }
        name = name.replace('.', '/');
        name = name + PROPS_SUFFIX;
        Properties result = null;
        System.err.println("Searching for resource: " + name);
        InputStream in = loader.getResourceAsStream(name);
        try {
            if (in != null) {
                result = new Properties();
                result.load(in);
            }
        }
        catch (IOException e) {
            result = null;
        }
        finally {
            IOUtils.closeIgnoringExceptions(in);
        }
        return result;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public TreePrint getConstituentTreePrinter() {
        return this.constituentTreePrinter;
    }

    public TreePrint getDependencyTreePrinter() {
        return this.dependencyTreePrinter;
    }

    public double getBeamPrintingOption() {
        return PropertiesUtils.getDouble(this.properties, "printable.relation.beam", 0.0);
    }

    public String getEncoding() {
        return this.properties.getProperty("encoding", "UTF-8");
    }

    public static boolean isXMLOutputPresent() {
        try {
            Class<?> clazz = Class.forName("edu.stanford.nlp.pipeline.XMLOutputter");
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        return true;
    }

    private void construct(Properties props, boolean enforceRequirements) {
        this.numWords = 0;
        this.constituentTreePrinter = new TreePrint("penn");
        this.dependencyTreePrinter = new TreePrint("typedDependenciesCollapsed");
        this.gsf = new PennTreebankLanguagePack().grammaticalStructureFactory();
        if (props == null) {
            props = StanfordCoreNLP.loadPropertiesFromClasspath();
        } else if (props.getProperty("annotators") == null) {
            Properties fromClassPath = StanfordCoreNLP.loadPropertiesFromClasspath();
            fromClassPath.putAll((Map<?, ?>)props);
            props = fromClassPath;
        }
        this.properties = props;
        AnnotatorPool pool = StanfordCoreNLP.getDefaultAnnotatorPool(props);
        HashMap<String, Requirement> requires = new HashMap<String, Requirement>();
        if (enforceRequirements) {
            requires.put(STANFORD_TOKENIZE, new Requirement(new String[0]));
            requires.put(STANFORD_CLEAN_XML, new Requirement(STANFORD_TOKENIZE));
            requires.put(STANFORD_SSPLIT, new Requirement(STANFORD_TOKENIZE));
            requires.put(STANFORD_POS, new Requirement(STANFORD_TOKENIZE, STANFORD_SSPLIT));
            requires.put(STANFORD_LEMMA, new Requirement(STANFORD_TOKENIZE, STANFORD_SSPLIT, POS_TAGGING));
            requires.put(STANFORD_NER, new Requirement(STANFORD_TOKENIZE, STANFORD_SSPLIT, POS_TAGGING, STANFORD_LEMMA));
            requires.put(STANFORD_REGEXNER, new Requirement(STANFORD_TOKENIZE, STANFORD_SSPLIT));
            requires.put(STANFORD_GENDER, new Requirement(STANFORD_TOKENIZE, STANFORD_SSPLIT));
            requires.put(STANFORD_TRUECASE, new Requirement(STANFORD_TOKENIZE, STANFORD_SSPLIT, POS_TAGGING, STANFORD_LEMMA));
            requires.put(STANFORD_NFL, new Requirement(STANFORD_TOKENIZE, STANFORD_SSPLIT, POS_TAGGING, STANFORD_LEMMA, STANFORD_NER, STANFORD_PARSE));
            requires.put(STANFORD_PARSE, new Requirement(STANFORD_TOKENIZE, STANFORD_SSPLIT));
            requires.put(STANFORD_DETERMINISTIC_COREF, new Requirement(STANFORD_TOKENIZE, STANFORD_SSPLIT, POS_TAGGING, STANFORD_NER, STANFORD_PARSE));
        }
        List<String> annoNames = Arrays.asList(StanfordCoreNLP.getRequiredProperty(props, "annotators").split("[, \t]+"));
        HashSet<String> alreadyAddedAnnoNames = new HashSet<String>();
        for (String name : annoNames) {
            String missingRequirement;
            if ((name = name.trim()).isEmpty()) continue;
            System.err.println("Adding annotator " + name);
            if (requires.containsKey(name) && (missingRequirement = ((Requirement)requires.get(name)).getMissingRequirement(alreadyAddedAnnoNames)) != null) {
                String fmt = "annotator \"%s\" requires annotator \"%s\"";
                throw new IllegalArgumentException(String.format(fmt, name, missingRequirement));
            }
            Annotator an = pool.get(name);
            this.addAnnotator(an);
            if (name.equals(STANFORD_TOKENIZE) && annoNames.contains(STANFORD_NFL) && !annoNames.contains(STANFORD_NFL_TOKENIZE)) {
                Annotator pp = pool.get(STANFORD_NFL_TOKENIZE);
                this.addAnnotator(pp);
            }
            alreadyAddedAnnoNames.add(name);
        }
        if (!alreadyAddedAnnoNames.contains(STANFORD_SSPLIT)) {
            System.setProperty(NEWLINE_SPLITTER_PROPERTY, "false");
        }
    }

    public static synchronized void clearAnnotatorPool() {
        pool = null;
    }

    private static synchronized AnnotatorPool getDefaultAnnotatorPool(Properties inputProps) {
        if (pool == null) {
            pool = new AnnotatorPool();
        }
        pool.register(STANFORD_TOKENIZE, new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                if (Boolean.valueOf(this.properties.getProperty("tokenize.whitespace", "false")).booleanValue()) {
                    return new WhitespaceTokenizerAnnotator(this.properties);
                }
                String options = this.properties.getProperty("tokenize.options", "invertible,ptb3Escaping=true");
                boolean keepNewline = Boolean.valueOf(this.properties.getProperty(StanfordCoreNLP.NEWLINE_SPLITTER_PROPERTY, "false"));
                if (keepNewline) {
                    options = "tokenizeNLs," + options;
                }
                return new PTBTokenizerAnnotator(false, options);
            }

            @Override
            public String signature() {
                StringBuilder os = new StringBuilder();
                os.append("tokenize.whitespace:" + this.properties.getProperty("tokenize.whitespace", "false"));
                if (Boolean.valueOf(this.properties.getProperty("tokenize.whitespace", "false")).booleanValue()) {
                    os.append("tokenize.keepeol:" + this.properties.getProperty("tokenize.keepeol", "false"));
                    os.append("ssplit.eolonly:" + this.properties.getProperty(StanfordCoreNLP.NEWLINE_SPLITTER_PROPERTY, "false"));
                    return os.toString();
                }
                os.append("ssplit.eolonly:" + Boolean.valueOf(this.properties.getProperty(StanfordCoreNLP.NEWLINE_SPLITTER_PROPERTY, "false")));
                return os.toString();
            }
        });
        pool.register(STANFORD_CLEAN_XML, new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String xmlTags = this.properties.getProperty("clean.xmltags", ".*");
                String sentenceEndingTags = this.properties.getProperty("clean.sentenceendingtags", "");
                String allowFlawedString = this.properties.getProperty("clean.allowflawedxml");
                boolean allowFlawed = true;
                if (allowFlawedString != null) {
                    allowFlawed = Boolean.valueOf(allowFlawedString);
                }
                String dateTags = this.properties.getProperty("clean.datetags", "datetime|date");
                return new CleanXmlAnnotator(xmlTags, sentenceEndingTags, dateTags, allowFlawed);
            }

            @Override
            public String signature() {
                StringBuilder os = new StringBuilder();
                os.append("clean.xmltags:" + this.properties.getProperty("clean.xmltags", ".*"));
                os.append("clean.sentenceendingtags:" + this.properties.getProperty("clean.sentenceendingtags", ""));
                os.append("clean.allowflawedxml:" + this.properties.getProperty("clean.allowflawedxml", ""));
                os.append("clean.datetags:" + this.properties.getProperty("clean.datetags", "datetime|date"));
                return os.toString();
            }
        });
        pool.register(STANFORD_SSPLIT, new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String isOneSentence;
                String[] toks;
                boolean nlSplitting = Boolean.valueOf(this.properties.getProperty(StanfordCoreNLP.NEWLINE_SPLITTER_PROPERTY, "false"));
                if (nlSplitting) {
                    boolean whitespaceTokenization = Boolean.valueOf(this.properties.getProperty("tokenize.whitespace", "false"));
                    WordsToSentencesAnnotator wts = whitespaceTokenization ? (System.getProperty("line.separator").equals("\n") ? WordsToSentencesAnnotator.newlineSplitter(false, "\n") : WordsToSentencesAnnotator.newlineSplitter(false, System.getProperty("line.separator"), "\n")) : WordsToSentencesAnnotator.newlineSplitter(false, PTBTokenizer.getNewlineToken());
                    return wts;
                }
                WordsToSentencesAnnotator wts = new WordsToSentencesAnnotator();
                String bounds = this.properties.getProperty("ssplit.boundariesToDiscard");
                if (bounds != null) {
                    toks = bounds.split(",");
                    wts.setSentenceBoundaryToDiscard(new HashSet<String>(Arrays.asList(toks)));
                }
                if ((bounds = this.properties.getProperty("ssplit.htmlBoundariesToDiscard")) != null) {
                    toks = bounds.split(",");
                    wts.addHtmlSentenceBoundaryToDiscard(new HashSet<String>(Arrays.asList(toks)));
                }
                if ((isOneSentence = this.properties.getProperty("ssplit.isOneSentence")) != null) {
                    wts.setOneSentence(Boolean.parseBoolean(isOneSentence));
                }
                return wts;
            }

            @Override
            public String signature() {
                StringBuilder os = new StringBuilder();
                os.append("ssplit.eolonly:" + this.properties.getProperty(StanfordCoreNLP.NEWLINE_SPLITTER_PROPERTY, "false"));
                if (Boolean.valueOf(this.properties.getProperty(StanfordCoreNLP.NEWLINE_SPLITTER_PROPERTY, "false")).booleanValue()) {
                    os.append("tokenize.whitespace:" + this.properties.getProperty("tokenize.whitespace", "false"));
                } else {
                    os.append("ssplit.boundariesToDiscard:" + this.properties.getProperty("ssplit.boundariesToDiscard", ""));
                    os.append("ssplit.htmlBoundariesToDiscard:" + this.properties.getProperty("ssplit.htmlBoundariesToDiscard", ""));
                    os.append("ssplit.isOneSentence:" + this.properties.getProperty("ssplit.isOneSentence", ""));
                }
                return os.toString();
            }
        });
        pool.register(STANFORD_POS, new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                try {
                    String maxLenStr = this.properties.getProperty("pos.maxlen");
                    int maxLen = Integer.MAX_VALUE;
                    if (maxLenStr != null) {
                        maxLen = Integer.parseInt(maxLenStr);
                    }
                    return new POSTaggerAnnotator(this.properties.getProperty("pos.model", "edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger"), false, maxLen);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public String signature() {
                StringBuilder os = new StringBuilder();
                os.append("pos.maxlen:" + this.properties.getProperty("pos.maxlen", ""));
                os.append("pos.model:" + this.properties.getProperty("pos.model", "edu/stanford/nlp/models/pos-tagger/english-left3words/english-left3words-distsim.tagger"));
                return os.toString();
            }
        });
        pool.register(STANFORD_LEMMA, new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return new MorphaAnnotator(false);
            }

            @Override
            public String signature() {
                StringBuilder os = new StringBuilder();
                return os.toString();
            }
        });
        pool.register(STANFORD_NER, new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                NERClassifierCombiner nerCombiner;
                ArrayList<String> models = new ArrayList<String>();
                String modelNames = this.properties.getProperty("ner.model");
                if (modelNames == null) {
                    modelNames = "edu/stanford/nlp/models/ner/english.all.3class.distsim.crf.ser.gz,edu/stanford/nlp/models/ner/english.muc.7class.distsim.crf.ser.gz,edu/stanford/nlp/models/ner/english.conll.4class.distsim.crf.ser.gz";
                }
                if (modelNames.length() > 0) {
                    models.addAll(Arrays.asList(modelNames.split(",")));
                }
                if (models.isEmpty()) {
                    System.err.println("WARNING: no NER models specified");
                }
                try {
                    boolean applyNumericClassifiers = PropertiesUtils.getBool(this.properties, "ner.applyNumericClassifiers", true);
                    boolean useSUTime = PropertiesUtils.getBool(this.properties, "ner.useSUTime", NumberSequenceClassifier.USE_SUTIME_DEFAULT);
                    nerCombiner = new NERClassifierCombiner(applyNumericClassifiers, useSUTime, this.properties, models.toArray(new String[models.size()]));
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                return new NERCombinerAnnotator(nerCombiner, false);
            }

            @Override
            public String signature() {
                StringBuilder os = new StringBuilder();
                os.append("ner.model:" + this.properties.getProperty("ner.model", ""));
                os.append("ner.model.3class:" + this.properties.getProperty("ner.model.3class", "edu/stanford/nlp/models/ner/english.all.3class.distsim.crf.ser.gz"));
                os.append("ner.model.7class:" + this.properties.getProperty("ner.model.7class", "edu/stanford/nlp/models/ner/english.muc.7class.distsim.crf.ser.gz"));
                os.append("ner.model.MISCclass:" + this.properties.getProperty("ner.model.MISCclass", "edu/stanford/nlp/models/ner/english.conll.4class.distsim.crf.ser.gz"));
                os.append("ner.applyNumericClassifiers:" + this.properties.getProperty("ner.applyNumericClassifiers", Boolean.toString(true)));
                os.append("ner.useSUTime:" + this.properties.getProperty("ner.useSUTime", Boolean.toString(NumberSequenceClassifier.USE_SUTIME_DEFAULT)));
                return os.toString();
            }
        });
        pool.register(STANFORD_REGEXNER, new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String mapping = this.properties.getProperty("regexner.mapping", "edu/stanford/nlp/models/regexner/type_map_clean");
                String ignoreCase = this.properties.getProperty("regexner.ignorecase", "false");
                String validPosPattern = this.properties.getProperty("regexner.validpospattern", "^(NN|JJ)");
                return new RegexNERAnnotator(mapping, Boolean.valueOf(ignoreCase), validPosPattern);
            }

            @Override
            public String signature() {
                StringBuilder os = new StringBuilder();
                os.append("regexner.mapping:" + this.properties.getProperty("regexner.mapping", "edu/stanford/nlp/models/regexner/type_map_clean"));
                os.append("regexner.ignorecase:" + this.properties.getProperty("regexner.ignorecase", "false"));
                os.append("regexner.validpospattern:" + this.properties.getProperty("regexner.validpospattern", "^(NN|JJ)"));
                return os.toString();
            }
        });
        pool.register(STANFORD_GENDER, new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return new GenderAnnotator(false, this.properties.getProperty("gender.firstnames", "edu/stanford/nlp/models/gender/first_name_map_small"));
            }

            @Override
            public String signature() {
                StringBuilder os = new StringBuilder();
                os.append("gender.firstnames:" + this.properties.getProperty("gender.firstnames", "edu/stanford/nlp/models/gender/first_name_map_small"));
                return os.toString();
            }
        });
        pool.register(STANFORD_TRUECASE, new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String model = this.properties.getProperty("truecase.model", "edu/stanford/nlp/models/truecase/truecasing.fast.qn.ser.gz");
                String bias = this.properties.getProperty("truecase.bias", "INIT_UPPER:-0.7,UPPER:-0.7,O:0");
                String mixed = this.properties.getProperty("truecase.mixedcasefile", "edu/stanford/nlp/models/truecase/MixDisambiguation.list");
                return new TrueCaseAnnotator(model, bias, mixed, false);
            }

            @Override
            public String signature() {
                StringBuilder os = new StringBuilder();
                os.append("truecase.model:" + this.properties.getProperty("truecase.model", "edu/stanford/nlp/models/truecase/truecasing.fast.qn.ser.gz"));
                os.append("truecase.bias:" + this.properties.getProperty("truecase.bias", "INIT_UPPER:-0.7,UPPER:-0.7,O:0"));
                os.append("truecase.mixedcasefile:" + this.properties.getProperty("truecase.mixedcasefile", "edu/stanford/nlp/models/truecase/MixDisambiguation.list"));
                return os.toString();
            }
        });
        pool.register(STANFORD_NFL_TOKENIZE, new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String className = "edu.stanford.nlp.pipeline.NFLTokenizerAnnotator";
                return (Annotator)ReflectionLoading.loadByReflection("edu.stanford.nlp.pipeline.NFLTokenizerAnnotator", new Object[0]);
            }

            @Override
            public String signature() {
                StringBuilder os = new StringBuilder();
                return os.toString();
            }
        });
        pool.register(STANFORD_NFL, new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String className = "edu.stanford.nlp.pipeline.NFLAnnotator";
                return (Annotator)ReflectionLoading.loadByReflection("edu.stanford.nlp.pipeline.NFLAnnotator", this.properties);
            }

            @Override
            public String signature() {
                StringBuilder os = new StringBuilder();
                os.append("nfl.verbose:" + this.properties.getProperty("nfl.verbose", "false"));
                os.append("nfl.relations.use.max.recall:" + this.properties.getProperty("nfl.relations.use.max.recall", "false"));
                os.append("nfl.relations.use.model.merging:" + this.properties.getProperty("nfl.relations.use.model.merging", "false"));
                os.append("nfl.relations.use.basic.inference:" + this.properties.getProperty("nfl.relations.use.basic.inference", "true"));
                os.append("nfl.gazetteer:" + this.properties.getProperty("nfl.gazetteer", "edu/stanford/nlp/models/machinereading/nfl/NFLgazetteer.txt"));
                os.append("nfl.entity.model:" + this.properties.getProperty("nfl.entity.model", "edu/stanford/nlp/models/machinereading/nfl/nfl_entity_model.ser"));
                os.append("nfl.relation.model:" + this.properties.getProperty("nfl.relation.model", "edu/stanford/nlp/models/machinereading/nfl/nfl_relation_model.ser"));
                return os.toString();
            }
        });
        pool.register(STANFORD_PARSE, new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String parserType = this.properties.getProperty("parse.type", "stanford");
                String maxLenStr = this.properties.getProperty("parse.maxlen");
                if (parserType.equalsIgnoreCase("stanford")) {
                    ParserAnnotator anno = new ParserAnnotator(StanfordCoreNLP.STANFORD_PARSE, this.properties);
                    return anno;
                }
                if (parserType.equalsIgnoreCase("charniak")) {
                    String model = this.properties.getProperty("parse.model");
                    String parserExecutable = this.properties.getProperty("parse.executable");
                    if (model == null || parserExecutable == null) {
                        throw new RuntimeException("Both parse.model and parse.executable properties must be specified if parse.type=charniak");
                    }
                    int maxLen = 399;
                    if (maxLenStr != null) {
                        maxLen = Integer.parseInt(maxLenStr);
                    }
                    CharniakParserAnnotator anno = new CharniakParserAnnotator(model, parserExecutable, false, maxLen);
                    return anno;
                }
                throw new RuntimeException("Unknown parser type: " + parserType + " (currently supported: stanford and charniak)");
            }

            @Override
            public String signature() {
                String type = this.properties.getProperty("parse.type", "stanford");
                if (type.equalsIgnoreCase("stanford")) {
                    return ParserAnnotator.signature("parser", this.properties);
                }
                if (type.equalsIgnoreCase("charniak")) {
                    StringBuilder os = new StringBuilder();
                    os.append("parse.model:" + this.properties.getProperty("parse.model", ""));
                    os.append("parse.executable:" + this.properties.getProperty("parse.executable", ""));
                    os.append("parse.maxlen:" + this.properties.getProperty("parse.maxlen", ""));
                    return os.toString();
                }
                throw new RuntimeException("Unknown parser type: " + type + " (currently supported: stanford and charniak)");
            }
        });
        pool.register(STANFORD_DETERMINISTIC_COREF, new AnnotatorFactory(inputProps){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return new DeterministicCorefAnnotator(this.properties);
            }

            @Override
            public String signature() {
                return DeterministicCorefAnnotator.signature(this.properties);
            }
        });
        for (Object propertyKey : inputProps.keySet()) {
            String property;
            if (!(propertyKey instanceof String) || !(property = (String)propertyKey).startsWith(CUSTOM_ANNOTATOR_PREFIX)) continue;
            final String customName = property.substring(CUSTOM_ANNOTATOR_PREFIX.length());
            final String customClassName = inputProps.getProperty(property);
            System.err.println("Registering annotator " + customName + " with class " + customClassName);
            pool.register(customName, new AnnotatorFactory(inputProps){
                private static final long serialVersionUID = 1L;
                private final String name;
                private final String className;
                {
                    super(x0);
                    this.name = customName;
                    this.className = customClassName;
                }

                @Override
                public Annotator create() {
                    return (Annotator)ReflectionLoading.loadByReflection(this.className, this.name, this.properties);
                }

                @Override
                public String signature() {
                    StringBuilder os = new StringBuilder();
                    for (Object key : this.properties.keySet()) {
                        String skey = (String)key;
                        os.append(skey + ":" + this.properties.getProperty(skey));
                    }
                    return os.toString();
                }
            });
        }
        return pool;
    }

    public static synchronized Annotator getExistingAnnotator(String name) {
        if (pool == null) {
            System.err.println("ERROR: attempted to fetch annotator \"" + name + "\" before the annotator pool was created!");
            return null;
        }
        try {
            Annotator a = pool.get(name);
            return a;
        }
        catch (IllegalArgumentException e) {
            System.err.println("ERROR: attempted to fetch annotator \"" + name + "\" but the annotator pool does not store any such type!");
            return null;
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        super.annotate(annotation);
        List words = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        if (words != null) {
            this.numWords += words.size();
        }
    }

    public Annotation process(String text) {
        Annotation annotation = new Annotation(text);
        this.annotate(annotation);
        return annotation;
    }

    public void prettyPrint(Annotation annotation, OutputStream os) {
        TextOutputter.prettyPrint(annotation, os, this);
    }

    public void prettyPrint(Annotation annotation, PrintWriter os) {
        TextOutputter.prettyPrint(annotation, os, this);
    }

    public void xmlPrint(Annotation annotation, Writer w) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.xmlPrint(annotation, os);
        w.write(new String(os.toByteArray(), this.getEncoding()));
        w.flush();
    }

    public void xmlPrint(Annotation annotation, OutputStream os) throws IOException {
        try {
            Class<?> clazz = Class.forName("edu.stanford.nlp.pipeline.XMLOutputter");
            Method method = clazz.getMethod("xmlPrint", Annotation.class, OutputStream.class, StanfordCoreNLP.class);
            method.invoke(null, annotation, os, this);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void printHelp(PrintStream os, String helpTopic) {
        if (helpTopic.toLowerCase().startsWith("pars")) {
            os.println("StanfordCoreNLP currently supports the following parsers:");
            os.println("\tstanford - Stanford lexicalized parser (default)");
            os.println("\tcharniak - Charniak and Johnson reranking parser (sold separately)");
            os.println();
            os.println("General options: (all parsers)");
            os.println("\tparse.type - selects the parser to use");
            os.println("\tparse.model - path to model file for parser");
            os.println("\tparse.maxlen - maximum sentence length");
            os.println();
            os.println("Stanford Parser-specific options:");
            os.println("(In general, you shouldn't need to set this flags)");
            os.println("\tparse.flags - extra flags to the parser (default: -retainTmpSubcategories)");
            os.println("\tparse.debug - set to true to make the parser slightly more verbose");
            os.println();
            os.println("Charniak and Johnson parser-specific options:");
            os.println("\tparse.executable - path to the parseIt binary or parse.sh script");
        } else if (!helpTopic.equalsIgnoreCase("true")) {
            os.println("Unknown help topic: " + helpTopic);
            os.println("See -help for a list of all help topics.");
        } else {
            StanfordCoreNLP.printRequiredProperties(os);
        }
    }

    private static void printRequiredProperties(PrintStream os) {
        os.println("The following properties can be defined:");
        os.println("(if -props or -annotators is not passed in, default properties will be loaded via the classpath)");
        os.println("\t\"props\" - path to file with configuration properties");
        os.println("\t\"annotators\" - comma separated list of annotators");
        os.println("\tThe following annotators are supported: cleanxml, tokenize, ssplit, pos, lemma, ner, truecase, parse, coref, dcoref, nfl");
        os.println("\n\tIf annotator \"tokenize\" is defined:");
        os.println("\t\"tokenize.options\" - PTBTokenizer options (see edu.stanford.nlp.process.PTBTokenizer for details)");
        os.println("\t\"tokenize.whitespace\" - If true, just use whitespace tokenization");
        os.println("\n\tIf annotator \"cleanxml\" is defined:");
        os.println("\t\"clean.xmltags\" - regex of tags to extract text from");
        os.println("\t\"clean.sentenceendingtags\" - regex of tags which mark sentence endings");
        os.println("\t\"clean.allowflawedxml\" - if set to false, don't complain about XML errors");
        os.println("\n\tIf annotator \"pos\" is defined:");
        os.println("\t\"pos.maxlen\" - maximum length of sentence to POS tag");
        os.println("\t\"pos.model\" - path towards the POS tagger model");
        os.println("\n\tIf annotator \"ner\" is defined:");
        os.println("\t\"ner.model.3class\" - path towards the three-class NER model");
        os.println("\t\"ner.model.7class\" - path towards the seven-class NER model");
        os.println("\t\"ner.model.MISCclass\" - path towards the NER model with a MISC class");
        os.println("\n\tIf annotator \"truecase\" is defined:");
        os.println("\t\"truecase.model\" - path towards the true-casing model; default: edu/stanford/nlp/models/truecase/truecasing.fast.qn.ser.gz");
        os.println("\t\"truecase.bias\" - class bias of the true case model; default: INIT_UPPER:-0.7,UPPER:-0.7,O:0");
        os.println("\t\"truecase.mixedcasefile\" - path towards the mixed case file; default: edu/stanford/nlp/models/truecase/MixDisambiguation.list");
        os.println("\n\tIf annotator \"nfl\" is defined:");
        os.println("\t\"nfl.gazetteer\" - path towards the gazetteer for the NFL domain");
        os.println("\t\"nfl.relation.model\" - path towards the NFL relation extraction model");
        os.println("\n\tIf annotator \"parse\" is defined:");
        os.println("\t\"parse.model\" - path towards the PCFG parser model");
        os.println("\nCommand line properties:");
        os.println("\t\"file\" - run the pipeline on the content of this file, or on the content of the files in this directory");
        os.println("\t         XML output is generated for every input file \"file\" as file.xml");
        os.println("\t\"extension\" - if -file used with a directory, process only the files with this extension");
        os.println("\t\"filelist\" - run the pipeline on the list of files given in this file");
        os.println("\t             output is generated for every input file as file.outputExtension");
        os.println("\t\"outputDirectory\" - where to put output (defaults to the current directory)");
        os.println("\t\"outputExtension\" - extension to use for the output file (defaults to \".xml\" for XML, \".ser.gz\" for serialized).  Don't forget the dot!");
        os.println("\t\"outputFormat\" - \"xml\" to output XML (default), \"serialized\" to output serialized Java objects, \"text\" to output text");
        os.println("\t\"replaceExtension\" - flag to chop off the last extension before adding outputExtension to file");
        os.println("\t\"noClobber\" - don't automatically override (clobber) output files that already exist");
        os.println("\t\"threads\" - multithread on this number of threads");
        os.println("\nIf none of the above are present, run the pipeline in an interactive shell (default properties will be loaded from the classpath).");
        os.println("The shell accepts input from stdin and displays the output at stdout.");
        os.println("\nRun with -help [topic] for more help on a specific topic.");
        os.println("Current topics include: parser");
        os.println();
    }

    @Override
    public String timingInformation() {
        StringBuilder sb = new StringBuilder(super.timingInformation());
        if (this.numWords >= 0) {
            long total = this.getTotalTime();
            sb.append(" for ").append(this.numWords).append(" tokens at ");
            sb.append(String.format("%.1f", (double)this.numWords / ((double)total / 1000.0)));
            sb.append(" tokens/sec.");
        }
        return sb.toString();
    }

    private static void shell(StanfordCoreNLP pipeline) throws IOException {
        String encoding = pipeline.getEncoding();
        BufferedReader r = new BufferedReader(IOUtils.encodedInputStreamReader(System.in, encoding));
        System.err.println("Entering interactive shell. Type q RETURN or EOF to quit.");
        while (true) {
            System.err.print("NLP> ");
            String line = r.readLine();
            if (line == null || line.equalsIgnoreCase("q")) break;
            if (line.length() <= 0) continue;
            Annotation anno = pipeline.process(line);
            pipeline.prettyPrint(anno, System.out);
        }
    }

    private static Collection<File> readFileList(String fileName) throws IOException {
        return ObjectBank.getLineIterator(fileName, new ObjectBank.PathToFileFunction());
    }

    public void processFiles(Collection<File> files, int numThreads) throws IOException {
        LinkedList<Runnable> toRun = new LinkedList<Runnable>();
        for (final File file : files) {
            toRun.add(new Runnable(){

                @Override
                public void run() {
                    try {
                        String outputFormat;
                        int lastDot;
                        String outputFilename = new File(StanfordCoreNLP.this.properties.getProperty("outputDirectory", "."), file.getName()).getPath();
                        if (StanfordCoreNLP.this.properties.getProperty("replaceExtension") != null && (lastDot = outputFilename.lastIndexOf(46)) > 0) {
                            outputFilename = outputFilename.substring(0, lastDot);
                        }
                        String defaultExtension = (outputFormat = StanfordCoreNLP.this.properties.getProperty("outputFormat", DEFAULT_OUTPUT_FORMAT)).equalsIgnoreCase("xml") ? ".xml" : (outputFormat.equalsIgnoreCase("text") ? ".out" : ".ser.gz");
                        String extension = StanfordCoreNLP.this.properties.getProperty("outputExtension", defaultExtension);
                        if (!outputFilename.endsWith(extension)) {
                            outputFilename = outputFilename + extension;
                        }
                        if ((outputFilename = new File(outputFilename).getCanonicalPath()).equals(file.getCanonicalPath())) {
                            Redwood.Util.err("Skipping " + file.getName() + ": output file " + outputFilename + " has the same filename as the input file -- assuming you don't actually want to do this.");
                            return;
                        }
                        if (StanfordCoreNLP.this.properties.getProperty("noClobber") != null && new File(outputFilename).exists()) {
                            Redwood.Util.err("Skipping " + file.getName() + ": output file " + outputFilename + " as it already exists.  Don't use the noClobber option to override this.");
                            return;
                        }
                        String encoding = StanfordCoreNLP.this.getEncoding();
                        Redwood.Util.forceTrack("Processing file " + file.getAbsolutePath() + " ... (writing to " + outputFilename + ")");
                        String text = IOUtils.slurpFile(file, encoding);
                        Annotation annotation = StanfordCoreNLP.this.process(text);
                        if (outputFormat.equalsIgnoreCase("xml")) {
                            FileOutputStream fos = new FileOutputStream(outputFilename);
                            StanfordCoreNLP.this.xmlPrint(annotation, fos);
                            fos.close();
                        } else if (outputFormat.equalsIgnoreCase("text")) {
                            FileOutputStream fos = new FileOutputStream(outputFilename);
                            StanfordCoreNLP.this.prettyPrint(annotation, fos);
                            fos.close();
                        } else if (outputFormat.equalsIgnoreCase("serialized")) {
                            IOUtils.writeObjectToFile((Object)annotation, outputFilename);
                        } else {
                            throw new IllegalArgumentException("Unknown output format " + outputFormat);
                        }
                        Redwood.Util.endTrack("Processing file " + file.getAbsolutePath() + " ... (writing to " + outputFilename + ")");
                    }
                    catch (IOException e) {
                        throw new RuntimeIOException(e);
                    }
                }
            });
        }
        if (numThreads == 1) {
            for (Runnable r : toRun) {
                r.run();
            }
        } else {
            Redwood.Util.threadAndRun("StanfordCoreNLP <" + numThreads + " threads>", toRun, numThreads);
        }
    }

    public void processFiles(Collection<File> files) throws IOException {
        this.processFiles(files, 1);
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Timing tim = new Timing();
        StanfordRedwoodConfiguration.minimalSetup();
        Properties props = null;
        if (args.length > 0) {
            props = StringUtils.argsToProperties(args);
            boolean hasH = props.containsKey("h");
            boolean hasHelp = props.containsKey("help");
            if (hasH || hasHelp) {
                String helpValue = hasH ? props.getProperty("h") : props.getProperty("help");
                StanfordCoreNLP.printHelp(System.err, helpValue);
                return;
            }
        }
        String numThreadsString = props == null ? null : props.getProperty("threads");
        int numThreads = 1;
        try {
            if (numThreadsString != null) {
                numThreads = Integer.parseInt(numThreadsString);
            }
        }
        catch (NumberFormatException e) {
            Redwood.Util.err("-threads [number]: was not given a valid number: " + numThreadsString);
        }
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        props = pipeline.getProperties();
        long setupTime = tim.report();
        Redwood.Util.log("");
        if (props.containsKey("file")) {
            String fileName = props.getProperty("file");
            FileSequentialCollection files = new FileSequentialCollection(new File(fileName), props.getProperty("extension"), true);
            pipeline.processFiles(files, numThreads);
        } else if (props.containsKey("filelist")) {
            String fileName = props.getProperty("filelist");
            Collection<File> files = StanfordCoreNLP.readFileList(fileName);
            pipeline.processFiles(files, numThreads);
        } else {
            StanfordCoreNLP.shell(pipeline);
        }
        Redwood.Util.log(new Object[0]);
        Redwood.Util.log(pipeline.timingInformation());
        Redwood.Util.log("Pipeline setup: " + Timing.toSecondsString(setupTime) + " sec.");
        Redwood.Util.log("Total time for StanfordCoreNLP pipeline: " + tim.toSecondsString() + " sec.");
    }
}

