package Lingua::RU::Antimat;
use strict;
use 5.004;
use FileHandle;

$Lingua::RU::Antimat::VERSION = '1.00';

use locale;

sub new
{
	my $that = shift;
	my $class = ref($that)||$that;
	my $self= {};
	
	my $codepage=shift;
	if (defined($codepage)&&($codepage eq 'koi8'))
	{ 
		$self->{'word'}='a[\W_]*s[\W_]*s(?:[\W_]*e[\W_]*s)?|f[\W_]*u[\W_]*c[\W_]*k(?:[\W_]*i[\W_]*n[\W_]*g)?|[\W_]*(?:[iu][\W_]*[d](?:[\W_]*[yiau]|[\W_]*[o0][\W_]*[bv])?|[o0][\W_]*[np][\W_]*(?:[a](?:[\W_]*[xh])?|[eyiu]|[o0][\W_]*[j]))|[d][\W_]*[e][\W_]*[pr][\W_]*(?:[b][\W_]*)?[m][\W_]*[eoya0u](?:[\W_]*[m])?|[c][\W_]*[m][\W_]*(?:[o0]|[i][\W_]*[pr][\W_]*[eibu])|[sc][\W_]*[uy][\W_]*(?:(?:[c][\W_]*)?[k][\W_]*[iyau](?:[\W_]*[hn](?:[\W_]*[o0][\W_]*[j]|[\W_]*[yiau])?)?|[c][\W_]*(?:(?:[b][\W_]*)?(?:[ţeiu]|[eiu][\W_]*[j])|[a][\W_]*[pr][\W_]*[eyiau]))|[rg][\W_]*(?:[oa0][\W_]*(?:[hn][\W_]*[d][\W_]*[oa0][\W_]*[hn](?:[\W_]*[yiu])?|[bv][\W_]*[hn][\W_]*[oa0](?:[\W_]*(?:[m]|[e][\W_]*[d](?:[\W_]*[eyiau]|[\W_]*[oa0][\W_]*[m](?:[\W_]*[iu])?)?))?)|[hn][\W_]*(?:[iu][\W_]*[d][\W_]*(?:[eyiau]|[o0][\W_]*[j])|[yu][sc](?:[\W_]*[yiau]|[\W_]*[oa0][\W_]*[m](?:[\W_]*[iu])?)?))|(?:[hn][\W_]*[e][\W_]*)?(?:(?:[3z][\W_]*[a]|[o0][t]|[np][\W_]*[o0]|[np][\W_]*(?:[e][\W_]*[pr][\W_]*[e]|[pr][\W_]*[eiou0]|[iu][\W_]*[3z][\W_]*[d][\W_]*[o0])|[hn][\W_]*[a]|[iu][\W_]*[3z]|[d][\W_]*[o0]|[bv][\W_]*[i]|[yu]|[pr][\W_]*[a][\W_]*[3z]|[3z][\W_]*[l][\W_]*[o0]|[t][\W_]*[pr][\W_]*[o0]|[yu])[\W_]*)?(?:[bv][\W_]*[i][\W_]*)?(?:[b][\W_]*)?(?:[ţe][\W_]*[b6](?:(?:[\W_]*[ţeioyau0])?(?:[\W_]*[hn](?:[\W_]*[hn])?[\W_]*[iybau]?)?(?:[\W_]*[bv][\W_]*[a])?(?:(?:[\W_]*(?:[eiu][\W_]*[b][\W_]*[sc][\W_]*|[t][\W_]*(?:(?:[b][\W_]*)?[sc][\W_]*|[b]|[e][\W_]*[sc][\W_]*[b]|[e]|[o0]|[iu][\W_]*[hn][\W_]*[eyiau])|(?:[\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[eiu][\W_]*[e]|[e][\W_]*[rg][\W_]*[o0])|[\W_]*[t])(?:[\W_]*[sc][\W_]*)?|[e][\W_]*[mt]|[k](?:[\W_]*[iau])?|[a][\W_]*[l](?:[\W_]*[sc][\W_]*)?|[l][\W_]*(?:[a][\W_]*[hn]|[oa0](?:[\W_]*[m])?|(?:[iu][\W_]*)?[sc][\W_]*[b]|[iu]|[a][\W_]*[sc][\W_]*[b])|[pr][\W_]*[b]|[sc][\W_]*[b]|[hn][\W_]*[o0]|[c][\W_]*(?:[iu][\W_]*[xh]|[e][\W_]*[sc][\W_]*[t][\W_]*[ibu](?:[\W_]*)?)|(?:[t][\W_]*[e][\W_]*[l][\W_]*[b][\W_]*[sc][\W_]*[k][\W_]*|[sc][\W_]*[t][\W_]*|[l][\W_]*[iu][\W_]*[bv][\W_]*|[tc][\W_]*)?(?:[a][\W_]*|[o0][\W_]*[ejm]|[i][\W_]*[ejxh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[iu][\W_]*[e]|[o0][\W_]*[m][\W_]*[yu]|[iu][\W_]*[j]|[e][\W_]*[bv]|[iu][\W_]*[m](?:[\W_]*[iu])?)|[ijltcu]))?)|[\W_]*[i](?:(?:[\W_]*[bv][\W_]*[a]|[\W_]*[hn](?:[\W_]*[hn])?)(?:(?:[\W_]*(?:[eiu][\W_]*[b][\W_]*[sc][\W_]*|[t][\W_]*(?:[b][\W_]*[sc][\W_]*|[b]|[e][\W_]*[sc][\W_]*[b]|[e]|[iu][\W_]*[hn][\W_]*[eyiau])|(?:[\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[eiu][\W_]*[e]|[e][\W_]*[rg][\W_]*[o0])|[\W_]*[t])(?:[\W_]*[sc][\W_]*)?|[e][\W_]*[mt]|[l][\W_]*(?:(?:[iu][\W_]*)?[sc][\W_]*[b]|[iu]|[a][\W_]*[sc][\W_]*[b])|(?:[sc][\W_]*[t][\W_]*|[l][\W_]*[iu][\W_]*[bv][\W_]*|[tc][\W_]*)?(?:[a][\W_]*|[o0][\W_]*[ejm]|[i][\W_]*[ejxh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[iu][\W_]*[e]|[o0][\W_]*[m][\W_]*[yu]|[iu][\W_]*[j]|[e][\W_]*[bv]|[iu][\W_]*[m](?:[\W_]*[iu])?))))|[pr][\W_]*[b]))|[\W_]*[b6](?:[\W_]*[ţeioyau0])?(?:(?:[\W_]*[hn](?:[\W_]*[hn])?[\W_]*[iybau]?)?(?:(?:[\W_]*(?:[eiu][\W_]*[b][\W_]*[sc][\W_]*|[t][\W_]*(?:[b][\W_]*[sc][\W_]*|[b]|[e][\W_]*[sc][\W_]*[b]|[e]|[iu][\W_]*[hn][\W_]*[eyiau])|(?:[\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[eiu][\W_]*[e]|[e][\W_]*[rg][\W_]*[o0])|[\W_]*[t])(?:[\W_]*[sc][\W_]*)?|[e][\W_]*[mt]|[k](?:[\W_]*[iau])?|[a][\W_]*[l](?:[\W_]*[sc][\W_]*)?|[l][\W_]*(?:[a][\W_]*[hn]|[oa0](?:[\W_]*[m])?|(?:[iu][\W_]*)?[sc][\W_]*[b]|[iu])|[pr][\W_]*[b]|[sc][\W_]*[b]|[hn][\W_]*[o0]|[c][\W_]*(?:[iu][\W_]*[xh]|[e][\W_]*[sc][\W_]*[t][\W_]*[ibu](?:[\W_]*)?)|(?:[t][\W_]*[e][\W_]*[l][\W_]*[b][\W_]*[sc][\W_]*[k][\W_]*|[sc][\W_]*[t][\W_]*|[l][\W_]*[iu][\W_]*[bv][\W_]*|[tc][\W_]*)?(?:[a][\W_]*|[o0][\W_]*[ejm]|[i][\W_]*[ejxh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[iu][\W_]*[e]|[o0][\W_]*[m][\W_]*[yu]|[iu][\W_]*[j]|[e][\W_]*[bv]|[iu][\W_]*[m](?:[\W_]*[iu])?)|[ijlmcu]))|(?:[\W_]*[hn](?:[\W_]*[hn])?[\W_]*[iybau]?)))|[\W_]*[b6][\W_]*(?:[ţeiyau][\W_]*)?(?:[hn][\W_]*(?:[hn][\W_]*)?(?:[iybau][\W_]*)?)?[t])|[sc][\W_]*[b][\W_]*[ѣe][\W_]*[b6][\W_]*(?:[yu]|(?:[ɣeiyau](?:[\W_]*[l](?:[\W_]*[ioau0])?|[\W_]*[\W_]*[b]|[\W_]*[t][\W_]*[e])?(?:[\W_]*[sc][\W_]*[b])?))|[e][\W_]*(?:[b6][\W_]*(?:[yu][\W_]*[k][\W_]*[e][\W_]*[hn][\W_]*[t][\W_]*[iu][\W_]*[j]|[e][\W_]*[hn][\W_]*(?:[b]|(?:[\W_]*[m])?)|[iu][\W_]*(?:[c][\W_]*[k][\W_]*[a][\W_]*|[c][\W_]*[e][\W_]*[sc][\W_]*[k][\W_]*[a][\W_]*)|[l][\W_]*[iu][\W_]*[\W_]*[e]|[a][\W_]*(?:[l][\W_]*[b][\W_]*[hn][\W_]*[iu][\W_]*[k](?:[\W_]*[iau])?|[t][\W_]*[o0][\W_]*[pr][\W_]*[iu][\W_]*[j]|[hn][\W_]*(?:[t][\W_]*[pr][\W_]*[o0][\W_]*[np]|[a][\W_]*[t][\W_]*[iu][\W_]*(?:[k]|[c][\W_]*[e][\W_]*[sc][\W_]*[k][\W_]*[iu][\W_]*[j]))))|[d][\W_]*[pr][\W_]*[iu][\W_]*[t])|[hn][\W_]*[e][\W_]*[bv][\W_]*[pr][\W_]*[o0][\W_]*[t][\W_]*[\W_]*[e][\W_]*[b6][\W_]*[a][\W_]*[t][\W_]*[e][\W_]*[l][\W_]*[b][\W_]*[sc][\W_]*[k][\W_]*[iu][\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[o0][\W_]*[ej]|[i][\W_]*[xh]|[i][\W_]*[e]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o0][\W_]*[m][\W_]*[yu])|[yu][\W_]*(?:[e][\W_]*[b6][\W_]*(?:[iu][\W_]*[\W_]*[ea]|[a][\W_]*[hn](?:[\W_]*[t][\W_]*[yu][\W_]*[sc])?(?:[\W_]*[oa0][\W_]*[bmv]|[\W_]*[eyiau])?)|[pr][\W_]*[o0][\W_]*[d](?:[\W_]*[oa0][\W_]*[bmv]|[\W_]*[eyiau])?|[b6][\W_]*[l][\W_]*[\W_]*[d][\W_]*(?:[o0][\W_]*[k]|[k][\W_]*(?:[oa0][\W_]*[bmv](?:[\W_]*[iu])?|[eiyau])?))|[m][\W_]*(?:[yu][\W_]*[d][\W_]*(?:[o0][\W_]*[xh][\W_]*[a][\W_]*(?:[t][\W_]*[b][\W_]*[sc][\W_]*|[\W_]*[sc][\W_]*[b]|[e][\W_]*[\W_]*[b][\W_]*[sc][\W_]*)|[a][\W_]*(?:[k](?:[\W_]*[iau]|[o0][bmv])?|[c][\W_]*(?:[b][\W_]*[ţe]|[iu][\W_]*[hn][\W_]*[yiau]|[k][\W_]*(?:[eiyau]|[o0][\W_]*[j])))|[e][\W_]*[hn][\W_]*[b]|[iu][\W_]*[l](?:[\W_]*[eoia0]?))|[a][\W_]*[hn][\W_]*[d][\W_]*[yau]|[l][\W_]*(?:[iu][\W_]*[hn]|))|(?:[m][\W_]*(?:[o0][\W_]*[3z][\W_]*[rg]|[yu][\W_]*[d])|[d][\W_]*(?:[o0][\W_]*[l][\W_]*[b6]|[yu][\W_]*[pr])|[sc][\W_]*[k][\W_]*[o0][\W_]*[t]|[\W_]*[iu][\W_]*[d])[\W_]*[oa0][\W_]*(?:[xh][\W_]*[yu][\W_]*[iju]|[e][\W_]*[b6](?:[\W_]*[eo0][\W_]*[bv]|[\W_]*[ia]|[\W_]*[sc][\W_]*[t][\W_]*[bv][\W_]*[oy0u](?:[\W_]*[m])?|[iu][\W_]*[3z][\W_]*[m])?)|(?:[hn][\W_]*[e][\W_]*|[3z][\W_]*[a][\W_]*|[o0][\W_]*[t][\W_]*|[np][\W_]*[o0][\W_]*|[hn][\W_]*[a][\W_]*|[pr][\W_]*[a][\W_]*[3szc][\W_]*)?(?:[np][\W_]*[iu][\W_]*[3z][\W_]*[d][\W_]*[eiu]|(?:)?[ţe][\W_]*[b6][\W_]*[a])[\W_]*(?:(?:[t][\W_]*[b][\W_]*[sc][\W_]*|[t][\W_]*[b]|[l][\W_]*[iu]|[a][\W_]*[l]|[l]|c[\W_]*[b]|[iu][\W_]*[t]|[iu]|[t][\W_]*[e]|[c][\W_]*[yu]|[\W_]*[b])|(?:[iju]|[eiu][\W_]*[m](?:[\W_]*[iu])?|[j][\W_]*[sc][\W_]*(?:[k][\W_]*(?:[iu][\W_]*[ej]|[a][\W_]*|[o0][\W_]*[e]|[i][\W_]*[xh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o0][\W_]*[m][\W_]*[yu])|[t][\W_]*[bv][\W_]*[oya0u](?:[\W_]*[m])?)))|[np][\W_]*[eiu][\W_]*[d][\W_]*[eoa0][\W_]*[pr](?:(?:[\W_]*[a][\W_]*[3szc](?:(?:[\W_]*[t])?(?:[\W_]*[i]|[\W_]*[oa0][\W_]*[m](?:[\W_]*[iu])?|[\W_]*[k][\W_]*[iau])?|(?:[\W_]*[eyiau]|[\W_]*[oa0][\W_]*[m](?:[\W_]*[iu])?|[\W_]*[o0][\W_]*[bv])))|[\W_]*(?:[eyiau]|[oa0][\W_]*[m](?:[\W_]*[iu])?|[o0][\W_]*[bv]|[hn][\W_]*))?|[np][\W_]*[iu][\W_]*[3z][\W_]*(?:[b][\W_]*)?[d][\W_]*(?:[e][\W_]*(?:[hn][\W_]*[i][\W_]*(?:[\W_]*[b])?|[hn](?:[\W_]*[b])?)|[yu][\W_]*(?:[j](?:[\W_]*[t][\W_]*[e])?|[hn](?:[\W_]*[i])?)|[\W_]*(?:[k](?:[\W_]*(?:[eiyau]|[o0][\W_]*[bv]|[a][\W_]*[m](?:[\W_]*[iu])?))?|[l](?:[ibu]|[e][\W_]*[j]|[\W_]*[mxh]))|[e][\W_]*[c]|[oa0][\W_]*(?:[hn][\W_]*[yu][\W_]*)?[t][\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[o0](?:[\W_]*[ej])?|[i][\W_]*[ejxh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o0][\W_]*[m][\W_]*[yu]|[e][\W_]*[e]|[eyibau])|[a][\W_]*[hn][\W_]*[yu][\W_]*[l](?:[\W_]*[iau])?|[eiyau]|[oa0][\W_]*(?:[j]|[xh][\W_]*[yu][\W_]*[j]|[ţe][\W_]*[b6]|(?:[pr][\W_]*[o0][\W_]*[t]|[rg][\W_]*[o0][\W_]*[l][\W_]*[o0][\W_]*[bv])[\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[o0][\W_]*[ej]|[i][\W_]*[xh]|[i][\W_]*[e]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o0][\W_]*[m][\W_]*[yu])|[b6][\W_]*(?:[pr][\W_]*[a][\W_]*[t][\W_]*[iu][\W_]*|[o0][\W_]*[l](?:[\W_]*[yiau])?)))|[np][\W_]*(?:[a][\W_]*[d][\W_]*[l][\W_]*[oia0]|[oa0][\W_]*[sc][\W_]*[k][\W_]*[yu][\W_]*[d][\W_]*(?:[eyiau]|[oa0][\W_]*[m](?:[\W_]*[iu])?)|[eiu][\W_]*[d][\W_]*(?:[iu][\W_]*[k]|[pr][\W_]*[iu][\W_]*[l](?:[\W_]*[l])?)(?:[\W_]*[oa0][\W_]*[bmv]|[\W_]*[eioyau0])?|[pr][\W_]*[o0][\W_]*[b6][\W_]*[l][\W_]*[\W_]*[d][\W_]*[o0][\W_]*[m])|(?:[3z][\W_]*[a][\W_]*|[o0][\W_]*[t][\W_]*|[hn][\W_]*[a][\W_]*)?[sc][\W_]*[pr][\W_]*(?:[a][\W_]*[t][\W_]*[b]|[a][\W_]*[l](?:[\W_]*[iu])?|[eiyu])|[sc][\W_]*[pr][\W_]*[a][\W_]*(?:[k][\W_]*(?:[eiyau]|[o0][\W_]*[j])|[hn](?:[\W_]*[hn])?(?:[b]|(?:[\W_]*[i][\W_]*[ej]|[\W_]*[a][\W_]*|[\W_]*[o0][\W_]*[e]))|[l][\W_]*[b][\W_]*[hn][\W_]*[iu][\W_]*[k](?:[\W_]*[iu]|[\W_]*[oa0][\W_]*[m])?)|(?:[3z][\W_]*[a][\W_]*)?[t][\W_]*[pr][\W_]*[a][\W_]*[xh][\W_]*(?:[hn][\W_]*(?:[yu](?:[\W_]*[t][\W_]*[b](?:[\W_]*[sc][\W_]*)?|[\W_]*[sc][\W_]*[b]|[\W_]*[l](?:[\W_]*[iau])?)?|[eiu][\W_]*[\W_]*[b][\W_]*[sc][\W_]*)|[a][\W_]*(?:[l](?:[\W_]*[ioau0])?|[t][\W_]*[b](?:[\W_]*[sc][\W_]*)?|[hn][\W_]*(?:[hn][\W_]*)?(?:[iu][\W_]*[j]|[a][\W_]*|[o0][\W_]*[ej]|[i][\W_]*[xh]|[i][\W_]*[e]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o0][\W_]*[m][\W_]*[yu])))|(?:[hn][\W_]*[eiu][\W_]*|[np][\W_]*[o0][\W_]*|[hn][\W_]*[a][\W_]*|[oa0][\W_]*(?:[t][\W_]*)?|[d][\W_]*[oa0][\W_]*|[3z][\W_]*[a][\W_]*)?(?:(?:[f][\W_]*[iu][\W_]*[rg]|[xh][\W_]*(?:[eiu][\W_]*(?:[j][\W_]*)?[pr]|[pr][\W_]*[e][\W_]*[hn]|[yu](?:[\W_]*[j])?))(?:[\W_]*[ϣeo0][\W_]*[bv](?:[\W_]*[a][\W_]*[\W_]*|[\W_]*)?)?(?:[\W_]*[eiau][\W_]*[lhn])?(?:[hn])?(?:[\W_]*(?:[ϣeioau0][beijmvu]|[\W_]*(?:[m](?:[\W_]*[iu])?|[pr][\W_]*(?:|[iu][\W_]*(?:[t](?:[\W_]*[eb][\W_]*[sc][\W_]*[b])?|[l](?:[\W_]*[ioau0])?))|[c][\W_]*(?:[iau][\W_]*[t](?:[\W_]*[sc][\W_]*)|[iu][\W_]*[l](?:[\W_]*[ioau0])?)|[c](?:[\W_]*[b])?)|[e][\W_]*(?:[t][\W_]*(?:[o0][\W_]*[j]|[ybau])|[e][\W_]*(?:[t][\W_]*[e]|[\W_]*[b]))|[ijoyau0]|[l][\W_]*[iou0]|[c][\W_]*[yu])))|(?:[f][\W_]*[iu][\W_]*[rg]|[xh][\W_]*(?:[eiu][\W_]*(?:[j][\W_]*)?[pr]|[pr][\W_]*[e][\W_]*[hn]|[yu][\W_]*[j]))|[xh][\W_]*[yu][\W_]*(?:[ţeiu][\W_]*(?:[sc][\W_]*[o0][\W_]*[sc]|[np][\W_]*[l][\W_]*[e][\W_]*[t]|[hn][\W_]*[i][\W_]*)(?:[\W_]*[yiau]|[\W_]*[oa0][\W_]*[m](?:[\W_]*[iu])?|[hn][\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[o0][\W_]*[ej]|[i][\W_]*[xh]|[i][\W_]*[e]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o0][\W_]*[m][\W_]*[yu]))?|[d][\W_]*[o0][\W_]*[\W_]*[b6][\W_]*[iu][\W_]*[hn][\W_]*(?:[o0][\W_]*[j]|[eyiau]))|[b6][\W_]*[l][\W_]*(?:[\W_]*[dt][\W_]*(?:[b]|[iu]|[k][\W_]*[iu]|[sc][\W_]*[t][\W_]*[bv][\W_]*[o0]|[sc][\W_]*[k][\W_]*(?:[o0][\W_]*[ej]|[iu][\W_]*[e]|[a][\W_]*|[iu][\W_]*[j]|[o0][\W_]*[rg][\W_]*[o0])))?|[bv][\W_]*[i][\W_]*[b6][\W_]*[l][\W_]*[\W_]*[d][\W_]*(?:[o0][\W_]*[k]|[k][\W_]*(?:[eiyau]|[a][\W_]*[m](?:[\W_]*[iu])?))|(?:[3z][\W_]*[oa0][\W_]*)(?:[np][\W_]*[oa0][\W_]*[d][\W_]*[l][\W_]*[oia0]|[l][\W_]*[yu][\W_]*[np][\W_]*(?:[o0][\W_]*[j]|[eyiau]))|[\W_]*[l][\W_]*[\W_]*[xh][\W_]*(?:[eiyau]|[o0][\W_]*[j])|[a][\W_]*[hn][\W_]*[yu][\W_]*[sc](?:[\W_]*[eyiau]|[\W_]*[o0][\W_]*[m])?|(?:\w*(?:[xh](?:[pr][e][hn]|[yu][iu])|[np][eiu](?:[3z][d]|[d](?:[eoa0][pr]|[pr]))|[b6][l][d]|[o0][xh][yu][e]|[m][yu][d][eioau0]|[d][e][pr][b]|[rg][oa0][bv][hn]|[yu][ţe][b6])|[xh][\W_]*(?:[pr][\W_]*[e][\W_]*[hn]|[yu][\W_]*[eiju])|[np][\W_]*[eiu][\W_]*(?:[3z][\W_]*[d]|[d][\W_]*(?:[eoa0][\W_]*[pr]|[pr]))|[b6][\W_]*[l][\W_]*[\W_]*[d]|[o0][\W_]*[xh][\W_]*[yu][\W_]*[e]|[m][\W_]*[yu][\W_]*[d][\W_]*[eioau0]|[d][\W_]*[e][\W_]*[pr][\W_]*[b]|[rg][\W_]*[oa0][\W_]*[bv][\W_]*[hn]|[yu][\W_]*[ţe][\W_]*[b6]|[e][b6])\w+';
		$self->{'bip'}='';
	}	
	
	
	else 
	{
		$self->{'word'}='a[\W_]*s[\W_]*s(?:[\W_]*e[\W_]*s)?|f[\W_]*u[\W_]*c[\W_]*k(?:[\W_]*i[\W_]*n[\W_]*g)?|[\W_]*(?:[iu][\W_]*[d](?:[\W_]*[yiau]|[\W_]*[o0][\W_]*[bv])?|[o0][\W_]*[np][\W_]*(?:[a](?:[\W_]*[xh])?|[eyiu]|[o0][\W_]*[j]))|[d][\W_]*[e][\W_]*[pr][\W_]*(?:[b][\W_]*)?[m][\W_]*[eoya0u](?:[\W_]*[m])?|[c][\W_]*[m][\W_]*(?:[o0]|[i][\W_]*[pr][\W_]*[eibu])|[sc][\W_]*[uy][\W_]*(?:(?:[c][\W_]*)?[k][\W_]*[iyau](?:[\W_]*[hn](?:[\W_]*[o0][\W_]*[j]|[\W_]*[yiau])?)?|[c][\W_]*(?:(?:[b][\W_]*)?(?:[eiu]|[eiu][\W_]*[j])|[a][\W_]*[pr][\W_]*[eyiau]))|[rg][\W_]*(?:[oa0][\W_]*(?:[hn][\W_]*[d][\W_]*[oa0][\W_]*[hn](?:[\W_]*[yiu])?|[bv][\W_]*[hn][\W_]*[oa0](?:[\W_]*(?:[m]|[e][\W_]*[d](?:[\W_]*[eyiau]|[\W_]*[oa0][\W_]*[m](?:[\W_]*[iu])?)?))?)|[hn][\W_]*(?:[iu][\W_]*[d][\W_]*(?:[eyiau]|[o0][\W_]*[j])|[yu][sc](?:[\W_]*[yiau]|[\W_]*[oa0][\W_]*[m](?:[\W_]*[iu])?)?))|(?:[hn][\W_]*[e][\W_]*)?(?:(?:[3z][\W_]*[a]|[o0][t]|[np][\W_]*[o0]|[np][\W_]*(?:[e][\W_]*[pr][\W_]*[e]|[pr][\W_]*[eiou0]|[iu][\W_]*[3z][\W_]*[d][\W_]*[o0])|[hn][\W_]*[a]|[iu][\W_]*[3z]|[d][\W_]*[o0]|[bv][\W_]*[i]|[yu]|[pr][\W_]*[a][\W_]*[3z]|[3z][\W_]*[l][\W_]*[o0]|[t][\W_]*[pr][\W_]*[o0]|[yu])[\W_]*)?(?:[bv][\W_]*[i][\W_]*)?(?:[b][\W_]*)?(?:[e][\W_]*[b6](?:(?:[\W_]*[eioyau0])?(?:[\W_]*[hn](?:[\W_]*[hn])?[\W_]*[iybau]?)?(?:[\W_]*[bv][\W_]*[a])?(?:(?:[\W_]*(?:[eiu][\W_]*[b][\W_]*[sc][\W_]*|[t][\W_]*(?:(?:[b][\W_]*)?[sc][\W_]*|[b]|[e][\W_]*[sc][\W_]*[b]|[e]|[o0]|[iu][\W_]*[hn][\W_]*[eyiau])|(?:[\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[eiu][\W_]*[e]|[e][\W_]*[rg][\W_]*[o0])|[\W_]*[t])(?:[\W_]*[sc][\W_]*)?|[e][\W_]*[mt]|[k](?:[\W_]*[iau])?|[a][\W_]*[l](?:[\W_]*[sc][\W_]*)?|[l][\W_]*(?:[a][\W_]*[hn]|[oa0](?:[\W_]*[m])?|(?:[iu][\W_]*)?[sc][\W_]*[b]|[iu]|[a][\W_]*[sc][\W_]*[b])|[pr][\W_]*[b]|[sc][\W_]*[b]|[hn][\W_]*[o0]|[c][\W_]*(?:[iu][\W_]*[xh]|[e][\W_]*[sc][\W_]*[t][\W_]*[ibu](?:[\W_]*)?)|(?:[t][\W_]*[e][\W_]*[l][\W_]*[b][\W_]*[sc][\W_]*[k][\W_]*|[sc][\W_]*[t][\W_]*|[l][\W_]*[iu][\W_]*[bv][\W_]*|[tc][\W_]*)?(?:[a][\W_]*|[o0][\W_]*[ejm]|[i][\W_]*[ejxh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[iu][\W_]*[e]|[o0][\W_]*[m][\W_]*[yu]|[iu][\W_]*[j]|[e][\W_]*[bv]|[iu][\W_]*[m](?:[\W_]*[iu])?)|[ijltcu]))?)|[\W_]*[i](?:(?:[\W_]*[bv][\W_]*[a]|[\W_]*[hn](?:[\W_]*[hn])?)(?:(?:[\W_]*(?:[eiu][\W_]*[b][\W_]*[sc][\W_]*|[t][\W_]*(?:[b][\W_]*[sc][\W_]*|[b]|[e][\W_]*[sc][\W_]*[b]|[e]|[iu][\W_]*[hn][\W_]*[eyiau])|(?:[\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[eiu][\W_]*[e]|[e][\W_]*[rg][\W_]*[o0])|[\W_]*[t])(?:[\W_]*[sc][\W_]*)?|[e][\W_]*[mt]|[l][\W_]*(?:(?:[iu][\W_]*)?[sc][\W_]*[b]|[iu]|[a][\W_]*[sc][\W_]*[b])|(?:[sc][\W_]*[t][\W_]*|[l][\W_]*[iu][\W_]*[bv][\W_]*|[tc][\W_]*)?(?:[a][\W_]*|[o0][\W_]*[ejm]|[i][\W_]*[ejxh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[iu][\W_]*[e]|[o0][\W_]*[m][\W_]*[yu]|[iu][\W_]*[j]|[e][\W_]*[bv]|[iu][\W_]*[m](?:[\W_]*[iu])?))))|[pr][\W_]*[b]))|[\W_]*[b6](?:[\W_]*[eioyau0])?(?:(?:[\W_]*[hn](?:[\W_]*[hn])?[\W_]*[iybau]?)?(?:(?:[\W_]*(?:[eiu][\W_]*[b][\W_]*[sc][\W_]*|[t][\W_]*(?:[b][\W_]*[sc][\W_]*|[b]|[e][\W_]*[sc][\W_]*[b]|[e]|[iu][\W_]*[hn][\W_]*[eyiau])|(?:[\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[eiu][\W_]*[e]|[e][\W_]*[rg][\W_]*[o0])|[\W_]*[t])(?:[\W_]*[sc][\W_]*)?|[e][\W_]*[mt]|[k](?:[\W_]*[iau])?|[a][\W_]*[l](?:[\W_]*[sc][\W_]*)?|[l][\W_]*(?:[a][\W_]*[hn]|[oa0](?:[\W_]*[m])?|(?:[iu][\W_]*)?[sc][\W_]*[b]|[iu])|[pr][\W_]*[b]|[sc][\W_]*[b]|[hn][\W_]*[o0]|[c][\W_]*(?:[iu][\W_]*[xh]|[e][\W_]*[sc][\W_]*[t][\W_]*[ibu](?:[\W_]*)?)|(?:[t][\W_]*[e][\W_]*[l][\W_]*[b][\W_]*[sc][\W_]*[k][\W_]*|[sc][\W_]*[t][\W_]*|[l][\W_]*[iu][\W_]*[bv][\W_]*|[tc][\W_]*)?(?:[a][\W_]*|[o0][\W_]*[ejm]|[i][\W_]*[ejxh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[iu][\W_]*[e]|[o0][\W_]*[m][\W_]*[yu]|[iu][\W_]*[j]|[e][\W_]*[bv]|[iu][\W_]*[m](?:[\W_]*[iu])?)|[ijlmcu]))|(?:[\W_]*[hn](?:[\W_]*[hn])?[\W_]*[iybau]?)))|[\W_]*[b6][\W_]*(?:[eiyau][\W_]*)?(?:[hn][\W_]*(?:[hn][\W_]*)?(?:[iybau][\W_]*)?)?[t])|[sc][\W_]*[b][\W_]*[e][\W_]*[b6][\W_]*(?:[yu]|(?:[eiyau](?:[\W_]*[l](?:[\W_]*[ioau0])?|[\W_]*[\W_]*[b]|[\W_]*[t][\W_]*[e])?(?:[\W_]*[sc][\W_]*[b])?))|[e][\W_]*(?:[b6][\W_]*(?:[yu][\W_]*[k][\W_]*[e][\W_]*[hn][\W_]*[t][\W_]*[iu][\W_]*[j]|[e][\W_]*[hn][\W_]*(?:[b]|(?:[\W_]*[m])?)|[iu][\W_]*(?:[c][\W_]*[k][\W_]*[a][\W_]*|[c][\W_]*[e][\W_]*[sc][\W_]*[k][\W_]*[a][\W_]*)|[l][\W_]*[iu][\W_]*[\W_]*[e]|[a][\W_]*(?:[l][\W_]*[b][\W_]*[hn][\W_]*[iu][\W_]*[k](?:[\W_]*[iau])?|[t][\W_]*[o0][\W_]*[pr][\W_]*[iu][\W_]*[j]|[hn][\W_]*(?:[t][\W_]*[pr][\W_]*[o0][\W_]*[np]|[a][\W_]*[t][\W_]*[iu][\W_]*(?:[k]|[c][\W_]*[e][\W_]*[sc][\W_]*[k][\W_]*[iu][\W_]*[j]))))|[d][\W_]*[pr][\W_]*[iu][\W_]*[t])|[hn][\W_]*[e][\W_]*[bv][\W_]*[pr][\W_]*[o0][\W_]*[t][\W_]*[\W_]*[e][\W_]*[b6][\W_]*[a][\W_]*[t][\W_]*[e][\W_]*[l][\W_]*[b][\W_]*[sc][\W_]*[k][\W_]*[iu][\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[o0][\W_]*[ej]|[i][\W_]*[xh]|[i][\W_]*[e]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o0][\W_]*[m][\W_]*[yu])|[yu][\W_]*(?:[e][\W_]*[b6][\W_]*(?:[iu][\W_]*[\W_]*[ea]|[a][\W_]*[hn](?:[\W_]*[t][\W_]*[yu][\W_]*[sc])?(?:[\W_]*[oa0][\W_]*[bmv]|[\W_]*[eyiau])?)|[pr][\W_]*[o0][\W_]*[d](?:[\W_]*[oa0][\W_]*[bmv]|[\W_]*[eyiau])?|[b6][\W_]*[l][\W_]*[\W_]*[d][\W_]*(?:[o0][\W_]*[k]|[k][\W_]*(?:[oa0][\W_]*[bmv](?:[\W_]*[iu])?|[eiyau])?))|[m][\W_]*(?:[yu][\W_]*[d][\W_]*(?:[o0][\W_]*[xh][\W_]*[a][\W_]*(?:[t][\W_]*[b][\W_]*[sc][\W_]*|[\W_]*[sc][\W_]*[b]|[e][\W_]*[\W_]*[b][\W_]*[sc][\W_]*)|[a][\W_]*(?:[k](?:[\W_]*[iau]|[o0][bmv])?|[c][\W_]*(?:[b][\W_]*[e]|[iu][\W_]*[hn][\W_]*[yiau]|[k][\W_]*(?:[eiyau]|[o0][\W_]*[j])))|[e][\W_]*[hn][\W_]*[b]|[iu][\W_]*[l](?:[\W_]*[eoia0]?))|[a][\W_]*[hn][\W_]*[d][\W_]*[yau]|[l][\W_]*(?:[iu][\W_]*[hn]|))|(?:[m][\W_]*(?:[o0][\W_]*[3z][\W_]*[rg]|[yu][\W_]*[d])|[d][\W_]*(?:[o0][\W_]*[l][\W_]*[b6]|[yu][\W_]*[pr])|[sc][\W_]*[k][\W_]*[o0][\W_]*[t]|[\W_]*[iu][\W_]*[d])[\W_]*[oa0][\W_]*(?:[xh][\W_]*[yu][\W_]*[iju]|[e][\W_]*[b6](?:[\W_]*[eo0][\W_]*[bv]|[\W_]*[ia]|[\W_]*[sc][\W_]*[t][\W_]*[bv][\W_]*[oy0u](?:[\W_]*[m])?|[iu][\W_]*[3z][\W_]*[m])?)|(?:[hn][\W_]*[e][\W_]*|[3z][\W_]*[a][\W_]*|[o0][\W_]*[t][\W_]*|[np][\W_]*[o0][\W_]*|[hn][\W_]*[a][\W_]*|[pr][\W_]*[a][\W_]*[3szc][\W_]*)?(?:[np][\W_]*[iu][\W_]*[3z][\W_]*[d][\W_]*[eiu]|(?:)?[e][\W_]*[b6][\W_]*[a])[\W_]*(?:(?:[t][\W_]*[b][\W_]*[sc][\W_]*|[t][\W_]*[b]|[l][\W_]*[iu]|[a][\W_]*[l]|[l]|c[\W_]*[b]|[iu][\W_]*[t]|[iu]|[t][\W_]*[e]|[c][\W_]*[yu]|[\W_]*[b])|(?:[iju]|[eiu][\W_]*[m](?:[\W_]*[iu])?|[j][\W_]*[sc][\W_]*(?:[k][\W_]*(?:[iu][\W_]*[ej]|[a][\W_]*|[o0][\W_]*[e]|[i][\W_]*[xh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o0][\W_]*[m][\W_]*[yu])|[t][\W_]*[bv][\W_]*[oya0u](?:[\W_]*[m])?)))|[np][\W_]*[eiu][\W_]*[d][\W_]*[eoa0][\W_]*[pr](?:(?:[\W_]*[a][\W_]*[3szc](?:(?:[\W_]*[t])?(?:[\W_]*[i]|[\W_]*[oa0][\W_]*[m](?:[\W_]*[iu])?|[\W_]*[k][\W_]*[iau])?|(?:[\W_]*[eyiau]|[\W_]*[oa0][\W_]*[m](?:[\W_]*[iu])?|[\W_]*[o0][\W_]*[bv])))|[\W_]*(?:[eyiau]|[oa0][\W_]*[m](?:[\W_]*[iu])?|[o0][\W_]*[bv]|[hn][\W_]*))?|[np][\W_]*[iu][\W_]*[3z][\W_]*(?:[b][\W_]*)?[d][\W_]*(?:[e][\W_]*(?:[hn][\W_]*[i][\W_]*(?:[\W_]*[b])?|[hn](?:[\W_]*[b])?)|[yu][\W_]*(?:[j](?:[\W_]*[t][\W_]*[e])?|[hn](?:[\W_]*[i])?)|[\W_]*(?:[k](?:[\W_]*(?:[eiyau]|[o0][\W_]*[bv]|[a][\W_]*[m](?:[\W_]*[iu])?))?|[l](?:[ibu]|[e][\W_]*[j]|[\W_]*[mxh]))|[e][\W_]*[c]|[oa0][\W_]*(?:[hn][\W_]*[yu][\W_]*)?[t][\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[o0](?:[\W_]*[ej])?|[i][\W_]*[ejxh]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o0][\W_]*[m][\W_]*[yu]|[e][\W_]*[e]|[eyibau])|[a][\W_]*[hn][\W_]*[yu][\W_]*[l](?:[\W_]*[iau])?|[eiyau]|[oa0][\W_]*(?:[j]|[xh][\W_]*[yu][\W_]*[j]|[e][\W_]*[b6]|(?:[pr][\W_]*[o0][\W_]*[t]|[rg][\W_]*[o0][\W_]*[l][\W_]*[o0][\W_]*[bv])[\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[o0][\W_]*[ej]|[i][\W_]*[xh]|[i][\W_]*[e]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o0][\W_]*[m][\W_]*[yu])|[b6][\W_]*(?:[pr][\W_]*[a][\W_]*[t][\W_]*[iu][\W_]*|[o0][\W_]*[l](?:[\W_]*[yiau])?)))|[np][\W_]*(?:[a][\W_]*[d][\W_]*[l][\W_]*[oia0]|[oa0][\W_]*[sc][\W_]*[k][\W_]*[yu][\W_]*[d][\W_]*(?:[eyiau]|[oa0][\W_]*[m](?:[\W_]*[iu])?)|[eiu][\W_]*[d][\W_]*(?:[iu][\W_]*[k]|[pr][\W_]*[iu][\W_]*[l](?:[\W_]*[l])?)(?:[\W_]*[oa0][\W_]*[bmv]|[\W_]*[eioyau0])?|[pr][\W_]*[o0][\W_]*[b6][\W_]*[l][\W_]*[\W_]*[d][\W_]*[o0][\W_]*[m])|(?:[3z][\W_]*[a][\W_]*|[o0][\W_]*[t][\W_]*|[hn][\W_]*[a][\W_]*)?[sc][\W_]*[pr][\W_]*(?:[a][\W_]*[t][\W_]*[b]|[a][\W_]*[l](?:[\W_]*[iu])?|[eiyu])|[sc][\W_]*[pr][\W_]*[a][\W_]*(?:[k][\W_]*(?:[eiyau]|[o0][\W_]*[j])|[hn](?:[\W_]*[hn])?(?:[b]|(?:[\W_]*[i][\W_]*[ej]|[\W_]*[a][\W_]*|[\W_]*[o0][\W_]*[e]))|[l][\W_]*[b][\W_]*[hn][\W_]*[iu][\W_]*[k](?:[\W_]*[iu]|[\W_]*[oa0][\W_]*[m])?)|(?:[3z][\W_]*[a][\W_]*)?[t][\W_]*[pr][\W_]*[a][\W_]*[xh][\W_]*(?:[hn][\W_]*(?:[yu](?:[\W_]*[t][\W_]*[b](?:[\W_]*[sc][\W_]*)?|[\W_]*[sc][\W_]*[b]|[\W_]*[l](?:[\W_]*[iau])?)?|[eiu][\W_]*[\W_]*[b][\W_]*[sc][\W_]*)|[a][\W_]*(?:[l](?:[\W_]*[ioau0])?|[t][\W_]*[b](?:[\W_]*[sc][\W_]*)?|[hn][\W_]*(?:[hn][\W_]*)?(?:[iu][\W_]*[j]|[a][\W_]*|[o0][\W_]*[ej]|[i][\W_]*[xh]|[i][\W_]*[e]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o0][\W_]*[m][\W_]*[yu])))|(?:[hn][\W_]*[eiu][\W_]*|[np][\W_]*[o0][\W_]*|[hn][\W_]*[a][\W_]*|[oa0][\W_]*(?:[t][\W_]*)?|[d][\W_]*[oa0][\W_]*|[3z][\W_]*[a][\W_]*)?(?:(?:[f][\W_]*[iu][\W_]*[rg]|[xh][\W_]*(?:[eiu][\W_]*(?:[j][\W_]*)?[pr]|[pr][\W_]*[e][\W_]*[hn]|[yu](?:[\W_]*[j])?))(?:[\W_]*[eo0][\W_]*[bv](?:[\W_]*[a][\W_]*[\W_]*|[\W_]*)?)?(?:[\W_]*[eiau][\W_]*[lhn])?(?:[hn])?(?:[\W_]*(?:[eioau0][beijmvu]|[\W_]*(?:[m](?:[\W_]*[iu])?|[pr][\W_]*(?:|[iu][\W_]*(?:[t](?:[\W_]*[eb][\W_]*[sc][\W_]*[b])?|[l](?:[\W_]*[ioau0])?))|[c][\W_]*(?:[iau][\W_]*[t](?:[\W_]*[sc][\W_]*)|[iu][\W_]*[l](?:[\W_]*[ioau0])?)|[c](?:[\W_]*[b])?)|[e][\W_]*(?:[t][\W_]*(?:[o0][\W_]*[j]|[ybau])|[e][\W_]*(?:[t][\W_]*[e]|[\W_]*[b]))|[ijoyau0]|[l][\W_]*[iou0]|[c][\W_]*[yu])))|(?:[f][\W_]*[iu][\W_]*[rg]|[xh][\W_]*(?:[eiu][\W_]*(?:[j][\W_]*)?[pr]|[pr][\W_]*[e][\W_]*[hn]|[yu][\W_]*[j]))|[xh][\W_]*[yu][\W_]*(?:[eiu][\W_]*(?:[sc][\W_]*[o0][\W_]*[sc]|[np][\W_]*[l][\W_]*[e][\W_]*[t]|[hn][\W_]*[i][\W_]*)(?:[\W_]*[yiau]|[\W_]*[oa0][\W_]*[m](?:[\W_]*[iu])?|[hn][\W_]*(?:[iu][\W_]*[j]|[a][\W_]*|[o0][\W_]*[ej]|[i][\W_]*[xh]|[i][\W_]*[e]|[i][\W_]*[m](?:[\W_]*[iu])?|[yu][\W_]*|[o0][\W_]*[m][\W_]*[yu]))?|[d][\W_]*[o0][\W_]*[\W_]*[b6][\W_]*[iu][\W_]*[hn][\W_]*(?:[o0][\W_]*[j]|[eyiau]))|[b6][\W_]*[l][\W_]*(?:[\W_]*[dt][\W_]*(?:[b]|[iu]|[k][\W_]*[iu]|[sc][\W_]*[t][\W_]*[bv][\W_]*[o0]|[sc][\W_]*[k][\W_]*(?:[o0][\W_]*[ej]|[iu][\W_]*[e]|[a][\W_]*|[iu][\W_]*[j]|[o0][\W_]*[rg][\W_]*[o0])))?|[bv][\W_]*[i][\W_]*[b6][\W_]*[l][\W_]*[\W_]*[d][\W_]*(?:[o0][\W_]*[k]|[k][\W_]*(?:[eiyau]|[a][\W_]*[m](?:[\W_]*[iu])?))|(?:[3z][\W_]*[oa0][\W_]*)(?:[np][\W_]*[oa0][\W_]*[d][\W_]*[l][\W_]*[oia0]|[l][\W_]*[yu][\W_]*[np][\W_]*(?:[o0][\W_]*[j]|[eyiau]))|[\W_]*[l][\W_]*[\W_]*[xh][\W_]*(?:[eiyau]|[o0][\W_]*[j])|[a][\W_]*[hn][\W_]*[yu][\W_]*[sc](?:[\W_]*[eyiau]|[\W_]*[o0][\W_]*[m])?|(?:\w*(?:[xh](?:[pr][e][hn]|[yu][iu])|[np][eiu](?:[3z][d]|[d](?:[eoa0][pr]|[pr]))|[b6][l][d]|[o0][xh][yu][e]|[m][yu][d][eioau0]|[d][e][pr][b]|[rg][oa0][bv][hn]|[yu][e][b6])|[xh][\W_]*(?:[pr][\W_]*[e][\W_]*[hn]|[yu][\W_]*[eiju])|[np][\W_]*[eiu][\W_]*(?:[3z][\W_]*[d]|[d][\W_]*(?:[eoa0][\W_]*[pr]|[pr]))|[b6][\W_]*[l][\W_]*[\W_]*[d]|[o0][\W_]*[xh][\W_]*[yu][\W_]*[e]|[m][\W_]*[yu][\W_]*[d][\W_]*[eioau0]|[d][\W_]*[e][\W_]*[pr][\W_]*[b]|[rg][\W_]*[oa0][\W_]*[bv][\W_]*[hn]|[yu][\W_]*[e][\W_]*[b6]|[e][b6])\w+';
		$self->{'bip'}='';
	}

	bless $self,$class;
	return $self;
		
}


sub remove_slang
{
	
	my ($self,$slang)=@_;

	
	eval
	{
		#$slang =~s/(?<=[\W_])($self->{'word'})(?=[\W_])/$self->{'bip'}/gi;
		#$slang =~s/(\b|_)(?:$self->{'word'})(\b|_)/$1bip$2/gi;	
		#$slang =~s/(?:\b|_)(?:$self->{'word'})(?:\b|_)//gi;

		$slang =~s/(?:\b|(?<=_))(?:$self->{'word'})(?:\b|(?=_))/$self->{'bip'}/gi;
  	
	};
	
	die "Fatal error: bad regular expression!" if $@;

	return $slang; 
}


sub detect_slang
{
	
	my ($self,$slang)=@_;
	my $match;
	
	eval 
	{
		$match=($slang =~m/(?:\b|(?<=_))(?:$self->{'word'})(?:\b|(?=_))/i);	
		
     };
	
	 die "Fatal error: bad regular expression!" if $@;

	return $match; 
}

sub set_bip
{
	my ($self,$bip)=@_;
	$self->{'bip'}=$bip;
}

sub load_dict
{
	my ($self,$file)=@_;
	
	local($/) = undef;
	my $FH = new FileHandle("$file")||die "Can't open $file!";
	my $dict=<$FH>;
	close($FH);
  	$dict=~ s/\015?\012/|/g;
  	
  	eval { '1'=~m/$dict/; };
	die "Bad regular expression in dictionary $file!" if $@;
	
	$self->{'word'}=$self->{'word'}.'|'.$dict;

}



1;

__END__


=head1 NAME

Lingua::RU::Antimat - Perl Module for removal Russian slang from chat, guestbooks, etc.

=head1 SYNOPSIS

use POSIX qw(locale_h);

use Lingua::RU::Antimat;

use locale;

setlocale(LC_CTYPE,"ru_RU.CP1251"); 

$dirty_text='text with slang';

$mat= Lingua::RU::Antimat->new;

#load dictionary with additional words

$mat->load_dict('/home/www/badwords');

$mat->set_bip('Sorry!');

$clean_text=$mat->remove_slang($dirty_text);


=head1 RUSSIAN DOCUMENTATION

Detailed Russian documentation and tutorial available on http://www.tcen.ru/antimat

=head1 DESCRIPTION

This module will remove Russian slang from a string. 'Mat' is Russian name for such bad words and  that is why this module is called Antimat. 

=over

=item $mat=Lingua::RU::Antimat->new($codepage);

This method creates a new object and returns it.
If new() is called without any arguments, the module will use templates for text in encoding win-1251.
If your text in encoding KOI8-R set $codepage equal 'koi8'.

Examples:

$mat=Lingua::RU::Antimat->new; #for text in win-1251

$mat=Lingua::RU::Antimat->new('koi8'); #for text in KOI8-R 

=item $clean_text=$mat->remove_slang($dirty_text);

Method remove_slang takes string and returns string where all 
bad words replaced on Russian analog 'bip' or string you set in method set_bip
which is described later.

=item $badwords=$mat->detect_slang($dirty_text);

Method detect_slang takes string and returns boolean value. This value equal 1
if there is bad word in the string and 0 if there is no such words in the string. 

=item $mat->set_bip($bip);

Set the string (usually word) which will replace bad words in method remove_slang.

Examples:

$mat->set_bip(''); #let strip out slang

$mat->set_bip('I am sorry!'); #long but also correct

=item $mat->load_dict($file);

This method loads dictionary with additional bad words. Each string in the dictionary should be a word or regular expression. $file could be relative or absolute path to the dictionary.

=back

=head1 SEE ALSO

Detailed Russian documentation on http://www.tcen.ru/antimat

perllocale manpage

=head1 CREDITS

Andrey Skorohod, marlenus@marlenus.com for his bug reports.
Vladimir Zhdanov, vovka@lg.kamaz.net for his bug report.
Andrey Sharapov, Sharapov@tut.by for his suggestions.
Yury Voloshin, xtc@norilsk.net for his bug report and suggestions.

Thanks!

=head1 AUTHOR

Ilya Soldatkin, arc@tcen.ru

Drop me a line if you deploy this module on your site. Think about this as a small contribution to my efforts for writing and supporting this module. I can not improve this module if I will know that no one uses it. 

=head1 COPYRIGHT

Copyright 2001-2003 Ilya Soldatkin. All rights reserved.

This library is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
