/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.CreateViewNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.LikeEscapeOperatorNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

public class FromBaseTable
extends FromTable {
    static final int UNSET = -1;
    TableName tableName;
    TableDescriptor tableDescriptor;
    ConglomerateDescriptor baseConglomerateDescriptor;
    ConglomerateDescriptor[] conglomDescs;
    int updateOrDelete;
    int bulkFetch = -1;
    boolean bulkFetchTurnedOff;
    private double singleScanRowCount;
    private FormatableBitSet referencedCols;
    private ResultColumnList templateColumns;
    private String[] columnNames;
    private boolean specialMaxScan;
    private boolean distinctScan;
    private boolean raDependentScan;
    private String raParentResultSetId;
    private long fkIndexConglomId;
    private int[] fkColArray;
    PredicateList baseTableRestrictionList;
    PredicateList nonBaseTableRestrictionList;
    PredicateList restrictionList;
    PredicateList storeRestrictionList;
    PredicateList nonStoreRestrictionList;
    PredicateList requalificationRestrictionList;
    public static final int UPDATE = 1;
    public static final int DELETE = 2;
    private boolean existsBaseTable;
    private boolean isNotExists;
    private JBitSet dependencyMap;
    private boolean getUpdateLocks;
    private boolean gotRowCount = false;
    private long rowCount = 0L;

    public void init(Object object, Object object2, Object object3, Object object4) {
        if (object3 instanceof Integer) {
            this.init(object2, null);
            this.tableName = (TableName)object;
            this.updateOrDelete = (Integer)object3;
            this.resultColumns = (ResultColumnList)object4;
        } else {
            this.init(object2, object4);
            this.tableName = (TableName)object;
            this.resultColumns = (ResultColumnList)object3;
        }
        this.templateColumns = this.resultColumns;
    }

    public boolean LOJ_reorderable(int n) throws StandardException {
        return false;
    }

    public JBitSet LOJgetReferencedTables(int n) throws StandardException {
        JBitSet jBitSet = new JBitSet(n);
        this.fillInReferencedTableMap(jBitSet);
        return jBitSet;
    }

    public boolean nextAccessPath(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, RowOrdering rowOrdering) throws StandardException {
        Object object;
        String string = this.getUserSpecifiedIndexName();
        AccessPath accessPath = this.getCurrentAccessPath();
        ConglomerateDescriptor conglomerateDescriptor = accessPath.getConglomerateDescriptor();
        optimizer.trace(42, optimizablePredicateList == null ? 0 : optimizablePredicateList.size(), 0, 0.0, this.getExposedName());
        rowOrdering.removeOptimizable(this.getTableNumber());
        if (string != null) {
            if (conglomerateDescriptor != null) {
                if (!super.nextAccessPath(optimizer, optimizablePredicateList, rowOrdering)) {
                    conglomerateDescriptor = null;
                }
            } else {
                optimizer.trace(39, this.tableNumber, 0, 0.0, string);
                if (StringUtil.SQLToUpperCase(string).equals("NULL")) {
                    conglomerateDescriptor = this.tableDescriptor.getConglomerateDescriptor(this.tableDescriptor.getHeapConglomerateId());
                } else {
                    this.getConglomDescs();
                    for (int i = 0; !(i >= this.conglomDescs.length || (object = (Object)(conglomerateDescriptor = this.conglomDescs[i]).getConglomerateName()) != null && ((String)object).equals(string)); ++i) {
                    }
                }
                if (!super.nextAccessPath(optimizer, optimizablePredicateList, rowOrdering)) {
                    // empty if block
                }
            }
        } else if (conglomerateDescriptor != null) {
            if (!super.nextAccessPath(optimizer, optimizablePredicateList, rowOrdering)) {
                conglomerateDescriptor = this.getNextConglom(conglomerateDescriptor);
                this.resetJoinStrategies(optimizer);
                if (!super.nextAccessPath(optimizer, optimizablePredicateList, rowOrdering)) {
                    // empty if block
                }
            }
        } else {
            conglomerateDescriptor = this.getFirstConglom();
            if (!super.nextAccessPath(optimizer, optimizablePredicateList, rowOrdering)) {
                // empty if block
            }
        }
        if (conglomerateDescriptor == null) {
            optimizer.trace(30, this.tableNumber, 0, 0.0, null);
        } else {
            conglomerateDescriptor.setColumnNames(this.columnNames);
            optimizer.trace(31, this.tableNumber, 0, 0.0, conglomerateDescriptor);
        }
        if (conglomerateDescriptor != null) {
            if (!conglomerateDescriptor.isIndex()) {
                if (!this.isOneRowResultSet(optimizablePredicateList)) {
                    optimizer.trace(33, optimizablePredicateList == null ? 0 : optimizablePredicateList.size(), 0, 0.0, null);
                    rowOrdering.addUnorderedOptimizable(this);
                } else {
                    optimizer.trace(32, 0, 0, 0.0, null);
                }
            } else {
                IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
                object = indexRowGenerator.baseColumnPositions();
                boolean[] blArray = indexRowGenerator.isAscending();
                for (int i = 0; i < ((Object)object).length; ++i) {
                    if (rowOrdering.orderedOnColumn(blArray[i] ? 1 : 2, this.getTableNumber(), (int)object[i])) continue;
                    rowOrdering.nextOrderPosition(blArray[i] ? 1 : 2);
                    rowOrdering.addOrderedColumn(blArray[i] ? 1 : 2, this.getTableNumber(), (int)object[i]);
                }
            }
        }
        accessPath.setConglomerateDescriptor(conglomerateDescriptor);
        return conglomerateDescriptor != null;
    }

    protected boolean canBeOrdered() {
        return true;
    }

    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate, RowOrdering rowOrdering) throws StandardException {
        optimizer.costOptimizable(this, this.tableDescriptor, this.getCurrentAccessPath().getConglomerateDescriptor(), optimizablePredicateList, costEstimate);
        return this.costEstimate;
    }

    public TableDescriptor getTableDescriptor() {
        return this.tableDescriptor;
    }

    public boolean isMaterializable() throws StandardException {
        return true;
    }

    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        this.restrictionList.addPredicate((Predicate)optimizablePredicate);
        return true;
    }

    public void pullOptPredicates(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        for (int i = this.restrictionList.size() - 1; i >= 0; --i) {
            optimizablePredicateList.addOptPredicate(this.restrictionList.getOptPredicate(i));
            this.restrictionList.removeOptPredicate(i);
        }
    }

    public boolean isCoveringIndex(ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        boolean bl = true;
        if (!conglomerateDescriptor.isIndex()) {
            return false;
        }
        IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
        int[] nArray = indexRowGenerator.baseColumnPositions();
        int n = this.resultColumns.size();
        for (int i = 0; i < n; ++i) {
            ResultColumn resultColumn = (ResultColumn)this.resultColumns.elementAt(i);
            if (!resultColumn.isReferenced() || resultColumn.getExpression() instanceof ConstantNode) continue;
            bl = false;
            int n2 = resultColumn.getColumnPosition();
            for (int j = 0; j < nArray.length; ++j) {
                if (n2 != nArray[j]) continue;
                bl = true;
                break;
            }
            if (!bl) break;
        }
        return bl;
    }

    public void verifyProperties(DataDictionary dataDictionary) throws StandardException {
        String string;
        Object object;
        if (this.tableProperties == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        ConstraintDescriptor constraintDescriptor = null;
        Enumeration<Object> enumeration = this.tableProperties.keys();
        StringUtil.SQLEqualsIgnoreCase(this.tableDescriptor.getSchemaName(), "SYS");
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            string = (String)this.tableProperties.get(object);
            if (((String)object).equals("index")) {
                String string2;
                if (bl2) {
                    throw StandardException.newException("42Y50", this.getBaseTableName());
                }
                bl = true;
                if (StringUtil.SQLToUpperCase(string).equals("NULL")) continue;
                ConglomerateDescriptor conglomerateDescriptor = null;
                ConglomerateDescriptor[] conglomerateDescriptorArray = this.tableDescriptor.getConglomerateDescriptors();
                for (int i = 0; !(i >= conglomerateDescriptorArray.length || (string2 = (conglomerateDescriptor = conglomerateDescriptorArray[i]).getConglomerateName()) != null && string2.equals(string)); ++i) {
                    conglomerateDescriptor = null;
                }
                if (conglomerateDescriptor == null) {
                    throw StandardException.newException("42Y46", string, (Object)this.getBaseTableName());
                }
                this.getCompilerContext().createDependency(conglomerateDescriptor);
                continue;
            }
            if (((String)object).equals("constraint")) {
                if (bl) {
                    throw StandardException.newException("42Y50", this.getBaseTableName());
                }
                bl2 = true;
                if (StringUtil.SQLToUpperCase(string).equals("NULL")) continue;
                constraintDescriptor = dataDictionary.getConstraintDescriptorByName(this.tableDescriptor, null, string, false);
                if (constraintDescriptor == null || !constraintDescriptor.hasBackingIndex()) {
                    throw StandardException.newException("42Y48", string, (Object)this.getBaseTableName());
                }
                this.getCompilerContext().createDependency(constraintDescriptor);
                continue;
            }
            if (((String)object).equals("joinStrategy")) {
                this.userSpecifiedJoinStrategy = StringUtil.SQLToUpperCase(string);
                continue;
            }
            if (((String)object).equals("hashInitialCapacity")) {
                this.initialCapacity = this.getIntProperty(string, (String)object);
                if (this.initialCapacity > 0) continue;
                throw StandardException.newException("42Y59", String.valueOf(this.initialCapacity));
            }
            if (((String)object).equals("hashLoadFactor")) {
                try {
                    this.loadFactor = Float.valueOf(string).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    throw StandardException.newException("42Y58", string, object);
                }
                if (!((double)this.loadFactor <= 0.0) && !((double)this.loadFactor > 1.0)) continue;
                throw StandardException.newException("42Y60", string);
            }
            if (((String)object).equals("hashMaxCapacity")) {
                this.maxCapacity = this.getIntProperty(string, (String)object);
                if (this.maxCapacity > 0) continue;
                throw StandardException.newException("42Y61", String.valueOf(this.maxCapacity));
            }
            if (((String)object).equals("bulkFetch")) {
                this.bulkFetch = this.getIntProperty(string, (String)object);
                if (this.bulkFetch <= 0) {
                    throw StandardException.newException("42Y64", String.valueOf(this.bulkFetch));
                }
                if (!this.forUpdate()) continue;
                throw StandardException.newException("42Y66");
            }
            throw StandardException.newException("42Y44", object, (Object)"index, constraint, joinStrategy");
        }
        if (bl2) {
            object = dataDictionary.getConglomerateDescriptor(constraintDescriptor.getConglomerateId());
            string = ((ConglomerateDescriptor)object).getConglomerateName();
            this.tableProperties.remove("constraint");
            this.tableProperties.put("index", string);
        }
    }

    public String getBaseTableName() {
        return this.tableName.getTableName();
    }

    public void startOptimizing(Optimizer optimizer, RowOrdering rowOrdering) {
        AccessPath accessPath = this.getCurrentAccessPath();
        AccessPath accessPath2 = this.getBestAccessPath();
        AccessPath accessPath3 = this.getBestSortAvoidancePath();
        accessPath.setConglomerateDescriptor(null);
        accessPath2.setConglomerateDescriptor(null);
        accessPath3.setConglomerateDescriptor(null);
        accessPath.setCoveringIndexScan(false);
        accessPath2.setCoveringIndexScan(false);
        accessPath3.setCoveringIndexScan(false);
        accessPath.setLockMode(0);
        accessPath2.setLockMode(0);
        accessPath3.setLockMode(0);
        CostEstimate costEstimate = this.getCostEstimate(optimizer);
        accessPath.setCostEstimate(costEstimate);
        costEstimate.setCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        super.startOptimizing(optimizer, rowOrdering);
    }

    public int convertAbsoluteToRelativeColumnPosition(int n) {
        return this.mapAbsoluteToRelativeColumnPosition(n);
    }

    public CostEstimate estimateCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        boolean bl = false;
        boolean bl2 = false;
        PredicateList predicateList = null;
        if (optimizer.useStatistics() && optimizablePredicateList != null) {
            bl2 = this.tableDescriptor.statisticsExist(conglomerateDescriptor);
            bl = this.tableDescriptor.statisticsExist(null);
            predicateList = new PredicateList();
            optimizablePredicateList.copyPredicatesToOtherList(predicateList);
        }
        AccessPath accessPath = this.getCurrentAccessPath();
        JoinStrategy joinStrategy = accessPath.getJoinStrategy();
        optimizer.trace(38, this.tableNumber, 0, 0.0, conglomerateDescriptor);
        double d = optimizer.uniqueJoinWithOuterTable(optimizablePredicateList);
        boolean bl3 = this.isOneRowResultSet(optimizablePredicateList);
        this.baseTableRestrictionList.removeAllElements();
        joinStrategy.getBasePredicates(optimizablePredicateList, this.baseTableRestrictionList, this);
        StoreCostController storeCostController = this.getStoreCostController(conglomerateDescriptor);
        CostEstimate costEstimate2 = this.getScratchCostEstimate(optimizer);
        if (this.isOneRowResultSet(conglomerateDescriptor, this.baseTableRestrictionList)) {
            OptimizablePredicate optimizablePredicate;
            rowOrdering.optimizableAlwaysOrdered(this);
            this.singleScanRowCount = 1.0;
            double d2 = storeCostController.getFetchFromFullKeyCost(null, 0);
            optimizer.trace(40, this.tableNumber, 0, d2, null);
            costEstimate2.setCost(d2, 1.0, 1.0);
            double d3 = costEstimate2.getEstimatedCost();
            if (joinStrategy.multiplyBaseCostByOuterRows()) {
                d3 *= costEstimate.rowCount();
            }
            costEstimate2.setCost(d3, costEstimate2.rowCount() * costEstimate.rowCount(), costEstimate2.singleScanRowCount());
            boolean bl4 = true;
            for (int i = 0; i < optimizablePredicateList.size() && ((optimizablePredicate = optimizablePredicateList.getOptPredicate(i)).isStartKey() || optimizablePredicate.isStopKey()); ++i) {
                if (optimizablePredicate.getReferencedMap().hasSingleBitSet()) continue;
                bl4 = false;
                break;
            }
            if (bl4) {
                accessPath.setLockMode(6);
                optimizer.trace(37, 0, 0, 0.0, null);
            } else {
                this.setLockingBasedOnThreshold(optimizer, costEstimate2.rowCount());
            }
            optimizer.trace(23, this.tableNumber, 0, costEstimate.rowCount(), costEstimate2);
            if (conglomerateDescriptor.isIndex() && !this.isCoveringIndex(conglomerateDescriptor)) {
                double d4 = this.getBaseCostController().getFetchFromRowLocationCost(null, 0);
                d2 = d4 * costEstimate2.rowCount();
                costEstimate2.setEstimatedCost(costEstimate2.getEstimatedCost() + d2);
                optimizer.trace(36, this.tableNumber, 0, d2, null);
            }
        } else {
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            int n;
            int n2;
            OptimizablePredicate optimizablePredicate;
            double d10 = 1.0;
            double d11 = 1.0;
            double d12 = 1.0;
            double d13 = 1.0;
            double d14 = 1.0;
            double d15 = 1.0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = true;
            boolean bl9 = false;
            int n7 = 0;
            int n8 = 0;
            int n9 = optimizablePredicateList != null ? this.baseTableRestrictionList.size() : 0;
            int n10 = 0;
            ColumnReference columnReference = null;
            for (int i = 0; i < n9; ++i) {
                ValueNode valueNode;
                optimizablePredicate = this.baseTableRestrictionList.getOptPredicate(i);
                boolean bl10 = optimizablePredicate.isStartKey();
                n2 = optimizablePredicate.isStopKey();
                if (bl10 || n2 != 0) {
                    bl9 = true;
                    if (!optimizablePredicate.getReferencedMap().hasSingleBitSet()) {
                        bl8 = false;
                    }
                    n = optimizablePredicate.compareWithKnownConstant(this, true);
                    if (bl10) {
                        if (n != 0 && !bl5) {
                            ++n7;
                            if (predicateList != null) {
                                predicateList.removeOptPredicate(optimizablePredicate);
                            }
                        } else {
                            bl5 = true;
                        }
                    }
                    if (n2 != 0) {
                        if (n != 0 && !bl6) {
                            ++n8;
                            if (predicateList != null) {
                                predicateList.removeOptPredicate(optimizablePredicate);
                            }
                        } else {
                            bl6 = true;
                        }
                    }
                    if (!bl5 && !bl6 || this.baseTableRestrictionList.isRedundantPredicate(i)) continue;
                    if (bl10 && n2 != 0) {
                        ++n10;
                    }
                    if (optimizablePredicate.getIndexPosition() == 0) {
                        d10 *= optimizablePredicate.selectivity(this);
                        if (bl7) continue;
                        valueNode = ((Predicate)optimizablePredicate).getAndNode().getLeftOperand();
                        if (valueNode instanceof BinaryRelationalOperatorNode) {
                            columnReference = ((BinaryRelationalOperatorNode)valueNode).getColumnOperand(this);
                        }
                        bl7 = true;
                        continue;
                    }
                    d11 *= optimizablePredicate.selectivity(this);
                    ++n4;
                    continue;
                }
                if (this.baseTableRestrictionList.isRedundantPredicate(i)) continue;
                if (optimizablePredicate instanceof Predicate) {
                    ColumnReference columnReference2;
                    ValueNode valueNode2;
                    ValueNode valueNode3 = ((Predicate)optimizablePredicate).getAndNode().getLeftOperand();
                    if (columnReference != null && valueNode3 instanceof LikeEscapeOperatorNode && (valueNode = (LikeEscapeOperatorNode)valueNode3).getLeftOperand().isParameterNode() && (valueNode2 = valueNode.getReceiver()) instanceof ColumnReference && (columnReference2 = (ColumnReference)valueNode2).getTableNumber() == columnReference.getTableNumber() && columnReference2.getColumnNumber() == columnReference.getColumnNumber()) {
                        d10 *= 0.2;
                    }
                }
                if (optimizablePredicate.isQualifier()) {
                    d12 *= optimizablePredicate.selectivity(this);
                    ++n5;
                } else {
                    d13 *= optimizablePredicate.selectivity(this);
                    ++n6;
                }
                bl5 = true;
                bl6 = true;
            }
            if (predicateList != null && (d15 = predicateList.selectivity(this)) == -1.0) {
                d15 = 1.0;
            }
            if (bl7 && bl2 && n10 > 0) {
                d14 = this.tableDescriptor.selectivityForConglomerate(conglomerateDescriptor, n10);
            }
            d13 *= joinStrategy.nonBasePredicateSelectivity(this, optimizablePredicateList);
            DataValueDescriptor[] dataValueDescriptorArray = n7 > 0 ? new DataValueDescriptor[n7] : null;
            DataValueDescriptor[] dataValueDescriptorArray2 = n8 > 0 ? new DataValueDescriptor[n8] : null;
            n7 = 0;
            n8 = 0;
            bl5 = false;
            bl6 = false;
            for (n2 = 0; n2 < n9; ++n2) {
                optimizablePredicate = this.baseTableRestrictionList.getOptPredicate(n2);
                n = optimizablePredicate.isStartKey();
                boolean bl11 = optimizablePredicate.isStopKey();
                if (n != 0 || bl11) {
                    boolean bl12 = optimizablePredicate.compareWithKnownConstant(this, true);
                    if (n != 0) {
                        if (bl12 && !bl5) {
                            dataValueDescriptorArray[n7] = optimizablePredicate.getCompareValue(this);
                            ++n7;
                        } else {
                            bl5 = true;
                        }
                    }
                    if (!bl11) continue;
                    if (bl12 && !bl6) {
                        dataValueDescriptorArray2[n8] = optimizablePredicate.getCompareValue(this);
                        ++n8;
                        continue;
                    }
                    bl6 = true;
                    continue;
                }
                bl5 = true;
                bl6 = true;
            }
            if (this.baseTableRestrictionList != null) {
                n2 = this.baseTableRestrictionList.startOperator(this);
                n = this.baseTableRestrictionList.stopOperator(this);
            } else {
                n2 = 0;
                n = 0;
            }
            DataValueDescriptor[] dataValueDescriptorArray3 = this.getRowTemplate(conglomerateDescriptor, this.getBaseCostController());
            long l = dataValueDescriptorArray != null || dataValueDescriptorArray2 != null ? this.baseRowCount() : this.baseRowCount() + 5L;
            storeCostController.getScanCost(joinStrategy.scanCostType(), l, 1, this.forUpdate(), null, dataValueDescriptorArray3, dataValueDescriptorArray, n2, dataValueDescriptorArray2, n, false, 0, costEstimate2);
            double d16 = 0.0;
            if (conglomerateDescriptor.isIndex()) {
                d16 = storeCostController.getFetchFromFullKeyCost(null, 0);
                if (bl3 && costEstimate2.rowCount() <= 1.0) {
                    costEstimate2.setCost(costEstimate2.getEstimatedCost() * 2.0, costEstimate2.rowCount() + 2.0, costEstimate2.singleScanRowCount() + 2.0);
                }
            }
            optimizer.trace(53, this.tableNumber, 0, 0.0, conglomerateDescriptor);
            optimizer.trace(54, this.tableNumber, 0, 0.0, costEstimate2);
            optimizer.trace(55, n3, 0, d10, null);
            optimizer.trace(56, n4, 0, d11, null);
            optimizer.trace(59, n10, 0, d14, null);
            optimizer.trace(57, n5, 0, d12, null);
            optimizer.trace(58, n6, 0, d13, null);
            double d17 = costEstimate2.rowCount();
            if (d14 != 1.0) {
                costEstimate2.setCost(this.scanCostAfterSelectivity(costEstimate2.getEstimatedCost(), d16, d14, bl3), costEstimate2.rowCount() * d14, costEstimate2.singleScanRowCount() * d14);
                optimizer.trace(62, this.tableNumber, 0, 0.0, costEstimate2);
            } else {
                if (d10 != 1.0) {
                    costEstimate2.setCost(this.scanCostAfterSelectivity(costEstimate2.getEstimatedCost(), d16, d10, bl3), costEstimate2.rowCount() * d10, costEstimate2.singleScanRowCount() * d10);
                    optimizer.trace(41, this.tableNumber, 0, 0.0, costEstimate2);
                }
                if (d11 != 1.0) {
                    costEstimate2.setCost(costEstimate2.getEstimatedCost(), costEstimate2.rowCount() * d11, costEstimate2.singleScanRowCount() * d11);
                    optimizer.trace(45, this.tableNumber, 0, 0.0, costEstimate2);
                }
            }
            if (!bl9) {
                accessPath.setLockMode(7);
                optimizer.trace(35, 0, 0, 0.0, null);
            } else {
                d9 = costEstimate2.rowCount();
                if (!bl8 && joinStrategy.multiplyBaseCostByOuterRows()) {
                    d8 = this.baseRowCount();
                    if (d8 > 0.0) {
                        double d18;
                        d7 = costEstimate2.rowCount();
                        d6 = costEstimate.rowCount();
                        d5 = 1.0 - d7 / d8;
                        double d19 = Math.pow(d5, d6);
                        double d20 = 1.0 - d19;
                        d9 = d18 = d8 * d20;
                    } else {
                        d9 = optimizer.tableLockThreshold() + 1;
                    }
                }
                this.setLockingBasedOnThreshold(optimizer, d9);
            }
            if (conglomerateDescriptor.isIndex() && !this.isCoveringIndex(conglomerateDescriptor)) {
                d9 = this.getBaseCostController().getFetchFromRowLocationCost(null, 0);
                double d21 = d9 * costEstimate2.rowCount();
                costEstimate2.setEstimatedCost(costEstimate2.getEstimatedCost() + d21);
                optimizer.trace(48, this.tableNumber, 0, 0.0, costEstimate2);
            }
            if (d12 != 1.0) {
                costEstimate2.setCost(costEstimate2.getEstimatedCost(), costEstimate2.rowCount() * d12, costEstimate2.singleScanRowCount() * d12);
                optimizer.trace(46, this.tableNumber, 0, 0.0, costEstimate2);
            }
            this.singleScanRowCount = costEstimate2.singleScanRowCount();
            d9 = costEstimate2.getEstimatedCost();
            d8 = costEstimate2.rowCount();
            if (joinStrategy.multiplyBaseCostByOuterRows()) {
                d9 *= costEstimate.rowCount();
            }
            d8 *= costEstimate.rowCount();
            d17 *= costEstimate.rowCount();
            if (bl3 && costEstimate.rowCount() < d8) {
                d8 = costEstimate.rowCount();
            }
            if (conglomerateDescriptor.isIndex() && bl9 && !bl8 && (d7 = optimizer.uniqueJoinWithOuterTable(this.baseTableRestrictionList)) > 0.0 && d8 > (d6 = (double)this.baseRowCount() / d7)) {
                d9 *= d6 / d8;
            }
            if (d > 0.0 && d8 > (d7 = (double)this.baseRowCount() / d)) {
                d8 = d7;
            }
            costEstimate2.setCost(d9, d8, costEstimate2.singleScanRowCount());
            optimizer.trace(23, this.tableNumber, 0, costEstimate.rowCount(), costEstimate2);
            d7 = -1.0;
            d6 = -1.0;
            if (this.existsBaseTable) {
                d6 = 1.0;
                d7 = 1.0;
            } else if (d13 != 1.0) {
                d7 = bl3 ? costEstimate2.rowCount() : costEstimate2.rowCount() * d13;
                d6 = costEstimate2.singleScanRowCount() * d13;
            }
            if (d7 != -1.0) {
                costEstimate2.setCost(costEstimate2.getEstimatedCost(), d7, d6);
                optimizer.trace(47, this.tableNumber, 0, 0.0, costEstimate2);
            }
            if (bl && !bl3 && d15 != 1.0) {
                d5 = d17 * d15;
                optimizer.trace(61, 0, 0, d15, null);
                if (!(d > 0.0) || !(d5 > (double)this.baseRowCount() * d)) {
                    costEstimate2.setCost(costEstimate2.getEstimatedCost(), d5, this.existsBaseTable ? 1.0 : d5 / costEstimate.rowCount());
                    optimizer.trace(60, this.tableNumber, 0, 0.0, costEstimate2);
                }
            }
        }
        joinStrategy.putBasePredicates(optimizablePredicateList, this.baseTableRestrictionList);
        return costEstimate2;
    }

    private double scanCostAfterSelectivity(double d, double d2, double d3, boolean bl) throws StandardException {
        double d4;
        double d5;
        if (bl && (d5 = (double)this.baseRowCount()) > 0.0 && (d4 = 2.0 / d5) > d3) {
            d3 = d4;
        }
        if ((d5 = (d - d2) * d3) < 0.0) {
            d5 = 0.0;
        }
        return d2 + d5;
    }

    private void setLockingBasedOnThreshold(Optimizer optimizer, double d) {
        this.getCurrentAccessPath().setLockMode(6);
    }

    public boolean isBaseTable() {
        return true;
    }

    public boolean forUpdate() {
        return this.updateOrDelete != 0 || this.cursorTargetTable || this.getUpdateLocks;
    }

    public int initialCapacity() {
        return this.initialCapacity;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public boolean memoryUsageOK(double d, int n) throws StandardException {
        return super.memoryUsageOK(this.singleScanRowCount, n);
    }

    public boolean isTargetTable() {
        return this.updateOrDelete != 0;
    }

    public double uniqueJoin(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        double d = -1.0;
        PredicateList predicateList = (PredicateList)optimizablePredicateList;
        int n = this.getTableDescriptor().getNumberOfColumns();
        int n2 = this.getTableNumber();
        int[] nArray = new int[]{};
        JBitSet[] jBitSetArray = new JBitSet[]{new JBitSet(n + 1)};
        predicateList.checkTopPredicatesForEqualsConditions(n2, null, nArray, jBitSetArray, false);
        if (this.supersetOfUniqueIndex(jBitSetArray)) {
            d = this.getBestAccessPath().getCostEstimate().singleScanRowCount();
        }
        return d;
    }

    public boolean isOneRowScan() throws StandardException {
        if (this.existsBaseTable) {
            return false;
        }
        return super.isOneRowScan();
    }

    public boolean legalJoinOrder(JBitSet jBitSet) {
        if (this.existsBaseTable) {
            return jBitSet.contains(this.dependencyMap);
        }
        return true;
    }

    public String toString() {
        return "";
    }

    boolean getExistsBaseTable() {
        return this.existsBaseTable;
    }

    void setExistsBaseTable(boolean bl, JBitSet jBitSet, boolean bl2) {
        this.existsBaseTable = bl;
        this.isNotExists = bl2;
        this.dependencyMap = bl ? jBitSet : null;
    }

    void clearDependency(Vector vector) {
        if (this.dependencyMap != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.dependencyMap.clear((Integer)vector.elementAt(i));
            }
        }
    }

    public void setTableProperties(Properties properties) {
        this.tableProperties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        TableDescriptor tableDescriptor = this.bindTableDescriptor();
        ResultColumnList resultColumnList = this.resultColumns;
        this.restrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        this.baseTableRestrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        CompilerContext compilerContext = this.getCompilerContext();
        this.templateColumns = this.resultColumns = this.genResultColList();
        if (tableDescriptor.getTableType() == 2) {
            ViewDescriptor viewDescriptor = dataDictionary.getViewDescriptor(tableDescriptor);
            SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(viewDescriptor.getCompSchemaId(), null);
            SchemaDescriptor schemaDescriptor2 = compilerContext.setCompilationSchema(schemaDescriptor);
            try {
                compilerContext.createDependency(viewDescriptor);
                LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
                CompilerContext compilerContext2 = languageConnectionContext.pushCompilerContext();
                CreateViewNode createViewNode = (CreateViewNode)QueryTreeNode.parseQueryText(compilerContext2, viewDescriptor.getViewText(), null, languageConnectionContext);
                languageConnectionContext.popCompilerContext(compilerContext2);
                ResultSetNode resultSetNode = createViewNode.getParsedQueryExpression();
                if (resultSetNode.getResultColumns().containsAllResultColumn()) {
                    this.resultColumns.setCountMismatchAllowed(true);
                }
                FromTable fromTable = (FromTable)this.getNodeFactory().getNode(136, resultSetNode, this.correlationName != null ? this.correlationName : this.tableName.getTableName(), this.resultColumns, this.tableProperties, this.getContextManager());
                fromTable.setLevel(this.level);
                ResultSetNode resultSetNode2 = fromTable.bindNonVTITables(dataDictionary, fromList);
                return resultSetNode2;
            }
            finally {
                compilerContext.setCompilationSchema(schemaDescriptor2);
            }
        }
        compilerContext.createDependency(tableDescriptor);
        this.baseConglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(tableDescriptor.getHeapConglomerateId());
        this.columnNames = this.resultColumns.getColumnNames();
        if (resultColumnList != null) {
            this.resultColumns.propagateDCLInfo(resultColumnList, this.tableName.getFullTableName());
        }
        if (this.tableNumber == -1) {
            this.tableNumber = compilerContext.getNextTableNumber();
        }
        return this;
    }

    protected FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        String string3;
        String string4 = this.tableName.getSchemaName();
        String string5 = string3 = string2 != null ? string2 + '.' + string : string;
        if (bl) {
            if (string2 != null && string4 == null || string2 == null && string4 != null) {
                return null;
            }
            if (this.getExposedName().equals(string3)) {
                return this;
            }
            return null;
        }
        if (this.getExposedName().equals(string3)) {
            return this;
        }
        if (string2 != null && string4 != null || string2 == null && string4 == null) {
            return null;
        }
        if (string2 != null && string4 == null) {
            if (!string2.equals(this.tableDescriptor.getSchemaDescriptor().getSchemaName())) {
                return null;
            }
            if (!this.getExposedName().equals(string)) {
                return null;
            }
            if (!this.getExposedName().equals(this.tableName.getTableName())) {
                return null;
            }
            return this;
        }
        if (!this.getExposedName().equals(this.tableName.getSchemaName() + "." + string)) {
            return null;
        }
        return this;
    }

    private TableDescriptor bindTableDescriptor() throws StandardException {
        String string = this.tableName.getSchemaName();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(string);
        this.tableDescriptor = this.getTableDescriptor(this.tableName.getTableName(), schemaDescriptor);
        if (this.tableDescriptor != null) {
            this.tableDescriptor = this.tableDescriptor;
        } else {
            TableName tableName = this.resolveTableToSynonym(this.tableName);
            if (tableName == null) {
                throw StandardException.newException("42X05", this.tableName);
            }
            this.tableName = tableName;
            schemaDescriptor = this.getSchemaDescriptor(this.tableName.getSchemaName());
            this.tableDescriptor = this.getTableDescriptor(tableName.getTableName(), schemaDescriptor);
            if (this.tableDescriptor == null) {
                throw StandardException.newException("42X05", this.tableName);
            }
        }
        return this.tableDescriptor;
    }

    public void bindExpressions(FromList fromList) throws StandardException {
    }

    public void bindResultColumns(FromList fromList) throws StandardException {
    }

    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        TableName tableName;
        ResultColumn resultColumn = null;
        TableName tableName2 = columnReference.getTableNameNode();
        if (tableName2 != null && tableName2.getSchemaName() == null && this.correlationName == null) {
            tableName2.bind(this.getDataDictionary());
        }
        if ((tableName = this.correlationName != null ? this.makeTableName(null, this.correlationName) : this.tableName).getSchemaName() == null && this.correlationName == null) {
            tableName.bind(this.getDataDictionary());
        }
        if ((tableName2 == null || tableName2.equals(tableName)) && (resultColumn = this.resultColumns.getResultColumn(columnReference.getColumnName())) != null) {
            columnReference.setTableNumber(this.tableNumber);
            if (this.tableDescriptor != null) {
                FormatableBitSet formatableBitSet = this.tableDescriptor.getReferencedColumnMap();
                if (formatableBitSet == null) {
                    formatableBitSet = new FormatableBitSet(this.tableDescriptor.getNumberOfColumns() + 1);
                }
                formatableBitSet.set(resultColumn.getColumnPosition());
                this.tableDescriptor.setReferencedColumnMap(formatableBitSet);
            }
        }
        return resultColumn;
    }

    public ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        this.referencedTableMap = new JBitSet(n);
        this.referencedTableMap.set(this.tableNumber);
        return this.genProjectRestrict(n);
    }

    protected ResultSetNode genProjectRestrict(int n) throws StandardException {
        ResultColumnList resultColumnList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        resultColumnList.genVirtualColumnNodes(this, this.resultColumns, false);
        resultColumnList.doProjection();
        return (ResultSetNode)this.getNodeFactory().getNode(151, this, resultColumnList, null, null, null, null, null, this.getContextManager());
    }

    public ResultSetNode changeAccessPath() throws StandardException {
        AccessPath accessPath = this.getTrulyTheBestAccessPath();
        ConglomerateDescriptor conglomerateDescriptor = accessPath.getConglomerateDescriptor();
        JoinStrategy joinStrategy = accessPath.getJoinStrategy();
        Optimizer optimizer = accessPath.getOptimizer();
        optimizer.trace(34, this.tableNumber, 0, 0.0, null);
        if (this.bulkFetch != -1) {
            if (!joinStrategy.bulkFetchOK()) {
                throw StandardException.newException("42Y65", joinStrategy.getName());
            }
            if (joinStrategy.ignoreBulkFetch()) {
                this.disableBulkFetch();
            } else if (this.isOneRowResultSet()) {
                this.disableBulkFetch();
            }
        }
        if (this.bulkFetch == 1) {
            this.disableBulkFetch();
        }
        this.restrictionList.removeRedundantPredicates();
        this.storeRestrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        this.nonStoreRestrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        this.requalificationRestrictionList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        joinStrategy.divideUpPredicateLists(this, this.restrictionList, this.storeRestrictionList, this.nonStoreRestrictionList, this.requalificationRestrictionList, this.getDataDictionary());
        if (!(!joinStrategy.bulkFetchOK() || joinStrategy.ignoreBulkFetch() || this.bulkFetchTurnedOff || this.bulkFetch != -1 || this.forUpdate() || this.isOneRowResultSet() || this.getLevel() != 0)) {
            this.bulkFetch = this.getDefaultBulkFetch();
        }
        this.getCompilerContext().createDependency(conglomerateDescriptor);
        if (!conglomerateDescriptor.isIndex()) {
            boolean bl = this.tableName.equals("SYS", "SYSSTATEMENTS");
            this.templateColumns = this.resultColumns;
            this.referencedCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, bl, false);
            this.resultColumns = this.resultColumns.compactColumns(this.cursorTargetTable, bl);
            return this;
        }
        if (accessPath.getCoveringIndexScan()) {
            this.resultColumns = this.newResultColumns(this.resultColumns, conglomerateDescriptor, this.baseConglomerateDescriptor, false);
            this.templateColumns = this.newResultColumns(this.resultColumns, conglomerateDescriptor, this.baseConglomerateDescriptor, false);
            this.templateColumns.addRCForRID();
            if (this.forUpdate()) {
                this.resultColumns.addRCForRID();
            }
            this.referencedCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, true, false);
            this.resultColumns = this.resultColumns.compactColumns(this.cursorTargetTable, true);
            this.resultColumns.setIndexRow(this.baseConglomerateDescriptor.getConglomerateNumber(), this.forUpdate());
            return this;
        }
        this.getCompilerContext().createDependency(this.baseConglomerateDescriptor);
        if (this.bulkFetch != -1) {
            this.restrictionList.copyPredicatesToOtherList(this.requalificationRestrictionList);
        }
        ResultColumnList resultColumnList = this.newResultColumns(this.resultColumns, conglomerateDescriptor, this.baseConglomerateDescriptor, true);
        FormatableBitSet formatableBitSet = null;
        FormatableBitSet formatableBitSet2 = null;
        if (this.bulkFetch == -1 && (this.requalificationRestrictionList == null || this.requalificationRestrictionList.size() == 0)) {
            formatableBitSet = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, true, false);
            formatableBitSet2 = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, true, true);
            if (formatableBitSet2 != null) {
                formatableBitSet.xor(formatableBitSet2);
            }
        } else {
            formatableBitSet2 = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, true, false);
        }
        ResultColumnList resultColumnList2 = this.resultColumns.compactColumns(this.cursorTargetTable, false);
        ResultSetNode resultSetNode = (ResultSetNode)this.getNodeFactory().getNode(149, this, this.baseConglomerateDescriptor, resultColumnList2, new Boolean(this.cursorTargetTable), formatableBitSet2, formatableBitSet, this.requalificationRestrictionList, new Boolean(this.forUpdate()), this.tableProperties, this.getContextManager());
        this.resultColumns = resultColumnList;
        this.templateColumns = this.newResultColumns(this.resultColumns, conglomerateDescriptor, this.baseConglomerateDescriptor, false);
        if (this.bulkFetch != -1) {
            this.resultColumns.markAllUnreferenced();
            this.storeRestrictionList.markReferencedColumns();
            if (this.nonStoreRestrictionList != null) {
                this.nonStoreRestrictionList.markReferencedColumns();
            }
        }
        this.resultColumns.addRCForRID();
        this.templateColumns.addRCForRID();
        this.referencedCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable, false, false);
        this.resultColumns = this.resultColumns.compactColumns(this.cursorTargetTable, false);
        this.resultColumns.setIndexRow(this.baseConglomerateDescriptor.getConglomerateNumber(), this.forUpdate());
        this.getUpdateLocks = this.cursorTargetTable;
        this.cursorTargetTable = false;
        return resultSetNode;
    }

    private ResultColumnList newResultColumns(ResultColumnList resultColumnList, ConglomerateDescriptor conglomerateDescriptor, ConglomerateDescriptor conglomerateDescriptor2, boolean bl) throws StandardException {
        IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
        int[] nArray = indexRowGenerator.baseColumnPositions();
        ResultColumnList resultColumnList2 = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        for (int i = 0; i < nArray.length; ++i) {
            ResultColumn resultColumn;
            int n = nArray[i];
            ResultColumn resultColumn2 = resultColumnList.getResultColumn(n);
            if (bl) {
                resultColumn = resultColumn2.cloneMe();
                resultColumn2.setExpression((ValueNode)this.getNodeFactory().getNode(107, this, resultColumn, ReuseFactory.getInteger(resultColumn2.getVirtualColumnId()), this.getContextManager()));
            } else {
                resultColumn = resultColumn2;
            }
            resultColumnList2.addResultColumn(resultColumn);
        }
        resultColumnList2.setIndexRow(conglomerateDescriptor2.getConglomerateNumber(), this.forUpdate());
        return resultColumnList2;
    }

    public void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateResultSet(activationClassBuilder, methodBuilder);
        if (this.cursorTargetTable) {
            activationClassBuilder.rememberCursorTarget(methodBuilder);
        }
    }

    public void generateResultSet(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.assignResultSetNumber();
        if (this.specialMaxScan) {
            this.generateMaxSpecialResultSet(expressionClassBuilder, methodBuilder);
            return;
        }
        if (this.distinctScan) {
            this.generateDistinctScan(expressionClassBuilder, methodBuilder);
            return;
        }
        if (this.raDependentScan) {
            this.generateRefActionDependentTableScan(expressionClassBuilder, methodBuilder);
            return;
        }
        JoinStrategy joinStrategy = this.getTrulyTheBestAccessPath().getJoinStrategy();
        expressionClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        int n = this.getScanArguments(expressionClassBuilder, methodBuilder);
        methodBuilder.callMethod((short)185, null, joinStrategy.resultSetMethodName(this.bulkFetch != -1), "org.apache.derby.iapi.sql.execute.NoPutResultSet", n);
        if (this.updateOrDelete == 1 || this.updateOrDelete == 2) {
            methodBuilder.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
            methodBuilder.putField(expressionClassBuilder.getRowLocationScanResultSetName(), "org.apache.derby.iapi.sql.execute.CursorResultSet");
            methodBuilder.cast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        }
    }

    public CostEstimate getFinalCostEstimate() {
        return this.getTrulyTheBestAccessPath().getCostEstimate();
    }

    private void generateMaxSpecialResultSet(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        ConglomerateDescriptor conglomerateDescriptor = this.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        CostEstimate costEstimate = this.getFinalCostEstimate();
        int n = this.referencedCols == null ? -1 : expressionClassBuilder.addItem(this.referencedCols);
        boolean bl = this.tableDescriptor.getLockGranularity() == 'T';
        expressionClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        expressionClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(this.getResultSetNumber());
        this.resultColumns.generateHolder(expressionClassBuilder, methodBuilder, this.referencedCols, null);
        methodBuilder.push(conglomerateDescriptor.getConglomerateNumber());
        methodBuilder.push(this.tableDescriptor.getName());
        methodBuilder.push(conglomerateDescriptor.getConglomerateName());
        methodBuilder.push(n);
        methodBuilder.push(this.getTrulyTheBestAccessPath().getLockMode());
        methodBuilder.push(bl);
        methodBuilder.push(this.getCompilerContext().getScanIsolationLevel());
        methodBuilder.push(costEstimate.singleScanRowCount());
        methodBuilder.push(costEstimate.getEstimatedCost());
        this.closeMethodArgument(expressionClassBuilder, methodBuilder);
        methodBuilder.callMethod((short)185, null, "getLastIndexKeyResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 13);
    }

    private void generateDistinctScan(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n;
        ConglomerateDescriptor conglomerateDescriptor = this.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        CostEstimate costEstimate = this.getFinalCostEstimate();
        int n2 = this.referencedCols == null ? -1 : expressionClassBuilder.addItem(this.referencedCols);
        boolean bl = this.tableDescriptor.getLockGranularity() == 'T';
        int[] nArray = new int[this.resultColumns.size()];
        if (this.referencedCols == null) {
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = n;
            }
        } else {
            n = 0;
            int n3 = this.referencedCols.anySetBit();
            while (n3 != -1) {
                nArray[n++] = n3;
                n3 = this.referencedCols.anySetBit(n3);
            }
        }
        Object[] objectArray = FormatableIntHolder.getFormatableIntHolders(nArray);
        FormatableArrayHolder formatableArrayHolder = new FormatableArrayHolder(objectArray);
        int n4 = expressionClassBuilder.addItem(formatableArrayHolder);
        long l = conglomerateDescriptor.getConglomerateNumber();
        StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo = this.getLanguageConnectionContext().getTransactionCompile().getStaticCompiledConglomInfo(l);
        expressionClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        methodBuilder.push(l);
        methodBuilder.push(expressionClassBuilder.addItem(staticCompiledOpenConglomInfo));
        expressionClassBuilder.pushThisAsActivation(methodBuilder);
        this.resultColumns.generateHolder(expressionClassBuilder, methodBuilder, this.referencedCols, null);
        methodBuilder.push(this.getResultSetNumber());
        methodBuilder.push(n4);
        methodBuilder.push(this.tableDescriptor.getName());
        methodBuilder.push(conglomerateDescriptor.getConglomerateName());
        methodBuilder.push(conglomerateDescriptor.isConstraint());
        methodBuilder.push(n2);
        methodBuilder.push(this.getTrulyTheBestAccessPath().getLockMode());
        methodBuilder.push(bl);
        methodBuilder.push(this.getCompilerContext().getScanIsolationLevel());
        methodBuilder.push(costEstimate.singleScanRowCount());
        methodBuilder.push(costEstimate.getEstimatedCost());
        this.closeMethodArgument(expressionClassBuilder, methodBuilder);
        methodBuilder.callMethod((short)185, null, "getDistinctScanResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 16);
    }

    private void generateRefActionDependentTableScan(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        expressionClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        int n = this.getScanArguments(expressionClassBuilder, methodBuilder);
        methodBuilder.push(this.raParentResultSetId);
        methodBuilder.push(this.fkIndexConglomId);
        methodBuilder.push(expressionClassBuilder.addItem(this.fkColArray));
        methodBuilder.push(expressionClassBuilder.addItem(this.getDataDictionary().getRowLocationTemplate(this.getLanguageConnectionContext(), this.tableDescriptor)));
        int n2 = n + 4;
        methodBuilder.callMethod((short)185, null, "getRaDependentTableScanResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", n2);
        if (this.updateOrDelete == 1 || this.updateOrDelete == 2) {
            methodBuilder.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
            methodBuilder.putField(expressionClassBuilder.getRowLocationScanResultSetName(), "org.apache.derby.iapi.sql.execute.CursorResultSet");
            methodBuilder.cast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        }
    }

    private int getScanArguments(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        Object object;
        Object object2;
        MethodBuilder methodBuilder2 = this.resultColumns.generateHolderMethod(expressionClassBuilder, this.referencedCols, null);
        int n = -1;
        if (this.referencedCols != null) {
            n = expressionClassBuilder.addItem(this.referencedCols);
        }
        int n2 = -1;
        if ((this.cursorTargetTable || this.getUpdateLocks) && ((ConglomerateDescriptor)(object2 = this.getTrulyTheBestAccessPath().getConglomerateDescriptor())).isIndex()) {
            object = ((ConglomerateDescriptor)object2).getIndexDescriptor().baseColumnPositions();
            boolean[] blArray = ((ConglomerateDescriptor)object2).getIndexDescriptor().isAscending();
            int[] nArray = new int[((Object)object).length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (int)(blArray[i] ? object[i] : -object[i]);
            }
            n2 = expressionClassBuilder.addItem(nArray);
        }
        object2 = this.getTrulyTheBestAccessPath();
        object = object2.getJoinStrategy();
        int n3 = object.getScanArgs(this.getLanguageConnectionContext().getTransactionCompile(), methodBuilder, this, this.storeRestrictionList, this.nonStoreRestrictionList, expressionClassBuilder, this.bulkFetch, methodBuilder2, n, n2, this.getTrulyTheBestAccessPath().getLockMode(), this.tableDescriptor.getLockGranularity() == 'T', this.getCompilerContext().getScanIsolationLevel(), object2.getOptimizer().getMaxMemoryPerTable());
        this.closeMethodArgument(expressionClassBuilder, methodBuilder);
        return n3;
    }

    private int mapAbsoluteToRelativeColumnPosition(int n) {
        if (this.referencedCols == null) {
            return n;
        }
        int n2 = 0;
        for (int i = 0; i < this.referencedCols.size() && i < n; ++i) {
            if (!this.referencedCols.get(i)) continue;
            ++n2;
        }
        return n2;
    }

    public String getExposedName() {
        if (this.correlationName != null) {
            return this.correlationName;
        }
        return this.tableName.getFullTableName();
    }

    public TableName getTableNameField() {
        return this.tableName;
    }

    public ResultColumnList getAllResultColumns(TableName tableName) throws StandardException {
        return this.getResultColumnsForList(tableName, this.resultColumns, this.tableName);
    }

    public ResultColumnList genResultColList() throws StandardException {
        ResultColumnList resultColumnList = null;
        ColumnDescriptor columnDescriptor = null;
        TableName tableName = this.correlationName == null ? this.tableName : this.makeTableName(null, this.correlationName);
        resultColumnList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ColumnDescriptorList columnDescriptorList = this.tableDescriptor.getColumnDescriptorList();
        int n = columnDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            columnDescriptor = columnDescriptorList.elementAt(i);
            columnDescriptor.setTableDescriptor(this.tableDescriptor);
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(94, columnDescriptor.getColumnName(), tableName, columnDescriptor.getType(), this.getContextManager());
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, columnDescriptor, valueNode, this.getContextManager());
            resultColumnList.addResultColumn(resultColumn);
        }
        return resultColumnList;
    }

    public ResultColumnList addColsToList(ResultColumnList resultColumnList, FormatableBitSet formatableBitSet) throws StandardException {
        Object var3_3 = null;
        ColumnDescriptor columnDescriptor = null;
        TableName tableName = this.correlationName == null ? this.tableName : this.makeTableName(null, this.correlationName);
        ResultColumnList resultColumnList2 = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ColumnDescriptorList columnDescriptorList = this.tableDescriptor.getColumnDescriptorList();
        int n = columnDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            columnDescriptor = columnDescriptorList.elementAt(i);
            int n2 = columnDescriptor.getPosition();
            if (!formatableBitSet.get(n2)) continue;
            ResultColumn resultColumn = resultColumnList.getResultColumn(n2);
            if (resultColumn == null) {
                ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(62, columnDescriptor.getColumnName(), tableName, this.getContextManager());
                resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, columnDescriptor, valueNode, this.getContextManager());
            }
            resultColumnList2.addResultColumn(resultColumn);
        }
        return resultColumnList2;
    }

    public TableName getTableName() throws StandardException {
        TableName tableName = super.getTableName();
        if (tableName != null && tableName.getSchemaName() == null && this.correlationName == null) {
            tableName.bind(this.getDataDictionary());
        }
        return tableName != null ? tableName : this.tableName;
    }

    public boolean markAsCursorTargetTable() {
        this.cursorTargetTable = true;
        return true;
    }

    protected boolean cursorTargetTable() {
        return this.cursorTargetTable;
    }

    void markUpdated(ResultColumnList resultColumnList) {
        this.resultColumns.markUpdated(resultColumnList);
    }

    public boolean referencesTarget(String string, boolean bl) throws StandardException {
        return bl && string.equals(this.getBaseTableName());
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.tableDescriptor.getSchemaDescriptor());
    }

    public boolean isOneRowResultSet() throws StandardException {
        if (this.existsBaseTable) {
            return true;
        }
        AccessPath accessPath = this.getTrulyTheBestAccessPath();
        JoinStrategy joinStrategy = accessPath.getJoinStrategy();
        if (joinStrategy.isHashJoin()) {
            PredicateList predicateList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
            if (this.storeRestrictionList != null) {
                predicateList.nondestructiveAppend(this.storeRestrictionList);
            }
            if (this.nonStoreRestrictionList != null) {
                predicateList.nondestructiveAppend(this.nonStoreRestrictionList);
            }
            return this.isOneRowResultSet(predicateList);
        }
        return this.isOneRowResultSet(this.getTrulyTheBestAccessPath().getConglomerateDescriptor(), this.restrictionList);
    }

    public boolean isNotExists() {
        return this.isNotExists;
    }

    public boolean isOneRowResultSet(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.tableDescriptor.getConglomerateDescriptors();
        for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
            if (!this.isOneRowResultSet(conglomerateDescriptorArray[i], optimizablePredicateList)) continue;
            return true;
        }
        return false;
    }

    protected boolean supersetOfUniqueIndex(boolean[] blArray) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.tableDescriptor.getConglomerateDescriptors();
        for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
            int n;
            IndexRowGenerator indexRowGenerator;
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i];
            if (!conglomerateDescriptor.isIndex() || !(indexRowGenerator = conglomerateDescriptor.getIndexDescriptor()).isUnique()) continue;
            int[] nArray = indexRowGenerator.baseColumnPositions();
            for (n = 0; n < nArray.length && blArray[nArray[n]]; ++n) {
            }
            if (n != nArray.length) continue;
            return true;
        }
        return false;
    }

    protected boolean supersetOfUniqueIndex(JBitSet[] jBitSetArray) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.tableDescriptor.getConglomerateDescriptors();
        for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
            IndexRowGenerator indexRowGenerator;
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i];
            if (!conglomerateDescriptor.isIndex() || !(indexRowGenerator = conglomerateDescriptor.getIndexDescriptor()).isUnique()) continue;
            int[] nArray = indexRowGenerator.baseColumnPositions();
            int n = jBitSetArray[0].size();
            JBitSet jBitSet = new JBitSet(n);
            JBitSet jBitSet2 = new JBitSet(n);
            for (int j = 0; j < nArray.length; ++j) {
                jBitSet.set(nArray[j]);
            }
            for (int j = 0; j < jBitSetArray.length; ++j) {
                jBitSet2.setTo(jBitSetArray[j]);
                jBitSet2.and(jBitSet);
                if (!jBitSet.equals(jBitSet2)) continue;
                jBitSetArray[j].set(0);
                return true;
            }
        }
        return false;
    }

    public int updateTargetLockMode() {
        if (this.getTrulyTheBestAccessPath().getConglomerateDescriptor().isIndex()) {
            return 6;
        }
        int n = this.getLanguageConnectionContext().getCurrentIsolationLevel();
        if (n != 4 && this.tableDescriptor.getLockGranularity() != 'T') {
            int n2 = this.getTrulyTheBestAccessPath().getLockMode();
            n2 = n2 != 6 ? (n2 & 0xFF) << 16 : 0;
            return n2 += 6;
        }
        return this.getTrulyTheBestAccessPath().getLockMode();
    }

    boolean isOrderedOn(ColumnReference[] columnReferenceArray, boolean bl, Vector vector) throws StandardException {
        for (int i = 0; i < columnReferenceArray.length; ++i) {
            if (columnReferenceArray[i].getTableNumber() == this.tableNumber) continue;
            return false;
        }
        ConglomerateDescriptor conglomerateDescriptor = this.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        if (!conglomerateDescriptor.isIndex()) {
            return false;
        }
        boolean bl2 = bl ? this.isOrdered(columnReferenceArray, conglomerateDescriptor) : this.isStrictlyOrdered(columnReferenceArray, conglomerateDescriptor);
        if (vector != null) {
            vector.addElement(this);
        }
        return bl2;
    }

    void disableBulkFetch() {
        this.bulkFetchTurnedOff = true;
        this.bulkFetch = -1;
    }

    void doSpecialMaxScan() {
        this.specialMaxScan = true;
    }

    boolean isPossibleDistinctScan() {
        return this.restrictionList == null || this.restrictionList.size() == 0;
    }

    void markForDistinctScan() {
        this.distinctScan = true;
    }

    void markOrderingDependent() {
    }

    private boolean isOrdered(ColumnReference[] columnReferenceArray, ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        int n;
        int n2;
        int n3;
        boolean[] blArray = new boolean[columnReferenceArray.length];
        int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n2 = 0;
            for (n = 0; n < columnReferenceArray.length; ++n) {
                if (columnReferenceArray[n].getColumnNumber() != nArray[n3]) continue;
                blArray[n] = true;
                n2 = 1;
                break;
            }
            if (n2 == 0 && !this.storeRestrictionList.hasOptimizableEqualityPredicate(this, nArray[n3], true)) break;
        }
        n2 = 0;
        for (n = 0; n < blArray.length; ++n) {
            if (!blArray[n]) continue;
            ++n2;
        }
        if (n2 == blArray.length) {
            return true;
        }
        if (n3 == nArray.length) {
            return conglomerateDescriptor.getIndexDescriptor().isUnique();
        }
        return false;
    }

    private boolean isStrictlyOrdered(ColumnReference[] columnReferenceArray, ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        int n = 0;
        int[] nArray = conglomerateDescriptor.getIndexDescriptor().baseColumnPositions();
        block0: for (int i = 0; i < columnReferenceArray.length; ++i) {
            if (n == nArray.length) {
                if (conglomerateDescriptor.getIndexDescriptor().isUnique()) break;
                return false;
            }
            if (columnReferenceArray[i].getColumnNumber() == nArray[n]) {
                ++n;
                continue;
            }
            while (columnReferenceArray[i].getColumnNumber() != nArray[n]) {
                if (!this.storeRestrictionList.hasOptimizableEqualityPredicate(this, nArray[n], true)) {
                    return false;
                }
                if (++n != nArray.length) continue;
                if (conglomerateDescriptor.getIndexDescriptor().isUnique()) continue block0;
                return false;
            }
        }
        return true;
    }

    private boolean isOneRowResultSet(ConglomerateDescriptor conglomerateDescriptor, OptimizablePredicateList optimizablePredicateList) throws StandardException {
        if (optimizablePredicateList == null) {
            return false;
        }
        PredicateList predicateList = (PredicateList)optimizablePredicateList;
        if (!conglomerateDescriptor.isIndex()) {
            return false;
        }
        IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
        if (!indexRowGenerator.isUnique()) {
            return false;
        }
        int[] nArray = indexRowGenerator.baseColumnPositions();
        DataDictionary dataDictionary = this.getDataDictionary();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (predicateList.hasOptimizableEqualityPredicate(this, n, true)) continue;
            return false;
        }
        return true;
    }

    private int getDefaultBulkFetch() throws StandardException {
        String string = PropertyUtil.getServiceProperty(this.getLanguageConnectionContext().getTransactionCompile(), "derby.language.bulkFetchDefault", "16");
        int n = this.getIntProperty(string, "derby.language.bulkFetchDefault");
        if (n <= 0) {
            throw StandardException.newException("42Y64", String.valueOf(n));
        }
        return n <= 1 ? -1 : n;
    }

    private String getUserSpecifiedIndexName() {
        String string = null;
        if (this.tableProperties != null) {
            string = this.tableProperties.getProperty("index");
        }
        return string;
    }

    private StoreCostController getStoreCostController(ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        return this.getCompilerContext().getStoreCostController(conglomerateDescriptor.getConglomerateNumber(), this.getLanguageConnectionContext());
    }

    private StoreCostController getBaseCostController() throws StandardException {
        return this.getStoreCostController(this.baseConglomerateDescriptor);
    }

    private long baseRowCount() throws StandardException {
        if (!this.gotRowCount) {
            StoreCostController storeCostController = this.getBaseCostController();
            this.rowCount = storeCostController.getEstimatedRowCount();
            this.gotRowCount = true;
        }
        return this.rowCount;
    }

    private DataValueDescriptor[] getRowTemplate(ConglomerateDescriptor conglomerateDescriptor, StoreCostController storeCostController) throws StandardException {
        if (!conglomerateDescriptor.isIndex()) {
            return this.templateColumns.buildEmptyRow().getRowArray();
        }
        ExecRow execRow = this.templateColumns.buildEmptyIndexRow(this.tableDescriptor, conglomerateDescriptor, storeCostController, this.getDataDictionary());
        return execRow.getRowArray();
    }

    private ConglomerateDescriptor getFirstConglom() throws StandardException {
        this.getConglomDescs();
        return this.conglomDescs[0];
    }

    private ConglomerateDescriptor getNextConglom(ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        int n;
        for (n = 0; n < this.conglomDescs.length && conglomerateDescriptor != this.conglomDescs[n]; ++n) {
        }
        if (n < this.conglomDescs.length - 1) {
            return this.conglomDescs[n + 1];
        }
        return null;
    }

    private void getConglomDescs() throws StandardException {
        if (this.conglomDescs == null) {
            this.conglomDescs = this.tableDescriptor.getConglomerateDescriptors();
        }
    }

    public void setRefActionInfo(long l, int[] nArray, String string, boolean bl) {
        this.fkIndexConglomId = l;
        this.fkColArray = nArray;
        this.raParentResultSetId = string;
        this.raDependentScan = bl;
    }
}

