# Generated by default/object.tt
package Paws::ApiGatewayV2::TlsConfigInput;
  use Moose;
  has ServerNameToVerify => (is => 'ro', isa => 'Str', request_name => 'serverNameToVerify', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApiGatewayV2::TlsConfigInput

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApiGatewayV2::TlsConfigInput object:

  $service_obj->Method(Att1 => { ServerNameToVerify => $value, ..., ServerNameToVerify => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApiGatewayV2::TlsConfigInput object:

  $result = $service_obj->Method(...);
  $result->Att1->ServerNameToVerify

=head1 DESCRIPTION

The TLS configuration for a private integration. If you specify a TLS
configuration, private integration traffic uses the HTTPS protocol.
Supported only for HTTP APIs.

=head1 ATTRIBUTES


=head2 ServerNameToVerify => Str

If you specify a server name, API Gateway uses it to verify the
hostname on the integration's certificate. The server name is also
included in the TLS handshake to support Server Name Indication (SNI)
or virtual hosting.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApiGatewayV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

