package Acme::ChuckNorris;

use strict;
use warnings;

$Acme::ChuckNorris::VERSION = '0.3';

sub import {
    no strict 'refs';    ## no critic
    *{ caller() . '::round_house_kick_to_the_perl' } = \&round_house_kick_to_the_perl;
    *{ caller() . '::round_house_kick_to_the_text' } = \&round_house_kick_to_the_text;
}

my %mostly_defaults = (
    'Regex'  => 1,
    'Binary' => 0,
);

my %defaults_overridable = (
    'Gap'            => 1,
    'InformHandler'  => sub { },
    'TrailingSpaces' => 1,
);

sub round_house_kick_to_the_text {
    require Acme::EyeDrops;
    return Acme::EyeDrops::sightly(
        {
            %defaults_overridable,    # allow caller to override these in @_
            @_[ 1 .. $#_ ],
            ( ref( $_[0] ) eq 'SCALAR' ? ( 'SourceString' => ${ $_[0] } ) : ref( $_[0] ) ? ( 'SourceHandle' => $_[0] ) : ( 'SourceFile' => $_[0] ) ),
            'ShapeString' => join( '', <DATA> ),
            'Shape'       => undef,
            %mostly_defaults,         # not overridable
            'Print' => 1,
        }
    );
}

sub round_house_kick_to_the_perl {
    require Acme::EyeDrops;
    return Acme::EyeDrops::sightly(
        {

            # allow caller to override the below options in @_
            %defaults_overridable,
            %mostly_defaults,    # overridable
            'TrapEvalDie' => 1,
            'TrapWarn'    => 1,

            # allow caller to override the above options in @_
            @_[ 1 .. $#_ ],
            ( ref( $_[0] ) eq 'SCALAR' ? ( 'SourceString' => ${ $_[0] } ) : ref( $_[0] ) ? ( 'SourceHandle' => $_[0] ) : ( 'SourceFile' => $_[0] ) ),
            'ShapeString' => join( '', <DATA> ),
            'Shape'       => undef,
        }
    );
}

'When Chuck Norris is SCUBA diving and surfaces too fast the ocean gets the bends.';    # return true, so very very true

__DATA__
                                                                                                                                                
                                                                  ################                                                              
                                                                ######################                                                          
                                                        ################################                                                        
                                                    ####################################  ##                                                    
                                                  ############################################                                                  
                                                ##########################################  ##                                                  
                                              ##################################################                                                
                                              ##################################################                                                
                                            ######################################################                                              
                                            ######################################################                                              
                                            ######################################################                                              
                                            ########################################################                                            
                                            ########################################################                                            
                                            ########################################################                                            
                                          ################################  ##########################                                          
                                            ##########################            ####################                                          
                                            ######################  ##            ####################                                          
                                            ######################                  ####################                                        
                                            ######################                  ####################                                        
                                            ############                              ##################                                        
                                              ################                        ##################                                        
                                              ##########                              ##################                                        
                                                ############  ##############            ########  ######                                        
        ####                                    ############  ##############              ##############                                        
        ######                                  ############    ############          ####        ####                                          
          ######                                ############    ####                  ####      ######                                          
          ######                                ############                          ####      ######                                          
            ######                              ####    ####                          ####    ######                                            
            ########                            ####    ####                          ####    ######                                            
              ##########                          ##    ##                          ######  ######                                              
              ############                        ##  ####          ##                ####  ######                                              
                ##########                        ########        ##                  ##                                                        
              ##############    ########            ######  ######                ######      ##                                                
                ##################      ##          ############                ########      ####                                              
                  ######  ##      ####  ##          ########################  ##########        ####                                            
                  ############        ##################################################      ######                                            
                  ##############    ##############################    ################        ########                                          
                  ##############    ############################        ############        ##########                                          
                  ################    ##############################################        ##########                                          
                    ################    ############################################      ##############                                        
                    ################    ############################################    ##################                                      
                      ############  ######  ########################################  ########################                                  
                      ####################  ####################################################################                                
                        ##################  ######################################################################                              
                        ####################  ########################################################################                          
                          ##############  ##      ######################################################################                        
                          ####################    ######################################################################                        
                          ################  ##      ######################################################################                      
                          ##################  ##      ####################################################################                      
                        ##########################    ######################################################################                    
                        ######################  ##      ########################################################################                
                        ##################    ##  ##      ######################################################################                
                        ##################  ##  ######    ########################################################################              
                        ##############################      ########################################################################            
                        ########################  ##  ##    ########################################################################            
                      ############################    ######  ########################################################################          
                    ######################  ######  ##########  ##################################################          ##########          
  ##                ####################      ######  ##########################################################              ########          
######            ######################      ##################  ##########################################                    ######          
##    ##          ######################        ##################  ######################################                      ######          
##    ##        ################  ########    ####################  ####################################                        ######          
  ##  ##      ####################    ####    ##  ##############      ################################                          ######          
  ##  ####    ##############  ######            ##  ######      ##      ############################                              ####          
  ##      ##########################            ########  ##  ##  ##    ##########################                                ####          
  ##      ############  ############              ##  ########    ####    ######################                                  ##            
  ########        ####  ########  ##                ########        ##    ######################                                ####            
  ####                  ########                    ##########    ##  ##  ######################                                ####            
  ####      ####      ##########                    ############################################                                ##              
######    ####        ########                      ##############  ##  ##  ######    ##########                                ##              
############            ######                      ################  ############      ######                                  ##              
##########              ######                      ########################            ####                                    ##              
##########              ########                    ##################  ##          ##  ####                                  ##                
##############          ########                    ####################                ##                                    ##                
############      ####  ##########                  ##################                ####                                    ##                
############      ##    ##########                    ##################            ######                                    ##                
############    ####    ##    ######                    ##########                                                            ##                
  ################                ####                                                                                      ##                  
    ##############    ##            ####                                                                                    ##                  
                ######                                                                                                                          
