package App::BPOMUtils::Table::FoodTypeRBAImporter;

use 5.010001;
use strict 'subs', 'vars';
use utf8;
use warnings;
use Log::ger;

use Exporter 'import';
use Perinci::Sub::Gen::AccessTable qw(gen_read_table_func);

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2025-05-22'; # DATE
our $DIST = 'App-BPOMUtils-Table-FoodType'; # DIST
our $VERSION = '0.021'; # VERSION

our @EXPORT_OK = qw(
                       bpom_list_food_types_rba_importer
               );

our %SPEC;

# BEGIN FRAGMENT id=meta-idn_bpom_jenis_pangan_rba_importir varname=meta_idn_bpom_jenis_pangan_rba_importir
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_jenis_pangan_rba_importir/meta.yaml
# src-revision: e2063114ea985d6735726a9c42fb5fb28050df7e (Tue Feb 14 11:36:11 2023 +0700)
# generate-date: Thu May 22 08:21:19 2025 UTC
# generated-by: update-fragments-in-perl-module
our $meta_idn_bpom_jenis_pangan_rba_importir = {
  "fields" => {
    category_code => {
      "filterable_regex" => "Yes",
      "pos" => 5,
      "schema" => ["str*"],
      "sortable" => "Yes",
      "summary" => "Food category name",
      "summary.alt.lang.id" => "Nama kategori pangan",
      "unique" => "No",
    },
    dosage_form_code => {
      "filterable_regex" => "Yes",
      "pos" => 2,
      "schema" => ["str*", { match => "^[0-9]+\$" }],
      "sortable" => "Yes",
      "summary" => "Dosage form code",
      "summary.alt.lang.id" => "Kode bentuk sediaan",
      "unique" => "No",
    },
    dosage_form_name => {
      "filterable_regex" => "Yes",
      "pos" => 3,
      "schema" => ["str*"],
      "sortable" => "Yes",
      "summary" => "Dosage form name",
      "summary.alt.lang.id" => "Nama bentuk sediaan",
      "unique" => "No",
    },
    id => {
      filterable_regex => "Yes",
      pos => 0,
      schema => ["posint*"],
      sortable => "Yes",
      summary => "Numeric ID",
      unique => "Yes",
    },
    kbli_code => {
      "filterable_regex" => "Yes",
      "pos" => 1,
      "schema" => ["str*", { match => "^[0-9]+\$" }],
      "sortable" => "Yes",
      "summary" => "KBLI code",
      "summary.alt.lang.id" => "Kode KBLI",
      "unique" => "No",
    },
    mod_price => {
      "filterable_regex" => "Yes",
      "pos" => 8,
      "schema" => ["ufloat*"],
      "sortable" => "Yes",
      "summary" => "Price for modification of product",
      "summary.alt.lang.id" => "Harga perubahan product",
      "unique" => "No",
    },
    new_reg_price => {
      "filterable_regex" => "Yes",
      "pos" => 6,
      "schema" => ["ufloat*"],
      "sortable" => "Yes",
      "summary" => "Price for new registration of new product",
      "summary.alt.lang.id" => "Harga daftar baru produ",
      "unique" => "No",
    },
    rereg_price => {
      "filterable_regex" => "Yes",
      "pos" => 7,
      "schema" => ["ufloat*"],
      "sortable" => "Yes",
      "summary" => "Price for re-registration of product",
      "summary.alt.lang.id" => "Harga daftar ulang produk",
      "unique" => "No",
    },
    status => {
      "filterable_regex" => "Yes",
      "pos" => 9,
      "schema" => ["str*"],
      "sortable" => "Yes",
      "summary" => "Status",
      "summary.alt.lang.id" => "Status",
      "unique" => "No",
    },
  },
  "pk" => "id",
  "summary" => "Food types in BPOM processed food division (RBA version, for importers)",
  "summary.alt.lang.id_ID" => "Jenis pangan di BPOM pangan olahan (versi RBA, importir)",
};
# END FRAGMENT id=meta-idn_bpom_jenis_pangan_rba_importir

# BEGIN FRAGMENT id=data-idn_bpom_jenis_pangan_rba_importir varname=data_idn_bpom_jenis_pangan_rba_importir
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_jenis_pangan_rba_importir/data.csv
# src-revision: e2063114ea985d6735726a9c42fb5fb28050df7e (Tue Feb 14 11:36:11 2023 +0700)
# generate-date: Thu May 22 08:21:19 2025 UTC
# generated-by: update-fragments-in-perl-module
our $data_idn_bpom_jenis_pangan_rba_importir = [
  [
    1,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010101000001",
    "Susu Lemak Penuh (Full Cream) Murni",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    2,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010101000002",
    "Susu Skim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    3,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010101000003",
    "Susu Skim Sebagian",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    4,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000001",
    "Susu Lemak Penuh Rekombinasi (Recombined Full Cream Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    5,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000001",
    "Susu Lemak Penuh Rekombinasi (Recombined Full Cream Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    6,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000002",
    "Susu Lemak Penuh Rekonstitusi (Reconstituted Full Cream Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    7,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000002",
    "Susu Lemak Penuh Rekonstitusi (Reconstituted Full Cream Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    8,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000003",
    "Susu Skim Rekonstitusi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    9,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000004",
    "Susu Skim Sebagian Rekonstitusi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    10,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000005",
    "Susu Skim Sebagian Rekombinasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    11,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000006",
    "Susu Lemak Nabati/Susu Minyak Nabati (Filled Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    12,
    46326,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    13,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    14,
    46326,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    15,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    16,
    46326,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    17,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    18,
    46326,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    19,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    20,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    21,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    22,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    23,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    24,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    25,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    26,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    27,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    28,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    29,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    30,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    31,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    32,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    33,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    34,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    35,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    36,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    37,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    38,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    39,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    40,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    41,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    42,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    43,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    44,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    45,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    46,
    46326,
    "0113",
    "Lassi",
    "010102000010",
    "Lassi (Plain)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    47,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000011",
    "Susu Lemak Penuh (Full Cream) dengan Penambahan Bahan Pangan Lain ",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    48,
    46326,
    "0102",
    "Buttermilk (plain) dengan proses pasteurisasi",
    "010103000001",
    "Buttermilk Cair",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    49,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010104000001",
    "Susu (Rasa) Lemak Penuh (Full Cream Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    50,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010104000002",
    "Susu Berperisa/Susu Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    51,
    46326,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    52,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    53,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    54,
    46326,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    55,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    56,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    57,
    46326,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    58,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    59,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    60,
    46326,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    61,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    62,
    46326,
    "0129",
    "Minuman susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    63,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    64,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    65,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    66,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    67,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    68,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    69,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    70,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    71,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    72,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    73,
    46326,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    74,
    46326,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    75,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    76,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    77,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    78,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    79,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    80,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    81,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    82,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    83,
    46326,
    "0113",
    "Lassi",
    "010104000006",
    "Lassi (Rasa/Berperisa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    84,
    46326,
    "0104",
    "Cairan whey dan produknya, kecuali keju whey",
    "010104000007",
    "Minuman Berbasis Whey",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    85,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    86,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    87,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    88,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    89,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    90,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    91,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    92,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    93,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    94,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    95,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    96,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    97,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    98,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    99,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    100,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    101,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    102,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    103,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000010",
    "Susu Bubuk Skim Sebagian (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    104,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000010",
    "Susu Bubuk Skim Sebagian (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    105,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000010",
    "Susu Bubuk Skim Sebagian (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    106,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    107,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    108,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    109,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    110,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    111,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    112,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    113,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    114,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    115,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000012",
    "Susu Bubuk Skim Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    116,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000012",
    "Susu Bubuk Skim Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    117,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000012",
    "Susu Bubuk Skim Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    118,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000013",
    "Susu Bubuk Skim Sebagian Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    119,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000013",
    "Susu Bubuk Skim Sebagian Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    120,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000013",
    "Susu Bubuk Skim Sebagian Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    121,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000013",
    "Susu Bubuk Skim Sebagian Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    122,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000013",
    "Susu Bubuk Skim Sebagian Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    123,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000013",
    "Susu Bubuk Skim Sebagian Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    124,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    125,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    126,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    127,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    128,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    129,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    130,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    131,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    132,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    133,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    134,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    135,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    136,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    137,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    138,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    139,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    140,
    46326,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    141,
    46326,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    142,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010104000016",
    "Susu Bubuk Lemak Nabati/Susu Bubuk Minyak Nabati Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    143,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000017",
    "Minuman Kefir Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    144,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000018",
    "Minuman Kumys Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    145,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000019",
    "Minuman Yogurt Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    146,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000020",
    "Lassi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    147,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010104000028",
    "Susu Skim Sebagian Rekonstitusi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    148,
    46326,
    "0127",
    "Susu yang digumpalkan dengan enzim renin",
    "010200000001",
    "Dadih",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    149,
    46326,
    "0125",
    "Susu diasamkan",
    "010201010001",
    "Susu Diasamkan (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    150,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010002",
    "Susu Asidofilus (Acidophilus Milk) (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    151,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010003",
    "Yogurt (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    152,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010004",
    "Yogurt Kultur Lain (Alternate Culture Yogurt) (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    153,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010005",
    "Kefir (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    154,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010006",
    "Kumys (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    155,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010007",
    "Susu Fermentasi atau Susu Berkultur (Cultured Milk) (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    156,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010008",
    "Minuman Yogurt (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    157,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010009",
    "Minuman Kefir (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    158,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010010",
    "Minuman Kumys (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    159,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010011",
    "Minuman Susu Fermentasi (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    160,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020001",
    "Susu Diasamkan (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    161,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020002",
    "Susu Asidofilus (Acidophilus Milk) (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    162,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020003",
    "Yogurt (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    163,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020004",
    "Yogurt Kultur Lain (Alternate Culture Yogurt) (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    164,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020005",
    "Kefir (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    165,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020006",
    "Kumys (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    166,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020007",
    "Susu Fermentasi atau Susu Berkultur (Cultured Milk) (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    167,
    46326,
    "0127",
    "Susu yang digumpalkan dengan enzim renin",
    "010202000001",
    "Susu yang digumpalkan dengan rennet (Plain)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    168,
    46326,
    "0126",
    "Susu evaporasi",
    "010301000001",
    "Susu Evaporasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    169,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010301000002",
    "Susu Skim Evaporasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    170,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010301000003",
    "Susu Skim Sebagian Evaporasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    171,
    46326,
    "0124",
    "Susu dan krim kental manis",
    "010301000004",
    "Susu Kental Manis",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    172,
    46326,
    "0124",
    "Susu dan krim kental manis",
    "010301000005",
    "Susu Skim Kental Manis",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    173,
    46326,
    "0124",
    "Susu dan krim kental manis",
    "010301000006",
    "Krim Kental Manis",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    174,
    46326,
    "0109",
    "Khoa",
    "010301000007",
    "Khoa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    175,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010302000001",
    "Susu Lemak Nabati Evaporasi/ Susu Minyak Nabati Evaporasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    176,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010302000002",
    "Susu Kental Manis Lemak Nabati/ Susu Kental Manis Minyak Nabati",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    177,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010302000003",
    "Krimer Kental Manis",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    178,
    46326,
    "0112",
    "Krimer nabati",
    "010302000004",
    "Krimer Minuman ",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    179,
    46326,
    "0112",
    "Krimer nabati",
    "010302000004",
    "Krimer Minuman ",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    180,
    46326,
    "0112",
    "Krimer nabati",
    "010302000005",
    "Krimer Minuman Penghasil Buih",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    181,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010400000001",
    "Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    182,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010401000001",
    "Krim Pasteurisasi (Plain)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    183,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010401000002",
    "Half and Half",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    184,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010402000001",
    "Krim sterilisasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    185,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010402000002",
    "Whipping cream",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    186,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010402000003",
    "Whipped Cream",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    187,
    46326,
    "0111",
    "Krim yang digumpalkan",
    "010403000001",
    "Krim yang Digumpalkan Dengan Enzim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    188,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010403000002",
    "Krim Asam",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    189,
    46326,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010403000003",
    "Krim yang Diasamkan",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    190,
    46326,
    "0110",
    "Krim nabati",
    "010404000001",
    "Krim Nabati (Khusus Registrasi Variasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    191,
    46326,
    "0110",
    "Krim Nabati",
    "010404000002",
    "Pengganti Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    192,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010501000001",
    "Susu Bubuk Lemak Penuh (Full Cream)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    193,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010501000002",
    "Susu Bubuk Lemak Penuh (Full Cream) Instan",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    194,
    46327,
    "0122",
    "Susu dan krim bubuk",
    "010501000003",
    "Susu Bubuk Skim Sebagian",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    195,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010501000004",
    "Susu Bubuk Skim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    196,
    46326,
    "0122",
    "Susu dan krim bubuk",
    "010501000004",
    "Susu Bubuk Skim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    197,
    46329,
    "0122",
    "Susu dan krim bubuk",
    "010501000005",
    "Campuran Susu dan Krim Bubuk (Plain)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    198,
    46330,
    "0122",
    "Susu dan krim bubuk",
    "010501000006",
    "Krim Bubuk",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    199,
    46326,
    "0103",
    "Buttermilk bubuk (plain)",
    "010501000007",
    "Bubuk Buttermilk",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    200,
    46331,
    "0122",
    "Susu dan krim bubuk",
    "010501000008",
    "Minuman Mengandung Susu Bubuk (Plain)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    201,
    46332,
    "0122",
    "Susu dan krim bubuk",
    "010502000001",
    "Susu Bubuk Lemak Nabati/Susu Bubuk Minyak Nabati",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    202,
    46326,
    "0107",
    "Keju olahan",
    "010600000001",
    "Keju",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    203,
    46326,
    "0107",
    "Keju olahan",
    "010600000002",
    "Analog Keju",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    204,
    46326,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000001",
    "Keju Cottage (Cottage Cheese)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    205,
    46326,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000002",
    "Keju Cottage yang Ditambah Krim (Creamed Cottage Cheese)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    206,
    46326,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000003",
    "Keju Krim (Cream Cheese)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    207,
    46326,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000004",
    "Keju Mozzarella",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    208,
    46326,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000005",
    "Keju Bocconcini",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    209,
    46326,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000006",
    "Keju Tanpa Pemeraman (Keju Mentah)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    210,
    46326,
    "0107",
    "Keju olahan",
    "010602010001",
    "Keju Cheddar",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    211,
    46326,
    "0107",
    "Keju olahan",
    "010602010002",
    "Keju Edam",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    212,
    46326,
    "0107",
    "Keju olahan",
    "010602010003",
    "Keju Camembert",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    213,
    46326,
    "0107",
    "Keju olahan",
    "010602010004",
    "Keju Bath",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    214,
    46326,
    "0107",
    "Keju olahan",
    "010602010005",
    "Keju Bondard",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    215,
    46326,
    "0107",
    "Keju olahan",
    "010602010006",
    "Keju Bougon",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    216,
    46326,
    "0107",
    "Keju olahan",
    "010602010007",
    "Keju Bouquet des moines",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    217,
    46326,
    "0107",
    "Keju olahan",
    "010602010008",
    "Keju Biru (Blue Cheese)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    218,
    46326,
    "0107",
    "Keju olahan",
    "010602010009",
    "Keju Bata (Brick Cheese)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    219,
    46326,
    "0107",
    "Keju olahan",
    "010602010010",
    "Keju Gouda",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    220,
    46326,
    "0107",
    "Keju olahan",
    "010602010011",
    "Keju Havarti",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    221,
    46326,
    "0107",
    "Keju olahan",
    "010602010012",
    "Keju Brie",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    222,
    46326,
    "0107",
    "Keju olahan",
    "010602010013",
    "Keju Parmesan",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    223,
    46326,
    "0107",
    "Keju olahan",
    "010602010014",
    "Keju Swiss",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    224,
    46326,
    "0107",
    "Keju olahan",
    "010602010015",
    "Keju Peram Lainnya",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    225,
    46326,
    "0134",
    "Keju Peram",
    "010602010016",
    "Keju Emmental/Keju Swiss",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    226,
    46326,
    "0107",
    "Keju olahan",
    "010602020001",
    "Kulit Keju Peram",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    227,
    46326,
    "0107",
    "Keju olahan",
    "010602030001",
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    228,
    46326,
    "0107",
    "Keju olahan",
    "010603000001",
    "Keju Whey",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    229,
    46326,
    "0107",
    "Keju olahan",
    "010604000001",
    "Keju Olahan",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    230,
    46326,
    "0107",
    "Keju olahan",
    "010604010001",
    "Keju Olahan Plain",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    231,
    46326,
    "0107",
    "Keju olahan",
    "010604020001",
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    232,
    46326,
    "0107",
    "Keju olahan",
    "010605000001",
    "Analog Keju (Keju lemak nabati)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    233,
    46326,
    "0107",
    "Keju olahan",
    "010606000001",
    "Keju Protein Whey",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    234,
    46326,
    "0105",
    "Es krim",
    "010700000001",
    "Es Krim Susu (Dairy Ice Cream)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    235,
    46326,
    "0105",
    "Es krim",
    "010700000002",
    "Es Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    236,
    46326,
    "0106",
    "Es susu / es mengandung susu",
    "010700000003",
    "Es Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    237,
    46326,
    "0121",
    "Premiks bentuk cair",
    "010700000004",
    "Premiks Es Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    238,
    46326,
    "0619",
    "Premiks bentuk bubuk (termasuk pada kategori pangan 1, 5, 6, 7, 10, dan 14)",
    "010700000004",
    "Premiks Es Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    239,
    46326,
    "0121",
    "Premiks bentuk cair",
    "010700000004",
    "Premiks Es Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    240,
    46326,
    "0619",
    "Premiks bentuk bubuk (termasuk pada kategori pangan 1, 5, 6, 7, 10, dan 14)",
    "010700000004",
    "Premiks Es Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    241,
    46326,
    "0121",
    "Premiks bentuk cair",
    "010700000005",
    "Premiks Es Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    242,
    46326,
    "0619",
    "Premiks bentuk bubuk (termasuk pada kategori pangan 1, 5, 6, 7, 10, dan 14)",
    "010700000005",
    "Premiks Es Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    243,
    46326,
    "0121",
    "Premiks bentuk cair",
    "010700000005",
    "Premiks Es Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    244,
    46326,
    "0619",
    "Premiks bentuk bubuk (termasuk pada kategori pangan 1, 5, 6, 7, 10, dan 14)",
    "010700000005",
    "Premiks Es Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    245,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010700000006",
    "Yogurt Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    246,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010700000007",
    "Yogurt Kultur Lain (Alternate Culture Yogurt) Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    247,
    46326,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000008",
    "Kefir",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    248,
    46326,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010700000009",
    "Susu Fermentasi atau Susu Berkultur Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    249,
    46326,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000010",
    "Junket",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    250,
    46326,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000011",
    "Dulce de leche",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    251,
    46326,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000012",
    "Puding Butterscotch/Puding Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    252,
    46326,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000013",
    "Bubuk Puding Butterscotch/Puding Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    253,
    46326,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000014",
    "Kembang Gula / Permen Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    254,
    46326,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000015",
    "Makanan pencuci mulut berbasis susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    255,
    46326,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010700000016",
    "Kefir Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    256,
    46326,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000017",
    "Bola-bola Keju dalam Sirup Gula (Rasgulla/ Rasagola/ Roshogolla/ Rasogolla)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    257,
    46326,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000018",
    "Bola-Bola Keju Goreng dalam Sirup Gula (Gulab jamun/ gulaab jamun/ gulab ki janu)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    258,
    46326,
    "0104",
    "Cairan whey dan produknya, kecuali keju whey",
    "010801000001",
    "Whey",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    259,
    46326,
    "0104",
    "Cairan whey dan produknya, kecuali keju whey",
    "010801000002",
    "Whey Asam",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    260,
    46326,
    "0101",
    "Bubuk whey dan produknya, kecuali keju whey",
    "010802000001",
    "Bubuk Whey",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    261,
    46326,
    "0101",
    "Bubuk whey dan produknya, kecuali keju whey",
    "010802000002",
    "Bubuk Whey yang Telah Didemineralisasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    262,
    46326,
    "0101",
    "Bubuk whey dan produknya, kecuali keju whey",
    "010802000003",
    "Bubuk Whey Permeate",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    263,
    46326,
    "0209",
    "Pangan kategori 2 risiko sedang lainnya",
    "020101000001",
    "Lemak Susu Anhidrat (AMF), Minyak Mentega (butter oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    264,
    46326,
    "0204",
    "Ghee",
    "020101000002",
    "Ghee",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    265,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000001",
    "Lemak dan Minyak Nabati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    266,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000001",
    "Lemak dan Minyak Nabati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    267,
    46315,
    "0210",
    "Virgin oil",
    "020102000002",
    "Virgin Oil ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    268,
    46315,
    "0210",
    "Virgin oil",
    "020102000002",
    "Virgin Oil ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    269,
    46315,
    "0210",
    "Virgin oil",
    "020102000002",
    "Virgin Oil ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    270,
    46315,
    "0210",
    "Virgin oil",
    "020102000002",
    "Virgin Oil ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    271,
    46315,
    "0210",
    "Virgin oil",
    "020102000003",
    "Extra Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    272,
    46315,
    "0210",
    "Virgin oil",
    "020102000003",
    "Extra Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    273,
    46315,
    "0210",
    "Virgin oil",
    "020102000004",
    "Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    274,
    46315,
    "0210",
    "Virgin oil",
    "020102000004",
    "Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    275,
    46315,
    "0210",
    "Virgin oil",
    "020102000005",
    "Ordinary Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    276,
    46315,
    "0210",
    "Virgin oil",
    "020102000005",
    "Ordinary Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    277,
    46315,
    "0201",
    "Cold pressed oils",
    "020102000006",
    "Cold Pressed Oils",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    278,
    46315,
    "0201",
    "Cold pressed oils",
    "020102000006",
    "Cold Pressed Oils",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    279,
    46315,
    "0201",
    "Cold pressed oils",
    "020102000006",
    "Cold Pressed Oils",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    280,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000007",
    "Minyak Goreng (Frying oil) ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    281,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000007",
    "Minyak Goreng (Frying oil) ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    282,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000007",
    "Minyak Goreng (Frying oil) ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    283,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000008",
    "Minyak Goreng Padat (Frying Fat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    284,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000008",
    "Minyak Goreng Padat (Frying Fat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    285,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000008",
    "Minyak Goreng Padat (Frying Fat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    286,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000009",
    "Minyak Masak atau Minyak Sayur (Cooking Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    287,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000009",
    "Minyak Masak atau Minyak Sayur (Cooking Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    288,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000009",
    "Minyak Masak atau Minyak Sayur (Cooking Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    289,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000010",
    "Minyak Salad (Salad Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    290,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000010",
    "Minyak Salad (Salad Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    291,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000011",
    "Serbuk Lemak Nabati (Fat Powder)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    292,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000012",
    "Vanaspati atau Minyak Samin (Vegetable Ghee)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    293,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000012",
    "Vanaspati atau Minyak Samin (Vegetable Ghee)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    294,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    295,
    46315,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    296,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    297,
    46315,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    298,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    299,
    46315,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    300,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    301,
    46315,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    302,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    303,
    46315,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    304,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    305,
    46315,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    306,
    46315,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000014",
    "Pengganti Minyak Mentega (Butter Oil Substitute)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    307,
    46315,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000014",
    "Pengganti Minyak Mentega (Butter Oil Substitute)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    308,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000015",
    "Minyak Inti Kelapa Sawit Mentah (Crude Palm Kernel Oil/CPKO)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    309,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000016",
    "Minyak Inti Kelapa Sawit (Refined Bleached Deodorized Palm Kernel Oil/RBDPKO)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    310,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000017",
    "Minyak Kelapa Sawit Mentah (Crude Palm Oil/CPO) atau Pretreated Palm Oil",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    311,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000018",
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    312,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000018",
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    313,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000019",
    "Minyak Olein Kelapa Sawit Mentah (Crude Palm Olein)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    314,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000020",
    "Minyak Stearin Kelapa Sawit Mentah (Crude Palm Stearin)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    315,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000021",
    "Minyak Olein Kelapa Sawit (Refined Bleached Deodorized Palm Olein)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    316,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000022",
    "Stearin Kelapa Sawit (Refined Bleached Deodorized Palm Stearin/RBDPS)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    317,
    46315,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    318,
    46315,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    319,
    46315,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    320,
    46315,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    321,
    46315,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    322,
    46315,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    323,
    46315,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    324,
    46315,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    325,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000024",
    "Minyak Kelapa Mentah atau Unrefined Coconut Oil/Crude Coconut Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    326,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000025",
    "Minyak Kelapa (Refined Bleached Deodorized Coconut Oil )",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    327,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000026",
    "Minyak Kacang Tanah (Refined Bleached Deodorized Peanut Oil/Refined Bleached Deodorized Groundnut Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    328,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000026",
    "Minyak Kacang Tanah (Refined Bleached Deodorized Peanut Oil/Refined Bleached Deodorized Groundnut Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    329,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000027",
    "Minyak Jagung (Refined Bleached Deodorized Corn Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    330,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000027",
    "Minyak Jagung (Refined Bleached Deodorized Corn Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    331,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000028",
    "Minyak Kemiri (Refined Bleached Deodorized Candlenut/Lumbang Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    332,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000028",
    "Minyak Kemiri (Refined Bleached Deodorized Candlenut/Lumbang Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    333,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000029",
    "Minyak Kedelai (Refined Bleached Deodorized Soybean Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    334,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000029",
    "Minyak Kedelai (Refined Bleached Deodorized Soybean Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    335,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000029",
    "Minyak Kedelai (Refined Bleached Deodorized Soybean Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    336,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000030",
    "Minyak Wijen (Sesame Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    337,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000030",
    "Minyak Wijen (Sesame Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    338,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000031",
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    339,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000031",
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    340,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000031",
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    341,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000032",
    "Minyak Safflower (Refined Bleached Deodorized Safflower Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    342,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000032",
    "Minyak Safflower (Refined Bleached Deodorized Safflower Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    343,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000033",
    "Minyak Biji Bunga Matahari (Refined Bleached Deodorized Sunflower Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    344,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000033",
    "Minyak Biji Bunga Matahari (Refined Bleached Deodorized Sunflower Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    345,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000034",
    "Minyak Dedak atau Minyak Bekatul atau Minyak Katul (Refined Bleached Deodorized Rice Bran Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    346,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000035",
    "Minyak Biji Kapas (Refined Bleached Deodorized Cottonseed Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    347,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000035",
    "Minyak Biji Kapas (Refined Bleached Deodorized Cottonseed Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    348,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000036",
    "Rapeseed oil (turnip rape oil/colza oil/ravison oil/sarson oil/toria oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    349,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000036",
    "Rapeseed oil (turnip rape oil/colza oil/ravison oil/sarson oil/toria oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    350,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000037",
    "Rapeseed oil - low erucic acid (low erucic acid turnip rape oil/low erucic acid colza oil/canola oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    351,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000037",
    "Rapeseed oil - low erucic acid (low erucic acid turnip rape oil/low erucic acid colza oil/canola oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    352,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000038",
    "Mustardseed Oil (Refined Bleached Deodorized Mustardseed Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    353,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000038",
    "Mustardseed Oil (Refined Bleached Deodorized Mustardseed Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    354,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000039",
    "Minyak Biji Rami/Flaxseed Oil/Flax Oil/Linseed Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    355,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000040",
    "Minyak Makan Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    356,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000040",
    "Minyak Makan Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    357,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000040",
    "Minyak Makan Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    358,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000040",
    "Minyak Makan Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    359,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000040",
    "Minyak Makan Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    360,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000040",
    "Minyak Makan Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    361,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000040",
    "Minyak Makan Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    362,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000041",
    "Minyak Biji Anggur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    363,
    46315,
    "0210",
    "Virgin oil",
    "020102000042",
    "Minyak Kelapa Virgin (VCO)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    364,
    46315,
    "0210",
    "Virgin oil",
    "020102000043",
    "Minyak Kelapa Virgin (VCO) dengan Bahan Pangan Lain",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    365,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000044",
    "Stearin Inti Kelapa Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    366,
    46315,
    "0205",
    "Lemak dan minyak nabati",
    "020102000045",
    "Minyak Blondo Kelapa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    367,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000001",
    "Lemak Hewani",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    368,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000001",
    "Lemak Hewani",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    369,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000002",
    "Lemak Babi atau Lard",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    370,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000003",
    "Rendered Pork Fat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    371,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000004",
    "Lemak Sapi Utama (Prime Beef Fat (Premier Jus atau Oleo Stock))",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    372,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000005",
    "Lemak Sapi (Edible Beef Fat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    373,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000005",
    "Lemak Sapi (Edible Beef Fat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    374,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000006",
    "Dripping atau Edible Tallow",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    375,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000007",
    "Secunda Beef Fat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    376,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000008",
    "Suet",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    377,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000009",
    "Minyak Ikan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    378,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000010",
    "Serbuk Lemak Hewani (Fat Powder)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    379,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000010",
    "Serbuk Lemak Hewani (Fat Powder)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    380,
    46327,
    "0207",
    "Minyak dan lemak hewani",
    "020103000011",
    "Minyak Krill",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    381,
    46326,
    "0202",
    "Emulsi lemak",
    "020201000001",
    "Mentega dan Konsentrat Mentega",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    382,
    46326,
    "0202",
    "Emulsi lemak",
    "020201000002",
    "Mentega (butter)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    383,
    46326,
    "0202",
    "Emulsi lemak",
    "020201000003",
    "Mentega Rekombinasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    384,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000001",
    "Margarin dan Produk Sejenis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    385,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000001",
    "Margarin dan Produk Sejenis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    386,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000002",
    "Margarin",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    387,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000003",
    "Campuran Margarin dan Mentega (Blends of butter and margarine)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    388,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000003",
    "Campuran Margarin dan Mentega (Blends of butter and margarine)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    389,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000004",
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    390,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000004",
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    391,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000005",
    "Minarin atau Halvarine",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    392,
    46315,
    "0202",
    "Emulsi lemak",
    "020202000006",
    "Lemak Oles Loyang (Pan Release)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    393,
    46315,
    "0202",
    "Emulsi lemak",
    "020300000001",
    "Non-Dairy Toppings, Fillings, Frostings",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    394,
    46315,
    "0202",
    "Emulsi lemak",
    "020300000002",
    "Non-Dairy Whipped Cream",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    395,
    46315,
    "0202",
    "Emulsi lemak",
    "020300000003",
    "Krim Nabati (Vegetable Cream)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    396,
    46315,
    "0203",
    "Es krim non-dairy",
    "020400000001",
    "Melorin atau Non-Dairy Ice Cream",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    397,
    46315,
    "0203",
    "Es krim non-dairy",
    "020400000001",
    "Melorin atau Non-Dairy Ice Cream",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    398,
    46315,
    "0203",
    "Es krim non-dairy",
    "020400000002",
    "Non-Dairy Mousse",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    399,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000001",
    "Es Batu Untuk Konsumsi ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    400,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000002",
    "Water Ices",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    401,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000002",
    "Water Ices",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    402,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000003",
    "Es Mambo",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    403,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000004",
    "Es Stik (Ice Stick) atau Es Loli",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    404,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000005",
    "Es Buah (Fruit Ice)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    405,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000006",
    "Es Puter",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    406,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000007",
    "Es Lilin",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    407,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000008",
    "Es Kue",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    408,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000009",
    "Sorbet",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    409,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000010",
    "Sherbet",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    410,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000011",
    "Es Mengandung Susu ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    411,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000012",
    "Es Rasa Susu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    412,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000013",
    "Premiks Es Bentuk Bubuk ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    413,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000014",
    "Premiks Es Bentuk Cair ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    414,
    46339,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000015",
    "Sediaan Cair Yang Akan Dikonsumsi Dalam Keadaan Beku",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    415,
    46319,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102010001",
    "Buah Beku dengan Penambahan Bahan Pangan Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    416,
    46319,
    "0403",
    "Buah kering",
    "040102020001",
    "Buah Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    417,
    46319,
    "0403",
    "Buah kering",
    "040102020001",
    "Buah Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    418,
    46319,
    "0403",
    "Buah kering",
    "040102020002",
    "Buah Kering Campur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    419,
    46319,
    "0403",
    "Buah kering",
    "040102020003",
    "Kopra",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    420,
    46319,
    "0403",
    "Buah kering",
    "040102020004",
    "Kelapa Parut Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    421,
    46319,
    "0403",
    "Buah kering",
    "040102020004",
    "Kelapa Parut Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    422,
    46319,
    "0403",
    "Buah kering",
    "040102020005",
    "Santan Bubuk",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    423,
    46319,
    "0403",
    "Buah kering",
    "040102020006",
    "Tepung Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    424,
    46319,
    "0403",
    "Buah kering",
    "040102020006",
    "Tepung Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    425,
    46339,
    "0410",
    "Manisan/asinan buah",
    "040102030001",
    "Buah Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    426,
    46339,
    "0410",
    "Manisan/asinan buah",
    "040102030002",
    "Asinan Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    427,
    46339,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102030003",
    "Rujak",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    428,
    46319,
    "0402",
    "Buah dalam kemasan",
    "040102040001",
    "Buah Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    429,
    46319,
    "0402",
    "Buah dalam kemasan",
    "040102040001",
    "Buah Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    430,
    46319,
    "0402",
    "Buah dalam kemasan",
    "040102040002",
    "Koktil Buah Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    431,
    46319,
    "0402",
    "Buah dalam kemasan",
    "040102040002",
    "Koktil Buah Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    432,
    46319,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040102050001",
    "Jem Buah atau Selai Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    433,
    46319,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040102050002",
    "Jeli Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    434,
    46319,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040102050003",
    "Marmalad",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    435,
    46319,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102060001",
    "Chutney Mangga (Mango Chutney)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    436,
    46319,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102060001",
    "Chutney Mangga (Mango Chutney)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    437,
    46319,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102060002",
    "Produk Buah Oles",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    438,
    46319,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102060002",
    "Produk Buah Oles",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    439,
    46319,
    "0401",
    "Buah bergula",
    "040102070001",
    "Buah Bersalut",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    440,
    46319,
    "0401",
    "Buah bergula",
    "040102070002",
    "Buah Bergula",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    441,
    46319,
    "0401",
    "Buah bergula",
    "040102070003",
    "Buah Berkristal",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    442,
    46319,
    "0401",
    "Buah bergula",
    "040102070004",
    "Kulit Buah Bergula",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    443,
    46319,
    "0401",
    "Buah bergula",
    "040102070005",
    "Bunga Bergula",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    444,
    46319,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040102080001",
    "Bubur Buah (Fruit Pulp)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    445,
    46319,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040102080002",
    "Puree Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    446,
    46319,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040102080003",
    "Pasta Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    447,
    46319,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040102080004",
    "Saus Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    448,
    46319,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040102080005",
    "Topping Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    449,
    46319,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102080006",
    "Santan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    450,
    46319,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040102080007",
    "Nata",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    451,
    46319,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040102080008",
    "Konsentrat Asam Jawa/Tamarin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    452,
    46319,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102080009",
    "Bubuk Asam Jawa/Tamarin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    453,
    46319,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102080010",
    "Bars Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    454,
    46339,
    "0410",
    "Manisan/asinan buah",
    "040102090001",
    "Manisan Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    455,
    46339,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040102090002",
    "Nata Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    456,
    46339,
    "0302",
    "Makanan Pencuci Mulut Berbahan Dasar Selain Susu",
    "040102090003",
    "Jeli Agar",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    457,
    46339,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090003",
    "Jeli Agar",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    458,
    46339,
    "0302",
    "Makanan Pencuci Mulut Berbahan Dasar Selain Susu",
    "040102090003",
    "Jeli Agar",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    459,
    46339,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090003",
    "Jeli Agar",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    460,
    46319,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102090004",
    "Bubuk Agar (Agar-Agar Tepung/Tepung Agar-Agar)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    461,
    46319,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090004",
    "Bubuk Agar (Agar-Agar Tepung/Tepung Agar-Agar)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    462,
    46319,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102090004",
    "Bubuk Agar (Agar-Agar Tepung/Tepung Agar-Agar)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    463,
    46319,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090004",
    "Bubuk Agar (Agar-Agar Tepung/Tepung Agar-Agar)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    464,
    46319,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090005",
    "Agar-Agar Kertas",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    465,
    46319,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090006",
    "Tepung Gelatin (Bubuk Gelatin)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    466,
    46319,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090007",
    "Tepung Karagenan (Bubuk Karagenan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    467,
    46319,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090008",
    "Jeli Agar Bubuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    468,
    46339,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090009",
    "Puding Rasa/Berperisa",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    469,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102090010",
    "Bubuk Puding Rasa/Berperisa",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    470,
    46339,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090010",
    "Bubuk Puding Rasa/Berperisa",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    471,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102090010",
    "Bubuk Puding Rasa/Berperisa",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    472,
    46339,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090010",
    "Bubuk Puding Rasa/Berperisa",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    473,
    46339,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090011",
    "Mitsumame",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    474,
    46339,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090012",
    "Sale Pisang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    475,
    46339,
    "0405",
    "Cincau",
    "040102090013",
    "Cincau Hijau",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    476,
    46339,
    "0405",
    "Cincau",
    "040102090014",
    "Cincau Hitam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    477,
    46339,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090015",
    "Siwalan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    478,
    46319,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090016",
    "Makanan Pencuci Mulut (Dessert) Berbasis Buah Termasuk Makanan Pencuci Mulut Berbasis Air Berflavor Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    479,
    46319,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090017",
    "Makanan Pencuci Mulut/ Hidangan Penutup Berbahan Dasar Kelapa",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    480,
    46319,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040102100001",
    "Pikel Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    481,
    46339,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040102100002",
    "Tempoyak/Pakasam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    482,
    46319,
    "0424",
    "Produk Buah Untuk Isi Pastri",
    "040102110001",
    "Produk Buah Untuk Isi Pastri",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    483,
    46319,
    "0424",
    "Produk Buah Untuk Isi Pastri",
    "040102110001",
    "Produk Buah Untuk Isi Pastri",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    484,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102120001",
    "Keripik Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    485,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102120001",
    "Keripik Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    486,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102120001",
    "Keripik Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    487,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102120002",
    "Keripik3 Buah Simulasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    488,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102120002",
    "Keripik3 Buah Simulasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    489,
    46339,
    "0409",
    "Lempok buah",
    "040102120003",
    "Dodol atau Lempok Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    490,
    46339,
    "0409",
    "Lempok buah",
    "040102120003",
    "Dodol atau Lempok Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    491,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102120004",
    "Wajit Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    492,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102120004",
    "Wajit Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    493,
    46339,
    "0407",
    "Geplak",
    "040102120005",
    "Geplak",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    494,
    46319,
    "0416",
    "Sayur beku",
    "040202010001",
    "Sayur Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    495,
    46319,
    "0416",
    "Sayur beku",
    "040202010001",
    "Sayur Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    496,
    46319,
    "0416",
    "Sayur beku",
    "040202010002",
    "Kentang Goreng Beku (Frozen French Fries)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    497,
    46319,
    "0416",
    "Sayur beku",
    "040202010002",
    "Kentang Goreng Beku (Frozen French Fries)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    498,
    46319,
    "0416",
    "Sayur beku",
    "040202010003",
    "Perkedel Kentang Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    499,
    46319,
    "0416",
    "Sayur beku",
    "040202010004",
    "Olahan Sayur Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    500,
    46319,
    "0419",
    "Sayur kering",
    "040202020001",
    "Sayur Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    501,
    46339,
    "0415",
    "Rumput laut kering",
    "040202020002",
    "Rumput Laut Kering",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    502,
    46339,
    "0415",
    "Rumput laut kering",
    "040202020003",
    "Nori",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    503,
    46339,
    "0415",
    "Rumput laut kering",
    "040202020003",
    "Nori",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    504,
    46339,
    "0419",
    "Sayur kering",
    "040202020004",
    "Sayur Asin Kering",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    505,
    46339,
    "0419",
    "Sayur kering",
    "040202020005",
    "Kacang Kering dan Polong Kacang Kering",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    506,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202020006",
    "Biji Bunga Matahari",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    507,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202020006",
    "Biji Bunga Matahari",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    508,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202020007",
    "Biji Wijen",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    509,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202020007",
    "Biji Wijen",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    510,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202020008",
    "Kuaci",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    511,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202020008",
    "Kuaci",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    512,
    46339,
    "0406",
    "Emping",
    "040202020009",
    "Emping Melinjo",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    513,
    46339,
    "0406",
    "Emping",
    "040202020009",
    "Emping Melinjo",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    514,
    46339,
    "0406",
    "Emping",
    "040202020010",
    "Emping Jengkol",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    515,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202020011",
    "Mete Gelondong",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    516,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202020011",
    "Mete Gelondong",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    517,
    46339,
    "0419",
    "Sayur kering",
    "040202020012",
    "Kentang Kering Serpih (Flakes)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    518,
    46319,
    "0418",
    "Sayur bubuk, Sayur kering",
    "040202020013",
    "Tepung Tomat/Bubur Tomat Kering/Pasta Tomat Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    519,
    46319,
    "0417",
    "Sayur bubuk",
    "040202020014",
    "Tepung Bit",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    520,
    46319,
    "0417",
    "Sayur bubuk",
    "040202020015",
    "Tepung Daun Kelor",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    521,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030001",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    522,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030001",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    523,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030001",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    524,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030001",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    525,
    46339,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030001",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    526,
    46339,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030001",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    527,
    46339,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030001",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    528,
    46339,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030001",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    529,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030002",
    "Sayur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    530,
    46319,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030002",
    "Sayur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    531,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030002",
    "Sayur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    532,
    46319,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030002",
    "Sayur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    533,
    46339,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030002",
    "Sayur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    534,
    46339,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030002",
    "Sayur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    535,
    46339,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030002",
    "Sayur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    536,
    46339,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030002",
    "Sayur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    537,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030003",
    "Jamur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    538,
    46319,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030003",
    "Jamur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    539,
    46339,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030003",
    "Jamur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    540,
    46339,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030003",
    "Jamur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    541,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    542,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    543,
    46319,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    544,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    545,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    546,
    46319,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    547,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    548,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    549,
    46319,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    550,
    46339,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    551,
    46339,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    552,
    46339,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    553,
    46339,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    554,
    46339,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    555,
    46339,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    556,
    46339,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    557,
    46339,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    558,
    46339,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    559,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030005",
    "Asinan Jahe",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    560,
    46319,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030005",
    "Asinan Jahe",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    561,
    46339,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030005",
    "Asinan Jahe",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    562,
    46339,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030005",
    "Asinan Jahe",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    563,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040001",
    "Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    564,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040001",
    "Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    565,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040001",
    "Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    566,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040001",
    "Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    567,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040001",
    "Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    568,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040001",
    "Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    569,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040001",
    "Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    570,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040001",
    "Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    571,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040002",
    "Tomat Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    572,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040002",
    "Tomat Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    573,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040002",
    "Tomat Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    574,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040002",
    "Tomat Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    575,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040002",
    "Tomat Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    576,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040002",
    "Tomat Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    577,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040002",
    "Tomat Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    578,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040002",
    "Tomat Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    579,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    580,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    581,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    582,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    583,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    584,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    585,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    586,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    587,
    46339,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    588,
    46339,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    589,
    46339,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    590,
    46339,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    591,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040004",
    "Wortel Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    592,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040004",
    "Wortel Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    593,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040004",
    "Wortel Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    594,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040004",
    "Wortel Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    595,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040005",
    "Jamur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    596,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040005",
    "Jamur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    597,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040005",
    "Jamur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    598,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040005",
    "Jamur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    599,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040005",
    "Jamur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    600,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040005",
    "Jamur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    601,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040005",
    "Jamur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    602,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040005",
    "Jamur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    603,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040006",
    "Buncis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    604,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040006",
    "Buncis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    605,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040006",
    "Buncis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    606,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040006",
    "Buncis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    607,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040007",
    "Asparagus Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    608,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040007",
    "Asparagus Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    609,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040007",
    "Asparagus Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    610,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040007",
    "Asparagus Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    611,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040008",
    "Rebung Bambu Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    612,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040008",
    "Rebung Bambu Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    613,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040008",
    "Rebung Bambu Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    614,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040008",
    "Rebung Bambu Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    615,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040009",
    "Kacang Kapri (Green Peas) dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    616,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040009",
    "Kacang Kapri (Green Peas) dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    617,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040009",
    "Kacang Kapri (Green Peas) dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    618,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040009",
    "Kacang Kapri (Green Peas) dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    619,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040009",
    "Kacang Kapri (Green Peas) dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    620,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040009",
    "Kacang Kapri (Green Peas) dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    621,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040009",
    "Kacang Kapri (Green Peas) dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    622,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040009",
    "Kacang Kapri (Green Peas) dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    623,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    624,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    625,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    626,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    627,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    628,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    629,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    630,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    631,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    632,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    633,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    634,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    635,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040011",
    "Manisan Rumput Laut dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    636,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040011",
    "Manisan Rumput Laut dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    637,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040011",
    "Manisan Rumput Laut dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    638,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040011",
    "Manisan Rumput Laut dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    639,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040012",
    "Lidah Buaya dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    640,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040012",
    "Lidah Buaya dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    641,
    46319,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040012",
    "Lidah Buaya dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    642,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040012",
    "Lidah Buaya dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    643,
    46319,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040013",
    "Olahan Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    644,
    46319,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040202050001",
    "Puree Tomat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    645,
    46319,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040202050002",
    "Selai Kacang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    646,
    46319,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040202050003",
    "Olesan Kacang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    647,
    46319,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040202050004",
    "Olesan Mengandung Kacang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    648,
    46319,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040202050005",
    "Selai Sayur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    649,
    46319,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040202050006",
    "Selai Biji-Bijian",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    650,
    46319,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040202050007",
    "Olesan Wijen",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    651,
    46319,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040202060001",
    "Pasta Tomat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    652,
    46319,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040202060002",
    "Pasta Umbi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    653,
    46319,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040202060003",
    "Bubur (Pulp) Sayur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    654,
    46319,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040202060004",
    "Produk Jeli Tidak Siap Konsumsi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    655,
    46319,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070001",
    "Pikel (fermentasi)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    656,
    46319,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070002",
    "Sawi Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    657,
    46319,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070003",
    "Sauerkraut",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    658,
    46319,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070004",
    "Jamur Fermentasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    659,
    46319,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070005",
    "Kimchi ",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    660,
    46319,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070006",
    "Gochujang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    661,
    46319,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202070007",
    "Olahan Kacang Serupa Keju",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    662,
    46319,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040202070007",
    "Olahan Kacang Serupa Keju",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    663,
    46319,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202070007",
    "Olahan Kacang Serupa Keju",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    664,
    46319,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040202070007",
    "Olahan Kacang Serupa Keju",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    665,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202070007",
    "Olahan Kacang Serupa Keju",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    666,
    46339,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040202070007",
    "Olahan Kacang Serupa Keju",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    667,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202070007",
    "Olahan Kacang Serupa Keju",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    668,
    46339,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040202070007",
    "Olahan Kacang Serupa Keju",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    669,
    46319,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070008",
    "Tempe Selain Kedelai",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    670,
    46319,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070009",
    "Tape Singkong",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    671,
    46319,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070010",
    "Oncom Hitam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    672,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080001",
    "Keripik Bayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    673,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080001",
    "Keripik Bayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    674,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080001",
    "Keripik Bayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    675,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080002",
    "Keripik3 Jamur Kancing",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    676,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080002",
    "Keripik3 Jamur Kancing",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    677,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080002",
    "Keripik3 Jamur Kancing",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    678,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080003",
    "Getuk Singkong",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    679,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080003",
    "Getuk Singkong",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    680,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080004",
    "Vegetable Tsukudani",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    681,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080004",
    "Vegetable Tsukudani",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    682,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080005",
    "Kerupuk 4Jengkol",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    683,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080005",
    "Kerupuk 4Jengkol",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    684,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080005",
    "Kerupuk 4Jengkol",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    685,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080006",
    "Dodol Rumput Laut",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    686,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080006",
    "Dodol Rumput Laut",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    687,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080006",
    "Dodol Rumput Laut",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    688,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080007",
    "Sayur Olahan Yang Dibentuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    689,
    46339,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040202080007",
    "Sayur Olahan Yang Dibentuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    690,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080007",
    "Sayur Olahan Yang Dibentuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    691,
    46339,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040202080007",
    "Sayur Olahan Yang Dibentuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    692,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080008",
    "Produk Olahan Singkong",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    693,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080008",
    "Produk Olahan Singkong",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    694,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080009",
    "Umbi Panggang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    695,
    46319,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080010",
    "Keripik Bonggol Pisang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    696,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080012",
    "Keripik Sayur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    697,
    46314,
    "0508",
    "Massa kakao dan cairan kental (liquor) cokelat",
    "050101000001",
    "Kakao Massa (Cocoa liquor)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    698,
    46314,
    "0503",
    "Keik kakao (cocoa press cake)",
    "050101000002",
    "Keik Kakao/Bungkil Kakao",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    699,
    46314,
    "0503",
    "Keik kakao (cocoa press cake)",
    "050101000002",
    "Keik Kakao/Bungkil Kakao",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    700,
    46314,
    "0502",
    "Kakao bubuk",
    "050101000003",
    "Kakao Bubuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    701,
    46314,
    "0502",
    "Kakao bubuk",
    "050101000003",
    "Kakao Bubuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    702,
    46314,
    "0507",
    "Lemak kakao (cocoa butter)",
    "050101000004",
    "Lemak Kakao (Cocoa Butter)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    703,
    46314,
    "0510",
    "Pangan kategori 5 risiko rendah lainnya",
    "050101000005",
    "Debu Kakao (Cocoa Dust)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    704,
    46314,
    "0510",
    "Pangan kategori 5 risiko rendah lainnya",
    "050101000006",
    "Bubuk Minuman Kakao (Drinking Cocoa Mixes)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    705,
    46331,
    "0510",
    "Pangan kategori 5 risiko rendah lainnya",
    "050101000007",
    "Bubuk Minuman Cokelat (Drinking Chocolate)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    706,
    46314,
    "0510",
    "Pangan kategori 5 risiko rendah lainnya",
    "050101000008",
    "Kakao Instan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    707,
    46331,
    "0510",
    "Pangan kategori 5 risiko rendah lainnya",
    "050101000009",
    "Cokelat Instan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    708,
    46331,
    "0510",
    "Pangan kategori 5 risiko rendah lainnya",
    "050101000010",
    "Cokelat Bubuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    709,
    46331,
    "0510",
    "Pangan kategori 5 risiko rendah lainnya",
    "050101000010",
    "Cokelat Bubuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    710,
    46331,
    "0510",
    "Pangan kategori 5 risiko rendah lainnya",
    "050102000001",
    "Sirup Cokelat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    711,
    46331,
    "0512",
    "Pasta coklat",
    "050103000001",
    "Cokelat Pasta (Berbasis Minyak)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    712,
    46331,
    "0512",
    "Pasta coklat",
    "050103000002",
    "Cokelat Pasta (Berbasis Air)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    713,
    46331,
    "0501",
    "Cokelat",
    "050104000001",
    "Cokelat Hitam (Dark Chocolate, Semisweet Chocolate, Bittersweet Chocolate)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    714,
    46331,
    "0501",
    "Cokelat",
    "050104000002",
    "Cokelat Hitam Manis (Sweet Chocolate)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    715,
    46331,
    "0501",
    "Cokelat",
    "050104000003",
    "Cokelat Hitam Kovertur (Dark Chocolate Couverture)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    716,
    46331,
    "0501",
    "Cokelat",
    "050104000004",
    "Cokelat Susu (Milk Chocolate)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    717,
    46331,
    "0501",
    "Cokelat",
    "050104000005",
    "Cokelat Susu Kovertur (Milk Chocolate Couverture)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    718,
    46331,
    "0501",
    "Cokelat",
    "050104000006",
    "Cokelat Putih (White Chocolate)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    719,
    46331,
    "0501",
    "Cokelat",
    "050104000007",
    "Cokelat Putih Kovertur (White Chocolate Couverture)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    720,
    46331,
    "0501",
    "Cokelat",
    "050104000008",
    "Meses/Cokelat Butir/Cokelat Vermicelli /Streusel",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    721,
    46331,
    "0501",
    "Cokelat",
    "050104000009",
    "Meses Susu/Cokelat Susu Butir/Cokelat Susu Vermicelli",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    722,
    46331,
    "0501",
    "Cokelat",
    "050104000010",
    "Bonbon Cokelat /Permen Isi Cokelat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    723,
    46331,
    "0501",
    "Cokelat",
    "050104000011",
    "Praline",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    724,
    46331,
    "0501",
    "Cokelat",
    "050104000012",
    "Truffles",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    725,
    46331,
    "0501",
    "Cokelat",
    "050104000013",
    "Cokelat Isi (filled chocolate)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    726,
    46331,
    "0501",
    "Cokelat",
    "050104000014",
    "Cokelat Berperisa",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    727,
    46331,
    "0501",
    "Cokelat",
    "050104000015",
    "Cokelat Aerasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    728,
    46331,
    "0501",
    "Cokelat",
    "050104000016",
    "Cokelat Laminasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    729,
    46331,
    "0501",
    "Cokelat",
    "050104000017",
    "Cokelat Komposit",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    730,
    46331,
    "0501",
    "Cokelat",
    "050105000001",
    "Cokelat Paduan/Cokelat Compound",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    731,
    46331,
    "0501",
    "Cokelat",
    "050105000001",
    "Cokelat Paduan/Cokelat Compound",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    732,
    46331,
    "0501",
    "Cokelat",
    "050105000001",
    "Cokelat Paduan/Cokelat Compound",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    733,
    46331,
    "0501",
    "Cokelat",
    "050105000001",
    "Cokelat Paduan/Cokelat Compound",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    734,
    46331,
    "0501",
    "Cokelat",
    "050105000002",
    "Cokelat Paduan/Cokelat Compound Butir",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    735,
    46331,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000002",
    "Cokelat Paduan/Cokelat Compound Butir",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    736,
    46331,
    "0501",
    "Cokelat",
    "050105000002",
    "Cokelat Paduan/Cokelat Compound Butir",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    737,
    46331,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000002",
    "Cokelat Paduan/Cokelat Compound Butir",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    738,
    46331,
    "0501",
    "Cokelat",
    "050105000002",
    "Cokelat Paduan/Cokelat Compound Butir",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    739,
    46331,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000002",
    "Cokelat Paduan/Cokelat Compound Butir",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    740,
    46331,
    "0501",
    "Cokelat",
    "050105000002",
    "Cokelat Paduan/Cokelat Compound Butir",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    741,
    46331,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000002",
    "Cokelat Paduan/Cokelat Compound Butir",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    742,
    46331,
    "0501",
    "Cokelat",
    "050105000003",
    "Minuman Cokelat Paduan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    743,
    46331,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000004",
    "Cokelat Imitasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    744,
    46331,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000005",
    "Cocoa Butter Equivalent",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    745,
    46331,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000005",
    "Cocoa Butter Equivalent",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    746,
    46315,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000006",
    "Pengganti Lemak Kakao Laurat (Lauric Cocoa Butter Replacer/Substitute = CBS Lauric)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    747,
    46315,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000007",
    "Pengganti Lemak Kakao Non-Laurat (Non-lauric Cocoa Butter Replacer/Substitute = CBS Non-Lauric)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    748,
    46331,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000008",
    "Carob Coatings",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    749,
    46331,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000009",
    "Coating Dari Lembaga Gandum Bebas Lemak (Deffated Wheat Germ Coating)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    750,
    46331,
    "0505",
    "Kembang gula/permen keras",
    "050201000001",
    "Kembang Gula Keras/Permen Keras/Hard Candy/Boiled Sweet",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    751,
    46331,
    "0505",
    "Kembang gula/permen keras",
    "050201000002",
    "Pastiles",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    752,
    46331,
    "0505",
    "Kembang gula/permen keras",
    "050201000002",
    "Pastiles",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    753,
    46331,
    "0505",
    "Kembang gula/permen keras",
    "050201000003",
    "Pressed Candy/Lozenges",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    754,
    46331,
    "0505",
    "Kembang gula/permen keras",
    "050201000004",
    "Kembang Gula Isi Susu/Permen Isi Susu",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    755,
    46331,
    "0505",
    "Kembang gula/permen keras",
    "050201000005",
    "Kembang Gula Keras Rasa Susu/Permen Keras Rasa Susu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    756,
    46331,
    "0505",
    "Kembang gula/permen keras",
    "050201000006",
    "Kembang Gula Serbuk/Permen Serbuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    757,
    46331,
    "0506",
    "Kembang gula/permen lunak",
    "050202000001",
    "Kembang Gula Lunak/Permen Lunak",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    758,
    46331,
    "0506",
    "Kembang gula/permen lunak",
    "050202000002",
    "Kembang Gula Karamel/Permen Karamel",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    759,
    46331,
    "0506",
    "Kembang gula/permen lunak",
    "050202000003",
    "Fudge",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    760,
    46331,
    "0506",
    "Kembang gula/permen lunak",
    "050202000004",
    "Butterscotch",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    761,
    46331,
    "0506",
    "Kembang gula/permen lunak",
    "050202000005",
    "Licorice",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    762,
    46331,
    "0506",
    "Kembang gula/permen lunak",
    "050202000006",
    "Toffee",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    763,
    46331,
    "0506",
    "Kembang gula/permen lunak",
    "050202000007",
    "Krokant/Brittles",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    764,
    46331,
    "0506",
    "Kembang gula/permen lunak",
    "050202000008",
    "Marshmallow",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    765,
    46331,
    "0506",
    "Kembang gula/permen lunak",
    "050202000009",
    "Kembang Gula Jeli Pati (Starch Jelly)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    766,
    46331,
    "0506",
    "Kembang gula/permen lunak",
    "050202000010",
    "Kembang Gula Jeli Agar dan Gelatin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    767,
    46331,
    "0506",
    "Kembang gula/permen lunak",
    "050202000010",
    "Kembang Gula Jeli Agar dan Gelatin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    768,
    46331,
    "0506",
    "Kembang gula/permen lunak",
    "050202000011",
    "Gula Kapas (Cotton Candy)/Arumanis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    769,
    46331,
    "0506",
    "Kembang gula/permen lunak",
    "050202000012",
    "Gulali",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    770,
    46331,
    "0506",
    "Kembang gula/permen lunak",
    "050202000013",
    "Kembang Gula Lunak Rasa Susu/Permen Lunak Rasa Susu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    771,
    46331,
    "0506",
    "Kembang gula/permen lunak",
    "050202000014",
    "Kembang Gula Cair/Permen Cair",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    772,
    46331,
    "0509",
    "Nougat, marzipan",
    "050203000001",
    "Permen Enting-Enting atau Nut Brittles",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    773,
    46331,
    "0509",
    "Nougat, marzipan",
    "050203000002",
    "Raw Marzipan, Base Almond Paste",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    774,
    46331,
    "0509",
    "Nougat, marzipan",
    "050203000003",
    "Marzipan, Almond Paste",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    775,
    46331,
    "0509",
    "Nougat, marzipan",
    "050203000004",
    "Nougat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    776,
    46331,
    "0504",
    "Kembang gula/permen karet",
    "050300000001",
    "Kembang Gula Karet/Permen Karet",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    777,
    46331,
    "0504",
    "Kembang gula/permen karet",
    "050300000001",
    "Kembang Gula Karet/Permen Karet",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    778,
    46331,
    "0504",
    "Kembang gula/permen karet",
    "050300000002",
    "Kembang Gula Karet Rasa Susu/Permen Karet Rasa Susu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    779,
    46331,
    "0504",
    "Kembang gula/permen karet",
    "050300000002",
    "Kembang Gula Karet Rasa Susu/Permen Karet Rasa Susu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    780,
    46331,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000001",
    "Icing",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    781,
    46331,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000001",
    "Icing",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    782,
    46331,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000002",
    "Frosting",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    783,
    46315,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000003",
    "Saus Butterstotch",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    784,
    46331,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000004",
    "Saus/Topping/Olesan Cokelat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    785,
    46331,
    "0514",
    "Dekorasi, Topping (Non-Buah) dan Saus Manis",
    "050400000004",
    "Saus/Topping/Olesan Cokelat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    786,
    46331,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000004",
    "Saus/Topping/Olesan Cokelat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    787,
    46331,
    "0514",
    "Dekorasi, Topping (Non-Buah) dan Saus Manis",
    "050400000004",
    "Saus/Topping/Olesan Cokelat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    788,
    46331,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000005",
    "Saus/Topping/Olesan Manis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    789,
    46331,
    "0514",
    "Dekorasi, Topping (Non-Buah) dan Saus Manis",
    "050400000005",
    "Saus/Topping/Olesan Manis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    790,
    46331,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000005",
    "Saus/Topping/Olesan Manis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    791,
    46331,
    "0514",
    "Dekorasi, Topping (Non-Buah) dan Saus Manis",
    "050400000005",
    "Saus/Topping/Olesan Manis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    792,
    46331,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000005",
    "Saus/Topping/Olesan Manis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    793,
    46331,
    "0514",
    "Dekorasi, Topping (Non-Buah) dan Saus Manis",
    "050400000005",
    "Saus/Topping/Olesan Manis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    794,
    46331,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000005",
    "Saus/Topping/Olesan Manis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    795,
    46331,
    "0514",
    "Dekorasi, Topping (Non-Buah) dan Saus Manis",
    "050400000005",
    "Saus/Topping/Olesan Manis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    796,
    46331,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000006",
    "Saus/Topping/Olesan (non buah)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    797,
    46331,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000007",
    "Taburan Berbasis Gula",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    798,
    46331,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000007",
    "Taburan Berbasis Gula",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    799,
    46319,
    "0601",
    "Biji-bijian / kacang-kacangan kering",
    "060100000001",
    "Nasi Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    800,
    46319,
    "0633",
    "Nasi Instan (dikeringkan)",
    "060100000001",
    "Nasi Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    801,
    46319,
    "0601",
    "Biji-bijian / kacang-kacangan kering",
    "060100000002",
    "Emping Beras",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    802,
    46319,
    "0603",
    "Bubur instan, kecuali yang disterilisasi",
    "060100000003",
    "Bubur Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    803,
    46319,
    "0602",
    "Biji-bijian dan kacang-kacangan (utuh, patahan, atau serpihan)",
    "060100000004",
    "Gandum Hancur (Crushed Wheat)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    804,
    46319,
    "0602",
    "Biji-bijian dan kacang-kacangan (utuh, patahan, atau serpihan)",
    "060100000005",
    "Jagung Pipil",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    805,
    46319,
    "0602",
    "Biji-bijian dan kacang-kacangan (utuh, patahan, atau serpihan)",
    "060100000006",
    "Biji Oats",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    806,
    46319,
    "0602",
    "Biji-bijian dan kacang-kacangan (utuh, patahan, atau serpihan)",
    "060100000007",
    "Jewawut (Pearl Millet)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    807,
    46319,
    "0601",
    "Biji-bijian / kacang-kacangan kering",
    "060100000008",
    "Sorgum",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    808,
    46319,
    "0601",
    "Biji-bijian / kacang-kacangan kering",
    "060100000009",
    "Gaplek",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    809,
    46319,
    "0601",
    "Biji-bijian / kacang-kacangan kering",
    "060100000010",
    "Beras Pecah Kulit Pratanak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    810,
    46319,
    "0602",
    "Biji-bijian dan kacang-kacangan (utuh, patahan, atau serpihan)",
    "060100000011",
    "Gandum Patah (Cracked Wheat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    811,
    46319,
    "0602",
    "Biji-bijian dan kacang-kacangan (utuh, patahan, atau serpihan)",
    "060100000012",
    "Lembaga Gandum",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    812,
    46319,
    "0625",
    "Tepung",
    "060201000001",
    "Tepung Beras",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    813,
    46319,
    "0625",
    "Tepung",
    "060201000001",
    "Tepung Beras",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    814,
    46319,
    "0625",
    "Tepung",
    "060201000002",
    "Tepung Beras Ketan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    815,
    46319,
    "0625",
    "Tepung",
    "060201000003",
    "Tepung Jagung",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    816,
    46319,
    "0625",
    "Tepung",
    "060201000004",
    "Tepung Kacang Hijau Tanpa Kulit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    817,
    46319,
    "0625",
    "Tepung",
    "060201000005",
    "Tepung Kacang Hijau Utuh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    818,
    46319,
    "0625",
    "Tepung",
    "060201000006",
    "Tepung Kacang Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    819,
    46319,
    "0625",
    "Tepung",
    "060201000007",
    "Tepung Kedelai (Soybean Flour)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    820,
    46319,
    "0625",
    "Tepung",
    "060201000008",
    "Semolina Gandum Durum ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    821,
    46319,
    "0625",
    "Tepung",
    "060201000008",
    "Semolina Gandum Durum ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    822,
    46319,
    "0625",
    "Tepung",
    "060201000009",
    "Tepung Gandum Durum",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    823,
    46319,
    "0625",
    "Tepung",
    "060201000009",
    "Tepung Gandum Durum",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    824,
    46319,
    "0625",
    "Tepung",
    "060201000010",
    "Semolina Gandum Durum Utuh dan Tepung Gandum Durum Utuh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    825,
    46319,
    "0625",
    "Tepung",
    "060201000010",
    "Semolina Gandum Durum Utuh dan Tepung Gandum Durum Utuh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    826,
    46319,
    "0625",
    "Tepung",
    "060201000011",
    "Tepung Jewawut (Pearl Millet Flour)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    827,
    46319,
    "0625",
    "Tepung",
    "060201000012",
    "Tepung Sorgum",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    828,
    46319,
    "0627",
    "Tepung terigu",
    "060201000013",
    "Tepung Terigu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    829,
    46319,
    "0627",
    "Tepung terigu",
    "060201000013",
    "Tepung Terigu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    830,
    46339,
    "0627",
    "Tepung terigu",
    "060201000013",
    "Tepung Terigu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    831,
    46339,
    "0627",
    "Tepung terigu",
    "060201000013",
    "Tepung Terigu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    832,
    46319,
    "0627",
    "Tepung terigu",
    "060201000014",
    "Tepung Terigu Self-Raising",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    833,
    46319,
    "0627",
    "Tepung terigu",
    "060201000014",
    "Tepung Terigu Self-Raising",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    834,
    46339,
    "0627",
    "Tepung terigu",
    "060201000014",
    "Tepung Terigu Self-Raising",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    835,
    46339,
    "0627",
    "Tepung terigu",
    "060201000014",
    "Tepung Terigu Self-Raising",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    836,
    46319,
    "0627",
    "Tepung terigu",
    "060201000015",
    "Tepung Terigu Termodifikasi ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    837,
    46339,
    "0627",
    "Tepung terigu",
    "060201000015",
    "Tepung Terigu Termodifikasi ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    838,
    46319,
    "0627",
    "Tepung terigu",
    "060201000016",
    "Tepung Gluten Terigu (Wheat Gluten Powder)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    839,
    46339,
    "0627",
    "Tepung terigu",
    "060201000016",
    "Tepung Gluten Terigu (Wheat Gluten Powder)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    840,
    46319,
    "0627",
    "Tepung terigu",
    "060201000017",
    "Tepung Terigu dengan Penambahan Protein",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    841,
    46339,
    "0627",
    "Tepung terigu",
    "060201000017",
    "Tepung Terigu dengan Penambahan Protein",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    842,
    46319,
    "0625",
    "Tepung",
    "060201000018",
    "Tepung Terigu Utuh (Wholemeal Wheat Flour)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    843,
    46319,
    "0625",
    "Tepung",
    "060201000019",
    "Tepung Kulit Ari (Fine Bran)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    844,
    46319,
    "0625",
    "Tepung",
    "060201000019",
    "Tepung Kulit Ari (Fine Bran)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    845,
    46319,
    "0625",
    "Tepung",
    "060201000020",
    "Tepung Singkong",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    846,
    46319,
    "0625",
    "Tepung",
    "060201000021",
    "Tepung Mokaf",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    847,
    46319,
    "0625",
    "Tepung",
    "060201000021",
    "Tepung Mokaf",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    848,
    46319,
    "0625",
    "Tepung",
    "060201000021",
    "Tepung Mokaf",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    849,
    46319,
    "0625",
    "Tepung",
    "060201000022",
    "Tepung Gaplek",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    850,
    46319,
    "0625",
    "Tepung",
    "060201000023",
    "Tepung Umbi Lainnya (Tepung Kentang, Tepung Ubi Jalar, Tepung Garut, Tepung Ganyong dan lain-lain.)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    851,
    46319,
    "0625",
    "Tepung",
    "060201000024",
    "Tepung Aren",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    852,
    46319,
    "0625",
    "Tepung",
    "060201000025",
    "Kinako",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    853,
    46319,
    "0625",
    "Tepung",
    "060201000026",
    "Konjac Flour",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    854,
    46319,
    "0625",
    "Tepung",
    "060201000027",
    "Maida",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    855,
    46319,
    "0625",
    "Tepung",
    "060201000028",
    "Tepung Iles-iles",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    856,
    46339,
    "0625",
    "Tepung",
    "060201000029",
    "Tepung Kacang Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    857,
    46319,
    "0625",
    "Tepung",
    "060201000030",
    "Tepung Campur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    858,
    46319,
    "0625",
    "Tepung",
    "060201000031",
    "Tepung Kedelai Lemak Penuh/ Tepung Kedelai (Soybean Flour)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    859,
    46319,
    "0625",
    "Tepung",
    "060201000032",
    "Tepung kedelai yang telah dipisahkan lemaknya (deffated soy flour)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    860,
    46319,
    "0625",
    "Tepung",
    "060201000033",
    "Tepung Pragelatinisasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    861,
    46319,
    "0625",
    "Tepung",
    "060201000033",
    "Tepung Pragelatinisasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    862,
    46319,
    "0625",
    "Tepung",
    "060201000033",
    "Tepung Pragelatinisasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    863,
    46319,
    "0617",
    "Pati",
    "060202000001",
    "Pati Garut",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    864,
    46319,
    "0617",
    "Pati",
    "060202000002",
    "Pati Jagung atau Maizena",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    865,
    46319,
    "0617",
    "Pati",
    "060202000002",
    "Pati Jagung atau Maizena",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    866,
    46319,
    "0617",
    "Pati",
    "060202000003",
    "Pati Sagu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    867,
    46319,
    "0617",
    "Pati",
    "060202000003",
    "Pati Sagu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    868,
    46319,
    "0617",
    "Pati",
    "060202000004",
    "Pati Kacang Hijau/Hunkwee",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    869,
    46319,
    "0617",
    "Pati",
    "060202000004",
    "Pati Kacang Hijau/Hunkwee",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    870,
    46319,
    "0617",
    "Pati",
    "060202000005",
    "Tapioka/Pati Singkong/Pati Ubi Kayu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    871,
    46319,
    "0617",
    "Pati",
    "060202000005",
    "Tapioka/Pati Singkong/Pati Ubi Kayu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    872,
    46319,
    "0617",
    "Pati",
    "060202000005",
    "Tapioka/Pati Singkong/Pati Ubi Kayu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    873,
    46319,
    "0605",
    "Dekstrin",
    "060202000006",
    "Dekstrin",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    874,
    46319,
    "0605",
    "Dekstrin",
    "060202000006",
    "Dekstrin",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    875,
    46319,
    "0618",
    "Pati termodifikasi",
    "060202000007",
    "Pati Termodifikasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    876,
    46319,
    "0618",
    "Pati termodifikasi",
    "060202000007",
    "Pati Termodifikasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    877,
    46319,
    "0617",
    "Pati",
    "060202000008",
    "Pati Pragelatinisasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    878,
    46319,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000001",
    "Bulgur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    879,
    46319,
    "0602",
    "Biji-bijian dan kacang-kacangan (utuh, patahan, atau serpihan)",
    "060300000002",
    "Keping Jagung (Corn Flake)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    880,
    46319,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000003",
    "Meal",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    881,
    46319,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000004",
    "Meal Lembaga Gandum (Wheat Germ Meal)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    882,
    46319,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000005",
    "Oatmeal",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    883,
    46319,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000005",
    "Oatmeal",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    884,
    46319,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000006",
    "Whole Maize (Corn) Meal",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    885,
    46319,
    "0604",
    "Degermed maize",
    "060300000007",
    "Degermed Maize (Corn) Meal",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    886,
    46319,
    "0611",
    "Nasi jagung (dikeringkan)",
    "060300000008",
    "Nasi Jagung",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    887,
    46319,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000009",
    "Sereal Siap Santap",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    888,
    46319,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000010",
    "Sereal Siap Santap dengan Serealia Utuh (Whole Grain Ready To Eat Cereal)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    889,
    46319,
    "0610",
    "Minuman serbuk biji-bijian dan sereal",
    "060300000011",
    "Serbuk Minuman Sereal",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    890,
    46319,
    "0610",
    "Minuman serbuk biji-bijian dan sereal",
    "060300000011",
    "Serbuk Minuman Sereal",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    891,
    46319,
    "0628",
    "Tiwul",
    "060300000012",
    "Tiwul",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    892,
    46339,
    "0628",
    "Tiwul",
    "060300000012",
    "Tiwul",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    893,
    46319,
    "0604",
    "Degermed maize",
    "060300000013",
    "Degermed Maize (Corn) Grits",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    894,
    46319,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000014",
    "Gari",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    895,
    46319,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000015",
    "Granola",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    896,
    46319,
    "0610",
    "Minuman serbuk biji-bijian dan sereal",
    "060300000016",
    "Minuman Sereal/ Minuman Serealia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    897,
    46339,
    "0610",
    "Minuman serbuk biji-bijian dan sereal",
    "060300000016",
    "Minuman Sereal/ Minuman Serealia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    898,
    46339,
    "0610",
    "Minuman serbuk biji-bijian dan sereal",
    "060300000016",
    "Minuman Sereal/ Minuman Serealia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    899,
    46319,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000001",
    "Mi Basah Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    900,
    46319,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000002",
    "Mi Basah Mentah lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    901,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060401000003",
    "Kulit Pangsit/Risol/Lumpia  ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    902,
    46319,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000003",
    "Kulit Pangsit/Risol/Lumpia  ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    903,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060401000003",
    "Kulit Pangsit/Risol/Lumpia  ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    904,
    46319,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000003",
    "Kulit Pangsit/Risol/Lumpia  ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    905,
    46319,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    906,
    46319,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    907,
    46319,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    908,
    46319,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    909,
    46319,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    910,
    46319,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    911,
    46319,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    912,
    46319,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    913,
    46319,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    914,
    46319,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    915,
    46319,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    916,
    46319,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    917,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    918,
    46339,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    919,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    920,
    46339,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    921,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    922,
    46339,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    923,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    924,
    46339,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    925,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    926,
    46339,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    927,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    928,
    46339,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    929,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000001",
    "Kuetiaw Kering",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    930,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000002",
    "Pasta",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    931,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000003",
    "Pasta Gandum Utuh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    932,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000004",
    "Produk Pasta Gandum dan Kedelai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    933,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000005",
    "Produk Pasta Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    934,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000005",
    "Produk Pasta Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    935,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000006",
    "Pasta Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    936,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000007",
    "Produk Mi Gandum dan Kedelai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    937,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000008",
    "Produk Mi Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    938,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000008",
    "Produk Mi Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    939,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000001",
    "Sohun",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    940,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000002",
    "Sohun Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    941,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000003",
    "Bihun",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    942,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000004",
    "Bihun Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    943,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000005",
    "Pasta Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    944,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000006",
    "Pasta Instan Lainnya ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    945,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000007",
    "Mi Kering ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    946,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000008",
    "Bihun Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    947,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000009",
    "Kuetiaw Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    948,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000010",
    "Makaroni Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    949,
    46319,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000011",
    "Mi Basah Matang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    950,
    46319,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000012",
    "Mi Basah Matang Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    951,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000013",
    "Mi Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    952,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000014",
    "Mi Instan Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    953,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000015",
    "Mi Kering Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    954,
    46319,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000016",
    "Mi Soa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    955,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000017",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    956,
    46339,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000017",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    957,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000017",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    958,
    46339,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000017",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    959,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000017",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    960,
    46339,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000017",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    961,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000017",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    962,
    46339,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000017",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    963,
    46339,
    "0606",
    "Kerupuk mentah",
    "060403000018",
    "Kerupuk Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    964,
    46339,
    "0606",
    "Kerupuk mentah",
    "060403000018",
    "Kerupuk Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    965,
    46339,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000019",
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    966,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000019",
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    967,
    46339,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000019",
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    968,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000019",
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    969,
    46339,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000019",
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    970,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000019",
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    971,
    46339,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000019",
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    972,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000019",
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    973,
    46339,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000020",
    "Cilok",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    974,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000020",
    "Cilok",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    975,
    46339,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000020",
    "Cilok",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    976,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000020",
    "Cilok",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    977,
    46339,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000021",
    "Cireng/Cireng Isi",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    978,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000021",
    "Cireng/Cireng Isi",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    979,
    46339,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000021",
    "Cireng/Cireng Isi",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    980,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000021",
    "Cireng/Cireng Isi",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    981,
    46339,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000022",
    "Nasi Siap Saji",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    982,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000022",
    "Nasi Siap Saji",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    983,
    46319,
    "0639",
    "Pangan olahan lainnya yang diproses dan dikemas secara aseptik dengan pH>4,6",
    "060403000023",
    "Bubur Siap Saji Dalam Kemasan (khusus Steril Komersil)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    984,
    46339,
    "0639",
    "Pangan olahan lainnya yang diproses dan dikemas secara aseptik dengan pH>4,6",
    "060403000023",
    "Bubur Siap Saji Dalam Kemasan (khusus Steril Komersil)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    985,
    46339,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000024",
    "Butiran Tepung dan/atau Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    986,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000024",
    "Butiran Tepung dan/atau Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    987,
    46339,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000024",
    "Butiran Tepung dan/atau Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    988,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000024",
    "Butiran Tepung dan/atau Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    989,
    46339,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000025",
    "Olahan Tepung/Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    990,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000025",
    "Olahan Tepung/Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    991,
    46339,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000025",
    "Olahan Tepung/Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    992,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000025",
    "Olahan Tepung/Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    993,
    46319,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000026",
    "Pasta Basah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    994,
    46319,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000027",
    "Pasta Basah Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    995,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000028",
    "Olahan Tepung/Pati Siap Konsumsi (Latiao dan Produk Sejenis)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    996,
    46319,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000001",
    "Tepung Custard Tanpa Telur (Eggless Custard)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    997,
    46319,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    998,
    46319,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    999,
    46319,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1000,
    46319,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1001,
    46319,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1002,
    46319,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1003,
    46319,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1004,
    46319,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1005,
    46339,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1006,
    46339,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1007,
    46339,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1008,
    46339,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1009,
    46339,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1010,
    46339,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1011,
    46339,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1012,
    46339,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1013,
    46319,
    "0619",
    "Premiks bentuk bubuk (termasuk pada kategori pangan 1, 5, 6, 7, 10, dan 14)",
    "060500000003",
    "Premiks Untuk Makanan Pencuci Mulut Berbasis Serealia dan Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1014,
    46319,
    "0626",
    "Tepung adonan",
    "060600000001",
    "Tepung Pelapis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1015,
    46339,
    "0626",
    "Tepung adonan",
    "060600000001",
    "Tepung Pelapis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1016,
    46319,
    "0626",
    "Tepung adonan",
    "060600000002",
    "Tepung Bumbu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1017,
    46339,
    "0626",
    "Tepung adonan",
    "060600000002",
    "Tepung Bumbu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1018,
    46319,
    "0626",
    "Tepung adonan",
    "060600000003",
    "Tepung Bakwan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1019,
    46339,
    "0626",
    "Tepung adonan",
    "060600000003",
    "Tepung Bakwan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1020,
    46319,
    "0626",
    "Tepung adonan",
    "060600000004",
    "Tepung Bakso",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1021,
    46339,
    "0626",
    "Tepung adonan",
    "060600000004",
    "Tepung Bakso",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1022,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000001",
    "Dodol/Jenang/Gelamai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1023,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000001",
    "Dodol/Jenang/Gelamai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1024,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000001",
    "Dodol/Jenang/Gelamai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1025,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000002",
    "Wajik/Wajit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1026,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000002",
    "Wajik/Wajit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1027,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000003",
    "Kue Mochi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1028,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000003",
    "Kue Mochi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1029,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000004",
    "Kue Teuck/Tteok",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1030,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000004",
    "Kue Teuck/Tteok",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1031,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000005",
    "Nagasari/Kue Pisang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1032,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000005",
    "Nagasari/Kue Pisang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1033,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000006",
    "Putu Ayu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1034,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000006",
    "Putu Ayu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1035,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000007",
    "Kue Mangkok",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1036,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000007",
    "Kue Mangkok",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1037,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000008",
    "Jongkong Kelapa Muda",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1038,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000008",
    "Jongkong Kelapa Muda",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1039,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000008",
    "Jongkong Kelapa Muda",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1040,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000009",
    "Talam Ebi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1041,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000009",
    "Talam Ebi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1042,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000010",
    "Kue Lapis Beras",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1043,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000010",
    "Kue Lapis Beras",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1044,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000011",
    "Juadah Kering/Mayang Papan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1045,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000011",
    "Juadah Kering/Mayang Papan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1046,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000012",
    "Petah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1047,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000012",
    "Petah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1048,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000013",
    "Amparan Tatak Pisang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1049,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000013",
    "Amparan Tatak Pisang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1050,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000014",
    "Lampu-Lampu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1051,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000014",
    "Lampu-Lampu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1052,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000015",
    "Pisang Hijau",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1053,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000015",
    "Pisang Hijau",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1054,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000016",
    "Temo Coe",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1055,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000016",
    "Temo Coe",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1056,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000017",
    "Lemper Ayam",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1057,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000017",
    "Lemper Ayam",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1058,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000018",
    "Semar Mendem",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1059,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000018",
    "Semar Mendem",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1060,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000019",
    "Jadah Manten",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1061,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000019",
    "Jadah Manten",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1062,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000020",
    "Lepet Ketan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1063,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000020",
    "Lepet Ketan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1064,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000021",
    "Kue Ku",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1065,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000021",
    "Kue Ku",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1066,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000022",
    "Legondo",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1067,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000022",
    "Legondo",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1068,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000023",
    "Onde-Onde",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1069,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000023",
    "Onde-Onde",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1070,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000024",
    "Seri Muka",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1071,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000024",
    "Seri Muka",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1072,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000025",
    "Kekicak/Gegicak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1073,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000025",
    "Kekicak/Gegicak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1074,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000026",
    "Lalampa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1075,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000026",
    "Lalampa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1076,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000027",
    "Katrisolo",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1077,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000027",
    "Katrisolo",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1078,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000028",
    "Lapek Bugis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1079,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000028",
    "Lapek Bugis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1080,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000029",
    "Lamang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1081,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000029",
    "Lamang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1082,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000030",
    "Ombus-ombus",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1083,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000030",
    "Ombus-ombus",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1084,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000031",
    "Legomoro",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1085,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000031",
    "Legomoro",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1086,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000032",
    "Kue Berbahan Dasar Beras Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1087,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000032",
    "Kue Berbahan Dasar Beras Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1088,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000033",
    "Brem Padat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1089,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060700000034",
    "Nasi Siap konsumsi/Siap Santap/Siap Saji",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1090,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060700000035",
    "Bubur Beras Siap Konsumsi/Siap Santap/Siap Saji",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1091,
    46339,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060700000035",
    "Bubur Beras Siap Konsumsi/Siap Santap/Siap Saji",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1092,
    46339,
    "0607",
    "Kue berbahan dasar beras",
    "060700000036",
    "Tape Ketan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1093,
    46339,
    "0609",
    "Minuman kedelai",
    "060801000001",
    "Sari Kedelai ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1094,
    46339,
    "0609",
    "Minuman kedelai",
    "060801000001",
    "Sari Kedelai ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1095,
    46339,
    "0610",
    "Minuman serbuk biji-bijian dan sereal",
    "060801000002",
    "Serbuk Minuman Kedelai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1096,
    46339,
    "0609",
    "Minuman kedelai",
    "060801000003",
    "Konsentrat Sari Kedelai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1097,
    46339,
    "0609",
    "Minuman kedelai",
    "060801000004",
    "Sari Kedelai Fermentasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1098,
    46339,
    "0609",
    "Minuman kedelai",
    "060801000004",
    "Sari Kedelai Fermentasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1099,
    46319,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060802000001",
    "Lapisan Tipis Cairan Kedelai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1100,
    46319,
    "0623",
    "Tahu segar",
    "060803000001",
    "Tahu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1101,
    46339,
    "0623",
    "Tahu segar",
    "060803000001",
    "Tahu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1102,
    46339,
    "0624",
    "Tahu semi-kering",
    "060804000001",
    "Tahu Semi-Kering",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1103,
    46319,
    "0624",
    "Tahu semi-kering",
    "060804010001",
    "Tahu Semi-Kering yang Diolah Dengan Saus Kental",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1104,
    46339,
    "0624",
    "Tahu semi-kering",
    "060804010001",
    "Tahu Semi-Kering yang Diolah Dengan Saus Kental",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1105,
    46339,
    "0624",
    "Tahu semi-kering",
    "060804020001",
    "Tahu Semi-Kering yang Digoreng Dengan Minyak Banyak (DeepFried)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1106,
    46339,
    "0624",
    "Tahu semi-kering",
    "060804030001",
    "Tahu Semi-Kering, Selain Dari Kategori 0608040001 dan 0608040002",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1107,
    46319,
    "0622",
    "Tahu kering",
    "060805000001",
    "Tahu Kering",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1108,
    46319,
    "0622",
    "Tahu kering",
    "060805000001",
    "Tahu Kering",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1109,
    46339,
    "0620",
    "Produk kedelai fermentasi",
    "060806000001",
    "Dou chi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1110,
    46339,
    "0620",
    "Produk kedelai fermentasi",
    "060806000002",
    "Natto",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1111,
    46339,
    "0620",
    "Produk kedelai fermentasi",
    "060806000003",
    "Tempe",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1112,
    46339,
    "0620",
    "Produk kedelai fermentasi",
    "060806000004",
    "Tauco",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    1113,
    46339,
    "0620",
    "Produk kedelai fermentasi",
    "060806000005",
    "Abon Tempe",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1114,
    46339,
    "0620",
    "Produk kedelai fermentasi",
    "060806000005",
    "Abon Tempe",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1115,
    46339,
    "0620",
    "Produk kedelai fermentasi",
    "060806000006",
    "Oncom Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1116,
    46339,
    "0620",
    "Produk kedelai fermentasi",
    "060806000006",
    "Oncom Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1117,
    46339,
    "0620",
    "Produk kedelai fermentasi",
    "060807000001",
    "Tahu Fermentasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1118,
    46339,
    "0621",
    "Produk protein kedelai lainnya",
    "060808000001",
    "Produk Protein Kedelai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1119,
    46339,
    "0621",
    "Produk protein kedelai lainnya",
    "060808000001",
    "Produk Protein Kedelai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1120,
    46339,
    "0621",
    "Produk protein kedelai lainnya",
    "060808000002",
    "Texturized Vegetable Protein (TVP)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1121,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010001",
    "Roti Tawar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1122,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010002",
    "Roti Tawar Dengan Penambahan Bahan Pangan Lain",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1123,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010003",
    "Roti Tawar Kupas",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1124,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010004",
    "Roti Rye",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1125,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010005",
    "Roti Pumpernickel",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1126,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010006",
    "Roti Buah/Roti Kismis/Roti Chocochips",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1127,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010007",
    "Roti Gandum Utuh (Whole Wheat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1128,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010008",
    "Roti Campuran Tepung Terigu dan Kulit Gandum/Roti dengan Kulit Gandum (Fine Bran)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1129,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010009",
    "Roti Perancis (Baguette/pain courant francais)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1130,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010010",
    "Roti Malt",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1131,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010011",
    "Roti Kadet",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1132,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010012",
    "Roti Kadet Gandum",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1133,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010013",
    "Roti Kadet Susu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1134,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010014",
    "Roti Wheat-Germ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1135,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010015",
    "Roti Meal",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1136,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010016",
    "Roti Meal Utuh (Whole Meal)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1137,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010017",
    "Roti Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1138,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101020001",
    "Roti Soda",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1139,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070102000001",
    "Krekers",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1140,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070102000002",
    "Krekers Krim",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1141,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070102000003",
    "Water Biscuit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1142,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070102000004",
    "Krekers Soda",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1143,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070103000001",
    "Shortened Bread",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1144,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070103000002",
    "Bagel",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1145,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070103000003",
    "Roti Pita",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1146,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070103000004",
    "Muffin Inggris (English Muffin)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1147,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070103000005",
    "Roti Canai/Roti Cane/Roti Kane/Roti Kanai/Roti Maryam",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1148,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070103000006",
    "Roti Jala",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1149,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070103000007",
    "Roti Tortila/ Kulit Tortila/ Tortilla Wraps",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1150,
    46332,
    "0704",
    "Produk serupa roti termasuk roti untuk isi (stuffing) dan tepung roti, tepung panir",
    "070104000001",
    "Crouton",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1151,
    46339,
    "0704",
    "Produk serupa roti termasuk roti untuk isi (stuffing) dan tepung roti, tepung panir",
    "070104000002",
    "Tepung Panir",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1152,
    46339,
    "0704",
    "Produk serupa roti termasuk roti untuk isi (stuffing) dan tepung roti, tepung panir",
    "070104000003",
    "Tepung Roti/Bread Crumb",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1153,
    46339,
    "0704",
    "Produk serupa roti termasuk roti untuk isi (stuffing) dan tepung roti, tepung panir",
    "070104000003",
    "Tepung Roti/Bread Crumb",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1154,
    46332,
    "0704",
    "Produk serupa roti termasuk roti untuk isi (stuffing) dan tepung roti, tepung panir",
    "070104000004",
    "Roti Untuk Stuffing",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1155,
    46339,
    "0704",
    "Produk serupa roti termasuk roti untuk isi (stuffing) dan tepung roti, tepung panir",
    "070104000005",
    "Premiks Untuk Stuffing",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1156,
    46339,
    "0704",
    "Produk serupa roti termasuk roti untuk isi (stuffing) dan tepung roti, tepung panir",
    "070104000006",
    "Adonan Shortened Bread",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1157,
    46332,
    "0702",
    "Pangan kategori 7 risiko sedang lainnya",
    "070105000001",
    "Mantao",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1158,
    46332,
    "0702",
    "Pangan kategori 7 risiko sedang lainnya",
    "070105000001",
    "Mantao",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1159,
    46332,
    "0702",
    "Pangan kategori 7 risiko sedang lainnya",
    "070105000002",
    "Bakpao/Pao",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1160,
    46332,
    "0702",
    "Pangan kategori 7 risiko sedang lainnya",
    "070105000002",
    "Bakpao/Pao",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1161,
    46332,
    "0702",
    "Pangan kategori 7 risiko sedang lainnya",
    "070105000003",
    "Apem",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1162,
    46332,
    "0702",
    "Pangan kategori 7 risiko sedang lainnya",
    "070105000004",
    "Kue Mangkok",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1163,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070105000005",
    "Bun Kukus",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1164,
    46339,
    "0701",
    "Pangan kategori 7 risiko rendah lainnya",
    "070106000001",
    "Premiks Untuk Roti Tawar dan Produk Bakeri Tawar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1165,
    46339,
    "0701",
    "Pangan kategori 7 risiko rendah lainnya",
    "070106000001",
    "Premiks Untuk Roti Tawar dan Produk Bakeri Tawar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1166,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000001",
    "Keik (Cake)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1167,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000001",
    "Keik (Cake)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1168,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000002",
    "Keik Mentega (Butter Cake)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1169,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000002",
    "Keik Mentega (Butter Cake)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1170,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000003",
    "Keik Keju (Cheese Cake)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1171,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000003",
    "Keik Keju (Cheese Cake)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1172,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000004",
    "Keik Pound (Pound Cake atau Quatre Quarts)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1173,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000004",
    "Keik Pound (Pound Cake atau Quatre Quarts)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1174,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000005",
    "Brownies",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1175,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000006",
    "Biskuit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1176,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000006",
    "Biskuit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1177,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000007",
    "Biskuit Non Terigu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1178,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000007",
    "Biskuit Non Terigu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1179,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000008",
    "Biskuit Marie",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1180,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000008",
    "Biskuit Marie",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1181,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000009",
    "Biskuit Marie Salut",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1182,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000009",
    "Biskuit Marie Salut",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1183,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000010",
    "Biskuit Lapis/Biskuit Sandwich",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1184,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000010",
    "Biskuit Lapis/Biskuit Sandwich",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1185,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000011",
    "Biskuit Colek",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1186,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000011",
    "Biskuit Colek",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1187,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000012",
    "Kukis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1188,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000013",
    "Kukis Lunak (Soft Cookies)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1189,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000014",
    "Kukis Gula",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1190,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000015",
    "Kukis Oatmeal",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1191,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000016",
    "Nastar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1192,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000017",
    "Kastengel",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1193,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000018",
    "Wafer",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1194,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000019",
    "Wafer Roll/Wafer Stick",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1195,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000020",
    "Wafer Salut",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1196,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000021",
    "Pai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1197,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000022",
    "Pai Isi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1198,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000023",
    "Bolu Kukus",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1199,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000024",
    "Bika Ambon",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1200,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000025",
    "Egg Roll",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1201,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000026",
    "Biskuit Bar Sereal Isi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1202,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000026",
    "Biskuit Bar Sereal Isi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1203,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000027",
    "Crepes",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1204,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000028",
    "Roti Bagelen",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1205,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000029",
    "Kue Semprong/Kapit/Gapit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1206,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000001",
    "Pastri",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1207,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000002",
    "Roti Manis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1208,
    46332,
    "0705",
    "Adonan/produk bakeri beku",
    "070202000002",
    "Roti Manis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1209,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000002",
    "Roti Manis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1210,
    46332,
    "0705",
    "Adonan/produk bakeri beku",
    "070202000002",
    "Roti Manis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1211,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000003",
    "Roti Isi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1212,
    46332,
    "0705",
    "Adonan/produk bakeri beku",
    "070202000003",
    "Roti Isi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1213,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000003",
    "Roti Isi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1214,
    46332,
    "0705",
    "Adonan/produk bakeri beku",
    "070202000003",
    "Roti Isi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1215,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000004",
    "Scone",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1216,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000005",
    "Donat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1217,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000005",
    "Donat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1218,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000006",
    "Muffin Amerika (American Muffin)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1219,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000007",
    "Roti Buaya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1220,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000008",
    "Kue Tambang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1221,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000009",
    "Wafel",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1222,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000010",
    "Stroopwafel",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1223,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000011",
    "Cone untuk Es Krim",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1224,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000012",
    "Panekuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1225,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000012",
    "Panekuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1226,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000013",
    "Bakpia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1227,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000013",
    "Bakpia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1228,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000014",
    "Bolu Emprit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1229,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000015",
    "Remahan Biskuit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1230,
    46339,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000015",
    "Remahan Biskuit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1231,
    46332,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000017",
    "Piza/Pizza",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1232,
    46339,
    "0701",
    "Pangan kategori 7 risiko rendah lainnya",
    "070203000001",
    "Premiks Untuk Produk Bakeri Istimewa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1233,
    46339,
    "0701",
    "Pangan kategori 7 risiko rendah lainnya",
    "070203000001",
    "Premiks Untuk Produk Bakeri Istimewa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1234,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000001",
    "Karkas Hewan Mamalia",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1235,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000002",
    "Karkas Sapi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1236,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000003",
    "Karkas Paruh Sapi (Half Carcass)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1237,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000004",
    "Karkas Perempat Sapi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1238,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000005",
    "Seperempat Karkas Bagian Belakang/Karkas Bagian Paha (Hind Quarter/Leg Quarter)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1239,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000006",
    "Forequarter",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1240,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000007",
    "Hindquarter",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1241,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000008",
    "Forequarter dan Hindquarter",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1242,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000009",
    "Tulang Iga Pendek (Short Ribs)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1243,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000010",
    "Tulang Iga Utama (Prime Rib)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1244,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000011",
    "Karkas Kerbau",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1245,
    46323,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000012",
    "Karkas Kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1246,
    46323,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000013",
    "Karkas Paruh Depan dan Karkas Paruh Belakang Kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1247,
    46323,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000014",
    "Karkas Paruh Kiri dan Karkas Paruh Kanan Kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1248,
    46323,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000015",
    "Karkas Perempat Kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1249,
    46323,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000016",
    "Leg kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1250,
    46323,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000017",
    "Shoulder Kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1251,
    46323,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000018",
    "Karkas Babi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1252,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000019",
    "Bagian Mamalia Non Karkas",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1253,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000020",
    "Offal",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1254,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000021",
    "Jeroan",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1255,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000022",
    "Rack",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1256,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000023",
    "Breast",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1257,
    46323,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000024",
    "Foreshank Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1258,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000025",
    "Karkas Ayam",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1259,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000026",
    "Separuh Karkas (Half Poultry)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1260,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000027",
    "Seperempat Karkas Bagian Depan/Karkas Bagian Dada (Front Quarter/Breast Quarter)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1261,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000028",
    "Seperempat Karkas Bagian Belakang/Karkas Bagian Paha (Hind Quarter/ Leg Quarter)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1262,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000029",
    "Punggung Utuh (Whole Back)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1263,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000030",
    "Ekor (Brutu)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1264,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000031",
    "Punggung (Back)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1265,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000032",
    "Punggung Terkupas (Stripped Back)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1266,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000033",
    "Dada Utuh (Full Breast)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1267,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000034",
    "Dada Depan (Wishbone)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1268,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000035",
    "Dada Hasil Trimming (Trimmed Breast)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1269,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000036",
    "Separuh Dada Hasil Trimming (Half Trimmed Breast)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1270,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000037",
    "Sayap (Wing)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1271,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000038",
    "Sayap Atas (Wing Drumette)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1272,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000039",
    "Sayap Bawah (Winglet atau V-Wing)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1273,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000040",
    "Paha (Leg) Unggas",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1274,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000041",
    "Paha Atas (Thigh)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1275,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000042",
    "Paha Bawah (Drumstick)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1276,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000043",
    "Bagian Unggas Non Karkas",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1277,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000044",
    "Kepala",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1278,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000045",
    "Leher",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1279,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000046",
    "Kaki atau Cakar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1280,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000047",
    "Jeroan Unggas (Poultry Giblets)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1281,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000048",
    "Daging",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1282,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000049",
    "Daging Dingin",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1283,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000050",
    "Daging Beku",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1284,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000051",
    "Steik (Steaks) Daging Sapi Beku",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1285,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000052",
    "Daging Sapi/Kerbau",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1286,
    46323,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000053",
    "Daging Kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1287,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000054",
    "Daging Iga (Rib Meat)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1288,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000055",
    "Jenis Potongan Bagian Daging",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1289,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000056",
    "Lamusir (Rib Eye)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1290,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000057",
    "Lamusir (Cuberoll)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1291,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000058",
    "Sandung Lamur (Brisket)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1292,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000059",
    "Sengkel (Shin dan Shank)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1293,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000060",
    "Sengkel (Shank/Foreshank)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1294,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000061",
    "Samcan (Thin Flank)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1295,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000062",
    "Flank",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1296,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000063",
    "Has Dalam (Tenderloin)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1297,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000064",
    "Has Luar (Striploin/Sirloin)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1298,
    46323,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000065",
    "Has (Tenderloin) Kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1299,
    46323,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000066",
    "Loin Kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1300,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000067",
    "Penutup (Top side)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1301,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000068",
    "Pendasar (Riverside)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1302,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000069",
    "Gandik (Eye Round)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1303,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000070",
    "Tanjung (Rump)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1304,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000071",
    "Kelapa (Round)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1305,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000072",
    "Kijen (Chuck Tender)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1306,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000073",
    "Sampil Besar (Chuck)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1307,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000074",
    "Sampil Kecil (Blade)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1308,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000075",
    "Daging Tanpa Tulang yang Dijual dalam Bentuk Kemasan Besar (Bulk Pack)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1309,
    46321,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000076",
    "Tetelan",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1310,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000077",
    "Potongan Daging Unggas",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1311,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080101000078",
    "Filet Dada (Breast Fillet)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1312,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080101000079",
    "Lemak",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1313,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080102000001",
    "Patties",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1314,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080102000002",
    "Sosis Mentah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1315,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080102000003",
    "Sosis Mentah Daging Babi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1316,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080102000004",
    "Daging Cincang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1317,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080102000005",
    "Daging Giling",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1318,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080102000006",
    "Daging Murni Giling Tanpa Lemak",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1319,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080102000007",
    "Potongan Daging Unggas dan Daging Hewan Buruan yang Dilepaskan dari Tulangnya, Digiling Mekanik dan Dibentuk (Dengan atau Tanpa Pembaluran atau Pelapisan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1320,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080102000008",
    "Mechanically Deboned Meat (MDM)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1321,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080102000009",
    "Desinewed Minced Meat (DMM)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1322,
    46323,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010001",
    "Bacon",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1323,
    46321,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010002",
    "Bacon Sapi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1324,
    46321,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010003",
    "Daging Marinasi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1325,
    46321,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010004",
    "Daging Sapi yang Dimarinasi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1326,
    46322,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010005",
    "Daging Ayam yang Dimarinasi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1327,
    46321,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1328,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1329,
    46321,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1330,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1331,
    46321,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1332,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1333,
    46321,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1334,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1335,
    46322,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1336,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1337,
    46322,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1338,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1339,
    46323,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1340,
    46323,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1341,
    46323,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1342,
    46323,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1343,
    46321,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010007",
    "Daging Sei",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1344,
    46323,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201020001",
    "Daging Paha Babi Curing Mentah",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1345,
    46321,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201020002",
    "Dendeng Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1346,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080201030001",
    "Daging Sapi yang Difermentasi Dalam Wadah Keramik (Potted Beef)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1347,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080201030002",
    "Daging Cangkuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1348,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080202000001",
    "Daging Paha Babi Curing Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1349,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080202000001",
    "Daging Paha Babi Curing Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1350,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080202000002",
    "Ham Sapi (Daging Paha Sapi Curing) Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1351,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080202000002",
    "Ham Sapi (Daging Paha Sapi Curing) Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1352,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080202000003",
    "Bahu Babi Curing Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1353,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080202000003",
    "Bahu Babi Curing Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1354,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080202000004",
    "Bahu Sapi Curing Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1355,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080202000004",
    "Bahu Sapi Curing Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1356,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080202000005",
    "Daging Olahan Berbumbu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1357,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080202000005",
    "Daging Olahan Berbumbu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1358,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080202000006",
    "Daging Kuah dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1359,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080202000006",
    "Daging Kuah dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1360,
    46321,
    "0801",
    "Daging dalam Kaleng",
    "080202000007",
    "Daging dalam Kaleng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1361,
    46321,
    "0801",
    "Daging dalam Kaleng",
    "080202000007",
    "Daging dalam Kaleng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1362,
    46321,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000008",
    "Abon Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1363,
    46321,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000008",
    "Abon Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1364,
    46321,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000009",
    "Kerupuk4  Kulit/Rambak",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1365,
    46321,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000009",
    "Kerupuk4  Kulit/Rambak",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1366,
    46321,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000010",
    "Keripik3 Paru",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1367,
    46321,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000010",
    "Keripik3 Paru",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1368,
    46321,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000011",
    "Kerupuk4 Berbasis Daging, Daging Unggas dan Daging Hewan Buruan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1369,
    46322,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000012",
    "Usus Ayam Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1370,
    46322,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000012",
    "Usus Ayam Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1371,
    46321,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000013",
    "Foie Gras and Pates",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1372,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080203000001",
    "Ayam Katsu (Chicken Katsu)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1373,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080203000001",
    "Ayam Katsu (Chicken Katsu)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1374,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080203000002",
    "Ayam Karage (Chicken Karage)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1375,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080203000002",
    "Ayam Karage (Chicken Karage)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1376,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080203000003",
    "Ayam Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1377,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080203000003",
    "Ayam Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1378,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080203000004",
    "Daging Marinasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1379,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080203000004",
    "Daging Marinasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1380,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080203000005",
    "Chicken Strip Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1381,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080203000005",
    "Chicken Strip Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1382,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080203000006",
    "Ayam Cordon Bleu (Chicken Cordon Bleu)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1383,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080203000006",
    "Ayam Cordon Bleu (Chicken Cordon Bleu)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1384,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080203000007",
    "Kulit Ayam Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1385,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080203000007",
    "Kulit Ayam Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1386,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080203000008",
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1387,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080203000008",
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1388,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1389,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1390,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1391,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1392,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1393,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1394,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1395,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1396,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1397,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1398,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1399,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1400,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1401,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1402,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1403,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1404,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1405,
    46323,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1406,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1407,
    46323,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1408,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1409,
    46323,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1410,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1411,
    46323,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1412,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080301010001",
    "Sosis Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1413,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080301010001",
    "Sosis Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1414,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080301010001",
    "Sosis Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1415,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080301010001",
    "Sosis Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1416,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080301010002",
    "Sosis Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1417,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080301010002",
    "Sosis Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1418,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080301010002",
    "Sosis Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1419,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080301010002",
    "Sosis Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1420,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080301010003",
    "Kornet Daging Non Sterilisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1421,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080301010004",
    "Urutan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1422,
    46321,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080301020001",
    "Sosis Cina (Termasuk Sosis Tradisional yang Dicuring atau Diasap) atau LupCheong",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1423,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080301030001",
    "Salami",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1424,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080301030002",
    "Chorizos",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1425,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000001",
    "Pate Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1426,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000001",
    "Pate Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1427,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000002",
    "Bakso Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1428,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080302000002",
    "Bakso Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1429,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000002",
    "Bakso Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1430,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080302000002",
    "Bakso Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1431,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000003",
    "Daging Cincang Olahan Berbumbu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1432,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000003",
    "Daging Cincang Olahan Berbumbu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1433,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000004",
    "Patties Daging Panggang Setengah Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1434,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000005",
    "Brawn and Head Cheese",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1435,
    46321,
    "0802",
    "Kornet Daging Sterilisasi",
    "080302000006",
    "Kornet Daging Sterilisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1436,
    46321,
    "0802",
    "Kornet Daging Sterilisasi",
    "080302000006",
    "Kornet Daging Sterilisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1437,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000007",
    "Daging Luncheon Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1438,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000007",
    "Daging Luncheon Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1439,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000008",
    "Pasta Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1440,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000009",
    "Salami Matang / Pepperoni Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1441,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000009",
    "Salami Matang / Pepperoni Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1442,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000010",
    "Sosis Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1443,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080302000010",
    "Sosis Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1444,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000010",
    "Sosis Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1445,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080302000010",
    "Sosis Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1446,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000011",
    "Sosis Daging Non Casing",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1447,
    46321,
    "0807",
    "Sosis Daging Siap Makan",
    "080302000012",
    "Sosis Daging Siap Makan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1448,
    46321,
    "0807",
    "Sosis Daging Siap Makan",
    "080302000012",
    "Sosis Daging Siap Makan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1449,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000013",
    "Terrines (Campuran Cacahan Daging Matang)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1450,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000013",
    "Terrines (Campuran Cacahan Daging Matang)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1451,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000014",
    "Rolade Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1452,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000014",
    "Rolade Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1453,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000015",
    "Daging Halus Olahan Berbumbu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1454,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000015",
    "Daging Halus Olahan Berbumbu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1455,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000016",
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1456,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000016",
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1457,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000017",
    "Dendeng Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1458,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000017",
    "Dendeng Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1459,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000018",
    "Pepperoni",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1460,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000018",
    "Pepperoni",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1461,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080302000018",
    "Pepperoni",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1462,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080302000018",
    "Pepperoni",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1463,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080302000018",
    "Pepperoni",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1464,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080302000018",
    "Pepperoni",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1465,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000019",
    "Tahu Bakso",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1466,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000019",
    "Tahu Bakso",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1467,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080302000019",
    "Tahu Bakso",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1468,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080302000019",
    "Tahu Bakso",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1469,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080302000019",
    "Tahu Bakso",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1470,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080302000019",
    "Tahu Bakso",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1471,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000020",
    "Sosis Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1472,
    46321,
    "0807",
    "Sosis Daging Siap Makan",
    "080302000020",
    "Sosis Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1473,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000020",
    "Sosis Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1474,
    46321,
    "0807",
    "Sosis Daging Siap Makan",
    "080302000020",
    "Sosis Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1475,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000020",
    "Sosis Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1476,
    46321,
    "0807",
    "Sosis Daging Siap Makan",
    "080302000020",
    "Sosis Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1477,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080302000020",
    "Sosis Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1478,
    46321,
    "0807",
    "Sosis Daging Siap Makan",
    "080302000020",
    "Sosis Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1479,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080302000021",
    "Bakso Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1480,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1481,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1482,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1483,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1484,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1485,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1486,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1487,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1488,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1489,
    46323,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1490,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1491,
    46323,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1492,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1493,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1494,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1495,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1496,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1497,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1498,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1499,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1500,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1501,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1502,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1503,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1504,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1505,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1506,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1507,
    46322,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1508,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1509,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1510,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080303000003",
    "Kornet Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1511,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080303000004",
    "Naget Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1512,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080303000004",
    "Naget Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1513,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000005",
    "Smoked Chicken Breast (Daging Dada Ayam Asap)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1514,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1515,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1516,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1517,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1518,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1519,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1520,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1521,
    46321,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1522,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1523,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1524,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1525,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1526,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1527,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1528,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1529,
    46322,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1530,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1531,
    46323,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1532,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1533,
    46323,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1534,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1535,
    46323,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1536,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1537,
    46323,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1538,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080303000007",
    "Gyoza",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1539,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080303000007",
    "Gyoza",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1540,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080303000008",
    "Swikiau/Kuotieh Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1541,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080303000008",
    "Swikiau/Kuotieh Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1542,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000009",
    "Ebi Katsu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1543,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000009",
    "Ebi Katsu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1544,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000010",
    "Keecho/Heecho",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1545,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000010",
    "Keecho/Heecho",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1546,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000011",
    "Telur Bungkus Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1547,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000011",
    "Telur Bungkus Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1548,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080303000012",
    "Bakso Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1549,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080303000012",
    "Bakso Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1550,
    46321,
    "0806",
    "Produk olahan daging lainnya",
    "080303000013",
    "Tahu Bakso Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1551,
    46322,
    "0806",
    "Produk olahan daging lainnya",
    "080303000013",
    "Tahu Bakso Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1552,
    46323,
    "0806",
    "Produk olahan daging lainnya",
    "080303000013",
    "Tahu Bakso Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1553,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090101000001",
    "Ikan Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1554,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090101000002",
    "Sashimi Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1555,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090101000003",
    "Tuna Loin Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1556,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090101000004",
    "Fillet Ikan Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1557,
    46329,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090101000005",
    "Ikan Hidup untuk Konsumsi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1558,
    46329,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090101000005",
    "Ikan Hidup untuk Konsumsi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1559,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090101000006",
    "Bandeng Segar Cabut Tulang dan Duri",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1560,
    46329,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000001",
    "Keong Hidup",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1561,
    46329,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000002",
    "Kerang Hidup",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1562,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000003",
    "Kerang Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1563,
    46329,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000004",
    "Tiram Hidup",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1564,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000005",
    "Bulu Babi Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1565,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000006",
    "Cumi-cumi Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1566,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000007",
    "Rajungan Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1567,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000008",
    "Teripang Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1568,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000009",
    "Udang Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1569,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000010",
    "Kepiting Hidup untuk Konsumsi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1570,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000011",
    "Lobster dan Udang Kipas Hidup Untuk Konsumsi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1571,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090201000001",
    "Sidat Panggang Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1572,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090201000001",
    "Sidat Panggang Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1573,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090201000002",
    "Pempek Ikan Rebus Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1574,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090201000003",
    "Bakso Ikan Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1575,
    46324,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090201000003",
    "Bakso Ikan Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1576,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090201000003",
    "Bakso Ikan Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1577,
    46324,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090201000003",
    "Bakso Ikan Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1578,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090201000004",
    "Cumi-Cumi / Kerang / Ikan / ... Beku dengan Penambahan Bahan Pangan Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1579,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090201000005",
    "Telur ikan beku dengan penambahan bahan pangan lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1580,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090201000006",
    "Tahu Bakso Ikan Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1581,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090202000004",
    "Stik, Filet,dan Lumatan Daging Ikan Berlapis Tepung Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1582,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090202000004",
    "Stik, Filet,dan Lumatan Daging Ikan Berlapis Tepung Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1583,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090202000005",
    "Udang Berlapis Tepung (Breaded) Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1584,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090202000006",
    "Naget Ikan/Udang/Cumi/Kerang Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1585,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090202000006",
    "Naget Ikan/Udang/Cumi/Kerang Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1586,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010001",
    "Ikan dan Produk Ikan Kukus atau Rebus",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1587,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010002",
    "Ikan Pindang Air Garam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1588,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010003",
    "Ikan Pindang Garam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1589,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010004",
    "Bandeng Presto",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1590,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010004",
    "Bandeng Presto",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1591,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010005",
    "Kue Ikan/Kamaboko/Fish Cake (rebus atau kukus)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1592,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010006",
    "Bakwan Ikan (Rebus Atau Kukus)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1593,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010007",
    "Stik Kepiting Analog atau Imitation Crab Stick",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1594,
    46329,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010007",
    "Stik Kepiting Analog atau Imitation Crab Stick",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1595,
    46339,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010007",
    "Stik Kepiting Analog atau Imitation Crab Stick",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1596,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010008",
    "Bakso Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1597,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010009",
    "Otak-Otak Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1598,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010010",
    "Bandeng Isi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1599,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010010",
    "Bandeng Isi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1600,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010011",
    "Dimsum Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1601,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010012",
    "Pempek Ikan (Rebus)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1602,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010013",
    "Tekwan Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1603,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010014",
    "Pepes Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1604,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010014",
    "Pepes Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1605,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010015",
    "Sosis Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1606,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010016",
    "Sosis Ikan Kombinasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1607,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010017",
    "Rolade Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1608,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010018",
    "Burger Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1609,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010019",
    "Tsukudani",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1610,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010020",
    "Telur Ikan Masak",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1611,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010021",
    "Olahan Ikan Berbumbu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1612,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010021",
    "Olahan Ikan Berbumbu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1613,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010022",
    "Tahu Bakso Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1614,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204020001",
    "Kue Cumi/Sotong/Udang Kukus",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1615,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204020002",
    "Dimsum Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1616,
    46324,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090204020002",
    "Dimsum Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1617,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204020002",
    "Dimsum Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1618,
    46324,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090204020002",
    "Dimsum Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1619,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204020002",
    "Dimsum Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1620,
    46324,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090204020002",
    "Dimsum Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1621,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204020002",
    "Dimsum Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1622,
    46324,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090204020002",
    "Dimsum Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1623,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204020003",
    "Bakso Moluska/Krustase/Ekinodermata",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1624,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204020004",
    "Sosis Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1625,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204020005",
    "Daging Rajungan Rebus Dingin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1626,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030001",
    "Udang Popcorn",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1627,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030002",
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1628,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030002",
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1629,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030003",
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1630,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030003",
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1631,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030003",
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1632,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030004",
    "Sambal Goreng Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1633,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030005",
    "Sambal Goreng Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1634,
    46339,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030006",
    "Keripik3 Kulit Ikan Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1635,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030007",
    "Abon Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1636,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030007",
    "Abon Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1637,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030008",
    "Pempek Ikan (Goreng atau Panggang)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1638,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030008",
    "Pempek Ikan (Goreng atau Panggang)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1639,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030009",
    "Ikan Renyah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1640,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030009",
    "Ikan Renyah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1641,
    46339,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030010",
    "Keripik3 Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1642,
    46339,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030011",
    "Keripik3 Belut",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1643,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030012",
    "Tortila Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1644,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030013",
    "Rendang Ikan Tuna",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1645,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030014",
    "Rendang Kerang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1646,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000001",
    "Ikan Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1647,
    46324,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090205000001",
    "Ikan Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1648,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000001",
    "Ikan Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1649,
    46324,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090205000001",
    "Ikan Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1650,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000001",
    "Ikan Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1651,
    46324,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090205000001",
    "Ikan Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1652,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000001",
    "Ikan Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1653,
    46324,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090205000001",
    "Ikan Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1654,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000002",
    "Ikan Kayu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1655,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000002",
    "Ikan Kayu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1656,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000003",
    "Ikan Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1657,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000003",
    "Ikan Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1658,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000003",
    "Ikan Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1659,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000004",
    "Ikan Asin Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1660,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000004",
    "Ikan Asin Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1661,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000005",
    "Teri Asin Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1662,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000005",
    "Teri Asin Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1663,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000006",
    "Teri Nasi Setengah Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1664,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000006",
    "Teri Nasi Setengah Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1665,
    46339,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000007",
    "Kerupuk4 Ikan, Udang, Moluska (Mentah)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1666,
    46339,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000008",
    "Kerupuk4 Kulit Ikan Mentah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1667,
    46339,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000009",
    "Dendeng Ikan (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1668,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000010",
    "Belut Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1669,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000011",
    "Udang Kering Tanpa Kulit (Ebi) (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1670,
    46339,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000012",
    "Ebi Bubuk (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1671,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000013",
    "Cumi dan Sotong Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1672,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000014",
    "Ubur-Ubur Asin (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1673,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000015",
    "Teripang Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1674,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000016",
    "Daging Kerang Abalon Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1675,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000016",
    "Daging Kerang Abalon Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1676,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000017",
    "Sirip Hiu Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1677,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000017",
    "Sirip Hiu Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1678,
    46325,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000018",
    "Telur Ikan Terbang Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1679,
    46325,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000018",
    "Telur Ikan Terbang Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1680,
    46324,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000019",
    "Terasi Udang (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1681,
    46324,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000019",
    "Terasi Udang (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1682,
    46324,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000020",
    "Pasta Ikan (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1683,
    46324,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000021",
    "Ikan Asin Jambal Roti (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1684,
    46339,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000022",
    "Ikan Peda (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1685,
    46339,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000023",
    "Bekasam/Bekasang (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1686,
    46339,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000023",
    "Bekasam/Bekasang (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1687,
    46339,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000024",
    "Rusip (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1688,
    46339,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000024",
    "Rusip (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1689,
    46339,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000025",
    "Masin (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1690,
    46339,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000025",
    "Masin (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1691,
    46339,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000026",
    "Tepung Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1692,
    46339,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000027",
    "Pasta Gonad Bulu Babi (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1693,
    46324,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000028",
    "Rebon (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1694,
    46324,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090301000001",
    "Rollmops",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1695,
    46324,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090301000002",
    "Gel Ikan (Sea Gel)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1696,
    46324,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090301000003",
    "Aspic Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1697,
    46324,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090302000001",
    "Ikan dan Produk Perikanan Termasuk Moluska, Krustase, dan Ekinodermata yang Diolah Menjadi Pikel dan/atau Direndam Dalam Larutan Garam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1698,
    46325,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090303000001",
    "Caviar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1699,
    46325,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090303000002",
    "Red Caviar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1700,
    46325,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090303000003",
    "Golden Caviar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1701,
    46325,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090303000004",
    "Pengganti Kaviar (Caviar Substitute)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1702,
    46325,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090303000005",
    "Telur Ikan Dengan Penambahan Bahan Pangan Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1703,
    46324,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090304000001",
    "Petis Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1704,
    46324,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000001",
    "Sosis Ikan/Moluska/Krustase/Ekinodermata Siap Santap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1705,
    46324,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000001",
    "Sosis Ikan/Moluska/Krustase/Ekinodermata Siap Santap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1706,
    46324,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000001",
    "Sosis Ikan/Moluska/Krustase/Ekinodermata Siap Santap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1707,
    46324,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000002",
    "Otak-Otak Ikan/Moluska/Krustase/Ekinodermata Siap Santap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1708,
    46324,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000002",
    "Otak-Otak Ikan/Moluska/Krustase/Ekinodermata Siap Santap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1709,
    46324,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000002",
    "Otak-Otak Ikan/Moluska/Krustase/Ekinodermata Siap Santap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1710,
    46324,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000003",
    "Tuna dalam Kemasan Kaleng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1711,
    46324,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000004",
    "Udang Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1712,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000005",
    "Kerang Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1713,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000005",
    "Kerang Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1714,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000006",
    "Daging Rajungan Sterilisasi dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1715,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000007",
    "Daging Rajungan Pasteurisasi Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1716,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090400000007",
    "Daging Rajungan Pasteurisasi Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1717,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000007",
    "Daging Rajungan Pasteurisasi Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1718,
    46324,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090400000007",
    "Daging Rajungan Pasteurisasi Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1719,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000008",
    "Tiram Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1720,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000008",
    "Tiram Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1721,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000009",
    "Salmon Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1722,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000010",
    "Sarden Dan Makerel Dalam Kemasan Kaleng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1723,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000011",
    "Bekicot Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1724,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000012",
    "Cumi-cumi Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1725,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000013",
    "Sotong Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1726,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000014",
    "Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1727,
    46324,
    "0906",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000014",
    "Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1728,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000014",
    "Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1729,
    46324,
    "0906",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000014",
    "Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1730,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000014",
    "Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1731,
    46324,
    "0906",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000014",
    "Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1732,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000014",
    "Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1733,
    46324,
    "0906",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000014",
    "Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1734,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000015",
    "Olahan Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1735,
    46324,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000015",
    "Olahan Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1736,
    46324,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000016",
    "Tuna dalam Kemasan Selain Kaleng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1737,
    46324,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000017",
    "Sarden Dan Makerel Dalam Kemasan Selain Kaleng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1738,
    46325,
    1005,
    "Telur segar",
    100100000001,
    "Telur Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1739,
    46325,
    1003,
    "Produk Telur Cair",
    100201000001,
    "Telur Cair Utuh",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1740,
    46325,
    1003,
    "Produk Telur Cair",
    100201000002,
    "Putih Telur Cair",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1741,
    46325,
    1003,
    "Produk Telur Cair",
    100201000003,
    "Kuning Telur Cair",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1742,
    46325,
    1003,
    "Produk Telur Cair",
    100201000004,
    "Telur Cair Campuran /Premiks Telur Cair",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1743,
    46325,
    1002,
    "Produk Telur Beku",
    100202000001,
    "Telur Beku Utuh",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1744,
    46325,
    1002,
    "Produk Telur Beku",
    100202000002,
    "Putih Telur Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1745,
    46325,
    1002,
    "Produk Telur Beku",
    100202000003,
    "Kuning Telur Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1746,
    46325,
    1002,
    "Produk Telur Beku",
    100202000004,
    "Telur Campuran Beku/Premiks Telur Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1747,
    46325,
    1004,
    "Produk-Produk Telur yang Dikeringkan dan/atau Dipanaskan Hingga Terkoagulasi",
    100203000001,
    "Tepung Telur Utuh",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1748,
    46325,
    1004,
    "Produk-Produk Telur yang Dikeringkan dan/atau Dipanaskan Hingga Terkoagulasi",
    100203000002,
    "Tepung Putih Telur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1749,
    46325,
    1004,
    "Produk-Produk Telur yang Dikeringkan dan/atau Dipanaskan Hingga Terkoagulasi",
    100203000003,
    "Tepung Kuning Telur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1750,
    46325,
    1004,
    "Produk-Produk Telur yang Dikeringkan dan/atau Dipanaskan Hingga Terkoagulasi",
    100203000004,
    "Telur Matang/Setengah Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1751,
    46325,
    1004,
    "Produk-Produk Telur yang Dikeringkan dan/atau Dipanaskan Hingga Terkoagulasi",
    100203000005,
    "Telur Pindang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1752,
    46325,
    1004,
    "Produk-Produk Telur yang Dikeringkan dan/atau Dipanaskan Hingga Terkoagulasi",
    100203000006,
    "Tepung Telur Campuran/Premiks Tepung Telur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1753,
    46325,
    1004,
    "Produk-Produk Telur yang Dikeringkan dan/atau Dipanaskan Hingga Terkoagulasi",
    100203000007,
    "Rendang Telur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1754,
    46325,
    1006,
    "\"Telur yang Diawetkan, Termasuk Produk Tradisional Telur Yang Diawetkan, Termasuk Dengan Cara Dibasakan, Diasinkan dan Dikalengkan\"",
    100300000001,
    "Telur Asin Mentah",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1755,
    46325,
    1006,
    "\"Telur yang Diawetkan, Termasuk Produk Tradisional Telur Yang Diawetkan, Termasuk Dengan Cara Dibasakan, Diasinkan dan Dikalengkan\"",
    100300000002,
    "Telur Asin Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1756,
    46325,
    1006,
    "\"Telur yang Diawetkan, Termasuk Produk Tradisional Telur Yang Diawetkan, Termasuk Dengan Cara Dibasakan, Diasinkan dan Dikalengkan\"",
    100300000003,
    "Telur Olahan Steril",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1757,
    46325,
    1006,
    "\"Telur yang Diawetkan, Termasuk Produk Tradisional Telur Yang Diawetkan, Termasuk Dengan Cara Dibasakan, Diasinkan dan Dikalengkan\"",
    100300000004,
    "Telur Hitam (Pidan/Pitan/Bitan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1758,
    46325,
    1006,
    "\"Telur yang Diawetkan, Termasuk Produk Tradisional Telur Yang Diawetkan, Termasuk Dengan Cara Dibasakan, Diasinkan dan Dikalengkan\"",
    100300000005,
    "Hulidan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1759,
    46325,
    1006,
    "\"Telur yang Diawetkan, Termasuk Produk Tradisional Telur Yang Diawetkan, Termasuk Dengan Cara Dibasakan, Diasinkan dan Dikalengkan\"",
    100300000006,
    "Dsaudan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1760,
    46325,
    1001,
    "Makanan Pencuci Mulut Berbahan Dasar Telur (Misalnya Custard)",
    100400000001,
    "Selai Kaya",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1761,
    46325,
    1001,
    "Makanan Pencuci Mulut Berbahan Dasar Telur (Misalnya Custard)",
    100400000002,
    "Custard",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1762,
    46325,
    1001,
    "Makanan Pencuci Mulut Berbahan Dasar Telur (Misalnya Custard)",
    100400000003,
    "Tepung Custard",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1763,
    46325,
    1001,
    "Makanan Pencuci Mulut Berbahan Dasar Telur (Misalnya Custard)",
    100400000004,
    "Martabak Telur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1764,
    46325,
    1001,
    "Makanan Pencuci Mulut Berbahan Dasar Telur (Misalnya Custard)",
    100400000004,
    "Martabak Telur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1765,
    46331,
    1111,
    "Gula dan Pemanis",
    110101000001,
    "Gula Kristal Rafinasi",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1766,
    46331,
    1111,
    "Gula dan Pemanis",
    110101000002,
    "Dekstrosa Anhidrat",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1767,
    46331,
    1111,
    "Gula dan Pemanis",
    110101000002,
    "Dekstrosa Anhidrat",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1768,
    46331,
    1111,
    "Gula dan Pemanis",
    110101000003,
    "Dekstrosa Monohidrat",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1769,
    46331,
    1111,
    "Gula dan Pemanis",
    110101000003,
    "Dekstrosa Monohidrat",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1770,
    46331,
    1111,
    "Gula dan Pemanis",
    110101000004,
    "Fruktosa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1771,
    46331,
    1111,
    "Gula dan Pemanis",
    110101000004,
    "Fruktosa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1772,
    46331,
    1111,
    "Gula dan Pemanis",
    110101000004,
    "Fruktosa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1773,
    46331,
    1111,
    "Gula dan Pemanis",
    110102000001,
    "Gula Serbuk (Icing Sugar) ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1774,
    46331,
    1111,
    "Gula dan Pemanis",
    110102000001,
    "Gula Serbuk (Icing Sugar) ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1775,
    46331,
    1111,
    "Gula dan Pemanis",
    110102000002,
    "Dektrosa Serbuk (Icing Dextrose)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1776,
    46331,
    1111,
    "Gula dan Pemanis",
    110102000002,
    "Dektrosa Serbuk (Icing Dextrose)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1777,
    46331,
    1111,
    "Gula dan Pemanis",
    110103000001,
    "Gula Putih Lembab atau Soft White Sugar",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1778,
    46331,
    1111,
    "Gula dan Pemanis",
    110103000002,
    "Gula Merah Lembab atau Soft Brown Sugar ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1779,
    46331,
    1111,
    "Gula dan Pemanis",
    110103000003,
    "Gula Tebu Mentah",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1780,
    46331,
    1111,
    "Gula dan Pemanis",
    110103000003,
    "Gula Tebu Mentah",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1781,
    46331,
    1114,
    "Sirup Glukosa",
    110103000004,
    "Glukosa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1782,
    46331,
    1114,
    "Sirup Glukosa",
    110103000004,
    "Glukosa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1783,
    46331,
    1114,
    "Sirup Glukosa",
    110103010001,
    "Sirup Glukosa Kering ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1784,
    46331,
    1111,
    "Gula dan Pemanis",
    110103010002,
    "Sirup Jagung Terfermentasi Kering",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1785,
    46331,
    1114,
    "Sirup Glukosa",
    110103010002,
    "Sirup Jagung Terfermentasi Kering",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1786,
    46331,
    1111,
    "Gula dan Pemanis",
    110103010002,
    "Sirup Jagung Terfermentasi Kering",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1787,
    46331,
    1114,
    "Sirup Glukosa",
    110103010002,
    "Sirup Jagung Terfermentasi Kering",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1788,
    46331,
    1114,
    "Sirup Glukosa",
    110103020001,
    "Sirup glukosa ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1789,
    46331,
    1107,
    "Laktosa",
    110104000001,
    "Laktosa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1790,
    46331,
    1111,
    "Gula dan Pemanis",
    110105000001,
    "Gula Kristal Putih atau Gula Pasir",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1791,
    46331,
    1111,
    "Gula dan Pemanis",
    110105000001,
    "Gula Kristal Putih atau Gula Pasir",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1792,
    46331,
    1111,
    "Gula dan Pemanis",
    110200000001,
    "Gula Palma Cetak",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1793,
    46331,
    1111,
    "Gula dan Pemanis",
    110200000001,
    "Gula Palma Cetak",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1794,
    46331,
    1111,
    "Gula dan Pemanis",
    110200000001,
    "Gula Palma Cetak",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1795,
    46331,
    1111,
    "Gula dan Pemanis",
    110200000002,
    "Gula Palma Serbuk (Gula Semut)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1796,
    46331,
    1111,
    "Gula dan Pemanis",
    110200000002,
    "Gula Palma Serbuk (Gula Semut)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1797,
    46331,
    1111,
    "Gula dan Pemanis",
    110200000002,
    "Gula Palma Serbuk (Gula Semut)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1798,
    46331,
    1111,
    "Gula dan Pemanis",
    110200000003,
    "Gula Merah Tebu/Saka",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1799,
    46331,
    1111,
    "Gula dan Pemanis",
    110200000003,
    "Gula Merah Tebu/Saka",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1800,
    46331,
    1111,
    "Gula dan Pemanis",
    110200000004,
    "Gula Coklat Sukrosa",
    150000,
    100000,
    400000,
    "Aktif",
  ],
  [
    1801,
    46331,
    1111,
    "Gula dan Pemanis",
    110200000004,
    "Gula Coklat Sukrosa",
    150000,
    100000,
    400000,
    "Aktif",
  ],
  [
    1802,
    46331,
    1111,
    "Gula dan Pemanis",
    110200000004,
    "Gula Coklat Sukrosa",
    150000,
    100000,
    400000,
    "Aktif",
  ],
  [
    1803,
    46331,
    1111,
    "Gula dan Pemanis",
    110200000005,
    "Gula Serbuk Campuran",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1804,
    46331,
    1111,
    "Gula dan Pemanis",
    110300000001,
    "Tetes Tebu atau Molases",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1805,
    46331,
    1111,
    "Gula dan Pemanis",
    110300000002,
    "Gula Invert",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1806,
    46331,
    1111,
    "Gula dan Pemanis",
    110300000003,
    "Sirup Fruktosa (High Fructose Syrup/HFS)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1807,
    46331,
    1111,
    "Gula dan Pemanis",
    110300000003,
    "Sirup Fruktosa (High Fructose Syrup/HFS)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1808,
    46331,
    1111,
    "Gula dan Pemanis",
    110300000004,
    "Sirup Fruktosa-Glukosa (High Fructose Glucose Syrup)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1809,
    46331,
    1111,
    "Gula dan Pemanis",
    110300000005,
    "Sirup Jagung",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1810,
    46331,
    1111,
    "Gula dan Pemanis",
    110300000005,
    "Sirup Jagung",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1811,
    46331,
    1111,
    "Gula dan Pemanis",
    110300000005,
    "Sirup Jagung",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1812,
    46331,
    1111,
    "Gula dan Pemanis",
    110300000005,
    "Sirup Jagung",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1813,
    46331,
    1111,
    "Gula dan Pemanis",
    110300000006,
    "Sirup Tebu (Cane Syrup)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1814,
    46331,
    1111,
    "Gula dan Pemanis",
    110300000007,
    "Gula Sukrosa Cair ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1815,
    46331,
    1111,
    "Gula dan Pemanis",
    110400000001,
    "Sirup Maple (Maple Syrup)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1816,
    46331,
    1111,
    "Gula dan Pemanis",
    110400000002,
    "Sirup Sorgum (Shorgum Syrup)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1817,
    46331,
    1111,
    "Gula dan Pemanis",
    110400000003,
    "Sirup/Sirup Meja (Table Syrup)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1818,
    46331,
    1111,
    "Gula dan Pemanis",
    110400000003,
    "Sirup/Sirup Meja (Table Syrup)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1819,
    46331,
    1111,
    "Gula dan Pemanis",
    110400000004,
    "Gula Hias ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1820,
    46331,
    1111,
    "Gula dan Pemanis",
    110400000004,
    "Gula Hias ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1821,
    46331,
    1111,
    "Gula dan Pemanis",
    110400000005,
    "Sirup Agave",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1822,
    46331,
    1111,
    "Gula dan Pemanis",
    110400000006,
    "Gula Merah Cair",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1823,
    46331,
    1111,
    "Gula dan Pemanis",
    110400000007,
    "Gula Palma Cair",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1824,
    46331,
    1111,
    "Gula dan Pemanis",
    110400000007,
    "Gula Palma Cair",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1825,
    46329,
    1109,
    "Madu",
    110500000001,
    "Madu",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1826,
    46339,
    1109,
    "Madu",
    110500000001,
    "Madu",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1827,
    46339,
    1109,
    "Madu",
    110500000001,
    "Madu",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1828,
    46339,
    1109,
    "Madu",
    110500000001,
    "Madu",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1829,
    46339,
    1113,
    "Madu Bubuk",
    110500000002,
    "Madu Serbuk",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1830,
    46329,
    1109,
    "Madu",
    110500000003,
    "Madu dengan penambahan bahan lain",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1831,
    46339,
    1109,
    "Madu",
    110500000003,
    "Madu dengan penambahan bahan lain",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1832,
    46331,
    1111,
    "Gula dan Pemanis",
    110600000001,
    "Sediaan Pemanis Alami",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1833,
    46331,
    1111,
    "Gula dan Pemanis",
    110600000002,
    "Sediaan Pemanis Alami dan Buatan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1834,
    46331,
    1111,
    "Gula dan Pemanis",
    110600000002,
    "Sediaan Pemanis Alami dan Buatan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1835,
    46331,
    1111,
    "Gula dan Pemanis",
    110600000003,
    "Sediaan Pemanis Buatan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1836,
    46319,
    1204,
    "Garam",
    120101000001,
    "Garam Konsumsi Beriodium",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1837,
    46319,
    1204,
    "Garam",
    120101000001,
    "Garam Konsumsi Beriodium",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1838,
    46319,
    1204,
    "Garam",
    120101000002,
    "Garam Konsumsi Cair Beriodium",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1839,
    46319,
    1204,
    "Garam",
    120101000003,
    "Garam Gurih",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1840,
    46319,
    1204,
    "Garam",
    120101000004,
    "Garam Industri Aneka Pangan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1841,
    46319,
    1204,
    "Garam",
    120101000005,
    "Garam Diet",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1842,
    46319,
    1204,
    "Garam",
    120101000006,
    "Garam Kurang Natrium",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1843,
    46319,
    1204,
    "Garam",
    120101000007,
    "Garam Bahan Baku Untuk Garam Konsumsi Beriodium",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1844,
    46319,
    1204,
    "Garam",
    120101000008,
    "Garam Campuran",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1845,
    46319,
    1204,
    "Garam",
    120101000009,
    "Garam Berbumbu",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1846,
    46319,
    1212,
    "Pengganti Garam",
    120102000001,
    "Pengganti Garam ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1847,
    46319,
    1217,
    "Rempah",
    120201000001,
    "Rempah Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1848,
    46319,
    1217,
    "Rempah",
    120201000002,
    "Adas, Adas Pedas, Fennel, Jinten Manis",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1849,
    46319,
    1217,
    "Rempah",
    120201000003,
    "Adas Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1850,
    46319,
    1217,
    "Rempah",
    120201000004,
    "Akar Chicory",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1851,
    46319,
    1217,
    "Rempah",
    120201000005,
    "Andaliman",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1852,
    46319,
    1217,
    "Rempah",
    120201000006,
    "Asam Gelugur",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1853,
    46319,
    1217,
    "Rempah",
    120201000007,
    "Asam Sunti",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1854,
    46319,
    1217,
    "Rempah",
    120201000008,
    "Asam Jawa",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1855,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000009,
    "Asam Kandis",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1856,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000010,
    "Allspice/Pimento",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1857,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000011,
    "Basil",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1858,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000012,
    "Ruku-Ruku",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1859,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000013,
    "Kemangi",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1860,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000014,
    "Basilla",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1861,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000015,
    "Bay Leaves",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1862,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000016,
    "Bawang Putih",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1863,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000017,
    "Bawang Merah (Shallot)",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1864,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000017,
    "Bawang Merah (Shallot)",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1865,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000018,
    "Bawang Batak/Lokio",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1866,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000019,
    "Bawang Daun",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1867,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000020,
    "Biji Seledri",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1868,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000021,
    "Daun Seledri",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1869,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000022,
    "Biji Sawi/Biji Mustard",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1870,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000023,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1871,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000024,
    "Cabe Jawa",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1872,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000025,
    "Cabe Segar",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1873,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000026,
    "Bubur Cabe",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1874,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000027,
    "Cabe Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1875,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000028,
    "Kucai/Chives",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1876,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000029,
    "Cengkeh",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1877,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000030,
    "Cengkeh Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1878,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000031,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1879,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000032,
    "Dill Weed",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1880,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000033,
    "Daun Jeruk Purut (Kaffir lime)",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1881,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000034,
    "Daun Pandan",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1882,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000035,
    "Daun Peterseli",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1883,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000036,
    "Daun Salam",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1884,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000037,
    "Daun Sembung",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1885,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000038,
    "Daun Suji",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1886,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000039,
    "Fenugreek, Kelabat, Kelabet, Klabat",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1887,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000040,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1888,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000041,
    "Fuli Kering (Bunga Pala)",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1889,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000042,
    "Fuli Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1890,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000043,
    "Jahe Segar",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1891,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000044,
    "Jahe Kering",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1892,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000045,
    "Bubur Jahe",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1893,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000046,
    "Jahe Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1894,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000047,
    "Jintan/Caraway",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1895,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000048,
    "Jintan Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1896,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000049,
    "Jintan Manis",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1897,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000050,
    "Jintan Hitam",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1898,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000051,
    "Jintan Hitam Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1899,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000052,
    "Jintan Putih, Cumin",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1900,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000053,
    "Jintan Putih Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1901,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000054,
    "Kapulaga",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1902,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000055,
    "Biji Kapulaga",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1903,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000056,
    "Kapulaga Lokal",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1904,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000057,
    "Kapulaga (Cardamom) Amomum",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1905,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000058,
    "Biji Kapulaga (Cardamom) Amomum",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1906,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000059,
    "Kapulaga Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1907,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000060,
    "Kapulaga (Cardamom) Amomum Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1908,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000061,
    "Kayu Manis",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1909,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000062,
    "Kayu Manis Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1910,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000063,
    "Kemiri",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1911,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000064,
    "Kencur",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1912,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000065,
    "Kencur Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1913,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000066,
    "Ketumbar",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1914,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000067,
    "Daun Ketumbar",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1915,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000068,
    "Ketumbar Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1916,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000069,
    "Lempuyang",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1917,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000070,
    "Picung",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1918,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000071,
    "Kluwek",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1919,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000072,
    "Kunyit",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1920,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000073,
    "Kunyit Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1921,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000074,
    "Lada Hitam",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1922,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000075,
    "Lada Hitam Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1923,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000076,
    "Lada Putih",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1924,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000077,
    "Lada Putih Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1925,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000078,
    "Lada Bubuk Campuran",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1926,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000079,
    "Lengkuas/Laos",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1927,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000080,
    "Lengkuas/Laos Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1928,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000081,
    "Kecombrang/Sambuang/Kincung/Honje",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1929,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000082,
    "Marjoram",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1930,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000083,
    "Mesoyi",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1931,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000084,
    "Mint",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1932,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000085,
    "Onion/Bawang Bombay",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1933,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000086,
    "Oregano",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1934,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000087,
    "Pala",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1935,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000088,
    "Pala Untuk Destilasi",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1936,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000089,
    "Pala Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1937,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000090,
    "Parsley",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1938,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000091,
    "Paprika Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1939,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000092,
    "Sweet Paprika Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1940,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000093,
    "Rosemari",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1941,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000094,
    "Sereh",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1942,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000095,
    "Pekak/Bunga Lawang/Star Anise",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1943,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000096,
    "Temu Kunci",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1944,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000097,
    "Thymi/Thyme",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1945,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000098,
    "Wasabi",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1946,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000099,
    "Wijen",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1947,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000100,
    "Herba dan Rempah Olahan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1948,
    46319,
    1217,
    "Rempah",
    120201000100,
    "Herba dan Rempah Olahan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1949,
    46319,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000100,
    "Herba dan Rempah Olahan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1950,
    46319,
    1217,
    "Rempah",
    120201000100,
    "Herba dan Rempah Olahan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1951,
    46319,
    1202,
    "Bumbu dan kondimen",
    120202000001,
    "Bubuk Ngohyang",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1952,
    46319,
    1202,
    "Bumbu dan kondimen",
    120202000002,
    "Bumbu Siap Pakai",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1953,
    46319,
    1202,
    "Bumbu dan kondimen",
    120202000002,
    "Bumbu Siap Pakai",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1954,
    46339,
    1202,
    "Bumbu dan kondimen",
    120202000003,
    "Bumbu Ekstrak Daging Sapi",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1955,
    46339,
    1202,
    "Bumbu dan kondimen",
    120202000004,
    "Bumbu Rasa Sapi",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1956,
    46339,
    1202,
    "Bumbu dan kondimen",
    120202000005,
    "Bumbu Ekstrak Daging Ayam",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1957,
    46339,
    1202,
    "Bumbu dan kondimen",
    120202000006,
    "Bumbu Ekstrak Udang",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1958,
    46339,
    1202,
    "Bumbu dan kondimen",
    120202000007,
    "Bumbu Ekstrak Cumi",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1959,
    46339,
    1202,
    "Bumbu dan kondimen",
    120202000008,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1960,
    46339,
    1202,
    "Bumbu dan kondimen",
    120202000009,
    "Bumbu Rasa Ikan",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1961,
    46339,
    1202,
    "Bumbu dan kondimen",
    120202000010,
    "Bumbu Rasa Udang",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1962,
    46339,
    1202,
    "Bumbu dan kondimen",
    120202000011,
    "Bumbu Rasa Ayam",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1963,
    46339,
    1202,
    "Bumbu dan kondimen",
    120202000012,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1964,
    46339,
    1202,
    "Bumbu dan kondimen",
    120202000013,
    "Ragi Kering (Tidak Aktif)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1965,
    46339,
    1202,
    "Bumbu dan kondimen",
    120202000013,
    "Ragi Kering (Tidak Aktif)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1966,
    46319,
    1202,
    "Bumbu dan kondimen",
    120202000014,
    "Bawang hitam (Black Garlic)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1967,
    46319,
    1202,
    "Bumbu dan kondimen",
    120202000014,
    "Bawang hitam (Black Garlic)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1968,
    46339,
    1202,
    "Bumbu dan kondimen",
    120202000015,
    "Kondimen Berperisa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1969,
    46339,
    1202,
    "Bumbu dan kondimen",
    120202000016,
    "Bumbu Rasa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1970,
    46339,
    1202,
    "Bumbu dan kondimen",
    120202000017,
    "Bumbu Tabur",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1971,
    46339,
    1203,
    "Cuka makan",
    120300000001,
    "Cuka Fermentasi (Vinegar)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1972,
    46339,
    1203,
    "Cuka makan",
    120300000002,
    "Cuka Hasil Pengenceran Asam Asetat Glasial",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1973,
    46339,
    1201,
    "Arak masak",
    120300000003,
    "Arak Masak",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1974,
    46319,
    1207,
    "Mustard",
    120400000001,
    "Mustard/Saus Mustard",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1975,
    46339,
    1223,
    "Sup dan kaldu cair yang disterilisasi, Sup dan kaldu cair kecuali yang disterilisasi",
    120501000001,
    "Sari Pati Ayam",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1976,
    46339,
    1222,
    "Sup dan kaldu bubuk",
    120501000002,
    "Kaldu dan Konsome",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1977,
    46339,
    1223,
    "Sup dan kaldu cair yang disterilisasi, Sup dan kaldu cair kecuali yang disterilisasi",
    120501000002,
    "Kaldu dan Konsome",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1978,
    46339,
    1222,
    "Sup dan kaldu bubuk",
    120501000002,
    "Kaldu dan Konsome",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1979,
    46339,
    1223,
    "Sup dan kaldu cair yang disterilisasi, Sup dan kaldu cair kecuali yang disterilisasi",
    120501000002,
    "Kaldu dan Konsome",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1980,
    46339,
    1222,
    "Sup dan kaldu bubuk",
    120501000002,
    "Kaldu dan Konsome",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1981,
    46339,
    1223,
    "Sup dan kaldu cair yang disterilisasi, Sup dan kaldu cair kecuali yang disterilisasi",
    120501000002,
    "Kaldu dan Konsome",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1982,
    46339,
    1222,
    "Sup dan kaldu bubuk",
    120501000002,
    "Kaldu dan Konsome",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1983,
    46339,
    1223,
    "Sup dan kaldu cair yang disterilisasi, Sup dan kaldu cair kecuali yang disterilisasi",
    120501000002,
    "Kaldu dan Konsome",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1984,
    46339,
    1223,
    "Sup dan kaldu cair yang disterilisasi, Sup dan kaldu cair kecuali yang disterilisasi",
    120501000003,
    "Sup Siap Konsumsi",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1985,
    46339,
    1223,
    "Sup dan kaldu cair yang disterilisasi, Sup dan kaldu cair kecuali yang disterilisasi",
    120501000003,
    "Sup Siap Konsumsi",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1986,
    46339,
    1222,
    "Sup dan kaldu bubuk",
    120502000001,
    "Sup Instan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1987,
    46339,
    1222,
    "Sup dan kaldu bubuk",
    120502000001,
    "Sup Instan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1988,
    46339,
    1222,
    "Sup dan kaldu bubuk",
    120502000002,
    "Sup Pasta Instan (Misalnya Sup Makaroni Instan)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1989,
    46339,
    1222,
    "Sup dan kaldu bubuk",
    120502000002,
    "Sup Pasta Instan (Misalnya Sup Makaroni Instan)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1990,
    46339,
    1222,
    "Sup dan kaldu bubuk",
    120502000003,
    "Sup Krim Instan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1991,
    46339,
    1222,
    "Sup dan kaldu bubuk",
    120502000003,
    "Sup Krim Instan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1992,
    46339,
    1222,
    "Sup dan kaldu bubuk",
    120502000004,
    "Sup Krim Pasta Instan (Misalnya Sup Krim Makaroni Instan)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1993,
    46339,
    1222,
    "Sup dan kaldu bubuk",
    120502000004,
    "Sup Krim Pasta Instan (Misalnya Sup Krim Makaroni Instan)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1994,
    46315,
    1206,
    "Mayonais/salad dressing",
    120601000001,
    "Mayonais, Mayonnaise",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1995,
    46315,
    1206,
    "Mayonais/salad dressing",
    120601000002,
    "Salad Dressing (Misalnya Thousand Island, Blue Cheese, Burger Dressing, Saus Siram Caesar)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1996,
    46315,
    1206,
    "Mayonais/salad dressing",
    120601000002,
    "Salad Dressing (Misalnya Thousand Island, Blue Cheese, Burger Dressing, Saus Siram Caesar)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1997,
    46315,
    1206,
    "Mayonais/salad dressing",
    120601000003,
    "Saus Tar Tar (Tar Tar Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1998,
    46315,
    1206,
    "Mayonais/salad dressing",
    120601000004,
    "French Dressing (Italian Dressing, Greek Dressing, Ranch Style Dressing)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1999,
    46315,
    1206,
    "Mayonais/salad dressing",
    120601000005,
    "Sandwich Spread",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2000,
    46315,
    1206,
    "Mayonais/salad dressing",
    120601000006,
    "Mayones/Mayonais Tanpa Telur (Eggless Mayonnaise/Eggfree Mayonnaise",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2001,
    46319,
    1218,
    "Sambal",
    120602000001,
    "Sambal",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2002,
    46319,
    1219,
    "Saus bumbu",
    120602000002,
    "Saus Cabe",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2003,
    46319,
    1219,
    "Saus Bumbu",
    120602000002,
    "Saus Cabe",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2004,
    46319,
    1219,
    "Saus bumbu",
    120602000003,
    "Bumbu Kacang",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2005,
    46319,
    1219,
    "Saus Bumbu",
    120602000003,
    "Bumbu Kacang",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2006,
    46319,
    1219,
    "Saus bumbu",
    120602000004,
    "Saus Keju (Cheese Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2007,
    46319,
    1219,
    "Saus Bumbu",
    120602000004,
    "Saus Keju (Cheese Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2008,
    46319,
    1219,
    "Saus bumbu",
    120602000005,
    "Saus Lobak",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2009,
    46319,
    1219,
    "Saus Bumbu",
    120602000005,
    "Saus Lobak",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2010,
    46319,
    1219,
    "Saus bumbu",
    120602000006,
    "Saus Panggang/Saus Barbekue (BBQ Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2011,
    46319,
    1219,
    "Saus Bumbu",
    120602000006,
    "Saus Panggang/Saus Barbekue (BBQ Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2012,
    46319,
    1219,
    "Saus bumbu",
    120602000007,
    "Saus Pizza",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2013,
    46319,
    1219,
    "Saus Bumbu",
    120602000007,
    "Saus Pizza",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2014,
    46319,
    1216,
    "Ragi",
    120602000008,
    "Saus Spagheti (Spaghetti Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2015,
    46319,
    1219,
    "Saus Bumbu",
    120602000008,
    "Saus Spagheti (Spaghetti Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2016,
    46319,
    1216,
    "Ragi",
    120602000008,
    "Saus Spagheti (Spaghetti Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2017,
    46319,
    1219,
    "Saus Bumbu",
    120602000008,
    "Saus Spagheti (Spaghetti Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2018,
    46339,
    1216,
    "Ragi",
    120602000008,
    "Saus Spagheti (Spaghetti Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2019,
    46339,
    1219,
    "Saus Bumbu",
    120602000008,
    "Saus Spagheti (Spaghetti Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2020,
    46339,
    1216,
    "Ragi",
    120602000008,
    "Saus Spagheti (Spaghetti Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2021,
    46339,
    1219,
    "Saus Bumbu",
    120602000008,
    "Saus Spagheti (Spaghetti Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2022,
    46319,
    1219,
    "Saus bumbu",
    120602000009,
    "Saus Tiram",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2023,
    46324,
    1219,
    "Saus Bumbu",
    120602000009,
    "Saus Tiram",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2024,
    46324,
    1219,
    "Saus bumbu",
    120602000009,
    "Saus Tiram",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2025,
    46319,
    1219,
    "Saus Bumbu",
    120602000010,
    "Saus Perendam/Saus Marinasi (Marinated Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2026,
    46319,
    1219,
    "Saus bumbu",
    120602000010,
    "Saus Perendam/Saus Marinasi (Marinated Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2027,
    46319,
    1221,
    "Saus tomat",
    120602000011,
    "Saus Tomat",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2028,
    46319,
    1221,
    "Saus tomat",
    120602000011,
    "Saus Tomat",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2029,
    46319,
    1219,
    "Saus bumbu",
    120602000012,
    "Saus Asam Manis",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2030,
    46319,
    1219,
    "Saus Bumbu",
    120602000012,
    "Saus Asam Manis",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2031,
    46319,
    1205,
    "Kecap selain kedelai",
    120602000013,
    "Kecap Inggris, Saus Worchester",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2032,
    46319,
    1219,
    "Saus bumbu",
    120602000014,
    "Saus Teriyaki",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2033,
    46319,
    1219,
    "Saus Bumbu",
    120602000014,
    "Saus Teriyaki",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2034,
    46319,
    1219,
    "Saus bumbu",
    120602000015,
    "Saus Topping/Saus Siram",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2035,
    46319,
    1219,
    "Saus Bumbu",
    120602000015,
    "Saus Topping/Saus Siram",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2036,
    46319,
    1219,
    "Saus bumbu",
    120602000016,
    "Saus Salsa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2037,
    46319,
    1219,
    "Saus Bumbu",
    120602000016,
    "Saus Salsa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2038,
    46319,
    1219,
    "Saus bumbu",
    120602000017,
    "Saus Putih (Berbasis Krim)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2039,
    46319,
    1219,
    "Saus Bumbu",
    120602000017,
    "Saus Putih (Berbasis Krim)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2040,
    46314,
    1205,
    "Kecap selain kedelai",
    120602000018,
    "Kecap Air Kelapa",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    2041,
    46314,
    1205,
    "Kecap selain kedelai",
    120602000018,
    "Kecap Air Kelapa",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    2042,
    46314,
    1205,
    "Kecap selain kedelai",
    120602000019,
    "Kecap Gula Aren",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    2043,
    46319,
    1205,
    "Kecap selain kedelai",
    120602000020,
    "Pengganti kecap (non-kedelai)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2044,
    46339,
    1226,
    "Bubuk Untuk Saus dan Gravies",
    120603000001,
    "Campuran Untuk Saus, Gravies, dan Dressing",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2045,
    46324,
    1205,
    "Kecap selain kedelai",
    120604000001,
    "Kecap Ikan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2046,
    46324,
    1210,
    "Pangan kategori 12 risiko sedang lainnya",
    120604000002,
    "Saus Tiram Bening",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2047,
    46319,
    1213,
    "Produk oles untuk salad",
    120700000001,
    "Olesan/Saus",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2048,
    46319,
    1213,
    "Produk oles untuk salad",
    120700000001,
    "Olesan/Saus",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2049,
    46319,
    1216,
    "Ragi",
    120800000001,
    "Ragi Roti Kering",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2050,
    46319,
    1216,
    "Ragi",
    120800000002,
    "Ragi Roti Semi Kering",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2051,
    46319,
    1216,
    "Ragi",
    120800000003,
    "Ragi Roti Cair (cream yeast)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2052,
    46319,
    1216,
    "Ragi",
    120800000004,
    "Ragi Roti Padat (Compressed Yeast)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2053,
    46319,
    1216,
    "Ragi",
    120800000005,
    "Ragi Tape",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2054,
    46319,
    1216,
    "Ragi",
    120800000006,
    "Ragi Tempe",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2055,
    46319,
    1216,
    "Ragi",
    120800000007,
    "Koji atau Ragi Tauco atau Ragi Kecap",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2056,
    46319,
    1216,
    "Ragi",
    120800000008,
    "Ragi Untuk Minuman Beralkohol",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2057,
    46319,
    1216,
    "Ragi",
    120800000009,
    "Ragi Oncom Merah",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2058,
    46319,
    1216,
    "Ragi",
    120800000010,
    "Ragi Oncom Hitam",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2059,
    46319,
    1211,
    "Pasta kedelai fermentasi",
    120901000001,
    "Miso",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2060,
    46319,
    1211,
    "Pasta kedelai fermentasi",
    120901000001,
    "Miso",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2061,
    46319,
    1211,
    "Pasta kedelai fermentasi",
    120901000002,
    "Tauco",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2062,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902010001,
    "Kecap Kedelai Asin (Salty Soy Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2063,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902010001,
    "Kecap Kedelai Asin (Salty Soy Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2064,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902020001,
    "Kecap Kedelai Asin Non Fermentasi/Hidrolisat",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2065,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902020001,
    "Kecap Kedelai Asin Non Fermentasi/Hidrolisat",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2066,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902020002,
    "Saus Protein Nabati Terhidrolisis",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2067,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902020002,
    "Saus Protein Nabati Terhidrolisis",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2068,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030001,
    "Saus Kedelai Lainnya",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2069,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030001,
    "Saus Kedelai Lainnya",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2070,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030002,
    "Kecap Kedelai Manis (Sweet Soy Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2071,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030002,
    "Kecap Kedelai Manis (Sweet Soy Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2072,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030003,
    "Kecap yang Dikeringkan/Bubuk Kecap (Fermented Soy Sauce Powder)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2073,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030003,
    "Kecap yang Dikeringkan/Bubuk Kecap (Fermented Soy Sauce Powder)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2074,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030004,
    "Kecap Pedas",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2075,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030004,
    "Kecap Pedas",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2076,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030005,
    "Kecap Bumbu",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2077,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030005,
    "Kecap Bumbu",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2078,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030006,
    "Saus Campuran Protein Nabati Terhidrolisis",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2079,
    46319,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030006,
    "Saus Campuran Protein Nabati Terhidrolisis",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2080,
    46319,
    1214,
    "Produk protein",
    121000000001,
    "Produk Protein Gandum",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2081,
    46319,
    1215,
    "Produk protein ",
    121000000002,
    "Hydrolised Vegetable Protein (HVP)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2082,
    46319,
    1208,
    "Olahan gluten ",
    121000000003,
    "Produk Olahan Gluten",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2083,
    46326,
    1301,
    "Formula bayi bentuk bubuk",
    130101000001,
    "Formula Bayi (Padat)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2084,
    46326,
    1302,
    "Formula bayi bentuk cair (steril)",
    130101000002,
    "Formula Bayi (Cair)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2085,
    46326,
    1303,
    "Formula lanjutan bentuk bubuk",
    130102000001,
    "Formula Lanjutan (Padat)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2086,
    46339,
    1304,
    "Formula lanjutan bentuk cair (steril)",
    130102000002,
    "Formula Lanjutan (Cair)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2087,
    46326,
    1305,
    "Formula pertumbuhan bentuk bubuk",
    130102000003,
    "Formula Pertumbuhan ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2088,
    46339,
    1306,
    "Formula pertumbuhan bentuk cair (UHT)",
    130102000004,
    "Formula Pertumbuhan (Cair)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2089,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000001,
    "PKMK untuk Pasien Kelainan Metabolik (Inborn Errors of Metabolism)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2090,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000001,
    "PKMK untuk Pasien Kelainan Metabolik (Inborn Errors of Metabolism)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2091,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000002,
    "PKMK untuk Pasien Kelainan Metabolik Isovaleric Acidemia",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2092,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000002,
    "PKMK untuk Pasien Kelainan Metabolik Isovaleric Acidemia",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2093,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000003,
    "PKMK untuk Pasien Kelainan Metabolik Tyrosinemia ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2094,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000003,
    "PKMK untuk Pasien Kelainan Metabolik Tyrosinemia ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2095,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000004,
    "PKMK untuk Pasien Kelainan Metabolik Phenylketonuria (PKU) ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2096,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000004,
    "PKMK untuk Pasien Kelainan Metabolik Phenylketonuria (PKU) ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2097,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000005,
    "PKMK untuk Pasien Kelainan Metabolik Maple Syrup Urine Disease (MSUD)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2098,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000005,
    "PKMK untuk Pasien Kelainan Metabolik Maple Syrup Urine Disease (MSUD)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2099,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000006,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (0-12 Bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2100,
    46326,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000006,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (0-12 Bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2101,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000006,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (0-12 Bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2102,
    46326,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000006,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (0-12 Bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2103,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000006,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (0-12 Bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2104,
    46339,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000006,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (0-12 Bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2105,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000006,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (0-12 Bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2106,
    46339,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000006,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (0-12 Bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2107,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000007,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (di Atas 1 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2108,
    46326,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000007,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (di Atas 1 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2109,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000007,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (di Atas 1 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2110,
    46326,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000007,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (di Atas 1 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2111,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000007,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (di Atas 1 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2112,
    46339,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000007,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (di Atas 1 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2113,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000007,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (di Atas 1 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2114,
    46339,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000007,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (di Atas 1 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2115,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000008,
    "PKMK untuk Bayi Prematur",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2116,
    46326,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000008,
    "PKMK untuk Bayi Prematur",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2117,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000008,
    "PKMK untuk Bayi Prematur",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2118,
    46339,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000008,
    "PKMK untuk Bayi Prematur",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2119,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000009,
    "PKMK untuk Pelengkap Gizi Air Susu Ibu (Human Milk Fortifier/HMF)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2120,
    46326,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000009,
    "PKMK untuk Pelengkap Gizi Air Susu Ibu (Human Milk Fortifier/HMF)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2121,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000009,
    "PKMK untuk Pelengkap Gizi Air Susu Ibu (Human Milk Fortifier/HMF)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2122,
    46339,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000009,
    "PKMK untuk Pelengkap Gizi Air Susu Ibu (Human Milk Fortifier/HMF)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2123,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000010,
    "PKMK untuk Pasien Alergi Protein Susu Sapi (bagi bayi usia 0-6bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2124,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000010,
    "PKMK untuk Pasien Alergi Protein Susu Sapi (bagi bayi usia 0-6bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2125,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000011,
    "PKMK untuk Pasien Alergi Protein Susu Sapi (bagi bayi 6 \x{2013} 12 bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2126,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000011,
    "PKMK untuk Pasien Alergi Protein Susu Sapi (bagi bayi 6 \x{2013} 12 bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2127,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000012,
    "PKMK untuk Pasien Alergi Protein Susu Sapi (bagi anak usia 1-3 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2128,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000012,
    "PKMK untuk Pasien Alergi Protein Susu Sapi (bagi anak usia 1-3 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2129,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000013,
    "PKMK untuk Diet Ketogenik Anak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2130,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000013,
    "PKMK untuk Diet Ketogenik Anak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2131,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000014,
    "PKMK untuk Bayi Intoleransi Laktosa",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2132,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000014,
    "PKMK untuk Bayi Intoleransi Laktosa",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2133,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000015,
    "PKMK untuk Pasien Malabsorpsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2134,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000015,
    "PKMK untuk Pasien Malabsorpsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2135,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000016,
    "PKMK untuk Pasien Inflammatory Bowel Diseases",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2136,
    46339,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000016,
    "PKMK untuk Pasien Inflammatory Bowel Diseases",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2137,
    46339,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130103000017,
    "PKMK untuk Pasien Malabsorpsi",
    3000000,
    2500000,
    1500000,
    "Nonaktif",
  ],
  [
    2138,
    46326,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2139,
    46326,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2140,
    46326,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2141,
    46326,
    1327,
    "Repacking Sekunder MPASI",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2142,
    46326,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2143,
    46326,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2144,
    46326,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2145,
    46326,
    1327,
    "Repacking Sekunder MPASI",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2146,
    46326,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2147,
    46326,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2148,
    46326,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2149,
    46326,
    1327,
    "Repacking Sekunder MPASI",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2150,
    46326,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2151,
    46326,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2152,
    46326,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2153,
    46326,
    1327,
    "Repacking Sekunder MPASI",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2154,
    46339,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2155,
    46339,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2156,
    46339,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2157,
    46339,
    1327,
    "Repacking Sekunder MPASI",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2158,
    46339,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2159,
    46339,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2160,
    46339,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2161,
    46339,
    1327,
    "Repacking Sekunder MPASI",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2162,
    46326,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000002,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok - Siap Masak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2163,
    46326,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000002,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok - Siap Masak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2164,
    46326,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000002,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok - Siap Masak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2165,
    46326,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000002,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok - Siap Masak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2166,
    46326,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000002,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok - Siap Masak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2167,
    46326,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000002,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok - Siap Masak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2168,
    46326,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2169,
    46326,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2170,
    46326,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2171,
    46326,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2172,
    46326,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2173,
    46326,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2174,
    46326,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2175,
    46326,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2176,
    46326,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2177,
    46326,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2178,
    46326,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2179,
    46326,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2180,
    46339,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2181,
    46339,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2182,
    46339,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2183,
    46339,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2184,
    46339,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2185,
    46339,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2186,
    46339,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2187,
    46339,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2188,
    46339,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2189,
    46339,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2190,
    46339,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2191,
    46339,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2192,
    46326,
    1309,
    "Makanan selingan untuk anak",
    130200000004,
    "Makanan Selingan Untuk Anak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2193,
    46339,
    1309,
    "Makanan selingan untuk anak",
    130200000004,
    "Makanan Selingan Untuk Anak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2194,
    46326,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000005,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi (Bubuk Instan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2195,
    46339,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000005,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi (Bubuk Instan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2196,
    46326,
    1307,
    "Makanan diet diabetes bentuk bubuk",
    130300000001,
    "PKMK untuk Penyandang Diabetes",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2197,
    46326,
    1308,
    "Makanan diet diabetes bentuk cair (UHT)",
    130300000001,
    "PKMK untuk Penyandang Diabetes",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2198,
    46326,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000002,
    "PKMK untuk Pasien Penyakit Ginjal Kronik Pradialisis)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2199,
    46326,
    1324,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk cair (steril)",
    130300000002,
    "PKMK untuk Pasien Penyakit Ginjal Kronik Pradialisis)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2200,
    46326,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000003,
    "PKMK untuk Pasien Penyakit Ginjal Kronik (dengan Terapi Dialisis)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2201,
    46326,
    1324,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk cair (steril)",
    130300000003,
    "PKMK untuk Pasien Penyakit Ginjal Kronik (dengan Terapi Dialisis)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2202,
    46326,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000004,
    "PKMK untuk Pasien Penyakit Hati Kronik",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2203,
    46326,
    1324,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk cair (steril)",
    130300000004,
    "PKMK untuk Pasien Penyakit Hati Kronik",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2204,
    46326,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000005,
    "PKMK untuk Pasien Penyakit Hati Kronik dengan Ensefalopati Hepatik (EH)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2205,
    46326,
    1324,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk cair (steril)",
    130300000005,
    "PKMK untuk Pasien Penyakit Hati Kronik dengan Ensefalopati Hepatik (EH)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2206,
    46326,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000006,
    "PKMK untuk Dukungan Nutrisi bagi Pasien Dewasa Malnutrisi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2207,
    46326,
    1324,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk cair (steril)",
    130300000006,
    "PKMK untuk Dukungan Nutrisi bagi Pasien Dewasa Malnutrisi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2208,
    46326,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000006,
    "PKMK untuk Dukungan Nutrisi bagi Pasien Dewasa Malnutrisi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2209,
    46326,
    1324,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk cair (steril)",
    130300000006,
    "PKMK untuk Dukungan Nutrisi bagi Pasien Dewasa Malnutrisi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2210,
    46326,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000007,
    "PKMK untuk Diet Ketogenik",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2211,
    46326,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000008,
    "PKMK untuk Pasien Kelainan Metabolik (Inborn Errors of Metabolism)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2212,
    46339,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000008,
    "PKMK untuk Pasien Kelainan Metabolik (Inborn Errors of Metabolism)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2213,
    46326,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130300000009,
    "PKMK untuk Anak (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2214,
    46326,
    1315,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000010,
    "PKMK untuk Dewasa (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2215,
    46326,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000010,
    "PKMK untuk Dewasa (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2216,
    46326,
    1315,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000010,
    "PKMK untuk Dewasa (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2217,
    46326,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000010,
    "PKMK untuk Dewasa (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2218,
    46339,
    1315,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000010,
    "PKMK untuk Dewasa (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2219,
    46339,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000010,
    "PKMK untuk Dewasa (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2220,
    46339,
    1315,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000010,
    "PKMK untuk Dewasa (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2221,
    46339,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000010,
    "PKMK untuk Dewasa (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2222,
    46326,
    1318,
    "Pangan olahan diet untuk kontrol berat badan bentuk biskuit",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2223,
    46326,
    1319,
    "Pangan olahan diet untuk kontrol berat badan bentuk bubuk",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2224,
    46326,
    1320,
    "Pangan olahan diet untuk kontrol berat badan bentuk cair (UHT)",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2225,
    46326,
    1318,
    "Pangan olahan diet untuk kontrol berat badan bentuk biskuit",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2226,
    46326,
    1319,
    "Pangan olahan diet untuk kontrol berat badan bentuk bubuk",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2227,
    46326,
    1320,
    "Pangan olahan diet untuk kontrol berat badan bentuk cair (UHT)",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2228,
    46326,
    1318,
    "Pangan olahan diet untuk kontrol berat badan bentuk biskuit",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2229,
    46326,
    1319,
    "Pangan olahan diet untuk kontrol berat badan bentuk bubuk",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2230,
    46326,
    1320,
    "Pangan olahan diet untuk kontrol berat badan bentuk cair (UHT)",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2231,
    46326,
    1315,
    "Pangan ibu hamil dan pangan ibu menyusui bentuk biskuit",
    130500000001,
    "Minuman Khusus Ibu Hamil  ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2232,
    46326,
    1316,
    "Pangan ibu hamil dan pangan ibu menyusui bentuk bubuk",
    130500000001,
    "Minuman Khusus Ibu Hamil  ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2233,
    46326,
    1317,
    "Pangan ibu hamil dan pangan ibu menyusui bentuk cair (UHT)",
    130500000001,
    "Minuman Khusus Ibu Hamil  ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2234,
    46326,
    1315,
    "Pangan ibu hamil dan pangan ibu menyusui bentuk biskuit",
    130500000002,
    "Minuman Khusus Ibu Menyusui ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2235,
    46326,
    1316,
    "Pangan ibu hamil dan pangan ibu menyusui bentuk bubuk",
    130500000002,
    "Minuman Khusus Ibu Menyusui ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2236,
    46326,
    1317,
    "Pangan ibu hamil dan pangan ibu menyusui bentuk cair (UHT)",
    130500000002,
    "Minuman Khusus Ibu Menyusui ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2237,
    46339,
    1325,
    "Pangan tambahan untuk olahragawan bentuk bubuk",
    130500000003,
    "Minuman Olahraga",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2238,
    46339,
    1326,
    "Pangan tambahan untuk olahragawan bentuk cair (UHT)",
    130500000003,
    "Minuman Olahraga",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2239,
    46339,
    1325,
    "Pangan tambahan untuk olahragawan bentuk bubuk",
    130500000004,
    "Pangan Tambahan Untuk Olahragawan Berbasis Karbohidrat",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2240,
    46339,
    1326,
    "Pangan tambahan untuk olahragawan bentuk cair (UHT)",
    130500000004,
    "Pangan Tambahan Untuk Olahragawan Berbasis Karbohidrat",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2241,
    46339,
    1325,
    "Pangan tambahan untuk olahragawan bentuk bubuk",
    130500000004,
    "Pangan Tambahan Untuk Olahragawan Berbasis Karbohidrat",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2242,
    46339,
    1326,
    "Pangan tambahan untuk olahragawan bentuk cair (UHT)",
    130500000004,
    "Pangan Tambahan Untuk Olahragawan Berbasis Karbohidrat",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2243,
    46339,
    1325,
    "Pangan tambahan untuk olahragawan bentuk bubuk",
    130500000005,
    "Pangan Tambahan Untuk Olahragawan Berbasis Protein",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2244,
    46339,
    1326,
    "Pangan tambahan untuk olahragawan bentuk cair (UHT)",
    130500000005,
    "Pangan Tambahan Untuk Olahragawan Berbasis Protein",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2245,
    46339,
    1325,
    "Pangan tambahan untuk olahragawan bentuk bubuk",
    130500000006,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Protein",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2246,
    46339,
    1326,
    "Pangan tambahan untuk olahragawan bentuk cair (UHT)",
    130500000006,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Protein",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2247,
    46334,
    1401,
    "Air minum dalam kemasan",
    140101010001,
    "Air Mineral Alami",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2248,
    46334,
    1401,
    "Air minum dalam kemasan",
    140101020001,
    "Air Mineral",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2249,
    46334,
    1401,
    "Air minum dalam kemasan",
    140101020002,
    "Air Demineral",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2250,
    46334,
    1401,
    "Air minum dalam kemasan",
    140101020003,
    "Air Minum Embun",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2251,
    46334,
    1401,
    "Air minum dalam kemasan",
    140101020004,
    "Air Minum Embun/Mineral/Demineral Beroksigen",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2252,
    46334,
    1403,
    "Air soda/air berkarbonat/sparkling water",
    140101020005,
    "Air Minum Embun/Mineral/Demineral Berkarbonat",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2253,
    46334,
    1403,
    "Air soda/air berkarbonat/sparkling water",
    140101020006,
    "Air Soda",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2254,
    46334,
    1402,
    "Air minum ph tinggi",
    140101020007,
    "Air Minum pH Tinggi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2255,
    46334,
    1410,
    "Minuman ringan karbonasi",
    140101020008,
    "Air Minum Olahan dengan Penambahan Garam Mineral",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2256,
    46334,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140101020008,
    "Air Minum Olahan dengan Penambahan Garam Mineral",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2257,
    46334,
    1410,
    "Minuman ringan karbonasi",
    140101020008,
    "Air Minum Olahan dengan Penambahan Garam Mineral",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2258,
    46334,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140101020008,
    "Air Minum Olahan dengan Penambahan Garam Mineral",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2259,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010001,
    "Sari Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2260,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010001,
    "Sari Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2261,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010002,
    "Sari Buah Campuran",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2262,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010003,
    "Sari Buah dan Sari Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2263,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010004,
    "Sari Jeruk Nipis (Lime Juice)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2264,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010005,
    "Sari Buah Apel",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2265,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010006,
    "Sari Buah Jeruk Bali",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2266,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010007,
    "Sari Buah Jeruk Orange, Valencia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2267,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010008,
    "Sari Buah Jeruk Siam, Tangerine, Jeruk Pontianak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2268,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010009,
    "Sari Buah Jeruk Garut",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2269,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010010,
    "Sari Buah Jeruk Medan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2270,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010011,
    "Sari Buah Nanas",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2271,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010012,
    "Sari Buah Lemon",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2272,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010013,
    "Sari Buah Markisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2273,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010014,
    "Sari Buah Anggur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2274,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010015,
    "Sari Buah Prune (Prune Juice)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2275,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010016,
    "Sari Buah Blackcurrant",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2276,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010017,
    "Sari Buah Mangga",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2277,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010018,
    "Sari Buah Sirsak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2278,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010019,
    "Sari Buah Belimbing",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2279,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010020,
    "Sari Buah Plum",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2280,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010021,
    "Sari Buah Peach",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2281,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010022,
    "Sari Buah Jambu Biji",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2282,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010023,
    "Sari Buah Delima",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2283,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010024,
    "Sari Buah Pir",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2284,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010025,
    "Sari Buah Redcurrant",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2285,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010026,
    "Sari Buah Blackberry",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2286,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010027,
    "Sari Buah Raspberry",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2287,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010028,
    "Sari Buah Stroberi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2288,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010029,
    "Sari Buah Blueberry",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2289,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010030,
    "Sari Buah Manggis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2290,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010031,
    "Sari Buah Terong Belanda",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2291,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010032,
    "Sari Buah Leci",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2292,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010033,
    "Sari Buah Kiwi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2293,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010034,
    "Sari Buah Naga",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2294,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010035,
    "Sari Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2295,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010036,
    "Sari Tomat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2296,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010037,
    "Sari Wortel",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2297,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010038,
    "Sari Sayur Campuran",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2298,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010039,
    "Sari Sayur dan Sari Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2299,
    46334,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030001,
    "Konsentrat Sari Buah Jeruk Orange, Valencia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2300,
    46334,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030002,
    "Konsentrat Sari Buah Jeruk Siam, Tangerine",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2301,
    46334,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030003,
    "Konsentrat Sari Buah Apel",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2302,
    46334,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030004,
    "Konsentrat Sari Buah Anggur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2303,
    46334,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030005,
    "Konsentrat Sari Buah Anggur Manis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2304,
    46334,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030006,
    "Konsentrat Sari Buah Blackcurrant",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2305,
    46334,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030007,
    "Konsentrat Sari Buah Nanas",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2306,
    46334,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030008,
    "Konsentrat Minuman Sari Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2307,
    46334,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030009,
    "Konsentrat Minuman Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2308,
    46334,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030010,
    "Konsentrat Sari Buah dan Sari Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2309,
    46334,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102040001,
    "Konsentrat Sari Tomat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2310,
    46334,
    1415,
    "Nektar buah/sayur",
    140103010001,
    "Nektar Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2311,
    46334,
    1415,
    "Nektar buah/sayur",
    140103010002,
    "Nektar Buah Kecil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2312,
    46334,
    1415,
    "Nektar buah/sayur",
    140103010003,
    "Nektar Buah Campuran",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2313,
    46334,
    1415,
    "Nektar buah/sayur",
    140103010004,
    "Nektar Aprikot, Nektar Peach atau Nektar Pear/Pir",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2314,
    46334,
    1415,
    "Nektar buah/sayur",
    140103010005,
    "Nektar Blackcurrant",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2315,
    46334,
    1415,
    "Nektar buah/sayur",
    140103010006,
    "Nektar Buah Citrus",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2316,
    46334,
    1415,
    "Nektar buah/sayur",
    140103010007,
    "Nektar Jambu Biji",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2317,
    46334,
    1415,
    "Nektar buah/sayur",
    140103010008,
    "Nektar Mangga",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2318,
    46334,
    1415,
    "Nektar buah/sayur",
    140103010009,
    "Nektar Sirsak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2319,
    46334,
    1415,
    "Nektar buah/sayur",
    140103020001,
    "Nektar Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2320,
    46334,
    1415,
    "Nektar buah/sayur",
    140103030001,
    "Konsentrat Nektar Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2321,
    46334,
    1415,
    "Nektar buah/sayur",
    140103040001,
    "Konsentrat Nektar Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2322,
    46334,
    1413,
    "Minuman sari buah",
    140104010001,
    "Minuman Sari Buah Berkarbonat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2323,
    46334,
    1409,
    "Minuman buah",
    140104010002,
    "Minuman Buah Berkarbonat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2324,
    46334,
    1410,
    "Minuman ringan karbonasi",
    140104010003,
    "Minuman Berperisa Berkarbonat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2325,
    46334,
    1410,
    "Minuman ringan karbonasi",
    140104010004,
    "Minuman Rasa Susu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2326,
    46334,
    1410,
    "Minuman ringan karbonasi",
    140104010005,
    "Ginger Ale",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2327,
    46334,
    1410,
    "Minuman ringan karbonasi",
    140104010006,
    "Sarsaparilla",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2328,
    46334,
    1410,
    "Minuman ringan karbonasi",
    140104010007,
    "Root Beer",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2329,
    46334,
    1410,
    "Minuman ringan karbonasi",
    140104010008,
    "Birch Beer",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2330,
    46334,
    1410,
    "Minuman ringan karbonasi",
    140104010009,
    "Soda Krim (Cream soda)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2331,
    46334,
    1410,
    "Minuman ringan karbonasi",
    140104010010,
    "Minuman Citrus",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2332,
    46334,
    1410,
    "Minuman ringan karbonasi",
    140104010011,
    "Minuman Citrus Comminutes",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2333,
    46334,
    1410,
    "Minuman ringan karbonasi",
    140104010012,
    "Minuman Kola",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2334,
    46334,
    1410,
    "Minuman ringan karbonasi",
    140104010013,
    "Limun",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2335,
    46334,
    1410,
    "Minuman ringan karbonasi",
    140104010014,
    "Minuman Fermentasi Berkarbonasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2336,
    46334,
    1410,
    "Minuman ringan karbonasi",
    140104010015,
    "Minuman Teh Fermentasi (Kombucha) Berkarbonasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2337,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020001,
    "Punches/Ades",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2338,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020002,
    "Crush",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2339,
    46334,
    1413,
    "Minuman sari buah",
    140104020003,
    "Minuman Sari Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2340,
    46334,
    1413,
    "Minuman Sari Buah",
    140104020003,
    "Minuman Sari Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2341,
    46334,
    1409,
    "Minuman buah",
    140104020004,
    "Minuman Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2342,
    46334,
    1409,
    "Minuman buah",
    140104020004,
    "Minuman Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2343,
    46334,
    1411,
    "Minuman ringan non karbonasi pH = 4,6",
    140104020005,
    "Minuman Rasa Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2344,
    46334,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140104020005,
    "Minuman Rasa Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2345,
    46334,
    1411,
    "Minuman ringan non karbonasi pH = 4,6",
    140104020005,
    "Minuman Rasa Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2346,
    46334,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140104020005,
    "Minuman Rasa Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2347,
    46334,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140104020006,
    "Minuman Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2348,
    46334,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140104020006,
    "Minuman Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2349,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020007,
    "Minuman Jeli",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2350,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020007,
    "Minuman Jeli",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2351,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020008,
    "Minuman Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2352,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020008,
    "Minuman Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2353,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020008,
    "Minuman Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2354,
    46314,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020009,
    "Minuman Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2355,
    46314,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020009,
    "Minuman Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2356,
    46314,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020009,
    "Minuman Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2357,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020009,
    "Minuman Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2358,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020009,
    "Minuman Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2359,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020009,
    "Minuman Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2360,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020010,
    "Kapucino",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2361,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020011,
    "Minuman Rasa Susu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2362,
    46334,
    1409,
    "Minuman buah",
    140104020012,
    "Minuman Citrus Comminutes",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2363,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020013,
    "Minuman Teh Fermentasi (Kombucha)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2364,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020013,
    "Minuman Teh Fermentasi (Kombucha)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2365,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020014,
    "Minuman Fermentasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2366,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020014,
    "Minuman Fermentasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2367,
    46334,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140104020015,
    "Minuman dengan Penambahan Garam Mineral",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2368,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020016,
    "Minuman Teh Fermentasi (Kombucha)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2369,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020016,
    "Minuman Teh Fermentasi (Kombucha)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2370,
    46334,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal ",
    140104020017,
    "Minuman dengan Larutan Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2371,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya ",
    140104020017,
    "Minuman dengan Larutan Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2372,
    46334,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal ",
    140104020017,
    "Minuman dengan Larutan Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2373,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya ",
    140104020017,
    "Minuman dengan Larutan Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2374,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020019,
    "Minuman Kacang-Kacangan, Biji-bijian, dan Bahan Nabati Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2375,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030001,
    "Konsentrat Lemonade Beku",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2376,
    46334,
    1414,
    "Minuman serbuk",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2377,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2378,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2379,
    46334,
    1414,
    "Minuman serbuk",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2380,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2381,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2382,
    46334,
    1414,
    "Minuman serbuk",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2383,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2384,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2385,
    46334,
    1414,
    "Minuman serbuk",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2386,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2387,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2388,
    46334,
    1414,
    "Minuman serbuk",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2389,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2390,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2391,
    46334,
    1414,
    "Minuman serbuk",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2392,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2393,
    46334,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2394,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030003,
    "Squash",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2395,
    46334,
    1422,
    "Sirup dan Squash",
    140104030003,
    "Squash",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2396,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030003,
    "Squash",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2397,
    46334,
    1422,
    "Sirup dan Squash",
    140104030003,
    "Squash",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2398,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030004,
    "Squash Berperisa/Rasa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2399,
    46334,
    1422,
    "Sirup dan Squash",
    140104030004,
    "Squash Berperisa/Rasa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2400,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030004,
    "Squash Berperisa/Rasa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2401,
    46334,
    1422,
    "Sirup dan Squash",
    140104030004,
    "Squash Berperisa/Rasa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2402,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030005,
    "Sirup Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2403,
    46334,
    1422,
    "Sirup dan Squash",
    140104030005,
    "Sirup Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2404,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030005,
    "Sirup Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2405,
    46334,
    1422,
    "Sirup dan Squash",
    140104030005,
    "Sirup Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2406,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030006,
    "Sirup Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2407,
    46334,
    1422,
    "Sirup dan Squash",
    140104030006,
    "Sirup Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2408,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030006,
    "Sirup Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2409,
    46334,
    1422,
    "Sirup dan Squash",
    140104030006,
    "Sirup Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2410,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030007,
    "Sirup Encer Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2411,
    46334,
    1422,
    "Sirup dan Squash",
    140104030007,
    "Sirup Encer Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2412,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030007,
    "Sirup Encer Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2413,
    46334,
    1422,
    "Sirup dan Squash",
    140104030007,
    "Sirup Encer Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2414,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030008,
    "Sirup Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2415,
    46334,
    1422,
    "Sirup dan Squash",
    140104030008,
    "Sirup Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2416,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030008,
    "Sirup Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2417,
    46334,
    1422,
    "Sirup dan Squash",
    140104030008,
    "Sirup Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2418,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030009,
    "Sirup Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2419,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030010,
    "Pengganti Sirup Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2420,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030011,
    "Pengganti Squash Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2421,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030012,
    "Pengganti Sirup Encer Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2422,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030013,
    "Konsentrat Minuman Cuka/ Konsentrat Minuman Vinegar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2423,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000001,
    "Teh Hitam",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2424,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000001,
    "Teh Hitam",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2425,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000002,
    "Teh Hijau",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2426,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000002,
    "Teh Hijau",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2427,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000003,
    "Teh Putih",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2428,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000003,
    "Teh Putih",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2429,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000004,
    "Teh Wangi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2430,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000004,
    "Teh Wangi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2431,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000005,
    "Teh Olong atau Teh Semi Fermentasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2432,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000005,
    "Teh Olong atau Teh Semi Fermentasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2433,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000006,
    "Teh Hijau Bubuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2434,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000006,
    "Teh Hijau Bubuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2435,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000007,
    "Teh Kering",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2436,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000007,
    "Teh Kering",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2437,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000008,
    "Teh Hitam Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2438,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000008,
    "Teh Hitam Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2439,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000009,
    "Teh Wangi Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2440,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000009,
    "Teh Wangi Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2441,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000010,
    "Teh Hijau Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2442,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000010,
    "Teh Hijau Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2443,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000011,
    "Teh Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2444,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000011,
    "Teh Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2445,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000012,
    "Teh Instan Dekafein",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2446,
    46314,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000012,
    "Teh Instan Dekafein",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2447,
    46314,
    1406,
    "Konsentrat teh",
    140105000013,
    "Konsentrat Minuman Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2448,
    46334,
    1414,
    "Minuman serbuk",
    140105000014,
    "Minuman Serbuk Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2449,
    46334,
    1414,
    "Minuman serbuk",
    140105000014,
    "Minuman Serbuk Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2450,
    46314,
    1407,
    "Kopi",
    140105000015,
    "Biji Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2451,
    46314,
    1407,
    "Kopi",
    140105000016,
    "Kopi Bubuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2452,
    46314,
    1407,
    "Kopi",
    140105000016,
    "Kopi Bubuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2453,
    46314,
    1407,
    "Kopi",
    140105000017,
    "Kopi Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2454,
    46314,
    1407,
    "Kopi",
    140105000017,
    "Kopi Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2455,
    46314,
    1407,
    "Kopi",
    140105000018,
    "Kopi Campur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2456,
    46334,
    1407,
    "Kopi",
    140105000019,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2457,
    46334,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140105000019,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2458,
    46334,
    1407,
    "Kopi",
    140105000019,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2459,
    46334,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140105000019,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2460,
    46314,
    1404,
    "Konsentrat kopi",
    140105000020,
    "Konsentrat Minuman Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2461,
    46314,
    1407,
    "Kopi",
    140105000021,
    "Kopi Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2462,
    46314,
    1407,
    "Kopi",
    140105000021,
    "Kopi Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2463,
    46314,
    1407,
    "Kopi",
    140105000022,
    "Kopi Dekafein",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2464,
    46314,
    1407,
    "Kopi",
    140105000023,
    "Kopi Instan Dekafein",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2465,
    46314,
    1407,
    "Kopi",
    140105000023,
    "Kopi Instan Dekafein",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2466,
    46314,
    1414,
    "Minuman serbuk",
    140105000024,
    "Minuman Serbuk Kopi Susu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2467,
    46314,
    1414,
    "Minuman serbuk",
    140105000024,
    "Minuman Serbuk Kopi Susu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2468,
    46314,
    1414,
    "Minuman serbuk",
    140105000025,
    "Minuman Serbuk Kopi Krimer",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2469,
    46314,
    1414,
    "Minuman serbuk",
    140105000025,
    "Minuman Serbuk Kopi Krimer",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2470,
    46314,
    1414,
    "Minuman serbuk",
    140105000026,
    "Minuman Serbuk Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2471,
    46314,
    1414,
    "Minuman serbuk",
    140105000026,
    "Minuman Serbuk Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2472,
    46334,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140105000027,
    "Minuman Botanikal/Minuman Rempah (Bentuk Padat atau Cair)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2473,
    46334,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140105000027,
    "Minuman Botanikal/Minuman Rempah (Bentuk Padat atau Cair)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2474,
    46334,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140105000027,
    "Minuman Botanikal/Minuman Rempah (Bentuk Padat atau Cair)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2475,
    46334,
    1414,
    "Minuman serbuk",
    140105000028,
    "Serbuk Sekoteng",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2476,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140105000029,
    "Minuman Sari Kacang Hijau",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2477,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140105000029,
    "Minuman Sari Kacang Hijau",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2478,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140105000029,
    "Minuman Sari Kacang Hijau",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2479,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140105000030,
    "Serealia Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2480,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140105000031,
    "Minuman Serealia",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2481,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140105000032,
    "Minuman Mengandung Sereal/Minuman Mengandung Serealia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2482,
    46334,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140105000032,
    "Minuman Mengandung Sereal/Minuman Mengandung Serealia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2483,
    46314,
    1414,
    "Minuman serbuk ",
    140105000033,
    "Minuman Teh Fermentasi (Kombucha) Serbuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2484,
    46314,
    1414,
    "Minuman serbuk ",
    140105000033,
    "Minuman Teh Fermentasi (Kombucha) Serbuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2485,
    46334,
    1414,
    "Minuman serbuk ",
    140105000033,
    "Minuman Teh Fermentasi (Kombucha) Serbuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2486,
    46334,
    1414,
    "Minuman serbuk ",
    140105000033,
    "Minuman Teh Fermentasi (Kombucha) Serbuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2487,
    46334,
    1414,
    "Minuman serbuk ",
    140105000034,
    "Minuman Serbuk Biji Salak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2488,
    46334,
    1414,
    "Minuman serbuk ",
    140105000034,
    "Minuman Serbuk Biji Salak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2489,
    46334,
    1414,
    "Minuman serbuk ",
    140105000035,
    "Minuman Serbuk Kulit Pisang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2490,
    46334,
    1414,
    "Minuman serbuk ",
    140105000035,
    "Minuman Serbuk Kulit Pisang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2491,
    46333,
    1408,
    "Minuman beralkohol",
    140201000001,
    "Bir",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2492,
    46333,
    1408,
    "Minuman beralkohol",
    140201000002,
    "Bir Hitam (Stout)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2493,
    46333,
    1408,
    "Minuman beralkohol",
    140202000001,
    "Cider atau Anggur Apel",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2494,
    46333,
    1408,
    "Minuman beralkohol",
    140202000002,
    "Perry",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2495,
    46333,
    1408,
    "Minuman beralkohol",
    140203000001,
    "Anggur (Grape Wine)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2496,
    46333,
    1408,
    "Minuman beralkohol",
    140203010001,
    "Still Grape Wine",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2497,
    46333,
    1408,
    "Minuman beralkohol",
    140203020001,
    "Anggur Sparkling dan Semi Sparkling",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2498,
    46333,
    1408,
    "Minuman beralkohol",
    140203030001,
    "Anggur Fortifikasi, Anggur Liqueur dan Anggur Manis",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2499,
    46333,
    1408,
    "Minuman beralkohol",
    140204000001,
    "Anggur Buah",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2500,
    46333,
    1408,
    "Minuman beralkohol",
    140204000002,
    "Anggur Beras",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2501,
    46333,
    1408,
    "Minuman beralkohol",
    140204000003,
    "Anggur Beras Ketan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2502,
    46333,
    1408,
    "Minuman beralkohol",
    140204000004,
    "Anggur Brem Bali",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2503,
    46333,
    1408,
    "Minuman beralkohol",
    140204000005,
    "Anggur Sayur (Vegetable Wine)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2504,
    46333,
    1408,
    "Minuman beralkohol",
    140204000006,
    "Tuak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2505,
    46333,
    1408,
    "Minuman beralkohol",
    140204000007,
    "Anggur Tonikum Kinina",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2506,
    46333,
    1408,
    "Minuman beralkohol",
    140204000008,
    "Sake",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2507,
    46333,
    1408,
    "Minuman beralkohol",
    140205000001,
    "Mead, Anggur Madu",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2508,
    46333,
    1408,
    "Minuman beralkohol",
    140206000001,
    "Minuman Spirit",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2509,
    46333,
    1408,
    "Minuman beralkohol",
    140206000002,
    "Brandy",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2510,
    46333,
    1408,
    "Minuman beralkohol",
    140206000003,
    "Brandy Buah",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2511,
    46333,
    1408,
    "Minuman beralkohol",
    140206000004,
    "Cognac",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2512,
    46333,
    1408,
    "Minuman beralkohol",
    140206000005,
    "Rum",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2513,
    46333,
    1408,
    "Minuman beralkohol",
    140206000006,
    "Whisky",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2514,
    46333,
    1408,
    "Minuman beralkohol",
    140206000007,
    "Gin",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2515,
    46333,
    1408,
    "Minuman beralkohol",
    140206000008,
    "Vodka",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2516,
    46333,
    1408,
    "Minuman beralkohol",
    140206000009,
    "Tequila",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2517,
    46333,
    1408,
    "Minuman beralkohol",
    140206000010,
    "Arak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2518,
    46333,
    1408,
    "Minuman beralkohol",
    140206000011,
    "Genever",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2519,
    46333,
    1408,
    "Minuman beralkohol",
    140206000012,
    "Liqueur",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2520,
    46333,
    1408,
    "Minuman beralkohol",
    140206000013,
    "Soju",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2521,
    46333,
    1408,
    "Minuman beralkohol",
    140207000001,
    "Minuman Ringan Beralkohol",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2522,
    46333,
    1408,
    "Minuman beralkohol",
    140207000002,
    "Shandy",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2523,
    46333,
    1408,
    "Minuman beralkohol",
    140207000003,
    "Anggur Rendah Alkohol",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2524,
    46333,
    1408,
    "Minuman beralkohol",
    140207000004,
    "Koktail Anggur (Wine Cocktail)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2525,
    46333,
    1408,
    "Minuman beralkohol",
    140207000005,
    "Meat Wine",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2526,
    46333,
    1408,
    "Minuman beralkohol",
    140207000006,
    "Anggur Mengandung bahan pangan lain (antara lain : Ginseng/kolesom/temulawak)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2527,
    46333,
    1408,
    "Minuman beralkohol",
    140207000007,
    "Minuman Beralkohol Golongan A",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2528,
    46333,
    1408,
    "Minuman beralkohol",
    140207000007,
    "Minuman Beralkohol Golongan A",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2529,
    46333,
    1408,
    "Minuman beralkohol",
    140207000007,
    "Minuman Beralkohol Golongan A",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2530,
    46333,
    1408,
    "Minuman beralkohol",
    140207000008,
    "Minuman Beralkohol Golongan B",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2531,
    46333,
    1408,
    "Minuman beralkohol",
    140207000008,
    "Minuman Beralkohol Golongan B",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2532,
    46333,
    1408,
    "Minuman beralkohol",
    140207000008,
    "Minuman Beralkohol Golongan B",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2533,
    46333,
    1408,
    "Minuman beralkohol",
    140207000009,
    "Minuman Beralkohol Golongan C",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2534,
    46333,
    1408,
    "Minuman beralkohol",
    140207000009,
    "Minuman Beralkohol Golongan C",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2535,
    46333,
    1408,
    "Minuman beralkohol",
    140207000009,
    "Minuman Beralkohol Golongan C",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2536,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000001,
    "Keripik Kentang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2537,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000001,
    "Keripik Kentang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2538,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000001,
    "Keripik Kentang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2539,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000001,
    "Keripik Kentang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2540,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000002,
    "Keripik Gadung",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2541,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000003,
    "Krekers Beras (Senbei)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2542,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000003,
    "Krekers Beras (Senbei)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2543,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000004,
    "Keripik Singkong ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2544,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000004,
    "Keripik Singkong ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2545,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000005,
    "Dakak-dakak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2546,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000006,
    "Lanting/Karak Kaliang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2547,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000007,
    "Keripik Ubi Jalar  ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2548,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000008,
    "Keripik Tempe ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2549,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000009,
    "Keripik Oncom ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2550,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000010,
    "Keripik Tahu/Keripik Produk Tahu/Keripik Kembang Tahu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2551,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000011,
    "Keripik Talas",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2552,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000012,
    "Makanan Ringan Simulasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2553,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000012,
    "Makanan Ringan Simulasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2554,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000012,
    "Makanan Ringan Simulasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2555,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000012,
    "Makanan Ringan Simulasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2556,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000012,
    "Makanan Ringan Simulasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2557,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000013,
    "Kecimpring ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2558,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000014,
    "Opak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2559,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000015,
    "Simping",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2560,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000016,
    "Slondok",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2561,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000017,
    "Pilus",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2562,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000018,
    "Jagung Berondong",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2563,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000018,
    "Jagung Berondong",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2564,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000019,
    "Jagung Marning",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2565,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000019,
    "Jagung Marning",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2566,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000020,
    "Jipang Jagung ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2567,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000020,
    "Jipang Jagung ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2568,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000021,
    "Jipang Beras",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2569,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000022,
    "Jipang Melinjo ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2570,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000023,
    "Kerupuk Beras ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2571,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000023,
    "Kerupuk Beras ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2572,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000024,
    "Kerupuk Karak ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2573,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000025,
    "Kerupuk Intip ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2574,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000026,
    "Rengginang/Batiah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2575,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000027,
    "Patilo / Rengginang Singkong",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2576,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000028,
    "Rempeyek ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2577,
    46339,
    1504,
    "Makanan ringan ekstrudat",
    150100000029,
    "Makanan Ringan Ekstrudat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2578,
    46339,
    1504,
    "Makanan ringan ekstrudat",
    150100000029,
    "Makanan Ringan Ekstrudat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2579,
    46339,
    1504,
    "Makanan ringan ekstrudat",
    150100000029,
    "Makanan Ringan Ekstrudat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2580,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000030,
    "Emping Melinjo Goreng",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2581,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000031,
    "Makanan Ringan Berbentuk Batang/Bar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2582,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000031,
    "Makanan Ringan Berbentuk Batang/Bar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2583,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000031,
    "Makanan Ringan Berbentuk Batang/Bar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2584,
    46339,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000031,
    "Makanan Ringan Berbentuk Batang/Bar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2585,
    46332,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000032,
    "Krekers Rasa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2586,
    46332,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000033,
    "Krekers Sandwich ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2587,
    46332,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000034,
    "Malkist ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2588,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2589,
    46339,
    "0415",
    "Rumput laut kering",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2590,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2591,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2592,
    46339,
    "0415",
    "Rumput laut kering",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2593,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2594,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2595,
    46339,
    "0415",
    "Rumput laut kering",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2596,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2597,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2598,
    46339,
    "0415",
    "Rumput laut kering",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2599,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2600,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2601,
    46339,
    "0415",
    "Rumput laut kering",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2602,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2603,
    46339,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2604,
    46339,
    "0415",
    "Rumput laut kering",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2605,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2606,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000001,
    "Kacang Garing/Kacang Kulit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2607,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000002,
    "Kacang Sangrai ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2608,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000003,
    "Kacang Goreng",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2609,
    46319,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000004,
    "Kacang Goreng Lainnya ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2610,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000004,
    "Kacang Goreng Lainnya ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2611,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000005,
    "Kacang Bawang / Kacang Tojin",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2612,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000006,
    "Kacang Panggang ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2613,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000007,
    "Kacang Panggang Lainnya ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2614,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000007,
    "Kacang Panggang Lainnya ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2615,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000008,
    "Kacang Atom/Sukro ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2616,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000009,
    "Kacang Atom Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2617,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000010,
    "Kacang Telur ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2618,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000011,
    "Kacang Goyang ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2619,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000012,
    "Jipang/Kipang Kacang ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2620,
    46339,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000013,
    "Kacang Bersalut",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2621,
    46324,
    1503,
    "Makanan ringan berbasis ikan",
    150300000001,
    "Kerupuk Hasil Perikanan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2622,
    46324,
    1503,
    "Makanan ringan berbasis ikan",
    150300000001,
    "Kerupuk Hasil Perikanan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2623,
    46324,
    1503,
    "Makanan ringan berbasis ikan",
    150300000002,
    "Rempeyek Ikan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2624,
    46324,
    1503,
    "Makanan ringan berbasis ikan",
    150300000003,
    "Sumpia Udang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2625,
    46339,
    1601,
    "Pangan siap saji terkemas",
    160000000001,
    "Makanan Siap Saji Berbasis Nasi (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2626,
    46339,
    1601,
    "Pangan siap saji terkemas",
    160000000002,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2627,
    46339,
    1601,
    "Pangan siap saji terkemas",
    160000000003,
    "Makanan Siap Saji Berbasis Kentang (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2628,
    46339,
    1601,
    "Pangan siap saji terkemas",
    160000000004,
    "Makanan Siap Saji Berbasis Pasta (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2629,
    46339,
    1601,
    "Pangan siap saji terkemas",
    160000000005,
    "Makanan Siap Saji Berbasis Umbi (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2630,
    46339,
    1601,
    "Pangan siap saji terkemas",
    160000000006,
    "Makanan Siap Saji Berbasis Roti (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2631,
    46339,
    1601,
    "Pangan siap saji terkemas",
    160000000006,
    "Makanan Siap Saji Berbasis Roti (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2632,
    46339,
    1601,
    "Pangan siap saji terkemas",
    160000000007,
    "Makanan Siap Saji Berbasis Kuah (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2633,
    46339,
    1601,
    "Pangan siap saji terkemas",
    160000000008,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2634,
    46339,
    1601,
    "Pangan siap saji terkemas",
    160000000009,
    "Makanan Siap Saji Berbasis Bahan Lain",
    300000,
    200000,
    150000,
    "Aktif",
  ],
];
# END FRAGMENT id=data-idn_bpom_jenis_pangan_rba_importir

my $res = gen_read_table_func(
    name => 'bpom_list_food_types_rba_importer',
    summary => 'List food types in BPOM processed food division (RBA version, for importers)',
    table_data => $data_idn_bpom_jenis_pangan_rba_importir,
    table_spec => $meta_idn_bpom_jenis_pangan_rba_importir,
    description => <<'_',
_
    extra_props => {
        examples => [
        ],
    },
);
die "Can't generate function: $res->[0] - $res->[1]" unless $res->[0] == 200;

1;
# ABSTRACT: List food types in BPOM processed food division (RBA version, for importers)

__END__

=pod

=encoding UTF-8

=head1 NAME

App::BPOMUtils::Table::FoodTypeRBAImporter - List food types in BPOM processed food division (RBA version, for importers)

=head1 VERSION

This document describes version 0.021 of App::BPOMUtils::Table::FoodTypeRBAImporter (from Perl distribution App-BPOMUtils-Table-FoodType), released on 2025-05-22.

=head1 FUNCTIONS


=head2 bpom_list_food_types_rba_importer

Usage:

 bpom_list_food_types_rba_importer(%args) -> [$status_code, $reason, $payload, \%result_meta]

List food types in BPOM processed food division (RBA version, for importers).

This function is not exported by default, but exportable.

Arguments ('*' denotes required arguments):

=over 4

=item * B<category_code> => I<str>

Only return records where the 'category_code' field equals specified value.

=item * B<category_code.contains> => I<str>

Only return records where the 'category_code' field contains specified text.

=item * B<category_code.in> => I<array[str]>

Only return records where the 'category_code' field is in the specified values.

=item * B<category_code.is> => I<str>

Only return records where the 'category_code' field equals specified value.

=item * B<category_code.isnt> => I<str>

Only return records where the 'category_code' field does not equal specified value.

=item * B<category_code.matches> => I<str>

Only return records where the 'category_code' field matches specified regular expression pattern.

=item * B<category_code.max> => I<str>

Only return records where the 'category_code' field is less than or equal to specified value.

=item * B<category_code.min> => I<str>

Only return records where the 'category_code' field is greater than or equal to specified value.

=item * B<category_code.not_contains> => I<str>

Only return records where the 'category_code' field does not contain specified text.

=item * B<category_code.not_in> => I<array[str]>

Only return records where the 'category_code' field is not in the specified values.

=item * B<category_code.not_matches> => I<str>

Only return records where the 'category_code' field does not match specified regular expression.

=item * B<category_code.xmax> => I<str>

Only return records where the 'category_code' field is less than specified value.

=item * B<category_code.xmin> => I<str>

Only return records where the 'category_code' field is greater than specified value.

=item * B<detail> => I<bool> (default: 0)

Return array of full records instead of just ID fields.

By default, only the key (ID) field is returned per result entry.

=item * B<dosage_form_code> => I<str>

Only return records where the 'dosage_form_code' field equals specified value.

=item * B<dosage_form_code.contains> => I<str>

Only return records where the 'dosage_form_code' field contains specified text.

=item * B<dosage_form_code.in> => I<array[str]>

Only return records where the 'dosage_form_code' field is in the specified values.

=item * B<dosage_form_code.is> => I<str>

Only return records where the 'dosage_form_code' field equals specified value.

=item * B<dosage_form_code.isnt> => I<str>

Only return records where the 'dosage_form_code' field does not equal specified value.

=item * B<dosage_form_code.matches> => I<str>

Only return records where the 'dosage_form_code' field matches specified regular expression pattern.

=item * B<dosage_form_code.max> => I<str>

Only return records where the 'dosage_form_code' field is less than or equal to specified value.

=item * B<dosage_form_code.min> => I<str>

Only return records where the 'dosage_form_code' field is greater than or equal to specified value.

=item * B<dosage_form_code.not_contains> => I<str>

Only return records where the 'dosage_form_code' field does not contain specified text.

=item * B<dosage_form_code.not_in> => I<array[str]>

Only return records where the 'dosage_form_code' field is not in the specified values.

=item * B<dosage_form_code.not_matches> => I<str>

Only return records where the 'dosage_form_code' field does not match specified regular expression.

=item * B<dosage_form_code.xmax> => I<str>

Only return records where the 'dosage_form_code' field is less than specified value.

=item * B<dosage_form_code.xmin> => I<str>

Only return records where the 'dosage_form_code' field is greater than specified value.

=item * B<dosage_form_name> => I<str>

Only return records where the 'dosage_form_name' field equals specified value.

=item * B<dosage_form_name.contains> => I<str>

Only return records where the 'dosage_form_name' field contains specified text.

=item * B<dosage_form_name.in> => I<array[str]>

Only return records where the 'dosage_form_name' field is in the specified values.

=item * B<dosage_form_name.is> => I<str>

Only return records where the 'dosage_form_name' field equals specified value.

=item * B<dosage_form_name.isnt> => I<str>

Only return records where the 'dosage_form_name' field does not equal specified value.

=item * B<dosage_form_name.matches> => I<str>

Only return records where the 'dosage_form_name' field matches specified regular expression pattern.

=item * B<dosage_form_name.max> => I<str>

Only return records where the 'dosage_form_name' field is less than or equal to specified value.

=item * B<dosage_form_name.min> => I<str>

Only return records where the 'dosage_form_name' field is greater than or equal to specified value.

=item * B<dosage_form_name.not_contains> => I<str>

Only return records where the 'dosage_form_name' field does not contain specified text.

=item * B<dosage_form_name.not_in> => I<array[str]>

Only return records where the 'dosage_form_name' field is not in the specified values.

=item * B<dosage_form_name.not_matches> => I<str>

Only return records where the 'dosage_form_name' field does not match specified regular expression.

=item * B<dosage_form_name.xmax> => I<str>

Only return records where the 'dosage_form_name' field is less than specified value.

=item * B<dosage_form_name.xmin> => I<str>

Only return records where the 'dosage_form_name' field is greater than specified value.

=item * B<exclude_fields> => I<array[str]>

Select fields to return.

=item * B<fields> => I<array[str]>

Select fields to return.

=item * B<id> => I<int>

Only return records where the 'id' field equals specified value.

=item * B<id.in> => I<array[int]>

Only return records where the 'id' field is in the specified values.

=item * B<id.is> => I<int>

Only return records where the 'id' field equals specified value.

=item * B<id.isnt> => I<int>

Only return records where the 'id' field does not equal specified value.

=item * B<id.max> => I<int>

Only return records where the 'id' field is less than or equal to specified value.

=item * B<id.min> => I<int>

Only return records where the 'id' field is greater than or equal to specified value.

=item * B<id.not_in> => I<array[int]>

Only return records where the 'id' field is not in the specified values.

=item * B<id.xmax> => I<int>

Only return records where the 'id' field is less than specified value.

=item * B<id.xmin> => I<int>

Only return records where the 'id' field is greater than specified value.

=item * B<kbli_code> => I<str>

Only return records where the 'kbli_code' field equals specified value.

=item * B<kbli_code.contains> => I<str>

Only return records where the 'kbli_code' field contains specified text.

=item * B<kbli_code.in> => I<array[str]>

Only return records where the 'kbli_code' field is in the specified values.

=item * B<kbli_code.is> => I<str>

Only return records where the 'kbli_code' field equals specified value.

=item * B<kbli_code.isnt> => I<str>

Only return records where the 'kbli_code' field does not equal specified value.

=item * B<kbli_code.matches> => I<str>

Only return records where the 'kbli_code' field matches specified regular expression pattern.

=item * B<kbli_code.max> => I<str>

Only return records where the 'kbli_code' field is less than or equal to specified value.

=item * B<kbli_code.min> => I<str>

Only return records where the 'kbli_code' field is greater than or equal to specified value.

=item * B<kbli_code.not_contains> => I<str>

Only return records where the 'kbli_code' field does not contain specified text.

=item * B<kbli_code.not_in> => I<array[str]>

Only return records where the 'kbli_code' field is not in the specified values.

=item * B<kbli_code.not_matches> => I<str>

Only return records where the 'kbli_code' field does not match specified regular expression.

=item * B<kbli_code.xmax> => I<str>

Only return records where the 'kbli_code' field is less than specified value.

=item * B<kbli_code.xmin> => I<str>

Only return records where the 'kbli_code' field is greater than specified value.

=item * B<mod_price> => I<float>

Only return records where the 'mod_price' field equals specified value.

=item * B<mod_price.in> => I<array[float]>

Only return records where the 'mod_price' field is in the specified values.

=item * B<mod_price.is> => I<float>

Only return records where the 'mod_price' field equals specified value.

=item * B<mod_price.isnt> => I<float>

Only return records where the 'mod_price' field does not equal specified value.

=item * B<mod_price.max> => I<float>

Only return records where the 'mod_price' field is less than or equal to specified value.

=item * B<mod_price.min> => I<float>

Only return records where the 'mod_price' field is greater than or equal to specified value.

=item * B<mod_price.not_in> => I<array[float]>

Only return records where the 'mod_price' field is not in the specified values.

=item * B<mod_price.xmax> => I<float>

Only return records where the 'mod_price' field is less than specified value.

=item * B<mod_price.xmin> => I<float>

Only return records where the 'mod_price' field is greater than specified value.

=item * B<new_reg_price> => I<float>

Only return records where the 'new_reg_price' field equals specified value.

=item * B<new_reg_price.in> => I<array[float]>

Only return records where the 'new_reg_price' field is in the specified values.

=item * B<new_reg_price.is> => I<float>

Only return records where the 'new_reg_price' field equals specified value.

=item * B<new_reg_price.isnt> => I<float>

Only return records where the 'new_reg_price' field does not equal specified value.

=item * B<new_reg_price.max> => I<float>

Only return records where the 'new_reg_price' field is less than or equal to specified value.

=item * B<new_reg_price.min> => I<float>

Only return records where the 'new_reg_price' field is greater than or equal to specified value.

=item * B<new_reg_price.not_in> => I<array[float]>

Only return records where the 'new_reg_price' field is not in the specified values.

=item * B<new_reg_price.xmax> => I<float>

Only return records where the 'new_reg_price' field is less than specified value.

=item * B<new_reg_price.xmin> => I<float>

Only return records where the 'new_reg_price' field is greater than specified value.

=item * B<queries> => I<array[str]>

Search.

This will search all searchable fields with one or more specified queries. Each
query can be in the form of C<-FOO> (dash prefix notation) to require that the
fields do not contain specified string, or C</FOO/> to use regular expression.
All queries must match if the C<query_boolean> option is set to C<and>; only one
query should match if the C<query_boolean> option is set to C<or>.

=item * B<query_boolean> => I<str> (default: "and")

Whether records must match all search queries ('and') or just one ('or').

If set to C<and>, all queries must match; if set to C<or>, only one query should
match. See the C<queries> option for more details on searching.

=item * B<random> => I<bool> (default: 0)

Return records in random order.

=item * B<rereg_price> => I<float>

Only return records where the 'rereg_price' field equals specified value.

=item * B<rereg_price.in> => I<array[float]>

Only return records where the 'rereg_price' field is in the specified values.

=item * B<rereg_price.is> => I<float>

Only return records where the 'rereg_price' field equals specified value.

=item * B<rereg_price.isnt> => I<float>

Only return records where the 'rereg_price' field does not equal specified value.

=item * B<rereg_price.max> => I<float>

Only return records where the 'rereg_price' field is less than or equal to specified value.

=item * B<rereg_price.min> => I<float>

Only return records where the 'rereg_price' field is greater than or equal to specified value.

=item * B<rereg_price.not_in> => I<array[float]>

Only return records where the 'rereg_price' field is not in the specified values.

=item * B<rereg_price.xmax> => I<float>

Only return records where the 'rereg_price' field is less than specified value.

=item * B<rereg_price.xmin> => I<float>

Only return records where the 'rereg_price' field is greater than specified value.

=item * B<result_limit> => I<int>

Only return a certain number of records.

=item * B<result_start> => I<int> (default: 1)

Only return starting from the n'th record.

=item * B<sort> => I<array[str]>

Order records according to certain field(s).

A list of field names separated by comma. Each field can be prefixed with '-' to
specify descending order instead of the default ascending.

=item * B<status> => I<str>

Only return records where the 'status' field equals specified value.

=item * B<status.contains> => I<str>

Only return records where the 'status' field contains specified text.

=item * B<status.in> => I<array[str]>

Only return records where the 'status' field is in the specified values.

=item * B<status.is> => I<str>

Only return records where the 'status' field equals specified value.

=item * B<status.isnt> => I<str>

Only return records where the 'status' field does not equal specified value.

=item * B<status.matches> => I<str>

Only return records where the 'status' field matches specified regular expression pattern.

=item * B<status.max> => I<str>

Only return records where the 'status' field is less than or equal to specified value.

=item * B<status.min> => I<str>

Only return records where the 'status' field is greater than or equal to specified value.

=item * B<status.not_contains> => I<str>

Only return records where the 'status' field does not contain specified text.

=item * B<status.not_in> => I<array[str]>

Only return records where the 'status' field is not in the specified values.

=item * B<status.not_matches> => I<str>

Only return records where the 'status' field does not match specified regular expression.

=item * B<status.xmax> => I<str>

Only return records where the 'status' field is less than specified value.

=item * B<status.xmin> => I<str>

Only return records where the 'status' field is greater than specified value.

=item * B<with_field_names> => I<bool>

Return field names in each record (as hashE<sol>associative array).

When enabled, function will return each record as hash/associative array
(field name => value pairs). Otherwise, function will return each record
as list/array (field value, field value, ...).


=back

Returns an enveloped result (an array).

First element ($status_code) is an integer containing HTTP-like status code
(200 means OK, 4xx caller error, 5xx function error). Second element
($reason) is a string containing error message, or something like "OK" if status is
200. Third element ($payload) is the actual result, but usually not present when enveloped result is an error response ($status_code is not 2xx). Fourth
element (%result_meta) is called result metadata and is optional, a hash
that contains extra information, much like how HTTP response headers provide additional metadata.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-BPOMUtils-Table-FoodType>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-BPOMUtils-Table-FoodType>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2025 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-BPOMUtils-Table-FoodType>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
