use Test::More;
use strict;
use warnings;
our ( $sub, $globref );

BEGIN {
	use_ok('String::Locale::Object');
	$sub     = sub { };
	$globref = \*globref;
}
subtest 'new' => sub {
	plan tests => 16;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	ok( $obj = String::Locale::Object->new(),
		q{$obj = String::Locale::Object->new()}
	);
	isa_ok( $obj, 'String::Locale::Object' );
	ok( $obj = String::Locale::Object->new(
			{   locale  => 'geras',
				locales => { 'gaudia' => { 'test' => 'test' } },
				fb      => 'curae'
			}
		),
		q{$obj = String::Locale::Object->new({ locale => 'geras', locales => { 'gaudia' => { 'test' => 'test' } }, fb => 'curae' })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locale  => [],
				locales => { 'gaudia' => { 'test' => 'test' } },
				fb      => 'curae'
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => [], locales => { 'gaudia' => { 'test' => 'test' } }, fb => 'curae' })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locale  => \1,
				locales => { 'gaudia' => { 'test' => 'test' } },
				fb      => 'curae'
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => \1, locales => { 'gaudia' => { 'test' => 'test' } }, fb => 'curae' })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locale  => 'geras',
				locales => { 'gaudia' => [] },
				fb      => 'curae'
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => 'geras', locales => { 'gaudia' => [] }, fb => 'curae' })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locale  => 'geras',
				locales => { 'gaudia' => 'algea' },
				fb      => 'curae'
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => 'geras', locales => { 'gaudia' => 'algea' }, fb => 'curae' })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locale  => 'geras',
				locales => { 'gaudia' => undef },
				fb      => 'curae'
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => 'geras', locales => { 'gaudia' => undef }, fb => 'curae' })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{ locale => 'geras', locales => [], fb => 'curae' } );
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => 'geras', locales => [], fb => 'curae' })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{ locale => 'geras', locales => 'gaudia', fb => 'curae' } );
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => 'geras', locales => 'gaudia', fb => 'curae' })}
	);
	ok( $obj = String::Locale::Object->new(
			{   locale  => 'geras',
				locales => { 'gaudia' => { 'test' => 'test' } }
			}
		),
		q{$obj = String::Locale::Object->new({locale => 'geras', locales => { 'gaudia' => { 'test' => 'test' } }})}
	);
	ok( $obj = String::Locale::Object->new(
			locale  => 'geras',
			locales => { 'gaudia' => { 'test' => 'test' } }
		),
		q{$obj = String::Locale::Object->new(locale => 'geras', locales => { 'gaudia' => { 'test' => 'test' } })}
	);
	is_deeply( $obj->fb, 'en', q{$obj->fb} );
	eval {
		$obj = String::Locale::Object->new(
			{   locale  => 'geras',
				locales => { 'gaudia' => { 'test' => 'test' } },
				fb      => []
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => 'geras', locales => { 'gaudia' => { 'test' => 'test' } }, fb => [] })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   locale  => 'geras',
				locales => { 'gaudia' => { 'test' => 'test' } },
				fb      => \1
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ locale => 'geras', locales => { 'gaudia' => { 'test' => 'test' } }, fb => \1 })}
	);
};
subtest 'has fb' => sub {
	plan tests => 6;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'fb' );
	is_deeply( $obj->fb('limos'), 'limos', q{$obj->fb('limos')} );
	eval { $obj->fb( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->fb([])} );
	eval { $obj->fb( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->fb(\1)} );
	is_deeply( $obj->fb, 'limos', q{$obj->fb} );
};
subtest 'has locale' => sub {
	plan tests => 6;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'locale' );
	is_deeply( $obj->locale('gaudia'), 'gaudia', q{$obj->locale('gaudia')} );
	eval { $obj->locale( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locale([])} );
	eval { $obj->locale( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locale(\1)} );
	is_deeply( $obj->locale, 'gaudia', q{$obj->locale} );
};
subtest '_build_locale' => sub {
	plan tests => 4;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, '_build_locale' );
	eval { $obj->_build_locale( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_build_locale([])} );
	eval { $obj->_build_locale( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_build_locale(\1)} );
};
subtest '_set_language_from_locale' => sub {
	plan tests => 5;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, '_set_language_from_locale' );
	eval { $obj->_set_language_from_locale( [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_set_language_from_locale([])}
	);
	eval { $obj->_set_language_from_locale( \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_set_language_from_locale(\1)}
	);
	eval { $obj->_set_language_from_locale() };
	like( $@, qr/undef/, q{$obj->_set_language_from_locale()} );
};
subtest 'has language' => sub {
	plan tests => 4;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'language' );
	eval { $obj->language( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->language([])} );
	eval { $obj->language( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->language(\1)} );
};
subtest 'has_language' => sub {
	plan tests => 6;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'has_language' );
	ok( do { delete $obj->{language}; 1; },
		q{do{ delete $obj->{language}; 1;}}
	);
	is( $obj->has_language, '', q{$obj->has_language} );
	is_deeply( $obj->language('algea'), 'algea', q{$obj->language('algea')} );
	is( $obj->has_language, 1, q{$obj->has_language} );
};
subtest 'has locales' => sub {
	plan tests => 9;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'locales' );
	is_deeply(
		$obj->locales( { 'algea' => { 'test' => 'test' } } ),
		{ 'algea' => { 'test' => 'test' } },
		q{$obj->locales({ 'algea' => { 'test' => 'test' } })}
	);
	eval { $obj->locales( { 'algea' => [] } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales({ 'algea' => [] })}
	);
	eval { $obj->locales( { 'algea' => 'limos' } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales({ 'algea' => 'limos' })}
	);
	eval { $obj->locales( { 'algea' => undef } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales({ 'algea' => undef })}
	);
	eval { $obj->locales( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales([])} );
	eval { $obj->locales('penthos') };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales('penthos')} );
	is_deeply( $obj->locales, { 'algea' => { 'test' => 'test' } },
		q{$obj->locales} );
};
subtest '_build_locales' => sub {
	plan tests => 4;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, '_build_locales' );
	eval { $obj->_build_locales( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_build_locales([])} );
	eval { $obj->_build_locales('limos') };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_build_locales('limos')}
	);
};
subtest 'convert_locale' => sub {
	plan tests => 6;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'convert_locale' );
	eval { $obj->convert_locale( [], 'curae' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->convert_locale([], 'curae')}
	);
	eval { $obj->convert_locale( \1, 'curae' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->convert_locale(\1, 'curae')}
	);
	eval { $obj->convert_locale( 'aporia', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->convert_locale('aporia', [])}
	);
	eval { $obj->convert_locale( 'aporia', \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->convert_locale('aporia', \1)}
	);
};
subtest 'add' => sub {
	plan tests => 9;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'add' );
	eval { $obj->add( [], { 'limos' => { 'test' => 'test' } } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add([], { 'limos' => { 'test' => 'test' } })}
	);
	eval { $obj->add( \1, { 'limos' => { 'test' => 'test' } } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add(\1, { 'limos' => { 'test' => 'test' } })}
	);
	eval { $obj->add( 'curae', { 'limos' => [] } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('curae', { 'limos' => [] })}
	);
	eval { $obj->add( 'curae', { 'limos' => 'hypnos' } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('curae', { 'limos' => 'hypnos' })}
	);
	eval { $obj->add( 'curae', { 'limos' => undef } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('curae', { 'limos' => undef })}
	);
	eval { $obj->add( 'curae', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('curae', [])}
	);
	eval { $obj->add( 'curae', 'algea' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('curae', 'algea')}
	);
};
subtest 'string' => sub {
	plan tests => 10;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'string' );
	eval { $obj->string( [], 'curae', 'limos', 'nosoi' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string([], 'curae', 'limos', 'nosoi')}
	);
	eval { $obj->string( \1, 'curae', 'limos', 'nosoi' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string(\1, 'curae', 'limos', 'nosoi')}
	);
	eval { $obj->string( 'curae', [], 'limos', 'nosoi' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('curae', [], 'limos', 'nosoi')}
	);
	eval { $obj->string( 'curae', \1, 'limos', 'nosoi' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('curae', \1, 'limos', 'nosoi')}
	);
	eval { $obj->string( 'curae', 'curae', [], 'nosoi' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('curae', 'curae', [], 'nosoi')}
	);
	eval { $obj->string( 'curae', 'curae', \1, 'nosoi' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('curae', 'curae', \1, 'nosoi')}
	);
	eval { $obj->string( 'curae', 'curae', 'limos', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('curae', 'curae', 'limos', [])}
	);
	eval { $obj->string( 'curae', 'curae', 'limos', \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('curae', 'curae', 'limos', \1)}
	);
};
subtest 'DESTROY' => sub {
	plan tests => 2;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'DESTROY' );
};
subtest 'AUTOLOAD' => sub {
	plan tests => 2;
	ok( my $obj = String::Locale::Object->new( {} ),
		q{my $obj = String::Locale::Object->new({})}
	);
	can_ok( $obj, 'AUTOLOAD' );
};
done_testing();
