## -*- Mode: CPerl -*-
##
## File: DTA::CAB::Analyzer::Morph::Latin::Dict.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description: auxilliary latin-language analysis, dictionary-based

##==============================================================================
## Package: Analyzer::Morph::Latin::Dict
##==============================================================================
package DTA::CAB::Analyzer::Morph::Latin::Dict;
use DTA::CAB::Analyzer::Dict ':all';
use Carp;
use strict;
our @ISA = qw(DTA::CAB::Analyzer::Dict);

## $obj = CLASS_OR_OBJ->new(%args)
##  + object structure: see DTA::CAB::Analyzer::Dict
sub new {
  my $that = shift;
  my $aut = $that->SUPER::new(
			      ##-- analysis selection
			      label      => 'mlatin',
			      analyzeGet => "lc($DICT_GET_TEXT)",
			      analyzeSet => $DICT_SET_FST,

			      ##-- user args
			      @_
			     );
  return $aut;
}

##==============================================================================
## Analysis Formatting
##==============================================================================


1; ##-- be happy

__END__
##========================================================================
## POD DOCUMENTATION, auto-generated by podextract.perl
=pod

=cut

##========================================================================
## NAME
=pod

=head1 NAME

DTA::CAB::Analyzer::Morph::Latin::Dict - auxilliary latin word recognizer via external full-form dictionary

=cut

##========================================================================
## SYNOPSIS
=pod

=head1 SYNOPSIS

 use DTA::CAB::Analyzer::Morph::Latin::Dict;
 
 $latin = DTA::CAB::Analyzer::Morph::Latin::Dict->new(%args);
 

=cut

##========================================================================
## DESCRIPTION
=pod

=head1 DESCRIPTION

DTA::CAB::Analyzer::Morph::Latin::Dict (formerly known as DTA::CAB::Analyzer::Dict::Latin)
is a just a simplified wrapper for
L<DTA::CAB::Analyzer::Dict|DTA::CAB::Analyzer::Dict>
which sets the following default options:

 label      => 'mlatin',
 analyzeGet => "lc($DICT_GET_TEXT)",
 analyzeSet => $DICT_SET_FST,


=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl

##======================================================================
## Footer
##======================================================================

=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2009-2019 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.24.1 or,
at your option, any later version of Perl 5 you may have available.

=cut
