######## GeoData for Geo::Location::TimeZone - Check main library for copyright.
######## Roughly GMT -5
package Geo::Location::TimeZone::R;
use Class::Singleton;
use Geo::Location::TimeZone;
@ISA = qw(Class::Singleton Geo::Location::TimeZone);
# Coordinates are X,Y, NOT lat,lon
# Output of partial data at 1172109537
my $data = {
	# Longitude -82.5 to -67.5
	"-5" => {
		# Grid -5:-6 ; 1 records
		"-6" => {
			"454" => {
				"z" => "Antartica/South_Pole",
				"c" => "ESRI",
				"s" => "32,1",
				"p" => [[-72.9175109863281,-82.5],[-67.5,-82.5],[-67.5,-90],[-82.5,-90],[-82.5,-82.5],[-70.83056640625,-82.5],[-72.9175109863281,-82.5],],
			},
		},
		# Grid -5:-5 ; 1 records
		"-5" => {
			"455" => {
				"z" => "Antartica/Rothera",
				"c" => "ESRI",
				"s" => "32,1",
				"p" => [[-72.9175109863281,-67.5],[-67.5,-67.5],[-67.5,-82.5],[-82.5,-82.5],[-82.5,-67.5],[-70.83056640625,-67.5],[-72.9175109863281,-67.5],],
			},
		},
		# Grid -5:-4 ; 2 records
		"-4" => {
			"def_z" => "Etc/GMT-4",
			"299" => {
				"z" => "Etc/GMT-3",
				"c" => "ESRI",
				"s" => "19,1",
				"p" => [[-71.6691741943359,-52.5],[-67.5,-52.5],[-67.5,-54.8896273604573],[-67.8477783203125,-54.8761138916016],[-68.2883453369141,-54.7936172485352],[-68.3233337402344,-54.8436126708984],[-68.5572357177734,-54.8800048828125],[-68.6431121826172,-54.8886108398438],[-68.6361236572266,-54.8047714233398],[-68.6358337402344,-54.7883377075195],[-68.6175842285156,-52.6415100097656],[-68.5232414928914,-52.5],[-73.5816802978516,-52.5],[-71.6691741943359,-52.5],],
			},
		},
		# Grid -5:-3 ; 2 records
		"-3" => {
			"def_z" => "Etc/GMT-3",
			"469" => {
				"z" => "Etc/GMT-4",
				"c" => "ESRI",
				"s" => "33,2",
				"p" => [[-72.4716796875,-37.5],[-71.1106339209142,-37.5],[-71.1155700683594,-37.5794448852539],[-71.1716766357422,-37.6180572509766],[-71.1802825927734,-37.6980590820312],[-70.9975128173828,-38.0711135864258],[-71.0130615234375,-38.2305603027344],[-70.9708404541016,-38.4180603027344],[-70.8241729736328,-38.5680618286133],[-70.8766784667969,-38.6388931274414],[-70.8600006103516,-38.6880569458008],[-70.9258422851562,-38.7425003051758],[-71.2261199951172,-38.8030624389648],[-71.4013977050781,-38.920280456543],[-71.4227905273438,-39.0369491577148],[-71.3875122070312,-39.2344512939453],[-71.4019470214844,-39.3272247314453],[-71.4705657958984,-39.3880615234375],[-71.4488983154297,-39.432502746582],[-71.4733428955078,-39.4786148071289],[-71.5408477783203,-39.5313949584961],[-71.48583984375,-39.557502746582],[-71.4880676269531,-39.5930557250977],[-71.5094451904297,-39.6194458007812],[-71.6152801513672,-39.6197280883789],[-71.6822357177734,-39.5672225952148],[-71.7044525146484,-39.732780456543],[-71.6694488525391,-39.8572235107422],[-71.6063995361328,-39.9125061035156],[-71.6730651855469,-40.01611328125],[-71.6616668701172,-40.0938949584961],[-71.7888946533203,-40.07861328125],[-71.8186187744141,-40.2019500732422],[-71.7286224365234,-40.3011169433594],[-71.7025146484375,-40.2763900756836],[-71.6697235107422,-40.2947235107422],[-71.6638946533203,-40.3361129760742],[-71.7197265625,-40.4277801513672],[-71.7913970947266,-40.415283203125],[-71.8558349609375,-40.5550003051758],[-71.8439025878906,-40.6163940429688],[-71.9505615234375,-40.732780456543],[-71.8369445800781,-40.9594497680664],[-71.8994445800781,-41.3586120605469],[-71.8647308349609,-41.4408340454102],[-71.8777923583984,-41.5225067138672],[-71.8400115966797,-41.5752792358398],[-71.9183349609375,-41.6447296142578],[-71.7852783203125,-41.8661117553711],[-71.759765625,-41.9997253417969],[-71.7288970947266,-42.1013946533203],[-71.9138946533203,-42.1780624389648],[-71.9638977050781,-42.1275024414062],[-72.0122222900391,-42.1311111450195],[-72.1313934326172,-42.2819519042969],[-72.0477905273438,-42.3566741943359],[-72.0716705322266,-42.4297256469727],[-72.0258483886719,-42.4775009155273],[-72.1094512939453,-42.5250015258789],[-72.1391754150391,-42.5875015258789],[-72.1019592285156,-42.8547286987305],[-72.1394500732422,-42.9913940429688],[-72.0527801513672,-43.1047286987305],[-71.8363952636719,-43.131950378418],[-71.73583984375,-43.1769485473633],[-71.7433471679688,-43.3022232055664],[-71.8941802978516,-43.3230590820312],[-71.9466705322266,-43.4472274780273],[-71.8583374023438,-43.4622268676758],[-71.8697357177734,-43.540283203125],[-71.7800140380859,-43.54833984375],[-71.7027893066406,-43.5958404541016],[-71.6986236572266,-43.6872253417969],[-71.8114013671875,-43.7491683959961],[-71.7913970947266,-43.7822265625],[-71.7375030517578,-43.7719497680664],[-71.7555694580078,-43.8255615234375],[-71.6983337402344,-43.8666687011719],[-71.6472320556641,-43.9186172485352],[-71.6522369384766,-43.9516677856445],[-71.758056640625,-44.0716705322266],[-71.854736328125,-44.11083984375],[-71.7938995361328,-44.2155609130859],[-71.822509765625,-44.2652816772461],[-71.7938995361328,-44.3255615234375],[-71.8513946533203,-44.3600006103516],[-71.8383483886719,-44.3933334350586],[-71.20361328125,-44.4269485473633],[-71.1080627441406,-44.5397262573242],[-71.1347351074219,-44.5838928222656],[-71.1972351074219,-44.5969467163086],[-71.2333374023438,-44.6627807617188],[-71.2236175537109,-44.745002746582],[-71.2822265625,-44.8002853393555],[-71.5008392333984,-44.7430572509766],[-71.6536254882812,-44.7827835083008],[-71.7700042724609,-44.7538909912109],[-71.8494567871094,-44.7930603027344],[-72.0425109863281,-44.7541732788086],[-72.0808410644531,-44.7747268676758],[-72.0627899169922,-44.9055557250977],[-71.8838958740234,-44.948616027832],[-71.7533416748047,-44.9319458007812],[-71.6747283935547,-44.9802780151367],[-71.5736236572266,-44.9794464111328],[-71.45361328125,-45.1591720581055],[-71.3383483886719,-45.2205581665039],[-71.2977905273438,-45.2933349609375],[-71.3733367919922,-45.3694458007812],[-71.5063934326172,-45.4113922119141],[-71.4675140380859,-45.4775009155273],[-71.5025024414062,-45.5155563354492],[-71.7566680908203,-45.5627822875977],[-71.7327880859375,-45.5988922119141],[-71.7805633544922,-45.6488952636719],[-71.7925109863281,-45.7325057983398],[-71.7383422851562,-45.790283203125],[-71.7550048828125,-45.8483352661133],[-71.6300048828125,-45.9008407592773],[-71.6016693115234,-45.974723815918],[-71.6450042724609,-45.9994506835938],[-71.7602844238281,-46.1141738891602],[-71.9061126708984,-46.1483383178711],[-71.7475128173828,-46.2427825927734],[-71.7489013671875,-46.386116027832],[-71.6691741943359,-46.5475006103516],[-71.6819458007812,-46.6988906860352],[-71.8088989257812,-46.7841720581055],[-71.9402923583984,-46.815559387207],[-71.9247283935547,-46.8505630493164],[-71.9605560302734,-46.9500045776367],[-71.9047241210938,-47.0008392333984],[-71.9966735839844,-47.0611114501953],[-71.8605651855469,-47.1419448852539],[-71.8652801513672,-47.2169494628906],[-71.9175109863281,-47.2344512939453],[-72.0319519042969,-47.2033386230469],[-72.0150146484375,-47.2744445800781],[-72.0836181640625,-47.3547286987305],[-72.1805572509766,-47.420280456543],[-72.2563934326172,-47.4111175537109],[-72.3472290039062,-47.4450073242188],[-72.3594512939453,-47.4811172485352],[-72.3055572509766,-47.5072250366211],[-72.3316802978516,-47.6016693115234],[-72.5352783203125,-47.9091720581055],[-72.5150146484375,-47.9611129760742],[-72.3227844238281,-48.0755615234375],[-72.2897338867188,-48.3475036621094],[-72.3666687011719,-48.3461151123047],[-72.4075012207031,-48.3969497680664],[-72.5897369384766,-48.4663925170898],[-72.5641784667969,-48.8044509887695],[-72.7552795410156,-48.9280624389648],[-72.9880676269531,-48.9816741943359],[-73.1663970947266,-49.2000045776367],[-73.1676940917969,-49.2526397705078],[-73.0827789306641,-49.269172668457],[-73.1352844238281,-49.3055572509766],[-73.4647369384766,-49.311393737793],[-73.4525146484375,-49.3852844238281],[-73.5311126708984,-49.4311141967773],[-73.5297241210938,-49.4963912963867],[-73.5816802978516,-49.5319519042969],[-73.510009765625,-49.6133346557617],[-73.5333404541016,-49.6897277832031],[-73.4444580078125,-49.7825012207031],[-73.564453125,-49.9247283935547],[-73.4672241210938,-50.0066680908203],[-73.5322265625,-50.1405563354492],[-73.3463897705078,-50.2380599975586],[-73.2800140380859,-50.3227844238281],[-73.2491760253906,-50.5763931274414],[-73.1783447265625,-50.6477813720703],[-73.1808471679688,-50.7291717529297],[-73.1444549560547,-50.7675018310547],[-73.01806640625,-50.7494506835938],[-72.9061126708984,-50.6675033569336],[-72.7583465576172,-50.618896484375],[-72.6297302246094,-50.6730575561523],[-72.5011138916016,-50.6033401489258],[-72.2941741943359,-50.6497268676758],[-72.3416748046875,-50.743896484375],[-72.2422332763672,-50.8511123657227],[-72.2669525146484,-51.0172271728516],[-72.3411254882812,-51.0366668701172],[-72.3977813720703,-51.1141738891602],[-72.3716735839844,-51.1647262573242],[-72.2452850341797,-51.2444458007812],[-72.3091735839844,-51.3022232055664],[-72.3394470214844,-51.4758377075195],[-72.439453125,-51.5597229003906],[-72.3308410644531,-51.5872268676758],[-72.2855682373047,-51.6991729736328],[-72.1355590820312,-51.7400054931641],[-71.9664001464844,-51.8486175537109],[-71.939453125,-51.8988952636719],[-71.9625091552734,-51.9602813720703],[-71.931396484375,-51.9888916015625],[-69.9983367919922,-51.9963912963867],[-69.4613952636719,-52.1436157226562],[-69.2336120605469,-52.1433334350586],[-68.82861328125,-52.2797241210938],[-68.4375,-52.3283386230469],[-68.4417572021484,-52.3777770996094],[-68.5232414928914,-52.5],[-67.5,-52.5],[-67.5,-52.2236008263316],[-67.5083465576172,-48.9841690063477],[-67.5,-48.9770123143866],[-67.5,-46.455863280903],[-67.5366668701172,-46.4175033569336],[-67.6202850341797,-46.1713943481445],[-67.586669921875,-46.0038909912109],[-67.5843505859375,-46.0002975463867],[-67.5,-45.9075039629768],[-67.5,-52.5],[-74.9070865038966,-52.5],[-75.3615036010742,-51.6100959777832],[-75.7308807373047,-49.0351371765137],[-75.6882553100586,-48.4633178710938],[-75.6030197143555,-48.0513229370117],[-75.6527404785156,-46.9218902587891],[-75.7521896362305,-46.8082389831543],[-75.7166748046875,-46.5631713867188],[-75.3259887695312,-46.3287620544434],[-75.1839218139648,-44.8015441894531],[-74.8784790039062,-43.5264930725098],[-74.4309692382812,-43.2210502624512],[-74.189453125,-42.1733055114746],[-74.0544891357422,-41.7328987121582],[-73.855598449707,-41.7684173583984],[-73.7528076171875,-41.7512855529785],[-73.6827850341797,-41.6247253417969],[-73.5641784667969,-41.6136169433594],[-73.4919586181641,-41.5208358764648],[-73.5916748046875,-41.6025009155273],[-73.8216705322266,-41.565559387207],[-73.8238983154297,-41.5172271728516],[-73.8744506835938,-41.4733352661133],[-73.8589019775391,-41.339729309082],[-73.9780578613281,-41.118896484375],[-73.9950103759766,-40.9700012207031],[-73.8980560302734,-40.9063949584961],[-73.9477844238281,-40.8638916015625],[-73.8427886962891,-40.6869506835938],[-73.8577880859375,-40.6263961791992],[-73.7475128173828,-40.5247268676758],[-73.7844543457031,-40.4236145019531],[-73.7502899169922,-40.2572250366211],[-73.7170867919922,-40.2083206176758],[-73.7311248779297,-40.1800003051758],[-73.6580657958984,-40.1102828979492],[-73.7144470214844,-39.9786148071289],[-73.4516754150391,-39.8325042724609],[-73.3825073242188,-39.9144515991211],[-73.3797302246094,-39.7363891601562],[-73.4044494628906,-39.6916732788086],[-73.3455657958984,-39.6641693115234],[-73.243896484375,-39.4913940429688],[-73.2575073242188,-39.4538955688477],[-73.2225036621094,-39.4147262573242],[-73.2459716796875,-39.3858337402344],[-73.2075042724609,-39.2155609130859],[-73.2352905273438,-39.1858367919922],[-73.2250061035156,-39.2194519042969],[-73.2477874755859,-39.2222290039062],[-73.4330596923828,-38.6916732788086],[-73.4419555664062,-38.7675018310547],[-73.542236328125,-38.4183349609375],[-73.4539031982422,-38.0555572509766],[-73.5380706787109,-37.8733367919922],[-73.6694488525391,-37.7261123657227],[-73.6872253417969,-37.6011123657227],[-73.6019592285156,-37.5133361816406],[-73.6029519453404,-37.5],[-67.5,-37.5],[-72.4716796875,-37.5],],
			},
		},
		# Grid -5:-2 ; 2 records
		"-2" => {
			"def_z" => "Pacific/Marquesas",
			"301" => {
				"z" => "Etc/GMT-3",
				"c" => "ESRI",
				"s" => "19,1",
				"p" => [[-67.5,-36.3833389282227],[-67.5,-37.5],[-71.1106339209142,-37.5],[-71.1080627441406,-37.4586181640625],[-71.1966705322266,-37.2966690063477],[-71.1391754150391,-37.2241668701172],[-71.1352844238281,-37.144172668457],[-71.0791778564453,-37.1041717529297],[-71.125,-37.0755615234375],[-71.1461181640625,-36.9966735839844],[-71.2011260986328,-36.9705581665039],[-71.1222229003906,-36.9469451904297],[-71.1583404541016,-36.9250030517578],[-71.1402893066406,-36.8825073242188],[-71.1869506835938,-36.8488922119141],[-71.1383361816406,-36.6908340454102],[-71.0458374023438,-36.6858367919922],[-71.0605621337891,-36.5930557250977],[-71.0291748046875,-36.4791717529297],[-70.9361114501953,-36.4819488525391],[-70.8875122070312,-36.4005584716797],[-70.8016815185547,-36.4347229003906],[-70.7080688476562,-36.4177780151367],[-70.7047271728516,-36.2705612182617],[-70.5897369384766,-36.1919479370117],[-70.5800018310547,-36.1486129760742],[-70.4738922119141,-36.165283203125],[-70.42431640625,-36.1360397338867],[-70.3691711425781,-36.0466690063477],[-70.4094543457031,-35.9636154174805],[-70.3736114501953,-35.9138946533203],[-70.4105682373047,-35.8869476318359],[-70.3377838134766,-35.8083343505859],[-70.4202880859375,-35.6436157226562],[-70.3966674804688,-35.5036163330078],[-70.4622344970703,-35.383056640625],[-70.4200134277344,-35.3472290039062],[-70.55029296875,-35.2966690063477],[-70.5675048828125,-35.2477798461914],[-70.5363922119141,-35.2063903808594],[-70.3680572509766,-35.1588897705078],[-70.3619537353516,-35.0044479370117],[-70.2636260986328,-34.7977828979492],[-70.3136138916016,-34.748893737793],[-70.2530670166016,-34.7180557250977],[-70.2213897705078,-34.5900039672852],[-70.0475006103516,-34.4091720581055],[-70.0494537353516,-34.2875061035156],[-69.8933410644531,-34.2861175537109],[-69.8891754150391,-34.2594451904297],[-69.8125,-34.2355575561523],[-69.868896484375,-34.1336135864258],[-69.8488922119141,-33.9719467163086],[-69.9044494628906,-33.9516677856445],[-69.883056640625,-33.8797225952148],[-69.9061126708984,-33.7877807617188],[-69.8466796875,-33.7175064086914],[-69.8852844238281,-33.6627807617188],[-69.868896484375,-33.5519485473633],[-69.8291778564453,-33.5316696166992],[-69.7744445800781,-33.3811111450195],[-69.8077850341797,-33.2738952636719],[-69.9191741943359,-33.2380599975586],[-69.9958343505859,-33.3019485473633],[-70.0988922119141,-33.1725006103516],[-70.1013946533203,-33.0300064086914],[-70.0352783203125,-32.9983367919922],[-69.9875030517578,-32.8788909912109],[-70.1486206054688,-32.7525024414062],[-70.1711120605469,-32.607780456543],[-70.1294555664062,-32.5652847290039],[-70.1625061035156,-32.4630584716797],[-70.2388916015625,-32.4175033569336],[-70.2443237304688,-32.3098373413086],[-70.3166809082031,-32.2833404541016],[-70.3252868652344,-32.1375045776367],[-70.3800048828125,-32.0516738891602],[-70.3638916015625,-32.029167175293],[-70.2625122070312,-32.0436172485352],[-70.2344512939453,-31.9425010681152],[-70.2905578613281,-31.8866691589355],[-70.4100036621094,-31.8808364868164],[-70.4588928222656,-31.8325004577637],[-70.4766693115234,-31.726390838623],[-70.5880584716797,-31.5616683959961],[-70.542236328125,-31.3733367919922],[-70.5611114501953,-31.3141670227051],[-70.5294494628906,-31.174446105957],[-70.4713897705078,-31.0980567932129],[-70.445556640625,-31.0930557250977],[-70.4133453369141,-31.1538925170898],[-70.3277893066406,-31.039722442627],[-70.2550048828125,-31.0341682434082],[-70.3277893066406,-30.9583358764648],[-70.3266754150391,-30.8880577087402],[-70.2069549560547,-30.5050010681152],[-70.1338958740234,-30.4397239685059],[-70.1633453369141,-30.3647232055664],[-70.0297241210938,-30.3977813720703],[-69.9441680908203,-30.376392364502],[-69.8975067138672,-30.3225021362305],[-69.8700103759766,-30.2108345031738],[-69.8316802978516,-30.1905555725098],[-69.8586120605469,-30.1069450378418],[-69.9708404541016,-30.0844459533691],[-69.9188079833984,-29.974063873291],[-69.9055633544922,-29.7911148071289],[-69.9150085449219,-29.7177810668945],[-69.9683380126953,-29.6611137390137],[-69.9605560302734,-29.5502815246582],[-70.0314025878906,-29.3063926696777],[-69.9080657958984,-29.1413917541504],[-69.7938995361328,-29.0986137390137],[-69.7952880859375,-28.951114654541],[-69.7230682373047,-28.803337097168],[-69.7450103759766,-28.6605567932129],[-69.6663970947266,-28.5727806091309],[-69.6553802490234,-28.4009323120117],[-69.5300140380859,-28.3122253417969],[-69.4761199951172,-28.1913909912109],[-69.4064025878906,-28.2088890075684],[-69.30029296875,-27.9994468688965],[-69.1858367919922,-27.9658355712891],[-69.1080627441406,-27.7219467163086],[-69.0655670166016,-27.6988906860352],[-69.0841674804688,-27.6458358764648],[-69.0125122070312,-27.5316696166992],[-69.0069580078125,-27.4588890075684],[-68.9047241210938,-27.3666687011719],[-68.8658447265625,-27.2880592346191],[-68.8772277832031,-27.2308349609375],[-68.8108367919922,-27.1205558776855],[-68.6966705322266,-27.1075019836426],[-68.5819549560547,-27.1697235107422],[-68.5030670166016,-27.0747222900391],[-68.3155670166016,-27.0419464111328],[-68.2958374023438,-26.8916702270508],[-68.5836181640625,-26.5052795410156],[-68.5636138916016,-26.3005561828613],[-68.3977813720703,-26.1561126708984],[-68.5975036621094,-25.4433364868164],[-68.5022277832031,-25.1772232055664],[-68.4650115966797,-25.1405563354492],[-68.4202880859375,-25.1527786254883],[-68.3519592285156,-25.1172256469727],[-68.4241790771484,-25.0336112976074],[-68.4550018310547,-24.9050025939941],[-68.5452880859375,-24.8736114501953],[-68.5691680908203,-24.7861137390137],[-68.48779296875,-24.6025009155273],[-68.4436187744141,-24.626392364502],[-68.3891754150391,-24.5016670227051],[-68.3077850341797,-24.4925003051758],[-68.2522277832031,-24.3963890075684],[-67.5,-24.0887924003525],[-67.5,-22.5],[-67.5,-34.1654891967773],[-67.5,-36.3833389282227],],
			},
		},
		# Grid -5:-1 ; 1 records
		"-1" => {
			"471" => {
				"z" => "Etc/GMT-4",
				"c" => "ESRI",
				"s" => "33,2",
				"p" => [[-67.5,-22.5],[-70.2635025864461,-22.5],[-70.1683349609375,-21.9419479370117],[-70.1933441162109,-21.8880577087402],[-70.1480560302734,-21.8555564880371],[-70.1541748046875,-21.6669464111328],[-70.0658416748047,-21.5236129760742],[-70.0844573974609,-21.4847259521484],[-70.0533447265625,-21.425651550293],[-70.0952911376953,-21.336669921875],[-70.0647277832031,-21.2963905334473],[-70.1230621337891,-21.0813903808594],[-70.1700134277344,-21.0108337402344],[-70.1391754150391,-20.8755569458008],[-70.2122344970703,-20.7997245788574],[-70.2047271728516,-20.529167175293],[-70.167236328125,-20.4516677856445],[-70.1905670166016,-20.3677787780762],[-70.133056640625,-20.2733345031738],[-70.165283203125,-20.2038917541504],[-70.1261138916016,-20.0736122131348],[-70.1361236572266,-19.8638916015625],[-70.1663970947266,-19.8069458007812],[-70.1516723632812,-19.7144470214844],[-70.2300109863281,-19.586669921875],[-70.1986236572266,-19.5769462585449],[-70.1969451904297,-19.5027809143066],[-70.2886199951172,-19.2944450378418],[-70.2716674804688,-19.1413917541504],[-70.3577880859375,-18.7841682434082],[-70.3100128173828,-18.4344482421875],[-70.4054870605469,-18.3485450744629],[-70.3558349609375,-18.3197250366211],[-70.14111328125,-18.3233337402344],[-69.9511260986328,-18.2427787780762],[-69.8414001464844,-18.1286125183105],[-69.7700042724609,-17.9688911437988],[-69.8497314453125,-17.7541694641113],[-69.8322296142578,-17.676944732666],[-69.8147277832031,-17.6522254943848],[-69.6838989257812,-17.6636123657227],[-69.4997253417969,-17.5052795410156],[-69.5011138916016,-17.3788909912109],[-69.5908355712891,-17.295280456543],[-69.6561889648438,-17.2872467041016],[-69.6180572509766,-17.1866683959961],[-69.3883361816406,-17.0550003051758],[-69.4111175537109,-17.0205574035645],[-69.3433380126953,-16.9825019836426],[-69.1700134277344,-16.7238922119141],[-69.0111236572266,-16.6569480895996],[-69.0416717529297,-16.5411148071289],[-68.9908447265625,-16.4197235107422],[-68.822509765625,-16.3397254943848],[-68.8408355712891,-16.2955589294434],[-68.9650115966797,-16.2094459533691],[-69.1341705322266,-16.2236137390137],[-69.2119445800781,-16.1605567932129],[-69.4219512939453,-15.6180572509766],[-69.3269500732422,-15.4305572509766],[-69.2758483886719,-15.404167175293],[-69.2683410644531,-15.3269462585449],[-69.1369476318359,-15.2458343505859],[-69.3813934326172,-14.9700012207031],[-69.3494567871094,-14.8950004577637],[-69.3663940429688,-14.8025016784668],[-69.2419586181641,-14.7302780151367],[-69.2288970947266,-14.5763893127441],[-69.1575012207031,-14.5755558013916],[-69.1577911376953,-14.5052795410156],[-68.9813995361328,-14.3791675567627],[-68.9991760253906,-14.2433338165283],[-68.8530578613281,-14.1991672515869],[-68.8955688476562,-14.0338897705078],[-68.9775085449219,-13.9616680145264],[-69.0030670166016,-13.7544460296631],[-69.0877838134766,-13.6633338928223],[-69.0147247314453,-13.638334274292],[-68.9619445800781,-13.5130558013916],[-68.9633483886719,-13.026668548584],[-68.9736175537109,-12.8633346557617],[-68.8466796875,-12.7327785491943],[-68.7566680908203,-12.7147235870361],[-68.7313995361328,-12.6697244644165],[-68.7808380126953,-12.6177787780762],[-68.6739044189453,-12.5011501312256],[-68.9250030517578,-11.9966678619385],[-69.5675048828125,-10.9505558013916],[-69.3952789306641,-10.926944732666],[-68.9002838134766,-11.0152778625488],[-68.7858428955078,-10.992223739624],[-68.7476043701172,-11.0103740692139],[-68.7808380126953,-11.0650005340576],[-68.7747344970703,-11.1363906860352],[-68.5834503173828,-11.1061382293701],[-68.5169525146484,-11.0544452667236],[-68.4175109863281,-11.0444450378418],[-68.3914031982422,-11.008056640625],[-68.2805633544922,-10.980001449585],[-68.0611114501953,-10.6763896942139],[-67.8455657958984,-10.6575012207031],[-67.7455596923828,-10.7125015258789],[-67.7033386230469,-10.6957235336304],[-67.6116790771484,-10.5322227478027],[-67.5,-10.4743934616801],[-67.5,-9.55525621262759],[-68.6572265625,-9.0663890838623],[-70.3572235107422,-8.16055679321289],[-72.6377868652344,-7.60333347320557],[-72.8865706362683,-7.5],[-67.5,-7.5],[-67.5,-18.7083358764648],[-67.5,-22.5],],
			},
		},
		# Grid -5:0 ; 2 records
		"0" => {
			"def_z" => "Pacific/Galapagos",
			"472" => {
				"z" => "Etc/GMT-4",
				"c" => "ESRI",
				"s" => "33,2",
				"p" => [[-67.5,-7.5],[-72.8865706362683,-7.5],[-73.7951354980469,-7.12262344360352],[-73.7544555664062,-6.89416694641113],[-73.6763916015625,-6.80444526672363],[-73.3530578613281,-6.57694530487061],[-73.1916809082031,-6.55277824401855],[-73.1239013671875,-6.44722270965576],[-73.1630706787109,-6.2072229385376],[-73.229736328125,-6.09361171722412],[-73.1261138916016,-5.86750030517578],[-72.9633483886719,-5.65416717529297],[-72.9425048828125,-5.54333400726318],[-72.9627838134766,-5.45805644989014],[-72.8841705322266,-5.25805568695068],[-72.9175109863281,-5.1511116027832],[-72.8902893066406,-5.12361145019531],[-72.7413940429688,-5.0508337020874],[-72.6252899169922,-5.05416679382324],[-72.6091766357422,-5.00083351135254],[-72.4061126708984,-4.8788890838623],[-72.3752899169922,-4.78444480895996],[-72.2350006103516,-4.75333404541016],[-72.1291809082031,-4.69361114501953],[-72.0665740966797,-4.60609149932861],[-72.0280609130859,-4.61250019073486],[-71.9024810791016,-4.5181884765625],[-71.6905670166016,-4.47388935089111],[-71.6447296142578,-4.5091667175293],[-71.6230621337891,-4.47583389282227],[-71.6072235107422,-4.49805641174316],[-71.5105590820312,-4.48138904571533],[-71.4708404541016,-4.43833351135254],[-71.3822326660156,-4.43083381652832],[-71.3538970947266,-4.4572229385376],[-71.2952880859375,-4.43361186981201],[-71.2905578613281,-4.38305568695068],[-71.2329559326172,-4.37461471557617],[-71.2002868652344,-4.41055583953857],[-71.1694488525391,-4.35777854919434],[-71.1291809082031,-4.39888954162598],[-71.0833435058594,-4.36361122131348],[-71.0113983154297,-4.38222312927246],[-70.9886169433594,-4.34055614471436],[-70.9502868652344,-4.38138961791992],[-70.83056640625,-4.2344446182251],[-70.8347320556641,-4.18777847290039],[-70.7658386230469,-4.14638900756836],[-70.6838989257812,-4.1733341217041],[-70.6200103759766,-4.11500072479248],[-70.6288909912109,-4.15666675567627],[-70.5841674804688,-4.19555568695068],[-70.5452880859375,-4.13861179351807],[-70.5119476318359,-4.18027782440186],[-70.4333343505859,-4.131667137146],[-70.3597259521484,-4.16583347320557],[-70.3238983154297,-4.13666725158691],[-70.3066711425781,-4.24472236633301],[-70.194091796875,-4.33317279815674],[-70.1069488525391,-4.25305557250977],[-70.0741119384766,-4.31308269500732],[-70.0186157226562,-4.33916759490967],[-69.9641723632812,-4.29000091552734],[-69.9569244384766,-4.23687362670898],[-69.4605560302734,-1.49611115455627],[-69.3794555664062,-1.3502779006958],[-69.3808441162109,-1.17444467544556],[-69.4389038085938,-1.08388900756836],[-69.4419708251953,-1.01780796051025],[-69.4347229003906,-0.994166731834412],[-69.5291748046875,-0.924444556236267],[-69.5625,-0.808055639266968],[-69.6147308349609,-0.751111149787903],[-69.5727844238281,-0.636666774749756],[-69.6075134277344,-0.517500042915344],[-69.7461242675781,-0.452222228050232],[-69.8516693115234,-0.335277795791626],[-69.9283447265625,-0.309444487094879],[-70.0580596923828,-0.157500028610229],[-70.0441741943359,0.590833306312561],[-69.7977905273438,0.600277662277222],[-69.6783447265625,0.67888879776001],[-69.6077880859375,0.64638888835907],[-69.5672302246094,0.701111078262329],[-69.4641723632812,0.740277767181396],[-69.3500061035156,0.63694441318512],[-69.2938995361328,0.66777777671814],[-69.2869567871094,0.620833277702332],[-69.1372222900391,0.629999995231628],[-69.1386260986328,0.68666660785675],[-69.1825103759766,0.724444389343262],[-69.1400146484375,0.866944432258606],[-69.2027893066406,0.90666663646698],[-69.2241668701172,0.995277762413025],[-69.3436126708984,1.07472205162048],[-69.4208374023438,1.02611088752747],[-69.4463958740234,1.06222200393677],[-69.6019592285156,1.08083319664001],[-69.7047271728516,1.05944442749023],[-69.7650146484375,1.09583330154419],[-69.8422241210938,1.06222200393677],[-69.8460998535156,1.71045517921448],[-69.7869567871094,1.70611095428467],[-69.7169494628906,1.74805545806885],[-69.6313934326172,1.73777770996094],[-69.5558471679688,1.78416657447815],[-69.3779296875,1.72614908218384],[-68.1530609130859,1.72416663169861],[-68.1758422851562,1.76305532455444],[-68.2327880859375,1.77555537223816],[-68.2291717529297,1.82333326339722],[-68.2772369384766,1.83777761459351],[-68.1866760253906,2.01999998092651],[-68.1708374023438,1.97388887405396],[-68.0894470214844,1.9336109161377],[-68.0050048828125,1.76305532455444],[-67.9147338867188,1.74527764320374],[-67.8055572509766,1.78833317756653],[-67.6441802978516,2],[-67.5,2.09429894480531],[-67.5,2.67340287629626],[-67.5033416748047,2.67722177505493],[-67.5677795410156,2.68333292007446],[-67.6069488525391,2.79555511474609],[-67.7516784667969,2.83999967575073],[-67.8550720214844,2.78978443145752],[-67.8430633544922,2.868332862854],[-67.5,3.19292096276413],[-67.5,3.72826549289063],[-67.6133422851562,3.75472211837769],[-67.7085113525391,4.04695415496826],[-67.8055572509766,4.22749996185303],[-67.7919464111328,4.42749977111816],[-67.8761138916016,4.53083324432373],[-67.7905578613281,5.05470180511475],[-67.82861328125,5.11222171783447],[-67.8116760253906,5.21749973297119],[-67.8506164550781,5.30163192749023],[-67.8027954101562,5.38556003570557],[-67.6494445800781,5.47833251953125],[-67.6130676269531,5.53916645050049],[-67.6519470214844,5.67638874053955],[-67.6222229003906,5.78749942779541],[-67.5,5.90711590813809],[-67.5,6.22171607891463],[-67.5683441162109,6.26472187042236],[-67.8227844238281,6.30944442749023],[-67.9950103759766,6.20777702331543],[-68.1522369384766,6.22333240509033],[-68.3136138916016,6.16694355010986],[-68.4539031982422,6.19055461883545],[-68.6372222900391,6.13388824462891],[-69.056396484375,6.21611022949219],[-69.2452850341797,6.08138847351074],[-69.3250122070312,6.15361022949219],[-69.4294586181641,6.11861038208008],[-70.1191711425781,6.97583293914795],[-70.3008422851562,6.93916606903076],[-70.5127868652344,7.0155553817749],[-70.5636138916016,7.08944416046143],[-70.61279296875,7.07249927520752],[-70.7025146484375,7.10805511474609],[-70.8900146484375,7.07499980926514],[-71.0250091552734,6.98444366455078],[-71.1280670166016,6.99888801574707],[-71.1866760253906,6.96277713775635],[-71.2655639648438,6.98777770996094],[-71.2955627441406,7.03333282470703],[-71.4577789306641,7.01583290100098],[-71.6069488525391,7.05972194671631],[-71.7641754150391,7.03222179412842],[-71.7655639648438,7.00555515289307],[-71.8327789306641,6.98722171783447],[-71.9268035888672,7.00974225997925],[-72.0661010742188,7.06241512298584],[-72.1452789306641,7.19861030578613],[-72.1508483886719,7.3397216796875],[-72.1833343505859,7.38277721405029],[-72.399169921875,7.4061107635498],[-72.4716796875,7.49194431304932],[-72.4710005593394,7.5],[-67.5,7.5],[-67.5,-7.5],[-70.4054870605469,-7.5],[-67.5,-7.5],],
			},
		},
		# Grid -5:1 ; 2 records
		"1" => {
			"def_z" => "Pacific/Norfolk",
			"473" => {
				"z" => "Etc/GMT-4",
				"c" => "ESRI",
				"s" => "33,2",
				"p" => [[-72.4716796875,7.5],[-72.4710005593394,7.5],[-72.4433441162109,7.8280553817749],[-72.4813995361328,7.94777774810791],[-72.4230651855469,7.98583316802979],[-72.4025115966797,8.04194259643555],[-72.3336181640625,8.0494441986084],[-72.3252868652344,8.09555435180664],[-72.3855590820312,8.25388717651367],[-72.3841705322266,8.3630542755127],[-72.6644592285156,8.64110946655273],[-72.7902984619141,9.08304977416992],[-72.7681884765625,9.11142539978027],[-72.8169555664062,9.14527702331543],[-72.9422302246094,9.10416603088379],[-73.0063934326172,9.304443359375],[-73.2189025878906,9.17138862609863],[-73.3719482421875,9.16694259643555],[-73.3836212158203,9.18972206115723],[-73.29833984375,9.28472137451172],[-73.1683349609375,9.53610992431641],[-73.0927886962891,9.5855541229248],[-72.9622344970703,9.83694267272949],[-72.9872283935547,9.91416549682617],[-72.9050140380859,10.4424991607666],[-72.7602844238281,10.651388168335],[-72.665283203125,10.8727760314941],[-72.5586242675781,10.9738883972168],[-72.4930572509766,11.1211109161377],[-72.3411254882812,11.1649990081787],[-72.260009765625,11.1544437408447],[-71.9772338867188,11.6649990081787],[-71.5294494628906,11.780047416687],[-71.3847351074219,11.8288879394531],[-71.3247222900391,11.8530540466309],[-71.0813598632812,12.0020799636841],[-71.0621719360352,12.2322807312012],[-71.2540054321289,12.4432973861694],[-71.7719573974609,12.5583972930908],[-71.7678680419922,18.038501739502],[-71.7447357177734,18.1338882446289],[-71.7691802978516,18.202220916748],[-71.6947326660156,18.3222198486328],[-71.9075012207031,18.4377746582031],[-71.885009765625,18.4772186279297],[-72.0030670166016,18.600830078125],[-71.8316802978516,18.6224975585938],[-71.7158355712891,18.7497215270996],[-71.7194519042969,18.8838882446289],[-71.7888946533203,18.962776184082],[-71.8560485839844,18.9478378295898],[-71.75,19.0197219848633],[-71.635009765625,19.1580543518066],[-71.6291809082031,19.2197208404541],[-71.6961212158203,19.2416648864746],[-71.7666778564453,19.3319435119629],[-71.6986236572266,19.400276184082],[-71.6916809082031,19.4858322143555],[-71.7541809082031,19.7058296203613],[-71.7558670043945,20.2411003112793],[-67.5036544799805,20.2413387298584],[-67.5036544799805,22.5],[-67.5,22.5],[-67.5,7.5],[-67.5,7.5],[-72.4716796875,7.5],],
			},
		},
		# Grid -5:2 ; 1 records
		"2" => {
			"474" => {
				"z" => "Etc/GMT-4",
				"c" => "ESRI",
				"s" => "33,2",
				"p" => [[-72.4716796875,22.5],[-67.5036544799805,22.5],[-67.5036544799805,37.5],[-67.5,37.5],[-67.5,22.5],[-67.5,22.5],[-72.4716796875,22.5],],
			},
		},
		# Grid -5:3 ; 1 records
		"3" => {
			"475" => {
				"z" => "Etc/GMT-4",
				"c" => "ESRI",
				"s" => "33,2",
				"p" => [[-72.4716796875,37.5],[-67.5036544799805,37.5],[-67.5036544799805,44.4795303344727],[-67.5,44.481588670716],[-67.5,45.6025645712168],[-67.6566619873047,45.6305465698242],[-67.7174987792969,45.6913757324219],[-67.7991638183594,45.7011032104492],[-67.8063812255859,45.7847213745117],[-67.7572326660156,45.8333282470703],[-67.790283203125,45.8819351196289],[-67.7469482421875,45.9291610717773],[-67.7725067138672,45.9574966430664],[-67.7933349609375,47.0702743530273],[-68.1858215332031,47.3327713012695],[-68.3066558837891,47.3644409179688],[-68.373046875,47.3472137451172],[-68.3975067138672,47.2952728271484],[-68.498046875,47.305549621582],[-68.8877868652344,47.1880416870117],[-69.0361175537109,47.2572174072266],[-69.0535888671875,47.2937774658203],[-68.5761108398438,47.4247131347656],[-68.3802795410156,47.5586013793945],[-68.3727722167969,47.9247131347656],[-68.1202697753906,47.9266586303711],[-68.1161041259766,48.0019378662109],[-67.6122131347656,47.9974899291992],[-67.6041717529297,47.9361038208008],[-67.5,47.8963546644751],[-67.5,52.5],[-67.5,37.5],[-67.5,37.5],[-72.4716796875,37.5],],
			},
		},
		# Grid -5:4 ; 1 records
		"4" => {
			"476" => {
				"z" => "Etc/GMT-4",
				"c" => "ESRI",
				"s" => "33,2",
				"p" => [[-72.4716796875,52.5],[-67.5,52.5],[-67.5,53.8153814368555],[-67.5880584716797,53.8572158813477],[-67.6091613769531,53.9280471801758],[-67.7605590820312,54.0158309936523],[-67.7819519042969,54.0638809204102],[-67.7155609130859,54.1294326782227],[-67.6961059570312,54.1386032104492],[-67.5,54.2273718086356],[-67.5,54.2388906712702],[-67.5316772460938,54.2488784790039],[-67.5,54.3050722394671],[-67.5,54.317091976803],[-67.5958404541016,54.3652725219727],[-67.5861206054688,54.4174957275391],[-67.633056640625,54.4799880981445],[-67.6013946533203,54.5663833618164],[-67.5,54.5808672975121],[-67.5,67.5],[-67.5,52.5],[-67.5,52.5],[-72.4716796875,52.5],],
			},
		},
		# Grid -5:5 ; 2 records
		"5" => {
			"def_z" => "Etc/GMT-4",
			"302" => {
				"z" => "Etc/GMT-3",
				"c" => "ESRI",
				"s" => "19,1",
				"p" => [[-67.5,67.5],[-67.5,78.9234419676945],[-67.7672424316406,79.1015472412109],[-67.5,79.1397253706131],[-67.5,80.1720946486274],[-67.5255508422852,80.1803817749023],[-67.5480804443359,80.2930145263672],[-67.5,80.3410949707031],[-67.5,82.0227355957031],[-67.5,67.5],],
			},
		},
		# Grid -5:6 ; 1 records
		"6" => {
			"467" => {
				"z" => "Etc/GMT-4",
				"c" => "ESRI",
				"s" => "33,1",
				"p" => [[-67.5,82.9962172083837],[-67.5030212402344,82.9962921142578],[-67.5030212402344,90],[-67.5,90],[-67.5,82.5],[-67.5,82.9962172083837],],
			},
		},
	},
};

# Used by Class::Singleton
sub _new_instance
{
	return shift->_init( @_, data => $data );
}

1;
