#!/usr/bin/perl

package eBay::API::XML::DataType::SuggestedCategoryArrayType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SuggestedCategoryArrayType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SuggestedCategoryArrayType

=head1 DESCRIPTION

Contains an array of categories that contain listings with
specified keywords in their titles or descriptions. The array
can contain up to 10 categories.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SuggestedCategoryArrayType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::SuggestedCategoryType;


my @gaProperties = ( [ 'SuggestedCategory', 'ns:SuggestedCategoryType', '1'
	     ,'eBay::API::XML::DataType::SuggestedCategoryType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setSuggestedCategory()

Describes a category that contains listings that match
specified keywords in the query. Returned if a category matches the query.

#    Argument: reference to an array  
                      of 'ns:SuggestedCategoryType'

=cut

sub setSuggestedCategory {
  my $self = shift;
  $self->{'SuggestedCategory'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getSuggestedCategory()

  Calls: GetSuggestedCategories
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:SuggestedCategoryType'

=cut

sub getSuggestedCategory {
  my $self = shift;
  return $self->_getDataTypeArray('SuggestedCategory');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
