#!/usr/bin/perl

package eBay::API::XML::Call::SetNotificationPreferences;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SetNotificationPreferences.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SetNotificationPreferences

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SetNotificationPreferences inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::SetNotificationPreferences::SetNotificationPreferencesRequestType;
use eBay::API::XML::Call::SetNotificationPreferences::SetNotificationPreferencesResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'SetNotificationPreferences';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::SetNotificationPreferences::SetNotificationPreferencesRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::SetNotificationPreferences::SetNotificationPreferencesResponseType';
}

#
# input properties
#

=head2 setApplicationDeliveryPreferences()

Specifies application-based event preferences that have been enabled,
including the URL to which notifications should be delivered and whether
notifications should be enabled or disabled (although the
UserDeliveryPreferenceArray input property specifies specific
notification subscriptions).

  RequiredInput: No
#    Argument: 'ns:ApplicationDeliveryPreferencesType'

=cut
       
sub setApplicationDeliveryPreferences {
   my $self   = shift;
   my $pApplicationDeliveryPreferences = shift;
   $self->getRequestDataType()->setApplicationDeliveryPreferences($pApplicationDeliveryPreferences);
}

=head2 setDeliveryURLName()

For Platform Notifications, specify the name of the delivery notification URL
that you want to associate with the user token specified for
the SetNotificationPreferences call.
If, with different SetNotificationPreferences calls, you
associate multiple URL names with a single user
token, each subsequent URL name overwrites
the previous name associated with the user token.

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setDeliveryURLName {
   my $self   = shift;
   my $sDeliveryURLName = shift;
   $self->getRequestDataType()->setDeliveryURLName($sDeliveryURLName);
}

=head2 setEventProperty()

Characteristics or details of an event such as type, name and value.
Currently can only be set for wireless applications.

  RequiredInput: No
#    Argument: reference to an array  
                      of 'ns:NotificationEventPropertyType'

=cut
       
sub setEventProperty {
   my $self   = shift;
   my $pEventProperty = shift;
   $self->getRequestDataType()->setEventProperty($pEventProperty);
}

=head2 setUserData()

Specifies user data for notification settings such as mobile phone number.

  RequiredInput: No
#    Argument: 'ns:NotificationUserDataType'

=cut
       
sub setUserData {
   my $self   = shift;
   my $pUserData = shift;
   $self->getRequestDataType()->setUserData($pUserData);
}

=head2 setUserDeliveryPreferenceArray()

Array of NotificationEventEnableTypes. Each NotificationEventEnableType
contains an EventSetting and an EventType.

  RequiredInput: No
#    Argument: 'ns:NotificationEnableArrayType'

=cut
       
sub setUserDeliveryPreferenceArray {
   my $self   = shift;
   my $pUserDeliveryPreferenceArray = shift;
   $self->getRequestDataType()->setUserDeliveryPreferenceArray($pUserDeliveryPreferenceArray);
}



#
# output properties
#





1;   
