#!/usr/bin/env raku

use Timer::Stopwatch;

my $irregular-supply = Supply.interval(1).grep: { Bool.pick };

# Will run for 10 seconds.
# Will abort after 2 seconds of silence
# after receiving the first message.

my $timer = Timer::Stopwatch.new;
react {
    whenever $irregular-supply {
        note 'Received an irregular event';

        # Wait up to 2 seconds for the next one
        $timer.reset: 2;
    }
    whenever $timer {
        note "It's been { .round } seconds since the last event";
        $timer.stop;
    }
    whenever Promise.in: 10 {
        note 'Enough...';
        $timer.stop;
    }
    whenever $timer.Promise {
        note "Timer finished { .round } seconds after the last reset";
        done;
    }
}
