#!./perl

BEGIN {
    chdir 't';
    @INC = '../lib';
    require './test.pl';
}

plan(tests => 6);

my $filename = tempfile();
open(TRY,'>',$filename) || (die "Can't open $filename: $!");

$x = 'now is the time
for all good men
to come to.


!

';

$y = 'now is the time' . "\n" .
'for all good men' . "\n" .
'to come to.' . "\n\n\n!\n\n";

is($x, $y,  'test data is sane');

print TRY $x;
close TRY or die "Could not close: $!";

open(TRY,$filename) || (die "Can't reopen $filename: $!");
$count = 0;
$z = '';
while (<TRY>) {
    $z .= $_;
    $count = $count + 1;
}

is($z, $y,  'basic multiline reading');

is($count, 7,   '    line count');
is($., 7,       '    $.' );

$out = (($^O eq 'MSWin32') || $^O eq 'NetWare') ? `type $filename`
    : ($^O eq 'VMS') ? `type $filename.;0`   # otherwise .LIS is assumed
    : `cat $filename`;

like($out, qr/.*\n.*\n.*\n$/);

close(TRY) || (die "Can't close $filename: $!");

is($out, $y);
