#!/usr/bin/perl -w

use strict;

require 5.006 ;

use ExtUtils::MakeMaker ;
use ExtUtils::Embed ;

use Config ;
use File::Copy ;

BEGIN
{
    eval { require File::Spec::Functions ; File::Spec::Functions->import() } ;
    if ($@)
    {
        *catfile = sub { return "$_[0]/$_[1]" }
    }
}

########
# VARS #
########

## EMBED

my $debug = 0;

my $exe = $Config{_exe};
my $o = $Config{_o};
my $pccflags = ccopts;
my $pldflags = ldopts;
my $ld = $Config{ld};
my $cc = $Config{cc};
my $f2c = "./file2c.pl";

my( $out, $ccdebug, $lddebug, $warn, $rm, $mv );

my $is_MSVC = $cc =~ m/^cl/;
if( $is_MSVC ) {
  $out = '-out:';
  $ccdebug = $debug ? '-Zi ' : '';
  $lddebug = $debug ? '-debug ' : '-release ';
  $warn = '-W3';
} else {
  $out = '-o ';
  $ccdebug = $debug ? '-g ' : '';
  $lddebug = $debug ? '' : '-s ';
  $warn = '-Wall -Wno-comments ';
}

$rm = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e rm_f' : 'rm';
$mv = $^O eq 'MSWin32' ? '$(PERL) -MExtUtils::Command -e mv' : 'mv';

my  $cflags = "$ccdebug$warn$pccflags";
my $ldflags = "$lddebug$pldflags";

my $rm_exe = "-\$(RM) *$exe" if $exe ;

## ZLIB

my $ZLIB_LIB = './zlib-src' ;
my $ZLIB_INCLUDE = './zlib-src' ;
my $BUILD_ZLIB = 1 ;
my $OLD_ZLIB = '' ;

#################
# WRITEMAKEFILE #
#################

my %zlib = zlib_files($ZLIB_LIB) ;

#use Data::Dumper ; print Dumper( \%zlib ) ;

my $C_FILES = join(" ", @{$zlib{C}}) ;
my $H_FILES = join(" ", @{$zlib{H}}) ;
my $O_FILES = $zlib{OBJECT} ;

################################################################################

print "Writing Makefile for the embed program (LibZipBin)\n";

open OUT, "> Makefile" or die "open 'Makefile': $!";

print OUT <<EOT;
# AUTOGENERATED, DO NOT EDIT, RERUN Makefile.PL

RM=$rm
MV=$mv
PERL=$^X
LD=$ld
CC=$cc
CFLAGS=$cflags
LDFLAGS=$ldflags

INC = -I./zlib-src

C_FILES = $C_FILES
H_FILES = $H_FILES
O_FILES = $O_FILES

OBJECTS=  \$(O_FILES)

.c$o:
	\$(CC) -c \$(INC) \$(CFLAGS) \$<

all: LibZipBin$exe

clean:
	-\$(RM) *$o *.c *.exe
	-\$(RM) *.opt *.pdb
	\$(MV) Makefile Makefile.old

realclean: clean
	-\$(RM) LibZipBin$exe
	-\$(RM) Makefile Makefile.old

LibZipBin$exe: \$(OBJECTS)
	\$(LD) \$(OBJECTS) \$(LDFLAGS) $out\$@

.SUFFIXES: $o

EOT


################################################################################

sub zlib_files
{
    my $dir = shift ;

    my @h_files = ();
    my @c_files = ();
    
    if (-f catfile($dir, "infback.c")) {
        # zlib 1.2.0 or greater
        #
        @h_files = qw(crc32.h    inffast.h inflate.h  trees.h    zconf.in.h 
    	          zutil.h    deflate.h inffixed.h inftrees.h zconf.h  
    		  zlib.h 
    		 );
        @c_files = qw(adler32  crc32   infback  inflate  uncompr
    		  compress deflate gzio     inffast  inftrees  
    		  trees    zutil main
    		 );
    }
    else {
        # zlib 1.1.x
    
        @h_files = qw(deflate.h  infcodes.h inftrees.h zconf.h zutil.h
    		  infblock.h inffast.h  infutil.h  zlib.h
    		 );
        @c_files = qw(adler32  compress crc32    gzio    uncompr
    		  deflate  trees    zutil    inflate infblock
    		  inftrees infcodes infutil  inffast main
    		 );
    }
    
    @h_files = map { catfile($dir, $_)  } @h_files ;
    my @o_files = map { "$_$o" } @c_files;
    @c_files = map { "$_.c" } @c_files ;

    foreach my $file (@c_files)
      { copy(catfile($dir, $file), '.') }
    
    return (
        'H'         =>  [ @h_files ],
    	'C'         =>  [ @c_files ] ,
        'OBJECT'    => qq[ @o_files ],

           ) ;
}



