package Getopt::Type::Tiny::Types;

# ABSTRACT: No user-serviceable parts inside

use strict;
use warnings;
use Type::Library -base;
use Type::Utils -all;

our @EXPORT_OK;

BEGIN {
    extends qw(
      Types::Standard
      Types::Common::Numeric
      Types::Common::String
    );
    @EXPORT_OK = grep {/\A[[:upper:]]/} (
        Types::Standard->type_names,
        Types::Common::Numeric->type_names,
        Types::Common::String->type_names,
    );
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Getopt::Type::Tiny::Types - No user-serviceable parts inside

=head1 VERSION

version 0.02

=head1 DESCRIPTION

This module is merely intended to provide core types to our getopts wrapper.
It is not intended to be used directly.

=head1 AUTHOR

Curtis "Ovid" Poe <curtis.poe@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2025 by Curtis "Ovid" Poe.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
