# ABSTRACT: Types for Net::Object::Peer
package Net::Object::Peer::Types;

use strict;
use warnings;

our $VERSION = '0.06'; # TRIAL

use Type::Library
  -base,
  -declare => qw[ Identifier ];

use Type::Utils -all;
use Types::Standard -types;

declare Identifier,
as Str,
where { $_[0] !~ /\W/ };

1;

__END__

=pod

=head1 NAME

Net::Object::Peer::Types - Types for Net::Object::Peer

=head1 VERSION

version 0.06

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Smithsonian Astrophysical Observatory.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut
