# Generated by default/object.tt
package Paws::Quicksight::Sheet;
  use Moose;
  has Name => (is => 'ro', isa => 'Str');
  has SheetId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Quicksight::Sheet

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Quicksight::Sheet object:

  $service_obj->Method(Att1 => { Name => $value, ..., SheetId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Quicksight::Sheet object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

A I<sheet>, which is an object that contains a set of visuals that are
viewed together on one page in the Amazon QuickSight console. Every
analysis and dashboard contains at least one sheet. Each sheet contains
at least one visualization widget, for example a chart, pivot table, or
narrative insight. Sheets can be associated with other components, such
as controls, filters, and so on.

=head1 ATTRIBUTES


=head2 Name => Str

The name of a sheet. This name is displayed on the sheet's tab in the
QuickSight console.


=head2 SheetId => Str

The unique identifier associated with a sheet.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Quicksight>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

