#ifndef SASS_COLOR_MAPS_H
#define SASS_COLOR_MAPS_H

#include <map>
#include "ast.hpp"

namespace Sass {

  struct map_cmp_str
  {
    bool operator()(char const *a, char const *b) const
    {
      return std::strcmp(a, b) < 0;
    }
  };

  namespace ColorNames
  {
    extern const char aliceblue[];
    extern const char antiquewhite[];
    extern const char cyan[];
    extern const char aqua[];
    extern const char aquamarine[];
    extern const char azure[];
    extern const char beige[];
    extern const char bisque[];
    extern const char black[];
    extern const char blanchedalmond[];
    extern const char blue[];
    extern const char blueviolet[];
    extern const char brown[];
    extern const char burlywood[];
    extern const char cadetblue[];
    extern const char chartreuse[];
    extern const char chocolate[];
    extern const char coral[];
    extern const char cornflowerblue[];
    extern const char cornsilk[];
    extern const char crimson[];
    extern const char darkblue[];
    extern const char darkcyan[];
    extern const char darkgoldenrod[];
    extern const char darkgray[];
    extern const char darkgrey[];
    extern const char darkgreen[];
    extern const char darkkhaki[];
    extern const char darkmagenta[];
    extern const char darkolivegreen[];
    extern const char darkorange[];
    extern const char darkorchid[];
    extern const char darkred[];
    extern const char darksalmon[];
    extern const char darkseagreen[];
    extern const char darkslateblue[];
    extern const char darkslategray[];
    extern const char darkslategrey[];
    extern const char darkturquoise[];
    extern const char darkviolet[];
    extern const char deeppink[];
    extern const char deepskyblue[];
    extern const char dimgray[];
    extern const char dimgrey[];
    extern const char dodgerblue[];
    extern const char firebrick[];
    extern const char floralwhite[];
    extern const char forestgreen[];
    extern const char magenta[];
    extern const char fuchsia[];
    extern const char gainsboro[];
    extern const char ghostwhite[];
    extern const char gold[];
    extern const char goldenrod[];
    extern const char gray[];
    extern const char grey[];
    extern const char green[];
    extern const char greenyellow[];
    extern const char honeydew[];
    extern const char hotpink[];
    extern const char indianred[];
    extern const char indigo[];
    extern const char ivory[];
    extern const char khaki[];
    extern const char lavender[];
    extern const char lavenderblush[];
    extern const char lawngreen[];
    extern const char lemonchiffon[];
    extern const char lightblue[];
    extern const char lightcoral[];
    extern const char lightcyan[];
    extern const char lightgoldenrodyellow[];
    extern const char lightgray[];
    extern const char lightgrey[];
    extern const char lightgreen[];
    extern const char lightpink[];
    extern const char lightsalmon[];
    extern const char lightseagreen[];
    extern const char lightskyblue[];
    extern const char lightslategray[];
    extern const char lightslategrey[];
    extern const char lightsteelblue[];
    extern const char lightyellow[];
    extern const char lime[];
    extern const char limegreen[];
    extern const char linen[];
    extern const char maroon[];
    extern const char mediumaquamarine[];
    extern const char mediumblue[];
    extern const char mediumorchid[];
    extern const char mediumpurple[];
    extern const char mediumseagreen[];
    extern const char mediumslateblue[];
    extern const char mediumspringgreen[];
    extern const char mediumturquoise[];
    extern const char mediumvioletred[];
    extern const char midnightblue[];
    extern const char mintcream[];
    extern const char mistyrose[];
    extern const char moccasin[];
    extern const char navajowhite[];
    extern const char navy[];
    extern const char oldlace[];
    extern const char olive[];
    extern const char olivedrab[];
    extern const char orange[];
    extern const char orangered[];
    extern const char orchid[];
    extern const char palegoldenrod[];
    extern const char palegreen[];
    extern const char paleturquoise[];
    extern const char palevioletred[];
    extern const char papayawhip[];
    extern const char peachpuff[];
    extern const char peru[];
    extern const char pink[];
    extern const char plum[];
    extern const char powderblue[];
    extern const char purple[];
    extern const char red[];
    extern const char rosybrown[];
    extern const char royalblue[];
    extern const char saddlebrown[];
    extern const char salmon[];
    extern const char sandybrown[];
    extern const char seagreen[];
    extern const char seashell[];
    extern const char sienna[];
    extern const char silver[];
    extern const char skyblue[];
    extern const char slateblue[];
    extern const char slategray[];
    extern const char slategrey[];
    extern const char snow[];
    extern const char springgreen[];
    extern const char steelblue[];
    extern const char tan[];
    extern const char teal[];
    extern const char thistle[];
    extern const char tomato[];
    extern const char turquoise[];
    extern const char violet[];
    extern const char wheat[];
    extern const char white[];
    extern const char whitesmoke[];
    extern const char yellow[];
    extern const char yellowgreen[];
    extern const char rebeccapurple[];
    extern const char transparent[];
  }

  namespace Colors {
    extern const Color aliceblue;
    extern const Color antiquewhite;
    extern const Color cyan;
    extern const Color aqua;
    extern const Color aquamarine;
    extern const Color azure;
    extern const Color beige;
    extern const Color bisque;
    extern const Color black;
    extern const Color blanchedalmond;
    extern const Color blue;
    extern const Color blueviolet;
    extern const Color brown;
    extern const Color burlywood;
    extern const Color cadetblue;
    extern const Color chartreuse;
    extern const Color chocolate;
    extern const Color coral;
    extern const Color cornflowerblue;
    extern const Color cornsilk;
    extern const Color crimson;
    extern const Color darkblue;
    extern const Color darkcyan;
    extern const Color darkgoldenrod;
    extern const Color darkgray;
    extern const Color darkgrey;
    extern const Color darkgreen;
    extern const Color darkkhaki;
    extern const Color darkmagenta;
    extern const Color darkolivegreen;
    extern const Color darkorange;
    extern const Color darkorchid;
    extern const Color darkred;
    extern const Color darksalmon;
    extern const Color darkseagreen;
    extern const Color darkslateblue;
    extern const Color darkslategray;
    extern const Color darkslategrey;
    extern const Color darkturquoise;
    extern const Color darkviolet;
    extern const Color deeppink;
    extern const Color deepskyblue;
    extern const Color dimgray;
    extern const Color dimgrey;
    extern const Color dodgerblue;
    extern const Color firebrick;
    extern const Color floralwhite;
    extern const Color forestgreen;
    extern const Color magenta;
    extern const Color fuchsia;
    extern const Color gainsboro;
    extern const Color ghostwhite;
    extern const Color gold;
    extern const Color goldenrod;
    extern const Color gray;
    extern const Color grey;
    extern const Color green;
    extern const Color greenyellow;
    extern const Color honeydew;
    extern const Color hotpink;
    extern const Color indianred;
    extern const Color indigo;
    extern const Color ivory;
    extern const Color khaki;
    extern const Color lavender;
    extern const Color lavenderblush;
    extern const Color lawngreen;
    extern const Color lemonchiffon;
    extern const Color lightblue;
    extern const Color lightcoral;
    extern const Color lightcyan;
    extern const Color lightgoldenrodyellow;
    extern const Color lightgray;
    extern const Color lightgrey;
    extern const Color lightgreen;
    extern const Color lightpink;
    extern const Color lightsalmon;
    extern const Color lightseagreen;
    extern const Color lightskyblue;
    extern const Color lightslategray;
    extern const Color lightslategrey;
    extern const Color lightsteelblue;
    extern const Color lightyellow;
    extern const Color lime;
    extern const Color limegreen;
    extern const Color linen;
    extern const Color maroon;
    extern const Color mediumaquamarine;
    extern const Color mediumblue;
    extern const Color mediumorchid;
    extern const Color mediumpurple;
    extern const Color mediumseagreen;
    extern const Color mediumslateblue;
    extern const Color mediumspringgreen;
    extern const Color mediumturquoise;
    extern const Color mediumvioletred;
    extern const Color midnightblue;
    extern const Color mintcream;
    extern const Color mistyrose;
    extern const Color moccasin;
    extern const Color navajowhite;
    extern const Color navy;
    extern const Color oldlace;
    extern const Color olive;
    extern const Color olivedrab;
    extern const Color orange;
    extern const Color orangered;
    extern const Color orchid;
    extern const Color palegoldenrod;
    extern const Color palegreen;
    extern const Color paleturquoise;
    extern const Color palevioletred;
    extern const Color papayawhip;
    extern const Color peachpuff;
    extern const Color peru;
    extern const Color pink;
    extern const Color plum;
    extern const Color powderblue;
    extern const Color purple;
    extern const Color red;
    extern const Color rosybrown;
    extern const Color royalblue;
    extern const Color saddlebrown;
    extern const Color salmon;
    extern const Color sandybrown;
    extern const Color seagreen;
    extern const Color seashell;
    extern const Color sienna;
    extern const Color silver;
    extern const Color skyblue;
    extern const Color slateblue;
    extern const Color slategray;
    extern const Color slategrey;
    extern const Color snow;
    extern const Color springgreen;
    extern const Color steelblue;
    extern const Color tan;
    extern const Color teal;
    extern const Color thistle;
    extern const Color tomato;
    extern const Color turquoise;
    extern const Color violet;
    extern const Color wheat;
    extern const Color white;
    extern const Color whitesmoke;
    extern const Color yellow;
    extern const Color yellowgreen;
    extern const Color rebeccapurple;
    extern const Color transparent;
  }

  extern const std::map<const int, const char*> colors_to_names;
  extern const std::map<const char*, Color_Ptr_Const, map_cmp_str> names_to_colors;

  extern Color_Ptr_Const name_to_color(const char*);
  extern Color_Ptr_Const name_to_color(const std::string&);
  extern const char* color_to_name(const int);
  extern const char* color_to_name(const Color&);
  extern const char* color_to_name(const double);

}

#endif
