# This Makefile.PL for App-Sandy was generated by
# inc::SandyMakeMaker <self>
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.47.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT" => "A straightforward and complete next-generation sequencing read simulator",
  "AUTHOR" => "Thiago L. A. Miller <tmiller\@mochsl.org.br>, J. Leonel Buzzo <lbuzzo\@mochsl.org.br>, Felipe R. C. dos Santos <fsantos\@mochsl.org.br>, Helena B. Concei\x{e7}\x{e3}o <hconceicao\@mochsl.org.br>, Rodrigo Barreiro <rbarreiro\@mochsl.org.br>, Gabriela Guardia <gguardia\@mochsl.org.br>, Fernanda Orpinelli <forpinelli\@mochsl.org.br>, Pedro A. F. Galante <pgalante\@mochsl.org.br>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "App-Sandy",
  "EXE_FILES" => [
    "script/sandy"
  ],
  "LICENSE" => "gpl",
  "NAME" => "App::Sandy",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Compress::BGZF::Writer" => 0,
    "DBIx::Class::Core" => 0,
    "DBIx::Class::Schema" => 0,
    "Data::OptList" => 0,
    "File::Cat" => 0,
    "File::Path" => 0,
    "Getopt::Long" => 0,
    "Hook::AfterRuntime" => 0,
    "IO::Compress::Gzip" => 0,
    "IO::Handle" => 0,
    "IO::Uncompress::Gunzip" => 0,
    "Import::Into" => 0,
    "List::Util" => "1.44",
    "Math::Random" => "0.72",
    "Module::Runtime" => 0,
    "Moose" => 0,
    "Moose::Role" => 0,
    "Moose::Util::TypeConstraints" => 0,
    "MooseX::Singleton" => 0,
    "MooseX::StrictConstructor" => 0,
    "MooseX::UndefTolerant" => 0,
    "Parallel::ForkManager" => "1.19",
    "Path::Class" => 0,
    "PerlIO::gzip" => "0.19",
    "Pod::Usage" => 0,
    "Scalar::Util" => 0,
    "Storable" => "2.51",
    "Text::ASCIITable" => 0,
    "Try::Tiny" => 0,
    "base" => 0,
    "constant" => 0,
    "feature" => 0,
    "namespace::autoclean" => 0,
    "strict" => 0,
    "true" => 0,
    "utf8" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Class::Data::Inheritable" => "0.08",
    "Test::Class" => "0.50",
    "Test::Most" => "0.35",
    "Test::UseAllModules" => 0,
    "autodie" => 0
  },
  "VERSION" => "0.23",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Carp" => 0,
  "Class::Data::Inheritable" => "0.08",
  "Compress::BGZF::Writer" => 0,
  "DBIx::Class::Core" => 0,
  "DBIx::Class::Schema" => 0,
  "Data::OptList" => 0,
  "File::Cat" => 0,
  "File::Path" => 0,
  "Getopt::Long" => 0,
  "Hook::AfterRuntime" => 0,
  "IO::Compress::Gzip" => 0,
  "IO::Handle" => 0,
  "IO::Uncompress::Gunzip" => 0,
  "Import::Into" => 0,
  "List::Util" => "1.44",
  "Math::Random" => "0.72",
  "Module::Runtime" => 0,
  "Moose" => 0,
  "Moose::Role" => 0,
  "Moose::Util::TypeConstraints" => 0,
  "MooseX::Singleton" => 0,
  "MooseX::StrictConstructor" => 0,
  "MooseX::UndefTolerant" => 0,
  "Parallel::ForkManager" => "1.19",
  "Path::Class" => 0,
  "PerlIO::gzip" => "0.19",
  "Pod::Usage" => 0,
  "Scalar::Util" => 0,
  "Storable" => "2.51",
  "Test::Class" => "0.50",
  "Test::Most" => "0.35",
  "Test::UseAllModules" => 0,
  "Text::ASCIITable" => 0,
  "Try::Tiny" => 0,
  "autodie" => 0,
  "base" => 0,
  "constant" => 0,
  "feature" => 0,
  "namespace::autoclean" => 0,
  "strict" => 0,
  "true" => 0,
  "utf8" => 0,
  "warnings" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

package MY;

use File::ShareDir::Install;

sub postamble {
	my $self = shift;
	my @ret = File::ShareDir::Install::postamble($self);

	my $cmd = q{
# --- App::Sandy custom postamble section:
INST_DB = $(INST_LIB)/auto/share/dist/$(DISTNAME)
INST_SHARE = blib/share
INSTALLSHARE = /usr/share
DESTINSTALLSHARE = $(DESTDIR)$(INSTALLSHARE)
PERM_DB_DIR = 0777
PERM_DB = 666

pure_perl_install :: all
	$(NOECHO) $(CHMOD) $(PERM_DB_DIR) "$(DESTINSTALLPRIVLIB)/auto/share/dist/$(DISTNAME)"
	$(NOECHO) $(CHMOD) $(PERM_DB) "$(DESTINSTALLPRIVLIB)/auto/share/dist/$(DISTNAME)/db.sqlite3"

pure_site_install :: all
	$(NOECHO) $(CHMOD) $(PERM_DB_DIR) "$(DESTINSTALLSITELIB)/auto/share/dist/$(DISTNAME)"
	$(NOECHO) $(CHMOD) $(PERM_DB) "$(DESTINSTALLSITELIB)/auto/share/dist/$(DISTNAME)/db.sqlite3"

pure_vendor_install :: all
	$(NOECHO) $(CHMOD) $(PERM_DB_DIR) "$(DESTINSTALLVENDORLIB)/auto/share/dist/$(DISTNAME)"
	$(NOECHO) $(CHMOD) $(PERM_DB) "$(DESTINSTALLVENDORLIB)/auto/share/dist/$(DISTNAME)/db.sqlite3"

pure_perl_install :: all
	-$(NOECHO) $(MOD_INSTALL) \
		read "$(PERL_ARCHLIB)/auto/$(FULLEXT)/.packlist" \
		write "$(DESTINSTALLARCHLIB)/auto/$(FULLEXT)/.packlist" \
		"$(INST_SHARE)" "$(DESTINSTALLSHARE)"

pure_site_install :: all
	-$(NOECHO) $(MOD_INSTALL) \
		read "$(SITEARCHEXP)/auto/$(FULLEXT)/.packlist" \
		write "$(DESTINSTALLSITEARCH)/auto/$(FULLEXT)/.packlist" \
		"$(INST_SHARE)" "$(DESTINSTALLSHARE)"

pure_vendor_install :: all
	-$(NOECHO) $(MOD_INSTALL) \
		read "$(VENDORARCHEXP)/auto/$(FULLEXT)/.packlist" \
		write "$(DESTINSTALLVENDORARCH)/auto/$(FULLEXT)/.packlist" \
		"$(INST_SHARE)" "$(DESTINSTALLSHARE)"

config ::
	$(NOECHO) $(ABSPERLRUN) -MExtUtils::Install -e 'pm_to_blib({@ARGV}, '\''$(INST_DB)'\'')' -- \
		'share/assets/db.sql' '$(INST_DB)/db.sql' \
		'share/assets/db.sqlite3' '$(INST_DB)/db.sqlite3'

config ::
	$(NOECHO) $(ABSPERLRUN) -MExtUtils::Install -e 'pm_to_blib({@ARGV}, '\''$(INST_SHARE)'\'')' -- \
		'share/completions/sandy-completion.bash' '$(INST_SHARE)/bash-completion/completions/sandy' \
		'share/completions/sandy-completion.zsh' '$(INST_SHARE)/zsh/site-functions/_sandy'

# --- END: App::Sandy custom postamble section
};

	push @ret, $cmd;
	return join "\n", @ret;
}
