# NAME

Mojolicious::Plugin::CoverDb - Mojolicious Plugin

# SYNOPSIS

    # Mojolicious
    $self->plugin('CoverDb');
    $self->plugin('CoverDb' => { dir => 'cover_db', route => 'coverdb' });

    # Mojolicious::Lite
    plugin 'CoverDb';
    plugin 'CoverDb' => { dir => 'cover_db', route => 'coverdb' };

# DESCRIPTION

[Mojolicious::Plugin::CoverDb](https://metacpan.org/pod/Mojolicious::Plugin::CoverDb) is a [Mojolicious](https://metacpan.org/pod/Mojolicious) plugin to conveniently expose a `cover_db` directory
generated by [Devel::Cover](https://metacpan.org/pod/Devel::Cover). You automatically get `coverage.html` when going to the exposed route (if
the file exists, otherwise, you’get a list of the files).

As [Devel::Cover](https://metacpan.org/pod/Devel::Cover) is a development tool, the directory is only exposed if `MOJO_MODE` is `development`.

# OPTIONS

[Mojolicious::Plugin::StaticCache](https://metacpan.org/pod/Mojolicious::Plugin::StaticCache) supports the following options.

## dir

The directory to expose. It may be an absolute path or a path relative to your mojolicious app’s directory.

Default is `cover_db`.

## route

The route to the exposed directory.

Default is `coverdb`.

# METHODS

[Mojolicious::Plugin::CoverDb](https://metacpan.org/pod/Mojolicious::Plugin::CoverDb) inherits all methods from
[Mojolicious::Plugin](https://metacpan.org/pod/Mojolicious::Plugin) and implements the following new ones.

## register

    $plugin->register(Mojolicious->new);

Register plugin in [Mojolicious](https://metacpan.org/pod/Mojolicious) application.

# BUGS and SUPPORT

The latest source code can be browsed and fetched at:

    https://framagit.org/fiat-tux/mojolicious/mojolicious-plugin-coverdb
    git clone https://framagit.org/fiat-tux/mojolicious/mojolicious-plugin-coverdb.git

Bugs and feature requests will be tracked at:

    https://framagit.org/fiat-tux/mojolicious/mojolicious-plugin-coverdb/issues

# AUTHOR

    Luc DIDRY
    CPAN ID: LDIDRY
    ldidry@cpan.org
    https://fiat-tux.fr/

# COPYRIGHT

This program is free software; you can redistribute
it and/or modify it under the same terms as Perl itself.

The full text of the license can be found in the
LICENSE file included with this module.

# SEE ALSO

[Mojolicious](https://metacpan.org/pod/Mojolicious), [Mojolicious::Guides](https://metacpan.org/pod/Mojolicious::Guides), [https://mojolicious.org](https://mojolicious.org).
