/*
** Copyright (c) 2007-2016, Erik de Castro Lopo <erikd@mega-nerd.com>
** All rights reserved.
**
** This code is released under 2-clause BSD license. Please see the
** file at : https://github.com/erikd/libsamplerate/blob/master/COPYING
*/

/*
** f = make_src_filter (cycles = 21, incr = 491, atten = 122.000000)
**
**   Stop band atten. : 120.61 dB
**   -3dB band width  : 1.811
**   half length      : 22437
**   increment        : 491
*/

static const struct slow_mid_qual_coeffs_s
{	int increment ;
	coeff_t coeffs [22438] ;
} slow_mid_qual_coeffs =
{	491,
{
 9.190632349861385109e-01,
 9.190579273831620544e-01,
 9.190420046848706281e-01,
 9.190154672231939381e-01,
 9.189783155513205903e-01,
 9.189305504437105254e-01,
 9.188721728960548285e-01,
 9.188031841252660703e-01,
 9.187235855694375619e-01,
 9.186333788878118245e-01,
 9.185325659607400661e-01,
 9.184211488896345532e-01,
 9.182991299969165411e-01,
 9.181665118259576541e-01,
 9.180232971410120513e-01,
 9.178694889271632462e-01,
 9.177050903902308487e-01,
 9.175301049567006206e-01,
 9.173445362736407649e-01,
 9.171483882086021167e-01,
 9.169416648495360977e-01,
 9.167243705046783653e-01,
 9.164965097024515561e-01,
 9.162580871913481584e-01,
 9.160091079398144931e-01,
 9.157495771361238157e-01,
 9.154795001882498617e-01,
 9.151988827237356183e-01,
 9.149077305895451095e-01,
 9.146060498519228421e-01,
 9.142938467962469229e-01,
 9.139711279268634136e-01,
 9.136378999669314549e-01,
 9.132941698582575096e-01,
 9.129399447611106222e-01,
 9.125752320540596596e-01,
 9.122000393337836854e-01,
 9.118143744148777818e-01,
 9.114182453296666431e-01,
 9.110116603280005165e-01,
 9.105946278770478131e-01,
 9.101671566610971542e-01,
 9.097292555813195625e-01,
 9.092809337555683991e-01,
 9.088222005181412211e-01,
 9.083530654195477450e-01,
 9.078735382262775877e-01,
 9.073836289205553518e-01,
 9.068833477000901588e-01,
 9.063727049778221856e-01,
 9.058517113816679789e-01,
 9.053203777542537800e-01,
 9.047787151526440752e-01,
 9.042267348480692579e-01,
 9.036644483256435212e-01,
 9.030918672840801964e-01,
 9.025090036354035394e-01,
 9.019158695046503027e-01,
 9.013124772295638687e-01,
 9.006988393602999299e-01,
 9.000749686590990839e-01,
 8.994408780999827435e-01,
 8.987965808684226232e-01,
 8.981420903610175532e-01,
 8.974774201851590805e-01,
 8.968025841586921842e-01,
 8.961175963095725505e-01,
 8.954224708755219586e-01,
 8.947172223036650163e-01,
 8.940018652501846574e-01,
 8.932764145799431121e-01,
 8.925408853661255248e-01,
 8.917952928898525977e-01,
 8.910396526398144390e-01,
 8.902739803118754347e-01,
 8.894982918086901114e-01,
 8.887126032393080077e-01,
 8.879169309187701087e-01,
 8.871112913677079437e-01,
 8.862957013119301397e-01,
 8.854701776820081971e-01,
 8.846347376128601558e-01,
 8.837893984433177197e-01,
 8.829341777157024840e-01,
 8.820690931753858433e-01,
 8.811941627703521185e-01,
 8.803094046507521364e-01,
 8.794148371684512577e-01,
 8.785104788765752959e-01,
 8.775963485290545485e-01,
 8.766724650801458463e-01,
 8.757388476839771396e-01,
 8.747955156940626642e-01,
 8.738424886628276544e-01,
 8.728797863411223990e-01,
 8.719074286777279692e-01,
 8.709254358188718292e-01,
 8.699338281077153567e-01,
 8.689326260838612370e-01,
 8.679218504828314362e-01,
 8.669015222355691552e-01,
 8.658716624679085871e-01,
 8.648322925000503369e-01,
 8.637834338460406158e-01,
 8.627251082132331161e-01,
 8.616573375017505532e-01,
 8.605801438039482054e-01,
 8.594935494038545842e-01,
 8.583975767766348630e-01,
 8.572922485880160037e-01,
 8.561775876937460783e-01,
 8.550536171390092921e-01,
 8.539203601578667646e-01,
 8.527778401726748836e-01,
 8.516260807935129851e-01,
 8.504651058175859424e-01,
 8.492949392286508470e-01,
 8.481156051964116038e-01,
 8.469271280759230747e-01,
 8.457295324069898923e-01,
 8.445228429135611670e-01,
 8.433070845031135354e-01,
 8.420822822660410933e-01,
 8.408484614750260100e-01,
 8.396056475844214662e-01,
 8.383538662296191601e-01,
 8.370931432264129279e-01,
 8.358235045703655830e-01,
 8.345449764361591027e-01,
 8.332575851769530306e-01,
 8.319613573237311099e-01,
 8.306563195846453640e-01,
 8.293424988443554025e-01,
 8.280199221633630646e-01,
 8.266886167773459526e-01,
 8.253486100964876337e-01,
 8.239999297047861937e-01,
 8.226426033593938758e-01,
 8.212766589899133107e-01,
 8.199021246977172828e-01,
 8.185190287552487343e-01,
 8.171273996053307620e-01,
 8.157272658604564075e-01,
 8.143186563020841096e-01,
 8.129015998799332676e-01,
 8.114761257112590442e-01,
 8.100422630801440427e-01,
 8.086000414367682243e-01,
 8.071494903966890400e-01,
 8.056906397400991349e-01,
 8.042235194111070351e-01,
 8.027481595169910777e-01,
 8.012645903274501213e-01,
 7.997728422738685783e-01,
 7.982729459485642387e-01,
 7.967649321040266575e-01,
 7.952488316521624245e-01,
 7.937246756635402134e-01,
 7.921924953666147351e-01,
 7.906523221469667906e-01,
 7.891041875465214517e-01,
 7.875481232627762340e-01,
 7.859841611480169465e-01,
 7.844123332085419786e-01,
 7.828326716038601640e-01,
 7.812452086459110712e-01,
 7.796499767982624229e-01,
 7.780470086753159542e-01,
 7.764363370415053867e-01,
 7.748179948104801928e-01,
 7.731920150443076789e-01,
 7.715584309526551943e-01,
 7.699172758919735626e-01,
 7.682685833646747398e-01,
 7.666123870183109146e-01,
 7.649487206447473930e-01,
 7.632776181793284875e-01,
 7.615991137000481803e-01,
 7.599132414267077973e-01,
 7.582200357200843399e-01,
 7.565195310810692852e-01,
 7.548117621498410257e-01,
 7.530967637050012264e-01,
 7.513745706627268373e-01,
 7.496452180759085593e-01,
 7.479087411332924207e-01,
 7.461651751586176884e-01,
 7.444145556097488958e-01,
 7.426569180778060941e-01,
 7.408922982862901074e-01,
 7.391207320902084543e-01,
 7.373422554751976055e-01,
 7.355569045566335840e-01,
 7.337647155787578868e-01,
 7.319657249137790922e-01,
 7.301599690609852367e-01,
 7.283474846458531937e-01,
 7.265283084191426211e-01,
 7.247024772560038963e-01,
 7.228700281550752837e-01,
 7.210309982375715521e-01,
 7.191854247463771443e-01,
 7.173333450451372384e-01,
 7.154747966173405915e-01,
 7.136098170654050499e-01,
 7.117384441097539538e-01,
 7.098607155879003150e-01,
 7.079766694535134519e-01,
 7.060863437754946181e-01,
 7.041897767370496330e-01,
 7.022870066347511875e-01,
 7.003780718776047021e-01,
 6.984630109861137415e-01,
 6.965418625913292194e-01,
 6.946146654339206972e-01,
 6.926814583632128208e-01,
 6.907422803362553987e-01,
 6.887971704168563969e-01,
 6.868461677746440230e-01,
 6.848893116840982787e-01,
 6.829266415235965004e-01,
 6.809581967744615660e-01,
 6.789840170199873404e-01,
 6.770041419444806641e-01,
 6.750186113322906856e-01,
 6.730274650668458536e-01,
 6.710307431296762548e-01,
 6.690284855994397262e-01,
 6.670207326509497436e-01,
 6.650075245541966495e-01,
 6.629889016733656604e-01,
 6.609649044658548744e-01,
 6.589355734812931686e-01,
 6.569009493605521000e-01,
 6.548610728347569188e-01,
 6.528159847243016900e-01,
 6.507657259378472059e-01,
 6.487103374713369952e-01,
 6.466498604069961242e-01,
 6.445843359123345495e-01,
 6.425138052391472510e-01,
 6.404383097225108123e-01,
 6.383578907797843316e-01,
 6.362725899096030036e-01,
 6.341824486908668179e-01,
 6.320875087817382498e-01,
 6.299878119186311798e-01,
 6.278833999151931522e-01,
 6.257743146613017338e-01,
 6.236605981220407768e-01,
 6.215422923366868968e-01,
 6.194194394176928409e-01,
 6.172920815496674152e-01,
 6.151602609883521922e-01,
 6.130240200596011046e-01,
 6.108834011583562651e-01,
 6.087384467476207872e-01,
 6.065891993574344943e-01,
 6.044357015838404124e-01,
 6.022779960878675842e-01,
 6.001161255944840178e-01,
 5.979501328915760583e-01,
 5.957800608289128830e-01,
 5.936059523171076657e-01,
 5.914278503265888443e-01,
 5.892457978865548451e-01,
 5.870598380839474606e-01,
 5.848700140623979138e-01,
 5.826763690212029001e-01,
 5.804789462142687650e-01,
 5.782777889490804402e-01,
 5.760729405856517271e-01,
 5.738644445354834644e-01,
 5.716523442605190297e-01,
 5.694366832720955118e-01,
 5.672175051299007675e-01,
 5.649948534409220402e-01,
 5.627687718583990195e-01,
 5.605393040807753469e-01,
 5.583064938506450137e-01,
 5.560703849537081966e-01,
 5.538310212177105507e-01,
 5.515884465114002655e-01,
 5.493427047434678023e-01,
 5.470938398614946241e-01,
 5.448418958509020360e-01,
 5.425869167338921439e-01,
 5.403289465683932535e-01,
 5.380680294470076008e-01,
 5.358042094959520885e-01,
 5.335375308740007982e-01,
 5.312680377714298352e-01,
 5.289957744089563985e-01,
 5.267207850366882882e-01,
 5.244431139330546499e-01,
 5.221628054037583677e-01,
 5.198799037807055878e-01,
 5.175944534209612202e-01,
 5.153064987056736879e-01,
 5.130160840390248778e-01,
 5.107232538471692118e-01,
 5.084280525771708303e-01,
 5.061305246959465487e-01,
 5.038307146892031518e-01,
 5.015286670603764652e-01,
 4.992244263295749218e-01,
 4.969180370325161356e-01,
 4.946095437194681921e-01,
 4.922989909541840015e-01,
 4.899864233128516933e-01,
 4.876718853830233624e-01,
 4.853554217625615785e-01,
 4.830370770585796225e-01,
 4.807168958863756725e-01,
 4.783949228683817001e-01,
 4.760712026330969904e-01,
 4.737457798140347620e-01,
 4.714186990486617379e-01,
 4.690900049773344405e-01,
 4.667597422422511966e-01,
 4.644279554863849913e-01,
 4.620946893524336962e-01,
 4.597599884817572535e-01,
 4.574238975133261276e-01,
 4.550864610826618750e-01,
 4.527477238207830434e-01,
 4.504077303531530130e-01,
 4.480665252986199554e-01,
 4.457241532683687835e-01,
 4.433806588648644964e-01,
 4.410360866808032965e-01,
 4.386904812980580992e-01,
 4.363438872866268747e-01,
 4.339963492035851522e-01,
 4.316479115920361376e-01,
 4.292986189800601093e-01,
 4.269485158796667568e-01,
 4.245976467857516812e-01,
 4.222460561750463470e-01,
 4.198937885050729735e-01,
 4.175408882131029231e-01,
 4.151873997151118156e-01,
 4.128333674047376389e-01,
 4.104788356522376391e-01,
 4.081238488034499290e-01,
 4.057684511787542636e-01,
 4.034126870720317060e-01,
 4.010566007496311758e-01,
 3.987002364493300588e-01,
 3.963436383793022544e-01,
 3.939868507170818934e-01,
 3.916299176085331069e-01,
 3.892728831668186840e-01,
 3.869157914713690083e-01,
 3.845586865668559340e-01,
 3.822016124621629984e-01,
 3.798446131293629069e-01,
 3.774877325026881336e-01,
 3.751310144775131805e-01,
 3.727745029093312845e-01,
 3.704182416127326238e-01,
 3.680622743603884639e-01,
 3.657066448820316396e-01,
 3.633513968634422553e-01,
 3.609965739454338851e-01,
 3.586422197228419373e-01,
 3.562883777435115751e-01,
 3.539350915072877468e-01,
 3.515824044650110447e-01,
 3.492303600175108436e-01,
 3.468790015145981065e-01,
 3.445283722540682936e-01,
 3.421785154806974427e-01,
 3.398294743852442457e-01,
 3.374812921034551771e-01,
 3.351340117150671816e-01,
 3.327876762428151336e-01,
 3.304423286514424074e-01,
 3.280980118467101692e-01,
 3.257547686744098892e-01,
 3.234126419193791291e-01,
 3.210716743045173849e-01,
 3.187319084898069810e-01,
 3.163933870713313556e-01,
 3.140561525802987863e-01,
 3.117202474820692792e-01,
 3.093857141751790718e-01,
 3.070525949903712415e-01,
 3.047209321896293677e-01,
 3.023907679652058089e-01,
 3.000621444386648573e-01,
 2.977351036599155676e-01,
 2.954096876062539678e-01,
 2.930859381814076015e-01,
 2.907638972145774048e-01,
 2.884436064594896321e-01,
 2.861251075934408972e-01,
 2.838084422163551501e-01,
 2.814936518498354356e-01,
 2.791807779362223130e-01,
 2.768698618376533860e-01,
 2.745609448351263859e-01,
 2.722540681275621988e-01,
 2.699492728308742207e-01,
 2.676465999770359372e-01,
 2.653460905131571068e-01,
 2.630477853005538380e-01,
 2.607517251138323777e-01,
 2.584579506399626303e-01,
 2.561665024773684407e-01,
 2.538774211350079968e-01,
 2.515907470314657779e-01,
 2.493065204940423107e-01,
 2.470247817578479221e-01,
 2.447455709649018207e-01,
 2.424689281632305682e-01,
 2.401948933059702695e-01,
 2.379235062504720111e-01,
 2.356548067574134042e-01,
 2.333888344899041900e-01,
 2.311256290126076363e-01,
 2.288652297908512490e-01,
 2.266076761897511394e-01,
 2.243530074733340873e-01,
 2.221012628036639069e-01,
 2.198524812399700601e-01,
 2.176067017377827095e-01,
 2.153639631480640526e-01,
 2.131243042163519785e-01,
 2.108877635818975083e-01,
 2.086543797768119768e-01,
 2.064241912252161304e-01,
 2.041972362423890019e-01,
 2.019735530339234475e-01,
 1.997531796948866234e-01,
 1.975361542089770495e-01,
 1.953225144476904152e-01,
 1.931122981694899932e-01,
 1.909055430189743885e-01,
 1.887022865260525595e-01,
 1.865025661051234740e-01,
 1.843064190542557934e-01,
 1.821138825543719975e-01,
 1.799249936684388651e-01,
 1.777397893406555962e-01,
 1.755583063956519529e-01,
 1.733805815376853743e-01,
 1.712066513498422260e-01,
 1.690365522932452125e-01,
 1.668703207062609550e-01,
 1.647079928037134544e-01,
 1.625496046760998015e-01,
 1.603951922888105230e-01,
 1.582447914813536749e-01,
 1.560984379665793786e-01,
 1.539561673299155720e-01,
 1.518180150285969310e-01,
 1.496840163909078092e-01,
 1.475542066154204024e-01,
 1.454286207702433220e-01,
 1.433072937922706958e-01,
 1.411902604864334054e-01,
 1.390775555249584849e-01,
 1.369692134466284628e-01,
 1.348652686560476988e-01,
 1.327657554229089709e-01,
 1.306707078812674727e-01,
 1.285801600288170587e-01,
 1.264941457261690716e-01,
 1.244126986961386766e-01,
 1.223358525230311133e-01,
 1.202636406519352608e-01,
 1.181960963880184096e-01,
 1.161332528958274463e-01,
 1.140751431985919384e-01,
 1.120218001775331595e-01,
 1.099732565711753762e-01,
 1.079295449746630053e-01,
 1.058906978390803943e-01,
 1.038567474707753902e-01,
 1.018277260306897219e-01,
 9.980366553368975879e-02,
 9.778459784790455300e-02,
 9.577055469406584032e-02,
 9.376156764485409079e-02,
 9.175766812424655805e-02,
 8.975888740687235079e-02,
 8.776525661736865602e-02,
 8.577680672974313802e-02,
 8.379356856674115284e-02,
 8.181557279921417014e-02,
 7.984284994549635528e-02,
 7.787543037078317743e-02,
 7.591334428651391741e-02,
 7.395662174976043446e-02,
 7.200529266261787575e-02,
 7.005938677160263028e-02,
 6.811893366705192021e-02,
 6.618396278252910991e-02,
 6.425450339423315060e-02,
 6.233058462041313197e-02,
 6.041223542078567182e-02,
 5.849948459595861322e-02,
 5.659236078685713628e-02,
 5.469089247415612892e-02,
 5.279510797771662378e-02,
 5.090503545602581559e-02,
 4.902070290564224803e-02,
 4.714213816064585783e-02,
 4.526936889209169645e-02,
 4.340242260746868946e-02,
 4.154132665016377346e-02,
 3.968610819892821884e-02,
 3.783679426735115509e-02,
 3.599341170333596185e-02,
 3.415598718858217642e-02,
 3.232454723807156455e-02,
 3.049911819955901035e-02,
 2.867972625306763890e-02,
 2.686639741038932688e-02,
 2.505915751458907478e-02,
 2.325803223951459012e-02,
 2.146304708931060651e-02,
 1.967422739793688383e-02,
 1.789159832869266151e-02,
 1.611518487374387701e-02,
 1.434501185365678888e-02,
 1.258110391693542836e-02,
 1.082348553956342420e-02,
 9.072181024551642312e-03,
 7.327214501490089335e-03,
 5.588609926104382876e-03,
 3.856391079816731595e-03,
 2.130581569313045372e-03,
 4.112048261128918277e-04,
-1.301715893853703891e-03,
-3.008157510666674764e-03,
-4.708097120829565600e-03,
-6.401511997679847077e-03,
-8.088379591793346673e-03,
-9.768677531385444243e-03,
-1.144238362270462092e-02,
-1.310947585042377024e-02,
-1.476993237802585839e-02,
-1.642373154818383557e-02,
-1.807085188313660440e-02,
-1.971127208506028711e-02,
-2.134497103643320792e-02,
-2.297192780039746321e-02,
-2.459212162111552510e-02,
-2.620553192412000687e-02,
-2.781213831666087127e-02,
-2.941192058804676171e-02,
-3.100485870998073712e-02,
-3.259093283689189213e-02,
-3.417012330626258837e-02,
-3.574241063894840337e-02,
-3.730777553949572029e-02,
-3.886619889645268056e-02,
-4.041766178267684750e-02,
-4.196214545563502207e-02,
-4.349963135770099770e-02,
-4.503010111644691060e-02,
-4.655353654492962873e-02,
-4.806991964197219330e-02,
-4.957923259244118031e-02,
-5.108145776751701894e-02,
-5.257657772496109050e-02,
-5.406457520937765077e-02,
-5.554543315246938257e-02,
-5.701913467328958290e-02,
-5.848566307848800799e-02,
-5.994500186255261043e-02,
-6.139713470804509382e-02,
-6.284204548583378902e-02,
-6.427971825531779426e-02,
-6.571013726464908222e-02,
-6.713328695094904208e-02,
-6.854915194051883209e-02,
-6.995771704904532595e-02,
-7.135896728180173010e-02,
-7.275288783384496749e-02,
-7.413946409020417960e-02,
-7.551868162606749368e-02,
-7.689052620696315565e-02,
-7.825498378893407103e-02,
-7.961204051870818255e-02,
-8.096168273386479541e-02,
-8.230389696299372781e-02,
-8.363866992585079763e-02,
-8.496598853350889602e-02,
-8.628583988850112296e-02,
-8.759821128496195208e-02,
-8.890309020876198398e-02,
-9.020046433763699578e-02,
-9.149032154131311878e-02,
-9.277264988162647885e-02,
-9.404743761263691104e-02,
-9.531467318073758022e-02,
-9.657434522475939753e-02,
-9.782644257607100990e-02,
-9.907095425867107341e-02,
-1.003078694892777928e-01,
-1.015371776774138673e-01,
-1.027588684254842066e-01,
-1.039729315288496908e-01,
-1.051793569758964209e-01,
-1.063781349480981131e-01,
-1.075692558200752463e-01,
-1.087527101596490881e-01,
-1.099284887278886014e-01,
-1.110965824791536605e-01,
-1.122569825611343941e-01,
-1.134096803148829935e-01,
-1.145546672748422035e-01,
-1.156919351688680681e-01,
-1.168214759182474166e-01,
-1.179432816377107424e-01,
-1.190573446354401682e-01,
-1.201636574130715424e-01,
-1.212622126656922456e-01,
-1.223530032818331281e-01,
-1.234360223434566306e-01,
-1.245112631259390062e-01,
-1.255787190980464096e-01,
-1.266383839219092644e-01,
-1.276902514529875965e-01,
-1.287343157400339111e-01,
-1.297705710250501576e-01,
-1.307990117432406285e-01,
-1.318196325229574750e-01,
-1.328324281856444466e-01,
-1.338373937457725815e-01,
-1.348345244107727325e-01,
-1.358238155809629033e-01,
-1.368052628494691725e-01,
-1.377788620021447863e-01,
-1.387446090174797586e-01,
-1.397025000665092775e-01,
-1.406525315127157560e-01,
-1.415946999119251926e-01,
-1.425290020122001178e-01,
-1.434554347537262409e-01,
-1.443739952686944883e-01,
-1.452846808811790458e-01,
-1.461874891070080174e-01,
-1.470824176536327244e-01,
-1.479694644199892328e-01,
-1.488486274963550238e-01,
-1.497199051642035539e-01,
-1.505832958960495460e-01,
-1.514387983552939465e-01,
-1.522864113960600008e-01,
-1.531261340630272472e-01,
-1.539579655912597933e-01,
-1.547819054060284583e-01,
-1.555979531226297785e-01,
-1.564061085462002954e-01,
-1.572063716715234871e-01,
-1.579987426828348140e-01,
-1.587832219536197687e-01,
-1.595598100464094560e-01,
-1.603285077125682634e-01,
-1.610893158920797819e-01,
-1.618422357133250944e-01,
-1.625872684928586220e-01,
-1.633244157351789183e-01,
-1.640536791324917476e-01,
-1.647750605644736632e-01,
-1.654885620980248440e-01,
-1.661941859870235405e-01,
-1.668919346720686980e-01,
-1.675818107802248824e-01,
-1.682638171247568815e-01,
-1.689379567048636122e-01,
-1.696042327054044230e-01,
-1.702626484966231479e-01,
-1.709132076338646389e-01,
-1.715559138572904652e-01,
-1.721907710915855649e-01,
-1.728177834456636197e-01,
-1.734369552123671276e-01,
-1.740482908681612872e-01,
-1.746517950728253277e-01,
-1.752474726691367890e-01,
-1.758353286825550810e-01,
-1.764153683208952716e-01,
-1.769875969740035415e-01,
-1.775520202134212855e-01,
-1.781086437920502696e-01,
-1.786574736438100441e-01,
-1.791985158832926639e-01,
-1.797317768054111087e-01,
-1.802572628850462877e-01,
-1.807749807766843297e-01,
-1.812849373140552889e-01,
-1.817871395097633569e-01,
-1.822815945549154382e-01,
-1.827683098187413702e-01,
-1.832472928482144769e-01,
-1.837185513676646009e-01,
-1.841820932783877762e-01,
-1.846379266582506562e-01,
-1.850860597612929148e-01,
-1.855265010173219875e-01,
-1.859592590315060912e-01,
-1.863843425839618873e-01,
-1.868017606293377042e-01,
-1.872115222963938452e-01,
-1.876136368875747640e-01,
-1.880081138785841266e-01,
-1.883949629179472729e-01,
-1.887741938265751485e-01,
-1.891458165973220751e-01,
-1.895098413945400795e-01,
-1.898662785536271713e-01,
-1.902151385805748440e-01,
-1.905564321515070547e-01,
-1.908901701122190653e-01,
-1.912163634777095667e-01,
-1.915350234317103051e-01,
-1.918461613262105736e-01,
-1.921497886809775124e-01,
-1.924459171830743276e-01,
-1.927345586863704607e-01,
-1.930157252110531740e-01,
-1.932894289431289492e-01,
-1.935556822339275507e-01,
-1.938144975995957087e-01,
-1.940658877205916066e-01,
-1.943098654411736514e-01,
-1.945464437688827486e-01,
-1.947756358740273808e-01,
-1.949974550891566127e-01,
-1.952119149085367322e-01,
-1.954190289876166220e-01,
-1.956188111424968790e-01,
-1.958112753493901070e-01,
-1.959964357440767968e-01,
-1.961743066213625097e-01,
-1.963449024345252369e-01,
-1.965082377947637848e-01,
-1.966643274706406652e-01,
-1.968131863875193510e-01,
-1.969548296270003107e-01,
-1.970892724263536289e-01,
-1.972165301779451041e-01,
-1.973366184286627079e-01,
-1.974495528793354937e-01,
-1.975553493841510633e-01,
-1.976540239500707841e-01,
-1.977455927362358201e-01,
-1.978300720533773538e-01,
-1.979074783632173984e-01,
-1.979778282778685006e-01,
-1.980411385592297513e-01,
-1.980974261183778840e-01,
-1.981467080149586224e-01,
-1.981890014565697022e-01,
-1.982243237981424766e-01,
-1.982526925413239660e-01,
-1.982741253338477783e-01,
-1.982886399689092749e-01,
-1.982962543845317727e-01,
-1.982969866629326061e-01,
-1.982908550298856376e-01,
-1.982778778540780218e-01,
-1.982580736464675530e-01,
-1.982314610596337956e-01,
-1.981980588871263271e-01,
-1.981578860628108452e-01,
-1.981109616602116097e-01,
-1.980573048918519430e-01,
-1.979969351085877072e-01,
-1.979298717989431133e-01,
-1.978561345884379818e-01,
-1.977757432389165293e-01,
-1.976887176478709651e-01,
-1.975950778477610914e-01,
-1.974948440053329035e-01,
-1.973880364209327498e-01,
-1.972746755278200759e-01,
-1.971547818914748951e-01,
-1.970283762089042046e-01,
-1.968954793079456533e-01,
-1.967561121465653262e-01,
-1.966102958121587474e-01,
-1.964580515208399492e-01,
-1.962994006167389505e-01,
-1.961343645712849137e-01,
-1.959629649824959630e-01,
-1.957852235742604252e-01,
-1.956011621956174340e-01,
-1.954108028200353953e-01,
-1.952141675446855962e-01,
-1.950112785897158141e-01,
-1.948021582975197619e-01,
-1.945868291320025922e-01,
-1.943653136778486501e-01,
-1.941376346397789276e-01,
-1.939038148418137653e-01,
-1.936638772265284747e-01,
-1.934178448543069084e-01,
-1.931657409025933636e-01,
-1.929075886651437644e-01,
-1.926434115512693501e-01,
-1.923732330850826677e-01,
-1.920970769047395388e-01,
-1.918149667616791398e-01,
-1.915269265198594195e-01,
-1.912329801549935704e-01,
-1.909331517537815881e-01,
-1.906274655131419415e-01,
-1.903159457394377752e-01,
-1.899986168477036386e-01,
-1.896755033608688856e-01,
-1.893466299089792415e-01,
-1.890120212284156775e-01,
-1.886717021611102052e-01,
-1.883256976537637795e-01,
-1.879740327570557090e-01,
-1.876167326248569800e-01,
-1.872538225134368906e-01,
-1.868853277806705182e-01,
-1.865112738852438279e-01,
-1.861316863858549775e-01,
-1.857465909404159565e-01,
-1.853560133052509495e-01,
-1.849599793342928122e-01,
-1.845585149782788814e-01,
-1.841516462839419832e-01,
-1.837393993932036618e-01,
-1.833218005423634112e-01,
-1.828988760612835773e-01,
-1.824706523725789786e-01,
-1.820371559907975889e-01,
-1.815984135216056616e-01,
-1.811544516609651101e-01,
-1.807052971943146902e-01,
-1.802509769957474639e-01,
-1.797915180271848767e-01,
-1.793269473375513623e-01,
-1.788572920619474760e-01,
-1.783825794208199200e-01,
-1.779028367191308468e-01,
-1.774180913455263020e-01,
-1.769283707715027520e-01,
-1.764337025505696988e-01,
-1.759341143174174282e-01,
-1.754296337870740463e-01,
-1.749202887540707296e-01,
-1.744061070915970402e-01,
-1.738871167506614024e-01,
-1.733633457592479721e-01,
-1.728348222214689811e-01,
-1.723015743167230218e-01,
-1.717636302988445329e-01,
-1.712210184952562553e-01,
-1.706737673061213545e-01,
-1.701219052034905754e-01,
-1.695654607304505901e-01,
-1.690044625002734557e-01,
-1.684389391955579962e-01,
-1.678689195673798429e-01,
-1.672944324344317613e-01,
-1.667155066821666698e-01,
-1.661321712619413249e-01,
-1.655444551901550099e-01,
-1.649523875473913603e-01,
-1.643559974775558319e-01,
-1.637553141870143614e-01,
-1.631503669437308346e-01,
-1.625411850764024169e-01,
-1.619277979735971595e-01,
-1.613102350828858056e-01,
-1.606885259099785079e-01,
-1.600627000178563852e-01,
-1.594327870259047986e-01,
-1.587988166090451014e-01,
-1.581608184968653352e-01,
-1.575188224727510355e-01,
-1.568728583730151782e-01,
-1.562229560860272370e-01,
-1.555691455513421584e-01,
-1.549114567588285030e-01,
-1.542499197477955886e-01,
-1.535845646061212433e-01,
-1.529154214693787817e-01,
-1.522425205199613163e-01,
-1.515658919862105658e-01,
-1.508855661415393901e-01,
-1.502015733035588496e-01,
-1.495139438332021009e-01,
-1.488227081338478752e-01,
-1.481278966504471217e-01,
-1.474295398686431557e-01,
-1.467276683138982185e-01,
-1.460223125506163178e-01,
-1.453135031812648192e-01,
-1.446012708454984530e-01,
-1.438856462192825147e-01,
-1.431666600140145407e-01,
-1.424443429756479529e-01,
-1.417187258838134845e-01,
-1.409898395509420199e-01,
-1.402577148213876301e-01,
-1.395223825705493303e-01,
-1.387838737039929771e-01,
-1.380422191565756351e-01,
-1.372974498915662533e-01,
-1.365495968997690046e-01,
-1.357986911986465428e-01,
-1.350447638314421495e-01,
-1.342878458663030183e-01,
-1.335279683954043173e-01,
-1.327651625340714736e-01,
-1.319994594199049298e-01,
-1.312308902119038168e-01,
-1.304594860895899600e-01,
-1.296852782521335790e-01,
-1.289082979174762944e-01,
-1.281285763214592144e-01,
-1.273461447169460803e-01,
-1.265610343729507703e-01,
-1.257732765737639424e-01,
-1.249829026180795249e-01,
-1.241899438181227056e-01,
-1.233944314987776986e-01,
-1.225963969967164835e-01,
-1.217958716595282653e-01,
-1.209928868448487266e-01,
-1.201874739194905700e-01,
-1.193796642585740891e-01,
-1.185694892446600424e-01,
-1.177569802668806259e-01,
-1.169421687200731391e-01,
-1.161250860039137744e-01,
-1.153057635220514771e-01,
-1.144842326812446492e-01,
-1.136605248904952736e-01,
-1.128346715601877132e-01,
-1.120067041012253739e-01,
-1.111766539241694496e-01,
-1.103445524383789011e-01,
-1.095104310511497286e-01,
-1.086743211668582260e-01,
-1.078362541861021262e-01,
-1.069962615048431626e-01,
-1.061543745135536260e-01,
-1.053106245963597309e-01,
-1.044650431301889504e-01,
-1.036176614839176974e-01,
-1.027685110175191041e-01,
-1.019176230812139927e-01,
-1.010650290146204999e-01,
-1.002107601459072267e-01,
-9.935484779094549967e-02,
-9.849732325246546294e-02,
-9.763821781920969944e-02,
-9.677756276509209832e-02,
-9.591538934835500130e-02,
-9.505172881072967983e-02,
-9.418661237659614605e-02,
-9.332007125214691889e-02,
-9.245213662454923598e-02,
-9.158283966111123442e-02,
-9.071221150844796521e-02,
-8.984028329164922555e-02,
-8.896708611344975037e-02,
-8.809265105339894597e-02,
-8.721700916703446771e-02,
-8.634019148505563124e-02,
-8.546222901249865556e-02,
-8.458315272791444572e-02,
-8.370299358254701394e-02,
-8.282178249951348270e-02,
-8.193955037298662758e-02,
-8.105632806737848861e-02,
-8.017214641652514739e-02,
-7.928703622287416874e-02,
-7.840102825667365216e-02,
-7.751415325516218535e-02,
-7.662644192176196190e-02,
-7.573792492527164910e-02,
-7.484863289906408534e-02,
-7.395859644028197899e-02,
-7.306784610903965804e-02,
-7.217641242762286302e-02,
-7.128432587969313339e-02,
-7.039161690949324868e-02,
-6.949831592105389089e-02,
-6.860445327740317956e-02,
-6.771005929977824689e-02,
-6.681516426683822840e-02,
-6.591979841387921035e-02,
-6.502399193205235517e-02,
-6.412777496758288731e-02,
-6.323117762099134120e-02,
-6.233422994631773739e-02,
-6.143696195034705626e-02,
-6.053940359183709874e-02,
-5.964158478074842867e-02,
-5.874353537747725729e-02,
-5.784528519208916031e-02,
-5.694686398355629231e-02,
-5.604830145899593330e-02,
-5.514962727291260886e-02,
-5.425087102644017556e-02,
-5.335206226658920081e-02,
-5.245323048549390549e-02,
-5.155440511966371403e-02,
-5.065561554923501270e-02,
-4.975689109722783443e-02,
-4.885826102880189148e-02,
-4.795975455051824932e-02,
-4.706140080960100752e-02,
-4.616322889320215866e-02,
-4.526526782767004153e-02,
-4.436754657781861316e-02,
-4.347009404619985723e-02,
-4.257293907237917618e-02,
-4.167611043221376710e-02,
-4.077963683713110854e-02,
-3.988354693341313734e-02,
-3.898786930148114699e-02,
-3.809263245518437757e-02,
-3.719786484108952851e-02,
-3.630359483777548940e-02,
-3.540985075512882024e-02,
-3.451666083364200721e-02,
-3.362405324371572218e-02,
-3.273205608496281699e-02,
-3.184069738551512097e-02,
-3.095000510133325000e-02,
-3.006000711551949645e-02,
-2.917073123763230108e-02,
-2.828220520300543661e-02,
-2.739445667206867954e-02,
-2.650751322967108067e-02,
-2.562140238440870077e-02,
-2.473615156795364034e-02,
-2.385178813438674703e-02,
-2.296833935953311243e-02,
-2.208583244030043816e-02,
-2.120429449402067013e-02,
-2.032375255779379775e-02,
-1.944423358783580608e-02,
-1.856576445882891432e-02,
-1.768837196327451358e-02,
-1.681208281085015688e-02,
-1.593692362776880436e-02,
-1.506292095614137141e-02,
-1.419010125334228822e-02,
-1.331849089137860688e-02,
-1.244811615626108259e-02,
-1.157900324738007913e-02,
-1.071117827688339297e-02,
-9.844667269056943046e-03,
-8.979496159710283198e-03,
-8.115690795563606369e-03,
-7.253276933638790752e-03,
-6.392280240653525070e-03,
-5.532726292418784463e-03,
-4.674640573238895459e-03,
-3.818048475316177144e-03,
-2.962975298157581594e-03,
-2.109446247985370584e-03,
-1.257486437150360332e-03,
-4.071208835497625608e-04,
 4.416254899527989955e-04,
 1.288727856103917936e-03,
 2.134161483832644392e-03,
 2.977901738819858837e-03,
 3.819924084065656495e-03,
 4.660204080450173689e-03,
 5.498717387294599357e-03,
 6.335439762916334275e-03,
 7.170347065180650466e-03,
 8.003415252051096843e-03,
 8.834620382134322075e-03,
 9.663938615221290968e-03,
 1.049134621282744352e-02,
 1.131681953872633144e-02,
 1.214033505948173067e-02,
 1.296186934497535817e-02,
 1.378139906893190852e-02,
 1.459890100943853943e-02,
 1.541435204946387319e-02,
 1.622772917737084694e-02,
 1.703900948742618007e-02,
 1.784817018030847649e-02,
 1.865518856360981123e-02,
 1.946004205233562226e-02,
 2.026270816940014055e-02,
 2.106316454611901340e-02,
 2.186138892269620312e-02,
 2.265735914871047640e-02,
 2.345105318359553062e-02,
 2.424244909711654322e-02,
 2.503152506984553799e-02,
 2.581825939362976385e-02,
 2.660263047205869286e-02,
 2.738461682092602906e-02,
 2.816419706868916392e-02,
 2.894134995692274059e-02,
 2.971605434077162142e-02,
 3.048828918939719412e-02,
 3.125803358642074981e-02,
 3.202526673036449473e-02,
 3.278996793508710816e-02,
 3.355211663021503976e-02,
 3.431169236157279728e-02,
 3.506867479160614282e-02,
 3.582304369980302688e-02,
 3.657477898311160130e-02,
 3.732386065635161926e-02,
 3.807026885262537047e-02,
 3.881398382372207995e-02,
 3.955498594051913563e-02,
 4.029325569338068624e-02,
 4.102877369255063938e-02,
 4.176152066854230821e-02,
 4.249147747252515761e-02,
 4.321862507670611031e-02,
 4.394294457470727944e-02,
 4.466441718194132104e-02,
 4.538302423598088858e-02,
 4.609874719692400730e-02,
 4.681156764775806778e-02,
 4.752146729471744269e-02,
 4.822842796763708584e-02,
 4.893243162030429944e-02,
 4.963346033080404118e-02,
 5.033149630186199014e-02,
 5.102652186118265126e-02,
 5.171851946178442072e-02,
 5.240747168232848252e-02,
 5.309336122744753861e-02,
 5.377617092806637189e-02,
 5.445588374172065371e-02,
 5.513248275287205291e-02,
 5.580595117321775905e-02,
 5.647627234199695950e-02,
 5.714342972629322948e-02,
 5.780740692133330000e-02,
 5.846818765077928248e-02,
 5.912575576702142760e-02,
 5.978009525146244646e-02,
 6.043119021479914643e-02,
 6.107902489730181878e-02,
 6.172358366908740207e-02,
 6.236485103038832967e-02,
 6.300281161181928158e-02,
 6.363745017463873221e-02,
 6.426875161100566169e-02,
 6.489670094423362345e-02,
 6.552128332903969787e-02,
 6.614248405178961565e-02,
 6.676028853073934233e-02,
 6.737468231627116722e-02,
 6.798565109112746085e-02,
 6.859318067063896462e-02,
 6.919725700294883375e-02,
 6.979786616923443210e-02,
 7.039499438392284036e-02,
 7.098862799490290865e-02,
 7.157875348373402002e-02,
 7.216535746585003852e-02,
 7.274842669075808066e-02,
 7.332794804223585761e-02,
 7.390390853852199515e-02,
 7.447629533250424427e-02,
 7.504509571190193240e-02,
 7.561029709944663835e-02,
 7.617188705305501240e-02,
 7.672985326600156863e-02,
 7.728418356708499637e-02,
 7.783486592078980859e-02,
 7.838188842744558960e-02,
 7.892523932338159354e-02,
 7.946490698107566697e-02,
 8.000087990930167259e-02,
 8.053314675327025163e-02,
 8.106169629476690786e-02,
 8.158651745228566454e-02,
 8.210759928115832218e-02,
 8.262493097367956674e-02,
 8.313850185922837255e-02,
 8.364830140438496431e-02,
 8.415431921304285245e-02,
 8.465654502651848157e-02,
 8.515496872365528602e-02,
 8.564958032092395701e-02,
 8.614036997251864336e-02,
 8.662732797044912780e-02,
 8.711044474462915910e-02,
 8.758971086295898323e-02,
 8.806511703140673664e-02,
 8.853665409408212339e-02,
 8.900431303330950950e-02,
 8.946808496969338442e-02,
 8.992796116218310098e-02,
 9.038393300813062081e-02,
 9.083599204334591448e-02,
 9.128412994214787912e-02,
 9.172833851741038491e-02,
 9.216860972060436641e-02,
 9.260493564183765181e-02,
 9.303730850988797818e-02,
 9.346572069223295365e-02,
 9.389016469507693863e-02,
 9.431063316337252866e-02,
 9.472711888083733267e-02,
 9.513961476997029321e-02,
 9.554811389205820904e-02,
 9.595260944718277119e-02,
 9.635309477422218660e-02,
 9.674956335084826387e-02,
 9.714200879351844731e-02,
 9.753042485746703238e-02,
 9.791480543668885927e-02,
 9.829514456392052235e-02,
 9.867143641061781878e-02,
 9.904367528692763212e-02,
 9.941185564165799793e-02,
 9.977597206224188275e-02,
 1.001360192746983263e-01,
 1.004919921435895591e-01,
 1.008438856719724164e-01,
 1.011916950013485306e-01,
 1.015354154116073354e-01,
 1.018750423209683204e-01,
 1.022105712859157911e-01,
 1.025419980011329085e-01,
 1.028693182994293021e-01,
 1.031925281516662546e-01,
 1.035116236666767803e-01,
 1.038266010911824133e-01,
 1.041374568097056669e-01,
 1.044441873444791474e-01,
 1.047467893553492291e-01,
 1.050452596396778127e-01,
 1.053395951322381868e-01,
 1.056297929051085993e-01,
 1.059158501675602909e-01,
 1.061977642659436560e-01,
 1.064755326835677279e-01,
 1.067491530405779016e-01,
 1.070186230938299510e-01,
 1.072839407367579129e-01,
 1.075451039992403046e-01,
 1.078021110474614019e-01,
 1.080549601837691998e-01,
 1.083036498465280856e-01,
 1.085481786099699586e-01,
 1.087885451840396034e-01,
 1.090247484142371631e-01,
 1.092567872814559082e-01,
 1.094846609018174932e-01,
 1.097083685265021202e-01,
 1.099279095415756358e-01,
 1.101432834678127276e-01,
 1.103544899605155838e-01,
 1.105615288093303034e-01,
 1.107643999380577282e-01,
 1.109631034044619990e-01,
 1.111576394000742957e-01,
 1.113480082499938295e-01,
 1.115342104126838263e-01,
 1.117162464797655103e-01,
 1.118941171758056075e-01,
 1.120678233581040434e-01,
 1.122373660164741466e-01,
 1.124027462730216587e-01,
 1.125639653819188457e-01,
 1.127210247291753065e-01,
 1.128739258324051309e-01,
 1.130226703405906863e-01,
 1.131672600338419626e-01,
 1.133076968231531700e-01,
 1.134439827501550480e-01,
 1.135761199868644267e-01,
 1.137041108354286401e-01,
 1.138279577278690502e-01,
 1.139476632258167033e-01,
 1.140632300202501642e-01,
 1.141746609312234984e-01,
 1.142819589075965009e-01,
 1.143851270267569054e-01,
 1.144841684943423976e-01,
 1.145790866439563016e-01,
 1.146698849368823908e-01,
 1.147565669617940376e-01,
 1.148391364344608367e-01,
 1.149175971974534943e-01,
 1.149919532198401817e-01,
 1.150622085968862202e-01,
 1.151283675497450365e-01,
 1.151904344251484247e-01,
 1.152484136950913812e-01,
 1.153023099565165382e-01,
 1.153521279309927400e-01,
 1.153978724643902054e-01,
 1.154395485265540811e-01,
 1.154771612109735945e-01,
 1.155107157344481272e-01,
 1.155402174367492762e-01,
 1.155656717802802796e-01,
 1.155870843497332628e-01,
 1.156044608517408645e-01,
 1.156178071145261832e-01,
 1.156271290875492269e-01,
 1.156324328411498237e-01,
 1.156337245661875623e-01,
 1.156310105736796240e-01,
 1.156242972944318131e-01,
 1.156135912786717401e-01,
 1.155988991956739681e-01,
 1.155802278333856459e-01,
 1.155575840980460067e-01,
 1.155309750138054092e-01,
 1.155004077223396458e-01,
 1.154658894824609344e-01,
 1.154274276697283830e-01,
 1.153850297760513205e-01,
 1.153387034092934887e-01,
 1.152884562928717105e-01,
 1.152342962653528091e-01,
 1.151762312800465454e-01,
 1.151142694045968057e-01,
 1.150484188205689456e-01,
 1.149786878230339149e-01,
 1.149050848201512154e-01,
 1.148276183327461980e-01,
 1.147462969938865956e-01,
 1.146611295484560450e-01,
 1.145721248527229452e-01,
 1.144792918739091503e-01,
 1.143826396897532349e-01,
 1.142821774880731500e-01,
 1.141779145663237016e-01,
 1.140698603311543491e-01,
 1.139580242979606889e-01,
 1.138424160904357163e-01,
 1.137230454401182145e-01,
 1.135999221859367581e-01,
 1.134730562737523707e-01,
 1.133424577558981017e-01,
 1.132081367907163821e-01,
 1.130701036420929950e-01,
 1.129283686789885194e-01,
 1.127829423749675680e-01,
 1.126338353077252358e-01,
 1.124810581586112579e-01,
 1.123246217121506435e-01,
 1.121645368555623107e-01,
 1.120008145782764308e-01,
 1.118334659714461665e-01,
 1.116625022274604639e-01,
 1.114879346394518772e-01,
 1.113097746008028244e-01,
 1.111280336046494149e-01,
 1.109427232433825294e-01,
 1.107538552081471228e-01,
 1.105614412883377251e-01,
 1.103654933710936092e-01,
 1.101660234407898648e-01,
 1.099630435785269866e-01,
 1.097565659616171196e-01,
 1.095466028630702332e-01,
 1.093331666510749256e-01,
 1.091162697884799915e-01,
 1.088959248322710210e-01,
 1.086721444330465552e-01,
 1.084449413344920066e-01,
 1.082143283728496802e-01,
 1.079803184763889062e-01,
 1.077429246648720779e-01,
 1.075021600490196488e-01,
 1.072580378299725218e-01,
 1.070105712987531182e-01,
 1.067597738357224380e-01,
 1.065056589100376316e-01,
 1.062482400791050774e-01,
 1.059875309880336097e-01,
 1.057235453690833632e-01,
 1.054562970411151712e-01,
 1.051857999090357876e-01,
 1.049120679632426917e-01,
 1.046351152790657157e-01,
 1.043549560162079365e-01,
 1.040716044181830002e-01,
 1.037850748117533639e-01,
 1.034953816063630683e-01,
 1.032025392935715102e-01,
 1.029065624464844120e-01,
 1.026074657191820699e-01,
 1.023052638461480757e-01,
 1.019999716416930963e-01,
 1.016916039993806808e-01,
 1.013801758914470580e-01,
 1.010657023682232231e-01,
 1.007481985575529870e-01,
 1.004276796642093739e-01,
 1.001041609693105461e-01,
 9.977765782973362085e-02,
 9.944818567752557181e-02,
 9.911576001931479696e-02,
 9.878039643571960571e-02,
 9.844211058075447163e-02,
 9.810091818123778395e-02,
 9.775683503619382597e-02,
 9.740987701625695994e-02,
 9.706006006307223155e-02,
 9.670740018869518340e-02,
 9.635191347499004466e-02,
 9.599361607302604738e-02,
 9.563252420247460306e-02,
 9.526865415100128909e-02,
 9.490202227365962528e-02,
 9.453264499228233864e-02,
 9.416053879487110145e-02,
 9.378572023498490950e-02,
 9.340820593112907078e-02,
 9.302801256613879577e-02,
 9.264515688656607684e-02,
 9.225965570206304256e-02,
 9.187152588476360515e-02,
 9.148078436866510788e-02,
 9.108744814900887610e-02,
 9.069153428165842301e-02,
 9.029305988247791903e-02,
 8.989204212670820482e-02,
 8.948849824834312350e-02,
 8.908244553950339650e-02,
 8.867390134981041616e-02,
 8.826288308575909458e-02,
 8.784940821008821454e-02,
 8.743349424115216817e-02,
 8.701515875228980901e-02,
 8.659441937119286004e-02,
 8.617129377927386369e-02,
 8.574579971103250819e-02,
 8.531795495342238411e-02,
 8.488777734521436857e-02,
 8.445528477636236875e-02,
 8.402049518736558198e-02,
 8.358342656863104736e-02,
 8.314409695983582260e-02,
 8.270252444928742619e-02,
 8.225872717328426564e-02,
 8.181272331547521925e-02,
 8.136453110621788554e-02,
 8.091416882193715188e-02,
 8.046165478448212560e-02,
 8.000700736048345363e-02,
 7.955024496070883799e-02,
 7.909138603941888446e-02,
 7.863044909372222946e-02,
 7.816745266292945971e-02,
 7.770241532790697625e-02,
 7.723535571043102510e-02,
 7.676629247253963229e-02,
 7.629524431588495526e-02,
 7.582222998108610612e-02,
 7.534726824707928261e-02,
 7.487037793046977252e-02,
 7.439157788488190426e-02,
 7.391088700030996883e-02,
 7.342832420246665770e-02,
 7.294390845213463703e-02,
 7.245765874451400024e-02,
 7.196959410857182993e-02,
 7.147973360639094109e-02,
 7.098809633251808304e-02,
 7.049470141331172501e-02,
 6.999956800629074383e-02,
 6.950271529948102989e-02,
 6.900416251076395280e-02,
 6.850392888722357798e-02,
 6.800203370449309226e-02,
 6.749849626610290865e-02,
 6.699333590282730011e-02,
 6.648657197203076963e-02,
 6.597822385701584968e-02,
 6.546831096636943070e-02,
 6.495685273330933929e-02,
 6.444386861503183239e-02,
 6.392937809205777311e-02,
 6.341340066757955585e-02,
 6.289595586680890582e-02,
 6.237706323632246502e-02,
 6.185674234341029948e-02,
 6.133501277542201258e-02,
 6.081189413911518293e-02,
 6.028740606000180385e-02,
 5.976156818169715834e-02,
 5.923440016526682755e-02,
 5.870592168857491355e-02,
 5.817615244563349719e-02,
 5.764511214594966737e-02,
 5.711282051387563813e-02,
 5.657929728795784569e-02,
 5.604456222028585122e-02,
 5.550863507584274936e-02,
 5.497153563185583347e-02,
 5.443328367714608124e-02,
 5.389389901147991629e-02,
 5.335340144492110165e-02,
 5.281181079718162003e-02,
 5.226914689697428895e-02,
 5.172542958136654156e-02,
 5.118067869513240331e-02,
 5.063491409010693195e-02,
 5.008815562454091430e-02,
 4.954042316245493849e-02,
 4.899173657299552703e-02,
 4.844211572979159608e-02,
 4.789158051030967950e-02,
 4.734015079521310815e-02,
 4.678784646771852462e-02,
 4.623468741295520129e-02,
 4.568069351732450406e-02,
 4.512588466785955044e-02,
 4.457028075158589453e-02,
 4.401390165488382883e-02,
 4.345676726284972841e-02,
 4.289889745865927556e-02,
 4.234031212293234980e-02,
 4.178103113309632882e-02,
 4.122107436275198461e-02,
 4.066046168104092695e-02,
 4.009921295201131913e-02,
 3.953734803398728515e-02,
 3.897488677893685971e-02,
 3.841184903184327593e-02,
 3.784825463007453900e-02,
 3.728412340275675391e-02,
 3.671947517014593348e-02,
 3.615432974300223506e-02,
 3.558870692196561963e-02,
 3.502262649693039381e-02,
 3.445610824642367231e-02,
 3.388917193698297303e-02,
 3.332183732253514441e-02,
 3.275412414377701364e-02,
 3.218605212755724920e-02,
 3.161764098625815395e-02,
 3.104891041717990074e-02,
 3.047988010192603792e-02,
 2.991056970578846036e-02,
 2.934099887713631158e-02,
 2.877118724680330711e-02,
 2.820115442747860371e-02,
 2.763092001309731816e-02,
 2.706050357823376606e-02,
 2.648992467749444052e-02,
 2.591920284491351298e-02,
 2.534835759334986768e-02,
 2.477740841388362605e-02,
 2.420637477521704953e-02,
 2.363527612307361747e-02,
 2.306413187960070638e-02,
 2.249296144277369153e-02,
 2.192178418579965316e-02,
 2.135061945652438550e-02,
 2.077948657684075551e-02,
 2.020840484209705801e-02,
 1.963739352050834427e-02,
 1.906647185256950261e-02,
 1.849565905046804404e-02,
 1.792497429750028112e-02,
 1.735443674748887027e-02,
 1.678406552420035058e-02,
 1.621387972076678008e-02,
 1.564389839910706320e-02,
 1.507414058935030270e-02,
 1.450462528926140665e-02,
 1.393537146366859852e-02,
 1.336639804389102432e-02,
 1.279772392716960021e-02,
 1.222936797609982737e-02,
 1.166134901806436391e-02,
 1.109368584466934385e-02,
 1.052639721118220177e-02,
 9.959501835969834099e-03,
 9.393018399940177704e-03,
 8.826965545985472963e-03,
 8.261361878425896310e-03,
 7.696225962456655287e-03,
 7.131576323596798377e-03,
 6.567431447138396931e-03,
 6.003809777599971101e-03,
 5.440729718179292129e-03,
 4.878209630210759117e-03,
 4.316267832621930103e-03,
 3.754922601394939871e-03,
 3.194192169027075100e-03,
 2.634094723995269137e-03,
 2.074648410222489341e-03,
 1.515871326544439724e-03,
 9.577815261809084118e-04,
 4.003970162065617904e-04,
-1.562642429744725257e-04,
-7.121843381519621981e-04,
-1.267345403832345185e-03,
-1.821729622757877181e-03,
-2.375319226423679153e-03,
-2.928096495594133264e-03,
-3.480043760815640895e-03,
-4.031143402927247175e-03,
-4.581377853570486186e-03,
-5.130729595695702507e-03,
-5.679181164066179205e-03,
-6.226715145760802587e-03,
-6.773314180674660893e-03,
-7.318960962015670473e-03,
-7.863638236801374568e-03,
-8.407328806351688916e-03,
-8.950015526779514508e-03,
-9.491681309480425738e-03,
-1.003230912161858293e-02,
-1.057188198661029345e-02,
-1.111038298460692575e-02,
-1.164779525297362367e-02,
-1.218410198676608130e-02,
-1.271928643920606540e-02,
-1.325333192215328790e-02,
-1.378622180657479435e-02,
-1.431793952301350752e-02,
-1.484846856205270481e-02,
-1.537779247477824920e-02,
-1.590589487323990775e-02,
-1.643275943090778679e-02,
-1.695836988312885568e-02,
-1.748271002757850745e-02,
-1.800576372471216630e-02,
-1.852751489821160419e-02,
-1.904794753543158359e-02,
-1.956704568784189968e-02,
-2.008479347146733748e-02,
-2.060117506732618217e-02,
-2.111617472186435099e-02,
-2.162977674738865083e-02,
-2.214196552249662192e-02,
-2.265272549250304732e-02,
-2.316204116986610509e-02,
-2.366989713460843081e-02,
-2.417627803473664308e-02,
-2.468116858665893310e-02,
-2.518455357559880661e-02,
-2.568641785600618913e-02,
-2.618674635196735143e-02,
-2.668552405761034571e-02,
-2.718273603750876247e-02,
-2.767836742708236139e-02,
-2.817240343299569696e-02,
-2.866482933355291723e-02,
-2.915563047909090072e-02,
-2.964479229236912164e-02,
-3.013230026895627814e-02,
-3.061813997761563683e-02,
-3.110229706068614111e-02,
-3.158475723446103195e-02,
-3.206550628956489346e-02,
-3.254453009132615704e-02,
-3.302181458014773890e-02,
-3.349734577187515883e-02,
-3.397110975816115819e-02,
-3.444309270682747309e-02,
-3.491328086222460214e-02,
-3.538166054558810475e-02,
-3.584821815539138146e-02,
-3.631294016769773259e-02,
-3.677581313650651190e-02,
-3.723682369409982845e-02,
-3.769595855138266338e-02,
-3.815320449822387494e-02,
-3.860854840379085440e-02,
-3.906197721688409868e-02,
-3.951347796626701603e-02,
-3.996303776099318500e-02,
-4.041064379073169149e-02,
-4.085628332608786523e-02,
-4.129994371892273253e-02,
-4.174161240266845846e-02,
-4.218127689264063868e-02,
-4.261892478634904391e-02,
-4.305454376380369458e-02,
-4.348812158781886761e-02,
-4.391964610431411259e-02,
-4.434910524261240217e-02,
-4.477648701573413992e-02,
-4.520177952068980820e-02,
-4.562497093876844573e-02,
-4.604604953582377980e-02,
-4.646500366255647968e-02,
-4.688182175479485569e-02,
-4.729649233377042350e-02,
-4.770900400639280226e-02,
-4.811934546551954739e-02,
-4.852750549022394333e-02,
-4.893347294605966680e-02,
-4.933723678532259127e-02,
-4.973878604730814362e-02,
-5.013810985856800850e-02,
-5.053519743316140650e-02,
-5.093003807290445717e-02,
-5.132262116761681509e-02,
-5.171293619536403846e-02,
-5.210097272269752916e-02,
-5.248672040489194002e-02,
-5.287016898617811350e-02,
-5.325130829997406362e-02,
-5.363012826911270348e-02,
-5.400661890606531235e-02,
-5.438077031316390642e-02,
-5.475257268281816941e-02,
-5.512201629773157141e-02,
-5.548909153111245690e-02,
-5.585378884688277368e-02,
-5.621609879988397757e-02,
-5.657601203607912771e-02,
-5.693351929275265733e-02,
-5.728861139870543989e-02,
-5.764127927444902960e-02,
-5.799151393239466296e-02,
-5.833930647704012318e-02,
-5.868464810515328089e-02,
-5.902753010595210292e-02,
-5.936794386128207979e-02,
-5.970588084579041277e-02,
-6.004133262709646784e-02,
-6.037429086595917649e-02,
-6.070474731644233402e-02,
-6.103269382607497129e-02,
-6.135812233601007498e-02,
-6.168102488117883919e-02,
-6.200139359044339049e-02,
-6.231922068674428800e-02,
-6.263449848724655933e-02,
-6.294721940348170508e-02,
-6.325737594148625464e-02,
-6.356496070193826120e-02,
-6.386996638028936968e-02,
-6.417238576689431040e-02,
-6.447221174713720082e-02,
-6.476943730155461376e-02,
-6.506405550595520393e-02,
-6.535605953153604541e-02,
-6.564544264499701243e-02,
-6.593219820864985870e-02,
-6.621631968052585360e-02,
-6.649780061447972679e-02,
-6.677663466028946337e-02,
-6.705281556375505825e-02,
-6.732633716679145564e-02,
-6.759719340752012862e-02,
-6.786537832035696716e-02,
-6.813088603609683547e-02,
-6.839371078199486809e-02,
-6.865384688184511530e-02,
-6.891128875605452564e-02,
-6.916603092171628997e-02,
-6.941806799267744021e-02,
-6.966739467960426924e-02,
-6.991400579004571070e-02,
-7.015789622849051554e-02,
-7.039906099642520565e-02,
-7.063749519238513019e-02,
-7.087319401200507796e-02,
-7.110615274806442176e-02,
-7.133636679053179108e-02,
-7.156383162660372166e-02,
-7.178854284074179248e-02,
-7.201049611470679290e-02,
-7.222968722758806026e-02,
-7.244611205583206814e-02,
-7.265976657326482513e-02,
-7.287064685111470375e-02,
-7.307874905802826115e-02,
-7.328406946008640677e-02,
-7.348660442081482447e-02,
-7.368635040119259072e-02,
-7.388330395965721220e-02,
-7.407746175210652706e-02,
-7.426882053189751143e-02,
-7.445737714984203282e-02,
-7.464312855419916182e-02,
-7.482607179066477765e-02,
-7.500620400235745444e-02,
-7.518352242980172462e-02,
-7.535802441090819204e-02,
-7.552970738095023118e-02,
-7.569856887253761935e-02,
-7.586460651558714352e-02,
-7.602781803729012633e-02,
-7.618820126207685728e-02,
-7.634575411157773495e-02,
-7.650047460458174464e-02,
-7.665236085699106416e-02,
-7.680141108177293563e-02,
-7.694762358890945564e-02,
-7.709099678534202249e-02,
-7.723152917491574176e-02,
-7.736921935831750363e-02,
-7.750406603301283892e-02,
-7.763606799318044371e-02,
-7.776522412964197162e-02,
-7.789153342978868966e-02,
-7.801499497750735701e-02,
-7.813560795310030282e-02,
-7.825337163320410239e-02,
-7.836828539070507527e-02,
-7.848034869465121688e-02,
-7.858956111016091040e-02,
-7.869592229833052843e-02,
-7.879943201613610892e-02,
-7.890009011633403180e-02,
-7.899789654735855926e-02,
-7.909285135321561522e-02,
-7.918495467337399729e-02,
-7.927420674265373002e-02,
-7.936060789111153146e-02,
-7.944415854392208876e-02,
-7.952485922125902829e-02,
-7.960271053816962705e-02,
-7.967771320444942684e-02,
-7.974986802451212997e-02,
-7.981917589725705253e-02,
-7.988563781593471802e-02,
-7.994925486800705250e-02,
-8.001002823500755201e-02,
-8.006795919239662052e-02,
-8.012304910941422942e-02,
-8.017529944893107829e-02,
-8.022471176729469022e-02,
-8.027128771417457731e-02,
-8.031502903240339553e-02,
-8.035593755781576808e-02,
-8.039401521908397241e-02,
-8.042926403755103204e-02,
-8.046168612706085244e-02,
-8.049128369378535930e-02,
-8.051805903604918047e-02,
-8.054201454415137185e-02,
-8.056315270018434005e-02,
-8.058147607784947597e-02,
-8.059698734227134509e-02,
-8.060968924980749239e-02,
-8.061958464785648482e-02,
-8.062667647466324750e-02,
-8.063096775912062530e-02,
-8.063246162056990352e-02,
-8.063116126859672106e-02,
-8.062707000282591518e-02,
-8.062019121271238320e-02,
-8.061052837732993193e-02,
-8.059808506515787896e-02,
-8.058286493386304650e-02,
-8.056487173008190783e-02,
-8.054410928919755741e-02,
-8.052058153511557070e-02,
-8.049429248003638071e-02,
-8.046524622422575324e-02,
-8.043344695578176495e-02,
-8.039889895039974144e-02,
-8.036160657113503025e-02,
-8.032157426816183277e-02,
-8.027880657853071755e-02,
-8.023330812592333050e-02,
-8.018508362040356607e-02,
-8.013413785816747570e-02,
-8.008047572129053937e-02,
-8.002410217747082943e-02,
-7.996502227977152211e-02,
-7.990324116636024487e-02,
-7.983876406024549566e-02,
-7.977159626901146605e-02,
-7.970174318454900653e-02,
-7.962921028278552305e-02,
-7.955400312341211200e-02,
-7.947612734960739223e-02,
-7.939558868776043499e-02,
-7.931239294718864241e-02,
-7.922654601985744394e-02,
-7.913805388009254038e-02,
-7.904692258429427132e-02,
-7.895315827064632030e-02,
-7.885676715882442012e-02,
-7.875775554970082526e-02,
-7.865612982504785466e-02,
-7.855189644723831188e-02,
-7.844506195894383749e-02,
-7.833563298283097165e-02,
-7.822361622125473257e-02,
-7.810901845595029369e-02,
-7.799184654772250980e-02,
-7.787210743613204311e-02,
-7.774980813918051792e-02,
-7.762495575299306616e-02,
-7.749755745149848607e-02,
-7.736762048610719422e-02,
-7.723515218538730409e-02,
-7.710015995473767925e-02,
-7.696265127606051470e-02,
-7.682263370742957453e-02,
-7.668011488275798537e-02,
-7.653510251146330989e-02,
-7.638760437813052473e-02,
-7.623762834217213957e-02,
-7.608518233748813586e-02,
-7.593027437212182540e-02,
-7.577291252791458487e-02,
-7.561310496015874461e-02,
-7.545085989724746589e-02,
-7.528618564032441007e-02,
-7.511909056292874476e-02,
-7.494958311064056633e-02,
-7.477767180072351916e-02,
-7.460336522176438945e-02,
-7.442667203331282400e-02,
-7.424760096551691335e-02,
-7.406616081875874724e-02,
-7.388236046328676421e-02,
-7.369620883884638041e-02,
-7.350771495430935554e-02,
-7.331688788730084116e-02,
-7.312373678382456943e-02,
-7.292827085788614050e-02,
-7.273049939111450590e-02,
-7.253043173238218899e-02,
-7.232807729742261882e-02,
-7.212344556844652033e-02,
-7.191654609375608409e-02,
-7.170738848735802584e-02,
-7.149598242857389818e-02,
-7.128233766164919494e-02,
-7.106646399536135916e-02,
-7.084837130262473803e-02,
-7.062806952009438588e-02,
-7.040556864776979784e-02,
-7.018087874859349484e-02,
-6.995400994805141270e-02,
-6.972497243377005771e-02,
-6.949377645511187196e-02,
-6.926043232276914152e-02,
-6.902495040835739115e-02,
-6.878734114400550381e-02,
-6.854761502194529899e-02,
-6.830578259409987585e-02,
-6.806185447166897273e-02,
-6.781584132471454862e-02,
-6.756775388174379726e-02,
-6.731760292929084288e-02,
-6.706539931149697875e-02,
-6.681115392968989264e-02,
-6.655487774196078288e-02,
-6.629658176274041970e-02,
-6.603627706237351347e-02,
-6.577397476669244458e-02,
-6.550968605658825938e-02,
-6.524342216758195756e-02,
-6.497519438939264314e-02,
-6.470501406550616119e-02,
-6.443289259274068148e-02,
-6.415884142081215713e-02,
-6.388287205189886742e-02,
-6.360499604020235231e-02,
-6.332522499150991524e-02,
-6.304357056275446125e-02,
-6.276004446157291972e-02,
-6.247465844586397310e-02,
-6.218742432334468245e-02,
-6.189835395110540595e-02,
-6.160745923516382921e-02,
-6.131475213001792018e-02,
-6.102024463819785693e-02,
-6.072394880981624166e-02,
-6.042587674211781501e-02,
-6.012604057902817128e-02,
-5.982445251070026004e-02,
-5.952112477306180371e-02,
-5.921606964735958573e-02,
-5.890929945970377335e-02,
-5.860082658061234462e-02,
-5.829066342455116456e-02,
-5.797882244947703823e-02,
-5.766531615637713465e-02,
-5.735015708880845942e-02,
-5.703335783243624474e-02,
-5.671493101457135422e-02,
-5.639488930370698677e-02,
-5.607324540905390259e-02,
-5.575001208007627357e-02,
-5.542520210602428637e-02,
-5.509882831546800835e-02,
-5.477090357582996283e-02,
-5.444144079291571986e-02,
-5.411045291044555561e-02,
-5.377795290958351654e-02,
-5.344395380846742732e-02,
-5.310846866173626890e-02,
-5.277151056005919411e-02,
-5.243309262966099754e-02,
-5.209322803185014589e-02,
-5.175192996254258937e-02,
-5.140921165178801572e-02,
-5.106508636329365469e-02,
-5.071956739394813812e-02,
-5.037266807334418034e-02,
-5.002440176330155003e-02,
-4.967478185738846697e-02,
-4.932382178044337345e-02,
-4.897153498809565797e-02,
-4.861793496628525474e-02,
-4.826303523078317309e-02,
-4.790684932671046559e-02,
-4.754939082805644673e-02,
-4.719067333719809132e-02,
-4.683071048441636575e-02,
-4.646951592741498105e-02,
-4.610710335083630096e-02,
-4.574348646577875571e-02,
-4.537867900931220194e-02,
-4.501269474399419851e-02,
-4.464554745738560232e-02,
-4.427725096156497758e-02,
-4.390781909264397653e-02,
-4.353726571028161685e-02,
-4.316560469719835091e-02,
-4.279284995868991304e-02,
-4.241901542214145809e-02,
-4.204411503654013893e-02,
-4.166816277198868990e-02,
-4.129117261921873283e-02,
-4.091315858910295200e-02,
-4.053413471216760905e-02,
-4.015411503810565469e-02,
-3.977311363528829996e-02,
-3.939114459027746179e-02,
-3.900822200733783385e-02,
-3.862436000794840923e-02,
-3.823957273031457216e-02,
-3.785387432888023124e-02,
-3.746727897383874545e-02,
-3.707980085064529335e-02,
-3.669145415952819456e-02,
-3.630225311500043239e-02,
-3.591221194537174560e-02,
-3.552134489225985958e-02,
-3.512966621010248786e-02,
-3.473719016566926415e-02,
-3.434393103757314714e-02,
-3.394990311578257453e-02,
-3.355512070113409601e-02,
-3.315959810484352122e-02,
-3.276334964801892735e-02,
-3.236638966117337535e-02,
-3.196873248373656440e-02,
-3.157039246356881795e-02,
-3.117138395647334193e-02,
-3.077172132570999558e-02,
-3.037141894150807361e-02,
-2.997049118058095832e-02,
-2.956895242563938736e-02,
-2.916681706490596715e-02,
-2.876409949163010252e-02,
-2.836081410360228802e-02,
-2.795697530266948866e-02,
-2.755259749425129426e-02,
-2.714769508685485611e-02,
-2.674228249159179074e-02,
-2.633637412169491376e-02,
-2.592998439203500136e-02,
-2.552312771863811044e-02,
-2.511581851820446007e-02,
-2.470807120762553641e-02,
-2.429990020350381030e-02,
-2.389131992167181293e-02,
-2.348234477671209269e-02,
-2.307298918147697095e-02,
-2.266326754661033421e-02,
-2.225319428006821559e-02,
-2.184278378664095133e-02,
-2.143205046747626366e-02,
-2.102100871960134801e-02,
-2.060967293544775300e-02,
-2.019805750237453623e-02,
-1.978617680219405678e-02,
-1.937404521069751098e-02,
-1.896167709718065905e-02,
-1.854908682397107475e-02,
-1.813628874595625898e-02,
-1.772329721011116355e-02,
-1.731012655502743927e-02,
-1.689679111044398857e-02,
-1.648330519677641826e-02,
-1.606968312464891746e-02,
-1.565593919442648599e-02,
-1.524208769574730837e-02,
-1.482814290705705175e-02,
-1.441411909514261729e-02,
-1.400003051466842605e-02,
-1.358589140771156861e-02,
-1.317171600329985516e-02,
-1.275751851694901899e-02,
-1.234331315020175540e-02,
-1.192911409016795751e-02,
-1.151493550906453230e-02,
-1.110079156375751858e-02,
-1.068669639530485729e-02,
-1.027266412849928666e-02,
-9.858708871413103883e-03,
-9.444844714944151606e-03,
-9.031085732361488622e-03,
-8.617445978853281036e-03,
-8.203939491075741205e-03,
-7.790580286701910551e-03,
-7.377382363973220523e-03,
-6.964359701250321527e-03,
-6.551526256566859996e-03,
-6.138895967182455768e-03,
-5.726482749138683132e-03,
-5.314300496814470740e-03,
-4.902363082483721102e-03,
-4.490684355874207702e-03,
-4.079278143726318591e-03,
-3.668158249354945468e-03,
-3.257338452210606448e-03,
-2.846832507443070731e-03,
-2.436654145466198886e-03,
-2.026817071522901085e-03,
-1.617334965252489052e-03,
-1.208221480259231680e-03,
-7.994902436811283670e-04,
-3.911548557610529516e-04,
 1.677111058077926023e-05,
 4.242741101741629079e-04,
 8.313406260238004721e-04,
 1.237957169732863214e-03,
 1.644110281926440586e-03,
 2.049786532671881486e-03,
 2.454972521898892736e-03,
 2.859654879818813826e-03,
 3.263820267340243435e-03,
 3.667455376485580579e-03,
 4.070546930804781749e-03,
 4.473081685789086388e-03,
 4.875046429280869599e-03,
 5.276427981884174861e-03,
 5.677213197373867648e-03,
 6.077388963101055044e-03,
 6.476942200399119463e-03,
 6.875859864988406213e-03,
 7.274128947377056509e-03,
 7.671736473262571673e-03,
 8.068669503931742357e-03,
 8.464915136656972136e-03,
 8.860460505093223013e-03,
 9.255292779672637249e-03,
 9.649399167997339474e-03,
 1.004276691523033928e-02,
 1.043538330448613369e-02,
 1.082723565721786969e-02,
 1.121831133360458831e-02,
 1.160859773293578846e-02,
 1.199808229399418856e-02,
 1.238675249543743848e-02,
 1.277459585617868321e-02,
 1.316159993576333093e-02,
 1.354775233474598758e-02,
 1.393304069506600892e-02,
 1.431745270041902274e-02,
 1.470097607662862807e-02,
 1.508359859201690960e-02,
 1.546530805777043306e-02,
 1.584609232830710285e-02,
 1.622593930164089454e-02,
 1.660483691974278669e-02,
 1.698277316890229802e-02,
 1.735973608008629585e-02,
 1.773571372929534651e-02,
 1.811069423791929200e-02,
 1.848466577309051603e-02,
 1.885761654803489243e-02,
 1.922953482242151582e-02,
 1.960040890271130473e-02,
 1.997022714250126091e-02,
 2.033897794286903746e-02,
 2.070664975271587979e-02,
 2.107323106910502855e-02,
 2.143871043760092049e-02,
 2.180307645260595728e-02,
 2.216631775769328794e-02,
 2.252842304594031286e-02,
 2.288938106025933256e-02,
 2.324918059372480666e-02,
 2.360781048990075875e-02,
 2.396525964316528756e-02,
 2.432151699903265657e-02,
 2.467657155447372519e-02,
 2.503041235823523503e-02,
 2.538302851115518607e-02,
 2.573440916647813659e-02,
 2.608454353016740820e-02,
 2.643342086121521634e-02,
 2.678103047195084033e-02,
 2.712736172834807891e-02,
 2.747240405032783800e-02,
 2.781614691206098916e-02,
 2.815857984226893818e-02,
 2.849969242452052992e-02,
 2.883947429752827668e-02,
 2.917791515544300093e-02,
 2.951500474814375274e-02,
 2.985073288152844187e-02,
 3.018508941780147226e-02,
 3.051806427575786199e-02,
 3.084964743106703364e-02,
 3.117982891655382907e-02,
 3.150859882247699501e-02,
 3.183594729680571528e-02,
 3.216186454549446044e-02,
 3.248634083275445811e-02,
 3.280936648132455613e-02,
 3.313093187273905005e-02,
 3.345102744759234636e-02,
 3.376964370580342462e-02,
 3.408677120687665651e-02,
 3.440240057016114711e-02,
 3.471652247510688405e-02,
 3.502912766151942275e-02,
 3.534020692981312828e-02,
 3.564975114125976813e-02,
 3.595775121823711895e-02,
 3.626419814447476991e-02,
 3.656908296529646357e-02,
 3.687239678786174979e-02,
 3.717413078140495430e-02,
 3.747427617747067785e-02,
 3.777282427014849731e-02,
 3.806976641630491903e-02,
 3.836509403581284117e-02,
 3.865879861177835830e-02,
 3.895087169076628941e-02,
 3.924130488302231268e-02,
 3.953008986269310882e-02,
 3.981721836804547054e-02,
 4.010268220168012460e-02,
 4.038647323074603945e-02,
 4.066858338715204774e-02,
 4.094900466777352810e-02,
 4.122772913466016265e-02,
 4.150474891523963511e-02,
 4.178005620251827590e-02,
 4.205364325528090919e-02,
 4.232550239828787586e-02,
 4.259562602246853152e-02,
 4.286400658511372447e-02,
 4.313063661006582422e-02,
 4.339550868790523208e-02,
 4.365861547613541366e-02,
 4.391994969936587057e-02,
 4.417950414949153165e-02,
 4.443727168587049969e-02,
 4.469324523549987604e-02,
 4.494741779318756764e-02,
 4.519978242172353888e-02,
 4.545033225204764271e-02,
 4.569906048341459970e-02,
 4.594596038355773515e-02,
 4.619102528884996839e-02,
 4.643424860446098562e-02,
 4.667562380451385079e-02,
 4.691514443223870207e-02,
 4.715280410012290258e-02,
 4.738859649005978947e-02,
 4.762251535349541764e-02,
 4.785455451157124424e-02,
 4.808470785526570285e-02,
 4.831296934553317574e-02,
 4.853933301343992673e-02,
 4.876379296029758476e-02,
 4.898634335779545462e-02,
 4.920697844812826210e-02,
 4.942569254412320506e-02,
 4.964248002936416659e-02,
 4.985733535831241015e-02,
 5.007025305642578278e-02,
 5.028122772027596166e-02,
 5.049025401766154414e-02,
 5.069732668771988887e-02,
 5.090244054103713195e-02,
 5.110559045975310299e-02,
 5.130677139766675471e-02,
 5.150597838033766501e-02,
 5.170320650518459016e-02,
 5.189845094158274802e-02,
 5.209170693095781929e-02,
 5.228296978687782537e-02,
 5.247223489514173111e-02,
 5.265949771386699285e-02,
 5.284475377357324144e-02,
 5.302799867726451510e-02,
 5.320922810050816160e-02,
 5.338843779151170033e-02,
 5.356562357119716566e-02,
 5.374078133327277879e-02,
 5.391390704430269742e-02,
 5.408499674377323374e-02,
 5.425404654415744155e-02,
 5.442105263097726797e-02,
 5.458601126286231203e-02,
 5.474891877160698028e-02,
 5.490977156222513061e-02,
 5.506856611300162130e-02,
 5.522529897554126488e-02,
 5.537996677481685920e-02,
 5.553256620921263181e-02,
 5.568309405056650480e-02,
 5.583154714420941050e-02,
 5.597792240900273386e-02,
 5.612221683737193823e-02,
 5.626442749533908799e-02,
 5.640455152255246379e-02,
 5.654258613231323560e-02,
 5.667852861160008887e-02,
 5.681237632109142205e-02,
 5.694412669518481712e-02,
 5.707377724201420643e-02,
 5.720132554346434028e-02,
 5.732676925518302019e-02,
 5.745010610659129213e-02,
 5.757133390088959440e-02,
 5.769045051506336425e-02,
 5.780745389988525829e-02,
 5.792234207991459743e-02,
 5.803511315349475091e-02,
 5.814576529274893130e-02,
 5.825429674357097964e-02,
 5.836070582561687925e-02,
 5.846499093229173827e-02,
 5.856715053073460048e-02,
 5.866718316180138948e-02,
 5.876508744004534796e-02,
 5.886086205369428503e-02,
 5.895450576462613057e-02,
 5.904601740834193591e-02,
 5.913539589393613377e-02,
 5.922264020406479285e-02,
 5.930774939491100656e-02,
 5.939072259614806143e-02,
 5.947155901090028784e-02,
 5.955025791570162791e-02,
 5.962681866045101142e-02,
 5.970124066836630244e-02,
 5.977352343593546335e-02,
 5.984366653286506826e-02,
 5.991166960202637393e-02,
 5.997753235939982247e-02,
 6.004125459401647019e-02,
 6.010283616789632161e-02,
 6.016227701598628880e-02,
 6.021957714609379314e-02,
 6.027473663881898619e-02,
 6.032775564748447950e-02,
 6.037863439806250010e-02,
 6.042737318909979088e-02,
 6.047397239164051252e-02,
 6.051843244914587028e-02,
 6.056075387741225585e-02,
 6.060093726448704393e-02,
 6.063898327058152987e-02,
 6.067489262798180655e-02,
 6.070866614095681013e-02,
 6.074030468566572749e-02,
 6.076980921006056718e-02,
 6.079718073378870963e-02,
 6.082242034809136333e-02,
 6.084552921570155620e-02,
 6.086650857073751947e-02,
 6.088535971859639073e-02,
 6.090208403584315006e-02,
 6.091668297009911887e-02,
 6.092915803992764168e-02,
 6.093951083471679103e-02,
 6.094774301456059445e-02,
 6.095385631013817973e-02,
 6.095785252258952014e-02,
 6.095973352339040252e-02,
 6.095950125422446020e-02,
 6.095715772685216666e-02,
 6.095270502297909371e-02,
 6.094614529412142878e-02,
 6.093748076146855014e-02,
 6.092671371574377714e-02,
 6.091384651706437114e-02,
 6.089888159479672769e-02,
 6.088182144741112467e-02,
 6.086266864233412510e-02,
 6.084142581579844722e-02,
 6.081809567269076677e-02,
 6.079268098639753481e-02,
 6.076518459864802685e-02,
 6.073560941935628871e-02,
 6.070395842646030687e-02,
 6.067023466575852120e-02,
 6.063444125074543556e-02,
 6.059658136244441134e-02,
 6.055665824923797680e-02,
 6.051467522669694288e-02,
 6.047063567740684764e-02,
 6.042454305079233978e-02,
 6.037640086293942498e-02,
 6.032621269641617184e-02,
 6.027398220009076019e-02,
 6.021971308894749630e-02,
 6.016340914390131550e-02,
 6.010507421160960623e-02,
 6.004471220428249378e-02,
 5.998232709949078562e-02,
 5.991792293997202229e-02,
 5.985150383343446068e-02,
 5.978307395235912813e-02,
 5.971263753380014888e-02,
 5.964019887918215607e-02,
 5.956576235409705850e-02,
 5.948933238809774732e-02,
 5.941091347449023452e-02,
 5.933051017012427875e-02,
 5.924812709518093717e-02,
 5.916376893295986761e-02,
 5.907744042966268233e-02,
 5.898914639417618400e-02,
 5.889889169785273576e-02,
 5.880668127428869546e-02,
 5.871252011910215590e-02,
 5.861641328970636222e-02,
 5.851836590508399660e-02,
 5.841838314555813233e-02,
 5.831647025256120331e-02,
 5.821263252840275237e-02,
 5.810687533603505622e-02,
 5.799920409881725858e-02,
 5.788962430027688733e-02,
 5.777814148387054594e-02,
 5.766476125274203751e-02,
 5.754948926947907328e-02,
 5.743233125586839904e-02,
 5.731329299264863175e-02,
 5.719238031926159038e-02,
 5.706959913360234310e-02,
 5.694495539176641641e-02,
 5.681845510779613001e-02,
 5.669010435342562715e-02,
 5.655990925782287959e-02,
 5.642787600733064485e-02,
 5.629401084520669479e-02,
 5.615832007136059567e-02,
 5.602081004208959297e-02,
 5.588148716981398284e-02,
 5.574035792280878504e-02,
 5.559742882493519389e-02,
 5.545270645536990589e-02,
 5.530619744833302487e-02,
 5.515790849281448222e-02,
 5.500784633229773013e-02,
 5.485601776448425365e-02,
 5.470242964101335731e-02,
 5.454708886718351996e-02,
 5.439000240166987077e-02,
 5.423117725624113789e-02,
 5.407062049547496640e-02,
 5.390833923647164044e-02,
 5.374434064856668802e-02,
 5.357863195304077980e-02,
 5.341122042282967636e-02,
 5.324211338223209383e-02,
 5.307131820661516175e-02,
 5.289884232212019310e-02,
 5.272469320536576215e-02,
 5.254887838314915849e-02,
 5.237140543214788974e-02,
 5.219228197861830454e-02,
 5.201151569809316089e-02,
 5.182911431507822991e-02,
 5.164508560274734539e-02,
 5.145943738263589889e-02,
 5.127217752433306519e-02,
 5.108331394517288265e-02,
 5.089285460992350185e-02,
 5.070080753047587901e-02,
 5.050718076553058211e-02,
 5.031198242028282752e-02,
 5.011522064610827998e-02,
 4.991690364024480020e-02,
 4.971703964547460192e-02,
 4.951563694980555541e-02,
 4.931270388614966693e-02,
 4.910824883200155810e-02,
 4.890228020911547430e-02,
 4.869480648318098848e-02,
 4.848583616349690789e-02,
 4.827537780264567341e-02,
 4.806343999616458085e-02,
 4.785003138221756436e-02,
 4.763516064126436383e-02,
 4.741883649572962989e-02,
 4.720106770967028714e-02,
 4.698186308844284204e-02,
 4.676123147836757504e-02,
 4.653918176639375986e-02,
 4.631572287976245400e-02,
 4.609086378566933789e-02,
 4.586461349092482709e-02,
 4.563698104161497543e-02,
 4.540797552276072679e-02,
 4.517760605797500190e-02,
 4.494588180912080511e-02,
 4.471281197596696511e-02,
 4.447840579584280002e-02,
 4.424267254329306009e-02,
 4.400562152973085811e-02,
 4.376726210308929527e-02,
 4.352760364747376015e-02,
 4.328665558281200032e-02,
 4.304442736450318774e-02,
 4.280092848306752545e-02,
 4.255616846379326607e-02,
 4.231015686638363998e-02,
 4.206290328460323552e-02,
 4.181441734592326182e-02,
 4.156470871116545174e-02,
 4.131378707414628398e-02,
 4.106166216131934554e-02,
 4.080834373141728477e-02,
 4.055384157509318854e-02,
 4.029816551456149448e-02,
 4.004132540323636358e-02,
 3.978333112537235650e-02,
 3.952419259570155718e-02,
 3.926391975907111975e-02,
 3.900252259008071126e-02,
 3.874001109271837245e-02,
 3.847639529999571234e-02,
 3.821168527358311667e-02,
 3.794589110344370742e-02,
 3.767902290746692751e-02,
 3.741109083110142480e-02,
 3.714210504698767235e-02,
 3.687207575458907594e-02,
 3.660101317982328295e-02,
 3.632892757469322748e-02,
 3.605582921691673215e-02,
 3.578172840955531897e-02,
 3.550663548064450503e-02,
 3.523056078282122555e-02,
 3.495351469295160385e-02,
 3.467550761175898499e-02,
 3.439654996345063720e-02,
 3.411665219534355808e-02,
 3.383582477749137035e-02,
 3.355407820230967703e-02,
 3.327142298420013994e-02,
 3.298786965917676478e-02,
 3.270342878448915386e-02,
 3.241811093824626538e-02,
 3.213192671904098463e-02,
 3.184488674557200971e-02,
 3.155700165626729864e-02,
 3.126828210890678778e-02,
 3.097873878024409722e-02,
 3.068838236562784413e-02,
 3.039722357862456592e-02,
 3.010527315063872555e-02,
 2.981254183053381676e-02,
 2.951904038425356633e-02,
 2.922477959444228293e-02,
 2.892977026006430391e-02,
 2.863402319602474308e-02,
 2.833754923278945792e-02,
 2.804035921600333756e-02,
 2.774246400611119281e-02,
 2.744387447797607196e-02,
 2.714460152049846114e-02,
 2.684465603623512747e-02,
 2.654404894101841661e-02,
 2.624279116357395789e-02,
 2.594089364514005208e-02,
 2.563836733908565410e-02,
 2.533522321052872339e-02,
 2.503147223595478602e-02,
 2.472712540283522956e-02,
 2.442219370924449476e-02,
 2.411668816347972699e-02,
 2.381061978367808585e-02,
 2.350399959743439127e-02,
 2.319683864142038643e-02,
 2.288914796100240470e-02,
 2.258093860985876597e-02,
 2.227222164959932402e-02,
 2.196300814938328960e-02,
 2.165330918553663025e-02,
 2.134313584117212420e-02,
 2.103249920580676363e-02,
 2.072141037498076085e-02,
 2.040988044987618669e-02,
 2.009792053693617089e-02,
 1.978554174748349895e-02,
 1.947275519734028779e-02,
 1.915957200644721053e-02,
 1.884600329848249572e-02,
 1.853206020048260572e-02,
 1.821775384246182572e-02,
 1.790309535703187363e-02,
 1.758809587902336255e-02,
 1.727276654510595533e-02,
 1.695711849340873420e-02,
 1.664116286314245435e-02,
 1.632491079422064909e-02,
 1.600837342688059273e-02,
 1.569156190130669565e-02,
 1.537448735725228249e-02,
 1.505716093366207993e-02,
 1.473959376829560471e-02,
 1.442179699735095418e-02,
 1.410378175508775721e-02,
 1.378555917345238545e-02,
 1.346714038170172129e-02,
 1.314853650602847319e-02,
 1.282975866918687098e-02,
 1.251081799011815807e-02,
 1.219172558357715756e-02,
 1.187249255975839773e-02,
 1.155313002392431912e-02,
 1.123364907603253797e-02,
 1.091406081036339765e-02,
 1.059437631514981160e-02,
 1.027460667220603252e-02,
 9.954762956556636663e-03,
 9.634856236068070276e-03,
 9.314897571078967903e-03,
 8.994898014030819344e-03,
 8.674868609101299421e-03,
 8.354820391836078122e-03,
 8.034764388781564029e-03,
 7.714711617119713802e-03,
 7.394673084301857206e-03,
 7.074659787683494454e-03,
 6.754682714160666068e-03,
 6.434752839805614986e-03,
 6.114881129504146084e-03,
 5.795078536593415049e-03,
 5.475356002500293175e-03,
 5.155724456379775535e-03,
 4.836194814755938320e-03,
 4.516777981161897854e-03,
 4.197484845780509455e-03,
 3.878326285087576025e-03,
 3.559313161494014922e-03,
 3.240456322988873126e-03,
 2.921766602784826514e-03,
 2.603254818962751505e-03,
 2.284931774117096841e-03,
 1.966808255003778955e-03,
 1.648895032187144708e-03,
 1.331202859688308468e-03,
 1.013742474634615233e-03,
 6.965245969101002471e-04,
 3.795599288058420953e-04,
 6.285915467254162275e-05,
-2.535670594268588400e-04,
-5.697080660641302280e-04,
-8.855532367899752923e-04,
-1.201091962479042697e-03,
-1.516313653674007103e-03,
-1.831207740926959170e-03,
-2.145763675141579112e-03,
-2.459970927914333604e-03,
-2.773818991872943965e-03,
-3.087297381015633238e-03,
-3.400395631049311831e-03,
-3.713103299725090383e-03,
-4.025409967174431447e-03,
-4.337305236244289389e-03,
-4.648778732829520269e-03,
-4.959820106206004262e-03,
-5.270419029362214194e-03,
-5.580565199328917959e-03,
-5.890248337509066540e-03,
-6.199458190005678430e-03,
-6.508184527948632919e-03,
-6.816417147820781619e-03,
-7.124145871783336623e-03,
-7.431360547998411108e-03,
-7.738051050952144544e-03,
-8.044207281776545940e-03,
-8.349819168568684696e-03,
-8.654876666710175498e-03,
-8.959369759185552978e-03,
-9.263288456897925474e-03,
-9.566622798984828271e-03,
-9.869362853133048161e-03,
-1.017149871589054233e-02,
-1.047302051297883431e-02,
-1.077391839960360233e-02,
-1.107418256076376888e-02,
-1.137380321155924238e-02,
-1.167277059749829461e-02,
-1.197107499480240533e-02,
-1.226870671071055713e-02,
-1.256565608378274086e-02,
-1.286191348420051561e-02,
-1.315746931406783747e-02,
-1.345231400770978067e-02,
-1.374643803197069143e-02,
-1.403983188650943272e-02,
-1.433248610409477292e-02,
-1.462439125089949783e-02,
-1.491553792679147297e-02,
-1.520591676562495914e-02,
-1.549551843553028871e-02,
-1.578433363920156429e-02,
-1.607235311418258802e-02,
-1.635956763315388196e-02,
-1.664596800421410186e-02,
-1.693154507116420224e-02,
-1.721628971378745890e-02,
-1.750019284812929024e-02,
-1.778324542677434811e-02,
-1.806543843912499642e-02,
-1.834676291167382581e-02,
-1.862720990827931161e-02,
-1.890677053043694072e-02,
-1.918543591755002969e-02,
-1.946319724719821134e-02,
-1.974004573540671589e-02,
-2.001597263691005241e-02,
-2.029096924541853170e-02,
-2.056502689388045590e-02,
-2.083813695474322214e-02,
-2.111029084021400978e-02,
-2.138148000251775122e-02,
-2.165169593415407212e-02,
-2.192093016815180317e-02,
-2.218917427832410930e-02,
-2.245641987951886576e-02,
-2.272265862787032145e-02,
-2.298788222104748355e-02,
-2.325208239850166600e-02,
-2.351525094171103003e-02,
-2.377737967442692529e-02,
-2.403846046291355926e-02,
-2.429848521619067461e-02,
-2.455744588627195232e-02,
-2.481533446840275201e-02,
-2.507214300129514961e-02,
-2.532786356736328390e-02,
-2.558248829295506344e-02,
-2.583600934858316586e-02,
-2.608841894915431975e-02,
-2.633970935419615439e-02,
-2.658987286808375122e-02,
-2.683890184026338499e-02,
-2.708678866547472447e-02,
-2.733352578397119440e-02,
-2.757910568174019514e-02,
-2.782352089071823964e-02,
-2.806676398900820671e-02,
-2.830882760109225404e-02,
-2.854970439804405125e-02,
-2.878938709773831012e-02,
-2.902786846506084234e-02,
-2.926514131211338521e-02,
-2.950119849841987760e-02,
-2.973603293112926996e-02,
-2.996963756521692571e-02,
-3.020200540368389586e-02,
-3.043312949775546852e-02,
-3.066300294707679022e-02,
-3.089161889990713755e-02,
-3.111897055331265191e-02,
-3.134505115335641662e-02,
-3.156985399528784708e-02,
-3.179337242372963501e-02,
-3.201559983286290240e-02,
-3.223652966661002400e-02,
-3.245615541881754357e-02,
-3.267447063343414948e-02,
-3.289146890469003132e-02,
-3.310714387727202446e-02,
-3.332148924649831756e-02,
-3.353449875849000283e-02,
-3.374616621034268876e-02,
-3.395648545029412296e-02,
-3.416545037789159300e-02,
-3.437305494415599655e-02,
-3.457929315174609886e-02,
-3.478415905511812733e-02,
-3.498764676068633062e-02,
-3.518975042697974898e-02,
-3.539046426479728474e-02,
-3.558978253736214820e-02,
-3.578769956047301443e-02,
-3.598420970265375080e-02,
-3.617930738530115292e-02,
-3.637298708283200066e-02,
-3.656524332282515277e-02,
-3.675607068616555673e-02,
-3.694546380718333189e-02,
-3.713341737379273477e-02,
-3.731992612762760619e-02,
-3.750498486417733895e-02,
-3.768858843291756494e-02,
-3.787073173744227861e-02,
-3.805140973559151957e-02,
-3.823061743957868047e-02,
-3.840834991611457444e-02,
-3.858460228653117635e-02,
-3.875936972690165877e-02,
-3.893264746815981031e-02,
-3.910443079621696294e-02,
-3.927471505207656699e-02,
-3.944349563194798902e-02,
-3.961076798735697901e-02,
-3.977652762525509672e-02,
-3.994077010812675799e-02,
-4.010349105409504594e-02,
-4.026468613702371968e-02,
-4.042435108661964621e-02,
-4.058248168853173521e-02,
-4.073907378444820149e-02,
-4.089412327219155846e-02,
-4.104762610581318139e-02,
-4.119957829568306196e-02,
-4.134997590858076333e-02,
-4.149881506778189261e-02,
-4.164609195314414314e-02,
-4.179180280119016572e-02,
-4.193594390518966958e-02,
-4.207851161523871314e-02,
-4.221950233833710736e-02,
-4.235891253846401500e-02,
-4.249673873665161389e-02,
-4.263297751105663697e-02,
-4.276762549702978894e-02,
-4.290067938718337970e-02,
-4.303213593145702176e-02,
-4.316199193718126687e-02,
-4.329024426913872375e-02,
-4.341688984962442655e-02,
-4.354192565850283775e-02,
-4.366534873326371330e-02,
-4.378715616907559449e-02,
-4.390734511883770397e-02,
-4.402591279322923268e-02,
-4.414285646075716274e-02,
-4.425817344780190454e-02,
-4.437186113866109505e-02,
-4.448391697559060665e-02,
-4.459433845884520214e-02,
-4.470312314671527620e-02,
-4.481026865556295841e-02,
-4.491577265985596812e-02,
-4.501963289219865910e-02,
-4.512184714336230779e-02,
-4.522241326231255659e-02,
-4.532132915623512254e-02,
-4.541859279055930620e-02,
-4.551420218898043907e-02,
-4.560815543347856993e-02,
-4.570045066433676972e-02,
-4.579108608015700077e-02,
-4.588005993787376557e-02,
-4.596737055276535477e-02,
-4.605301629846447059e-02,
-4.613699560696565838e-02,
-4.621930696863099652e-02,
-4.629994893219394059e-02,
-4.637892010476165477e-02,
-4.645621915181401274e-02,
-4.653184479720262612e-02,
-4.660579582314586244e-02,
-4.667807107022313440e-02,
-4.674866943736685765e-02,
-4.681758988185266007e-02,
-4.688483141928711379e-02,
-4.695039312359397532e-02,
-4.701427412699839964e-02,
-4.707647362000887126e-02,
-4.713699085139760880e-02,
-4.719582512817859649e-02,
-4.725297581558410981e-02,
-4.730844233703894453e-02,
-4.736222417413284147e-02,
-4.741432086659043421e-02,
-4.746473201224087057e-02,
-4.751345726698293082e-02,
-4.756049634475089521e-02,
-4.760584901747635239e-02,
-4.764951511504921661e-02,
-4.769149452527685767e-02,
-4.773178719384044838e-02,
-4.777039312425021556e-02,
-4.780731237779797804e-02,
-4.784254507350924057e-02,
-4.787609138809141573e-02,
-4.790795155588148391e-02,
-4.793812586879121762e-02,
-4.796661467625110836e-02,
-4.799341838515095576e-02,
-4.801853745978074128e-02,
-4.804197242176705407e-02,
-4.806372385001020375e-02,
-4.808379238061719074e-02,
-4.810217870683440589e-02,
-4.811888357897738111e-02,
-4.813390780435974903e-02,
-4.814725224721889962e-02,
-4.815891782864113041e-02,
-4.816890552648405571e-02,
-4.817721637529769063e-02,
-4.818385146624309251e-02,
-4.818881194700976034e-02,
-4.819209902173104271e-02,
-4.819371395089716570e-02,
-4.819365805126699792e-02,
-4.819193269577821959e-02,
-4.818853931345431357e-02,
-4.818347938931162588e-02,
-4.817675446426313013e-02,
-4.816836613502095688e-02,
-4.815831605399711890e-02,
-4.814660592920209925e-02,
-4.813323752414238460e-02,
-4.811821265771498018e-02,
-4.810153320410152228e-02,
-4.808320109265933756e-02,
-4.806321830781184329e-02,
-4.804158688893610946e-02,
-4.801830893024960911e-02,
-4.799338658069447067e-02,
-4.796682204382023140e-02,
-4.793861757766496728e-02,
-4.790877549463466722e-02,
-4.787729816138016486e-02,
-4.784418799867379973e-02,
-4.780944748128269223e-02,
-4.777307913784129001e-02,
-4.773508555072199927e-02,
-4.769546935590419923e-02,
-4.765423324284077944e-02,
-4.761137995432414977e-02,
-4.756691228634986335e-02,
-4.752083308797826894e-02,
-4.747314526119529587e-02,
-4.742385176077097697e-02,
-4.737295559411616036e-02,
-4.732045982113838173e-02,
-4.726636755409471119e-02,
-4.721068195744436424e-02,
-4.715340624769884942e-02,
-4.709454369327053386e-02,
-4.703409761431960601e-02,
-4.697207138259974074e-02,
-4.690846842130179384e-02,
-4.684329220489558826e-02,
-4.677654625897107593e-02,
-4.670823416007649498e-02,
-4.663835953555664493e-02,
-4.656692606338756757e-02,
-4.649393747201126942e-02,
-4.641939754016849440e-02,
-4.634331009672902624e-02,
-4.626567902052154679e-02,
-4.618650824016166251e-02,
-4.610580173387752306e-02,
-4.602356352933524575e-02,
-4.593979770346184183e-02,
-4.585450838226686615e-02,
-4.576769974066238061e-02,
-4.567937600228236250e-02,
-4.558954143929872665e-02,
-4.549820037223782643e-02,
-4.540535716979402642e-02,
-4.531101624864267846e-02,
-4.521518207325108535e-02,
-4.511785915568827798e-02,
-4.501905205543316885e-02,
-4.491876537918113726e-02,
-4.481700378065004570e-02,
-4.471377196038264779e-02,
-4.460907466555085604e-02,
-4.450291668975525639e-02,
-4.439530287282546922e-02,
-4.428623810061761701e-02,
-4.417572730481238857e-02,
-4.406377546270856538e-02,
-4.395038759701863640e-02,
-4.383556877566043702e-02,
-4.371932411154887815e-02,
-4.360165876238526056e-02,
-4.348257793044650599e-02,
-4.336208686237141147e-02,
-4.324019084894727138e-02,
-4.311689522489405013e-02,
-4.299220536864727799e-02,
-4.286612670214035026e-02,
-4.273866469058475170e-02,
-4.260982484224946909e-02,
-4.247961270823868291e-02,
-4.234803388226898030e-02,
-4.221509400044389654e-02,
-4.208079874102885198e-02,
-4.194515382422375066e-02,
-4.180816501193435064e-02,
-4.166983810754284340e-02,
-4.153017895567748252e-02,
-4.138919344197949934e-02,
-4.124688749287076101e-02,
-4.110326707531898605e-02,
-4.095833819660176650e-02,
-4.081210690407020836e-02,
-4.066457928491069851e-02,
-4.051576146590552679e-02,
-4.036565961319268925e-02,
-4.021427993202473378e-02,
-4.006162866652517029e-02,
-3.990771209944581760e-02,
-3.975253655192109020e-02,
-3.959610838322231291e-02,
-3.943843399051047416e-02,
-3.927951980858845893e-02,
-3.911937230965078366e-02,
-3.895799800303442056e-02,
-3.879540343496618721e-02,
-3.863159518831146833e-02,
-3.846657988231934333e-02,
-3.830036417236910157e-02,
-3.813295474971411386e-02,
-3.796435834122510733e-02,
-3.779458170913279486e-02,
-3.762363165076928334e-02,
-3.745151499830794151e-02,
-3.727823861850332321e-02,
-3.710380941242927971e-02,
-3.692823431521626704e-02,
-3.675152029578850760e-02,
-3.657367435659860527e-02,
-3.639470353336279884e-02,
-3.621461489479418927e-02,
-3.603341554233650823e-02,
-3.585111260989409798e-02,
-3.566771326356503458e-02,
-3.548322470136976159e-02,
-3.529765415298060510e-02,
-3.511100887945043519e-02,
-3.492329617294022415e-02,
-3.473452335644471728e-02,
-3.454469778351952625e-02,
-3.435382683800535658e-02,
-3.416191793375215197e-02,
-3.396897851434274584e-02,
-3.377501605281544445e-02,
-3.358003805138540937e-02,
-3.338405204116585978e-02,
-3.318706558188833783e-02,
-3.298908626162218305e-02,
-3.279012169649338226e-02,
-3.259017953040219823e-02,
-3.238926743474049991e-02,
-3.218739310810864174e-02,
-3.198456427603126040e-02,
-3.178078869067160750e-02,
-3.157607413054729084e-02,
-3.137042840024306667e-02,
-3.116385933012424947e-02,
-3.095637477604932727e-02,
-3.074798261908187960e-02,
-3.053869076520074333e-02,
-3.032850714501227757e-02,
-3.011743971345876361e-02,
-2.990549644952865752e-02,
-2.969268535596459799e-02,
-2.947901445897259387e-02,
-2.926449180792852628e-02,
-2.904912547508570198e-02,
-2.883292355528170245e-02,
-2.861589416564302643e-02,
-2.839804544529225122e-02,
-2.817938555505131171e-02,
-2.795992267714690269e-02,
-2.773966501491360176e-02,
-2.751862079249831755e-02,
-2.729679825456143502e-02,
-2.707420566598130532e-02,
-2.685085131155455843e-02,
-2.662674349569844195e-02,
-2.640189054215152931e-02,
-2.617630079367494825e-02,
-2.594998261175176721e-02,
-2.572294437628747446e-02,
-2.549519448530907645e-02,
-2.526674135466419960e-02,
-2.503759341772020253e-02,
-2.480775912506162639e-02,
-2.457724694418877281e-02,
-2.434606535921502238e-02,
-2.411422287056476377e-02,
-2.388172799466880408e-02,
-2.364858926366300573e-02,
-2.341481522508297164e-02,
-2.318041444156099598e-02,
-2.294539549052141553e-02,
-2.270976696387663404e-02,
-2.247353746772122116e-02,
-2.223671562202844676e-02,
-2.199931006034350905e-02,
-2.176132942947965263e-02,
-2.152278238921035911e-02,
-2.128367761196581220e-02,
-2.104402378252490449e-02,
-2.080382959770994342e-02,
-2.056310376607967810e-02,
-2.032185500762339128e-02,
-2.008009205345307607e-02,
-1.983782364549729893e-02,
-1.959505853619383786e-02,
-1.935180548818230331e-02,
-1.910807327399761946e-02,
-1.886387067576157997e-02,
-1.861920648487594074e-02,
-1.837408950171459318e-02,
-1.812852853531673331e-02,
-1.788253240307727948e-02,
-1.763610993044150560e-02,
-1.738926995059542069e-02,
-1.714202130415855285e-02,
-1.689437283887624056e-02,
-1.664633340931207656e-02,
-1.639791187653862406e-02,
-1.614911710783160231e-02,
-1.589995797636059929e-02,
-1.565044336088179319e-02,
-1.540058214543002166e-02,
-1.515038321901172359e-02,
-1.489985547529647236e-02,
-1.464900781230964177e-02,
-1.439784913212591513e-02,
-1.414638834055993201e-02,
-1.389463434686135160e-02,
-1.364259606340595746e-02,
-1.339028240538946146e-02,
-1.313770229052024785e-02,
-1.288486463871350851e-02,
-1.263177837178292191e-02,
-1.237845241313639301e-02,
-1.212489568746820921e-02,
-1.187111712045369090e-02,
-1.161712563844312894e-02,
-1.136293016815685328e-02,
-1.110853963637818166e-02,
-1.085396296965038948e-02,
-1.059920909397008178e-02,
-1.034428693448308408e-02,
-1.008920541518053791e-02,
-9.833973458593743902e-03,
-9.578599985490971955e-03,
-9.323093914573563762e-03,
-9.067464162173310277e-03,
-8.811719641947927950e-03,
-8.555869264580420741e-03,
-8.299921937475201669e-03,
-8.043886564456753999e-03,
-7.787772045467711290e-03,
-7.531587276268427583e-03,
-7.275341148134297636e-03,
-7.019042547557440004e-03,
-6.762700355944790964e-03,
-6.506323449319266310e-03,
-6.249920698019990721e-03,
-5.993500966404121354e-03,
-5.737073112547368646e-03,
-5.480645987946627419e-03,
-5.224228437222215062e-03,
-4.967829297820585029e-03,
-4.711457399718278066e-03,
-4.455121565124857755e-03,
-4.198830608187782872e-03,
-3.942593334696933675e-03,
-3.686418541790675157e-03,
-3.430315017659999518e-03,
-3.174291541257058796e-03,
-2.918356882000325194e-03,
-2.662519799482811027e-03,
-2.406789043179776919e-03,
-2.151173352158020774e-03,
-1.895681454783338347e-03,
-1.640322068432381337e-03,
-1.385103899201141223e-03,
-1.130035641617361608e-03,
-8.751259783502362546e-04,
-6.203835799247027277e-04,
-3.658171044325204090e-04,
-1.114351972464500416e-04,
 1.427535092659879619e-04,
 3.967403960271835128e-04,
 6.505168575349715978e-04,
 9.040743021459496896e-04,
 1.157404152358894713e-03,
 1.410497845097456997e-03,
 1.663346831991413272e-03,
 1.915942579658723487e-03,
 2.168276569985339974e-03,
 2.420340300405178155e-03,
 2.672125284178331929e-03,
 2.923623050670949835e-03,
 3.174825145630515068e-03,
 3.425723131464205283e-03,
 3.676308587514073942e-03,
 3.926573110332396040e-03,
 4.176508313955305980e-03,
 4.426105830177932965e-03,
 4.675357308825033031e-03,
 4.924254418024512012e-03,
 5.172788844477903616e-03,
 5.420952293730155365e-03,
 5.668736490439921054e-03,
 5.916133178647458440e-03,
 6.163134122042608458e-03,
 6.409731104230886184e-03,
 6.655915929000998620e-03,
 6.901680420587838309e-03,
 7.147016423938205680e-03,
 7.391915804973368115e-03,
 7.636370450851612084e-03,
 7.880372270228933052e-03,
 8.123913193521218115e-03,
 8.366985173161568812e-03,
 8.609580183860635408e-03,
 8.851690222863483476e-03,
 9.093307310206582769e-03,
 9.334423488972936472e-03,
 9.575030825547659746e-03,
 9.815121409871190375e-03,
 1.005468735569220277e-02,
 1.029372080081947596e-02,
 1.053221390737212222e-02,
 1.077015886203006555e-02,
 1.100754787628239854e-02,
 1.124437318667508533e-02,
 1.148062705505716388e-02,
 1.171630176882771171e-02,
 1.195138964117840527e-02,
 1.218588301133870927e-02,
 1.241977424481747853e-02,
 1.265305573364454254e-02,
 1.288571989661032278e-02,
 1.311775917950654298e-02,
 1.334916605536229026e-02,
 1.357993302468250840e-02,
 1.381005261568314831e-02,
 1.403951738452622819e-02,
 1.426831991555274973e-02,
 1.449645282151618662e-02,
 1.472390874381300507e-02,
 1.495068035271317035e-02,
 1.517676034758918061e-02,
 1.540214145714347872e-02,
 1.562681643963588496e-02,
 1.585077808310851599e-02,
 1.607401920561048539e-02,
 1.629653265542033505e-02,
 1.651831131126934443e-02,
 1.673934808256050122e-02,
 1.695963590958959877e-02,
 1.717916776376256921e-02,
 1.739793664781313573e-02,
 1.761593559601792869e-02,
 1.783315767441211175e-02,
 1.804959598100195489e-02,
 1.826524364597752886e-02,
 1.848009383192267263e-02,
 1.869413973402626536e-02,
 1.890737458028849544e-02,
 1.911979163172956853e-02,
 1.933138418259487679e-02,
 1.954214556055955745e-02,
 1.975206912693131325e-02,
 1.996114827685321891e-02,
 2.016937643950366885e-02,
 2.037674707829554774e-02,
 2.058325369107523797e-02,
 2.078888981031776911e-02,
 2.099364900332346962e-02,
 2.119752487241136421e-02,
 2.140051105511208904e-02,
 2.160260122435852387e-02,
 2.180378908867731946e-02,
 2.200406839237566484e-02,
 2.220343291572988986e-02,
 2.240187647517083089e-02,
 2.259939292346849898e-02,
 2.279597614991486082e-02,
 2.299162008050662301e-02,
 2.318631867812414107e-02,
 2.338006594271169886e-02,
 2.357285591145470358e-02,
 2.376468265895527107e-02,
 2.395554029740802962e-02,
 2.414542297677284982e-02,
 2.433432488494709570e-02,
 2.452224024793563800e-02,
 2.470916333002115550e-02,
 2.489508843393019658e-02,
 2.508000990100086453e-02,
 2.526392211134685650e-02,
 2.544681948402115201e-02,
 2.562869647717732485e-02,
 2.580954758823139628e-02,
 2.598936735401911197e-02,
 2.616815035095467271e-02,
 2.634589119518640846e-02,
 2.652258454275164753e-02,
 2.669822508972909819e-02,
 2.687280757239155632e-02,
 2.704632676735546984e-02,
 2.721877749172962879e-02,
 2.739015460326264806e-02,
 2.756045300048807351e-02,
 2.772966762286941528e-02,
 2.789779345094221472e-02,
 2.806482550645560473e-02,
 2.823075885251150746e-02,
 2.839558859370369323e-02,
 2.855930987625323464e-02,
 2.872191788814460259e-02,
 2.888340785925901447e-02,
 2.904377506150637375e-02,
 2.920301480895552346e-02,
 2.936112245796436426e-02,
 2.951809340730592035e-02,
 2.967392309829521707e-02,
 2.982860701491337960e-02,
 2.998214068393063175e-02,
 3.013451967502715073e-02,
 3.028573960091325915e-02,
 3.043579611744749377e-02,
 3.058468492375314429e-02,
 3.073240176233360543e-02,
 3.087894241918508892e-02,
 3.102430272390957477e-02,
 3.116847854982460891e-02,
 3.131146581407209806e-02,
 3.145326047772543931e-02,
 3.159385854589585874e-02,
 3.173325606783530123e-02,
 3.187144913703984089e-02,
 3.200843389135021866e-02,
 3.214420651305129051e-02,
 3.227876322896932465e-02,
 3.241210031056863256e-02,
 3.254421407404577138e-02,
 3.267510088042289290e-02,
 3.280475713563807405e-02,
 3.293317929063656335e-02,
 3.306036384145739221e-02,
 3.318630732932101313e-02,
 3.331100634071352401e-02,
 3.343445750747046225e-02,
 3.355665750685804527e-02,
 3.367760306165377970e-02,
 3.379729094022449615e-02,
 3.391571795660333621e-02,
 3.403288097056535177e-02,
 3.414877688770053682e-02,
 3.426340265948638747e-02,
 3.437675528335786684e-02,
 3.448883180277667604e-02,
 3.459962930729763853e-02,
 3.470914493263538292e-02,
 3.481737586072709834e-02,
 3.492431931979551180e-02,
 3.502997258440931211e-02,
 3.513433297554234558e-02,
 3.523739786063057738e-02,
 3.533916465362867132e-02,
 3.543963081506344009e-02,
 3.553879385208651154e-02,
 3.563665131852564172e-02,
 3.573320081493307210e-02,
 3.582843998863430995e-02,
 3.592236653377334915e-02,
 3.601497819135713457e-02,
 3.610627274929843755e-02,
 3.619624804245726718e-02,
 3.628490195267933260e-02,
 3.637223240883519920e-02,
 3.645823738685539939e-02,
 3.654291490976566137e-02,
 3.662626304771939012e-02,
 3.670827991802962098e-02,
 3.678896368519790627e-02,
 3.686831256094273701e-02,
 3.694632480422611887e-02,
 3.702299872127819136e-02,
 3.709833266561997356e-02,
 3.717232503808562405e-02,
 3.724497428684171718e-02,
 3.731627890740588788e-02,
 3.738623744266306864e-02,
 3.745484848288076901e-02,
 3.752211066572234965e-02,
 3.758802267625870747e-02,
 3.765258324697849657e-02,
 3.771579115779633701e-02,
 3.777764523606016306e-02,
 3.783814435655578901e-02,
 3.789728744151123208e-02,
 3.795507346059798920e-02,
 3.801150143093195294e-02,
 3.806657041707171840e-02,
 3.812027953101626565e-02,
 3.817262793219978328e-02,
 3.822361482748581896e-02,
 3.827323947116003516e-02,
 3.832150116491998132e-02,
 3.836839925786485889e-02,
 3.841393314648246932e-02,
 3.845810227463543340e-02,
 3.850090613354515551e-02,
 3.854234426177444162e-02,
 3.858241624520869495e-02,
 3.862112171703494662e-02,
 3.865846035772015771e-02,
 3.869443189498693314e-02,
 3.872903610378839595e-02,
 3.876227280628136845e-02,
 3.879414187179720114e-02,
 3.882464321681215053e-02,
 3.885377680491545332e-02,
 3.888154264677603361e-02,
 3.890794080010710754e-02,
 3.893297136963060068e-02,
 3.895663450703810982e-02,
 3.897893041095178840e-02,
 3.899985932688297685e-02,
 3.901942154718916755e-02,
 3.903761741103010247e-02,
 3.905444730432132416e-02,
 3.906991165968676238e-02,
 3.908401095641005074e-02,
 3.909674572038326912e-02,
 3.910811652405543626e-02,
 3.911812398637815741e-02,
 3.912676877275057807e-02,
 3.913405159496266550e-02,
 3.913997321113658889e-02,
 3.914453442566696861e-02,
 3.914773608915943226e-02,
 3.914957909836734584e-02,
 3.915006439612759431e-02,
 3.914919297129441228e-02,
 3.914696585867177836e-02,
 3.914338413894432461e-02,
 3.913844893860665003e-02,
 3.913216142989146829e-02,
 3.912452283069554199e-02,
 3.911553440450481894e-02,
 3.910519746031777127e-02,
 3.909351335256698590e-02,
 3.908048348103985298e-02,
 3.906610929079719352e-02,
 3.905039227209091551e-02,
 3.903333396027936636e-02,
 3.901493593574209551e-02,
 3.899519982379302113e-02,
 3.897412729459116126e-02,
 3.895172006305153839e-02,
 3.892797988875280196e-02,
 3.890290857584489254e-02,
 3.887650797295454097e-02,
 3.884877997308908842e-02,
 3.881972651353962633e-02,
 3.878934957578208942e-02,
 3.875765118537688458e-02,
 3.872463341186761082e-02,
 3.869029836867765582e-02,
 3.865464821300632070e-02,
 3.861768514572199579e-02,
 3.857941141125584977e-02,
 3.853982929749250746e-02,
 3.849894113565995035e-02,
 3.845674930021829308e-02,
 3.841325620874662394e-02,
 3.836846432182876299e-02,
 3.832237614293747263e-02,
 3.827499421831773163e-02,
 3.822632113686743466e-02,
 3.817635953001870253e-02,
 3.812511207161575072e-02,
 3.807258147779273710e-02,
 3.801877050684965981e-02,
 3.796368195912738080e-02,
 3.790731867688070661e-02,
 3.784968354415032404e-02,
 3.779077948663394498e-02,
 3.773060947155543188e-02,
 3.766917650753256325e-02,
 3.760648364444421632e-02,
 3.754253397329565534e-02,
 3.747733062608224475e-02,
 3.741087677565298891e-02,
 3.734317563557109504e-02,
 3.727423045997497325e-02,
 3.720404454343683581e-02,
 3.713262122082020000e-02,
 3.705996386713648200e-02,
 3.698607589740000867e-02,
 3.691096076648173185e-02,
 3.683462196896204743e-02,
 3.675706303898171323e-02,
 3.667828755009259339e-02,
 3.659829911510561334e-02,
 3.651710138593901311e-02,
 3.643469805346447737e-02,
 3.635109284735237728e-02,
 3.626628953591548576e-02,
 3.618029192595203364e-02,
 3.609310386258689218e-02,
 3.600472922911215207e-02,
 3.591517194682605774e-02,
 3.582443597487114384e-02,
 3.573252531007095611e-02,
 3.563944398676543307e-02,
 3.554519607664550357e-02,
 3.544978568858653256e-02,
 3.535321696848028883e-02,
 3.525549409906547638e-02,
 3.515662129975866135e-02,
 3.505660282648188214e-02,
 3.495544297149060647e-02,
 3.485314606320048109e-02,
 3.474971646601232589e-02,
 3.464515858013641342e-02,
 3.453947684141583929e-02,
 3.443267572114830366e-02,
 3.432475972590728203e-02,
 3.421573339736153768e-02,
 3.410560131209468965e-02,
 3.399436808142207445e-02,
 3.388203835120793400e-02,
 3.376861680168111168e-02,
 3.365410814724927729e-02,
 3.353851713631293696e-02,
 3.342184855107770830e-02,
 3.330410720736565189e-02,
 3.318529795442622110e-02,
 3.306542567474547722e-02,
 3.294449528385426373e-02,
 3.282251173013660955e-02,
 3.269947999463518329e-02,
 3.257540509085745523e-02,
 3.245029206458004134e-02,
 3.232414599365244362e-02,
 3.219697198779936792e-02,
 3.206877518842285446e-02,
 3.193956076840260422e-02,
 3.180933393189597919e-02,
 3.167809991413680221e-02,
 3.154586398123367108e-02,
 3.141263142996627428e-02,
 3.127840758758216461e-02,
 3.114319781159198899e-02,
 3.100700748956309108e-02,
 3.086984203891421363e-02,
 3.073170690670692581e-02,
 3.059260756943811901e-02,
 3.045254953283036900e-02,
 3.031153833162273867e-02,
 3.016957952935862136e-02,
 3.002667871817562770e-02,
 2.988284151859190926e-02,
 2.973807357929347459e-02,
 2.959238057691976689e-02,
 2.944576821584931822e-02,
 2.929824222798289510e-02,
 2.914980837252825405e-02,
 2.900047243578204176e-02,
 2.885024023091202483e-02,
 2.869911759773830298e-02,
 2.854711040251367224e-02,
 2.839422453770320057e-02,
 2.824046592176318246e-02,
 2.808584049891964599e-02,
 2.793035423894522917e-02,
 2.777401313693676418e-02,
 2.761682321309034960e-02,
 2.745879051247763006e-02,
 2.729992110481971324e-02,
 2.714022108426198884e-02,
 2.697969656914598821e-02,
 2.681835370178397085e-02,
 2.665619864822913604e-02,
 2.649323759804825609e-02,
 2.632947676409113855e-02,
 2.616492238226189246e-02,
 2.599958071128747814e-02,
 2.583345803248688483e-02,
 2.566656064953919125e-02,
 2.549889488825139716e-02,
 2.533046709632500587e-02,
 2.516128364312291560e-02,
 2.499135091943482587e-02,
 2.482067533724264391e-02,
 2.464926332948581475e-02,
 2.447712134982420185e-02,
 2.430425587240298002e-02,
 2.413067339161478406e-02,
 2.395638042186325548e-02,
 2.378138349732370968e-02,
 2.360568917170620395e-02,
 2.342930401801543439e-02,
 2.325223462831186444e-02,
 2.307448761347139291e-02,
 2.289606960294561511e-02,
 2.271698724451986368e-02,
 2.253724720407314711e-02,
 2.235685616533534745e-02,
 2.217582082964546231e-02,
 2.199414791570874703e-02,
 2.181184415935418300e-02,
 2.162891631329006206e-02,
 2.144537114686094134e-02,
 2.126121544580271763e-02,
 2.107645601199834365e-02,
 2.089109966323285383e-02,
 2.070515323294745344e-02,
 2.051862356999407597e-02,
 2.033151753838897610e-02,
 2.014384201706698879e-02,
 1.995560389963323827e-02,
 1.976681009411762960e-02,
 1.957746752272627316e-02,
 1.938758312159392927e-02,
 1.919716384053600858e-02,
 1.900621664280056217e-02,
 1.881474850481856809e-02,
 1.862276641595629265e-02,
 1.843027737826500798e-02,
 1.823728840623209391e-02,
 1.804380652653100880e-02,
 1.784983877777181899e-02,
 1.765539221025032995e-02,
 1.746047388569797049e-02,
 1.726509087703175307e-02,
 1.706925026810185431e-02,
 1.687295915344256061e-02,
 1.667622463801951213e-02,
 1.647905383697905249e-02,
 1.628145387539623248e-02,
 1.608343188802377824e-02,
 1.588499501903887015e-02,
 1.568615042179280147e-02,
 1.548690525855737042e-02,
 1.528726670027324291e-02,
 1.508724192629739939e-02,
 1.488683812415080368e-02,
 1.468606248926533631e-02,
 1.448492222473132980e-02,
 1.428342454104480387e-02,
 1.408157665585427036e-02,
 1.387938579370845242e-02,
 1.367685918580233834e-02,
 1.347400406972472375e-02,
 1.327082768920489174e-02,
 1.306733729385999888e-02,
 1.286354013894051677e-02,
 1.265944348507900934e-02,
 1.245505459803523084e-02,
 1.225038074844389188e-02,
 1.204542921156104979e-02,
 1.184020726701153631e-02,
 1.163472219853503228e-02,
 1.142898129373349364e-02,
 1.122299184381787135e-02,
 1.101676114335571263e-02,
 1.081029649001691295e-02,
 1.060360518432260958e-02,
 1.039669452939095962e-02,
 1.018957183068507945e-02,
 9.982244395760354536e-03,
 9.774719534012271324e-03,
 9.567004556423359257e-03,
 9.359106775311510154e-03,
 9.151033504077636660e-03,
 8.942792056953613455e-03,
 8.734389748750952254e-03,
 8.525833894608396066e-03,
 8.317131809740840528e-03,
 8.108290809187831960e-03,
 7.899318207562969207e-03,
 7.690221318801668780e-03,
 7.481007455912013458e-03,
 7.271683930722933759e-03,
 7.062258053634427706e-03,
 6.852737133367259315e-03,
 6.643128476713625920e-03,
 6.433439388286207872e-03,
 6.223677170270484720e-03,
 6.013849122174232467e-03,
 5.803962540579294185e-03,
 5.594024718892734796e-03,
 5.384042947099001997e-03,
 5.174024511511204211e-03,
 4.963976694523694784e-03,
 4.753906774365251192e-03,
 4.543822024850515187e-03,
 4.333729715135012546e-03,
 4.123637109467314862e-03,
 3.913551466943596124e-03,
 3.703480041261589077e-03,
 3.493430080475851737e-03,
 3.283408826751327801e-03,
 3.073423516120447636e-03,
 2.863481378237488391e-03,
 2.653589636135308093e-03,
 2.443755505981569289e-03,
 2.233986196836339200e-03,
 2.024288910407985934e-03,
 1.814670840812705049e-03,
 1.605139174331314143e-03,
 1.395701089168377386e-03,
 1.186363755211621495e-03,
 9.771343337907146317e-04,
 7.680199774377314409e-04,
 5.590278296473556166e-04,
 3.501650246384149985e-04,
 1.414386871139108773e-04,
-6.714406797532524471e-05,
-2.755761356696215117e-04,
-4.838504212369299103e-04,
-6.919598404096564915e-04,
-8.998973196200926337e-04,
-1.107655796237313854e-03,
-1.315228218800422108e-03,
-1.522607547254347564e-03,
-1.729786753183119906e-03,
-1.936758820043437681e-03,
-2.143516743396924572e-03,
-2.350053531143047464e-03,
-2.556362203750230187e-03,
-2.762435794486947736e-03,
-2.968267349652289888e-03,
-3.173849928805214018e-03,
-3.379176604994517819e-03,
-3.584240464986861337e-03,
-3.789034609494973740e-03,
-3.993552153404298852e-03,
-4.197786226001021942e-03,
-4.401729971196341289e-03,
-4.605376547753154901e-03,
-4.808719129510105258e-03,
-5.011750905605867785e-03,
-5.214465080701932709e-03,
-5.416854875205988872e-03,
-5.618913525493401950e-03,
-5.820634284128644101e-03,
-6.022010420085259497e-03,
-6.223035218966967846e-03,
-6.423701983225124992e-03,
-6.624004032378331096e-03,
-6.823934703229525209e-03,
-7.023487350083052090e-03,
-7.222655344960342109e-03,
-7.421432077815970189e-03,
-7.619810956751992166e-03,
-7.817785408231142305e-03,
-8.015348877291375226e-03,
-8.212494827756386742e-03,
-8.409216742448382895e-03,
-8.605508123398268594e-03,
-8.801362492055639364e-03,
-8.996773389497357554e-03,
-9.191734376637086118e-03,
-9.386239034430995595e-03,
-9.580280964085745310e-03,
-9.773853787263610954e-03,
-9.966951146287629515e-03,
-1.015956670434512571e-02,
-1.035169414569211098e-02,
-1.054332717585409855e-02,
-1.073445952182879200e-02,
-1.092508493228623763e-02,
-1.111519717776823964e-02,
-1.130479005088781685e-02,
-1.149385736652666808e-02,
-1.168239296203250031e-02,
-1.187039069741461193e-02,
-1.205784445554020090e-02,
-1.224474814232723481e-02,
-1.243109568693899838e-02,
-1.261688104197600940e-02,
-1.280209818366766228e-02,
-1.298674111206232600e-02,
-1.317080385121814808e-02,
-1.335428044939008380e-02,
-1.353716497921899839e-02,
-1.371945153791762941e-02,
-1.390113424745671560e-02,
-1.408220725474928006e-02,
-1.426266473183509034e-02,
-1.444250087606311662e-02,
-1.462170991027329087e-02,
-1.480028608297755469e-02,
-1.497822366853926446e-02,
-1.515551696735254784e-02,
-1.533216030601970530e-02,
-1.550814803752814490e-02,
-1.568347454142571956e-02,
-1.585813422399643888e-02,
-1.603212151843270289e-02,
-1.620543088500921505e-02,
-1.637805681125380219e-02,
-1.654999381211829518e-02,
-1.672123643014758465e-02,
-1.689177923564882597e-02,
-1.706161682685768122e-02,
-1.723074383010550492e-02,
-1.739915489998408726e-02,
-1.756684471950997056e-02,
-1.773380800028697551e-02,
-1.790003948266882111e-02,
-1.806553393591952758e-02,
-1.823028615837306646e-02,
-1.839429097759243473e-02,
-1.855754325052635240e-02,
-1.872003786366661926e-02,
-1.888176973320252611e-02,
-1.904273380517574471e-02,
-1.920292505563232430e-02,
-1.936233849077598559e-02,
-1.952096914711735215e-02,
-1.967881209162467004e-02,
-1.983586242187164450e-02,
-1.999211526618507179e-02,
-2.014756578379050395e-02,
-2.030220916495782332e-02,
-2.045604063114460358e-02,
-2.060905543513915847e-02,
-2.076124886120123136e-02,
-2.091261622520351401e-02,
-2.106315287476944256e-02,
-2.121285418941205869e-02,
-2.136171558067034848e-02,
-2.150973249224502268e-02,
-2.165690040013229511e-02,
-2.180321481275778600e-02,
-2.194867127110818744e-02,
-2.209326534886145096e-02,
-2.223699265251750587e-02,
-2.237984882152514732e-02,
-2.252182952841035382e-02,
-2.266293047890131918e-02,
-2.280314741205369602e-02,
-2.294247610037327897e-02,
-2.308091234993929486e-02,
-2.321845200052402927e-02,
-2.335509092571364312e-02,
-2.349082503302600891e-02,
-2.362565026402827645e-02,
-2.375956259445225274e-02,
-2.389255803431026073e-02,
-2.402463262800718508e-02,
-2.415578245445383979e-02,
-2.428600362717741115e-02,
-2.441529229443087021e-02,
-2.454364463930214582e-02,
-2.467105687982060203e-02,
-2.479752526906326901e-02,
-2.492304609525907572e-02,
-2.504761568189283263e-02,
-2.517123038780650496e-02,
-2.529388660730040247e-02,
-2.541558077023262779e-02,
-2.553630934211734843e-02,
-2.565606882422114682e-02,
-2.577485575365960971e-02,
-2.589266670349036487e-02,
-2.600949828280732512e-02,
-2.612534713683156706e-02,
-2.624020994700220627e-02,
-2.635408343106486126e-02,
-2.646696434316042970e-02,
-2.657884947391070049e-02,
-2.668973565050400745e-02,
-2.679961973677885689e-02,
-2.690849863330639982e-02,
-2.701636927747217559e-02,
-2.712322864355530203e-02,
-2.722907374280770024e-02,
-2.733390162353071737e-02,
-2.743770937115195402e-02,
-2.754049410829891714e-02,
-2.764225299487278742e-02,
-2.774298322812055947e-02,
-2.784268204270538144e-02,
-2.794134671077564899e-02,
-2.803897454203365183e-02,
-2.813556288380150705e-02,
-2.823110912108676984e-02,
-2.832561067664642745e-02,
-2.841906501104941515e-02,
-2.851146962273781033e-02,
-2.860282204808687473e-02,
-2.869311986146369162e-02,
-2.878236067528441508e-02,
-2.887054214006988875e-02,
-2.895766194450049777e-02,
-2.904371781546937967e-02,
-2.912870751813411915e-02,
-2.921262885596732917e-02,
-2.929547967080571927e-02,
-2.937725784289823769e-02,
-2.945796129095207966e-02,
-2.953758797217819268e-02,
-2.961613588233447808e-02,
-2.969360305576914522e-02,
-2.976998756546063093e-02,
-2.984528752305824761e-02,
-2.991950107891983013e-02,
-2.999262642214932037e-02,
-3.006466178063167682e-02,
-3.013560542106804088e-02,
-3.020545564900779453e-02,
-3.027421080888069091e-02,
-3.034186928402699684e-02,
-3.040842949672599091e-02,
-3.047388990822378491e-02,
-3.053824901875952513e-02,
-3.060150536758995260e-02,
-3.066365753301263097e-02,
-3.072470413238886228e-02,
-3.078464382216340028e-02,
-3.084347529788432352e-02,
-3.090119729422105208e-02,
-3.095780858498090385e-02,
-3.101330798312432885e-02,
-3.106769434077895700e-02,
-3.112096654925215755e-02,
-3.117312353904214822e-02,
-3.122416427984811213e-02,
-3.127408778057861466e-02,
-3.132289308935849725e-02,
-3.137057929353534447e-02,
-3.141714551968324137e-02,
-3.146259093360639220e-02,
-3.150691474034070239e-02,
-3.155011618415422964e-02,
-3.159219454854636511e-02,
-3.163314915624525908e-02,
-3.167297936920464296e-02,
-3.171168458859845857e-02,
-3.174926425481500170e-02,
-3.178571784744874812e-02,
-3.182104488529178404e-02,
-3.185524492632346022e-02,
-3.188831756769851256e-02,
-3.192026244573401700e-02,
-3.195107923589565746e-02,
-3.198076765278123901e-02,
-3.200932745010416636e-02,
-3.203675842067514601e-02,
-3.206306039638223693e-02,
-3.208823324817009631e-02,
-3.211227688601762942e-02,
-3.213519125891409894e-02,
-3.215697635483470707e-02,
-3.217763220071370722e-02,
-3.219715886241709957e-02,
-3.221555644471373742e-02,
-3.223282509124499040e-02,
-3.224896498449319332e-02,
-3.226397634574883905e-02,
-3.227785943507630734e-02,
-3.229061455127852504e-02,
-3.230224203185996790e-02,
-3.231274225298885749e-02,
-3.232211562945740135e-02,
-3.233036261464142941e-02,
-3.233748370045810144e-02,
-3.234347941732289983e-02,
-3.234835033410499855e-02,
-3.235209705808109182e-02,
-3.235472023488864673e-02,
-3.235622054847708817e-02,
-3.235659872105840079e-02,
-3.235585551305591306e-02,
-3.235399172305213067e-02,
-3.235100818773500170e-02,
-3.234690578184324511e-02,
-3.234168541811028447e-02,
-3.233534804720666900e-02,
-3.232789465768164811e-02,
-3.231932627590312912e-02,
-3.230964396599660116e-02,
-3.229884882978276139e-02,
-3.228694200671385767e-02,
-3.227392467380860164e-02,
-3.225979804558607583e-02,
-3.224456337399872474e-02,
-3.222822194836302140e-02,
-3.221077509529027272e-02,
-3.219222417861491992e-02,
-3.217257059932268626e-02,
-3.215181579547667784e-02,
-3.212996124214287375e-02,
-3.210700845131374964e-02,
-3.208295897183143647e-02,
-3.205781438930890848e-02,
-3.203157632605083127e-02,
-3.200424644097209920e-02,
-3.197582642951619231e-02,
-3.194631802357193739e-02,
-3.191572299138863145e-02,
-3.188404313749091529e-02,
-3.185128030259157250e-02,
-3.181743636350382182e-02,
-3.178251323305173598e-02,
-3.174651285998011246e-02,
-3.170943722886302579e-02,
-3.167128836001074921e-02,
-3.163206830937623920e-02,
-3.159177916845995471e-02,
-3.155042306421346893e-02,
-3.150800215894252604e-02,
-3.146451865020816890e-02,
-3.141997477072722145e-02,
-3.137437278827146653e-02,
-3.132771500556590094e-02,
-3.128000376018543610e-02,
-3.123124142445093607e-02,
-3.118143040532366655e-02,
-3.113057314429898761e-02,
-3.107867211729903670e-02,
-3.102572983456357292e-02,
-3.097174884054076927e-02,
-3.091673171377604459e-02,
-3.086068106680010456e-02,
-3.080359954601598338e-02,
-3.074548983158499962e-02,
-3.068635463731118201e-02,
-3.062619671052560499e-02,
-3.056501883196831998e-02,
-3.050282381567042192e-02,
-3.043961450883426664e-02,
-3.037539379171316778e-02,
-3.031016457748949428e-02,
-3.024392981215225790e-02,
-3.017669247437310479e-02,
-3.010845557538209191e-02,
-3.003922215884124308e-02,
-2.996899530071836862e-02,
-2.989777810915871664e-02,
-2.982557372435642659e-02,
-2.975238531842462272e-02,
-2.967821609526432799e-02,
-2.960306929043293386e-02,
-2.952694817101107067e-02,
-2.944985603546875982e-02,
-2.937179621353038644e-02,
-2.929277206603954700e-02,
-2.921278698482115965e-02,
-2.913184439254465699e-02,
-2.904994774258463919e-02,
-2.896710051888121834e-02,
-2.888330623579958914e-02,
-2.879856843798815971e-02,
-2.871289070023605103e-02,
-2.862627662732963180e-02,
-2.853872985390795008e-02,
-2.845025404431733920e-02,
-2.836085289246543031e-02,
-2.827053012167349971e-02,
-2.817928948452856630e-02,
-2.808713476273430945e-02,
-2.799406976696127217e-02,
-2.790009833669554809e-02,
-2.780522434008783975e-02,
-2.770945167380007429e-02,
-2.761278426285258478e-02,
-2.751522606046888711e-02,
-2.741678104792164353e-02,
-2.731745323437563891e-02,
-2.721724665673099300e-02,
-2.711616537946578628e-02,
-2.701421349447717321e-02,
-2.691139512092183966e-02,
-2.680771440505578390e-02,
-2.670317552007335851e-02,
-2.659778266594506335e-02,
-2.649154006925513380e-02,
-2.638445198303774122e-02,
-2.627652268661263141e-02,
-2.616775648542009683e-02,
-2.605815771085522037e-02,
-2.594773072010065143e-02,
-2.583647989595979147e-02,
-2.572440964668787702e-02,
-2.561152440582354500e-02,
-2.549782863201859734e-02,
-2.538332680886799808e-02,
-2.526802344473786169e-02,
-2.515192307259437807e-02,
-2.503503024983027778e-02,
-2.491734955809185581e-02,
-2.479888560310459025e-02,
-2.467964301449855277e-02,
-2.455962644563235847e-02,
-2.443884057341726146e-02,
-2.431729009813999448e-02,
-2.419497974328516793e-02,
-2.407191425535708598e-02,
-2.394809840370046641e-02,
-2.382353698032086547e-02,
-2.369823479970435340e-02,
-2.357219669863688111e-02,
-2.344542753602172833e-02,
-2.331793219269839498e-02,
-2.318971557125883154e-02,
-2.306078259586426607e-02,
-2.293113821206095235e-02,
-2.280078738659578955e-02,
-2.266973510723007193e-02,
-2.253798638255474079e-02,
-2.240554624180268739e-02,
-2.227241973466238811e-02,
-2.213861193108979109e-02,
-2.200412792112037969e-02,
-2.186897281467985177e-02,
-2.173315174139509379e-02,
-2.159666985040420775e-02,
-2.145953231016553900e-02,
-2.132174430826746375e-02,
-2.118331105123606381e-02,
-2.104423776434341531e-02,
-2.090452969141478115e-02,
-2.076419209463601853e-02,
-2.062323025435881460e-02,
-2.048164946890804194e-02,
-2.033945505438608872e-02,
-2.019665234447805616e-02,
-2.005324669025632459e-02,
-1.990924345998469625e-02,
-1.976464803892110864e-02,
-1.961946582912189180e-02,
-1.947370224924338186e-02,
-1.932736273434448523e-02,
-1.918045273568861828e-02,
-1.903297772054459575e-02,
-1.888494317198787312e-02,
-1.873635458870081399e-02,
-1.858721748477324201e-02,
-1.843753738950107066e-02,
-1.828731984718711193e-02,
-1.813657041693867225e-02,
-1.798529467246682764e-02,
-1.783349820188425208e-02,
-1.768118660750349000e-02,
-1.752836550563380627e-02,
-1.737504052637872318e-02,
-1.722121731343255815e-02,
-1.706690152387747503e-02,
-1.691209882797834949e-02,
-1.675681490898013951e-02,
-1.660105546290210551e-02,
-1.644482619833365772e-02,
-1.628813283622896832e-02,
-1.613098110970202781e-02,
-1.597337676382026839e-02,
-1.581532555539919699e-02,
-1.565683325279592850e-02,
-1.549790563570262007e-02,
-1.533854849494023682e-02,
-1.517876763225092622e-02,
-1.501856886009115925e-02,
-1.485795800142423670e-02,
-1.469694088951293762e-02,
-1.453552336771072109e-02,
-1.437371128925485873e-02,
-1.421151051705718364e-02,
-1.404892692349614565e-02,
-1.388596639020774591e-02,
-1.372263480787732498e-02,
-1.355893807602950515e-02,
-1.339488210282020059e-02,
-1.323047280482640177e-02,
-1.306571610683699043e-02,
-1.290061794164303055e-02,
-1.273518424982831784e-02,
-1.256942097955895087e-02,
-1.240333408637363938e-02,
-1.223692953297348361e-02,
-1.207021328901167895e-02,
-1.190319133088352591e-02,
-1.173586964151535246e-02,
-1.156825421015453791e-02,
-1.140035103215857569e-02,
-1.123216610878496717e-02,
-1.106370544697938239e-02,
-1.089497505916626682e-02,
-1.072598096303693967e-02,
-1.055672918133917539e-02,
-1.038722574166609305e-02,
-1.021747667624580726e-02,
-1.004748802172921243e-02,
-9.877265818980634701e-03,
-9.706816112865510396e-03,
-9.536144952040109812e-03,
-9.365258388740322487e-03,
-9.194162478571054828e-03,
-9.022863280294793342e-03,
-8.851366855620984922e-03,
-8.679679268995585395e-03,
-8.507806587389124889e-03,
-8.335754880087448138e-03,
-8.163530218479833622e-03,
-7.991138675848901210e-03,
-7.818586327159883151e-03,
-7.645879248850672230e-03,
-7.473023518620261832e-03,
-7.300025215219971969e-03,
-7.126890418242071493e-03,
-6.953625207910332784e-03,
-6.780235664869733829e-03,
-6.606727869977159495e-03,
-6.433107904091067177e-03,
-6.259381847862280010e-03,
-6.085555781524558915e-03,
-5.911635784685204120e-03,
-5.737627936116367934e-03,
-5.563538313545551318e-03,
-5.389372993447197682e-03,
-5.215138050833963146e-03,
-5.040839559048849831e-03,
-4.866483589555837749e-03,
-4.692076211733416276e-03,
-4.517623492665615893e-03,
-4.343131496934970678e-03,
-4.168606286414993332e-03,
-3.994053920063510635e-03,
-3.819480453715101177e-03,
-3.644891939874956438e-03,
-3.470294427512249195e-03,
-3.295693961854606960e-03,
-3.121096584181022853e-03,
-2.946508331617845190e-03,
-2.771935236932227854e-03,
-2.597383328327730438e-03,
-2.422858629239335506e-03,
-2.248367158129460728e-03,
-2.073914928283230718e-03,
-1.899507947605078538e-03,
-1.725152218415164406e-03,
-1.550853737246128987e-03,
-1.376618494640682172e-03,
-1.202452474948495368e-03,
-1.028361656124486979e-03,
-8.543520095268402085e-04,
-6.804294997161049489e-04,
-5.066000842529871364e-04,
-3.328697134991459019e-04,
-1.592443304157407837e-04,
 1.427012963595713283e-05,
 1.876677390942900871e-04,
 3.609425783958070534e-04,
 5.340887361750209540e-04,
 7.071003094617644849e-04,
 8.799714038791712177e-04,
 1.052696133841647284e-03,
 1.225268622751578230e-03,
 1.397683003195592704e-03,
 1.569933417141219922e-03,
 1.742014016132769879e-03,
 1.913918961485100434e-03,
 2.085642424480469836e-03,
 2.257178586561334101e-03,
 2.428521639524397306e-03,
 2.599665785714316227e-03,
 2.770605238216777670e-03,
 2.941334221049340166e-03,
 3.111846969355572517e-03,
 3.282137729593889719e-03,
 3.452200759730636361e-03,
 3.622030329428905637e-03,
 3.791620720238545340e-03,
 3.960966225785719774e-03,
 4.130061151961897901e-03,
 4.298899817110462748e-03,
 4.467476552216401685e-03,
 4.635785701091860687e-03,
 4.803821620562829207e-03,
 4.971578680655551821e-03,
 5.139051264781509601e-03,
 5.306233769921847240e-03,
 5.473120606812043910e-03,
 5.639706200125558025e-03,
 5.805984988655794529e-03,
 5.971951425499591806e-03,
 6.137599978238397064e-03,
 6.302925129119171972e-03,
 6.467921375235353813e-03,
 6.632583228706884215e-03,
 6.796905216858062544e-03,
 6.960881882398097659e-03,
 7.124507783597640309e-03,
 7.287777494466331218e-03,
 7.450685604929750683e-03,
 7.613226721005292644e-03,
 7.775395464976892976e-03,
 7.937186475570675442e-03,
 8.098594408128030261e-03,
 8.259613934778883490e-03,
 8.420239744614810284e-03,
 8.580466543860569562e-03,
 8.740289056044948240e-03,
 8.899702022171707833e-03,
 9.058700200889377441e-03,
 9.217278368659456017e-03,
 9.375431319925636373e-03,
 9.533153867280931906e-03,
 9.690440841634272509e-03,
 9.847287092377029344e-03,
 1.000368748754857165e-02,
 1.015963691399949208e-02,
 1.031513027755733003e-02,
 1.047016250318834156e-02,
 1.062472853515999092e-02,
 1.077882333720293732e-02,
 1.093244189267148468e-02,
 1.108557920470326121e-02,
 1.123823029637925110e-02,
 1.139039021088145143e-02,
 1.154205401165041278e-02,
 1.169321678254269838e-02,
 1.184387362798644365e-02,
 1.199401967313636248e-02,
 1.214365006402848626e-02,
 1.229275996773403386e-02,
 1.244134457251068124e-02,
 1.258939908795639849e-02,
 1.273691874515923798e-02,
 1.288389879684765510e-02,
 1.303033451754032762e-02,
 1.317622120369482674e-02,
 1.332155417385399998e-02,
 1.346632876879472022e-02,
 1.361054035167236914e-02,
 1.375418430816635444e-02,
 1.389725604662457245e-02,
 1.403975099820661300e-02,
 1.418166461702592002e-02,
 1.432299238029171792e-02,
 1.446372978845002731e-02,
 1.460387236532248618e-02,
 1.474341565824609235e-02,
 1.488235523821109831e-02,
 1.502068669999757911e-02,
 1.515840566231226559e-02,
 1.529550776792384242e-02,
 1.543198868379625117e-02,
 1.556784410122366916e-02,
 1.570306973596197544e-02,
 1.583766132836047710e-02,
 1.597161464349286519e-02,
 1.610492547128709873e-02,
 1.623758962665301786e-02,
 1.636960294961189652e-02,
 1.650096130542204331e-02,
 1.663166058470503042e-02,
 1.676169670357096145e-02,
 1.689106560374238966e-02,
 1.701976325267692131e-02,
 1.714778564368987790e-02,
 1.727512879607541463e-02,
 1.740178875522601504e-02,
 1.752776159275231532e-02,
 1.765304340660108634e-02,
 1.777763032117215050e-02,
 1.790151848743505233e-02,
 1.802470408304427188e-02,
 1.814718331245259927e-02,
 1.826895240702566120e-02,
 1.839000762515331441e-02,
 1.851034525236080683e-02,
 1.862996160141953961e-02,
 1.874885301245588984e-02,
 1.886701585305926993e-02,
 1.898444651838999617e-02,
 1.910114143128463504e-02,
 1.921709704236146052e-02,
 1.933230983012480808e-02,
 1.944677630106780158e-02,
 1.956049298977436540e-02,
 1.967345645902069534e-02,
 1.978566329987502606e-02,
 1.989711013179604540e-02,
 2.000779360273171464e-02,
 2.011771038921536872e-02,
 2.022685719646185459e-02,
 2.033523075846227837e-02,
 2.044282783807782264e-02,
 2.054964522713178046e-02,
 2.065567974650213759e-02,
 2.076092824621122990e-02,
 2.086538760551549451e-02,
 2.096905473299415582e-02,
 2.107192656663622182e-02,
 2.117400007392666525e-02,
 2.127527225193203558e-02,
 2.137574012738435031e-02,
 2.147540075676379959e-02,
 2.157425122638124276e-02,
 2.167228865245898056e-02,
 2.176951018121016032e-02,
 2.186591298891790366e-02,
 2.196149428201302906e-02,
 2.205625129714974125e-02,
 2.215018130128231649e-02,
 2.224328159173863742e-02,
 2.233554949629345740e-02,
 2.242698237324079399e-02,
 2.251757761146537876e-02,
 2.260733263051144248e-02,
 2.269624488065293336e-02,
 2.278431184296046685e-02,
 2.287153102936801546e-02,
 2.295789998273886981e-02,
 2.304341627692980607e-02,
 2.312807751685410501e-02,
 2.321188133854456409e-02,
 2.329482540921393521e-02,
 2.337690742731499821e-02,
 2.345812512259980859e-02,
 2.353847625617705094e-02,
 2.361795862056883730e-02,
 2.369657003976634660e-02,
 2.377430836928422567e-02,
 2.385117149621337335e-02,
 2.392715733927396754e-02,
 2.400226384886581729e-02,
 2.407648900711837139e-02,
 2.414983082793995331e-02,
 2.422228735706480687e-02,
 2.429385667210001362e-02,
 2.436453688257099806e-02,
 2.443432612996527392e-02,
 2.450322258777623552e-02,
 2.457122446154478071e-02,
 2.463832998890016709e-02,
 2.470453743960009108e-02,
 2.476984511556896626e-02,
 2.483425135093558778e-02,
 2.489775451206958923e-02,
 2.496035299761625165e-02,
 2.502204523853107654e-02,
 2.508282969811246113e-02,
 2.514270487203358953e-02,
 2.520166928837308529e-02,
 2.525972150764447741e-02,
 2.531686012282503839e-02,
 2.537308375938215205e-02,
 2.542839107530048617e-02,
 2.548278076110627871e-02,
 2.553625153989148508e-02,
 2.558880216733642673e-02,
 2.564043143173149256e-02,
 2.569113815399715409e-02,
 2.574092118770400853e-02,
 2.578977941909024740e-02,
 2.583771176707915646e-02,
 2.588471718329470386e-02,
 2.593079465207653519e-02,
 2.597594319049341058e-02,
 2.602016184835584736e-02,
 2.606344970822745480e-02,
 2.610580588543500585e-02,
 2.614722952807754797e-02,
 2.618771981703453544e-02,
 2.622727596597243874e-02,
 2.626589722135054886e-02,
 2.630358286242547722e-02,
 2.634033220125447591e-02,
 2.637614458269786286e-02,
 2.641101938442010424e-02,
 2.644495601688977640e-02,
 2.647795392337858045e-02,
 2.651001257995891022e-02,
 2.654113149550076101e-02,
 2.657131021166683760e-02,
 2.660054830290738137e-02,
 2.662884537645306485e-02,
 2.665620107230712646e-02,
 2.668261506323670387e-02,
 2.670808705476243258e-02,
 2.673261678514701409e-02,
 2.675620402538339201e-02,
 2.677884857918074596e-02,
 2.680055028295023206e-02,
 2.682130900578901314e-02,
 2.684112464946362617e-02,
 2.685999714839181624e-02,
 2.687792646962372176e-02,
 2.689491261282142207e-02,
 2.691095561023793686e-02,
 2.692605552669453256e-02,
 2.694021245955745270e-02,
 2.695342653871309752e-02,
 2.696569792654264844e-02,
 2.697702681789478085e-02,
 2.698741344005808201e-02,
 2.699685805273200137e-02,
 2.700536094799652412e-02,
 2.701292245028120292e-02,
 2.701954291633272554e-02,
 2.702522273518143808e-02,
 2.702996232810703225e-02,
 2.703376214860291407e-02,
 2.703662268233945898e-02,
 2.703854444712614630e-02,
 2.703952799287312470e-02,
 2.703957390155075496e-02,
 2.703868278714928117e-02,
 2.703685529563602460e-02,
 2.703409210491271655e-02,
 2.703039392477123506e-02,
 2.702576149684807888e-02,
 2.702019559457825848e-02,
 2.701369702314778548e-02,
 2.700626661944505527e-02,
 2.699790525201160862e-02,
 2.698861382099120368e-02,
 2.697839325807823915e-02,
 2.696724452646514711e-02,
 2.695516862078862694e-02,
 2.694216656707465116e-02,
 2.692823942268271140e-02,
 2.691338827624906171e-02,
 2.689761424762835557e-02,
 2.688091848783511623e-02,
 2.686330217898348985e-02,
 2.684476653422624565e-02,
 2.682531279769255830e-02,
 2.680494224442509996e-02,
 2.678365618031573747e-02,
 2.676145594204052541e-02,
 2.673834289699345695e-02,
 2.671431844321912538e-02,
 2.668938400934478192e-02,
 2.666354105451094678e-02,
 2.663679106830125348e-02,
 2.660913557067118990e-02,
 2.658057611187589903e-02,
 2.655111427239683838e-02,
 2.652075166286785649e-02,
 2.648948992399963176e-02,
 2.645733072650366738e-02,
 2.642427577101505790e-02,
 2.639032678801446138e-02,
 2.635548553774864911e-02,
 2.631975381015071863e-02,
 2.628313342475883593e-02,
 2.624562623063405806e-02,
 2.620723410627774294e-02,
 2.616795895954709267e-02,
 2.612780272757033936e-02,
 2.608676737666114701e-02,
 2.604485490223136870e-02,
 2.600206732870353685e-02,
 2.595840670942189607e-02,
 2.591387512656297479e-02,
 2.586847469104473773e-02,
 2.582220754243538460e-02,
 2.577507584886045561e-02,
 2.572708180690964908e-02,
 2.567822764154271270e-02,
 2.562851560599365905e-02,
 2.557794798167527250e-02,
 2.552652707808165597e-02,
 2.547425523269031267e-02,
 2.542113481086329813e-02,
 2.536716820574775808e-02,
 2.531235783817458937e-02,
 2.525670615655770460e-02,
 2.520021563679113522e-02,
 2.514288878214575307e-02,
 2.508472812316510717e-02,
 2.502573621756071925e-02,
 2.496591565010545730e-02,
 2.490526903252734958e-02,
 2.484379900340185146e-02,
 2.478150822804298103e-02,
 2.471839939839432648e-02,
 2.465447523291870030e-02,
 2.458973847648720373e-02,
 2.452419190026695200e-02,
 2.445783830160899383e-02,
 2.439068050393422213e-02,
 2.432272135661921186e-02,
 2.425396373488106910e-02,
 2.418441053966127047e-02,
 2.411406469750883644e-02,
 2.404292916046315079e-02,
 2.397100690593455957e-02,
 2.389830093658639604e-02,
 2.382481428021375816e-02,
 2.375054998962340680e-02,
 2.367551114251207484e-02,
 2.359970084134392632e-02,
 2.352312221322724883e-02,
 2.344577840979123265e-02,
 2.336767260706032467e-02,
 2.328880800532946369e-02,
 2.320918782903755306e-02,
 2.312881532664080864e-02,
 2.304769377048459730e-02,
 2.296582645667543179e-02,
 2.288321670495141111e-02,
 2.279986785855253259e-02,
 2.271578328409030317e-02,
 2.263096637141572345e-02,
 2.254542053348768116e-02,
 2.245914920624014072e-02,
 2.237215584844855221e-02,
 2.228444394159532008e-02,
 2.219601698973591719e-02,
 2.210687851936197004e-02,
 2.201703207926593298e-02,
 2.192648124040389931e-02,
 2.183522959575783656e-02,
 2.174328076019725262e-02,
 2.165063837034060870e-02,
 2.155730608441520230e-02,
 2.146328758211712984e-02,
 2.136858656447056595e-02,
 2.127320675368563410e-02,
 2.117715189301673170e-02,
 2.108042574661944668e-02,
 2.098303209940706807e-02,
 2.088497475690637845e-02,
 2.078625754511327986e-02,
 2.068688431034723316e-02,
 2.058685891910513183e-02,
 2.048618525791521400e-02,
 2.038486723318956931e-02,
 2.028290877107639251e-02,
 2.018031381731211216e-02,
 2.007708633707185053e-02,
 1.997323031482039005e-02,
 1.986874975416220296e-02,
 1.976364867769043673e-02,
 1.965793112683598964e-02,
 1.955160116171619777e-02,
 1.944466286098165894e-02,
 1.933712032166413908e-02,
 1.922897765902326431e-02,
 1.912023900639222077e-02,
 1.901090851502363482e-02,
 1.890099035393466922e-02,
 1.879048870975164043e-02,
 1.867940778655364023e-02,
 1.856775180571698311e-02,
 1.845552500575733598e-02,
 1.834273164217297553e-02,
 1.822937598728661610e-02,
 1.811546233008703988e-02,
 1.800099497607002969e-02,
 1.788597824707991932e-02,
 1.777041648114840652e-02,
 1.765431403233556559e-02,
 1.753767527056864992e-02,
 1.742050458148083555e-02,
 1.730280636624986768e-02,
 1.718458504143620391e-02,
 1.706584503882006137e-02,
 1.694659080523904654e-02,
 1.682682680242484838e-02,
 1.670655750683937638e-02,
 1.658578740951064182e-02,
 1.646452101586876049e-02,
 1.634276284558048783e-02,
 1.622051743238397958e-02,
 1.609778932392419426e-02,
 1.597458308158537094e-02,
 1.585090328032566845e-02,
 1.572675450851029541e-02,
 1.560214136774425511e-02,
 1.547706847270462552e-02,
 1.535154045097384887e-02,
 1.522556194287018674e-02,
 1.509913760128024293e-02,
 1.497227209149007247e-02,
 1.484497009101580153e-02,
 1.471723628943425247e-02,
 1.458907538821377359e-02,
 1.446049210054328564e-02,
 1.433149115116272819e-02,
 1.420207727619240100e-02,
 1.407225522296166008e-02,
 1.394202974983805438e-02,
 1.381140562605604957e-02,
 1.368038763154505975e-02,
 1.354898055675716508e-02,
 1.341718920249620681e-02,
 1.328501837974356732e-02,
 1.315247290948682625e-02,
 1.301955762254639742e-02,
 1.288627735940229245e-02,
 1.275263697002040029e-02,
 1.261864131368021190e-02,
 1.248429525879919157e-02,
 1.234960368276009218e-02,
 1.221457147173649754e-02,
 1.207920352051795529e-02,
 1.194350473233585057e-02,
 1.180748001868864999e-02,
 1.167113429916675355e-02,
 1.153447250127715915e-02,
 1.139749956026906222e-02,
 1.126022041895750891e-02,
 1.112264002754829312e-02,
 1.098476334346236948e-02,
 1.084659533115965406e-02,
 1.070814096196290137e-02,
 1.056940521388274878e-02,
 1.043039307143982242e-02,
 1.029110952548958902e-02,
 1.015155957304581837e-02,
 1.001174821710356169e-02,
 9.871680466462499567e-03,
 9.731361335551406977e-03,
 9.590795844249579150e-03,
 9.449989017711180397e-03,
 9.308945886188217320e-03,
 9.167671484852981181e-03,
 9.026170853621350715e-03,
 8.884449036975935327e-03,
 8.742511083788422066e-03,
 8.600362047142311173e-03,
 8.458006984156623068e-03,
 8.315450955807572250e-03,
 8.172699026751788567e-03,
 8.029756265149227967e-03,
 7.886627742485496917e-03,
 7.743318533394381517e-03,
 7.599833715481738375e-03,
 7.456178369146524917e-03,
 7.312357577404790011e-03,
 7.168376425712182261e-03,
 7.024240001786364630e-03,
 6.879953395430116886e-03,
 6.735521698354520435e-03,
 6.590950004001026007e-03,
 6.446243407365244774e-03,
 6.301407004819813140e-03,
 6.156445893937156043e-03,
 6.011365173312808834e-03,
 5.866169942389056619e-03,
 5.720865301277692355e-03,
 5.575456350583458433e-03,
 5.429948191228325255e-03,
 5.284345924274186888e-03,
 5.138654650746986123e-03,
 4.992879471460830859e-03,
 4.847025486841466044e-03,
 4.701097796750216586e-03,
 4.555101500309456826e-03,
 4.409041695724982661e-03,
 4.262923480112671033e-03,
 4.116751949321147824e-03,
 3.970532197757900908e-03,
 3.824269318213967695e-03,
 3.677968401688795717e-03,
 3.531634537215375992e-03,
 3.385272811686903822e-03,
 3.238888309680765937e-03,
 3.092486113285572089e-03,
 2.946071301927081186e-03,
 2.799648952194017278e-03,
 2.653224137664800166e-03,
 2.506801928734503707e-03,
 2.360387392441326213e-03,
 2.213985592293632454e-03,
 2.067601588098103710e-03,
 1.921240435786485080e-03,
 1.774907187243770883e-03,
 1.628606890136575450e-03,
 1.482344587741034900e-03,
 1.336125318771251656e-03,
 1.189954117209411242e-03,
 1.043836012133179903e-03,
 8.977760275463510286e-04,
 7.517791822084059694e-04,
 6.058504894640585935e-04,
 4.599949570738438159e-04,
 3.142175870450486302e-04,
 1.685233754617562079e-04,
 2.291731231684970379e-05,
-1.225956186565327420e-04,
-2.680104401535781397e-04,
-4.133221814653443085e-04,
-5.585258786459684115e-04,
-7.036165746802448048e-04,
-8.485893196504932113e-04,
-9.934391709022197172e-04,
-1.138161193211061463e-03,
-1.282750458948161846e-03,
-1.427202048245250487e-03,
-1.571511049160075361e-03,
-1.715672557841153812e-03,
-1.859681678690775419e-03,
-2.003533524530585683e-03,
-2.147223216763767713e-03,
-2.290745885538263658e-03,
-2.434096669909839583e-03,
-2.577270718004019950e-03,
-2.720263187177549176e-03,
-2.863069244180643791e-03,
-3.005684065317124325e-03,
-3.148102836605065017e-03,
-3.290320753937273513e-03,
-3.432333023240669891e-03,
-3.574134860635235899e-03,
-3.715721492593151987e-03,
-3.857088156097276434e-03,
-3.998230098797715855e-03,
-4.139142579170927531e-03,
-4.279820866675360103e-03,
-4.420260241908030574e-03,
-4.560455996760779535e-03,
-4.700403434575827280e-03,
-4.840097870299543172e-03,
-4.979534630638556870e-03,
-5.118709054212478189e-03,
-5.257616491707528539e-03,
-5.396252306029749972e-03,
-5.534611872457287883e-03,
-5.672690578791775989e-03,
-5.810483825510545305e-03,
-5.947987025916703745e-03,
-6.085195606289405673e-03,
-6.222105006034032125e-03,
-6.358710677831066506e-03,
-6.495008087784452482e-03,
-6.630992715570114063e-03,
-6.766660054583568430e-03,
-6.902005612085633166e-03,
-7.037024909350550819e-03,
-7.171713481810510459e-03,
-7.306066879201033974e-03,
-7.440080665705905288e-03,
-7.573750420101347559e-03,
-7.707071735898306936e-03,
-7.840040221486904715e-03,
-7.972651500277500719e-03,
-8.104901210842443623e-03,
-8.236785007057479541e-03,
-8.368298558241969720e-03,
-8.499437549298223538e-03,
-8.630197680851192307e-03,
-8.760574669386950522e-03,
-8.890564247389896868e-03,
-9.020162163480669945e-03,
-9.149364182552525288e-03,
-9.278166085906966454e-03,
-9.406563671389389994e-03,
-9.534552753523904689e-03,
-9.662129163646185348e-03,
-9.789288750038257353e-03,
-9.916027378060134415e-03,
-1.004234093028183797e-02,
-1.016822530661502105e-02,
-1.029367642444365544e-02,
-1.041869021875293198e-02,
-1.054326264225992522e-02,
-1.066738966554110768e-02,
-1.079106727716027010e-02,
-1.091429148379606355e-02,
-1.103705831036811726e-02,
-1.115936380016254587e-02,
-1.128120401495737862e-02,
-1.140257503514678465e-02,
-1.152347295986402669e-02,
-1.164389390710497858e-02,
-1.176383401384995149e-02,
-1.188328943618488162e-02,
-1.200225634942218497e-02,
-1.212073094822093029e-02,
-1.223870944670485232e-02,
-1.235618807858226281e-02,
-1.247316309726264651e-02,
-1.258963077597365608e-02,
-1.270558740787775150e-02,
-1.282102930618706817e-02,
-1.293595280427807352e-02,
-1.305035425580582109e-02,
-1.316423003481652886e-02,
-1.327757653585985922e-02,
-1.339039017410088156e-02,
-1.350266738543038671e-02,
-1.361440462657482163e-02,
-1.372559837520571230e-02,
-1.383624513004809604e-02,
-1.394634141098707696e-02,
-1.405588375917628426e-02,
-1.416486873714232000e-02,
-1.427329292889057723e-02,
-1.438115294000960435e-02,
-1.448844539777470117e-02,
-1.459516695124992922e-02,
-1.470131427139115959e-02,
-1.480688405114629139e-02,
-1.491187300555560369e-02,
-1.501627787185164618e-02,
-1.512009540955744358e-02,
-1.522332240058422818e-02,
-1.532595564932872668e-02,
-1.542799198276907820e-02,
-1.552942825055975834e-02,
-1.563026132512657790e-02,
-1.573048810175993809e-02,
-1.583010549870741968e-02,
-1.592911045726590896e-02,
-1.602749994187278870e-02,
-1.612527094019517229e-02,
-1.622242046322053613e-02,
-1.631894554534410111e-02,
-1.641484324445681778e-02,
-1.651011064203211642e-02,
-1.660474484321154687e-02,
-1.669874297688987361e-02,
-1.679210219579945970e-02,
-1.688481967659248920e-02,
-1.697689261992463283e-02,
-1.706831825053561902e-02,
-1.715909381732993316e-02,
-1.724921659345668434e-02,
-1.733868387638842767e-02,
-1.742749298799872379e-02,
-1.751564127463973303e-02,
-1.760312610721784590e-02,
-1.768994488126899092e-02,
-1.777609501703314096e-02,
-1.786157395952775104e-02,
-1.794637917861995752e-02,
-1.803050816909852402e-02,
-1.811395845074471184e-02,
-1.819672756840142250e-02,
-1.827881309204278798e-02,
-1.836021261684185266e-02,
-1.844092376323755098e-02,
-1.852094417700113696e-02,
-1.860027152930137512e-02,
-1.867890351676846153e-02,
-1.875683786155812535e-02,
-1.883407231141354110e-02,
-1.891060463972702582e-02,
-1.898643264560096952e-02,
-1.906155415390711413e-02,
-1.913596701534553066e-02,
-1.920966910650268727e-02,
-1.928265832990805340e-02,
-1.935493261409006530e-02,
-1.942648991363144992e-02,
-1.949732820922337254e-02,
-1.956744550771814112e-02,
-1.963683984218203560e-02,
-1.970550927194642671e-02,
-1.977345188265776377e-02,
-1.984066578632767697e-02,
-1.990714912138112289e-02,
-1.997290005270370775e-02,
-2.003791677168861515e-02,
-2.010219749628245831e-02,
-2.016574047102922748e-02,
-2.022854396711497998e-02,
-2.029060628240994535e-02,
-2.035192574151081443e-02,
-2.041250069578154011e-02,
-2.047232952339312489e-02,
-2.053141062936294364e-02,
-2.058974244559272707e-02,
-2.064732343090555297e-02,
-2.070415207108192504e-02,
-2.076022687889543181e-02,
-2.081554639414654601e-02,
-2.087010918369605617e-02,
-2.092391384149750247e-02,
-2.097695898862862729e-02,
-2.102924327332133039e-02,
-2.108076537099192599e-02,
-2.113152398426891218e-02,
-2.118151784302092430e-02,
-2.123074570438338374e-02,
-2.127920635278394285e-02,
-2.132689859996710763e-02,
-2.137382128501827752e-02,
-2.141997327438635579e-02,
-2.146535346190535029e-02,
-2.150996076881553018e-02,
-2.155379414378315317e-02,
-2.159685256291946423e-02,
-2.163913502979845915e-02,
-2.168064057547436363e-02,
-2.172136825849706881e-02,
-2.176131716492767793e-02,
-2.180048640835252627e-02,
-2.183887512989617086e-02,
-2.187648249823371388e-02,
-2.191330770960237678e-02,
-2.194934998781103777e-02,
-2.198460858425039730e-02,
-2.201908277790084675e-02,
-2.205277187533984454e-02,
-2.208567521074877513e-02,
-2.211779214591815326e-02,
-2.214912207025205443e-02,
-2.217966440077214635e-02,
-2.220941858211982617e-02,
-2.223838408655824661e-02,
-2.226656041397285721e-02,
-2.229394709187123083e-02,
-2.232054367538185979e-02,
-2.234634974725192846e-02,
-2.237136491784458281e-02,
-2.239558882513429522e-02,
-2.241902113470234381e-02,
-2.244166153973074784e-02,
-2.246350976099515881e-02,
-2.248456554685739073e-02,
-2.250482867325626080e-02,
-2.252429894369804494e-02,
-2.254297618924576765e-02,
-2.256086026850767992e-02,
-2.257795106762433210e-02,
-2.259424850025546286e-02,
-2.260975250756524710e-02,
-2.262446305820708936e-02,
-2.263838014830715437e-02,
-2.265150380144716549e-02,
-2.266383406864608957e-02,
-2.267537102834113819e-02,
-2.268611478636751652e-02,
-2.269606547593752341e-02,
-2.270522325761853422e-02,
-2.271358831931004699e-02,
-2.272116087622008673e-02,
-2.272794117084021848e-02,
-2.273392947292002600e-02,
-2.273912607944043873e-02,
-2.274353131458628496e-02,
-2.274714552971776257e-02,
-2.274996910334114303e-02,
-2.275200244107850739e-02,
-2.275324597563636170e-02,
-2.275370016677385338e-02,
-2.275336550126943677e-02,
-2.275224249288709116e-02,
-2.275033168234133138e-02,
-2.274763363726172230e-02,
-2.274414895215584945e-02,
-2.273987824837205018e-02,
-2.273482217406064265e-02,
-2.272898140413487714e-02,
-2.272235664023035742e-02,
-2.271494861066413948e-02,
-2.270675807039231747e-02,
-2.269778580096736345e-02,
-2.268803261049419026e-02,
-2.267749933358528466e-02,
-2.266618683131520900e-02,
-2.265409599117402389e-02,
-2.264122772701984351e-02,
-2.262758297903059643e-02,
-2.261316271365491209e-02,
-2.259796792356203940e-02,
-2.258199962759077292e-02,
-2.256525887069798716e-02,
-2.254774672390566850e-02,
-2.252946428424760367e-02,
-2.251041267471491983e-02,
-2.249059304420072611e-02,
-2.247000656744422425e-02,
-2.244865444497351828e-02,
-2.242653790304795225e-02,
-2.240365819359937949e-02,
-2.238001659417252973e-02,
-2.235561440786480378e-02,
-2.233045296326504822e-02,
-2.230453361439124066e-02,
-2.227785774062796334e-02,
-2.225042674666236758e-02,
-2.222224206241973574e-02,
-2.219330514299809945e-02,
-2.216361746860196630e-02,
-2.213318054447508884e-02,
-2.210199590083307061e-02,
-2.207006509279409515e-02,
-2.203738970030971397e-02,
-2.200397132809459727e-02,
-2.196981160555513610e-02,
-2.193491218671758669e-02,
-2.189927475015553474e-02,
-2.186290099891595798e-02,
-2.182579266044511884e-02,
-2.178795148651340233e-02,
-2.174937925313927267e-02,
-2.171007776051250837e-02,
-2.167004883291693412e-02,
-2.162929431865179275e-02,
-2.158781608995275977e-02,
-2.154561604291231960e-02,
-2.150269609739862905e-02,
-2.145905819697458555e-02,
-2.141470430881544859e-02,
-2.136963642362592342e-02,
-2.132385655555626286e-02,
-2.127736674211827550e-02,
-2.123016904409963032e-02,
-2.118226554547809892e-02,
-2.113365835333498241e-02,
-2.108434959776728929e-02,
-2.103434143179989946e-02,
-2.098363603129648619e-02,
-2.093223559486982743e-02,
-2.088014234379131223e-02,
-2.082735852190018347e-02,
-2.077388639551124017e-02,
-2.071972825332259877e-02,
-2.066488640632232685e-02,
-2.060936318769432396e-02,
-2.055316095272367513e-02,
-2.049628207870161228e-02,
-2.043872896482880341e-02,
-2.038050403211884992e-02,
-2.032160972330105883e-02,
-2.026204850272175784e-02,
-2.020182285624563118e-02,
-2.014093529115654202e-02,
-2.007938833605663401e-02,
-2.001718454076589424e-02,
-1.995432647622053662e-02,
-1.989081673437059772e-02,
-1.982665792807720637e-02,
-1.976185269100888542e-02,
-1.969640367753764179e-02,
-1.963031356263347099e-02,
-1.956358504175966309e-02,
-1.949622083076607212e-02,
-1.942822366578255203e-02,
-1.935959630311154256e-02,
-1.929034151912006195e-02,
-1.922046211013061362e-02,
-1.914996089231281451e-02,
-1.907884070157240403e-02,
-1.900710439344140482e-02,
-1.893475484296692005e-02,
-1.886179494459913966e-02,
-1.878822761207914194e-02,
-1.871405577832618503e-02,
-1.863928239532363501e-02,
-1.856391043400536928e-02,
-1.848794288414094128e-02,
-1.841138275422012430e-02,
-1.833423307133727476e-02,
-1.825649688107483862e-02,
-1.817817724738634427e-02,
-1.809927725247868421e-02,
-1.801979999669454935e-02,
-1.793974859839314942e-02,
-1.785912619383124567e-02,
-1.777793593704372552e-02,
-1.769618099972276523e-02,
-1.761386457109714518e-02,
-1.753098985781153391e-02,
-1.744756008380344767e-02,
-1.736357849018189958e-02,
-1.727904833510399141e-02,
-1.719397289365155040e-02,
-1.710835545770711050e-02,
-1.702219933582982750e-02,
-1.693550785313002391e-02,
-1.684828435114404596e-02,
-1.676053218770860720e-02,
-1.667225473683374773e-02,
-1.658345538857645615e-02,
-1.649413754891326800e-02,
-1.640430463961214946e-02,
-1.631396009810423542e-02,
-1.622310737735577213e-02,
-1.613174994573776319e-02,
-1.603989128689708651e-02,
-1.594753489962638313e-02,
-1.585468429773310983e-02,
-1.576134300990859882e-02,
-1.566751457959735666e-02,
-1.557320256486404569e-02,
-1.547841053826206140e-02,
-1.538314208670076358e-02,
-1.528740081131192523e-02,
-1.519119032731666361e-02,
-1.509451426389145715e-02,
-1.499737626403355173e-02,
-1.489977998442652482e-02,
-1.480172909530525285e-02,
-1.470322728032014484e-02,
-1.460427823640148351e-02,
-1.450488567362328597e-02,
-1.440505331506649125e-02,
-1.430478489668178532e-02,
-1.420408416715326395e-02,
-1.410295488775945884e-02,
-1.400140083223608972e-02,
-1.389942578663771848e-02,
-1.379703354919874225e-02,
-1.369422793019418536e-02,
-1.359101275180127875e-02,
-1.348739184795838195e-02,
-1.338336906422606457e-02,
-1.327894825764642378e-02,
-1.317413329660224210e-02,
-1.306892806067627352e-02,
-1.296333644051009780e-02,
-1.285736233766237614e-02,
-1.275100966446686586e-02,
-1.264428234389095365e-02,
-1.253718430939260858e-02,
-1.242971950477799771e-02,
-1.232189188405869405e-02,
-1.221370541130826527e-02,
-1.210516406051866979e-02,
-1.199627181545734680e-02,
-1.188703266952217431e-02,
-1.177745062559797801e-02,
-1.166752969591214155e-02,
-1.155727390188950737e-02,
-1.144668727400779268e-02,
-1.133577385165260819e-02,
-1.122453768297161127e-02,
-1.111298282472945181e-02,
-1.100111334216199652e-02,
-1.088893330883010553e-02,
-1.077644680647357744e-02,
-1.066365792486514454e-02,
-1.055057076166350527e-02,
-1.043718942226662567e-02,
-1.032351801966543102e-02,
-1.020956067429608372e-02,
-1.009532151389309559e-02,
-9.980804673342068972e-03,
-9.866014294531775045e-03,
-9.750954526206979944e-03,
-9.635629523820216091e-03,
-9.520043449383654155e-03,
-9.404200471322067892e-03,
-9.288104764323130980e-03,
-9.171760509190053992e-03,
-9.055171892693024416e-03,
-8.938343107420297987e-03,
-8.821278351629404518e-03,
-8.703981829099321707e-03,
-8.586457748980202975e-03,
-8.468710325645341375e-03,
-8.350743778541955611e-03,
-8.232562332041785252e-03,
-8.114170215291913180e-03,
-7.995571662065858662e-03,
-7.876770910613678164e-03,
-7.757772203512596117e-03,
-7.638579787518150893e-03,
-7.519197913413848931e-03,
-7.399630835861967237e-03,
-7.279882813254146857e-03,
-7.159958107561304602e-03,
-7.039860984183864828e-03,
-6.919595711803034656e-03,
-6.799166562229660982e-03,
-6.678577810255433705e-03,
-6.557833733503068939e-03,
-6.436938612276165220e-03,
-6.315896729409391057e-03,
-6.194712370119691627e-03,
-6.073389821855109359e-03,
-5.951933374146112059e-03,
-5.830347318455689383e-03,
-5.708635948029338290e-03,
-5.586803557745648706e-03,
-5.464854443966910870e-03,
-5.342792904389175382e-03,
-5.220623237892694016e-03,
-5.098349744393057027e-03,
-4.975976724691116154e-03,
-4.853508480323891205e-03,
-4.730949313415542569e-03,
-4.608303526527789476e-03,
-4.485575422510628373e-03,
-4.362769304354342792e-03,
-4.239889475039071605e-03,
-4.116940237386972415e-03,
-3.993925893913327640e-03,
-3.870850746677485365e-03,
-3.747719097134599893e-03,
-3.624535245987407870e-03,
-3.501303493037245460e-03,
-3.378028137036475850e-03,
-3.254713475540381602e-03,
-3.131363804758847090e-03,
-3.007983419408793817e-03,
-2.884576612566757542e-03,
-2.761147675521031727e-03,
-2.637700897624235992e-03,
-2.514240566146805269e-03,
-2.390770966129234301e-03,
-2.267296380235498277e-03,
-2.143821088606640002e-03,
-2.020349368713863537e-03,
-1.896885495212083860e-03,
-1.773433739794856925e-03,
-1.649998371046929252e-03,
-1.526583654299577385e-03,
-1.403193851484911070e-03,
-1.279833220990185321e-03,
-1.156506017512916751e-03,
-1.033216491916293719e-03,
-9.099688910837541332e-04,
-7.867674577752378122e-04,
-6.636164304828861106e-04,
-5.405200432867124935e-04,
-4.174825257110998137e-04,
-2.945081025815410466e-04,
-1.716009938810469850e-04,
-4.876541460702524413e-05,
 7.399442537038658876e-05,
 1.966743214522470714e-04,
 3.192700744519398094e-04,
 4.417774907372183537e-04,
 5.641923823721127409e-04,
 6.865105672584077660e-04,
 8.087278692756437329e-04,
 9.308401184233330416e-04,
 1.052843150960382137e-03,
 1.174732809545360164e-03,
 1.296504943376712441e-03,
 1.418155408332052135e-03,
 1.539680067107132436e-03,
 1.661074789355097359e-03,
 1.782335451825100897e-03,
 1.903457938499860834e-03,
 2.024438140734280932e-03,
 2.145271957392683171e-03,
 2.265955294985793223e-03,
 2.386484067807952743e-03,
 2.506854198073739902e-03,
 2.627061616053086562e-03,
 2.747102260208499243e-03,
 2.866972077329447716e-03,
 2.986667022667534224e-03,
 3.106183060071405957e-03,
 3.225516162121221716e-03,
 3.344662310261458001e-03,
 3.463617494935885676e-03,
 3.582377715719659191e-03,
 3.700938981452131342e-03,
 3.819297310369545312e-03,
 3.937448730236663315e-03,
 4.055389278478044833e-03,
 4.173115002309503094e-03,
 4.290621958868744493e-03,
 4.407906215345009683e-03,
 4.524963849109518710e-03,
 4.641790947844548314e-03,
 4.758383609672180506e-03,
 4.874737943283089306e-03,
 4.990850068064676959e-03,
 5.106716114227768596e-03,
 5.222332222935020807e-03,
 5.337694546426706432e-03,
 5.452799248146997235e-03,
 5.567642502870082631e-03,
 5.682220496825196414e-03,
 5.796529427821185514e-03,
 5.910565505371439578e-03,
 6.024324950817197717e-03,
 6.137803997450883876e-03,
 6.250998890639326844e-03,
 6.363905887945945500e-03,
 6.476521259252390229e-03,
 6.588841286880223365e-03,
 6.700862265711889261e-03,
 6.812580503310372917e-03,
 6.923992320039829181e-03,
 7.035094049184498037e-03,
 7.145882037067385721e-03,
 7.256352643168840870e-03,
 7.366502240244394289e-03,
 7.476327214441089511e-03,
 7.585823965415458732e-03,
 7.694988906448703252e-03,
 7.803818464562471517e-03,
 7.912309080634149713e-03,
 8.020457209511236418e-03,
 8.128259320124913215e-03,
 8.235711895604218985e-03,
 8.342811433388119119e-03,
 8.449554445337934677e-03,
 8.555937457849266750e-03,
 8.661957011963006617e-03,
 8.767609663475579157e-03,
 8.872891983049285142e-03,
 8.977800556321715447e-03,
 9.082331984013739326e-03,
 9.186482882038946376e-03,
 9.290249881610300811e-03,
 9.393629629347328286e-03,
 9.496618787382900273e-03,
 9.599214033468504020e-03,
 9.701412061079843843e-03,
 9.803209579521523012e-03,
 9.904603314030183472e-03,
 1.000559000587908885e-02,
 1.010616641247996834e-02,
 1.020632930748534284e-02,
 1.030607548089013635e-02,
 1.040540173913275489e-02,
 1.050430490519447049e-02,
 1.060278181870017919e-02,
 1.070082933601651520e-02,
 1.079844433035032428e-02,
 1.089562369184667555e-02,
 1.099236432768559667e-02,
 1.108866316217835789e-02,
 1.118451713686353412e-02,
 1.127992321060189602e-02,
 1.137487835967062287e-02,
 1.146937957785748065e-02,
 1.156342387655382060e-02,
 1.165700828484619693e-02,
 1.175012984960944161e-02,
 1.184278563559693423e-02,
 1.193497272553099148e-02,
 1.202668822019265643e-02,
 1.211792923851129876e-02,
 1.220869291765190427e-02,
 1.229897641310395175e-02,
 1.238877689876734592e-02,
 1.247809156703925948e-02,
 1.256691762889990821e-02,
 1.265525231399690712e-02,
 1.274309287072975666e-02,
 1.283043656633353798e-02,
 1.291728068696155855e-02,
 1.300362253776720690e-02,
 1.308945944298555569e-02,
 1.317478874601430219e-02,
 1.325960780949325853e-02,
 1.334391401538365281e-02,
 1.342770476504728631e-02,
 1.351097747932332449e-02,
 1.359372959860644624e-02,
 1.367595858292232000e-02,
 1.375766191200363149e-02,
 1.383883708536518334e-02,
 1.391948162237794870e-02,
 1.399959306234187240e-02,
 1.407916896455966259e-02,
 1.415820690840819719e-02,
 1.423670449340956948e-02,
 1.431465933930179367e-02,
 1.439206908610891032e-02,
 1.446893139420930841e-02,
 1.454524394440433015e-02,
 1.462100443798604321e-02,
 1.469621059680334407e-02,
 1.477086016332868242e-02,
 1.484495090072272469e-02,
 1.491848059289905583e-02,
 1.499144704458813503e-02,
 1.506384808140014651e-02,
 1.513568154988661173e-02,
 1.520694531760288966e-02,
 1.527763727316827636e-02,
 1.534775532632576441e-02,
 1.541729740800147630e-02,
 1.548626147036315064e-02,
 1.555464548687730819e-02,
 1.562244745236675628e-02,
 1.568966538306579978e-02,
 1.575629731667621547e-02,
 1.582234131242160960e-02,
 1.588779545110093755e-02,
 1.595265783514151353e-02,
 1.601692658865138189e-02,
 1.608059985747074816e-02,
 1.614367580922199119e-02,
 1.620615263336012621e-02,
 1.626802854122168240e-02,
 1.632930176607275824e-02,
 1.638997056315654940e-02,
 1.645003320974021063e-02,
 1.650948800516041995e-02,
 1.656833327086880067e-02,
 1.662656735047578910e-02,
 1.668418860979449525e-02,
 1.674119543688341524e-02,
 1.679758624208790158e-02,
 1.685335945808172364e-02,
 1.690851353990724740e-02,
 1.696304696501492459e-02,
 1.701695823330185917e-02,
 1.707024586714987052e-02,
 1.712290841146273807e-02,
 1.717494443370218629e-02,
 1.722635252392349173e-02,
 1.727713129481052781e-02,
 1.732727938170896057e-02,
 1.737679544266008611e-02,
 1.742567815843261078e-02,
 1.747392623255423008e-02,
 1.752153839134243732e-02,
 1.756851338393440945e-02,
 1.761484998231563001e-02,
 1.766054698134867165e-02,
 1.770560319880053191e-02,
 1.775001747536888649e-02,
 1.779378867470824202e-02,
 1.783691568345490558e-02,
 1.787939741125114945e-02,
 1.792123279076842171e-02,
 1.796242077773028273e-02,
 1.800296035093375269e-02,
 1.804285051227065562e-02,
 1.808209028674747157e-02,
 1.812067872250464062e-02,
 1.815861489083537769e-02,
 1.819589788620319323e-02,
 1.823252682625850843e-02,
 1.826850085185518016e-02,
 1.830381912706565903e-02,
 1.833848083919515162e-02,
 1.837248519879548792e-02,
 1.840583143967802066e-02,
 1.843851881892536598e-02,
 1.847054661690291852e-02,
 1.850191413726888501e-02,
 1.853262070698417918e-02,
 1.856266567632097741e-02,
 1.859204841887079560e-02,
 1.862076833155142108e-02,
 1.864882483461351159e-02,
 1.867621737164594509e-02,
 1.870294540958048271e-02,
 1.872900843869576906e-02,
 1.875440597262031939e-02,
 1.877913754833488574e-02,
 1.880320272617378580e-02,
 1.882660108982582570e-02,
 1.884933224633368598e-02,
 1.887139582609340810e-02,
 1.889279148285237867e-02,
 1.891351889370680023e-02,
 1.893357775909837795e-02,
 1.895296780280989954e-02,
 1.897168877196058964e-02,
 1.898974043700002098e-02,
 1.900712259170158486e-02,
 1.902383505315527121e-02,
 1.903987766175902971e-02,
 1.905525028121022452e-02,
 1.906995279849559369e-02,
 1.908398512388055288e-02,
 1.909734719089801330e-02,
 1.911003895633593685e-02,
 1.912206040022464831e-02,
 1.913341152582260368e-02,
 1.914409235960211342e-02,
 1.915410295123387216e-02,
 1.916344337357066621e-02,
 1.917211372263061611e-02,
 1.918011411757922571e-02,
 1.918744470071081717e-02,
 1.919410563742927553e-02,
 1.920009711622791895e-02,
 1.920541934866842534e-02,
 1.921007256935930094e-02,
 1.921405703593342604e-02,
 1.921737302902446626e-02,
 1.922002085224315884e-02,
 1.922200083215233266e-02,
 1.922331331824129672e-02,
 1.922395868289938567e-02,
 1.922393732138893627e-02,
 1.922324965181723341e-02,
 1.922189611510789764e-02,
 1.921987717497119705e-02,
 1.921719331787400536e-02,
 1.921384505300866366e-02,
 1.920983291226120715e-02,
 1.920515745017882525e-02,
 1.919981924393643694e-02,
 1.919381889330281504e-02,
 1.918715702060544773e-02,
 1.917983427069525071e-02,
 1.917185131090988481e-02,
 1.916320883103691045e-02,
 1.915390754327575204e-02,
 1.914394818219909353e-02,
 1.913333150471354174e-02,
 1.912205829001954738e-02,
 1.911012933957028856e-02,
 1.909754547703048158e-02,
 1.908430754823357833e-02,
 1.907041642113888741e-02,
 1.905587298578782784e-02,
 1.904067815425910734e-02,
 1.902483286062357781e-02,
 1.900833806089816114e-02,
 1.899119473299908795e-02,
 1.897340387669427947e-02,
 1.895496651355524365e-02,
 1.893588368690819063e-02,
 1.891615646178405191e-02,
 1.889578592486838848e-02,
 1.887477318445011584e-02,
 1.885311937036975374e-02,
 1.883082563396679468e-02,
 1.880789314802645482e-02,
 1.878432310672585245e-02,
 1.876011672557915261e-02,
 1.873527524138219116e-02,
 1.870979991215654045e-02,
 1.868369201709266930e-02,
 1.865695285649236063e-02,
 1.862958375171064329e-02,
 1.860158604509687397e-02,
 1.857296109993531591e-02,
 1.854371030038461099e-02,
 1.851383505141721356e-02,
 1.848333677875734285e-02,
 1.845221692881920256e-02,
 1.842047696864362177e-02,
 1.838811838583445657e-02,
 1.835514268849442257e-02,
 1.832155140516013650e-02,
 1.828734608473618281e-02,
 1.825252829642902072e-02,
 1.821709962968008287e-02,
 1.818106169409788170e-02,
 1.814441611938988688e-02,
 1.810716455529356311e-02,
 1.806930867150667586e-02,
 1.803085015761718771e-02,
 1.799179072303231514e-02,
 1.795213209690686360e-02,
 1.791187602807130588e-02,
 1.787102428495874681e-02,
 1.782957865553158258e-02,
 1.778754094720736215e-02,
 1.774491298678437107e-02,
 1.770169662036587613e-02,
 1.765789371328437690e-02,
 1.761350615002507669e-02,
 1.756853583414880876e-02,
 1.752298468821389052e-02,
 1.747685465369816504e-02,
 1.743014769091950217e-02,
 1.738286577895672980e-02,
 1.733501091556901089e-02,
 1.728658511711513024e-02,
 1.723759041847225046e-02,
 1.718802887295380402e-02,
 1.713790255222680248e-02,
 1.708721354622873279e-02,
 1.703596396308417610e-02,
 1.698415592901989304e-02,
 1.693179158828022821e-02,
 1.687887310304175825e-02,
 1.682540265332712476e-02,
 1.677138243691824598e-02,
 1.671681466926954254e-02,
 1.666170158341985508e-02,
 1.660604542990444521e-02,
 1.654984847666611178e-02,
 1.649311300896565483e-02,
 1.643584132929191283e-02,
 1.637803575727200117e-02,
 1.631969862957930589e-02,
 1.626083229984251130e-02,
 1.620143913855357984e-02,
 1.614152153297516989e-02,
 1.608108188704705441e-02,
 1.602012262129319173e-02,
 1.595864617272719707e-02,
 1.589665499475750171e-02,
 1.583415155709276545e-02,
 1.577113834564553355e-02,
 1.570761786243669508e-02,
 1.564359262549840091e-02,
 1.557906516877692951e-02,
 1.551403804203508284e-02,
 1.544851381075452827e-02,
 1.538249505603620122e-02,
 1.531598437450189254e-02,
 1.524898437819462681e-02,
 1.518149769447843522e-02,
 1.511352696593780062e-02,
 1.504507485027690994e-02,
 1.497614402021787104e-02,
 1.490673716339916376e-02,
 1.483685698227316802e-02,
 1.476650619400304322e-02,
 1.469568753035998925e-02,
 1.462440373761927752e-02,
 1.455265757645607741e-02,
 1.448045182184086108e-02,
 1.440778926293477362e-02,
 1.433467270298388087e-02,
 1.426110495921315002e-02,
 1.418708886272073040e-02,
 1.411262725837097130e-02,
 1.403772300468706172e-02,
 1.396237897374420951e-02,
 1.388659805106094020e-02,
 1.381038313549157875e-02,
 1.373373713911713034e-02,
 1.365666298713603607e-02,
 1.357916361775516820e-02,
 1.350124198207987292e-02,
 1.342290104400330891e-02,
 1.334414378009625424e-02,
 1.326497317949619156e-02,
 1.318539224379586955e-02,
 1.310540398693122582e-02,
 1.302501143506995529e-02,
 1.294421762649881902e-02,
 1.286302561151059405e-02,
 1.278143845229153842e-02,
 1.269945922280738167e-02,
 1.261709100869000053e-02,
 1.253433690712308160e-02,
 1.245120002672745092e-02,
 1.236768348744680078e-02,
 1.228379042043228203e-02,
 1.219952396792690560e-02,
 1.211488728315037421e-02,
 1.202988353018238574e-02,
 1.194451588384689948e-02,
 1.185878752959517758e-02,
 1.177270166338870681e-02,
 1.168626149158237711e-02,
 1.159947023080680657e-02,
 1.151233110785025195e-02,
 1.142484735954087116e-02,
 1.133702223262840481e-02,
 1.124885898366548807e-02,
 1.116036087888837465e-02,
 1.107153119409851061e-02,
 1.098237321454267716e-02,
 1.089289023479312474e-02,
 1.080308555862839574e-02,
 1.071296249891229117e-02,
 1.062252437747425449e-02,
 1.053177452498839373e-02,
 1.044071628085248629e-02,
 1.034935299306685708e-02,
 1.025768801811399733e-02,
 1.016572472083561961e-02,
 1.007346647431169549e-02,
 9.980916659738693630e-03,
 9.888078666307097836e-03,
 9.794955891078819393e-03,
 9.701551738865299770e-03,
 9.607869622104001778e-03,
 9.513912960736174013e-03,
 9.419685182083433958e-03,
 9.325189720724135975e-03,
 9.230430018370516451e-03,
 9.135409523744803320e-03,
 9.040131692455122617e-03,
 8.944599986871668712e-03,
 8.848817876003325575e-03,
 8.752788835372109222e-03,
 8.656516346889436830e-03,
 8.560003898731726249e-03,
 8.463254985215442130e-03,
 8.366273106671916551e-03,
 8.269061769323144545e-03,
 8.171624485155785933e-03,
 8.073964771796700648e-03,
 7.976086152387346084e-03,
 7.877992155457846576e-03,
 7.779686314802221683e-03,
 7.681172169352324698e-03,
 7.582453263051854020e-03,
 7.483533144730685448e-03,
 7.384415367979182791e-03,
 7.285103491021882247e-03,
 7.185601076591062279e-03,
 7.085911691801206891e-03,
 6.986038908022328305e-03,
 6.885986300753385927e-03,
 6.785757449496574410e-03,
 6.685355937629942034e-03,
 6.584785352281750763e-03,
 6.484049284203445042e-03,
 6.383151327642865198e-03,
 6.282095080217611760e-03,
 6.180884142789266726e-03,
 6.079522119335117707e-03,
 5.978012616822295060e-03,
 5.876359245081048607e-03,
 5.774565616677745060e-03,
 5.672635346787597427e-03,
 5.570572053068606130e-03,
 5.468379355534291886e-03,
 5.366060876426498837e-03,
 5.263620240089391181e-03,
 5.161061072841650887e-03,
 5.058387002850427486e-03,
 4.955601660004180231e-03,
 4.852708675785660786e-03,
 4.749711683145209015e-03,
 4.646614316374858902e-03,
 4.543420210980151155e-03,
 4.440133003554318919e-03,
 4.336756331651733624e-03,
 4.233293833661081959e-03,
 4.129749148678431812e-03,
 4.026125916381596663e-03,
 3.922427776902741824e-03,
 3.818658370702809977e-03,
 3.714821338444885494e-03,
 3.610920320867558320e-03,
 3.506958958659539896e-03,
 3.402940892333166257e-03,
 3.298869762098176946e-03,
 3.194749207736021727e-03,
 3.090582868474330350e-03,
 2.986374382860920024e-03,
 2.882127388637794208e-03,
 2.777845522616391710e-03,
 2.673532420551809254e-03,
 2.569191717017110365e-03,
 2.464827045279071888e-03,
 2.360442037172083476e-03,
 2.256040322974148683e-03,
 2.151625531281681301e-03,
 2.047201288884499884e-03,
 1.942771220642053711e-03,
 1.838338949358669493e-03,
 1.733908095659088440e-03,
 1.629482277864633451e-03,
 1.525065111869564755e-03,
 1.420660211017043704e-03,
 1.316271185975206740e-03,
 1.211901644614462974e-03,
 1.107555191883890372e-03,
 1.003235429687791315e-03,
 8.989459567636706293e-04,
 7.946903685585427575e-04,
 6.904722571072911038e-04,
 5.862952109099781994e-04,
 4.821628148094715314e-04,
 3.780786498696533785e-04,
 2.740462932545903820e-04,
 1.700693181055207260e-04,
 6.615129342045394695e-05,
-3.770421606677580958e-05,
-1.414936500076040520e-04,
-2.452134525597306691e-04,
-3.488600725066301933e-04,
-4.524299633787056546e-04,
-5.559195835723291200e-04,
-6.593253964698814413e-04,
-7.626438705595621785e-04,
-8.658714795538029630e-04,
-9.690047025085711530e-04,
-1.072040023942268756e-03,
-1.174973933954016935e-03,
-1.277802928340907159e-03,
-1.380523508717356471e-03,
-1.483132182631826399e-03,
-1.585625463684000062e-03,
-1.687999871642072462e-03,
-1.790251932559834992e-03,
-1.892378178892288251e-03,
-1.994375149612764072e-03,
-2.096239390327925105e-03,
-2.197967453393707884e-03,
-2.299555898030920028e-03,
-2.401001290439449664e-03,
-2.502300203913285833e-03,
-2.603449218955047537e-03,
-2.704444923389746902e-03,
-2.805283912478201067e-03,
-2.905962789030639652e-03,
-3.006478163520059400e-03,
-3.106826654194166752e-03,
-3.207004887188090632e-03,
-3.307009496636714903e-03,
-3.406837124785505946e-03,
-3.506484422102764450e-03,
-3.605948047389703585e-03,
-3.705224667891401057e-03,
-3.804310959407415475e-03,
-3.903203606400888759e-03,
-4.001899302108397061e-03,
-4.100394748649457792e-03,
-4.198686657134403401e-03,
-4.296771747773732268e-03,
-4.394646749985233088e-03,
-4.492308402501929768e-03,
-4.589753453479691533e-03,
-4.686978660603294787e-03,
-4.783980791193223094e-03,
-4.880756622311885166e-03,
-4.977302940869038350e-03,
-5.073616543726759340e-03,
-5.169694237804412298e-03,
-5.265532840183511157e-03,
-5.361129178210854128e-03,
-5.456480089602535125e-03,
-5.551582422547319401e-03,
-5.646433035808625343e-03,
-5.741028798827675465e-03,
-5.835366591824510223e-03,
-5.929443305899749495e-03,
-6.023255843135806760e-03,
-6.116801116697255861e-03,
-6.210076050930149992e-03,
-6.303077581462931435e-03,
-6.395802655304913542e-03,
-6.488248230944782674e-03,
-6.580411278449150442e-03,
-6.672288779560638441e-03,
-6.763877727794473729e-03,
-6.855175128536194519e-03,
-6.946177999137275946e-03,
-7.036883369011399415e-03,
-7.127288279730179844e-03,
-7.217389785117512072e-03,
-7.307184951344372625e-03,
-7.396670857022979648e-03,
-7.485844593300210355e-03,
-7.574703263949853632e-03,
-7.663243985466459442e-03,
-7.751463887156488132e-03,
-7.839360111229863939e-03,
-7.926929812891069654e-03,
-8.014170160430055673e-03,
-8.101078335311441211e-03,
-8.187651532264892534e-03,
-8.273886959373276395e-03,
-8.359781838161519513e-03,
-8.445333403684772422e-03,
-8.530538904615249732e-03,
-8.615395603329398244e-03,
-8.699900775994435370e-03,
-8.784051712653980284e-03,
-8.867845717313183745e-03,
-8.951280108023566481e-03,
-9.034352216967685839e-03,
-9.117059390542067709e-03,
-9.199398989440702237e-03,
-9.281368388737946257e-03,
-9.362964977969755187e-03,
-9.444186161216075459e-03,
-9.525029357180981801e-03,
-9.605491999273423412e-03,
-9.685571535687232878e-03,
-9.765265429479868739e-03,
-9.844571158651350615e-03,
-9.923486216222545536e-03,
-1.000200811031260947e-02,
-1.008013436421564303e-02,
-1.015786251647746163e-02,
-1.023519012097144805e-02,
-1.031211474697353754e-02,
-1.038863397923694108e-02,
-1.046474541806664306e-02,
-1.054044667939213475e-02,
-1.061573539484119040e-02,
-1.069060921181149391e-02,
-1.076506579354261431e-02,
-1.083910281918742079e-02,
-1.091271798388242058e-02,
-1.098590899881721206e-02,
-1.105867359130480176e-02,
-1.113100950484971832e-02,
-1.120291449921624258e-02,
-1.127438635049585886e-02,
-1.134542285117465937e-02,
-1.141602181019905210e-02,
-1.148618105304193872e-02,
-1.155589842176749614e-02,
-1.162517177509573077e-02,
-1.169399898846669797e-02,
-1.176237795410316374e-02,
-1.183030658107355783e-02,
-1.189778279535406297e-02,
-1.196480453988999458e-02,
-1.203136977465590375e-02,
-1.209747647671677653e-02,
-1.216312264028689832e-02,
-1.222830627678854476e-02,
-1.229302541491060149e-02,
-1.235727810066625937e-02,
-1.242106239744936343e-02,
-1.248437638609156165e-02,
-1.254721816491722285e-02,
-1.260958584979889920e-02,
-1.267147757421183997e-02,
-1.273289148928736375e-02,
-1.279382576386618557e-02,
-1.285427858455096342e-02,
-1.291424815575812832e-02,
-1.297373269976871343e-02,
-1.303273045677920926e-02,
-1.309123968495149934e-02,
-1.314925866046177082e-02,
-1.320678567754913352e-02,
-1.326381904856393373e-02,
-1.332035710401433329e-02,
-1.337639819261355993e-02,
-1.343194068132532414e-02,
-1.348698295540926712e-02,
-1.354152341846578782e-02,
-1.359556049247979959e-02,
-1.364909261786366283e-02,
-1.370211825350049067e-02,
-1.375463587678569383e-02,
-1.380664398366820110e-02,
-1.385814108869117683e-02,
-1.390912572503214505e-02,
-1.395959644454196000e-02,
-1.400955181778349573e-02,
-1.405899043406978917e-02,
-1.410791090150091513e-02,
-1.415631184700099146e-02,
-1.420419191635368707e-02,
-1.425154977423769530e-02,
-1.429838410426125840e-02,
-1.434469360899618198e-02,
-1.439047701001039056e-02,
-1.443573304790142509e-02,
-1.448046048232757080e-02,
-1.452465809203922625e-02,
-1.456832467490938414e-02,
-1.461145904796355526e-02,
-1.465406004740853023e-02,
-1.469612652866135634e-02,
-1.473765736637651022e-02,
-1.477865145447332385e-02,
-1.481910770616236446e-02,
-1.485902505397088472e-02,
-1.489840244976809239e-02,
-1.493723886478938098e-02,
-1.497553328965996015e-02,
-1.501328473441776619e-02,
-1.505049222853576882e-02,
-1.508715482094367781e-02,
-1.512327158004862261e-02,
-1.515884159375542606e-02,
-1.519386396948612869e-02,
-1.522833783419900999e-02,
-1.526226233440640574e-02,
-1.529563663619222524e-02,
-1.532845992522890999e-02,
-1.536073140679345556e-02,
-1.539245030578255923e-02,
-1.542361586672746226e-02,
-1.545422735380815558e-02,
-1.548428405086628781e-02,
-1.551378526141820174e-02,
-1.554273030866654658e-02,
-1.557111853551162994e-02,
-1.559894930456207605e-02,
-1.562622199814462862e-02,
-1.565293601831317660e-02,
-1.567909078685747123e-02,
-1.570468574531082295e-02,
-1.572972035495718429e-02,
-1.575419409683759264e-02,
-1.577810647175590525e-02,
-1.580145700028390277e-02,
-1.582424522276544565e-02,
-1.584647069932046404e-02,
-1.586813300984758410e-02,
-1.588923175402669197e-02,
-1.590976655132043255e-02,
-1.592973704097502829e-02,
-1.594914288202073371e-02,
-1.596798375327124209e-02,
-1.598625935332243647e-02,
-1.600396940055088049e-02,
-1.602111363311100461e-02,
-1.603769180893207733e-02,
-1.605370370571422220e-02,
-1.606914912092401518e-02,
-1.608402787178913121e-02,
-1.609833979529236639e-02,
-1.611208474816519867e-02,
-1.612526260688037019e-02,
-1.613787326764397692e-02,
-1.614991664638687832e-02,
-1.616139267875515637e-02,
-1.617230132010046353e-02,
-1.618264254546906630e-02,
-1.619241634959064924e-02,
-1.620162274686613030e-02,
-1.621026177135519164e-02,
-1.621833347676268633e-02,
-1.622583793642466687e-02,
-1.623277524329374069e-02,
-1.623914550992363801e-02,
-1.624494886845310668e-02,
-1.625018547058913743e-02,
-1.625485548758974844e-02,
-1.625895911024582974e-02,
-1.626249654886236309e-02,
-1.626546803323902432e-02,
-1.626787381265029642e-02,
-1.626971415582451064e-02,
-1.627098935092266205e-02,
-1.627169970551623976e-02,
-1.627184554656465817e-02,
-1.627142722039167863e-02,
-1.627044509266169919e-02,
-1.626889954835478505e-02,
-1.626679099174156359e-02,
-1.626411984635712724e-02,
-1.626088655497445398e-02,
-1.625709157957712023e-02,
-1.625273540133129191e-02,
-1.624781852055739648e-02,
-1.624234145670051116e-02,
-1.623630474830084838e-02,
-1.622970895296310320e-02,
-1.622255464732529767e-02,
-1.621484242702695214e-02,
-1.620657290667673958e-02,
-1.619774671981933853e-02,
-1.618836451890188002e-02,
-1.617842697523936765e-02,
-1.616793477897988593e-02,
-1.615688863906890316e-02,
-1.614528928321313714e-02,
-1.613313745784364026e-02,
-1.612043392807823577e-02,
-1.610717947768356903e-02,
-1.609337490903618717e-02,
-1.607902104308343502e-02,
-1.606411871930311930e-02,
-1.604866879566329424e-02,
-1.603267214858079825e-02,
-1.601612967287956851e-02,
-1.599904228174808818e-02,
-1.598141090669648670e-02,
-1.596323649751276580e-02,
-1.594452002221859871e-02,
-1.592526246702436268e-02,
-1.590546483628391128e-02,
-1.588512815244834050e-02,
-1.586425345601918252e-02,
-1.584284180550137727e-02,
-1.582089427735547393e-02,
-1.579841196594878802e-02,
-1.577539598350683955e-02,
-1.575184746006334097e-02,
-1.572776754341019545e-02,
-1.570315739904669383e-02,
-1.567801821012795513e-02,
-1.565235117741309648e-02,
-1.562615751921279592e-02,
-1.559943847133595830e-02,
-1.557219528703605339e-02,
-1.554442923695702888e-02,
-1.551614160907834050e-02,
-1.548733370865956749e-02,
-1.545800685818437409e-02,
-1.542816239730421257e-02,
-1.539780168278103746e-02,
-1.536692608842961383e-02,
-1.533553700505954111e-02,
-1.530363584041638352e-02,
-1.527122401912222281e-02,
-1.523830298261611392e-02,
-1.520487418909334358e-02,
-1.517093911344477401e-02,
-1.513649924719524635e-02,
-1.510155609844145326e-02,
-1.506611119178956175e-02,
-1.503016606829210566e-02,
-1.499372228538421205e-02,
-1.495678141681948403e-02,
-1.491934505260548820e-02,
-1.488141479893850642e-02,
-1.484299227813752967e-02,
-1.480407912857848070e-02,
-1.476467700462711675e-02,
-1.472478757657176389e-02,
-1.468441253055590562e-02,
-1.464355356850928838e-02,
-1.460221240807978507e-02,
-1.456039078256366262e-02,
-1.451809044083586346e-02,
-1.447531314727971627e-02,
-1.443206068171653568e-02,
-1.438833483933363820e-02,
-1.434413743061304682e-02,
-1.429947028125928311e-02,
-1.425433523212640829e-02,
-1.420873413914482825e-02,
-1.416266887324782627e-02,
-1.411614132029707057e-02,
-1.406915338100829700e-02,
-1.402170697087604979e-02,
-1.397380402009797129e-02,
-1.392544647349904484e-02,
-1.387663629045500328e-02,
-1.382737544481520489e-02,
-1.377766592482535489e-02,
-1.372750973304993211e-02,
-1.367690888629323996e-02,
-1.362586541552132657e-02,
-1.357438136578225339e-02,
-1.352245879612682354e-02,
-1.347009977952845147e-02,
-1.341730640280247924e-02,
-1.336408076652520829e-02,
-1.331042498495320706e-02,
-1.325634118594055597e-02,
-1.320183151085717495e-02,
-1.314689811450625752e-02,
-1.309154316504113416e-02,
-1.303576884388157539e-02,
-1.297957734563045216e-02,
-1.292297087798894260e-02,
-1.286595166167219667e-02,
-1.280852193032431738e-02,
-1.275068393043249544e-02,
-1.269243992124167476e-02,
-1.263379217466806953e-02,
-1.257474297521239334e-02,
-1.251529461987301549e-02,
-1.245544941805870262e-02,
-1.239520969150068735e-02,
-1.233457777416442462e-02,
-1.227355601216133067e-02,
-1.221214676365988717e-02,
-1.215035239879602019e-02,
-1.208817529958418867e-02,
-1.202561785982670522e-02,
-1.196268248502397116e-02,
-1.189937159228364634e-02,
-1.183568761022943915e-02,
-1.177163297891013760e-02,
-1.170721014970772279e-02,
-1.164242158524528455e-02,
-1.157726975929466127e-02,
-1.151175715668404514e-02,
-1.144588627320481354e-02,
-1.137965961551783492e-02,
-1.131307970106048590e-02,
-1.124614905795225453e-02,
-1.117887022490037831e-02,
-1.111124575110573193e-02,
-1.104327819616731862e-02,
-1.097497012998760631e-02,
-1.090632413267689747e-02,
-1.083734279445721163e-02,
-1.076802871556650082e-02,
-1.069838450616260837e-02,
-1.062841278622586941e-02,
-1.055811618546261335e-02,
-1.048749734320805933e-02,
-1.041655890832871890e-02,
-1.034530353912434253e-02,
-1.027373390323051139e-02,
-1.020185267751970784e-02,
-1.012966254800327058e-02,
-1.005716620973243040e-02,
-9.984366366699030243e-03,
-9.911265731736607770e-03,
-9.837867026420765021e-03,
-9.764172980969043625e-03,
-9.690186334141153920e-03,
-9.615909833139141619e-03,
-9.541346233506057400e-03,
-9.466498299025639593e-03,
-9.391368801621658574e-03,
-9.315960521256490962e-03,
-9.240276245829443999e-03,
-9.164318771075860570e-03,
-9.088090900464562347e-03,
-9.011595445096541937e-03,
-8.934835223602374810e-03,
-8.857813062039695401e-03,
-8.780531793790995881e-03,
-8.702994259460694604e-03,
-8.625203306771899239e-03,
-8.547161790463494307e-03,
-8.468872572186926864e-03,
-8.390338520402541161e-03,
-8.311562510275666976e-03,
-8.232547423573250908e-03,
-8.153296148559580417e-03,
-8.073811579891891632e-03,
-7.994096618516560032e-03,
-7.914154171564033446e-03,
-7.833987152244703545e-03,
-7.753598479743899555e-03,
-7.672991079116803920e-03,
-7.592167881183427801e-03,
-7.511131822424126948e-03,
-7.429885844873071465e-03,
-7.348432896013512745e-03,
-7.266775928672270651e-03,
-7.184917900913851199e-03,
-7.102861775934335258e-03,
-7.020610521955991494e-03,
-6.938167112121049716e-03,
-6.855534524385129003e-03,
-6.772715741411793403e-03,
-6.689713750465358169e-03,
-6.606531543305180915e-03,
-6.523172116078787032e-03,
-6.439638469215128690e-03,
-6.355933607317943573e-03,
-6.272060539059686086e-03,
-6.188022277073482701e-03,
-6.103821837846914837e-03,
-6.019462241615114798e-03,
-5.934946512253571130e-03,
-5.850277677170630415e-03,
-5.765458767201120556e-03,
-5.680492816498221992e-03,
-5.595382862427049353e-03,
-5.510131945456873959e-03,
-5.424743109053587441e-03,
-5.339219399572860125e-03,
-5.253563866152425113e-03,
-5.167779560604406595e-03,
-5.081869537308088790e-03,
-4.995836853102523546e-03,
-4.909684567178897695e-03,
-4.823415740972634112e-03,
-4.737033438056455562e-03,
-4.650540724032582035e-03,
-4.563940666424741617e-03,
-4.477236334571446826e-03,
-4.390430799517563119e-03,
-4.303527133907454269e-03,
-4.216528411877203987e-03,
-4.129437708946700515e-03,
-4.042258101912808016e-03,
-3.954992668741562183e-03,
-3.867644488460480773e-03,
-3.780216641051363773e-03,
-3.692712207343115671e-03,
-3.605134268904144033e-03,
-3.517485907934766315e-03,
-3.429770207160556458e-03,
-3.341990249724780763e-03,
-3.254149119080950846e-03,
-3.166249898886402698e-03,
-3.078295672894431571e-03,
-2.990289524848022823e-03,
-2.902234538372582256e-03,
-2.814133796868923624e-03,
-2.725990383406524595e-03,
-2.637807380617601932e-03,
-2.549587870589224703e-03,
-2.461334934757474033e-03,
-2.373051653801136647e-03,
-2.284741107535107410e-03,
-2.196406374803828304e-03,
-2.108050533375849765e-03,
-2.019676659836925313e-03,
-1.931287829484806644e-03,
-1.842887116223071615e-03,
-1.754477592455084937e-03,
-1.666062328979006635e-03,
-1.577644394882002105e-03,
-1.489226857434644948e-03,
-1.400812781985787949e-03,
-1.312405231858214697e-03,
-1.224007268242254627e-03,
-1.135621950092263396e-03,
-1.047252334020938114e-03,
-9.589014741955454195e-04,
-8.705724222331929748e-04,
-7.822682270963814393e-04,
-6.939919349890169044e-04,
-6.057465892532377808e-04,
-5.175352302643749071e-04,
-4.293608953280970844e-04,
-3.412266185770983186e-04,
-2.531354308676335451e-04,
-1.650903596761246382e-04,
-7.709442899701688312e-05,
 1.084934076078174458e-05,
 9.873793287567347876e-05,
 1.865683344160195818e-04,
 2.743375363425893591e-04,
 3.620425336098599938e-04,
 4.496803252680676250e-04,
 5.372479145649475653e-04,
 6.247423090468417909e-04,
 7.121605206595957175e-04,
 7.994995658496585351e-04,
 8.867564656650857476e-04,
 9.739282458553426931e-04,
 1.061011936971860935e-03,
 1.148004574468343116e-03,
 1.234903198799802660e-03,
 1.321704855522920453e-03,
 1.408406595394625597e-03,
 1.495005474471442809e-03,
 1.581498554208609969e-03,
 1.667882901558024938e-03,
 1.754155589066851801e-03,
 1.840313694975782973e-03,
 1.926354303316628888e-03,
 2.012274504009623193e-03,
 2.098071392960927217e-03,
 2.183742072159911961e-03,
 2.269283649775279132e-03,
 2.354693240251814253e-03,
 2.439967964406884130e-03,
 2.525104949525616791e-03,
 2.610101329457301805e-03,
 2.694954244710039398e-03,
 2.779660842546052661e-03,
 2.864218277076647622e-03,
 2.948623709356558344e-03,
 3.032874307477366558e-03,
 3.116967246662576217e-03,
 3.200899709360450259e-03,
 3.284668885337120592e-03,
 3.368271971769712381e-03,
 3.451706173339270586e-03,
 3.534968702322395431e-03,
 3.618056778683586064e-03,
 3.700967630167094607e-03,
 3.783698492387607953e-03,
 3.866246608922008134e-03,
 3.948609231399311664e-03,
 4.030783619591324016e-03,
 4.112767041502787130e-03,
 4.194556773460918035e-03,
 4.276150100204033702e-03,
 4.357544314971672529e-03,
 4.438736719592482373e-03,
 4.519724624572392206e-03,
 4.600505349182682294e-03,
 4.681076221547825385e-03,
 4.761434578731930586e-03,
 4.841577766826405012e-03,
 4.921503141035617895e-03,
 5.001208065763321046e-03,
 5.080689914698616541e-03,
 5.159946070900697096e-03,
 5.238973926884092983e-03,
 5.317770884703398523e-03,
 5.396334356037289087e-03,
 5.474661762272099198e-03,
 5.552750534585431871e-03,
 5.630598114029463502e-03,
 5.708201951612938176e-03,
 5.785559508383787339e-03,
 5.862668255511091150e-03,
 5.939525674366003330e-03,
 6.016129256603351683e-03,
 6.092476504241727681e-03,
 6.168564929743899569e-03,
 6.244392056096888070e-03,
 6.319955416890802626e-03,
 6.395252556398078360e-03,
 6.470281029652157068e-03,
 6.545038402525452624e-03,
 6.619522251806895727e-03,
 6.693730165279313839e-03,
 6.767659741796532707e-03,
 6.841308591359330366e-03,
 6.914674335191608838e-03,
 6.987754605816167731e-03,
 7.060547047129256577e-03,
 7.133049314475884382e-03,
 7.205259074723411802e-03,
 7.277174006335595212e-03,
 7.348791799446125102e-03,
 7.420110155931267625e-03,
 7.491126789481819190e-03,
 7.561839425676039443e-03,
 7.632245802050555486e-03,
 7.702343668171306862e-03,
 7.772130785704297988e-03,
 7.841604928486036602e-03,
 7.910763882592488153e-03,
 7.979605446409019850e-03,
 8.048127430698517187e-03,
 8.116327658669793624e-03,
 8.184203966045732262e-03,
 8.251754201130034536e-03,
 8.318976224874201353e-03,
 8.385867910944212397e-03,
 8.452427145786077858e-03,
 8.518651828690841990e-03,
 8.584539871860284027e-03,
 8.650089200470825399e-03,
 8.715297752737365816e-03,
 8.780163479976794971e-03,
 8.844684346671193714e-03,
 8.908858330529675212e-03,
 8.972683422551013671e-03,
 9.036157627084373534e-03,
 9.099278961890664916e-03,
 9.162045458202995249e-03,
 9.224455160786283053e-03,
 9.286506127996850893e-03,
 9.348196431841405973e-03,
 9.409524158035389302e-03,
 9.470487406060615343e-03,
 9.531084289222890860e-03,
 9.591312934708976293e-03,
 9.651171483642561819e-03,
 9.710658091140243406e-03,
 9.769770926367125907e-03,
 9.828508172590949901e-03,
 9.886868027237049467e-03,
 9.944848701941561356e-03,
 1.000244842260475560e-02,
 1.005966542944389946e-02,
 1.011649797704539284e-02,
 1.017294433441578994e-02,
 1.022900278503374207e-02,
 1.028467162690010865e-02,
 1.033994917258787387e-02,
 1.039483374929168341e-02,
 1.044932369887713840e-02,
 1.050341737792864251e-02,
 1.055711315779756139e-02,
 1.061040942464965865e-02,
 1.066330457951144249e-02,
 1.071579703831699627e-02,
 1.076788523195298594e-02,
 1.081956760630425722e-02,
 1.087084262229842321e-02,
 1.092170875594954821e-02,
 1.097216449840195465e-02,
 1.102220835597313500e-02,
 1.107183885019589684e-02,
 1.112105451786053224e-02,
 1.116985391105575036e-02,
 1.121823559720956653e-02,
 1.126619815912948894e-02,
 1.131374019504221250e-02,
 1.136086031863211589e-02,
 1.140755715908051485e-02,
 1.145382936110309578e-02,
 1.149967558498732334e-02,
 1.154509450662928420e-02,
 1.159008481757003994e-02,
 1.163464522503099979e-02,
 1.167877445194937490e-02,
 1.172247123701234545e-02,
 1.176573433469126247e-02,
 1.180856251527502912e-02,
 1.185095456490280891e-02,
 1.189290928559623775e-02,
 1.193442549529141923e-02,
 1.197550202786974542e-02,
 1.201613773318829445e-02,
 1.205633147711027489e-02,
 1.209608214153413269e-02,
 1.213538862442223309e-02,
 1.217424983982931704e-02,
 1.221266471793015264e-02,
 1.225063220504644251e-02,
 1.228815126367364084e-02,
 1.232522087250658913e-02,
 1.236184002646494896e-02,
 1.239800773671819595e-02,
 1.243372303070944609e-02,
 1.246898495217938461e-02,
 1.250379256118913998e-02,
 1.253814493414286135e-02,
 1.257204116380946680e-02,
 1.260548035934391103e-02,
 1.263846164630818593e-02,
 1.267098416669107039e-02,
 1.270304707892787321e-02,
 1.273464955791951854e-02,
 1.276579079505061123e-02,
 1.279646999820757171e-02,
 1.282668639179556161e-02,
 1.285643921675534186e-02,
 1.288572773057917835e-02,
 1.291455120732649953e-02,
 1.294290893763830677e-02,
 1.297080022875211035e-02,
 1.299822440451523647e-02,
 1.302518080539797826e-02,
 1.305166878850619501e-02,
 1.307768772759337547e-02,
 1.310323701307180601e-02,
 1.312831605202342475e-02,
 1.315292426821015187e-02,
 1.317706110208333344e-02,
 1.320072601079285736e-02,
 1.322391846819554080e-02,
 1.324663796486309775e-02,
 1.326888400808922883e-02,
 1.329065612189665908e-02,
 1.331195384704267348e-02,
 1.333277674102521099e-02,
 1.335312437808758475e-02,
 1.337299634922267492e-02,
 1.339239226217688560e-02,
 1.341131174145338174e-02,
 1.342975442831441379e-02,
 1.344771998078369245e-02,
 1.346520807364751972e-02,
 1.348221839845578987e-02,
 1.349875066352229994e-02,
 1.351480459392435766e-02,
 1.353037993150186039e-02,
 1.354547643485589856e-02,
 1.356009387934675042e-02,
 1.357423205709100585e-02,
 1.358789077695863462e-02,
 1.360106986456907120e-02,
 1.361376916228681545e-02,
 1.362598852921650255e-02,
 1.363772784119742995e-02,
 1.364898699079735052e-02,
 1.365976588730592398e-02,
 1.367006445672726105e-02,
 1.367988264177234271e-02,
 1.368922040185034314e-02,
 1.369807771305992482e-02,
 1.370645456817937147e-02,
 1.371435097665675215e-02,
 1.372176696459906885e-02,
 1.372870257476097207e-02,
 1.373515786653293873e-02,
 1.374113291592891570e-02,
 1.374662781557328683e-02,
 1.375164267468727795e-02,
 1.375617761907488475e-02,
 1.376023279110826988e-02,
 1.376380834971238469e-02,
 1.376690447034916928e-02,
 1.376952134500117851e-02,
 1.377165918215474821e-02,
 1.377331820678236694e-02,
 1.377449866032460363e-02,
 1.377520080067156857e-02,
 1.377542490214365110e-02,
 1.377517125547179748e-02,
 1.377444016777726842e-02,
 1.377323196255066627e-02,
 1.377154697963060663e-02,
 1.376938557518171853e-02,
 1.376674812167216246e-02,
 1.376363500785047350e-02,
 1.376004663872207323e-02,
 1.375598343552492976e-02,
 1.375144583570496806e-02,
 1.374643429289080197e-02,
 1.374094927686778794e-02,
 1.373499127355187407e-02,
 1.372856078496246905e-02,
 1.372165832919517922e-02,
 1.371428444039374250e-02,
 1.370643966872154250e-02,
 1.369812458033247034e-02,
 1.368933975734142917e-02,
 1.368008579779412225e-02,
 1.367036331563646276e-02,
 1.366017294068320662e-02,
 1.364951531858647066e-02,
 1.363839111080323782e-02,
 1.362680099456272526e-02,
 1.361474566283294406e-02,
 1.360222582428697452e-02,
 1.358924220326845726e-02,
 1.357579553975688490e-02,
 1.356188658933204713e-02,
 1.354751612313808730e-02,
 1.353268492784721194e-02,
 1.351739380562255732e-02,
 1.350164357408079226e-02,
 1.348543506625414154e-02,
 1.346876913055175540e-02,
 1.345164663072093841e-02,
 1.343406844580737752e-02,
 1.341603547011526766e-02,
 1.339754861316668107e-02,
 1.337860879966069026e-02,
 1.335921696943156295e-02,
 1.333937407740697773e-02,
 1.331908109356545744e-02,
 1.329833900289317458e-02,
 1.327714880534061094e-02,
 1.325551151577839676e-02,
 1.323342816395288446e-02,
 1.321089979444124186e-02,
 1.318792746660570406e-02,
 1.316451225454789119e-02,
 1.314065524706223287e-02,
 1.311635754758896932e-02,
 1.309162027416688710e-02,
 1.306644455938535225e-02,
 1.304083155033590284e-02,
 1.301478240856353621e-02,
 1.298829831001727109e-02,
 1.296138044500045640e-02,
 1.293403001812058403e-02,
 1.290624824823835559e-02,
 1.287803636841668674e-02,
 1.284939562586919631e-02,
 1.282032728190777779e-02,
 1.279083261189029389e-02,
 1.276091290516751658e-02,
 1.273056946502972020e-02,
 1.269980360865257188e-02,
 1.266861666704307589e-02,
 1.263700998498463145e-02,
 1.260498492098158230e-02,
 1.257254284720398484e-02,
 1.253968514943094165e-02,
 1.250641322699451961e-02,
 1.247272849272253875e-02,
 1.243863237288101234e-02,
 1.240412630711642747e-02,
 1.236921174839764048e-02,
 1.233389016295676974e-02,
 1.229816303023019072e-02,
 1.226203184279922587e-02,
 1.222549810632985075e-02,
 1.218856333951232919e-02,
 1.215122907400066968e-02,
 1.211349685435097849e-02,
 1.207536823796017712e-02,
 1.203684479500385582e-02,
 1.199792810837369862e-02,
 1.195861977361477139e-02,
 1.191892139886227379e-02,
 1.187883460477782635e-02,
 1.183836102448534468e-02,
 1.179750230350684083e-02,
 1.175626009969746658e-02,
 1.171463608318017852e-02,
 1.167263193628032686e-02,
 1.163024935345964052e-02,
 1.158749004124970221e-02,
 1.154435571818543393e-02,
 1.150084811473781055e-02,
 1.145696897324647093e-02,
 1.141272004785186256e-02,
 1.136810310442685698e-02,
 1.132311992050838954e-02,
 1.127777228522843130e-02,
 1.123206199924450983e-02,
 1.118599087467021282e-02,
 1.113956073500515544e-02,
 1.109277341506467902e-02,
 1.104563076090878983e-02,
 1.099813462977149159e-02,
 1.095028688998920738e-02,
 1.090208942092887358e-02,
 1.085354411291617263e-02,
 1.080465286716275272e-02,
 1.075541759569374582e-02,
 1.070584022127459359e-02,
 1.065592267733752284e-02,
 1.060566690790775216e-02,
 1.055507486752993093e-02,
 1.050414852119305534e-02,
 1.045288984425612154e-02,
 1.040130082237319259e-02,
 1.034938345141796917e-02,
 1.029713973740796311e-02,
 1.024457169642900047e-02,
 1.019168135455847737e-02,
 1.013847074778922996e-02,
 1.008494192195255081e-02,
 1.003109693264086534e-02,
 9.976937845130687613e-03,
 9.922466734304658323e-03,
 9.867685684573565541e-03,
 9.812596789797962960e-03,
 9.757202153210223564e-03,
 9.701503887334787454e-03,
 9.645504113909623978e-03,
 9.589204963806855983e-03,
 9.532608576953021523e-03,
 9.475717102248964324e-03,
 9.418532697490072936e-03,
 9.361057529285430473e-03,
 9.303293772977457021e-03,
 9.245243612560884172e-03,
 9.186909240601313226e-03,
 9.128292858154217482e-03,
 9.069396674683000842e-03,
 9.010222907977032125e-03,
 8.950773784069523259e-03,
 8.891051537155341550e-03,
 8.831058409508223475e-03,
 8.770796651397756022e-03,
 8.710268521006621703e-03,
 8.649476284347154889e-03,
 8.588422215177611910e-03,
 8.527108594918893919e-03,
 8.465537712570032902e-03,
 8.403711864624565861e-03,
 8.341633354985856022e-03,
 8.279304494882492108e-03,
 8.216727602783474235e-03,
 8.153905004313804009e-03,
 8.090839032168435294e-03,
 8.027532026027387260e-03,
 7.963986332470307516e-03,
 7.900204304890558193e-03,
 7.836188303409076517e-03,
 7.771940694788673394e-03,
 7.707463852347639852e-03,
 7.642760155872944071e-03,
 7.577831991534224668e-03,
 7.512681751796333740e-03,
 7.447311835332892128e-03,
 7.381724646939077060e-03,
 7.315922597444000398e-03,
 7.249908103623524912e-03,
 7.183683588113070999e-03,
 7.117251479319094618e-03,
 7.050614211331647681e-03,
 6.983774223836457934e-03,
 6.916733962026669694e-03,
 6.849495876514232438e-03,
 6.782062423242072625e-03,
 6.714436063394874261e-03,
 6.646619263310956684e-03,
 6.578614494393243348e-03,
 6.510424233020035457e-03,
 6.442050960456524589e-03,
 6.373497162765302641e-03,
 6.304765330717023580e-03,
 6.235857959701086861e-03,
 6.166777549636329528e-03,
 6.097526604881391317e-03,
 6.028107634144600109e-03,
 5.958523150394828827e-03,
 5.888775670771299355e-03,
 5.818867716493412480e-03,
 5.748801812771252642e-03,
 5.678580488714787301e-03,
 5.608206277244285817e-03,
 5.537681714999733926e-03,
 5.467009342250256886e-03,
 5.396191702804154985e-03,
 5.325231343918205261e-03,
 5.254130816206915508e-03,
 5.182892673552050647e-03,
 5.111519473012162557e-03,
 5.040013774731693166e-03,
 4.968378141849874585e-03,
 4.896615140410511338e-03,
 4.824727339270694880e-03,
 4.752717310010077557e-03,
 4.680587626839689472e-03,
 4.608340866511101419e-03,
 4.535979608225580023e-03,
 4.463506433542909803e-03,
 4.390923926289986255e-03,
 4.318234672470317066e-03,
 4.245441260172636011e-03,
 4.172546279479466547e-03,
 4.099552322376659452e-03,
 4.026461982661497588e-03,
 3.953277855852197105e-03,
 3.880002539096428105e-03,
 3.806638631079976680e-03,
 3.733188731936024941e-03,
 3.659655443153816533e-03,
 3.586041367487296117e-03,
 3.512349108864200754e-03,
 3.438581272295084500e-03,
 3.364740463782081494e-03,
 3.290829290227577537e-03,
 3.216850359343675740e-03,
 3.142806279560935324e-03,
 3.068699659937129069e-03,
 2.994533110066895879e-03,
 2.920309239990162564e-03,
 2.846030660101848877e-03,
 2.771699981060818819e-03,
 2.697319813698906103e-03,
 2.622892768930282659e-03,
 2.548421457661428219e-03,
 2.473908490699426328e-03,
 2.399356478662039317e-03,
 2.324768031887311862e-03,
 2.250145760342964641e-03,
 2.175492273535773683e-03,
 2.100810180421906412e-03,
 2.026102089316008260e-03,
 1.951370607801693538e-03,
 1.876618342641225975e-03,
 1.801847899685298784e-03,
 1.727061883783685995e-03,
 1.652262898695184721e-03,
 1.577453546997768189e-03,
 1.502636429999059048e-03,
 1.427814147647470762e-03,
 1.352989298441743512e-03,
 1.278164479342286603e-03,
 1.203342285682085450e-03,
 1.128525311077476726e-03,
 1.053716147338906598e-03,
 9.789173843827499600e-04,
 9.041316101418683110e-04,
 8.293614104776662107e-04,
 7.546093690913539950e-04,
 6.798780674353603268e-04,
 6.051700846256634998e-04,
 5.304879973534834970e-04,
 4.558343797971634590e-04,
 3.812118035345843088e-04,
 3.066228374557106195e-04,
 2.320700476749260922e-04,
 1.575559974434305899e-04,
 8.308324706260158227e-05,
 8.654353796701388379e-06,
-6.572812821425376699e-05,
-1.400616480405653553e-04,
-2.143436580501050523e-04,
-2.885716139940516182e-04,
-3.627429750933549549e-04,
-4.368552041249363456e-04,
-5.109057675074390884e-04,
-5.848921353862669183e-04,
-6.588117817201385226e-04,
-7.326621843657555450e-04,
-8.064408251628123843e-04,
-8.801451900191028122e-04,
-9.537727689954961620e-04,
-1.027321056389929712e-03,
-1.100787550821998896e-03,
-1.174169755317343907e-03,
-1.247465177390946452e-03,
-1.320671329131541290e-03,
-1.393785727284493512e-03,
-1.466805893335346514e-03,
-1.539729353593065949e-03,
-1.612553639272791897e-03,
-1.685276286577856589e-03,
-1.757894836783225039e-03,
-1.830406836317062611e-03,
-1.902809836842590547e-03,
-1.975101395339952989e-03,
-2.047279074187973412e-03,
-2.119340441244770695e-03,
-2.191283069929440309e-03,
-2.263104539302206782e-03,
-2.334802434145183750e-03,
-2.406374345042894183e-03,
-2.477817868461732864e-03,
-2.549130606830016937e-03,
-2.620310168617607984e-03,
-2.691354168414987653e-03,
-2.762260227012067453e-03,
-2.833025971477055351e-03,
-2.903649035235150201e-03,
-2.974127058146209222e-03,
-3.044457686582880806e-03,
-3.114638573508505311e-03,
-3.184667378553859667e-03,
-3.254541768094878183e-03,
-3.324259415328889317e-03,
-3.393818000351311696e-03,
-3.463215210232161931e-03,
-3.532448739091453068e-03,
-3.601516288175060990e-03,
-3.670415565930259475e-03,
-3.739144288080574387e-03,
-3.807700177700332114e-03,
-3.876080965289281730e-03,
-3.944284388847004233e-03,
-4.012308193946169908e-03,
-4.080150133806381176e-03,
-4.147807969367549655e-03,
-4.215279469362277938e-03,
-4.282562410389018949e-03,
-4.349654576983841454e-03,
-4.416553761692518232e-03,
-4.483257765142386990e-03,
-4.549764396113498317e-03,
-4.616071471609033312e-03,
-4.682176816926869600e-03,
-4.748078265729367524e-03,
-4.813773660113206641e-03,
-4.879260850679185794e-03,
-4.944537696601749091e-03,
-5.009602065697390388e-03,
-5.074451834493866158e-03,
-5.139084888297909548e-03,
-5.203499121263349507e-03,
-5.267692436458998317e-03,
-5.331662745935269315e-03,
-5.395407970791326301e-03,
-5.458926041241761104e-03,
-5.522214896682599815e-03,
-5.585272485756570017e-03,
-5.648096766419458299e-03,
-5.710685706004608141e-03,
-5.773037281287514075e-03,
-5.835149478550334320e-03,
-5.897020293646010498e-03,
-5.958647732061412433e-03,
-6.020029808981010311e-03,
-6.081164549349276152e-03,
-6.142049987933317738e-03,
-6.202684169385174265e-03,
-6.263065148303072899e-03,
-6.323190989292905642e-03,
-6.383059767029361856e-03,
-6.442669566316225511e-03,
-6.502018482146416575e-03,
-6.561104619761931774e-03,
-6.619926094713288363e-03,
-6.678481032918178600e-03,
-6.736767570720247379e-03,
-6.794783854947092708e-03,
-6.852528042968320833e-03,
-6.909998302752707981e-03,
-6.967192812925016021e-03,
-7.024109762822705778e-03,
-7.080747352552266109e-03,
-7.137103793044574131e-03,
-7.193177306110322237e-03,
-7.248966124495315015e-03,
-7.304468491934277760e-03,
-7.359682663205658129e-03,
-7.414606904184672248e-03,
-7.469239491896902464e-03,
-7.523578714571176919e-03,
-7.577622871691658962e-03,
-7.631370274049992068e-03,
-7.684819243797008474e-03,
-7.737968114493700561e-03,
-7.790815231161806256e-03,
-7.843358950334163721e-03,
-7.895597640104825773e-03,
-7.947529680178005984e-03,
-7.999153461917271959e-03,
-8.050467388394242502e-03,
-8.101469874436308116e-03,
-8.152159346674714077e-03,
-8.202534243591359797e-03,
-8.252593015565858406e-03,
-8.302334124921859071e-03,
-8.351756045972949516e-03,
-8.400857265067675564e-03,
-8.449636280635275387e-03,
-8.498091603229741484e-03,
-8.546221755573998879e-03,
-8.594025272603523016e-03,
-8.641500701509837942e-03,
-8.688646601782822748e-03,
-8.735461545253422194e-03,
-8.781944116135158643e-03,
-8.828092911065631848e-03,
-8.873906539147670067e-03,
-8.919383621989398700e-03,
-8.964522793744475471e-03,
-9.009322701151671609e-03,
-9.053782003574003742e-03,
-9.097899373036913429e-03,
-9.141673494267100672e-03,
-9.185103064729789255e-03,
-9.228186794666000739e-03,
-9.270923407129287239e-03,
-9.313311638022356634e-03,
-9.355350236132367256e-03,
-9.397037963166772478e-03,
-9.438373593787838245e-03,
-9.479355915647228251e-03,
-9.519983729420087790e-03,
-9.560255848838130135e-03,
-9.600171100722884251e-03,
-9.639728325018255550e-03,
-9.678926374822502052e-03,
-9.717764116419665837e-03,
-9.756240429310726950e-03,
-9.794354206244436367e-03,
-9.832104353247115083e-03,
-9.869489789652421963e-03,
-9.906509448130687914e-03,
-9.943162274717273416e-03,
-9.979447228841137676e-03,
-1.001536328335225073e-02,
-1.005090942454888413e-02,
-1.008608465220469166e-02,
-1.012088797959445272e-02,
-1.015531843352023185e-02,
-1.018937505433654966e-02,
-1.022305689597528301e-02,
-1.025636302596980194e-02,
-1.028929252547891235e-02,
-1.032184448931031812e-02,
-1.035401802594324537e-02,
-1.038581225755096267e-02,
-1.041722632002271311e-02,
-1.044825936298487100e-02,
-1.047891054982214888e-02,
-1.050917905769773765e-02,
-1.053906407757330098e-02,
-1.056856481422855688e-02,
-1.059768048628009600e-02,
-1.062641032619955454e-02,
-1.065475358033208218e-02,
-1.068270950891349151e-02,
-1.071027738608713344e-02,
-1.073745649992057134e-02,
-1.076424615242149545e-02,
-1.079064565955311153e-02,
-1.081665435124923823e-02,
-1.084227157142876596e-02,
-1.086749667800953646e-02,
-1.089232904292206788e-02,
-1.091676805212238484e-02,
-1.094081310560448411e-02,
-1.096446361741261998e-02,
-1.098771901565256080e-02,
-1.101057874250258896e-02,
-1.103304225422431159e-02,
-1.105510902117242192e-02,
-1.107677852780434603e-02,
-1.109805027268920274e-02,
-1.111892376851654485e-02,
-1.113939854210411508e-02,
-1.115947413440571308e-02,
-1.117915010051793827e-02,
-1.119842600968698650e-02,
-1.121730144531466085e-02,
-1.123577600496388287e-02,
-1.125384930036374756e-02,
-1.127152095741421403e-02,
-1.128879061619015960e-02,
-1.130565793094487695e-02,
-1.132212257011319667e-02,
-1.133818421631428187e-02,
-1.135384256635335598e-02,
-1.136909733122368552e-02,
-1.138394823610747349e-02,
-1.139839502037658103e-02,
-1.141243743759264885e-02,
-1.142607525550666005e-02,
-1.143930825605816645e-02,
-1.145213623537389910e-02,
-1.146455900376601791e-02,
-1.147657638572957550e-02,
-1.148818821993993593e-02,
-1.149939435924934687e-02,
-1.151019467068307989e-02,
-1.152058903543524970e-02,
-1.153057734886398823e-02,
-1.154015952048610509e-02,
-1.154933547397145495e-02,
-1.155810514713660926e-02,
-1.156646849193808391e-02,
-1.157442547446523376e-02,
-1.158197607493247940e-02,
-1.158912028767102032e-02,
-1.159585812112031919e-02,
-1.160218959781889395e-02,
-1.160811475439454954e-02,
-1.161363364155435646e-02,
-1.161874632407407411e-02,
-1.162345288078693063e-02,
-1.162775340457211821e-02,
-1.163164800234273329e-02,
-1.163513679503321886e-02,
-1.163821991758636452e-02,
-1.164089751893977905e-02,
-1.164316976201196056e-02,
-1.164503682368778388e-02,
-1.164649889480369981e-02,
-1.164755618013210703e-02,
-1.164820889836572920e-02,
-1.164845728210111946e-02,
-1.164830157782179541e-02,
-1.164774204588110013e-02,
-1.164677896048432748e-02,
-1.164541260967046771e-02,
-1.164364329529360247e-02,
-1.164147133300361993e-02,
-1.163889705222662801e-02,
-1.163592079614490793e-02,
-1.163254292167617381e-02,
-1.162876379945276990e-02,
-1.162458381379992758e-02,
-1.162000336271395116e-02,
-1.161502285783979835e-02,
-1.160964272444816453e-02,
-1.160386340141206056e-02,
-1.159768534118315979e-02,
-1.159110900976745989e-02,
-1.158413488670055266e-02,
-1.157676346502252603e-02,
-1.156899525125228492e-02,
-1.156083076536149404e-02,
-1.155227054074807296e-02,
-1.154331512420918651e-02,
-1.153396507591388301e-02,
-1.152422096937515475e-02,
-1.151408339142167420e-02,
-1.150355294216902531e-02,
-1.149263023499047000e-02,
-1.148131589648733290e-02,
-1.146961056645891437e-02,
-1.145751489787194891e-02,
-1.144502955682964382e-02,
-1.143215522254032758e-02,
-1.141889258728549794e-02,
-1.140524235638764108e-02,
-1.139120524817759626e-02,
-1.137678199396120575e-02,
-1.136197333798594569e-02,
-1.134678003740684053e-02,
-1.133120286225208773e-02,
-1.131524259538818807e-02,
-1.129890003248466314e-02,
-1.128217598197839115e-02,
-1.126507126503746743e-02,
-1.124758671552466942e-02,
-1.122972317996055736e-02,
-1.121148151748602509e-02,
-1.119286259982459585e-02,
-1.117386731124415250e-02,
-1.115449654851832610e-02,
-1.113475122088766756e-02,
-1.111463225001990338e-02,
-1.109414056997033889e-02,
-1.107327712714152416e-02,
-1.105204288024270141e-02,
-1.103043880024859140e-02,
-1.100846587035811050e-02,
-1.098612508595242336e-02,
-1.096341745455280299e-02,
-1.094034399577788717e-02,
-1.091690574130067294e-02,
-1.089310373480518145e-02,
-1.086893903194256772e-02,
-1.084441270028689910e-02,
-1.081952581929059541e-02,
-1.079427948023951520e-02,
-1.076867478620758406e-02,
-1.074271285201090602e-02,
-1.071639480416194251e-02,
-1.068972178082272691e-02,
-1.066269493175810851e-02,
-1.063531541828867215e-02,
-1.060758441324283381e-02,
-1.057950310090906808e-02,
-1.055107267698754923e-02,
-1.052229434854122340e-02,
-1.049316933394705588e-02,
-1.046369886284636945e-02,
-1.043388417609504917e-02,
-1.040372652571340886e-02,
-1.037322717483575747e-02,
-1.034238739765949884e-02,
-1.031120847939366592e-02,
-1.027969171620779325e-02,
-1.024783841517961161e-02,
-1.021564989424290221e-02,
-1.018312748213500568e-02,
-1.015027251834360600e-02,
-1.011708635305369301e-02,
-1.008357034709387624e-02,
-1.004972587188220079e-02,
-1.001555430937203263e-02,
-9.981057051997576160e-03,
-9.946235502618510499e-03,
-9.911091074464965789e-03,
-9.875625191081895821e-03,
-9.839839286273121058e-03,
-9.803734804044887674e-03,
-9.767313198549615674e-03,
-9.730575934028607918e-03,
-9.693524484755217108e-03,
-9.656160334977105519e-03,
-9.618484978858326054e-03,
-9.580499920421451862e-03,
-9.542206673488940957e-03,
-9.503606761624306537e-03,
-9.464701718073172815e-03,
-9.425493085704157378e-03,
-9.385982416948667612e-03,
-9.346171273741351107e-03,
-9.306061227459833107e-03,
-9.265653858864082715e-03,
-9.224950758035550119e-03,
-9.183953524316310763e-03,
-9.142663766247291837e-03,
-9.101083101506961953e-03,
-9.059213156849321713e-03,
-9.017055568041327032e-03,
-8.974611979800952571e-03,
-8.931884045734068620e-03,
-8.888873428271343996e-03,
-8.845581798605148954e-03,
-8.802010836625953280e-03,
-8.758162230858474590e-03,
-8.714037678397412029e-03,
-8.669638884843396814e-03,
-8.624967564238252352e-03,
-8.580025438999923024e-03,
-8.534814239857850537e-03,
-8.489335705787096065e-03,
-8.443591583943121578e-03,
-8.397583629595851279e-03,
-8.351313606063358319e-03,
-8.304783284645905414e-03,
-8.257994444559246458e-03,
-8.210948872867633239e-03,
-8.163648364417012970e-03,
-8.116094721767851128e-03,
-8.068289755127522334e-03,
-8.020235282282465322e-03,
-7.971933128530610257e-03,
-7.923385126613067056e-03,
-7.874593116645588198e-03,
-7.825558946050427053e-03,
-7.776284469487053895e-03,
-7.726771548783680291e-03,
-7.677022052867775621e-03,
-7.627037857696629571e-03,
-7.576820846187794917e-03,
-7.526372908149692523e-03,
-7.475695940210969059e-03,
-7.424791845750682191e-03,
-7.373662534827987898e-03,
-7.322309924111516412e-03,
-7.270735936808390802e-03,
-7.218942502593746029e-03,
-7.166931557539162924e-03,
-7.114705044041747493e-03,
-7.062264910752570103e-03,
-7.009613112504795886e-03,
-6.956751610242266175e-03,
-6.903682370947366968e-03,
-6.850407367568658867e-03,
-6.796928578949034370e-03,
-6.743247989753013878e-03,
-6.689367590393994860e-03,
-6.635289376961860976e-03,
-6.581015351149664856e-03,
-6.526547520180898086e-03,
-6.471887896736185260e-03,
-6.417038498879749919e-03,
-6.362001349985991518e-03,
-6.306778478666309577e-03,
-6.251371918694581704e-03,
-6.195783708933684172e-03,
-6.140015893261548466e-03,
-6.084070520496857870e-03,
-6.027949644324580997e-03,
-5.971655323221999705e-03,
-5.915189620383731750e-03,
-5.858554603647451661e-03,
-5.801752345418986247e-03,
-5.744784922597273059e-03,
-5.687654416499737797e-03,
-5.630362912787031590e-03,
-5.572912501387698031e-03,
-5.515305276423063986e-03,
-5.457543336131907494e-03,
-5.399628782794937444e-03,
-5.341563722658955807e-03,
-5.283350265861584509e-03,
-5.224990526355404244e-03,
-5.166486621831771486e-03,
-5.107840673645542770e-03,
-5.049054806738368685e-03,
-4.990131149563236876e-03,
-4.931071834008021043e-03,
-4.871878995319098467e-03,
-4.812554772025473201e-03,
-4.753101305862226199e-03,
-4.693520741693899510e-03,
-4.633815227438242181e-03,
-4.573986913989756646e-03,
-4.514037955142986662e-03,
-4.453970507515669919e-03,
-4.393786730472448374e-03,
-4.333488786047921121e-03,
-4.273078838869686855e-03,
-4.212559056081938841e-03,
-4.151931607268115332e-03,
-4.091198664374426017e-03,
-4.030362401632753971e-03,
-3.969424995483510771e-03,
-3.908388624498746605e-03,
-3.847255469305609077e-03,
-3.786027712508435034e-03,
-3.724707538612243192e-03,
-3.663297133945640858e-03,
-3.601798686583667763e-03,
-3.540214386270423494e-03,
-3.478546424342479886e-03,
-3.416796993651161074e-03,
-3.354968288485956750e-03,
-3.293062504497140924e-03,
-3.231081838618463532e-03,
-3.169028488990416250e-03,
-3.106904654882967909e-03,
-3.044712536618240060e-03,
-2.982454335493545539e-03,
-2.920132253704793481e-03,
-2.857748494268537356e-03,
-2.795305260945486238e-03,
-2.732804758163528622e-03,
-2.670249190940591870e-03,
-2.607640764807488652e-03,
-2.544981685731459008e-03,
-2.482274160038702802e-03,
-2.419520394338039310e-03,
-2.356722595443827822e-03,
-2.293882970299008367e-03,
-2.231003725898760004e-03,
-2.168087069213613972e-03,
-2.105135207112651848e-03,
-2.042150346287067118e-03,
-1.979134693173770568e-03,
-1.916090453878758213e-03,
-1.853019834100487484e-03,
-1.789925039053932984e-03,
-1.726808273394105347e-03,
-1.663671741139575956e-03,
-1.600517645596858394e-03,
-1.537348189283727811e-03,
-1.474165573853725110e-03,
-1.410972000020032074e-03,
-1.347769667479437354e-03,
-1.284560774836677370e-03,
-1.221347519529267277e-03,
-1.158132097751012231e-03,
-1.094916704377040017e-03,
-1.031703532888466127e-03,
-9.684947752969288439e-04,
-9.052926220691658509e-04,
-8.420992620523414310e-04,
-7.789168823988288585e-04,
-7.157476684910744295e-04,
-6.525938038673398042e-04,
-5.894574701464155506e-04,
-5.263408469535913858e-04,
-4.632461118459744879e-04,
-4.001754402380083842e-04,
-3.371310053273465367e-04,
-2.741149780212911763e-04,
-2.111295268619290343e-04,
-1.481768179528349658e-04,
-8.525901488544691093e-05,
-2.237827866535364188e-05,
 4.046323236136215479e-05,
 1.032633625808792108e-04,
 1.660199591853928124e-04,
 2.287308722455853708e-04,
 2.913939547837128465e-04,
 3.540070628465379109e-04,
 4.165680555774341209e-04,
 4.790747952890165684e-04,
 5.415251475355384227e-04,
 6.039169811848338169e-04,
 6.662481684900863933e-04,
 7.285165851617564142e-04,
 7.907201104393997773e-04,
 8.528566271626482386e-04,
 9.149240218426940054e-04,
 9.769201847336138680e-04,
 1.038843009902744871e-03,
 1.100690395302029697e-03,
 1.162460242838037798e-03,
 1.224150458442581227e-03,
 1.285758952143110359e-03,
 1.347283638132279774e-03,
 1.408722434837982301e-03,
 1.470073264993120021e-03,
 1.531334055704890434e-03,
 1.592502738523860319e-03,
 1.653577249513157790e-03,
 1.714555529317514067e-03,
 1.775435523231478230e-03,
 1.836215181268034636e-03,
 1.896892458227065949e-03,
 1.957465313762832802e-03,
 2.017931712452353775e-03,
 2.078289623862501247e-03,
 2.138537022617561720e-03,
 2.198671888466552198e-03,
 2.258692206350047370e-03,
 2.318595966466396180e-03,
 2.378381164339084600e-03,
 2.438045800882449564e-03,
 2.497587882467646164e-03,
 2.557005420988598798e-03,
 2.616296433927745024e-03,
 2.675458944420889065e-03,
 2.734490981322824227e-03,
 2.793390579271708488e-03,
 2.852155778753865528e-03,
 2.910784626168364583e-03,
 2.969275173890681754e-03,
 3.027625480336824503e-03,
 3.085833610027120897e-03,
 3.143897633649158415e-03,
 3.201815628121101789e-03,
 3.259585676654786195e-03,
 3.317205868817775689e-03,
 3.374674300596267745e-03,
 3.431989074456692854e-03,
 3.489148299407688388e-03,
 3.546150091061818325e-03,
 3.602992571696721387e-03,
 3.659673870315688880e-03,
 3.716192122709150673e-03,
 3.772545471514705730e-03,
 3.828732066277179547e-03,
 3.884750063508678533e-03,
 3.940597626748425404e-03,
 3.996272926621569771e-03,
 4.051774140898863931e-03,
 4.107099454554861973e-03,
 4.162247059826647971e-03,
 4.217215156272244130e-03,
 4.272001950828037929e-03,
 4.326605657866649905e-03,
 4.381024499254372075e-03,
 4.435256704408034774e-03,
 4.489300510351376498e-03,
 4.543154161772123244e-03,
 4.596815911077757263e-03,
 4.650284018451154855e-03,
 4.703556751906285728e-03,
 4.756632387343561960e-03,
 4.809509208604297904e-03,
 4.862185507525776385e-03,
 4.914659583995067624e-03,
 4.966929746003165627e-03,
 5.018994309698832264e-03,
 5.070851599441469036e-03,
 5.122499947854363550e-03,
 5.173937695877473680e-03,
 5.225163192819631472e-03,
 5.276174796410456475e-03,
 5.326970872852158922e-03,
 5.377549796871144289e-03,
 5.427909951768681955e-03,
 5.478049729471706590e-03,
 5.527967530583552738e-03,
 5.577661764433403113e-03,
 5.627130849126638079e-03,
 5.676373211593643830e-03,
 5.725387287639173081e-03,
 5.774171521991049161e-03,
 5.822724368348519697e-03,
 5.871044289429851355e-03,
 5.919129757020716483e-03,
 5.966979252021086151e-03,
 6.014591264492144020e-03,
 6.061964293703055347e-03,
 6.109096848177438498e-03,
 6.155987445738881486e-03,
 6.202634613556771634e-03,
 6.249036888191630834e-03,
 6.295192815639622484e-03,
 6.341100951377481691e-03,
 6.386759860406317907e-03,
 6.432168117295548534e-03,
 6.477324306226421406e-03,
 6.522227021035088834e-03,
 6.566874865254905373e-03,
 6.611266452159409064e-03,
 6.655400404803977349e-03,
 6.699275356067286961e-03,
 6.742889948692776421e-03,
 6.786242835329623670e-03,
 6.829332678572868492e-03,
 6.872158151004048414e-03,
 6.914717935230468501e-03,
 6.957010723924821581e-03,
 6.999035219864431154e-03,
 7.040790135969372809e-03,
 7.082274195341109989e-03,
 7.123486131300334374e-03,
 7.164424687424417702e-03,
 7.205088617584422088e-03,
 7.245476685981949889e-03,
 7.285587667185660504e-03,
 7.325420346166925875e-03,
 7.364973518335538906e-03,
 7.404245989575152127e-03,
 7.443236576277710223e-03,
 7.481944105378206082e-03,
 7.520367414388478416e-03,
 7.558505351430971214e-03,
 7.596356775272163596e-03,
 7.633920555355059451e-03,
 7.671195571831971975e-03,
 7.708180715596558812e-03,
 7.744874888315485956e-03,
 7.781277002459632830e-03,
 7.817385981335063169e-03,
 7.853200759113724422e-03,
 7.888720280863176573e-03,
 7.923943502576583781e-03,
 7.958869391201984361e-03,
 7.993496924671108020e-03,
 8.027825091928033480e-03,
 8.061852892957108857e-03,
 8.095579338810776626e-03,
 8.129003451636966637e-03,
 8.162124264705925350e-03,
 8.194940822436469138e-03,
 8.227452180422529029e-03,
 8.259657405458619914e-03,
 8.291555575565026995e-03,
 8.323145780012780603e-03,
 8.354427119348242434e-03,
 8.385398705416954521e-03,
 8.416059661387509036e-03,
 8.446409121774588885e-03,
 8.476446232461911159e-03,
 8.506170150724795889e-03,
 8.535580045251869169e-03,
 8.564675096166865162e-03,
 8.593454495049905953e-03,
 8.621917444958179452e-03,
 8.650063160446136781e-03,
 8.677890867585785067e-03,
 8.705399803986064305e-03,
 8.732589218811970949e-03,
 8.759458372803240883e-03,
 8.786006538292831167e-03,
 8.812232999224577784e-03,
 8.838137051170872477e-03,
 8.863718001349584971e-03,
 8.888975168640740609e-03,
 8.913907883602856241e-03,
 8.938515488488570082e-03,
 8.962797337260085956e-03,
 8.986752795604353861e-03,
 9.010381240947355416e-03,
 9.033682062468375434e-03,
 9.056654661113675009e-03,
 9.079298449609952970e-03,
 9.101612852477024979e-03,
 9.123597306040348229e-03,
 9.145251258443285944e-03,
 9.166574169658422977e-03,
 9.187565511498997639e-03,
 9.208224767629606677e-03,
 9.228551433576610147e-03,
 9.248545016738121682e-03,
 9.268205036393580704e-03,
 9.287531023712589096e-03,
 9.306522521764061875e-03,
 9.325179085524226003e-03,
 9.343500281884497757e-03,
 9.361485689658987155e-03,
 9.379134899591514904e-03,
 9.396447514362218228e-03,
 9.413423148593712611e-03,
 9.430061428856890970e-03,
 9.446361993676240590e-03,
 9.462324493534814834e-03,
 9.477948590878682716e-03,
 9.493233960121064477e-03,
 9.508180287646042159e-03,
 9.522787271811697721e-03,
 9.537054622953036048e-03,
 9.550982063384415299e-03,
 9.564569327401477652e-03,
 9.577816161282812907e-03,
 9.590722323291039214e-03,
 9.603287583673557684e-03,
 9.615511724663008616e-03,
 9.627394540477073742e-03,
 9.638935837317830907e-03,
 9.650135433371226715e-03,
 9.660993158805331396e-03,
 9.671508855768836538e-03,
 9.681682378388756574e-03,
 9.691513592767949867e-03,
 9.701002376982053449e-03,
 9.710148621076114192e-03,
 9.718952227060654453e-03,
 9.727413108907593739e-03,
 9.735531192545502505e-03,
 9.743306415854529820e-03,
 9.750738728660961543e-03,
 9.757828092731313588e-03,
 9.764574481766047018e-03,
 9.770977881392806097e-03,
 9.777038289159387455e-03,
 9.782755714526129853e-03,
 9.788130178857972624e-03,
 9.793161715416139404e-03,
 9.797850369349403801e-03,
 9.802196197684855464e-03,
 9.806199269318329609e-03,
 9.809859665004532978e-03,
 9.813177477346527941e-03,
 9.816152810785004970e-03,
 9.818785781587067649e-03,
 9.821076517834646455e-03,
 9.823025159412487536e-03,
 9.824631857995752907e-03,
 9.825896777037183491e-03,
 9.826820091753953393e-03,
 9.827401989113969047e-03,
 9.827642667821915104e-03,
 9.827542338304901329e-03,
 9.827101222697502345e-03,
 9.826319554826693295e-03,
 9.825197580196143657e-03,
 9.823735555970358399e-03,
 9.821933750958099230e-03,
 9.819792445595746863e-03,
 9.817311931930052665e-03,
 9.814492513600586721e-03,
 9.811334505821693239e-03,
 9.807838235364334939e-03,
 9.804004040537082215e-03,
 9.799832271167157813e-03,
 9.795323288580855270e-03,
 9.790477465583657252e-03,
 9.785295186439854284e-03,
 9.779776846851962260e-03,
 9.773922853939583100e-03,
 9.767733626217999995e-03,
 9.761209593576309490e-03,
 9.754351197255189260e-03,
 9.747158889824341504e-03,
 9.739633135159513067e-03,
 9.731774408419144318e-03,
 9.723583196020596509e-03,
 9.715059995616033908e-03,
 9.706205316068056144e-03,
 9.697019677424712977e-03,
 9.687503610894284897e-03,
 9.677657658819753192e-03,
 9.667482374652813792e-03,
 9.656978322927438352e-03,
 9.646146079233260118e-03,
 9.634986230188479286e-03,
 9.623499373412362431e-03,
 9.611686117497537235e-03,
 9.599547081981660984e-03,
 9.587082897319040495e-03,
 9.574294204851655291e-03,
 9.561181656779885879e-03,
 9.547745916132934982e-03,
 9.533987656738854982e-03,
 9.519907563194185060e-03,
 9.505506330833230974e-03,
 9.490784665697171371e-03,
 9.475743284502470207e-03,
 9.460382914609283961e-03,
 9.444704293989344968e-03,
 9.428708171193353818e-03,
 9.412395305318468908e-03,
 9.395766465974961582e-03,
 9.378822433252786278e-03,
 9.361563997687763830e-03,
 9.343991960227473331e-03,
 9.326107132196691241e-03,
 9.307910335262485277e-03,
 9.289402401399192086e-03,
 9.270584172852770408e-03,
 9.251456502104984242e-03,
 9.232020251837258148e-03,
 9.212276294894100603e-03,
 9.192225514246287962e-03,
 9.171868802953717092e-03,
 9.151207064127869426e-03,
 9.130241210893905515e-03,
 9.108972166352787350e-03,
 9.087400863542453508e-03,
 9.065528245399223292e-03,
 9.043355264718663106e-03,
 9.020882884116211697e-03,
 8.998112075987213868e-03,
 8.975043822467099891e-03,
 8.951679115390962990e-03,
 8.928018956252675373e-03,
 8.904064356164189883e-03,
 8.879816335813965622e-03,
 8.855275925425544481e-03,
 8.830444164715588184e-03,
 8.805322102851556240e-03,
 8.779910798409278072e-03,
 8.754211319330211169e-03,
 8.728224742878114631e-03,
 8.701952155595788635e-03,
 8.675394653261336853e-03,
 8.648553340844114881e-03,
 8.621429332460467040e-03,
 8.594023751329150917e-03,
 8.566337729726420172e-03,
 8.538372408940925196e-03,
 8.510128939228263356e-03,
 8.481608479765104236e-03,
 8.452812198603455382e-03,
 8.423741272624157839e-03,
 8.394396887490343517e-03,
 8.364780237600632357e-03,
 8.334892526042121316e-03,
 8.304734964542846015e-03,
 8.274308773424093183e-03,
 8.243615181552676682e-03,
 8.212655426292642807e-03,
 8.181430753456628638e-03,
 8.149942417257556929e-03,
 8.118191680259154858e-03,
 8.086179813327196153e-03,
 8.053908095579691978e-03,
 8.021377814337168552e-03,
 7.988590265072873647e-03,
 7.955546751362280525e-03,
 7.922248584832662990e-03,
 7.888697085112342591e-03,
 7.854893579779788360e-03,
 7.820839404312256854e-03,
 7.786535902034231842e-03,
 7.751984424065929032e-03,
 7.717186329271187584e-03,
 7.682142984205298300e-03,
 7.646855763062511760e-03,
 7.611326047623397269e-03,
 7.575555227202082978e-03,
 7.539544698593054518e-03,
 7.503295866017596280e-03,
 7.466810141070586576e-03,
 7.430088942666458404e-03,
 7.393133696985184494e-03,
 7.355945837418199906e-03,
 7.318526804513745231e-03,
 7.280878045922417087e-03,
 7.243001016342202544e-03,
 7.204897177463267209e-03,
 7.166567997912753722e-03,
 7.128014953199578521e-03,
 7.089239525658173890e-03,
 7.050243204392903952e-03,
 7.011027485222023556e-03,
 6.971593870621277216e-03,
 6.931943869667249979e-03,
 6.892078997980994118e-03,
 6.852000777670948922e-03,
 6.811710737275768549e-03,
 6.771210411707393600e-03,
 6.730501342193257082e-03,
 6.689585076218892805e-03,
 6.648463167470081495e-03,
 6.607137175774767911e-03,
 6.565608667044845262e-03,
 6.523879213218322128e-03,
 6.481950392200105070e-03,
 6.439823787803672893e-03,
 6.397500989692334571e-03,
 6.354983593320104665e-03,
 6.312273199872342824e-03,
 6.269371416206797470e-03,
 6.226279854793739625e-03,
 6.183000133656570314e-03,
 6.139533876311959598e-03,
 6.095882711709671616e-03,
 6.052048274172813769e-03,
 6.008032203337359059e-03,
 5.963836144091688371e-03,
 5.919461746516141432e-03,
 5.874910665822384755e-03,
 5.830184562292559276e-03,
 5.785285101218067168e-03,
 5.740213952838857381e-03,
 5.694972792281972201e-03,
 5.649563299500067783e-03,
 5.603987159210296366e-03,
 5.558246060832187571e-03,
 5.512341698426369285e-03,
 5.466275770632519210e-03,
 5.420049980607138593e-03,
 5.373666035961876739e-03,
 5.327125648701110452e-03,
 5.280430535159485322e-03,
 5.233582415939605319e-03,
 5.186583015849574076e-03,
 5.139434063840279433e-03,
 5.092137292942376138e-03,
 5.044694440203852277e-03,
 4.997107246626865396e-03,
 4.949377457104471925e-03,
 4.901506820357946423e-03,
 4.853497088873032217e-03,
 4.805350018836997833e-03,
 4.757067370075092338e-03,
 4.708650905986890532e-03,
 4.660102393482724002e-03,
 4.611423602920474742e-03,
 4.562616308041092875e-03,
 4.513682285905160421e-03,
 4.464623316829089035e-03,
 4.415441184320982072e-03,
 4.366137675016432476e-03,
 4.316714578614817659e-03,
 4.267173687814651561e-03,
 4.217516798249744230e-03,
 4.167745708424761171e-03,
 4.117862219650605775e-03,
 4.067868135980432301e-03,
 4.017765264144984930e-03,
 3.967555413487884770e-03,
 3.917240395901216976e-03,
 3.866822025761264010e-03,
 3.816302119863129554e-03,
 3.765682497356482618e-03,
 3.714964979680825466e-03,
 3.664151390500620595e-03,
 3.613243555640274600e-03,
 3.562243303019714449e-03,
 3.511152462588991007e-03,
 3.459972866263840135e-03,
 3.408706347860499582e-03,
 3.357354743030586605e-03,
 3.305919889196498596e-03,
 3.254403625486182710e-03,
 3.202807792668003941e-03,
 3.151134233085833500e-03,
 3.099384790594104239e-03,
 3.047561310492645330e-03,
 2.995665639461397682e-03,
 2.943699625495717863e-03,
 2.891665117841119102e-03,
 2.839563966927989742e-03,
 2.787398024306930559e-03,
 2.735169142583204326e-03,
 2.682879175352089179e-03,
 2.630529977133602704e-03,
 2.578123403307348328e-03,
 2.525661310047499618e-03,
 2.473145554258229101e-03,
 2.420577993507942293e-03,
 2.367960485964699154e-03,
 2.315294890331318078e-03,
 2.262583065780284300e-03,
 2.209826871888658298e-03,
 2.157028168573510690e-03,
 2.104188816026917371e-03,
 2.051310674650875729e-03,
 1.998395604992992802e-03,
 1.945445467681188121e-03,
 1.892462123359403559e-03,
 1.839447432622744400e-03,
 1.786403255952702168e-03,
 1.733331453652612068e-03,
 1.680233885783556039e-03,
 1.627112412099111565e-03,
 1.573968891981315657e-03,
 1.520805184376375352e-03,
 1.467623147730174596e-03,
 1.414424639923819726e-03,
 1.361211518209859981e-03,
 1.307985639147634565e-03,
 1.254748858539622616e-03,
 1.201503031367237399e-03,
 1.148250011726672550e-03,
 1.094991652765424416e-03,
 1.041729806618279467e-03,
 9.884663243434699612e-04,
 9.352030558591477218e-04,
 8.819418498799381449e-04,
 8.286845538533339599e-04,
 7.754330138960990751e-04,
 7.221890747313393149e-04,
 6.689545796250819052e-04,
 6.157313703229568740e-04,
 5.625212869875974948e-04,
 5.093261681351904987e-04,
 4.561478505730758482e-04,
 4.029881693368073375e-04,
 3.498489576273183604e-04,
 2.967320467487643827e-04,
 2.436392660458966332e-04,
 1.905724428416119499e-04,
 1.375334023748625545e-04,
 8.452396773868434382e-05,
 3.154595981807963354e-05,
-2.139880277204428150e-05,
-7.430850374824364709e-05,
-1.271813292204252278e-04,
-1.800154677532257773e-04,
-2.328091104275871318e-04,
-2.855604509018841051e-04,
-3.382676854729227867e-04,
-3.909290131370648787e-04,
-4.435426356512794997e-04,
-4.961067575934901761e-04,
-5.486195864233519084e-04,
-6.010793325428956954e-04,
-6.534842093563903711e-04,
-7.058324333310175402e-04,
-7.581222240564444758e-04,
-8.103518043048941241e-04,
-8.625194000910486837e-04,
-9.146232407312527906e-04,
-9.666615589031128707e-04,
-1.018632590704893204e-03,
-1.070534575714492077e-03,
-1.122365757048264740e-03,
-1.174124381419940468e-03,
-1.225808699199420039e-03,
-1.277416964470876829e-03,
-1.328947435091215904e-03,
-1.380398372748392393e-03,
-1.431768043018942504e-03,
-1.483054715426220579e-03,
-1.534256663497612656e-03,
-1.585372164822118233e-03,
-1.636399501107736005e-03,
-1.687336958238476198e-03,
-1.738182826330797849e-03,
-1.788935399791078676e-03,
-1.839592977371667026e-03,
-1.890153862227182333e-03,
-1.940616361970752025e-03,
-1.990978788730162798e-03,
-2.041239459203183105e-03,
-2.091396694713596252e-03,
-2.141448821266162070e-03,
-2.191394169601946790e-03,
-2.241231075253473370e-03,
-2.290957878599133267e-03,
-2.340572924917901348e-03,
-2.390074564443828761e-03,
-2.439461152420123805e-03,
-2.488731049152662512e-03,
-2.537882620064437714e-03,
-2.586914235748656761e-03,
-2.635824272021959798e-03,
-2.684611109977651493e-03,
-2.733273136038706381e-03,
-2.781808742010044317e-03,
-2.830216325131368425e-03,
-2.878494288129014676e-03,
-2.926641039268057781e-03,
-2.974654992404242304e-03,
-3.022534567035187799e-03,
-3.070278188351798637e-03,
-3.117884287289503838e-03,
-3.165351300578907959e-03,
-3.212677670796319686e-03,
-3.259861846414184149e-03,
-3.306902281851403780e-03,
-3.353797437522858162e-03,
-3.400545779889219220e-03,
-3.447145781506518770e-03,
-3.493595921074912469e-03,
-3.539894683488022283e-03,
-3.586040559881204740e-03,
-3.632032047680157014e-03,
-3.677867650649139196e-03,
-3.723545878938901241e-03,
-3.769065249133877853e-03,
-3.814424284300290194e-03,
-3.859621514032918373e-03,
-3.904655474501891269e-03,
-3.949524708499478100e-03,
-3.994227765486566863e-03,
-4.038763201638482722e-03,
-4.083129579890998513e-03,
-4.127325469986025189e-03,
-4.171349448516623558e-03,
-4.215200098972382049e-03,
-4.258876011783914971e-03,
-4.302375784367460515e-03,
-4.345698021169248047e-03,
-4.388841333709396150e-03,
-4.431804340625226935e-03,
-4.474585667715319341e-03,
-4.517183947982252729e-03,
-4.559597821675418980e-03,
-4.601825936333727926e-03,
-4.643866946827995314e-03,
-4.685719515402646425e-03,
-4.727382311717818683e-03,
-4.768854012890457253e-03,
-4.810133303535644826e-03,
-4.851218875807574056e-03,
-4.892109429439858194e-03,
-4.932803671785957085e-03,
-4.973300317859285710e-03,
-5.013598090372811851e-03,
-5.053695719778360587e-03,
-5.093591944305869354e-03,
-5.133285510002273504e-03,
-5.172775170769823745e-03,
-5.212059688404416594e-03,
-5.251137832633667214e-03,
-5.290008381154213783e-03,
-5.328670119669382671e-03,
-5.367121841925938559e-03,
-5.405362349750883130e-03,
-5.443390453088061201e-03,
-5.481204970033951539e-03,
-5.518804726873620739e-03,
-5.556188558116275517e-03,
-5.593355306530422080e-03,
-5.630303823178582287e-03,
-5.667032967451949080e-03,
-5.703541607104829422e-03,
-5.739828618288236352e-03,
-5.775892885583674453e-03,
-5.811733302036615686e-03,
-5.847348769189117390e-03,
-5.882738197112881776e-03,
-5.917900504441320556e-03,
-5.952834618401647328e-03,
-5.987539474846804294e-03,
-6.022014018286686414e-03,
-6.056257201919003873e-03,
-6.090267987660512305e-03,
-6.124045346177131068e-03,
-6.157588256914045891e-03,
-6.190895708125529646e-03,
-6.223966696904554077e-03,
-6.256800229211594011e-03,
-6.289395319903801941e-03,
-6.321750992763126159e-03,
-6.353866280524658738e-03,
-6.385740224904490857e-03,
-6.417371876627006935e-03,
-6.448760295452132807e-03,
-6.479904550202232605e-03,
-6.510803718788542478e-03,
-6.541456888237116851e-03,
-6.571863154715021013e-03,
-6.602021623555607774e-03,
-6.631931409283598096e-03,
-6.661591635639950958e-03,
-6.691001435606536325e-03,
-6.720159951429930355e-03,
-6.749066334645476874e-03,
-6.777719746100658443e-03,
-6.806119355978151701e-03,
-6.834264343818763007e-03,
-6.862153898543738723e-03,
-6.889787218476892475e-03,
-6.917163511366409764e-03,
-6.944281994406318638e-03,
-6.971141894257327186e-03,
-6.997742447067827574e-03,
-7.024082898494089962e-03,
-7.050162503720494578e-03,
-7.075980527479031751e-03,
-7.101536244068723004e-03,
-7.126828937374781944e-03,
-7.151857900887070851e-03,
-7.176622437718472268e-03,
-7.201121860622881551e-03,
-7.225355492012937482e-03,
-7.249322663977078932e-03,
-7.273022718296585053e-03,
-7.296455006462264185e-03,
-7.319618889690427191e-03,
-7.342513738939051605e-03,
-7.365138934923109656e-03,
-7.387493868129770512e-03,
-7.409577938833420384e-03,
-7.431390557109923689e-03,
-7.452931142850768853e-03,
-7.474199125777057987e-03,
-7.495193945452767112e-03,
-7.515915051297784345e-03,
-7.536361902600756391e-03,
-7.556533968531464057e-03,
-7.576430728152719861e-03,
-7.596051670432153735e-03,
-7.615396294253566796e-03,
-7.634464108427718720e-03,
-7.653254631703155890e-03,
-7.671767392776334370e-03,
-7.690001930301545996e-03,
-7.707957792900550428e-03,
-7.725634539171729286e-03,
-7.743031737698866449e-03,
-7.760148967059764431e-03,
-7.776985815834371561e-03,
-7.793541882612486753e-03,
-7.809816776001235299e-03,
-7.825810114632203787e-03,
-7.841521527168129196e-03,
-7.856950652309268798e-03,
-7.872097138799450874e-03,
-7.886960645431664862e-03,
-7.901540841053546552e-03,
-7.915837404572127756e-03,
-7.929850024958629354e-03,
-7.943578401252591667e-03,
-7.957022242565919834e-03,
-7.970181268086183254e-03,
-7.983055207080130139e-03,
-7.995643798896279186e-03,
-8.007946792967589322e-03,
-8.019963948813433816e-03,
-8.031695036041525820e-03,
-8.043139834349257583e-03,
-8.054298133524899136e-03,
-8.065169733448195044e-03,
-8.075754444090784204e-03,
-8.086052085516338625e-03,
-8.096062487880075972e-03,
-8.105785491428155881e-03,
-8.115220946496685961e-03,
-8.124368713510363507e-03,
-8.133228662980647103e-03,
-8.141800675503707910e-03,
-8.150084641758138099e-03,
-8.158080462501987942e-03,
-8.165788048569768212e-03,
-8.173207320868961651e-03,
-8.180338210376118108e-03,
-8.187180658132816105e-03,
-8.193734615241067554e-03,
-8.200000042858432772e-03,
-8.205976912192877032e-03,
-8.211665204497207299e-03,
-8.217064911063064886e-03,
-8.222176033214883412e-03,
-8.226998582303078275e-03,
-8.231532579697262153e-03,
-8.235778056778851608e-03,
-8.239735054933581757e-03,
-8.243403625543368682e-03,
-8.246783829978147559e-03,
-8.249875739587145262e-03,
-8.252679435689870210e-03,
-8.255195009566842004e-03,
-8.257422562449866568e-03,
-8.259362205512025060e-03,
-8.261014059857326244e-03,
-8.262378256510050090e-03,
-8.263454936403622983e-03,
-8.264244250369314274e-03,
-8.264746359124563319e-03,
-8.264961433260812132e-03,
-8.264889653231254768e-03,
-8.264531209338087103e-03,
-8.263886301719387123e-03,
-8.262955140335807858e-03,
-8.261737944956878271e-03,
-8.260234945146839244e-03,
-8.258446380250422311e-03,
-8.256372499378014304e-03,
-8.254013561390643322e-03,
-8.251369834884629897e-03,
-8.248441598175939790e-03,
-8.245229139284018099e-03,
-8.241732755915571335e-03,
-8.237952755447777026e-03,
-8.233889454911364966e-03,
-8.229543180973237018e-03,
-8.224914269918840587e-03,
-8.220003067634115354e-03,
-8.214809929587301232e-03,
-8.209335220810239780e-03,
-8.203579315879462250e-03,
-8.197542598896925478e-03,
-8.191225463470360943e-03,
-8.184628312693521465e-03,
-8.177751559125794739e-03,
-8.170595624771782167e-03,
-8.163160941060438811e-03,
-8.155447948823845578e-03,
-8.147457098275801002e-03,
-8.139188848989988012e-03,
-8.130643669877930801e-03,
-8.121822039166469442e-03,
-8.112724444375168584e-03,
-8.103351382293191851e-03,
-8.093703358956044411e-03,
-8.083780889621883584e-03,
-8.073584498747501600e-03,
-8.063114719964209476e-03,
-8.052372096053216077e-03,
-8.041357178920738313e-03,
-8.030070529572871929e-03,
-8.018512718090130970e-03,
-8.006684323601673259e-03,
-7.994585934259204954e-03,
-7.982218147210796630e-03,
-7.969581568573969044e-03,
-7.956676813408933291e-03,
-7.943504505691303605e-03,
-7.930065278284558622e-03,
-7.916359772912209478e-03,
-7.902388640129695552e-03,
-7.888152539295990515e-03,
-7.873652138544852755e-03,
-7.858888114756001214e-03,
-7.843861153525638966e-03,
-7.828571949137034039e-03,
-7.813021204530744626e-03,
-7.797209631274335147e-03,
-7.781137949532133079e-03,
-7.764806888034528690e-03,
-7.748217184046874914e-03,
-7.731369583338530346e-03,
-7.714264840151144158e-03,
-7.696903717166927138e-03,
-7.679286985476664260e-03,
-7.661415424547342139e-03,
-7.643289822189525823e-03,
-7.624910974524575988e-03,
-7.606279685951427248e-03,
-7.587396769113329172e-03,
-7.568263044864044324e-03,
-7.548879342233975193e-03,
-7.529246498396003143e-03,
-7.509365358631042014e-03,
-7.489236776293269060e-03,
-7.468861612775175469e-03,
-7.448240737472515416e-03,
-7.427375027748503097e-03,
-7.406265368898326366e-03,
-7.384912654113139942e-03,
-7.363317784443742034e-03,
-7.341481668764099182e-03,
-7.319405223734733179e-03,
-7.297089373765536409e-03,
-7.274535050978740702e-03,
-7.251743195171365779e-03,
-7.228714753777398805e-03,
-7.205450681830074568e-03,
-7.181951941923503391e-03,
-7.158219504174272163e-03,
-7.134254346182732250e-03,
-7.110057452994258780e-03,
-7.085629817059972170e-03,
-7.060972438197343423e-03,
-7.036086323550706616e-03,
-7.010972487551391484e-03,
-6.985631951877554167e-03,
-6.960065745414088616e-03,
-6.934274904211936916e-03,
-6.908260471447484619e-03,
-6.882023497381561418e-03,
-6.855565039318264886e-03,
-6.828886161563469358e-03,
-6.801987935383554257e-03,
-6.774871438963152304e-03,
-6.747537757363346149e-03,
-6.719987982479443470e-03,
-6.692223212998457162e-03,
-6.664244554356384305e-03,
-6.636053118695479057e-03,
-6.607650024821048497e-03,
-6.579036398158182551e-03,
-6.550213370708371161e-03,
-6.521182081005665217e-03,
-6.491943674072945050e-03,
-6.462499301377766514e-03,
-6.432850120788078697e-03,
-6.402997296527635461e-03,
-6.372941999131759121e-03,
-6.342685405401934061e-03,
-6.312228698361075155e-03,
-6.281573067208350361e-03,
-6.250719707273597395e-03,
-6.219669819971759481e-03,
-6.188424612757230034e-03,
-6.156985299077714219e-03,
-6.125353098328261379e-03,
-6.093529235804864656e-03,
-6.061514942657885395e-03,
-6.029311455845621538e-03,
-5.996920018087273201e-03,
-5.964341877815992378e-03,
-5.931578289131684591e-03,
-5.898630511753797517e-03,
-5.865499810973720182e-03,
-5.832187457606990456e-03,
-5.798694727945759297e-03,
-5.765022903710618346e-03,
-5.731173272002380685e-03,
-5.697147125254025529e-03,
-5.662945761181951629e-03,
-5.628570482737661751e-03,
-5.594022598058855621e-03,
-5.559303420420428320e-03,
-5.524414268185646494e-03,
-5.489356464756827564e-03,
-5.454131338525939135e-03,
-5.418740222825205351e-03,
-5.383184455877518954e-03,
-5.347465380746665130e-03,
-5.311584345287254788e-03,
-5.275542702094978761e-03,
-5.239341808456299959e-03,
-5.202983026298047507e-03,
-5.166467722137317066e-03,
-5.129797267030509859e-03,
-5.092973036523065593e-03,
-5.055996410598454643e-03,
-5.018868773627240508e-03,
-4.981591514316032962e-03,
-4.944166025656675408e-03,
-4.906593704874445162e-03,
-4.868875953376990140e-03,
-4.831014176702883023e-03,
-4.793009784469877063e-03,
-4.754864190323154077e-03,
-4.716578811883732902e-03,
-4.678155070696266363e-03,
-4.639594392177254570e-03,
-4.600898205562835817e-03,
-4.562067943856446504e-03,
-4.523105043776710042e-03,
-4.484010945704936316e-03,
-4.444787093632503183e-03,
-4.405434935108289152e-03,
-4.365955921186367994e-03,
-4.326351506372581000e-03,
-4.286623148572106697e-03,
-4.246772309036463307e-03,
-4.206800452310467849e-03,
-4.166709046178954969e-03,
-4.126499561613912979e-03,
-4.086173472720864425e-03,
-4.045732256685839918e-03,
-4.005177393721881876e-03,
-3.964510367015356557e-03,
-3.923732662672737952e-03,
-3.882845769666851739e-03,
-3.841851179783077174e-03,
-3.800750387565728083e-03,
-3.759544890264346264e-03,
-3.718236187779754183e-03,
-3.676825782609951555e-03,
-3.635315179796496775e-03,
-3.593705886870298544e-03,
-3.551999413797409660e-03,
-3.510197272925242359e-03,
-3.468300978927987832e-03,
-3.426312048752790367e-03,
-3.384232001565296109e-03,
-3.342062358695204859e-03,
-3.299804643582263802e-03,
-3.257460381721701340e-03,
-3.215031100609725984e-03,
-3.172518329689179208e-03,
-3.129923600295167908e-03,
-3.087248445600417144e-03,
-3.044494400560634161e-03,
-3.001663001860180747e-03,
-2.958755787857402994e-03,
-2.915774298529815334e-03,
-2.872720075419841427e-03,
-2.829594661579767478e-03,
-2.786399601517409834e-03,
-2.743136441141296421e-03,
-2.699806727705881572e-03,
-2.656412009756850198e-03,
-2.612953837076816607e-03,
-2.569433760629941717e-03,
-2.525853332507581577e-03,
-2.482214105873634460e-03,
-2.438517634909659858e-03,
-2.394765474760032157e-03,
-2.350959181477550557e-03,
-2.307100311968326035e-03,
-2.263190423937401670e-03,
-2.219231075833899818e-03,
-2.175223826796167121e-03,
-2.131170236597403067e-03,
-2.087071865590822348e-03,
-2.042930274654848870e-03,
-1.998747025138782486e-03,
-1.954523678808036367e-03,
-1.910261797789365073e-03,
-1.865962944516660286e-03,
-1.821628681675996732e-03,
-1.777260572151452859e-03,
-1.732860178970473770e-03,
-1.688429065249311785e-03,
-1.643968794138628330e-03,
-1.599480928769480507e-03,
-1.554967032198334691e-03,
-1.510428667353100156e-03,
-1.465867396978913105e-03,
-1.421284783583796245e-03,
-1.376682389384289301e-03,
-1.332061776251691450e-03,
-1.287424505657525087e-03,
-1.242772138619859575e-03,
-1.198106235649155568e-03,
-1.153428356694151174e-03,
-1.108740061088301938e-03,
-1.064042907495777813e-03,
-1.019338453857582651e-03,
-9.746282573379494050e-04,
-9.299138742707950675e-04,
-8.851968601060221983e-04,
-8.404787693558401834e-04,
-7.957611555416282696e-04,
-7.510455711403962514e-04,
-7.063335675313077173e-04,
-6.616266949428156524e-04,
-6.169265023990716263e-04,
-5.722345376672119920e-04,
-5.275523472041916467e-04,
-4.828814761036936878e-04,
-4.382234680436028528e-04,
-3.935798652330907074e-04,
-3.489522083598248117e-04,
-3.043420365374958285e-04,
-2.597508872534213392e-04,
-2.151802963160355747e-04,
-1.706317978024115092e-04,
-1.261069240063661466e-04,
-8.160720538617621258e-05,
-3.713417051239320700e-05,
 7.310653983705088637e-06,
 5.172574346236636760e-05,
 9.610957532670665602e-05,
 1.404606290744316998e-04,
 1.847773863497182052e-04,
 2.290583309940219601e-04,
 2.733019490974734011e-04,
 3.175067290506943863e-04,
 3.616711615950029906e-04,
 4.057937398737899428e-04,
 4.498729594834496468e-04,
 4.939073185237722718e-04,
 5.378953176486954727e-04,
 5.818354601169213993e-04,
 6.257262518419496981e-04,
 6.695662014424009741e-04,
 7.133538202925205534e-04,
 7.570876225713017325e-04,
 8.007661253129485590e-04,
 8.443878484566738878e-04,
 8.879513148957390379e-04,
 9.314550505269920738e-04,
 9.748975843007780771e-04,
 1.018277448269265615e-03,
 1.061593177635863266e-03,
 1.104843310804208426e-03,
 1.148026389426561652e-03,
 1.191140958452559977e-03,
 1.234185566177799795e-03,
 1.277158764291809988e-03,
 1.320059107926288512e-03,
 1.362885155703510076e-03,
 1.405635469783307655e-03,
 1.448308615911498599e-03,
 1.490903163466976520e-03,
 1.533417685509523738e-03,
 1.575850758826466890e-03,
 1.618200963979818689e-03,
 1.660466885353755785e-03,
 1.702647111200529745e-03,
 1.744740233687412352e-03,
 1.786744848943194654e-03,
 1.828659557104074301e-03,
 1.870482962359864675e-03,
 1.912213673000015589e-03,
 1.953850301459000589e-03,
 1.995391464361956878e-03,
 2.036835782570415448e-03,
 2.078181881226687667e-03,
 2.119428389799437977e-03,
 2.160573942128611504e-03,
 2.201617176469553711e-03,
 2.242556735537552023e-03,
 2.283391266552714863e-03,
 2.324119421283227412e-03,
 2.364739856089650809e-03,
 2.405251231968704839e-03,
 2.445652214596499840e-03,
 2.485941474371975487e-03,
 2.526117686460202950e-03,
 2.566179530834985373e-03,
 2.606125692321721588e-03,
 2.645954860640292814e-03,
 2.685665730446669570e-03,
 2.725257001375590207e-03,
 2.764727378082610602e-03,
 2.804075570285303846e-03,
 2.843300292805138203e-03,
 2.882400265608877146e-03,
 2.921374213849412156e-03,
 2.960220867906847905e-03,
 2.998938963429289509e-03,
 3.037527241373109803e-03,
 3.075984448043331525e-03,
 3.114309335133829976e-03,
 3.152500659766927643e-03,
 3.190557184533110262e-03,
 3.228477677530780174e-03,
 3.266260912404953670e-03,
 3.303905668386299208e-03,
 3.341410730330489180e-03,
 3.378774888756009946e-03,
 3.415996939882809304e-03,
 3.453075685670534568e-03,
 3.490009933856074147e-03,
 3.526798497991368454e-03,
 3.563440197480956251e-03,
 3.599933857618892175e-03,
 3.636278309625829482e-03,
 3.672472390685894202e-03,
 3.708514943982909196e-03,
 3.744404818736712763e-03,
 3.780140870239560944e-03,
 3.815721959891366262e-03,
 3.851146955235381416e-03,
 3.886414729994040838e-03,
 3.921524164103316890e-03,
 3.956474143747935185e-03,
 3.991263561396040868e-03,
 4.025891315833313687e-03,
 4.060356312197196255e-03,
 4.094657462010889426e-03,
 4.128793683216757000e-03,
 4.162763900209755577e-03,
 4.196567043870915587e-03,
 4.230202051599536023e-03,
 4.263667867346368837e-03,
 4.296963441646063468e-03,
 4.330087731648829888e-03,
 4.363039701152633329e-03,
 4.395818320634907635e-03,
 4.428422567283673596e-03,
 4.460851425028817749e-03,
 4.493103884573028568e-03,
 4.525178943422227852e-03,
 4.557075605915989966e-03,
 4.588792883257804094e-03,
 4.620329793544647803e-03,
 4.651685361796645615e-03,
 4.682858619986702414e-03,
 4.713848607068965926e-03,
 4.744654369008005634e-03,
 4.775274958807516380e-03,
 4.805709436538106033e-03,
 4.835956869365551532e-03,
 4.866016331578675892e-03,
 4.895886904616514844e-03,
 4.925567677095672552e-03,
 4.955057744837382434e-03,
 4.984356210893888840e-03,
 5.013462185575010867e-03,
 5.042374786474377452e-03,
 5.071093138495033625e-03,
 5.099616373875087531e-03,
 5.127943632213308005e-03,
 5.156074060493741167e-03,
 5.184006813110581154e-03,
 5.211741051893022635e-03,
 5.239275946128976215e-03,
 5.266610672589243543e-03,
 5.293744415551263939e-03,
 5.320676366822277292e-03,
 5.347405725762565017e-03,
 5.373931699308358810e-03,
 5.400253501994163943e-03,
 5.426370355975174489e-03,
 5.452281491049349414e-03,
 5.477986144678897995e-03,
 5.503483562011805136e-03,
 5.528772995903173670e-03,
 5.553853706935773030e-03,
 5.578724963440631276e-03,
 5.603386041517751173e-03,
 5.627836225055627556e-03,
 5.652074805751183643e-03,
 5.676101083129289279e-03,
 5.699914364561757020e-03,
 5.723513965286300062e-03,
 5.746899208425205671e-03,
 5.770069425003398859e-03,
 5.793023953966610143e-03,
 5.815762142199262276e-03,
 5.838283344541454929e-03,
 5.860586923806479324e-03,
 5.882672250797681482e-03,
 5.904538704324800713e-03,
 5.926185671220367962e-03,
 5.947612546355769345e-03,
 5.968818732656783199e-03,
 5.989803641119087647e-03,
 6.010566690823426414e-03,
 6.031107308950281118e-03,
 6.051424930794470705e-03,
 6.071518999779508888e-03,
 6.091388967471352694e-03,
 6.111034293592108521e-03,
 6.130454446033634097e-03,
 6.149648900870147324e-03,
 6.168617142371372007e-03,
 6.187358663014968889e-03,
 6.205872963498559880e-03,
 6.224159552751679439e-03,
 6.242217947947528191e-03,
 6.260047674514048269e-03,
 6.277648266145029014e-03,
 6.295019264810897824e-03,
 6.312160220768997521e-03,
 6.329070692573737084e-03,
 6.345750247086559374e-03,
 6.362198459485234048e-03,
 6.378414913273239804e-03,
 6.394399200288775412e-03,
 6.410150920713220818e-03,
 6.425669683079451681e-03,
 6.440955104280241504e-03,
 6.456006809575557011e-03,
 6.470824432600300220e-03,
 6.485407615371427750e-03,
 6.499756008294696290e-03,
 6.513869270171348223e-03,
 6.527747068204360972e-03,
 6.541389078004332044e-03,
 6.554794983595226172e-03,
 6.567964477419838826e-03,
 6.580897260344645630e-03,
 6.593593041664774952e-03,
 6.606051539108486956e-03,
 6.618272478841292703e-03,
 6.630255595469773146e-03,
 6.642000632045462309e-03,
 6.653507340067833613e-03,
 6.664775479487444060e-03,
 6.675804818708704590e-03,
 6.686595134592149964e-03,
 6.697146212456646201e-03,
 6.707457846081225049e-03,
 6.717529837706530740e-03,
 6.727361998036060324e-03,
 6.736954146237270416e-03,
 6.746306109941899859e-03,
 6.755417725246546518e-03,
 6.764288836712718453e-03,
 6.772919297366427130e-03,
 6.781308968697770216e-03,
 6.789457720660085904e-03,
 6.797365431668761157e-03,
 6.805031988599864745e-03,
 6.812457286788422932e-03,
 6.819641230026336071e-03,
 6.826583730560172904e-03,
 6.833284709088562406e-03,
 6.839744094759197916e-03,
 6.845961825165754536e-03,
 6.851937846344421414e-03,
 6.857672112770065408e-03,
 6.863164587352167494e-03,
 6.868415241430599581e-03,
 6.873424054770853157e-03,
 6.878191015559132621e-03,
 6.882716120397189274e-03,
 6.886999374296765876e-03,
 6.891040790673802659e-03,
 6.894840391342384016e-03,
 6.898398206508320890e-03,
 6.901714274762464282e-03,
 6.904788643073838349e-03,
 6.907621366782335480e-03,
 6.910212509591190204e-03,
 6.912562143559207624e-03,
 6.914670349092657056e-03,
 6.916537214936804845e-03,
 6.918162838167385593e-03,
 6.919547324181552113e-03,
 6.920690786688650162e-03,
 6.921593347700764204e-03,
 6.922255137522799993e-03,
 6.922676294742526396e-03,
 6.922856966220088983e-03,
 6.922797307077469854e-03,
 6.922497480687494695e-03,
 6.921957658662647277e-03,
 6.921178020843555233e-03,
 6.920158755287243377e-03,
 6.918900058255136355e-03,
 6.917402134200631957e-03,
 6.915665195756572070e-03,
 6.913689463722363232e-03,
 6.911475167050803135e-03,
 6.909022542834677288e-03,
 6.906331836293051231e-03,
 6.903403300757206262e-03,
 6.900237197656595121e-03,
 6.896833796504112449e-03,
 6.893193374881395608e-03,
 6.889316218423775090e-03,
 6.885202620804891857e-03,
 6.880852883721138603e-03,
 6.876267316875729792e-03,
 6.871446237962625103e-03,
 6.866389972650062574e-03,
 6.861098854563938212e-03,
 6.855573225270810041e-03,
 6.849813434260680969e-03,
 6.843819838929652427e-03,
 6.837592804562022883e-03,
 6.831132704312368152e-03,
 6.824439919187302514e-03,
 6.817514838026905895e-03,
 6.810357857486005334e-03,
 6.802969382015039250e-03,
 6.795349823840840173e-03,
 6.787499602947032369e-03,
 6.779419147054295026e-03,
 6.771108891600118897e-03,
 6.762569279718645340e-03,
 6.753800762220058679e-03,
 6.744803797569659358e-03,
 6.735578851866829558e-03,
 6.726126398823781098e-03,
 6.716446919743777715e-03,
 6.706540903499473572e-03,
 6.696408846510721810e-03,
 6.686051252722231310e-03,
 6.675468633581092479e-03,
 6.664661508013801708e-03,
 6.653630402403252868e-03,
 6.642375850565436501e-03,
 6.630898393725916974e-03,
 6.619198580495818697e-03,
 6.607276966848027455e-03,
 6.595134116092807135e-03,
 6.582770598853190068e-03,
 6.570186993040347430e-03,
 6.557383883828532024e-03,
 6.544361863629765200e-03,
 6.531121532068494273e-03,
 6.517663495955828418e-03,
 6.503988369263496126e-03,
 6.490096773097868595e-03,
 6.475989335673465290e-03,
 6.461666692286146402e-03,
 6.447129485286573307e-03,
 6.432378364052904023e-03,
 6.417413984963501669e-03,
 6.402237011369443440e-03,
 6.386848113566725993e-03,
 6.371247968768246200e-03,
 6.355437261075630104e-03,
 6.339416681450814675e-03,
 6.323186927687332072e-03,
 6.306748704381460319e-03,
 6.290102722903216127e-03,
 6.273249701366842915e-03,
 6.256190364601539947e-03,
 6.238925444121603409e-03,
 6.221455678096378394e-03,
 6.203781811320301098e-03,
 6.185904595182402377e-03,
 6.167824787635738451e-03,
 6.149543153166621250e-03,
 6.131060462763654462e-03,
 6.112377493886431319e-03,
 6.093495030434251461e-03,
 6.074413862714446617e-03,
 6.055134787410531086e-03,
 6.035658607550299301e-03,
 6.015986132473565180e-03,
 5.996118177799611773e-03,
 5.976055565394830862e-03,
 5.955799123339871638e-03,
 5.935349685896335742e-03,
 5.914708093474063851e-03,
 5.893875192597413520e-03,
 5.872851835871784228e-03,
 5.851638881949887405e-03,
 5.830237195497769281e-03,
 5.808647647160703614e-03,
 5.786871113528757431e-03,
 5.764908477102479931e-03,
 5.742760626258068372e-03,
 5.720428455212475845e-03,
 5.697912863988505161e-03,
 5.675214758379520247e-03,
 5.652335049913827063e-03,
 5.629274655819525505e-03,
 5.606034498988434964e-03,
 5.582615507940102278e-03,
 5.559018616786007456e-03,
 5.535244765193075497e-03,
 5.511294898347202965e-03,
 5.487169966916853082e-03,
 5.462870927016082699e-03,
 5.438398740167652533e-03,
 5.413754373265985617e-03,
 5.388938798539878554e-03,
 5.363952993514991587e-03,
 5.338797940976386380e-03,
 5.313474628930733336e-03,
 5.287984050568284716e-03,
 5.262327204225020379e-03,
 5.236505093344458704e-03,
 5.210518726438943642e-03,
 5.184369117051558853e-03,
 5.158057283717254297e-03,
 5.131584249923997962e-03,
 5.104951044073938009e-03,
 5.078158699444293434e-03,
 5.051208254147947219e-03,
 5.024100751094270206e-03,
 4.996837237949561597e-03,
 4.969418767097050563e-03,
 4.941846395597707976e-03,
 4.914121185149825620e-03,
 4.886244202048923256e-03,
 4.858216517147876876e-03,
 4.830039205816460610e-03,
 4.801713347900548635e-03,
 4.773240027681999696e-03,
 4.744620333837661248e-03,
 4.715855359398496774e-03,
 4.686946201708766004e-03,
 4.657893962384831305e-03,
 4.628699747273872997e-03,
 4.599364666412680998e-03,
 4.569889833986226155e-03,
 4.540276368285730245e-03,
 4.510525391667553896e-03,
 4.480638030510998571e-03,
 4.450615415176297635e-03,
 4.420458679962983861e-03,
 4.390168963067502331e-03,
 4.359747406540913535e-03,
 4.329195156246743934e-03,
 4.298513361818440993e-03,
 4.267703176616687716e-03,
 4.236765757686999923e-03,
 4.205702265716817004e-03,
 4.174513864992584859e-03,
 4.143201723356988025e-03,
 4.111767012165847002e-03,
 4.080210906244747561e-03,
 4.048534583846148845e-03,
 4.016739226606062980e-03,
 3.984826019500159640e-03,
 3.952796150800858520e-03,
 3.920650812033510228e-03,
 3.888391197932561990e-03,
 3.856018506398098053e-03,
 3.823533938451900444e-03,
 3.790938698193385692e-03,
 3.758233992755888059e-03,
 3.725421032262469633e-03,
 3.692501029781640638e-03,
 3.659475201283434505e-03,
 3.626344765595013262e-03,
 3.593110944356045673e-03,
 3.559774961974752384e-03,
 3.526338045583284498e-03,
 3.492801424992763443e-03,
 3.459166332649254126e-03,
 3.425434003588802637e-03,
 3.391605675392603183e-03,
 3.357682588142465140e-03,
 3.323665984375805214e-03,
 3.289557109040659125e-03,
 3.255357209450969978e-03,
 3.221067535241439045e-03,
 3.186689338322209585e-03,
 3.152223872834365986e-03,
 3.117672395104289281e-03,
 3.083036163598390413e-03,
 3.048316438878282807e-03,
 3.013514483555253254e-03,
 2.978631562244791336e-03,
 2.943668941521508740e-03,
 2.908627889873591481e-03,
 2.873509677657236534e-03,
 2.838315577051415874e-03,
 2.803046862012236774e-03,
 2.767704808227306433e-03,
 2.732290693070368523e-03,
 2.696805795555646135e-03,
 2.661251396291865103e-03,
 2.625628777437285198e-03,
 2.589939222653528730e-03,
 2.554184017059778645e-03,
 2.518364447187545607e-03,
 2.482481800934628873e-03,
 2.446537367519292707e-03,
 2.410532437434731619e-03,
 2.374468302403188666e-03,
 2.338346255330031251e-03,
 2.302167590258195982e-03,
 2.265933602322244955e-03,
 2.229645587702456296e-03,
 2.193304843579210479e-03,
 2.156912668087114255e-03,
 2.120470360268848775e-03,
 2.083979220029832588e-03,
 2.047440548092295705e-03,
 2.010855645948924318e-03,
 1.974225815817752788e-03,
 1.937552360595998311e-03,
 1.900836583814144746e-03,
 1.864079789590423900e-03,
 1.827283282584888074e-03,
 1.790448367953500174e-03,
 1.753576351302636900e-03,
 1.716668538643245211e-03,
 1.679726236344770019e-03,
 1.642750751090128790e-03,
 1.605743389829516077e-03,
 1.568705459734606169e-03,
 1.531638268153382625e-03,
 1.494543122564397954e-03,
 1.457421330530673988e-03,
 1.420274199654805941e-03,
 1.383103037533093931e-03,
 1.345909151709942953e-03,
 1.308693849632633225e-03,
 1.271458438605769592e-03,
 1.234204225745722493e-03,
 1.196932517935541621e-03,
 1.159644621779514851e-03,
 1.122341843557540884e-03,
 1.085025489180590878e-03,
 1.047696864144956634e-03,
 1.010357273487016375e-03,
 9.730080217386040051e-04,
 9.356504128816294950e-04,
 8.982857503029848586e-04,
 8.609153367498366405e-04,
 8.235404742845856647e-04,
 7.861624642398756801e-04,
 7.487826071740569375e-04,
 7.114022028263114949e-04,
 6.740225500718343603e-04,
 6.366449468774720583e-04,
 5.992706902570754017e-04,
 5.619010762266812842e-04,
 5.245373997605741944e-04,
 4.871809547468279643e-04,
 4.498330339424663651e-04,
 4.124949289299474067e-04,
 3.751679300726488693e-04,
 3.378533264706862519e-04,
 3.005524059171712321e-04,
 2.632664548541371126e-04,
 2.259967583285409760e-04,
 1.887445999487515882e-04,
 1.515112618407108498e-04,
 1.142980246041755041e-04,
 7.710616726944776725e-05,
 3.993696725382956747e-05,
 2.791700317938687076e-06,
-3.432835947708023786e-05,
-7.142193981283992941e-05,
-1.084877701573526122e-04,
-1.455245818073255273e-04,
-1.825311079314393032e-04,
-2.195060836132626983e-04,
-2.564482458937150525e-04,
-2.933563338138312740e-04,
-3.302290884574314556e-04,
-3.670652529932863376e-04,
-4.038635727175385608e-04,
-4.406227950962912122e-04,
-4.773416698070177345e-04,
-5.140189487811164812e-04,
-5.506533862459150408e-04,
-5.872437387659844646e-04,
-6.237887652851423432e-04,
-6.602872271681299718e-04,
-6.967378882418101896e-04,
-7.331395148366647843e-04,
-7.694908758281665626e-04,
-8.057907426776331726e-04,
-8.420378894733750695e-04,
-8.782310929717124020e-04,
-9.143691326374758181e-04,
-9.504507906847409161e-04,
-9.864748521176999567e-04,
-1.022440104770359166e-03,
-1.058345339347336938e-03,
-1.094189349464083291e-03,
-1.129970931686433621e-03,
-1.165688885570777744e-03,
-1.201342013703910611e-03,
-1.236929121742405546e-03,
-1.272449018452201722e-03,
-1.307900515748111831e-03,
-1.343282428732765982e-03,
-1.378593575735820786e-03,
-1.413832778353032917e-03,
-1.448998861484787756e-03,
-1.484090653374855280e-03,
-1.519106985649195177e-03,
-1.554046693353863806e-03,
-1.588908614993314291e-03,
-1.623691592568998667e-03,
-1.658394471616608931e-03,
-1.693016101244206473e-03,
-1.727555334169925648e-03,
-1.762011026759215462e-03,
-1.796382039062291176e-03,
-1.830667234851415890e-03,
-1.864865481657696205e-03,
-1.898975650808049824e-03,
-1.932996617462059107e-03,
-1.966927260648223749e-03,
-2.000766463300492765e-03,
-2.034513112294727716e-03,
-2.068166098484336760e-03,
-2.101724316736266682e-03,
-2.135186665967208318e-03,
-2.168552049178547325e-03,
-2.201819373492050046e-03,
-2.234987550185233221e-03,
-2.268055494726151262e-03,
-2.301022126808427697e-03,
-2.333886370386117903e-03,
-2.366647153708011098e-03,
-2.399303409352086715e-03,
-2.431854074260057091e-03,
-2.464298089770759585e-03,
-2.496634401654481122e-03,
-2.528861960146735859e-03,
-2.560979719981296490e-03,
-2.592986640423843546e-03,
-2.624881685305131569e-03,
-2.656663823053748933e-03,
-2.688332026728997796e-03,
-2.719885274053602739e-03,
-2.751322547445894662e-03,
-2.782642834052133449e-03,
-2.813845125778674950e-03,
-2.844928419323599321e-03,
-2.875891716208407896e-03,
-2.906734022809816763e-03,
-2.937454350390457467e-03,
-2.968051715130382625e-03,
-2.998525138158034207e-03,
-3.028873645580577780e-03,
-3.059096268514592369e-03,
-3.089192043116541740e-03,
-3.119160010612622488e-03,
-3.148999217328782557e-03,
-3.178708714720588410e-03,
-3.208287559402498920e-03,
-3.237734813177313604e-03,
-3.267049543065380160e-03,
-3.296230821333318017e-03,
-3.325277725522801740e-03,
-3.354189338479314931e-03,
-3.382964748380078417e-03,
-3.411603048762216952e-03,
-3.440103338551093754e-03,
-3.468464722087412095e-03,
-3.496686309155019445e-03,
-3.524767215008211586e-03,
-3.552706560398617795e-03,
-3.580503471602136754e-03,
-3.608157080445719388e-03,
-3.635666524333564052e-03,
-3.663030946273410169e-03,
-3.690249494902831870e-03,
-3.717321324514494697e-03,
-3.744245595082114440e-03,
-3.771021472285898159e-03,
-3.797648127537381953e-03,
-3.824124738004386695e-03,
-3.850450486636161976e-03,
-3.876624562187337870e-03,
-3.902646159242463032e-03,
-3.928514478240129927e-03,
-3.954228725496631257e-03,
-3.979788113229631996e-03,
-4.005191859581700049e-03,
-4.030439188643260111e-03,
-4.055529330475606507e-03,
-4.080461521133898692e-03,
-4.105235002689133252e-03,
-4.129849023250808937e-03,
-4.154302836989020968e-03,
-4.178595704155966400e-03,
-4.202726891107741794e-03,
-4.226695670325770517e-03,
-4.250501320437746929e-03,
-4.274143126238696792e-03,
-4.297620378711653442e-03,
-4.320932375048024306e-03,
-4.344078418667846400e-03,
-4.367057819239882240e-03,
-4.389869892701200524e-03,
-4.412513961276767240e-03,
-4.434989353498958696e-03,
-4.457295404226265315e-03,
-4.479431454662189706e-03,
-4.501396852374239289e-03,
-4.523190951311749711e-03,
-4.544813111824354442e-03,
-4.566262700679619979e-03,
-4.587539091081086970e-03,
-4.608641662685280908e-03,
-4.629569801619067178e-03,
-4.650322900496665218e-03,
-4.670900358436223809e-03,
-4.691301581076315688e-03,
-4.711525980592279512e-03,
-4.731572975712047477e-03,
-4.751441991731960787e-03,
-4.771132460532455898e-03,
-4.790643820592951040e-03,
-4.809975517007172505e-03,
-4.829127001498005611e-03,
-4.848097732431760204e-03,
-4.866887174832646053e-03,
-4.885494800396903044e-03,
-4.903920087506456922e-03,
-4.922162521242615801e-03,
-4.940221593399417993e-03,
-4.958096802496630290e-03,
-4.975787653792668186e-03,
-4.993293659297261093e-03,
-5.010614337783663927e-03,
-5.027749214800854814e-03,
-5.044697822685554126e-03,
-5.061459700573622475e-03,
-5.078034394411443976e-03,
-5.094421456967394499e-03,
-5.110620447842356695e-03,
-5.126630933480539470e-03,
-5.142452487179944437e-03,
-5.158084689102357054e-03,
-5.173527126283364655e-03,
-5.188779392642089115e-03,
-5.203841088990434662e-03,
-5.218711823042343489e-03,
-5.233391209422821530e-03,
-5.247878869676429921e-03,
-5.262174432275815508e-03,
-5.276277532629995888e-03,
-5.290187813092073719e-03,
-5.303904922967010022e-03,
-5.317428518519276039e-03,
-5.330758262979719275e-03,
-5.343893826552669792e-03,
-5.356834886422721237e-03,
-5.369581126761001875e-03,
-5.382132238731496786e-03,
-5.394487920496994493e-03,
-5.406647877224744769e-03,
-5.418611821091919543e-03,
-5.430379471290961921e-03,
-5.441950554034281212e-03,
-5.453324802559210774e-03,
-5.464501957132409000e-03,
-5.475481765054007917e-03,
-5.486263980661622124e-03,
-5.496848365334134831e-03,
-5.507234687495087509e-03,
-5.517422722615908208e-03,
-5.527412253218988089e-03,
-5.537203068880280910e-03,
-5.546794966231876484e-03,
-5.556187748964224599e-03,
-5.565381227828090915e-03,
-5.574375220636283886e-03,
-5.583169552265267177e-03,
-5.591764054656234335e-03,
-5.600158566816201659e-03,
-5.608352934818810510e-03,
-5.616347011804708085e-03,
-5.624140657981880481e-03,
-5.631733740625694332e-03,
-5.639126134078593228e-03,
-5.646317719749614598e-03,
-5.653308386113765210e-03,
-5.660098028710944772e-03,
-5.666686550144724686e-03,
-5.673073860081010583e-03,
-5.679259875246167946e-03,
-5.685244519425159022e-03,
-5.691027723459396968e-03,
-5.696609425244184531e-03,
-5.701989569726047778e-03,
-5.707168108899937121e-03,
-5.712145001805884505e-03,
-5.716920214525669265e-03,
-5.721493720179172612e-03,
-5.725865498920420724e-03,
-5.730035537933482991e-03,
-5.734003831428073628e-03,
-5.737770380634884398e-03,
-5.741335193800762952e-03,
-5.744698286183617074e-03,
-5.747859680046954640e-03,
-5.750819404654401029e-03,
-5.753577496263847027e-03,
-5.756133998121295767e-03,
-5.758488960454629865e-03,
-5.760642440467061108e-03,
-5.762594502330276557e-03,
-5.764345217177457154e-03,
-5.765894663096021375e-03,
-5.767242925120047957e-03,
-5.768390095222626635e-03,
-5.769336272307825503e-03,
-5.770081562202492714e-03,
-5.770626077647791896e-03,
-5.770969938290536339e-03,
-5.771113270674273384e-03,
-5.771056208230092993e-03,
-5.770798891267278456e-03,
-5.770341466963654388e-03,
-5.769684089355788144e-03,
-5.768826919328847759e-03,
-5.767770124606282946e-03,
-5.766513879739304863e-03,
-5.765058366096107410e-03,
-5.763403771850841330e-03,
-5.761550291972360183e-03,
-5.759498128212799800e-03,
-5.757247489095821194e-03,
-5.754798589904737242e-03,
-5.752151652670304573e-03,
-5.749306906158418301e-03,
-5.746264585857417326e-03,
-5.743024933965339314e-03,
-5.739588199376801855e-03,
-5.735954637669731827e-03,
-5.732124511091887462e-03,
-5.728098088547114129e-03,
-5.723875645581376348e-03,
-5.719457464368605908e-03,
-5.714843833696320145e-03,
-5.710035048950971338e-03,
-5.705031412103126094e-03,
-5.699833231692421828e-03,
-5.694440822812321147e-03,
-5.688854507094511480e-03,
-5.683074612693328996e-03,
-5.677101474269804354e-03,
-5.670935432975417884e-03,
-5.664576836435869511e-03,
-5.658026038734486132e-03,
-5.651283400395358363e-03,
-5.644349288366428720e-03,
-5.637224076002280565e-03,
-5.629908143046623466e-03,
-5.622401875614797644e-03,
-5.614705666175856882e-03,
-5.606819913534460617e-03,
-5.598745022812777299e-03,
-5.590481405431858668e-03,
-5.582029479093036581e-03,
-5.573389667759065698e-03,
-5.564562401635037188e-03,
-5.555548117148957632e-03,
-5.546347256932469307e-03,
-5.536960269801018825e-03,
-5.527387610733961593e-03,
-5.517629740854538764e-03,
-5.507687127409508984e-03,
-5.497560243748650897e-03,
-5.487249569304123407e-03,
-5.476755589569555320e-03,
-5.466078796078850492e-03,
-5.455219686385071043e-03,
-5.444178764038858261e-03,
-5.432956538566696518e-03,
-5.421553525449183258e-03,
-5.409970246098881781e-03,
-5.398207227838059535e-03,
-5.386265003876284166e-03,
-5.374144113287762821e-03,
-5.361845100988515793e-03,
-5.349368517713386229e-03,
-5.336714919992844273e-03,
-5.323884870129526672e-03,
-5.310878936174783307e-03,
-5.297697691904897609e-03,
-5.284341716797013797e-03,
-5.270811596005200300e-03,
-5.257107920336114189e-03,
-5.243231286224355955e-03,
-5.229182295708024661e-03,
-5.214961556403790825e-03,
-5.200569681481813193e-03,
-5.186007289640676317e-03,
-5.171275005081935223e-03,
-5.156373457484576817e-03,
-5.141303281979350305e-03,
-5.126065119122860843e-03,
-5.110659614871465410e-03,
-5.095087420555121857e-03,
-5.079349192850967330e-03,
-5.063445593756649502e-03,
-5.047377290563756676e-03,
-5.031144955830874933e-03,
-5.014749267356379860e-03,
-4.998190908151411288e-03,
-4.981470566412372729e-03,
-4.964588935493342327e-03,
-4.947546713878460400e-03,
-4.930344605154042027e-03,
-4.912983317980409471e-03,
-4.895463566063884206e-03,
-4.877786068128373009e-03,
-4.859951547886717273e-03,
-4.841960734012339812e-03,
-4.823814360110226414e-03,
-4.805513164687893503e-03,
-4.787057891126509333e-03,
-4.768449287651493028e-03,
-4.749688107303068514e-03,
-4.730775107906834941e-03,
-4.711711052043954587e-03,
-4.692496707021306945e-03,
-4.673132844841568212e-03,
-4.653620242173053985e-03,
-4.633959680319325175e-03,
-4.614151945188955245e-03,
-4.594197827264898462e-03,
-4.574098121573604014e-03,
-4.553853627654556868e-03,
-4.533465149529050144e-03,
-4.512933495668993052e-03,
-4.492259478965969499e-03,
-4.471443916699681734e-03,
-4.450487630506389652e-03,
-4.429391446347472408e-03,
-4.408156194477506028e-03,
-4.386782709412401747e-03,
-4.365271829897467148e-03,
-4.343624398875207092e-03,
-4.321841263453010153e-03,
-4.299923274870868888e-03,
-4.277871288468871117e-03,
-4.255686163654327780e-03,
-4.233368763869363970e-03,
-4.210919956557983464e-03,
-4.188340613132744694e-03,
-4.165631608942124524e-03,
-4.142793823237044155e-03,
-4.119828139137546828e-03,
-4.096735443599462505e-03,
-4.073516627380817552e-03,
-4.050172585008088300e-03,
-4.026704214742578627e-03,
-4.003112418546494848e-03,
-3.979398102048788133e-03,
-3.955562174511448835e-03,
-3.931605548795043606e-03,
-3.907529141324321900e-03,
-3.883333872054159450e-03,
-3.859020664434970483e-03,
-3.834590445377801179e-03,
-3.810044145220108352e-03,
-3.785382697690729305e-03,
-3.760607039874977464e-03,
-3.735718112179840789e-03,
-3.710716858298840175e-03,
-3.685604225176778142e-03,
-3.660381162974708259e-03,
-3.635048625034529874e-03,
-3.609607567843351687e-03,
-3.584058950998464648e-03,
-3.558403737171414102e-03,
-3.532642892072276625e-03,
-3.506777384414233069e-03,
-3.480808185877566976e-03,
-3.454736271073653459e-03,
-3.428562617509220856e-03,
-3.402288205550159199e-03,
-3.375914018385334312e-03,
-3.349441041990512940e-03,
-3.322870265092074931e-03,
-3.296202679130518995e-03,
-3.269439278224235603e-03,
-3.242581059132984556e-03,
-3.215629021221136623e-03,
-3.188584166421351042e-03,
-3.161447499197880904e-03,
-3.134220026509443140e-03,
-3.106902757772898611e-03,
-3.079496704826179768e-03,
-3.052002881891233491e-03,
-3.024422305537325609e-03,
-2.996755994643815913e-03,
-2.969004970363028125e-03,
-2.941170256083290319e-03,
-2.913252877391622753e-03,
-2.885253862036404882e-03,
-2.857174239890283938e-03,
-2.829015042912739596e-03,
-2.800777305112483843e-03,
-2.772462062510372156e-03,
-2.744070353101861481e-03,
-2.715603216819092655e-03,
-2.687061695493841041e-03,
-2.658446832819667035e-03,
-2.629759674314175420e-03,
-2.601001267281559653e-03,
-2.572172660774762337e-03,
-2.543274905557640474e-03,
-2.514309054067365330e-03,
-2.485276160376539544e-03,
-2.456177280155086122e-03,
-2.427013470632891599e-03,
-2.397785790561519827e-03,
-2.368495300176185099e-03,
-2.339143061158176738e-03,
-2.309730136596644876e-03,
-2.280257590950501585e-03,
-2.250726490010642941e-03,
-2.221137900861748678e-03,
-2.191492891844142987e-03,
-2.161792532515914664e-03,
-2.132037893614715900e-03,
-2.102230047019522895e-03,
-2.072370065712753843e-03,
-2.042459023742025648e-03,
-2.012497996181746279e-03,
-1.982488059095505531e-03,
-1.952430289497423654e-03,
-1.922325765314248942e-03,
-1.892175565346879834e-03,
-1.861980769232540137e-03,
-1.831742457406565234e-03,
-1.801461711063749626e-03,
-1.771139612120748537e-03,
-1.740777243177608685e-03,
-1.710375687479514378e-03,
-1.679936028878809429e-03,
-1.649459351796739130e-03,
-1.618946741185152329e-03,
-1.588399282488579724e-03,
-1.557818061606006631e-03,
-1.527204164852439747e-03,
-1.496558678921360800e-03,
-1.465882690846186413e-03,
-1.435177287962096163e-03,
-1.404443557868347014e-03,
-1.373682588389944824e-03,
-1.342895467539549376e-03,
-1.312083283479644836e-03,
-1.281247124484429173e-03,
-1.250388078901738288e-03,
-1.219507235115286064e-03,
-1.188605681506627954e-03,
-1.157684506417155576e-03,
-1.126744798110420470e-03,
-1.095787644734223234e-03,
-1.064814134282495578e-03,
-1.033825354558100479e-03,
-1.002822393134637259e-03,
-9.718063373186457523e-04,
-9.407782741123305688e-04,
-9.097392901756490378e-04,
-8.786904717886333390e-04,
-8.476329048140350758e-04,
-8.165676746596979303e-04,
-7.854958662409396424e-04,
-7.544185639433437099e-04,
-7.233368515852502210e-04,
-6.922518123802773706e-04,
-6.611645289002518293e-04,
-6.300760830378660015e-04,
-5.989875559692127687e-04,
-5.679000281170404688e-04,
-5.368145791135660620e-04,
-5.057322877629800593e-04,
-4.746542320050438379e-04,
-4.435814888778529344e-04,
-4.125151344808724186e-04,
-3.814562439383414926e-04,
-3.504058913623886071e-04,
-3.193651498162206298e-04,
-2.883350912777005908e-04,
-2.573167866026539988e-04,
-2.263113054882466601e-04,
-1.953197164367568488e-04,
-1.643430867191181418e-04,
-1.333824823383446983e-04,
-1.024389679936998015e-04,
-7.151360704444580248e-05,
-4.060746147329469621e-05,
-9.721591850978506961e-06,
 2.114294270000422832e-05,
 5.198508454134074977e-05,
 8.280377755448202319e-05,
 1.135979671764772024e-04,
 1.443666004357311303e-04,
 1.751086259873432241e-04,
 2.058229941486652544e-04,
 2.365086569349976583e-04,
 2.671645680943107617e-04,
 2.977896831429220235e-04,
 3.283829594007117085e-04,
 3.589433560257759403e-04,
 3.894698340496509392e-04,
 4.199613564122667785e-04,
 4.504168879965114790e-04,
 4.808353956630409456e-04,
 5.112158482849898629e-04,
 5.415572167822562278e-04,
 5.718584741560284179e-04,
 6.021185955232084483e-04,
 6.323365581504117924e-04,
 6.625113414881567218e-04,
 6.926419272051804977e-04,
 7.227272992217690468e-04,
 7.527664437440139550e-04,
 7.827583492975939304e-04,
 8.127020067609840243e-04,
 8.425964093992186627e-04,
 8.724405528973475229e-04,
 9.022334353935168192e-04,
 9.319740575122574533e-04,
 9.616614223976476146e-04,
 9.912945357460789964e-04,
 1.020872405839189220e-03,
 1.050394043576713919e-03,
 1.079858462508892026e-03,
 1.109264678869032166e-03,
 1.138611711606159508e-03,
 1.167898582416887618e-03,
 1.197124315777641380e-03,
 1.226287938977123869e-03,
 1.255388482147646321e-03,
 1.284424978297214444e-03,
 1.313396463341261720e-03,
 1.342301976133983494e-03,
 1.371140558499856681e-03,
 1.399911255265045423e-03,
 1.428613114288360044e-03,
 1.457245186492357606e-03,
 1.485806525894543947e-03,
 1.514296189637582809e-03,
 1.542713238020385329e-03,
 1.571056734528679779e-03,
 1.599325745865064338e-03,
 1.627519341979322695e-03,
 1.655636596098959516e-03,
 1.683676584758636531e-03,
 1.711638387830293406e-03,
 1.739521088552928828e-03,
 1.767323773561953974e-03,
 1.795045532918754802e-03,
 1.822685460140049864e-03,
 1.850242652226873844e-03,
 1.877716209693638732e-03,
 1.905105236597268506e-03,
 1.932408840565385134e-03,
 1.959626132825301008e-03,
 1.986756228232504189e-03,
 2.013798245298583332e-03,
 2.040751306219602563e-03,
 2.067614536904160191e-03,
 2.094387067001018086e-03,
 2.121068029926911468e-03,
 2.147656562894180009e-03,
 2.174151806937958762e-03,
 2.200552906943514797e-03,
 2.226859011673432923e-03,
 2.253069273794340837e-03,
 2.279182849903754401e-03,
 2.305198900556928998e-03,
 2.331116590292945431e-03,
 2.356935087661107646e-03,
 2.382653565247446273e-03,
 2.408271199700206047e-03,
 2.433787171755937354e-03,
 2.459200666265206562e-03,
 2.484510872217927761e-03,
 2.509716982768781229e-03,
 2.534818195262510468e-03,
 2.559813711258733526e-03,
 2.584702736556887884e-03,
 2.609484481221010978e-03,
 2.634158159604097892e-03,
 2.658722990372467711e-03,
 2.683178196530202741e-03,
 2.707523005442828787e-03,
 2.731756648861188418e-03,
 2.755878362945540609e-03,
 2.779887388288521111e-03,
 2.803782969938773285e-03,
 2.827564357424144394e-03,
 2.851230804774506321e-03,
 2.874781570544672135e-03,
 2.898215917837115331e-03,
 2.921533114324276637e-03,
 2.944732432270912893e-03,
 2.967813148556457201e-03,
 2.990774544696485262e-03,
 3.013615906864853481e-03,
 3.036336525915313191e-03,
 3.058935697402620935e-03,
 3.081412721603982684e-03,
 3.103766903540138098e-03,
 3.125997552996097415e-03,
 3.148103984541865321e-03,
 3.170085517553074619e-03,
 3.191941476231148055e-03,
 3.213671189623497435e-03,
 3.235273991643583535e-03,
 3.256749221090551871e-03,
 3.278096221668838108e-03,
 3.299314342007806430e-03,
 3.320402935680577799e-03,
 3.341361361223338291e-03,
 3.362188982154282711e-03,
 3.382885166991949754e-03,
 3.403449289273917117e-03,
 3.423880727575133193e-03,
 3.444178865525837196e-03,
 3.464343091829586406e-03,
 3.484372800281016272e-03,
 3.504267389783244022e-03,
 3.524026264365286154e-03,
 3.543648833199253018e-03,
 3.563134510617204688e-03,
 3.582482716127922268e-03,
 3.601692874433685704e-03,
 3.620764415446356844e-03,
 3.639696774303642895e-03,
 3.658489391385378979e-03,
 3.677141712328920765e-03,
 3.695653188044961245e-03,
 3.714023274732975843e-03,
 3.732251433896327086e-03,
 3.750337132357291214e-03,
 3.768279842272032314e-03,
 3.786079041145031313e-03,
 3.803734211843578725e-03,
 3.821244842612192810e-03,
 3.838610427086299598e-03,
 3.855830464306348338e-03,
 3.872904458731434279e-03,
 3.889831920252616142e-03,
 3.906612364206113464e-03,
 3.923245311386667870e-03,
 3.939730288060007066e-03,
 3.956066825975685687e-03,
 3.972254462379548427e-03,
 3.988292740025841873e-03,
 4.004181207189359305e-03,
 4.019919417677315747e-03,
 4.035506930840823160e-03,
 4.050943311586462786e-03,
 4.066228130387594675e-03,
 4.081360963295126848e-03,
 4.096341391948555080e-03,
 4.111169003586640988e-03,
 4.125843391057633890e-03,
 4.140364152829604551e-03,
 4.154730893000543879e-03,
 4.168943221308011454e-03,
 4.183000753138837839e-03,
 4.196903109538612647e-03,
 4.210649917220717249e-03,
 4.224240808575441611e-03,
 4.237675421678794088e-03,
 4.250953400301008510e-03,
 4.264074393914951515e-03,
 4.277038057704423205e-03,
 4.289844052571995490e-03,
 4.302492045146744624e-03,
 4.314981707792066995e-03,
 4.327312718612767208e-03,
 4.339484761462323106e-03,
 4.351497525949929619e-03,
 4.363350707447043869e-03,
 4.375044007094105493e-03,
 4.386577131806783381e-03,
 4.397949794282120933e-03,
 4.409161713004424582e-03,
 4.420212612251062968e-03,
 4.431102222097900098e-03,
 4.441830278424586248e-03,
 4.452396522919782954e-03,
 4.462800703085907476e-03,
 4.473042572243796609e-03,
 4.483121889537429461e-03,
 4.493038419937902574e-03,
 4.502791934247656579e-03,
 4.512382209104331618e-03,
 4.521809026984370365e-03,
 4.531072176206488340e-03,
 4.540171450934924781e-03,
 4.549106651182468868e-03,
 4.557877582813230077e-03,
 4.566484057545462313e-03,
 4.574925892953676798e-03,
 4.583202912471058543e-03,
 4.591314945391482098e-03,
 4.599261826871218518e-03,
 4.607043397930500953e-03,
 4.614659505455063343e-03,
 4.622110002197181260e-03,
 4.629394746776697989e-03,
 4.636513603681825975e-03,
 4.643466443269638616e-03,
 4.650253141766504811e-03,
 4.656873581268203451e-03,
 4.663327649739880919e-03,
 4.669615241015780474e-03,
 4.675736254798893571e-03,
 4.681690596660054333e-03,
 4.687478178037338475e-03,
 4.693098916234863735e-03,
 4.698552734421495777e-03,
 4.703839561629405766e-03,
 4.708959332752409369e-03,
 4.713911988544038610e-03,
 4.718697475615455869e-03,
 4.723315746433216084e-03,
 4.727766759316703697e-03,
 4.732050478435455114e-03,
 4.736166873806320690e-03,
 4.740115921290258966e-03,
 4.743897602589097068e-03,
 4.747511905242071673e-03,
 4.750958822622026491e-03,
 4.754238353931534294e-03,
 4.757350504198843734e-03,
 4.760295284273534724e-03,
 4.763072710821988215e-03,
 4.765682806322732792e-03,
 4.768125599061496384e-03,
 4.770401123126112239e-03,
 4.772509418401224557e-03,
 4.774450530562803288e-03,
 4.776224511072367507e-03,
 4.777831417171191433e-03,
 4.779271311874143564e-03,
 4.780544263963396566e-03,
 4.781650347981974969e-03,
 4.782589644227001890e-03,
 4.783362238742911929e-03,
 4.783968223314291092e-03,
 4.784407695458635194e-03,
 4.784680758418889679e-03,
 4.784787521155786476e-03,
 4.784728098339967491e-03,
 4.784502610343958039e-03,
 4.784111183233913898e-03,
 4.783553948761199229e-03,
 4.782831044353722492e-03,
 4.781942613107168297e-03,
 4.780888803775931728e-03,
 4.779669770763955543e-03,
 4.778285674115347915e-03,
 4.776736679504747785e-03,
 4.775022958227586982e-03,
 4.773144687190138125e-03,
 4.771102048899315308e-03,
 4.768895231452421890e-03,
 4.766524428526530514e-03,
 4.763989839367813693e-03,
 4.761291668780665357e-03,
 4.758430127116572601e-03,
 4.755405430262867744e-03,
 4.752217799631248789e-03,
 4.748867462146190606e-03,
 4.745354650233048199e-03,
 4.741679601806093186e-03,
 4.737842560256323027e-03,
 4.733843774439056018e-03,
 4.729683498661394446e-03,
 4.725361992669504727e-03,
 4.720879521635661623e-03,
 4.716236356145177104e-03,
 4.711432772183105425e-03,
 4.706469051120798150e-03,
 4.701345479702258821e-03,
 4.696062350030363181e-03,
 4.690619959552788827e-03,
 4.685018611047945744e-03,
 4.679258612610599777e-03,
 4.673340277637261925e-03,
 4.667263924811666104e-03,
 4.661029878089801952e-03,
 4.654638466684837481e-03,
 4.648090025051992286e-03,
 4.641384892873112386e-03,
 4.634523415041101081e-03,
 4.627505941644230111e-03,
 4.620332827950229641e-03,
 4.613004434390162271e-03,
 4.605521126542302252e-03,
 4.597883275115636527e-03,
 4.590091255933311139e-03,
 4.582145449915960532e-03,
 4.574046243064703796e-03,
 4.565794026444139168e-03,
 4.557389196165105225e-03,
 4.548832153367305883e-03,
 4.540123304201661332e-03,
 4.531263059812683236e-03,
 4.522251836320559382e-03,
 4.513090054803079593e-03,
 4.503778141277483583e-03,
 4.494316526682071156e-03,
 4.484705646857625912e-03,
 4.474945942528844173e-03,
 4.465037859285438636e-03,
 4.454981847563084171e-03,
 4.444778362624400916e-03,
 4.434427864539561802e-03,
 4.423930818166788188e-03,
 4.413287693132868922e-03,
 4.402498963813366271e-03,
 4.391565109312529566e-03,
 4.380486613443475979e-03,
 4.369263964707845692e-03,
 4.357897656275384196e-03,
 4.346388185963572307e-03,
 4.334736056216855447e-03,
 4.322941774085857329e-03,
 4.311005851206450509e-03,
 4.298928803778674299e-03,
 4.286711152545371641e-03,
 4.274353422770974312e-03,
 4.261856144219899542e-03,
 4.249219851134773164e-03,
 4.236445082214794142e-03,
 4.223532380593727868e-03,
 4.210482293817702573e-03,
 4.197295373823123690e-03,
 4.183972176914277710e-03,
 4.170513263740736540e-03,
 4.156919199274843393e-03,
 4.143190552788877760e-03,
 4.129327897832121494e-03,
 4.115331812207879796e-03,
 4.101202877950318321e-03,
 4.086941681300994104e-03,
 4.072548812685718687e-03,
 4.058024866690759444e-03,
 4.043370442039175353e-03,
 4.028586141567082508e-03,
 4.013672572199714940e-03,
 3.998630344927217410e-03,
 3.983460074780616894e-03,
 3.968162380807431500e-03,
 3.952737886047156222e-03,
 3.937187217506841509e-03,
 3.921511006136331814e-03,
 3.905709886803421325e-03,
 3.889784498269030499e-03,
 3.873735483162124571e-03,
 3.857563487954449033e-03,
 3.841269162935409976e-03,
 3.824853162186731513e-03,
 3.808316143556624445e-03,
 3.791658768634564251e-03,
 3.774881702725334850e-03,
 3.757985614823200309e-03,
 3.740971177586059192e-03,
 3.723839067309297080e-03,
 3.706589963899609153e-03,
 3.689224550848805868e-03,
 3.671743515207359729e-03,
 3.654147547557918662e-03,
 3.636437341988761271e-03,
 3.618613596067114194e-03,
 3.600677010812189296e-03,
 3.582628290668520964e-03,
 3.564468143478903995e-03,
 3.546197280457082969e-03,
 3.527816416160854066e-03,
 3.509326268464615234e-03,
 3.490727558531959724e-03,
 3.472021010788268764e-03,
 3.453207352893112106e-03,
 3.434287315712483343e-03,
 3.415261633291183548e-03,
 3.396131042824906097e-03,
 3.376896284632138930e-03,
 3.357558102126441055e-03,
 3.338117241788100212e-03,
 3.318574453135853409e-03,
 3.298930488698833836e-03,
 3.279186103988065894e-03,
 3.259342057467902540e-03,
 3.239399110527660820e-03,
 3.219358027452897016e-03,
 3.199219575396654910e-03,
 3.178984524350792536e-03,
 3.158653647117045261e-03,
 3.138227719278043320e-03,
 3.117707519168386610e-03,
 3.097093827845529956e-03,
 3.076387429060422479e-03,
 3.055589109228624457e-03,
 3.034699657400736789e-03,
 3.013719865232946261e-03,
 2.992650526957824943e-03,
 2.971492439354675094e-03,
 2.950246401719819854e-03,
 2.928913215837176693e-03,
 2.907493685948391113e-03,
 2.885988618722985528e-03,
 2.864398823228692017e-03,
 2.842725110901413860e-03,
 2.820968295515210045e-03,
 2.799129193152381703e-03,
 2.777208622173344722e-03,
 2.755207403186302022e-03,
 2.733126359017294411e-03,
 2.710966314679887166e-03,
 2.688728097344569943e-03,
 2.666412536308747794e-03,
 2.644020462966144118e-03,
 2.621552710776254777e-03,
 2.599010115233981767e-03,
 2.576393513838965907e-03,
 2.553703746064897410e-03,
 2.530941653328996465e-03,
 2.508108078961208878e-03,
 2.485203868173368330e-03,
 2.462229868028545116e-03,
 2.439186927410158957e-03,
 2.416075896990872805e-03,
 2.392897629201985385e-03,
 2.369652978202388318e-03,
 2.346342799847234845e-03,
 2.322967951657346677e-03,
 2.299529292787887494e-03,
 2.276027683997213814e-03,
 2.252463987615875487e-03,
 2.228839067515365081e-03,
 2.205153789076810898e-03,
 2.181409019159898099e-03,
 2.157605626071547843e-03,
 2.133744479534392148e-03,
 2.109826450655884981e-03,
 2.085852411896614491e-03,
 2.061823237038882400e-03,
 2.037739801155580462e-03,
 2.013602980578607649e-03,
 1.989413652867336787e-03,
 1.965172696777325780e-03,
 1.940880992228753666e-03,
 1.916539420274824797e-03,
 1.892148863070418265e-03,
 1.867710203840475388e-03,
 1.843224326848352281e-03,
 1.818692117364423310e-03,
 1.794114461634471833e-03,
 1.769492246847830050e-03,
 1.744826361106280831e-03,
 1.720117693392081773e-03,
 1.695367133536294360e-03,
 1.670575572187476751e-03,
 1.645743900779866138e-03,
 1.620873011501667562e-03,
 1.595963797263604900e-03,
 1.571017151667191249e-03,
 1.546033968972988044e-03,
 1.521015144069164928e-03,
 1.495961572439740870e-03,
 1.470874150132881874e-03,
 1.445753773729432012e-03,
 1.420601340311212438e-03,
 1.395417747429216100e-03,
 1.370203893072276463e-03,
 1.344960675635436999e-03,
 1.319688993887953559e-03,
 1.294389746942198587e-03,
 1.269063834221833068e-03,
 1.243712155430169502e-03,
 1.218335610518807895e-03,
 1.192935099655980085e-03,
 1.167511523194946117e-03,
 1.142065781642656467e-03,
 1.116598775628199151e-03,
 1.091111405871064265e-03,
 1.065604573150193265e-03,
 1.040079178272161099e-03,
 1.014536122039705508e-03,
 9.889763052206375273e-04,
 9.634006285164089470e-04,
 9.378099925303987495e-04,
 9.122052977370962877e-04,
 8.865874444505453646e-04,
 8.609573327930381123e-04,
 8.353158626640458774e-04,
 8.096639337089449762e-04,
 7.840024452877271616e-04,
 7.583322964440632153e-04,
 7.326543858741269314e-04,
 7.069696118952726238e-04,
 6.812788724154956446e-04,
 6.555830649020618619e-04,
 6.298830863504853829e-04,
 6.041798332539347538e-04,
 5.784742015721440044e-04,
 5.527670867004985753e-04,
 5.270593834394299163e-04,
 5.013519859635497686e-04,
 4.756457877908557876e-04,
 4.499416817522415004e-04,
 4.242405599607809675e-04,
 3.985433137810593589e-04,
 3.728508337988328575e-04,
 3.471640097904833233e-04,
 3.214837306923774927e-04,
 2.958108845708255254e-04,
 2.701463585916985153e-04,
 2.444910389897813480e-04,
 2.188458110390504360e-04,
 1.932115590222649383e-04,
 1.675891662007986452e-04,
 1.419795147847756291e-04,
 1.163834859029883235e-04,
 9.080195957287256353e-05,
 6.523581467082280761e-05,
 3.968592890228980112e-05,
 1.415317877194101341e-05,
-1.136156044583797919e-05,
-3.685741473662481363e-05,
-6.233351137572971283e-05,
-8.778897895734495064e-05,
-1.132229474240262706e-04,
-1.386345480964154499e-04,
-1.640229137020295059e-04,
-1.893871784047209631e-04,
-2.147264778338800115e-04,
-2.400399491133198347e-04,
-2.653267308903651308e-04,
-2.905859633648651455e-04,
-3.158167883178597340e-04,
-3.410183491404079979e-04,
-3.661897908625303039e-04,
-3.913302601813334097e-04,
-4.164389054899176245e-04,
-4.415148769058907844e-04,
-4.665573262994130929e-04,
-4.915654073217061090e-04,
-5.165382754333231559e-04,
-5.414750879321004323e-04,
-5.663750039812890779e-04,
-5.912371846376073860e-04,
-6.160607928789350136e-04,
-6.408449936321838078e-04,
-6.655889538010888347e-04,
-6.902918422936414047e-04,
-7.149528300496597920e-04,
-7.395710900684641454e-04,
-7.641457974357330433e-04,
-7.886761293511002340e-04,
-8.131612651553743985e-04,
-8.376003863572644087e-04,
-8.619926766605366403e-04,
-8.863373219909643358e-04,
-9.106335105228922921e-04,
-9.348804327060132938e-04,
-9.590772812920184522e-04,
-9.832232513608961562e-04,
-1.007317540347393760e-03,
-1.031359348067371288e-03,
-1.055347876743798321e-03,
-1.079282331032872973e-03,
-1.103161918050193230e-03,
-1.126985847396292945e-03,
-1.150753331182444985e-03,
-1.174463584056664733e-03,
-1.198115823228773158e-03,
-1.221709268496098044e-03,
-1.245243142268706409e-03,
-1.268716669594726698e-03,
-1.292129078185285437e-03,
-1.315479598439576363e-03,
-1.338767463469831996e-03,
-1.361991909125918757e-03,
-1.385152174020064155e-03,
-1.408247499551500484e-03,
-1.431277129930693922e-03,
-1.454240312203730623e-03,
-1.477136296276721460e-03,
-1.499964334939427003e-03,
-1.522723683889551892e-03,
-1.545413601756638697e-03,
-1.568033350125479317e-03,
-1.590582193559895432e-03,
-1.613059399626286944e-03,
-1.635464238916811133e-03,
-1.657795985072696692e-03,
-1.680053914807436762e-03,
-1.702237307929605750e-03,
-1.724345447365808852e-03,
-1.746377619183488899e-03,
-1.768333112613376928e-03,
-1.790211220072026894e-03,
-1.812011237184359483e-03,
-1.833732462805593788e-03,
-1.855374199043387804e-03,
-1.876935751280139810e-03,
-1.898416428194394214e-03,
-1.919815541782765632e-03,
-1.941132407381545959e-03,
-1.962366343688017826e-03,
-1.983516672781830519e-03,
-2.004582720146246000e-03,
-2.025563814689034306e-03,
-2.046459288763445052e-03,
-2.067268478189149012e-03,
-2.087990722272514005e-03,
-2.108625363827364759e-03,
-2.129171749195417525e-03,
-2.149629228266253678e-03,
-2.169997154497448153e-03,
-2.190274884934827540e-03,
-2.210461780231850852e-03,
-2.230557204669511573e-03,
-2.250560526175888424e-03,
-2.270471116345387352e-03,
-2.290288350458061575e-03,
-2.310011607498777247e-03,
-2.329640270176030863e-03,
-2.349173724940810479e-03,
-2.368611362005447821e-03,
-2.387952575361773893e-03,
-2.407196762799759023e-03,
-2.426343325925832840e-03,
-2.445391670180653045e-03,
-2.464341204857272739e-03,
-2.483191343118929147e-03,
-2.501941502016568220e-03,
-2.520591102506413057e-03,
-2.539139569467366644e-03,
-2.557586331718083271e-03,
-2.575930822034069867e-03,
-2.594172477164655502e-03,
-2.612310737849619143e-03,
-2.630345048835790091e-03,
-2.648274858893711736e-03,
-2.666099620833527282e-03,
-2.683818791521430137e-03,
-2.701431831895659361e-03,
-2.718938206982106972e-03,
-2.736337385910116073e-03,
-2.753628841928082958e-03,
-2.770812052418673236e-03,
-2.787886498914084795e-03,
-2.804851667111195410e-03,
-2.821707046886314831e-03,
-2.838452132309977633e-03,
-2.855086421661626791e-03,
-2.871609417443870063e-03,
-2.888020626396830062e-03,
-2.904319559512375058e-03,
-2.920505732047843240e-03,
-2.936578663539903596e-03,
-2.952537877818393365e-03,
-2.968382903019509307e-03,
-2.984113271599235766e-03,
-2.999728520346587983e-03,
-3.015228190396442107e-03,
-3.030611827242448916e-03,
-3.045878980749762779e-03,
-3.061029205167420213e-03,
-3.076062059140731875e-03,
-3.090977105723610816e-03,
-3.105773912390295301e-03,
-3.120452051047446773e-03,
-3.135011098045851000e-03,
-3.149450634191777038e-03,
-3.163770244758400824e-03,
-3.177969519497181924e-03,
-3.192048052648650044e-03,
-3.206005442953415753e-03,
-3.219841293662882402e-03,
-3.233555212549738163e-03,
-3.247146811918333580e-03,
-3.260615708614970649e-03,
-3.273961524037847983e-03,
-3.287183884146954813e-03,
-3.300282419473945898e-03,
-3.313256765131388035e-03,
-3.326106560822374766e-03,
-3.338831450849741658e-03,
-3.351431084124936385e-03,
-3.363905114177034080e-03,
-3.376253199161451720e-03,
-3.388475001868394929e-03,
-3.400570189731295673e-03,
-3.412538434835073447e-03,
-3.424379413924034769e-03,
-3.436092808409844674e-03,
-3.447678304379220206e-03,
-3.459135592601427899e-03,
-3.470464368535605606e-03,
-3.481664332338145051e-03,
-3.492735188869478067e-03,
-3.503676647700983398e-03,
-3.514488423121893499e-03,
-3.525170234145498342e-03,
-3.535721804515668410e-03,
-3.546142862713040720e-03,
-3.556433141960935532e-03,
-3.566592380231240096e-03,
-3.576620320250127605e-03,
-3.586516709503422690e-03,
-3.596281300242057128e-03,
-3.605913849487172532e-03,
-3.615414119035089031e-03,
-3.624781875462130404e-03,
-3.634016890129343393e-03,
-3.643118939186847528e-03,
-3.652087803578167157e-03,
-3.660923269044518390e-03,
-3.669625126128547854e-03,
-3.678193170178239296e-03,
-3.686627201350598133e-03,
-3.694927024614957402e-03,
-3.703092449756340086e-03,
-3.711123291378629757e-03,
-3.719019368907363048e-03,
-3.726780506592602352e-03,
-3.734406533511572604e-03,
-3.741897283570940706e-03,
-3.749252595509212048e-03,
-3.756472312898792663e-03,
-3.763556284147850147e-03,
-3.770504362502080480e-03,
-3.777316406046367283e-03,
-3.783992277706055545e-03,
-3.790531845248291259e-03,
-3.796934981283062692e-03,
-3.803201563264069045e-03,
-3.809331473489480698e-03,
-3.815324599102492154e-03,
-3.821180832091690231e-03,
-3.826900069291290420e-03,
-3.832482212381238800e-03,
-3.837927167886933180e-03,
-3.843234847179125956e-03,
-3.848405166473366397e-03,
-3.853438046829377878e-03,
-3.858333414150259474e-03,
-3.863091199181578703e-03,
-3.867711337510172393e-03,
-3.872193769562859086e-03,
-3.876538440605043021e-03,
-3.880745300738961193e-03,
-3.884814304901970314e-03,
-3.888745412864550582e-03,
-3.892538589228145950e-03,
-3.896193803422893370e-03,
-3.899711029705122192e-03,
-3.903090247154752078e-03,
-3.906331439672412927e-03,
-3.909434595976584749e-03,
-3.912399709600357205e-03,
-3.915226778888166587e-03,
-3.917915806992373212e-03,
-3.920466801869527430e-03,
-3.922879776276664253e-03,
-3.925154747767281398e-03,
-3.927291738687243607e-03,
-3.929290776170455378e-03,
-3.931151892134469514e-03,
-3.932875123275766070e-03,
-3.934460511065054726e-03,
-3.935908101742302198e-03,
-3.937217946311609602e-03,
-3.938390100535934558e-03,
-3.939424624931701403e-03,
-3.940321584763133850e-03,
-3.941081050036555553e-03,
-3.941703095494455619e-03,
-3.942187800609389323e-03,
-3.942535249577733963e-03,
-3.942745531313335446e-03,
-3.942818739440887704e-03,
-3.942754972289228867e-03,
-3.942554332884494299e-03,
-3.942216928943031128e-03,
-3.941742872864203474e-03,
-3.941132281723077127e-03,
-3.940385277262857880e-03,
-3.939501985887263955e-03,
-3.938482538652625202e-03,
-3.937327071259984906e-03,
-3.936035724046917962e-03,
-3.934608641979189456e-03,
-3.933045974642384625e-03,
-3.931347876233246517e-03,
-3.929514505550905229e-03,
-3.927546025988009996e-03,
-3.925442605521611492e-03,
-3.923204416703933092e-03,
-3.920831636653061489e-03,
-3.918324447043317234e-03,
-3.915683034095645242e-03,
-3.912907588567761559e-03,
-3.909998305744150082e-03,
-3.906955385425940445e-03,
-3.903779031920649300e-03,
-3.900469454031675262e-03,
-3.897026865047791694e-03,
-3.893451482732350217e-03,
-3.889743529312430018e-03,
-3.885903231467805006e-03,
-3.881930820319770895e-03,
-3.877826531419789266e-03,
-3.873590604738051408e-03,
-3.869223284651833548e-03,
-3.864724819933798745e-03,
-3.860095463739974392e-03,
-3.855335473597807771e-03,
-3.850445111393919345e-03,
-3.845424643361781015e-03,
-3.840274340069216134e-03,
-3.834994476405804119e-03,
-3.829585331570091195e-03,
-3.824047189056697070e-03,
-3.818380336643277615e-03,
-3.812585066377283723e-03,
-3.806661674562735343e-03,
-3.800610461746657676e-03,
-3.794431732705532551e-03,
-3.788125796431556381e-03,
-3.781692966118731149e-03,
-3.775133559148876466e-03,
-3.768447897077481165e-03,
-3.761636305619407011e-03,
-3.754699114634452769e-03,
-3.747636658112845406e-03,
-3.740449274160518797e-03,
-3.733137304984277937e-03,
-3.725701096876886820e-03,
-3.718141000201972447e-03,
-3.710457369378748413e-03,
-3.702650562866803552e-03,
-3.694720943150495932e-03,
-3.686668876723368099e-03,
-3.678494734072485558e-03,
-3.670198889662527626e-03,
-3.661781721919766825e-03,
-3.653243613216015755e-03,
-3.644584949852377066e-03,
-3.635806122042791778e-03,
-3.626907523897678672e-03,
-3.617889553407238439e-03,
-3.608752612424709263e-03,
-3.599497106649548681e-03,
-3.590123445610456706e-03,
-3.580632042648162171e-03,
-3.571023314898366923e-03,
-3.561297683274315326e-03,
-3.551455572449258805e-03,
-3.541497410839016240e-03,
-3.531423630584204758e-03,
-3.521234667532369914e-03,
-3.510930961220162707e-03,
-3.500512954855232971e-03,
-3.489981095298013043e-03,
-3.479335833043572124e-03,
-3.468577622203109813e-03,
-3.457706920485475663e-03,
-3.446724189178615450e-03,
-3.435629893130785414e-03,
-3.424424500731675439e-03,
-3.413108483893568211e-03,
-3.401682318032267678e-03,
-3.390146482047778562e-03,
-3.378501458305260829e-03,
-3.366747732615492372e-03,
-3.354885794215431861e-03,
-3.342916135748656269e-03,
-3.330839253245621457e-03,
-3.318655646103869407e-03,
-3.306365817068164341e-03,
-3.293970272210492659e-03,
-3.281469520909809610e-03,
-3.268864075832096476e-03,
-3.256154452909865681e-03,
-3.243341171321727050e-03,
-3.230424753472059020e-03,
-3.217405724970275223e-03,
-3.204284614610130970e-03,
-3.191061954349007183e-03,
-3.177738279286955372e-03,
-3.164314127645715714e-03,
-3.150790040747690913e-03,
-3.137166562994750038e-03,
-3.123444241846907912e-03,
-3.109623627801088620e-03,
-3.095705274369599767e-03,
-3.081689738058659631e-03,
-3.067577578346661511e-03,
-3.053369357662615892e-03,
-3.039065641364304196e-03,
-3.024666997716279893e-03,
-3.010173997868069093e-03,
-2.995587215832107037e-03,
-2.980907228461414805e-03,
-2.966134615427604322e-03,
-2.951269959198489588e-03,
-2.936313845015648023e-03,
-2.921266860872063793e-03,
-2.906129597489543002e-03,
-2.890902648296036527e-03,
-2.875586609403050879e-03,
-2.860182079582837024e-03,
-2.844689660245392285e-03,
-2.829109955415830442e-03,
-2.813443571711165062e-03,
-2.797691118317198206e-03,
-2.781853206965567444e-03,
-2.765930451910405142e-03,
-2.749923469905029855e-03,
-2.733832880178655930e-03,
-2.717659304412960858e-03,
-2.701403366718493470e-03,
-2.685065693611249100e-03,
-2.668646913988958948e-03,
-2.652147659107355164e-03,
-2.635568562556528296e-03,
-2.618910260237033646e-03,
-2.602173390335892674e-03,
-2.585358593302913149e-03,
-2.568466511826471982e-03,
-2.551497790809392156e-03,
-2.534453077345014821e-03,
-2.517333020692906660e-03,
-2.500138272254545137e-03,
-2.482869485549130378e-03,
-2.465527316189183686e-03,
-2.448112421856053246e-03,
-2.430625462275586793e-03,
-2.413067099193515457e-03,
-2.395437996350861017e-03,
-2.377738819459388267e-03,
-2.359970236176915561e-03,
-2.342132916082428039e-03,
-2.324227530651535624e-03,
-2.306254753231608366e-03,
-2.288215259016646800e-03,
-2.270109725022718267e-03,
-2.251938830062802550e-03,
-2.233703254721757653e-03,
-2.215403681331401357e-03,
-2.197040793945345162e-03,
-2.178615278313802191e-03,
-2.160127821858526947e-03,
-2.141579113647586359e-03,
-2.122969844369911388e-03,
-2.104300706310353007e-03,
-2.085572393324111509e-03,
-2.066785600811316733e-03,
-2.047941025691830778e-03,
-2.029039366379810014e-03,
-2.010081322757941834e-03,
-1.991067596152308085e-03,
-1.971998889306684696e-03,
-1.952875906356931314e-03,
-1.933699352805522955e-03,
-1.914469935495878268e-03,
-1.895188362586646812e-03,
-1.875855343526154195e-03,
-1.856471589026665713e-03,
-1.837037811038482382e-03,
-1.817554722724549782e-03,
-1.798023038434415962e-03,
-1.778443473678384488e-03,
-1.758816745101955681e-03,
-1.739143570459826147e-03,
-1.719424668589985454e-03,
-1.699660759387984109e-03,
-1.679852563780959759e-03,
-1.660000803701673373e-03,
-1.640106202062704792e-03,
-1.620169482730468092e-03,
-1.600191370499156251e-03,
-1.580172591064934106e-03,
-1.560113870999902536e-03,
-1.540015937725948587e-03,
-1.519879519489000450e-03,
-1.499705345332960410e-03,
-1.479494145073417723e-03,
-1.459246649271984464e-03,
-1.438963589210077998e-03,
-1.418645696862837679e-03,
-1.398293704873217408e-03,
-1.377908346525861779e-03,
-1.357490355720993502e-03,
-1.337040466948488182e-03,
-1.316559415261761524e-03,
-1.296047936251628783e-03,
-1.275506766020409032e-03,
-1.254936641155806731e-03,
-1.234338298704700052e-03,
-1.213712476147361160e-03,
-1.193059911371356424e-03,
-1.172381342645225462e-03,
-1.151677508592832168e-03,
-1.130949148167145670e-03,
-1.110197000624171988e-03,
-1.089421805497093210e-03,
-1.068624302570199370e-03,
-1.047805231852810999e-03,
-1.026965333553471645e-03,
-1.006105348053915310e-03,
-9.852260158829241696e-04,
-9.643280776907884547e-04,
-9.434122742230831781e-04,
-9.224793462947113599e-04,
-9.015300347642920273e-04,
-8.805650805081132338e-04,
-8.595852243942221204e-04,
-8.385912072567520926e-04,
-8.175837698700231821e-04,
-7.965636529226811143e-04,
-7.755315969920811891e-04,
-7.544883425184541279e-04,
-7.334346297791220120e-04,
-7.123711988629378902e-04,
-6.912987896445758765e-04,
-6.702181417586752050e-04,
-6.491299945746222292e-04,
-6.280350871706721428e-04,
-6.069341583083195241e-04,
-5.858279464070612541e-04,
-5.647171895187093815e-04,
-5.436026253018773520e-04,
-5.224849909966959799e-04,
-5.013650233993343719e-04,
-4.802434588365601530e-04,
-4.591210331405535584e-04,
-4.379984816235427407e-04,
-4.168765390524637425e-04,
-3.957559396238955851e-04,
-3.746374169388205300e-04,
-3.535217039773128913e-04,
-3.324095330737109684e-04,
-3.113016358915037256e-04,
-2.901987433980109305e-04,
-2.691015858398123684e-04,
-2.480108927176114279e-04,
-2.269273927612973666e-04,
-2.058518139052563476e-04,
-1.847848832634994885e-04,
-1.637273271048368824e-04,
-1.426798708283303382e-04,
-1.216432389385911763e-04,
-1.006181550209736422e-04,
-7.960534171743082171e-05,
-5.860552070170776327e-05,
-3.761941265484430267e-05,
-1.664773724103225223e-05,
 4.308786916777418395e-06,
 2.524944226146522429e-05,
 4.617351232557014452e-05,
 6.708028175566784358e-05,
 8.796903633653994849e-05,
 1.088390630150838797e-04,
 1.296896499243903724e-04,
 1.505200864077633387e-04,
 1.713296630424509257e-04,
 1.921176716635178579e-04,
 2.128834053878085012e-04,
 2.336261586372400246e-04,
 2.543452271627408257e-04,
 2.750399080678704979e-04,
 2.957094998320490250e-04,
 3.163533023341733334e-04,
 3.369706168760397457e-04,
 3.575607462055036228e-04,
 3.781229945397871091e-04,
 3.986566675887307149e-04,
 4.191610725777394257e-04,
 4.396355182708891647e-04,
 4.600793149939640830e-04,
 4.804917746571881051e-04,
 5.008722107780962281e-04,
 5.212199385044725530e-04,
 5.415342746366214781e-04,
 5.618145376502610075e-04,
 5.820600477190839136e-04,
 6.022701267369346594e-04,
 6.224440983403472507e-04,
 6.425812879308757898e-04,
 6.626810226971588565e-04,
 6.827426316371288479e-04,
 7.027654455801275344e-04,
 7.227487972087354943e-04,
 7.426920210807277500e-04,
 7.625944536509633763e-04,
 7.824554332929544017e-04,
 8.022743003205570073e-04,
 8.220503970097083708e-04,
 8.417830676196175069e-04,
 8.614716584142138216e-04,
 8.811155176837288071e-04,
 9.007139957655305043e-04,
 9.202664450654405442e-04,
 9.397722200788232892e-04,
 9.592306774113869023e-04,
 9.786411758001220020e-04,
 9.980030761341431716e-04,
 1.017315741475221472e-03,
 1.036578537078426676e-03,
 1.055790830412810157e-03,
 1.074951991181429456e-03,
 1.094061391341947468e-03,
 1.113118405126884260e-03,
 1.132122409063526704e-03,
 1.151072781993976247e-03,
 1.169968905095373829e-03,
 1.188810161899367390e-03,
 1.207595938312021073e-03,
 1.226325622633510403e-03,
 1.244998605577525390e-03,
 1.263614280290770555e-03,
 1.282172042372397734e-03,
 1.300671289893093026e-03,
 1.319111423414271074e-03,
 1.337491846007299702e-03,
 1.355811963272073170e-03,
 1.374071183356116678e-03,
 1.392268916973370173e-03,
 1.410404577422572948e-03,
 1.428477580605932301e-03,
 1.446487345047604844e-03,
 1.464433291911865567e-03,
 1.482314845021392470e-03,
 1.500131430875424566e-03,
 1.517882478667638424e-03,
 1.535567420304092797e-03,
 1.553185690421066351e-03,
 1.570736726402627162e-03,
 1.588219968398199610e-03,
 1.605634859340192852e-03,
 1.622980844961099131e-03,
 1.640257373810766412e-03,
 1.657463897273776625e-03,
 1.674599869586108989e-03,
 1.691664747852199713e-03,
 1.708657992061789416e-03,
 1.725579065106435956e-03,
 1.742427432796153251e-03,
 1.759202563875899824e-03,
 1.775903930041798466e-03,
 1.792531005957390599e-03,
 1.809083269269802161e-03,
 1.825560200625598760e-03,
 1.841961283686681383e-03,
 1.858286005146181450e-03,
 1.874533854743861251e-03,
 1.890704325281656207e-03,
 1.906796912639322069e-03,
 1.922811115789372412e-03,
 1.938746436812379759e-03,
 1.954602380912081987e-03,
 1.970378456430132031e-03,
 1.986074174860973356e-03,
 2.001689050866565373e-03,
 2.017222602290807444e-03,
 2.032674350173998678e-03,
 2.048043818767303348e-03,
 2.063330535546624347e-03,
 2.078534031226882996e-03,
 2.093653839775990073e-03,
 2.108689498428448217e-03,
 2.123640547699173764e-03,
 2.138506531397074868e-03,
 2.153286996638395425e-03,
 2.167981493860067672e-03,
 2.182589576832948131e-03,
 2.197110802674765578e-03,
 2.211544731863112831e-03,
 2.225890928248291500e-03,
 2.240148959065886135e-03,
 2.254318394949334468e-03,
 2.268398809942501117e-03,
 2.282389781511697489e-03,
 2.296290890558011326e-03,
 2.310101721429425048e-03,
 2.323821861932480904e-03,
 2.337450903344211531e-03,
 2.350988440423793392e-03,
 2.364434071423979471e-03,
 2.377787398102497712e-03,
 2.391048025733382223e-03,
 2.404215563117993119e-03,
 2.417289622596026366e-03,
 2.430269820056439947e-03,
 2.443155774948088145e-03,
 2.455947110290321138e-03,
 2.468643452683565512e-03,
 2.481244432319493643e-03,
 2.493749682991208260e-03,
 2.506158842103532389e-03,
 2.518471550682654415e-03,
 2.530687453386055476e-03,
 2.542806198512199186e-03,
 2.554827438009952927e-03,
 2.566750827488028207e-03,
 2.578576026224283120e-03,
 2.590302697174739870e-03,
 2.601930506982593188e-03,
 2.613459125987208781e-03,
 2.624888228232539339e-03,
 2.636217491475929559e-03,
 2.647446597196567285e-03,
 2.658575230603616758e-03,
 2.669603080644457251e-03,
 2.680529840012854485e-03,
 2.691355205156608157e-03,
 2.702078876285465316e-03,
 2.712700557378752275e-03,
 2.723219956192732012e-03,
 2.733636784268051335e-03,
 2.743950756936901388e-03,
 2.754161593330125245e-03,
 2.764269016384091754e-03,
 2.774272752847487845e-03,
 2.784172533288072678e-03,
 2.793968092099038871e-03,
 2.803659167505471745e-03,
 2.813245501570652441e-03,
 2.822726840202000216e-03,
 2.832102933157104076e-03,
 2.841373534049636881e-03,
 2.850538400354873936e-03,
 2.859597293415329540e-03,
 2.868549978446168890e-03,
 2.877396224540415721e-03,
 2.886135804674087087e-03,
 2.894768495711248345e-03,
 2.903294078408756324e-03,
 2.911712337420998588e-03,
 2.920023061304563312e-03,
 2.928226042522448589e-03,
 2.936321077448524140e-03,
 2.944307966371676865e-03,
 2.952186513499686655e-03,
 2.959956526963172449e-03,
 2.967617818819377837e-03,
 2.975170205055635737e-03,
 2.982613505592885978e-03,
 2.989947544288984287e-03,
 2.997172148941820886e-03,
 3.004287151292384453e-03,
 3.011292387027667342e-03,
 3.018187695783343134e-03,
 3.024972921146413390e-03,
 3.031647910657729941e-03,
 3.038212515814171961e-03,
 3.044666592070964864e-03,
 3.051009998843695181e-03,
 3.057242599510207048e-03,
 3.063364261412289662e-03,
 3.069374855857465775e-03,
 3.075274258120358657e-03,
 3.081062347444011359e-03,
 3.086739007041273616e-03,
 3.092304124095627584e-03,
 3.097757589762248180e-03,
 3.103099299168879128e-03,
 3.108329151416238442e-03,
 3.113447049578764794e-03,
 3.118452900704853439e-03,
 3.123346615817120323e-03,
 3.128128109912504864e-03,
 3.132797301962238733e-03,
 3.137354114911583905e-03,
 3.141798475679602812e-03,
 3.146130315158656571e-03,
 3.150349568213764873e-03,
 3.154456173681932912e-03,
 3.158450074371231108e-03,
 3.162331217059796348e-03,
 3.166099552494640226e-03,
 3.169755035390428230e-03,
 3.173297624428003498e-03,
 3.176727282252777857e-03,
 3.180043975473134145e-03,
 3.183247674658491993e-03,
 3.186338354337373176e-03,
 3.189315992995267468e-03,
 3.192180573072400922e-03,
 3.194932080961300318e-03,
 3.197570507004361944e-03,
 3.200095845491074311e-03,
 3.202508094655288125e-03,
 3.204807256672301957e-03,
 3.206993337655733231e-03,
 3.209066347654356693e-03,
 3.211026300648765937e-03,
 3.212873214547867090e-03,
 3.214607111185313528e-03,
 3.216228016315740221e-03,
 3.217735959610870146e-03,
 3.219130974655540038e-03,
 3.220413098943549195e-03,
 3.221582373873347390e-03,
 3.222638844743665101e-03,
 3.223582560748949020e-03,
 3.224413574974700422e-03,
 3.225131944392623570e-03,
 3.225737729855760252e-03,
 3.226230996093340693e-03,
 3.226611811705618407e-03,
 3.226880249158540267e-03,
 3.227036384778259569e-03,
 3.227080298745538083e-03,
 3.227012075090032305e-03,
 3.226831801684429662e-03,
 3.226539570238458506e-03,
 3.226135476292774952e-03,
 3.225619619212705298e-03,
 3.224992102181876985e-03,
 3.224253032195735502e-03,
 3.223402520054850524e-03,
 3.222440680358239391e-03,
 3.221367631496409572e-03,
 3.220183495644391575e-03,
 3.218888398754539415e-03,
 3.217482470549333680e-03,
 3.215965844513928723e-03,
 3.214338657888662562e-03,
 3.212601051661398508e-03,
 3.210753170559755773e-03,
 3.208795163043211274e-03,
 3.206727181295085643e-03,
 3.204549381214389162e-03,
 3.202261922407568812e-03,
 3.199864968180095737e-03,
 3.197358685527955120e-03,
 3.194743245129035014e-03,
 3.192018821334329133e-03,
 3.189185592159078479e-03,
 3.186243739273775938e-03,
 3.183193447995021248e-03,
 3.180034907276285770e-03,
 3.176768309698567959e-03,
 3.173393851460874944e-03,
 3.169911732370632538e-03,
 3.166322155834024998e-03,
 3.162625328846011691e-03,
 3.158821461980536316e-03,
 3.154910769380357954e-03,
 3.150893468746836582e-03,
 3.146769781329705144e-03,
 3.142539931916596158e-03,
 3.138204148822476384e-03,
 3.133762663879072815e-03,
 3.129215712424018078e-03,
 3.124563533290001041e-03,
 3.119806368793799026e-03,
 3.114944464725088839e-03,
 3.109978070335288163e-03,
 3.104907438326199622e-03,
 3.099732824838568115e-03,
 3.094454489440481588e-03,
 3.089072695115736237e-03,
 3.083587708252070320e-03,
 3.077999798629237928e-03,
 3.072309239406976079e-03,
 3.066516307113003898e-03,
 3.060621281630690471e-03,
 3.054624446186762158e-03,
 3.048526087338923607e-03,
 3.042326494963238075e-03,
 3.036025962241496040e-03,
 3.029624785648536538e-03,
 3.023123264939250182e-03,
 3.016521703135749584e-03,
 3.009820406514262647e-03,
 3.003019684591857596e-03,
 2.996119850113346684e-03,
 2.989121219037761418e-03,
 2.982024110524918864e-03,
 2.974828846921910314e-03,
 2.967535753749285955e-03,
 2.960145159687361388e-03,
 2.952657396562342450e-03,
 2.945072799332293465e-03,
 2.937391706073043916e-03,
 2.929614457964117239e-03,
 2.921741399274326110e-03,
 2.913772877347440594e-03,
 2.905709242587780836e-03,
 2.897550848445556472e-03,
 2.889298051402259399e-03,
 2.880951210955871779e-03,
 2.872510689606090108e-03,
 2.863976852839279080e-03,
 2.855350069113483588e-03,
 2.846630709843348331e-03,
 2.837819149384793703e-03,
 2.828915765019764540e-03,
 2.819920936940854394e-03,
 2.810835048235748104e-03,
 2.801658484871638339e-03,
 2.792391635679681173e-03,
 2.783034892338986759e-03,
 2.773588649361064060e-03,
 2.764053304073732162e-03,
 2.754429256604993409e-03,
 2.744716909867203191e-03,
 2.734916669540638640e-03,
 2.725028944057295878e-03,
 2.715054144584646070e-03,
 2.704992685008992485e-03,
 2.694844981919068683e-03,
 2.684611454589479716e-03,
 2.674292524963851891e-03,
 2.663888617638195903e-03,
 2.653400159844075245e-03,
 2.642827581431544774e-03,
 2.632171314852272716e-03,
 2.621431795142368203e-03,
 2.610609459905350628e-03,
 2.599704749294742996e-03,
 2.588718105996834842e-03,
 2.577649975213395280e-03,
 2.566500804644023491e-03,
 2.555271044468700008e-03,
 2.543961147330263840e-03,
 2.532571568316566504e-03,
 2.521102764942793461e-03,
 2.509555197133725695e-03,
 2.497929327205613594e-03,
 2.486225619848467586e-03,
 2.474444542107927681e-03,
 2.462586563366985989e-03,
 2.450652155328139452e-03,
 2.438641791994881208e-03,
 2.426555949653485568e-03,
 2.414395106854730095e-03,
 2.402159744395282459e-03,
 2.389850345299295020e-03,
 2.377467394799912676e-03,
 2.365011380320476697e-03,
 2.352482791455937604e-03,
 2.339882119954158745e-03,
 2.327209859696953605e-03,
 2.314466506681304384e-03,
 2.301652559000488645e-03,
 2.288768516824943571e-03,
 2.275814882383315422e-03,
 2.262792159943301674e-03,
 2.249700855792603326e-03,
 2.236541478219529824e-03,
 2.223314537493816054e-03,
 2.210020545847378622e-03,
 2.196660017454760746e-03,
 2.183233468413771448e-03,
 2.169741416726110421e-03,
 2.156184382277632951e-03,
 2.142562886818841217e-03,
 2.128877453945395536e-03,
 2.115128609078061831e-03,
 2.101316879443378572e-03,
 2.087442794053693575e-03,
 2.073506883687126212e-03,
 2.059509680868122899e-03,
 2.045451719847147815e-03,
 2.031333536580870631e-03,
 2.017155668712222825e-03,
 2.002918655550166901e-03,
 1.988623038049674649e-03,
 1.974269358791686316e-03,
 1.959858161962736278e-03,
 1.945389993334805528e-03,
 1.930865400245184143e-03,
 1.916284931575938004e-03,
 1.901649137733726815e-03,
 1.886958570629326121e-03,
 1.872213783657358148e-03,
 1.857415331675654020e-03,
 1.842563770984821095e-03,
 1.827659659307861919e-03,
 1.812703555769396577e-03,
 1.797696020875166499e-03,
 1.782637616491516801e-03,
 1.767528905824542742e-03,
 1.752370453399503328e-03,
 1.737162825040222550e-03,
 1.721906587847995586e-03,
 1.706602310181241358e-03,
 1.691250561634494382e-03,
 1.675851913017376233e-03,
 1.660406936334171343e-03,
 1.644916204762585966e-03,
 1.629380292632956429e-03,
 1.613799775407441560e-03,
 1.598175229658840412e-03,
 1.582507233049731780e-03,
 1.566796364311578808e-03,
 1.551043203223481659e-03,
 1.535248330591260438e-03,
 1.519412328226500599e-03,
 1.503535778925233629e-03,
 1.487619266447016281e-03,
 1.471663375493708400e-03,
 1.455668691688514430e-03,
 1.439635801554599043e-03,
 1.423565292494039739e-03,
 1.407457752766748870e-03,
 1.391313771469078866e-03,
 1.375133938512706957e-03,
 1.358918844603545064e-03,
 1.342669081220287117e-03,
 1.326385240593261914e-03,
 1.310067915683326301e-03,
 1.293717700160362414e-03,
 1.277335188382117083e-03,
 1.260920975373108679e-03,
 1.244475656802885178e-03,
 1.227999828965276432e-03,
 1.211494088756838276e-03,
 1.194959033655338494e-03,
 1.178395261698955308e-03,
 1.161803371464544335e-03,
 1.145183962046487751e-03,
 1.128537633035503777e-03,
 1.111864984497099029e-03,
 1.095166616950379737e-03,
 1.078443131346856028e-03,
 1.061695129048896872e-03,
 1.044923211808546732e-03,
 1.028127981746343499e-03,
 1.011310041329766506e-03,
 9.944699933521130176e-04,
 9.776084409111253544e-04,
 9.607259873878630421e-04,
 9.438232364251844357e-04,
 9.269007919065958868e-04,
 9.099592579351170650e-04,
 8.929992388117661585e-04,
 8.760213390144557704e-04,
 8.590261631768711425e-04,
 8.420143160670028439e-04,
 8.249864025660497147e-04,
 8.079430276473599732e-04,
 7.908847963549791920e-04,
 7.738123137826105960e-04,
 7.567261850525817566e-04,
 7.396270152944452603e-04,
 7.225154096240274772e-04,
 7.053919731222282885e-04,
 6.882573108140978280e-04,
 6.711120276475123934e-04,
 6.539567284722411049e-04,
 6.367920180190405352e-04,
 6.196185008783824466e-04,
 6.024367814795905966e-04,
 5.852474640699900123e-04,
 5.680511526937052002e-04,
 5.508484511708671002e-04,
 5.336399630768638410e-04,
 5.164262917210167602e-04,
 4.992080401262639737e-04,
 4.819858110080800159e-04,
 4.647602067534357040e-04,
 4.475318294005590104e-04,
 4.303012806177380434e-04,
 4.130691616827708622e-04,
 3.958360734624042873e-04,
 3.786026163914317294e-04,
 3.613693904521913603e-04,
 3.441369951540993572e-04,
 3.269060295128440089e-04,
 3.096770920299790251e-04,
 2.924507806725580995e-04,
 2.752276928524277329e-04,
 2.580084254059257639e-04,
 2.407935745736235395e-04,
 2.235837359797234174e-04,
 2.063795046119099529e-04,
 1.891814748009962798e-04,
 1.719902402008489960e-04,
 1.548063937679436072e-04,
 1.376305277413319669e-04,
 1.204632336226494802e-04,
 1.033051021557907314e-04,
 8.615672330700057725e-05,
 6.901868624500784983e-05,
 5.189157932082953667e-05,
 3.477599004799140252e-05,
 1.767250508283470036e-05,
 5.817102042483011815e-07,
-1.649580970556165701e-05,
-3.355947068104061961e-05,
-5.060868969320613843e-05,
-6.764288466873769436e-05,
-8.466147451000654504e-05,
-1.016638791144389115e-04,
-1.186495193938698545e-04,
-1.356178172942185893e-04,
-1.525681958147387255e-04,
-1.695000790272216699e-04,
-1.864128920955139730e-04,
-2.033060612946117147e-04,
-2.201790140297043533e-04,
-2.370311788555291702e-04,
-2.538619854952655535e-04,
-2.706708648596152208e-04,
-2.874572490655805741e-04,
-3.042205714556028471e-04,
-3.209602666162620710e-04,
-3.376757703969292560e-04,
-3.543665199287255631e-04,
-3.710319536430503433e-04,
-3.876715112900554010e-04,
-4.042846339574174123e-04,
-4.208707640886937928e-04,
-4.374293455015668391e-04,
-4.539598234066371803e-04,
-4.704616444251858830e-04,
-4.869342566076348910e-04,
-5.033771094519475615e-04,
-5.197896539211989755e-04,
-5.361713424620450502e-04,
-5.525216290225209645e-04,
-5.688399690698212616e-04,
-5.851258196083648257e-04,
-6.013786391974347426e-04,
-6.175978879687543015e-04,
-6.337830276443470572e-04,
-6.499335215539753545e-04,
-6.660488346525003569e-04,
-6.821284335375427240e-04,
-6.981717864666570246e-04,
-7.141783633746936078e-04,
-7.301476358908313112e-04,
-7.460790773559497404e-04,
-7.619721628395594113e-04,
-7.778263691566632623e-04,
-7.936411748849067811e-04,
-8.094160603812844759e-04,
-8.251505077987782589e-04,
-8.408440011032780473e-04,
-8.564960260900683587e-04,
-8.721060704002296876e-04,
-8.876736235373331591e-04,
-9.031981768836940200e-04,
-9.186792237165040259e-04,
-9.341162592244755701e-04,
-9.495087805234736023e-04,
-9.648562866728153074e-04,
-9.801582786914471608e-04,
-9.954142595733730167e-04,
-1.010623734303864448e-03,
-1.025786209875047131e-03,
-1.040901195301440711e-03,
-1.055968201635741534e-03,
-1.070986741984194471e-03,
-1.085956331521887100e-03,
-1.100876487508279170e-03,
-1.115746729302316814e-03,
-1.130566578377481058e-03,
-1.145335558337052737e-03,
-1.160053194928943512e-03,
-1.174719016060653959e-03,
-1.189332551813925259e-03,
-1.203893334459678853e-03,
-1.218400898472508107e-03,
-1.232854780545124436e-03,
-1.247254519603012684e-03,
-1.261599656818680358e-03,
-1.275889735625817742e-03,
-1.290124301733684611e-03,
-1.304302903141093184e-03,
-1.318425090150261410e-03,
-1.332490415381103839e-03,
-1.346498433784584650e-03,
-1.360448702656653561e-03,
-1.374340781652071998e-03,
-1.388174232797503328e-03,
-1.401948620505332962e-03,
-1.415663511586873723e-03,
-1.429318475265512877e-03,
-1.442913083190082305e-03,
-1.456446909447817748e-03,
-1.469919530577209208e-03,
-1.483330525581101579e-03,
-1.496679475939345985e-03,
-1.509965965621383032e-03,
-1.523189581099033789e-03,
-1.536349911358841913e-03,
-1.549446547914526797e-03,
-1.562479084819148097e-03,
-1.575447118677479521e-03,
-1.588350248658021132e-03,
-1.601188076504874184e-03,
-1.613960206549843856e-03,
-1.626666245724121959e-03,
-1.639305803569900697e-03,
-1.651878492252147100e-03,
-1.664383926569994523e-03,
-1.676821723968053039e-03,
-1.689191504547871842e-03,
-1.701492891079052754e-03,
-1.713725509010190912e-03,
-1.725888986480212696e-03,
-1.737982954328848046e-03,
-1.750007046107611257e-03,
-1.761960898090625654e-03,
-1.773844149284828755e-03,
-1.785656441440761815e-03,
-1.797397419062814672e-03,
-1.809066729419389922e-03,
-1.820664022553250549e-03,
-1.832188951291454900e-03,
-1.843641171255244173e-03,
-1.855020340870024891e-03,
-1.866326121375043879e-03,
-1.877558176832909952e-03,
-1.888716174139296001e-03,
-1.899799783032231045e-03,
-1.910808676101479224e-03,
-1.921742528797605902e-03,
-1.932601019441257569e-03,
-1.943383829232062055e-03,
-1.954090642257417729e-03,
-1.964721145501425147e-03,
-1.975275028853488470e-03,
-1.985751985116759443e-03,
-1.996151710016768731e-03,
-2.006473902209661517e-03,
-2.016718263290338559e-03,
-2.026884497800854421e-03,
-2.036972313238080614e-03,
-2.046981420061782467e-03,
-2.056911531702530337e-03,
-2.066762364569079986e-03,
-2.076533638056201822e-03,
-2.086225074552036565e-03,
-2.095836399445395824e-03,
-2.105367341133113860e-03,
-2.114817631027121354e-03,
-2.124187003561391670e-03,
-2.133475196198975597e-03,
-2.142681949438734676e-03,
-2.151807006821945725e-03,
-2.160850114939025929e-03,
-2.169811023435881496e-03,
-2.178689485020306616e-03,
-2.187485255468139562e-03,
-2.196198093629492948e-03,
-2.204827761434732889e-03,
-2.213374023900284253e-03,
-2.221836649134557341e-03,
-2.230215408343553217e-03,
-2.238510075836361475e-03,
-2.246720429030736946e-03,
-2.254846248458377590e-03,
-2.262887317770027190e-03,
-2.270843423740868169e-03,
-2.278714356275198406e-03,
-2.286499908411471476e-03,
-2.294199876327154743e-03,
-2.301814059343170252e-03,
-2.309342259928545520e-03,
-2.316784283704942469e-03,
-2.324139939450758745e-03,
-2.331409039105489245e-03,
-2.338591397773778866e-03,
-2.345686833729308720e-03,
-2.352695168418789898e-03,
-2.359616226465625476e-03,
-2.366449835673515266e-03,
-2.373195827030067078e-03,
-2.379854034710134764e-03,
-2.386424296079064315e-03,
-2.392906451695991574e-03,
-2.399300345316785193e-03,
-2.405605823897073291e-03,
-2.411822737594990392e-03,
-2.417950939773975960e-03,
-2.423990287005361316e-03,
-2.429940639070788267e-03,
-2.435801858964683261e-03,
-2.441573812896472625e-03,
-2.447256370292683753e-03,
-2.452849403799065367e-03,
-2.458352789282454952e-03,
-2.463766405832544266e-03,
-2.469090135763703404e-03,
-2.474323864616379855e-03,
-2.479467481158641965e-03,
-2.484520877387640884e-03,
-2.489483948530601086e-03,
-2.494356593046149172e-03,
-2.499138712625235004e-03,
-2.503830212191987797e-03,
-2.508430999904583906e-03,
-2.512940987155854854e-03,
-2.517360088573823793e-03,
-2.521688222022191658e-03,
-2.525925308600637711e-03,
-2.530071272644994311e-03,
-2.534126041727406946e-03,
-2.538089546656280455e-03,
-2.541961721476165836e-03,
-2.545742503467477054e-03,
-2.549431833146199172e-03,
-2.553029654263378346e-03,
-2.556535913804529412e-03,
-2.559950561988982767e-03,
-2.563273552269072515e-03,
-2.566504841329154615e-03,
-2.569644389084662327e-03,
-2.572692158680916618e-03,
-2.575648116491852883e-03,
-2.578512232118726401e-03,
-2.581284478388535478e-03,
-2.583964831352494450e-03,
-2.586553270284343634e-03,
-2.589049777678469316e-03,
-2.591454339248050638e-03,
-2.593766943922974893e-03,
-2.595987583847706847e-03,
-2.598116254379029266e-03,
-2.600152954083700171e-03,
-2.602097684735915368e-03,
-2.603950451314773588e-03,
-2.605711262001578557e-03,
-2.607380128176964556e-03,
-2.608957064418064489e-03,
-2.610442088495431613e-03,
-2.611835221369905764e-03,
-2.613136487189372456e-03,
-2.614345913285426575e-03,
-2.615463530169873877e-03,
-2.616489371531168298e-03,
-2.617423474230767735e-03,
-2.618265878299298570e-03,
-2.619016626932676398e-03,
-2.619675766488092743e-03,
-2.620243346479944092e-03,
-2.620719419575551039e-03,
-2.621104041590865269e-03,
-2.621397271486054694e-03,
-2.621599171360936356e-03,
-2.621709806450329104e-03,
-2.621729245119329074e-03,
-2.621657558858413867e-03,
-2.621494822278536748e-03,
-2.621241113105987532e-03,
-2.620896512177283821e-03,
-2.620461103433857544e-03,
-2.619934973916676884e-03,
-2.619318213760788404e-03,
-2.618610916189677024e-03,
-2.617813177509622103e-03,
-2.616925097103871799e-03,
-2.615946777426744578e-03,
-2.614878323997642685e-03,
-2.613719845394937239e-03,
-2.612471453249755760e-03,
-2.611133262239682083e-03,
-2.609705390082333546e-03,
-2.608187957528867919e-03,
-2.606581088357365870e-03,
-2.604884909366092863e-03,
-2.603099550366718123e-03,
-2.601225144177377914e-03,
-2.599261826615687204e-03,
-2.597209736491587831e-03,
-2.595069015600168921e-03,
-2.592839808714354159e-03,
-2.590522263577480638e-03,
-2.588116530895784046e-03,
-2.585622764330814446e-03,
-2.583041120491725434e-03,
-2.580371758927477860e-03,
-2.577614842118926882e-03,
-2.574770535470858289e-03,
-2.571839007303886905e-03,
-2.568820428846241375e-03,
-2.565714974225561523e-03,
-2.562522820460441577e-03,
-2.559244147451999411e-03,
-2.555879137975350379e-03,
-2.552427977670860409e-03,
-2.548890855035479321e-03,
-2.545267961413874656e-03,
-2.541559490989460553e-03,
-2.537765640775423159e-03,
-2.533886610605586443e-03,
-2.529922603125147468e-03,
-2.525873823781459374e-03,
-2.521740480814609227e-03,
-2.517522785247862729e-03,
-2.513220950878219517e-03,
-2.508835194266660542e-03,
-2.504365734728393293e-03,
-2.499812794323096575e-03,
-2.495176597844889470e-03,
-2.490457372812371426e-03,
-2.485655349458532667e-03,
-2.480770760720511087e-03,
-2.475803842229359984e-03,
-2.470754832299672243e-03,
-2.465623971919132535e-03,
-2.460411504737971058e-03,
-2.455117677058338797e-03,
-2.449742737823678001e-03,
-2.444286938607828988e-03,
-2.438750533604205472e-03,
-2.433133779614897029e-03,
-2.427436936039533040e-03,
-2.421660264864217756e-03,
-2.415804030650362585e-03,
-2.409868500523330587e-03,
-2.403853944161117411e-03,
-2.397760633782941575e-03,
-2.391588844137620094e-03,
-2.385338852492089375e-03,
-2.379010938619688462e-03,
-2.372605384788281820e-03,
-2.366122475748636683e-03,
-2.359562498722322064e-03,
-2.352925743389808547e-03,
-2.346212501878410656e-03,
-2.339423068750080912e-03,
-2.332557740989229904e-03,
-2.325616817990466562e-03,
-2.318600601546145449e-03,
-2.311509395833970856e-03,
-2.304343507404537153e-03,
-2.297103245168618472e-03,
-2.289788920384601065e-03,
-2.282400846645691889e-03,
-2.274939339867196580e-03,
-2.267404718273537210e-03,
-2.259797302385340746e-03,
-2.252117415006508420e-03,
-2.244365381210991061e-03,
-2.236541528329695841e-03,
-2.228646185937323190e-03,
-2.220679685838953046e-03,
-2.212642362056764251e-03,
-2.204534550816645080e-03,
-2.196356590534531000e-03,
-2.188108821803062473e-03,
-2.179791587377859392e-03,
-2.171405232163728730e-03,
-2.162950103201105936e-03,
-2.154426549652156339e-03,
-2.145834922786777656e-03,
-2.137175575968873562e-03,
-2.128448864642174931e-03,
-2.119655146316225865e-03,
-2.110794780552320733e-03,
-2.101868128949198767e-03,
-2.092875555128855328e-03,
-2.083817424722296356e-03,
-2.074694105355035650e-03,
-2.065505966632739596e-03,
-2.056253380126815081e-03,
-2.046936719359723766e-03,
-2.037556359790489331e-03,
-2.028112678799986156e-03,
-2.018606055676321672e-03,
-2.009036871599933355e-03,
-1.999405509628864389e-03,
-1.989712354683912266e-03,
-1.979957793533612589e-03,
-1.970142214779297025e-03,
-1.960266008840141298e-03,
-1.950329567937958810e-03,
-1.940333286082108121e-03,
-1.930277559054421020e-03,
-1.920162784393713608e-03,
-1.909989361380793520e-03,
-1.899757691022988578e-03,
-1.889468176038648769e-03,
-1.879121220841985847e-03,
-1.868717231527378857e-03,
-1.858256615853903218e-03,
-1.847739783229880627e-03,
-1.837167144697080933e-03,
-1.826539112915175327e-03,
-1.815856102146073308e-03,
-1.805118528238050394e-03,
-1.794326808610024809e-03,
-1.783481362235813565e-03,
-1.772582609628096462e-03,
-1.761630972822604297e-03,
-1.750626875362130790e-03,
-1.739570742280604565e-03,
-1.728463000086948205e-03,
-1.717304076749042677e-03,
-1.706094401677717143e-03,
-1.694834405710432578e-03,
-1.683524521095187227e-03,
-1.672165181474358307e-03,
-1.660756821868290432e-03,
-1.649299878659098726e-03,
-1.637794789574415107e-03,
-1.626241993670769640e-03,
-1.614641931317498807e-03,
-1.602995044180207307e-03,
-1.591301775204105162e-03,
-1.579562568597891493e-03,
-1.567777869816914908e-03,
-1.555948125546735691e-03,
-1.544073783686638560e-03,
-1.532155293332825366e-03,
-1.520193104761887945e-03,
-1.508187669414200530e-03,
-1.496139439877064740e-03,
-1.484048869868059275e-03,
-1.471916414218397843e-03,
-1.459742528855953155e-03,
-1.447527670788567589e-03,
-1.435272298087297057e-03,
-1.422976869869402479e-03,
-1.410641846281582377e-03,
-1.398267688483028530e-03,
-1.385854858628626264e-03,
-1.373403819851821018e-03,
-1.360915036247790878e-03,
-1.348388972856510038e-03,
-1.335826095645604745e-03,
-1.323226871493403314e-03,
-1.310591768172013035e-03,
-1.297921254330072901e-03,
-1.285215799475769149e-03,
-1.272475873959882237e-03,
-1.259701948958351359e-03,
-1.246894496455535880e-03,
-1.234053989226921010e-03,
-1.221180900821773390e-03,
-1.208275705546386913e-03,
-1.195338878446561368e-03,
-1.182370895290567672e-03,
-1.169372232552012489e-03,
-1.156343367392464539e-03,
-1.143284777644328759e-03,
-1.130196941793702248e-03,
-1.117080338962963279e-03,
-1.103935448893619657e-03,
-1.090762751929138423e-03,
-1.077562728997507116e-03,
-1.064335861594093184e-03,
-1.051082631764306509e-03,
-1.037803522086443641e-03,
-1.024499015654222389e-03,
-1.011169596059586367e-03,
-9.978157473755110748e-04,
-9.844379541385115881e-04,
-9.710367013314586109e-04,
-9.576124743663553792e-04,
-9.441657590668645506e-04,
-9.306970416510967122e-04,
-9.172068087144401955e-04,
-9.036955472119038687e-04,
-8.901637444412496608e-04,
-8.766118880254890940e-04,
-8.630404658954084381e-04,
-8.494499662726913685e-04,
-8.358408776522746608e-04,
-8.222136887852057614e-04,
-8.085688886614483166e-04,
-7.949069664924277110e-04,
-7.812284116938512327e-04,
-7.675337138685592482e-04,
-7.538233627890643428e-04,
-7.400978483804155055e-04,
-7.263576607030540738e-04,
-7.126032899353896286e-04,
-6.988352263567237021e-04,
-6.850539603299628244e-04,
-6.712599822845673843e-04,
-6.574537826991594001e-04,
-6.436358520844570694e-04,
-6.298066809662091012e-04,
-6.159667598678487824e-04,
-6.021165792934638720e-04,
-5.882566297107762535e-04,
-5.743874015338354660e-04,
-5.605093851060412909e-04,
-5.466230706831593997e-04,
-5.327289484160722391e-04,
-5.188275083338409746e-04,
-5.049192403268192584e-04,
-4.910046341292870209e-04,
-4.770841793028953001e-04,
-4.631583652195109648e-04,
-4.492276810440716289e-04,
-4.352926157180945577e-04,
-4.213536579424142711e-04,
-4.074112961604362286e-04,
-3.934660185413807552e-04,
-3.795183129632495752e-04,
-3.655686669961199912e-04,
-3.516175678854574407e-04,
-3.376655025351574355e-04,
-3.237129574909094554e-04,
-3.097604189235913619e-04,
-2.958083726123844669e-04,
-2.818573039282544664e-04,
-2.679076978172545095e-04,
-2.539600387840648416e-04,
-2.400148108752173505e-04,
-2.260724976626562967e-04,
-2.121335822273299977e-04,
-1.981985471425053093e-04,
-1.842678744574233857e-04,
-1.703420456809773146e-04,
-1.564215417651290002e-04,
-1.425068430886536396e-04,
-1.285984294409557550e-04,
-1.146967800054122573e-04,
-1.008023733435576224e-04,
-8.691568737866478794e-05,
-7.303719937936182843e-05,
-5.916738594392185210e-05,
-4.530672298378503213e-05,
-3.145568570761954038e-05,
-1.761474860538695696e-05,
-3.784385432144545134e-06,
 1.003493080781320573e-05,
 2.384272787677377340e-05,
 3.763853431968683806e-05,
 5.142187947990367949e-05,
 6.519229351487651567e-05,
 7.894930741211600542e-05,
 9.269245300477468277e-05,
 1.064212629873866587e-04,
 1.201352709313665217e-04,
 1.338340113007963105e-04,
 1.475170194678704621e-04,
 1.611838317282952772e-04,
 1.748339853169438105e-04,
 1.884670184231668243e-04,
 2.020824702060562954e-04,
 2.156798808099616763e-04,
 2.292587913796625184e-04,
 2.428187440754936888e-04,
 2.563592820887157248e-04,
 2.698799496565497912e-04,
 2.833802920771181480e-04,
 2.968598557248405541e-04,
 3.103181880649821724e-04,
 3.237548376687864851e-04,
 3.371693542285444565e-04,
 3.505612885719995683e-04,
 3.639301926774864268e-04,
 3.772756196885171842e-04,
 3.905971239283597221e-04,
 4.038942609148517553e-04,
 4.171665873748641438e-04,
 4.304136612587164987e-04,
 4.436350417548291444e-04,
 4.568302893040243964e-04,
 4.699989656137736819e-04,
 4.831406336726886070e-04,
 4.962548577646155304e-04,
 5.093412034828837150e-04,
 5.223992377442921321e-04,
 5.354285288033688341e-04,
 5.484286462662718359e-04,
 5.613991611046417491e-04,
 5.743396456696796054e-04,
 5.872496737058781682e-04,
 6.001288203646896026e-04,
 6.129766622184250552e-04,
 6.257927772738085910e-04,
 6.385767449854253116e-04,
 6.513281462696002277e-04,
 6.640465635174451139e-04,
 6.767315806084485495e-04,
 6.893827829239955940e-04,
 7.019997573602329306e-04,
 7.145820923416265971e-04,
 7.271293778339721955e-04,
 7.396412053573895966e-04,
 7.521171679995203915e-04,
 7.645568604283829511e-04,
 7.769598789051636268e-04,
 7.893258212972229480e-04,
 8.016542870907484783e-04,
 8.139448774033519437e-04,
 8.261971949968673718e-04,
 8.384108442897719293e-04,
 8.505854313697414158e-04,
 8.627205640059568267e-04,
 8.748158516614874597e-04,
 8.868709055057746350e-04,
 8.988853384264395251e-04,
 9.108587650417573336e-04,
 9.227908017125892662e-04,
 9.346810665543010561e-04,
 9.465291794488509512e-04,
 9.583347620565619814e-04,
 9.700974378278031524e-04,
 9.818168320148811922e-04,
 9.934925716835810161e-04,
 1.005124285724643416e-03,
 1.016711604865424461e-03,
 1.028254161681230834e-03,
 1.039751590606563005e-03,
 1.051203527946563323e-03,
 1.062609611888090709e-03,
 1.073969482510894443e-03,
 1.085282781798541400e-03,
 1.096549153649555583e-03,
 1.107768243888224147e-03,
 1.118939700275323190e-03,
 1.130063172519025702e-03,
 1.141138312285480986e-03,
 1.152164773209312341e-03,
 1.163142210904289080e-03,
 1.174070282973681094e-03,
 1.184948649020485696e-03,
 1.195776970658007487e-03,
 1.206554911519707026e-03,
 1.217282137269453919e-03,
 1.227958315611757780e-03,
 1.238583116301336532e-03,
 1.249156211153327643e-03,
 1.259677274052940993e-03,
 1.270145980965112610e-03,
 1.280562009944304124e-03,
 1.290925041143962428e-03,
 1.301234756825922967e-03,
 1.311490841369952450e-03,
 1.321692981282995144e-03,
 1.331840865208296218e-03,
 1.341934183934728481e-03,
 1.351972630405738141e-03,
 1.361955899728375984e-03,
 1.371883689182099367e-03,
 1.381755698227735531e-03,
 1.391571628516134187e-03,
 1.401331183896738133e-03,
 1.411034070426305442e-03,
 1.420679996377294035e-03,
 1.430268672246206565e-03,
 1.439799810762027463e-03,
 1.449273126894383510e-03,
 1.458688337861585799e-03,
 1.468045163138944264e-03,
 1.477343324466433858e-03,
 1.486582545856708973e-03,
 1.495762553603052596e-03,
 1.504883076286776204e-03,
 1.513943844785108420e-03,
 1.522944592278623098e-03,
 1.531885054258645944e-03,
 1.540764968534732689e-03,
 1.549584075241897466e-03,
 1.558342116847726260e-03,
 1.567038838159603769e-03,
 1.575673986331685037e-03,
 1.584247310871744361e-03,
 1.592758563648128062e-03,
 1.601207498896456806e-03,
 1.609593873226296485e-03,
 1.617917445627661257e-03,
 1.626177977477630873e-03,
 1.634375232546680023e-03,
 1.642508977004914026e-03,
 1.650578979428419862e-03,
 1.658585010805350502e-03,
 1.666526844541858744e-03,
 1.674404256468221656e-03,
 1.682217024844604629e-03,
 1.689964930366786612e-03,
 1.697647756171960813e-03,
 1.705265287844256105e-03,
 1.712817313420174955e-03,
 1.720303623394203296e-03,
 1.727724010723885248e-03,
 1.735078270835176692e-03,
 1.742366201627682399e-03,
 1.749587603479466850e-03,
 1.756742279252218077e-03,
 1.763830034296034414e-03,
 1.770850676454154438e-03,
 1.777804016067738952e-03,
 1.784689865980413140e-03,
 1.791508041542726106e-03,
 1.798258360616640994e-03,
 1.804940643579835795e-03,
 1.811554713329843703e-03,
 1.818100395288312727e-03,
 1.824577517404984929e-03,
 1.830985910161663085e-03,
 1.837325406576016456e-03,
 1.843595842205445531e-03,
 1.849797055150713453e-03,
 1.855928886059470765e-03,
 1.861991178129858426e-03,
 1.867983777113846073e-03,
 1.873906531320505874e-03,
 1.879759291619306771e-03,
 1.885541911443204240e-03,
 1.891254246791608182e-03,
 1.896896156233477456e-03,
 1.902467500909993956e-03,
 1.907968144537376112e-03,
 1.913397953409655319e-03,
 1.918756796401043831e-03,
 1.924044544968564604e-03,
 1.929261073154400980e-03,
 1.934406257588114960e-03,
 1.939479977488959379e-03,
 1.944482114667925310e-03,
 1.949412553529728540e-03,
 1.954271181074799298e-03,
 1.959057886901082249e-03,
 1.963772563205741072e-03,
 1.968415104786856110e-03,
 1.972985409044957211e-03,
 1.977483375984490435e-03,
 1.981908908215129078e-03,
 1.986261910953155373e-03,
 1.990542292022571148e-03,
 1.994749961856175959e-03,
 1.998884833496626136e-03,
 2.002946822597313423e-03,
 2.006935847423141697e-03,
 2.010851828851323211e-03,
 2.014694690371954516e-03,
 2.018464358088560735e-03,
 2.022160760718570878e-03,
 2.025783829593660011e-03,
 2.029333498659963066e-03,
 2.032809704478360634e-03,
 2.036212386224432562e-03,
 2.039541485688503488e-03,
 2.042796947275586465e-03,
 2.045978718005082419e-03,
 2.049086747510584124e-03,
 2.052120988039468543e-03,
 2.055081394452392025e-03,
 2.057967924222793739e-03,
 2.060780537436214793e-03,
 2.063519196789532790e-03,
 2.066183867590179902e-03,
 2.068774517755183565e-03,
 2.071291117810150368e-03,
 2.073733640888187919e-03,
 2.076102062728693142e-03,
 2.078396361676073355e-03,
 2.080616518678343740e-03,
 2.082762517285720923e-03,
 2.084834343649020084e-03,
 2.086831986518014777e-03,
 2.088755437239719556e-03,
 2.090604689756560275e-03,
 2.092379740604448108e-03,
 2.094080588910797198e-03,
 2.095707236392428674e-03,
 2.097259687353357580e-03,
 2.098737948682601918e-03,
 2.100142029851721943e-03,
 2.101471942912438388e-03,
 2.102727702494117112e-03,
 2.103909325801078117e-03,
 2.105016832609929271e-03,
 2.106050245266780346e-03,
 2.107009588684301792e-03,
 2.107894890338809536e-03,
 2.108706180267171538e-03,
 2.109443491063663165e-03,
 2.110106857876746251e-03,
 2.110696318405726277e-03,
 2.111211912897355356e-03,
 2.111653684142340229e-03,
 2.112021677471759631e-03,
 2.112315940753387109e-03,
 2.112536524387950091e-03,
 2.112683481305283138e-03,
 2.112756866960412670e-03,
 2.112756739329533281e-03,
 2.112683158905939371e-03,
 2.112536188695814544e-03,
 2.112315894213987605e-03,
 2.112022343479581874e-03,
 2.111655607011592509e-03,
 2.111215757824335456e-03,
 2.110702871422896840e-03,
 2.110117025798416250e-03,
 2.109458301423333161e-03,
 2.108726781246521038e-03,
 2.107922550688401050e-03,
 2.107045697635872780e-03,
 2.106096312437240586e-03,
 2.105074487897046730e-03,
 2.103980319270796519e-03,
 2.102813904259625329e-03,
 2.101575343004864153e-03,
 2.100264738082545293e-03,
 2.098882194497815688e-03,
 2.097427819679274340e-03,
 2.095901723473217373e-03,
 2.094304018137826701e-03,
 2.092634818337245090e-03,
 2.090894241135625182e-03,
 2.089082405991029776e-03,
 2.087199434749298279e-03,
 2.085245451637858950e-03,
 2.083220583259387613e-03,
 2.081124958585432554e-03,
 2.078958708949997340e-03,
 2.076721968042984437e-03,
 2.074414871903566826e-03,
 2.072037558913545751e-03,
 2.069590169790545397e-03,
 2.067072847581198029e-03,
 2.064485737654243262e-03,
 2.061828987693473808e-03,
 2.059102747690749746e-03,
 2.056307169938837581e-03,
 2.053442409024124841e-03,
 2.050508621819431814e-03,
 2.047505967476580865e-03,
 2.044434607418977451e-03,
 2.041294705334110917e-03,
 2.038086427165959006e-03,
 2.034809941107314744e-03,
 2.031465417592101617e-03,
 2.028053029287517437e-03,
 2.024572951086202506e-03,
 2.021025360098280699e-03,
 2.017410435643345479e-03,
 2.013728359242357869e-03,
 2.009979314609512333e-03,
 2.006163487644011152e-03,
 2.002281066421740356e-03,
 1.998332241186918327e-03,
 1.994317204343682391e-03,
 1.990236150447547911e-03,
 1.986089276196848722e-03,
 1.981876780424123366e-03,
 1.977598864087367746e-03,
 1.973255730261267837e-03,
 1.968847584128403331e-03,
 1.964374632970249633e-03,
 1.959837086158296073e-03,
 1.955235155144985013e-03,
 1.950569053454505016e-03,
 1.945838996673796744e-03,
 1.941045202443159425e-03,
 1.936187890447020827e-03,
 1.931267282404606394e-03,
 1.926283602060424073e-03,
 1.921237075174835225e-03,
 1.916127929514514945e-03,
 1.910956394842768620e-03,
 1.905722702909912669e-03,
 1.900427087443524315e-03,
 1.895069784138626087e-03,
 1.889651030647817621e-03,
 1.884171066571403578e-03,
 1.878630133447349148e-03,
 1.873028474741268322e-03,
 1.867366335836318251e-03,
 1.861643964023076709e-03,
 1.855861608489251706e-03,
 1.850019520309443806e-03,
 1.844117952434858130e-03,
 1.838157159682819904e-03,
 1.832137398726381081e-03,
 1.826058928083855188e-03,
 1.819922008108162004e-03,
 1.813726900976284128e-03,
 1.807473870678615556e-03,
 1.801163183008099283e-03,
 1.794795105549638978e-03,
 1.788369907669168715e-03,
 1.781887860502688430e-03,
 1.775349236945506035e-03,
 1.768754311641083585e-03,
 1.762103360970061674e-03,
 1.755396663039198845e-03,
 1.748634497670127760e-03,
 1.741817146388230202e-03,
 1.734944892411401053e-03,
 1.728018020638672414e-03,
 1.721036817638919685e-03,
 1.714001571639494140e-03,
 1.706912572514700027e-03,
 1.699770111774344091e-03,
 1.692574482552179713e-03,
 1.685325979594372303e-03,
 1.678024899247770613e-03,
 1.670671539448269783e-03,
 1.663266199709131010e-03,
 1.655809181109113874e-03,
 1.648300786280702769e-03,
 1.640741319398281942e-03,
 1.633131086166164821e-03,
 1.625470393806639595e-03,
 1.617759551048077692e-03,
 1.609998868112706358e-03,
 1.602188656704740767e-03,
 1.594329229998150965e-03,
 1.586420902624418846e-03,
 1.578463990660538847e-03,
 1.570458811616589744e-03,
 1.562405684423515476e-03,
 1.554304929420853923e-03,
 1.546156868344276611e-03,
 1.537961824313212756e-03,
 1.529720121818502589e-03,
 1.521432086709751004e-03,
 1.513098046182983266e-03,
 1.504718328767960713e-03,
 1.496293264315633718e-03,
 1.487823183985612432e-03,
 1.479308420233270849e-03,
 1.470749306797338764e-03,
 1.462146178687012774e-03,
 1.453499372169110440e-03,
 1.444809224755494621e-03,
 1.436076075190113139e-03,
 1.427300263436045383e-03,
 1.418482130662850537e-03,
 1.409622019233407750e-03,
 1.400720272691062052e-03,
 1.391777235746696545e-03,
 1.382793254265570404e-03,
 1.373768675254356158e-03,
 1.364703846848107143e-03,
 1.355599118297046504e-03,
 1.346454839953469375e-03,
 1.337271363258676080e-03,
 1.328049040729629721e-03,
 1.318788225945840588e-03,
 1.309489273536077738e-03,
 1.300152539165186838e-03,
 1.290778379520667951e-03,
 1.281367152299423126e-03,
 1.271919216194482066e-03,
 1.262434930881500134e-03,
 1.252914657005442609e-03,
 1.243358756167227321e-03,
 1.233767590910178407e-03,
 1.224141524706606277e-03,
 1.214480921944446120e-03,
 1.204786147913507188e-03,
 1.195057568792231434e-03,
 1.185295551634034513e-03,
 1.175500464353615784e-03,
 1.165672675713652542e-03,
 1.155812555310984464e-03,
 1.145920473563070627e-03,
 1.135996801694428952e-03,
 1.126041911722864674e-03,
 1.116056176445858394e-03,
 1.106039969426959781e-03,
 1.095993664981965944e-03,
 1.085917638165263517e-03,
 1.075812264756172056e-03,
 1.065677921245086410e-03,
 1.055514984819789972e-03,
 1.045323833351663196e-03,
 1.035104845381990771e-03,
 1.024858400108028325e-03,
 1.014584877369272518e-03,
 1.004284657633722905e-03,
 9.939581219839152375e-04,
 9.836056521031514514e-04,
 9.732276302617416794e-04,
 9.628244393029964689e-04,
 9.523964626294466806e-04,
 9.419440841890658811e-04,
 9.314676884611259493e-04,
 9.209676604426418394e-04,
 9.104443856343186941e-04,
 8.998982500265211839e-04,
 8.893296400856626508e-04,
 8.787389427401446317e-04,
 8.681265453663104771e-04,
 8.574928357748379639e-04,
 8.468382021965543526e-04,
 8.361630332686124847e-04,
 8.254677180206433521e-04,
 8.147526458606703598e-04,
 8.040182065612653649e-04,
 7.932647902456876942e-04,
 7.824927873738035016e-04,
 7.717025887282345439e-04,
 7.608945854004969811e-04,
 7.500691687769247456e-04,
 7.392267305248401100e-04,
 7.283676625785744183e-04,
 7.174923571256488445e-04,
 7.066012065926979792e-04,
 6.956946036316235919e-04,
 6.847729411057636812e-04,
 6.738366120758258184e-04,
 6.628860097860484997e-04,
 6.519215276503942651e-04,
 6.409435592384841269e-04,
 6.299524982617935075e-04,
 6.189487385598709457e-04,
 6.079326740861809098e-04,
 5.969046988945631970e-04,
 5.858652071252303537e-04,
 5.748145929907501339e-04,
 5.637532507625433878e-04,
 5.526815747567657977e-04,
 5.415999593205905521e-04,
 5.305087988184719380e-04,
 5.194084876181841778e-04,
 5.082994200771124519e-04,
 4.971819905285536790e-04,
 4.860565932677927037e-04,
 4.749236225384207495e-04,
 4.637834725186874276e-04,
 4.526365373076032166e-04,
 4.414832109113394471e-04,
 4.303238872294752517e-04,
 4.191589600414256304e-04,
 4.079888229926087657e-04,
 3.968138695808784248e-04,
 3.856344931429704572e-04,
 3.744510868407237769e-04,
 3.632640436475634521e-04,
 3.520737563349943646e-04,
 3.408806174588811734e-04,
 3.296850193459841503e-04,
 3.184873540805376242e-04,
 3.072880134904547550e-04,
 2.960873891341862449e-04,
 2.848858722870988014e-04,
 2.736838539278663401e-04,
 2.624817247254022587e-04,
 2.512798750251605422e-04,
 2.400786948358675954e-04,
 2.288785738162484366e-04,
 2.176799012615346959e-04,
 2.064830660902371054e-04,
 1.952884568309465026e-04,
 1.840964616089101882e-04,
 1.729074681328839416e-04,
 1.617218636820032273e-04,
 1.505400350924415720e-04,
 1.393623687443367397e-04,
 1.281892505487441480e-04,
 1.170210659343737274e-04,
 1.058581998346278647e-04,
 9.470103667450128593e-05,
 8.354996035767432098e-05,
 7.240535425336543421e-05,
 6.126760118345450765e-05,
 5.013708340963751178e-05,
 3.901418262036876765e-05,
 2.789927991807623472e-05,
 1.679275580640780355e-05,
 5.694990177268111283e-06,
-5.393637701871444205e-06,
-1.647274920060317176e-05,
-2.754196633858244566e-05,
-3.860091179785114649e-05,
-4.964920893563560302e-05,
-6.068648179711078077e-05,
-7.171235512762116492e-05,
-8.272645438550835261e-05,
-9.372840575450274521e-05,
-1.047178361561054217e-04,
-1.156943732621754073e-04,
-1.266576455072369542e-04,
-1.376072821007541459e-04,
-1.485429130396052541e-04,
-1.594641691202777626e-04,
-1.703706819510302157e-04,
-1.812620839642499276e-04,
-1.921380084285084159e-04,
-2.029980894607346883e-04,
-2.138419620381927760e-04,
-2.246692620106818003e-04,
-2.354796261124546069e-04,
-2.462726919741019499e-04,
-2.570480981346270075e-04,
-2.678054840532421792e-04,
-2.785444901211268790e-04,
-2.892647576733759851e-04,
-2.999659290006674280e-04,
-3.106476473608668393e-04,
-3.213095569909746470e-04,
-3.319513031184054643e-04,
-3.425725319727157417e-04,
-3.531728907972934181e-04,
-3.637520278604978270e-04,
-3.743095924673848552e-04,
-3.848452349709975532e-04,
-3.953586067836319172e-04,
-4.058493603882894251e-04,
-4.163171493498559199e-04,
-4.267616283262275299e-04,
-4.371824530796190596e-04,
-4.475792804875989997e-04,
-4.579517685540755311e-04,
-4.682995764204541029e-04,
-4.786223643765085117e-04,
-4.889197938713348663e-04,
-4.991915275241225409e-04,
-5.094372291351150243e-04,
-5.196565636962964139e-04,
-5.298491974020335098e-04,
-5.400147976598789141e-04,
-5.501530331011165228e-04,
-5.602635735912360037e-04,
-5.703460902405902864e-04,
-5.804002554147807014e-04,
-5.904257427449707786e-04,
-6.004222271383954186e-04,
-6.103893847885736440e-04,
-6.203268931854535873e-04,
-6.302344311258662596e-04,
-6.401116787233423512e-04,
-6.499583174183374504e-04,
-6.597740299883953548e-04,
-6.695585005578064694e-04,
-6.793114146077801167e-04,
-6.890324589862116805e-04,
-6.987213219173989001e-04,
-7.083776930119406370e-04,
-7.180012632763465913e-04,
-7.275917251225925931e-04,
-7.371487723778411254e-04,
-7.466721002938821227e-04,
-7.561614055565216196e-04,
-7.656163862951137315e-04,
-7.750367420918177893e-04,
-7.844221739909175992e-04,
-7.937723845079566048e-04,
-8.030870776390365475e-04,
-8.123659588698566763e-04,
-8.216087351846765221e-04,
-8.308151150754513855e-04,
-8.399848085506821365e-04,
-8.491175271442006137e-04,
-8.582129839241233989e-04,
-8.672708935015087384e-04,
-8.762909720389590361e-04,
-8.852729372594744491e-04,
-8.942165084547236149e-04,
-9.031214064936711906e-04,
-9.119873538311361110e-04,
-9.208140745158811466e-04,
-9.296012941991518624e-04,
-9.383487401428387093e-04,
-9.470561412275869647e-04,
-9.557232279610387285e-04,
-9.643497324858288063e-04,
-9.729353885874975419e-04,
-9.814799317025525108e-04,
-9.899830989262515743e-04,
-9.984446290203469014e-04,
-1.006864262420928196e-03,
-1.015241741246011246e-03,
-1.023576809303170486e-03,
-1.031869212096995060e-03,
-1.040118696836679537e-03,
-1.048325012443358968e-03,
-1.056487909557386490e-03,
-1.064607140545726716e-03,
-1.072682459509081976e-03,
-1.080713622288984738e-03,
-1.088700386474978710e-03,
-1.096642511411556435e-03,
-1.104539758205041371e-03,
-1.112391889730558660e-03,
-1.120198670638793614e-03,
-1.127959867362625292e-03,
-1.135675248124014443e-03,
-1.143344582940337192e-03,
-1.150967643631035974e-03,
-1.158544203824180691e-03,
-1.166074038962614185e-03,
-1.173556926310480655e-03,
-1.180992644959401707e-03,
-1.188380975834583660e-03,
-1.195721701701070797e-03,
-1.203014607169705001e-03,
-1.210259478703049193e-03,
-1.217456104621409633e-03,
-1.224604275108597809e-03,
-1.231703782217643530e-03,
-1.238754419876599532e-03,
-1.245755983894079356e-03,
-1.252708271964856832e-03,
-1.259611083675259971e-03,
-1.266464220508691733e-03,
-1.273267485850917242e-03,
-1.280020684995276416e-03,
-1.286723625147976387e-03,
-1.293376115433169694e-03,
-1.299977966897961339e-03,
-1.306528992517467895e-03,
-1.313029007199697498e-03,
-1.319477827790317736e-03,
-1.325875273077590719e-03,
-1.332221163796855172e-03,
-1.338515322635261797e-03,
-1.344757574236391754e-03,
-1.350947745204537313e-03,
-1.357085664109286723e-03,
-1.363171161489781444e-03,
-1.369204069858923284e-03,
-1.375184223707665455e-03,
-1.381111459509077027e-03,
-1.386985615722325206e-03,
-1.392806532796741310e-03,
-1.398574053175672283e-03,
-1.404288021300243534e-03,
-1.409948283613201778e-03,
-1.415554688562544513e-03,
-1.421107086605121741e-03,
-1.426605330210123411e-03,
-1.432049273862616087e-03,
-1.437438774066871231e-03,
-1.442773689349650121e-03,
-1.448053880263489848e-03,
-1.453279209389847938e-03,
-1.458449541342132262e-03,
-1.463564742768800123e-03,
-1.468624682356246998e-03,
-1.473629230831620049e-03,
-1.478578260965763679e-03,
-1.483471647575747244e-03,
-1.488309267527605914e-03,
-1.493090999738954467e-03,
-1.497816725181360829e-03,
-1.502486326882822602e-03,
-1.507099689930188526e-03,
-1.511656701471278527e-03,
-1.516157250717215616e-03,
-1.520601228944444680e-03,
-1.524988529496873555e-03,
-1.529319047787796844e-03,
-1.533592681301766160e-03,
-1.537809329596500707e-03,
-1.541968894304579507e-03,
-1.546071279135102393e-03,
-1.550116389875363151e-03,
-1.554104134392332278e-03,
-1.558034422634074897e-03,
-1.561907166631258453e-03,
-1.565722280498305433e-03,
-1.569479680434705902e-03,
-1.573179284726227475e-03,
-1.576821013745869846e-03,
-1.580404789954990407e-03,
-1.583930537904190260e-03,
-1.587398184234161411e-03,
-1.590807657676523990e-03,
-1.594158889054514503e-03,
-1.597451811283603831e-03,
-1.600686359372108496e-03,
-1.603862470421668152e-03,
-1.606980083627626349e-03,
-1.610039140279440149e-03,
-1.613039583760916048e-03,
-1.615981359550417709e-03,
-1.618864415220959418e-03,
-1.621688700440316461e-03,
-1.624454166970960931e-03,
-1.627160768669963942e-03,
-1.629808461488854677e-03,
-1.632397203473363650e-03,
-1.634926954763088339e-03,
-1.637397677591147325e-03,
-1.639809336283681558e-03,
-1.642161897259317247e-03,
-1.644455329028619633e-03,
-1.646689602193324078e-03,
-1.648864689445633715e-03,
-1.650980565567420613e-03,
-1.653037207429252156e-03,
-1.655034593989486392e-03,
-1.656972706293211896e-03,
-1.658851527471104587e-03,
-1.660671042738278043e-03,
-1.662431239393022137e-03,
-1.664132106815427621e-03,
-1.665773636466051470e-03,
-1.667355821884381655e-03,
-1.668878658687322075e-03,
-1.670342144567574065e-03,
-1.671746279291941350e-03,
-1.673091064699571903e-03,
-1.674376504700115240e-03,
-1.675602605271842190e-03,
-1.676769374459654953e-03,
-1.677876822373049887e-03,
-1.678924961183999622e-03,
-1.679913805124774902e-03,
-1.680843370485673180e-03,
-1.681713675612718376e-03,
-1.682524740905244186e-03,
-1.683276588813427963e-03,
-1.683969243835777094e-03,
-1.684602732516499602e-03,
-1.685177083442842639e-03,
-1.685692327242351842e-03,
-1.686148496580050461e-03,
-1.686545626155542578e-03,
-1.686883752700112874e-03,
-1.687162914973646408e-03,
-1.687383153761579406e-03,
-1.687544511871735993e-03,
-1.687647034131086647e-03,
-1.687690767382484316e-03,
-1.687675760481275634e-03,
-1.687602064291896745e-03,
-1.687469731684360921e-03,
-1.687278817530703029e-03,
-1.687029378701349622e-03,
-1.686721474061425932e-03,
-1.686355164466978940e-03,
-1.685930512761157083e-03,
-1.685447583770317750e-03,
-1.684906444300063658e-03,
-1.684307163131196824e-03,
-1.683649811015649990e-03,
-1.682934460672305286e-03,
-1.682161186782782326e-03,
-1.681330065987139992e-03,
-1.680441176879531604e-03,
-1.679494600003761861e-03,
-1.678490417848838793e-03,
-1.677428714844378908e-03,
-1.676309577356031649e-03,
-1.675133093680792381e-03,
-1.673899354042236677e-03,
-1.672608450585758499e-03,
-1.671260477373677413e-03,
-1.669855530380292023e-03,
-1.668393707486929721e-03,
-1.666875108476854406e-03,
-1.665299835030154474e-03,
-1.663667990718580274e-03,
-1.661979681000284219e-03,
-1.660235013214516860e-03,
-1.658434096576280690e-03,
-1.656577042170873136e-03,
-1.654663962948419798e-03,
-1.652694973718329616e-03,
-1.650670191143674588e-03,
-1.648589733735517223e-03,
-1.646453721847202000e-03,
-1.644262277668552498e-03,
-1.642015525220020178e-03,
-1.639713590346779815e-03,
-1.637356600712788724e-03,
-1.634944685794713056e-03,
-1.632477976875888791e-03,
-1.629956607040169547e-03,
-1.627380711165702818e-03,
-1.624750425918715119e-03,
-1.622065889747170480e-03,
-1.619327242874395775e-03,
-1.616534627292671566e-03,
-1.613688186756760722e-03,
-1.610788066777304106e-03,
-1.607834414614307773e-03,
-1.604827379270428291e-03,
-1.601767111484291885e-03,
-1.598653763723746363e-03,
-1.595487490179007227e-03,
-1.592268446755808111e-03,
-1.588996791068482926e-03,
-1.585672682432970153e-03,
-1.582296281859765959e-03,
-1.578867752046892933e-03,
-1.575387257372691009e-03,
-1.571854963888673004e-03,
-1.568271039312245938e-03,
-1.564635653019464442e-03,
-1.560948976037609612e-03,
-1.557211181037838552e-03,
-1.553422442327742192e-03,
-1.549582935843788183e-03,
-1.545692839143811281e-03,
-1.541752331399407882e-03,
-1.537761593388259872e-03,
-1.533720807486427468e-03,
-1.529630157660655720e-03,
-1.525489829460456147e-03,
-1.521300010010389172e-03,
-1.517060888002091327e-03,
-1.512772653686288811e-03,
-1.508435498864910997e-03,
-1.504049616882948293e-03,
-1.499615202620405196e-03,
-1.495132452484180261e-03,
-1.490601564399833111e-03,
-1.486022737803387650e-03,
-1.481396173633066533e-03,
-1.476722074320930677e-03,
-1.472000643784531979e-03,
-1.467232087418538075e-03,
-1.462416612086208344e-03,
-1.457554426110944067e-03,
-1.452645739267712172e-03,
-1.447690762774505192e-03,
-1.442689709283650080e-03,
-1.437642792873161917e-03,
-1.432550229038060318e-03,
-1.427412234681540342e-03,
-1.422229028106228180e-03,
-1.417000829005333855e-03,
-1.411727858453740592e-03,
-1.406410338899087261e-03,
-1.401048494152860998e-03,
-1.395642549381268232e-03,
-1.390192731096331642e-03,
-1.384699267146750771e-03,
-1.379162386708698883e-03,
-1.373582320276800451e-03,
-1.367959299654865780e-03,
-1.362293557946590719e-03,
-1.356585329546417060e-03,
-1.350834850130108213e-03,
-1.345042356645433958e-03,
-1.339208087302825060e-03,
-1.333332281565880210e-03,
-1.327415180141942137e-03,
-1.321457024972643585e-03,
-1.315458059224303231e-03,
-1.309418527278399672e-03,
-1.303338674722008539e-03,
-1.297218748338105181e-03,
-1.291058996095935212e-03,
-1.284859667141304614e-03,
-1.278621011786890008e-03,
-1.272343281502401249e-03,
-1.266026728904824043e-03,
-1.259671607748635456e-03,
-1.253278172915856144e-03,
-1.246846680406198419e-03,
-1.240377387327208257e-03,
-1.233870551884205195e-03,
-1.227326433370356249e-03,
-1.220745292156716648e-03,
-1.214127389682039199e-03,
-1.207472988442884199e-03,
-1.200782351983445710e-03,
-1.194055744885322767e-03,
-1.187293432757577458e-03,
-1.180495682226381446e-03,
-1.173662760924865231e-03,
-1.166794937482936194e-03,
-1.159892481516928585e-03,
-1.152955663619357812e-03,
-1.145984755348658903e-03,
-1.138980029218765802e-03,
-1.131941758688785864e-03,
-1.124870218152663071e-03,
-1.117765682928690326e-03,
-1.110628429249121930e-03,
-1.103458734249698455e-03,
-1.096256875959229294e-03,
-1.089023133289001525e-03,
-1.081757786022297194e-03,
-1.074461114803908863e-03,
-1.067133401129470192e-03,
-1.059774927334928120e-03,
-1.052385976585980135e-03,
-1.044966832867350211e-03,
-1.037517780972201358e-03,
-1.030039106491528441e-03,
-1.022531095803295986e-03,
-1.014994036061961109e-03,
-1.007428215187642544e-03,
-9.998339218552925074e-04,
-9.922114454841575969e-04,
-9.845610762268218463e-04,
-9.768831049584880862e-04,
-9.691778232662328491e-04,
-9.614455234380709986e-04,
-9.536864984521881920e-04,
-9.459010419661369141e-04,
-9.380894483058657609e-04,
-9.302520124549044141e-04,
-9.223890300435129462e-04,
-9.145007973376844323e-04,
-9.065876112282719203e-04,
-8.986497692201181114e-04,
-8.906875694210047382e-04,
-8.827013105307699933e-04,
-8.746912918303075641e-04,
-8.666578131706672563e-04,
-8.586011749619550408e-04,
-8.505216781623951882e-04,
-8.424196242673797188e-04,
-8.342953152983453554e-04,
-8.261490537917942417e-04,
-8.179811427883309236e-04,
-8.097918858215022225e-04,
-8.015815869068038590e-04,
-7.933505505307068091e-04,
-7.850990816393778066e-04,
-7.768274856278670291e-04,
-7.685360683289115414e-04,
-7.602251360017354877e-04,
-7.518949953212293201e-04,
-7.435459533666263906e-04,
-7.351783176104986252e-04,
-7.267923959077086113e-04,
-7.183884964841890817e-04,
-7.099669279258967371e-04,
-7.015279991677578295e-04,
-6.930720194824361528e-04,
-6.845992984692816615e-04,
-6.761101460432679226e-04,
-6.676048724237571789e-04,
-6.590837881234632789e-04,
-6.505472039372838531e-04,
-6.419954309312617255e-04,
-6.334287804313536640e-04,
-6.248475640123590498e-04,
-6.162520934868660023e-04,
-6.076426808940156837e-04,
-5.990196384884407263e-04,
-5.903832787292164538e-04,
-5.817339142686288713e-04,
-5.730718579411211164e-04,
-5.643974227522754713e-04,
-5.557109218674858350e-04,
-5.470126686011248093e-04,
-5.383029764053267599e-04,
-5.295821588587784666e-04,
-5.208505296559009547e-04,
-5.121084025955464697e-04,
-5.033560915700088963e-04,
-4.945939105540206240e-04,
-4.858221735935694895e-04,
-4.770411947949065932e-04,
-4.682512883135697820e-04,
-4.594527683432175595e-04,
-4.506459491046668265e-04,
-4.418311448349313258e-04,
-4.330086697760940958e-04,
-4.241788381643801223e-04,
-4.153419642191290805e-04,
-4.064983621318995371e-04,
-3.976483460553640096e-04,
-3.887922300924204861e-04,
-3.799303282853054640e-04,
-3.710629546045264679e-04,
-3.621904229380032772e-04,
-3.533130470802178812e-04,
-3.444311407211904743e-04,
-3.355450174356526668e-04,
-3.266549906722380440e-04,
-3.177613737424974630e-04,
-3.088644798101176383e-04,
-2.999646218801749089e-04,
-2.910621127880838577e-04,
-2.821572651890765383e-04,
-2.732503915472697599e-04,
-2.643418041248705541e-04,
-2.554318149714932592e-04,
-2.465207359133792984e-04,
-2.376088785427645444e-04,
-2.286965542070517178e-04,
-2.197840739981896238e-04,
-2.108717487420765666e-04,
-2.019598889877818079e-04,
-1.930488049969875520e-04,
-1.841388067334424504e-04,
-1.752302038522455098e-04,
-1.663233056893448629e-04,
-1.574184212510731842e-04,
-1.485158592033871457e-04,
-1.396159278616411687e-04,
-1.307189351799714031e-04,
-1.218251887407079516e-04,
-1.129349957442123581e-04,
-1.040486629982233154e-04,
-9.516649690754836919e-05,
-8.628880346375612342e-05,
-7.741588823469970312e-05,
-6.854805635425640709e-05,
-5.968561251209189079e-05,
-5.082886094325584373e-05,
-4.197810541799623538e-05,
-3.313364923159705430e-05,
-2.429579519405073357e-05,
-1.546484561996956149e-05,
-6.641102318394703775e-06,
 2.175133417239181911e-06,
 1.098356081932656723e-05,
 1.978387965609399896e-05,
 2.857579024157589487e-05,
 3.735899344575398207e-05,
 4.613319070447661108e-05,
 5.489808402935040144e-05,
 6.365337601779317775e-05,
 7.239876986286759527e-05,
 8.113396936306343534e-05,
 8.985867893236808171e-05,
 9.857260360979877188e-05,
 1.072754490693069601e-04,
 1.159669216296498696e-04,
 1.246467282638319559e-04,
 1.333145766090209922e-04,
 1.419701749761142974e-04,
 1.506132323592958018e-04,
 1.592434584457509184e-04,
 1.678605636251562130e-04,
 1.764642589991399346e-04,
 1.850542563908954467e-04,
 1.936302683545738338e-04,
 2.021920081846413782e-04,
 2.107391899253936523e-04,
 2.192715283802431183e-04,
 2.277887391209755866e-04,
 2.362905384971565365e-04,
 2.447766436452975848e-04,
 2.532467724981062214e-04,
 2.617006437935804220e-04,
 2.701379770842724242e-04,
 2.785584927463274495e-04,
 2.869619119884903881e-04,
 2.953479568612558687e-04,
 3.037163502657987233e-04,
 3.120668159628676975e-04,
 3.203990785818209750e-04,
 3.287128636294461620e-04,
 3.370078974987135933e-04,
 3.452839074778038878e-04,
 3.535406217586018049e-04,
 3.617777694455424670e-04,
 3.699950805644150811e-04,
 3.781922860707375876e-04,
 3.863691178585886249e-04,
 3.945253087690807326e-04,
 4.026605925988248802e-04,
 4.107747041085313888e-04,
 4.188673790313878322e-04,
 4.269383540813956302e-04,
 4.349873669618451485e-04,
 4.430141563735710310e-04,
 4.510184620231619951e-04,
 4.590000246313102731e-04,
 4.669585859409160775e-04,
 4.748938887252755498e-04,
 4.828056767960925270e-04,
 4.906936950116624245e-04,
 4.985576892848198180e-04,
 5.063974065908500828e-04,
 5.142125949755298924e-04,
 5.220030035629505492e-04,
 5.297683825632913896e-04,
 5.375084832807306649e-04,
 5.452230581211314504e-04,
 5.529118605996566479e-04,
 5.605746453486456062e-04,
 5.682111681249677219e-04,
 5.758211858176949050e-04,
 5.834044564557391323e-04,
 5.909607392150700899e-04,
 5.984897944263479564e-04,
 6.059913835822169394e-04,
 6.134652693445843919e-04,
 6.209112155520156136e-04,
 6.283289872268973909e-04,
 6.357183505825825644e-04,
 6.430790730306304393e-04,
 6.504109231878409808e-04,
 6.577136708832383768e-04,
 6.649870871651810192e-04,
 6.722309443082358877e-04,
 6.794450158200260456e-04,
 6.866290764481879647e-04,
 6.937829021870829541e-04,
 7.009062702845844824e-04,
 7.079989592487035202e-04,
 7.150607488543382411e-04,
 7.220914201498112184e-04,
 7.290907554633709519e-04,
 7.360585384097854435e-04,
 7.429945538967281478e-04,
 7.498985881311290118e-04,
 7.567704286256091064e-04,
 7.636098642047234623e-04,
 7.704166850111276868e-04,
 7.771906825119581684e-04,
 7.839316495047332807e-04,
 7.906393801235557777e-04,
 7.973136698452215143e-04,
 8.039543154949979186e-04,
 8.105611152527244720e-04,
 8.171338686586189374e-04,
 8.236723766190512776e-04,
 8.301764414124033348e-04,
 8.366458666947349790e-04,
 8.430804575053986493e-04,
 8.494800202727394384e-04,
 8.558443628196018638e-04,
 8.621732943687790678e-04,
 8.684666255485545003e-04,
 8.747241683980334827e-04,
 8.809457363725042628e-04,
 8.871311443486598570e-04,
 8.932802086299247366e-04,
 8.993927469515809346e-04,
 9.054685784858287770e-04,
 9.115075238469614542e-04,
 9.175094050963154878e-04,
 9.234740457471753367e-04,
 9.294012707697772062e-04,
 9.352909065960940665e-04,
 9.411427811245662431e-04,
 9.469567237250022277e-04,
 9.527325652430538314e-04,
 9.584701380049278014e-04,
 9.641692758220411687e-04,
 9.698298139953369151e-04,
 9.754515893198953012e-04,
 9.810344400892657968e-04,
 9.865782060997816631e-04,
 9.920827286549035919e-04,
 9.975478505694190378e-04,
 1.002973416173564680e-03,
 1.008359271317221416e-03,
 1.013705263373931549e-03,
 1.019011241244850707e-03,
 1.024277055362774131e-03,
 1.029502557695969982e-03,
 1.034687601752027394e-03,
 1.039832042581570297e-03,
 1.044935736782055379e-03,
 1.049998542501388334e-03,
 1.055020319441472886e-03,
 1.060000928861834849e-03,
 1.064940233583064246e-03,
 1.069838097990195641e-03,
 1.074694388036153076e-03,
 1.079508971245021331e-03,
 1.084281716715261232e-03,
 1.089012495122965510e-03,
 1.093701178724963306e-03,
 1.098347641361844445e-03,
 1.102951758461111426e-03,
 1.107513407039978186e-03,
 1.112032465708343411e-03,
 1.116508814671708129e-03,
 1.120942335733794487e-03,
 1.125332912299417589e-03,
 1.129680429377082811e-03,
 1.133984773581581378e-03,
 1.138245833136584647e-03,
 1.142463497877127141e-03,
 1.146637659251979876e-03,
 1.150768210326108239e-03,
 1.154855045782940360e-03,
 1.158898061926596666e-03,
 1.162897156684146970e-03,
 1.166852229607708187e-03,
 1.170763181876549423e-03,
 1.174629916299059582e-03,
 1.178452337314769838e-03,
 1.182230350996239278e-03,
 1.185963865050850777e-03,
 1.189652788822667369e-03,
 1.193297033294118611e-03,
 1.196896511087642938e-03,
 1.200451136467348221e-03,
 1.203960825340541800e-03,
 1.207425495259162058e-03,
 1.210845065421330352e-03,
 1.214219456672589390e-03,
 1.217548591507281678e-03,
 1.220832394069843200e-03,
 1.224070790155891300e-03,
 1.227263707213453302e-03,
 1.230411074344001706e-03,
 1.233512822303459242e-03,
 1.236568883503198074e-03,
 1.239579192010915615e-03,
 1.242543683551446598e-03,
 1.245462295507600943e-03,
 1.248334966920861553e-03,
 1.251161638492013150e-03,
 1.253942252581809061e-03,
 1.256676753211479055e-03,
 1.259365086063228079e-03,
 1.262007198480642831e-03,
 1.264603039469102677e-03,
 1.267152559696074115e-03,
 1.269655711491328486e-03,
 1.272112448847195461e-03,
 1.274522727418666472e-03,
 1.276886504523458031e-03,
 1.279203739142069189e-03,
 1.281474391917721261e-03,
 1.283698425156232052e-03,
 1.285875802825937799e-03,
 1.288006490557389375e-03,
 1.290090455643119619e-03,
 1.292127667037360579e-03,
 1.294118095355558003e-03,
 1.296061712873987967e-03,
 1.297958493529267465e-03,
 1.299808412917737282e-03,
 1.301611448294881295e-03,
 1.303367578574648198e-03,
 1.305076784328686266e-03,
 1.306739047785595480e-03,
 1.308354352830043248e-03,
 1.309922685001867551e-03,
 1.311444031495120682e-03,
 1.312918381157037731e-03,
 1.314345724486955204e-03,
 1.315726053635197330e-03,
 1.317059362401852649e-03,
 1.318345646235552547e-03,
 1.319584902232137473e-03,
 1.320777129133317946e-03,
 1.321922327325251653e-03,
 1.323020498837053317e-03,
 1.324071647339277466e-03,
 1.325075778142325092e-03,
 1.326032898194792189e-03,
 1.326943016081785125e-03,
 1.327806142023155341e-03,
 1.328622287871674204e-03,
 1.329391467111203312e-03,
 1.330113694854723411e-03,
 1.330788987842383914e-03,
 1.331417364439478699e-03,
 1.331998844634317818e-03,
 1.332533450036127182e-03,
 1.333021203872819874e-03,
 1.333462130988752716e-03,
 1.333856257842414537e-03,
 1.334203612504068683e-03,
 1.334504224653327003e-03,
 1.334758125576679172e-03,
 1.334965348164972570e-03,
 1.335125926910825812e-03,
 1.335239897905995433e-03,
 1.335307298838693361e-03,
 1.335328168990832171e-03,
 1.335302549235241722e-03,
 1.335230482032818576e-03,
 1.335112011429622500e-03,
 1.334947183053914214e-03,
 1.334736044113169927e-03,
 1.334478643390998084e-03,
 1.334175031244028142e-03,
 1.333825259598761396e-03,
 1.333429381948338533e-03,
 1.332987453349282047e-03,
 1.332499530418163177e-03,
 1.331965671328227008e-03,
 1.331385935805979182e-03,
 1.330760385127708213e-03,
 1.330089082115939710e-03,
 1.329372091135884318e-03,
 1.328609478091786556e-03,
 1.327801310423250020e-03,
 1.326947657101516407e-03,
 1.326048588625663429e-03,
 1.325104177018795147e-03,
 1.324114495824145997e-03,
 1.323079620101151425e-03,
 1.321999626421471253e-03,
 1.320874592864949284e-03,
 1.319704599015543650e-03,
 1.318489725957187322e-03,
 1.317230056269622388e-03,
 1.315925674024157575e-03,
 1.314576664779401691e-03,
 1.313183115576943951e-03,
 1.311745114936967074e-03,
 1.310262752853837403e-03,
 1.308736120791639942e-03,
 1.307165311679652680e-03,
 1.305550419907783831e-03,
 1.303891541321978292e-03,
 1.302188773219540175e-03,
 1.300442214344430187e-03,
 1.298651964882541112e-03,
 1.296818126456863139e-03,
 1.294940802122661761e-03,
 1.293020096362596481e-03,
 1.291056115081764709e-03,
 1.289048965602741965e-03,
 1.286998756660528206e-03,
 1.284905598397524055e-03,
 1.282769602358364370e-03,
 1.280590881484785191e-03,
 1.278369550110422829e-03,
 1.276105723955552659e-03,
 1.273799520121794314e-03,
 1.271451057086795625e-03,
 1.269060454698826140e-03,
 1.266627834171363482e-03,
 1.264153318077657811e-03,
 1.261637030345153605e-03,
 1.259079096250011187e-03,
 1.256479642411477762e-03,
 1.253838796786223113e-03,
 1.251156688662736442e-03,
 1.248433448655534130e-03,
 1.245669208699429296e-03,
 1.242864102043738901e-03,
 1.240018263246424075e-03,
 1.237131828168194000e-03,
 1.234204933966629326e-03,
 1.231237719090155303e-03,
 1.228230323272079538e-03,
 1.225182887524551255e-03,
 1.222095554132434682e-03,
 1.218968466647229716e-03,
 1.215801769880885683e-03,
 1.212595609899620947e-03,
 1.209350134017658394e-03,
 1.206065490790956575e-03,
 1.202741830010919380e-03,
 1.199379302698000980e-03,
 1.195978061095338742e-03,
 1.192538258662336707e-03,
 1.189060050068172945e-03,
 1.185543591185306495e-03,
 1.181989039082974096e-03,
 1.178396552020560080e-03,
 1.174766289441008535e-03,
 1.171098411964224427e-03,
 1.167393081380289953e-03,
 1.163650460642861543e-03,
 1.159870713862364965e-03,
 1.156054006299164424e-03,
 1.152200504356851347e-03,
 1.148310375575298985e-03,
 1.144383788623803532e-03,
 1.140420913294190120e-03,
 1.136421920493817543e-03,
 1.132386982238607056e-03,
 1.128316271646049272e-03,
 1.124209962928106104e-03,
 1.120068231384145890e-03,
 1.115891253393859646e-03,
 1.111679206410058282e-03,
 1.107432268951529224e-03,
 1.103150620595808474e-03,
 1.098834441971982805e-03,
 1.094483914753358392e-03,
 1.090099221650178869e-03,
 1.085680546402347521e-03,
 1.081228073771984015e-03,
 1.076741989536078277e-03,
 1.072222480479102314e-03,
 1.067669734385496465e-03,
 1.063083940032221808e-03,
 1.058465287181312338e-03,
 1.053813966572214860e-03,
 1.049130169914367847e-03,
 1.044414089879560628e-03,
 1.039665920094249001e-03,
 1.034885855132055155e-03,
 1.030074090505983531e-03,
 1.025230822660772208e-03,
 1.020356248965206781e-03,
 1.015450567704311068e-03,
 1.010513978071613493e-03,
 1.005546680161382034e-03,
 1.000548874960741855e-03,
 9.955207643418668810e-04,
 9.904625510541418838e-04,
 9.853744387162107279e-04,
 9.802566318081050618e-04,
 9.751093356632819370e-04,
 9.699327564607153123e-04,
 9.647271012168377215e-04,
 9.594925777775743141e-04,
 9.542293948103555386e-04,
 9.489377617959874689e-04,
 9.436178890206282747e-04,
 9.382699875677296721e-04,
 9.328942693098521725e-04,
 9.274909469005708637e-04,
 9.220602337663724073e-04,
 9.166023440983521106e-04,
 9.111174928441763020e-04,
 9.056058956998054230e-04,
 9.000677691011814505e-04,
 8.945033302161382307e-04,
 8.889127969360583262e-04,
 8.832963878675109985e-04,
 8.776543223241176561e-04,
 8.719868203180868374e-04,
 8.662941025519472777e-04,
 8.605763904102082260e-04,
 8.548339059509340015e-04,
 8.490668718973875054e-04,
 8.432755116296690705e-04,
 8.374600491762256406e-04,
 8.316207092054559010e-04,
 8.257577170173019659e-04,
 8.198712985347126952e-04,
 8.139616802952159749e-04,
 8.080290894424101145e-04,
 8.020737537175063117e-04,
 7.960959014507400363e-04,
 7.900957615528756556e-04,
 7.840735635067089997e-04,
 7.780295373584304990e-04,
 7.719639137090982591e-04,
 7.658769237061030044e-04,
 7.597687990344968462e-04,
 7.536397719084299285e-04,
 7.474900750625995422e-04,
 7.413199417434725332e-04,
 7.351296057008325363e-04,
 7.289193011790576779e-04,
 7.226892629083808217e-04,
 7.164397260964157702e-04,
 7.101709264193303405e-04,
 7.038831000132227296e-04,
 6.975764834654804222e-04,
 6.912513138059971779e-04,
 6.849078284985137249e-04,
 6.785462654319569364e-04,
 6.721668629116212554e-04,
 6.657698596505078710e-04,
 6.593554947606233450e-04,
 6.529240077441652657e-04,
 6.464756384848308491e-04,
 6.400106272390439005e-04,
 6.335292146272634159e-04,
 6.270316416251297707e-04,
 6.205181495547575999e-04,
 6.139889800760048267e-04,
 6.074443751776164658e-04,
 6.008845771684934341e-04,
 5.943098286689637482e-04,
 5.877203726019104976e-04,
 5.811164521840289469e-04,
 5.744983109171132368e-04,
 5.678661925790867791e-04,
 5.612203412154260010e-04,
 5.545610011302659842e-04,
 5.478884168775232343e-04,
 5.412028332523002340e-04,
 5.345044952819250550e-04,
 5.277936482172163740e-04,
 5.210705375237395997e-04,
 5.143354088729195587e-04,
 5.075885081332942366e-04,
 5.008300813617724227e-04,
 4.940603747947466123e-04,
 4.872796348393572115e-04,
 4.804881080647489876e-04,
 4.736860411931917252e-04,
 4.668736810913507178e-04,
 4.600512747615535195e-04,
 4.532190693329189485e-04,
 4.463773120526464983e-04,
 4.395262502772244884e-04,
 4.326661314637179575e-04,
 4.257972031609243927e-04,
 4.189197130006590752e-04,
 4.120339086890591825e-04,
 4.051400379977358312e-04,
 3.982383487550915152e-04,
 3.913290888376291950e-04,
 3.844125061611313918e-04,
 3.774888486719866240e-04,
 3.705583643385449008e-04,
 3.636213011422263970e-04,
 3.566779070690375168e-04,
 3.497284301007847905e-04,
 3.427731182062867653e-04,
 3.358122193329186921e-04,
 3.288459813977606650e-04,
 3.218746522790085179e-04,
 3.148984798073750169e-04,
 3.079177117573507027e-04,
 3.009325958386286108e-04,
 2.939433796875278522e-04,
 2.869503108582935422e-04,
 2.799536368145437459e-04,
 2.729536049207351264e-04,
 2.659504624334856418e-04,
 2.589444564930812841e-04,
 2.519358341148838858e-04,
 2.449248421808643142e-04,
 2.379117274309715442e-04,
 2.308967364546693219e-04,
 2.238801156824832641e-04,
 2.168621113774124045e-04,
 2.098429696265062441e-04,
 2.028229363324506648e-04,
 1.958022572050234131e-04,
 1.887811777527103718e-04,
 1.817599432743553594e-04,
 1.747387988505725719e-04,
 1.677179893355776070e-04,
 1.606977593487146953e-04,
 1.536783532659995166e-04,
 1.466600152119983363e-04,
 1.396429890513185628e-04,
 1.326275183803704918e-04,
 1.256138465191267736e-04,
 1.186022165027489838e-04,
 1.115928710733831813e-04,
 1.045860526719730703e-04,
 9.758200342993907388e-05,
 9.058096516102830521e-05,
 8.358317935318291549e-05,
 7.658888716027496336e-05,
 6.959832939401281858e-05,
 6.261174651586647153e-05,
 5.562937862886168798e-05,
 4.865146546956139223e-05,
 4.167824639996744931e-05,
 3.470996039954273271e-05,
 2.774684605708660799e-05,
 2.078914156278256393e-05,
 1.383708470026656214e-05,
 6.890912838566480117e-06,
-4.913707578592772503e-08,
-6.982828526621039276e-06,
-1.390992543612590632e-05,
-2.083019217266539693e-05,
-2.774339355856376133e-05,
-3.464929487811433068e-05,
-4.154766188516390599e-05,
-4.843826081099238378e-05,
-5.532085837216674034e-05,
-6.219522177805544383e-05,
-6.906111873871813929e-05,
-7.591831747252026480e-05,
-8.276658671374057961e-05,
-8.960569572030233879e-05,
-9.643541428133037209e-05,
-1.032555127246812069e-04,
-1.100657619245988365e-04,
-1.168659333091944143e-04,
-1.236557988678968500e-04,
-1.304351311590309090e-04,
-1.372037033171992601e-04,
-1.439612890607381678e-04,
-1.507076626990466858e-04,
-1.574425991400530691e-04,
-1.641658738975048412e-04,
-1.708772630982331113e-04,
-1.775765434895319522e-04,
-1.842634924463679115e-04,
-1.909378879785556676e-04,
-1.975995087380538978e-04,
-2.042481340260857484e-04,
-2.108835438002127391e-04,
-2.175055186816232851e-04,
-2.241138399620029608e-04,
-2.307082896106800701e-04,
-2.372886502817431078e-04,
-2.438547053208198700e-04,
-2.504062387722173311e-04,
-2.569430353857779493e-04,
-2.634648806237349411e-04,
-2.699715606676703116e-04,
-2.764628624253014717e-04,
-2.829385735372370652e-04,
-2.893984823838406184e-04,
-2.958423780919223448e-04,
-3.022700505413981518e-04,
-3.086812903720562011e-04,
-3.150758889901330824e-04,
-3.214536385749574253e-04,
-3.278143320854560333e-04,
-3.341577632667929419e-04,
-3.404837266568277402e-04,
-3.467920175925417992e-04,
-3.530824322165747103e-04,
-3.593547674835782520e-04,
-3.656088211665443899e-04,
-3.718443918632335660e-04,
-3.780612790024309245e-04,
-3.842592828501668130e-04,
-3.904382045160389829e-04,
-3.965978459593645688e-04,
-4.027380099952789427e-04,
-4.088585003010300500e-04,
-4.149591214218714815e-04,
-4.210396787772009014e-04,
-4.270999786666738627e-04,
-4.331398282759865628e-04,
-4.391590356829823947e-04,
-4.451574098635047963e-04,
-4.511347606972195240e-04,
-4.570908989735368902e-04,
-4.630256363973645948e-04,
-4.689387855948216866e-04,
-4.748301601190486410e-04,
-4.806995744558443975e-04,
-4.865468440292690833e-04,
-4.923717852073391642e-04,
-4.981742153075393665e-04,
-5.039539526023775317e-04,
-5.097108163248212408e-04,
-5.154446266738409600e-04,
-5.211552048197731551e-04,
-5.268423729096598793e-04,
-5.325059540726688077e-04,
-5.381457724253405593e-04,
-5.437616530768128167e-04,
-5.493534221341171957e-04,
-5.549209067073139186e-04,
-5.604639349145882146e-04,
-5.659823358874331318e-04,
-5.714759397756634298e-04,
-5.769445777523928270e-04,
-5.823880820190882254e-04,
-5.878062858104544756e-04,
-5.931990233993579553e-04,
-5.985661301016203693e-04,
-6.039074422809192350e-04,
-6.092227973535132689e-04,
-6.145120337929350311e-04,
-6.197749911347634737e-04,
-6.250115099812222604e-04,
-6.302214320057560742e-04,
-6.354045999576603786e-04,
-6.405608576665803135e-04,
-6.456900500469258926e-04,
-6.507920231024541665e-04,
-6.558666239304962019e-04,
-6.609137007263934200e-04,
-6.659331027878739786e-04,
-6.709246805191642835e-04,
-6.758882854353462886e-04,
-6.808237701664931855e-04,
-6.857309884617664945e-04,
-6.906097951935905683e-04,
-6.954600463616633817e-04,
-7.002815990969358780e-04,
-7.050743116656409733e-04,
-7.098380434731914801e-04,
-7.145726550680096172e-04,
-7.192780081454444498e-04,
-7.239539655515225781e-04,
-7.286003912866587107e-04,
-7.332171505094309651e-04,
-7.378041095401980916e-04,
-7.423611358647298156e-04,
-7.468880981377335306e-04,
-7.513848661864549333e-04,
-7.558513110141166797e-04,
-7.602873048033330795e-04,
-7.646927209195589431e-04,
-7.690674339144149387e-04,
-7.734113195289488716e-04,
-7.777242546969679801e-04,
-7.820061175482145637e-04,
-7.862567874114939062e-04,
-7.904761448179203768e-04,
-7.946640715038440174e-04,
-7.988204504139658890e-04,
-8.029451657043791503e-04,
-8.070381027453751898e-04,
-8.110991481244583584e-04,
-8.151281896491629434e-04,
-8.191251163498158242e-04,
-8.230898184823724198e-04,
-8.270221875310948849e-04,
-8.309221162111916003e-04,
-8.347894984715085965e-04,
-8.386242294970661527e-04,
-8.424262057115749049e-04,
-8.461953247799755898e-04,
-8.499314856108412027e-04,
-8.536345883587958530e-04,
-8.573045344268170670e-04,
-8.609412264686017342e-04,
-8.645445683908025997e-04,
-8.681144653551939577e-04,
-8.716508237809084689e-04,
-8.751535513465194798e-04,
-8.786225569920904895e-04,
-8.820577509212572517e-04,
-8.854590446031705567e-04,
-8.888263507744094145e-04,
-8.921595834409556036e-04,
-8.954586578799268769e-04,
-8.987234906414228158e-04,
-9.019539995503202687e-04,
-9.051501037078724414e-04,
-9.083117234934525103e-04,
-9.114387805661303783e-04,
-9.145311978662115909e-04,
-9.175888996168072610e-04,
-9.206118113252717214e-04,
-9.235998597846069996e-04,
-9.265529730748901707e-04,
-9.294710805645713635e-04,
-9.323541129117488913e-04,
-9.352020020654370092e-04,
-9.380146812667520314e-04,
-9.407920850500130130e-04,
-9.435341492439080265e-04,
-9.462408109724991089e-04,
-9.489120086562512777e-04,
-9.515476820129577891e-04,
-9.541477720587016086e-04,
-9.567122211086919814e-04,
-9.592409727780684767e-04,
-9.617339719827181508e-04,
-9.641911649399729058e-04,
-9.666124991692828881e-04,
-9.689979234928709122e-04,
-9.713473880363282303e-04,
-9.736608442291015556e-04,
-9.759382448050748452e-04,
-9.781795438029358691e-04,
-9.803846965666057709e-04,
-9.825536597456499804e-04,
-9.846863912954841036e-04,
-9.867828504777338781e-04,
-9.888429978604069102e-04,
-9.908667953180511859e-04,
-9.928542060319244227e-04,
-9.948051944900465453e-04,
-9.967197264872257063e-04,
-9.985977691250706462e-04,
-1.000439290811920871e-03,
-1.002244261262728257e-03,
-1.004012651498933885e-03,
-1.005744433848253586e-03,
-1.007439581944457197e-03,
-1.009098070727040049e-03,
-1.010719876440943675e-03,
-1.012304976636147500e-03,
-1.013853350167237110e-03,
-1.015364977192958216e-03,
-1.016839839175703603e-03,
-1.018277918880916393e-03,
-1.019679200376535791e-03,
-1.021043669032315349e-03,
-1.022371311519126684e-03,
-1.023662115808248027e-03,
-1.024916071170539796e-03,
-1.026133168175637732e-03,
-1.027313398691084238e-03,
-1.028456755881388806e-03,
-1.029563234207076959e-03,
-1.030632829423679120e-03,
-1.031665538580666579e-03,
-1.032661360020375963e-03,
-1.033620293376845672e-03,
-1.034542339574627372e-03,
-1.035427500827582102e-03,
-1.036275780637578364e-03,
-1.037087183793175462e-03,
-1.037861716368275629e-03,
-1.038599385720700681e-03,
-1.039300200490756105e-03,
-1.039964170599718156e-03,
-1.040591307248313162e-03,
-1.041181622915129598e-03,
-1.041735131354980725e-03,
-1.042251847597259638e-03,
-1.042731787944210830e-03,
-1.043174969969173568e-03,
-1.043581412514797734e-03,
-1.043951135691195686e-03,
-1.044284160874050767e-03,
-1.044580510702703248e-03,
-1.044840209078177519e-03,
-1.045063281161165902e-03,
-1.045249753369979946e-03,
-1.045399653378462253e-03,
-1.045513010113816770e-03,
-1.045589853754478769e-03,
-1.045630215727840623e-03,
-1.045634128708029841e-03,
-1.045601626613570445e-03,
-1.045532744605060394e-03,
-1.045427519082770939e-03,
-1.045285987684217797e-03,
-1.045108189281689385e-03,
-1.044894163979737329e-03,
-1.044643953112622510e-03,
-1.044357599241716459e-03,
-1.044035146152874540e-03,
-1.043676638853751693e-03,
-1.043282123571096258e-03,
-1.042851647747981142e-03,
-1.042385260041021541e-03,
-1.041883010317524788e-03,
-1.041344949652629141e-03,
-1.040771130326378609e-03,
-1.040161605820758743e-03,
-1.039516430816723102e-03,
-1.038835661191144693e-03,
-1.038119354013733366e-03,
-1.037367567543953217e-03,
-1.036580361227832205e-03,
-1.035757795694809301e-03,
-1.034899932754482091e-03,
-1.034006835393333360e-03,
-1.033078567771453758e-03,
-1.032115195219177961e-03,
-1.031116784233694367e-03,
-1.030083402475655014e-03,
-1.029015118765692688e-03,
-1.027912003080923287e-03,
-1.026774126551441464e-03,
-1.025601561456726063e-03,
-1.024394381222034495e-03,
-1.023152660414776947e-03,
-1.021876474740819911e-03,
-1.020565901040774949e-03,
-1.019221017286238689e-03,
-1.017841902576026520e-03,
-1.016428637132312180e-03,
-1.014981302296791635e-03,
-1.013499980526782118e-03,
-1.011984755391283873e-03,
-1.010435711567006338e-03,
-1.008852934834389556e-03,
-1.007236512073532127e-03,
-1.005586531260141935e-03,
-1.003903081461424412e-03,
-1.002186252831929617e-03,
-1.000436136609384559e-03,
-9.986528251104910461e-04,
-9.968364117266456919e-04,
-9.949869909197100060e-04,
-9.931046582176681660e-04,
-9.911895102102659220e-04,
-9.892416445446826790e-04,
-9.872611599210667516e-04,
-9.852481560881189756e-04,
-9.832027338386147355e-04,
-9.811249950048769874e-04,
-9.790150424542468956e-04,
-9.768729800845134866e-04,
-9.746989128192940811e-04,
-9.724929466033987871e-04,
-9.702551883981759117e-04,
-9.679857461767852733e-04,
-9.656847289194843073e-04,
-9.633522466088544327e-04,
-9.609884102250294781e-04,
-9.585933317408363956e-04,
-9.561671241169576599e-04,
-9.537099012970576706e-04,
-9.512217782028455125e-04,
-9.487028707291379325e-04,
-9.461532957389022589e-04,
-9.435731710582193066e-04,
-9.409626154712719777e-04,
-9.383217487152996014e-04,
-9.356506914754482993e-04,
-9.329495653797184943e-04,
-9.302184929937970612e-04,
-9.274575978158340747e-04,
-9.246670042713208207e-04,
-9.218468377077907588e-04,
-9.189972243895846689e-04,
-9.161182914925853314e-04,
-9.132101670988634120e-04,
-9.102729801913593414e-04,
-9.073068606485362470e-04,
-9.043119392389385594e-04,
-9.012883476158068882e-04,
-8.982362183116377125e-04,
-8.951556847326868011e-04,
-8.920468811534831496e-04,
-8.889099427113010673e-04,
-8.857450054006482014e-04,
-8.825522060676369018e-04,
-8.793316824044129397e-04,
-8.760835729435631925e-04,
-8.728080170524128495e-04,
-8.695051549273914628e-04,
-8.661751275883468500e-04,
-8.628180768727989301e-04,
-8.594341454302085234e-04,
-8.560234767162485346e-04,
-8.525862149869356012e-04,
-8.491225052929162386e-04,
-8.456324934735877548e-04,
-8.421163261512045264e-04,
-8.385741507250963830e-04,
-8.350061153656844612e-04,
-8.314123690086001666e-04,
-8.277930613487567571e-04,
-8.241483428343486083e-04,
-8.204783646608863673e-04,
-8.167832787652278773e-04,
-8.130632378194886482e-04,
-8.093183952250334245e-04,
-8.055489051064373962e-04,
-8.017549223053490725e-04,
-7.979366023744099675e-04,
-7.940941015711598661e-04,
-7.902275768518467886e-04,
-7.863371858652950684e-04,
-7.824230869467139072e-04,
-7.784854391115291318e-04,
-7.745244020491238784e-04,
-7.705401361166203675e-04,
-7.665328023326656911e-04,
-7.625025623711080948e-04,
-7.584495785547311570e-04,
-7.543740138489842808e-04,
-7.502760318556131154e-04,
-7.461557968063408253e-04,
-7.420134735565646475e-04,
-7.378492275788789759e-04,
-7.336632249568144195e-04,
-7.294556323783818116e-04,
-7.252266171296103655e-04,
-7.209763470882260160e-04,
-7.167049907171195357e-04,
-7.124127170579132046e-04,
-7.080996957245257444e-04,
-7.037660968966224367e-04,
-6.994120913131502424e-04,
-6.950378502658434302e-04,
-6.906435455926471321e-04,
-6.862293496711998784e-04,
-6.817954354123171093e-04,
-6.773419762533485931e-04,
-6.728691461516917533e-04,
-6.683771195780882635e-04,
-6.638660715101387831e-04,
-6.593361774256499682e-04,
-6.547876132959252115e-04,
-6.502205555792787278e-04,
-6.456351812142635191e-04,
-6.410316676130697758e-04,
-6.364101926548730798e-04,
-6.317709346790990150e-04,
-6.271140724787720210e-04,
-6.224397852938416947e-04,
-6.177482528044181279e-04,
-6.130396551240857410e-04,
-6.083141727932062743e-04,
-6.035719867721291891e-04,
-5.988132784344822991e-04,
-5.940382295604081922e-04,
-5.892470223298478145e-04,
-5.844398393157047931e-04,
-5.796168634771106968e-04,
-5.747782781526720834e-04,
-5.699242670536212689e-04,
-5.650550142570497135e-04,
-5.601707041991507317e-04,
-5.552715216683341577e-04,
-5.503576517984547440e-04,
-5.454292800620228875e-04,
-5.404865922633174521e-04,
-5.355297745315843513e-04,
-5.305590133142541048e-04,
-5.255744953699736715e-04,
-5.205764077619130185e-04,
-5.155649378508469355e-04,
-5.105402732882350064e-04,
-5.055026020095174447e-04,
-5.004521122271284950e-04,
-4.953889924236790782e-04,
-4.903134313451270763e-04,
-4.852256179938381681e-04,
-4.801257416217534577e-04,
-4.750139917235496768e-04,
-4.698905580296915629e-04,
-4.647556304995963442e-04,
-4.596093993147826119e-04,
-4.544520548719284988e-04,
-4.492837877760317189e-04,
-4.441047888335062353e-04,
-4.389152490453525454e-04,
-4.337153596001922786e-04,
-4.285053118674351743e-04,
-4.232852973904220996e-04,
-4.180555078794770483e-04,
-4.128161352050583981e-04,
-4.075673713909169988e-04,
-4.023094086071427500e-04,
-3.970424391633220387e-04,
-3.917666555017125778e-04,
-3.864822501902346902e-04,
-3.811894159157528327e-04,
-3.758883454771375695e-04,
-3.705792317783217996e-04,
-3.652622678215956711e-04,
-3.599376467006085980e-04,
-3.546055615935619345e-04,
-3.492662057563908611e-04,
-3.439197725158356280e-04,
-3.385664552626355844e-04,
-3.332064474447201177e-04,
-3.278399425602990334e-04,
-3.224671341510608664e-04,
-3.170882157953855592e-04,
-3.117033811014453034e-04,
-3.063128237004334267e-04,
-3.009167372397281181e-04,
-2.955153153761375779e-04,
-2.901087517690214049e-04,
-2.846972400735334153e-04,
-2.792809739338741643e-04,
-2.738601469764329337e-04,
-2.684349528030499036e-04,
-2.630055849842917134e-04,
-2.575722370526098209e-04,
-2.521351024956329772e-04,
-2.466943747494730371e-04,
-2.412502471918466995e-04,
-2.358029131355176286e-04,
-2.303525658215004046e-04,
-2.248993984122740948e-04,
-2.194436039852368985e-04,
-2.139853755259360903e-04,
-2.085249059213123023e-04,
-2.030623879531936332e-04,
-1.975980142914925510e-04,
-1.921319774876060560e-04,
-1.866644699678138384e-04,
-1.811956840265718913e-04,
-1.757258118199292354e-04,
-1.702550453589622888e-04,
-1.647835765030968317e-04,
-1.593115969535642237e-04,
-1.538392982468665096e-04,
-1.483668717481367665e-04,
-1.428945086446425363e-04,
-1.374223999392225001e-04,
-1.319507364438163657e-04,
-1.264797087728732712e-04,
-1.210095073368948457e-04,
-1.155403223359896954e-04,
-1.100723437533229792e-04,
-1.046057613486993143e-04,
-9.914076465215889539e-05,
-9.367754295746940827e-05,
-8.821628531575050123e-05,
-8.275718052912717714e-05,
-7.730041714419935912e-05,
-7.184618344584266648e-05,
-6.639466745077478619e-05,
-6.094605690113776166e-05,
-5.550053925834408836e-05,
-5.005830169662453858e-05,
-4.461953109678957406e-05,
-3.918441403999252718e-05,
-3.375313680139212756e-05,
-2.832588534394949684e-05,
-2.290284531224215863e-05,
-1.748420202617706522e-05,
-1.207014047483894625e-05,
-6.660845310356076629e-06,
-1.256500841665996954e-06,
 4.142708971569870839e-06,
 9.536600525112154351e-06,
 1.492499057619274568e-05,
 2.030769624967599987e-05,
 2.568453504408354536e-05,
 3.105532483760099782e-05,
 3.641988389418168801e-05,
 4.177803086951488985e-05,
 4.712958481697404487e-05,
 5.247436519366268352e-05,
 5.781219186632302208e-05,
 6.314288511721191828e-05,
 6.846626565015140385e-05,
 7.378215459624679388e-05,
 7.909037351983140118e-05,
 8.439074442438941083e-05,
 8.968308975821263722e-05,
 9.496723242034604481e-05,
 1.002429957663184478e-04,
 1.055102036138641974e-04,
 1.107686802487392895e-04,
 1.160182504303993719e-04,
 1.212587393976569491e-04,
 1.264899728744298352e-04,
 1.317117770753533778e-04,
 1.369239787113688423e-04,
 1.421264049954059868e-04,
 1.473188836479250561e-04,
 1.525012429024379188e-04,
 1.576733115111194098e-04,
 1.628349187502669388e-04,
 1.679858944258158266e-04,
 1.731260688787515884e-04,
 1.782552729906257849e-04,
 1.833733381889341807e-04,
 1.884800964524708860e-04,
 1.935753803167702394e-04,
 1.986590228794117541e-04,
 2.037308578053001560e-04,
 2.087907193320324008e-04,
 2.138384422751280010e-04,
 2.188738620332202132e-04,
 2.238968145934106143e-04,
 2.289071365362968448e-04,
 2.339046650412136428e-04,
 2.388892378914447931e-04,
 2.438606934791750038e-04,
 2.488188708107133486e-04,
 2.537636095115039341e-04,
 2.586947498311209276e-04,
 2.636121326483504570e-04,
 2.685155994761332710e-04,
 2.734049924664817052e-04,
 2.782801544154755221e-04,
 2.831409287681265646e-04,
 2.879871596232135922e-04,
 2.928186917381939342e-04,
 2.976353705339744127e-04,
 3.024370420997210258e-04,
 3.072235531975709452e-04,
 3.119947512674359647e-04,
 3.167504844316666301e-04,
 3.214906014996939251e-04,
 3.262149519727448464e-04,
 3.309233860484240793e-04,
 3.356157546252652073e-04,
 3.402919093073620985e-04,
 3.449517024088623275e-04,
 3.495949869584225956e-04,
 3.542216167038053686e-04,
 3.588314461161693360e-04,
 3.634243303945546466e-04,
 3.680001254703288969e-04,
 3.725586880113943228e-04,
 3.770998754266320532e-04,
 3.816235458701503934e-04,
 3.861295582455114245e-04,
 3.906177722100302447e-04,
 3.950880481789426427e-04,
 3.995402473295382923e-04,
 4.039742316053696806e-04,
 4.083898637203266474e-04,
 4.127870071626776947e-04,
 4.171655261991858896e-04,
 4.215252858790878858e-04,
 4.258661520380436181e-04,
 4.301879913021596684e-04,
 4.344906710918574277e-04,
 4.387740596257891259e-04,
 4.430380259246505920e-04,
 4.472824398150707201e-04,
 4.515071719333702905e-04,
 4.557120937292936848e-04,
 4.598970774697981189e-04,
 4.640619962427209016e-04,
 4.682067239604121634e-04,
 4.723311353634274861e-04,
 4.764351060240935181e-04,
 4.805185123500354269e-04,
 4.845812315878257810e-04,
 4.886231418263460103e-04,
 4.926441220003196586e-04,
 4.966440518938045447e-04,
 5.006228121434661308e-04,
 5.045802842420517948e-04,
 5.085163505416884309e-04,
 5.124308942571550052e-04,
 5.163237994692042266e-04,
 5.201949511277739529e-04,
 5.240442350551527363e-04,
 5.278715379492098783e-04,
 5.316767473864941881e-04,
 5.354597518253069368e-04,
 5.392204406088238174e-04,
 5.429587039680883187e-04,
 5.466744330250291684e-04,
 5.503675197953786799e-04,
 5.540378571916648254e-04,
 5.576853390260723365e-04,
 5.613098600132774597e-04,
 5.649113157733260792e-04,
 5.684896028344019019e-04,
 5.720446186355427091e-04,
 5.755762615294334784e-04,
 5.790844307850486926e-04,
 5.825690265902807707e-04,
 5.860299500546479719e-04,
 5.894671032117649668e-04,
 5.928803890219376581e-04,
 5.962697113747352342e-04,
 5.996349750913461396e-04,
 6.029760859271178193e-04,
 6.062929505739329643e-04,
 6.095854766625461840e-04,
 6.128535727649765154e-04,
 6.160971483967860908e-04,
 6.193161140193128352e-04,
 6.225103810419527119e-04,
 6.256798618243304038e-04,
 6.288244696784329145e-04,
 6.319441188707793826e-04,
 6.350387246244833424e-04,
 6.381082031213075037e-04,
 6.411524715036643219e-04,
 6.441714478766291446e-04,
 6.471650513098705249e-04,
 6.501332018395310957e-04,
 6.530758204701513775e-04,
 6.559928291764805051e-04,
 6.588841509052539933e-04,
 6.617497095770068487e-04,
 6.645894300877820552e-04,
 6.674032383107944989e-04,
 6.701910610981423816e-04,
 6.729528262823973117e-04,
 6.756884626781701087e-04,
 6.783979000837320108e-04,
 6.810810692824369314e-04,
 6.837379020442409683e-04,
 6.863683311271892790e-04,
 6.889722902787230856e-04,
 6.915497142371327234e-04,
 6.941005387328573820e-04,
 6.966247004897616448e-04,
 6.991221372264366405e-04,
 7.015927876574044831e-04,
 7.040365914942878006e-04,
 7.064534894469953101e-04,
 7.088434232248260781e-04,
 7.112063355375188110e-04,
 7.135421700963402855e-04,
 7.158508716150683952e-04,
 7.181323858109666313e-04,
 7.203866594057007754e-04,
 7.226136401262718556e-04,
 7.248132767058608483e-04,
 7.269855188846295786e-04,
 7.291303174105546884e-04,
 7.312476240401567622e-04,
 7.333373915392041916e-04,
 7.353995736834247369e-04,
 7.374341252591368580e-04,
 7.394410020638285700e-04,
 7.414201609067992910e-04,
 7.433715596096182425e-04,
 7.452951570066621055e-04,
 7.471909129456056221e-04,
 7.490587882877828511e-04,
 7.508987449086383052e-04,
 7.527107456980605595e-04,
 7.544947545606843107e-04,
 7.562507364162082647e-04,
 7.579786571996227108e-04,
 7.596784838614114004e-04,
 7.613501843677586292e-04,
 7.629937277006503937e-04,
 7.646090838580184811e-04,
 7.661962238537797180e-04,
 7.677551197178618825e-04,
 7.692857444962511925e-04,
 7.707880722508854031e-04,
 7.722620780596120647e-04,
 7.737077380161091599e-04,
 7.751250292296649018e-04,
 7.765139298250676872e-04,
 7.778744189423480570e-04,
 7.792064767365317144e-04,
 7.805100843773641380e-04,
 7.817852240489829357e-04,
 7.830318789495419518e-04,
 7.842500332908374340e-04,
 7.854396722978802077e-04,
 7.866007822084016042e-04,
 7.877333502723910495e-04,
 7.888373647515349888e-04,
 7.899128149186553788e-04,
 7.909596910571057866e-04,
 7.919779844601335540e-04,
 7.929676874301979424e-04,
 7.939287932782540178e-04,
 7.948612963230295954e-04,
 7.957651918902326890e-04,
 7.966404763117262153e-04,
 7.974871469247019409e-04,
 7.983052020707870995e-04,
 7.990946410951118694e-04,
 7.998554643453875852e-04,
 8.005876731708947433e-04,
 8.012912699214730676e-04,
 8.019662579464677732e-04,
 8.026126415936325710e-04,
 8.032304262080092530e-04,
 8.038196181307850517e-04,
 8.043802246980747556e-04,
 8.049122542397163776e-04,
 8.054157160780107700e-04,
 8.058906205264146187e-04,
 8.063369788882313776e-04,
 8.067548034552441977e-04,
 8.071441075063179576e-04,
 8.075049053059850292e-04,
 8.078372121029805215e-04,
 8.081410441287377325e-04,
 8.084164185958818676e-04,
 8.086633536966562116e-04,
 8.088818686013411448e-04,
 8.090719834566152636e-04,
 8.092337193839120547e-04,
 8.093670984777242032e-04,
 8.094721438038737478e-04,
 8.095488793977691179e-04,
 8.095973302626120792e-04,
 8.096175223675689024e-04,
 8.096094826459341578e-04,
 8.095732389932340121e-04,
 8.095088202653166233e-04,
 8.094162562763975409e-04,
 8.092955777970859159e-04,
 8.091468165523677761e-04,
 8.089700052195641488e-04,
 8.087651774262582822e-04,
 8.085323677481871980e-04,
 8.082716117071006090e-04,
 8.079829457685973933e-04,
 8.076664073399224958e-04,
 8.073220347677394345e-04,
 8.069498673358594396e-04,
 8.065499452629619178e-04,
 8.061223097002577801e-04,
 8.056670027291479991e-04,
 8.051840673588278466e-04,
 8.046735475238796405e-04,
 8.041354880818228808e-04,
 8.035699348106476901e-04,
 8.029769344062965370e-04,
 8.023565344801446590e-04,
 8.017087835564225880e-04,
 8.010337310696298953e-04,
 8.003314273619051332e-04,
 7.996019236803823338e-04,
 7.988452721744976337e-04,
 7.980615258932864664e-04,
 7.972507387826368447e-04,
 7.964129656825282228e-04,
 7.955482623242176666e-04,
 7.946566853274374077e-04,
 7.937382921975122754e-04,
 7.927931413224972943e-04,
 7.918212919702607468e-04,
 7.908228042855317821e-04,
 7.897977392869490014e-04,
 7.887461588640586269e-04,
 7.876681257742840486e-04,
 7.865637036398866969e-04,
 7.854329569448789943e-04,
 7.842759510319227776e-04,
 7.830927520991912919e-04,
 7.818834271972155718e-04,
 7.806480442256898394e-04,
 7.793866719302669282e-04,
 7.780993798993106640e-04,
 7.767862385606291633e-04,
 7.754473191781839549e-04,
 7.740826938487735138e-04,
 7.726924354986823172e-04,
 7.712766178803085425e-04,
 7.698353155687750679e-04,
 7.683686039584927685e-04,
 7.668765592597292331e-04,
 7.653592584951234880e-04,
 7.638167794961861923e-04,
 7.622492008997814022e-04,
 7.606566021445830723e-04,
 7.590390634674799505e-04,
 7.573966658999979271e-04,
 7.557294912646853047e-04,
 7.540376221714233671e-04,
 7.523211420138068784e-04,
 7.505801349654176802e-04,
 7.488146859761091309e-04,
 7.470248807682772088e-04,
 7.452108058330804419e-04,
 7.433725484266520299e-04,
 7.415101965663034025e-04,
 7.396238390266588218e-04,
 7.377135653358222935e-04,
 7.357794657714921121e-04,
 7.338216313570454811e-04,
 7.318401538576178216e-04,
 7.298351257761545412e-04,
 7.278066403494536964e-04,
 7.257547915441482644e-04,
 7.236796740526988238e-04,
 7.215813832893810302e-04,
 7.194600153861954641e-04,
 7.173156671888024144e-04,
 7.151484362524373637e-04,
 7.129584208377604459e-04,
 7.107457199067274784e-04,
 7.085104331184505872e-04,
 7.062526608249720950e-04,
 7.039725040670914268e-04,
 7.016700645701501662e-04,
 6.993454447397392647e-04,
 6.969987476574989512e-04,
 6.946300770768122808e-04,
 6.922395374184635557e-04,
 6.898272337663859761e-04,
 6.873932718632741988e-04,
 6.849377581062314826e-04,
 6.824607995424156410e-04,
 6.799625038646101840e-04,
 6.774429794068226752e-04,
 6.749023351398709437e-04,
 6.723406806668944880e-04,
 6.697581262189100052e-04,
 6.671547826503297337e-04,
 6.645307614344314389e-04,
 6.618861746588575656e-04,
 6.592211350210664669e-04,
 6.565357558237893808e-04,
 6.538301509704408940e-04,
 6.511044349605316821e-04,
 6.483587228850827685e-04,
 6.455931304219723454e-04,
 6.428077738313162049e-04,
 6.400027699508201986e-04,
 6.371782361910900867e-04,
 6.343342905309513630e-04,
 6.314710515127771023e-04,
 6.285886382377061949e-04,
 6.256871703609873494e-04,
 6.227667680871986277e-04,
 6.198275521654534291e-04,
 6.168696438846962447e-04,
 6.138931650688516121e-04,
 6.108982380720437595e-04,
 6.078849857738000953e-04,
 6.048535315741740328e-04,
 6.018039993889274467e-04,
 5.987365136446873249e-04,
 5.956511992740372600e-04,
 5.925481817106480805e-04,
 5.894275868844089158e-04,
 5.862895412164641521e-04,
 5.831341716143296442e-04,
 5.799616054669383446e-04,
 5.767719706397206282e-04,
 5.735653954696080716e-04,
 5.703420087600790831e-04,
 5.671019397761962923e-04,
 5.638453182395781289e-04,
 5.605722743234096495e-04,
 5.572829386474481604e-04,
 5.539774422729585842e-04,
 5.506559166976907841e-04,
 5.473184938508689245e-04,
 5.439653060880461719e-04,
 5.405964861861393750e-04,
 5.372121673383002454e-04,
 5.338124831487895761e-04,
 5.303975676279690937e-04,
 5.269675551871457527e-04,
 5.235225806334174378e-04,
 5.200627791646430251e-04,
 5.165882863642302968e-04,
 5.130992381960214344e-04,
 5.095957709991694043e-04,
 5.060780214829311858e-04,
 5.025461267215298447e-04,
 4.990002241489996946e-04,
 4.954404515539628275e-04,
 4.918669470744596378e-04,
 4.882798491927809186e-04,
 4.846792967302175582e-04,
 4.810654288418840172e-04,
 4.774383850114784873e-04,
 4.737983050461042544e-04,
 4.701453290709878448e-04,
 4.664795975242650968e-04,
 4.628012511517678833e-04,
 4.591104310017354818e-04,
 4.554072784195751134e-04,
 4.516919350426390695e-04,
 4.479645427949119590e-04,
 4.442252438817632780e-04,
 4.404741807847180855e-04,
 4.367114962560791447e-04,
 4.329373333137633549e-04,
 4.291518352359646044e-04,
 4.253551455558110929e-04,
 4.215474080561872907e-04,
 4.177287667643441523e-04,
 4.138993659466307074e-04,
 4.100593501032241879e-04,
 4.062088639627654493e-04,
 4.023480524770779851e-04,
 3.984770608158919817e-04,
 3.945960343614649413e-04,
 3.907051187033032435e-04,
 3.868044596328656546e-04,
 3.828942031381954978e-04,
 3.789744953986290410e-04,
 3.750454827794597588e-04,
 3.711073118266491064e-04,
 3.671601292614462206e-04,
 3.632040819750935977e-04,
 3.592393170235192194e-04,
 3.552659816219668788e-04,
 3.512842231396859751e-04,
 3.472941890946343183e-04,
 3.432960271480985895e-04,
 3.392898850993909658e-04,
 3.352759108805616287e-04,
 3.312542525509678875e-04,
 3.272250582920719600e-04,
 3.231884764020604025e-04,
 3.191446552904624555e-04,
 3.150937434729509691e-04,
 3.110358895659198200e-04,
 3.069712422812003231e-04,
 3.028999504207764508e-04,
 2.988221628714084915e-04,
 2.947380285993509244e-04,
 2.906476966450733312e-04,
 2.865513161178917523e-04,
 2.824490361906951269e-04,
 2.783410060946716800e-04,
 2.742273751139537763e-04,
 2.701082925803509208e-04,
 2.659839078680851978e-04,
 2.618543703884510334e-04,
 2.577198295845655970e-04,
 2.535804349260690040e-04,
 2.494363359038927696e-04,
 2.452876820249253170e-04,
 2.411346228067783439e-04,
 2.369773077725528365e-04,
 2.328158864455248255e-04,
 2.286505083439224859e-04,
 2.244813229757127511e-04,
 2.203084798332983715e-04,
 2.161321283883147469e-04,
 2.119524180864417481e-04,
 2.077694983420694426e-04,
 2.035835185332142427e-04,
 1.993946279962468919e-04,
 1.952029760206311837e-04,
 1.910087118438572409e-04,
 1.868119846461404178e-04,
 1.826129435452815311e-04,
 1.784117375915205046e-04,
 1.742085157623095390e-04,
 1.700034269571836702e-04,
 1.657966199926384830e-04,
 1.615882435969271606e-04,
 1.573784464049535398e-04,
 1.531673769531766865e-04,
 1.489551836744313089e-04,
 1.447420148928568089e-04,
 1.405280188187795496e-04,
 1.363133435436576270e-04,
 1.320981370349393394e-04,
 1.278825471310213494e-04,
 1.236667215362126729e-04,
 1.194508078156219339e-04,
 1.152349533901436213e-04,
 1.110193055314539801e-04,
 1.068040113569272828e-04,
 1.025892178246517924e-04,
 9.837507172846837213e-05,
 9.416171969286832473e-05,
 8.994930816814143877e-05,
 8.573798342534791968e-05,
 8.152789155129717849e-05,
 7.731917844373348628e-05,
 7.311198980628809147e-05,
 6.890647114359636631e-05,
 6.470276775641560377e-05,
 6.050102473665496032e-05,
 5.630138696256780528e-05,
 5.210399909380643079e-05,
 4.790900556658911222e-05,
 4.371655058888034159e-05,
 3.952677813549303914e-05,
 3.533983194329480765e-05,
 3.115585550642686511e-05,
 2.697499207144599906e-05,
 2.279738463257082799e-05,
 1.862317592695097657e-05,
 1.445250842980009386e-05,
 1.028552434978355900e-05,
 6.122365624229527987e-06,
 1.963173914354139532e-06,
-2.191909399307805455e-06,
-6.342743221698878667e-06,
-1.048918674786956803e-05,
-1.463109946760408130e-05,
-1.876834117012134975e-05,
-2.290077194867067017e-05,
-2.702825220511210672e-05,
-3.115064265457150446e-05,
-3.526780432998958143e-05,
-3.937959858665561496e-05,
-4.348588710681530083e-05,
-4.758653190416223022e-05,
-5.168139532837312094e-05,
-5.577034006956731714e-05,
-5.985322916284904076e-05,
-6.392992599274387232e-05,
-6.800029429761756587e-05,
-7.206419817416877282e-05,
-7.612150208181388072e-05,
-8.017207084705626672e-05,
-8.421576966792508904e-05,
-8.825246411831133672e-05,
-9.228202015227184116e-05,
-9.630430410846711894e-05,
-1.003191827143430040e-04,
-1.043265230904824321e-04,
-1.083261927549382646e-04,
-1.123180596273612263e-04,
-1.163019920333456850e-04,
-1.202778587086088317e-04,
-1.242455288031627035e-04,
-1.282048718855528042e-04,
-1.321557579469925879e-04,
-1.360980574054779105e-04,
-1.400316411099682427e-04,
-1.439563803444644352e-04,
-1.478721468320641497e-04,
-1.517788127390868962e-04,
-1.556762506790810815e-04,
-1.595643337168700345e-04,
-1.634429353725202680e-04,
-1.673119296253876124e-04,
-1.711711909180511893e-04,
-1.750205941602354584e-04,
-1.788600147327902427e-04,
-1.826893284915673743e-04,
-1.865084117712798853e-04,
-1.903171413894207207e-04,
-1.941153946500767181e-04,
-1.979030493477156982e-04,
-2.016799837710877500e-04,
-2.054460767068859580e-04,
-2.092012074435604897e-04,
-2.129452557751097797e-04,
-2.166781020046869115e-04,
-2.203996269483478397e-04,
-2.241097119387793922e-04,
-2.278082388288294596e-04,
-2.314950899952372199e-04,
-2.351701483422017356e-04,
-2.388332973049388144e-04,
-2.424844208532982604e-04,
-2.461234034952754419e-04,
-2.497501302805005523e-04,
-2.533644868037883153e-04,
-2.569663592085805431e-04,
-2.605556341903700747e-04,
-2.641321990001794921e-04,
-2.676959414479296285e-04,
-2.712467499058333919e-04,
-2.747845133117211218e-04,
-2.783091211724257933e-04,
-2.818204635670651143e-04,
-2.853184311503021548e-04,
-2.888029151556634395e-04,
-2.922738073987491076e-04,
-2.957310002804216056e-04,
-2.991743867900526020e-04,
-3.026038605086632700e-04,
-3.060193156120324790e-04,
-3.094206468739132423e-04,
-3.128077496690150321e-04,
-3.161805199761264450e-04,
-3.195388543812149895e-04,
-3.228826500803346454e-04,
-3.262118048827233213e-04,
-3.295262172137374641e-04,
-3.328257861177762070e-04,
-3.361104112612581544e-04,
-3.393799929354906694e-04,
-3.426344320595245234e-04,
-3.458736301830481197e-04,
-3.490974894891895057e-04,
-3.523059127972889490e-04,
-3.554988035657231753e-04,
-3.586760658946206988e-04,
-3.618376045285989447e-04,
-3.649833248594339346e-04,
-3.681131329287763211e-04,
-3.712269354307747233e-04,
-3.743246397146759150e-04,
-3.774061537874640981e-04,
-3.804713863164073677e-04,
-3.835202466315781032e-04,
-3.865526447284191119e-04,
-3.895684912702074244e-04,
-3.925676975904945627e-04,
-3.955501756956266053e-04,
-3.985158382670605311e-04,
-4.014645986637956510e-04,
-4.043963709247800492e-04,
-4.073110697711497855e-04,
-4.102086106086150078e-04,
-4.130889095297162849e-04,
-4.159518833160564914e-04,
-4.187974494405718312e-04,
-4.216255260697148247e-04,
-4.244360320656046610e-04,
-4.272288869882246592e-04,
-4.300040110975179766e-04,
-4.327613253554627717e-04,
-4.355007514281856399e-04,
-4.382222116879796927e-04,
-4.409256292152973216e-04,
-4.436109278007842154e-04,
-4.462780319472062045e-04,
-4.489268668714023426e-04,
-4.515573585061591669e-04,
-4.541694335021370004e-04,
-4.567630192296945552e-04,
-4.593380437806990086e-04,
-4.618944359703641592e-04,
-4.644321253389956669e-04,
-4.669510421537198682e-04,
-4.694511174102391528e-04,
-4.719322828344936667e-04,
-4.743944708843056673e-04,
-4.768376147510778717e-04,
-4.792616483613185499e-04,
-4.816665063782572570e-04,
-4.840521242034328099e-04,
-4.864184379781392878e-04,
-4.887653845849875001e-04,
-4.910929016493441020e-04,
-4.934009275407648561e-04,
-4.956894013744314164e-04,
-4.979582630125267478e-04,
-5.002074530655732480e-04,
-5.024369128937963488e-04,
-5.046465846084096209e-04,
-5.068364110728711472e-04,
-5.090063359041649416e-04,
-5.111563034739979080e-04,
-5.132862589100021123e-04,
-5.153961480968690745e-04,
-5.174859176775289471e-04,
-5.195555150542333078e-04,
-5.216048883896219060e-04,
-5.236339866078035038e-04,
-5.256427593953671117e-04,
-5.276311572023592881e-04,
-5.295991312432845330e-04,
-5.315466334980310879e-04,
-5.334736167127590058e-04,
-5.353800344008440579e-04,
-5.372658408436644306e-04,
-5.391309910914612565e-04,
-5.409754409641723662e-04,
-5.427991470521338754e-04,
-5.446020667168816271e-04,
-5.463841580918508273e-04,
-5.481453800830460819e-04,
-5.498856923697329011e-04,
-5.516050554050554774e-04,
-5.533034304166338643e-04,
-5.549807794071562762e-04,
-5.566370651549240080e-04,
-5.582722512143591673e-04,
-5.598863019165212966e-04,
-5.614791823695569921e-04,
-5.630508584591426913e-04,
-5.646012968488869129e-04,
-5.661304649807269657e-04,
-5.676383310752780619e-04,
-5.691248641321425316e-04,
-5.705900339302359507e-04,
-5.720338110280472413e-04,
-5.734561667638651610e-04,
-5.748570732560228996e-04,
-5.762365034030694907e-04,
-5.775944308839210586e-04,
-5.789308301580147744e-04,
-5.802456764654073023e-04,
-5.815389458268270572e-04,
-5.828106150437761205e-04,
-5.840606616984941359e-04,
-5.852890641539828121e-04,
-5.864958015539906361e-04,
-5.876808538229068377e-04,
-5.888442016657117334e-04,
-5.899858265678480313e-04,
-5.911057107950715367e-04,
-5.922038373932919913e-04,
-5.932801901883750974e-04,
-5.943347537859077889e-04,
-5.953675135709560196e-04,
-5.963784557077862324e-04,
-5.973675671395502901e-04,
-5.983348355879607562e-04,
-5.992802495529256281e-04,
-6.002037983121684319e-04,
-6.011054719207968187e-04,
-6.019852612108830868e-04,
-6.028431577909788928e-04,
-6.036791540456271435e-04,
-6.044932431348390856e-04,
-6.052854189935475424e-04,
-6.060556763310210107e-04,
-6.068040106302798184e-04,
-6.075304181474490721e-04,
-6.082348959111083531e-04,
-6.089174417216230897e-04,
-6.095780541504153228e-04,
-6.102167325392310023e-04,
-6.108334769994055481e-04,
-6.114282884110374718e-04,
-6.120011684221977758e-04,
-6.125521194480911067e-04,
-6.130811446701708292e-04,
-6.135882480352661348e-04,
-6.140734342546560250e-04,
-6.145367088031177070e-04,
-6.149780779179629545e-04,
-6.153975485980498579e-04,
-6.157951286027385203e-04,
-6.161708264508632344e-04,
-6.165246514196488217e-04,
-6.168566135436185163e-04,
-6.171667236134546850e-04,
-6.174549931748643181e-04,
-6.177214345273962732e-04,
-6.179660607232365099e-04,
-6.181888855659877120e-04,
-6.183899236094177925e-04,
-6.185691901561730542e-04,
-6.187267012564867967e-04,
-6.188624737068503011e-04,
-6.189765250486558429e-04,
-6.190688735668237663e-04,
-6.191395382884032133e-04,
-6.191885389811366399e-04,
-6.192158961520189114e-04,
-6.192216310458151978e-04,
-6.192057656435624984e-04,
-6.191683226610496986e-04,
-6.191093255472567523e-04,
-6.190287984827980931e-04,
-6.189267663783119431e-04,
-6.188032548728387809e-04,
-6.186582903321892913e-04,
-6.184918998472626597e-04,
-6.183041112323545661e-04,
-6.180949530234442543e-04,
-6.178644544764535194e-04,
-6.176126455654801098e-04,
-6.173395569810077085e-04,
-6.170452201281006284e-04,
-6.167296671245690171e-04,
-6.163929307991048963e-04,
-6.160350446894051913e-04,
-6.156560430402689557e-04,
-6.152559608016694437e-04,
-6.148348336267999434e-04,
-6.143926978701053001e-04,
-6.139295905852934889e-04,
-6.134455495232993749e-04,
-6.129406131302638687e-04,
-6.124148205454583299e-04,
-6.118682115992002965e-04,
-6.113008268107554457e-04,
-6.107127073861997636e-04,
-6.101038952162644770e-04,
-6.094744328741759972e-04,
-6.088243636134469663e-04,
-6.081537313656636178e-04,
-6.074625807382529703e-04,
-6.067509570122140263e-04,
-6.060189061398409474e-04,
-6.052664747424182576e-04,
-6.044937101078982650e-04,
-6.037006601885510542e-04,
-6.028873735986067794e-04,
-6.020538996118607713e-04,
-6.012002881592650892e-04,
-6.003265898265066312e-04,
-5.994328558515527169e-04,
-5.985191381221832262e-04,
-5.975854891734927064e-04,
-5.966319621853970320e-04,
-5.956586109800830363e-04,
-5.946654900194719116e-04,
-5.936526544026431455e-04,
-5.926201598632436021e-04,
-5.915680627668748123e-04,
-5.904964201084772274e-04,
-5.894052895096540826e-04,
-5.882947292160319074e-04,
-5.871647980945590185e-04,
-5.860155556307927380e-04,
-5.848470619261819485e-04,
-5.836593776953231949e-04,
-5.824525642631895716e-04,
-5.812266835623525630e-04,
-5.799817981301792725e-04,
-5.787179711060220621e-04,
-5.774352662283634141e-04,
-5.761337478319708766e-04,
-5.748134808450266380e-04,
-5.734745307862269608e-04,
-5.721169637618717498e-04,
-5.707408464629464212e-04,
-5.693462461621697293e-04,
-5.679332307110253287e-04,
-5.665018685368019028e-04,
-5.650522286395598913e-04,
-5.635843805891618602e-04,
-5.620983945222121246e-04,
-5.605943411390014669e-04,
-5.590722917004733224e-04,
-5.575323180251127693e-04,
-5.559744924858600222e-04,
-5.543988880070024579e-04,
-5.528055780610286948e-04,
-5.511946366654886346e-04,
-5.495661383798437468e-04,
-5.479201583022637930e-04,
-5.462567720664432847e-04,
-5.445760558384051464e-04,
-5.428780863132523374e-04,
-5.411629407119379056e-04,
-5.394306967780089111e-04,
-5.376814327743420019e-04,
-5.359152274798394166e-04,
-5.341321601861401648e-04,
-5.323323106943111515e-04,
-5.305157593114988345e-04,
-5.286825868475931349e-04,
-5.268328746118826735e-04,
-5.249667044096563385e-04,
-5.230841585388290322e-04,
-5.211853197865536471e-04,
-5.192702714257683158e-04,
-5.173390972118150017e-04,
-5.153918813789747132e-04,
-5.134287086369905767e-04,
-5.114496641676510814e-04,
-5.094548336212589412e-04,
-5.074443031131625152e-04,
-5.054181592202514495e-04,
-5.033764889774196847e-04,
-5.013193798740397380e-04,
-4.992469198504351441e-04,
-4.971591972942945642e-04,
-4.950563010371177713e-04,
-4.929383203506471078e-04,
-4.908053449432454906e-04,
-4.886574649563142072e-04,
-4.864947709606651759e-04,
-4.843173539529117984e-04,
-4.821253053518022432e-04,
-4.799187169945834104e-04,
-4.776976811333543804e-04,
-4.754622904313672788e-04,
-4.732126379593568728e-04,
-4.709488171918626317e-04,
-4.686709220034980419e-04,
-4.663790466652465382e-04,
-4.640732858407570563e-04,
-4.617537345825791948e-04,
-4.594204883284330179e-04,
-4.570736428974772310e-04,
-4.547132944864867724e-04,
-4.523395396661517801e-04,
-4.499524753772600081e-04,
-4.475521989268783744e-04,
-4.451388079846178305e-04,
-4.427124005787705114e-04,
-4.402730750925058128e-04,
-4.378209302600714003e-04,
-4.353560651629133382e-04,
-4.328785792258610528e-04,
-4.303885722132850828e-04,
-4.278861442252072326e-04,
-4.253713956934523596e-04,
-4.228444273777876928e-04,
-4.203053403620071282e-04,
-4.177542360500658856e-04,
-4.151912161621689238e-04,
-4.126163827308963273e-04,
-4.100298380972492752e-04,
-4.074316849067566174e-04,
-4.048220261055625845e-04,
-4.022009649364658183e-04,
-3.995686049349941806e-04,
-3.969250499254837897e-04,
-3.942704040170865007e-04,
-3.916047715998412443e-04,
-3.889282573407287780e-04,
-3.862409661796424110e-04,
-3.835430033254899726e-04,
-3.808344742521838902e-04,
-3.781154846946167933e-04,
-3.753861406447554588e-04,
-3.726465483475792807e-04,
-3.698968142971049890e-04,
-3.671370452324029658e-04,
-3.643673481335547425e-04,
-3.615878302176550596e-04,
-3.587985989348221644e-04,
-3.559997619641304270e-04,
-3.531914272096155975e-04,
-3.503737027962569692e-04,
-3.475466970659134638e-04,
-3.447105185733121920e-04,
-3.418652760819985786e-04,
-3.390110785603189596e-04,
-3.361480351773383449e-04,
-3.332762552988153171e-04,
-3.303958484831651674e-04,
-3.275069244773739174e-04,
-3.246095932129608040e-04,
-3.217039648019402774e-04,
-3.187901495327224153e-04,
-3.158682578660709631e-04,
-3.129384004310637054e-04,
-3.100006880209819297e-04,
-3.070552315892662444e-04,
-3.041021422454750524e-04,
-3.011415312511400255e-04,
-2.981735100157859985e-04,
-2.951981900928157170e-04,
-2.922156831753968081e-04,
-2.892261010924789639e-04,
-2.862295558046435069e-04,
-2.832261594000568764e-04,
-2.802160240904169597e-04,
-2.771992622068371348e-04,
-2.741759861957921134e-04,
-2.711463086150643262e-04,
-2.681103421296289957e-04,
-2.650681995075991116e-04,
-2.620199936161758279e-04,
-2.589658374175321260e-04,
-2.559058439647700963e-04,
-2.528401263978371821e-04,
-2.497687979394841657e-04,
-2.466919718911537648e-04,
-2.436097616289358545e-04,
-2.405222805995268077e-04,
-2.374296423161179298e-04,
-2.343319603543603561e-04,
-2.312293483483235802e-04,
-2.281219199863990395e-04,
-2.250097890072605953e-04,
-2.218930691958490270e-04,
-2.187718743792344998e-04,
-2.156463184226692018e-04,
-2.125165152254974890e-04,
-2.093825787170703408e-04,
-2.062446228528014118e-04,
-2.031027616100538941e-04,
-1.999571089841372089e-04,
-1.968077789842991184e-04,
-1.936548856296604545e-04,
-1.904985429452152540e-04,
-1.873388649578360422e-04,
-1.841759656922168568e-04,
-1.810099591668891037e-04,
-1.778409593902383599e-04,
-1.746690803564612490e-04,
-1.714944360416001336e-04,
-1.683171403995389946e-04,
-1.651373073580485326e-04,
-1.619550508147597659e-04,
-1.587704846332155836e-04,
-1.555837226389194519e-04,
-1.523948786153299644e-04,
-1.492040662999244297e-04,
-1.460113993802669848e-04,
-1.428169914900206017e-04,
-1.396209562050251753e-04,
-1.364234070393964017e-04,
-1.332244574415121703e-04,
-1.300242207901904795e-04,
-1.268228103907297142e-04,
-1.236203394709516870e-04,
-1.204169211773936627e-04,
-1.172126685713664837e-04,
-1.140076946250221014e-04,
-1.108021122175711193e-04,
-1.075960341313265945e-04,
-1.043895730478680751e-04,
-1.011828415442064935e-04,
-9.797595208888789547e-05,
-9.476901703817362007e-05,
-9.156214863222875968e-05,
-8.835545899124883421e-05,
-8.514906011166596439e-05,
-8.194306386236004601e-05,
-7.873758198081212255e-05,
-7.553272606934206812e-05,
-7.232860759130854016e-05,
-6.912533786736448397e-05,
-6.592302807164487455e-05,
-6.272178922803207381e-05,
-5.952173220643080333e-05,
-5.632296771898314704e-05,
-5.312560631636255857e-05,
-4.992975838407696893e-05,
-4.673553413871244617e-05,
-4.354304362425660477e-05,
-4.035239670843832559e-05,
-3.716370307896371087e-05,
-3.397707223994543373e-05,
-3.079261350819724013e-05,
-2.761043600953867275e-05,
-2.443064867525565571e-05,
-2.125336023838858278e-05,
-1.807867923014542757e-05,
-1.490671397631821315e-05,
-1.173757259364196804e-05,
-8.571362986233174608e-06,
-5.408192842039840435e-06,
-2.248169629233924849e-06,
 9.085994073158900746e-07,
 4.062007249559963914e-06,
 7.211947109840360059e-06,
 1.035831243437538848e-05,
 1.350099690677804931e-05,
 1.663989445151674347e-05,
 1.977489923743988608e-05,
 2.290590568121984836e-05,
 2.603280845078441007e-05,
 2.915550246880447023e-05,
 3.227388291610041378e-05,
 3.538784523503596597e-05,
 3.849728513296748328e-05,
 4.160209858561236292e-05,
 4.470218184039641198e-05,
 4.779743141990192208e-05,
 5.088774412512074341e-05,
 5.397301703883864219e-05,
 5.705314752900416748e-05,
 6.012803325194276179e-05,
 6.319757215573732379e-05,
 6.626166248348101806e-05,
 6.932020277652611406e-05,
 7.237309187778388417e-05,
 7.542022893494506361e-05,
 7.846151340368422351e-05,
 8.149684505092017015e-05,
 8.452612395799063798e-05,
 8.754925052381620841e-05,
 9.056612546811526740e-05,
 9.357664983453636040e-05,
 9.658072499377798412e-05,
 9.957825264675863105e-05,
 1.025691348276992982e-04,
 1.055532739072324638e-04,
 1.085305725954559193e-04,
 1.115009339450413528e-04,
 1.144642613542636370e-04,
 1.174204585700133123e-04,
 1.203694296908608944e-04,
 1.233110791700392842e-04,
 1.262453118184091280e-04,
 1.291720328074765867e-04,
 1.320911476723274705e-04,
 1.350025623145396372e-04,
 1.379061830051878036e-04,
 1.408019163876573490e-04,
 1.436896694805827462e-04,
 1.465693496807631176e-04,
 1.494408647659332110e-04,
 1.523041228976822355e-04,
 1.551590326242550325e-04,
 1.580055028833392348e-04,
 1.608434430049030569e-04,
 1.636727627139501718e-04,
 1.664933721332581887e-04,
 1.693051817861664619e-04,
 1.721081025992772181e-04,
 1.749020459051485248e-04,
 1.776869234450233627e-04,
 1.804626473714810147e-04,
 1.832291302511037702e-04,
 1.859862850670928333e-04,
 1.887340252219307985e-04,
 1.914722645399650060e-04,
 1.942009172699763961e-04,
 1.969198980877891300e-04,
 1.996291220988007380e-04,
 2.023285048404991216e-04,
 2.050179622850149016e-04,
 2.076974108416031564e-04,
 2.103667673590943422e-04,
 2.130259491284320315e-04,
 2.156748738850263088e-04,
 2.183134598112238813e-04,
 2.209416255387514376e-04,
 2.235592901510201726e-04,
 2.261663731855686858e-04,
 2.287627946363877268e-04,
 2.313484749562338288e-04,
 2.339233350589864997e-04,
 2.364872963219185416e-04,
 2.390402805879580212e-04,
 2.415822101679853697e-04,
 2.441130078430523375e-04,
 2.466325968665815968e-04,
 2.491409009666123138e-04,
 2.516378443479499322e-04,
 2.541233516943481024e-04,
 2.565973481706226595e-04,
 2.590597594248182927e-04,
 2.615105115902947126e-04,
 2.639495312877900512e-04,
 2.663767456275328328e-04,
 2.687920822112623855e-04,
 2.711954691342454023e-04,
 2.735868349873153802e-04,
 2.759661088588475481e-04,
 2.783332203367077208e-04,
 2.806880995102372018e-04,
 2.830306769721676469e-04,
 2.853608838205087686e-04,
 2.876786516604782707e-04,
 2.899839126063509000e-04,
 2.922765992832912366e-04,
 2.945566448292232919e-04,
 2.968239828966126115e-04,
 2.990785476542692496e-04,
 3.013202737890967493e-04,
 3.035490965078737041e-04,
 3.057649515389691277e-04,
 3.079677751340319670e-04,
 3.101575040697167177e-04,
 3.123340756493348815e-04,
 3.144974277044852262e-04,
 3.166474985967178738e-04,
 3.187842272191221144e-04,
 3.209075529978961685e-04,
 3.230174158939708336e-04,
 3.251137564044837827e-04,
 3.271965155643439594e-04,
 3.292656349477634473e-04,
 3.313210566696717574e-04,
 3.333627233872442277e-04,
 3.353905783013171786e-04,
 3.374045651577999775e-04,
 3.394046282491060230e-04,
 3.413907124155172133e-04,
 3.433627630465302546e-04,
 3.453207260822255199e-04,
 3.472645480145729172e-04,
 3.491941758887091873e-04,
 3.511095573042519570e-04,
 3.530106404165289538e-04,
 3.548973739378270061e-04,
 3.567697071385853166e-04,
 3.586275898486170326e-04,
 3.604709724582657649e-04,
 3.622998059195475231e-04,
 3.641140417472995910e-04,
 3.659136320202863580e-04,
 3.676985293822643318e-04,
 3.694686870430808679e-04,
 3.712240587797045418e-04,
 3.729645989372330230e-04,
 3.746902624299445345e-04,
 3.764010047422215927e-04,
 3.780967819295399089e-04,
 3.797775506194354424e-04,
 3.814432680123662337e-04,
 3.830938918826428665e-04,
 3.847293805793243439e-04,
 3.863496930270196930e-04,
 3.879547887267716447e-04,
 3.895446277568475040e-04,
 3.911191707735202643e-04,
 3.926783790118635437e-04,
 3.942222142864887889e-04,
 3.957506389922609566e-04,
 3.972636161050249835e-04,
 3.987611091822865564e-04,
 4.002430823638575925e-04,
 4.017095003725249750e-04,
 4.031603285146561884e-04,
 4.045955326808080982e-04,
 4.060150793462865616e-04,
 4.074189355717365048e-04,
 4.088070690036545336e-04,
 4.101794478748993760e-04,
 4.115360410052106184e-04,
 4.128768178016641792e-04,
 4.142017482591180241e-04,
 4.155108029606594542e-04,
 4.168039530780101630e-04,
 4.180811703718910173e-04,
 4.193424271924330775e-04,
 4.205876964794781929e-04,
 4.218169517629213926e-04,
 4.230301671630330566e-04,
 4.242273173907018849e-04,
 4.254083777477293132e-04,
 4.265733241270551349e-04,
 4.277221330129674028e-04,
 4.288547814813199201e-04,
 4.299712471996981235e-04,
 4.310715084275624142e-04,
 4.321555440164084037e-04,
 4.332233334098622686e-04,
 4.342748566437679212e-04,
 4.353100943462749920e-04,
 4.363290277378814390e-04,
 4.373316386314608155e-04,
 4.383179094322644923e-04,
 4.392878231379250737e-04,
 4.402413633384142755e-04,
 4.411785142159785236e-04,
 4.420992605450830095e-04,
 4.430035876923051129e-04,
 4.438914816162095557e-04,
 4.447629288672291402e-04,
 4.456179165874963178e-04,
 4.464564325106518822e-04,
 4.472784649616788144e-04,
 4.480840028566412622e-04,
 4.488730357024674276e-04,
 4.496455535966942382e-04,
 4.504015472271598124e-04,
 4.511410078717227601e-04,
 4.518639273979317716e-04,
 4.525702982626724391e-04,
 4.532601135118208540e-04,
 4.539333667798478187e-04,
 4.545900522894110243e-04,
 4.552301648509383914e-04,
 4.558536998621819753e-04,
 4.564606533077386402e-04,
 4.570510217585829304e-04,
 4.576248023715507197e-04,
 4.581819928888074094e-04,
 4.587225916373142845e-04,
 4.592465975282551877e-04,
 4.597540100564493693e-04,
 4.602448292997426537e-04,
 4.607190559183878720e-04,
 4.611766911543958044e-04,
 4.616177368308614572e-04,
 4.620421953512901764e-04,
 4.624500696988885257e-04,
 4.628413634358270832e-04,
 4.632160807025117490e-04,
 4.635742262168107632e-04,
 4.639158052732666538e-04,
 4.642408237423050941e-04,
 4.645492880693974109e-04,
 4.648412052742233636e-04,
 4.651165829498146785e-04,
 4.653754292616635638e-04,
 4.656177529468281885e-04,
 4.658435633130129537e-04,
 4.660528702376251281e-04,
 4.662456841668207504e-04,
 4.664220161145283595e-04,
 4.665818776614450228e-04,
 4.667252809540293839e-04,
 4.668522387034660325e-04,
 4.669627641846072147e-04,
 4.670568712349087970e-04,
 4.671345742533333247e-04,
 4.671958881992458162e-04,
 4.672408285912818017e-04,
 4.672694115062051706e-04,
 4.672816535777399435e-04,
 4.672775719953896844e-04,
 4.672571845032351206e-04,
 4.672205093987145236e-04,
 4.671675655313846831e-04,
 4.670983723016658884e-04,
 4.670129496595690753e-04,
 4.669113181033992285e-04,
 4.667934986784483221e-04,
 4.666595129756697736e-04,
 4.665093831303249801e-04,
 4.663431318206253014e-04,
 4.661607822663494305e-04,
 4.659623582274440685e-04,
 4.657478840026049206e-04,
 4.655173844278470674e-04,
 4.652708848750484474e-04,
 4.650084112504843407e-04,
 4.647299899933398986e-04,
 4.644356480742053246e-04,
 4.641254129935572324e-04,
 4.637993127802194585e-04,
 4.634573759898105391e-04,
 4.630996317031664121e-04,
 4.627261095247605727e-04,
 4.623368395810890995e-04,
 4.619318525190577954e-04,
 4.615111795043335503e-04,
 4.610748522197000935e-04,
 4.606229028633767762e-04,
 4.601553641473365942e-04,
 4.596722692955974854e-04,
 4.591736520425064171e-04,
 4.586595466309942000e-04,
 4.581299878108344224e-04,
 4.575850108368651956e-04,
 4.570246514672037983e-04,
 4.564489459614547075e-04,
 4.558579310788811456e-04,
 4.552516440765832953e-04,
 4.546301227076468619e-04,
 4.539934052192734753e-04,
 4.533415303509126092e-04,
 4.526745373323598910e-04,
 4.519924658818471165e-04,
 4.512953562041267363e-04,
 4.505832489885180144e-04,
 4.498561854069646807e-04,
 4.491142071120569120e-04,
 4.483573562350536934e-04,
 4.475856753838733577e-04,
 4.467992076410936121e-04,
 4.459979965619085759e-04,
 4.451820861720944380e-04,
 4.443515209659479001e-04,
 4.435063459042188207e-04,
 4.426466064120195476e-04,
 4.417723483767223790e-04,
 4.408836181458559403e-04,
 4.399804625249631798e-04,
 4.390629287754658702e-04,
 4.381310646125140935e-04,
 4.371849182028055849e-04,
 4.362245381624045354e-04,
 4.352499735545582249e-04,
 4.342612738874614521e-04,
 4.332584891120592357e-04,
 4.322416696197972576e-04,
 4.312108662403607053e-04,
 4.301661302394392430e-04,
 4.291075133164244920e-04,
 4.280350676021317958e-04,
 4.269488456565061576e-04,
 4.258489004662909341e-04,
 4.247352854427120339e-04,
 4.236080544191417872e-04,
 4.224672616487353850e-04,
 4.213129618020723601e-04,
 4.201452099647876590e-04,
 4.189640616351733332e-04,
 4.177695727217762721e-04,
 4.165617995409934965e-04,
 4.153407988146542258e-04,
 4.141066276675647016e-04,
 4.128593436250719857e-04,
 4.115990046106124704e-04,
 4.103256689432263453e-04,
 4.090393953350821466e-04,
 4.077402428889936631e-04,
 4.064282710958981365e-04,
 4.051035398323516454e-04,
 4.037661093580081190e-04,
 4.024160403130726000e-04,
 4.010533937157509843e-04,
 3.996782309597162949e-04,
 3.982906138114988988e-04,
 3.968906044079513170e-04,
 3.954782652536374655e-04,
 3.940536592182181021e-04,
 3.926168495338786110e-04,
 3.911678997926778026e-04,
 3.897068739439286987e-04,
 3.882338362915720522e-04,
 3.867488514915060657e-04,
 3.852519845489371978e-04,
 3.837433008157242471e-04,
 3.822228659876809658e-04,
 3.806907461018970503e-04,
 3.791470075340564751e-04,
 3.775917169957095326e-04,
 3.760249415315750120e-04,
 3.744467485168102871e-04,
 3.728572056542912697e-04,
 3.712563809718577232e-04,
 3.696443428195687669e-04,
 3.680211598669621219e-04,
 3.663869011002663561e-04,
 3.647416358196356261e-04,
 3.630854336363811136e-04,
 3.614183644701632120e-04,
 3.597404985461995436e-04,
 3.580519063924802407e-04,
 3.563526588369090664e-04,
 3.546428270045379953e-04,
 3.529224823147112614e-04,
 3.511916964782126603e-04,
 3.494505414944692285e-04,
 3.476990896486621707e-04,
 3.459374135088842434e-04,
 3.441655859232905807e-04,
 3.423836800172041996e-04,
 3.405917691902502365e-04,
 3.387899271134843840e-04,
 3.369782277264827294e-04,
 3.351567452344539279e-04,
 3.333255541053511050e-04,
 3.314847290669380056e-04,
 3.296343451038909211e-04,
 3.277744774548732956e-04,
 3.259052016096209564e-04,
 3.240265933059882598e-04,
 3.221387285270224795e-04,
 3.202416834980367864e-04,
 3.183355346836296679e-04,
 3.164203587847511860e-04,
 3.144962327357511819e-04,
 3.125632337013957147e-04,
 3.106214390739068100e-04,
 3.086709264700072497e-04,
 3.067117737278970578e-04,
 3.047440589043241485e-04,
 3.027678602715731717e-04,
 3.007832563144453592e-04,
 2.987903257273184397e-04,
 2.967891474111177029e-04,
 2.947798004702863054e-04,
 2.927623642098342886e-04,
 2.907369181322795571e-04,
 2.887035419346474572e-04,
 2.866623155054684588e-04,
 2.846133189217250415e-04,
 2.825566324458409742e-04,
 2.804923365226680461e-04,
 2.784205117764215688e-04,
 2.763412390076613618e-04,
 2.742545991902678036e-04,
 2.721606734683706128e-04,
 2.700595431533260918e-04,
 2.679512897206588642e-04,
 2.658359948070293066e-04,
 2.637137402071755565e-04,
 2.615846078708275479e-04,
 2.594486798997124445e-04,
 2.573060385444451482e-04,
 2.551567662014868950e-04,
 2.530009454100995685e-04,
 2.508386588492504655e-04,
 2.486699893345648742e-04,
 2.464950198152724196e-04,
 2.443138333711105271e-04,
 2.421265132092706592e-04,
 2.399331426613412718e-04,
 2.377338051802090557e-04,
 2.355285843370046853e-04,
 2.333175638180193473e-04,
 2.311008274216529016e-04,
 2.288784590553089428e-04,
 2.266505427323334200e-04,
 2.244171625689555063e-04,
 2.221784027811817388e-04,
 2.199343476817356682e-04,
 2.176850816769960453e-04,
 2.154306892638919362e-04,
 2.131712550268407733e-04,
 2.109068636346947000e-04,
 2.086375998376094484e-04,
 2.063635484640345132e-04,
 2.040847944176105719e-04,
 2.018014226740629739e-04,
 1.995135182781994224e-04,
 1.972211663407786360e-04,
 1.949244520354615449e-04,
 1.926234605957580963e-04,
 1.903182773119268428e-04,
 1.880089875279238618e-04,
 1.856956766383542233e-04,
 1.833784300853742884e-04,
 1.810573333556474325e-04,
 1.787324719772986567e-04,
 1.764039315168246930e-04,
 1.740717975760575607e-04,
 1.717361557891002315e-04,
 1.693970918192953085e-04,
 1.670546913561437512e-04,
 1.647090401122718734e-04,
 1.623602238204041701e-04,
 1.600083282302875711e-04,
 1.576534391056663275e-04,
 1.552956422212641073e-04,
 1.529350233597161104e-04,
 1.505716683085541732e-04,
 1.482056628571951800e-04,
 1.458370927938849957e-04,
 1.434660439026914848e-04,
 1.410926019605108941e-04,
 1.387168527339910221e-04,
 1.363388819765940885e-04,
 1.339587754255551131e-04,
 1.315766187988467735e-04,
 1.291924977922529263e-04,
 1.268064980763105340e-04,
 1.244187052933432870e-04,
 1.220292050544901724e-04,
 1.196380829366912421e-04,
 1.172454244797248004e-04,
 1.148513151832536303e-04,
 1.124558405038200601e-04,
 1.100590858519014727e-04,
 1.076611365889665350e-04,
 1.052620780244888977e-04,
 1.028619954130201482e-04,
 1.004609739512355218e-04,
 9.805909877501749346e-05,
 9.565645495648902028e-05,
 9.325312750110331314e-05,
 9.084920134473885224e-05,
 8.844476135074806687e-05,
 8.603989230706530740e-05,
 8.363467892331827324e-05,
 8.122920582789540855e-05,
 7.882355756506970363e-05,
 7.641781859213564226e-05,
 7.401207327646574185e-05,
 7.160640589271114343e-05,
 6.920090061989899919e-05,
 6.679564153853753065e-05,
 6.439071262783644604e-05,
 6.198619776279526113e-05,
 5.958218071138609477e-05,
 5.717874513173604428e-05,
 5.477597456926659253e-05,
 5.237395245389007124e-05,
 4.997276209721475713e-05,
 4.757248668970427582e-05,
 4.517320929789675200e-05,
 4.277501286163184715e-05,
 4.037798019123245056e-05,
 3.798219396475260151e-05,
 3.558773672519759492e-05,
 3.319469087778752279e-05,
 3.080313868717025801e-05,
 2.841316227469468589e-05,
 2.602484361569175887e-05,
 2.363826453671236276e-05,
 2.125350671282456676e-05,
 1.887065166491977403e-05,
 1.648978075697524339e-05,
 1.411097519337696205e-05,
 1.173431601625678239e-05,
 9.359884102752299179e-06,
 6.987760162412990763e-06,
 4.618024734506339166e-06,
 2.250758185332994009e-06,
-1.139592943460997295e-07,
-2.476047691976475657e-06,
-4.835427175867579754e-06,
-7.192018097732475792e-06,
-9.545740995355304581e-06,
-1.189651659516344231e-05,
-1.424426581479630246e-05,
-1.658890976571526115e-05,
-1.893036975575310856e-05,
-2.126856729165356046e-05,
-2.360342408165203541e-05,
-2.593486203799535086e-05,
-2.826280327945194246e-05,
-3.058717013386214143e-05,
-3.290788514062223077e-05,
-3.522487105319239124e-05,
-3.753805084155972750e-05,
-3.984734769474820968e-05,
-4.215268502326642916e-05,
-4.445398646154595577e-05,
-4.675117587041871937e-05,
-4.904417733953356099e-05,
-5.133291518976179960e-05,
-5.361731397564326680e-05,
-5.589729848776915953e-05,
-5.817279375515100150e-05,
-6.044372504765935949e-05,
-6.271001787831994635e-05,
-6.497159800570334490e-05,
-6.722839143630304954e-05,
-6.948032442679744406e-05,
-7.172732348643322351e-05,
-7.396931537931442969e-05,
-7.620622712668445272e-05,
-7.843798600924763316e-05,
-8.066451956942798042e-05,
-8.288575561361803841e-05,
-8.510162221446331313e-05,
-8.731204771308690642e-05,
-8.951696072130161362e-05,
-9.171629012385885710e-05,
-9.390996508063228295e-05,
-9.609791502882000596e-05,
-9.828006968510332396e-05,
-1.004563590478474043e-04,
-1.026267133992400486e-04,
-1.047910633074188301e-04,
-1.069493396286341579e-04,
-1.091014735093504337e-04,
-1.112473963883362719e-04,
-1.133870399987890883e-04,
-1.155203363703990961e-04,
-1.176472178313953305e-04,
-1.197676170106592606e-04,
-1.218814668396951776e-04,
-1.239887005546941225e-04,
-1.260892516985776348e-04,
-1.281830541229342997e-04,
-1.302700419900651365e-04,
-1.323501497749413015e-04,
-1.344233122671481984e-04,
-1.364894645728694596e-04,
-1.385485421168049811e-04,
-1.406004806440810972e-04,
-1.426452162221888086e-04,
-1.446826852428661472e-04,
-1.467128244239635187e-04,
-1.487355708113438483e-04,
-1.507508617807235289e-04,
-1.527586350394968622e-04,
-1.547588286285951674e-04,
-1.567513809242809190e-04,
-1.587362306399566565e-04,
-1.607133168279312315e-04,
-1.626825788812234319e-04,
-1.646439565353026413e-04,
-1.665973898698204188e-04,
-1.685428193103691828e-04,
-1.704801856301821046e-04,
-1.724094299518231360e-04,
-1.743304937489001025e-04,
-1.762433188477262975e-04,
-1.781478474289576277e-04,
-1.800440220292915305e-04,
-1.819317855430339719e-04,
-1.838110812237446685e-04,
-1.856818526858653427e-04,
-1.875440439062452764e-04,
-1.893975992257657440e-04,
-1.912424633508784139e-04,
-1.930785813551326642e-04,
-1.949058986807341502e-04,
-1.967243611400427115e-04,
-1.985339149170557227e-04,
-2.003345065689232120e-04,
-2.021260830273986320e-04,
-2.039085916002819328e-04,
-2.056819799728869756e-04,
-2.074461962094438668e-04,
-2.092011887545202925e-04,
-2.109469064343977242e-04,
-2.126832984584741044e-04,
-2.144103144206201302e-04,
-2.161279043005096229e-04,
-2.178360184649824789e-04,
-2.195346076693506726e-04,
-2.212236230586868304e-04,
-2.229030161691393681e-04,
-2.245727389291929572e-04,
-2.262327436609087709e-04,
-2.278829830812132752e-04,
-2.295234103030713085e-04,
-2.311539788367216657e-04,
-2.327746425908999424e-04,
-2.343853558739638829e-04,
-2.359860733951051385e-04,
-2.375767502654831261e-04,
-2.391573419993466899e-04,
-2.407278045151767687e-04,
-2.422880941367792180e-04,
-2.438381675943598502e-04,
-2.453779820256201294e-04,
-2.469074949768038335e-04,
-2.484266644037227360e-04,
-2.499354486728099086e-04,
-2.514338065621144771e-04,
-2.529216972622859135e-04,
-2.543990803775748638e-04,
-2.558659159267800357e-04,
-2.573221643442039769e-04,
-2.587677864805675455e-04,
-2.602027436039487749e-04,
-2.616269974006728413e-04,
-2.630405099761820814e-04,
-2.644432438559275321e-04,
-2.658351619862104340e-04,
-2.672162277350069296e-04,
-2.685864048928109766e-04,
-2.699456576734278750e-04,
-2.712939507147492553e-04,
-2.726312490795658504e-04,
-2.739575182562754797e-04,
-2.752727241596490920e-04,
-2.765768331315761547e-04,
-2.778698119417266133e-04,
-2.791516277882845711e-04,
-2.804222482986127966e-04,
-2.816816415299000466e-04,
-2.829297759698325121e-04,
-2.841666205372087245e-04,
-2.853921445825464910e-04,
-2.866063178886988304e-04,
-2.878091106714275702e-04,
-2.890004935799564520e-04,
-2.901804376975452714e-04,
-2.913489145420056865e-04,
-2.925058960662293875e-04,
-2.936513546586777762e-04,
-2.947852631438808079e-04,
-2.959075947829078058e-04,
-2.970183232738041234e-04,
-2.981174227520507923e-04,
-2.992048677909770068e-04,
-3.002806334021593270e-04,
-3.013446950358265202e-04,
-3.023970285812287314e-04,
-3.034376103669809044e-04,
-3.044664171614393255e-04,
-3.054834261729900751e-04,
-3.064886150503766198e-04,
-3.074819618830130379e-04,
-3.084634452012223818e-04,
-3.094330439765360799e-04,
-3.103907376219247637e-04,
-3.113365059920235106e-04,
-3.122703293833623992e-04,
-3.131921885345585223e-04,
-3.141020646264928193e-04,
-3.149999392824904339e-04,
-3.158857945684658344e-04,
-3.167596129930534059e-04,
-3.176213775077397767e-04,
-3.184710715069595001e-04,
-3.193086788281887826e-04,
-3.201341837520082058e-04,
-3.209475710021750423e-04,
-3.217488257456560530e-04,
-3.225379335926461350e-04,
-3.233148805965934758e-04,
-3.240796532541876263e-04,
-3.248322385053268669e-04,
-3.255726237331009140e-04,
-3.263007967637243504e-04,
-3.270167458664689168e-04,
-3.277204597535875630e-04,
-3.284119275802105278e-04,
-3.290911389442200048e-04,
-3.297580838861458963e-04,
-3.304127528889890344e-04,
-3.310551368780754642e-04,
-3.316852272208876875e-04,
-3.323030157268494489e-04,
-3.329084946471374097e-04,
-3.335016566744514058e-04,
-3.340824949427684959e-04,
-3.346510030271022691e-04,
-3.352071749432266982e-04,
-3.357510051473851947e-04,
-3.362824885360034028e-04,
-3.368016204453670292e-04,
-3.373083966512867705e-04,
-3.378028133687669267e-04,
-3.382848672516250085e-04,
-3.387545553921413239e-04,
-3.392118753206416139e-04,
-3.396568250051043548e-04,
-3.400894028507488154e-04,
-3.405096076995764941e-04,
-3.409174388299389012e-04,
-3.413128959560680995e-04,
-3.416959792275864284e-04,
-3.420666892290225155e-04,
-3.424250269792968233e-04,
-3.427709939311909316e-04,
-3.431045919708170921e-04,
-3.434258234170579666e-04,
-3.437346910209959031e-04,
-3.440311979653319120e-04,
-3.443153478637875657e-04,
-3.445871447604909607e-04,
-3.448465931293432187e-04,
-3.450936978733858541e-04,
-3.453284643241399531e-04,
-3.455508982409302818e-04,
-3.457610058102085818e-04,
-3.459587936448474291e-04,
-3.461442687834250941e-04,
-3.463174386895036261e-04,
-3.464783112508803740e-04,
-3.466268947788322973e-04,
-3.467631980073503030e-04,
-3.468872300923437116e-04,
-3.469990006108486275e-04,
-3.470985195602179310e-04,
-3.471857973572835157e-04,
-3.472608448375257896e-04,
-3.473236732542124929e-04,
-3.473742942775333428e-04,
-3.474127199937145647e-04,
-3.474389629041271907e-04,
-3.474530359243715050e-04,
-3.474549523833589957e-04,
-3.474447260223739774e-04,
-3.474223709941186809e-04,
-3.473879018617541674e-04,
-3.473413335979242756e-04,
-3.472826815837561499e-04,
-3.472119616078660274e-04,
-3.471291898653342325e-04,
-3.470343829566808775e-04,
-3.469275578868154328e-04,
-3.468087320639852682e-04,
-3.466779232987000155e-04,
-3.465351498026552810e-04,
-3.463804301876283317e-04,
-3.462137834643777925e-04,
-3.460352290415146664e-04,
-3.458447867243708072e-04,
-3.456424767138495564e-04,
-3.454283196052703093e-04,
-3.452023363871887943e-04,
-3.449645484402159433e-04,
-3.447149775358203361e-04,
-3.444536458351144903e-04,
-3.441805758876352963e-04,
-3.438957906301077019e-04,
-3.435993133851945728e-04,
-3.432911678602424874e-04,
-3.429713781460032459e-04,
-3.426399687153562461e-04,
-3.422969644220061943e-04,
-3.419423904991795147e-04,
-3.415762725583007552e-04,
-3.411986365876650364e-04,
-3.408095089510884907e-04,
-3.404089163865570752e-04,
-3.399968860048563032e-04,
-3.395734452881962588e-04,
-3.391386220888159032e-04,
-3.386924446275821777e-04,
-3.382349414925830337e-04,
-3.377661416376902693e-04,
-3.372860743811352665e-04,
-3.367947694040543177e-04,
-3.362922567490312948e-04,
-3.357785668186277425e-04,
-3.352537303739060864e-04,
-3.347177785329264951e-04,
-3.341707427692584332e-04,
-3.336126549104582247e-04,
-3.330435471365414120e-04,
-3.324634519784571752e-04,
-3.318724023165340199e-04,
-3.312704313789250309e-04,
-3.306575727400449410e-04,
-3.300338603189870330e-04,
-3.293993283779351631e-04,
-3.287540115205719350e-04,
-3.280979446904600406e-04,
-3.274311631694306474e-04,
-3.267537025759531923e-04,
-3.260655988634914601e-04,
-3.253668883188602580e-04,
-3.246576075605667492e-04,
-3.239377935371342220e-04,
-3.232074835254289489e-04,
-3.224667151289711624e-04,
-3.217155262762384955e-04,
-3.209539552189528337e-04,
-3.201820405303666792e-04,
-3.193998211035420343e-04,
-3.186073361496017460e-04,
-3.178046251959928308e-04,
-3.169917280847345123e-04,
-3.161686849706443585e-04,
-3.153355363195760189e-04,
-3.144923229066344658e-04,
-3.136390858143763265e-04,
-3.127758664310251245e-04,
-3.119027064486582217e-04,
-3.110196478613769027e-04,
-3.101267329635019367e-04,
-3.092240043477244705e-04,
-3.083115049032666803e-04,
-3.073892778140380308e-04,
-3.064573665567624791e-04,
-3.055158148991206401e-04,
-3.045646668978766098e-04,
-3.036039668969818593e-04,
-3.026337595256923000e-04,
-3.016540896966719604e-04,
-3.006650026040731888e-04,
-2.996665437216319817e-04,
-2.986587588007351760e-04,
-2.976416938685037426e-04,
-2.966153952258385120e-04,
-2.955799094454812409e-04,
-2.945352833700679821e-04,
-2.934815641101539926e-04,
-2.924187990422545810e-04,
-2.913470358068745696e-04,
-2.902663223065145011e-04,
-2.891767067036858977e-04,
-2.880782374189269548e-04,
-2.869709631287710710e-04,
-2.858549327637701309e-04,
-2.847301955064623848e-04,
-2.835968007893348536e-04,
-2.824547982928240055e-04,
-2.813042379432560431e-04,
-2.801451699108123438e-04,
-2.789776446074848171e-04,
-2.778017126850119631e-04,
-2.766174250328198099e-04,
-2.754248327759651824e-04,
-2.742239872730473115e-04,
-2.730149401141329971e-04,
-2.717977431186827998e-04,
-2.705724483334443278e-04,
-2.693391080303630340e-04,
-2.680977747044793508e-04,
-2.668485010718276698e-04,
-2.655913400673114134e-04,
-2.643263448425881902e-04,
-2.630535687639590160e-04,
-2.617730654102196422e-04,
-2.604848885705368200e-04,
-2.591890922423171388e-04,
-2.578857306290453983e-04,
-2.565748581381476455e-04,
-2.552565293788432621e-04,
-2.539307991599698382e-04,
-2.525977224878305969e-04,
-2.512573545640386214e-04,
-2.499097507833110995e-04,
-2.485549667313339335e-04,
-2.471930581825615143e-04,
-2.458240810980175258e-04,
-2.444480916231409062e-04,
-2.430651460855632337e-04,
-2.416753009929237066e-04,
-2.402786130306762088e-04,
-2.388751390598696229e-04,
-2.374649361149466017e-04,
-2.360480614015408754e-04,
-2.346245722942464794e-04,
-2.331945263344053847e-04,
-2.317579812278978133e-04,
-2.303149948428945509e-04,
-2.288656252076453105e-04,
-2.274099305082379031e-04,
-2.259479690863772225e-04,
-2.244797994371286953e-04,
-2.230054802066868845e-04,
-2.215250701901428189e-04,
-2.200386283292193120e-04,
-2.185462137100298611e-04,
-2.170478855608389847e-04,
-2.155437032497881621e-04,
-2.140337262826512909e-04,
-2.125180143005880309e-04,
-2.109966270778476530e-04,
-2.094696245195501927e-04,
-2.079370666594009790e-04,
-2.063990136574038892e-04,
-2.048555257976375152e-04,
-2.033066634859470047e-04,
-2.017524872476864550e-04,
-2.001930577254539868e-04,
-1.986284356767997143e-04,
-1.970586819719535008e-04,
-1.954838575915635035e-04,
-1.939040236243918364e-04,
-1.923192412650470977e-04,
-1.907295718117106348e-04,
-1.891350766638361385e-04,
-1.875358173198774262e-04,
-1.859318553749967642e-04,
-1.843232525187964448e-04,
-1.827100705330078915e-04,
-1.810923712892176262e-04,
-1.794702167465910946e-04,
-1.778436689495616627e-04,
-1.762127900255543611e-04,
-1.745776421827086272e-04,
-1.729382877075663790e-04,
-1.712947889627954620e-04,
-1.696472083849151014e-04,
-1.679956084819648674e-04,
-1.663400518312669902e-04,
-1.646806010771129439e-04,
-1.630173189284529571e-04,
-1.613502681566538833e-04,
-1.596795115931883588e-04,
-1.580051121273238265e-04,
-1.563271327038883742e-04,
-1.546456363209392393e-04,
-1.529606860274956338e-04,
-1.512723449212647925e-04,
-1.495806761463344930e-04,
-1.478857428909037118e-04,
-1.461876083850123325e-04,
-1.444863358982375408e-04,
-1.427819887374256471e-04,
-1.410746302444266999e-04,
-1.393643237937954352e-04,
-1.376511327905296307e-04,
-1.359351206677910317e-04,
-1.342163508846486110e-04,
-1.324948869237844789e-04,
-1.307707922892377666e-04,
-1.290441305041498381e-04,
-1.273149651084755666e-04,
-1.255833596567337775e-04,
-1.238493777157573391e-04,
-1.221130828624121371e-04,
-1.203745386813520168e-04,
-1.186338087627821419e-04,
-1.168909567001617328e-04,
-1.151460460880099395e-04,
-1.133991405196329877e-04,
-1.116503035848572754e-04,
-1.098995988678417635e-04,
-1.081470899447932921e-04,
-1.063928403817494535e-04,
-1.046369137323567919e-04,
-1.028793735356176953e-04,
-1.011202833136759125e-04,
-9.935970656960644817e-05,
-9.759770678517043681e-05,
-9.583434741861026924e-05,
-9.406969190244984097e-05,
-9.230380364125933396e-05,
-9.053674600946567030e-05,
-8.876858234914139034e-05,
-8.699937596782250605e-05,
-8.522919013628890879e-05,
-8.345808808638402519e-05,
-8.168613300884085629e-05,
-7.991338805107395910e-05,
-7.813991631501132694e-05,
-7.636578085493227338e-05,
-7.459104467527134016e-05,
-7.281577072846352663e-05,
-7.104002191279907381e-05,
-6.926386107021868506e-05,
-6.748735098421495789e-05,
-6.571055437765771837e-05,
-6.393353391062474940e-05,
-6.215635217831653114e-05,
-6.037907170887482622e-05,
-5.860175496126965783e-05,
-5.682446432318681627e-05,
-5.504726210888180279e-05,
-5.327021055707770381e-05,
-5.149337182886793741e-05,
-4.971680800558536233e-05,
-4.794058108671611038e-05,
-4.616475298781709156e-05,
-4.438938553840276205e-05,
-4.261454047987333585e-05,
-4.084027946344990140e-05,
-3.906666404807705955e-05,
-3.729375569837272444e-05,
-3.552161578255872028e-05,
-3.375030557042293532e-05,
-3.197988623124410466e-05,
-3.021041883176161461e-05,
-2.844196433415065007e-05,
-2.667458359396532411e-05,
-2.490833735812642244e-05,
-2.314328626291511102e-05,
-2.137949083193460548e-05,
-1.961701147411656389e-05,
-1.785590848173807080e-05,
-1.609624202838127720e-05,
-1.433807216700148944e-05,
-1.258145882792123937e-05,
-1.082646181683097320e-05,
-9.073140812876971144e-06,
-7.321555366654213098e-06,
-5.571764898269951198e-06,
-3.823828695409499071e-06,
-2.077805911371170882e-06,
-3.337555631462109005e-07,
 1.408263470494281391e-06,
 3.148192450947390809e-06,
 4.885972781656096202e-06,
 6.621546010042845337e-06,
 8.354853829393779218e-06,
 1.008583808073136904e-05,
 1.181444075474264899e-05,
 1.354060399359919871e-05,
 1.526427009284940045e-05,
 1.698538150330287396e-05,
 1.870388083282798202e-05,
 2.041971084824172869e-05,
 2.213281447712934361e-05,
 2.384313480966037145e-05,
 2.555061510043408568e-05,
 2.725519877027979271e-05,
 2.895682940804879444e-05,
 3.065545077243629521e-05,
 3.235100679375700638e-05,
 3.404344157571324300e-05,
 3.573269939719221584e-05,
 3.741872471401271841e-05,
 3.910146216068953722e-05,
 4.078085655216379780e-05,
 4.245685288556682609e-05,
 4.412939634193747729e-05,
 4.579843228793225468e-05,
 4.746390627756269618e-05,
 4.912576405388786139e-05,
 5.078395155069788749e-05,
 5.243841489422560565e-05,
 5.408910040481267517e-05,
 5.573595459856728118e-05,
 5.737892418904863920e-05,
 5.901795608890704747e-05,
 6.065299741151007498e-05,
 6.228399547262131305e-05,
 6.391089779197211608e-05,
 6.553365209490185034e-05,
 6.715220631398753799e-05,
 6.876650859059009197e-05,
 7.037650727648529488e-05,
 7.198215093542717784e-05,
 7.358338834470490775e-05,
 7.518016849672695570e-05,
 7.677244060055888871e-05,
 7.836015408345385657e-05,
 7.994325859240618585e-05,
 8.152170399566256796e-05,
 8.309544038422206640e-05,
 8.466441807336241594e-05,
 8.622858760411755978e-05,
 8.778789974476800743e-05,
 8.934230549229964225e-05,
 9.089175607388921396e-05,
 9.243620294834814359e-05,
 9.397559780755341283e-05,
 9.550989257790557202e-05,
 9.703903942174033070e-05,
 9.856299073873128487e-05,
 1.000816991673172420e-04,
 1.015951175860831828e-04,
 1.031031991151302324e-04,
 1.046058971174895134e-04,
 1.061031652004372435e-04,
 1.075949572168700583e-04,
 1.090812272666689389e-04,
 1.105619296979858064e-04,
 1.120370191086031663e-04,
 1.135064503472337823e-04,
 1.149701785148090195e-04,
 1.164281589657927631e-04,
 1.178803473094499336e-04,
 1.193266994111055447e-04,
 1.207671713934262570e-04,
 1.222017196376570054e-04,
 1.236303007848491020e-04,
 1.250528717371095081e-04,
 1.264693896588017915e-04,
 1.278798119777601076e-04,
 1.292840963864697328e-04,
 1.306822008432736190e-04,
 1.320740835735343332e-04,
 1.334597030707871063e-04,
 1.348390180979125062e-04,
 1.362119876882666102e-04,
 1.375785711468011216e-04,
 1.389387280512034077e-04,
 1.402924182529940924e-04,
 1.416396018786102824e-04,
 1.429802393305299119e-04,
 1.443142912883029817e-04,
 1.456417187096335655e-04,
 1.469624828314567485e-04,
 1.482765451709362552e-04,
 1.495838675265184032e-04,
 1.508844119789691691e-04,
 1.521781408923413243e-04,
 1.534650169150062425e-04,
 1.547450029806271077e-04,
 1.560180623091243410e-04,
 1.572841584076566145e-04,
 1.585432550715660312e-04,
 1.597953163853056062e-04,
 1.610403067233911144e-04,
 1.622781907513069148e-04,
 1.635089334264041845e-04,
 1.647324999988141424e-04,
 1.659488560123206151e-04,
 1.671579673052372376e-04,
 1.683598000112571157e-04,
 1.695543205603179378e-04,
 1.707414956794345881e-04,
 1.719212923935127860e-04,
 1.730936780261838406e-04,
 1.742586202005990184e-04,
 1.754160868402104671e-04,
 1.765660461695719801e-04,
 1.777084667150960679e-04,
 1.788433173058005669e-04,
 1.799705670740855241e-04,
 1.810901854564287946e-04,
 1.822021421941263345e-04,
 1.833064073340197006e-04,
 1.844029512291565736e-04,
 1.854917445395107766e-04,
 1.865727582326443977e-04,
 1.876459635843636504e-04,
 1.887113321793897785e-04,
 1.897688359119871612e-04,
 1.908184469865865397e-04,
 1.918601379184174324e-04,
 1.928938815341040393e-04,
 1.939196509722520396e-04,
 1.949374196840444418e-04,
 1.959471614338028484e-04,
 1.969488502995489368e-04,
 1.979424606735411668e-04,
 1.989279672628242268e-04,
 1.999053450897450329e-04,
 2.008745694924540641e-04,
 2.018356161254214963e-04,
 2.027884609599164205e-04,
 2.037330802844741057e-04,
 2.046694507053757866e-04,
 2.055975491470918575e-04,
 2.065173528527125719e-04,
 2.074288393844034349e-04,
 2.083319866237904195e-04,
 2.092267727723780084e-04,
 2.101131763519565286e-04,
 2.109911762049535412e-04,
 2.118607514948268108e-04,
 2.127218817064139872e-04,
 2.135745466462707419e-04,
 2.144187264430180099e-04,
 2.152544015476567344e-04,
 2.160815527338730692e-04,
 2.169001610983474037e-04,
 2.177102080610353069e-04,
 2.185116753654365446e-04,
 2.193045450788706297e-04,
 2.200887995927198733e-04,
 2.208644216226643311e-04,
 2.216313942089217647e-04,
 2.223897007164534227e-04,
 2.231393248351739157e-04,
 2.238802505801342564e-04,
 2.246124622917153085e-04,
 2.253359446357891429e-04,
 2.260506826038725340e-04,
 2.267566615132812411e-04,
 2.274538670072590561e-04,
 2.281422850550943009e-04,
 2.288219019522401193e-04,
 2.294927043204088844e-04,
 2.301546791076483091e-04,
 2.308078135884433074e-04,
 2.314520953637461077e-04,
 2.320875123610491655e-04,
 2.327140528344266886e-04,
 2.333317053645474573e-04,
 2.339404588587064564e-04,
 2.345403025508244416e-04,
 2.351312260014386420e-04,
 2.357132190976906174e-04,
 2.362862720532959548e-04,
 2.368503754084961025e-04,
 2.374055200300155717e-04,
 2.379516971109948780e-04,
 2.384888981709089013e-04,
 2.390171150554883084e-04,
 2.395363399366166619e-04,
 2.400465653122224065e-04,
 2.405477840061526955e-04,
 2.410399891680482462e-04,
 2.415231742731948857e-04,
 2.419973331223648511e-04,
 2.424624598416571944e-04,
 2.429185488823155286e-04,
 2.433655950205341990e-04,
 2.438035933572666781e-04,
 2.442325393180082098e-04,
 2.446524286525663923e-04,
 2.450632574348449340e-04,
 2.454650220625743647e-04,
 2.458577192570688763e-04,
 2.462413460629618318e-04,
 2.466158998479121628e-04,
 2.469813783023258927e-04,
 2.473377794390515844e-04,
 2.476851015930616384e-04,
 2.480233434211388506e-04,
 2.483525039015336416e-04,
 2.486725823336194971e-04,
 2.489835783375405481e-04,
 2.492854918538394728e-04,
 2.495783231430794892e-04,
 2.498620727854570242e-04,
 2.501367416804008842e-04,
 2.504023310461557040e-04,
 2.506588424193689204e-04,
 2.509062776546506948e-04,
 2.511446389241341060e-04,
 2.513739287170174003e-04,
 2.515941498391026094e-04,
 2.518053054123185557e-04,
 2.520073988742323645e-04,
 2.522004339775543095e-04,
 2.523844147896320321e-04,
 2.525593456919275766e-04,
 2.527252313794938290e-04,
 2.528820768604318195e-04,
 2.530298874553403273e-04,
 2.531686687967628835e-04,
 2.532984268286067467e-04,
 2.534191678055681680e-04,
 2.535308982925446987e-04,
 2.536336251640243511e-04,
 2.537273556034816977e-04,
 2.538120971027521783e-04,
 2.538878574613999558e-04,
 2.539546447860787791e-04,
 2.540124674898752819e-04,
 2.540613342916483780e-04,
 2.541012542153570563e-04,
 2.541322365893778756e-04,
 2.541542910458098820e-04,
 2.541674275197747029e-04,
 2.541716562487030331e-04,
 2.541669877716125564e-04,
 2.541534329283751331e-04,
 2.541310028589737965e-04,
 2.540997090027559001e-04,
 2.540595630976642556e-04,
 2.540105771794701141e-04,
 2.539527635809943297e-04,
 2.538861349313109583e-04,
 2.538107041549536765e-04,
 2.537264844711015991e-04,
 2.536334893927610326e-04,
 2.535317327259405053e-04,
 2.534212285688066074e-04,
 2.533019913108423794e-04,
 2.531740356319878106e-04,
 2.530373765017760552e-04,
 2.528920291784547952e-04,
 2.527380092081051629e-04,
 2.525753324237468953e-04,
 2.524040149444354642e-04,
 2.522240731743521599e-04,
 2.520355238018808387e-04,
 2.518383837986798456e-04,
 2.516326704187434754e-04,
 2.514184011974527526e-04,
 2.511955939506217684e-04,
 2.509642667735295413e-04,
 2.507244380399485184e-04,
 2.504761264011613666e-04,
 2.502193507849666504e-04,
 2.499541303946834262e-04,
 2.496804847081407117e-04,
 2.493984334766581189e-04,
 2.491079967240238851e-04,
 2.488091947454601103e-04,
 2.485020481065775325e-04,
 2.481865776423268868e-04,
 2.478628044559419712e-04,
 2.475307499178667201e-04,
 2.471904356646838501e-04,
 2.468418835980331510e-04,
 2.464851158835113464e-04,
 2.461201549495815486e-04,
 2.457470234864609759e-04,
 2.453657444450025975e-04,
 2.449763410355772675e-04,
 2.445788367269378059e-04,
 2.441732552450798276e-04,
 2.437596205720983695e-04,
 2.433379569450259245e-04,
 2.429082888546761393e-04,
 2.424706410444718466e-04,
 2.420250385092651273e-04,
 2.415715064941538232e-04,
 2.411100704932906487e-04,
 2.406407562486783172e-04,
 2.401635897489653722e-04,
 2.396785972282298202e-04,
 2.391858051647607051e-04,
 2.386852402798212498e-04,
 2.381769295364192900e-04,
 2.376609001380633143e-04,
 2.371371795275066334e-04,
 2.366057953854931479e-04,
 2.360667756294951736e-04,
 2.355201484124377703e-04,
 2.349659421214198702e-04,
 2.344041853764384435e-04,
 2.338349070290809506e-04,
 2.332581361612411585e-04,
 2.326739020838106988e-04,
 2.320822343353571540e-04,
 2.314831626808217142e-04,
 2.308767171101835751e-04,
 2.302629278371346095e-04,
 2.296418252977360951e-04,
 2.290134401490810797e-04,
 2.283778032679431949e-04,
 2.277349457494174181e-04,
 2.270848989055589660e-04,
 2.264276942640204788e-04,
 2.257633635666698524e-04,
 2.250919387682129768e-04,
 2.244134520348128956e-04,
 2.237279357426851683e-04,
 2.230354224767161085e-04,
 2.223359450290488220e-04,
 2.216295363976716296e-04,
 2.209162297850169254e-04,
 2.201960585965246362e-04,
 2.194690564392264161e-04,
 2.187352571203150147e-04,
 2.179946946456994418e-04,
 2.172474032185700533e-04,
 2.164934172379514936e-04,
 2.157327712972447148e-04,
 2.149655001827733051e-04,
 2.141916388723227166e-04,
 2.134112225336661840e-04,
 2.126242865230963620e-04,
 2.118308663839513261e-04,
 2.110309978451221946e-04,
 2.102247168195730035e-04,
 2.094120594028465402e-04,
 2.085930618715713157e-04,
 2.077677606819526806e-04,
 2.069361924682697684e-04,
 2.060983940413735230e-04,
 2.052544023871569168e-04,
 2.044042546650445759e-04,
 2.035479882064720233e-04,
 2.026856405133484163e-04,
 2.018172492565295561e-04,
 2.009428522742874818e-04,
 2.000624875707536921e-04,
 1.991761933143927242e-04,
 1.982840078364487895e-04,
 1.973859696293771239e-04,
 1.964821173453162374e-04,
 1.955724897945040311e-04,
 1.946571259437248128e-04,
 1.937360649147434649e-04,
 1.928093459827275513e-04,
 1.918770085746745460e-04,
 1.909390922678429387e-04,
 1.899956367881556118e-04,
 1.890466820086241417e-04,
 1.880922679477648883e-04,
 1.871324347679953243e-04,
 1.861672227740477931e-04,
 1.851966724113680070e-04,
 1.842208242645230587e-04,
 1.832397190555826801e-04,
 1.822533976425216710e-04,
 1.812619010176148729e-04,
 1.802652703058122482e-04,
 1.792635467631297072e-04,
 1.782567717750380653e-04,
 1.772449868548298005e-04,
 1.762282336420009090e-04,
 1.752065539006359047e-04,
 1.741799895177535706e-04,
 1.731485825017057276e-04,
 1.721123749805319851e-04,
 1.710714092003098289e-04,
 1.700257275235466953e-04,
 1.689753724275153688e-04,
 1.679203865026223112e-04,
 1.668608124507696226e-04,
 1.657966930836964287e-04,
 1.647280713213367478e-04,
 1.636549901901793646e-04,
 1.625774928216002185e-04,
 1.614956224502179399e-04,
 1.604094224122458630e-04,
 1.593189361438209720e-04,
 1.582242071793559955e-04,
 1.571252791498758603e-04,
 1.560221957813655031e-04,
 1.549150008930939924e-04,
 1.538037383959586801e-04,
 1.526884522908265624e-04,
 1.515691866668553926e-04,
 1.504459856998329543e-04,
 1.493188936505160911e-04,
 1.481879548629491086e-04,
 1.470532137627978710e-04,
 1.459147148556897788e-04,
 1.447725027255245282e-04,
 1.436266220328107275e-04,
 1.424771175130018367e-04,
 1.413240339747959219e-04,
 1.401674162984926550e-04,
 1.390073094343048860e-04,
 1.378437584006663385e-04,
 1.366768082825908868e-04,
 1.355065042299668078e-04,
 1.343328914558912025e-04,
 1.331560152350018693e-04,
 1.319759209017845668e-04,
 1.307926538489037214e-04,
 1.296062595255340034e-04,
 1.284167834356670734e-04,
 1.272242711364437822e-04,
 1.260287682364849863e-04,
 1.248303203941986757e-04,
 1.236289733161153974e-04,
 1.224247727552074444e-04,
 1.212177645092228976e-04,
 1.200079944189948124e-04,
 1.187955083667757759e-04,
 1.175803522745720575e-04,
 1.163625721024517923e-04,
 1.151422138468843767e-04,
 1.139193235390733856e-04,
 1.126939472432705159e-04,
 1.114661310551135181e-04,
 1.102359210999678146e-04,
 1.090033635312273645e-04,
 1.077685045286839836e-04,
 1.065313902968447433e-04,
 1.052920670632483271e-04,
 1.040505810768396620e-04,
 1.028069786062748772e-04,
 1.015613059382719616e-04,
 1.003136093759594014e-04,
 9.906393523720000410e-05,
 9.781232985294319551e-05,
 9.655883956557731712e-05,
 9.530351072725912805e-05,
 9.404638969827012747e-05,
 9.278752284537424575e-05,
 9.152695654015217117e-05,
 9.026473715736677960e-05,
 8.900091107331022761e-05,
 8.773552466417485743e-05,
 8.646862430439302587e-05,
 8.520025636500784668e-05,
 8.393046721204431226e-05,
 8.265930320485759296e-05,
 8.138681069450903781e-05,
 8.011303602214466879e-05,
 7.883802551734986341e-05,
 7.756182549653232138e-05,
 7.628448226130869043e-05,
 7.500604209686519846e-05,
 7.372655127034890080e-05,
 7.244605602926513447e-05,
 7.116460259983033057e-05,
 6.988223718540192682e-05,
 6.859900596485298593e-05,
 6.731495509094953793e-05,
 6.603013068878831266e-05,
 6.474457885416511028e-05,
 6.345834565199078199e-05,
 6.217147711470825413e-05,
 6.088401924068444633e-05,
 5.959601799263318424e-05,
 5.830751929604122261e-05,
 5.701856903757009733e-05,
 5.572921306348851825e-05,
 5.443949717810833298e-05,
 5.314946714219649594e-05,
 5.185916867142081036e-05,
 5.056864743478076249e-05,
 4.927794905306088005e-05,
 4.798711909725599640e-05,
 4.669620308702950143e-05,
 4.540524648917313078e-05,
 4.411429471604436624e-05,
 4.282339312403530505e-05,
 4.153258701204434825e-05,
 4.024192161992546632e-05,
 3.895144212696797825e-05,
 3.766119365038407606e-05,
 3.637122124375397715e-05,
 3.508156989554928843e-05,
 3.379228452760169271e-05,
 3.250340999357636493e-05,
 3.121499107750768938e-05,
 2.992707249226543207e-05,
 2.863969887807180632e-05,
 2.735291480101950727e-05,
 2.606676475156658178e-05,
 2.478129314306364820e-05,
 2.349654431028547663e-05,
 2.221256250793961470e-05,
 2.092939190920728174e-05,
 1.964707660428885745e-05,
 1.836566059892662587e-05,
 1.708518781296296948e-05,
 1.580570207888476006e-05,
 1.452724714039143925e-05,
 1.324986665093697166e-05,
 1.197360417230447818e-05,
 1.069850317318606996e-05,
 9.424607027739795737e-06,
 8.151959014179596208e-06,
 6.880602313370171242e-06,
 5.610580007399637890e-06,
 4.341935078184899107e-06,
 3.074710406085300690e-06,
 1.808948768475808304e-06,
 5.446928383989096508e-07,
-7.180148168362075570e-07,
-1.979131737048930197e-06,
-3.238615570522119734e-06,
-4.496424075386408844e-06,
-5.752515120998873115e-06,
-7.006846689258187335e-06,
-8.259376875987296666e-06,
-9.510063892264602613e-06,
-1.075886606575263161e-05,
-1.200574184204806324e-05,
-1.325064978599878937e-05,
-1.449354858301492638e-05,
-1.573439704040153166e-05,
-1.697315408865764387e-05,
-1.820977878276983439e-05,
-1.944423030352651952e-05,
-2.067646795879647204e-05,
-2.190645118481880153e-05,
-2.313413954746912636e-05,
-2.435949274354964214e-05,
-2.558247060204550530e-05,
-2.680303308537577888e-05,
-2.802114029066407334e-05,
-2.923675245097673259e-05,
-3.044982993655440635e-05,
-3.166033325606376153e-05,
-3.286822305781628134e-05,
-3.407346013097800114e-05,
-3.527600540681618846e-05,
-3.647581995986938350e-05,
-3.767286500916668611e-05,
-3.886710191944030718e-05,
-4.005849220227566319e-05,
-4.124699751732548614e-05,
-4.243257967347268458e-05,
-4.361520062999010112e-05,
-4.479482249771946035e-05,
-4.597140754021680130e-05,
-4.714491817489179773e-05,
-4.831531697416636370e-05,
-4.948256666659907966e-05,
-5.064663013800463793e-05,
-5.180747043259000526e-05,
-5.296505075405724623e-05,
-5.411933446671401727e-05,
-5.527028509656192946e-05,
-5.641786633240519273e-05,
-5.756204202692676101e-05,
-5.870277619775746402e-05,
-5.984003302856355690e-05,
-6.097377687010093063e-05,
-6.210397224126283763e-05,
-6.323058383014574374e-05,
-6.435357649508150228e-05,
-6.547291526566067826e-05,
-6.658856534378977427e-05,
-6.770049210467434431e-05,
-6.880866109784741379e-05,
-6.991303804819054047e-05,
-7.101358885689487840e-05,
-7.211027960248054473e-05,
-7.320307654176841730e-05,
-7.429194611084508808e-05,
-7.537685492604744074e-05,
-7.645776978491243883e-05,
-7.753465766712103224e-05,
-7.860748573545866538e-05,
-7.967622133674323235e-05,
-8.074083200274496822e-05,
-8.180128545112448721e-05,
-8.285754958633706154e-05,
-8.390959250053051696e-05,
-8.495738247445779219e-05,
-8.600088797835758216e-05,
-8.704007767283999562e-05,
-8.807492040975105731e-05,
-8.910538523305462514e-05,
-9.013144137968244528e-05,
-9.115305828037637405e-05,
-9.217020556054804175e-05,
-9.318285304110298186e-05,
-9.419097073926184646e-05,
-9.519452886939276171e-05,
-9.619349784381526385e-05,
-9.718784827359122462e-05,
-9.817755096934835705e-05,
-9.916257694203322096e-05,
-1.001428974037043575e-04,
-1.011184837683172381e-04,
-1.020893076524557482e-04,
-1.030553408761100215e-04,
-1.040165554634148897e-04,
-1.049729236433791441e-04,
-1.059244178506295558e-04,
-1.068710107261247144e-04,
-1.078126751178599897e-04,
-1.087493840815880928e-04,
-1.096811108815070424e-04,
-1.106078289909413835e-04,
-1.115295120930364010e-04,
-1.124461340814203241e-04,
-1.133576690608719642e-04,
-1.142640913479660861e-04,
-1.151653754717347307e-04,
-1.160614961742975702e-04,
-1.169524284114851755e-04,
-1.178381473534741549e-04,
-1.187186283853938334e-04,
-1.195938471079232413e-04,
-1.204637793379019538e-04,
-1.213284011089104509e-04,
-1.221876886718401499e-04,
-1.230416184954905576e-04,
-1.238901672671010028e-04,
-1.247333118929212661e-04,
-1.255710294987587088e-04,
-1.264032974305102908e-04,
-1.272300932546930165e-04,
-1.280513947589578198e-04,
-1.288671799526124745e-04,
-1.296774270671184842e-04,
-1.304821145565805186e-04,
-1.312812210982427878e-04,
-1.320747255929631645e-04,
-1.328626071656733459e-04,
-1.336448451658530572e-04,
-1.344214191679748451e-04,
-1.351923089719428005e-04,
-1.359574946035365934e-04,
-1.367169563148357212e-04,
-1.374706745846251629e-04,
-1.382186301188279216e-04,
-1.389608038508802126e-04,
-1.396971769421342718e-04,
-1.404277307822541707e-04,
-1.411524469895631404e-04,
-1.418713074114345352e-04,
-1.425842941246375302e-04,
-1.432913894356834699e-04,
-1.439925758811756858e-04,
-1.446878362281358687e-04,
-1.453771534743216040e-04,
-1.460605108485528523e-04,
-1.467378918110107556e-04,
-1.474092800535296670e-04,
-1.480746594998980710e-04,
-1.487340143061296072e-04,
-1.493873288607390807e-04,
-1.500345877849973582e-04,
-1.506757759331978921e-04,
-1.513108783928950008e-04,
-1.519398804851365659e-04,
-1.525627677647030172e-04,
-1.531795260203213001e-04,
-1.537901412748724731e-04,
-1.543945997856018535e-04,
-1.549928880443109482e-04,
-1.555849927775345039e-04,
-1.561709009467364222e-04,
-1.567505997484549890e-04,
-1.573240766144746387e-04,
-1.578913192119859557e-04,
-1.584523154437074573e-04,
-1.590070534480365959e-04,
-1.595555215991698072e-04,
-1.600977085072144001e-04,
-1.606336030183057588e-04,
-1.611631942147045418e-04,
-1.616864714148802190e-04,
-1.622034241736069430e-04,
-1.627140422820305254e-04,
-1.632183157677305886e-04,
-1.637162348947869734e-04,
-1.642077901638237846e-04,
-1.646929723120502381e-04,
-1.651717723132891758e-04,
-1.656441813780085614e-04,
-1.661101909533315639e-04,
-1.665697927230395654e-04,
-1.670229786075785048e-04,
-1.674697407640450260e-04,
-1.679100715861622740e-04,
-1.683439637042634417e-04,
-1.687714099852501094e-04,
-1.691924035325449466e-04,
-1.696069376860520302e-04,
-1.700150060220808419e-04,
-1.704166023532863389e-04,
-1.708117207285957974e-04,
-1.712003554331125354e-04,
-1.715825009880269812e-04,
-1.719581521505229708e-04,
-1.723273039136506257e-04,
-1.726899515062232178e-04,
-1.730460903926834605e-04,
-1.733957162729666006e-04,
-1.737388250823631317e-04,
-1.740754129913643492e-04,
-1.744054764054994494e-04,
-1.747290119651748229e-04,
-1.750460165454943489e-04,
-1.753564872560722343e-04,
-1.756604214408476693e-04,
-1.759578166778806184e-04,
-1.762486707791445473e-04,
-1.765329817903072524e-04,
-1.768107479905120137e-04,
-1.770819678921413745e-04,
-1.773466402405756901e-04,
-1.776047640139495881e-04,
-1.778563384228910014e-04,
-1.781013629102586016e-04,
-1.783398371508690676e-04,
-1.785717610512195031e-04,
-1.787971347491934548e-04,
-1.790159586137734095e-04,
-1.792282332447294108e-04,
-1.794339594723093573e-04,
-1.796331383569258031e-04,
-1.798257711888182563e-04,
-1.800118594877267528e-04,
-1.801914050025463752e-04,
-1.803644097109737487e-04,
-1.805308758191553800e-04,
-1.806908057613164538e-04,
-1.808442021993881654e-04,
-1.809910680226299573e-04,
-1.811314063472383123e-04,
-1.812652205159478482e-04,
-1.813925140976337677e-04,
-1.815132908868963117e-04,
-1.816275549036418225e-04,
-1.817353103926566259e-04,
-1.818365618231754916e-04,
-1.819313138884383297e-04,
-1.820195715052398135e-04,
-1.821013398134776193e-04,
-1.821766241756863822e-04,
-1.822454301765652008e-04,
-1.823077636225030275e-04,
-1.823636305410920519e-04,
-1.824130371806331958e-04,
-1.824559900096393860e-04,
-1.824924957163258170e-04,
-1.825225612080964995e-04,
-1.825461936110244399e-04,
-1.825634002693198661e-04,
-1.825741887447973697e-04,
-1.825785668163316629e-04,
-1.825765424793094065e-04,
-1.825681239450706284e-04,
-1.825533196403450475e-04,
-1.825321382066837615e-04,
-1.825045884998782774e-04,
-1.824706795893784304e-04,
-1.824304207576995151e-04,
-1.823838214998261913e-04,
-1.823308915226047339e-04,
-1.822716407441320587e-04,
-1.822060792931381058e-04,
-1.821342175083605266e-04,
-1.820560659379111300e-04,
-1.819716353386392391e-04,
-1.818809366754839884e-04,
-1.817839811208264050e-04,
-1.816807800538262831e-04,
-1.815713450597606585e-04,
-1.814556879293510608e-04,
-1.813338206580860767e-04,
-1.812057554455368392e-04,
-1.810715046946656049e-04,
-1.809310810111300751e-04,
-1.807844972025789360e-04,
-1.806317662779418417e-04,
-1.804729014467158733e-04,
-1.803079161182383379e-04,
-1.801368239009649064e-04,
-1.799596386017289409e-04,
-1.797763742250039392e-04,
-1.795870449721572782e-04,
-1.793916652406948506e-04,
-1.791902496235038035e-04,
-1.789828129080874171e-04,
-1.787693700757942371e-04,
-1.785499363010407557e-04,
-1.783245269505291056e-04,
-1.780931575824585471e-04,
-1.778558439457310185e-04,
-1.776126019791501821e-04,
-1.773634478106175967e-04,
-1.771083977563196743e-04,
-1.768474683199085652e-04,
-1.765806761916838296e-04,
-1.763080382477592010e-04,
-1.760295715492312199e-04,
-1.757452933413390856e-04,
-1.754552210526194665e-04,
-1.751593722940540730e-04,
-1.748577648582191283e-04,
-1.745504167184149164e-04,
-1.742373460278082598e-04,
-1.739185711185566193e-04,
-1.735941105009274781e-04,
-1.732639828624223609e-04,
-1.729282070668846435e-04,
-1.725868021536064684e-04,
-1.722397873364351186e-04,
-1.718871820028644831e-04,
-1.715290057131288806e-04,
-1.711652781992939834e-04,
-1.707960193643319924e-04,
-1.704212492812016110e-04,
-1.700409881919235722e-04,
-1.696552565066424792e-04,
-1.692640748026914637e-04,
-1.688674638236499059e-04,
-1.684654444783993655e-04,
-1.680580378401653910e-04,
-1.676452651455659696e-04,
-1.672271477936518726e-04,
-1.668037073449352104e-04,
-1.663749655204242760e-04,
-1.659409442006490364e-04,
-1.655016654246796318e-04,
-1.650571513891427062e-04,
-1.646074244472387404e-04,
-1.641525071077430957e-04,
-1.636924220340138872e-04,
-1.632271920429934878e-04,
-1.627568401041943659e-04,
-1.622813893387030555e-04,
-1.618008630181590006e-04,
-1.613152845637352427e-04,
-1.608246775451269140e-04,
-1.603290656795160413e-04,
-1.598284728305475173e-04,
-1.593229230072979970e-04,
-1.588124403632332475e-04,
-1.582970491951708378e-04,
-1.577767739422375698e-04,
-1.572516391848175312e-04,
-1.567216696435003653e-04,
-1.561868901780303536e-04,
-1.556473257862415398e-04,
-1.551030016029978948e-04,
-1.545539428991258386e-04,
-1.540001750803473310e-04,
-1.534417236862029065e-04,
-1.528786143889750886e-04,
-1.523108729926141082e-04,
-1.517385254316474131e-04,
-1.511615977700947607e-04,
-1.505801162003850193e-04,
-1.499941070422536695e-04,
-1.494035967416507691e-04,
-1.488086118696474263e-04,
-1.482091791213196140e-04,
-1.476053253146584381e-04,
-1.469970773894543577e-04,
-1.463844624061801049e-04,
-1.457675075448910593e-04,
-1.451462401040951847e-04,
-1.445206874996382248e-04,
-1.438908772635859724e-04,
-1.432568370430905463e-04,
-1.426185945992657750e-04,
-1.419761778060623378e-04,
-1.413296146491254215e-04,
-1.406789332246638708e-04,
-1.400241617383160314e-04,
-1.393653285040007941e-04,
-1.387024619427811880e-04,
-1.380355905817142045e-04,
-1.373647430527111116e-04,
-1.366899480913779264e-04,
-1.360112345358680040e-04,
-1.353286313257320785e-04,
-1.346421675007523119e-04,
-1.339518721997900585e-04,
-1.332577746596274757e-04,
-1.325599042137975351e-04,
-1.318582902914237356e-04,
-1.311529624160579746e-04,
-1.304439502045035384e-04,
-1.297312833656484999e-04,
-1.290149916993015033e-04,
-1.282951050949993576e-04,
-1.275716535308531478e-04,
-1.268446670723617927e-04,
-1.261141758712232708e-04,
-1.253802101641751209e-04,
-1.246428002717956936e-04,
-1.239019765973267077e-04,
-1.231577696254946143e-04,
-1.224102099213130140e-04,
-1.216593281289018254e-04,
-1.209051549703030242e-04,
-1.201477212442807164e-04,
-1.193870578251345196e-04,
-1.186231956615130527e-04,
-1.178561657752098888e-04,
-1.170859992599766926e-04,
-1.163127272803225206e-04,
-1.155363810703263490e-04,
-1.147569919324271714e-04,
-1.139745912362324069e-04,
-1.131892104173229732e-04,
-1.124008809760428161e-04,
-1.116096344763034813e-04,
-1.108155025443885786e-04,
-1.100185168677391767e-04,
-1.092187091937578478e-04,
-1.084161113286116805e-04,
-1.076107551360083378e-04,
-1.068026725360152662e-04,
-1.059918955038434781e-04,
-1.051784560686322293e-04,
-1.043623863122651645e-04,
-1.035437183681457658e-04,
-1.027224844199966933e-04,
-1.018987167006602239e-04,
-1.010724474908790389e-04,
-1.002437091180949412e-04,
-9.941253395524840032e-05,
-9.857895441955837686e-05,
-9.774300297132163689e-05,
-9.690471211271142868e-05,
-9.606411438655779590e-05,
-9.522124237514915479e-05,
-9.437612869902159266e-05,
-9.352880601575852060e-05,
-9.267930701877419861e-05,
-9.182766443611142316e-05,
-9.097391102924314498e-05,
-9.011807959185397492e-05,
-8.926020294864151709e-05,
-8.840031395411717351e-05,
-8.753844549139025205e-05,
-8.667463047096955709e-05,
-8.580890182956689113e-05,
-8.494129252888212489e-05,
-8.407183555440741725e-05,
-8.320056391423181455e-05,
-8.232751063782899059e-05,
-8.145270877486337742e-05,
-8.057619139399704151e-05,
-7.969799158168016132e-05,
-7.881814244096163049e-05,
-7.793667709028861555e-05,
-7.705362866232014067e-05,
-7.616903030272012662e-05,
-7.528291516897048761e-05,
-7.439531642918523094e-05,
-7.350626726090823937e-05,
-7.261580084992840087e-05,
-7.172395038909805853e-05,
-7.083074907713423545e-05,
-6.993623011743750476e-05,
-6.904042671691702630e-05,
-6.814337208478443936e-05,
-6.724509943139868600e-05,
-6.634564196707426953e-05,
-6.544503290088958081e-05,
-6.454330543953721027e-05,
-6.364049278612536240e-05,
-6.273662813901244686e-05,
-6.183174469064137136e-05,
-6.092587562635654838e-05,
-6.001905412324112224e-05,
-5.911131334895745545e-05,
-5.820268646056820803e-05,
-5.729320660338046951e-05,
-5.638290690979031112e-05,
-5.547182049811131215e-05,
-5.455998047142553603e-05,
-5.364741991642378637e-05,
-5.273417190226172620e-05,
-5.182026947939526195e-05,
-5.090574567843844482e-05,
-4.999063350902295110e-05,
-4.907496595864112326e-05,
-4.815877599150988192e-05,
-4.724209654743732802e-05,
-4.632496054067239074e-05,
-4.540740085877575293e-05,
-4.448945036149627881e-05,
-4.357114187961620320e-05,
-4.265250821385204182e-05,
-4.173358213371594866e-05,
-4.081439637638023104e-05,
-3.989498364558491427e-05,
-3.897537661049697800e-05,
-3.805560790460379240e-05,
-3.713571012460757073e-05,
-3.621571582930308459e-05,
-3.529565753847758492e-05,
-3.437556773181348106e-05,
-3.345547884777428906e-05,
-3.253542328251334833e-05,
-3.161543338878512684e-05,
-3.069554147484003959e-05,
-2.977577980334398359e-05,
-2.885618059028785404e-05,
-2.793677600391348290e-05,
-2.701759816362029885e-05,
-2.609867913889508769e-05,
-2.518005094824508650e-05,
-2.426174555811442190e-05,
-2.334379488182336724e-05,
-2.242623077851109645e-05,
-2.150908505206193760e-05,
-2.059238945005458792e-05,
-1.967617566271486932e-05,
-1.876047532185217014e-05,
-1.784531999981886515e-05,
-1.693074120847545477e-05,
-1.601677039812668827e-05,
-1.510343895651326084e-05,
-1.419077820776580416e-05,
-1.327881941136239376e-05,
-1.236759376113135585e-05,
-1.145713238420517479e-05,
-1.054746634001075531e-05,
-9.638626619261631142e-06,
-8.730644142933770109e-06,
-7.823549761265219694e-06,
-6.917374252759404239e-06,
-6.012148323172715587e-06,
-5.107902604525509790e-06,
-4.204667654117172963e-06,
-3.302473953525395900e-06,
-2.401351907631273461e-06,
-1.501331843635360604e-06,
-6.024440100907752780e-07,
 2.952814240813488971e-07,
 1.191814370550560616e-06,
 2.087124822544718775e-06,
 2.981182855800449203e-06,
 3.873958629533237150e-06,
 4.765422387370817619e-06,
 5.655544458312672488e-06,
 6.544295257674329934e-06,
 7.431645288005860712e-06,
 8.317565140049265089e-06,
 9.202025493650286029e-06,
 1.008499711868988624e-05,
 1.096645087600670940e-05,
 1.184635771831740180e-05,
 1.272468869110877350e-05,
 1.360141493356852997e-05,
 1.447650767946839209e-05,
 1.534993825807918981e-05,
 1.622167809504512388e-05,
 1.709169871329599150e-05,
 1.795997173391202393e-05,
 1.882646887700788730e-05,
 1.969116196260968364e-05,
 2.055402291153119961e-05,
 2.141502374622265733e-05,
 2.227413659165448814e-05,
 2.313133367615436721e-05,
 2.398658733226025704e-05,
 2.483986999757942419e-05,
 2.569115421561321566e-05,
 2.654041263660582986e-05,
 2.738761801837843408e-05,
 2.823274322713895842e-05,
 2.907576123831658591e-05,
 2.991664513738264263e-05,
 3.075536812064811308e-05,
 3.159190349608258556e-05,
 3.242622468411841504e-05,
 3.325830521842883816e-05,
 3.408811874674232763e-05,
 3.491563903161259936e-05,
 3.574083995120635993e-05,
 3.656369550008192634e-05,
 3.738417978996398335e-05,
 3.820226705049147969e-05,
 3.901793163000071338e-05,
 3.983114799626283998e-05,
 4.064189073725000368e-05,
 4.145013456186270824e-05,
 4.225585430069115050e-05,
 4.305902490673210845e-05,
 4.385962145612164501e-05,
 4.465761914886132026e-05,
 4.545299330954223513e-05,
 4.624571938804247838e-05,
 4.703577296025655071e-05,
 4.782312972877953019e-05,
 4.860776552360599644e-05,
 4.938965630283344066e-05,
 5.016877815333190276e-05,
 5.094510729143668170e-05,
 5.171862006362476922e-05,
 5.248929294716893546e-05,
 5.325710255081278033e-05,
 5.402202561543325557e-05,
 5.478403901467974774e-05,
 5.554311975563655285e-05,
 5.629924497944692956e-05,
 5.705239196197055263e-05,
 5.780253811439589059e-05,
 5.854966098386711859e-05,
 5.929373825411444641e-05,
 6.003474774605410918e-05,
 6.077266741839936951e-05,
 6.150747536827406070e-05,
 6.223914983179369882e-05,
 6.296766918465726733e-05,
 6.369301194274349439e-05,
 6.441515676267491584e-05,
 6.513408244240155543e-05,
 6.584976792177056463e-05,
 6.656219228307079028e-05,
 6.727133475160919070e-05,
 6.797717469624548284e-05,
 6.867969162994176505e-05,
 6.937886521030273439e-05,
 7.007467524011137729e-05,
 7.076710166783914098e-05,
 7.145612458818644886e-05,
 7.214172424258097273e-05,
 7.282388101970076037e-05,
 7.350257545596115068e-05,
 7.417778823603089463e-05,
 7.484950019330741523e-05,
 7.551769231040494251e-05,
 7.618234571963618381e-05,
 7.684344170348963033e-05,
 7.750096169508325500e-05,
 7.815488727864462434e-05,
 7.880520018995008165e-05,
 7.945188231677633079e-05,
 8.009491569935304990e-05,
 8.073428253078868469e-05,
 8.136996515750435975e-05,
 8.200194607966915857e-05,
 8.263020795160580490e-05,
 8.325473358220520747e-05,
 8.387550593534295624e-05,
 8.449250813026791399e-05,
 8.510572344200524142e-05,
 8.571513530174807870e-05,
 8.632072729722484606e-05,
 8.692248317309331067e-05,
 8.752038683129901024e-05,
 8.811442233144304160e-05,
 8.870457389114338456e-05,
 8.929082588638862286e-05,
 8.987316285187106537e-05,
 9.045156948134251338e-05,
 9.102603062793538779e-05,
 9.159653130450137965e-05,
 9.216305668392023092e-05,
 9.272559209943155459e-05,
 9.328412304492929037e-05,
 9.383863517526969946e-05,
 9.438911430656809717e-05,
 9.493554641649538212e-05,
 9.547791764454981872e-05,
 9.601621429235263126e-05,
 9.655042282390628803e-05,
 9.708052986586289553e-05,
 9.760652220779222682e-05,
 9.812838680242494871e-05,
 9.864611076590789718e-05,
 9.915968137804796864e-05,
 9.966908608253591284e-05,
 1.001743124871836511e-04,
 1.006753483641505495e-04,
 1.011721816501509347e-04,
 1.016648004466722905e-04,
 1.021531930201818650e-04,
 1.026373478023125444e-04,
 1.031172533900710195e-04,
 1.035928985460102687e-04,
 1.040642721984211093e-04,
 1.045313634414944215e-04,
 1.049941615355039177e-04,
 1.054526559069498941e-04,
 1.059068361487303583e-04,
 1.063566920202775173e-04,
 1.068022134477129804e-04,
 1.072433905239719281e-04,
 1.076802135089481642e-04,
 1.081126728296077813e-04,
 1.085407590801087480e-04,
 1.089644630219215672e-04,
 1.093837755839255533e-04,
 1.097986878625127665e-04,
 1.102091911216893311e-04,
 1.106152767931523875e-04,
 1.110169364763758927e-04,
 1.114141619386907023e-04,
 1.118069451153470476e-04,
 1.121952781095839519e-04,
 1.125791531926881702e-04,
 1.129585628040368796e-04,
 1.133334995511501008e-04,
 1.137039562097310843e-04,
 1.140699257236937680e-04,
 1.144314012051948288e-04,
 1.147883759346569253e-04,
 1.151408433607740240e-04,
 1.154887971005323107e-04,
 1.158322309392037936e-04,
 1.161711388303520364e-04,
 1.165055148958135504e-04,
 1.168353534256955583e-04,
 1.171606488783407714e-04,
 1.174813958803127119e-04,
 1.177975892263542019e-04,
 1.181092238793556910e-04,
 1.184162949703029973e-04,
 1.187187977982362983e-04,
 1.190167278301852000e-04,
 1.193100807011072902e-04,
 1.195988522138254984e-04,
 1.198830383389472417e-04,
 1.201626352147854541e-04,
 1.204376391472792771e-04,
 1.207080466098931610e-04,
 1.209738542435215096e-04,
 1.212350588563896518e-04,
 1.214916574239373304e-04,
 1.217436470887086827e-04,
 1.219910251602316097e-04,
 1.222337891148846220e-04,
 1.224719365957710460e-04,
 1.227054654125758813e-04,
 1.229343735414234321e-04,
 1.231586591247274835e-04,
 1.233783204710379956e-04,
 1.235933560548721033e-04,
 1.238037645165556062e-04,
 1.240095446620432347e-04,
 1.242106954627461807e-04,
 1.244072160553410340e-04,
 1.245991057415880973e-04,
 1.247863639881286672e-04,
 1.249689904262876012e-04,
 1.251469848518637956e-04,
 1.253203472249227505e-04,
 1.254890776695720585e-04,
 1.256531764737451066e-04,
 1.258126440889665361e-04,
 1.259674811301178380e-04,
 1.261176883752020540e-04,
 1.262632667650915913e-04,
 1.264042174032825963e-04,
 1.265405415556367791e-04,
 1.266722406501169496e-04,
 1.267993162765220384e-04,
 1.269217701862141486e-04,
 1.270396042918389679e-04,
 1.271528206670432789e-04,
 1.272614215461862364e-04,
 1.273654093240424320e-04,
 1.274647865555052825e-04,
 1.275595559552792258e-04,
 1.276497203975718612e-04,
 1.277352829157760346e-04,
 1.278162467021519769e-04,
 1.278926151074969212e-04,
 1.279643916408172396e-04,
 1.280315799689897116e-04,
 1.280941839164217891e-04,
 1.281522074647016432e-04,
 1.282056547522501897e-04,
 1.282545300739606185e-04,
 1.282988378808358910e-04,
 1.283385827796232825e-04,
 1.283737695324414709e-04,
 1.284044030564011473e-04,
 1.284304884232255993e-04,
 1.284520308588603171e-04,
 1.284690357430805935e-04,
 1.284815086090963592e-04,
 1.284894551431463663e-04,
 1.284928811840932927e-04,
 1.284917927230116367e-04,
 1.284861959027673725e-04,
 1.284760970175989592e-04,
 1.284615025126892719e-04,
 1.284424189837336003e-04,
 1.284188531765034476e-04,
 1.283908119864055856e-04,
 1.283583024580350375e-04,
 1.283213317847250535e-04,
 1.282799073080907422e-04,
 1.282340365175699932e-04,
 1.281837270499577570e-04,
 1.281289866889366677e-04,
 1.280698233646027041e-04,
 1.280062451529876257e-04,
 1.279382602755736839e-04,
 1.278658770988078184e-04,
 1.277891041336076130e-04,
 1.277079500348651917e-04,
 1.276224236009459653e-04,
 1.275325337731827698e-04,
 1.274382896353649084e-04,
 1.273397004132248639e-04,
 1.272367754739175559e-04,
 1.271295243254984600e-04,
 1.270179566163950056e-04,
 1.269020821348746655e-04,
 1.267819108085093880e-04,
 1.266574527036339287e-04,
 1.265287180248019611e-04,
 1.263957171142360064e-04,
 1.262584604512751135e-04,
 1.261169586518176339e-04,
 1.259712224677588725e-04,
 1.258212627864269779e-04,
 1.256670906300113503e-04,
 1.255087171549896141e-04,
 1.253461536515512828e-04,
 1.251794115430136995e-04,
 1.250085023852383836e-04,
 1.248334378660397612e-04,
 1.246542298045934076e-04,
 1.244708901508351825e-04,
 1.242834309848641326e-04,
 1.240918645163340103e-04,
 1.238962030838462291e-04,
 1.236964591543354729e-04,
 1.234926453224550894e-04,
 1.232847743099538902e-04,
 1.230728589650547408e-04,
 1.228569122618265632e-04,
 1.226369472995509724e-04,
 1.224129773020896984e-04,
 1.221850156172453407e-04,
 1.219530757161173793e-04,
 1.217171711924584841e-04,
 1.214773157620262429e-04,
 1.212335232619264738e-04,
 1.209858076499619996e-04,
 1.207341830039695355e-04,
 1.204786635211565782e-04,
 1.202192635174392153e-04,
 1.199559974267663017e-04,
 1.196888798004520926e-04,
 1.194179253064969905e-04,
 1.191431487289076695e-04,
 1.188645649670141090e-04,
 1.185821890347872241e-04,
 1.182960360601446778e-04,
 1.180061212842623588e-04,
 1.177124600608760467e-04,
 1.174150678555863162e-04,
 1.171139602451523425e-04,
 1.168091529167905303e-04,
 1.165006616674679399e-04,
 1.161885024031892341e-04,
 1.158726911382824601e-04,
 1.155532439946868644e-04,
 1.152301772012276424e-04,
 1.149035070928978856e-04,
 1.145732501101350112e-04,
 1.142394227980874630e-04,
 1.139020418058898806e-04,
 1.135611238859260056e-04,
 1.132166858930924123e-04,
 1.128687447840643682e-04,
 1.125173176165511903e-04,
 1.121624215485506521e-04,
 1.118040738376078509e-04,
 1.114422918400608334e-04,
 1.110770930102897308e-04,
 1.107084948999681993e-04,
 1.103365151572992199e-04,
 1.099611715262632718e-04,
 1.095824818458501212e-04,
 1.092004640493029560e-04,
 1.088151361633424768e-04,
 1.084265163074088901e-04,
 1.080346226928835464e-04,
 1.076394736223217042e-04,
 1.072410874886718234e-04,
 1.068394827745053479e-04,
 1.064346780512280842e-04,
 1.060266919783064195e-04,
 1.056155433024818857e-04,
 1.052012508569847866e-04,
 1.047838335607436663e-04,
 1.043633104176028129e-04,
 1.039397005155208437e-04,
 1.035130230257845225e-04,
 1.030832972022132136e-04,
 1.026505423803556361e-04,
 1.022147779766975569e-04,
 1.017760234878557670e-04,
 1.013342984897746207e-04,
 1.008896226369277094e-04,
 1.004420156615070016e-04,
 9.999149737261256313e-05,
 9.953808765544943542e-05,
 9.908180647051075636e-05,
 9.862267385276454106e-05,
 9.816070991084661532e-05,
 9.769593482623487371e-05,
 9.722836885244083062e-05,
 9.675803231418238757e-05,
 9.628494560657163031e-05,
 9.580912919428301528e-05,
 9.533060361074271170e-05,
 9.484938945729212603e-05,
 9.436550740237209403e-05,
 9.387897818068666276e-05,
 9.338982259238482961e-05,
 9.289806150221876775e-05,
 9.240371583872346458e-05,
 9.190680659338318706e-05,
 9.140735481979174004e-05,
 9.090538163282673790e-05,
 9.040090820781176019e-05,
 8.989395577967375036e-05,
 8.938454564211442785e-05,
 8.887269914677176606e-05,
 8.835843770237281037e-05,
 8.784178277390430412e-05,
 8.732275588176149504e-05,
 8.680137860091756863e-05,
 8.627767256006760278e-05,
 8.575165944079697112e-05,
 8.522336097673384936e-05,
 8.469279895270370013e-05,
 8.415999520388011237e-05,
 8.362497161494898983e-05,
 8.308775011924755902e-05,
 8.254835269792869332e-05,
 8.200680137911156250e-05,
 8.146311823702630565e-05,
 8.091732539117420817e-05,
 8.036944500547171062e-05,
 7.981949928739913382e-05,
 7.926751048716019175e-05,
 7.871350089682433349e-05,
 7.815749284947355732e-05,
 7.759950871835902351e-05,
 7.703957091604317928e-05,
 7.647770189354594962e-05,
 7.591392413950464322e-05,
 7.534826017930776982e-05,
 7.478073257425246604e-05,
 7.421136392068941221e-05,
 7.364017684916770860e-05,
 7.306719402358060537e-05,
 7.249243814032418887e-05,
 7.191593192743057548e-05,
 7.133769814372726192e-05,
 7.075775957797366669e-05,
 7.017613904802144252e-05,
 6.959285939994649126e-05,
 6.900794350720966942e-05,
 6.842141426980163726e-05,
 6.783329461339003888e-05,
 6.724360748846380928e-05,
 6.665237586949324285e-05,
 6.605962275406314669e-05,
 6.546537116203540285e-05,
 6.486964413469693445e-05,
 6.427246473390174945e-05,
 6.367385604123233735e-05,
 6.307384115714270224e-05,
 6.247244320010872777e-05,
 6.186968530579037349e-05,
 6.126559062617670010e-05,
 6.066018232873614631e-05,
 6.005348359557971457e-05,
 5.944551762260716853e-05,
 5.883630761866076592e-05,
 5.822587680469341111e-05,
 5.761424841290975024e-05,
 5.700144568593581458e-05,
 5.638749187596620071e-05,
 5.577241024393500140e-05,
 5.515622405865875061e-05,
 5.453895659601687505e-05,
 5.392063113809588597e-05,
 5.330127097236401671e-05,
 5.268089939082399323e-05,
 5.205953968918941317e-05,
 5.143721516603453481e-05,
 5.081394912197322435e-05,
 5.018976485882552967e-05,
 4.956468567877652244e-05,
 4.893873488355664800e-05,
 4.831193577360924787e-05,
 4.768431164725405710e-05,
 4.705588579987165387e-05,
 4.642668152307624028e-05,
 4.579672210388313099e-05,
 4.516603082389661800e-05,
 4.453463095847968187e-05,
 4.390254577593236975e-05,
 4.326979853668558263e-05,
 4.263641249246714773e-05,
 4.200241088549816715e-05,
 4.136781694767275794e-05,
 4.073265389974401959e-05,
 4.009694495050920865e-05,
 3.946071329601255194e-05,
 3.882398211872058891e-05,
 3.818677458672821028e-05,
 3.754911385294185409e-05,
 3.691102305428816007e-05,
 3.627252531089499038e-05,
 3.563364372531120389e-05,
 3.499440138169012998e-05,
 3.435482134500644248e-05,
 3.371492666024863239e-05,
 3.307474035163948005e-05,
 3.243428542182762658e-05,
 3.179358485111165100e-05,
 3.115266159665085920e-05,
 3.051153859167018086e-05,
 2.987023874468685547e-05,
 2.922878493872556820e-05,
 2.858720003052916093e-05,
 2.794550684979286022e-05,
 2.730372819838677219e-05,
 2.666188684957304119e-05,
 2.602000554724588161e-05,
 2.537810700515306993e-05,
 2.473621390612689978e-05,
 2.409434890133213189e-05,
 2.345253460948628331e-05,
 2.281079361611086382e-05,
 2.216914847276788082e-05,
 2.152762169630188368e-05,
 2.088623576808264857e-05,
 2.024501313326714172e-05,
 1.960397620003284614e-05,
 1.896314733884459027e-05,
 1.832254888169719884e-05,
 1.768220312138699715e-05,
 1.704213231075473977e-05,
 1.640235866196212581e-05,
 1.576290434575326077e-05,
 1.512379149072065329e-05,
 1.448504218257062422e-05,
 1.384667846340775344e-05,
 1.320872233099333137e-05,
 1.257119573803645674e-05,
 1.193412059147283715e-05,
 1.129751875173838041e-05,
 1.066141203206686703e-05,
 1.002582219776904043e-05,
 9.390770965521807415e-06,
 8.756280002674018430e-06,
 8.122370926533653768e-06,
 7.489065303663868882e-06,
 6.856384649195353557e-06,
 6.224350426121986744e-06,
 5.592984044606705769e-06,
 4.962306861305528297e-06,
 4.332340178664007615e-06,
 3.703105244246982238e-06,
 3.074623250045389130e-06,
 2.446915331811808288e-06,
 1.820002568367166485e-06,
 1.193905980949734002e-06,
 5.686465325277691493e-07,
-5.575487285304644198e-08,
-6.792773907448401563e-07,
-1.301900236944085969e-06,
-1.923602688165210920e-06,
-2.544364082680986205e-06,
-3.164163820976385644e-06,
-3.782981366397813248e-06,
-4.400796245802158099e-06,
-5.017588050186235963e-06,
-5.633336435341474612e-06,
-6.248021122475436530e-06,
-6.861621898845164503e-06,
-7.474118618394712831e-06,
-8.085491202368466090e-06,
-8.695719639942215106e-06,
-9.304783988843304504e-06,
-9.912664375954183488e-06,
-1.051934099793345803e-05,
-1.112479412182761974e-05,
-1.172900408566606791e-05,
-1.233195129907195915e-05,
-1.293361624386246407e-05,
-1.353397947463050106e-05,
-1.413302161935288219e-05,
-1.473072337996534868e-05,
-1.532706553295916325e-05,
-1.592202892994946760e-05,
-1.651559449827052120e-05,
-1.710774324152980488e-05,
-1.769845624019637497e-05,
-1.828771465215499564e-05,
-1.887549971328155552e-05,
-1.946179273799034581e-05,
-2.004657511980633609e-05,
-2.062982833190547631e-05,
-2.121153392766515300e-05,
-2.179167354121897552e-05,
-2.237022888798842138e-05,
-2.294718176522451720e-05,
-2.352251405255091217e-05,
-2.409620771248360396e-05,
-2.466824479095987345e-05,
-2.523860741787020118e-05,
-2.580727780756699865e-05,
-2.637423825938933511e-05,
-2.693947115817652075e-05,
-2.750295897476430872e-05,
-2.806468426650501405e-05,
-2.862462967775755948e-05,
-2.918277794038877664e-05,
-2.973911187426810042e-05,
-3.029361438776029481e-05,
-3.084626847819818535e-05,
-3.139705723238017584e-05,
-3.194596382703590294e-05,
-3.249297152931071537e-05,
-3.303806369722434559e-05,
-3.358122378015165860e-05,
-3.412243531927313121e-05,
-3.466168194803569889e-05,
-3.519894739260904230e-05,
-3.573421547233996282e-05,
-3.626747010018807605e-05,
-3.679869528318357541e-05,
-3.732787512285343890e-05,
-3.785499381565763066e-05,
-3.838003565342774887e-05,
-3.890298502378413190e-05,
-3.942382641056034373e-05,
-3.994254439423548607e-05,
-4.045912365232555468e-05,
-4.097354895980823651e-05,
-4.148580518953054268e-05,
-4.199587731260208921e-05,
-4.250375039880140181e-05,
-4.300940961697082297e-05,
-4.351284023539532541e-05,
-4.401402762220268434e-05,
-4.451295724573500642e-05,
-4.500961467493005047e-05,
-4.550398557969644270e-05,
-4.599605573128578848e-05,
-4.648581100264606125e-05,
-4.697323736879700751e-05,
-4.745832090717593281e-05,
-4.794104779800016403e-05,
-4.842140432460515111e-05,
-4.889937687380196914e-05,
-4.937495193620665830e-05,
-4.984811610657907774e-05,
-5.031885608415570142e-05,
-5.078715867298121454e-05,
-5.125301078222226135e-05,
-5.171639942649958372e-05,
-5.217731172619310883e-05,
-5.263573490775318294e-05,
-5.309165630401457673e-05,
-5.354506335448944344e-05,
-5.399594360567233208e-05,
-5.444428471133557152e-05,
-5.489007443280881170e-05,
-5.533330063927232743e-05,
-5.577395130803952081e-05,
-5.621201452482593887e-05,
-5.664747848402928239e-05,
-5.708033148899782042e-05,
-5.751056195228484579e-05,
-5.793815839592066753e-05,
-5.836310945165795229e-05,
-5.878540386123149239e-05,
-5.920503047659557156e-05,
-5.962197826017918615e-05,
-6.003623628510942461e-05,
-6.044779373545825906e-05,
-6.085663990646246214e-05,
-6.126276420475775398e-05,
-6.166615614858962538e-05,
-6.206680536804276170e-05,
-6.246470160524302299e-05,
-6.285983471456668822e-05,
-6.325219466285137327e-05,
-6.364177152958735192e-05,
-6.402855550711508399e-05,
-6.441253690082210642e-05,
-6.479370612932165555e-05,
-6.517205372463561277e-05,
-6.554757033237868327e-05,
-6.592024671192342521e-05,
-6.629007373657662232e-05,
-6.665704239374386575e-05,
-6.702114378508195228e-05,
-6.738236912666610893e-05,
-6.774070974913359551e-05,
-6.809615709783453077e-05,
-6.844870273297710766e-05,
-6.879833832976684556e-05,
-6.914505567853355039e-05,
-6.948884668487257256e-05,
-6.982970336976173818e-05,
-7.016761786969062664e-05,
-7.050258243676985818e-05,
-7.083458943885569581e-05,
-7.116363135964506208e-05,
-7.148970079879194176e-05,
-7.181279047199880716e-05,
-7.213289321111999682e-05,
-7.245000196424561921e-05,
-7.276410979579796539e-05,
-7.307520988660740318e-05,
-7.338329553399098183e-05,
-7.368836015183327279e-05,
-7.399039727064959232e-05,
-7.428940053765422486e-05,
-7.458536371682649162e-05,
-7.487828068896246702e-05,
-7.516814545172741341e-05,
-7.545495211971084502e-05,
-7.573869492446410907e-05,
-7.601936821454512269e-05,
-7.629696645555583212e-05,
-7.657148423016670209e-05,
-7.684291623815294175e-05,
-7.711125729641124201e-05,
-7.737650233898160873e-05,
-7.763864641706328686e-05,
-7.789768469902625303e-05,
-7.815361247041097159e-05,
-7.840642513393934504e-05,
-7.865611820950585073e-05,
-7.890268733417691736e-05,
-7.914612826217439097e-05,
-7.938643686486866378e-05,
-7.962360913075390014e-05,
-7.985764116542591888e-05,
-8.008852919155679581e-05,
-8.031626954886464159e-05,
-8.054085869407389287e-05,
-8.076229320088036028e-05,
-8.098056975990718272e-05,
-8.119568517865204029e-05,
-8.140763638144178041e-05,
-8.161642040937130949e-05,
-8.182203442024758031e-05,
-8.202447568852058257e-05,
-8.222374160522193641e-05,
-8.241982967788378048e-05,
-8.261273753047048080e-05,
-8.280246290329136604e-05,
-8.298900365292210927e-05,
-8.317235775211005006e-05,
-8.335252328968763443e-05,
-8.352949847047152988e-05,
-8.370328161516191656e-05,
-8.387387116023904080e-05,
-8.404126565785606886e-05,
-8.420546377572122058e-05,
-8.436646429698789907e-05,
-8.452426612012838112e-05,
-8.467886825881031304e-05,
-8.483026984177053666e-05,
-8.497847011267900834e-05,
-8.512346843000541505e-05,
-8.526526426687825518e-05,
-8.540385721093718375e-05,
-8.553924696418820366e-05,
-8.567143334285144370e-05,
-8.580041627720267532e-05,
-8.592619581141530368e-05,
-8.604877210339833367e-05,
-8.616814542462326344e-05,
-8.628431615995866232e-05,
-8.639728480749045067e-05,
-8.650705197834629987e-05,
-8.661361839650910882e-05,
-8.671698489863530527e-05,
-8.681715243385848318e-05,
-8.691412206360001980e-05,
-8.700789496136810514e-05,
-8.709847241255837084e-05,
-8.718585581424549290e-05,
-8.727004667497822326e-05,
-8.735104661456318637e-05,
-8.742885736384824202e-05,
-8.750348076450507569e-05,
-8.757491876880262743e-05,
-8.764317343938039871e-05,
-8.770824694901854736e-05,
-8.777014158040174834e-05,
-8.782885972588042533e-05,
-8.788440388723046438e-05,
-8.793677667540564995e-05,
-8.798598081029018216e-05,
-8.803201912044573247e-05,
-8.807489454285378301e-05,
-8.811461012265841316e-05,
-8.815116901290020925e-05,
-8.818457447425140751e-05,
-8.821482987474516880e-05,
-8.824193868950264423e-05,
-8.826590450045338659e-05,
-8.828673099605780807e-05,
-8.830442197102115424e-05,
-8.831898132600694937e-05,
-8.833041306734530542e-05,
-8.833872130674032296e-05,
-8.834391026097091913e-05,
-8.834598425159074760e-05,
-8.834494770462315827e-05,
-8.834080515025570979e-05,
-8.833356122252653691e-05,
-8.832322065901227653e-05,
-8.830978830050965098e-05,
-8.829326909071538449e-05,
-8.827366807590174215e-05,
-8.825099040459032053e-05,
-8.822524132722051222e-05,
-8.819642619581737411e-05,
-8.816455046365366793e-05,
-8.812961968491066765e-05,
-8.809163951433589040e-05,
-8.805061570689537930e-05,
-8.800655411742644701e-05,
-8.795946070028372440e-05,
-8.790934150898470779e-05,
-8.785620269585141652e-05,
-8.780005051164863539e-05,
-8.774089130521977177e-05,
-8.767873152311891807e-05,
-8.761357770924130142e-05,
-8.754543650444930169e-05,
-8.747431464619596225e-05,
-8.740021896814629176e-05,
-8.732315639979467629e-05,
-8.724313396607997399e-05,
-8.716015878699776378e-05,
-8.707423807720901607e-05,
-8.698537914564708309e-05,
-8.689358939512097568e-05,
-8.679887632191602461e-05,
-8.670124751539183127e-05,
-8.660071065757758918e-05,
-8.649727352276470865e-05,
-8.639094397709622933e-05,
-8.628172997815373925e-05,
-8.616963957454220669e-05,
-8.605468090547117995e-05,
-8.593686220033350709e-05,
-8.581619177828221244e-05,
-8.569267804780515056e-05,
-8.556632950629352089e-05,
-8.543715473961318771e-05,
-8.530516242166929174e-05,
-8.517036131396897775e-05,
-8.503276026518465092e-05,
-8.489236821071021279e-05,
-8.474919417221874753e-05,
-8.460324725721427204e-05,
-8.445453665858462453e-05,
-8.430307165414772594e-05,
-8.414886160620121589e-05,
-8.399191596106253413e-05,
-8.383224424861417904e-05,
-8.366985608183923539e-05,
-8.350476115636145584e-05,
-8.333696924997654673e-05,
-8.316649022218722156e-05,
-8.299333401373212870e-05,
-8.281751064611290883e-05,
-8.263903022112106269e-05,
-8.245790292036086144e-05,
-8.227413900476843525e-05,
-8.208774881413384344e-05,
-8.189874276661666648e-05,
-8.170713135825959225e-05,
-8.151292516250347950e-05,
-8.131613482969531981e-05,
-8.111677108659741929e-05,
-8.091484473589571284e-05,
-8.071036665570124804e-05,
-8.050334779905507065e-05,
-8.029379919342759426e-05,
-8.008173194021726523e-05,
-7.986715721424518890e-05,
-7.965008626325439088e-05,
-7.943053040739763988e-05,
-7.920850103873197916e-05,
-7.898400962070459784e-05,
-7.875706768764412322e-05,
-7.852768684424013600e-05,
-7.829587876503348682e-05,
-7.806165519389264020e-05,
-7.782502794349749938e-05,
-7.758600889481486937e-05,
-7.734460999657814828e-05,
-7.710084326475896851e-05,
-7.685472078204253778e-05,
-7.660625469730052714e-05,
-7.635545722505783321e-05,
-7.610234064496386702e-05,
-7.584691730125947887e-05,
-7.558919960223839450e-05,
-7.532920001971573915e-05,
-7.506693108848959569e-05,
-7.480240540579838847e-05,
-7.453563563078505715e-05,
-7.426663448395130990e-05,
-7.399541474661395027e-05,
-7.372198926036468698e-05,
-7.344637092651743479e-05,
-7.316857270556582037e-05,
-7.288860761663183837e-05,
-7.260648873691578149e-05,
-7.232222920114266039e-05,
-7.203584220101474933e-05,
-7.174734098465177195e-05,
-7.145673885603995041e-05,
-7.116404917447121531e-05,
-7.086928535399056078e-05,
-7.057246086283091766e-05,
-7.027358922285829943e-05,
-6.997268400900919622e-05,
-6.966975884872874118e-05,
-6.936482742140422846e-05,
-6.905790345780647797e-05,
-6.874900073951732248e-05,
-6.843813309836921063e-05,
-6.812531441587643438e-05,
-6.781055862266379525e-05,
-6.749387969790195173e-05,
-6.717529166873340203e-05,
-6.685480860970044546e-05,
-6.653244464217917468e-05,
-6.620821393380185347e-05,
-6.588213069788209978e-05,
-6.555420919284555767e-05,
-6.522446372164990335e-05,
-6.489290863120848328e-05,
-6.455955831181954953e-05,
-6.422442719658088542e-05,
-6.388752976081866141e-05,
-6.354888052150154580e-05,
-6.320849403666927596e-05,
-6.286638490484205272e-05,
-6.252256776445088706e-05,
-6.217705729324737396e-05,
-6.182986820772794039e-05,
-6.148101526254557076e-05,
-6.113051324993372968e-05,
-6.077837699911396740e-05,
-6.042462137571917851e-05,
-6.006926128120685201e-05,
-5.971231165227442887e-05,
-5.935378746027074288e-05,
-5.899370371061640614e-05,
-5.863207544221014065e-05,
-5.826891772684785598e-05,
-5.790424566863610945e-05,
-5.753807440339950833e-05,
-5.717041909810034999e-05,
-5.680129495024546841e-05,
-5.643071718729775638e-05,
-5.605870106609462652e-05,
-5.568526187225433609e-05,
-5.531041491958633684e-05,
-5.493417554950761510e-05,
-5.455655913044964677e-05,
-5.417758105726791366e-05,
-5.379725675066096769e-05,
-5.341560165657167344e-05,
-5.303263124560543882e-05,
-5.264836101243477800e-05,
-5.226280647521728461e-05,
-5.187598317499646092e-05,
-5.148790667512404820e-05,
-5.109859256066130311e-05,
-5.070805643779714711e-05,
-5.031631393325230924e-05,
-4.992338069369868845e-05,
-4.952927238516060290e-05,
-4.913400469243442339e-05,
-4.873759331849922808e-05,
-4.834005398392349326e-05,
-4.794140242628299191e-05,
-4.754165439957169250e-05,
-4.714082567360894431e-05,
-4.673893203345903628e-05,
-4.633598927884416250e-05,
-4.593201322355216999e-05,
-4.552701969485745245e-05,
-4.512102453292990423e-05,
-4.471404359024867863e-05,
-4.430609273102518233e-05,
-4.389718783060873604e-05,
-4.348734477490947403e-05,
-4.307657945981225835e-05,
-4.266490779059236833e-05,
-4.225234568133118344e-05,
-4.183890905434221337e-05,
-4.142461383957948286e-05,
-4.100947597406484250e-05,
-4.059351140130022952e-05,
-4.017673607069634071e-05,
-3.975916593698287384e-05,
-3.934081695963874555e-05,
-3.892170510231242943e-05,
-3.850184633224354772e-05,
-3.808125661968411740e-05,
-3.765995193733019788e-05,
-3.723794825973633372e-05,
-3.681526156275023129e-05,
-3.639190782293836202e-05,
-3.596790301700766249e-05,
-3.554326312124045508e-05,
-3.511800411092171135e-05,
-3.469214195976345590e-05,
-3.426569263934300057e-05,
-3.383867211853393482e-05,
-3.341109636293315872e-05,
-3.298298133430213266e-05,
-3.255434298999571280e-05,
-3.212519728239682096e-05,
-3.169556015836203790e-05,
-3.126544755864805352e-05,
-3.083487541735845951e-05,
-3.040385966138062153e-05,
-2.997241620982529574e-05,
-2.954056097346664857e-05,
-2.910830985419444997e-05,
-2.867567874444683585e-05,
-2.824268352666494753e-05,
-2.780934007273126764e-05,
-2.737566424342652630e-05,
-2.694167188786718311e-05,
-2.650737884296492533e-05,
-2.607280093287594054e-05,
-2.563795396845234767e-05,
-2.520285374669323152e-05,
-2.476751605020780685e-05,
-2.433195664666105564e-05,
-2.389619128824027250e-05,
-2.346023571111360736e-05,
-2.302410563488442377e-05,
-2.258781676206124937e-05,
-2.215138477751522086e-05,
-2.171482534794368170e-05,
-2.127815412134465237e-05,
-2.084138672647828009e-05,
-2.040453877233409233e-05,
-1.996762584760853335e-05,
-1.953066352017126907e-05,
-1.909366733653743809e-05,
-1.865665282135244225e-05,
-1.821963547685721466e-05,
-1.778263078237570386e-05,
-1.734565419378691814e-05,
-1.690872114301532339e-05,
-1.647184703750179317e-05,
-1.603504725970282581e-05,
-1.559833716656460479e-05,
-1.516173208902037270e-05,
-1.472524733147193533e-05,
-1.428889817128959880e-05,
-1.385269985829893536e-05,
-1.341666761427490312e-05,
-1.298081663244770738e-05,
-1.254516207699006446e-05,
-1.210971908252558378e-05,
-1.167450275362782243e-05,
-1.123952816432302429e-05,
-1.080481035759382310e-05,
-1.037036434489603729e-05,
-9.936205105656713152e-06,
-9.502347586794675395e-06,
-9.068806702225443175e-06,
-8.635597332385602451e-06,
-8.202734323737344228e-06,
-7.770232488301851052e-06,
-7.338106603167762090e-06,
-6.906371410023311096e-06,
-6.475041614672838314e-06,
-6.044131886572840882e-06,
-5.613656858349518961e-06,
-5.183631125338718259e-06,
-4.754069245117851155e-06,
-4.324985737034575381e-06,
-3.896395081750927663e-06,
-3.468311720780319843e-06,
-3.040750056022464431e-06,
-2.613724449314812633e-06,
-2.187249221976859945e-06,
-1.761338654351428049e-06,
-1.336006985362486935e-06,
-9.112684120607396110e-07,
-4.871370891765281596e-07,
-6.362712868514867777e-08,
 3.592474006461222205e-07,
 7.814724736893390697e-07,
 1.203034109396238965e-06,
 1.623918371234312678e-06,
 2.044111367621653878e-06,
 2.463599252348319692e-06,
 2.882368225015842866e-06,
 3.300404531454056893e-06,
 3.717694464152948560e-06,
 4.134224362674899989e-06,
 4.549980614084981797e-06,
 4.964949653358522058e-06,
 5.379117963797626287e-06,
 5.792472077444214839e-06,
 6.204998575492761743e-06,
 6.616684088689541133e-06,
 7.027515297748717792e-06,
 7.437478933745757524e-06,
 7.846561778518595522e-06,
 8.254750665071460160e-06,
 8.662032477962061081e-06,
 9.068394153700423124e-06,
 9.473822681140410366e-06,
 9.878305101859544168e-06,
 1.028182851055056278e-05,
 1.068438005540629619e-05,
 1.108594693849336179e-05,
 1.148651641613593131e-05,
 1.188607579929227252e-05,
 1.228461245391885483e-05,
 1.268211380135157338e-05,
 1.307856731866475892e-05,
 1.347396053904449399e-05,
 1.386828105214237114e-05,
 1.426151650444757083e-05,
 1.465365459963077372e-05,
 1.504468309891088697e-05,
 1.543458982139872109e-05,
 1.582336264445461402e-05,
 1.621098950402690211e-05,
 1.659745839500719795e-05,
 1.698275737156351991e-05,
 1.736687454748169388e-05,
 1.774979809650293318e-05,
 1.813151625266070014e-05,
 1.851201731060441504e-05,
 1.889128962593864870e-05,
 1.926932161554044816e-05,
 1.964610175788376385e-05,
 2.002161859336546579e-05,
 2.039586072461596413e-05,
 2.076881681681987549e-05,
 2.114047559802952679e-05,
 2.151082585946703093e-05,
 2.187985645583708248e-05,
 2.224755630563299749e-05,
 2.261391439143162324e-05,
 2.297891976019795501e-05,
 2.334256152358166536e-05,
 2.370482885820233404e-05,
 2.406571100594982616e-05,
 2.442519727426381985e-05,
 2.478327703642591747e-05,
 2.513993973183369459e-05,
 2.549517486629057164e-05,
 2.584897201226992895e-05,
 2.620132080919957088e-05,
 2.655221096372413665e-05,
 2.690163224998076214e-05,
 2.724957450985603916e-05,
 2.759602765325790965e-05,
 2.794098165836768173e-05,
 2.828442657189735149e-05,
 2.862635250934865617e-05,
 2.896674965525785993e-05,
 2.930560826344599446e-05,
 2.964291865726884550e-05,
 2.997867122985263473e-05,
 3.031285644433437716e-05,
 3.064546483410373956e-05,
 3.097648700302972342e-05,
 3.130591362569682453e-05,
 3.163373544763383008e-05,
 3.195994328553100134e-05,
 3.228452802747200481e-05,
 3.260748063314599575e-05,
 3.292879213406703354e-05,
 3.324845363378757469e-05,
 3.356645630811147790e-05,
 3.388279140529373439e-05,
 3.419745024625429973e-05,
 3.451042422477251835e-05,
 3.482170480769270187e-05,
 3.513128353511246852e-05,
 3.543915202058470291e-05,
 3.574530195130046776e-05,
 3.604972508827759402e-05,
 3.635241326654588978e-05,
 3.665335839533057365e-05,
 3.695255245822428350e-05,
 3.724998751337124848e-05,
 3.754565569363236562e-05,
 3.783954920675574479e-05,
 3.813166033554747734e-05,
 3.842198143803048527e-05,
 3.871050494760574210e-05,
 3.899722337321544528e-05,
 3.928212929949080650e-05,
 3.956521538690510039e-05,
 3.984647437192675388e-05,
 4.012589906715901172e-05,
 4.040348236148758455e-05,
 4.067921722022118178e-05,
 4.095309668522154132e-05,
 4.122511387504577859e-05,
 4.149526198507145596e-05,
 4.176353428762668028e-05,
 4.202992413211622267e-05,
 4.229442494514452125e-05,
 4.255703023062904806e-05,
 4.281773356992375225e-05,
 4.307652862192619278e-05,
 4.333340912319348030e-05,
 4.358836888804293856e-05,
 4.384140180866454294e-05,
 4.409250185521558485e-05,
 4.434166307592094690e-05,
 4.458887959716879048e-05,
 4.483414562360520664e-05,
 4.507745543821877030e-05,
 4.531880340243355122e-05,
 4.555818395618758997e-05,
 4.579559161801409104e-05,
 4.603102098512264998e-05,
 4.626446673346891334e-05,
 4.649592361783085910e-05,
 4.672538647187733180e-05,
 4.695285020822945578e-05,
 4.717830981852738143e-05,
 4.740176037349154935e-05,
 4.762319702297518608e-05,
 4.784261499602224113e-05,
 4.806000960091929999e-05,
 4.827537622523838295e-05,
 4.848871033588886487e-05,
 4.870000747915456842e-05,
 4.890926328073801310e-05,
 4.911647344579150474e-05,
 4.932163375895805057e-05,
 4.952474008439376155e-05,
 4.972578836580294662e-05,
 4.992477462645732346e-05,
 5.012169496922321156e-05,
 5.031654557657491543e-05,
 5.050932271061777057e-05,
 5.070002271309582108e-05,
 5.088864200540324436e-05,
 5.107517708859487469e-05,
 5.125962454338732130e-05,
 5.144198103016188217e-05,
 5.162224328896624487e-05,
 5.180040813950653798e-05,
 5.197647248114103599e-05,
 5.215043329287366759e-05,
 5.232228763333718346e-05,
 5.249203264078074215e-05,
 5.265966553305267126e-05,
 5.282518360757452113e-05,
 5.298858424132104098e-05,
 5.314986489079369728e-05,
 5.330902309198812732e-05,
 5.346605646036413400e-05,
 5.362096269081196025e-05,
 5.377373955760846025e-05,
 5.392438491438283861e-05,
 5.407289669406800355e-05,
 5.421927290885821530e-05,
 5.436351165015556035e-05,
 5.450561108852343243e-05,
 5.464556947362574264e-05,
 5.478338513417402392e-05,
 5.491905647786407980e-05,
 5.505258199131555363e-05,
 5.518396024000298016e-05,
 5.531318986819138388e-05,
 5.544026959886113703e-05,
 5.556519823363515549e-05,
 5.568797465270359408e-05,
 5.580859781474214521e-05,
 5.592706675683065592e-05,
 5.604338059437037617e-05,
 5.615753852099311622e-05,
 5.626953980847224725e-05,
 5.637938380663098454e-05,
 5.648706994324421981e-05,
 5.659259772394273873e-05,
 5.669596673211207836e-05,
 5.679717662878609242e-05,
 5.689622715254450774e-05,
 5.699311811940129208e-05,
 5.708784942269410614e-05,
 5.718042103297065213e-05,
 5.727083299787233883e-05,
 5.735908544201247147e-05,
 5.744517856685724702e-05,
 5.752911265059880089e-05,
 5.761088804803107252e-05,
 5.769050519041601488e-05,
 5.776796458535618712e-05,
 5.784326681665611226e-05,
 5.791641254418643340e-05,
 5.798740250374357730e-05,
 5.805623750690911306e-05,
 5.812291844090194823e-05,
 5.818744626843379790e-05,
 5.824982202755745061e-05,
 5.831004683151426172e-05,
 5.836812186858104381e-05,
 5.842404840191012645e-05,
 5.847782776937210630e-05,
 5.852946138339276948e-05,
 5.857895073078676825e-05,
 5.862629737259223946e-05,
 5.867150294390146577e-05,
 5.871456915368717289e-05,
 5.875549778462953155e-05,
 5.879429069294002212e-05,
 5.883094980817970198e-05,
 5.886547713308034604e-05,
 5.889787474335898040e-05,
 5.892814478753169097e-05,
 5.895628948672607003e-05,
 5.898231113449013918e-05,
 5.900621209659740298e-05,
 5.902799481085329854e-05,
 5.904766178689603437e-05,
 5.906521560599746311e-05,
 5.908065892085935988e-05,
 5.909399445541035808e-05,
 5.910522500459784349e-05,
 5.911435343417868293e-05,
 5.912138268050813014e-05,
 5.912631575032668515e-05,
 5.912915572054258976e-05,
 5.912990573801620009e-05,
 5.912856901933723723e-05,
 5.912514885060392848e-05,
 5.911964858719771689e-05,
 5.911207165355637170e-05,
 5.910242154294564172e-05,
 5.909070181722801538e-05,
 5.907691610662864828e-05,
 5.906106810950152106e-05,
 5.904316159209094207e-05,
 5.902320038829237233e-05,
 5.900118839941093985e-05,
 5.897712959391811758e-05,
 5.895102800720508770e-05,
 5.892288774133601110e-05,
 5.889271296479792227e-05,
 5.886050791224880141e-05,
 5.882627688426410144e-05,
 5.879002424708054431e-05,
 5.875175443233900921e-05,
 5.871147193682424952e-05,
 5.866918132220346453e-05,
 5.862488721476300099e-05,
 5.857859430514220176e-05,
 5.853030734806640751e-05,
 5.848003116207734951e-05,
 5.842777062926228200e-05,
 5.837353069498028222e-05,
 5.831731636758804205e-05,
 5.825913271816212253e-05,
 5.819898488022093736e-05,
 5.813687804944393773e-05,
 5.807281748338935382e-05,
 5.800680850121014065e-05,
 5.793885648336808070e-05,
 5.786896687134602992e-05,
 5.779714516735814434e-05,
 5.772339693405923258e-05,
 5.764772779425156725e-05,
 5.757014343059021913e-05,
 5.749064958528656856e-05,
 5.740925205981056993e-05,
 5.732595671459043448e-05,
 5.724076946871207587e-05,
 5.715369629961506608e-05,
 5.706474324278856407e-05,
 5.697391639146483894e-05,
 5.688122189631100419e-05,
 5.678666596512036563e-05,
 5.669025486249976462e-05,
 5.659199490955803258e-05,
 5.649189248359164008e-05,
 5.638995401776813018e-05,
 5.628618600080973465e-05,
 5.618059497667358856e-05,
 5.607318754423160605e-05,
 5.596397035694954288e-05,
 5.585295012256154609e-05,
 5.574013360274778005e-05,
 5.562552761280663819e-05,
 5.550913902132734791e-05,
 5.539097474986008846e-05,
 5.527104177258780295e-05,
 5.514934711599149162e-05,
 5.502589785851900837e-05,
 5.490070113024868705e-05,
 5.477376411255516323e-05,
 5.464509403776987665e-05,
 5.451469818884427057e-05,
 5.438258389900918965e-05,
 5.424875855143335628e-05,
 5.411322957888049166e-05,
 5.397600446336713476e-05,
 5.383709073581504040e-05,
 5.369649597570647743e-05,
 5.355422781073782619e-05,
 5.341029391646770746e-05,
 5.326470201597022745e-05,
 5.311745987948206330e-05,
 5.296857532404957553e-05,
 5.281805621317798736e-05,
 5.266591045647481094e-05,
 5.251214600929433743e-05,
 5.235677087238186966e-05,
 5.219979309151482407e-05,
 5.204122075714320925e-05,
 5.188106200403242205e-05,
 5.171932501089898269e-05,
 5.155601800005105400e-05,
 5.139114923702278070e-05,
 5.122472703021336524e-05,
 5.105675973051784956e-05,
 5.088725573096577760e-05,
 5.071622346635020162e-05,
 5.054367141286250940e-05,
 5.036960808772141700e-05,
 5.019404204880568852e-05,
 5.001698189427992368e-05,
 4.983843626222595624e-05,
 4.965841383027034921e-05,
 4.947692331520852228e-05,
 4.929397347263366332e-05,
 4.910957309656069993e-05,
 4.892373101904846179e-05,
 4.873645610982596971e-05,
 4.854775727591486222e-05,
 4.835764346124900325e-05,
 4.816612364629839949e-05,
 4.797320684768808976e-05,
 4.777890211781632971e-05,
 4.758321854447769599e-05,
 4.738616525047842490e-05,
 4.718775139325350604e-05,
 4.698798616448652041e-05,
 4.678687878972309519e-05,
 4.658443852798705554e-05,
 4.638067467139804002e-05,
 4.617559654478235336e-05,
 4.596921350529023628e-05,
 4.576153494200597965e-05,
 4.555257027556411012e-05,
 4.534232895775703090e-05,
 4.513082047115256947e-05,
 4.491805432869964645e-05,
 4.470404007334332285e-05,
 4.448878727763113983e-05,
 4.427230554332725111e-05,
 4.405460450101624198e-05,
 4.383569380971692292e-05,
 4.361558315648929952e-05,
 4.339428225604044471e-05,
 4.317180085033535142e-05,
 4.294814870820305556e-05,
 4.272333562494094283e-05,
 4.249737142192482221e-05,
 4.227026594621511663e-05,
 4.204202907015930634e-05,
 4.181267069100180587e-05,
 4.158220073048627871e-05,
 4.135062913446013386e-05,
 4.111796587248371161e-05,
 4.088422093742937949e-05,
 4.064940434509025724e-05,
 4.041352613378188094e-05,
 4.017659636394659115e-05,
 3.993862511775557656e-05,
 3.969962249871726015e-05,
 3.945959863127493816e-05,
 3.921856366041492919e-05,
 3.897652775126532443e-05,
 3.873350108870356754e-05,
 3.848949387695388354e-05,
 3.824451633919472314e-05,
 3.799857871716051492e-05,
 3.775169127074362086e-05,
 3.750386427759596654e-05,
 3.725510803273531315e-05,
 3.700543284814239507e-05,
 3.675484905236826925e-05,
 3.650336699013658924e-05,
 3.625099702194274170e-05,
 3.599774952366119590e-05,
 3.574363488614524327e-05,
 3.548866351482874972e-05,
 3.523284582933404707e-05,
 3.497619226307146270e-05,
 3.471871326284139698e-05,
 3.446041928844178792e-05,
 3.420132081226799988e-05,
 3.394142831891605979e-05,
 3.368075230479130081e-05,
 3.341930327770664514e-05,
 3.315709175649080720e-05,
 3.289412827059142141e-05,
 3.263042335967892221e-05,
 3.236598757325051881e-05,
 3.210083147024035683e-05,
 3.183496561861872255e-05,
 3.156840059500297028e-05,
 3.130114698425890855e-05,
 3.103321537911246609e-05,
 3.076461637974981769e-05,
 3.049536059343004621e-05,
 3.022545863409091988e-05,
 2.995492112195628916e-05,
 2.968375868314240956e-05,
 2.941198194927150143e-05,
 2.913960155707353612e-05,
 2.886662814800181173e-05,
 2.859307236784160359e-05,
 2.831894486631692071e-05,
 2.804425629670637636e-05,
 2.776901731545046635e-05,
 2.749323858176280455e-05,
 2.721693075724719292e-05,
 2.694010450550694279e-05,
 2.666277049175654073e-05,
 2.638493938244008732e-05,
 2.610662184484173655e-05,
 2.582782854670034661e-05,
 2.554857015583039543e-05,
 2.526885733973121385e-05,
 2.498870076520983574e-05,
 2.470811109799267406e-05,
 2.442709900234972620e-05,
 2.414567514070556229e-05,
 2.386385017326736924e-05,
 2.358163475763749761e-05,
 2.329903954843998102e-05,
 2.301607519693657955e-05,
 2.273275235065494579e-05,
 2.244908165300413285e-05,
 2.216507374290424453e-05,
 2.188073925440996636e-05,
 2.159608881633185044e-05,
 2.131113305186678545e-05,
 2.102588257822330653e-05,
 2.074034800624520434e-05,
 2.045453994004501729e-05,
 2.016846897663246871e-05,
 1.988214570554065083e-05,
 1.959558070846185144e-05,
 1.930878455887556080e-05,
 1.902176782168012064e-05,
 1.873454105283225751e-05,
 1.844711479897403585e-05,
 1.815949959707348230e-05,
 1.787170597405879276e-05,
 1.758374444645473511e-05,
 1.729562552001940752e-05,
 1.700735968938912502e-05,
 1.671895743771121377e-05,
 1.643042923629095753e-05,
 1.614178554422816638e-05,
 1.585303680806613569e-05,
 1.556419346142845879e-05,
 1.527526592466975800e-05,
 1.498626460452061686e-05,
 1.469719989373398455e-05,
 1.440808217073114155e-05,
 1.411892179925660315e-05,
 1.382972912802073083e-05,
 1.354051449035746828e-05,
 1.325128820387594320e-05,
 1.296206057011024967e-05,
 1.267284187417882569e-05,
 1.238364238443892984e-05,
 1.209447235213986258e-05,
 1.180534201108638582e-05,
 1.151626157729743988e-05,
 1.122724124866271219e-05,
 1.093829120460977544e-05,
 1.064942160576292805e-05,
 1.036064259360675446e-05,
 1.007196429015752710e-05,
 9.783396797622446745e-06,
 9.494950198072855542e-06,
 9.206634553111385210e-06,
 8.918459903541568469e-06,
 8.630436269038206003e-06,
 8.342573647826393487e-06,
 8.054882016348239532e-06,
 7.767371328944549014e-06,
 7.480051517526239506e-06,
 7.192932491258548766e-06,
 6.906024136233123714e-06,
 6.619336315154956213e-06,
 6.332878867023199875e-06,
 6.046661606814069725e-06,
 5.760694325163667328e-06,
 5.474986788059783613e-06,
 5.189548736522045681e-06,
 4.904389886297172988e-06,
 4.619519927548758298e-06,
 4.334948524545081837e-06,
 4.050685315357956351e-06,
 3.766739911553316981e-06,
 3.483121897886810749e-06,
 3.199840832006893728e-06,
 2.916906244149839882e-06,
 2.634327636839011763e-06,
 2.352114484591655819e-06,
 2.070276233618403059e-06,
 1.788822301527623846e-06,
 1.507762077038085314e-06,
 1.227104919679563336e-06,
 9.468601595085163266e-07,
 6.670370968137836451e-07,
 3.876450018353160248e-07,
 1.086931144702606842e-07,
-1.698093560018521464e-07,
-4.478532312098952914e-07,
-7.254293639662186061e-07,
-1.002528638551576897e-06,
-1.279141970987068832e-06,
-1.555260309317894086e-06,
-1.830874633882091118e-06,
-2.105975957585071664e-06,
-2.380555326171853736e-06,
-2.654603818498988850e-06,
-2.928112546797570409e-06,
-3.201072656947214984e-06,
-3.473475328735126493e-06,
-3.745311776120159143e-06,
-4.016573247498492282e-06,
-4.287251025958453486e-06,
-4.557336429542851009e-06,
-4.826820811506356610e-06,
-5.095695560565298952e-06,
-5.363952101154910054e-06,
-5.631581893682354355e-06,
-5.898576434772019296e-06,
-6.164927257517767660e-06,
-6.430625931730005223e-06,
-6.695664064174694817e-06,
-6.960033298823574099e-06,
-7.223725317089608687e-06,
-7.486731838071820257e-06,
-7.749044618787265151e-06,
-8.010655454414945982e-06,
-8.271556178521036852e-06,
-8.531738663299270450e-06,
-8.791194819795910008e-06,
-9.049916598143935273e-06,
-9.307895987784455227e-06,
-9.565125017699310108e-06,
-9.821595756628929982e-06,
-1.007730031329480286e-05,
-1.033223083662351661e-05,
-1.058637951596039761e-05,
-1.083973858128730663e-05,
-1.109230030344108184e-05,
-1.134405699432125504e-05,
-1.159500100710169298e-05,
-1.184512473644348723e-05,
-1.209442061869731206e-05,
-1.234288113211256028e-05,
-1.259049879704165429e-05,
-1.283726617613612245e-05,
-1.308317587455350712e-05,
-1.332822054015033236e-05,
-1.357239286368014872e-05,
-1.381568557898861505e-05,
-1.405809146320699640e-05,
-1.429960333693731871e-05,
-1.454021406444781480e-05,
-1.477991655385414374e-05,
-1.501870375730928207e-05,
-1.525656867118111272e-05,
-1.549350433624004282e-05,
-1.572950383783306894e-05,
-1.596456030606204708e-05,
-1.619866691595988565e-05,
-1.643181688766585420e-05,
-1.666400348659236082e-05,
-1.689522002360119936e-05,
-1.712545985516603068e-05,
-1.735471638353872976e-05,
-1.758298305691688817e-05,
-1.781025336960175180e-05,
-1.803652086215882174e-05,
-1.826177912158235482e-05,
-1.848602178144122946e-05,
-1.870924252203938389e-05,
-1.893143507056892585e-05,
-1.915259320125619488e-05,
-1.937271073551397421e-05,
-1.959178154208821037e-05,
-1.980979953719763816e-05,
-2.002675868468247212e-05,
-2.024265299614053497e-05,
-2.045747653106753637e-05,
-2.067122339699562723e-05,
-2.088388774962347680e-05,
-2.109546379295527087e-05,
-2.130594577942659772e-05,
-2.151532801003356647e-05,
-2.172360483446336875e-05,
-2.193077065121439473e-05,
-2.213681990772286456e-05,
-2.234174710048388628e-05,
-2.254554677516660156e-05,
-2.274821352673400010e-05,
-2.294974199955927154e-05,
-2.315012688753498800e-05,
-2.334936293418761612e-05,
-2.354744493278682161e-05,
-2.374436772644813301e-05,
-2.394012620824371670e-05,
-2.413471532130090033e-05,
-2.432813005890737773e-05,
-2.452036546460598175e-05,
-2.471141663229792397e-05,
-2.490127870633087603e-05,
-2.508994688159829603e-05,
-2.527741640362635113e-05,
-2.546368256866695555e-05,
-2.564874072378069521e-05,
-2.583258626692767361e-05,
-2.601521464704629273e-05,
-2.619662136413498490e-05,
-2.637680196933493406e-05,
-2.655575206500357787e-05,
-2.673346730479126760e-05,
-2.690994339371744688e-05,
-2.708517608823830930e-05,
-2.725916119631662440e-05,
-2.743189457749224474e-05,
-2.760337214294374274e-05,
-2.777358985555466902e-05,
-2.794254372997564330e-05,
-2.811022983267956398e-05,
-2.827664428202468163e-05,
-2.844178324830592242e-05,
-2.860564295381045683e-05,
-2.876821967286956520e-05,
-2.892950973190916493e-05,
-2.908950950949363258e-05,
-2.924821543637630398e-05,
-2.940562399553942028e-05,
-2.956173172223929517e-05,
-2.971653520404256448e-05,
-2.987003108086840568e-05,
-3.002221604502082681e-05,
-3.017308684122346594e-05,
-3.032264026665203936e-05,
-3.047087317096562752e-05,
-3.061778245633137120e-05,
-3.076336507745541863e-05,
-3.090761804160300363e-05,
-3.105053840862156278e-05,
-3.119212329096316148e-05,
-3.133236985370020135e-05,
-3.147127531454255059e-05,
-3.160883694385442367e-05,
-3.174505206466401042e-05,
-3.187991805267412828e-05,
-3.201343233627337604e-05,
-3.214559239654001666e-05,
-3.227639576724888225e-05,
-3.240584003487468093e-05,
-3.253392283858986904e-05,
-3.266064187026751752e-05,
-3.278599487447570116e-05,
-3.290997964847389363e-05,
-3.303259404220663167e-05,
-3.315383595829574272e-05,
-3.327370335202652811e-05,
-3.339219423133970611e-05,
-3.350930665681366486e-05,
-3.362503874165126221e-05,
-3.373938865165871770e-05,
-3.385235460522961374e-05,
-3.396393487331991838e-05,
-3.407412777942495948e-05,
-3.418293169955479983e-05,
-3.429034506220716598e-05,
-3.439636634833599953e-05,
-3.450099409132391848e-05,
-3.460422687694624200e-05,
-3.470606334333660767e-05,
-3.480650218095256843e-05,
-3.490554213253399979e-05,
-3.500318199306509865e-05,
-3.509942060973237038e-05,
-3.519425688187838763e-05,
-3.528768976095758878e-05,
-3.537971825048960301e-05,
-3.547034140600743222e-05,
-3.555955833500824180e-05,
-3.564736819690044481e-05,
-3.573377020294620535e-05,
-3.581876361620835332e-05,
-3.590234775148909316e-05,
-3.598452197527195830e-05,
-3.606528570565787039e-05,
-3.614463841230403774e-05,
-3.622257961635504066e-05,
-3.629910889037861287e-05,
-3.637422585829442294e-05,
-3.644793019530503096e-05,
-3.652022162782147835e-05,
-3.659109993339133078e-05,
-3.666056494062071720e-05,
-3.672861652909671453e-05,
-3.679525462930946132e-05,
-3.686047922256895196e-05,
-3.692429034092315913e-05,
-3.698668806707444858e-05,
-3.704767253429120305e-05,
-3.710724392632068638e-05,
-3.716540247730001689e-05,
-3.722214847166347492e-05,
-3.727748224405059632e-05,
-3.733140417921138613e-05,
-3.738391471190890972e-05,
-3.743501432682177566e-05,
-3.748470355844503958e-05,
-3.753298299098769289e-05,
-3.757985325827048348e-05,
-3.762531504362167647e-05,
-3.766936907976918965e-05,
-3.771201614873441617e-05,
-3.775325708172118876e-05,
-3.779309275900654628e-05,
-3.783152410982569314e-05,
-3.786855211226036034e-05,
-3.790417779312012600e-05,
-3.793840222782755768e-05,
-3.797122654029673434e-05,
-3.800265190281483106e-05,
-3.803267953591799152e-05,
-3.806131070826953818e-05,
-3.808854673653297153e-05,
-3.811438898524590452e-05,
-3.813883886669212670e-05,
-3.816189784077084939e-05,
-3.818356741486556472e-05,
-3.820384914371198975e-05,
-3.822274462926269708e-05,
-3.824025552055112202e-05,
-3.825638351355523093e-05,
-3.827113035105732030e-05,
-3.828449782250458166e-05,
-3.829648776386752499e-05,
-3.830710205749539369e-05,
-3.831634263197275167e-05,
-3.832421146197270950e-05,
-3.833071056810936450e-05,
-3.833584201678908208e-05,
-3.833960792005982552e-05,
-3.834201043545896109e-05,
-3.834305176586069047e-05,
-3.834273415932072524e-05,
-3.834105990892075808e-05,
-3.833803135261071136e-05,
-3.833365087305009124e-05,
-3.832792089744784425e-05,
-3.832084389740051978e-05,
-3.831242238872969395e-05,
-3.830265893131780110e-05,
-3.829155612894236604e-05,
-3.827911662910946382e-05,
-3.826534312288503819e-05,
-3.825023834472583386e-05,
-3.823380507230846520e-05,
-3.821604612635725852e-05,
-3.819696437047086105e-05,
-3.817656271094812479e-05,
-3.815484409661135454e-05,
-3.813181151862972515e-05,
-3.810746801034077449e-05,
-3.808181664707048681e-05,
-3.805486054595296966e-05,
-3.802660286574763022e-05,
-3.799704680665662282e-05,
-3.796619561013968752e-05,
-3.793405255872869054e-05,
-3.790062097584093143e-05,
-3.786590422559055289e-05,
-3.782990571259976082e-05,
-3.779262888180826225e-05,
-3.775407721828165293e-05,
-3.771425424701849036e-05,
-3.767316353275689238e-05,
-3.763080867977940119e-05,
-3.758719333171660039e-05,
-3.754232117135019681e-05,
-3.749619592041501803e-05,
-3.744882133939888907e-05,
-3.740020122734271897e-05,
-3.735033942163888671e-05,
-3.729923979782845465e-05,
-3.724690626939756901e-05,
-3.719334278757299283e-05,
-3.713855334111611434e-05,
-3.708254195611651491e-05,
-3.702531269578359209e-05,
-3.696686966023811507e-05,
-3.690721698630285158e-05,
-3.684635884729119598e-05,
-3.678429945279568881e-05,
-3.672104304847539121e-05,
-3.665659391584187696e-05,
-3.659095637204473660e-05,
-3.652413476965642435e-05,
-3.645613349645506526e-05,
-3.638695697520760123e-05,
-3.631660966345107356e-05,
-3.624509605327396649e-05,
-3.617242067109475209e-05,
-3.609858807744277304e-05,
-3.602360286673441585e-05,
-3.594746966705206914e-05,
-3.587019313991897553e-05,
-3.579177798007636706e-05,
-3.571222891525629778e-05,
-3.563155070595697669e-05,
-3.554974814521563421e-05,
-3.546682605837993843e-05,
-3.538278930288024491e-05,
-3.529764276800040991e-05,
-3.521139137464642839e-05,
-3.512404007511674581e-05,
-3.503559385287060478e-05,
-3.494605772229446723e-05,
-3.485543672847070667e-05,
-3.476373594694198395e-05,
-3.467096048347729001e-05,
-3.457711547383739901e-05,
-3.448220608353755686e-05,
-3.438623750761184340e-05,
-3.428921497037548140e-05,
-3.419114372518656283e-05,
-3.409202905420671121e-05,
-3.399187626816404113e-05,
-3.389069070611016823e-05,
-3.378847773518211839e-05,
-3.368524275035904633e-05,
-3.358099117422232198e-05,
-3.347572845671053468e-05,
-3.336946007487949148e-05,
-3.326219153265589994e-05,
-3.315392836059495411e-05,
-3.304467611563422739e-05,
-3.293444038084974735e-05,
-3.282322676520823526e-05,
-3.271104090332221188e-05,
-3.259788845520339570e-05,
-3.248377510601324831e-05,
-3.236870656581705707e-05,
-3.225268856933483964e-05,
-3.213572687569119819e-05,
-3.201782726816760635e-05,
-3.189899555395216851e-05,
-3.177923756388845768e-05,
-3.165855915222595245e-05,
-3.153696619636775668e-05,
-3.141446459661879356e-05,
-3.129106027593559207e-05,
-3.116675917967164181e-05,
-3.104156727532612231e-05,
-3.091549055229013876e-05,
-3.078853502159270702e-05,
-3.066070671564654205e-05,
-3.053201168799575733e-05,
-3.040245601305837357e-05,
-3.027204578587398763e-05,
-3.014078712184599669e-05,
-3.000868615648847427e-05,
-2.987574904516730344e-05,
-2.974198196284626682e-05,
-2.960739110383007712e-05,
-2.947198268150718746e-05,
-2.933576292809198839e-05,
-2.919873809436979338e-05,
-2.906091444943594593e-05,
-2.892229828044059155e-05,
-2.878289589233058349e-05,
-2.864271360758929790e-05,
-2.850175776598046733e-05,
-2.836003472428799259e-05,
-2.821755085605663884e-05,
-2.807431255133525922e-05,
-2.793032621641609167e-05,
-2.778559827357468599e-05,
-2.764013516081242268e-05,
-2.749394333159515250e-05,
-2.734702925459331322e-05,
-2.719939941342441463e-05,
-2.705106030638993318e-05,
-2.690201844621788852e-05,
-2.675228035980021583e-05,
-2.660185258793539654e-05,
-2.645074168506421461e-05,
-2.629895421901388473e-05,
-2.614649677073380520e-05,
-2.599337593403773126e-05,
-2.583959831534102207e-05,
-2.568517053340283436e-05,
-2.553009921906197017e-05,
-2.537439101497928053e-05,
-2.521805257537656250e-05,
-2.506109056577553071e-05,
-2.490351166273647719e-05,
-2.474532255360027873e-05,
-2.458652993622448846e-05,
-2.442714051872582094e-05,
-2.426716101921969968e-05,
-2.410659816555775484e-05,
-2.394545869507050818e-05,
-2.378374935430530447e-05,
-2.362147689876585899e-05,
-2.345864809265536265e-05,
-2.329526970861445738e-05,
-2.313134852746119027e-05,
-2.296689133793368832e-05,
-2.280190493642827624e-05,
-2.263639612674341831e-05,
-2.247037171981685025e-05,
-2.230383853346973454e-05,
-2.213680339214814605e-05,
-2.196927312666208077e-05,
-2.180125457392975358e-05,
-2.163275457671906679e-05,
-2.146377998338756430e-05,
-2.129433764762761697e-05,
-2.112443442820884665e-05,
-2.095407718871895107e-05,
-2.078327279730956347e-05,
-2.061202812643770082e-05,
-2.044035005260891300e-05,
-2.026824545612481953e-05,
-2.009572122082317884e-05,
-1.992278423382543863e-05,
-1.974944138528079296e-05,
-1.957569956811059514e-05,
-1.940156567775348217e-05,
-1.922704661191454792e-05,
-1.905214927030744870e-05,
-1.887688055440437271e-05,
-1.870124736718004635e-05,
-1.852525661286237785e-05,
-1.834891519667597237e-05,
-1.817223002459377170e-05,
-1.799520800308471643e-05,
-1.781785603886230928e-05,
-1.764018103863261602e-05,
-1.746218990884743327e-05,
-1.728388955544989407e-05,
-1.710528688362864870e-05,
-1.692638879756865405e-05,
-1.674720220020020457e-05,
-1.656773399295423456e-05,
-1.638799107551217919e-05,
-1.620798034555883405e-05,
-1.602770869853862304e-05,
-1.584718302740742118e-05,
-1.566641022238606117e-05,
-1.548539717071813624e-05,
-1.530415075642301549e-05,
-1.512267786005164933e-05,
-1.494098535844642385e-05,
-1.475908012449409821e-05,
-1.457696902688660254e-05,
-1.439465892987799030e-05,
-1.421215669304296277e-05,
-1.402946917103519525e-05,
-1.384660321335127581e-05,
-1.366356566408647518e-05,
-1.348036336169977977e-05,
-1.329700313877223832e-05,
-1.311349182177320447e-05,
-1.292983623081866644e-05,
-1.274604317943864158e-05,
-1.256211947434076103e-05,
-1.237807191517469630e-05,
-1.219390729429639614e-05,
-1.200963239653789849e-05,
-1.182525399896950913e-05,
-1.164077887067119590e-05,
-1.145621377250057962e-05,
-1.127156545685922414e-05,
-1.108684066746581107e-05,
-1.090204613912394776e-05,
-1.071718859749296523e-05,
-1.053227475886297502e-05,
-1.034731132992496245e-05,
-1.016230500754335315e-05,
-9.977262478532865684e-06,
-9.792190419430813771e-06,
-9.607095496272283466e-06,
-9.421984364370238302e-06,
-9.236863668087909684e-06,
-9.051740040620555463e-06,
-8.866620103770735315e-06,
-8.681510467731490640e-06,
-8.496417730861525073e-06,
-8.311348479472294284e-06,
-8.126309287604658639e-06,
-7.941306716815481714e-06,
-7.756347315957696500e-06,
-7.571437620968535307e-06,
-7.386584154649924615e-06,
-7.201793426458470873e-06,
-7.017071932291848962e-06,
-6.832426154274008185e-06,
-6.647862560546742027e-06,
-6.463387605058422042e-06,
-6.279007727351578086e-06,
-6.094729352357750321e-06,
-5.910558890189114880e-06,
-5.726502735928916053e-06,
-5.542567269428886503e-06,
-5.358758855101453138e-06,
-5.175083841715077019e-06,
-4.991548562194799960e-06,
-4.808159333415089077e-06,
-4.624922456001809798e-06,
-4.441844214130421960e-06,
-4.258930875325916552e-06,
-4.076188690263356400e-06,
-3.893623892574035218e-06,
-3.711242698644000656e-06,
-3.529051307422225055e-06,
-3.347055900222299362e-06,
-3.165262640532555452e-06,
-2.983677673818009492e-06,
-2.802307127334631336e-06,
-2.621157109933241574e-06,
-2.440233711873597538e-06,
-2.259543004632077439e-06,
-2.079091040717726835e-06,
-1.898883853480690478e-06,
-1.718927456930304158e-06,
-1.539227845549882901e-06,
-1.359790994110375839e-06,
-1.180622857490685532e-06,
-1.001729370495117759e-06,
-8.231164476701934886e-07,
-6.447899831284926051e-07,
-4.667558503697162356e-07,
-2.890199021006317412e-07,
-1.115879700621159867e-07,
 6.553413514875661085e-08,
 2.423406242533919959e-07,
 4.188257294610106690e-07,
 5.949837046454449168e-07,
 7.708088255127391433e-07,
 9.462953897723443870e-07,
 1.121437717306370856e-06,
 1.296230150338159768e-06,
 1.470667053595075139e-06,
 1.644742814478691551e-06,
 1.818451843225367247e-06,
 1.991788573072934707e-06,
 2.164747460419015343e-06,
 2.337322984986742554e-06,
 2.509509649980827757e-06,
 2.681301982247215299e-06,
 2.852694532431100262e-06,
 3.023681875134739602e-06,
 3.194258609069374275e-06,
 3.364419357214090274e-06,
 3.534158766965082771e-06,
 3.703471510287963654e-06,
 3.872352283871004184e-06,
 4.040795809271372273e-06,
 4.208796833066042412e-06,
 4.376350126999426738e-06,
 4.543450488126117025e-06,
 4.710092738958259105e-06,
 4.876271727610091408e-06,
 5.041982327937555483e-06,
 5.207219439682118796e-06,
 5.371977988611340702e-06,
 5.536252926654062284e-06,
 5.700039232042755331e-06,
 5.863331909446321847e-06,
 6.026125990108750813e-06,
 6.188416531979610384e-06,
 6.350198619851843206e-06,
 6.511467365487804081e-06,
 6.672217907754643773e-06,
 6.832445412749991763e-06,
 6.992145073933239581e-06,
 7.151312112248778165e-06,
 7.309941776256052997e-06,
 7.468029342250372178e-06,
 7.625570114386874781e-06,
 7.782559424802884760e-06,
 7.938992633739787977e-06,
 8.094865129659387432e-06,
 8.250172329366438427e-06,
 8.404909678122115412e-06,
 8.559072649760172391e-06,
 8.712656746803802967e-06,
 8.865657500575736000e-06,
 9.018070471312618930e-06,
 9.169891248276180689e-06,
 9.321115449859551278e-06,
 9.471738723698001157e-06,
 9.621756746776539843e-06,
 9.771165225533018454e-06,
 9.919959895964938868e-06,
 1.006813652373300689e-05,
 1.021569090425964897e-05,
 1.036261886283389517e-05,
 1.050891625470748699e-05,
 1.065457896519577753e-05,
 1.079960290977150490e-05,
 1.094398403416473696e-05,
 1.108771831445203512e-05,
 1.123080175715398342e-05,
 1.137323039932354420e-05,
 1.151500030863975353e-05,
 1.165610758349336807e-05,
 1.179654835307897482e-05,
 1.193631877747840527e-05,
 1.207541504774645677e-05,
 1.221383338599714935e-05,
 1.235157004548413281e-05,
 1.248862131068278115e-05,
 1.262498349737275632e-05,
 1.276065295271404631e-05,
 1.289562605532508193e-05,
 1.302989921536115174e-05,
 1.316346887458679457e-05,
 1.329633150645173602e-05,
 1.342848361616370449e-05,
 1.355992174075666306e-05,
 1.369064244916441500e-05,
 1.382064234228673668e-05,
 1.394991805305760607e-05,
 1.407846624651175076e-05,
 1.420628361985013882e-05,
 1.433336690250032485e-05,
 1.445971285618254562e-05,
 1.458531827496751316e-05,
 1.471017998533879870e-05,
 1.483429484624811347e-05,
 1.495765974917623744e-05,
 1.508027161818546932e-05,
 1.520212740997507670e-05,
 1.532322411393468456e-05,
 1.544355875219714365e-05,
 1.556312837968662168e-05,
 1.568193008417141068e-05,
 1.579996098630915354e-05,
 1.591721823969386105e-05,
 1.603369903090322721e-05,
 1.614940057954072339e-05,
 1.626432013827868174e-05,
 1.637845499290346924e-05,
 1.649180246234997204e-05,
 1.660435989874440793e-05,
 1.671612468744200912e-05,
 1.682709424706155409e-05,
 1.693726602952234906e-05,
 1.704663752007838710e-05,
 1.715520623734827555e-05,
 1.726296973334999818e-05,
 1.736992559352839641e-05,
 1.747607143678500853e-05,
 1.758140491550580156e-05,
 1.768592371558803578e-05,
 1.778962555646259588e-05,
 1.789250819112083514e-05,
 1.799456940613454507e-05,
 1.809580702167926238e-05,
 1.819621889155157555e-05,
 1.829580290319101214e-05,
 1.839455697769471623e-05,
 1.849247906983420608e-05,
 1.858956716807035983e-05,
 1.868581929456809631e-05,
 1.878123350520603119e-05,
 1.887580788959099173e-05,
 1.896954057106507090e-05,
 1.906242970671462284e-05,
 1.915447348737898733e-05,
 1.924567013765472831e-05,
 1.933601791590164784e-05,
 1.942551511424682134e-05,
 1.951416005858473652e-05,
 1.960195110858001407e-05,
 1.968888665766764816e-05,
 1.977496513304982504e-05,
 1.986018499569497774e-05,
 1.994454474033385580e-05,
 2.002804289545245090e-05,
 2.011067802328814113e-05,
 2.019244871982018053e-05,
 2.027335361476271614e-05,
 2.035339137155255004e-05,
 2.043256068734108244e-05,
 2.051086029297814682e-05,
 2.058828895300142888e-05,
 2.066484546561956308e-05,
 2.074052866269771617e-05,
 2.081533740973832904e-05,
 2.088927060586533822e-05,
 2.096232718380204116e-05,
 2.103450610985089963e-05,
 2.110580638387247568e-05,
 2.117622703926080668e-05,
 2.124576714291940722e-05,
 2.131442579523668481e-05,
 2.138220213005790986e-05,
 2.144909531465678587e-05,
 2.151510454970810720e-05,
 2.158022906925539564e-05,
 2.164446814068080027e-05,
 2.170782106467260186e-05,
 2.177028717518956293e-05,
 2.183186583942755131e-05,
 2.189255645778323967e-05,
 2.195235846381582643e-05,
 2.201127132420952569e-05,
 2.206929453873427514e-05,
 2.212642764020308623e-05,
 2.218267019443251483e-05,
 2.223802180019767021e-05,
 2.229248208918961272e-05,
 2.234605072596852976e-05,
 2.239872740791926320e-05,
 2.245051186520152415e-05,
 2.250140386070312656e-05,
 2.255140318998893491e-05,
 2.260050968125086208e-05,
 2.264872319525502813e-05,
 2.269604362528977273e-05,
 2.274247089711057437e-05,
 2.278800496888460351e-05,
 2.283264583113537075e-05,
 2.287639350668438991e-05,
 2.291924805059266165e-05,
 2.296120955010145907e-05,
 2.300227812457197152e-05,
 2.304245392542205500e-05,
 2.308173713606504921e-05,
 2.312012797184468145e-05,
 2.315762667997103085e-05,
 2.319423353945349424e-05,
 2.322994886103497169e-05,
 2.326477298712278585e-05,
 2.329870629171963863e-05,
 2.333174918035359882e-05,
 2.336390209000734102e-05,
 2.339516548904475523e-05,
 2.342553987713908125e-05,
 2.345502578519764131e-05,
 2.348362377528641687e-05,
 2.351133444055462541e-05,
 2.353815840515641395e-05,
 2.356409632417335551e-05,
 2.358914888353495678e-05,
 2.361331679993769532e-05,
 2.363660082076426343e-05,
 2.365900172400159230e-05,
 2.368052031815677216e-05,
 2.370115744217360932e-05,
 2.372091396534726224e-05,
 2.373979078723741724e-05,
 2.375778883758215541e-05,
 2.377490907620903449e-05,
 2.379115249294684158e-05,
 2.380652010753467942e-05,
 2.382101296953253661e-05,
 2.383463215822764647e-05,
 2.384737878254324464e-05,
 2.385925398094386737e-05,
 2.387025892134153081e-05,
 2.388039480099941658e-05,
 2.388966284643639080e-05,
 2.389806431332901934e-05,
 2.390560048641332216e-05,
 2.391227267938589069e-05,
 2.391808223480409038e-05,
 2.392303052398456927e-05,
 2.392711894690223060e-05,
 2.393034893208719301e-05,
 2.393272193652108318e-05,
 2.393423944553323704e-05,
 2.393490297269499682e-05,
 2.393471405971395730e-05,
 2.393367427632713126e-05,
 2.393178522019268506e-05,
 2.392904851678197929e-05,
 2.392546581926992873e-05,
 2.392103880842453919e-05,
 2.391576919249628153e-05,
 2.390965870710606991e-05,
 2.390270911513241666e-05,
 2.389492220659819414e-05,
 2.388629979855643099e-05,
 2.387684373497507835e-05,
 2.386655588662116968e-05,
 2.385543815094455018e-05,
 2.384349245196004780e-05,
 2.383072074012966785e-05,
 2.381712499224361877e-05,
 2.380270721130055183e-05,
 2.378746942638718082e-05,
 2.377141369255730878e-05,
 2.375454209070969943e-05,
 2.373685672746560633e-05,
 2.371835973504540429e-05,
 2.369905327114455319e-05,
 2.367893951880875551e-05,
 2.365802068630852432e-05,
 2.363629900701291774e-05,
 2.361377673926277882e-05,
 2.359045616624309098e-05,
 2.356633959585465260e-05,
 2.354142936058544993e-05,
 2.351572781738052575e-05,
 2.348923734751219022e-05,
 2.346196035644875104e-05,
 2.343389927372313195e-05,
 2.340505655280062031e-05,
 2.337543467094591349e-05,
 2.334503612908945364e-05,
 2.331386345169361344e-05,
 2.328191918661771969e-05,
 2.324920590498261278e-05,
 2.321572620103479949e-05,
 2.318148269200976565e-05,
 2.314647801799475337e-05,
 2.311071484179094541e-05,
 2.307419584877514469e-05,
 2.303692374676077957e-05,
 2.299890126585827898e-05,
 2.296013115833513572e-05,
 2.292061619847485522e-05,
 2.288035918243628368e-05,
 2.283936292811136409e-05,
 2.279763027498289574e-05,
 2.275516408398186671e-05,
 2.271196723734400383e-05,
 2.266804263846520441e-05,
 2.262339321175831994e-05,
 2.257802190250726655e-05,
 2.253193167672166395e-05,
 2.248512552099131857e-05,
 2.243760644233930063e-05,
 2.238937746807496357e-05,
 2.234044164564716006e-05,
 2.229080204249561135e-05,
 2.224046174590296461e-05,
 2.218942386284580311e-05,
 2.213769151984532456e-05,
 2.208526786281750771e-05,
 2.203215605692341117e-05,
 2.197835928641778824e-05,
 2.192388075449905373e-05,
 2.186872368315656386e-05,
 2.181289131301998672e-05,
 2.175638690320576908e-05,
 2.169921373116537181e-05,
 2.164137509253184169e-05,
 2.158287430096642056e-05,
 2.152371468800409729e-05,
 2.146389960290039312e-05,
 2.140343241247542622e-05,
 2.134231650095986697e-05,
 2.128055526983953444e-05,
 2.121815213769892913e-05,
 2.115511054006619882e-05,
 2.109143392925587503e-05,
 2.102712577421207707e-05,
 2.096218956035237677e-05,
 2.089662878940965742e-05,
 2.083044697927429798e-05,
 2.076364766383668933e-05,
 2.069623439282864257e-05,
 2.062821073166416720e-05,
 2.055958026128188910e-05,
 2.049034657798457502e-05,
 2.042051329328059515e-05,
 2.035008403372327824e-05,
 2.027906244075206241e-05,
 2.020745217053060346e-05,
 2.013525689378813913e-05,
 2.006248029565710272e-05,
 1.998912607551331849e-05,
 1.991519794681377112e-05,
 1.984069963693618104e-05,
 1.976563488701615391e-05,
 1.969000745178610203e-05,
 1.961382109941329843e-05,
 1.953707961133661634e-05,
 1.945978678210504747e-05,
 1.938194641921472605e-05,
 1.930356234294522112e-05,
 1.922463838619768546e-05,
 1.914517839433135788e-05,
 1.906518622499943537e-05,
 1.898466574798666977e-05,
 1.890362084504488413e-05,
 1.882205540972878047e-05,
 1.873997334723369567e-05,
 1.865737857422948481e-05,
 1.857427501869769764e-05,
 1.849066661976682060e-05,
 1.840655732754759662e-05,
 1.832195110296811456e-05,
 1.823685191761068768e-05,
 1.815126375354541159e-05,
 1.806519060316660224e-05,
 1.797863646902665206e-05,
 1.789160536367261702e-05,
 1.780410130947906311e-05,
 1.771612833848529712e-05,
 1.762769049222837241e-05,
 1.753879182157905923e-05,
 1.744943638657549433e-05,
 1.735962825625933078e-05,
 1.726937150850846940e-05,
 1.717867022987333740e-05,
 1.708752851541130361e-05,
 1.699595046852034154e-05,
 1.690394020077466434e-05,
 1.681150183175921455e-05,
 1.671863948890303918e-05,
 1.662535730731544304e-05,
 1.653165942962043442e-05,
 1.643755000579026287e-05,
 1.634303319298180624e-05,
 1.624811315536986783e-05,
 1.615279406398197791e-05,
 1.605708009653492309e-05,
 1.596097543726745393e-05,
 1.586448427677683131e-05,
 1.576761081185333992e-05,
 1.567035924531503887e-05,
 1.557273378584253949e-05,
 1.547473864781619878e-05,
 1.537637805114907099e-05,
 1.527765622112435182e-05,
 1.517857738822912957e-05,
 1.507914578799205467e-05,
 1.497936566081667068e-05,
 1.487924125181926680e-05,
 1.477877681066443828e-05,
 1.467797659140105846e-05,
 1.457684485229793409e-05,
 1.447538585568187123e-05,
 1.437360386777206001e-05,
 1.427150315851847425e-05,
 1.416908800143883124e-05,
 1.406636267345419953e-05,
 1.396333145472803049e-05,
 1.385999862850220665e-05,
 1.375636848093454683e-05,
 1.365244530093824097e-05,
 1.354823338001849465e-05,
 1.344373701211039183e-05,
 1.333896049341878351e-05,
 1.323390812225551688e-05,
 1.312858419887807208e-05,
 1.302299302533071648e-05,
 1.291713890528113739e-05,
 1.281102614386189446e-05,
 1.270465904750942413e-05,
 1.259804192380390124e-05,
 1.249117908130890082e-05,
 1.238407482941406677e-05,
 1.227673347817340312e-05,
 1.216915933814824091e-05,
 1.206135672024679995e-05,
 1.195332993556785368e-05,
 1.184508329524003682e-05,
 1.173662111026608621e-05,
 1.162794769136494878e-05,
 1.151906734881412497e-05,
 1.140998439229219518e-05,
 1.130070313072396858e-05,
 1.119122787212162884e-05,
 1.108156292343087231e-05,
 1.097171259037500992e-05,
 1.086168117729825251e-05,
 1.075147298701251645e-05,
 1.064109232064147473e-05,
 1.053054347746589551e-05,
 1.041983075477171152e-05,
 1.030895844769490121e-05,
 1.019793084906782850e-05,
 1.008675224926811519e-05,
 9.975426936064558852e-06,
 9.863959194464877006e-06,
 9.752353306566170191e-06,
 9.640613551400839916e-06,
 9.528744204787876777e-06,
 9.416749539180357251e-06,
 9.304633823517478907e-06,
 9.192401323071813253e-06,
 9.080056299303519514e-06,
 8.967603009708400468e-06,
 8.855045707671638493e-06,
 8.742388642317743683e-06,
 8.629636058365221623e-06,
 8.516792195976455440e-06,
 8.403861290613386632e-06,
 8.290847572890793716e-06,
 8.177755268428994891e-06,
 8.064588597710186171e-06,
 7.951351775932936368e-06,
 7.838049012866245011e-06,
 7.724684512707476287e-06,
 7.611262473938566723e-06,
 7.497787089181416341e-06,
 7.384262545057384519e-06,
 7.270693022043545966e-06,
 7.157082694330919421e-06,
 7.043435729685557647e-06,
 6.929756289305138815e-06,
 6.816048527680886589e-06,
 6.702316592457180339e-06,
 6.588564624292186883e-06,
 6.474796756718737017e-06,
 6.361017116008632536e-06,
 6.247229821032179367e-06,
 6.133438983123528816e-06,
 6.019648705942142784e-06,
 5.905863085339135362e-06,
 5.792086209219025189e-06,
 5.678322157407190049e-06,
 5.564575001515090371e-06,
 5.450848804806159351e-06,
 5.337147622061865870e-06,
 5.223475499451135892e-06,
 5.109836474395393010e-06,
 4.996234575439402866e-06,
 4.882673822120103317e-06,
 4.769158224834579108e-06,
 4.655691784712203944e-06,
 4.542278493484839462e-06,
 4.428922333356677609e-06,
 4.315627276878344444e-06,
 4.202397286819125215e-06,
 4.089236316038654115e-06,
 3.976148307362718922e-06,
 3.863137193456065452e-06,
 3.750206896697139170e-06,
 3.637361329056045534e-06,
 3.524604391967867745e-06,
 3.411939976211584235e-06,
 3.299371961786785985e-06,
 3.186904217791437391e-06,
 3.074540602300088594e-06,
 2.962284962245597495e-06,
 2.850141133296198591e-06,
 2.738112939738512482e-06,
 2.626204194356701368e-06,
 2.514418698316729628e-06,
 2.402760241046049136e-06,
 2.291232600119179089e-06,
 2.179839541141053054e-06,
 2.068584817631273606e-06,
 1.957472170908511394e-06,
 1.846505329978235789e-06,
 1.735688011417616450e-06,
 1.625023919262481062e-06,
 1.514516744897550025e-06,
 1.404170166942085317e-06,
 1.293987851141493778e-06,
 1.183973450255115155e-06,
 1.074130603949209010e-06,
 9.644629386850627366e-07,
 8.549740676146555146e-07,
 7.456675904701764205e-07,
 6.365470934597509637e-07,
 5.276161491594079634e-07,
 4.188783164102114739e-07,
 3.103371402108453072e-07,
 2.019961516161545790e-07,
 9.385886763377096312e-08,
-1.407120887985109076e-08,
-1.217905893192894663e-07,
-2.292957994316432546e-07,
-3.365833794183395030e-07,
-4.436498840325718396e-07,
-5.504918826783609991e-07,
-6.571059595101858821e-07,
-7.634887135282474450e-07,
-8.696367586766381244e-07,
-9.755467239394675300e-07,
-1.081215253433690268e-06,
-1.186639006506335581e-06,
-1.291814657826114387e-06,
-1.396738897477108534e-06,
-1.501408431051205810e-06,
-1.605819979740030973e-06,
-1.709970280423336600e-06,
-1.813856085761725033e-06,
-1.917474164283543585e-06,
-2.020821300475335795e-06,
-2.123894294867226167e-06,
-2.226689964122856429e-06,
-2.329205141121998989e-06,
-2.431436675048983361e-06,
-2.533381431475018453e-06,
-2.635036292444089751e-06,
-2.736398156553769653e-06,
-2.837463939040303621e-06,
-2.938230571857904324e-06,
-3.038695003759765681e-06,
-3.138854200379595289e-06,
-3.238705144309056523e-06,
-3.338244835176744624e-06,
-3.437470289727350393e-06,
-3.536378541896539602e-06,
-3.634966642887346467e-06,
-3.733231661246981753e-06,
-3.831170682939380721e-06,
-3.928780811420458191e-06,
-4.026059167711330735e-06,
-4.123002890468281591e-06,
-4.219609136056849793e-06,
-4.315875078620500825e-06,
-4.411797910151173452e-06,
-4.507374840558520431e-06,
-4.602603097738638457e-06,
-4.697479927639311723e-06,
-4.792002594329335637e-06,
-4.886168380062160338e-06,
-4.979974585342869825e-06,
-5.073418528990297424e-06,
-5.166497548203035915e-06,
-5.259208998619991913e-06,
-5.351550254382690228e-06,
-5.443518708196553308e-06,
-5.535111771391841871e-06,
-5.626326873981242137e-06,
-5.717161464721026685e-06,
-5.807613011166785836e-06,
-5.897678999730726042e-06,
-5.987356935739235094e-06,
-6.076644343486445941e-06,
-6.165538766290217101e-06,
-6.254037766546213173e-06,
-6.342138925778936028e-06,
-6.429839844695381809e-06,
-6.517138143236806501e-06,
-6.604031460627693751e-06,
-6.690517455426898720e-06,
-6.776593805576725172e-06,
-6.862258208449132812e-06,
-6.947508380895431866e-06,
-7.032342059290811599e-06,
-7.116756999581770778e-06,
-7.200750977329073245e-06,
-7.284321787754370315e-06,
-7.367467245780485652e-06,
-7.450185186076384258e-06,
-7.532473463096870360e-06,
-7.614329951125164369e-06,
-7.695752544310966849e-06,
-7.776739156711943648e-06,
-7.857287722330266052e-06,
-7.937396195150590896e-06,
-8.017062549176968330e-06,
-8.096284778469479382e-06,
-8.175060897177658186e-06,
-8.253388939577119380e-06,
-8.331266960101213416e-06,
-8.408693033373872814e-06,
-8.485665254242844642e-06,
-8.562181737809004641e-06,
-8.638240619457924441e-06,
-8.713840054889521110e-06,
-8.788978220145060558e-06,
-8.863653311636210771e-06,
-8.937863546172551744e-06,
-9.011607160986285131e-06,
-9.084882413758905612e-06,
-9.157687582645996941e-06,
-9.230020966299256493e-06,
-9.301880883891684333e-06,
-9.373265675137930637e-06,
-9.444173700317411228e-06,
-9.514603340292949069e-06,
-9.584552996532990249e-06,
-9.654021091127875485e-06,
-9.723006066810289187e-06,
-9.791506386970971927e-06,
-9.859520535676753763e-06,
-9.927047017684755597e-06,
-9.994084358459280707e-06,
-1.006063110418440504e-05,
-1.012668582177755855e-05,
-1.019224709890322000e-05,
-1.025731354398342191e-05,
-1.032188378620919052e-05,
-1.038595647555174365e-05,
-1.044953028277051031e-05,
-1.051260389942204836e-05,
-1.057517603786881968e-05,
-1.063724543128492975e-05,
-1.069881083366342730e-05,
-1.075987101982201509e-05,
-1.082042478540611778e-05,
-1.088047094689476888e-05,
-1.094000834160236573e-05,
-1.099903582768154611e-05,
-1.105755228412500252e-05,
-1.111555661076649184e-05,
-1.117304772827958517e-05,
-1.123002457817852496e-05,
-1.128648612281541798e-05,
-1.134243134537914943e-05,
-1.139785924989093937e-05,
-1.145276886120225397e-05,
-1.150715922498889320e-05,
-1.156102940774580530e-05,
-1.161437849678122871e-05,
-1.166720560021030543e-05,
-1.171950984694617531e-05,
-1.177129038669325742e-05,
-1.182254638993682810e-05,
-1.187327704793321745e-05,
-1.192348157270005147e-05,
-1.197315919700379226e-05,
-1.202230917434799809e-05,
-1.207093077896118712e-05,
-1.211902330578208720e-05,
-1.216658607044537520e-05,
-1.221361840926753156e-05,
-1.226011967922964383e-05,
-1.230608925796179077e-05,
-1.235152654372581371e-05,
-1.239643095539603636e-05,
-1.244080193244185154e-05,
-1.248463893490737035e-05,
-1.252794144339125599e-05,
-1.257070895902612057e-05,
-1.261294100345693590e-05,
-1.265463711881757241e-05,
-1.269579686770896936e-05,
-1.273641983317414234e-05,
-1.277650561867479497e-05,
-1.281605384806466109e-05,
-1.285506416556505429e-05,
-1.289353623573698530e-05,
-1.293146974345408062e-05,
-1.296886439387451869e-05,
-1.300571991241262201e-05,
-1.304203604470853344e-05,
-1.307781255659910363e-05,
-1.311304923408608326e-05,
-1.314774588330464220e-05,
-1.318190233049179721e-05,
-1.321551842195254927e-05,
-1.324859402402703222e-05,
-1.328112902305609955e-05,
-1.331312332534562531e-05,
-1.334457685713147085e-05,
-1.337548956454335208e-05,
-1.340586141356709231e-05,
-1.343569239000753911e-05,
-1.346498249945053765e-05,
-1.349373176722269493e-05,
-1.352194023835308710e-05,
-1.354960797753199712e-05,
-1.357673506907069084e-05,
-1.360332161685897898e-05,
-1.362936774432406993e-05,
-1.365487359438648678e-05,
-1.367983932941739552e-05,
-1.370426513119377833e-05,
-1.372815120085429130e-05,
-1.375149775885301479e-05,
-1.377430504491427092e-05,
-1.379657331798531854e-05,
-1.381830285618886176e-05,
-1.383949395677576688e-05,
-1.386014693607583452e-05,
-1.388026212944881572e-05,
-1.389983989123508241e-05,
-1.391888059470451411e-05,
-1.393738463200573347e-05,
-1.395535241411474396e-05,
-1.397278437078218169e-05,
-1.398968095048100947e-05,
-1.400604262035310797e-05,
-1.402186986615466410e-05,
-1.403716319220204736e-05,
-1.405192312131688646e-05,
-1.406615019476963834e-05,
-1.407984497222373819e-05,
-1.409300803167881434e-05,
-1.410563996941250900e-05,
-1.411774139992320523e-05,
-1.412931295587089054e-05,
-1.414035528801840156e-05,
-1.415086906517111360e-05,
-1.416085497411741291e-05,
-1.417031371956709024e-05,
-1.417924602409053067e-05,
-1.418765262805631776e-05,
-1.419553428956931038e-05,
-1.420289178440689160e-05,
-1.420972590595620357e-05,
-1.421603746514952904e-05,
-1.422182729039972548e-05,
-1.422709622753539819e-05,
-1.423184513973487583e-05,
-1.423607490746025704e-05,
-1.423978642839077772e-05,
-1.424298061735542787e-05,
-1.424565840626517376e-05,
-1.424782074404510710e-05,
-1.424946859656528662e-05,
-1.425060294657195887e-05,
-1.425122479361761711e-05,
-1.425133515399070262e-05,
-1.425093506064518407e-05,
-1.425002556312921193e-05,
-1.424860772751354593e-05,
-1.424668263631940810e-05,
-1.424425138844613944e-05,
-1.424131509909761647e-05,
-1.423787489970923020e-05,
-1.423393193787361318e-05,
-1.422948737726639709e-05,
-1.422454239757111650e-05,
-1.421909819440407533e-05,
-1.421315597923849167e-05,
-1.420671697932810048e-05,
-1.419978243763070550e-05,
-1.419235361273099253e-05,
-1.418443177876293609e-05,
-1.417601822533197406e-05,
-1.416711425743653347e-05,
-1.415772119538917681e-05,
-1.414784037473747391e-05,
-1.413747314618428425e-05,
-1.412662087550782251e-05,
-1.411528494348110063e-05,
-1.410346674579111407e-05,
-1.409116769295767407e-05,
-1.407838921025161135e-05,
-1.406513273761285447e-05,
-1.405139972956804403e-05,
-1.403719165514760814e-05,
-1.402250999780270406e-05,
-1.400735625532159062e-05,
-1.399173193974581604e-05,
-1.397563857728580431e-05,
-1.395907770823627044e-05,
-1.394205088689116148e-05,
-1.392455968145840768e-05,
-1.390660567397405201e-05,
-1.388819046021641012e-05,
-1.386931564961937658e-05,
-1.384998286518592241e-05,
-1.383019374340087954e-05,
-1.380994993414360828e-05,
-1.378925310060021937e-05,
-1.376810491917553667e-05,
-1.374650707940470257e-05,
-1.372446128386453932e-05,
-1.370196924808432435e-05,
-1.367903270045676872e-05,
-1.365565338214827402e-05,
-1.363183304700889787e-05,
-1.360757346148231764e-05,
-1.358287640451533523e-05,
-1.355774366746677182e-05,
-1.353217705401681000e-05,
-1.350617838007536168e-05,
-1.347974947369049711e-05,
-1.345289217495659091e-05,
-1.342560833592212761e-05,
-1.339789982049708368e-05,
-1.336976850436059588e-05,
-1.334121627486762158e-05,
-1.331224503095604129e-05,
-1.328285668305292771e-05,
-1.325305315298112811e-05,
-1.322283637386502855e-05,
-1.319220829003668233e-05,
-1.316117085694107270e-05,
-1.312972604104185165e-05,
-1.309787581972607754e-05,
-1.306562218120952524e-05,
-1.303296712444106292e-05,
-1.299991265900727274e-05,
-1.296646080503685131e-05,
-1.293261359310445963e-05,
-1.289837306413482705e-05,
-1.286374126930631323e-05,
-1.282872026995437853e-05,
-1.279331213747478681e-05,
-1.275751895322715208e-05,
-1.272134280843730102e-05,
-1.268478580410057060e-05,
-1.264785005088391142e-05,
-1.261053766902879739e-05,
-1.257285078825291402e-05,
-1.253479154765280043e-05,
-1.249636209560553257e-05,
-1.245756458967060968e-05,
-1.241840119649132239e-05,
-1.237887409169679334e-05,
-1.233898545980259995e-05,
-1.229873749411257273e-05,
-1.225813239661997538e-05,
-1.221717237790777851e-05,
-1.217585965705020052e-05,
-1.213419646151322699e-05,
-1.209218502705475563e-05,
-1.204982759762563915e-05,
-1.200712642527018427e-05,
-1.196408377002568176e-05,
-1.192070189982339000e-05,
-1.187698309038812767e-05,
-1.183292962513814941e-05,
-1.178854379508574814e-05,
-1.174382789873619391e-05,
-1.169878424198821092e-05,
-1.165341513803322800e-05,
-1.160772290725499846e-05,
-1.156170987712889123e-05,
-1.151537838212213414e-05,
-1.146873076359224955e-05,
-1.142176936968711971e-05,
-1.137449655524374262e-05,
-1.132691468168799417e-05,
-1.127902611693305020e-05,
-1.123083323527922830e-05,
-1.118233841731293334e-05,
-1.113354404980563021e-05,
-1.108445252561270464e-05,
-1.103506624357308139e-05,
-1.098538760840726005e-05,
-1.093541903061713819e-05,
-1.088516292638489428e-05,
-1.083462171747128606e-05,
-1.078379783111546018e-05,
-1.073269369993332514e-05,
-1.068131176181627158e-05,
-1.062965445983099705e-05,
-1.057772424211785364e-05,
-1.052552356178963427e-05,
-1.047305487683121116e-05,
-1.042032064999794779e-05,
-1.036732334871471394e-05,
-1.031406544497572062e-05,
-1.026054941524253227e-05,
-1.020677774034415921e-05,
-1.015275290537532894e-05,
-1.009847739959664136e-05,
-1.004395371633261642e-05,
-9.989184352872384638e-06,
-9.934171810367785647e-06,
-9.878918593733770646e-06,
-9.823427211546985468e-06,
-9.767700175946281480e-06,
-9.711740002531117362e-06,
-9.655549210262264826e-06,
-9.599130321361358981e-06,
-9.542485861210113265e-06,
-9.485618358251031944e-06,
-9.428530343887141734e-06,
-9.371224352381416804e-06,
-9.313702920757855496e-06,
-9.255968588701730333e-06,
-9.198023898459097724e-06,
-9.139871394738386293e-06,
-9.081513624610204732e-06,
-9.022953137407908612e-06,
-8.964192484629383517e-06,
-8.905234219837349270e-06,
-8.846080898560023298e-06,
-8.786735078193281547e-06,
-8.727199317901135502e-06,
-8.667476178517132467e-06,
-8.607568222447024706e-06,
-8.547478013569068580e-06,
-8.487208117137132451e-06,
-8.426761099681565024e-06,
-8.366139528912553975e-06,
-8.305345973620928226e-06,
-8.244383003582358516e-06,
-8.183253189458508661e-06,
-8.121959102700900701e-06,
-8.060503315452955536e-06,
-7.998888400454152848e-06,
-7.937116930942007362e-06,
-7.875191480556620091e-06,
-7.813114623244291074e-06,
-7.750888933160513767e-06,
-7.688516984574959975e-06,
-7.626001351775381423e-06,
-7.563344608971258059e-06,
-7.500549330199428426e-06,
-7.437618089228823014e-06,
-7.374553459464549639e-06,
-7.311358013854282751e-06,
-7.248034324792887525e-06,
-7.184584964027791029e-06,
-7.121012502566128785e-06,
-7.057319510579317183e-06,
-6.993508557310410953e-06,
-6.929582210980173986e-06,
-6.865543038693727828e-06,
-6.801393606347233218e-06,
-6.737136478536295334e-06,
-6.672774218461890616e-06,
-6.608309387839307337e-06,
-6.543744546804962664e-06,
-6.479082253825755730e-06,
-6.414325065606069349e-06,
-6.349475536997549143e-06,
-6.284536220907820503e-06,
-6.219509668209529949e-06,
-6.154398427649328057e-06,
-6.089205045758714153e-06,
-6.023932066762442414e-06,
-5.958582032490061125e-06,
-5.893157482286228840e-06,
-5.827660952920657831e-06,
-5.762094978500356398e-06,
-5.696462090380049205e-06,
-5.630764817073703838e-06,
-5.565005684167559159e-06,
-5.499187214231509565e-06,
-5.433311926731222782e-06,
-5.367382337942021172e-06,
-5.301400960861037644e-06,
-5.235370305120476093e-06,
-5.169292876902587077e-06,
-5.103171178852093930e-06,
-5.037007709991598732e-06,
-4.970804965635773639e-06,
-4.904565437306151908e-06,
-4.838291612646055295e-06,
-4.771985975337445917e-06,
-4.705651005015213287e-06,
-4.639289177184708887e-06,
-4.572902963137025930e-06,
-4.506494829867235268e-06,
-4.440067239989918422e-06,
-4.373622651658005732e-06,
-4.307163518480360894e-06,
-4.240692289439770390e-06,
-4.174211408811092995e-06,
-4.107723316081253280e-06,
-4.041230445866843946e-06,
-3.974735227835052750e-06,
-3.908240086623402752e-06,
-3.841747441759117315e-06,
-3.775259707580980045e-06,
-3.708779293159354132e-06,
-3.642308602217397696e-06,
-3.575850033053969811e-06,
-3.509405978464784870e-06,
-3.442978825664532561e-06,
-3.376570956210725373e-06,
-3.310184745925999836e-06,
-3.243822564821433787e-06,
-3.177486777021876599e-06,
-3.111179740688543924e-06,
-3.044903807945070447e-06,
-2.978661324801340447e-06,
-2.912454631080273234e-06,
-2.846286060341835399e-06,
-2.780157939811371242e-06,
-2.714072590304354054e-06,
-2.648032326154760168e-06,
-2.582039455141228437e-06,
-2.516096278416180939e-06,
-2.450205090432364896e-06,
-2.384368178872734856e-06,
-2.318587824579320990e-06,
-2.252866301481645491e-06,
-2.187205876527602984e-06,
-2.121608809613320700e-06,
-2.056077353512826362e-06,
-1.990613753810302492e-06,
-1.925220248831316651e-06,
-1.859899069573744208e-06,
-1.794652439641236446e-06,
-1.729482575174964525e-06,
-1.664391684786535112e-06,
-1.599381969492874299e-06,
-1.534455622648481904e-06,
-1.469614829880963588e-06,
-1.404861769025376054e-06,
-1.340198610059256238e-06,
-1.275627515037949703e-06,
-1.211150638032036296e-06,
-1.146770125062153075e-06,
-1.082488114037271026e-06,
-1.018306734690843806e-06,
-9.542281085199710878e-07,
-8.902543487218015255e-07,
-8.263875601343361630e-07,
-7.626298391737098795e-07,
-6.989832737751242877e-07,
-6.354499433316156165e-07,
-5.720319186358712767e-07,
-5.087312618194472000e-07,
-4.455500262954725190e-07,
-3.824902567002777208e-07,
-3.195539888347248571e-07,
-2.567432496079552391e-07,
-1.940600569802213045e-07,
-1.315064199055783535e-07,
-6.908433827714173601e-08,
-6.795802871439582754e-09,
 5.535720470752680232e-08,
 1.173727120816574063e-07,
 1.792487561537736774e-07,
 2.409833831614232718e-07,
 3.025746487287260703e-07,
 3.640206179207551096e-07,
 4.253193652946031667e-07,
 4.864689749516357177e-07,
 5.474675405889767777e-07,
 6.083131655506686842e-07,
 6.690039628767349458e-07,
 7.295380553547482429e-07,
 7.899135755679503698e-07,
 8.501286659454289839e-07,
 9.101814788092998822e-07,
 9.700701764243819894e-07,
 1.029792931044428099e-06,
 1.089347924959520071e-06,
 1.148733350542840724e-06,
 1.207947410297249631e-06,
 1.266988316899775013e-06,
 1.325854293248425644e-06,
 1.384543572505563178e-06,
 1.443054398142295566e-06,
 1.501385023983092615e-06,
 1.559533714247895589e-06,
 1.617498743595774353e-06,
 1.675278397167371552e-06,
 1.732870970625587304e-06,
 1.790274770197762918e-06,
 1.847488112716836534e-06,
 1.904509325660705590e-06,
 1.961336747192977998e-06,
 2.017968726202504238e-06,
 2.074403622341018644e-06,
 2.130639806063139699e-06,
 2.186675658663011402e-06,
 2.242509572312909764e-06,
 2.298139950098927877e-06,
 2.353565206059147038e-06,
 2.408783765217655280e-06,
 2.463794063621745248e-06,
 2.518594548375641360e-06,
 2.573183677676146341e-06,
 2.627559920845437063e-06,
 2.681721758366097413e-06,
 2.735667681912958676e-06,
 2.789396194385899199e-06,
 2.842905809942093048e-06,
 2.896195054027954587e-06,
 2.949262463409156057e-06,
 3.002106586202714027e-06,
 3.054725981905856279e-06,
 3.107119221425796288e-06,
 3.159284887109610613e-06,
 3.211221572771865301e-06,
 3.262927883723475145e-06,
 3.314402436799513898e-06,
 3.365643860385298645e-06,
 3.416650794443830289e-06,
 3.467421890542230295e-06,
 3.517955811876505811e-06,
 3.568251233297473966e-06,
 3.618306841335610423e-06,
 3.668121334224060723e-06,
 3.717693421923770064e-06,
 3.767021826145546808e-06,
 3.816105280373762891e-06,
 3.864942529887502117e-06,
 3.913532331783751496e-06,
 3.961873454996910956e-06,
 4.009964680321029224e-06,
 4.057804800428972187e-06,
 4.105392619893167571e-06,
 4.152726955203748390e-06,
 4.199806634788781787e-06,
 4.246630499031346909e-06,
 4.293197400287546220e-06,
 4.339506202904529509e-06,
 4.385555783236483340e-06,
 4.431345029661199007e-06,
 4.476872842596713348e-06,
 4.522138134515610052e-06,
 4.567139829960088368e-06,
 4.611876865557067402e-06,
 4.656348190031120309e-06,
 4.700552764218612118e-06,
 4.744489561080753360e-06,
 4.788157565715010445e-06,
 4.831555775368315145e-06,
 4.874683199447634714e-06,
 4.917538859531329756e-06,
 4.960121789379774322e-06,
 5.002431034945596540e-06,
 5.044465654382218400e-06,
 5.086224718054219202e-06,
 5.127707308544807235e-06,
 5.168912520664920298e-06,
 5.209839461459900318e-06,
 5.250487250217348738e-06,
 5.290855018473898540e-06,
 5.330941910020542934e-06,
 5.370747080908983020e-06,
 5.410269699457119104e-06,
 5.449508946253051232e-06,
 5.488464014160028408e-06,
 5.527134108320382212e-06,
 5.565518446157890022e-06,
 5.603616257381895830e-06,
 5.641426783988786620e-06,
 5.678949280264292063e-06,
 5.716183012785083714e-06,
 5.753127260419931215e-06,
 5.789781314329349924e-06,
 5.826144477966822343e-06,
 5.862216067077408131e-06,
 5.897995409697789000e-06,
 5.933481846153965632e-06,
 5.968674729060630875e-06,
 6.003573423318008614e-06,
 6.038177306109331310e-06,
 6.072485766897830489e-06,
 6.106498207423363857e-06,
 6.140214041697550793e-06,
 6.173632696000366427e-06,
 6.206753608874221726e-06,
 6.239576231118649210e-06,
 6.272100025784989517e-06,
 6.304324468169304273e-06,
 6.336249045806109748e-06,
 6.367873258461242293e-06,
 6.399196618123435446e-06,
 6.430218648996748306e-06,
 6.460938887492114683e-06,
 6.491356882217805509e-06,
 6.521472193970363887e-06,
 6.551284395724859137e-06,
 6.580793072623731366e-06,
 6.609997821966972667e-06,
 6.638898253200128043e-06,
 6.667493987903296694e-06,
 6.695784659778339270e-06,
 6.723769914637296393e-06,
 6.751449410388255067e-06,
 6.778822817023021803e-06,
 6.805889816602504527e-06,
 6.832650103243157514e-06,
 6.859103383101530656e-06,
 6.885249374360169753e-06,
 6.911087807211246755e-06,
 6.936618423840737185e-06,
 6.961840978412596719e-06,
 6.986755237051362281e-06,
 7.011360977825115667e-06,
 7.035657990728420070e-06,
 7.059646077663543051e-06,
 7.083325052422180111e-06,
 7.106694740667073228e-06,
 7.129754979912064077e-06,
 7.152505619502967182e-06,
 7.174946520597496080e-06,
 7.197077556144200998e-06,
 7.218898610862311168e-06,
 7.240409581219900854e-06,
 7.261610375412445021e-06,
 7.282500913340772762e-06,
 7.303081126588752214e-06,
 7.323350958399773533e-06,
 7.343310363654294057e-06,
 7.362959308845503041e-06,
 7.382297772055809725e-06,
 7.401325742931882959e-06,
 7.420043222660490441e-06,
 7.438450223942713340e-06,
 7.456546770968550549e-06,
 7.474332899390909697e-06,
 7.491808656299555800e-06,
 7.508974100193796991e-06,
 7.525829300956125702e-06,
 7.542374339824161545e-06,
 7.558609309362868630e-06,
 7.574534313436769495e-06,
 7.590149467180819882e-06,
 7.605454896971666366e-06,
 7.620450740398671051e-06,
 7.635137146233752115e-06,
 7.649514274401409010e-06,
 7.663582295948651098e-06,
 7.677341393013908149e-06,
 7.690791758796076377e-06,
 7.703933597523239201e-06,
 7.716767124420317365e-06,
 7.729292565677532207e-06,
 7.741510158417430666e-06,
 7.753420150662288069e-06,
 7.765022801300834975e-06,
 7.776318380054873924e-06,
 7.787307167445022026e-06,
 7.797989454756927905e-06,
 7.808365544006380714e-06,
 7.818435747904722396e-06,
 7.828200389823384105e-06,
 7.837659803758624226e-06,
 7.846814334295414278e-06,
 7.855664336571285852e-06,
 7.864210176239872622e-06,
 7.872452229434189771e-06,
 7.880390882729137536e-06,
 7.888026533104565492e-06,
 7.895359587906979881e-06,
 7.902390464811627035e-06,
 7.909119591784222731e-06,
 7.915547407041981898e-06,
 7.921674359014805876e-06,
 7.927500906306058010e-06,
 7.933027517652515938e-06,
 7.938254671884784655e-06,
 7.943182857887076001e-06,
 7.947812574556493482e-06,
 7.952144330762393325e-06,
 7.956178645305289824e-06,
 7.959916046875313458e-06,
 7.963357074010679173e-06,
 7.966502275055610863e-06,
 7.969352208118250615e-06,
 7.971907441027914032e-06,
 7.974168551292653886e-06,
 7.976136126055693827e-06,
 7.977810762052583757e-06,
 7.979193065567171062e-06,
 7.980283652388002130e-06,
 7.981083147763917498e-06,
 7.981592186359951925e-06,
 7.981811412212350170e-06,
 7.981741478683835179e-06,
 7.981383048418229145e-06,
 7.980736793295216863e-06,
 7.979803394384428077e-06,
 7.978583541899702779e-06,
 7.977077935152724632e-06,
 7.975287282506547654e-06,
 7.973212301329141546e-06,
 7.970853717946159439e-06,
 7.968212267593958062e-06,
 7.965288694372211329e-06,
 7.962083751196088549e-06,
 7.958598199748532598e-06,
 7.954832810432112863e-06,
 7.950788362320739290e-06,
 7.946465643111005417e-06,
 7.941865449073526336e-06,
 7.936988585003824332e-06,
 7.931835864173229769e-06,
 7.926408108279326282e-06,
 7.920706147396478961e-06,
 7.914730819925778099e-06,
 7.908482972545120151e-06,
 7.901963460158860093e-06,
 7.895173145847394328e-06,
 7.888112900816436968e-06,
 7.880783604346182605e-06,
 7.873186143740221760e-06,
 7.865321414274280138e-06,
 7.857190319144737663e-06,
 7.848793769417027229e-06,
 7.840132683973769179e-06,
 7.831207989462741459e-06,
 7.822020620244714249e-06,
 7.812571518341108405e-06,
 7.802861633381318483e-06,
 7.792891922550071335e-06,
 7.782663350534515349e-06,
 7.772176889471106399e-06,
 7.761433518892400628e-06,
 7.750434225673647319e-06,
 7.739180003979200518e-06,
 7.727671855208759539e-06,
 7.715910787943553576e-06,
 7.703897817892231545e-06,
 7.691633967836682467e-06,
 7.679120267577649179e-06,
 7.666357753880381000e-06,
 7.653347470419756169e-06,
 7.640090467725670236e-06,
 7.626587803128003486e-06,
 7.612840540701673069e-06,
 7.598849751211248895e-06,
 7.584616512055740648e-06,
 7.570141907213180649e-06,
 7.555427027184871301e-06,
 7.540472968939712158e-06,
 7.525280835858423649e-06,
 7.509851737677451477e-06,
 7.494186790432926914e-06,
 7.478287116404581368e-06,
 7.462153844059151025e-06,
 7.445788107994190615e-06,
 7.429191048881450104e-06,
 7.412363813410005752e-06,
 7.395307554229899386e-06,
 7.378023429894975533e-06,
 7.360512604806010785e-06,
 7.342776249153693231e-06,
 7.324815538861361338e-06,
 7.306631655527773321e-06,
 7.288225786369923953e-06,
 7.269599124165388720e-06,
 7.250752867194972919e-06,
 7.231688219185107488e-06,
 7.212406389250042391e-06,
 7.192908591834103542e-06,
 7.173196046654075077e-06,
 7.153269978641006499e-06,
 7.133131617882447572e-06,
 7.112782199564273251e-06,
 7.092222963912678018e-06,
 7.071455156135774655e-06,
 7.050480026365592816e-06,
 7.029298829599727774e-06,
 7.007912825642927336e-06,
 6.986323279048588970e-06,
 6.964531459060604215e-06,
 6.942538639554406041e-06,
 6.920346098978726856e-06,
 6.897955120296966047e-06,
 6.875366990928347438e-06,
 6.852583002689468096e-06,
 6.829604451735377868e-06,
 6.806432638500796990e-06,
 6.783068867641536980e-06,
 6.759514447975525126e-06,
 6.735770692423790005e-06,
 6.711838917951935737e-06,
 6.687720445510890343e-06,
 6.663416599978057283e-06,
 6.638928710098572867e-06,
 6.614258108426013958e-06,
 6.589406131263696043e-06,
 6.564374118605419042e-06,
 6.539163414076766233e-06,
 6.513775364875601883e-06,
 6.488211321713700508e-06,
 6.462472638757092042e-06,
 6.436560673567515766e-06,
 6.410476787043006872e-06,
 6.384222343359264847e-06,
 6.357798709910185828e-06,
 6.331207257249174231e-06,
 6.304449359030219754e-06,
 6.277526391948508502e-06,
 6.250439735681843043e-06,
 6.223190772831578795e-06,
 6.195780888863405414e-06,
 6.168211472048783785e-06,
 6.140483913406089933e-06,
 6.112599606641336272e-06,
 6.084559948089802566e-06,
 6.056366336656928272e-06,
 6.028020173759440364e-06,
 5.999522863267125751e-06,
 5.970875811443499998e-06,
 5.942080426887649208e-06,
 5.913138120475334963e-06,
 5.884050305300427087e-06,
 5.854818396616257621e-06,
 5.825443811777592291e-06,
 5.795927970181632121e-06,
 5.766272293210054361e-06,
 5.736478204170354601e-06,
 5.706547128237925818e-06,
 5.676480492397269202e-06,
 5.646279725384609373e-06,
 5.615946257629076408e-06,
 5.585481521195239741e-06,
 5.554886949724689146e-06,
 5.524163978378601671e-06,
 5.493314043779334476e-06,
 5.462338583953167105e-06,
 5.431239038272593975e-06,
 5.400016847398361065e-06,
 5.368673453222341168e-06,
 5.337210298810053389e-06,
 5.305628828342853989e-06,
 5.273930487061187725e-06,
 5.242116721207376697e-06,
 5.210188977968122910e-06,
 5.178148705418016255e-06,
 5.145997352462253910e-06,
 5.113736368779790870e-06,
 5.081367204767137624e-06,
 5.048891311481110042e-06,
 5.016310140582780355e-06,
 4.983625144280901290e-06,
 4.950837775275528399e-06,
 4.917949486701720319e-06,
 4.884961732073997981e-06,
 4.851875965229655230e-06,
 4.818693640273513643e-06,
 4.785416211521631263e-06,
 4.752045133446260703e-06,
 4.718581860619609545e-06,
 4.685027847659085591e-06,
 4.651384549171832295e-06,
 4.617653419699547115e-06,
 4.583835913663273590e-06,
 4.549933485309034540e-06,
 4.515947588652335305e-06,
 4.481879677424123050e-06,
 4.447731205016297133e-06,
 4.413503624426844239e-06,
 4.379198388206215267e-06,
 4.344816948402852639e-06,
 4.310360756509111484e-06,
 4.275831263408076131e-06,
 4.241229919319490609e-06,
 4.206558173746063535e-06,
 4.171817475420622575e-06,
 4.137009272252486246e-06,
 4.102135011274343091e-06,
 4.067196138589956718e-06,
 4.032194099320640083e-06,
 3.997130337553349324e-06,
 3.962006296287599347e-06,
 3.926823417383733838e-06,
 3.891583141510677728e-06,
 3.856286908093506697e-06,
 3.820936155262290624e-06,
 3.785532319800362317e-06,
 3.750076837092473592e-06,
 3.714571141074038096e-06,
 3.679016664179635512e-06,
 3.643414837291965966e-06,
 3.607767089691693822e-06,
 3.572074849006406319e-06,
 3.536339541160087212e-06,
 3.500562590323376452e-06,
 3.464745418863073052e-06,
 3.428889447292212655e-06,
 3.392996094221053551e-06,
 3.357066776306756140e-06,
 3.321102908204742918e-06,
 3.285105902519000086e-06,
 3.249077169753801753e-06,
 3.213018118264044585e-06,
 3.176930154207820734e-06,
 3.140814681497106125e-06,
 3.104673101750311783e-06,
 3.068506814243705649e-06,
 3.032317215864359476e-06,
 2.996105701061722684e-06,
 2.959873661800952965e-06,
 2.923622487515715790e-06,
 2.887353565060751842e-06,
 2.851068278665655691e-06,
 2.814768009888235623e-06,
 2.778454137567654932e-06,
 2.742128037778975468e-06,
 2.705791083787162907e-06,
 2.669444646000909474e-06,
 2.633090091927805150e-06,
 2.596728786128565284e-06,
 2.560362090171934556e-06,
 2.523991362590539620e-06,
 2.487617958835407249e-06,
 2.451243231232216775e-06,
 2.414868528936883375e-06,
 2.378495197891515323e-06,
 2.342124580780538110e-06,
 2.305758016987929438e-06,
 2.269396842553025282e-06,
 2.233042390128217790e-06,
 2.196695988935488520e-06,
 2.160358964724540870e-06,
 2.124032639729546340e-06,
 2.087718332627769516e-06,
 2.051417358497473918e-06,
 2.015131028776209865e-06,
 1.978860651219132405e-06,
 1.942607529858466978e-06,
 1.906372964961660906e-06,
 1.870158252991403437e-06,
 1.833964686565078070e-06,
 1.797793554414028945e-06,
 1.761646141344148619e-06,
 1.725523728196039985e-06,
 1.689427591804621271e-06,
 1.653359004961335031e-06,
 1.617319236374228328e-06,
 1.581309550629114583e-06,
 1.545331208151615267e-06,
 1.509385465168393120e-06,
 1.473473573669061282e-06,
 1.437596781369137890e-06,
 1.401756331671624870e-06,
 1.365953463630407435e-06,
 1.330189411912970872e-06,
 1.294465406763569214e-06,
 1.258782673966552110e-06,
 1.223142434810857409e-06,
 1.187545906053100431e-06,
 1.151994299882583884e-06,
 1.116488823885169156e-06,
 1.081030681008778353e-06,
 1.045621069527533895e-06,
 1.010261183007808795e-06,
 9.749522102736120252e-07,
 9.396953353723328094e-07,
 9.044917375405781964e-07,
 8.693425911711894910e-07,
 8.342490657789357258e-07,
 7.992123259681408026e-07,
 7.642335313997488404e-07,
 7.293138367582319742e-07,
 6.944543917199337690e-07,
 6.596563409205194381e-07,
 6.249208239231025223e-07,
 5.902489751873889621e-07,
 5.556419240379346442e-07,
 5.211007946330052933e-07,
 4.866267059344408404e-07,
 4.522207716767289791e-07,
 4.178841003367633894e-07,
 3.836177951046833050e-07,
 3.494229538533585163e-07,
 3.153006691097809385e-07,
 2.812520280253407956e-07,
 2.472781123477650550e-07,
 2.133799983916186570e-07,
 1.795587570112023733e-07,
 1.458154535716042906e-07,
 1.121511479217408562e-07,
 7.856689436629406833e-08,
 4.506374163930164988e-08,
 1.164273287640902035e-08,
-2.169509441098402914e-08,
-5.494870836210749564e-08,
-8.811708279332675757e-08,
-1.211991972233221677e-07,
-1.541940368987142480e-07,
-1.871005928197270184e-07,
-2.199178617644482106e-07,
-2.526448463135336599e-07,
-2.852805548750229612e-07,
-3.178240017077620741e-07,
-3.502742069456566824e-07,
-3.826301966212441940e-07,
-4.148910026881930011e-07,
-4.470556630450987587e-07,
-4.791232215575047535e-07,
-5.110927280804921136e-07,
-5.429632384808429018e-07,
-5.747338146589899689e-07,
-6.064035245698203474e-07,
-6.379714422447647063e-07,
-6.694366478120401676e-07,
-7.007982275179241745e-07,
-7.320552737464307487e-07,
-7.632068850403326841e-07,
-7.942521661198764212e-07,
-8.251902279032251881e-07,
-8.560201875250045748e-07,
-8.867411683558652886e-07,
-9.173523000204439582e-07,
-9.478527184165916287e-07,
-9.782415657327725596e-07,
-1.008517990465944349e-06,
-1.038681147439538114e-06,
-1.068730197820151922e-06,
-1.098664309134666572e-06,
-1.128482655287342322e-06,
-1.158184416575597630e-06,
-1.187768779706177104e-06,
-1.217234937811407552e-06,
-1.246582090464109145e-06,
-1.275809443693296022e-06,
-1.304916209999166868e-06,
-1.333901608367123094e-06,
-1.362764864282952332e-06,
-1.391505209746321877e-06,
-1.420121883284817199e-06,
-1.448614129967521156e-06,
-1.476981201418413627e-06,
-1.505222355828639092e-06,
-1.533336857969997116e-06,
-1.561323979206647705e-06,
-1.589182997507807699e-06,
-1.616913197458892217e-06,
-1.644513870273843008e-06,
-1.671984313805741992e-06,
-1.699323832557871387e-06,
-1.726531737694502791e-06,
-1.753607347051480018e-06,
-1.780549985145770232e-06,
-1.807358983186058644e-06,
-1.834033679081681105e-06,
-1.860573417451919868e-06,
-1.886977549635434247e-06,
-1.913245433698379631e-06,
-1.939376434443257715e-06,
-1.965369923417109637e-06,
-1.991225278918809772e-06,
-2.016941886007084815e-06,
-2.042519136507907522e-06,
-2.067956429021045552e-06,
-2.093253168927218047e-06,
-2.118408768394592793e-06,
-2.143422646384379186e-06,
-2.168294228657441437e-06,
-2.193022947779355785e-06,
-2.217608243126233845e-06,
-2.242049560889237298e-06,
-2.266346354080133576e-06,
-2.290498082534893213e-06,
-2.314504212918714869e-06,
-2.338364218729418542e-06,
-2.362077580301612546e-06,
-2.385643784809561144e-06,
-2.409062326271012712e-06,
-2.432332705549490537e-06,
-2.455454430357022809e-06,
-2.478427015256509651e-06,
-2.501249981664000792e-06,
-2.523922857849917411e-06,
-2.546445178941280258e-06,
-2.568816486922377118e-06,
-2.591036330635799574e-06,
-2.613104265783507732e-06,
-2.635019854926753987e-06,
-2.656782667486659005e-06,
-2.678392279744109655e-06,
-2.699848274838937812e-06,
-2.721150242769640409e-06,
-2.742297780392589162e-06,
-2.763290491420448306e-06,
-2.784127986421131477e-06,
-2.804809882816106797e-06,
-2.825335804877958695e-06,
-2.845705383728794205e-06,
-2.865918257337238551e-06,
-2.885974070516173984e-06,
-2.905872474919186484e-06,
-2.925613129038060233e-06,
-2.945195698198377281e-06,
-2.964619854556483474e-06,
-2.983885277094919557e-06,
-3.002991651618601905e-06,
-3.021938670749757261e-06,
-3.040726033923742634e-06,
-3.059353447383513323e-06,
-3.077820624174338705e-06,
-3.096127284138582815e-06,
-3.114273153909536676e-06,
-3.132257966905441637e-06,
-3.150081463323503814e-06,
-3.167743390132937404e-06,
-3.185243501068165559e-06,
-3.202581556622106797e-06,
-3.219757324038456415e-06,
-3.236770577304444784e-06,
-3.253621097143098854e-06,
-3.270308671004735824e-06,
-3.286833093059280555e-06,
-3.303194164187289564e-06,
-3.319391691971370151e-06,
-3.335425490687220490e-06,
-3.351295381294486329e-06,
-3.367001191426838424e-06,
-3.382542755382780959e-06,
-3.397919914115302500e-06,
-3.413132515222005517e-06,
-3.428180412934294436e-06,
-3.443063468107225638e-06,
-3.457781548208192798e-06,
-3.472334527305886231e-06,
-3.486722286059021002e-06,
-3.500944711704833794e-06,
-3.515001698046942812e-06,
-3.528893145443792553e-06,
-3.542618960795974152e-06,
-3.556179057533785431e-06,
-3.569573355604762150e-06,
-3.582801781460468103e-06,
-3.595864268043344513e-06,
-3.608760754773636919e-06,
-3.621491187535421679e-06,
-3.634055518662814576e-06,
-3.646453706926192559e-06,
-3.658685717517570987e-06,
-3.670751522036407362e-06,
-3.682651098474895134e-06,
-3.694384431202714153e-06,
-3.705951510952344381e-06,
-3.717352334803400871e-06,
-3.728586906167205056e-06,
-3.739655234771104900e-06,
-3.750557336642507061e-06,
-3.761293234092410141e-06,
-3.771862955699422448e-06,
-3.782266536292831923e-06,
-3.792504016936138129e-06,
-3.802575444909667742e-06,
-3.812480873693865985e-06,
-3.822220362951472506e-06,
-3.831793978510052178e-06,
-3.841201792344222650e-06,
-3.850443882557765432e-06,
-3.859520333365148303e-06,
-3.868431235073516535e-06,
-3.877176684063824391e-06,
-3.885756782772063181e-06,
-3.894171639670522351e-06,
-3.902421369248349229e-06,
-3.910506091992418790e-06,
-3.918425934367810389e-06,
-3.926181028797873689e-06,
-3.933771513644461453e-06,
-3.941197533187918394e-06,
-3.948459237606612617e-06,
-3.955556782956647492e-06,
-3.962490331151247412e-06,
-3.969260049939681915e-06,
-3.975866112886626037e-06,
-3.982308699350665157e-06,
-3.988587994463233517e-06,
-3.994704189106805672e-06,
-4.000657479893558878e-06,
-4.006448069143105445e-06,
-4.012076164860785823e-06,
-4.017541980715251876e-06,
-4.022845736016246665e-06,
-4.027987655691876015e-06,
-4.032967970266160446e-06,
-4.037786915835942513e-06,
-4.042444734047876313e-06,
-4.046941672075414444e-06,
-4.051277982595210511e-06,
-4.055453923763708838e-06,
-4.059469759193600331e-06,
-4.063325757929795548e-06,
-4.067022194425480766e-06,
-4.070559348518076651e-06,
-4.073937505404852174e-06,
-4.077156955618562255e-06,
-4.080217995002712699e-06,
-4.083120924687068248e-06,
-4.085866051062458423e-06,
-4.088453685756021301e-06,
-4.090884145605789132e-06,
-4.093157752635610239e-06,
-4.095274834029422082e-06,
-4.097235722105901260e-06,
-4.099040754292550230e-06,
-4.100690273099827226e-06,
-4.102184626095227053e-06,
-4.103524165877049322e-06,
-4.104709250048095536e-06,
-4.105740241189356860e-06,
-4.106617506833363074e-06,
-4.107341419437490873e-06,
-4.107912356357268775e-06,
-4.108330699819289855e-06,
-4.108596836894308286e-06,
-4.108711159469973344e-06,
-4.108674064223463474e-06,
-4.108485952594177941e-06,
-4.108147230756098998e-06,
-4.107658309590143879e-06,
-4.107019604656399062e-06,
-4.106231536166276601e-06,
-4.105294528954315550e-06,
-4.104209012450240891e-06,
-4.102975420650602327e-06,
-4.101594192090507948e-06,
-4.100065769815052958e-06,
-4.098390601350927137e-06,
-4.096569138677556423e-06,
-4.094601838198403745e-06,
-4.092489160712084351e-06,
-4.090231571383399822e-06,
-4.087829539714188283e-06,
-4.085283539514210181e-06,
-4.082594048871844340e-06,
-4.079761550124650172e-06,
-4.076786529829977331e-06,
-4.073669478735326335e-06,
-4.070410891748737143e-06,
-4.067011267909015096e-06,
-4.063471110355881481e-06,
-4.059790926300069875e-06,
-4.055971226993279349e-06,
-4.052012527698073455e-06,
-4.047915347657714845e-06,
-4.043680210065899087e-06,
-4.039307642036353807e-06,
-4.034798174572495426e-06,
-4.030152342536833486e-06,
-4.025370684620433415e-06,
-4.020453743312244618e-06,
-4.015402064868365888e-06,
-4.010216199281237122e-06,
-4.004896700248742947e-06,
-3.999444125143327358e-06,
-3.993859034980878811e-06,
-3.988141994389724580e-06,
-3.982293571579427760e-06,
-3.976314338309608828e-06,
-3.970204869858647776e-06,
-3.963965744992346437e-06,
-3.957597545932555227e-06,
-3.951100858325662673e-06,
-3.944476271211105274e-06,
-3.937724376989811280e-06,
-3.930845771392550467e-06,
-3.923841053448249171e-06,
-3.916710825452307871e-06,
-3.909455692934759520e-06,
-3.902076264628437208e-06,
-3.894573152437140117e-06,
-3.886946971403699534e-06,
-3.879198339677958465e-06,
-3.871327878484807999e-06,
-3.863336212092142355e-06,
-3.855223967778669942e-06,
-3.846991775801908213e-06,
-3.838640269365885454e-06,
-3.830170084589036544e-06,
-3.821581860471858149e-06,
-3.812876238864704958e-06,
-3.804053864435430906e-06,
-3.795115384637082487e-06,
-3.786061449675465866e-06,
-3.776892712476813935e-06,
-3.767609828655295827e-06,
-3.758213456480615359e-06,
-3.748704256845488784e-06,
-3.739082893233138626e-06,
-3.729350031684836229e-06,
-3.719506340767251175e-06,
-3.709552491539975620e-06,
-3.699489157522938933e-06,
-3.689317014663700367e-06,
-3.679036741304984408e-06,
-3.668649018151976825e-06,
-3.658154528239666051e-06,
-3.647553956900269258e-06,
-3.636847991730502154e-06,
-3.626037322558885636e-06,
-3.615122641413206163e-06,
-3.604104642487703403e-06,
-3.592984022110450563e-06,
-3.581761478710651300e-06,
-3.570437712785945513e-06,
-3.559013426869655011e-06,
-3.547489325498259558e-06,
-3.535866115178559951e-06,
-3.524144504355078260e-06,
-3.512325203377294172e-06,
-3.500408924467105798e-06,
-3.488396381685989356e-06,
-3.476288290902484117e-06,
-3.464085369759508796e-06,
-3.451788337641755436e-06,
-3.439397915642939731e-06,
-3.426914826533382109e-06,
-3.414339794727210191e-06,
-3.401673546249939033e-06,
-3.388916808705897197e-06,
-3.376070311245557120e-06,
-3.363134784533203014e-06,
-3.350110960714313751e-06,
-3.336999573383019428e-06,
-3.323801357549799342e-06,
-3.310517049609024117e-06,
-3.297147387306433020e-06,
-3.283693109706965349e-06,
-3.270154957162217423e-06,
-3.256533671278162159e-06,
-3.242829994883037630e-06,
-3.229044671994862502e-06,
-3.215178447789392355e-06,
-3.201232068567857892e-06,
-3.187206281724854770e-06,
-3.173101835716092391e-06,
-3.158919480026606032e-06,
-3.144659965138442111e-06,
-3.130324042498882593e-06,
-3.115912464488310257e-06,
-3.101425984388505097e-06,
-3.086865356350565068e-06,
-3.072231335363243145e-06,
-3.057524677221170464e-06,
-3.042746138493111637e-06,
-3.027896476490210342e-06,
-3.012976449234560583e-06,
-2.997986815427398910e-06,
-2.982928334417757002e-06,
-2.967801766171014298e-06,
-2.952607871237327806e-06,
-2.937347410720479505e-06,
-2.922021146246434056e-06,
-2.906629839932048135e-06,
-2.891174254354167709e-06,
-2.875655152518266637e-06,
-2.860073297827402068e-06,
-2.844429454051371428e-06,
-2.828724385295646222e-06,
-2.812958855970459557e-06,
-2.797133630760250285e-06,
-2.781249474592670910e-06,
-2.765307152608114304e-06,
-2.749307430128918138e-06,
-2.733251072629106740e-06,
-2.717138845703576465e-06,
-2.700971515038112421e-06,
-2.684749846378775849e-06,
-2.668474605501863680e-06,
-2.652146558183563577e-06,
-2.635766470170120165e-06,
-2.619335107147504898e-06,
-2.602853234711754237e-06,
-2.586321618339091833e-06,
-2.569741023356006239e-06,
-2.553112214909729275e-06,
-2.536435957938605962e-06,
-2.519713017142377650e-06,
-2.502944156952997066e-06,
-2.486130141505246865e-06,
-2.469271734607292949e-06,
-2.452369699711744741e-06,
-2.435424799886390622e-06,
-2.418437797785154436e-06,
-2.401409455619453501e-06,
-2.384340535129185187e-06,
-2.367231797553921440e-06,
-2.350084003604543773e-06,
-2.332897913434455572e-06,
-2.315674286611129420e-06,
-2.298413882088063103e-06,
-2.281117458176151167e-06,
-2.263785772515834051e-06,
-2.246419582048767803e-06,
-2.229019642990194706e-06,
-2.211586710800637137e-06,
-2.194121540158659525e-06,
-2.176624884932774387e-06,
-2.159097498154223769e-06,
-2.141540131989234688e-06,
-2.123953537712024183e-06,
-2.106338465677124217e-06,
-2.088695665292612462e-06,
-2.071025884993028851e-06,
-2.053329872212256970e-06,
-2.035608373356963218e-06,
-2.017862133779817441e-06,
-2.000091897752724998e-06,
-1.982298408440581863e-06,
-1.964482407874919200e-06,
-1.946644636927417487e-06,
-1.928785835284053380e-06,
-1.910906741418868367e-06,
-1.893008092568010602e-06,
-1.875090624704293209e-06,
-1.857155072511081739e-06,
-1.839202169357048566e-06,
-1.821232647270617898e-06,
-1.803247236914603078e-06,
-1.785246667560922219e-06,
-1.767231667065877552e-06,
-1.749202961844742955e-06,
-1.731161276847284484e-06,
-1.713107335532735218e-06,
-1.695041859845541729e-06,
-1.676965570190475725e-06,
-1.658879185408613455e-06,
-1.640783422753074155e-06,
-1.622678997864840210e-06,
-1.604566624748703761e-06,
-1.586447015749716848e-06,
-1.568320881529058390e-06,
-1.550188931040788845e-06,
-1.532051871508355421e-06,
-1.513910408401046257e-06,
-1.495765245411073946e-06,
-1.477617084430297796e-06,
-1.459466625527239170e-06,
-1.441314566924590222e-06,
-1.423161604976310333e-06,
-1.405008434145023465e-06,
-1.386855746979858294e-06,
-1.368704234093967956e-06,
-1.350554584142346890e-06,
-1.332407483800186605e-06,
-1.314263617740582408e-06,
-1.296123668613115753e-06,
-1.277988317022164265e-06,
-1.259858241505384357e-06,
-1.241734118512338464e-06,
-1.223616622383669684e-06,
-1.205506425329633937e-06,
-1.187404197409560689e-06,
-1.169310606510773263e-06,
-1.151226318328355978e-06,
-1.133151996344209143e-06,
-1.115088301807099095e-06,
-1.097035893712385744e-06,
-1.078995428781933911e-06,
-1.060967561444086931e-06,
-1.042952943814242065e-06,
-1.024952225674773075e-06,
-1.006966054455933857e-06,
-9.889950752164876488e-07,
-9.710399306242885899e-07,
-9.531012609375619718e-07,
-9.351797039857770714e-07,
-9.172758951508739360e-07,
-8.993904673489714949e-07,
-8.815240510116896362e-07,
-8.636772740677657326e-07,
-8.458507619251851054e-07,
-8.280451374529334993e-07,
-8.102610209630994881e-07,
-7.924990301935440748e-07,
-7.747597802898812302e-07,
-7.570438837884476603e-07,
-7.393519505987189316e-07,
-7.216845879865676533e-07,
-7.040424005568230687e-07,
-6.864259902370403160e-07,
-6.688359562603469520e-07,
-6.512728951493209510e-07,
-6.337374006993094491e-07,
-6.162300639626009810e-07,
-5.987514732319360781e-07,
-5.813022140249769187e-07,
-5.638828690685370577e-07,
-5.464940182827447683e-07,
-5.291362387658998937e-07,
-5.118101047791142805e-07,
-4.945161877309505189e-07,
-4.772550561627735661e-07,
-4.600272757338931010e-07,
-4.428334092066732137e-07,
-4.256740164323354455e-07,
-4.085496543363808753e-07,
-3.914608769043499073e-07,
-3.744082351681478245e-07,
-3.573922771917193967e-07,
-3.404135480576487662e-07,
-3.234725898534596961e-07,
-3.065699416581685512e-07,
-2.897061395289459117e-07,
-2.728817164883716921e-07,
-2.560972025110559375e-07,
-2.393531245112056513e-07,
-2.226500063296816017e-07,
-2.059883687218756926e-07,
-1.893687293449629056e-07,
-1.727916027460974194e-07,
-1.562575003503315910e-07,
-1.397669304487320300e-07,
-1.233203981865752686e-07,
-1.069184055521343685e-07,
-9.056145136487337267e-08,
-7.425003126458912411e-08,
-5.798463770031509434e-08,
-4.176575991918963677e-08,
-2.559388395598939245e-08,
-9.469492622430668399e-09,
 6.606934503293871912e-09,
 2.263492108685763881e-08,
 3.861399404755873835e-08,
 5.454368356869616396e-08,
 7.042352310701285809e-08,
 8.625304940263784327e-08,
 1.020318024882154903e-07,
 1.177593256986449280e-07,
 1.334351656798934611e-07,
 1.490588723980747774e-07,
 1.646299991483308832e-07,
 1.801481025636315311e-07,
 1.956127426229954159e-07,
 2.110234826602816885e-07,
 2.263798893720542066e-07,
 2.416815328256779525e-07,
 2.569279864674402257e-07,
 2.721188271299872220e-07,
 2.872536350401322477e-07,
 3.023319938263174973e-07,
 3.173534905255769825e-07,
 3.323177155908737430e-07,
 3.472242628981247673e-07,
 3.620727297527363281e-07,
 3.768627168964648437e-07,
 3.915938285139325198e-07,
 4.062656722386272016e-07,
 4.208778591594652912e-07,
 4.354300038264820086e-07,
 4.499217242569753454e-07,
 4.643526419408784774e-07,
 4.787223818467419344e-07,
 4.930305724266091220e-07,
 5.072768456216916540e-07,
 5.214608368671119962e-07,
 5.355821850971194946e-07,
 5.496405327495329579e-07,
 5.636355257707482100e-07,
 5.775668136198690699e-07,
 5.914340492730585601e-07,
 6.052368892278866205e-07,
 6.189749935070865937e-07,
 6.326480256624668235e-07,
 6.462556527788077471e-07,
 6.597975454771181019e-07,
 6.732733779180476212e-07,
 6.866828278053389050e-07,
 7.000255763886074880e-07,
 7.133013084664883557e-07,
 7.265097123894373994e-07,
 7.396504800620788626e-07,
 7.527233069458815414e-07,
 7.657278920615414879e-07,
 7.786639379909242574e-07,
 7.915311508792689934e-07,
 8.043292404371007108e-07,
 8.170579199416379583e-07,
 8.297169062387358067e-07,
 8.423059197439962027e-07,
 8.548246844443194158e-07,
 8.672729278987031082e-07,
 8.796503812396296684e-07,
 8.919567791734229186e-07,
 9.041918599813188698e-07,
 9.163553655197047967e-07,
 9.284470412207550423e-07,
 9.404666360923930070e-07,
 9.524139027187146650e-07,
 9.642885972596556806e-07,
 9.760904794508198837e-07,
 9.878193126033280750e-07,
 9.994748636031009058e-07,
 1.011056902910284379e-06,
 1.022565204558676830e-06,
 1.033999546154531647e-06,
 1.045359708875537655e-06,
 1.056645477469797381e-06,
 1.067856640254224891e-06,
 1.078992989113237127e-06,
 1.090054319497168894e-06,
 1.101040430420195088e-06,
 1.111951124458769404e-06,
 1.122786207749324007e-06,
 1.133545489986163592e-06,
 1.144228784419161036e-06,
 1.154835907851344410e-06,
 1.165366680636030409e-06,
 1.175820926674377908e-06,
 1.186198473412256058e-06,
 1.196499151837448019e-06,
 1.206722796476234031e-06,
 1.216869245390409851e-06,
 1.226938340173595605e-06,
 1.236929925947745792e-06,
 1.246843851359446908e-06,
 1.256679968576194735e-06,
 1.266438133282188186e-06,
 1.276118204674541799e-06,
 1.285720045458798578e-06,
 1.295243521844606738e-06,
 1.304688503541367438e-06,
 1.314054863753402669e-06,
 1.323342479175359467e-06,
 1.332551229987350482e-06,
 1.341680999849717200e-06,
 1.350731675898045361e-06,
 1.359703148737965878e-06,
 1.368595312439533497e-06,
 1.377408064531886890e-06,
 1.386141305997600219e-06,
 1.394794941266679788e-06,
 1.403368878210943344e-06,
 1.411863028137770879e-06,
 1.420277305784052158e-06,
 1.428611629309903215e-06,
 1.436865920292337114e-06,
 1.445040103718500175e-06,
 1.453134107979307583e-06,
 1.461147864862448800e-06,
 1.469081309545711042e-06,
 1.476934380589726345e-06,
 1.484707019931127752e-06,
 1.492399172875076366e-06,
 1.500010788087952086e-06,
 1.507541817589890617e-06,
 1.514992216747244665e-06,
 1.522361944264712453e-06,
 1.529650962177716973e-06,
 1.536859235844277645e-06,
 1.543986733936964134e-06,
 1.551033428434859284e-06,
 1.557999294615083915e-06,
 1.564884311044529570e-06,
 1.571688459571383315e-06,
 1.578411725316291705e-06,
 1.585054096663782879e-06,
 1.591615565253449794e-06,
 1.598096125970853516e-06,
 1.604495776938571776e-06,
 1.610814519507071553e-06,
 1.617052358245204730e-06,
 1.623209300931077081e-06,
 1.629285358542355880e-06,
 1.635280545246839252e-06,
 1.641194878392567062e-06,
 1.647028378498249652e-06,
 1.652781069243097523e-06,
 1.658452977457013110e-06,
 1.664044133110312463e-06,
 1.669554569303669062e-06,
 1.674984322257609125e-06,
 1.680333431302315870e-06,
 1.685601938866915823e-06,
 1.690789890468927749e-06,
 1.695897334703604861e-06,
 1.700924323233021224e-06,
 1.705870910775203687e-06,
 1.710737155093222733e-06,
 1.715523116983951931e-06,
 1.720228860266907850e-06,
 1.724854451773039368e-06,
 1.729399961333226234e-06,
 1.733865461766904901e-06,
 1.738251028870519226e-06,
 1.742556741405715379e-06,
 1.746782681087769249e-06,
 1.750928932573648788e-06,
 1.754995583450096047e-06,
 1.758982724221663890e-06,
 1.762890448298634134e-06,
 1.766718851984692578e-06,
 1.770468034464832742e-06,
 1.774138097792847941e-06,
 1.777729146879045919e-06,
 1.781241289477537427e-06,
 1.784674636173838201e-06,
 1.788029300372015870e-06,
 1.791305398281974727e-06,
 1.794503048906588655e-06,
 1.797622374028855880e-06,
 1.800663498198728450e-06,
 1.803626548720206846e-06,
 1.806511655638036901e-06,
 1.809318951724489949e-06,
 1.812048572466118616e-06,
 1.814700656050261467e-06,
 1.817275343351633842e-06,
 1.819772777918817677e-06,
 1.822193105960568159e-06,
 1.824536476332133298e-06,
 1.826803040521572015e-06,
 1.828992952635823200e-06,
 1.831106369386872188e-06,
 1.833143450077816848e-06,
 1.835104356588684232e-06,
 1.836989253362483545e-06,
 1.838798307390927067e-06,
 1.840531688200234525e-06,
 1.842189567836822466e-06,
 1.843772120852997025e-06,
 1.845279524292365900e-06,
 1.846711957675503166e-06,
 1.848069602985278878e-06,
 1.849352644652328219e-06,
 1.850561269540274585e-06,
 1.851695666931093707e-06,
 1.852756028510253302e-06,
 1.853742548351831129e-06,
 1.854655422903636853e-06,
 1.855494850972260857e-06,
 1.856261033707967834e-06,
 1.856954174589718065e-06,
 1.857574479409932049e-06,
 1.858122156259344499e-06,
 1.858597415511761980e-06,
 1.859000469808722935e-06,
 1.859331534044194970e-06,
 1.859590825349184058e-06,
 1.859778563076203977e-06,
 1.859894968783864971e-06,
 1.859940266221290034e-06,
 1.859914681312496259e-06,
 1.859818442140791858e-06,
 1.859651778933095039e-06,
 1.859414924044130277e-06,
 1.859108111940732161e-06,
 1.858731579185979827e-06,
 1.858285564423347280e-06,
 1.857770308360766894e-06,
 1.857186053754750718e-06,
 1.856533045394311251e-06,
 1.855811530085010328e-06,
 1.855021756632828017e-06,
 1.854163975828136325e-06,
 1.853238440429458194e-06,
 1.852245405147374932e-06,
 1.851185126628259792e-06,
 1.850057863438030609e-06,
 1.848863876045888253e-06,
 1.847603426807989428e-06,
 1.846276779951066965e-06,
 1.844884201556096273e-06,
 1.843425959541840666e-06,
 1.841902323648411720e-06,
 1.840313565420814182e-06,
 1.838659958192409762e-06,
 1.836941777068429433e-06,
 1.835159298909378355e-06,
 1.833312802314450549e-06,
 1.831402567604927263e-06,
 1.829428876807545267e-06,
 1.827392013637822165e-06,
 1.825292263483368362e-06,
 1.823129913387220843e-06,
 1.820905252031041216e-06,
 1.818618569718422388e-06,
 1.816270158358087878e-06,
 1.813860311447118657e-06,
 1.811389324054116464e-06,
 1.808857492802424507e-06,
 1.806265115853215178e-06,
 1.803612492888676027e-06,
 1.800899925095107009e-06,
 1.798127715146042289e-06,
 1.795296167185323141e-06,
 1.792405586810187567e-06,
 1.789456281054346580e-06,
 1.786448558371005430e-06,
 1.783382728615927176e-06,
 1.780259103030455397e-06,
 1.777077994224539015e-06,
 1.773839716159736579e-06,
 1.770544584132213137e-06,
 1.767192914755772896e-06,
 1.763785025944788119e-06,
 1.760321236897220350e-06,
 1.756801868077587220e-06,
 1.753227241199924585e-06,
 1.749597679210760532e-06,
 1.745913506272093195e-06,
 1.742175047744322612e-06,
 1.738382630169228121e-06,
 1.734536581252920761e-06,
 1.730637229848794615e-06,
 1.726684905940503992e-06,
 1.722679940624890628e-06,
 1.718622666094993477e-06,
 1.714513415622949023e-06,
 1.710352523543003818e-06,
 1.706140325234456090e-06,
 1.701877157104647321e-06,
 1.697563356571941752e-06,
 1.693199262048693400e-06,
 1.688785212924266224e-06,
 1.684321549548012362e-06,
 1.679808613212269424e-06,
 1.675246746135400994e-06,
 1.670636291444820386e-06,
 1.665977593160000232e-06,
 1.661270996175566966e-06,
 1.656516846244315702e-06,
 1.651715489960264064e-06,
 1.646867274741803649e-06,
 1.641972548814752373e-06,
 1.637031661195450873e-06,
 1.632044961673928574e-06,
 1.627012800797031641e-06,
 1.621935529851539068e-06,
 1.616813500847410698e-06,
 1.611647066500915598e-06,
 1.606436580217884097e-06,
 1.601182396076924254e-06,
 1.595884868812653995e-06,
 1.590544353798986395e-06,
 1.585161207032436781e-06,
 1.579735785115390021e-06,
 1.574268445239487023e-06,
 1.568759545168931633e-06,
 1.563209443223917578e-06,
 1.557618498263994651e-06,
 1.551987069671508369e-06,
 1.546315517335077958e-06,
 1.540604201633058671e-06,
 1.534853483417025704e-06,
 1.529063723995368018e-06,
 1.523235285116787496e-06,
 1.517368528953922624e-06,
 1.511463818086986567e-06,
 1.505521515487367128e-06,
 1.499541984501366256e-06,
 1.493525588833851676e-06,
 1.487472692532070088e-06,
 1.481383659969318915e-06,
 1.475258855828897779e-06,
 1.469098645087807142e-06,
 1.462903393000733666e-06,
 1.456673465083877811e-06,
 1.450409227098982183e-06,
 1.444111045037209321e-06,
 1.437779285103261100e-06,
 1.431414313699396487e-06,
 1.425016497409481491e-06,
 1.418586202983189668e-06,
 1.412123797320145874e-06,
 1.405629647454077433e-06,
 1.399104120537141064e-06,
 1.392547583824214865e-06,
 1.385960404657140959e-06,
 1.379342950449197264e-06,
 1.372695588669447288e-06,
 1.366018686827180133e-06,
 1.359312612456507625e-06,
 1.352577733100782509e-06,
 1.345814416297297854e-06,
 1.339023029561846706e-06,
 1.332203940373416410e-06,
 1.325357516158880610e-06,
 1.318484124277866368e-06,
 1.311584132007448916e-06,
 1.304657906527129102e-06,
 1.297705814903630207e-06,
 1.290728224075977460e-06,
 1.283725500840376806e-06,
 1.276698011835373408e-06,
 1.269646123526945346e-06,
 1.262570202193635226e-06,
 1.255470613911754846e-06,
 1.248347724540703357e-06,
 1.241201899708171931e-06,
 1.234033504795612699e-06,
 1.226842904923644581e-06,
 1.219630464937454044e-06,
 1.212396549392398077e-06,
 1.205141522539582188e-06,
 1.197865748311391811e-06,
 1.190569590307297301e-06,
 1.183253411779588210e-06,
 1.175917575619095695e-06,
 1.168562444341149138e-06,
 1.161188380071437472e-06,
 1.153795744531934032e-06,
 1.146384899027068323e-06,
 1.138956204429668021e-06,
 1.131510021167209937e-06,
 1.124046709207991782e-06,
 1.116566628047375501e-06,
 1.109070136694115953e-06,
 1.101557593656832310e-06,
 1.094029356930335888e-06,
 1.086485783982252532e-06,
 1.078927231739488299e-06,
 1.071354056574987581e-06,
 1.063766614294275447e-06,
 1.056165260122355734e-06,
 1.048550348690486747e-06,
 1.040922234023065379e-06,
 1.033281269524540025e-06,
 1.025627807966532718e-06,
 1.017962201474750990e-06,
 1.010284801516361359e-06,
 1.002595958886949474e-06,
 9.948960236980155736e-07,
 9.871853453641984810e-07,
 9.794642725907486194e-07,
 9.717331533608866814e-07,
 9.639923349235500270e-07,
 9.562421637807930679e-07,
 9.484829856756430390e-07,
 9.407151455797571401e-07,
 9.329389876812929181e-07,
 9.251548553727073925e-07,
 9.173630912387782102e-07,
 9.095640370446830324e-07,
 9.017580337240286304e-07,
 8.939454213670242934e-07,
 8.861265392087654574e-07,
 8.783017256174526414e-07,
 8.704713180828340007e-07,
 8.626356532047146893e-07,
 8.547950666814085188e-07,
 8.469498932983733174e-07,
 8.391004669168073252e-07,
 8.312471204624477132e-07,
 8.233901859144520046e-07,
 8.155299942941949002e-07,
 8.076668756542601319e-07,
 7.998011590675244315e-07,
 7.919331726161567964e-07,
 7.840632433808785349e-07,
 7.761916974302901224e-07,
 7.683188598101073175e-07,
 7.604450545326436607e-07,
 7.525706045661643284e-07,
 7.446958318246865861e-07,
 7.368210571573467716e-07,
 7.289466003383487673e-07,
 7.210727800566312566e-07,
 7.131999139057978788e-07,
 7.053283183739326108e-07,
 6.974583088338631233e-07,
 6.895901995329825153e-07,
 6.817243035836685244e-07,
 6.738609329534398396e-07,
 6.660003984551939400e-07,
 6.581430097378136062e-07,
 6.502890752765583893e-07,
 6.424389023635504203e-07,
 6.345927970985985012e-07,
 6.267510643798419914e-07,
 6.189140078944566326e-07,
 6.110819301097352919e-07,
 6.032551322639600172e-07,
 5.954339143573428078e-07,
 5.876185751433930787e-07,
 5.798094121198454076e-07,
 5.720067215201856060e-07,
 5.642107983048827636e-07,
 5.564219361529011306e-07,
 5.486404274530960637e-07,
 5.408665632960587920e-07,
 5.331006334655316329e-07,
 5.253429264304156008e-07,
 5.175937293364890715e-07,
 5.098533279984055447e-07,
 5.021220068916115732e-07,
 4.944000491445033434e-07,
 4.866877365306805596e-07,
 4.789853494610943419e-07,
 4.712931669764286420e-07,
 4.636114667395562497e-07,
 4.559405250279441367e-07,
 4.482806167263071933e-07,
 4.406320153193431731e-07,
 4.329949928843925707e-07,
 4.253698200843288388e-07,
 4.177567661603849720e-07,
 4.101560989252162009e-07,
 4.025680847560502489e-07,
 3.949929885877513494e-07,
 3.874310739061089395e-07,
 3.798826027411924746e-07,
 3.723478356606713030e-07,
 3.648270317633791743e-07,
 3.573204486729592691e-07,
 3.498283425314283362e-07,
 3.423509679929888528e-07,
 3.348885782177328695e-07,
 3.274414248657766778e-07,
 3.200097580909998072e-07,
 3.125938265353537580e-07,
 3.051938773228941246e-07,
 2.978101560540912871e-07,
 2.904429068000295061e-07,
 2.830923720970535687e-07,
 2.757587929409955704e-07,
 2.684424087819899625e-07,
 2.611434575190375053e-07,
 2.538621754946526033e-07,
 2.465987974898900564e-07,
 2.393535567191647124e-07,
 2.321266848251428529e-07,
 2.249184118740239281e-07,
 2.177289663506049490e-07,
 2.105585751534286032e-07,
 2.034074635903109209e-07,
 1.962758553736544302e-07,
 1.891639726158516527e-07,
 1.820720358250875531e-07,
 1.750002639007453113e-07,
 1.679488741293799782e-07,
 1.609180821804174272e-07,
 1.539081021021311335e-07,
 1.469191463175073560e-07,
 1.399514256205530000e-07,
 1.330051491721930136e-07,
 1.260805244967435535e-07,
 1.191777574781080271e-07,
 1.122970523562509863e-07,
 1.054386117235922952e-07,
 9.860263652164807549e-08,
 9.178932603774776547e-08,
 8.499887790167887698e-08,
 7.823148808253934152e-08,
 7.148735088567252159e-08,
 6.476665894955666743e-08,
 5.806960324293555326e-08,
 5.139637306203214909e-08,
 4.474715602768161280e-08,
 3.812213808267680792e-08,
 3.152150348919307871e-08,
 2.494543482616859222e-08,
 1.839411298692410962e-08,
 1.186771717686317095e-08,
 5.366424911096248732e-09,
-1.109587987697465870e-09,
-7.560147391483507433e-09,
-1.398508086884859499e-08,
-2.038421768689729432e-08,
-2.675738881322390898e-08,
-3.310442691767998166e-08,
-3.942516637406091046e-08,
-4.571944326183737194e-08,
-5.198709536765164785e-08,
-5.822796218673526705e-08,
-6.444188492440100781e-08,
-7.062870649730131077e-08,
-7.678827153479307405e-08,
-8.292042637988419269e-08,
-8.902501909056209675e-08,
-9.510189944058539628e-08,
-1.011509189205320183e-07,
-1.071719307385870668e-07,
-1.131647898214326041e-07,
-1.191293528147321140e-07,
-1.250654780839818629e-07,
-1.309730257148403556e-07,
-1.368518575136786286e-07,
-1.427018370080512539e-07,
-1.485228294468237773e-07,
-1.543147018004943529e-07,
-1.600773227614306211e-07,
-1.658105627437721939e-07,
-1.715142938835196199e-07,
-1.771883900385460574e-07,
-1.828327267882717492e-07,
-1.884471814335248707e-07,
-1.940316329963300631e-07,
-1.995859622193245628e-07,
-2.051100515655417583e-07,
-2.106037852176833236e-07,
-2.160670490776346633e-07,
-2.214997307657343459e-07,
-2.269017196201388560e-07,
-2.322729066958079014e-07,
-2.376131847638299107e-07,
-2.429224483102614389e-07,
-2.482005935351996664e-07,
-2.534475183516132026e-07,
-2.586631223842403076e-07,
-2.638473069682806232e-07,
-2.689999751480047688e-07,
-2.741210316754420219e-07,
-2.792103830088809119e-07,
-2.842679373112990321e-07,
-2.892936044488330865e-07,
-2.942872959890387138e-07,
-2.992489251990896425e-07,
-3.041784070440271379e-07,
-3.090756581848196620e-07,
-3.139405969764790721e-07,
-3.187731434659757547e-07,
-3.235732193900873212e-07,
-3.283407481733080241e-07,
-3.330756549255922618e-07,
-3.377778664400150202e-07,
-3.424473111904856254e-07,
-3.470839193292531253e-07,
-3.516876226843515323e-07,
-3.562583547571017122e-07,
-3.607960507194287238e-07,
-3.653006474112486703e-07,
-3.697720833375272181e-07,
-3.742102986656445303e-07,
-3.786152352223178902e-07,
-3.829868364907365592e-07,
-3.873250476074805891e-07,
-3.916298153595313773e-07,
-3.959010881809312345e-07,
-4.001388161497651409e-07,
-4.043429509847021521e-07,
-4.085134460417228874e-07,
-4.126502563107798375e-07,
-4.167533384121798987e-07,
-4.208226505931294843e-07,
-4.248581527241984797e-07,
-4.288598062955290288e-07,
-4.328275744131875218e-07,
-4.367614217954549615e-07,
-4.406613147688479203e-07,
-4.445272212642985275e-07,
-4.483591108132524530e-07,
-4.521569545435005522e-07,
-4.559207251752838384e-07,
-4.596503970169999255e-07,
-4.633459459611019058e-07,
-4.670073494798025173e-07,
-4.706345866208637541e-07,
-4.742276380030641816e-07,
-4.777864858119639833e-07,
-4.813111137952719557e-07,
-4.848015072584004906e-07,
-4.882576530598332052e-07,
-4.916795396065432352e-07,
-4.950671568492623433e-07,
-4.984204962776691377e-07,
-5.017395509156569100e-07,
-5.050243153164489027e-07,
-5.082747855576638123e-07,
-5.114909592364076574e-07,
-5.146728354642226033e-07,
-5.178204148619590246e-07,
-5.209336995547240125e-07,
-5.240126931666630166e-07,
-5.270574008157925203e-07,
-5.300678291086838502e-07,
-5.330439861350935170e-07,
-5.359858814626552831e-07,
-5.388935261314193413e-07,
-5.417669326483655531e-07,
-5.446061149819549094e-07,
-5.474110885564199985e-07,
-5.501818702462988915e-07,
-5.529184783706282014e-07,
-5.556209326873165612e-07,
-5.582892543873255075e-07,
-5.609234660889470316e-07,
-5.635235918318139980e-07,
-5.660896570711497438e-07,
-5.686216886716872285e-07,
-5.711197149017479566e-07,
-5.735837654272402198e-07,
-5.760138713054845441e-07,
-5.784100649791428990e-07,
-5.807723802701020609e-07,
-5.831008523731615234e-07,
-5.853955178498308869e-07,
-5.876564146220990842e-07,
-5.898835819659789306e-07,
-5.920770605051929170e-07,
-5.942368922048047924e-07,
-5.963631203646429885e-07,
-5.984557896129335790e-07,
-6.005149458996603880e-07,
-6.025406364900334136e-07,
-6.045329099578567711e-07,
-6.064918161789325301e-07,
-6.084174063242608401e-07,
-6.103097328534343434e-07,
-6.121688495077601625e-07,
-6.139948113035335048e-07,
-6.157876745251456738e-07,
-6.175474967182699005e-07,
-6.192743366829144026e-07,
-6.209682544664493978e-07,
-6.226293113566702211e-07,
-6.242575698747648345e-07,
-6.258530937682646064e-07,
-6.274159480039851392e-07,
-6.289461987608961579e-07,
-6.304439134229436470e-07,
-6.319091605719112681e-07,
-6.333420099801796053e-07,
-6.347425326035377139e-07,
-6.361108005738603086e-07,
-6.374468871917945875e-07,
-6.387508669194587016e-07,
-6.400228153730692861e-07,
-6.412628093155326752e-07,
-6.424709266490605745e-07,
-6.436472464077067479e-07,
-6.447918487498438828e-07,
-6.459048149507109705e-07,
-6.469862273948525844e-07,
-6.480361695686054861e-07,
-6.490547260524330827e-07,
-6.500419825134038805e-07,
-6.509980256974859205e-07,
-6.519229434219116229e-07,
-6.528168245674840814e-07,
-6.536797590709065443e-07,
-6.545118379169698064e-07,
-6.553131531308810549e-07,
-6.560837977704204503e-07,
-6.568238659181500113e-07,
-6.575334526736343586e-07,
-6.582126541455283681e-07,
-6.588615674437405283e-07,
-6.594802906715733211e-07,
-6.600689229177529599e-07,
-6.606275642485439360e-07,
-6.611563156998070262e-07,
-6.616552792689896432e-07,
-6.621245579071653142e-07,
-6.625642555110557949e-07,
-6.629744769149445524e-07,
-6.633553278827069259e-07,
-6.637069150997037036e-07,
-6.640293461647228753e-07,
-6.643227295818859147e-07,
-6.645871747525740728e-07,
-6.648227919672475223e-07,
-6.650296923973737689e-07,
-6.652079880872329250e-07,
-6.653577919457653352e-07,
-6.654792177383913559e-07,
-6.655723800788414043e-07,
-6.656373944209342340e-07,
-6.656743770503450444e-07,
-6.656834450763978377e-07,
-6.656647164238303531e-07,
-6.656183098245145309e-07,
-6.655443448092293880e-07,
-6.654429416993693059e-07,
-6.653142215986493552e-07,
-6.651583063848331716e-07,
-6.649753187014127628e-07,
-6.647653819493347970e-07,
-6.645286202786437755e-07,
-6.642651585801598285e-07,
-6.639751224771590509e-07,
-6.636586383170249347e-07,
-6.633158331628918589e-07,
-6.629468347853220381e-07,
-6.625517716539106850e-07,
-6.621307729289247362e-07,
-6.616839684529443312e-07,
-6.612114887424754921e-07,
-6.607134649795909672e-07,
-6.601900290035069119e-07,
-6.596413133022496726e-07,
-6.590674510042068450e-07,
-6.584685758697704467e-07,
-6.578448222829255629e-07,
-6.571963252428704370e-07,
-6.565232203555872231e-07,
-6.558256438254704409e-07,
-6.551037324469107509e-07,
-6.543576235958847644e-07,
-6.535874552215767226e-07,
-6.527933658379521071e-07,
-6.519754945153670375e-07,
-6.511339808721749161e-07,
-6.502689650663230137e-07,
-6.493805877869431270e-07,
-6.484689902459815160e-07,
-6.475343141697855383e-07,
-6.465767017907242689e-07,
-6.455962958388107099e-07,
-6.445932395333010231e-07,
-6.435676765743410912e-07,
-6.425197511345766565e-07,
-6.414496078507878116e-07,
-6.403573918155294198e-07,
-6.392432485687807464e-07,
-6.381073240895785732e-07,
-6.369497647876883236e-07,
-6.357707174952635407e-07,
-6.345703294585043072e-07,
-6.333487483293439343e-07,
-6.321061221571345924e-07,
-6.308425993803343179e-07,
-6.295583288182100079e-07,
-6.282534596625593672e-07,
-6.269281414694096676e-07,
-6.255825241507612945e-07,
-6.242167579663261053e-07,
-6.228309935152735161e-07,
-6.214253817279935308e-07,
-6.200000738578615685e-07,
-6.185552214730401376e-07,
-6.170909764482480049e-07,
-6.156074909565835750e-07,
-6.141049174613392696e-07,
-6.125834087078333771e-07,
-6.110431177152567248e-07,
-6.094841977685253875e-07,
-6.079068024101687580e-07,
-6.063110854321931608e-07,
-6.046972008679991460e-07,
-6.030653029842919010e-07,
-6.014155462730126265e-07,
-5.997480854432827240e-07,
-5.980630754133756172e-07,
-5.963606713026772446e-07,
-5.946410284236963157e-07,
-5.929043022740692727e-07,
-5.911506485285904517e-07,
-5.893802230312536785e-07,
-5.875931817873216054e-07,
-5.857896809554094467e-07,
-5.839698768395748561e-07,
-5.821339258814451787e-07,
-5.802819846523548677e-07,
-5.784142098454930654e-07,
-5.765307582680966067e-07,
-5.746317868336248108e-07,
-5.727174525540065886e-07,
-5.707879125318483750e-07,
-5.688433239527013537e-07,
-5.668838440773494331e-07,
-5.649096302341043178e-07,
-5.629208398111154021e-07,
-5.609176302487439321e-07,
-5.589001590319020166e-07,
-5.568685836824453180e-07,
-5.548230617516006840e-07,
-5.527637508123920844e-07,
-5.506908084520898423e-07,
-5.486043922647121685e-07,
-5.465046598435188619e-07,
-5.443917687735453489e-07,
-5.422658766241581112e-07,
-5.401271409416394416e-07,
-5.379757192417755879e-07,
-5.358117690025170011e-07,
-5.336354476565977132e-07,
-5.314469125842605953e-07,
-5.292463211059292518e-07,
-5.270338304749645121e-07,
-5.248095978704105467e-07,
-5.225737803897913811e-07,
-5.203265350419327153e-07,
-5.180680187398060833e-07,
-5.157983882933832835e-07,
-5.135178004025555005e-07,
-5.112264116500417339e-07,
-5.089243784943540835e-07,
-5.066118572627940576e-07,
-5.042890041444465515e-07,
-5.019559751832464596e-07,
-4.996129262710179701e-07,
-4.972600131405970812e-07,
-4.948973913589726458e-07,
-4.925252163204334515e-07,
-4.901436432397649579e-07,
-4.877528271454765269e-07,
-4.853529228730506761e-07,
-4.829440850582201782e-07,
-4.805264681303101704e-07,
-4.781002263055659699e-07,
-4.756655135805432525e-07,
-4.732224837254955305e-07,
-4.707712902778706874e-07,
-4.683120865357223318e-07,
-4.658450255512726115e-07,
-4.633702601244278591e-07,
-4.608879427963659167e-07,
-4.583982258431194385e-07,
-4.559012612692587716e-07,
-4.533972008015285152e-07,
-4.508861958825846646e-07,
-4.483683976647296916e-07,
-4.458439570036682165e-07,
-4.433130244523581853e-07,
-4.407757502548381162e-07,
-4.382322843400862702e-07,
-4.356827763159874467e-07,
-4.331273754632487990e-07,
-4.305662307293776418e-07,
-4.279994907227414739e-07,
-4.254273037066071954e-07,
-4.228498175932105538e-07,
-4.202671799379471918e-07,
-4.176795379334659692e-07,
-4.150870384039331731e-07,
-4.124898277992400835e-07,
-4.098880521892947120e-07,
-4.072818572583052825e-07,
-4.046713882991790140e-07,
-4.020567902078620350e-07,
-3.994382074777995756e-07,
-3.968157841943798026e-07,
-3.941896640294461046e-07,
-3.915599902358122358e-07,
-3.889269056418540110e-07,
-3.862905526461347224e-07,
-3.836510732120467033e-07,
-3.810086088624933911e-07,
-3.783633006746363987e-07,
-3.757152892746383522e-07,
-3.730647148324842901e-07,
-3.704117170568417085e-07,
-3.677564351899312473e-07,
-3.650990080024438572e-07,
-3.624395737885219175e-07,
-3.597782703607358018e-07,
-3.571152350451418639e-07,
-3.544506046763816642e-07,
-3.517845155927761135e-07,
-3.491171036315140613e-07,
-3.464485041238147316e-07,
-3.437788518901955621e-07,
-3.411082812357694237e-07,
-3.384369259455416292e-07,
-3.357649192797817984e-07,
-3.330923939694333626e-07,
-3.304194822115422868e-07,
-3.277463156647441843e-07,
-3.250730254448178699e-07,
-3.223997421202230842e-07,
-3.197265957077266280e-07,
-3.170537156680142013e-07,
-3.143812309014500513e-07,
-3.117092697437258165e-07,
-3.090379599617033952e-07,
-3.063674287491919569e-07,
-3.036978027228219386e-07,
-3.010292079179068657e-07,
-2.983617697844422327e-07,
-2.956956131830241813e-07,
-2.930308623809219670e-07,
-2.903676410481240094e-07,
-2.877060722534160239e-07,
-2.850462784605828731e-07,
-2.823883815245724602e-07,
-2.797325026877001216e-07,
-2.770787625759848387e-07,
-2.744272811954280105e-07,
-2.717781779283535302e-07,
-2.691315715298622639e-07,
-2.664875801242488895e-07,
-2.638463212014596053e-07,
-2.612079116136922450e-07,
-2.585724675718838971e-07,
-2.559401046423967298e-07,
-2.533109377436360530e-07,
-2.506850811427683831e-07,
-2.480626484524263263e-07,
-2.454437526275566631e-07,
-2.428285059621801822e-07,
-2.402170200863171102e-07,
-2.376094059628691832e-07,
-2.350057738845927478e-07,
-2.324062334710691629e-07,
-2.298108936657649861e-07,
-2.272198627331329775e-07,
-2.246332482557178142e-07,
-2.220511571313259416e-07,
-2.194736955702534463e-07,
-2.169009690925126849e-07,
-2.143330825251493867e-07,
-2.117701399996011547e-07,
-2.092122449490600172e-07,
-2.066595001059089350e-07,
-2.041120074991606654e-07,
-2.015698684520349831e-07,
-1.990331835794390744e-07,
-1.965020527856323478e-07,
-1.939765752618286413e-07,
-1.914568494839053434e-07,
-1.889429732100841105e-07,
-1.864350434787728651e-07,
-1.839331566063013332e-07,
-1.814374081848429011e-07,
-1.789478930802844076e-07,
-1.764647054301375457e-07,
-1.739879386415844932e-07,
-1.715176853894679824e-07,
-1.690540376143371427e-07,
-1.665970865206143887e-07,
-1.641469225747214126e-07,
-1.617036355032457818e-07,
-1.592673142912421610e-07,
-1.568380471804777895e-07,
-1.544159216677330419e-07,
-1.520010245032329083e-07,
-1.495934416889795042e-07,
-1.471932584772696570e-07,
-1.448005593691486737e-07,
-1.424154281129690348e-07,
-1.400379477029233071e-07,
-1.376682003777339423e-07,
-1.353062676192383351e-07,
-1.329522301511576340e-07,
-1.306061679378048843e-07,
-1.282681601828891757e-07,
-1.259382853283204531e-07,
-1.236166210530928087e-07,
-1.213032442722190741e-07,
-1.189982311356551542e-07,
-1.167016570273045652e-07,
-1.144135965640631401e-07,
-1.121341235948722840e-07,
-1.098633111998510967e-07,
-1.076012316894790513e-07,
-1.053479566037679408e-07,
-1.031035567115224578e-07,
-1.008681020095959434e-07,
-9.864166172223154154e-08,
-9.642430430044873533e-08,
-9.421609742141590724e-08,
-9.201710798790867487e-08,
-8.982740212780445048e-08,
-8.764704519358142102e-08,
-8.547610176190389902e-08,
-8.331463563324712669e-08,
-8.116270983151930072e-08,
-7.902038660375401991e-08,
-7.688772741984876373e-08,
-7.476479297230374149e-08,
-7.265164317604658298e-08,
-7.054833716829560884e-08,
-6.845493330842018921e-08,
-6.637148917788015443e-08,
-6.429806158015576924e-08,
-6.223470654081328515e-08,
-6.018147930747472525e-08,
-5.813843434996179371e-08,
-5.610562536037877258e-08,
-5.408310525329052440e-08,
-5.207092616588070870e-08,
-5.006913945825099641e-08,
-4.807779571362271658e-08,
-4.609694473871045755e-08,
-4.412663556404464086e-08,
-4.216691644433219185e-08,
-4.021783485893574861e-08,
-3.827943751230757436e-08,
-3.635177033446494818e-08,
-3.443487848157963368e-08,
-3.252880633652612113e-08,
-3.063359750946706619e-08,
-2.874929483855499710e-08,
-2.687594039058986707e-08,
-2.501357546171638738e-08,
-2.316224057824240677e-08,
-2.132197549736501061e-08,
-1.949281920806151351e-08,
-1.767480993192207946e-08,
-1.586798512407024487e-08,
-1.407238147406689458e-08,
-1.228803490694432861e-08,
-1.051498058414832826e-08,
-8.753252904642081593e-09,
-7.002885505952706649e-09,
-5.263911265302983461e-09,
-3.536362300736567822e-09,
 0.0 /* Need a final zero coefficient */
}
} ; /* mid_qual_coeffs */

