package App::InteractivePerlTutorial::Chapter::IO::STDIN;

use 5.014000;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'Standard Input';
use constant EXERCISES => [
	{ statement => "Write a program that reads numbers from STDIN\nand prints them on one line, separated by spaces", hint => 'Use array string interpolation', solution => <<'SOL', input => "1\n2\n3\n4\n5\n6\n7\n8\n", check => sub { $_[0] eq '1 2 3 4 5 6 7 8' } }
my @numbers = <>;
chomp @numbers;
print "@numbers"
SOL
];

1;
__DATA__

=encoding utf-8

=head1 Reading from the Standard Input

Reading from the standard input is easy. We will use the <STDIN> operator:

E<bull> Evaluating this operator in B<scalar context> gives you the next line of input. For example, to read a line from STDIN and then chomp it, you can do:

  $line = <STDIN>;
  chomp $line);

or, more concisely:

  chomp($line = <STDIN>);

E<bull> Evaluating <STDIN> in B<list context> gives you all of the (remaining) lines of input as a list — each element of the list is one line:

  foreach (<STDIN>) {
    print " $_"
  }

Note: there's no connection between the line-input operator and Perl's favorite default variable; in this case the default variable for foreach is $_, so in this loop, you see each line of input in $_, one after the other.


=cut
