# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20250323211829;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]
            )|
            9(?:
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3(?:
                [045]|
                9(?:
                  [0-58]|
                  6[4-9]|
                  7[0-35689]
                )
              )|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9[0169]
              )|
              3(?:
                [29]|
                60|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[2-57-9]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                7(?:
                  2[2-468]|
                  3[78]
                )|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              8294|
              96
            )[1-3]|
            2(?:
              57|
              93
            )[015-9]|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              8292|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{ja} = {"818978", "伯方",
"815586", "下田",
"815959", "亀山",
"812879", "烏山",
"81937", "北九州",
"818876", "土佐山田",
"817674", "羽咋",
"818369", "宇部",
"815999", "津",
"812412", "喜多方",
"812796", "渋川",
"812853", "小山",
"812977", "竜ケ崎",
"815973", "尾鷲",
"817943", "加古川",
"812893", "宇都宮",
"817940", "加古川",
"812890", "宇都宮",
"819804", "名護",
"81182", "横手",
"817995", "洲本",
"81191", "一関",
"817955", "三田",
"818556", "江津",
"812559", "安塚",
"818596", "米子",
"81569", "半田",
"818894", "須崎",
"812417", "会津山口",
"811535", "厚岸",
"819935", "加世田",
"81565", "豊田",
"812573", "柏崎",
"812570", "小出",
"812648", "長野",
"819668", "水俣",
"812972", "水海道",
"812955", "常陸大宮",
"815744", "美濃加茂",
"818585", "倉吉",
"818548", "石見大田",
"814225", "武蔵野三鷹",
"818673", "福渡",
"812995", "石岡",
"81246", "いわき",
"81134", "小樽",
"811376", "八雲",
"811869", "大館",
"81944", "瀬高",
"812696", "飯山",
"818244", "三次",
"812656", "伊那",
"818944", "八幡浜",
"817685", "輪島",
"8198291", "延岡",
"812547", "村上",
"81878", "高松",
"814704", "館山",
"811939", "宮古",
"819826", "日向",
"81832", "下関",
"819723", "佐伯",
"812674", "小諸",
"817366", "岩出",
"81899", "松山",
"81825", "広島",
"811528", "美幌",
"812748", "富岡",
"811394", "松前",
"811354", "余市",
"812785", "沼田",
"8125481", "村上",
"812542", "新発田",
"812243", "白石",
"811563", "本別",
"819963", "川内",
"812485", "白河",
"817712", "亀岡",
"81552", "甲府",
"819787", "国東",
"818202", "柳井",
"817496", "長浜",
"81545", "富士",
"81549", "静岡",
"817456", "大和高田",
"812617", "大町",
"81766", "高岡",
"811464", "静内",
"81478", "佐原",
"817734", "福知山",
"819593", "大瀬戸",
"817914", "相生",
"811552", "帯広",
"811336", "石狩",
"819952", "大口",
"811953", "二戸",
"811877", "大曲",
"819553", "伊万里",
"81222", "仙台",
"812565", "三条",
"81425", "立川",
"817717", "園部",
"81281", "宇都宮",
"811945", "久慈",
"81292", "水戸",
"81495", "本庄",
"81429", "所沢",
"812612", "大町",
"81848", "尾道",
"81235", "鶴岡",
"81432", "千葉",
"819782", "豊後高田",
"818207", "久賀",
"817969", "浜坂",
"811584", "遠軽",
"81167", "富良野",
"817474", "五条",
"811646", "羽幌",
"819957", "加治木",
"81276", "太田",
"811557", "十勝池田",
"81792", "姫路",
"814770", "市川",
"819687", "玉名",
"815738", "中津川",
"812378", "寒河江",
"8111", "札幌",
"81722", "堺",
"811855", "能代",
"81484", "川口",
"815396", "浜松",
"812937", "水戸",
"819949", "大根占",
"817612", "小松",
"818266", "千代田",
"811549", "釧路",
"81739", "田辺",
"812237", "仙台",
"817908", "播磨山崎",
"812474", "石川",
"818512", "西郷",
"812839", "佐野",
"81468", "横須賀",
"81776", "福井",
"81933", "北九州",
"818836", "脇町",
"817703", "敦賀",
"818377", "下関",
"815766", "下呂",
"81143", "室蘭",
"811658", "上川",
"818665", "高梁",
"814289", "青梅",
"817485", "八日市",
"819975", "名瀬",
"819682", "山鹿",
"812232", "岩沼",
"817617", "加賀",
"812932", "高萩",
"81988", "那覇",
"812389", "米沢",
"819676", "高森",
"81964", "松橋",
"81266", "諏訪",
"81177", "青森",
"818372", "長門",
"818473", "甲山",
"812914", "鉾田",
"8186697", "倉敷",
"814757", "東金",
"81721", "富田林",
"8188095", "土佐清水",
"819595", "有川",
"818268", "千代田",
"81424", "武蔵野三鷹",
"819555", "唐津",
"815398", "浜松",
"811955", "二戸",
"81494", "秩父",
"814797", "八日市場",
"81936", "北九州",
"8147957", "八日市場",
"812837", "佐野",
"812376", "寒河江",
"81234", "酒田",
"815736", "中津川",
"811656", "美深",
"815768", "下呂",
"8186999", "岡山瀬戸",
"818564", "益田",
"818838", "阿波池田",
"814282", "青梅",
"812939", "水戸",
"812967", "笠間",
"81975", "大分",
"812483", "白河",
"812382", "米沢",
"8112399", "栗山",
"812239", "仙台",
"811547", "白糠",
"815562", "鰍沢青柳",
"817906", "播磨山崎",
"819947", "志布志",
"81979", "中津",
"814792", "銚子",
"818388", "田万川",
"819744", "三重",
"814752", "茂原",
"81263", "松本",
"81544", "富士宮",
"81928", "福岡",
"812832", "佐野",
"81998", "鹿児島",
"814287", "青梅",
"819942", "大根占",
"81250", "新津",
"812563", "三条",
"811542", "釧路",
"812560", "糸魚川",
"814994", "三宅",
"819543", "武雄",
"812387", "長井",
"812962", "下館",
"819678", "矢部",
"811943", "岩泉",
"817705", "小浜",
"81551", "韮崎",
"817458", "大和榛原",
"81763", "福野",
"817722", "宮津",
"818663", "総社",
"818660", "岡山瀬戸",
"817498", "長浜",
"811366", "寿都",
"818802", "窪川",
"81965", "八代",
"819438", "田主丸",
"817354", "新宮",
"81969", "天草",
"811756", "野辺地",
"81853", "出雲",
"814775", "船橋",
"817962", "豊岡",
"819789", "杵築",
"812619", "大町",
"811853", "男鹿",
"811977", "北上",
"819577", "島原",
"818475", "府中",
"81489", "草加",
"81282", "栃木",
"81485", "熊谷",
"817727", "峰山",
"81734", "和歌山",
"818807", "宿毛",
"811986", "遠野",
"811559", "帯広",
"81537", "掛川",
"81273", "高崎",
"819572", "諫早",
"817239", "寝屋川",
"811972", "水沢",
"819973", "種子島",
"8178", "神戸",
"817967", "八鹿",
"811648", "焼尻",
"817483", "八日市",
"818697", "備前",
"812855", "小山",
"8163", "大阪",
"811378", "今金",
"818657", "笠岡",
"817945", "加古川",
"812895", "宇都宮",
"81857", "鳥取",
"81460", "小田原",
"818684", "津山",
"8186698", "倉敷",
"812549", "津川",
"811237", "栗山",
"818546", "掛合",
"811937", "宮古",
"81564", "岡崎",
"818844", "阿南",
"812658", "伊那",
"81243", "二本松",
"812698", "飯山",
"811867", "鷹巣",
"818652", "倉敷",
"811526", "網走",
"812575", "十日町",
"817368", "岩出",
"818692", "邑久",
"819738", "玖珠",
"819233", "前原",
"811932", "釜石",
"81885", "小松島",
"819828", "高千穂",
"811456", "門別富川",
"819933", "指宿",
"811533", "根室",
"811232", "千歳",
"817464", "吉野",
"81166", "旭川",
"811734", "五所川原",
"817993", "洲本",
"811862", "鹿角",
"81533", "豊橋",
"812746", "富岡",
"817953", "西脇",
"817950", "三田",
"81277", "桐生",
"817683", "輪島",
"818878", "嶺北",
"815588", "修善寺大仁",
"818797", "土庄",
"812979", "竜ケ崎",
"818976", "新居浜",
"815984", "松阪",
"812798", "長野原",
"818583", "倉吉",
"812877", "黒磯",
"815957", "上野",
"812993", "石岡",
"815997", "阿児",
"818675", "久世",
"818367", "宇部",
"812552", "上越",
"814220", "国分寺",
"814223", "武蔵野三鷹",
"818598", "根雨",
"81952", "佐賀",
"815754", "関",
"8112395", "栗山",
"812419", "田島",
"8147950", "八日市場",
"81192", "大船渡",
"8186552", "倉敷",
"819965", "川内",
"818558", "川本",
"812245", "大河原",
"819204", "郷ノ浦",
"8186995", "岡山瀬戸",
"81949", "直方",
"812783", "沼田",
"812780", "前橋",
"818792", "三本松",
"819666", "水俣",
"812646", "長野",
"818954", "宇和島",
"818294", "廿日市",
"812584", "長岡",
"8188099", "土佐清水",
"812557", "新井",
"818362", "宇部",
"818463", "竹原",
"81176", "十和田",
"815992", "鳥羽",
"812872", "大田原",
"819725", "佐伯",
"815952", "上野",
"81743", "奈良",
"811634", "浜頓別",
"811735", "五所川原",
"812642", "木曾福島",
"819662", "人吉",
"812978", "竜ケ崎",
"817465", "吉野",
"81284", "足利",
"818879", "室戸",
"812876", "黒磯",
"815589", "修善寺大仁",
"81725", "和泉",
"815956", "上野",
"819803", "名護",
"815996", "阿児",
"81729", "八尾",
"818366", "宇部",
"81986", "都城",
"812574", "柏崎",
"81268", "上田",
"81923", "福岡",
"818796", "土庄",
"818977", "伯方",
"812799", "長野原",
"818893", "佐川",
"8161", "大阪",
"819667", "水俣",
"817673", "羽咋",
"818845", "丹生谷",
"812647", "長野",
"812556", "糸魚川",
"811551", "十勝池田",
"818559", "川本",
"812418", "会津山口",
"812894", "宇都宮",
"817944", "加古川",
"812854", "小山",
"815974", "尾鷲",
"8199345", "鹿児島",
"81466", "藤沢",
"81778", "武生",
"818972", "新居浜",
"818685", "津山",
"818955", "宇和島",
"812585", "長岡",
"818295", "廿日市",
"81542", "静岡",
"812673", "小諸",
"81555", "吉田",
"819724", "佐伯",
"812742", "藤岡",
"811635", "浜頓別",
"81559", "沼津",
"811866", "鷹巣",
"818696", "備前",
"819964", "川内",
"819205", "厳原",
"811564", "上士幌",
"812244", "白石",
"815755", "関",
"812659", "伊那",
"818656", "笠岡",
"811522", "斜里",
"811236", "千歳",
"818547", "掛合",
"811452", "早来",
"811353", "余市",
"811936", "宮古",
"811393", "松前",
"815985", "松阪",
"8112391", "夕張",
"81439", "木更津",
"818674", "久世",
"81229", "古川",
"81492", "川越",
"81587", "一宮",
"815743", "美濃加茂",
"812747", "富岡",
"81225", "石巻",
"814700", "鴨川",
"811527", "美幌",
"814703", "館山",
"81476", "成田",
"818943", "八幡浜",
"811457", "門別富川",
"818240", "東広島",
"818542", "安来",
"818243", "東広島",
"8182920", "廿日市",
"8188091", "窪川",
"811878", "大曲",
"8168", "大阪",
"811757", "野辺地",
"81124", "芦別",
"81538", "磐田",
"817459", "大和榛原",
"811976", "北上",
"819576", "島原",
"812618", "大町",
"819788", "国東",
"811367", "寿都",
"811982", "花巻",
"811583", "紋別",
"817473", "五条",
"81822", "広島",
"811558", "広尾",
"818565", "益田",
"81892", "久万",
"8186553", "倉敷",
"81596", "伊勢",
"81839", "山口",
"81835", "防府",
"817966", "八鹿",
"811752", "むつ",
"819554", "伊万里",
"81572", "多治見",
"818208", "久賀",
"814240", "国分寺",
"811954", "二戸",
"817238", "寝屋川",
"817726", "峰山",
"819594", "有川",
"818806", "宿毛",
"817733", "福知山",
"81930", "行橋",
"81583", "岐阜",
"817718", "園部",
"811987", "遠野",
"811463", "浦河",
"811362", "倶知安",
"818378", "下関",
"815399", "天竜",
"81927", "福岡",
"811546", "釧路",
"817907", "播磨山崎",
"819946", "鹿屋",
"81157", "北見",
"812238", "仙台",
"814756", "東金",
"812913", "鉾田",
"818474", "府中",
"812938", "水戸",
"814796", "八日市場",
"812836", "佐野",
"812377", "寒河江",
"819688", "玉名",
"815769", "荘川",
"815737", "中津川",
"814286", "相模原",
"817355", "新宮",
"811652", "士別",
"817902", "福崎",
"815566", "身延",
"812386", "長井",
"8153961", "天竜",
"819679", "高森",
"817704", "敦賀",
"817618", "加賀",
"815732", "恵那",
"81562", "尾張横須賀",
"812372", "村山",
"812473", "石川",
"819948", "志布志",
"811548", "弟子屈",
"817475", "下市",
"811585", "遠軽",
"8125489", "津川",
"819672", "熊本一の宮",
"812968", "笠間",
"819743", "三重",
"818837", "阿波池田",
"818376", "美祢",
"81987", "日南",
"815767", "下呂",
"81834", "徳山",
"81270", "伊勢崎",
"819686", "玉名",
"811944", "岩泉",
"819544", "武雄",
"813", "東京",
"812564", "三条",
"812838", "佐野",
"814798", "八日市場",
"81178", "八戸",
"812936", "水戸",
"818382", "萩",
"815397", "浜松",
"818267", "千代田",
"812236", "仙台",
"814758", "東金",
"819677", "矢部",
"8198299", "日向",
"817735", "福知山",
"812388", "長井",
"81942", "久留米",
"811465", "静内",
"81863", "玉野",
"81125", "滝川",
"815762", "下呂",
"81199", "盛岡",
"817915", "相生",
"818832", "鴨島",
"814288", "青梅",
"812484", "白河",
"81467", "藤沢",
"818563", "益田",
"818262", "加計",
"817616", "小松",
"818387", "田万川",
"815392", "浜松",
"81561", "瀬戸",
"819578", "島原",
"8162", "大阪",
"811978", "北上",
"8169", "大阪",
"811642", "石狩深川",
"81260", "阿南町",
"811337", "石狩",
"819437", "田主丸",
"811876", "大曲",
"81184", "本荘",
"817484", "八日市",
"819974", "屋久島",
"819786", "杵築",
"81253", "新潟",
"817497", "長浜",
"817457", "大和高田",
"812616", "大町",
"812475", "石川",
"817968", "浜坂",
"811647", "羽幌",
"81586", "一宮",
"818664", "高梁",
"819432", "八女",
"811332", "当別",
"819956", "加治木",
"812551", "上越",
"811556", "帯広",
"817716", "園部",
"811854", "男鹿",
"818808", "土佐清水",
"817353", "新宮",
"817452", "大和高田",
"81593", "四日市",
"817728", "峰山",
"817492", "彦根",
"818206", "柳井",
"811534", "中標津",
"812697", "飯山",
"811868", "鷹巣",
"819934", "指宿",
"812657", "伊那",
"818895", "須崎",
"811541", "弟子屈",
"818549", "石見大田",
"812546", "村上",
"817954", "西脇",
"811938", "宮古",
"819912", "中之島",
"819822", "延岡",
"8199331", "鹿児島",
"817994", "洲本",
"811238", "栗山",
"819805", "名護",
"811733", "五所川原",
"811377", "八雲",
"817362", "和歌山橋本",
"817463", "吉野",
"819732", "日田",
"818698", "備前",
"81962", "熊本",
"81740", "今津",
"81473", "市川",
"812652", "飯田",
"814281", "相模原",
"812692", "中野",
"818680", "岡山",
"818683", "津山",
"81724", "岸和田貝塚",
"81482", "川口",
"819827", "高千穂",
"818843", "阿南",
"819737", "玖珠",
"817675", "七尾",
"817367", "岩出",
"811372", "鹿部",
"81877", "丸亀",
"81434", "千葉",
"818368", "宇部",
"812784", "沼田",
"815998", "阿児",
"812878", "烏山",
"815958", "亀山",
"811395", "江差",
"81294", "常陸太田",
"812797", "渋川",
"812976", "竜ケ崎",
"81926", "福岡",
"815753", "関",
"8182941", "広島",
"818798", "土庄",
"818464", "竹原",
"818592", "米子",
"815587", "修善寺大仁",
"812580", "十日町",
"818290", "広島",
"812583", "長岡",
"818293", "廿日市",
"818953", "宇和島",
"818877", "嶺北",
"8198295", "日向",
"81983", "高鍋",
"812675", "佐久",
"818552", "浜田",
"815363", "新城",
"812416", "田島",
"818945", "八幡浜",
"818245", "三次",
"812558", "新井",
"81463", "平塚",
"814705", "館山",
"81938", "北九州",
"81554", "大月",
"817684", "輪島",
"812792", "渋川",
"814224", "武蔵野三鷹",
"812994", "石岡",
"815745", "美濃加茂",
"818584", "倉吉",
"812649", "長野",
"818557", "川本",
"815983", "松阪",
"81240", "磐城富岡",
"818872", "室戸",
"818597", "根雨",
"815582", "下田",
"8125485", "津川",
"811874", "角館",
"81272", "前橋",
"817917", "竜野",
"819675", "熊本一の宮",
"817737", "舞鶴",
"817472", "五条",
"811582", "紋別",
"811983", "花巻",
"812614", "大町",
"81436", "市原",
"819784", "豊後高田",
"818385", "萩",
"81924", "福岡",
"81548", "榛原",
"8186691", "倉敷",
"817486", "水口",
"81226", "気仙沼",
"812571", "六日町",
"819976", "名瀬",
"819954", "加治木",
"817912", "相生",
"811554", "帯広",
"818835", "脇町",
"815765", "下呂",
"818666", "井原",
"8183767", "下関",
"811363", "倶知安",
"811462", "浦河",
"811587", "中湧別",
"81940", "宗像",
"81762", "金沢",
"817732", "福知山",
"811958", "岩手",
"818204", "柳井",
"819558", "唐津",
"815395", "浜松",
"81852", "松江",
"819598", "福江",
"818265", "安芸吉田",
"81845", "因島",
"811753", "むつ",
"811856", "能代",
"81849", "福山",
"817714", "亀岡",
"8153977", "天竜",
"818374", "長門",
"812477", "三春",
"811645", "留萌",
"81262", "長野",
"81465", "小田原",
"8112393", "夕張",
"812234", "仙台",
"812934", "高萩",
"818478", "東城",
"8125486", "津川",
"812566", "三条",
"81738", "御坊",
"8186993", "備前",
"811946", "久慈",
"819684", "山鹿",
"819546", "鹿島",
"812917", "水戸",
"819435", "八女",
"818514", "海士",
"815733", "恵那",
"812472", "石川",
"812373", "村山",
"817495", "長浜",
"811653", "士別",
"8198296", "日向",
"8153974", "天竜",
"817614", "小松",
"817455", "大和高田",
"812486", "須賀川",
"81989", "那覇",
"81726", "茨木",
"817903", "福崎",
"81985", "宮崎",
"812974", "水海道",
"8145", "横浜",
"818892", "佐川",
"812786", "沼田",
"819735", "日田",
"819663", "人吉",
"817677", "七尾",
"81742", "奈良",
"817365", "和歌山橋本",
"812578", "六日町",
"812640", "長野",
"812643", "木曾福島",
"819802", "南大東",
"819825", "日向",
"818466", "木江",
"817686", "能都",
"8183768", "下関",
"81568", "春日井",
"8199347", "鹿児島",
"81480", "久喜",
"812695", "中野",
"818973", "新居浜",
"812655", "飯田",
"812414", "柳津",
"811639", "利尻礼文",
"8188093", "窪川",
"817948", "三木",
"812898", "鹿沼",
"811375", "八雲",
"815978", "熊野",
"812858", "真岡",
"817672", "羽咋",
"812956", "常陸大宮",
"812589", "長岡",
"818299", "広島",
"81584", "大垣",
"818586", "倉吉",
"814226", "武蔵野三鷹",
"819807", "沖縄宮古",
"812996", "潮来",
"814707", "大原",
"811523", "斜里",
"8153963", "天竜",
"818689", "岡山",
"812544", "新発田",
"811392", "木古内",
"819728", "臼杵",
"818947", "宇和",
"81875", "観音寺",
"811536", "厚岸",
"818247", "庄原",
"819936", "加世田",
"811352", "余市",
"811453", "早来",
"812248", "大河原",
"81532", "豊橋",
"818555", "江津",
"812672", "小諸",
"819968", "出水",
"818595", "米子",
"817996", "津名",
"817956", "三田",
"812743", "藤岡",
"815747", "美濃白川",
"812795", "渋川",
"814702", "館山",
"814771", "市川",
"818242", "東広島",
"811357", "岩内",
"818543", "安来",
"818678", "新見",
"81578", "神岡",
"818942", "八幡浜",
"811397", "奥尻",
"815585", "下田",
"818875", "土佐山田",
"812677", "佐久",
"81242", "会津若松",
"81898", "今治",
"815742", "美濃加茂",
"81259", "佐渡",
"81828", "広島",
"819938", "加世田",
"819823", "延岡",
"811864", "大館",
"811538", "根室標津",
"819726", "臼杵",
"819913", "硫黄島",
"817363", "和歌山橋本",
"8125482", "村上",
"819665", "人吉",
"818847", "牟岐",
"819733", "日田",
"812645", "木曾福島",
"81162", "稚内",
"811732", "五所川原",
"81833", "下松",
"8198294", "延岡",
"814709", "鴨川",
"811934", "釜石",
"817958", "丹波柏原",
"811234", "千歳",
"818687", "美作",
"817998", "津名",
"81531", "田原",
"81585", "揖斐川",
"818949", "宇和",
"818654", "鴨方",
"81227", "仙台",
"818694", "岡山",
"819966", "出水",
"818249", "東広島",
"812246", "大河原",
"811566", "十勝清水",
"8183766", "下関",
"818676", "久世",
"812679", "佐久",
"81864", "倉敷",
"811737", "鰺ケ沢",
"8125484", "村上",
"8198292", "延岡",
"818842", "阿南",
"818682", "津山",
"818975", "新居浜",
"812693", "中野",
"812653", "飯田",
"81888", "高知",
"81557", "伊東",
"818391", "小郡",
"815994", "阿児",
"812788", "前橋",
"818364", "宇部",
"811632", "天塩",
"8198297", "日向",
"812745", "藤岡",
"81172", "弘前",
"815954", "上野",
"812874", "大田原",
"815987", "三瀬谷",
"815362", "新城",
"818553", "浜田",
"818292", "広島",
"812582", "長岡",
"818593", "米子",
"81183", "湯沢",
"818952", "宇和島",
"811455", "鵡川",
"818794", "三本松",
"81126", "岩見沢",
"811525", "網走",
"815752", "関",
"812576", "十日町",
"81196", "盛岡",
"81956", "佐世保",
"8125487", "津川",
"81420", "所沢",
"811637", "北見枝幸",
"812554", "上越",
"818957", "御荘",
"818873", "安芸",
"812587", "長岡",
"818297", "廿日市",
"815583", "下田",
"819809", "八重山",
"815367", "設楽",
"817688", "能都",
"815982", "松阪",
"812998", "潮来",
"818545", "木次",
"814228", "武蔵野三鷹",
"818588", "郡家",
"81727", "池田",
"812856", "真岡",
"81138", "函館",
"812793", "渋川",
"81594", "桑名",
"815757", "郡上八幡",
"81797", "西宮",
"817946", "三木",
"812896", "鹿沼",
"81948", "飯塚",
"811544", "釧路",
"819944", "鹿屋",
"812964", "下館",
"814992", "伊豆大島",
"8125480", "村上",
"818567", "津和野",
"818383", "萩",
"819673", "熊本一の宮",
"812834", "宇都宮",
"812568", "巻",
"818476", "府中",
"814794", "銚子",
"814754", "茂原",
"819742", "三重",
"81474", "船橋",
"812384", "米沢",
"814776", "船橋",
"814297", "飯能",
"815564", "鰍沢青柳",
"815393", "浜松",
"81723", "堺",
"81793", "姫路",
"8198290", "延岡",
"814284", "立川",
"818263", "加計",
"818562", "益田",
"811365", "倶知安",
"81142", "伊達",
"818398", "小郡",
"81932", "北九州",
"812488", "須賀川",
"819747", "竹田",
"818833", "鴨島",
"817706", "小浜",
"81925", "福岡",
"81929", "福岡",
"815763", "下呂",
"811974", "水沢",
"81433", "千葉",
"819574", "諫早",
"817357", "串本",
"8198298", "日向",
"811643", "石狩深川",
"819978", "徳之島",
"817488", "水口",
"8165", "大阪",
"81286", "宇都宮",
"81984", "小林",
"817964", "豊岡",
"817905", "福崎",
"811655", "名寄",
"818668", "井原",
"81464", "厚木",
"8125488", "津川",
"817493", "彦根",
"81553", "山梨",
"817453", "大和高田",
"817352", "新宮",
"811858", "能代",
"812375", "村山",
"81488", "浦和",
"818804", "土佐中村",
"815735", "恵那",
"817724", "宮津",
"811333", "当別",
"819596", "福江",
"819556", "唐津",
"811589", "興部",
"811956", "岩手",
"819433", "八女",
"8182943", "広島",
"811364", "倶知安",
"811952", "二戸",
"819552", "伊万里",
"811553", "帯広",
"819592", "大瀬戸",
"819953", "大口",
"817713", "亀岡",
"81581", "高富",
"815565", "鰍沢青柳",
"811754", "むつ",
"812385", "米沢",
"81592", "津",
"81487", "浦和",
"817738", "舞鶴",
"814285", "相模原",
"817230", "寝屋川",
"81896", "伊予三島",
"817356", "串本",
"818203", "柳井",
"819979", "徳之島",
"81535", "浜松",
"811984", "花巻",
"812835", "佐野",
"818669", "総社",
"81174", "蟹田",
"814755", "東金",
"819597", "福江",
"8175", "京都",
"819557", "唐津",
"811957", "岩手",
"811873", "角館",
"814795", "銚子",
"812965", "下館",
"811588", "興部",
"811545", "釧路",
"81252", "新潟",
"819945", "鹿屋",
"81245", "福島",
"819783", "豊後高田",
"812613", "大町",
"81249", "郡山",
"8186996", "岡山瀬戸",
"812374", "村山",
"815734", "恵那",
"818805", "土佐中村",
"8144", "川崎",
"81566", "刈谷",
"8112396", "栗山",
"818477", "東城",
"81862", "岡山",
"8125483", "村上",
"817725", "宮津",
"817702", "敦賀",
"817904", "福崎",
"814772", "市川",
"817965", "豊岡",
"812478", "三春",
"814701", "鴨川",
"817613", "小松",
"812569", "巻",
"811654", "名寄",
"819746", "竹田",
"817707", "小浜",
"8198293", "延岡",
"81280", "古河",
"81977", "別府",
"818472", "甲山",
"8152", "名古屋",
"818373", "長門",
"814996", "八丈島",
"814777", "船橋",
"819683", "山鹿",
"811975", "水沢",
"819575", "諫早",
"812933", "高萩",
"812930", "水戸",
"812489", "須賀川",
"812230", "仙台",
"812233", "岩沼",
"81188", "秋田",
"812413", "喜多方",
"81462", "厚木",
"818974", "新居浜",
"812892", "宇都宮",
"817942", "加古川",
"812577", "六日町",
"812789", "前橋",
"815972", "尾鷲",
"817678", "七尾",
"812852", "小山",
"815986", "松阪",
"81728", "寝屋川",
"81798", "西宮",
"81947", "田川",
"811235", "夕張",
"819808", "八重山",
"811935", "釜石",
"815977", "熊野",
"81775", "大津",
"818695", "岡山瀬戸",
"812857", "真岡",
"812973", "水海道",
"8188096", "土佐清水",
"815756", "郡上八幡",
"812572", "柏崎",
"818655", "鴨方",
"81779", "大野",
"817947", "三木",
"812897", "鹿沼",
"811636", "北見枝幸",
"811865", "大館",
"818956", "宇和島",
"812644", "木曾福島",
"812586", "長岡",
"8182942", "広島",
"818296", "広島",
"812999", "潮来",
"815366", "設楽",
"814229", "武蔵野三鷹",
"819664", "人吉",
"815748", "美濃白川",
"818686", "津山",
"8124197", "柳津",
"818544", "木次",
"819967", "出水",
"812247", "大河原",
"811539", "根室標津",
"811567", "十勝清水",
"81426", "八王子",
"818248", "庄原",
"812555", "糸魚川",
"818672", "福渡",
"819727", "臼杵",
"818948", "宇和",
"818846", "丹生谷",
"81934", "北九州",
"814708", "大原",
"81236", "山形",
"81144", "苫小牧",
"817959", "三田",
"818795", "三本松",
"81765", "魚津",
"811454", "鵡川",
"811562", "本別",
"812242", "白石",
"812543", "新発田",
"812678", "佐久",
"819962", "川内",
"811524", "網走",
"81950", "平戸",
"811398", "熊石",
"812744", "藤岡",
"81438", "木更津",
"819722", "佐伯",
"81963", "熊本",
"812875", "大田原",
"815955", "上野",
"815995", "阿児",
"818677", "新見",
"812911", "鉾田",
"818365", "宇部",
"81298", "土浦",
"811736", "五所川原",
"81546", "静岡",
"81228", "築館",
"817466", "十津川",
"81423", "国分寺",
"81493", "東松山",
"8153960", "天竜",
"811374", "森",
"81774", "宇治",
"818688", "美作",
"817997", "津名",
"81471", "柏",
"81577", "高山",
"817957", "丹波柏原",
"81233", "新庄",
"815746", "美濃加茂",
"814706", "大原",
"8188098", "土佐清水",
"81486", "浦和",
"818848", "牟岐",
"8112392", "夕張",
"8164", "大阪",
"812415", "柳津",
"818946", "宇和",
"812654", "飯田",
"81827", "岩国",
"812694", "中野",
"811537", "中標津",
"818246", "三次",
"819937", "加世田",
"819969", "中甑",
"8186992", "備前",
"819734", "日田",
"812676", "佐久",
"818679", "新見",
"817364", "和歌山橋本",
"81543", "静岡",
"817952", "西脇",
"811863", "鹿角",
"817992", "洲本",
"819824", "延岡",
"817468", "上北山",
"814291", "飯能",
"818690", "岡山",
"812975", "水海道",
"818693", "邑久",
"811738", "鰺ケ沢",
"8112394", "夕張",
"81288", "今市",
"811356", "岩内",
"819932", "指宿",
"811233", "千歳",
"811532", "根室",
"8186994", "岡山瀬戸",
"819232", "前原",
"811396", "江差",
"811933", "釜石",
"817676", "七尾",
"81764", "富山",
"81567", "津島",
"815584", "下田",
"818874", "安芸",
"812992", "石岡",
"812550", "安塚",
"814222", "武蔵野三鷹",
"818467", "木江",
"812553", "上越",
"818582", "倉吉",
"812794", "渋川",
"817682", "輪島",
"815988", "三瀬谷",
"812579", "小出",
"812787", "沼田",
"818594", "米子",
"815758", "郡上八幡",
"819208", "対馬佐賀",
"818554", "浜田",
"815953", "上野",
"812957", "大子",
"812873", "大田原",
"818587", "郡家",
"818360", "小郡",
"818462", "竹原",
"814227", "武蔵野三鷹",
"818363", "宇部",
"815993", "鳥羽",
"819806", "沖縄宮古",
"812997", "潮来",
"817687", "能都",
"81992", "鹿児島",
"812545", "村上",
"815368", "設楽",
"812588", "長岡",
"8188090", "窪川",
"818298", "廿日市",
"81922", "福岡",
"818958", "御荘",
"8186997", "岡山瀬戸",
"81935", "北九州",
"818793", "三本松",
"812859", "小山",
"815979", "熊野",
"812782", "沼田",
"812899", "鹿沼",
"817949", "加古川",
"811638", "利尻礼文",
"8112397", "栗山",
"81939", "北九州",
"818896", "須崎",
"818264", "安芸吉田",
"814280", "立川",
"814283", "青梅",
"815394", "浜松",
"8153962", "天竜",
"818205", "柳井",
"815563", "鰍沢青柳",
"812567", "巻",
"81550", "御殿場",
"817715", "亀岡",
"8199343", "鹿児島",
"811947", "久慈",
"81179", "三戸",
"812383", "米沢",
"818493", "尾道",
"812482", "白河",
"819547", "鹿島",
"818490", "尾道",
"815764", "下呂",
"8147955", "八日市場",
"819955", "加治木",
"81563", "西尾",
"818834", "鴨島",
"811555", "帯広",
"8112390", "夕張",
"818568", "津和野",
"812476", "三春",
"81244", "原町",
"818479", "東城",
"81946", "甘木",
"8188097", "土佐清水",
"818384", "萩",
"819785", "豊後高田",
"8128798", "大田原",
"812615", "大町",
"818397", "小郡",
"819542", "武雄",
"812487", "須賀川",
"811942", "岩泉",
"8166", "大阪",
"8126177", "長野",
"812963", "下館",
"81220", "迫",
"819940", "志布志",
"819943", "鹿屋",
"811543", "釧路",
"812562", "三条",
"814753", "茂原",
"814793", "銚子",
"811875", "角館",
"812833", "宇都宮",
"812830", "宇都宮",
"814298", "飯能",
"81737", "湯浅",
"81534", "浜松",
"81958", "長崎",
"819674", "熊本一の宮",
"814998", "小笠原",
"817454", "大和高田",
"817615", "小松",
"817494", "彦根",
"81893", "大洲",
"811852", "男鹿",
"81823", "呉",
"817487", "水口",
"817960", "八鹿",
"819977", "瀬戸内",
"817963", "豊岡",
"818662", "高梁",
"81591", "津",
"819434", "八女",
"81427", "相模原",
"817916", "竜野",
"817723", "宮津",
"81582", "岐阜",
"8188094", "窪川",
"817736", "舞鶴",
"818803", "土佐中村",
"81886", "徳島",
"811466", "えりも",
"8167", "大阪",
"812935", "水戸",
"812235", "仙台",
"819685", "玉名",
"819972", "種子島",
"817482", "八日市",
"819573", "諫早",
"811857", "能代",
"811973", "水沢",
"8124196", "柳津",
"818375", "美祢",
"8188092", "窪川",
"8112398", "栗山",
"818667", "井原",
"819599", "大瀬戸",
"81547", "島田",
"817476", "下市",
"811586", "中湧別",
"81744", "大和高田",
"8186998", "岡山瀬戸",
"811644", "留萌",};
$areanames{en} = {"812994", "Ishioka\,\ Ibaraki",
"8124196", "Yanaizu\,\ Fukushima",
"818375", "Mine\,\ Yamaguchi",
"812649", "Nagano\,\ Nagano",
"818667", "Ibara\,\ Okayama",
"8112398", "Kuriyama\,\ Hokkaido",
"818584", "Kurayoshi\,\ Tottori",
"815745", "Minokamo\,\ Gifu",
"819599", "Oseto\,\ Nagasaki",
"818557", "Kawamoto\,\ Shimane",
"81547", "Shimada\,\ Shizuoka",
"815983", "Matsusaka\,\ Mie",
"817476", "Shimonoseki\,\ Yamaguchi",
"818872", "Muroto\,\ Kochi",
"811586", "Nakayubetsu\,\ Hokkaido",
"81744", "Yamatotakada\,\ Nara",
"8186998", "Seto\,\ Okayama",
"811644", "Rumoi\,\ Hokkaido",
"815582", "Shimoda\,\ Shizuoka",
"8125485", "Tsugawa\,\ Niigata",
"8126174", "Omachi\,\ Nagano",
"812416", "Tajima\,\ Fukushima",
"812935", "Mito\,\ Ibaraki",
"8167", "Osaka\,\ Osaka",
"818945", "Yawatahama\,\ Ehime",
"812235", "Sendai\,\ Miyagi",
"818245", "Miyoshi\,\ Hiroshima",
"81463", "Hiratsuka\,\ Kanagawa",
"819685", "Tamana\,\ Kumamoto",
"814705", "Tateyama\,\ Chiba",
"81938", "Kitakyushu\,\ Fukuoka",
"817482", "Yokaichi\,\ Shiga",
"81554", "Otsuki\,\ Yamanashi",
"817684", "Wajima\,\ Ishikawa",
"819573", "Isahaya\,\ Nagasaki",
"811973", "Mizusawa\,\ Iwate",
"811857", "Noshiro\,\ Akita",
"8153967", "Hamamatsu\,\ Shizuoka",
"812792", "Shibukawa\,\ Gunma",
"819434", "Yame\,\ Fukuoka",
"81591", "Tsu\,\ Mie",
"818662", "Takahashi\,\ Okayama",
"81427", "Sagamihara\,\ Kanagawa",
"81582", "Gifu\,\ Gifu",
"817723", "Miyazu\,\ Kyoto",
"818798", "Tonosho\,\ Kagawa",
"818464", "Takehara\,\ Hiroshima",
"812580", "Tokamachi\,\ Niigata",
"818290", "Hiroshima\,\ Hiroshima",
"818592", "Yonago\,\ Tottori",
"818293", "Hatsukaichi\,\ Hiroshima",
"812583", "Nagaoka\,\ Niigata",
"817736", "Maizuru\,\ Kyoto",
"8198295", "Hyuga\,\ Miyazaki",
"818953", "Uwajima\,\ Ehime",
"81886", "Tokushima\,\ Tokushima",
"812675", "Saku\,\ Nagano",
"81983", "Takanabe\,\ Miyazaki",
"811466", "Erimo\,\ Hokkaido",
"818552", "Hamada\,\ Shimane",
"815363", "Shinshiro\,\ Aichi",
"812784", "Numata\,\ Gunma",
"81434", "Chiba\,\ Chiba",
"818368", "Ube\,\ Yamaguchi",
"817454", "Yamatotakada\,\ Nara",
"8126172", "Omachi\,\ Nagano",
"817615", "Komatsu\,\ Ishikawa",
"815998", "Ago\,\ Mie",
"812878", "Nasukarasuyama\,\ Tochigi",
"817494", "Hikone\,\ Shiga",
"815958", "Kameyama\,\ Mie",
"811395", "Esashi\,\ Hokkaido",
"81294", "Hitachiota\,\ Ibaraki",
"811852", "Oga\,\ Akita",
"81893", "Ozu\,\ Ehime",
"812797", "Shibukawa\,\ Gunma",
"81926", "Fukuoka\,\ Fukuoka",
"817487", "Minakuchi\,\ Shiga",
"81823", "Kure\,\ Hiroshima",
"815753", "Sekigahara\,\ Gifu",
"817963", "Toyooka\,\ Hyogo",
"8182941", "Hiroshima\,\ Hiroshima",
"819977", "Setouchi\,\ Kagoshima",
"814753", "Mobara\,\ Chiba",
"819827", "Takachiho\,\ Miyazaki",
"814793", "Choshi\,\ Chiba",
"811875", "Kakunodate\,\ Akita",
"812833", "Utsunomiya\,\ Tochigi",
"819737", "Kusu\,\ Oita",
"818843", "Anan\,\ Tokushima",
"817675", "Nanao\,\ Ishikawa",
"812830", "Utsunomiya\,\ Tochigi",
"814298", "Hanno\,\ Saitama",
"817367", "Iwade\,\ Wakayama",
"81737", "Yuasa\,\ Wakayama",
"81534", "Hamamatsu\,\ Shizuoka",
"81958", "Nagasaki\,\ Nagasaki",
"811372", "Shikabe\,\ Hokkaido",
"814998", "Ogasawara\,\ Tokyo",
"81877", "Marugame\,\ Kagawa",
"819785", "Bungotakada\,\ Oita",
"818384", "Hagi\,\ Yamaguchi",
"81473", "Ichikawa\,\ Chiba",
"812652", "Iida\,\ Nagano",
"8153964", "Hamamatsu\,\ Shizuoka",
"8128798", "Otawara\,\ Tochigi",
"814281", "Sagamihara\,\ Kanagawa",
"818680", "Okayama\,\ Okayama",
"812692", "Nakano\,\ Nagano",
"812615", "Omachi\,\ Nagano",
"818683", "Tsuyama\,\ Okayama",
"812487", "Sukagawa\,\ Fukushima",
"818397", "Ogori\,\ Yamaguchi",
"819542", "Takeo\,\ Saga",
"811942", "Iwaizumi\,\ Iwate",
"8166", "Osaka\,\ Osaka",
"81482", "Kawaguchi\,\ Saitama",
"812963", "Shimodate\,\ Ibaraki",
"819940", "Shibushi\,\ Kagoshima",
"819943", "Kanoya\,\ Kagoshima",
"811543", "Kushiro\,\ Hokkaido",
"812562", "Sanjo\,\ Niigata",
"817954", "Nishiwaki\,\ Hyogo",
"815764", "Gero\,\ Gifu",
"811938", "Miyako\,\ Iwate",
"819955", "Kajiki\,\ Kagoshima",
"819822", "Nobeoka\,\ Miyazaki",
"8147955", "Yokaichiba\,\ Chiba",
"81563", "Nishio\,\ Aichi",
"8199331", "Kagoshima\,\ Kagoshima",
"818834", "Kamojima\,\ Tokushima",
"817994", "Sumoto\,\ Hyogo",
"819805", "Nago\,\ Okinawa",
"818568", "Tsuwano\,\ Shimane",
"811238", "Kuriyama\,\ Hokkaido",
"8112390", "Yubari\,\ Hokkaido",
"811555", "Obihiro\,\ Hokkaido",
"812476", "Miharu\,\ Fukushima",
"811733", "Goshogawara\,\ Aomori",
"81244", "Hobara\,\ Fukushima",
"811377", "Yakumo\,\ Hokkaido",
"818479", "Tojo\,\ Hiroshima",
"81946", "Amagi\,\ Fukuoka",
"8188097", "Tosashimizu\,\ Kochi",
"817463", "Yoshino\,\ Nara",
"818698", "Bizen\,\ Okayama",
"81962", "Kumamoto\,\ Kumamoto",
"819732", "Hita\,\ Oita",
"81740", "Imazu\,\ Shiga",
"812697", "Iiyama\,\ Nagano",
"811534", "Nakashibetsu\,\ Hokkaido",
"811868", "Takanosu\,\ Akita",
"814280", "Tachikawa\,\ Tokyo",
"814283", "Ome\,\ Tokyo",
"819934", "Ibusuki\,\ Kagoshima",
"812657", "Ina\,\ Nagano",
"815394", "Hamamatsu\,\ Shizuoka",
"818895", "Susaki\,\ Kochi",
"818205", "Yanai\,\ Yamaguchi",
"811541", "Teshikaga\,\ Hokkaido",
"81550", "Gotenba\,\ Shizuoka",
"817715", "Kameoka\,\ Kyoto",
"812546", "Murakami\,\ Niigata",
"8199343", "Kagoshima\,\ Kagoshima",
"811947", "Kuji\,\ Iwate",
"81179", "Sannohe\,\ Aomori",
"818493", "Onomichi\,\ Hiroshima",
"812383", "Yonezawa\,\ Yamagata",
"819547", "Kashima\,\ Saga",
"818490", "Onomichi\,\ Hiroshima",
"812482", "Shirakawa\,\ Fukushima",
"817687", "Noto\,\ Ishikawa",
"81992", "Kagoshima\,\ Kagoshima",
"815368", "Shitara\,\ Aichi",
"812545", "Murakami\,\ Niigata",
"817716", "Sonobe\,\ Kyoto",
"811854", "Oga\,\ Akita",
"81922", "Fukuoka\,\ Fukuoka",
"818298", "Hatsukaichi\,\ Hiroshima",
"812588", "Nagaoka\,\ Niigata",
"818808", "Tosashimizu\,\ Kochi",
"8186997", "Seto\,\ Okayama",
"818958", "Misho\,\ Ehime",
"817353", "Shingu\,\ Fukuoka",
"817452", "Yamatotakada\,\ Nara",
"81935", "Kitakyushu\,\ Fukuoka",
"812859", "Oyama\,\ Tochigi",
"81593", "Yokkaichi\,\ Mie",
"815979", "Kumano\,\ Mie",
"812782", "Numata\,\ Gunma",
"817949", "Kakogawa\,\ Hyogo",
"812899", "Kanuma\,\ Tochigi",
"8112397", "Kuriyama\,\ Hokkaido",
"818896", "Susaki\,\ Kochi",
"81939", "Kitakyushu\,\ Fukuoka",
"817492", "Hikone\,\ Shiga",
"818206", "Yanai\,\ Yamaguchi",
"812475", "Ishikawa\,\ Fukushima",
"817968", "Hamasaka\,\ Hyogo",
"818594", "Yonago\,\ Tottori",
"811647", "Haboro\,\ Hokkaido",
"818554", "Hamada\,\ Shimane",
"8153968", "Hamamatsu\,\ Shizuoka",
"812873", "Otawara\,\ Tochigi",
"81586", "Ichinomiya\,\ Aichi",
"812957", "Daigo\,\ Ibaraki",
"818587", "Koge\,\ Tottori",
"819432", "Yame\,\ Fukuoka",
"818664", "Takahashi\,\ Okayama",
"819956", "Kajiki\,\ Kagoshima",
"811332", "Tobetsu\,\ Hokkaido",
"818360", "Ogori\,\ Yamaguchi",
"818462", "Takehara\,\ Hiroshima",
"812551", "Joetsu\,\ Niigata",
"818363", "Ube\,\ Yamaguchi",
"815993", "Toba\,\ Mie",
"812997", "Itako\,\ Ibaraki",
"811556", "Obihiro\,\ Hokkaido",
"817484", "Yokaichi\,\ Shiga",
"819974", "Yakushima\,\ Kagoshima",
"812794", "Shibukawa\,\ Gunma",
"817682", "Wajima\,\ Ishikawa",
"819786", "Kitsuki\,\ Oita",
"817497", "Nagahama\,\ Shiga",
"81253", "Niigata\,\ Niigata",
"812787", "Numata\,\ Gunma",
"812616", "Omachi\,\ Nagano",
"817457", "Yamatotakada\,\ Nara",
"8162", "Osaka\,\ Osaka",
"819578", "Shimabara\,\ Nagasaki",
"817676", "Nanao\,\ Ishikawa",
"8126170", "Omachi\,\ Nagano",
"81764", "Toyama\,\ Toyama",
"811978", "Kitakami\,\ Iwate",
"81567", "Tsushima\,\ Aichi",
"8169", "Osaka\,\ Osaka",
"815584", "Shimoda\,\ Shizuoka",
"81260", "Anan\,\ Nagano",
"818874", "Aki\,\ Kochi",
"812992", "Ishioka\,\ Ibaraki",
"818467", "Mima\,\ Tokushima",
"811337", "Ishikari\,\ Hokkaido",
"812550", "Yasuzuka\,\ Niigata",
"812553", "Joetsu\,\ Niigata",
"819437", "Tanushimaru\,\ Fukuoka",
"818582", "Kurayoshi\,\ Tottori",
"811876", "Omagari\,\ Akita",
"81184", "Yurihonjo\,\ Akita",
"817468", "Kamikitayama\,\ Nara",
"814291", "Hanno\,\ Saitama",
"818690", "Okayama\,\ Okayama",
"818693", "Oku\,\ Okayama",
"812484", "Shirakawa\,\ Fukushima",
"8112394", "Yubari\,\ Hokkaido",
"811356", "Iwanai\,\ Hokkaido",
"819932", "Ibusuki\,\ Kagoshima",
"81467", "Fujisawa\,\ Kanagawa",
"81288", "Imabari\,\ Ehime",
"811233", "Chitose\,\ Hokkaido",
"818563", "Masuda\,\ Shimane",
"817616", "Komatsu\,\ Ishikawa",
"818262", "Kake\,\ Hiroshima",
"811532", "Nemuro\,\ Hokkaido",
"8186994", "Seto\,\ Okayama",
"819232", "Maebaru\,\ Fukuoka",
"818387", "Tamagawa\,\ Yamaguchi",
"815392", "Hamamatsu\,\ Shizuoka",
"81561", "Seto\,\ Aichi",
"811396", "Esashi\,\ Hokkaido",
"811933", "Kamaishi\,\ Iwate",
"8198299", "Hyuga\,\ Miyazaki",
"817735", "Fukuchiyama\,\ Kyoto",
"8126178", "Omachi\,\ Nagano",
"81942", "Kurume\,\ Fukuoka",
"812388", "Nagai\,\ Yamagata",
"812676", "Saku\,\ Nagano",
"811465", "Shizunai\,\ Hokkaido",
"819734", "Hita\,\ Oita",
"818679", "Niimi\,\ Okayama",
"81863", "Tamano\,\ Okayama",
"81543", "Shizuoka\,\ Shizuoka",
"81125", "Takikawa\,\ Hokkaido",
"815762", "Gero\,\ Gifu",
"817952", "Nishiwaki\,\ Hyogo",
"81199", "Morioka\,\ Iwate",
"817915", "Aioi\,\ Hyogo",
"811863", "Kazuno\,\ Akita",
"817992", "Sumoto\,\ Hyogo",
"818832", "Kamojima\,\ Tokushima",
"814288", "Ome\,\ Tokyo",
"819824", "Nobeoka\,\ Miyazaki",
"811944", "Iwaizumi\,\ Iwate",
"819686", "Tamana\,\ Kumamoto",
"819544", "Takeo\,\ Saga",
"813", "Tokyo",
"8153973", "Hamamatsu\,\ Shizuoka",
"8188098", "Tosashimizu\,\ Kochi",
"812564", "Sanjo\,\ Niigata",
"812838", "Sano\,\ Tochigi",
"81486", "Urawa\,\ Saitama",
"8164", "Osaka\,\ Osaka",
"8112392", "Yubari\,\ Hokkaido",
"81178", "Hachinohe\,\ Aomori",
"814798", "Yokaichiba\,\ Chiba",
"812415", "Yanaizu\,\ Fukushima",
"812936", "Mito\,\ Ibaraki",
"818382", "Hagi\,\ Yamaguchi",
"812654", "Iida\,\ Nagano",
"818946", "Uwajima\,\ Ehime",
"81827", "Iwakuni\,\ Yamaguchi",
"811537", "Nakashibetsu\,\ Hokkaido",
"812694", "Nakano\,\ Nagano",
"812236", "Sendai\,\ Miyagi",
"8186992", "Bizen\,\ Okayama",
"819937", "Kaseda\,\ Kagoshima",
"818246", "Miyoshi\,\ Hiroshima",
"814758", "Togane\,\ Chiba",
"819948", "Shibushi\,\ Kagoshima",
"81423", "Kokubunji\,\ Tokyo",
"811548", "Teshikaga\,\ Hokkaido",
"817475", "Shimonoseki\,\ Yamaguchi",
"811585", "Engaru\,\ Hokkaido",
"8125489", "Tsugawa\,\ Niigata",
"811374", "Mori\,\ Hokkaido",
"812968", "Kasama\,\ Ibaraki",
"81493", "Higashimatsuyama\,\ Saitama",
"818688", "Mimasaka\,\ Okayama",
"81774", "Uji\,\ Kyoto",
"81471", "Kashiwa\,\ Chiba",
"817997", "Tsuna\,\ Hyogo",
"819743", "Mie\,\ Oita",
"81987", "Nichinan\,\ Miyazaki",
"815767", "Gero\,\ Gifu",
"818376", "Mine\,\ Yamaguchi",
"81577", "Takayama\,\ Gifu",
"81233", "Shinjo\,\ Yamagata",
"81834", "Tokuyama\,\ Yamaguchi",
"81270", "Isesaki\,\ Gunma",
"815746", "Minokamo\,\ Gifu",
"81438", "Kisarazu\,\ Chiba",
"812744", "Fujioka\,\ Gunma",
"811398", "Kumaishi\,\ Hokkaido",
"81963", "Kumamoto\,\ Kumamoto",
"812875", "Otawara\,\ Tochigi",
"819722", "Saiki\,\ Oita",
"819679", "Takamori\,\ Kumamoto",
"817618", "Kaga\,\ Ishikawa",
"818677", "Niimi\,\ Okayama",
"812911", "Hokota\,\ Ibaraki",
"815995", "Ago\,\ Mie",
"817704", "Tsuruga\,\ Fukui",
"818365", "Ube\,\ Yamaguchi",
"81298", "Tsuchiura\,\ Ibaraki",
"815732", "Ena\,\ Gifu",
"812372", "Murayama\,\ Yamagata",
"811736", "Goshogawara\,\ Aomori",
"81546", "Shizuoka\,\ Shizuoka",
"812473", "Ishikawa\,\ Fukushima",
"817466", "Totsukawa\,\ Nara",
"814286", "Sagamihara\,\ Kanagawa",
"811454", "Mukawa\,\ Hokkaido",
"81765", "Uozu\,\ Toyama",
"817355", "Shingu\,\ Fukuoka",
"811652", "Shibetsu\,\ Hokkaido",
"817902", "Fukusaki\,\ Hyogo",
"812242", "Shiroishi\,\ Miyagi",
"811562", "Honbetsu\,\ Hokkaido",
"812543", "Shibata\,\ Niigata",
"819962", "Satsumasendai\,\ Kagoshima",
"812678", "Saku\,\ Nagano",
"815566", "Minobu\,\ Yamanashi",
"811524", "Abashiri\,\ Hokkaido",
"81950", "Hirado\,\ Nagasaki",
"812386", "Nagai\,\ Yamagata",
"812238", "Sendai\,\ Miyagi",
"818248", "Shobara\,\ Hiroshima",
"81426", "Hachioji\,\ Tokyo",
"812555", "Itoigawa\,\ Niigata",
"814756", "Togane\,\ Chiba",
"812913", "Hokota\,\ Ibaraki",
"819727", "Usuki\,\ Oita",
"812938", "Mito\,\ Ibaraki",
"818948", "Uwajima\,\ Ehime",
"818474", "Fuchu\,\ Hiroshima",
"814796", "Yokaichiba\,\ Chiba",
"8153966", "Hamamatsu\,\ Shizuoka",
"81934", "Kitakyushu\,\ Fukuoka",
"812836", "Sano\,\ Tochigi",
"812377", "Sagae\,\ Yamagata",
"81236", "Yamagata\,\ Yamagata",
"81144", "Tomakomai\,\ Hokkaido",
"817959", "Sanda\,\ Hyogo",
"815737", "Nakatsugawa\,\ Gifu",
"815769", "Shokawa\,\ Gifu",
"819688", "Tamana\,\ Kumamoto",
"818378", "Shimonoseki\,\ Yamaguchi",
"818686", "Tsuyama\,\ Okayama",
"8124197", "Yanaizu\,\ Fukushima",
"818544", "Kisuki\,\ Shimane",
"81927", "Fukuoka\,\ Fukuoka",
"819967", "Izumi\,\ Kagoshima",
"811546", "Kushiro\,\ Hokkaido",
"819946", "Kanoya\,\ Kagoshima",
"812247", "Ogawara\,\ Miyagi",
"81157", "Kitami\,\ Hokkaido",
"81572", "Tajimi\,\ Gifu",
"819554", "Imari\,\ Saga",
"814240", "Kokubunji\,\ Tokyo",
"811954", "Ninohe\,\ Iwate",
"817238", "Neyagawa\,\ Osaka",
"8126171", "Omachi\,\ Nagano",
"811865", "Odate\,\ Akita",
"818956", "Uwajima\,\ Ehime",
"81930", "Yukuhashi\,\ Fukuoka",
"818296", "Hiroshima\,\ Hiroshima",
"812586", "Nagaoka\,\ Niigata",
"8182942", "Hiroshima\,\ Hiroshima",
"81583", "Gifu\,\ Gifu",
"817733", "Fukuchiyama\,\ Kyoto",
"818806", "Sukumo\,\ Kochi",
"811987", "Tono\,\ Iwate",
"815366", "Shitara\,\ Aichi",
"817718", "Sonobe\,\ Kyoto",
"812999", "Itako\,\ Ibaraki",
"811463", "Urakawa\,\ Hokkaido",
"811362", "Kutchan\,\ Hokkaido",
"819664", "Hitoyoshi\,\ Kumamoto",
"8153975", "Hamamatsu\,\ Shizuoka",
"819808", "Yaeyama\ District\,\ Okinawa",
"811235", "Yubari\,\ Hokkaido",
"818565", "Masuda\,\ Shimane",
"81822", "Hiroshima\,\ Hiroshima",
"811558", "Hiroo\,\ Hokkaido",
"811935", "Kamaishi\,\ Iwate",
"81892", "Kumakogen\,\ Ehime",
"8186553", "Kurashiki\,\ Okayama",
"818695", "Seto\,\ Okayama",
"815977", "Kumano\,\ Mie",
"81775", "Otsu\,\ Shiga",
"81596", "Ise\,\ Mie",
"812857", "Mooka\,\ Tochigi",
"81839", "Yamaguchi\,\ Yamaguchi",
"8188096", "Tosashimizu\,\ Kochi",
"81835", "Hofu\,\ Yamaguchi",
"812572", "Kashiwazaki\,\ Niigata",
"81779", "Ono\,\ Gifu",
"811752", "Mutsu\,\ Aomori",
"818655", "Kamogata\,\ Okayama",
"812897", "Kanuma\,\ Tochigi",
"817947", "Miki\,\ Hyogo",
"812618", "Omachi\,\ Nagano",
"819788", "Kunisaki\,\ Oita",
"81728", "Neyagawa\,\ Osaka",
"811367", "Suttsu\,\ Hokkaido",
"815986", "Matsusaka\,\ Mie",
"811982", "Hanamaki\,\ Iwate",
"81798", "Nishinomiya\,\ Hyogo",
"8126176", "Omachi\,\ Nagano",
"811583", "Monbetsu\,\ Hokkaido",
"81947", "Tagawa\,\ Fukuoka",
"812413", "Kitakata\,\ Fukushima",
"8182920", "Hatsukaichi\,\ Hiroshima",
"811878", "Omagari\,\ Akita",
"8168", "Osaka\,\ Osaka",
"81462", "Atsugi\,\ Kanagawa",
"818974", "Niihama\,\ Ehime",
"811757", "Noheji\,\ Aomori",
"817942", "Kakogawa\,\ Hyogo",
"812892", "Utsunomiya\,\ Tochigi",
"81124", "Ashibetsu\,\ Hokkaido",
"812577", "Muika\,\ Niigata",
"81538", "Iwata\,\ Shizuoka",
"811976", "Kitakami\,\ Iwate",
"812789", "Maebashi\,\ Gunma",
"815972", "Owase\,\ Mie",
"819576", "Shimabara\,\ Nagasaki",
"812852", "Oyama\,\ Tochigi",
"817678", "Nanao\,\ Ishikawa",
"814700", "Kamogawa\,\ Chiba",
"814703", "Tateyama\,\ Chiba",
"811527", "Bihoro\,\ Hokkaido",
"814777", "Funabashi\,\ Chiba",
"819683", "Yamaga\,\ Kumamoto",
"81476", "Narita\,\ Chiba",
"811975", "Mizusawa\,\ Iwate",
"819575", "Isahaya\,\ Nagasaki",
"812933", "Takahagi\,\ Ibaraki",
"818943", "Yawatahama\,\ Ehime",
"812930", "Mito\,\ Ibaraki",
"812489", "Sukagawa\,\ Fukushima",
"818542", "Yasugi\,\ Shimane",
"812230", "Sendai\,\ Miyagi",
"818240", "Higashi\-ku\,\ Hiroshima",
"812233", "Iwanuma\,\ Miyagi",
"818243", "Higashi\-ku\,\ Hiroshima",
"81188", "Akita\,\ Akita",
"815985", "Matsusaka\,\ Mie",
"8112391", "Yubari\,\ Hokkaido",
"81439", "Kisarazu\,\ Chiba",
"817707", "Obama\,\ Fukui",
"818674", "Kuse\,\ Okayama",
"819746", "Taketa\,\ Oita",
"81280", "Koga\,\ Ibaraki",
"8198293", "Nobeoka\,\ Miyazaki",
"81492", "Kawagoe\,\ Saitama",
"81977", "Beppu\,\ Oita",
"81587", "Ichinomiya\,\ Aichi",
"815743", "Minokamo\,\ Gifu",
"812747", "Tomioka\,\ Gunma",
"81225", "Ishinomaki\,\ Miyagi",
"8152", "Nagoya\,\ Aichi",
"818373", "Nagato\,\ Yamaguchi",
"818696", "Bizen\,\ Okayama",
"819964", "Satsumasendai\,\ Kagoshima",
"817904", "Fukusaki\,\ Hyogo",
"812244", "Shiroishi\,\ Miyagi",
"811564", "Kamishihoro\,\ Hokkaido",
"814772", "Ichikawa\,\ Chiba",
"817965", "Toyooka\,\ Hyogo",
"812659", "Ina\,\ Nagano",
"815755", "Sekigahara\,\ Gifu",
"812478", "Miharu\,\ Fukushima",
"818656", "Kasaoka\,\ Okayama",
"814701", "Kamogawa\,\ Chiba",
"811522", "Shari\,\ Hokkaido",
"817613", "Komatsu\,\ Ishikawa",
"811236", "Chitose\,\ Hokkaido",
"811452", "Hayakita\,\ Hokkaido",
"818547", "Kakeya\,\ Shimane",
"8153979", "Hamamatsu\,\ Shizuoka",
"811353", "Yoichi\,\ Hokkaido",
"811654", "Nayoro\,\ Hokkaido",
"811936", "Miyako\,\ Iwate",
"811393", "Matsumae\,\ Hokkaido",
"812374", "Murayama\,\ Yamagata",
"8186996", "Seto\,\ Okayama",
"818955", "Uwajima\,\ Ehime",
"812585", "Nagaoka\,\ Niigata",
"818295", "Hatsukaichi\,\ Hiroshima",
"815734", "Ena\,\ Gifu",
"81542", "Shizuoka\,\ Shizuoka",
"8144", "Kawasaki\,\ Kanagawa",
"81566", "Kariya\,\ Aichi",
"812673", "Komoro\,\ Nagano",
"818477", "Tojo\,\ Hiroshima",
"8112396", "Kuriyama\,\ Hokkaido",
"819724", "Saiki\,\ Oita",
"81555", "Fujiyoshida\,\ Yamanashi",
"811635", "Hamatonbetsu\,\ Hokkaido",
"812742", "Fujioka\,\ Gunma",
"81862", "Okayama\,\ Okayama",
"8125483", "Murakami\,\ Niigata",
"817725", "Miyazu\,\ Kyoto",
"817702", "Tsuruga\,\ Fukui",
"81559", "Numazu\,\ Shizuoka",
"811866", "Takanosu\,\ Akita",
"812965", "Shimodate\,\ Ibaraki",
"817944", "Kakogawa\,\ Hyogo",
"812894", "Utsunomiya\,\ Tochigi",
"811588", "Okoppe\,\ Hokkaido",
"812854", "Oyama\,\ Tochigi",
"815974", "Owase\,\ Mie",
"81252", "Niigata\,\ Niigata",
"811545", "Kushiro\,\ Hokkaido",
"819945", "Kanoya\,\ Kagoshima",
"8199345", "Kagoshima\,\ Kagoshima",
"81245", "Fukushima\,\ Fukushima",
"81778", "Takefu\,\ Fukui",
"81466", "Fujisawa\,\ Kanagawa",
"819783", "Bungotakada\,\ Oita",
"818685", "Tsuyama\,\ Okayama",
"812613", "Omachi\,\ Nagano",
"818972", "Niihama\,\ Ehime",
"81249", "Koriyama\,\ Fukushima",
"811984", "Hanamaki\,\ Iwate",
"817673", "Hakui\,\ Ishikawa",
"819667", "Minamata\,\ Kumamoto",
"812835", "Sano\,\ Tochigi",
"818669", "Soja\,\ Okayama",
"812647", "Nagano\,\ Nagano",
"812556", "Itoigawa\,\ Niigata",
"814755", "Togane\,\ Chiba",
"81174", "Kanita\,\ Aomori",
"818559", "Kawamoto\,\ Shimane",
"819597", "Fukue\,\ Nagasaki",
"819557", "Karatsu\,\ Saga",
"8175", "Kyoto\,\ Kyoto",
"811873", "Kakunodate\,\ Akita",
"811957", "Iwate\,\ Iwate",
"814795", "Choshi\,\ Chiba",
"817713", "Kameoka\,\ Kyoto",
"811754", "Mutsu\,\ Aomori",
"812385", "Yonezawa\,\ Yamagata",
"81592", "Tsu\,\ Mie",
"812574", "Kashiwazaki\,\ Niigata",
"81268", "Ueda\,\ Nagano",
"817738", "Maizuru\,\ Kyoto",
"81487", "Urawa\,\ Saitama",
"81923", "Fukuoka\,\ Fukuoka",
"817230", "Neyagawa\,\ Osaka",
"814285", "Sagamihara\,\ Kanagawa",
"818796", "Tonosho\,\ Kagawa",
"818977", "Hakata\,\ Ehime",
"812799", "Naganohara\,\ Gunma",
"817356", "Kushimoto\,\ Wakayama",
"81896", "Iyomishima\,\ Ehime",
"819979", "Tokunoshima\,\ Kagoshima",
"818893", "Sakawa\,\ Kochi",
"818203", "Yanai\,\ Yamaguchi",
"81535", "Hamamatsu\,\ Shizuoka",
"8161", "Osaka\,\ Osaka",
"811735", "Goshogawara\,\ Aomori",
"811364", "Kutchan\,\ Hokkaido",
"819662", "Hitoyoshi\,\ Kumamoto",
"817465", "Yoshino\,\ Nara",
"811952", "Ninohe\,\ Iwate",
"81284", "Ashikaga\,\ Tochigi",
"818879", "Muroto\,\ Kochi",
"812876", "Kuroiso\,\ Tochigi",
"81725", "Izumi\,\ Osaka",
"819552", "Imari\,\ Saga",
"819803", "Nago\,\ Okinawa",
"811553", "Obihiro\,\ Hokkaido",
"819592", "Oseto\,\ Nagasaki",
"815996", "Ago\,\ Mie",
"81729", "Yao\,\ Osaka",
"81986", "Miyakonojo\,\ Miyazaki",
"818366", "Ube\,\ Yamaguchi",
"819953", "Okuchi\,\ Kagoshima",
"811858", "Noshiro\,\ Akita",
"819666", "Minamata\,\ Kumamoto",
"818954", "Uwajima\,\ Ehime",
"812375", "Murayama\,\ Yamagata",
"812646", "Nagano\,\ Nagano",
"81488", "Urawa\,\ Saitama",
"815735", "Ena\,\ Gifu",
"812584", "Nagaoka\,\ Niigata",
"818294", "Hatsukaichi\,\ Hiroshima",
"818362", "Ube\,\ Yamaguchi",
"817724", "Miyazu\,\ Kyoto",
"8188099", "Tosashimizu\,\ Kochi",
"818463", "Takehara\,\ Hiroshima",
"811333", "Tobetsu\,\ Hokkaido",
"81176", "Towada\,\ Aomori",
"815992", "Toba\,\ Mie",
"819596", "Fukue\,\ Nagasaki",
"819725", "Saiki\,\ Oita",
"812872", "Otawara\,\ Tochigi",
"819556", "Karatsu\,\ Saga",
"81743", "Nara\,\ Nara",
"811634", "Hamatonbetsu\,\ Hokkaido",
"811956", "Iwate\,\ Iwate",
"811589", "Okoppe\,\ Hokkaido",
"8182943", "Hiroshima\,\ Hiroshima",
"819433", "Yame\,\ Fukuoka",
"815754", "Sekigahara\,\ Gifu",
"81952", "Saga\,\ Saga",
"812419", "Tajima\,\ Fukushima",
"817964", "Toyooka\,\ Hyogo",
"8112395", "Kuriyama\,\ Hokkaido",
"8147950", "Yokaichiba\,\ Chiba",
"8186552", "Kurashiki\,\ Okayama",
"81192", "Ofunato\,\ Iwate",
"819965", "Satsumasendai\,\ Kagoshima",
"818558", "Kawamoto\,\ Shimane",
"817905", "Fukusaki\,\ Hyogo",
"812245", "Ogawara\,\ Miyagi",
"8186995", "Seto\,\ Okayama",
"818668", "Ibara\,\ Okayama",
"81464", "Atsugi\,\ Kanagawa",
"8125488", "Tsugawa\,\ Niigata",
"811655", "Nayoro\,\ Hokkaido",
"817493", "Hikone\,\ Shiga",
"81949", "Nogata\,\ Fukuoka",
"81553", "Yamanashi\,\ Yamanashi",
"817453", "Yamatotakada\,\ Nara",
"817352", "Shingu\,\ Fukuoka",
"812783", "Numata\,\ Gunma",
"812780", "Maebashi\,\ Gunma",
"819978", "Tokunoshima\,\ Kagoshima",
"817488", "Minakuchi\,\ Shiga",
"8165", "Osaka\,\ Osaka",
"815984", "Matsusaka\,\ Mie",
"812798", "Naganohara\,\ Gunma",
"818583", "Kurayoshi\,\ Tottori",
"812877", "Kuroiso\,\ Tochigi",
"81286", "Utsunomiya\,\ Tochigi",
"812993", "Ishioka\,\ Ibaraki",
"818675", "Kuse\,\ Okayama",
"81984", "Kobayashi\,\ Miyazaki",
"815997", "Ago\,\ Mie",
"814220", "Kokubunji\,\ Tokyo",
"812552", "Joetsu\,\ Niigata",
"818367", "Ube\,\ Yamaguchi",
"81433", "Chiba\,\ Chiba",
"811974", "Mizusawa\,\ Iwate",
"819574", "Isahaya\,\ Nagasaki",
"817683", "Wajima\,\ Ishikawa",
"818797", "Tonosho\,\ Kagawa",
"818976", "Niihama\,\ Ehime",
"817357", "Kushimoto\,\ Wakayama",
"8198298", "Hyuga\,\ Miyazaki",
"8126179", "Omachi\,\ Nagano",
"81142", "Date\,\ Hokkaido",
"811365", "Kutchan\,\ Hokkaido",
"817464", "Yoshino\,\ Nara",
"81166", "Asahikawa\,\ Hokkaido",
"812488", "Sukagawa\,\ Fukushima",
"811734", "Goshogawara\,\ Aomori",
"81932", "Kitakyushu\,\ Fukuoka",
"818398", "Ogori\,\ Yamaguchi",
"817706", "Obama\,\ Fukui",
"818833", "Kamojima\,\ Tokushima",
"817993", "Sumoto\,\ Hyogo",
"819747", "Taketa\,\ Oita",
"811862", "Kazuno\,\ Akita",
"81925", "Fukuoka\,\ Fukuoka",
"81929", "Fukuoka\,\ Fukuoka",
"81533", "Toyohashi\,\ Aichi",
"812746", "Tomioka\,\ Gunma",
"817953", "Nishiwaki\,\ Hyogo",
"815763", "Gero\,\ Gifu",
"81277", "Kiryu\,\ Gunma",
"817950", "Sanda\,\ Hyogo",
"818652", "Kurashiki\,\ Okayama",
"812384", "Yonezawa\,\ Yamagata",
"81474", "Funabashi\,\ Chiba",
"811526", "Abashiri\,\ Hokkaido",
"814776", "Funabashi\,\ Chiba",
"812575", "Tokamachi\,\ Niigata",
"814297", "Hanno\,\ Saitama",
"817368", "Iwade\,\ Wakayama",
"819738", "Kusu\,\ Oita",
"818692", "Oku\,\ Okayama",
"815393", "Hamamatsu\,\ Shizuoka",
"819233", "Maebaru\,\ Fukuoka",
"81723", "Sakai\,\ Osaka",
"81885", "Komatsushima\,\ Tokushima",
"811932", "Kamaishi\,\ Iwate",
"8198290", "Nobeoka\,\ Miyazaki",
"819828", "Takachiho\,\ Miyazaki",
"81793", "Himeji\,\ Hyogo",
"819933", "Ibusuki\,\ Kagoshima",
"814284", "Tachikawa\,\ Tokyo",
"811533", "Nemuro\,\ Hokkaido",
"818263", "Kake\,\ Hiroshima",
"811232", "Chitose\,\ Hokkaido",
"818562", "Masuda\,\ Shimane",
"81564", "Okazaki\,\ Aichi",
"818844", "Anan\,\ Tokushima",
"812834", "Utsunomiya\,\ Tochigi",
"818476", "Fuchu\,\ Hiroshima",
"812658", "Ina\,\ Nagano",
"814794", "Choshi\,\ Chiba",
"81243", "Nihonmatsu\,\ Fukushima",
"814754", "Mobara\,\ Chiba",
"819742", "Mie\,\ Oita",
"812698", "Iiyama\,\ Nagano",
"811867", "Takanosu\,\ Akita",
"818697", "Bizen\,\ Okayama",
"811544", "Kushiro\,\ Hokkaido",
"812855", "Oyama\,\ Tochigi",
"819944", "Kanoya\,\ Kagoshima",
"8163", "Osaka\,\ Osaka",
"811378", "Imakane\,\ Hokkaido",
"812964", "Shimodate\,\ Ibaraki",
"818657", "Kasaoka\,\ Okayama",
"812895", "Utsunomiya\,\ Tochigi",
"817945", "Kakogawa\,\ Hyogo",
"81460", "Odawara\,\ Kanagawa",
"81857", "Tottori\,\ Tottori",
"818567", "Tsuwano\,\ Shimane",
"8186698", "Kurashiki\,\ Okayama",
"812549", "Tsugawa\,\ Niigata",
"811237", "Kuriyama\,\ Hokkaido",
"818684", "Tsuyama\,\ Okayama",
"8125480", "Murakami\,\ Niigata",
"8153969", "Hamamatsu\,\ Shizuoka",
"818546", "Kakeya\,\ Shimane",
"811937", "Miyako\,\ Iwate",
"818383", "Hagi\,\ Yamaguchi",
"8153965", "Hamamatsu\,\ Shizuoka",
"812998", "Itako\,\ Ibaraki",
"818545", "Kisuki\,\ Shimane",
"818588", "Koge\,\ Tottori",
"819572", "Isahaya\,\ Nagasaki",
"81727", "Ikeda\,\ Osaka",
"81138", "Hakodate\,\ Hokkaido",
"817239", "Neyagawa\,\ Osaka",
"812856", "Mooka\,\ Tochigi",
"812793", "Shibukawa\,\ Gunma",
"81594", "Kuwana\,\ Mie",
"811972", "Mizusawa\,\ Iwate",
"8178", "Kobe\,\ Hyogo",
"81797", "Nishinomiya\,\ Hyogo",
"817483", "Yokaichi\,\ Shiga",
"81948", "Iizuka\,\ Fukuoka",
"812896", "Kanuma\,\ Tochigi",
"817946", "Miki\,\ Hyogo",
"818475", "Fuchu\,\ Hiroshima",
"8125487", "Tsugawa\,\ Niigata",
"81420", "Tokorozawa\,\ Saitama",
"81489", "Soka\,\ Saitama",
"81485", "Kumagaya\,\ Saitama",
"81282", "Tochigi\,\ Tochigi",
"812554", "Joetsu\,\ Niigata",
"818873", "Aki\,\ Kochi",
"818957", "Misho\,\ Ehime",
"812587", "Nagaoka\,\ Niigata",
"818297", "Hatsukaichi\,\ Hiroshima",
"818807", "Sukumo\,\ Kochi",
"81734", "Wakayama\,\ Wakayama",
"815583", "Shimoda\,\ Shizuoka",
"811559", "Obihiro\,\ Hokkaido",
"811986", "Tono\,\ Iwate",
"815367", "Shitara\,\ Aichi",
"819809", "Yaeyama\ District\,\ Okinawa",
"81537", "Kakegawa\,\ Shizuoka",
"817688", "Noto\,\ Ishikawa",
"81273", "Takasaki\,\ Gunma",
"815982", "Matsusaka\,\ Mie",
"81965", "Yatsushiro\,\ Kumamoto",
"819438", "Tanushimaru\,\ Fukuoka",
"811455", "Mukawa\,\ Hokkaido",
"81969", "Amakusa\,\ Kumamoto",
"817354", "Shingu\,\ Fukuoka",
"811756", "Noheji\,\ Aomori",
"811525", "Abashiri\,\ Hokkaido",
"81853", "Izumo\,\ Shimane",
"81126", "Iwamizawa\,\ Hokkaido",
"817962", "Toyooka\,\ Hyogo",
"814775", "Funabashi\,\ Chiba",
"815752", "Sekigahara\,\ Gifu",
"812576", "Tokamachi\,\ Niigata",
"819789", "Kitsuki\,\ Oita",
"81196", "Morioka\,\ Iwate",
"812619", "Omachi\,\ Nagano",
"811977", "Kitakami\,\ Iwate",
"811853", "Oga\,\ Akita",
"819577", "Shimabara\,\ Nagasaki",
"81956", "Sasebo\,\ Nagasaki",
"817705", "Obama\,\ Fukui",
"81551", "Nirasaki\,\ Yamanashi",
"815994", "Ago\,\ Mie",
"818364", "Ube\,\ Yamaguchi",
"817722", "Miyazu\,\ Kyoto",
"81763", "Fukuno\,\ Toyama",
"812788", "Maebashi\,\ Gunma",
"818663", "Soja\,\ Okayama",
"8198297", "Hyuga\,\ Miyazaki",
"81172", "Hirosaki\,\ Aomori",
"818660", "Seto\,\ Okayama",
"812745", "Fujioka\,\ Gunma",
"811632", "Teshio\,\ Hokkaido",
"817498", "Nagahama\,\ Shiga",
"812874", "Otawara\,\ Tochigi",
"811366", "Suttsu\,\ Hokkaido",
"815362", "Shinshiro\,\ Aichi",
"818553", "Hamada\,\ Shimane",
"812582", "Nagaoka\,\ Niigata",
"818292", "Hiroshima\,\ Hiroshima",
"818593", "Yonago\,\ Tottori",
"818952", "Uwajima\,\ Ehime",
"81183", "Yuzawa\,\ Akita",
"814287", "Ome\,\ Tokyo",
"818975", "Niihama\,\ Ehime",
"818682", "Tsuyama\,\ Okayama",
"812693", "Nakano\,\ Nagano",
"8126175", "Omachi\,\ Nagano",
"812653", "Iida\,\ Nagano",
"81250", "Niitsu\,\ Niigata",
"81888", "Kochi\,\ Kochi",
"81557", "Ito\,\ Shizuoka",
"812563", "Sanjo\,\ Niigata",
"811542", "Kushiro\,\ Hokkaido",
"812560", "Itoigawa\,\ Niigata",
"819543", "Takeo\,\ Saga",
"818391", "Ogori\,\ Yamaguchi",
"812387", "Nagai\,\ Yamagata",
"812962", "Shimodate\,\ Ibaraki",
"811943", "Iwaizumi\,\ Iwate",
"814792", "Choshi\,\ Chiba",
"8153971", "Hamamatsu\,\ Shizuoka",
"818388", "Tamagawa\,\ Yamaguchi",
"819744", "Mie\,\ Oita",
"818676", "Kuse\,\ Okayama",
"812679", "Saku\,\ Nagano",
"81864", "Kurashiki\,\ Okayama",
"81263", "Matsumoto\,\ Nagano",
"814752", "Mobara\,\ Chiba",
"81928", "Fukuoka\,\ Fukuoka",
"81544", "Fujinomiya\,\ Shizuoka",
"8125484", "Murakami\,\ Niigata",
"8198292", "Nobeoka\,\ Miyazaki",
"81998", "Kagoshima\,\ Kagoshima",
"818842", "Anan\,\ Tokushima",
"812832", "Sano\,\ Tochigi",
"811934", "Kamaishi\,\ Iwate",
"811656", "Bifuka\,\ Hokkaido",
"814709", "Kamogawa\,\ Chiba",
"8186999", "Seto\,\ Okayama",
"815768", "Gero\,\ Gifu",
"818687", "Mimasaka\,\ Okayama",
"811234", "Chitose\,\ Hokkaido",
"818564", "Masuda\,\ Shimane",
"817998", "Tsuna\,\ Hyogo",
"814282", "Ome\,\ Tokyo",
"81531", "Tahara\,\ Aichi",
"818949", "Uwajima\,\ Ehime",
"812967", "Kasama\,\ Ibaraki",
"81585", "Ibigawa\,\ Gifu",
"812939", "Mito\,\ Ibaraki",
"81975", "Oita\,\ Oita",
"812483", "Shirakawa\,\ Fukushima",
"818654", "Kamogata\,\ Okayama",
"812382", "Yonezawa\,\ Yamagata",
"8112399", "Kuriyama\,\ Hokkaido",
"81227", "Sendai\,\ Miyagi",
"818249", "Higashi\-ku\,\ Hiroshima",
"818694", "Okayama\,\ Okayama",
"819966", "Izumi\,\ Kagoshima",
"811547", "Shiranuka\,\ Hokkaido",
"812239", "Sendai\,\ Miyagi",
"819947", "Shibushi\,\ Kagoshima",
"8183766", "Shimonoseki\,\ Yamaguchi",
"812246", "Ogawara\,\ Miyagi",
"81979", "Nakatsu\,\ Oita",
"819938", "Kaseda\,\ Kagoshima",
"8186697", "Kurashiki\,\ Okayama",
"814757", "Togane\,\ Chiba",
"819823", "Nobeoka\,\ Miyazaki",
"8188095", "Tosashimizu\,\ Kochi",
"81721", "Tondabayashi\,\ Osaka",
"811864", "Odate\,\ Akita",
"819726", "Usuki\,\ Oita",
"815398", "Hamamatsu\,\ Shizuoka",
"819555", "Karatsu\,\ Saga",
"81494", "Chichibu\,\ Saitama",
"811955", "Ninohe\,\ Iwate",
"814797", "Yokaichiba\,\ Chiba",
"81936", "Kitakyushu\,\ Fukuoka",
"8125482", "Murakami\,\ Niigata",
"8153976", "Hamamatsu\,\ Shizuoka",
"819665", "Hitoyoshi\,\ Kumamoto",
"819733", "Hita\,\ Oita",
"812837", "Sano\,\ Tochigi",
"8147957", "Yokaichiba\,\ Chiba",
"811732", "Goshogawara\,\ Aomori",
"81162", "Wakkanai\,\ Hokkaido",
"812376", "Sagae\,\ Yamagata",
"81833", "Kudamatsu\,\ Yamaguchi",
"8198294", "Nobeoka\,\ Miyazaki",
"81234", "Sakata\,\ Yamagata",
"815736", "Nakatsugawa\,\ Gifu",
"815585", "Shimoda\,\ Shizuoka",
"819676", "Takamori\,\ Kumamoto",
"81266", "Suwa\,\ Nagano",
"812677", "Saku\,\ Nagano",
"81242", "Aizuwakamatsu\,\ Fukushima",
"81177", "Aomori\,\ Aomori",
"81898", "Imabari\,\ Ehime",
"815742", "Minokamo\,\ Gifu",
"818372", "Nagato\,\ Yamaguchi",
"81828", "Hiroshima\,\ Hiroshima",
"812914", "Hokota\,\ Ibaraki",
"81259", "Sado\,\ Niigata",
"812795", "Shibukawa\,\ Gunma",
"814289", "Ome\,\ Tokyo",
"814702", "Tateyama\,\ Chiba",
"817485", "Yokaichi\,\ Shiga",
"819682", "Yamaga\,\ Kumamoto",
"814771", "Ichikawa\,\ Chiba",
"819975", "Naze\,\ Kagoshima",
"818242", "Higashi\-ku\,\ Hiroshima",
"811357", "Iwanai\,\ Hokkaido",
"812232", "Iwanuma\,\ Miyagi",
"818543", "Yasugi\,\ Shimane",
"818678", "Niimi\,\ Okayama",
"817617", "Kaga\,\ Ishikawa",
"81578", "Kamioka\,\ Akita",
"81988", "Naha\,\ Okinawa",
"818942", "Yawatahama\,\ Ehime",
"812932", "Takahagi\,\ Ibaraki",
"812389", "Yonezawa\,\ Yamagata",
"811397", "Okushiri\,\ Hokkaido",
"81532", "Toyohashi\,\ Aichi",
"818555", "Gotsu\,\ Shimane",
"812248", "Ogawara\,\ Miyagi",
"812672", "Komoro\,\ Nagano",
"819968", "Izumi\,\ Kagoshima",
"812474", "Ishikawa\,\ Fukushima",
"818595", "Yonago\,\ Tottori",
"8153970", "Hamamatsu\,\ Shizuoka",
"818512", "Nishigo\,\ Fukushima",
"812839", "Sano\,\ Tochigi",
"81776", "Fukui\,\ Fukui",
"81468", "Yokosuka\,\ Kanagawa",
"818836", "Mima\,\ Tokushima",
"817703", "Tsuruga\,\ Fukui",
"817996", "Tsuna\,\ Hyogo",
"81933", "Kitakyushu\,\ Fukuoka",
"815766", "Gero\,\ Gifu",
"818377", "Shimonoseki\,\ Yamaguchi",
"81143", "Muroran\,\ Hokkaido",
"817956", "Sanda\,\ Hyogo",
"812743", "Fujioka\,\ Gunma",
"818665", "Takahashi\,\ Okayama",
"811658", "Kamikawa\,\ Hokkaido",
"814770", "Ichikawa\,\ Chiba",
"81792", "Himeji\,\ Hyogo",
"815738", "Nakatsugawa\,\ Gifu",
"819687", "Tamana\,\ Kumamoto",
"811523", "Shari\,\ Hokkaido",
"812378", "Sagae\,\ Yamagata",
"8111", "Sapporo\,\ Hokkaido",
"81722", "Sakai\,\ Osaka",
"81484", "Kawaguchi\,\ Saitama",
"811855", "Noshiro\,\ Akita",
"812544", "Shibata\,\ Niigata",
"818689", "Okayama\,\ Okayama",
"811392", "Kikonai\,\ Hokkaido",
"819728", "Usuki\,\ Oita",
"812937", "Mito\,\ Ibaraki",
"818947", "Uwajima\,\ Ehime",
"81875", "Kan\'onji\,\ Kagawa",
"811536", "Akkeshi\,\ Hokkaido",
"817612", "Komatsu\,\ Ishikawa",
"81739", "Tanabe\,\ Wakayama",
"811549", "Kushiro\,\ Hokkaido",
"812237", "Sendai\,\ Miyagi",
"811352", "Yoichi\,\ Hokkaido",
"819936", "Kaseda\,\ Kagoshima",
"818247", "Shobara\,\ Hiroshima",
"811453", "Hayakita\,\ Hokkaido",
"811584", "Engaru\,\ Hokkaido",
"812898", "Kanuma\,\ Tochigi",
"817948", "Miki\,\ Hyogo",
"81167", "Furano\,\ Hokkaido",
"811646", "Haboro\,\ Hokkaido",
"811375", "Yakumo\,\ Hokkaido",
"815978", "Kumano\,\ Mie",
"8153978", "Hamamatsu\,\ Shizuoka",
"817672", "Hakui\,\ Ishikawa",
"812858", "Mooka\,\ Tochigi",
"818299", "Hiroshima\,\ Hiroshima",
"812589", "Nagaoka\,\ Niigata",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"818586", "Kurayoshi\,\ Tottori",
"81584", "Ogaki\,\ Gifu",
"819957", "Kajiki\,\ Kagoshima",
"81276", "Ota\,\ Gunma",
"812996", "Itako\,\ Ibaraki",
"817686", "Noto\,\ Ishikawa",
"8183768", "Shimonoseki\,\ Yamaguchi",
"812565", "Sanjo\,\ Niigata",
"81425", "Tachikawa\,\ Tokyo",
"81222", "Sendai\,\ Miyagi",
"817717", "Sonobe\,\ Kyoto",
"81281", "Utsunomiya\,\ Tochigi",
"81495", "Honjo\,\ Saitama",
"811945", "Kuji\,\ Iwate",
"81292", "Mito\,\ Ibaraki",
"81568", "Kasugai\,\ Aichi",
"8199347", "Kagoshima\,\ Kagoshima",
"81480", "Kuki\,\ Saitama",
"81429", "Tokorozawa\,\ Saitama",
"812695", "Nakano\,\ Nagano",
"818973", "Niihama\,\ Ehime",
"812612", "Omachi\,\ Nagano",
"81848", "Onomichi\,\ Hiroshima",
"81432", "Chiba\,\ Chiba",
"81235", "Tsuruoka\,\ Yamagata",
"819782", "Bungotakada\,\ Oita",
"812655", "Iida\,\ Nagano",
"817969", "Hamasaka\,\ Hyogo",
"812414", "Yanaizu\,\ Fukushima",
"81478", "Sawara\,\ Chiba",
"819735", "Hita\,\ Oita",
"81766", "Takaoka\,\ Toyama",
"811464", "Shizunai\,\ Hokkaido",
"817677", "Nanao\,\ Ishikawa",
"819663", "Hitoyoshi\,\ Kumamoto",
"81742", "Nara\,\ Nara",
"817734", "Fukuchiyama\,\ Kyoto",
"812578", "Muika\,\ Niigata",
"812640", "Nagano\,\ Nagano",
"819593", "Oseto\,\ Nagasaki",
"811552", "Obihiro\,\ Hokkaido",
"817914", "Aioi\,\ Hyogo",
"819802", "Minamidaito\,\ Okinawa",
"818466", "Mima\,\ Tokushima",
"819825", "Hyuga\,\ Miyazaki",
"819952", "Okuchi\,\ Kagoshima",
"811336", "Ishikari\,\ Hokkaido",
"811877", "Omagari\,\ Akita",
"811953", "Ninohe\,\ Iwate",
"819553", "Imari\,\ Saga",
"812485", "Shirakawa\,\ Fukushima",
"817712", "Kameoka\,\ Kyoto",
"8145", "Yokohama\,\ Kanagawa",
"81552", "Kofu\,\ Yamanashi",
"8126173", "Omachi\,\ Nagano",
"819787", "Kunisaki\,\ Oita",
"818202", "Yanai\,\ Yamaguchi",
"817496", "Nagahama\,\ Shiga",
"818892", "Sakawa\,\ Kochi",
"81545", "Fuji\,\ Shizuoka",
"81549", "Shizuoka\,\ Shizuoka",
"812786", "Numata\,\ Gunma",
"817456", "Yamatotakada\,\ Nara",
"817495", "Nagahama\,\ Shiga",
"811653", "Shibetsu\,\ Hokkaido",
"812748", "Tomioka\,\ Gunma",
"811394", "Matsumae\,\ Hokkaido",
"8198296", "Hyuga\,\ Miyazaki",
"811354", "Yoichi\,\ Hokkaido",
"812785", "Numata\,\ Gunma",
"817614", "Komatsu\,\ Ishikawa",
"817455", "Yamatotakada\,\ Nara",
"81989", "Naha\,\ Okinawa",
"812486", "Sukagawa\,\ Fukushima",
"81726", "Ibaraki\,\ Osaka",
"812542", "Shibata\,\ Niigata",
"8125481", "Murakami\,\ Niigata",
"811563", "Honbetsu\,\ Hokkaido",
"812243", "Shiroishi\,\ Miyagi",
"817903", "Fukusaki\,\ Hyogo",
"819963", "Satsumasendai\,\ Kagoshima",
"81985", "Miyazaki\,\ Miyazaki",
"812917", "Mito\,\ Ibaraki",
"81832", "Shimonoseki\,\ Yamaguchi",
"819826", "Hyuga\,\ Miyazaki",
"819435", "Yame\,\ Fukuoka",
"819723", "Saiki\,\ Oita",
"812674", "Komoro\,\ Nagano",
"817366", "Iwade\,\ Wakayama",
"815733", "Ena\,\ Gifu",
"818514", "Ama\,\ Shimane",
"81899", "Matsuyama\,\ Ehime",
"812472", "Ishikawa\,\ Fukushima",
"81825", "Hiroshima\,\ Hiroshima",
"811528", "Bihoro\,\ Hokkaido",
"812373", "Murayama\,\ Yamagata",
"812696", "Iiyama\,\ Nagano",
"8112393", "Yubari\,\ Hokkaido",
"818244", "Miyoshi\,\ Hiroshima",
"812234", "Sendai\,\ Miyagi",
"818944", "Yawatahama\,\ Ehime",
"818478", "Tojo\,\ Hiroshima",
"8125486", "Tsugawa\,\ Niigata",
"812934", "Takahagi\,\ Ibaraki",
"812656", "Ina\,\ Nagano",
"8153972", "Hamamatsu\,\ Shizuoka",
"817685", "Wajima\,\ Ishikawa",
"812566", "Sanjo\,\ Niigata",
"8198291", "Nobeoka\,\ Miyazaki",
"81738", "Gobo\,\ Wakayama",
"812547", "Murakami\,\ Niigata",
"8186993", "Bizen\,\ Okayama",
"819684", "Yamaga\,\ Kumamoto",
"811946", "Kuji\,\ Iwate",
"81878", "Takamatsu\,\ Kagawa",
"819546", "Kashima\,\ Saga",
"811939", "Miyako\,\ Iwate",
"814704", "Tateyama\,\ Chiba",
"818374", "Nagato\,\ Yamaguchi",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"818585", "Kurayoshi\,\ Tottori",
"815744", "Minokamo\,\ Gifu",
"812995", "Ishioka\,\ Ibaraki",
"812477", "Miharu\,\ Fukushima",
"81246", "Iwaki\,\ Fukushima",
"81134", "Otaru\,\ Hokkaido",
"81465", "Odawara\,\ Kanagawa",
"811645", "Rumoi\,\ Hokkaido",
"81262", "Nagano\,\ Nagano",
"811376", "Yakumo\,\ Hokkaido",
"811869", "Odate\,\ Akita",
"81944", "Setaka\,\ Fukuoka",
"811958", "Iwate\,\ Iwate",
"81569", "Handa\,\ Aichi",
"818204", "Yanai\,\ Yamaguchi",
"818894", "Susaki\,\ Kochi",
"815395", "Hamamatsu\,\ Shizuoka",
"819558", "Karatsu\,\ Saga",
"811535", "Akkeshi\,\ Hokkaido",
"81852", "Matsue\,\ Shimane",
"819598", "Fukue\,\ Nagasaki",
"819935", "Kaseda\,\ Kagoshima",
"81565", "Toyota\,\ Aichi",
"812573", "Kashiwazaki\,\ Niigata",
"81845", "Innoshima\,\ Hiroshima",
"812648", "Nagano\,\ Nagano",
"811753", "Mutsu\,\ Aomori",
"819668", "Minamata\,\ Kumamoto",
"811856", "Noshiro\,\ Akita",
"81849", "Fukuyama\,\ Hiroshima",
"817714", "Kameoka\,\ Kyoto",
"819954", "Kajiki\,\ Kagoshima",
"811554", "Obihiro\,\ Hokkaido",
"817912", "Aioi\,\ Hyogo",
"819804", "Nago\,\ Okinawa",
"817995", "Sumoto\,\ Hyogo",
"818835", "Mima\,\ Tokushima",
"81182", "Yokote\,\ Akita",
"815765", "Gero\,\ Gifu",
"81191", "Ichinoseki\,\ Iwate",
"817955", "Sanda\,\ Hyogo",
"818666", "Ibara\,\ Okayama",
"818556", "Gotsu\,\ Shimane",
"8183767", "Shimonoseki\,\ Yamaguchi",
"811363", "Kutchan\,\ Hokkaido",
"812559", "Yasuzuka\,\ Niigata",
"811462", "Urakawa\,\ Hokkaido",
"811587", "Nakayubetsu\,\ Hokkaido",
"818596", "Yonago\,\ Tottori",
"81940", "Munakata\,\ Fukuoka",
"817732", "Fukuchiyama\,\ Kyoto",
"81762", "Kanazawa\,\ Ishikawa",
"812614", "Omachi\,\ Nagano",
"81436", "Ichihara\,\ Chiba",
"812412", "Kitakata\,\ Fukushima",
"818385", "Hagi\,\ Yamaguchi",
"819784", "Bungotakada\,\ Oita",
"81548", "Haibara\,\ Shizuoka",
"81924", "Fukuoka\,\ Fukuoka",
"812796", "Shibukawa\,\ Gunma",
"812853", "Oyama\,\ Tochigi",
"815973", "Owase\,\ Mie",
"812893", "Utsunomiya\,\ Tochigi",
"8186691", "Kurashiki\,\ Okayama",
"817943", "Kakogawa\,\ Hyogo",
"817486", "Minakuchi\,\ Shiga",
"812890", "Utsunomiya\,\ Tochigi",
"817940", "Kakogawa\,\ Hyogo",
"812571", "Muika\,\ Niigata",
"81226", "Kesennuma\,\ Miyagi",
"819976", "Naze\,\ Kagoshima",
"811874", "Kakunodate\,\ Akita",
"81272", "Maebashi\,\ Gunma",
"818978", "Hakata\,\ Ehime",
"815959", "Kameyama\,\ Mie",
"815586", "Shimoda\,\ Shizuoka",
"812879", "Nasukarasuyama\,\ Tochigi",
"817737", "Maizuru\,\ Kyoto",
"81937", "Kitakyushu\,\ Fukuoka",
"811582", "Monbetsu\,\ Hokkaido",
"817674", "Hakui\,\ Ishikawa",
"818369", "Ube\,\ Yamaguchi",
"815999", "Tsu\,\ Mie",
"811983", "Hanamaki\,\ Iwate",};
my $timezones = {
               '' => [
                       'Asia/Tokyo'
                     ],
               '70859' => [
                            'Asia/Tokyo'
                          ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:(000[259]\d{6})$|(?:(?:003768)0?)|0)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;