# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::UA;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20241212130807;

my $formatters = [
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            6[12][29]|
            (?:
              35|
              4[1378]|
              5[12457]|
              6[49]
            )2|
            (?:
              56|
              65
            )[24]|
            (?:
              3[1-46-8]|
              46
            )2[013-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[1-8]|
            4(?:
              [1367]|
              [45][6-9]|
              8[4-6]
            )|
            5(?:
              [1-5]|
              6(?:
                [015689]|
                3[02389]
              )|
              7[4-6]
            )|
            6(?:
              [12][3-7]|
              [459]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [3-7]|
            89|
            9[1-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[89]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3,4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3[1-8]|
            4[13-8]|
            5[1-7]|
            6[12459]
          )\\d{7}
        ',
                'geographic' => '
          (?:
            3[1-8]|
            4[13-8]|
            5[1-7]|
            6[12459]
          )\\d{7}
        ',
                'mobile' => '
          790\\d{6}|
          (?:
            39|
            50|
            6[36-8]|
            7[1-357]|
            9[1-9]
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(900[239]\\d{5,6})',
                'toll_free' => '800[1-8]\\d{5,6}',
                'voip' => '89[1-579]\\d{6}'
              };
my %areanames = ();
$areanames{uk} = {"3806445", "Новоайдар\,\ Луганськ",
"3805668", "Томаківка\,\ Дніпро",
"3806247", "Дзержинськ\,\ Донецьк",
"38033", "Волинська",
"38037", "Чернівці",
"3804639", "Срібне\,\ Чернігів",
"3805543", "Велика\ Лепетиха\,\ Херсон",
"3805531", "Іванівка\,\ Херсон",
"3804734", "Городище\,\ Черкаси",
"3804334", "Гайсин\,\ Вінниця",
"3803653", "Березне\,\ Рівне",
"3803230", "Пустомити\,\ Львівська",
"3804567", "Переяслав\-Хмельницький\,\ Київ",
"3804139", "Чуднів\,\ Житомир",
"3805168", "Березнегувате\,\ Миколаїв",
"3806461", "Старобільськ\,\ Луганськ",
"3803736", "Кіцмань\,\ Чернівці",
"3805445", "Лебедин\,\ Суми",
"38045", "Київ",
"3803263", "Перемишляни\,\ Львівська",
"38047", "Черкаси",
"38043", "Вінниця",
"3805258", "Мала\ Виска\,\ Кіровоград",
"3804653", "Борзна\,\ Чернігів",
"3803734", "Глибока\,\ Чернівці",
"3805532", "Велика\ Олександрівка\,\ Херсон",
"3803437", "Болехів\,\ Івано\-Франківська",
"3805343", "Кобеляки\,\ Полтава",
"380322", "Брюховичі\/Львів\,\ Львівська",
"3805743", "Ізюм\,\ Харків",
"3803235", "Львів\/Львівська",
"3806462", "Білокуракине\,\ Луганськ",
"3803479", "Тлумач\,\ Івано\-Франківська",
"3806258", "Донецьк",
"380329", "Львів\/Львівська",
"3806440", "Луганськ",
"3804736", "Канів\,\ Черкаси",
"3804336", "Ямпіль\,\ Вінниця",
"38035", "Тернопіль",
"3805634", "Петриківка\,\ Дніпро",
"380564", "Кривий\ Ріг\,\ Дніпро",
"3805455", "Недригайлів\,\ Суми",
"3806474", "Попасна\,\ Луганськ",
"3805257", "Бобринець\,\ Кіровоград",
"3803471", "Богородчани\,\ Івано\-Франківська",
"3803143", "Виноградів\,\ Закарпатська",
"3803131", "Мукачеве\,\ Закарпатська",
"3804132", "Радомишль\,\ Житомир",
"3803438", "Бурштин\,\ Івано\-Франківська",
"3806257", "Іловайськ\/Харцизьк\,\ Донецьк",
"3806455", "Первомайськ\,\ Луганськ",
"3805134", "Вознесенськ\,\ Миколаїв",
"3804632", "Бобровиця\,\ Чернігів",
"3805753", "Валки\,\ Харків",
"3805353", "Зіньків\,\ Полтава",
"38061", "Запоріжжя\/Запорізька",
"3805136", "Південноукраїнськ\,\ Миколаїв",
"3805667", "Орджонікідзе\,\ Дніпро",
"3806248", "Горлівка\,\ Донецьк",
"3806450", "Луганськ",
"3803368", "Рожище\,\ Волинська",
"3804131", "Червоноармійськ\,\ Житомир",
"3804143", "Бердичів\,\ Житомир",
"3803132", "Рахів\,\ Закарпатська",
"3804863", "Ананьїв\,\ Одеса",
"3803472", "Калуш\,\ Івано\-Франківська",
"3806469", "Луганськ",
"3804568", "Сквира\,\ Київ",
"3805539", "Гола\ Пристань\,\ Херсон",
"3805167", "Нова\ Одеса\,\ Миколаїв",
"3805636", "Тернівка\,\ Дніпро",
"3803632", "Зарічне\,\ Рівне",
"380327", "Львів\/Львівська",
"3804631", "Ніжин\,\ Чернігів",
"38051", "Миколаїв",
"3804643", "Куликівка\,\ Чернігів",
"3806273", "Вугледар\,\ Донецьк",
"3806136", "Веселе\,\ Запорізька",
"3806441", "Перевальськ\,\ Луганськ",
"3806236", "Ясинувата\,\ Донецьк",
"3806433", "Ровеньки\,\ Луганськ",
"38052", "Кіровоград",
"3804358", "Липовець\,\ Вінниця",
"3805535", "Високопілля\,\ Херсон",
"3803853", "Ярмолинці\,\ Хмельницький",
"3803558", "Шумське\,\ Тернопіль",
"38069", "Севастополь",
"3806267", "Дружківка\,\ Донецьк",
"3806465", "Мілове\,\ Луганськ",
"3803232", "Львів\/Львівська",
"3805236", "Світловодськ\,\ Кіровоград",
"3805763", "Дергачі\,\ Харків",
"3803547", "Козлів\/Козова\,\ Тернопіль",
"3805363", "Решетилівка\,\ Полтава",
"3806442", "Алчевськ\,\ Луганськ",
"3805657", "Широке\,\ Дніпро",
"380641", "Луганськ",
"3806460", "Луганськ",
"3805234", "Долинська\,\ Кіровоград",
"3804853", "Лиманське\/Роздільна\,\ Одеса",
"3806459", "Луганськ",
"3803243", "Львів\/Львівська",
"380572", "Мерефа\/Харків\,\ Харків",
"3803231", "Городок\,\ Львівська",
"3805459", "Краснопілля\,\ Суми",
"3805530", "Каланчак\,\ Херсон",
"3804747", "Жашків\,\ Черкаси",
"3804347", "Літин\,\ Вінниця",
"3805442", "Путивль\,\ Суми",
"3805693", "Новомосковськ\,\ Дніпро",
"3803548", "Бережани\,\ Тернопіль",
"3805658", "Верхньодніпровськ\,\ Дніпро",
"3805451", "Середина\-Буда\,\ Суми",
"3803475", "Делятин\/Надвірна\,\ Івано\-Франківська",
"3803357", "Камінь\-Каширський\,\ Волинська",
"3803239", "Жидачів\,\ Львівська",
"3803135", "Великий\ Березний\,\ Закарпатська",
"380312", "Ужгород\/Чоп\,\ Закарпатська",
"3805158", "Баштанка\,\ Миколаїв",
"3806451", "Лисичанськ\,\ Луганськ",
"3804130", "Коростишів\,\ Житомир",
"3804748", "Маньківка\,\ Черкаси",
"3804348", "Томашпіль\,\ Вінниця",
"3803635", "Рокитне\,\ Рівне",
"3803843", "Полонне\,\ Хмельницький",
"3803253", "Львів\/Львівська",
"380320", "Львів\/Львівська",
"3805449", "Шостка\,\ Суми",
"3804135", "Олевськ\,\ Житомир",
"3805452", "Липова\ Долина\,\ Суми",
"380648", "Луганськ",
"3803557", "Гусятин\,\ Тернопіль",
"3806452", "Сєвєродонецьк\,\ Луганськ",
"3806268", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3804573", "Кагарлик\/Ржищів\,\ Київ",
"3804635", "Батурин\/Бахмач\,\ Чернігів",
"3804843", "Вилкове\/Кілія\,\ Одеса",
"3806449", "Луганськ",
"3806147", "Куйбишеве\,\ Запорізька",
"3805549", "Нова\ Каховка\,\ Херсон",
"3803659", "Млинів\,\ Рівне",
"3804575", "Яготин\,\ Київ",
"3805238", "Онуфріївка\,\ Кіровоград",
"3806271", "Артемівськ\,\ Донецьк",
"3804641", "Ріпки\,\ Чернігів",
"3804845", "Арциз\,\ Одеса",
"3805690", "Царичанка\,\ Дніпро",
"3804633", "Ічня\,\ Чернігів",
"3803840", "Шепетівка\,\ Хмельницький",
"3805351", "Диканька\,\ Полтава",
"3803255", "Радехів\,\ Львівська",
"3805751", "Шевченкове\,\ Харків",
"3804141", "Новоград\-Волинський\,\ Житомир",
"3804133", "Малин\,\ Житомир",
"3804356", "Муровані\ Курилівці\,\ Вінниця",
"3803142", "Хуст\,\ Закарпатська",
"3804861", "Красні\ Окни\,\ Одеса",
"3804659", "Семенівка\,\ Чернігів",
"3803269", "Турка\,\ Львівська",
"3806272", "Костянтинівка\,\ Донецьк",
"3804642", "Носівка\,\ Чернігів",
"3803250", "Львів\/Львівська",
"3803845", "Волочиськ\,\ Хмельницький",
"3803633", "Радивилів\,\ Рівне",
"3804840", "Рені\,\ Одеса",
"3805752", "Великий\ Бурлук\,\ Харків",
"3805352", "Шишаки\,\ Полтава",
"3804570", "Згурівка\,\ Київ",
"3803554", "Заліщики\,\ Тернопіль",
"3803133", "Свалява\,\ Закарпатська",
"3806144", "Новомиколаївка\,\ Запорізька",
"3805749", "Балаклія\,\ Харків",
"3804862", "Котовськ\,\ Одеса",
"3803141", "Берегове\,\ Закарпатська",
"380647", "Луганськ",
"3804142", "Коростень\,\ Житомир",
"3805741", "Вовчанськ\,\ Харків",
"3805341", "Семенівка\,\ Полтава",
"3803850", "Стара\ Синява\,\ Хмельницький",
"3803245", "Стрий\,\ Львівська",
"3804595", "Бориспіль\,\ Київ",
"3804746", "Монастирище\,\ Черкаси",
"3806430", "Луганськ",
"3804346", "Погребище\,\ Вінниця",
"3803546", "Кременець\/Почаїв\,\ Тернопіль",
"3806264", "Краматорськ\,\ Донецьк",
"3805365", "Глобине\,\ Полтава",
"3803261", "Новий\ Роздол\,\ Львівська",
"3805765", "Печеніги\,\ Харків",
"3805656", "Апостолове\,\ Дніпро",
"3803652", "Здолбунів\,\ Рівне",
"3805542", "Цюрупинськ\,\ Херсон",
"3806156", "Велика\ Білозерка\,\ Запорізька",
"3804855", "Комінтернівське\,\ Одеса",
"3803344", "Нововолинськ\,\ Волинська",
"3804850", "Теплодар\,\ Одеса",
"3805654", "Кринички\,\ Дніпро",
"3804149", "Ємільчине\,\ Житомир",
"3805342", "Козельщина\,\ Полтава",
"3805742", "Купʼянськ\,\ Харків",
"3803544", "Бучач\,\ Тернопіль",
"3806463", "Новопсков\,\ Луганськ",
"3806266", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3805759", "Борова\,\ Харків",
"3805359", "Гребінка\,\ Полтава",
"3803346", "Стара\ Вижівка\,\ Волинська",
"3805237", "Петрове\,\ Кіровоград",
"3805360", "Кременчук\,\ Полтава",
"380649", "Луганськ",
"3806175", "Василівка\/Дніпрорудне\,\ Запорізька",
"3805154", "Очаків\,\ Миколаїв",
"3806279", "Тельманове\,\ Донецьк",
"3803262", "Львів\/Львівська",
"3806435", "Краснодон\,\ Луганськ",
"380642", "Луганськ\/Олександрівськ\,\ Луганськ",
"3806237", "Селидове\,\ Донецьк",
"3805533", "Нововоронцовка\,\ Херсон",
"3803651", "Корець\,\ Рівне",
"3804744", "Умань\,\ Черкаси",
"3804344", "Шаргород\,\ Вінниця",
"3803240", "Львів\/Львівська",
"3803855", "Красилів\,\ Хмельницький",
"3803859", "Чемерівці\,\ Хмельницький",
"3805637", "Павлоград\,\ Дніпро",
"3803842", "Нетішин\/Славута\,\ Хмельницький",
"3804161", "Лугини\,\ Житомир",
"3804571", "Васильків\/Глеваха\/Гребінки\/Калинівка\,\ Київ",
"3803738", "Путила\,\ Чернівці",
"3806137", "Приморськ\,\ Запорізька",
"3806439", "Луганськ",
"3804645", "Городня\,\ Чернігів",
"3806275", "Докучаєвськ\,\ Донецьк",
"3804841", "Ізмаїл\,\ Одеса",
"3805254", "Гайворон\,\ Кіровоград",
"3806254", "Торез\,\ Донецьк",
"3803251", "Сколе\/Славське\,\ Львівська",
"3805355", "Миргород\,\ Полтава",
"3805755", "Кегичівка\,\ Харків",
"3805692", "Дніпродзержинськ\,\ Дніпро",
"3805666", "Нікополь\,\ Дніпро",
"3804145", "Володарськ\-Волинський\,\ Житомир",
"3804865", "Саврань\,\ Одеса",
"3804860", "Фрунзівка\,\ Одеса",
"3805664", "Нікополь\,\ Дніпро",
"3804140", "Народичі\,\ Житомир",
"3804859", "Велика\ Михайлівка\,\ Одеса",
"3806453", "Рубіжне\,\ Луганськ",
"3806256", "Сніжне\,\ Донецьк",
"380640", "Луганськ",
"3805369", "Кременчук\,\ Полтава",
"3804738", "Драбів\,\ Черкаси",
"3804338", "Хмільник\,\ Вінниця",
"3804572", "Козин\/Обухів\/Українка\,\ Київ",
"3805350", "Котельва\,\ Полтава",
"3803841", "Білогірʼя\,\ Хмельницький",
"3804162", "Брусилів\,\ Житомир",
"3805750", "Дворічна\,\ Харків",
"3806270", "Артемівськ\,\ Донецьк",
"3805691", "Магдалинівка\,\ Дніпро",
"3803372", "Іваничі\,\ Волинська",
"3803252", "Жовква\,\ Львівська",
"3805164", "Казанка\,\ Миколаїв",
"380328", "Львів\/Львівська",
"3803249", "Червоноград\,\ Львівська",
"3803145", "Перечин\,\ Закарпатська",
"3805256", "Новомиргород\,\ Кіровоград",
"3805453", "Кролевець\,\ Суми",
"3805745", "Лозова\,\ Харків",
"3803650", "Гоща\,\ Рівне",
"3803436", "Тисмениця\,\ Івано\-Франківська",
"3803233", "Львів\/Львівська",
"3806244", "Волноваха\,\ Донецьк",
"3805345", "Велика\ Багачка\,\ Полтава",
"3803241", "Миколаїв\,\ Львівська",
"380623", "Красноармійськ\/Макіївка\,\ Донецьк",
"3804591", "Іванків\,\ Київ",
"3805540", "Нижні\ Сірогози\,\ Херсон",
"3804737", "Золотоноша\,\ Черкаси",
"3804337", "Могилів\-Подільський\,\ Вінниця",
"3806432", "Красний\ Луч\,\ Луганськ",
"3803265", "Золочів\,\ Львівська",
"3805361", "Лубни\,\ Полтава",
"3805761", "Зачепилівка\,\ Харків",
"3803849", "Камʼянець\-Подільський\,\ Хмельницький",
"3804564", "Ставище\,\ Київ",
"3803852", "Ізяслав\,\ Хмельницький",
"38034", "Івано\-Франківська",
"3804851", "Овідіополь\,\ Одеса",
"3804655", "Сосниця\,\ Чернігів",
"3804566", "Тараща\,\ Київ",
"3803242", "Львів\/Львівська",
"3805638", "Покровське\,\ Дніпро",
"3803379", "Горохів\,\ Волинська",
"3803259", "Яворів\,\ Львівська",
"3805443", "Білопілля\,\ Суми",
"3803737", "Заставна\,\ Чернівці",
"3806138", "Камʼянка\-Дніпровська\,\ Запорізька",
"380321", "Львів\/Львівська",
"3803260", "Моршин\,\ Львівська",
"3804579", "Славутич\,\ Київ",
"3804849", "Білгород\-Дністровський\/Затока\/Сергіївка\,\ Одеса",
"3805762", "Сахновщина\,\ Харків",
"3805362", "Хорол\,\ Полтава",
"3806431", "Антрацит\,\ Луганськ",
"3803434", "Ворохта\/Яремче\,\ Івано\-Франківська",
"3806443", "Брянка\,\ Луганськ",
"3806246", "Володарське\,\ Донецьк",
"3804852", "Біляївка\,\ Одеса",
"3803366", "Ратне\,\ Волинська",
"3805545", "Верхній\ Рогачик\,\ Херсон",
"38044", "м\.\ Київ",
"3805740", "Нова\ Водолага\,\ Харків",
"3803655", "Сарни\,\ Рівне",
"3805340", "Чорнухи\,\ Полтава",
"3803851", "Городок\/Сатанів\,\ Хмельницький",
"3805133", "Криве\ Озеро\,\ Миколаїв",
"3805756", "Краснокутськ\,\ Харків",
"3805356", "Лохвиця\,\ Полтава",
"3805665", "Марганець\,\ Дніпро",
"3806448", "Луганськ",
"3804146", "Дзержинськ\,\ Житомир",
"3804351", "Чечельник\,\ Вінниця",
"3806250", "Кіровське\,\ Донецьк",
"3806269", "Олександрівка\,\ Донецьк",
"3806165", "Пологи\,\ Запорізька",
"3803352", "Ковель\,\ Волинська",
"3804866", "Балта\,\ Одеса",
"3803551", "Теребовля\,\ Тернопіль",
"3805250", "Вільшанка\,\ Кіровоград",
"3805633", "Першотравенськ\,\ Дніпро",
"3805448", "Ромни\,\ Суми",
"3806141", "Оріхів\,\ Запорізька",
"3803144", "Іршава\,\ Закарпатська",
"3806133", "Приазовське\,\ Запорізька",
"3806473", "Словʼяносербськ\,\ Луганськ",
"3804646", "Десна\/Козелець\/Остер\,\ Чернігів",
"3806276", "Артемівськ\,\ Донецьк",
"3804749", "Лисянка\,\ Черкаси",
"3804349", "Піщанка\,\ Вінниця",
"3803146", "Міжгірʼя\,\ Закарпатська",
"3805255", "Новоархангельськ\,\ Кіровоград",
"3806274", "Артемівськ\/Сіверськ\,\ Донецьк",
"3804644", "Мена\,\ Чернігів",
"3805457", "Велика\ Писарівка\,\ Суми",
"3805159", "Єланець\,\ Миколаїв",
"3804352", "Бершадь\,\ Вінниця",
"3803238", "Старий\ Самбір\,\ Львівська",
"3803552", "Чортків\,\ Тернопіль",
"3806457", "Луганськ",
"3805754", "Близнюки\,\ Харків",
"3805354", "Гадяч\,\ Полтава",
"3806255", "Шахтарськ\,\ Донецьк",
"3803549", "Ланівці\,\ Тернопіль",
"3805660", "Нікополь\,\ Дніпро",
"380561", "Дніпропетро́вськ\/Дніпро",
"3804864", "Любашівка\,\ Одеса",
"3804144", "Баранівка\,\ Житомир",
"3805659", "Дніпропетро́вськ\/Дніпро",
"3803266", "Броди\,\ Львівська",
"3803541", "Борщів\,\ Тернопіль",
"3805651", "Дніпропетро́вськ\/Дніпро",
"3805240", "Компаніївка\,\ Кіровоград",
"3805458", "Тростянець\,\ Суми",
"3804656", "Короп\,\ Чернігів",
"3804560", "Тетіїв\,\ Київ",
"3805151", "Новий\ Буг\,\ Миколаїв",
"3806262", "Святогірськ\/Словʼянськ\,\ Донецьк",
"3803237", "Львів\/Львівська",
"3805346", "Карлівка\,\ Полтава",
"3806296", "Новоазовськ\,\ Донецьк",
"3805746", "Чугуїв\,\ Харків",
"3803435", "Рогатин\,\ Івано\-Франківська",
"3806458", "Луганськ",
"3804733", "Сміла\,\ Черкаси",
"3806240", "Горлівка\,\ Донецьк",
"3804341", "Бар\,\ Вінниця",
"3804741", "Шпола\,\ Черкаси",
"3804333", "Калинівка\,\ Вінниця",
"3803654", "Острог\,\ Рівне",
"3803342", "Володимир\-Волинський\,\ Волинська",
"3805544", "Горностаївка\,\ Херсон",
"3805652", "Жовті\ Води\,\ Дніпро",
"380568", "Дніпропетро́вськ\/Дніпро",
"3803542", "Підгайці\,\ Тернопіль",
"3805344", "Нові\ Санжари\,\ Полтава",
"3806245", "Горлівка\,\ Донецьк",
"3805744", "Красноград\,\ Харків",
"3806447", "Луганськ",
"3803365", "Ківерці\/Цумань\,\ Волинська",
"3805546", "Берислав\,\ Херсон",
"3803656", "Дубно\,\ Рівне",
"38037312", "Хотин\,\ Чернівці",
"3803430", "Городенка\,\ Івано\-Франківська",
"3804565", "Фастів\,\ Київ",
"3806261", "Красний\ Лиман\,\ Донецьк",
"3805152", "Доманівка\,\ Миколаїв",
"3803264", "Буськ\,\ Львівська",
"3803741", "Новодністровськ\,\ Чернівці",
"3805447", "Конотоп\,\ Суми",
"3804654", "Щорс\,\ Чернігів",
"3803733", "Новоселиця\,\ Чернівці",
"3804742", "Катеринопіль\,\ Черкаси",
"3804342", "Козятин\,\ Вінниця",
"3803376", "Маневичі\,\ Волинська",
"3803256", "Новояворівськ\,\ Львівська",
"3805661", "Нікополь\,\ Дніпро",
"3804569", "Володарка\,\ Київ",
"3804137", "Попільня\,\ Житомир",
"3805538", "Асканія\-Нова\/Чаплинка\,\ Херсон",
"3804355", "Гнівань\/Тиврів\,\ Вінниця",
"3803844", "Теофіполь\,\ Хмельницький",
"3805252", "Голованівськ\,\ Кіровоград",
"3806252", "Єнакієве\,\ Донецьк",
"3805161", "Первомайськ\,\ Миколаїв",
"3803555", "Монастириська\,\ Тернопіль",
"380628", "Донецьк",
"3806468", "Луганськ",
"3804576", "Баришівка\/Березань\,\ Київ",
"3806145", "Гуляйполе\,\ Запорізька",
"3806249", "Дебальцеве\,\ Донецьк",
"3804846", "Болград\,\ Одеса",
"3804637", "Прилуки\,\ Чернігів",
"3806140", "Чернігівка\,\ Запорізька",
"3805662", "Нікополь\,\ Дніпро",
"3806162", "Розівка\,\ Запорізька",
"3803477", "Долина\,\ Івано\-Франківська",
"3805251", "Новоукраїнка\,\ Кіровоград",
"3804844", "Татарбунари\,\ Одеса",
"3803355", "Шацьк\,\ Волинська",
"3803550", "Збараж\,\ Тернопіль",
"3804574", "Миронівка\,\ Київ",
"3803374", "Локачі\,\ Волинська",
"3803254", "Камʼянка\-Бузька\,\ Львівська",
"3806251", "Донецьк",
"3804350", "Вапнярка\,\ Вінниця",
"3805162", "Снігурівка\,\ Миколаїв",
"3803122", "Ужгород\,\ Закарпатська",
"3803637", "Демидівка\,\ Рівне",
"3803846", "Віньківці\,\ Хмельницький",
"3806242", "Горлівка\,\ Донецьк",
"3805766", "Коломак\,\ Харків",
"3805366", "Кременчук\,\ Полтава",
"3805655", "Дніпропетро́вськ\/Дніпро",
"3803740", "Герца\,\ Чернівці",
"3803478", "Косів\,\ Івано\-Франківська",
"380621", "Донецьк",
"3806260", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3806259", "Амвросіївка\,\ Донецьк",
"3803362", "Любешів\,\ Волинська",
"3804856", "Березівка\,\ Одеса",
"3805259", "Ульянівка\,\ Кіровоград",
"3803246", "Львів\/Львівська",
"3803431", "Галич\,\ Івано\-Франківська",
"3806434", "Свердловськ\,\ Луганськ",
"3804562", "Рокитне\,\ Київ",
"3804596", "Вишгород\/Димер\/Пірнове\,\ Київ",
"3803854", "Старокостянтинів\,\ Хмельницький",
"3804345", "Іллінці\,\ Вінниця",
"3804745", "Монастирище\,\ Черкаси",
"3805242", "Олександрівка\,\ Кіровоград",
"3804594", "Бровари\/Калита\,\ Київ",
"38054", "Суми",
"3806241", "Горлівка\,\ Донецьк",
"3804340", "Крижопіль\,\ Вінниця",
"3803244", "Дрогобич\,\ Львівська",
"3806436", "Лутугине\,\ Луганськ",
"3804740", "Ватутіне\/Звенигородка\,\ Черкаси",
"3804138", "Ружин\,\ Житомир",
"3805537", "Лазурне\/Скадовськ\,\ Херсон",
"3803856", "Деражня\,\ Хмельницький",
"3804561", "Богуслав\,\ Київ",
"3803432", "Верховина\,\ Івано\-Франківська",
"3806467", "Луганськ",
"3805764", "Золочів\,\ Харків",
"3806265", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3805364", "Машівка\,\ Полтава",
"3805233", "Знамʼянка\,\ Кіровоград",
"3805650", "Софіївка\,\ Дніпро",
"3804854", "Іванівка\,\ Одеса",
"3805241", "Новгородка\,\ Кіровоград",
"3805669", "Солоне\,\ Дніпро",
"3803540", "Зборів\,\ Тернопіль",
"3806263", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3806466", "Біловодськ\,\ Луганськ",
"38055", "Херсон",
"3804578", "Макарів\,\ Київ",
"380522", "Кропивницький\,\ Кіровоград",
"3805235", "Олександрія\,\ Кіровоград",
"3804848", "Сарата\,\ Одеса",
"3804732", "Камʼянка\,\ Черкаси",
"3804332", "Браїлів\/Жмеринка\,\ Вінниця",
"3803258", "Львів\/Львівська",
"380629", "Маріуполь\,\ Донецьк",
"380622", "Донецьк",
"3806139", "Енергодар\,\ Запорізька",
"3806437", "Луганськ",
"3805536", "Каховка\,\ Херсон",
"38065", "Крим",
"3803857", "Летичів\/Меджибіж\,\ Хмельницький",
"3805639", "Васильківка\,\ Дніпро",
"3803247", "Трускавець\,\ Львівська",
"3805153", "Березанка\,\ Миколаїв",
"3804597", "Буча\/Ворзель\/Гостомель\/Ірпінь\/Коцюбинське\,\ Київ",
"3804331", "Брацлав\/Немирів\,\ Вінниця",
"3804343", "Ладижин\/Тростянець\,\ Вінниця",
"3804731", "Тальне\,\ Черкаси",
"3805534", "Генічеськ\,\ Херсон",
"3803732", "Кельменці\,\ Чернівці",
"3806464", "Марківка\,\ Луганськ",
"3803543", "Підволочиськ\,\ Тернопіль",
"3805367", "Кременчук\,\ Полтава",
"380560", "Дніпропетро́вськ\/Дніпро",
"3805653", "Вільногірськ\,\ Дніпро",
"3804857", "Миколаївка\,\ Одеса",
"38053", "Полтава",
"3806153", "Бердянськ\,\ Запорізька",
"38057", "Харків",
"3803248", "Борислав\/Східниця\,\ Львівська",
"3805632", "Павлоград\,\ Дніпро",
"38031", "Закарпатська",
"3804598", "Боярка\/Вишневе\,\ Київ",
"3806132", "Михайлівка\,\ Запорізька",
"3806472", "Станиця\ Луганськ\,\ Луганськ",
"3803636", "Кузнецовськ\,\ Рівне",
"3803847", "Нова\ Ушиця\,\ Хмельницький",
"3804134", "Черняхів\,\ Житомир",
"3805368", "Кременчук\,\ Полтава",
"38036", "Рівне",
"3804739", "Чорнобай\,\ Черкаси",
"3805132", "Арбузинка\,\ Миколаїв",
"3803476", "Заболотів\/Снятин\,\ Івано\-Франківська",
"3804634", "Талалаївка\,\ Чернігів",
"3803136", "Воловець\,\ Закарпатська",
"3804858", "Ширяєве\,\ Одеса",
"3805631", "Петропавлівка\,\ Дніпро",
"38041", "Житомир",
"3804577", "Бородянка\/Клавдієво\-Тарасове\/Немішаєве\,\ Київ",
"3803474", "Рожнятів\,\ Івано\-Франківська",
"3806471", "Сватове\,\ Луганськ",
"3804847", "Тарутине\,\ Одеса",
"3804636", "Варва\,\ Чернігів",
"3803134", "Солотвино\/Тячів\,\ Закарпатська",
"3806131", "Якимівка\,\ Запорізька",
"3806143", "Вільнянськ\,\ Запорізька",
"3803377", "Любомль\,\ Волинська",
"3803257", "Сокаль\,\ Львівська",
"3805131", "Братське\,\ Миколаїв",
"38046", "Чернігів",
"3803739", "Сокиряни\,\ Чернівці",
"3806438", "Луганськ",
"3806178", "Токмак\,\ Запорізька",
"3803634", "Володимирець\,\ Рівне",
"3804353", "Теплик\,\ Вінниця",
"3804136", "Андрушівка\,\ Житомир",
"3803858", "Дунаївці\,\ Хмельницький",
"3804563", "Біла\ Церква\/Узин\,\ Київ",
"3803735", "Сторожинець\,\ Чернівці",
"3805446", "Охтирка\,\ Суми",
"380332", "Луцьк\,\ Волинська",
"3806278", "Марʼїнка\,\ Донецьк",
"3805758", "Богодухів\,\ Харків",
"3805358", "Пирятин\,\ Полтава",
"3803234", "Мостиська\,\ Львівська",
"3804330", "Оратів\,\ Вінниця",
"3806243", "Велика\ Новосілка\,\ Донецьк",
"3806446", "Кіровськ\,\ Луганськ",
"3804730", "Чигирин\,\ Черкаси",
"3805547", "Білозерка\,\ Херсон",
"3803363", "Турійськ\,\ Волинська",
"3804148", "Овруч\,\ Житомир",
"3804868", "Іллічівськ\,\ Одеса",
"3803657", "Костопіль\,\ Рівне",
"3805347", "Чутове\,\ Полтава",
"3803433", "Коломия\,\ Івано\-Франківська",
"3803236", "Самбір\,\ Львівська",
"3806444", "Стаханов\,\ Луганськ",
"3806297", "Мангуш\/Ялта\,\ Донецьк",
"3805747", "Зміїв\,\ Харків",
"3804335", "Тульчин\,\ Вінниця",
"3804735", "Корсунь\-Шевченківський\,\ Черкаси",
"380567", "Дніпропетро́вськ\/Дніпро",
"3803267", "Львів\/Львівська",
"3806232", "Макіївка\,\ Донецьк",
"3803730", "Вижниця\,\ Чернівці",
"3804657", "Корюківка\,\ Чернігів",
"3805444", "Глухів\,\ Суми",
"3805348", "Комсомольськ\,\ Полтава",
"3805748", "Первомайський\,\ Харків",
"380620", "Донецьк",
"3806456", "Троїцьке\,\ Луганськ",
"3806253", "Старобешеве\,\ Донецьк",
"3803268", "Львів\/Львівська",
"38038", "Хмельницький",
"3805630", "Межова\,\ Дніпро",
"3805456", "Ямпіль\,\ Суми",
"3805253", "Добровеличківка\,\ Кіровоград",
"3804658", "Новгород\-Сіверський\,\ Чернігів",
"380569", "Дніпродзержинськ\/Новомосковськ\,\ Дніпро",
"3805163", "Веселинове\,\ Миколаїв",
"3805635", "Юрʼївка\,\ Дніпро",
"380562", "Дніпропетровськ\,\ Дніпро",
"380619", "Мелітополь\,\ Запорізька",
"3806277", "Добропілля\,\ Донецьк",
"3805454", "Буринь\,\ Суми",
"380612", "Запоріжжя\,\ Запорізька",
"3806239", "Красноармійськ\,\ Донецьк",
"3805757", "Барвінкове\,\ Харків",
"3806454", "Кремінна\,\ Луганськ",
"3805357", "Оржиця\,\ Полтава",
"3805239", "Устинівка\,\ Кіровоград",
"38048", "Одеса",
"3805135", "Врадіївка\,\ Миколаїв",
"3805663", "Синельникове\,\ Дніпро",
"3805548", "Новотроїцьке\,\ Херсон",
"3804147", "Любар\,\ Житомир",
"3803658", "Дубровиця\,\ Рівне",
"3804867", "Кодима\,\ Одеса",};
$areanames{en} = {"3805369", "Kremenchug\,\ Poltava",
"3804338", "Khmilnyk\,\ Vinnytsia",
"3804738", "Drabiv\,\ Cherkasy",
"3804572", "Kozin\/Obukhiv\/Ukrainka\,\ Kyiv",
"3805750", "Two\ years\ old\,\ Kharkiv",
"3805350", "Kotelva\,\ Poltava",
"3804162", "Brusilov\,\ Zhytomyr",
"3803841", "Belogorsk\,\ Khmelnytskyi",
"3805664", "Nikopol\,\ Dnipro",
"3804860", "Frunzivka\,\ Odesa",
"3804859", "Velikaya\ Mikhailovka\,\ Odesa",
"3804140", "Natives\,\ Zhytomyr",
"3806256", "Snizhne\,\ Donetsk",
"3806453", "Rubizhne\,\ Luhansk",
"380640", "Luhansk",
"3803145", "Perechyn\,\ Zakarpattia",
"3803249", "Chervonograd\,\ Lviv",
"3805453", "Krolevets\,\ Sumy",
"3805256", "Novomirgorod\,\ Kirovohrad",
"3805691", "Magdalenivka\,\ Dnipro",
"3806270", "Artemivsk\,\ Donetsk",
"3803252", "Zhovkva\,\ Lviv",
"3805164", "Kazanka\,\ Mykolayiv",
"3803372", "Ivanychi\,\ Volyn",
"380328", "Lviv",
"3804161", "Luginy\,\ Zhytomyr",
"3803842", "Netishyn\/Slavuta\,\ Khmelnytskyi",
"3803738", "Putila\,\ Chernivtsi",
"3804571", "Vasilkov\/Glevaha\/Grebinky\/Kalinovka\,\ Kyiv",
"3806137", "Primorsk\,\ Zaporizhzhia",
"3806439", "Luhansk",
"3805254", "Haivoron\,\ Kirovohrad",
"3804841", "Izmail\,\ Odesa",
"3806275", "Dokuchaevsk\,\ Donetsk",
"3804645", "Gorodnya\,\ Chernihiv",
"3803859", "Chemerivtsi\,\ Khmelnytskyi",
"3805637", "Pavlograd\,\ Dnipro",
"3804145", "Volodarsk\-Volynsky\,\ Zhytomyr",
"3804865", "Savran\,\ Odesa",
"3805755", "Kegichivka\,\ Kharkiv",
"3803251", "Skole\/Slavske\,\ Lviv",
"3806254", "Torez\,\ Donetsk",
"3805355", "Mirgorod\,\ Poltava",
"3805692", "Dneprodzerzhinsk\,\ Dnipro",
"3805666", "Nikopol\,\ Dnipro",
"3803259", "Yavoriv\,\ Lviv",
"3803379", "Gorokhov\,\ Volyn",
"3803737", "Zastavna\,\ Chernivtsi",
"3805443", "Belopoly\,\ Sumy",
"3806138", "Kamyanets\'\-Dniprovs\'ka\,\ Zaporizhzhia",
"3803260", "Morshin\,\ Lviv",
"380321", "Lviv",
"3804566", "Tarashcha\,\ Kyiv",
"3803242", "Lviv",
"3805638", "Pokrovskoe\,\ Dnipro",
"3804852", "Belyaevka\,\ Odesa",
"3803366", "Ratne\,\ Volyn",
"3805545", "Upper\ Rogachik\,\ Kherson",
"38044", "Kyiv\ city",
"3803851", "Gorodok\/Sataniv\,\ Khmelnytskyi",
"3805340", "Chornukhi\,\ Poltava",
"3803655", "Sarny\,\ Rivne",
"3805740", "New\ Waterlog\,\ Kharkiv",
"3804579", "Slavutych\,\ Kyiv",
"3805362", "Khorol\,\ Poltava",
"3805762", "Sakhnovshchyna\,\ Kharkiv",
"3804849", "Belgorod\-Dniester\/Zatoka\/Sergievka\,\ Odesa",
"3806443", "Bryanka\,\ Luhansk",
"3806246", "Volodarske\,\ Donetsk",
"3803434", "Vorokhta\/Yaremche\,\ Ivano\-Frankivsk",
"3806431", "Anthracite\,\ Luhansk",
"3804337", "Mogilev\-Podolsky\,\ Vinnytsia",
"3804737", "Zolotonosha\,\ Cherkasy",
"3806244", "Volnovaha\,\ Donetsk",
"3805345", "Big\ Bagachka\,\ Poltava",
"3803241", "Nikolaev\,\ Lviv",
"3803436", "Tysmenytsia\,\ Ivano\-Frankivsk",
"3805745", "Lozova\,\ Kharkiv",
"3803650", "Goshcha\,\ Rivne",
"3803233", "Lviv",
"380623", "Krasnoarmeysk\/Makeyevka\,\ Donetsk",
"3805540", "Lower\ Sirogozy\,\ Kherson",
"3804591", "Ivankiv\,\ Kyiv",
"3803852", "Iziaslav\,\ Khmelnytskyi",
"38034", "Ivano\-Frankivsk",
"3804655", "Sosnitsa\,\ Chernihiv",
"3804851", "Ovidiopol\,\ Odesa",
"3806432", "Krasnyi\ Luch\,\ Luhansk",
"3805761", "Zachepilivka\,\ Kharkiv",
"3803265", "Zolochiv\,\ Lviv",
"3805361", "Lubny\,\ Poltava",
"3803849", "Kamyanets\-Podilskyi\,\ Khmelnytskyi",
"3804564", "Stavyshche\,\ Kyiv",
"3806272", "Kostiantynivka\,\ Donetsk",
"3804642", "Sedimentary\,\ Chernihiv",
"3803269", "Turka\,\ Lviv",
"3803250", "Lviv",
"3803845", "Volochysk\,\ Khmelnytskyi",
"3803633", "Radivilov\,\ Rivne",
"3804659", "Semenivka\,\ Chernihiv",
"3804862", "Kotovsk\,\ Odesa",
"3806144", "Novomikolaevka\,\ Zaporizhzhia",
"3805749", "Balaklia\,\ Kharkiv",
"3803141", "Berehove\,\ Zakarpattia",
"3803133", "Svalyava\,\ Zakarpattia",
"380647", "Luhansk",
"3804142", "Korosten\,\ Zhytomyr",
"3804840", "Reni\,\ Odesa",
"3805352", "Shishaki\,\ Poltava",
"3805752", "Great\ Burluk\,\ Kharkiv",
"3803554", "Zalishchiki\,\ Ternopil",
"3804570", "Zgurovka\,\ Kyiv",
"3804575", "Yagotin\,\ Kyiv",
"3805238", "Onufryevka\,\ Kirovohrad",
"3804845", "Artsis\,\ Odesa",
"3805690", "Tsarichanka\,\ Dnipro",
"3804633", "Ichnya\,\ Chernihiv",
"3806271", "Artemivsk\,\ Donetsk",
"3804641", "Rivers\,\ Chernihiv",
"3805549", "New\ Kakhovka\,\ Kherson",
"3803659", "Mlyniv\,\ Rivne",
"3804133", "Malin\,\ Zhytomyr",
"3804141", "Novograd\-Volynsky\,\ Zhytomyr",
"3804356", "Murovani\ Kurylivtsi\,\ Vinnytsia",
"3804861", "Red\ Windows\,\ Odesa",
"3803142", "Hust\,\ Zakarpattia",
"3805751", "Shevchenkovo\,\ Kharkiv",
"3805351", "Dikanka\,\ Poltava",
"3803840", "Shepetovka\,\ Khmelnytskyi",
"3803255", "Radehiv\,\ Lviv",
"3805359", "Hrebinka\,\ Poltava",
"3805759", "Borova\,\ Kharkiv",
"3805237", "Petrov\,\ Kirovohrad",
"3803346", "Old\ Vyzhivka\,\ Volyn",
"3805360", "Kremenchug\,\ Poltava",
"3804149", "Emilchine\,\ Zhytomyr",
"3805654", "Krynychky\,\ Dnipro",
"3804850", "Teplodar\,\ Odesa",
"3805742", "Kupyansk\,\ Kharkiv",
"3805342", "Kozelshchina\,\ Poltava",
"3803544", "Buchach\,\ Ternopil",
"3806463", "Novopskov\,\ Luhansk",
"3806266", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3805533", "Novovorontsovka\,\ Kherson",
"3803240", "Lviv",
"3804344", "Shargorod\,\ Vinnytsia",
"3803855", "Krasilov\,\ Khmelnytskyi",
"3803651", "Korets\,\ Rivne",
"3804744", "Uman\,\ Cherkasy",
"380649", "Luhansk",
"3803262", "Lviv",
"3806279", "Telmanov\,\ Donetsk",
"3805154", "Ochakiv\,\ Mykolayiv",
"3806175", "Vasilivka\/Dneprorudne\,\ Zaporizhzhia",
"3806237", "Selidus\,\ Donetsk",
"380642", "Luhansk\/Oleksandrivsk\,\ Luhansk",
"3806435", "Krasnodon\,\ Luhansk",
"3804346", "Pogrebishche\,\ Vinnytsia",
"3806430", "Luhansk",
"3804746", "Monastyrysche\,\ Cherkasy",
"3805341", "Semenivka\,\ Poltava",
"3803245", "Stryi\,\ Lviv",
"3803850", "Old\ Sinyava\,\ Khmelnytskyi",
"3805741", "Vovchansk\,\ Kharkiv",
"3804595", "Borispol\,\ Kyiv",
"3803652", "Zdolbunov\,\ Rivne",
"3806156", "Big\ Belozerka\,\ Zaporizhzhia",
"3805542", "Tsyurupinsk\,\ Kherson",
"3803344", "Novovolynsk\,\ Volyn",
"3804855", "Kominternovskoe\,\ Odesa",
"3805765", "Pechenegi\,\ Kharkiv",
"3806264", "Kramatorsk\,\ Donetsk",
"3803261", "Novy\ Rozdol\,\ Lviv",
"3805365", "Globin\,\ Poltava",
"3803546", "Kremenets\/Pochayiv\,\ Ternopil",
"3805656", "Apostolove\,\ Dnipro",
"380641", "Luhansk",
"3806460", "Luhansk",
"3804853", "Limanske\/Rozdilna\,\ Odesa",
"3805234", "Dolinska\,\ Kirovohrad",
"3806459", "Luhansk",
"3805363", "Reshetilivka\,\ Poltava",
"3805763", "Carriers\,\ Kharkiv",
"3803547", "Kozlov\/Kozova\,\ Ternopil",
"3806442", "Alchevsk\,\ Luhansk",
"3805657", "Broad\,\ Dnipro",
"3804347", "Litin\,\ Vinnytsia",
"3804747", "Zhashkiv\,\ Cherkasy",
"3805442", "Putivl\,\ Sumy",
"3803231", "Gorodok\,\ Lviv",
"380572", "Merefa\/Kharkiv\,\ Kharkiv",
"3803243", "Lviv",
"3805459", "Krasnopolye\,\ Sumy",
"3805530", "Kalanchak\,\ Kherson",
"3805535", "Vysokoplylya\,\ Kherson",
"3804358", "Lipovets\,\ Vinnytsia",
"3803853", "Yarmolintsy\,\ Khmelnytskyi",
"3806236", "Yasinovata\,\ Donetsk",
"3806433", "Rovenky\,\ Luhansk",
"3806441", "Perevalsk\,\ Luhansk",
"38052", "Kirovohrad",
"3805236", "Svetlovodsk\,\ Kirovohrad",
"3803558", "Shumsk\,\ Ternopil",
"38069", "Sevastopol\ city",
"3806465", "Milow\,\ Luhansk",
"3806267", "Druzhkovka\,\ Donetsk",
"3803232", "Lviv",
"3804135", "Olevsk\,\ Zhytomyr",
"3805452", "Lipova\ Dolina\,\ Sumy",
"3803253", "Lviv",
"380320", "Lviv",
"3805449", "Shostka\,\ Sumy",
"3804573", "Kagarlyk\/Rzhyshchiv\,\ Kyiv",
"3804635", "Baturin\/Bahmach\,\ Chernihiv",
"3804843", "Wilkow\/Kielia\,\ Odesa",
"3806147", "Kuybyshev\,\ Zaporizhzhia",
"3806449", "Luhansk",
"3803557", "Gusyatin\,\ Ternopil",
"380648", "Luhansk",
"3806452", "Severodonetsk\,\ Luhansk",
"3806268", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3803475", "Delyatin\/Nadvirna\,\ Ivano\-Frankivsk",
"3803357", "Kamin\-Kashirsky\,\ Volyn",
"3805451", "Mid\-Buda\,\ Sumy",
"3803135", "Great\ Berezny\,\ Zakarpattia",
"380312", "Uzhgorod\/Chop\,\ Zakarpattia",
"3803239", "Zhidachiv\,\ Lviv",
"3805693", "Novomoskovsk\,\ Dnipro",
"3803548", "Berezhany\,\ Ternopil",
"3805658", "Verhnedneprovsk\,\ Dnipro",
"3804348", "Tomashpil\,\ Vinnytsia",
"3804748", "Mankivka\,\ Cherkasy",
"3803843", "Polonne\,\ Khmelnytskyi",
"3803635", "Rokitne\,\ Rivne",
"3805158", "Bashtanka\,\ Mykolayiv",
"3806451", "Lisichansk\,\ Luhansk",
"3804130", "Korostyshiv\,\ Zhytomyr",
"3805258", "Malaya\ Vyska\,\ Kirovohrad",
"3803734", "Deep\,\ Chernivtsi",
"3804653", "Borzna\,\ Chernihiv",
"3805532", "Great\ Aleksandrovka\,\ Kherson",
"3803263", "Peremyshlyany\,\ Lviv",
"38043", "Vinnytsia",
"38047", "Cherkasy",
"3804336", "Yampil\,\ Vinnytsia",
"3804736", "Kaniv\,\ Cherkasy",
"3806440", "Luhansk",
"38035", "Ternopil",
"3805743", "Izyum\,\ Kharkiv",
"3803235", "Lviv",
"380322", "Bryukhovichi\/Lviv\,\ Lviv",
"3803437", "Bolechov\,\ Ivano\-Frankivsk",
"3805343", "Kobelyaky\,\ Poltava",
"3803479", "Tlumach\,\ Ivano\-Frankivsk",
"3806462", "Belokurakine\,\ Luhansk",
"3806258", "Donetsk",
"380329", "Lviv",
"3805531", "Ivanivka\,\ Kherson",
"3805543", "Great\ Lipetyha\,\ Kherson",
"3803653", "Berezne\,\ Rivne",
"3804334", "Haysin\,\ Vinnytsia",
"3803230", "Pustomyty\,\ Lviv",
"3804734", "Chernigov\ region",
"3806247", "Dzerzhinsk\,\ Donetsk",
"3805668", "Tomakivka\,\ Dnipro",
"3806445", "Novoyadar\,\ Luhansk",
"38037", "Chernivtsi",
"3804639", "Silver\,\ Chernihiv",
"38033", "Volyn",
"3805445", "Lebedin\,\ Sumy",
"3803736", "Kitsman\,\ Chernivtsi",
"38045", "Kyiv",
"3804139", "Chudniv\,\ Zhytomyr",
"3804567", "Pereyaslav\-Khmelnitsky\,\ Kyiv",
"3805168", "Bereznegovate\,\ Mykolayiv",
"3806461", "Starobilsk\,\ Luhansk",
"3803368", "Rozhysche\,\ Volyn",
"3806450", "Luhansk",
"3804143", "Berdychiv\,\ Zhytomyr",
"3804131", "Chervonoarmiysk\,\ Zhytomyr",
"3804863", "Ananev\,\ Odesa",
"3803132", "Rakhiv\,\ Zakarpattia",
"3803472", "Kalush\,\ Ivano\-Frankivsk",
"3806469", "Luhansk",
"3805353", "Zinkiv\,\ Poltava",
"38061", "Zaporizhzhia",
"3805753", "Valki\,\ Kharkiv",
"3805136", "Yuzhnoukrainsk\,\ Mykolayiv",
"3805667", "Ordzhonikidze\,\ Dnipro",
"3806248", "Gorlovka\,\ Donetsk",
"380327", "Lviv",
"3803632", "Zarechnaya\,\ Rivne",
"3806273", "Vugledar\,\ Donetsk",
"3804643", "Kulikivka\,\ Chernihiv",
"3804631", "Nizhyn\,\ Chernihiv",
"38051", "Mykolayiv",
"3806136", "Веселе\,\ Zaporizhzhia",
"3804568", "Skvyra\,\ Kyiv",
"3805167", "New\ Odesa\,\ Mykolayiv",
"3805539", "Gola\ Prystan\,\ Kherson",
"3805636", "Ternivka\,\ Dnipro",
"3806474", "Popasna\,\ Luhansk",
"3803471", "Bogorodchany\,\ Ivano\-Frankivsk",
"3805257", "Bobrinets\,\ Kirovohrad",
"3805455", "Nedrigailov\,\ Sumy",
"3803131", "Mukacheve\,\ Zakarpattia",
"3803143", "Vinogradov\,\ Zakarpattia",
"3804132", "Radomyshl\,\ Zhytomyr",
"3805634", "Petrykivka\,\ Dnipro",
"380564", "Krivoy\ Rog\,\ Dnipro",
"3804632", "Bobrovitsa\,\ Chernihiv",
"3803438", "Burshtyn\,\ Ivano\-Frankivsk",
"3806455", "Pervomaisk\,\ Luhansk",
"3806257", "Ilovajsk\/Khartsyzsk\,\ Donetsk",
"3805134", "Voznesensk\,\ Mykolayiv",
"3804735", "Korsun\-Shevchenkivsky\,\ Cherkasy",
"3804335", "Tulchin\,\ Vinnytsia",
"380567", "Dnipropetrovsk\/Dnipro",
"3806297", "Mangosh\/Yalta\,\ Donetsk",
"3806444", "Stakhanov\,\ Luhansk",
"3805747", "Snakes\,\ Kharkiv",
"3805347", "Chutovoye\,\ Poltava",
"3803433", "Kolomyia\,\ Ivano\-Frankivsk",
"3803236", "Sambir\,\ Lviv",
"3805444", "Glukhov\,\ Sumy",
"3804657", "Koryukivka\,\ Chernihiv",
"3803267", "Lviv",
"3806232", "Makeevka\,\ Donetsk",
"3803730", "Vyzhnytsia\,\ Chernivtsi",
"380332", "Lutsk\,\ Volyn",
"3805446", "Tomatoes\,\ Sumy",
"3803735", "Storozhynets\,\ Chernivtsi",
"3806278", "Marinka\,\ Donetsk",
"3804563", "Belaya\ Tserkov\/Uzin\,\ Kyiv",
"3803363", "Turiysk\,\ Volyn",
"3805547", "Belozerka\,\ Kherson",
"3804148", "Ovruch\,\ Zhytomyr",
"3803657", "Kostopil\,\ Rivne",
"3804868", "Illichivsk\,\ Odesa",
"3805358", "Pyriatyn\,\ Poltava",
"3805758", "Bogodukhiv\,\ Kharkiv",
"3806446", "Kirovsk\,\ Luhansk",
"3804730", "Chigirin\,\ Cherkasy",
"3806243", "Great\ Novosilka\,\ Donetsk",
"3803234", "Mostyska\,\ Lviv",
"3804330", "Oratov\,\ Vinnytsia",
"380619", "Melitopol\,\ Zaporizhzhia",
"3805454", "Burin\,\ Sumy",
"3806277", "Dobropolia\,\ Donetsk",
"3806239", "Krasnoarmeysk\,\ Donetsk",
"380612", "Zaporozhye\,\ Zaporizhzhia",
"380569", "Dneprodzerzhinsk\/Novomoskovsk\,\ Dnipro",
"3805163", "Veselinove\,\ Mykolayiv",
"380562", "Dnipropetrovsk\/Dnipro",
"3805635", "Yurievka\,\ Dnipro",
"3805548", "Novotroitsk\,\ Kherson",
"3804147", "Lyubar\,\ Zhytomyr",
"3803658", "Dubrovitsa\,\ Rivne",
"3804867", "Kodima\,\ Odesa",
"3805357", "Orzhitsa\,\ Poltava",
"3806454", "Kremenna\,\ Luhansk",
"3805757", "Barvinkov\,\ Kharkiv",
"3805135", "Vradievka\,\ Mykolayiv",
"3805239", "Ustinovka\,\ Kirovohrad",
"38048", "Odesa",
"3805663", "Sinelnikovo\,\ Dnipro",
"3805748", "Pervomaysk\,\ Kharkiv",
"3805348", "Komsomolsk\,\ Poltava",
"3806456", "Trinity\ Church\,\ Luhansk",
"3806253", "Starobesheve\,\ Donetsk",
"380620", "Donetsk",
"3805456", "Yampil\,\ Sumy",
"3805630", "Mezhova\,\ Dnipro",
"3805253", "Dobrovelichkovka\,\ Kirovohrad",
"3804658", "Novgorod\-Seversky\,\ Chernihiv",
"3803268", "Lviv",
"38038", "Khmelnytskyi",
"3804731", "Talne\,\ Cherkasy",
"3804343", "Ladyzhin\/Trostyanets\,\ Vinnytsia",
"3804331", "Bratslav\/Nemyriv\,\ Vinnytsia",
"3805534", "Genichesk\,\ Kherson",
"3803732", "Kelmentsi\,\ Chernivtsi",
"3803247", "Truskavets\,\ Lviv",
"3805153", "Berezanka\,\ Mykolayiv",
"3804597", "Bucha\/Vorzel\/Gostomel\/Irpen\/Kotsyubinskoe\,\ Kyiv",
"3804857", "Nikolaevka\,\ Odesa",
"38057", "Kharkiv",
"38053", "Poltava",
"3806153", "Berdyansk\,\ Zaporizhzhia",
"3805367", "Kremenchug\,\ Poltava",
"3806464", "Markovka\,\ Luhansk",
"3803543", "Podvolochisk\,\ Ternopil",
"3805653", "Volnogirsk\,\ Dnipro",
"380560", "Dnipropetrovsk\/Dnipro",
"380522", "Kropyvnytskyi\,\ Kirovohrad",
"3804578", "Makarov\,\ Kyiv",
"3805235", "Alexandria\,\ Kirovohrad",
"3804848", "Saratov\,\ Odesa",
"3804332", "Brailiv\/Zhmerinka\,\ Vinnytsia",
"3804732", "Kamyanets\,\ Cherkasy",
"3806263", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3806466", "Belovodsk\,\ Luhansk",
"38055", "Kherson",
"3805536", "Kakhovka\,\ Kherson",
"38065", "Crimea",
"3803857", "Letychiv\/Medzhybizh\,\ Khmelnytskyi",
"3805639", "Vasylkivka\,\ Dnipro",
"3803258", "Lviv",
"380629", "Mariupol\,\ Donetsk",
"3806139", "Energodar\,\ Zaporizhzhia",
"3806437", "Luhansk",
"380622", "Donetsk",
"3804577", "Borodyanka\/Klavdievo\-Tarasovo\/Nemishaive\,\ Kyiv",
"3804636", "Varva\,\ Chernihiv",
"3806471", "Swatov\,\ Luhansk",
"3803474", "Rozhnyatov\,\ Ivano\-Frankivsk",
"3804847", "Tarutino\,\ Odesa",
"3806143", "Vilnyansk\,\ Zaporizhzhia",
"3803134", "Solotvyno\/Tyachiv\,\ Zakarpattia",
"3806131", "Yakimivka\,\ Zaporizhzhia",
"3805631", "Petropavlovka\,\ Dnipro",
"38041", "Zhytomyr",
"3804353", "Teplik\,\ Vinnytsia",
"3803634", "Volodymyrets\,\ Rivne",
"3804136", "Andrushivka\,\ Zhytomyr",
"3803858", "Dunaevtsi\,\ Khmelnytskyi",
"3803257", "Sokal\,\ Lviv",
"3803377", "Lyuboml\,\ Volyn",
"3803739", "Sokyryany\,\ Chernivtsi",
"38046", "Chernihiv",
"3805131", "Bratsk\,\ Mykolayiv",
"3806438", "Luhansk",
"3806178", "Tokmak\,\ Zaporizhzhia",
"3806132", "Mikhailivka\,\ Zaporizhzhia",
"3806472", "Stanitsa\ Luhansk\,\ Luhansk",
"3803847", "New\ Ushitsa\,\ Khmelnytskyi",
"3803636", "Kuznetsovsk\,\ Rivne",
"3804134", "Chernyakhov\,\ Zhytomyr",
"3803248", "Boryslav\/Skhidnytsya\,\ Lviv",
"3805632", "Pavlograd\,\ Dnipro",
"3804598", "Boyarka\/Vishnevoe\,\ Kyiv",
"38031", "Zakarpattia",
"3804634", "Talalayevka\,\ Chernihiv",
"3803476", "Zabolotov\/Sniatyn\,\ Ivano\-Frankivsk",
"3803136", "Volovets\,\ Zakarpattia",
"3804858", "Shiryaevoe\,\ Odesa",
"3805368", "Kremenchug\,\ Poltava",
"38036", "Rivne",
"3804739", "Chernobyl\,\ Cherkasy",
"3805132", "Arbuzinka\,\ Mykolayiv",
"3806162", "Rozvku\,\ Zaporizhzhia",
"3803355", "Shatsk\,\ Volyn",
"3805251", "Novoukrainka\,\ Kirovohrad",
"3803477", "Valley\,\ Ivano\-Frankivsk",
"3804844", "Tatarbunary\,\ Odesa",
"3804574", "Myronivka\,\ Kyiv",
"3803550", "Zbarazh\,\ Ternopil",
"3805662", "Nikopol\,\ Dnipro",
"3806140", "Chernigovka\,\ Zaporizhzhia",
"3803122", "Uzhhorod\,\ Zakarpattia",
"3803846", "Vinkivtsi\,\ Khmelnytskyi",
"3803637", "Demidivka\,\ Rivne",
"3804350", "Vapnarka\,\ Vinnytsia",
"3806251", "Donetsk",
"3803254", "Kamyanka\-Buzka\,\ Lviv",
"3805162", "Snigurovka\,\ Mykolayiv",
"3803374", "Lokachi\,\ Volyn",
"3804137", "Popilnya\,\ Zhytomyr",
"3804569", "Volodarka\,\ Kyiv",
"3803844", "Theophyll\,\ Khmelnytskyi",
"3804355", "Hnivan\/Tyvriv\,\ Vinnytsia",
"3805538", "Askania\-Nova\/Chaplinka\,\ Kherson",
"3805252", "Golovanovsk\,\ Kirovohrad",
"3803256", "Novoyavorivsk\,\ Lviv",
"3803376", "Manevichi\,\ Volyn",
"3805661", "Nikopol\,\ Dnipro",
"3804576", "Baryshevka\/Berezan\,\ Kyiv",
"3806249", "Debaltsevo\,\ Donetsk",
"3806145", "Gulyaypole\,\ Zaporizhzhia",
"3804637", "Priluki\,\ Chernihiv",
"3804846", "Bolgrad\,\ Odesa",
"3805161", "Pervomaysk\,\ Mykolayiv",
"3806252", "Yenakievo\,\ Donetsk",
"3803555", "Monastery\,\ Ternopil",
"380628", "Donetsk",
"3806468", "Luhansk",
"3804138", "Ruzhin\,\ Zhytomyr",
"3805537", "Lazurne\/Skadovsk\,\ Kherson",
"3803856", "Derazhnya\,\ Khmelnytskyi",
"3804594", "Brovary\/Kalita\,\ Kyiv",
"38054", "Sumy",
"3806436", "Lutugin\,\ Luhansk",
"3804740", "Vatutina\/Zvenigorodka\,\ Cherkasy",
"3803244", "Drogobych\,\ Lviv",
"3806241", "Gorlovka\,\ Donetsk",
"3804340", "Kryzhopil\,\ Vinnytsia",
"3805241", "Novgorodka\,\ Kirovohrad",
"3804854", "Ivanivka\,\ Odesa",
"3805650", "Sofiyivka\,\ Dnipro",
"3805233", "Znamenka\,\ Kirovohrad",
"3805669", "Salt\,\ Dnipro",
"3803540", "Meeting\,\ Ternopil",
"3804561", "Boguslav\,\ Kyiv",
"3803432", "Verkhovyna\,\ Ivano\-Frankivsk",
"3805364", "Mashivka\,\ Poltava",
"3806265", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3806467", "Luhansk",
"3805764", "Zolochiv\,\ Kharkiv",
"3806260", "Kramatorsk\/Slavyansk\,\ Donetsk",
"380621", "Donetsk",
"3803478", "Kosiv\,\ Ivano\-Frankivsk",
"3803362", "Lubeshiv\,\ Volyn",
"3806259", "Amvrosievka\,\ Donetsk",
"3804856", "Berezivka\,\ Odesa",
"3806242", "Gorlovka\,\ Donetsk",
"3805366", "Kremenchug\,\ Poltava",
"3805766", "Kolomak\,\ Kharkiv",
"3803740", "Hertz\,\ Chernivtsi",
"3805655", "Dnipropetrovsk\/Dnipro",
"3804745", "Monastyrysche\,\ Cherkasy",
"3803854", "Starokostiantyniv\,\ Khmelnytskyi",
"3804345", "Illintsi\,\ Vinnytsia",
"3805242", "Aleksandrovka\,\ Kirovohrad",
"3805259", "Ulyanovka\,\ Kirovohrad",
"3803431", "Halych\,\ Ivano\-Frankivsk",
"3806434", "Sverdlovsk\,\ Luhansk",
"3803246", "Lviv",
"3804562", "Rokitne\,\ Kyiv",
"3804596", "Vyshgorod\/Dimer\/Pirnove\,\ Kyiv",
"3803146", "Mizhhirya\,\ Zakarpattia",
"3805457", "Great\ Pisarivka\,\ Sumy",
"3806274", "Artemivsk\/Siversk\,\ Donetsk",
"3805159", "Elanets\,\ Mykolayiv",
"3804644", "Mena\,\ Chernihiv",
"3805255", "Novorangels\'k\,\ Kirovohrad",
"3804352", "Bershad\,\ Vinnytsia",
"3804349", "Pishchanka\,\ Vinnytsia",
"3804749", "Lysyanka\,\ Cherkasy",
"3803549", "Lanovtsi\,\ Ternopil",
"3804864", "Lyubashevka\,\ Odesa",
"3805660", "Nikopol\,\ Dnipro",
"380561", "Dnipropetrovsk\/Dnipro",
"3805659", "Dnipropetrovsk\/Dnipro",
"3804144", "Baranivka\,\ Zhytomyr",
"3803238", "Old\ Sambir\,\ Lviv",
"3803552", "Chortkiv\,\ Ternopil",
"3805354", "Gadyach\,\ Poltava",
"3806255", "Shakhtarsk\,\ Donetsk",
"3805754", "Gemini\,\ Kharkiv",
"3806457", "Luhansk",
"3804146", "Dzerzhinsk\,\ Zhytomyr",
"3806250", "Kirovske\,\ Donetsk",
"3804351", "Chechelnyk\,\ Vinnytsia",
"3806165", "Childbirth\,\ Zaporizhzhia",
"3803352", "Kovel\,\ Volyn",
"3806269", "Aleksandrovka\,\ Donetsk",
"3804866", "Balta\,\ Odesa",
"3805133", "Creve\ Lake\,\ Mykolayiv",
"3805356", "Lokhvytsia\,\ Poltava",
"3805756", "Krasnokutsk\,\ Kharkiv",
"3806448", "Luhansk",
"3805665", "Manganese\,\ Dnipro",
"3805448", "Romny\,\ Sumy",
"3806133", "Priazovskoe\,\ Zaporizhzhia",
"3803144", "Irshava\,\ Zakarpattia",
"3806141", "Orychiv\,\ Zaporizhzhia",
"3806473", "Slavyanoserbsk\,\ Luhansk",
"3806276", "Artemivsk\,\ Donetsk",
"3804646", "Desna\/Kozelets\/Oster\,\ Chernihiv",
"3803551", "Terebovlya\,\ Ternopil",
"3805250", "Vilshanka\,\ Kirovohrad",
"3805633", "Pershotravensk\,\ Dnipro",
"3803365", "Kivertsi\/Tsuman\,\ Volyn",
"3805546", "Berislav\,\ Kherson",
"3803656", "Dubno\,\ Rivne",
"38037312", "Khotin\,\ Chernivtsi",
"3803430", "Gorodenka\,\ Ivano\-Frankivsk",
"3805652", "Yellow\ Waters\,\ Dnipro",
"380568", "Dnipropetrovsk\/Dnipro",
"3803542", "Pidhaytsi\,\ Ternopil",
"3806447", "Luhansk",
"3805744", "Krasnograd\,\ Kharkiv",
"3805344", "New\ Sanzhary\,\ Poltava",
"3806245", "Gorlovka\,\ Donetsk",
"3803733", "Novoselytsia\,\ Chernivtsi",
"3803741", "Novodnistrovsk\,\ Chernivtsi",
"3805447", "Konotop\,\ Sumy",
"3804654", "Shchors\,\ Chernihiv",
"3804342", "Kozatin\,\ Vinnytsia",
"3804742", "Katerinopil\,\ Cherkasy",
"3804565", "Fastov\,\ Kyiv",
"3803264", "Busk\,\ Lviv",
"3806261", "Krasny\ Liman\,\ Donetsk",
"3805152", "Domanivka\,\ Mykolayiv",
"3805458", "Trostyanets\,\ Sumy",
"3804560", "Tetiev\,\ Kyiv",
"3804656", "Carp\,\ Chernihiv",
"3803266", "Brody\,\ Lviv",
"3803541", "Borschiv\,\ Ternopil",
"3805240", "Kompaniyivka\,\ Kirovohrad",
"3805651", "Dnipropetrovsk\/Dnipro",
"3804333", "Kalinovka\,\ Vinnytsia",
"3803654", "Ostrog\,\ Rivne",
"3804741", "Shpola\,\ Cherkasy",
"3804733", "Smila\,\ Cherkasy",
"3806240", "Gorlovka\,\ Donetsk",
"3804341", "Bar\,\ Vinnytsia",
"3803342", "Volodymyr\-Volynsky\,\ Volyn",
"3805544", "Gornostaevka\,\ Kherson",
"3806262", "Svyatogorsk\/Slavyansk\,\ Donetsk",
"3805151", "Novy\ Buh\,\ Mykolayiv",
"3805746", "Chuguev\,\ Kharkiv",
"3806296", "Novoazovsk\,\ Donetsk",
"3803435", "Rohatyn\,\ Ivano\-Frankivsk",
"3803237", "Lviv",
"3805346", "Karlovka\,\ Poltava",
"3806458", "Luhansk",};
my $timezones = {
               '' => [
                       'Europe/Kyiv'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+380|\D)//g;
      my $self = bless({ country_code => '380', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '380', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;