# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::IM;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240607153920;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1624(?:
            230|
            [5-8]\\d\\d
          )\\d{3}
        ',
                'geographic' => '
          1624(?:
            230|
            [5-8]\\d\\d
          )\\d{3}
        ',
                'mobile' => '
          76245[06]\\d{4}|
          7(?:
            4576|
            [59]24\\d|
            624[0-4689]
          )\\d{5}
        ',
                'pager' => '',
                'personal_number' => '70\\d{8}',
                'specialrate' => '(
          8(?:
            440[49]06|
            72299\\d
          )\\d{3}|
          (?:
            8(?:
              45|
              70
            )|
            90[0167]
          )624\\d{4}
        )|(
          3440[49]06\\d{3}|
          (?:
            3(?:
              08162|
              3\\d{4}|
              45624|
              7(?:
                0624|
                2299
              )
            )|
            55\\d{4}
          )\\d{4}
        )',
                'toll_free' => '808162\\d{4}',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"442870", "Coleraine",
"4413393", "Aboyne",
"441643", "Minehead",
"441830", "Kirkwhelpington",
"442844", "Downpatrick",
"441501", "Harthill",
"4414232", "Harrogate",
"441957", "Mid\ Yell",
"442888", "Northern\ Ireland",
"441469", "Killingholme",
"4414375", "Clynderwen\ \(Clunderwen\)",
"441387", "Dumfries",
"441538", "Ipstones",
"441677", "Bedale",
"442882", "Omagh",
"441347", "Easingwold",
"442842", "Kircubbin",
"441267", "Carmarthen",
"442848", "Northern\ Ireland",
"441926", "Warwick",
"441563", "Kilmarnock",
"441865", "Oxford",
"441629", "Matlock",
"442884", "Northern\ Ireland",
"441141", "Sheffield",
"441373", "Frome",
"4419755", "Alford\ \(Aberdeen\)",
"441920", "Ware",
"441683", "Moffat",
"441675", "Coleshill",
"4418472", "Thurso",
"441534", "Jersey",
"4414346", "Hexham",
"441955", "Wick",
"4419644", "Patrington",
"441903", "Worthing",
"441236", "Coatbridge",
"4418510", "Great\ Bernera\/Stornoway",
"441728", "Saxmundham",
"442821", "Martinstown",
"44114703", "Sheffield",
"441665", "Alnwick",
"441363", "Crediton",
"4418478", "Thurso",
"441722", "Salisbury",
"441427", "Gainsborough",
"4414344", "Bellingham",
"4413399", "Ballater",
"441547", "Knighton",
"441299", "Bewdley",
"441243", "Chichester",
"4419646", "Patrington",
"441334", "St\ Andrews",
"4418471", "Thurso\/Tongue",
"441495", "Pontypool",
"441829", "Tarporley",
"441277", "Brentwood",
"441883", "Caterham",
"441875", "Tranent",
"441794", "Romsey",
"4412290", "Barrow\-in\-Furness\/Millom",
"441573", "Kelso",
"441404", "Honiton",
"441753", "Slough",
"441843", "Thanet",
"441939", "Wem",
"441545", "Llanarth",
"441899", "Biggar",
"441425", "Ringwood",
"441724", "Scunthorpe",
"441479", "Grantown\-on\-Spey",
"4418905", "Ayton",
"441630", "Market\ Drayton",
"442866", "Enniskillen",
"441667", "Nairn",
"4414238", "Harrogate",
"441450", "Hawick",
"441792", "Swansea",
"441707", "Welwyn\ Garden\ City",
"4414231", "Harrogate\/Boroughbridge",
"441275", "Clevedon",
"441971", "Scourie",
"441283", "Burton\-on\-Trent",
"441456", "Glenurquhart",
"441497", "Hay\-on\-Wye",
"441877", "Callander",
"441431", "Helmsdale",
"442891", "Bangor\ \(Co\.\ Down\)",
"441798", "Pulborough",
"441636", "Newark\-on\-Trent",
"441408", "Golspie",
"441301", "Arrochar",
"4415075", "Spilsby\ \(Horncastle\)",
"442837", "Armagh",
"441332", "Derby",
"441651", "Oldmeldrum",
"4418901", "Coldstream\/Ayton",
"441143", "Sheffield",
"4413873", "Langholm",
"441938", "Welshpool",
"4415078", "Alford\ \(Lincs\)",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441371", "Great\ Dunmow",
"44161", "Manchester",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"441253", "Blackpool",
"441807", "Ballindalloch",
"441892", "Tunbridge\ Wells",
"4418513", "Stornoway",
"441932", "Weybridge",
"441294", "Ardrossan",
"441557", "Kirkcudbright",
"441777", "Retford",
"441472", "Grimsby",
"441205", "Boston",
"441590", "Lymington",
"44114709", "Sheffield",
"4414235", "Harrogate",
"441480", "Huntingdon",
"441228", "Carlisle",
"441743", "Shrewsbury",
"441409", "Holsworthy",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441799", "Saffron\ Walden",
"441824", "Ruthin",
"4414372", "Clynderwen\ \(Clunderwen\)",
"4418908", "Coldstream",
"441561", "Laurencekirk",
"441805", "Torrington",
"441910", "Tyneside\/Durham\/Sunderland",
"441474", "Gravesend",
"441503", "Looe",
"441729", "Settle",
"441555", "Lanark",
"441775", "Spalding",
"441207", "Consett",
"441292", "Ayr",
"441934", "Weston\-super\-Mare",
"441520", "Lochcarron",
"441440", "Haverhill",
"4412299", "Millom",
"441298", "Buxton",
"441822", "Tavistock",
"4419752", "Alford\ \(Aberdeen\)",
"441963", "Wincanton",
"441224", "Aberdeen",
"441526", "Martin",
"441446", "Barry",
"4419647", "Patrington",
"441828", "Coupar\ Angus",
"441641", "Strathy",
"441916", "Tyneside",
"4413390", "Aboyne\/Ballater",
"4418475", "Thurso",
"441985", "Warminster",
"4414347", "Hexham",
"441320", "Fort\ Augustus",
"44121", "Birmingham",
"441433", "Hathersage",
"441303", "Folkestone",
"442849", "Northern\ Ireland",
"442893", "Ballyclare",
"4418519", "Great\ Bernera",
"441653", "Malton",
"441355", "East\ Kilbride",
"4419758", "Strathdon",
"441694", "Church\ Stretton",
"441464", "Insch",
"441841", "Newquay\ \(Padstow\)",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441628", "Maidenhead",
"4419467", "Gosforth",
"441947", "Whitby",
"441765", "Ripon",
"441622", "Maidstone",
"441326", "Falmouth",
"4418902", "Coldstream",
"4414378", "Haverfordwest",
"441692", "North\ Walsham",
"441357", "Strathaven",
"4412293", "Millom",
"441736", "Penzance",
"441987", "Ebbsfleet",
"441698", "Motherwell",
"441571", "Lochinver",
"441751", "Pickering",
"44114705", "Sheffield",
"4415242", "Hornby",
"442823", "Northern\ Ireland",
"441361", "Duns",
"442889", "Fivemiletown",
"441730", "Petersfield",
"441624", "Isle\ of\ Man",
"4415072", "Spilsby\ \(Horncastle\)",
"441462", "Hitchin",
"441945", "Wisbech",
"441241", "Arbroath",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441539", "Kendal",
"441767", "Sandy",
"441723", "Scarborough",
"441509", "Loughborough",
"4413882", "Stanhope\ \(Eastgate\)",
"441859", "Harris",
"441844", "Thame",
"441789", "Stratford\-upon\-Avon",
"442830", "Newry",
"441242", "Cheltenham",
"441461", "Gretna",
"441368", "Dunbar",
"4419649", "Hornsea",
"441490", "Corwen",
"4416862", "Llanidloes",
"441700", "Rothesay",
"441666", "Malmesbury",
"442867", "Lisnaskea",
"4413396", "Ballater",
"441580", "Cranbrook",
"441362", "Dereham",
"441248", "Bangor\ \(Gwynedd\)",
"441870", "Isle\ of\ Benbecula",
"441969", "Leyburn",
"441586", "Campbeltown",
"441876", "Lochmaddy",
"4415394", "Hawkshead",
"441882", "Kinloch\ Rannoch",
"4412297", "Millom",
"441457", "Glossop",
"441496", "Port\ Ellen",
"441572", "Oakham",
"441752", "Plymouth",
"441706", "Rochdale",
"441284", "Bury\ St\ Edmunds",
"441691", "Oswestry",
"441637", "Newquay",
"441888", "Turriff",
"441578", "Lauder",
"441758", "Pwllheli",
"441621", "Maldon",
"441270", "Crewe",
"441848", "Thornhill",
"441364", "Ashburton",
"441842", "Thetford",
"441259", "Alloa",
"441244", "Chester",
"441546", "Lochgilphead",
"441420", "Alton",
"441540", "Kingussie",
"441288", "Bude",
"441635", "Newbury",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"441793", "Swindon",
"441884", "Tiverton",
"441749", "Shepton\ Mallet",
"441282", "Burnley",
"441754", "Skegness",
"441403", "Horsham",
"441455", "Hinckley",
"44118", "Reading",
"441276", "Camberley",
"4414343", "Haltwhistle",
"441642", "Middlesbrough",
"441346", "Fraserburgh",
"441564", "Lapworth",
"4419643", "Patrington",
"441821", "Kinrossie",
"44247", "Coventry",
"442829", "Kilrea",
"441684", "Malvern",
"441260", "Congleton",
"442883", "Northern\ Ireland",
"441904", "York",
"441237", "Bideford",
"441340", "Craigellachie\ \(Aberlour\)",
"441291", "Chepstow",
"441995", "Garstang",
"442310", "Portsmouth",
"441835", "St\ Boswells",
"4414305", "North\ Cave",
"441866", "Kilchrenan",
"441670", "Morpeth",
"441562", "Kidderminster",
"441925", "Warrington",
"4415396", "Sedbergh",
"441439", "Helmsley",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441380", "Devizes",
"442899", "Northern\ Ireland",
"441950", "Sandwick",
"441309", "Forres",
"4416861", "Newtown\/Llanidloes",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441568", "Leominster",
"441644", "New\ Galloway",
"441659", "Sanquhar",
"441235", "Abingdon",
"441931", "Shap",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"4418517", "Stornoway",
"441902", "Wolverhampton",
"441997", "Strathpeffer",
"4416868", "Newtown",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"441837", "Okehampton",
"441676", "Meriden",
"441386", "Evesham",
"441908", "Milton\ Keynes",
"441372", "Esher",
"4414349", "Bellingham",
"442877", "Limavady",
"4413394", "Ballater",
"441978", "Wrexham",
"441397", "Fort\ William",
"441302", "Doncaster",
"441356", "Brechin",
"4413885", "Stanhope\ \(Eastgate\)",
"442892", "Lisburn",
"4414301", "North\ Cave\/Market\ Weighton",
"441606", "Northwich",
"441652", "Brigg",
"441760", "Swaffham",
"441438", "Stevenage",
"441972", "Glenborrodale",
"441308", "Bridport",
"442898", "Belfast",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"4418516", "Great\ Bernera",
"441432", "Hereford",
"441569", "Stonehaven",
"4416865", "Newtown",
"441737", "Redhill",
"441986", "Bungay",
"441325", "Darlington",
"441623", "Mansfield",
"441980", "Amesbury",
"441689", "Orpington",
"441379", "Diss",
"442824", "Northern\ Ireland",
"441766", "Porthmadog",
"441600", "Monmouth",
"4414308", "Market\ Weighton",
"441350", "Dunkeld",
"4412294", "Barrow\-in\-Furness",
"441909", "Worksop",
"441974", "Llanon",
"44114701", "Sheffield",
"441654", "Machynlleth",
"441395", "Budleigh\ Salterton",
"441304", "Dover",
"442894", "Antrim",
"441721", "Peebles",
"442828", "Larne",
"441946", "Whitehaven",
"441463", "Inverness",
"441327", "Daventry",
"442822", "Northern\ Ireland",
"441252", "Aldershot",
"441206", "Colchester",
"441784", "Staines",
"441933", "Wellingborough",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"441854", "Ullapool",
"441473", "Ipswich",
"44115", "Nottingham",
"441485", "Hunstanton",
"441142", "Sheffield",
"441258", "Blandford",
"441289", "Berwick\-upon\-Tweed",
"441527", "Redditch",
"441223", "Cambridge",
"441917", "Sunderland",
"442841", "Rostrevor",
"441748", "Richmond",
"441200", "Clitheroe",
"441508", "Brooke",
"441369", "Dunoon",
"441144", "Sheffield",
"441788", "Rugby",
"442881", "Newtownstewart",
"4414302", "North\ Cave",
"44281", "Northern\ Ireland",
"441858", "Market\ Harborough",
"441502", "Lowestoft",
"441776", "Stranraer",
"441556", "Castle\ Douglas",
"441597", "Llandrindod\ Wells",
"441782", "Stoke\-on\-Trent",
"441249", "Chippenham",
"4412296", "Barrow\-in\-Furness",
"441254", "Blackburn",
"441806", "Shetland",
"441293", "Crawley",
"441852", "Kilmelford",
"441531", "Ledbury",
"441487", "Warboys",
"441915", "Sunderland",
"441968", "Penicuik",
"4413397", "Ballater",
"441550", "Llandovery",
"441770", "Isle\ of\ Arran",
"441823", "Taunton",
"441445", "Gairloch",
"441962", "Winchester",
"441525", "Leighton\ Buzzard",
"441759", "Pocklington",
"4419640", "Hornsea\/Patrington",
"441579", "Liskeard",
"441744", "St\ Helens",
"4418514", "Great\ Bernera",
"441889", "Rugeley",
"441922", "Walsall",
"441565", "Knutsford",
"441863", "Ardgay",
"44280", "Northern\ Ireland",
"442846", "Northern\ Ireland",
"441928", "Runcorn",
"44114700", "Sheffield",
"441647", "Moretonhampstead",
"441905", "Worcester",
"44113", "Leeds",
"441994", "St\ Clears",
"442840", "Banbridge",
"441834", "Narberth",
"441953", "Wymondham",
"441375", "Grays\ Thurrock",
"441383", "Dunfermline",
"441685", "Merthyr\ Tydfil",
"441673", "Market\ Rasen",
"441329", "Fareham",
"4414379", "Haverfordwest",
"4414306", "Market\ Weighton",
"4418903", "Coldstream",
"441530", "Coalville",
"4415395", "Grange\-over\-Sands",
"441343", "Elgin",
"441567", "Killin",
"4412292", "Barrow\-in\-Furness",
"442880", "Carrickmore",
"4418511", "Great\ Bernera\/Stornoway",
"441924", "Wakefield",
"441263", "Cromer",
"441377", "Driffield",
"441838", "Dalmally",
"4419759", "Alford\ \(Aberdeen\)",
"441687", "Mallaig",
"442886", "Cookstown",
"4416867", "Llanidloes",
"4418518", "Stornoway",
"441234", "Bedford",
"441992", "Lea\ Valley",
"441832", "Clopton",
"4415073", "Louth",
"441771", "Maud",
"441536", "Kettering",
"441367", "Faringdon",
"441400", "Honington",
"4416974", "Raughton\ Head",
"441790", "Spilsby",
"441330", "Banchory",
"4418512", "Stornoway",
"441761", "Temple\ Cloud",
"442868", "Kesh",
"441489", "Bishops\ Waltham",
"4412291", "Barrow\-in\-Furness\/Millom",
"441845", "Thirsk",
"441599", "Kyle",
"441543", "Cannock",
"4413395", "Aboyne",
"4418470", "Thurso\/Tongue",
"4417684", "Pooley\ Bridge",
"441458", "Glastonbury",
"4414304", "North\ Cave",
"44241", "Coventry",
"4412298", "Barrow\-in\-Furness",
"441887", "Aberfeldy",
"441638", "Newmarket",
"441406", "Holbeach",
"441452", "Gloucester",
"441757", "Selby",
"441796", "Pitlochry",
"441577", "Kinross",
"4414373", "Clynderwen\ \(Clunderwen\)",
"441273", "Brighton",
"441981", "Wormbridge",
"441285", "Cirencester",
"4418909", "Ayton",
"441726", "St\ Austell",
"441245", "Chelmsford",
"4414230", "Harrogate\/Boroughbridge",
"441663", "New\ Mills",
"441885", "Pencombe",
"441873", "Abergavenny",
"4419753", "Strathdon",
"441583", "Carradale",
"441575", "Kirriemuir",
"441529", "Sleaford",
"441454", "Chipping\ Sodbury",
"441449", "Stowmarket",
"441287", "Guisborough",
"441493", "Great\ Yarmouth",
"4415079", "Alford\ \(Lincs\)",
"441634", "Medway",
"441919", "Durham",
"441720", "Isles\ of\ Scilly",
"44286", "Northern\ Ireland",
"441785", "Stafford",
"441773", "Ripley",
"441553", "Kings\ Lynn",
"441594", "Lydney",
"441855", "Ballachulish",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441296", "Aylesbury",
"441803", "Torquay",
"441257", "Coppull",
"441484", "Huddersfield",
"441505", "Johnstone",
"441290", "Cumnock",
"4414239", "Boroughbridge",
"442311", "Southampton",
"44238", "Southampton",
"441912", "Tyneside",
"4418900", "Coldstream\/Ayton",
"441528", "Laggan",
"441341", "Barmouth",
"441747", "Shaftesbury",
"441918", "Tyneside",
"441522", "Lincoln",
"441442", "Hemel\ Hempstead",
"441261", "Banff",
"441787", "Sudbury",
"441896", "Galashiels",
"441857", "Sanday",
"441482", "Kingston\-upon\-Hull",
"441476", "Grantham",
"441255", "Clacton\-on\-Sea",
"441951", "Colonsay",
"441592", "Kirkcaldy",
"44131", "Edinburgh",
"441671", "Newton\ Stewart",
"441488", "Hungerford",
"4413391", "Aboyne\/Ballater",
"441381", "Fortrose",
"441145", "Sheffield",
"4412295", "Barrow\-in\-Furness",
"441598", "Lynton",
"441444", "Haywards\ Heath",
"441524", "Lancaster",
"441745", "Rhyl",
"441226", "Barnsley",
"441967", "Strontian",
"4413398", "Aboyne",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"441914", "Tyneside",
"441639", "Neath",
"4418479", "Tongue",
"4416864", "Llanidloes",
"441581", "New\ Luce",
"44151", "Liverpool",
"441732", "Sevenoaks",
"441871", "Castlebay",
"441977", "Pontefract",
"441398", "Dulverton",
"441491", "Henley\-on\-Thames",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"4413392", "Aboyne",
"441738", "Perth",
"441460", "Chard",
"4416866", "Newtown",
"441307", "Forfar",
"441392", "Exeter",
"4418515", "Stornoway",
"442897", "Saintfield",
"441943", "Guiseley",
"4414233", "Boroughbridge",
"441690", "Betws\-y\-Coed",
"441466", "Huntly",
"442879", "Magherafelt",
"441324", "Falkirk",
"441661", "Prudhoe",
"4414307", "Market\ Weighton",
"4417687", "Keswick",
"442825", "Ballymena",
"441394", "Felixstowe",
"441655", "Maybole",
"441353", "Ely",
"441305", "Dorchester",
"442895", "Belfast",
"441603", "Norwich",
"441435", "Heathfield",
"441929", "Wareham",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441620", "North\ Berwick",
"441271", "Barnstaple",
"441983", "Isle\ of\ Wight",
"441626", "Newton\ Abbot",
"441322", "Dartford",
"44114704", "Sheffield",
"442827", "Ballymoney",
"4418473", "Thurso",
"44287", "Northern\ Ireland",
"441763", "Royston",
"441328", "Fakenham",
"441239", "Cardigan",
"441209", "Redruth",
"4418477", "Tongue",
"441727", "St\ Albans",
"441422", "Halifax",
"4419754", "Alford\ \(Aberdeen\)",
"441542", "Keith",
"441280", "Buckingham",
"4419645", "Hornsea",
"441664", "Melton\ Mowbray",
"44239", "Portsmouth",
"441548", "Kingsbridge",
"441428", "Haslemere",
"441286", "Caernarfon",
"441704", "Southport",
"441453", "Dursley",
"44117", "Bristol",
"441494", "High\ Wycombe",
"441874", "Brecon",
"441795", "Sittingbourne",
"441405", "Goole",
"441584", "Ludlow",
"441633", "Newport",
"441335", "Ashbourne",
"441840", "Camelford",
"441278", "Bridgwater",
"441750", "Selkirk",
"441570", "Lampeter",
"441880", "Tarbert",
"441366", "Downham\ Market",
"4414303", "North\ Cave",
"4418906", "Ayton",
"4417683", "Appleby",
"441668", "Bamburgh",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441544", "Kington",
"441559", "Llandysul",
"441779", "Peterhead",
"441424", "Hastings",
"441246", "Chesterfield",
"441725", "Rockbourne",
"4414237", "Harrogate",
"441809", "Tomdoun",
"441878", "Lochboisdale",
"441337", "Ladybank",
"441588", "Bishops\ Castle",
"4416973", "Wigton",
"441708", "Romford",
"441360", "Killearn",
"441872", "Truro",
"442838", "Portadown",
"441274", "Bradford",
"441582", "Luton",
"441756", "Skipton",
"441797", "Rye",
"441702", "Southend\-on\-Sea",
"441576", "Lockerbie",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"441407", "Holyhead",
"441492", "Colwyn\ Bay",
"4415076", "Louth",
"441344", "Bracknell",
"441359", "Pakenham",
"44114708", "Sheffield",
"441900", "Workington",
"441609", "Northallerton",
"442845", "Northern\ Ireland",
"441264", "Andover",
"441923", "Watford",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"441862", "Tain",
"4415074", "Alford\ \(Lincs\)",
"441566", "Launceston",
"441989", "Ross\-on\-Wye",
"441382", "Dundee",
"441560", "Moscow",
"441672", "Marlborough",
"442887", "Dungannon",
"4418904", "Coldstream",
"441376", "Braintree",
"44291", "Cardiff",
"441388", "Bishop\ Auckland",
"4414376", "Haverfordwest",
"441769", "South\ Molton",
"441481", "Guernsey",
"44141", "Glasgow",
"441678", "Bala",
"441233", "Ashford\ \(Kent\)",
"441591", "Llanwrtyd\ Wells",
"441952", "Telford",
"44116", "Leicester",
"441348", "Fishguard",
"441262", "Bridlington",
"4414309", "Market\ Weighton",
"441864", "Abington\ \(Crawford\)",
"441646", "Milford\ Haven",
"441268", "Basildon",
"441342", "East\ Grinstead",
"441911", "Tyneside\/Durham\/Sunderland",
"442847", "Northern\ Ireland",
"441993", "Witney",
"441535", "Keighley",
"441954", "Madingley",
"441949", "Whatton",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441833", "Barnard\ Castle",
"4419756", "Strathdon",
"442885", "Ballygawley",
"4414345", "Haltwhistle",
"441384", "Dudley",
"4416860", "Newtown\/Llanidloes",
"44114707", "Sheffield",
"441674", "Montrose",
"4420", "London",
"4414348", "Hexham",
"441604", "Northampton",
"441695", "Skelmersdale",
"441354", "Chatteris",
"441349", "Dingwall",
"441984", "Watchet\ \(Williton\)",
"4416869", "Newtown",
"4419642", "Hornsea",
"441733", "Peterborough",
"442820", "Ballycastle",
"4419757", "Strathdon",
"4418474", "Thurso",
"441269", "Ammanford",
"441948", "Whitchurch",
"442826", "Northern\ Ireland",
"4414300", "North\ Cave\/Market\ Weighton",
"441942", "Wigan",
"441465", "Girvan",
"441764", "Crieff",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"4414377", "Haverfordwest",
"441869", "Bicester",
"441358", "Ellon",
"441451", "Stow\-on\-the\-Wold",
"4414234", "Boroughbridge",
"441982", "Builth\ Wells",
"441608", "Chipping\ Norton",
"441436", "Helensburgh",
"442896", "Belfast",
"441631", "Oban",
"441306", "Dorking",
"441352", "Mold",
"441988", "Wigtown",
"441697", "Brampton",
"441656", "Bridgend",
"441467", "Inverurie",
"441650", "Cemmaes\ Road",
"441944", "West\ Heslerton",
"442890", "Belfast",
"441959", "Westerham",
"441300", "Cerne\ Abbas",
"441768", "Penrith",
"441389", "Dumbarton",
"441323", "Eastbourne",
"441970", "Aberystwyth",
"441625", "Macclesfield",
"441506", "Bathgate",
"441772", "Preston",
"441477", "Holmes\ Chapel",
"441295", "Banbury",
"44292", "Cardiff",
"441856", "Orkney",
"441937", "Wetherby",
"441786", "Stirling",
"4415077", "Louth",
"441204", "Bolton",
"441778", "Bourne",
"442871", "Londonderry",
"441558", "Llandeilo",
"4416863", "Llanidloes",
"441669", "Rothbury",
"441808", "Tomatin",
"441879", "Scarinish",
"441227", "Canterbury",
"441825", "Uckfield",
"441499", "Inveraray",
"4414236", "Harrogate",
"441709", "Rotherham",
"441443", "Pontypridd",
"441780", "Stamford",
"441913", "Durham",
"4418907", "Ayton",
"441146", "Sheffield",
"441208", "Bodmin",
"441740", "Sedgefield",
"4419641", "Hornsea\/Patrington",
"441202", "Bournemouth",
"441256", "Basingstoke",
"441297", "Axminster",
"441475", "Greenock",
"441483", "Guildford",
"441429", "Hartlepool",
"441554", "Llanelli",
"441549", "Lairg",
"441895", "Uxbridge",
"441935", "Yeovil",
"441593", "Lybster",
"4419648", "Hornsea",
"441250", "Blairgowrie",
"44283", "Northern\ Ireland",
"441225", "Bath",
"441746", "Bridgnorth",
"44114702", "Sheffield",
"4418476", "Tongue",
"441279", "Bishops\ Stortford",
"441827", "Tamworth",
"4414342", "Bellingham",
"441140", "Sheffield",};
my $timezones = {
               '' => [
                       'Europe/Guernsey',
                       'Europe/Isle_of_Man',
                       'Europe/Jersey',
                       'Europe/London'
                     ],
               '1' => [
                        'Europe/London'
                      ],
               '1481' => [
                           'Europe/Guernsey'
                         ],
               '1534' => [
                           'Europe/Jersey'
                         ],
               '1624' => [
                           'Europe/Isle_of_Man'
                         ],
               '2' => [
                        'Europe/London'
                      ],
               '3' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '5' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '70' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '71' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '72' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '73' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '74' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '75' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '760' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '762' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '763' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '7640' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7641' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7643' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7644' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7646' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '765' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '766' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '767' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '768' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '7693' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7699' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '77' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '78' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '79' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '8' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '9' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:([25-8]\d{5})$|0)//;
      $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;