# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::BG;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240607153918;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '1',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '2',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            43[1-6]|
            70[1-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '2',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [356]|
            4[124-7]|
            7[1-9]|
            8[1-6]|
            9[1-7]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{2,3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              70|
              8
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            43[1-7]|
            7
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [48]|
            9[08]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '9',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          2\\d{5,7}|
          (?:
            43[1-6]|
            70[1-9]
          )\\d{4,5}|
          (?:
            [36]\\d|
            4[124-7]|
            [57][1-9]|
            8[1-6]|
            9[1-7]
          )\\d{5,6}
        ',
                'geographic' => '
          2\\d{5,7}|
          (?:
            43[1-6]|
            70[1-9]
          )\\d{4,5}|
          (?:
            [36]\\d|
            4[124-7]|
            [57][1-9]|
            8[1-6]|
            9[1-7]
          )\\d{5,6}
        ',
                'mobile' => '
          (?:
            43[07-9]|
            99[69]\\d
          )\\d{5}|
          (?:
            8[7-9]|
            98
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(700\\d{5})|(90\\d{6})',
                'toll_free' => '
          (?:
            00800\\d\\d|
            800
          )\\d{5}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"3599110", "Virovsko",
"3593119", "Galabovo\,\ Plovdiv",
"35947193", "Mogila\,\ Yambol",
"3599133", "Komarevo\,\ Vratsa",
"359868", "Silistra",
"3594136", "Cherna\ gora\,\ St\.\ Zagora",
"3593721", "Stambolovo\,\ Hask\.",
"3596714", "Popovtsi",
"35959408", "Razhitsa",
"3596906", "Cherni\ Vit",
"3598138", "Brashlen",
"3599514", "Vladimirovo\,\ Mont\.",
"35937702", "Mustrak",
"35969245", "Devetaki",
"3599561", "Sumer",
"3593781", "Simeonovgrad",
"3593076", "Tsatsarovtsi",
"35931390", "Moskovets",
"3594718", "Roza",
"35974388", "Gorno\ Spanchevo",
"3596576", "Radomirtsi",
"35994", "Vidin",
"35941174", "Podslon\,\ St\.\ Zagora",
"3593622", "Stremtsi",
"3599318", "Bukovets\,\ Vidin",
"35941111", "Starozagorski\ bani",
"3595523", "Krumovo\ gradishte",
"3597723", "Dolni\ Rakovets",
"3594773", "Okop",
"35963571", "Brestovets",
"3598661", "Tutrakan",
"359537", "Novi\ pazar\,\ Shumen",
"3596959", "Debnevo",
"3597717", "Divotino",
"3595517", "Ravnets\,\ Burgas",
"359678", "Teteven",
"3597159", "Aprilovo\,\ Sofia",
"3595742", "Rakovski\,\ Dobr\.",
"3598620", "Silistra",
"3594552", "Stara\ reka\,\ Sliven",
"3594149", "Trankovo\,\ St\.\ Zagora",
"3597734", "Glavanovtsi\,\ Pernik",
"3598637", "Malak\ Preslavets",
"3595534", "Karageorgievo",
"35961305", "Lesicheri",
"35971228", "Maritsa",
"3596352", "Dolni\ Lukovit",
"3595130", "General\ Kiselovo",
"359817", "Byala\,\ Ruse",
"3595127", "Manastir\,\ Varna",
"3599520", "Gorno\ Ozirovo",
"3593529", "Mokrishte",
"3595910", "Cherni\ vrah\,\ Burgas",
"3599184", "Ohoden",
"3593045", "Dospat",
"3596569", "Lenkovo",
"3596029", "Nadarevo",
"35961704", "Pravda\,\ V\.\ Tarnovo",
"35991189", "Tri\ kladentsi",
"3593748", "Lyaskovets\,\ Hask\.",
"3597106", "Yamna",
"35951536", "Nikolaevka",
"3596545", "Lyubenovo\,\ Pleven",
"35981463", "Mogilino",
"3593589", "Tserovo\,\ Pazardzhik",
"3599124", "Tipchenitsa",
"3599745", "Zlatia\,\ Mont\.",
"3595338", "Troitsa",
"3593757", "Georgi\ Dobrevo",
"3594369", "Aleksandrovo\,\ St\.\ Zagora",
"3596720", "Kereka",
"3596737", "Krushevo\,\ Gabr\.",
"3594345", "Raduntsi",
"3598477", "Samuil",
"3598115", "Chervena\ voda",
"3596167", "Kesarevo",
"35931992", "Padarsko",
"3593113", "Branipole",
"3596150", "Zlataritsa",
"3593127", "Tsaratsovo",
"3595332", "Dragoevo",
"3594354", "Zimnitsa\,\ St\.\ Zagora",
"3599139", "Tarnava\,\ Vratsa",
"3599175", "Ostrov",
"3593130", "Karavelovo\,\ Plovdiv",
"3596034", "Slavyanovo\,\ Targ\.",
"3593054", "Podvis\,\ Smol\.",
"3593178", "Krasnovo",
"3593534", "Popintsi",
"3596554", "Krushovene",
"35967397", "Ryahovtsite",
"35941332", "Naydenovo",
"3595589", "Vinarsko",
"3595760", "Bozhurovo\,\ Dobr\.",
"3595946", "Tranak",
"3593196", "Drangovo\,\ Plovdiv",
"3595757", "Bezmer\,\ Dobr\.",
"3597164", "Rebrovo",
"3593641", "Krumovgrad",
"3594779", "Hanovo",
"3597729", "Dolna\ Dikanya",
"3595529", "Krushovo\,\ Burgas",
"35961106", "Novo\ selo\,\ V\.\ Tarnovo",
"3597548", "Godeshevo",
"3595748", "Durankulak",
"35943616", "Turia",
"3599335", "Tsar\ Petrovo",
"3593933", "Stransko",
"35969032", "Balgarski\ izvor",
"3596953", "Borima",
"3597445", "Banya\,\ Blag\.",
"35960370", "Golyamo\ gradishte",
"3596911", "Lisets\,\ Lovech",
"3593924", "Krepost",
"3595781", "Svoboda\,\ Dobr\.",
"3599146", "Sokolare",
"3593677", "Drangovo\,\ Kardzh\.",
"3594143", "Sarnevo\,\ St\.\ Zagora",
"3596964", "Velchevo\,\ Lovech",
"359725", "Elin\ Pelin",
"3599312", "Bregovo\,\ Vidin",
"3593628", "Miladinovo",
"35984740", "Bisertsi",
"3595119", "Ignatievo",
"3597521", "Koprivlen",
"35963202", "Dragomirovo\,\ V\.\ Tarnovo",
"3594712", "Kabile",
"35984737", "Raynino",
"3595315", "Tsarev\ brod",
"35931402", "Skobelevo\,\ Plovdiv",
"3593523", "Sinitevo",
"359391", "Dimitrovgrad",
"3598132", "Yudelnik",
"3593517", "Lesichovo",
"359337", "Hisarya",
"35984721", "Lipnik",
"3596023", "Podgoritsa",
"3596563", "Brest\,\ Pleven",
"359702", "Bobov\ dol",
"35981266", "Starmen\,\ Ruse",
"3593583", "Gabrovitsa",
"35971306", "Rashkovo",
"3594363", "Gabarevo",
"35974403", "Dolno\ Draglishte",
"35931709", "Mihiltsi",
"3593151", "Rakovski\,\ Plovdiv",
"3596002", "Saedinenie\,\ Targ\.",
"3599517", "Kobilyak",
"3595913", "Krushevets",
"3594526", "Mlekarevo",
"3595776", "Cherna\,\ Dobr\.",
"3599523", "Barzia",
"3595318", "Srednya",
"3596723", "Tsareva\ livada",
"35954", "Shumen",
"3596326", "Morava",
"3596717", "Lesicharka",
"3594586", "Neykovo\,\ Sliven",
"359558", "Aytos",
"3593763", "Balgarin",
"35930414", "Devin",
"3593625", "Shiroko\ pole",
"3593146", "Kurtovo\ Konare",
"3598623", "Golesh\,\ Silistra",
"3597714", "Meshtitsa",
"3594597", "Borov\ dol",
"35961105", "Prisovo",
"3595133", "General\ Kolevo\,\ Varna",
"3597448", "Bachevo",
"3593691", "Chernoochene",
"35941144", "Kaloyanovets",
"3594738", "Hlyabovo",
"35993212", "Karbintsi",
"3595124", "Komarevo\,\ Varna",
"3595745", "Vranino",
"3597545", "Kochan",
"35967307", "Mlechevo",
"3599338", "Shishentsi",
"3595769", "Hitovo",
"3595580", "Troyanovo\,\ Burgas",
"35995277", "Cherkaski",
"3595537", "Sadievo\,\ Burgas",
"3598634", "Nova\ Cherna",
"3594770", "General\ Inzovo",
"35974409", "Mesta",
"3595520", "Cherkovo",
"3597720", "Priboy",
"35931703", "Zhitnitsa\,\ Plovdiv",
"35930205", "Starnitsa",
"3596159", "Zlataritsa",
"3599127", "Lyutidol",
"3596542", "Vabel\,\ Pleven",
"3593175", "Dalgo\ pole\,\ Plovdiv",
"3599130", "Tlachene",
"3593042", "Borino",
"3594116", "Rakitnitsa\,\ St\.\ Zagora",
"3596734", "Petko\ Slaveykov",
"3599113", "Mramoren",
"35974346", "Tsaparevo",
"35958", "Dobrich",
"3593754", "Lozen\,\ Hask\.",
"3598118", "Nikolovo\,\ Ruse",
"3594342", "Ovoshtnik",
"3599187", "Lyutadzhik",
"3599742", "Yakimovo",
"359746", "Sandanski",
"3593057", "Plovdivtsi",
"3599172", "Selanovtsi",
"35935419", "Sveta\ Petka",
"3596560", "Kreta\,\ Pleven",
"3596020", "Lilyak",
"3599748", "Dalgodeltsi",
"3595335", "Milanovo\,\ Shumen",
"3599529", "Borovtsi",
"3596557", "Bregare",
"3593520", "Miryantsi",
"3595919", "Marinka",
"3594348", "Dunavtsi\,\ St\.\ Zagora",
"3593537", "Panagyurski\ kolonii",
"3596164", "Bryagovitsa",
"3594357", "Gorno\ Sahrane",
"3593769", "Oreshets\,\ Hask\.",
"3593745", "Malak\ izvor\,\ Hask\.",
"3593124", "Kalekovets",
"3596111", "Kapinovo\,\ V\.\ Tarnovo",
"3596548", "Debovo",
"3594140", "Polski\ Gradets",
"3598629", "Smilets\,\ Silistra",
"3596931", "Ugarchin",
"3598166", "Svalenik",
"3597167", "Tserovo\,\ Sofia",
"35974322", "Petrovo\,\ Blag\.",
"3595139", "Oborishte\,\ Varna",
"35961607", "Balkantsi\,\ V\.\ Tarnovo",
"3599332", "Rakovitsa",
"3597034", "Dzherman",
"35961395", "Paskalevets",
"3595754", "Zarnevo",
"35938", "Haskovo",
"3594101", "Opan",
"3594732", "Ustrem",
"35984764", "Seydol",
"35934", "Pazardzhik",
"3595366", "Branichevo",
"359608", "Popovo\,\ Targ\.",
"3595763", "Plachidol",
"35941489", "Bozduganovo",
"3597442", "Yakoruda",
"35977229", "Galabnik",
"35991183", "Furen",
"3593927", "Chernogorovo\,\ Hask\.",
"3596950", "Gumoshtnik",
"35937420", "Podkrepa",
"35961306", "Patresh",
"3594715", "Kalchevo",
"35947201", "Izgrev\,\ Yambol",
"3593674", "Samodiva",
"3593776", "Raykova\ mogila",
"3596967", "Kaleytsa",
"35941338", "Tselina",
"359306", "Rudozem",
"3599315", "Gradets\,\ Vidin",
"3597911", "Granitsa",
"3593133", "Kalofer",
"3599721", "Dolno\ Tserovene",
"3598135", "Babovo",
"3596153", "Zlataritsa",
"3599119", "Tishevitsa",
"3593110", "Popovitsa",
"3595312", "Dibich",
"3596581", "Byala\ voda\,\ Pleven",
"3594321", "Maglizh",
"3595146", "Goren\ chiflik",
"3593561", "Septemvri",
"35931998", "Choba",
"3596061", "Golyamo\ Sokolovo",
"3593514", "Chernogorovo\,\ Pazardzhik",
"3596521", "Sadovets",
"3596564", "Zagrazhden\,\ Pleven",
"3596024", "Ruets",
"3596148", "Pavel",
"35941355", "Yavorovo",
"3596511", "Pobeda\,\ Pleven",
"3593524", "Apriltsi\,\ Pazardzhik",
"3599189", "Pavolche",
"35937704", "Mladinovo",
"3594364", "Osetenovo",
"3597921", "Zhilentsi",
"3593584", "Vetren\,\ Pazardzhik",
"3593137", "Klisura\,\ Plovdiv",
"35947203", "Trankovo\,\ Yambol",
"3599129", "Sinyo\ bardo",
"3593120", "Hrabrino",
"3596157", "Slivovitsa",
"3596992", "Zlatna\ Panega",
"3594725", "Lesovo",
"359601", "Targovishte",
"3594144", "Kovachevo\,\ St\.\ Zagora",
"3596963", "Balkanets",
"35952", "Varna",
"3595539", "Chernograd",
"3595575", "Prilep\,\ Burgas",
"35960377", "Aprilovo\,\ Targ\.",
"3593923", "Radievo",
"3599325", "Belo\ pole\,\ Vidin",
"3597154", "Stolnik",
"35984393", "Vazovo",
"3595767", "Zhitnitsa\,\ Dobr\.",
"3593328", "Dolnoslav",
"3597030", "Resilovo",
"35984730", "Golyam\ Porovets",
"3595750", "Kableshkovo\,\ Dobr\.",
"3598672", "Bradvari",
"35941172", "Gorno\ Botevo",
"3593638", "Zvezdel",
"35967390", "Shumata",
"3595102", "Padina\,\ Varna",
"3595731", "General\ Toshevo\,\ Dobr\.",
"3597531", "Dolno\ Dryanovo",
"359726", "Svoge",
"3594599", "Chervenakovo",
"3596954", "Vrabevo",
"3593341", "Konush\,\ Plovdiv",
"3593934", "Skobelevo\,\ Hask\.",
"35963579", "Ralevo",
"359318", "Saedinenie\,\ Plovdiv",
"35941119", "Elhovo\,\ St\.\ Zagora",
"3597192", "Gintsi",
"3597163", "Iskrets",
"359454", "Tvarditsa\,\ Sliven",
"3593108", "Boykovo",
"3594353", "Srednogorovo",
"3599356", "Kalenik\,\ Vidin",
"35969616", "Staro\ selo\,\ Lovech",
"3593114", "Brestnik",
"3596121", "Nikyup",
"35984463", "Prelez",
"3594756", "Polyana\,\ Yambol",
"3596553", "Oryahovitsa\,\ Pleven",
"35930418", "Buynovo\,\ Smol\.",
"3593533", "Bata",
"3593053", "Hvoyna",
"3598122", "Tsenovo\,\ Ruse",
"3593510", "Ovchepoltsi",
"35935251", "Bratanitsa",
"3596033", "Medovina",
"35984729", "Ezerche",
"3599551", "Georgi\ Damyanovo",
"3598128", "Polsko\ Kosovo",
"3595341", "Hitrino",
"3599183", "Lilyache",
"359518", "Provadia",
"35931701", "Krastevich",
"3599117", "Krivodol",
"3599123", "Roman",
"3597176", "Hrabarsko",
"3594126", "Hrishteni",
"3593102", "Karadzhovo",
"3595533", "Pirne",
"3597733", "Filipovtsi",
"3596969", "Beklemeto",
"359953", "Berkovitsa",
"35984768", "Sinya\ voda",
"3593929", "Golyamo\ Asenovo",
"3595161", "Vetrino",
"35941334", "Saedinenie\,\ St\.\ Zagora",
"3595108", "Sadovo\,\ Varna",
"3596046", "Vrani\ kon",
"3593632", "Dzhebel",
"3595114", "Ezerovo\,\ Varna",
"3598678", "Sratsimir\,\ Silistra",
"35953436", "Chernoglavtsi",
"35931397", "Hristo\ Danovo",
"35931605", "Bukovo\,\ Plovdiv",
"3595120", "Bozveliysko",
"3593322", "Zlatovrah",
"3595137", "Kaloyan",
"35963204", "Delyanovtsi",
"3594155", "Glavan\,\ St\.\ Zagora",
"35963566", "Brashlyanitsa",
"3594562", "Kriva\ krusha",
"3594593", "Shivachevo",
"3597169", "Tompsan",
"3598630", "Silistra",
"35960383", "Berkovski",
"3594774", "Krumovo\,\ Yambol",
"3596998", "Golyam\ izvor\,\ Lovech",
"3595524", "Ekzarh\ Antimovo",
"3598627", "Babuk",
"3597724", "Izvor\,\ Pernik",
"3597145", "Mirovo\,\ Sofia",
"3596713", "Vranilovtsi",
"35957305", "Rositsa\,\ Dobr\.",
"3598141", "Dve\ mogili",
"3594359", "Asen\,\ St\.\ Zagora",
"3593767", "Branitsa",
"3599134", "Tarnak",
"3595328", "Nikola\ Kozlevo",
"35984266", "Prostorno",
"3596727", "Ganchovets",
"35932", "Plovdiv",
"3595917", "Izvor\,\ Burgas",
"3599527", "Varshets",
"3596142", "Obedinenie",
"3596559", "Gostilya",
"3596039", "Opaka",
"3599513", "Boychinovtsi",
"3598696", "Suhodol\,\ Silistra",
"3594516", "Kermen",
"3593059", "Kutela",
"3593759", "Borislavtsi",
"359701", "Dupnitsa",
"3594367", "Tazha",
"3595391", "Varbitsa\,\ Shumen",
"3596154", "Buynovtsi",
"35930412", "Devin",
"3593587", "Sestrimo",
"3593134", "Sopot\,\ Plovdiv",
"3594350", "Gorno\ Izvorovo",
"3596030", "Svetlen\,\ Targ\.",
"3593513", "Malo\ Konare",
"35955505", "Drachevo",
"3596567", "Somovit",
"3595325", "Voyvoda",
"3596027", "Dralfa",
"3593050", "Bukova\ polyana",
"35992", "Vratsa",
"3593530", "Poibrene",
"35936700", "Shoptsi",
"3593527", "Aleko\ Konstantinovo",
"3596550", "Stavertsi",
"3594158", "Iskritsa",
"35984723", "Dyankovo",
"3596981", "Petrevene",
"3595129", "Blaskovo",
"3595764", "Vladimirovo\,\ Dobr\.",
"3599322", "Oreshets\,\ Vidin",
"3595572", "Beronovo",
"3594722", "Granitovo\,\ Yambol",
"3593706", "Tankovo\,\ Hask\.",
"3595711", "Ovcharovo\,\ Dobr\.",
"3597148", "Muhovo",
"3598639", "Kolarovo\,\ Silistra",
"3598675", "Aydemir",
"35974401", "Gorno\ Draglishte",
"3596921", "Ablanitsa\,\ Lovech",
"3593673", "Tihomir",
"3594147", "Lyubenovo\,\ St\.\ Zagora",
"3597157", "Sarantsi",
"3598156", "Cherven\,\ Ruse",
"35971224", "Shipochane",
"35941178", "Oryahovitsa\,\ St\.\ Zagora",
"3597719", "Yardzhilovtsi",
"35953435", "Izgrev\,\ Shumen",
"3595519", "Zidarovo",
"3593937", "Yabalkovo\,\ Hask\.",
"3593920", "Zlatopole",
"3596957", "Golyama\ Zhelyazna",
"3595105", "Priseltsi\,\ Varna",
"35931606", "Voden\,\ Plovdiv",
"3596960", "Belish",
"35963565", "Mechka\,\ Pleven",
"3596948", "Karpachevo",
"3595753", "Orlyak",
"3597033", "Kraynitsi",
"35953220", "Pamukchii\,\ Shumen",
"3597181", "Pirdop",
"3599546", "Slavotin",
"35957306", "Izvorovo\,\ Dobr\.",
"3598185", "Senovo",
"3596531", "Izgrev\,\ Pleven",
"3593123", "Kaloyanovo\,\ Plovdiv",
"3598646", "Vokil",
"3598125", "Koprivets",
"35960389", "Kardam\,\ Targ\.",
"35959404", "Yasenovo\,\ Burgas",
"3596163", "Kamen\,\ V\.\ Tarnovo",
"35931791", "Begovo",
"3594331", "Gurkovo\,\ St\.\ Zagora",
"3593117", "Katunitsa",
"3593753", "Oryahovo\,\ Hask\.",
"3596733", "Kormyansko",
"3599161", "Mizia",
"35941356", "Rupkite",
"3596710", "Donino",
"3593105", "Manolsko\ Konare",
"3593519", "Velichkovo\,\ Pazardzhik",
"3597046", "Boboshevo",
"3595123", "Ravna\,\ Varna",
"35977221", "Kondofrey",
"3595117", "Botevo\,\ Varna",
"3596942", "Aleksandrovo\,\ Lovech",
"3593679", "Kirkovo",
"35974324", "Struma",
"3594741", "Bolyarovo",
"3598633", "Staro\ selo\,\ Silistra",
"3599341", "Dimovo\,\ Vidin",
"35971471", "Ochusha",
"3596176", "Polikraishte",
"35981461", "Karan\ Varbovka",
"3595551", "Sredets\,\ Burgas",
"3597751", "Breznik",
"35961403", "Orlovets",
"3593325", "Cherven\,\ Plovdiv",
"35930457", "Kasak",
"3595513", "Gabar",
"3597713", "Rudartsi",
"3598624", "Kalipetrovo",
"3597727", "Kovachevtsi\,\ Pernik",
"35984469", "Bozhurovo\,\ Razgrad",
"3595527", "Sokolovo\,\ Burgas",
"3595530", "Peshtersko",
"3594777", "Tenevo",
"35971798", "Vasilovtsi\,Sof\.",
"3597142", "Kostenets",
"3595759", "Kochmar",
"3594728", "Melnitsa",
"3595578", "Terziysko\,\ Burgas",
"3595134", "Cherventsi",
"3599328", "Dolni\ Lom",
"35941274", "Samuilovo\,\ St\.\ Zagora",
"3594152", "Obruchishte",
"3597039", "Samoranovo",
"3599524", "Yagodovo\,\ Mont\.",
"359745", "Petrich\,\ Blag\.",
"35969615", "Balabansko",
"3599180", "Golyamo\ Peshtene",
"3595914", "Atia",
"359861", "Silistra",
"3593666", "Popsko",
"3599137", "Popitsa",
"3593764", "Polyanovo\,\ Hask\.",
"3596072", "Dobrotitsa\,\ Targ\.",
"3593129", "Skutare",
"3596724", "Yantra\,\ Gabr\.",
"3593711", "Dolno\ Botevo",
"3596145", "Strahilovo",
"359470", "Topolovgrad",
"35963573", "Disevitsa",
"35941113", "Pryaporets\,\ St\.\ Zagora",
"3596169", "Blagoevo\,\ V\.\ Tarnovo",
"3598648", "Sekulovo",
"3595167", "Venchan",
"35969031", "Galata",
"35941331", "Granit",
"3597423", "Kolarovo\,\ Blag\.",
"3599344", "Vrav",
"3597042", "Korkina",
"3595554", "Momina\ tsarkva",
"3597754", "Kosharevo",
"3594125", "Mihaylovo\,\ St\.\ Zagora",
"3594744", "Golyamo\ Krushevo",
"3598660", "Tutrakan",
"3597175", "Gaber",
"3597139", "Dzhurovo",
"3599164", "Krushovitsa\,\ Vratsa",
"35930528", "Manastir\,\ Plovdiv",
"3596946", "Chavdartsi",
"3599729", "Rasovo",
"3593720", "Madzharovo",
"35931258", "Glavatar",
"3599111", "Chelopek",
"3599548", "Krapchene",
"35991888", "Veslets\,\ Vratsa",
"3596589", "Kulina\ voda",
"3594329", "Dolno\ Sahrane",
"3593545", "Draginovo",
"35931704", "Ivan\ Vazovo",
"3599560", "Bezdenitsa",
"3593569", "Karabunar",
"3593029", "Petkovo\,\ Smol\.",
"3595347", "Zhivkovo\,\ Shumen",
"3596529", "Koilovtsi",
"3599557", "Gorno\ Tserovene",
"3596069", "Vasil\ Levski\,\ Targ\.",
"35951106", "Osenovo\,\ Varna",
"3599521", "Zamfirovo",
"3598158", "Mechka\,\ Ruse",
"35931401", "Kadievo",
"3594156", "Aprilovo\,\ St\.\ Zagora",
"3597146", "Chernyovo",
"3598147", "Baniska",
"35975215", "Teshovo",
"3593708", "Orlovo\,\ Hask\.",
"35984722", "Yasenovets",
"3596119", "Dichin",
"35953437", "Gabritsa\,\ Shumen",
"3596939", "Dragana",
"3598621", "Silistra",
"35931396", "Domlyan",
"3597434", "Strumyani",
"35963567", "Gradina\,\ Pleven",
"3595131", "Valchi\ dol",
"35930413", "Devin",
"3593693", "Lyaskovo\,\ Kardzh\.",
"3593662", "Zhelezino",
"359676", "Dryanovo\,\ Gabr\.",
"3594515", "Mokren",
"3598695", "Nozharevo",
"3594109", "Trakia",
"3596076", "Taymishte",
"35993342", "Kireevo",
"3594797", "Galabintsi",
"35941112", "Starozagorski\ bani",
"35963572", "Yasen\,\ Pleven",
"3595714", "Karapelit",
"35960376", "Lyublen",
"3596984", "Bezhanovo\,\ Lovech",
"359723", "Botevgrad",
"3595761", "Batovo",
"3597110", "Opitsvet",
"3597133", "Pravets",
"35930200", "Zagrazhden\,\ Smol\.",
"35930517", "Zabardo",
"3599723", "Traykovo",
"35991184", "Rakevo",
"3595394", "Byala\ reka\,\ Shumen",
"359457", "Nova\ Zagora",
"3595576", "Lozarevo",
"3596151", "Elena\,\ V\.\ Tarnovo",
"3597913", "Rashka\ Grashtitsa",
"3593702", "Tsareva\ polyana",
"3594726", "Malomirovo",
"3594323", "Tulovo",
"35984763", "Beli\ Lom",
"3597927", "Treklyano",
"3596583", "Belene",
"35937701", "Sladun",
"3599326", "Gorni\ Lom",
"3597930", "Eremia",
"35971506", "Gabra",
"3598152", "Krasen\,\ Ruse",
"3593563", "Varvara\,\ Pazardzhik",
"3593023", "Momchilovtsi",
"3599783", "Brusartsi",
"3595959", "Zvezdets",
"3596517", "Podem",
"3596063", "Bayachevo",
"3596523", "Krushovitsa\,\ Pleven",
"35961402", "Stefan\ Stambolovo",
"35978", "Kyustendil",
"3593554", "Kozarsko",
"3598194", "Sandrovo",
"3596534", "Malchika",
"35967774", "Belitsa\,\ Gabr\.",
"3596178", "Strelets\,\ V\.\ Tarnovo",
"3593034", "Levochevo",
"3595352", "Yankovo",
"35931324", "Mrachenik",
"3594334", "Elhovo\,\ St\.\ Zagora\,\ mun\.\ Nikolaevo",
"3599542", "Smolyanovtsi",
"35960388", "Goritsa\,\ Targ\.",
"3596113", "Balvan",
"35935254", "Dobrovnitsa",
"3593167", "Bryagovo\,\ Plovdiv",
"3599355", "Kosovo\,\ Vidin",
"35941179", "Han\ Asparuhovo",
"3596933", "Golets",
"3597124", "Belchinski\ bani",
"3597745", "Egalnitsa",
"3594755", "Tamarino",
"3596910", "Malinovo",
"3597048", "Blazhievo",
"3593347", "Lenovo",
"3597520", "Kornitsa",
"3595737", "Lyulyakovo\,\ Dobr\.",
"3597184", "Koprivshtitsa",
"3594103", "Byal\ izvor\,\ St\.\ Zagora",
"3597057", "Malo\ selo",
"3598642", "Dulovo",
"3593699", "Gabrovo\,\ Kardzh\.",
"3595557", "Bistrets\,\ Burgas",
"35961703", "Varbitsa\,\ V\.\ Tarnovo",
"35941484", "Zemlen",
"35960375", "Garchinovo",
"3596919", "Slatina\,\ Lovech",
"3599347", "Bela\ Rada",
"35984769", "Gorotsvet",
"3594747", "Dennitsa\,\ Yambol",
"3597172", "Dragoman",
"35974321", "Harsovo\,\ Blag\.",
"3593106", "Stroevo",
"3594122", "Elenino",
"35984462", "Ostrovo",
"35984745", "Vladimirovtsi",
"3597529", "Breznitsa",
"35981464", "Ostritsa\,\ Ruse",
"3595164", "Neofit\ Rilski",
"3597045", "Golem\ Varbovnik",
"35984728", "Rakovski\,\ Razgrad",
"35941357", "Zetyovo\,\ St\.\ Zagora",
"3599554", "Chiprovtsi",
"35971505", "Churek",
"3595344", "Velino",
"3599167", "Lipnitsa\,\ Vratsa",
"3593636", "Raven",
"3596042", "Iliyno",
"359748", "Simitli",
"3596175", "Parvomaytsi",
"3593542", "Rakitovo",
"3593159", "Belozem",
"35941173", "Bratya\ Kunchevi",
"3593326", "Patriarh\ Evtimovo",
"3593717", "Konush\,\ Hask\.",
"3597939", "Tsarvaritsa",
"3598144", "Batishnitsa",
"3599131", "Dobrolevo",
"35984392", "Belintsi",
"3595967", "Bata",
"3593783", "Svirkovo",
"3594566", "Pitovo",
"359556", "Obzor",
"35947202", "Zhrebino",
"35930456", "Chavdar\,\ Smol\.",
"359915", "Byala\ Slatina",
"3595153", "Suvorovo",
"3594771", "Malomir\,\ Yambol",
"3598663", "Sitovo\,\ Silistra",
"35937606", "Shishmanovo",
"3598692", "Stefan\ Karadzha\,\ Silistra",
"3595521", "Venets\,\ Burgas",
"3594512", "Blatets\,\ Sliven",
"3593665", "Svirachi",
"3597437", "Melnik",
"3597119", "Dramsha",
"35960450", "Dolna\ Hubavka",
"3596146", "Polski\ Senovets",
"35984776", "Harsovo\,\ Razgrad",
"3596913", "Slavyani",
"3594518", "Topolchane",
"3596930", "Slavshtitsa",
"3598698", "Shumentsi",
"3596927", "Umarevtsi",
"3595783", "Kotlentsi",
"3595717", "Vedrina",
"3595326", "Varbyane",
"3594794", "Ovchi\ kladenets",
"35974404", "Babyak",
"3594100", "Stoletovo\,\ St\.\ Zagora",
"359308", "Madan\,\ Smol\.",
"3595723", "Gurkovo\,\ Dobr\.",
"3597523", "Garmen",
"3596987", "Karlukovo",
"35971221", "Yarlovo",
"35984717", "Pobit\ kamak\,\ Razgrad",
"35964", "Pleven",
"3596514", "Dolni\ Dabnik",
"3593521", "Zvanichevo",
"35960382", "Kovachevets",
"3596561", "Gulyantsi",
"3596021", "Buhovtsi",
"3593705", "Vaglarovo",
"3593581", "Belovo",
"35947356", "Mramor\,\ Yambol",
"3595397", "Metodievo\,\ Shumen",
"35930472", "Mihalkovo",
"3598676", "Vetren\,\ Silistra",
"35991401", "Vranyak",
"3594361", "Pavel\ banya",
"3593153", "Stryama",
"3597924", "Shishkovtsi",
"3596133", "Mihaltsi",
"3596124", "Ledenik",
"3597933", "Gramazhdano",
"3593111", "Parvenets\,\ Plovdiv",
"35957307", "Zhiten\,\ Dobr\.",
"3595106", "Avren\,\ Varna",
"3594337", "Yasenovo\,\ St\.\ Zagora",
"3593548", "Pashovo",
"3596580", "Tatari",
"3593164", "Dalbok\ izvor",
"3597910", "Bersin",
"3596048", "Izvorovo\,\ Targ\.",
"3593729", "Krivo\ pole",
"3599720", "Kovachitsa",
"3596537", "Asenovtsi",
"3593557", "Byaga",
"35930419", "Yagodina",
"3596520", "Nikolaevo\,\ Pleven",
"3596060", "Ovcharovo\,\ Targ\.",
"35969240", "Hlevene",
"3599545", "Gabrovnitsa",
"3593037", "Sivino",
"3599569", "Lipen",
"3593020", "Davidkovo",
"3597187", "Bunovo\,\ Sofia",
"3595734", "Preselentsi",
"35931395", "Iganovo",
"35968", "Lovech",
"3594752", "Parvenets\,\ Yambol",
"3597742", "Kalishte",
"3597178", "Prolesha",
"359721", "Kostinbrod",
"3599352", "Druzhba",
"3597054", "Rila",
"3598645", "Mezhden",
"3597127", "Shiroki\ dol",
"35941149", "Lovets\,\ St\.\ Zagora",
"3598669", "Garvan\,\ Silistra",
"3593643", "Golyama\ Chinka",
"35963578", "Opanets\,\ Pleven",
"3593344", "Novakovo\,\ Plovdiv",
"35941118", "Ostra\ mogila\,\ St\.\ Zagora",
"3593931", "Kasnakovo",
"35967396", "Berievo",
"3597439", "Ploski",
"3597117", "Gradets\,\ Sofia",
"359618", "Gorna\ Oryahovitsa",
"3598116", "Ivanovo\,\ Ruse",
"3599176", "Leskovets\,\ Vratsa",
"359728", "Zlatitsa",
"35965617", "Iskar\,\ Pleven",
"3597123", "Kovachevtsi\,\ Sofia",
"3596934", "Katunets",
"3593647", "Chernichevo\,\ Kardzh\.",
"3595751", "Tervel\,\ Dobr\.",
"35959403", "Rechitsa",
"3594104", "Kravino",
"35961107", "Momin\ sbor",
"3597183", "Dushantsi",
"3593658", "Padina\,\ Kardzh\.",
"359722", "Samokov",
"3597031", "Gorna\ Koznitsa",
"3594118", "Pamukchii\,\ St\.\ Zagora",
"35935418", "Krastava",
"35931702", "Dolna\ mahala\,\ Plovdiv",
"3596510", "Totleben",
"3596533", "Stezherovo",
"3595945", "Dobromir",
"3593195", "Rozovets",
"3595969", "Galabets\,\ Burgas",
"3593553", "Batak\,\ Pazardzhik",
"3594736", "Svetlina",
"3593121", "Rogosh",
"3596114", "Kilifarevo",
"3597937", "Razhdavitsa",
"3594333", "Dabovo\,\ St\.\ Zagora",
"3593719", "Knizhovnik",
"3596161", "Strazhitsa\,\ V\.\ Tarnovo",
"3599336", "Staropatitsa",
"3597920", "Skrinyano",
"3597446", "Eleshnitsa\,\ Blag\.",
"3593157", "Bolyarino",
"3596137", "Butovo",
"3596584", "Belene",
"3594324", "Shipka",
"3597914", "Vaksevo",
"3599169", "Rogozen",
"3599724", "Stanevo",
"3595393", "Ivanovo\,\ Shumen",
"3599145", "Brenitsa\,\ Vratsa",
"3595362", "Kliment\,\ Shumen",
"3593772", "Momkovo",
"3593148", "Yoakim\ Gruevo",
"3596064", "Golyamo\ Novo",
"3593511", "Ognyanovo\,\ Pazardzhik",
"3596524", "Petarnitsa",
"3599784", "Kiselevo",
"3593024", "Taran",
"3593564", "Semchinovo",
"3597527", "Gorno\ Dryanovo",
"3595316", "Salmanovo",
"3596983", "Dermantsi",
"359431", "Kazanlak",
"3595727", "Senokos\,\ Dobr\.",
"35967305", "Stokite",
"3595713", "Stefanovo\,\ Dobr\.",
"359971", "Lom",
"3596328", "Oresh",
"3594588", "Filaretovo",
"3593671", "Podkova",
"3594749", "Ruzhitsa\,\ Yambol",
"3596923", "Goran",
"3597134", "Vrachesh",
"3593340", "Novi\ izvor",
"3599349", "Slanotran",
"35984736", "Podayva",
"3596917", "Balgarene\,\ Lovech",
"35941339", "Dimitrievo",
"3594528", "Lyubenova\ mahala",
"3595559", "Kubadin",
"359301", "Smolyan",
"3595142", "Dolni\ chiflik",
"3595148", "Rudnik\,\ Varna",
"3597433", "Kresna",
"3594522", "Korten",
"3595511", "Lukoil\ Neftochim",
"3597711", "Kladnitsa",
"3595772", "Telerig",
"3598667", "Belitsa\,\ Silistra",
"3596006", "Presian",
"3597129", "Raduil",
"35941171", "Dalboki",
"3594582", "Gradets\,\ Sliven",
"35963574", "Todorovo\,\ Pleven",
"3596322", "Alekovo\,\ V\.\ Tarnovo",
"35963560", "Radishevo",
"3596905", "Divchovoto",
"35961605", "Novo\ gradishte",
"35941114", "Lozen\,\ St\.\ Zagora",
"35961397", "Musina",
"3597189", "Chavdar\,\ Sofia",
"3593787", "Tyanevo\,\ Hask\.",
"3599567", "Dolna\ Verenitsa",
"3593075", "Dolen\,\ Smol\.",
"3593039", "Polkovnik\ Serafimovo",
"3593142", "Brestovitsa\,\ Plovdiv",
"3599550", "Mitrovtsi",
"3593559", "Kapitan\ Dimitrievo",
"35962", "Veliko\ Tarnovo",
"3595340", "Visoka\ polyana\,\ Shumen",
"3596539", "Gradishte\,\ Pleven",
"3596575", "Telish",
"3593778", "Studena\,\ Hask\.",
"3593727", "Nova\ Nadezhda",
"3595368", "Takach",
"35991182", "Osen\,\ Vratsa",
"3593713", "Dinevo",
"3594339", "Yulievo",
"3593751", "Lyubimets",
"3599163", "Harlets",
"35951537", "Chernevo",
"35935252", "Topoli\ dol",
"3598140", "Borovo\,\ Ruse",
"359865", "Silistra",
"35974323", "Lozenitsa",
"35974207", "General\ Todorov",
"3595121", "Tutrakantsi",
"3594112", "Badeshte",
"3593046", "Barutin",
"359373", "Harmanli",
"35946", "Yambol",
"3596989", "Toros",
"359675", "Sevlievo",
"3593652", "Byal\ izvor\,\ Kardzh\.",
"3597105", "Malki\ Iskar",
"3596546", "Lozitsa\,\ Pleven",
"3595719", "Donchevo",
"3596929", "Radyuvene",
"3598631", "Silistra",
"3599746", "Razgrad\,\ Mont\.",
"3594743", "Mamarchevo",
"3597753", "Noevtsi",
"3595553", "Orlintsi",
"3594346", "Golyamo\ Dryanovo",
"3597424", "Karnalovo",
"35974408", "Obidim",
"3599343", "Gomotartsi",
"35984464", "Veselets\,\ Razgrad",
"3594107", "Sredets\,\ St\.\ Zagora",
"3595336", "Imrenchevo",
"3597053", "Kocherinovo",
"3595710", "Pobeda\,\ Dobr\.",
"359973", "Kozloduy",
"3596980", "Belentsi",
"3595733", "Kardam\,\ Dobr\.",
"3597533", "Osikovo\,\ Blag\.",
"35981462", "Volovo",
"35941279", "Strelets\,\ St\.\ Zagora",
"35977222", "Gorna\ Dikanya",
"35961606", "Vladislav",
"3593343", "Kozanovo",
"3596920", "Lesidren",
"3593644", "Egrek",
"3593746", "Sirakovo\,\ Hask\.",
"359605", "Omurtag",
"35991668", "Manastirishte",
"3596937", "Sokolovo\,\ Lovech",
"3596117", "Debelets\,\ V\.\ Tarnovo",
"3598165", "Smirnenski\,\ Ruse",
"3593163", "Iskra\,\ Plovdiv",
"3595942", "Lyulyakovo\,\ Burgas",
"3593192", "Babek",
"3598149", "Katselovo",
"3594351", "Koprinka",
"35953234", "Zlatna\ niva",
"3596123", "Bukovets\,\ V\.\ Tarnovo",
"3597934", "Bunovo\,\ Kyust\.",
"359417", "Radnevo",
"3596551", "Trastenik\,\ Pleven",
"35971337", "Kalugerovo\,\ Sofia",
"35969247", "Gostinya",
"3593051", "Chepelare",
"3599142", "Lazarovo",
"3599559", "Gorna\ Kovachitsa",
"3596527", "Odarne",
"3596067", "Kralevo\,\ Targ\.",
"3595365", "Lyatno",
"3596530", "Tranchovitsa",
"35984394", "Duhovets",
"3595349", "Studenitsa",
"35931388", "Beguntsi",
"3593567", "Kovachevo\,\ Pazardzhik",
"3593027", "Slaveyno",
"3599787", "Smirnenski\,\ Mont\.",
"3593030", "Shiroka\ laka",
"3596513", "Pordim",
"3594716", "Veselinovo\,\ Yambol",
"359751", "Gotse\ Delchev",
"3594327", "Sheynovo",
"3596587", "Petokladentsi",
"3597923", "Vrattsa",
"3596134", "Byala\ cherkva\,\ V\.\ Tarnovo",
"3593154", "Chalakovi",
"3594330", "Nikolaevo\,\ St\.\ Zagora",
"3599316", "Novo\ selo\,\ Vidin",
"3599727", "Medkovets",
"3597917", "Tavalichevo",
"3596578", "Reselets",
"3593775", "Generalovo",
"35931708", "Pesnopoy\,\ Plovdiv",
"3597137", "Skravena",
"3595784", "Vrachantsi",
"3598136", "Stambolovo\,\ Ruse",
"35984761", "Gradina\,\ Razgrad",
"3596908", "Glogovo",
"3597120", "Dolna\ banya",
"35937703", "Dimitrovche",
"3593921", "Merichleri",
"3596914", "Slivek",
"3597524", "Ablanitsa\,\ Blag\.",
"35947204", "Pchela",
"3595724", "Dropla\,\ Dobr\.",
"35961307", "Stambolovo\,\ V\.\ Tarnovo",
"3595145", "Grozdyovo",
"3595169", "Momchilovo",
"35947192", "Zavoy",
"3594762", "Vodenichane",
"3594793", "Boyadzhik",
"3594138", "Gita",
"35984710", "Osenets",
"35967395", "Gorna\ Rositsa",
"35974402", "Godlevo",
"3594132", "Orizovo",
"3594768", "Zimnitsa\,\ Yambol",
"3595775", "Polkovnik\ Dyakovo",
"3595739", "Pchelarovo\,\ Dobr\.",
"3594525", "Omarchevo\,\ Sliven",
"3593349", "Boyantsi",
"3599340", "Septemvriytsi\,\ Vidin",
"359596", "Pomorie",
"35981886", "Chereshovo\,\ Ruse",
"3596902", "Ribaritsa\,\ Lovech",
"35931403", "Trivoditsi",
"3594585", "Zheravna",
"3596325", "Kozlovets",
"3598664", "Polyana\,\ Silistra",
"359339", "Stamboliyski\,\ Plovdiv",
"3598143", "Obretenik",
"3596572", "Suhache",
"3599160", "Glozhene\,\ Vratsa",
"3593626", "Perperek",
"3593145", "Krichim",
"3593724", "Susam",
"3596711", "Kozi\ rog",
"35963203", "Hadzhidimitrovo\,\ V\.\ Tarnovo",
"3596129", "Gabrovtsi",
"3593072", "Nedelino",
"35935258", "Tsar\ Asen\,\ Pazardzhik",
"35959409", "Cheresha",
"35960384", "Gagovo",
"3599564", "Stubel",
"3593784", "Konstantinovo\,\ Hask\.",
"35930411", "Devin",
"3599148", "Barkachevo",
"3593019", "Pisanitsa",
"3594556", "Sotirya",
"3595343", "Venets\,\ Shumen",
"3599553", "Prevala",
"35931792", "Chernichevo\,\ Plovdiv",
"3596519", "Beglezh",
"35991188", "Galatin",
"35941350", "Mirovo\,\ St\.\ Zagora",
"3597546", "Slashten",
"3599181", "Kravoder",
"3595746", "Belgun",
"35974347", "Razdol",
"3593710", "Uzundzhovo",
"3599719", "Asparuhovo\,\ Mont\.",
"3597929", "Sovolyano",
"3593198", "Chehlare",
"3595948", "Snyagovo\,\ Burgas",
"3599121", "Tsarevets\,\ Vratsa",
"35941333", "Sredno\ gradishte",
"3593176", "Starosel",
"3597102", "Lopyan",
"3597731", "Tran",
"3597427", "Parvomay\,\ Blag\.",
"35967306", "Gradishte\,\ Gabr\.",
"3594115", "Kirilovo\,\ St\.\ Zagora",
"3597430", "Damyanitsa",
"3595163", "Mlada\ gvardia",
"35995276", "Draganitsa",
"35984735", "Sveshtari",
"35931993", "Sarnegor",
"3594799", "Golyam\ manastir",
"35947354", "Kamenna\ reka",
"3596912", "Bahovitsa",
"35931705", "Gorna\ mahala",
"3595147", "Pchelnik\,\ Varna",
"359359", "Velingrad",
"3598668", "Popina",
"3595782", "Benkovski\,\ Dobr\.",
"3598640", "Pravda\,\ Silistra",
"3594129", "Madzherito",
"3597179", "Golemo\ Malovo",
"3597135", "Trudovets",
"3594764", "Malenovo",
"3599311", "Kutovo",
"3594711", "Bezmer\,\ Yambol",
"3597522", "Dabnitsa",
"35937424", "Kozlets",
"3593926", "Dobrich\,\ Hask\.",
"3599568", "Blagovo\,\ Mont\.",
"35974406", "Dobarsko",
"3594325", "Kanchevo",
"3596585", "Belene",
"35984711", "Mortagonovo",
"3593777", "Mezek",
"35971227", "Beli\ Iskar",
"3596966", "Shipkovo",
"3597915", "Nevestino\,\ Kyust\.",
"3596591", "Gornik",
"3599144", "Nivyanin",
"3599725", "Komoshtitsa",
"3598131", "Borisovo\,\ Ruse",
"35984760", "Trapishte",
"3596049", "Kamburovo",
"35984774", "Golyam\ izvor\,\ Razgrad",
"3596525", "Barkach",
"3595367", "Todor\ Ikonomovo",
"3596065", "Bistra\,\ Targ\.",
"3593728", "Slavyanovo\,\ Hask\.",
"3598442", "Zavet\,\ Razgrad",
"3593549", "Grashevo",
"3599540", "Belotintsi",
"3593025", "Banite",
"3596132", "Karaisen",
"3599785", "Vasilovtsi\,\ Mont\.",
"3597932", "Shipochano",
"3593194", "Zelenikovo\,\ Plovdiv",
"3595944", "Ruen\,\ Burgas",
"3593700", "Trakiets",
"35967302", "Kravenik",
"35974495", "Yurukovo",
"3596115", "Resen",
"3597166", "Vlado\ Trichkov",
"35935392", "Dyulevo\,\ Pazardzhik",
"3593741", "Mandra",
"3598167", "Tserovets",
"3598150", "Semerdzhievo",
"3594753", "Zornitsa\,\ Yambol",
"3596935", "Sopot\,\ Lovech",
"35959407", "Sini\ rid",
"3597743", "Divlya",
"3594356", "Hadzhidimitrovo\,\ St\.\ Zagora",
"35975214", "Gaytaninovo",
"3599353", "Koshava",
"35961103", "Rusalya",
"3594519", "Samuilovo\,\ Sliven",
"3593056", "Chepintsi\,\ Smol\.",
"3598699", "Tarnovtsi\,\ Silistra",
"3596036", "Sadina",
"3594105", "Byalo\ pole",
"3593642", "Potochnitsa",
"3596556", "Gorna\ Mitropolia",
"35976", "Pernik",
"3593536", "Banya\,\ Pazardzhik",
"3597118", "Dragovishtitsa\,\ Sofia",
"3599186", "Zgorigrad",
"3597541", "Satovcha",
"359727", "Slivnitsa\,\ Sofia",
"3595590", "Zhitosvyat",
"3593648", "Golyamo\ Kamenyane",
"3597104", "Laga",
"3594551", "Byala\,\ Sliven",
"3599126", "Kameno\ pole",
"35991185", "Pudria",
"3594123", "Bogomilovo",
"3593657", "Zhaltusha",
"3597425", "Kulata",
"35941351", "Partizanin",
"35984738", "Kitanchevo",
"35974327", "Novo\ Delchevo",
"35974203", "Rupite",
"35981466", "Pomen",
"35961309", "Gorsko\ Kalugerovo",
"3595536", "Maglen",
"359453", "Kotel",
"35961602", "Tsarski\ izvor",
"35977226", "Debeli\ lag",
"3596043", "Dolno\ Novkovo",
"3593543", "Dorkovo",
"3597938", "Dolno\ Uyno",
"35953222", "Markovo\,\ Shumen",
"359335", "Karlovo",
"35937604", "Varbovo\,\ Hask\.",
"3596138", "Nedan",
"3598448", "Terter",
"3593074", "Erma\ reka",
"359570", "Kavarna",
"359750", "Borovets\,\ Sofia",
"3593722", "Mineralni\ bani\,\ Hask\.",
"3596574", "Chomakovtsi",
"35941277", "Zagore",
"3593147", "Novo\ selo\,\ Plovdiv",
"3593782", "Kalugerovo\,\ Hask\.",
"35967398", "Damyanovo",
"359559", "Karnobat",
"3597528", "Hadzhidimovo",
"35969249", "Doyrentsi",
"35961393", "Gorsko\ Kosovo",
"3594587", "Yablanovo",
"3594134", "Bratya\ Daskalovi",
"3596716", "Zhaltesh",
"3596327", "Ovcha\ mogila",
"35935255", "Rosen\,\ Pazardzhik",
"35930410", "Breze\,\ Smol\.",
"3598662", "Dobrotitsa\,\ Silistra",
"3599516", "Lehchevo",
"3598693", "Zvenimir",
"3593695", "Komuniga",
"3594513", "Gavrailovoc",
"3594527", "Zagortsi\,\ Sliven",
"35936702", "Gorski\ izvor\,\ Kardzh\.",
"3596918", "Drenov",
"35931627", "Krushevo\,\ Plovdiv",
"35961303", "Gorna\ Lipnitsa",
"3596915", "Smochan",
"3595144", "Kamchia",
"35991186", "Baurene",
"3597525", "Banichan",
"35942", "Stara\ Zagora",
"35951539", "Levski\,\ Varna",
"3597132", "Radotina",
"3593516", "Tsrancha\,\ Pazardzhik",
"35971504", "Belopoptsi",
"35937707", "Shtit",
"3599722", "Staliyska\ mahala",
"3597912", "Gorna\ Grashtitsa",
"3593703", "Zhalti\ bryag",
"35984744", "Belovets",
"3594322", "Yagoda",
"3596582", "Belene",
"3595311", "Gradishte\,\ Shumen",
"35981465", "Batin",
"3596179", "Krusheto",
"3593022", "Vievo",
"3596135", "Varbovka",
"3593562", "Slavovitsa\,\ Pazardzhik",
"3599782", "Bukovets\,\ Mont\.",
"35967308", "Lovnidol",
"35960374", "Gorsko\ Ablanovo",
"3598445", "Yuper",
"3593155", "Momino\ selo",
"3599147", "Borovan",
"3596062", "Strazha\,\ Targ\.",
"3596522", "Zgalevo",
"3593676", "Benkovski\,\ Kardzh\.",
"3593774", "Levka",
"35969243", "Kazachevo",
"3598164", "Pisanets",
"3599171", "Oryahovo\,\ Vratsa",
"3598111", "Shtraklevo",
"3595958", "Gramatikovo",
"3597935", "Dolno\ selo",
"3597036", "Balanovo",
"35991202", "Kunino",
"359554", "Sunny\ Beach",
"3595353", "Veselinovo\,\ Shumen",
"35951125", "Konstantinovo\,\ Varna",
"35935501", "Ravnogor",
"3596112", "Samovodene",
"35966", "Gabrovo",
"3595947", "Prosenik",
"3593197", "Tyurkmen",
"3595756", "Bozhan",
"3595599", "Hadzhiite",
"3596932", "Mikre",
"35935256", "Sbor\,\ Pazardzhik",
"3597428", "Gabrene",
"3596166", "Vinograd",
"3593126", "Trud",
"3593645", "Avren\,\ Kardzh\.",
"3594102", "Yastrebovo\,\ St\.\ Zagora",
"3598643", "Zlatoklas",
"35931997", "Zlatosel",
"3594108", "Vasil\ Levski\,\ St\.\ Zagora",
"35931706", "Suhozem",
"3593756", "Valche\ pole",
"35951104", "Dolishte\,\ Varna",
"3596736", "Gradnitsa\,\ Gabr\.",
"3597422", "Topolnitsa\,\ Blag\.",
"3597043", "Golemo\ selo",
"3594510", "Zhelyu\ voyvoda",
"3596938", "Kalenik\,\ Lovech",
"3598690", "Silistra",
"3593709", "Karamantsi",
"3596541", "Nikopol",
"35967392", "Yavorets",
"35974405", "Kraishte\,\ Blag\.",
"35941337", "Sarnevets",
"3596118", "Voneshta\ voda",
"3592", "Sofia",
"3595126", "Cherkovna\,\ Varna",
"3595952", "Malko\ Tarnovo",
"3596173", "Dolna\ Oryahovitsa",
"3594341", "Cherganovo",
"3598159", "Koshov",
"3599741", "Dolni\ Tsibar",
"3598636", "Glavinitsa\,\ Silistra",
"359418", "Galabovo\,\ St\.\ Zagora",
"3596068", "Bozhurka",
"3596528", "Valchitran",
"35965165", "Pisarovo\,\ Pleven",
"3593725", "Stamboliyski\,\ Hask\.",
"35963561", "Grivitsa",
"3596001", "Cherkovna\,\ Targ\.",
"35974496", "Filipovo\,\ Blag\.",
"3593568", "Vinogradets",
"3593028", "Arda",
"35961109", "Vaglevtsi",
"35961608", "Gorski\ Senovets",
"3595516", "Indzhe\ voyvoda",
"3593077", "Sredets\,\ Smol\.",
"3599549", "Dolna\ Riksa",
"35931394", "Vasil\ Levski\,\ Plovdiv",
"3593785", "Dryanovo\,\ Hask\.",
"3596588", "Dekov",
"359697", "Lukovit",
"3597918", "Yabalkovo\,\ Kyust\.",
"3596577", "Breste",
"359631", "Svishtov",
"3599728", "Slivata",
"35984732", "Yonkovo",
"3596907", "Gradezhnitsa",
"35960453", "Moravka",
"3597138", "Litakovo",
"3595774", "Koriten",
"359650", "Levski\,\ Pleven",
"3594524", "Kamenovo\,\ Sliven",
"3598649", "Yarebitsa",
"3596324", "Vardim",
"3598665", "Iskra\,\ Silistra",
"3594584", "Ticha",
"3594137", "Veren",
"35960386", "Voditsa\,\ Targ\.",
"3599136", "Galiche",
"3593667", "Pokrovan",
"3594798", "Savino",
"35951429", "Solnik",
"3593321", "Topolovo\,\ Plovdiv",
"35963563", "Borislav",
"35930417", "Grohotno",
"3597435", "Sklave",
"35930476", "Selcha",
"3594514", "Krushare",
"3598694", "Zebil",
"359336", "Parvomay\,\ Plovdiv",
"3598142", "Bazovets\,\ Ruse",
"3595949", "Planinitsa\,\ Burgas",
"3596573", "Koynare",
"35944", "Sliven",
"3593073", "Startsevo",
"35941270", "Malka\ Vereya",
"3597928", "Garlyano",
"35961502", "Gorsko\ Novo\ Selo",
"35960451", "Obitel",
"3596518", "Riben",
"3596141", "Polski\ Trambesh",
"35931108", "Bogdanitsa",
"35937422", "Dolni\ Glavanak",
"3598431", "Isperih",
"3597726", "Dren",
"3595526", "Klikach",
"35935394", "Oborishte\,\ Pazardzhik",
"3595342", "Kapitan\ Petko",
"3599165", "Sofronievo",
"3599149", "Bukovets\,\ Vratsa",
"3599552", "Belimel",
"35984719", "Balkanski",
"3596177", "Yantra\,\ V\.\ Tarnovo",
"3593544", "Kostandovo",
"3596128", "Hotnitsa",
"3596044", "Dolno\ Kozarevo",
"35967304", "Kramolin",
"3593101", "Voyvodinovo",
"3595116", "Krumovo\,\ Varna",
"3593168", "Ezerovo\,\ Plovdiv",
"35960378", "Tsar\ Asen\,\ Targ\.",
"35941018", "Knyazhevsko",
"3597103", "Brusen\,\ Sofia",
"3593348", "Dobralak",
"3597047", "Usoyka",
"3594520", "Konyovo",
"3595162", "Belogradets",
"3599345", "Vinarovo\,\ Vidin",
"3595738", "Spasovo\,\ Dobr\.",
"3595555", "Fakia",
"3597755", "Velkovtsi\,\ Pernik",
"359720", "Etropole",
"3594745", "Sharkovo",
"359610", "Pavlikeni\,\ V\.\ Tarnovo",
"3594124", "Zmeyovo",
"3593631", "Momchilgrad",
"35984725", "Kichenitsa",
"3597058", "Stob",
"3594580", "Borintsi",
"3597174", "Kalotina",
"3597052", "Pastra",
"3594139", "Svoboda\,\ St\.\ Zagora",
"3599354", "Antimovo\,\ Vidin",
"3598647", "Paisievo",
"3597744", "Elovdol\,\ Pernik",
"3597125", "Govedartsi",
"3594754", "Kamenets\,\ Yambol",
"35959400", "Daskotna",
"3593116", "Krumovo\,\ Plovdiv",
"3597532", "Bukovo\,\ Blag\.",
"3595732", "Petleshkovo",
"35936401", "Strandzhevo",
"3595101", "Dabravino",
"3595168", "Petrov\ dol\,\ Varna",
"35969241", "Yoglav",
"3595140", "Shkorpilovtsi",
"3593342", "Narechenski\ bani",
"3597185", "Chelopech",
"35961405", "Petko\ Karavelovo",
"3596909", "Malka\ Zhelyazna",
"35973", "Blagoevgrad",
"35963575", "Bohot",
"3593555", "Nova\ mahala\,\ Pazardzhik",
"3596579", "Ruptsi\,\ Pleven",
"3593162", "Gradina\,\ Plovdiv",
"3596535", "Kozar\ Belene",
"3595943", "Vresovo",
"35961604", "Mirovo\,\ V\.\ Tarnovo",
"3593193", "Borets",
"35941115", "Borilovo",
"3599547", "Vinishte",
"3593035", "Varbina",
"3596122", "Belyakovets",
"3593079", "Kozarka",
"35984466", "Zvanartsi",
"3593936", "Gorski\ izvor\,\ Hask\.",
"3596956", "Lomets\,\ Lovech",
"3594335", "Razhena",
"3599558", "Gavril\ Genovo",
"3595348", "Trem",
"35969613", "Chiflik\,\ Lovech",
"35931398", "Slatina\,\ Plovdiv",
"3595395", "Chernookovo\,\ Shumen",
"3599143", "Enitsa",
"3594146", "Dinya",
"35961301", "Byala\ reka\,\ V\.\ Tarnovo",
"3597156", "Ravno\ pole",
"35971220", "Gutsal",
"3596512", "Gorni\ Dabnik",
"3597922", "Dragovishtitsa\,\ Kyust\.",
"35937602", "Cherna\ mogila\,\ Hask\.",
"35967194", "Grablevtsi",
"3595321", "Praventsi",
"3593707", "Nikolovo\,\ Hask\.",
"3598148", "Gorno\ Ablanovo",
"3596566", "Dolni\ Vit",
"3595715", "Popgrigorovo",
"3596026", "Makariopolsko",
"3596991", "Yablanitsa",
"35951108", "Izvorsko",
"3596985", "Rumyantsevo",
"3593526", "Dinkata",
"35941359", "Izvorovo\,\ St\.\ Zagora",
"3594763", "Irechekovo",
"3596925", "Vladinya",
"3594792", "Botevo\,\ Yambol",
"3598671", "Silistra",
"3593586", "Borimechkovo",
"3594523", "Stoil\ voyvoda",
"3595916", "Rosen\,\ Burgas",
"3595773", "Lozenets\,\ Dobr\.",
"3599526", "Slatina\,\ Mont\.",
"3596928", "Kakrina",
"35971502", "Eleshnitsa\,\ Sofia",
"3598697", "Sokol\,\ Silistra",
"3594517", "Ichera",
"3594583", "Kipilovo",
"3596323", "Balgarsko\ slivovo",
"3593664", "Plevun",
"3593766", "Biser",
"3595718", "Smolnitsa",
"35961406", "Karantsi",
"3596988", "Peshterna",
"3596726", "Skalsko",
"35960372", "Krepcha",
"35963576", "Tuchenitsa",
"35941116", "Sladak\ Kladenets",
"3593143", "Perushtitsa",
"35961391", "Slomer",
"3598626", "Sredishte\,\ Silistra",
"3598145", "Trastenik\,\ Ruse",
"35984465", "Savin",
"3596071", "Antonovo",
"3593712", "Malevo\,\ Hask\.",
"3595136", "Brestak",
"3593547", "Sarnitsa\,\ Pazardzhik",
"35941330", "Tsenovo\,\ St\.\ Zagora",
"3594338", "Kran",
"359519", "Devnya",
"3599555", "Kopilovtsi\,\ Mont\.",
"3596570", "Deventsi",
"3599162", "Mihaylovo\,\ Vratsa",
"3596047", "Zelena\ morava",
"3595345", "Razvigorovo",
"3593558", "Isperihovo",
"35941353", "Plodovitovo",
"3596538", "Obnova",
"35931308", "Bogdan\,\ Plovdiv",
"3593779", "Siva\ reka",
"3596174", "Draganovo\,\ V\.\ Tarnovo",
"35984778", "Bogdantsi\,\ Razgrad",
"3593038", "Chokmanovo",
"3594113", "Preslaven",
"3599116", "Kostelevo",
"3593653", "Mlechino",
"3597188", "Petrich\,\ Sofia",
"3596941", "Letnitsa",
"35974201", "Kapatovo",
"3597415", "Selishte\,\ Blag\.",
"3597177", "Aldomirovtsi",
"3594130", "Spasovo\,\ St\.\ Zagora",
"3596900", "Vasilyovo",
"3594742", "Stefan\ Karadzhovo",
"3595149", "Golitsa",
"3597752", "Rezhantsi",
"3595552", "Dyulevo\,\ Burgas",
"3597044", "Babino",
"3595165", "Nevsha",
"3599342", "Inovo",
"3599348", "Negovanovtsi",
"3595735", "Krasen\,\ Dobr\.",
"35960385", "Lomtsi",
"3594529", "Sadievo\,\ Sliven",
"3595558", "Debelt",
"3594748", "Voden\,\ Yambol",
"3598644", "Chernolik",
"35984269", "Nedoklan",
"35931603", "Vinitsa",
"35930475", "Stomanevo",
"3596329", "Tsarevets\,\ V\.\ Tarnovo",
"3593345", "Lyaskovo\,\ Plovdiv",
"3597182", "Mirkovo",
"35961203", "Emen",
"35930257", "Vishnevo",
"3594757", "Nedyalsko",
"35961101", "Velchevo\,\ V\.\ Tarnovo",
"3596125", "Pushevo",
"3593032", "Srednogortsi",
"3596532", "Balgarene\,\ Pleven",
"3593165", "Karadzhalovo",
"35963569", "Kamenets\,\ Pleven",
"3599140", "Gabare",
"3593552", "Bratsigovo",
"3593149", "Tsalapitsa",
"3598192", "Hotantsa",
"3598163", "Bazan",
"359747", "Razlog",
"35967394", "Bogatovo",
"3599168", "Butan",
"3599544", "Studeno\ buche",
"3594332", "Vetren\,\ St\.\ Zagora",
"3595354", "Rish",
"35930458", "Lyubcha",
"35931392", "Dabene",
"3596515", "Slavyanovo\,\ Pleven",
"3595766", "Metodievo\,\ Dobr\.",
"3593718", "Voyvodovo\,\ Hask\.",
"3593704", "Bryagovo\,\ Hask\.",
"359936", "Belogradchik",
"35984734", "Todorovo\,\ Razgrad",
"3593190", "Varben\,\ Plovdiv",
"3595392", "Mengishevo",
"3595363", "Gusla",
"3593773", "Kapitan\ Andreevo",
"3595968", "Kableshkovo\,\ Burgas",
"3597925", "Gyueshevo",
"35931620", "Dobri\ dol\,\ Plovdiv",
"3596982", "aglen",
"35984713", "Blagoevo\,\ Razgrad",
"3595712", "Stozher",
"3593136", "Rozino\,\ Plovdiv",
"3595571", "Sungurlare",
"3596156", "Rodina",
"3594795", "Skalitsa",
"3596922", "Leshnitsa\,\ Lovech",
"35984726", "Ushintsi",
"3597438", "Katuntsi",
"3595143", "Byala\,\ Varna",
"3596590", "Rakita\,\ Pleven",
"3599173", "Galovo",
"3597126", "Gorni\ Okol",
"3598127", "Karamanovo",
"359517", "Dalgopol",
"35963568", "Bukovlak",
"3593115", "Kuklen",
"35953221", "Stoyan\ Mihaylovski",
"3598113", "Novo\ selo\,\ Ruse",
"35984467", "Seslav",
"3599541", "Doktor\ Yosifovo",
"3597186", "Anton",
"3598187", "Tetovo",
"3595351", "Smyadovo",
"35941175", "Kolena",
"35930459", "Brashten",
"3596536", "Asparuhovo\,\ Pleven",
"3593556", "Radilovo",
"3598196", "Nisovo",
"35969244", "Tepava",
"3593036", "Mogilitsa",
"35941352", "Vinarovo\,\ St\.\ Zagora",
"3594336", "Dolno\ Izvorovo",
"3596955", "Dalbok\ dol",
"3599333", "Boynitsa",
"3593935", "Varbitsa\,\ Hask\.",
"3594710", "Bolyarsko",
"3598641", "Okorsh",
"3594733", "Orlov\ dol",
"359670", "Troyan\,\ Lovech",
"3594145", "Znamenosets",
"3594724", "Razdel\,\ Yambol",
"3595396", "Lovets\,\ Shumen",
"3598677", "Srebarna",
"3595574", "Saedinenie\,\ Burgas",
"3599324", "Ruzhintsi",
"3595762", "Stefan\ Karadzha\,\ Dobr\.",
"3595138", "Dobrotich",
"35984743", "Brestovene",
"3597155", "Lesnovo",
"359659", "Cherven\ bryag",
"3598628", "Tsar\ Asen\,\ Silistra",
"35961705", "Gorski\ dolen\ Trambesh",
"3596997", "Dobrevtsi\,\ Lovech",
"35960373", "Posabina",
"359309", "Pamporovo",
"35961304", "Dimcha",
"3593701", "Elena\,\ Hask\.",
"3596565", "Milkovitsa",
"3595716", "Paskalevo",
"3596025", "Alvanovo",
"3593132", "Banya\,\ Plovdiv",
"3595327", "Kaspichan\,\ Shumen",
"3593768", "Dositeevo",
"3596549", "Sanadinovo",
"3596152", "Bebrovo",
"3595330", "Zlatar",
"3596728", "Burya",
"3596986", "Daben",
"3595313", "Madara",
"3593049", "Beden",
"3599528", "Gaganitsa",
"35984766", "Kamenar\,\ Razgrad",
"359860", "Silistra",
"3595918", "Rusokastro",
"3598151", "Prosena",
"35971503", "Dolno\ Kamartsi",
"3593585", "Akandzhievo",
"3599749", "Cherni\ vrah\,\ Mont\.",
"3593740", "Pchelari",
"3596926", "Gorno\ Pavlikene",
"3596003", "Preselets",
"3599135", "Bardarski\ geran",
"3597436", "Levunovo",
"35960454", "Zmeyno",
"3595912", "Polski\ izvor",
"35941146", "Hristianovo",
"3596147", "Ivancha\,\ V\.\ Tarnovo",
"3599522", "Kotenovtsi",
"3596722", "Sokolovo\,\ Gabr\.",
"3596158", "Sredni\ kolibi",
"3596074", "Lyubichevo",
"35984712", "Kostandenets",
"3593762", "Izvorovo\,\ Hask\.",
"3593138", "Vedrare",
"35960387", "Gloginka",
"3598622", "Alekovo\,\ Silistra",
"3595740", "Gorichane",
"35930416", "Gyovren",
"3594567", "Banya\,\ Sliven",
"3594154", "Mednikarovo",
"3599339", "Makresh",
"3593327", "Bachkovo",
"3595132", "Mihalich\,\ Varna",
"3595768", "Odrintsi\,\ Dobr\.",
"3594739", "Radovets",
"3594775", "Karavelovo\,\ Yambol",
"3593661", "Ivaylovgrad",
"3597144", "Kostenets",
"3595525", "Devetak",
"3597725", "Klenovik",
"35931393", "Voynyagovo",
"3596944", "Krushuna",
"35951314", "Voyvodino",
"3593637", "Gruevo",
"3599166", "Hayredin",
"359848", "Kubrat",
"3597041", "Shatrovo",
"3595115", "General\ Kantardzhievo",
"3596543", "Muselievo",
"35935391", "Blatnitsa",
"3593107", "Graf\ Ignatievo",
"35951103", "Lyuben\ Karavelovo",
"3593043", "Zmeitsa",
"3595319", "Drumevo",
"35931602", "Tatarevo\,\ Plovdiv",
"35996", "Montana",
"3599112", "Banitsa",
"35941480", "Kolarovo\,\ St\.\ Zagora",
"3595556", "Golyamo\ Bukovo",
"3594343", "Konare\,\ St\.\ Zagora",
"3599346", "Sinagovtsi",
"35931309", "Kliment\,\ Plovdiv",
"35984779", "Zdravets\,\ Razgrad",
"359749", "Bansko",
"35967301", "Idilevo",
"3594746", "Popovo\,\ Yambol",
"3595310", "Radko\ Dimitrievo",
"3598184", "Glodzhevo",
"35961104", "Vodoley",
"3593112", "Markovo\,\ Plovdiv",
"3595736", "Vasilevo",
"3595333", "Han\ Krum",
"3597056", "Mursalevo",
"35941145", "Arnautito",
"3593743", "Silen",
"3598124", "Novgrad",
"35967391", "Stolat",
"3593346", "Muldava",
"3594751", "Voynika",
"3596126", "Tserova\ koria",
"3593629", "Most",
"3599351", "Izvor\,\ Vidin",
"3597741", "Zemen",
"3593166", "Byala\ reka\,\ Plovdiv",
"35930415", "Devin",
"3595118", "Voditsa\,\ Varna",
"35955502", "Suhodol\,\ Burgas",
"3593932", "Bodrovo",
"3596952", "Oreshak\,\ Lovech",
"35930256", "Galabovo\,\ Smol\.",
"3597549", "Dolen\,\ Blag\.",
"35981264", "Piperkovo",
"3597152", "Gorna\ Malina",
"3595749", "Krapets\,\ Dobr\.",
"35971304", "Lipnitsa\,\ Sofia",
"3596516", "Iskar\,\ Pleven",
"3595765", "Lovchantsi",
"35984", "Razgrad",
"35937423", "Golemantsi",
"3594778", "Pobeda\,\ Yambol",
"3597728", "Drugan",
"3595528", "Nevestino\,\ Burgas",
"3594142", "Troyanovo\,\ St\.\ Zagora",
"3596994", "Brestnitsa\,\ Lovech",
"35961503", "Chakali",
"3599313", "Kapitanovtsi",
"35941358", "Opalchenets",
"35991180", "Lesura",
"3598674", "Profesor\ Ishirkovo",
"3594730", "Knyazhevo",
"3595577", "Podvis\,\ Burgas",
"3594727", "Malak\ manastir",
"3597926", "Konyavo",
"3594713", "Stara\ reka\,\ Yambol",
"3599330", "Rabrovo",
"35984727", "Kamenovo\,\ Razgrad",
"3599327", "Chuprene",
"3596359", "Glava",
"359550", "Sozopol",
"3593522", "Gelemenovo",
"3596155", "Konstantin",
"3598133", "Ryahovo",
"35947353", "Balgarska\ polyana",
"3596022", "Probuda\,\ Targ\.",
"3596562", "Gigen",
"3593135", "Karnare",
"3594796", "General\ Toshevo\,\ Yambol",
"359579", "Albena",
"3595324", "Harsovo\,\ Shumen",
"3593582", "Momina\ klisura",
"35963562", "Komarevo\,\ Pleven",
"3599138", "Altimir",
"3594362", "Manolovo",
"35963577", "Pelishat",
"3599525", "Dolno\ Ozirovo",
"359331", "Asenovgrad",
"3594368", "Tarnicheni",
"3595915", "Balgarovo",
"3593040", "Trigrad",
"35941117", "Kazanka",
"3599132", "Knezha",
"35961394", "Daskot",
"3593588", "Menenkyovo",
"3596540", "Asenovo\,\ Pleven",
"3596077", "Stevrek",
"3596568", "Dabovan",
"3596028", "Vardun",
"3593765", "Ivanovo\,\ Hask\.",
"3593749", "Garvanovo",
"3599740", "Septemvriytsi\,\ Mont\.",
"3593528", "Govedare",
"3596144", "Dolna\ Lipnitsa",
"3596725", "Gostilitsa",
"3594340", "Panicherevo",
"3593324", "Izbeglii",
"359379", "Svilengrad",
"35951428", "Gospodinovo\,\ Varna",
"3594157", "Razdelna\,\ St\.\ Zagora",
"3598625", "Oven",
"3597147", "Pchelin\,\ Sofia",
"35937603", "Rogozinovo",
"3593623", "Boyno",
"3594511", "Slivenski\ mineralni\ bani",
"359350", "Peshtera\,\ Pazardzhik",
"3595522", "Iskra\,\ Burgas",
"3594772", "Simeonovo\,\ Yambol",
"3598691", "Silistra",
"3595135", "Stefan\ Karadzha\,\ Varna",
"35957308", "Chernookovo\,\ Dobr\.",
"3594564", "Novoselets",
"3597158", "Doganovo",
"35969612", "Terziysko\,\ Lovech",
"3596958", "Apriltsi\,\ Lovech",
"35941019", "Venets\,\ St\.\ Zagora",
"35931700", "Belovitsa",
"3595743", "Shabla",
"3594553", "Rakovo\,\ Sliven",
"3595346", "Kamenyak\,\ Shumen",
"35974204", "Gega",
"3599556", "Govezhda",
"3595112", "Beloslav",
"35956", "Burgas",
"3593634", "Pripek\,\ Kardzh\.",
"3594121", "Lyulyak",
"3599319", "Gamzovo",
"35961706", "Pisarevo\,\ V\.\ Tarnovo",
"35991201", "Lyuti\ brod",
"3599115", "Chiren",
"35984718", "Dryanovets\,\ Razgrad",
"35935502", "Fotinovo\,\ Pazardzhik",
"3593173", "Panicheri",
"35984749", "Sevar",
"3593104", "Yagodovo\,\ Plovdiv",
"35984765", "Veselina",
"359416", "Chirpan",
"3595166", "Dobroplodno",
"3593118", "Sadovo\,\ Plovdiv",
"3593752", "Malko\ gradishte",
"3596732", "Sennik",
"3593044", "Lyaskovo\,\ Smol\.",
"3599185", "Beli\ Izvor",
"3596168", "Sushitsa\,\ V\.\ Tarnovo",
"3596544", "Novachene\,\ Pleven",
"3593128", "Zlatitrap",
"3593177", "Novo\ Zhelezare",
"3599744", "Valchedram",
"3599125", "Gorna\ Beshovitsa",
"3597426", "Marikostinovo",
"35971587", "Golema\ Rakovitsa",
"3594344", "Shanovo",
"3593320", "Oreshets\,\ Plovdiv",
"3599329", "Rabisha",
"3593651", "Ardino",
"3595122", "Slaveykovo\,\ Varna",
"3595758", "Kladentsi",
"35981268", "Krivina\,\ Ruse",
"3594729", "Kirilovo\,\ Yambol",
"3595535", "Lyaskovo\,\ Burgas",
"3597735", "Leva\ reka",
"3595579", "Vedrovo",
"3596943", "Gorsko\ Slivovo",
"35991203", "Lik",
"3594557", "Bikovo",
"3598632", "Zafirovo",
"35941354", "Malko\ Tranovo",
"35969242", "Presyaka",
"35937705", "Pastrogor",
"3597547", "Valkosel",
"35936402", "Gorna\ kula",
"3595747", "Vaklino",
"3595771", "Krushari",
"359724", "Ihtiman",
"35960380", "Drinovo",
"3597712", "Batanovtsi",
"3593678", "Chakalarovo",
"3597143", "Vakarel",
"3596321", "Gorna\ Studena",
"3594595", "Sborishte",
"3594153", "Madrets\,\ St\.\ Zagora",
"359707", "Sapareva\ banya",
"3593518", "Dragor",
"35941276", "Mogila\,\ St\.\ Zagora",
"3596004", "Makovo",
"35961108", "Plakovo",
"3593696", "Pchelarovo\,\ Kardzh\.",
"35951127", "Razdelna\,\ Varna",
"3593100", "Belashtitsa",
"35961302", "Batak\,\ V\.\ Tarnovo",
"3599515", "Madan\,\ Mont\.",
"35982", "Ruse",
"3595314", "Belokopitovo",
"35974407", "Kremen\,\ Blag\.",
"35937421", "Dolno\ pole",
"35941335", "Mogilovo",
"3595361", "Kaolinovo",
"3598137", "Golyamo\ Vranovo",
"35967309", "Agatovo",
"3597136", "Novachene\,\ Sofia",
"3593512", "Hadzhievo",
"35959694", "Gaberovo",
"35931995", "Streltsi\,\ Plovdiv",
"35984733", "Ludogortsi",
"3596586", "Belene",
"3594717", "Chargan",
"3594326", "Enina",
"3593925", "Krum",
"3599323", "Drenovets",
"3595100", "Sindel",
"3597444", "Belitsa\,\ Blag\.",
"3599317", "Archar",
"3599726", "Zamfir",
"3595573", "Vezenkovo",
"3594723", "Boyanovo\,\ Yambol",
"3597916", "Bagrentsi",
"3596965", "Beli\ Osam",
"3596066", "Buynovo\,\ Targ\.",
"3596526", "Varbitsa\,\ Pleven",
"359538", "Veliki\ Preslav",
"359677", "Tryavna",
"3593672", "Chorbadzhiysko",
"35951538", "Izgrev\,\ Varna",
"3595518", "Rudnik\,\ Burgas",
"3597718", "Dragichevo",
"3595141", "Staro\ Oryahovo",
"3593026", "Smilyan",
"3593566", "Boshulya",
"3598638", "Bogdantsi\,\ Silistra",
"35959406", "Razboyna\,\ Burgas",
"3596990", "Malak\ izvor\,\ Lovech",
"3598670", "Silistra",
"35957304", "Dabovik",
"3594734", "Srem",
"3596116", "Golemanite",
"3597165", "Milanovo\,\ Sofia",
"3595752", "Nova\ Kamena",
"3597149", "Zhivkovo\,\ Sofia",
"3597032", "Yahinovo",
"3595128", "Zhitnitsa\,\ Varna",
"35967393", "Dushevo",
"3596770", "Plachkovtsi",
"3598114", "Pirgovo",
"3598161", "Vetovo",
"3593747", "Tatarevo\,\ Hask\.",
"3599174", "Gorni\ Vadin",
"3594355", "Buzovgrad",
"3595337", "Kochovo",
"3596035", "Palamartsa",
"3593122", "Manole",
"3594106", "Pastren",
"3595320", "Pet\ mogili\,\ Shumen",
"3593055", "Elhovets",
"35931604", "Dragoynovo",
"3593535", "Levski\,\ Pazardzhik",
"3596738", "Dobromirka",
"3593758", "Yerusalimovo",
"35963205", "Chervena",
"3596555", "Baykal",
"35974386", "Pirin",
"3599747", "Mokresh\,\ Mont\.",
"35941336", "Yazdach",
"3593174", "Staro\ Zhelezare",
"3593058", "Mugla",
"3593538", "Elshitsa",
"35971225", "Novo\ selo\,\ Sofia",
"3594347", "Rozovo\,\ St\.\ Zagora",
"3599182", "Devene",
"35961308", "Vishovgrad",
"3593755", "Belitsa\,\ Hask\.",
"3598424", "Tsar\ Kaloyan\,\ Razgrad",
"3596558", "Slavovitsa\,\ Pleven",
"35961102", "Pchelishte",
"3599122", "Zverino",
"3596547", "Dragash\ voyvoda",
"3594358", "Skobelevo\,\ St\.\ Zagora",
"3593103", "Milevo",
"3595329", "Mirovtsi",
"3597168", "Bov",
"3597732", "Vukan",
"3595532", "Topolitsa",
"35931996", "Svezhen",
"35955504", "Bogdanovo\,\ Burgas",
"3594554", "Trapoklovo",
"35931707", "Chernozemen",
"35935393", "Smilets\,\ Pazardzhik",
"3597544", "Osina",
"3595125", "Gradinarovo",
"35967303", "Batoshevo",
"3598635", "Tsar\ Samuil",
"3598679", "Kaynardzha",
"3593633", "Rogozche",
"35931387", "Prolom",
"3593624", "Chiflik\,\ Kardzh\.",
"3593726", "Klokotnitsa",
"35971338", "Osikovska\ Lakavitsa",
"35969248", "Skobelevo\,\ Lovech",
"359357", "Panagyurishte",
"3595515", "Kameno",
"3597715", "Studena\,\ Pernik",
"35959405", "Zaychar",
"3593323", "Bolyartsi\,\ Plovdiv",
"35971302", "Bozhenitsa",
"3593786", "Navasen",
"35981262", "Bistrentsi",
"3593928", "Dolno\ Belevo",
"3594592", "Byala\ palanka",
"3596968", "Dobrodan",
"3596901", "Glozhene\,\ Lovech",
"3596712", "Gabene",
"359361", "Kardzhali",
"35963564", "Bivolare",
"35963570", "Staroseltsi",
"35941110", "Starozagorski\ bani",
"3596571", "Lepitsa",
"3593071", "Zlatograd",
"35953434", "Yasenkovo",
"3596143", "Maslarevo",
"3596007", "Ralitsa",
"3599512", "Beli\ breg",
"3598666", "Tutrakan",
"35967399", "Malki\ Varshets",
"3598129", "Lom\ Cherkovna",
"35974325", "Lilyanovo",
"3599518", "Marchevo",
"3599141", "Malorad",
"359478", "Elhovo\,\ Yambol",
"3598134", "Malko\ Vranovo",
"3596916", "Brestovo\,\ Lovech",
"359938", "Kula",
"359777", "Radomir",
"3597526", "Ribnovo",
"3595317", "Ivanski",
"3595726", "Tsarichino",
"3595323", "Pliska",
"3593109", "Lilkovo",
"3593515", "Kalugerovo\,\ Pazardzhik",
"3596718", "Draganovtsi",
"3596962", "Cherni\ Osam",
"359590", "Tsarevo",
"3593922", "Brod",
"3593156", "Shishmantsi",
"3597447", "Dobrinishte",
"3594714", "Drazhevo",
"35974348", "Igralishte",
"3596136", "Suhindol",
"35984720", "Topchii",
"3593675", "Fotinovo\,\ Kardzh\.",
"3593639", "Nanovitsa\,\ Kardzh\.",
"3594761", "Straldzha",
"3599314", "Dunavtsi\,\ Vidin",
"3598673", "Alfatar",
"35967193", "Kmetovtsi",
"35937706", "Chernodab",
"359619", "Lyaskovets\,\ V\.\ Tarnovo",
"35953223", "Tsarkvitsa",
"35971398", "Osikovitsa",
"3594737", "Sinapovo",
"3595570", "Manolich",
"3597936", "Slokoshtitsa",
"35935257", "Saraya",
"3599320", "Stakevtsi",
"359910", "Mezdra",
"3599337", "Gramada",
"359729", "Godech",
"35961603", "Lozen\,\ V\.\ Tarnovo",
"35969614", "Gorno\ trape",
"3597035", "Cherven\ breg",
"35974202", "Klyuch",
"3595755", "Kolartsi",
"3595538", "Karanovo\,\ Burgas",
"3597193", "Golesh\,\ Sofia",
"3597162", "Lakatnik",
"3595941", "Skalak\,\ Burgas",
"3593191", "Brezovo\,\ Plovdiv",
"35960458", "Verentsi",
"3594352", "Gorno\ Cherkovishte",
"3595334", "Osmar",
"3599128", "Eliseyna",
"35941275", "Lyaskovo\,\ St\.\ Zagora",
"3596149", "Kutsina",
"3596552", "Dolna\ Mitropolia",
"3599188", "Gorno\ Peshtene",
"3598475", "Loznitsa\,\ Razgrad",
"3598117", "Marten",
"3597116", "Petarch",
"3596165", "Asenovo\,\ V\.\ Tarnovo",
"3593532", "Strelcha",
"3593052", "Laki\,\ Plovdiv",
"3598123", "Bosilkovtsi",
"3596032", "Zaraevo",
"3593646", "Tokachka",
"3593125", "Razhevo\ Konare",
"3593744", "Sarnitsa\,\ Hask\.",};
$areanames{bg} = {"3597745", "Егълница",
"3597124", "Белчински\ бани",
"3596933", "Голец",
"35941179", "Хан\ Аспарухово",
"3599355", "Косово\,\ Видин",
"3596910", "Малиново",
"3597048", "Блажиево",
"3593347", "Леново",
"3594755", "Тамарино",
"3595737", "Люляково\,\ Добр\.",
"3597184", "Копривщица",
"3597520", "Корница",
"3598642", "Дулово",
"3593699", "Габрово\,\ Кърдж\.",
"3594103", "Бял\ извор\,\ Ст\.\ Загора",
"3597057", "Мало\ село",
"35967774", "Белица\,\ Габр\.",
"3596534", "Малчика",
"35978", "Кюстендил",
"3593554", "Козарско",
"3598194", "Сандрово",
"3593034", "Левочево",
"3596178", "Стрелец\,\ В\.\ Търново",
"3599542", "Смоляновци",
"3594334", "Елхово\,\ Ст\.\ Загора\,\ общ\.\ Николаево",
"35931324", "Мраченик",
"3595352", "Янково",
"3593167", "Брягово\,\ Пловдив",
"35960388", "Горица\,\ Търг\.",
"3596113", "Балван",
"35935254", "Добровница",
"3593702", "Царева\ поляна",
"3594726", "Маломирово",
"3597913", "Рашка\ Гращица",
"3595394", "Бяла\ река\,\ Шумен",
"3599723", "Трайково",
"35991184", "Ракево",
"3596151", "Елена\,\ В\.\ Търново",
"3595576", "Лозарево",
"359457", "Нова\ Загора",
"3599326", "Горни\ Лом",
"35971506", "Габра",
"3597930", "Еремия",
"3597927", "Трекляно",
"35984763", "Бели\ Лом",
"3596583", "Белене",
"3594323", "Тулово",
"35937701", "Сладун",
"3596517", "Подем",
"3598152", "Красен\,\ Русе",
"3599783", "Брусарци",
"3595959", "Звездец",
"3593023", "Момчиловци",
"3593563", "Варвара\,\ Пазарджик",
"35961402", "Стефан\ Стамболово",
"3596523", "Крушовица\,\ Плевен",
"3596063", "Баячево",
"3595714", "Карапелит",
"35963572", "Ясен\,\ Плевен",
"35960376", "Люблен",
"3594797", "Гълъбинци",
"35941112", "Старозагорски\ бани",
"3595761", "Батово",
"3596984", "Бежаново\,\ Ловеч",
"359723", "Ботевград",
"3597110", "Опицвет",
"35930200", "Загражден\,\ Смол\.",
"35930517", "Забърдо",
"3597133", "Правец",
"35931396", "Домлян",
"3596939", "Драгана",
"35953437", "Габрица\,\ Шумен",
"3598621", "Силистра",
"3597434", "Струмяни",
"35930413", "Девин",
"3595131", "Вълчи\ дол",
"35963567", "Градина\,\ Плевен",
"3598695", "Ножарево",
"35993342", "Киреево",
"3594109", "Тракия",
"3596076", "Таймище",
"3594515", "Мокрен",
"3593662", "Железино",
"359676", "Дряново\,\ Габр\.",
"3593693", "Лясково\,\ Кърдж\.",
"3598158", "Мечка\,\ Русе",
"3599521", "Замфирово",
"3594156", "Априлово\,\ Ст\.\ Загора",
"35931401", "Кадиево",
"3596119", "Дичин",
"35984722", "Ясеновец",
"3598147", "Баниска",
"3597146", "Черньово",
"35975215", "Тешово",
"3593708", "Орлово\,\ Хаск\.",
"3596946", "Чавдарци",
"35931258", "Главатар",
"3599729", "Расово",
"3593720", "Маджарово",
"3599164", "Крушовица\,\ Враца",
"35930528", "Манастир\,\ Пловдив",
"35991888", "Веслец\,\ Враца",
"3594329", "Долно\ Сахране",
"3596589", "Кулина\ вода",
"3599111", "Челопек",
"3599548", "Крапчене",
"3593569", "Карабунар",
"3599560", "Безденица",
"3593029", "Петково\,\ Смол\.",
"35931704", "Иван\ Вазово",
"3593545", "Драгиново",
"3596069", "Васил\ Левски\,\ Търг\.",
"3599557", "Горно\ Церовене",
"3596529", "Коиловци",
"35951106", "Осеново\,\ Варна",
"3595347", "Живково\,\ Шумен",
"3598648", "Секулово",
"35969031", "Галата",
"3595167", "Венчан",
"3597754", "Кошарево",
"3595554", "Момина\ църква",
"35941331", "Гранит",
"3597423", "Коларово\,\ Благ\.",
"3597042", "Коркина",
"3599344", "Връв",
"3597139", "Джурово",
"3597175", "Габер",
"3598660", "Тутракан",
"3594744", "Голямо\ Крушево",
"3594125", "Михайлово\,\ Ст\.\ Загора",
"35931395", "Иганово",
"3594752", "Първенец\,\ Ямбол",
"35968", "Ловеч",
"3597187", "Буново\,\ София",
"3595734", "Преселенци",
"3597178", "Пролеша",
"3597054", "Рила",
"359721", "Костинброд",
"3599352", "Дружба",
"3597742", "Калище",
"3598669", "Гарван\,\ Силистра",
"35941149", "Ловец\,\ Ст\.\ Загора",
"3593643", "Голяма\ Чинка",
"3597127", "Широки\ дол",
"3598645", "Межден",
"35941118", "Остра\ могила\,\ Ст\.\ Загора",
"3593931", "Каснаково",
"35963578", "Опанец\,\ Плевен",
"3593344", "Новаково\,\ Пловдив",
"3596580", "Татари",
"3594337", "Ясеново\,\ Ст\.\ Загора",
"35957307", "Житен\,\ Добр\.",
"3595106", "Аврен\,\ Варна",
"3597933", "Грамаждано",
"3593111", "Първенец\,\ Пловдив",
"3596124", "Леденик",
"3593548", "Пашово",
"3593729", "Криво\ поле",
"3599720", "Ковачица",
"3593164", "Дълбок\ извор",
"3597910", "Берсин",
"3596048", "Изворово\,\ Търг\.",
"3593557", "Бяга",
"35930419", "Ягодина",
"3596060", "Овчарово\,\ Търг\.",
"3596520", "Николаево\,\ Плевен",
"3596537", "Асеновци",
"3593020", "Давидково",
"3599569", "Липен",
"3599545", "Габровница",
"3593037", "Сивино",
"35969240", "Хлевене",
"35960382", "Ковачевец",
"3596514", "Долни\ Дъбник",
"3593521", "Звъничево",
"3593705", "Въгларово",
"3596021", "Буховци",
"3596561", "Гулянци",
"3595397", "Методиево\,\ Шумен",
"3598676", "Ветрен\,\ Силистра",
"35930472", "Михалково",
"3593581", "Белово",
"35947356", "Мрамор\,\ Ямбол",
"3596133", "Михалци",
"3597924", "Шишковци",
"3594361", "Павел\ баня",
"35991401", "Враняк",
"3593153", "Стряма",
"35984776", "Хърсово\,\ Разград",
"3596913", "Славяни",
"3598698", "Шуменци",
"3596927", "Умаревци",
"3595783", "Котленци",
"3594518", "Тополчане",
"3596930", "Славщица",
"3594794", "Овчи\ кладенец",
"3594100", "Столетово\,\ Ст\.\ Загора",
"35974404", "Бабяк",
"3595717", "Ведрина",
"3595326", "Върбяне",
"3596987", "Карлуково",
"3597523", "Гърмен",
"3595723", "Гурково\,\ Добр\.",
"35984717", "Побит\ камък\,\ Разград",
"35971221", "Ярлово",
"35964", "Плевен",
"359308", "Мадан\,\ Смол\.",
"35947202", "Жребино",
"35930456", "Чавдар\,\ Смол\.",
"3595153", "Суворово",
"359915", "Бяла\ Слатина",
"3593665", "Свирачи",
"3594512", "Блатец\,\ Сливен",
"3595521", "Венец\,\ Бургас",
"3594771", "Маломир\,\ Ямбол",
"3598692", "Стефан\ Караджа\,\ Силистра",
"35937606", "Шишманово",
"3598663", "Ситово\,\ Силистра",
"3596146", "Полски\ Сеновец",
"3597437", "Мелник",
"3597119", "Дръмша",
"35960450", "Долна\ Хубавка",
"3593717", "Конуш\,\ Хаск\.",
"3593326", "Патриарх\ Евтимово",
"3597939", "Църварица",
"35941173", "Братя\ Кунчеви",
"3599131", "Добролево",
"3598144", "Батишница",
"35984392", "Белинци",
"3595967", "Бата",
"359556", "Обзор",
"3594566", "Питово",
"3593783", "Свирково",
"35984728", "Раковски\,\ Разград",
"35971505", "Чурек",
"3595344", "Велино",
"3599554", "Чипровци",
"35941357", "Зетьово\,\ Ст\.\ Загора",
"3593636", "Равен",
"3599167", "Липница\,\ Враца",
"3596042", "Илийно",
"3593159", "Белозем",
"3593542", "Ракитово",
"3596175", "Първомайци",
"359748", "Симитли",
"3596919", "Слатина\,\ Ловеч",
"35960375", "Гърчиново",
"3599347", "Бела\ Рада",
"3595557", "Бистрец\,\ Бургас",
"35961703", "Върбица\,\ В\.\ Търново",
"35941484", "Землен",
"3594747", "Денница\,\ Ямбол",
"35984769", "Гороцвет",
"35984462", "Острово",
"3594122", "Еленино",
"35974321", "Хърсово\,\ Благ\.",
"3593106", "Строево",
"35984745", "Владимировци",
"3597172", "Драгоман",
"3597045", "Голем\ Върбовник",
"3595164", "Неофит\ Рилски",
"35981464", "Острица\,\ Русе",
"3597529", "Брезница",
"3593652", "Бял\ извор\,\ Кърдж\.",
"359675", "Севлиево",
"3594112", "Бъдеще",
"3593046", "Барутин",
"359373", "Харманли",
"35946", "Ямбол",
"3595121", "Тутраканци",
"3596989", "Торос",
"3595719", "Дончево",
"3596546", "Лозица\,\ Плевен",
"3597105", "Малки\ Искър",
"3594743", "Мамарчево",
"3596929", "Радювене",
"3598631", "Силистра",
"3599746", "Разград\,\ Монт\.",
"35974408", "Обидим",
"3597424", "Кърналово",
"3599343", "Гомотарци",
"3597753", "Ноевци",
"3595553", "Орлинци",
"3594346", "Голямо\ Дряново",
"3593751", "Любимец",
"35951537", "Чернево",
"3599163", "Хърлец",
"3598140", "Борово\,\ Русе",
"35935252", "Тополи\ дол",
"359865", "Силистра",
"35974207", "Генерал\ Тодоров",
"35974323", "Лозеница",
"3593039", "Полковник\ Серафимово",
"3593075", "Долен\,\ Смол\.",
"3599567", "Долна\ Вереница",
"3593787", "Тянево\,\ Хаск\.",
"35962", "Велико\ Търново",
"3596539", "Градище\,\ Плевен",
"3595340", "Висока\ поляна\,\ Шумен",
"3596575", "Телиш",
"3593778", "Студена\,\ Хаск\.",
"3593142", "Брестовица\,\ Пловдив",
"3599550", "Митровци",
"3593559", "Капитан\ Димитриево",
"35991182", "Осен\,\ Враца",
"3593727", "Нова\ Надежда",
"3595368", "Тъкач",
"3593713", "Динево",
"3594339", "Юлиево",
"3595772", "Телериг",
"3597433", "Кресна",
"3595148", "Рудник\,\ Варна",
"3595511", "Лукойл\ Нефтохим",
"3597711", "Кладница",
"3594522", "Кортен",
"35941171", "Дълбоки",
"3597129", "Радуил",
"3596006", "Пресиян",
"3598667", "Белица\,\ Силистра",
"35961605", "Ново\ градище",
"3596905", "Дивчовото",
"35941114", "Лозен\,\ Ст\.\ Загора",
"3596322", "Алеково\,\ В\.\ Търново",
"3594582", "Градец\,\ Сливен",
"35963574", "Тодорово\,\ Плевен",
"35963560", "Радишево",
"3597189", "Чавдар\,\ София",
"35961397", "Мусина",
"3597527", "Горно\ Дряново",
"3595727", "Сенокос\,\ Добр\.",
"3596983", "Дерманци",
"3595316", "Салманово",
"359431", "Казанлък",
"359971", "Лом",
"3594588", "Филаретово",
"3596328", "Ореш",
"35967305", "Стоките",
"3595713", "Стефаново\,\ Добр\.",
"3597134", "Врачеш",
"3596923", "Горан",
"3594749", "Ружица\,\ Ямбол",
"3593671", "Подкова",
"3594528", "Любенова\ махала",
"35941339", "Димитриево",
"3595142", "Долни\ чифлик",
"3595559", "Кубадин",
"359301", "Смолян",
"35984736", "Подайва",
"3599349", "Сланотрън",
"3593340", "Нови\ извор",
"3596917", "Българене\,\ Ловеч",
"3594324", "Шипка",
"3596137", "Бутово",
"3596584", "Белене",
"3593157", "Болярино",
"3597446", "Елешница\,\ Благ\.",
"3599145", "Бреница\,\ Враца",
"3595362", "Климент\,\ Шумен",
"3595393", "Иваново\,\ Шумен",
"3599724", "Станево",
"3597914", "Ваксево",
"3599169", "Рогозен",
"3593148", "Йоаким\ Груево",
"3596524", "Петърница",
"3593511", "Огняново\,\ Пазарджик",
"3596064", "Голямо\ Ново",
"3593772", "Момково",
"3593024", "Търън",
"3593564", "Семчиново",
"3599784", "Киселево",
"35931702", "Долна\ махала\,\ Пловдив",
"3596510", "Тотлебен",
"35935418", "Кръстава",
"3593553", "Батак\,\ Пазарджик",
"3595969", "Гълъбец\,\ Бургас",
"3595945", "Добромир",
"3593195", "Розовец",
"3596533", "Стежерово",
"3596114", "Килифарево",
"3593121", "Рогош",
"3594736", "Светлина",
"3599336", "Старопатица",
"3596161", "Стражица\,\ В\.\ Търново",
"3597920", "Скриняно",
"3594333", "Дъбово\,\ Ст\.\ Загора",
"3597937", "Ръждавица",
"3593719", "Книжовник",
"359618", "Горна\ Оряховица",
"3598116", "Иваново\,\ Русе",
"3597117", "Градец\,\ София",
"3597439", "Плоски",
"35967396", "Бериево",
"3593647", "Черничево\,\ Кърдж\.",
"359728", "Златица",
"35965617", "Искър\,\ Плевен",
"3599176", "Лесковец\,\ Враца",
"3597123", "Ковачевци\,\ София",
"3596934", "Катунец",
"35961107", "Момин\ сбор",
"3594104", "Кравино",
"35959403", "Речица",
"3595751", "Тервел\,\ Добр\.",
"3597031", "Горна\ Козница",
"3594118", "Памукчии\,\ Ст\.\ Загора",
"3597183", "Душанци",
"3593658", "Падина\,\ Кърдж\.",
"359722", "Самоков",
"3597731", "Трън",
"3597102", "Лопян",
"3593176", "Старосел",
"3597430", "Дамяница",
"3594115", "Кирилово\,\ Ст\.\ Загора",
"3597427", "Първомай\,\ Благ\.",
"35967306", "Градище\,\ Габр\.",
"35995276", "Драганица",
"3595163", "Млада\ гвардия",
"3594799", "Голям\ манастир",
"35931993", "Сърнегор",
"35984735", "Свещари",
"3599553", "Превала",
"3593019", "Писаница",
"3594556", "Сотиря",
"3595343", "Венец\,\ Шумен",
"35974347", "Раздол",
"3599181", "Краводер",
"3595746", "Белгун",
"3597546", "Слащен",
"35931792", "Черничево\,\ Пловдив",
"3596519", "Беглеж",
"35941350", "Мирово\,\ Ст\.\ Загора",
"35991188", "Галатин",
"3597929", "Соволяно",
"3593710", "Узунджово",
"3599719", "Аспарухово\,\ Монт\.",
"35941333", "Средно\ градище",
"3599121", "Царевец\,\ Враца",
"3593198", "Чехларе",
"3595948", "Снягово\,\ Бургас",
"3593724", "Сусам",
"3596711", "Кози\ рог",
"3593626", "Перперек",
"3593145", "Кричим",
"35963203", "Хаджидимитрово\,\ В\.\ Търново",
"3598143", "Обретеник",
"359339", "Стамболийски\,\ Пловдив",
"3599160", "Гложене\,\ Враца",
"3596572", "Сухаче",
"3593072", "Неделино",
"3596129", "Габровци",
"3593784", "Константиново\,\ Хаск\.",
"3599564", "Стубел",
"35935258", "Цар\ Асен\,\ Пазарджик",
"35959409", "Череша",
"35960384", "Гагово",
"3599148", "Бъркачево",
"35930411", "Девин",
"3594132", "Оризово",
"3594768", "Зимница\,\ Ямбол",
"35967395", "Горна\ Росица",
"35974402", "Годлево",
"3594525", "Омарчево\,\ Сливен",
"3595739", "Пчеларово\,\ Добр\.",
"3595775", "Полковник\ Дяково",
"35981886", "Черешово\,\ Русе",
"3593349", "Боянци",
"3599340", "Септемврийци\,\ Видин",
"359596", "Поморие",
"35931403", "Триводици",
"3598664", "Поляна\,\ Силистра",
"3596325", "Козловец",
"3594585", "Жеравна",
"3596902", "Рибарица\,\ Ловеч",
"3596908", "Глогово",
"3597120", "Долна\ баня",
"35984761", "Градина\,\ Разград",
"35937703", "Димитровче",
"3598136", "Стамболово\,\ Русе",
"3597137", "Скравена",
"3595784", "Врачанци",
"3593921", "Меричлери",
"3596914", "Сливек",
"3595169", "Момчилово",
"35961307", "Стамболово\,\ В\.\ Търново",
"3595145", "Гроздьово",
"3597524", "Абланица\,\ Благ\.",
"35947204", "Пчела",
"3595724", "Дропла\,\ Добр\.",
"35984710", "Осенец",
"3594793", "Бояджик",
"35947192", "Завой",
"3594762", "Воденичане",
"3594138", "Гита",
"3595349", "Студеница",
"35984394", "Духовец",
"3596530", "Трънчовица",
"35931388", "Бегунци",
"3596067", "Кралево\,\ Търг\.",
"3599559", "Горна\ Ковачица",
"3599142", "Лазарово",
"3595365", "Лятно",
"3596527", "Одърне",
"3593030", "Широка\ лъка",
"3596513", "Пордим",
"3599787", "Смирненски\,\ Монт\.",
"3593027", "Славейно",
"3593567", "Ковачево\,\ Пазарджик",
"3594330", "Николаево\,\ Ст\.\ Загора",
"3593154", "Чалъкови",
"3597923", "Вратца",
"3596587", "Петокладенци",
"3596134", "Бяла\ черква\,\ В\.\ Търново",
"359751", "Гоце\ Делчев",
"3594327", "Шейново",
"3594716", "Веселиново\,\ Ямбол",
"3597917", "Таваличево",
"3596578", "Реселец",
"35931708", "Песнопой\,\ Пловдив",
"3593775", "Генералово",
"3599316", "Ново\ село\,\ Видин",
"3599727", "Медковец",
"3593192", "Бабек",
"3595942", "Люляково\,\ Бургас",
"3593163", "Искра\,\ Пловдив",
"3594351", "Копринка",
"3598149", "Кацелово",
"3598165", "Смирненски\,\ Русе",
"3596117", "Дебелец\,\ В\.\ Търново",
"3597934", "Буново\,\ Кюст\.",
"3596123", "Буковец\,\ В\.\ Търново",
"35953234", "Златна\ нива",
"3596551", "Тръстеник\,\ Плевен",
"359417", "Раднево",
"3593051", "Чепеларе",
"35969247", "Гостиня",
"35971337", "Калугерово\,\ София",
"3595710", "Победа\,\ Добр\.",
"3594107", "Средец\,\ Ст\.\ Загора",
"35984464", "Веселец\,\ Разград",
"3595336", "Имренчево",
"3597053", "Кочериново",
"3595733", "Кардам\,\ Добр\.",
"3597533", "Осиково\,\ Благ\.",
"35981462", "Волово",
"359973", "Козлодуй",
"3596980", "Беленци",
"35977222", "Горна\ Диканя",
"35941279", "Стрелец\,\ Ст\.\ Загора",
"3593343", "Козаново",
"35961606", "Владислав",
"35991668", "Манастирище",
"359605", "Омуртаг",
"3596937", "Соколово\,\ Ловеч",
"3596920", "Лесидрен",
"3593746", "Сираково\,\ Хаск\.",
"3593644", "Егрек",
"359391", "Димитровград",
"3593523", "Синитево",
"3595315", "Царев\ брод",
"35931402", "Скобелево\,\ Пловдив",
"35984721", "Липник",
"359337", "Хисаря",
"3596023", "Подгорица",
"3596563", "Брест\,\ Плевен",
"3593517", "Лесичово",
"3598132", "Юделник",
"35971306", "Рашково",
"3593583", "Габровица",
"359702", "Бобов\ дол",
"35981266", "Стърмен\,\ Русе",
"3594363", "Габарево",
"35974403", "Долно\ Драглище",
"35931709", "Михилци",
"3593151", "Раковски\,\ Пловдив",
"3597445", "Баня\,\ Благ\.",
"3593924", "Крепост",
"3596911", "Лисец\,\ Ловеч",
"35960370", "Голямо\ градище",
"3593677", "Дрангово\,\ Кърдж\.",
"3594143", "Сърнево\,\ Ст\.\ Загора",
"3596964", "Велчево\,\ Ловеч",
"3595781", "Свобода\,\ Добр\.",
"3599146", "Соколаре",
"35984740", "Бисерци",
"3595119", "Игнатиево",
"3599312", "Брегово\,\ Видин",
"359725", "Елин\ Пелин",
"3593628", "Миладиново",
"35963202", "Драгомирово\,\ В\.\ Търново",
"3594712", "Кабиле",
"3597521", "Копривлен",
"35984737", "Райнино",
"3595760", "Божурово\,\ Добр\.",
"3595589", "Винарско",
"35967397", "Ряховците",
"35941332", "Найденово",
"3595946", "Трънак",
"3593196", "Дрангово\,\ Пловдив",
"3595757", "Безмер\,\ Добр\.",
"3595529", "Крушово\,\ Бургас",
"3597729", "Долна\ Диканя",
"35961106", "Ново\ село\,\ В\.\ Търново",
"3594779", "Ханово",
"3597164", "Реброво",
"3593641", "Крумовград",
"3596953", "Борима",
"35969032", "Български\ извор",
"35943616", "Турия",
"3597548", "Годешево",
"3595748", "Дуранкулак",
"3593933", "Странско",
"3599335", "Цар\ Петрово",
"3593113", "Браниполе",
"35931992", "Пъдарско",
"3596167", "Кесарево",
"3598115", "Червена\ вода",
"3598477", "Самуил",
"3599175", "Остров",
"3599139", "Търнава\,\ Враца",
"3593130", "Каравелово\,\ Пловдив",
"3594354", "Зимница\,\ Ст\.\ Загора",
"3593127", "Царацово",
"3596150", "Златарица",
"3595332", "Драгоево",
"3593054", "Подвис\,\ Смол\.",
"3593178", "Красново",
"3596034", "Славяново\,\ Търг\.",
"3596554", "Крушовене",
"3593534", "Попинци",
"3595910", "Черни\ връх\,\ Бургас",
"3599184", "Оходен",
"3593045", "Доспат",
"3599520", "Горно\ Озирово",
"3593529", "Мокрище",
"3593748", "Лясковец\,\ Хаск\.",
"3597106", "Ямна",
"35951536", "Николаевка",
"3596545", "Любеново\,\ Плевен",
"35961704", "Правда\,\ В\.\ Търново",
"3596029", "Надарево",
"3596569", "Ленково",
"35991189", "Три\ кладенци",
"3599745", "Златия\,\ Монт\.",
"3599124", "Типченица",
"3595338", "Троица",
"35981463", "Могилино",
"3593589", "Церово\,\ Пазарджик",
"3596737", "Крушево\,\ Габр\.",
"3594345", "Радунци",
"3596720", "Керека",
"3593757", "Георги\ Добрево",
"3594369", "Александрово\,\ Ст\.\ Загора",
"3597159", "Априлово\,\ София",
"3595742", "Раковски\,\ Добр\.",
"3598637", "Малък\ Преславец",
"3597734", "Главановци\,\ Перник",
"3595534", "Карагеоргиево",
"3594149", "Трънково\,\ Ст\.\ Загора",
"3594552", "Стара\ река\,\ Сливен",
"3598620", "Силистра",
"35961305", "Лесичери",
"35971228", "Марица",
"3595127", "Манастир\,\ Варна",
"359817", "Бяла\,\ Русе",
"3595130", "Генерал\ Киселово",
"3596352", "Долни\ Луковит",
"35974388", "Горно\ Спанчево",
"35931390", "Московец",
"3594718", "Роза",
"3593076", "Цацаровци",
"3593622", "Стремци",
"3599318", "Буковец\,\ Видин",
"35941174", "Подслон\,\ Ст\.\ Загора",
"35994", "Видин",
"3596576", "Радомирци",
"3594773", "Окоп",
"3598661", "Тутракан",
"35963571", "Брестовец",
"35941111", "Старозагорски\ бани",
"3597723", "Долни\ Раковец",
"3595523", "Крумово\ градище",
"359678", "Тетевен",
"3597717", "Дивотино",
"3595517", "Равнец\,\ Бургас",
"359537", "Нови\ пазар\,\ Шумен",
"3596959", "Дебнево",
"35947193", "Могила\,\ Ямбол",
"3599110", "Вировско",
"3593119", "Гълъбово\,\ Пловдив",
"3596714", "Поповци",
"3593721", "Стамболово\,\ Хаск\.",
"3594136", "Черна\ гора\,\ Ст\.\ Загора",
"359868", "Силистра",
"3599133", "Комарево\,\ Враца",
"3598138", "Бръшлен",
"3599514", "Владимирово\,\ Монт\.",
"3596906", "Черни\ Вит",
"35959408", "Ръжица",
"3593781", "Симеоновград",
"3599561", "Сумер",
"35969245", "Деветаки",
"35937702", "Мустрак",
"3598135", "Бабово",
"3599721", "Долно\ Церовене",
"3596153", "Златарица",
"3597911", "Граница",
"3593133", "Калофер",
"3594321", "Мъглиж",
"3595312", "Дибич",
"3596581", "Бяла\ вода\,\ Плевен",
"3593110", "Поповица",
"3599119", "Тишевица",
"3593561", "Септември",
"3595146", "Горен\ чифлик",
"3596521", "Садовец",
"3596061", "Голямо\ Соколово",
"3593514", "Черногорово\,\ Пазарджик",
"35931998", "Чоба",
"359608", "Попово\,\ Търг\.",
"3595366", "Браничево",
"35984764", "Сейдол",
"35934", "Пазарджик",
"35941489", "Боздуганово",
"3595763", "Плачидол",
"35977229", "Гълъбник",
"35991183", "Фурен",
"3597442", "Якоруда",
"3594715", "Калчево",
"35947201", "Изгрев\,\ Ямбол",
"35961306", "Патреш",
"3596950", "Гумощник",
"35937420", "Подкрепа",
"3593927", "Черногорово\,\ Хаск\.",
"35941338", "Целина",
"3599315", "Градец\,\ Видин",
"359306", "Рудозем",
"3593776", "Райкова\ могила",
"3593674", "Самодива",
"3596967", "Калейца",
"35974322", "Петрово\,\ Благ\.",
"3597167", "Церово\,\ София",
"3598166", "Сваленик",
"3598629", "Смилец\,\ Силистра",
"3594140", "Полски\ Градец",
"3596931", "Угърчин",
"3597034", "Джерман",
"3599332", "Раковица",
"35961607", "Балканци\,\ В\.\ Търново",
"3595139", "Оборище\,\ Варна",
"3594732", "Устрем",
"3594101", "Опан",
"35961395", "Паскалевец",
"35938", "Хасково",
"3595754", "Зърнево",
"3599748", "Дългоделци",
"3595335", "Миланово\,\ Шумен",
"3599172", "Селановци",
"35935419", "Света\ Петка",
"3593057", "Пловдивци",
"3596560", "Крета\,\ Плевен",
"3596020", "Лиляк",
"3595919", "Маринка",
"3594348", "Дунавци\,\ Ст\.\ Загора",
"3593537", "Панагюрски\ колонии",
"3599529", "Боровци",
"3596557", "Брегаре",
"3593520", "Мирянци",
"3596164", "Бряговица",
"3596111", "Къпиново\,\ В\.\ Търново",
"3593124", "Калековец",
"3593745", "Малък\ извор\,\ Хаск\.",
"3596548", "Дебово",
"3593769", "Орешец\,\ Хаск\.",
"3594357", "Горно\ Сахране",
"3599130", "Тлачене",
"3593175", "Дълго\ поле\,\ Пловдив",
"3596542", "Въбел\,\ Плевен",
"3599127", "Лютидол",
"3596159", "Златарица",
"35974346", "Цапарево",
"3599113", "Мраморен",
"35958", "Добрич",
"3593754", "Лозен\,\ Хаск\.",
"3596734", "Петко\ Славейков",
"3594116", "Ракитница\,\ Ст\.\ Загора",
"3593042", "Борино",
"3598118", "Николово\,\ Русе",
"3599187", "Лютаджик",
"3594342", "Овощник",
"359746", "Сандански",
"3599742", "Якимово",
"35993212", "Карбинци",
"3594738", "Хлябово",
"3595580", "Трояново\,\ Бургас",
"3595769", "Хитово",
"35967307", "Млечево",
"3597545", "Кочан",
"3595745", "Вранино",
"3595124", "Комарево\,\ Варна",
"3599338", "Шишенци",
"35995277", "Черкаски",
"3595520", "Черково",
"3597720", "Прибой",
"35974409", "Места",
"35930205", "Стърница",
"35931703", "Житница\,\ Пловдив",
"3598634", "Нова\ Черна",
"3595537", "Съдиево\,\ Бургас",
"3594770", "Генерал\ Инзово",
"3598623", "Голеш\,\ Силистра",
"3593146", "Куртово\ Конаре",
"3593625", "Широко\ поле",
"3594597", "Боров\ дол",
"3597714", "Мещица",
"3597448", "Бачево",
"35961105", "Присово",
"3595133", "Генерал\ Колево\,\ Варна",
"3593691", "Черноочeне",
"35941144", "Калояновец",
"3599517", "Кобиляк",
"3596002", "Съединение\,\ Търг\.",
"3595776", "Черна\,\ Добр\.",
"3599523", "Бързия",
"3594526", "Млекарево",
"3595913", "Крушевец",
"3596723", "Царева\ ливада",
"35954", "Шумен",
"3595318", "Средня",
"3593763", "Българин",
"35930414", "Девин",
"359558", "Айтос",
"3594586", "Нейково\,\ Сливен",
"3596717", "Лесичарка",
"3596326", "Морава",
"3599134", "Търнак",
"3598141", "Две\ могили",
"3594359", "Асен\,\ Ст\.\ Загора",
"3593767", "Браница",
"3595328", "Никола\ Козлево",
"3596713", "Враниловци",
"35957305", "Росица\,\ Добр\.",
"3596727", "Ганчовец",
"35984266", "Просторно",
"3599527", "Вършец",
"3596559", "Гостиля",
"3596142", "Обединение",
"35932", "Пловдив",
"3595917", "Извор\,\ Бургас",
"3594516", "Кермен",
"3593059", "Кутела",
"3596039", "Опака",
"3599513", "Бойчиновци",
"3598696", "Суходол\,\ Силистра",
"35931397", "Христо\ Даново",
"3598678", "Срацимир\,\ Силистра",
"35953436", "Черноглавци",
"35963204", "Деляновци",
"3593322", "Златовръх",
"3595137", "Калоян",
"35931605", "Буково\,\ Пловдив",
"3595120", "Бозвелийско",
"3594593", "Шивачево",
"3594562", "Крива\ круша",
"3594155", "Главан\,\ Ст\.\ Загора",
"35963566", "Бръшляница",
"3596998", "Голям\ извор\,\ Ловеч",
"3597145", "Мирово\,\ София",
"3598627", "Бабук",
"3597724", "Извор\,\ Перник",
"3595524", "Екзарх\ Антимово",
"3598630", "Силистра",
"35960383", "Берковски",
"3594774", "Крумово\,\ Ямбол",
"3597169", "Томпсън",
"3596969", "Беклемето",
"359953", "Берковица",
"3597733", "Филиповци",
"3595533", "Пирне",
"3593929", "Голямо\ Асеново",
"35984768", "Синя\ вода",
"3595161", "Ветрино",
"3595108", "Садово\,\ Варна",
"35941334", "Съединение\,\ Ст\.\ Загора",
"3595114", "Езерово\,\ Варна",
"3593632", "Джебел",
"3596046", "Врани\ кон",
"3598128", "Полско\ Косово",
"3595341", "Хитрино",
"3599551", "Георги\ Дамяново",
"35984729", "Езерче",
"359518", "Провадия",
"3599183", "Лиляче",
"3599117", "Криводол",
"35931701", "Кръстевич",
"3594126", "Хрищени",
"3593102", "Караджово",
"3599123", "Роман",
"3597176", "Храбърско",
"3599356", "Каленик\,\ Видин",
"35969616", "Старо\ село\,\ Ловеч",
"359454", "Твърдица\,\ Сливен",
"3594353", "Средногорово",
"3593108", "Бойково",
"3594756", "Поляна\,\ Ямбол",
"3593114", "Брестник",
"3596121", "Никюп",
"35984463", "Прелез",
"35930418", "Буйново\,\ Смол\.",
"3593533", "Бъта",
"3596553", "Оряховица\,\ Плевен",
"35935251", "Братаница",
"3593510", "Овчеполци",
"3596033", "Медовина",
"3593053", "Хвойна",
"3598122", "Ценово\,\ Русе",
"3593638", "Звездел",
"35967390", "Шумата",
"359726", "Своге",
"3597531", "Долно\ Дряново",
"3595731", "Генерал\ Тошево\,\ Добр\.",
"3595102", "Падина\,\ Варна",
"3593934", "Скобелево\,\ Хаск\.",
"3596954", "Врабево",
"3594599", "Червенаково",
"3593341", "Конуш\,\ Пловдив",
"35941119", "Елхово\,\ Ст\.\ Загора",
"3597163", "Искрец",
"3597192", "Гинци",
"359318", "Съединение\,\ Пловдив",
"35963579", "Ралево",
"3595539", "Черноград",
"35952", "Варна",
"3595575", "Прилеп\,\ Бургас",
"35960377", "Априлово\,\ Търг\.",
"3594144", "Ковачево\,\ Ст\.\ Загора",
"3596963", "Балканец",
"359601", "Търговище",
"3596992", "Златна\ Панега",
"3594725", "Лесово",
"3597154", "Столник",
"35984393", "Вазово",
"3599325", "Бело\ поле\,\ Видин",
"3593923", "Радиево",
"3597030", "Ресилово",
"3595767", "Житница\,\ Добр\.",
"3593328", "Долнослав",
"35941172", "Горно\ Ботево",
"3598672", "Брадвари",
"35984730", "Голям\ Поровец",
"3595750", "Каблешково\,\ Добр\.",
"3596024", "Руец",
"3596564", "Загражден\,\ Плевен",
"3599189", "Паволче",
"35937704", "Младиново",
"35941355", "Яворово",
"3596148", "Павел",
"3596511", "Победа\,\ Плевен",
"3593524", "Априлци\,\ Пазарджик",
"3597921", "Жиленци",
"3594364", "Осетеново",
"3596157", "Сливовица",
"3599129", "Синьо\ бърдо",
"3593120", "Храбрино",
"3593137", "Клисура\,\ Пловдив",
"3593584", "Ветрен\,\ Пазарджик",
"35947203", "Трънково\,\ Ямбол",
"3599180", "Голямо\ Пещене",
"35969615", "Балабанско",
"3595914", "Атия",
"359745", "Петрич\,\ Благ\.",
"3599524", "Ягодово\,\ Монт\.",
"359861", "Силистра",
"3593129", "Скутаре",
"3596072", "Добротица\,\ Търг\.",
"3593764", "Поляново\,\ Хаск\.",
"3593666", "Попско",
"3599137", "Попица",
"35941113", "Пряпорец\,\ Ст\.\ Загора",
"3596169", "Благоево\,\ В\.\ Търново",
"359470", "Тополовград",
"3596145", "Страхилово",
"3593711", "Долно\ Ботево",
"3596724", "Янтра\,\ Габр\.",
"35963573", "Дисевица",
"35930457", "Късак",
"3597713", "Рударци",
"3595513", "Габър",
"35961403", "Орловец",
"3593325", "Червен\,\ Пловдив",
"35971798", "Василовци\,Соф\.",
"3594777", "Тенево",
"3595530", "Пещерско",
"3598624", "Калипетрово",
"35984469", "Божурово\,\ Разград",
"3595527", "Соколово\,\ Бургас",
"3597727", "Ковачевци\,\ Перник",
"3595578", "Терзийско\,\ Бургас",
"3595759", "Кочмар",
"3597142", "Костенец",
"3594728", "Мелница",
"3594152", "Обручище",
"3597039", "Самораново",
"35941274", "Самуилово\,\ Ст\.\ Загора",
"3595134", "Червенци",
"3599328", "Долни\ Лом",
"3595123", "Равна\,\ Варна",
"35977221", "Кондофрей",
"3596942", "Александрово\,\ Ловеч",
"3595117", "Ботево\,\ Варна",
"3598633", "Старо\ село\,\ Силистра",
"35974324", "Струма",
"3594741", "Болярово",
"3593679", "Кирково",
"3595551", "Средец\,\ Бургас",
"35981461", "Каран\ Върбовка",
"3597751", "Брезник",
"3596176", "Поликраище",
"35971471", "Очуша",
"3599341", "Димово\,\ Видин",
"3596733", "Кормянско",
"3593753", "Оряхово\,\ Хаск\.",
"3596710", "Донино",
"3599161", "Мизия",
"35941356", "Рупките",
"3593519", "Величково\,\ Пазарджик",
"3593105", "Манолско\ Конаре",
"3597046", "Бобошево",
"3598185", "Сеново",
"35957306", "Изворово\,\ Добр\.",
"3596531", "Изгрев\,\ Плевен",
"3598125", "Копривец",
"3598646", "Вокил",
"3593123", "Калояново\,\ Пловдив",
"3593117", "Катуница",
"3594331", "Гурково\,\ Ст\.\ Загора",
"3596163", "Камен\,\ В\.\ Търново",
"35959404", "Ясеново\,\ Бургас",
"35960389", "Кардам\,\ Търг\.",
"35931791", "Бегово",
"3593920", "Златополе",
"3596957", "Голяма\ Желязна",
"3595105", "Приселци\,\ Варна",
"35953435", "Изгрев\,\ Шумен",
"3597719", "Ярджиловци",
"3595519", "Зидарово",
"35941178", "Оряховица\,\ Ст\.\ Загора",
"3593937", "Ябълково\,\ Хаск\.",
"3596960", "Белиш",
"35931606", "Воден\,\ Пловдив",
"3595753", "Орляк",
"35963565", "Мечка\,\ Плевен",
"3596948", "Кърпачево",
"3597181", "Пирдоп",
"3599546", "Славотин",
"35953220", "Памукчии\,\ Шумен",
"3597033", "Крайници",
"3599322", "Орешец\,\ Видин",
"3595764", "Владимирово\,\ Добр\.",
"35984723", "Дянково",
"3596981", "Петревене",
"3594158", "Искрица",
"3595129", "Блъсково",
"3595711", "Овчарово\,\ Добр\.",
"3594722", "Гранитово\,\ Ямбол",
"3593706", "Тънково\,\ Хаск\.",
"3597148", "Мухово",
"3595572", "Бероново",
"3593673", "Тихомир",
"3594147", "Любеново\,\ Ст\.\ Загора",
"35974401", "Горно\ Драглище",
"3598639", "Коларово\,\ Силистра",
"3598675", "Айдемир",
"3596921", "Абланица\,\ Ловеч",
"3598156", "Червен\,\ Русе",
"35971224", "Шипочане",
"3597157", "Саранци",
"3593759", "Бориславци",
"359701", "Дупница",
"3594367", "Тъжа",
"3594350", "Горно\ Изворово",
"3593587", "Сестримо",
"3593134", "Сопот\,\ Пловдив",
"3595391", "Върбица\,\ Шумен",
"3596154", "Буйновци",
"35930412", "Девин",
"35955505", "Драчево",
"3595325", "Войвода",
"3593050", "Букова\ поляна",
"3596567", "Сомовит",
"3596027", "Дралфа",
"3596030", "Светлен\,\ Търг\.",
"3593513", "Мало\ Конаре",
"3593527", "Алеко\ Константиново",
"3596550", "Ставерци",
"3593530", "Поибрене",
"35992", "Враца",
"35936700", "Шопци",
"35935391", "Блатница",
"3593107", "Граф\ Игнатиево",
"35951103", "Любен\ Каравелово",
"3596543", "Муселиево",
"35996", "Монтана",
"3599112", "Баница",
"35931602", "Татарево\,\ Пловдив",
"3593043", "Змеица",
"3595319", "Друмево",
"35931309", "Климент\,\ Пловдив",
"3599346", "Синаговци",
"3595556", "Голямо\ Буково",
"35941480", "Коларово\,\ Ст\.\ Загора",
"3594343", "Конаре\,\ Ст\.\ Загора",
"359749", "Банско",
"35967301", "Идилево",
"3594746", "Попово\,\ Ямбол",
"35984779", "Здравец\,\ Разград",
"3599166", "Хайредин",
"3593637", "Груево",
"3596944", "Крушуна",
"35951314", "Войводино",
"359848", "Кубрат",
"3597041", "Шатрово",
"3595115", "Генерал\ Кантарджиево",
"3598622", "Алеково\,\ Силистра",
"35960387", "Глогинка",
"35930416", "Гьоврен",
"3594567", "Баня\,\ Сливен",
"3595740", "Горичане",
"3593327", "Бачково",
"3595132", "Михалич\,\ Варна",
"3595768", "Одринци\,\ Добр\.",
"3599339", "Макреш",
"3594154", "Медникарово",
"3595525", "Деветак",
"3597725", "Кленовик",
"3597144", "Костенец",
"3593661", "Ивайловград",
"35931393", "Войнягово",
"3594739", "Радовец",
"3594775", "Каравелово\,\ Ямбол",
"3599135", "Бърдарски\ геран",
"3596003", "Преселец",
"35941146", "Християново",
"3596147", "Иванча\,\ В\.\ Търново",
"3599522", "Котеновци",
"35960454", "Змейно",
"3597436", "Левуново",
"3595912", "Полски\ извор",
"3596722", "Соколово\,\ Габр\.",
"3593762", "Изворово\,\ Хаск\.",
"3593138", "Ведраре",
"3596158", "Средни\ колиби",
"35984712", "Костанденец",
"3596074", "Любичево",
"3596152", "Беброво",
"3596549", "Санадиново",
"3595330", "Златар",
"3596025", "Алваново",
"3596565", "Милковица",
"3595327", "Каспичан\,\ Шумен",
"3595716", "Паскалево",
"3593132", "Баня\,\ Пловдив",
"35961304", "Димча",
"3593701", "Елена\,\ Хаск\.",
"3593768", "Доситеево",
"3595313", "Мадара",
"3596986", "Дъбен",
"3593049", "Беден",
"3596728", "Буря",
"3595918", "Русокастро",
"3598151", "Просена",
"35971503", "Долно\ Камарци",
"3599528", "Гаганица",
"35984766", "Каменар\,\ Разград",
"359860", "Силистра",
"3593740", "Пчелари",
"3599749", "Черни\ връх\,\ Монт\.",
"3596926", "Горно\ Павликене",
"3593585", "Аканджиево",
"3595396", "Ловец\,\ Шумен",
"3595574", "Съединение\,\ Бургас",
"3598677", "Сребърна",
"3594724", "Раздел\,\ Ямбол",
"359670", "Троян\,\ Ловеч",
"3594145", "Знаменосец",
"35984743", "Брестовене",
"3597155", "Лесново",
"3595762", "Стефан\ Караджа\,\ Добр\.",
"3599324", "Ружинци",
"3595138", "Добротич",
"359659", "Червен\ бряг",
"359309", "Пампорово",
"35960373", "Посабина",
"35961705", "Горски\ долен\ Тръмбеш",
"3598628", "Цар\ Асен\,\ Силистра",
"3596997", "Добревци\,\ Ловеч",
"3593556", "Радилово",
"3598196", "Нисово",
"3596536", "Аспарухово\,\ Плевен",
"35941352", "Винарово\,\ Ст\.\ Загора",
"35969244", "Тепава",
"3593036", "Могилица",
"3593935", "Върбица\,\ Хаск\.",
"3599333", "Бойница",
"3594710", "Болярско",
"3594336", "Долно\ Изворово",
"3596955", "Дълбок\ дол",
"3594733", "Орлов\ дол",
"3598641", "Окорш",
"359517", "Дългопол",
"3599173", "Галово",
"3596590", "Ракита\,\ Плевен",
"3598127", "Караманово",
"3597126", "Горни\ Окол",
"35953221", "Стоян\ Михайловски",
"3598113", "Ново\ село\,\ Русе",
"3593115", "Куклен",
"35963568", "Буковлък",
"3595351", "Смядово",
"3598187", "Тетово",
"3597186", "Антон",
"3599541", "Доктор\ Йосифово",
"35984467", "Сеслав",
"35930459", "Бръщен",
"35941175", "Колена",
"35935502", "Фотиново\,\ Пазарджик",
"35984718", "Дряновец\,\ Разград",
"3599115", "Чирен",
"35991201", "Люти\ брод",
"35984749", "Севар",
"3593173", "Паничери",
"3593104", "Ягодово\,\ Пловдив",
"35984765", "Веселина",
"3595166", "Доброплодно",
"359416", "Чирпан",
"3593118", "Садово\,\ Пловдив",
"35941019", "Венец\,\ Ст\.\ Загора",
"3595743", "Шабла",
"35931700", "Беловица",
"35969612", "Терзийско\,\ Ловеч",
"3596958", "Априлци\,\ Ловеч",
"3599556", "Говежда",
"35974204", "Гега",
"3594553", "Раково\,\ Сливен",
"3595346", "Каменяк\,\ Шумен",
"3599319", "Гъмзово",
"3593634", "Припек\,\ Кърдж\.",
"3594121", "Люляк",
"35956", "Бургас",
"3595112", "Белослав",
"35961706", "Писарево\,\ В\.\ Търново",
"359379", "Свиленград",
"3594157", "Разделна\,\ Ст\.\ Загора",
"35951428", "Господиново\,\ Варна",
"3593324", "Избеглии",
"3593623", "Бойно",
"3597147", "Пчелин\,\ София",
"3598625", "Овен",
"35937603", "Рогозиново",
"3594772", "Симеоново\,\ Ямбол",
"3598691", "Силистра",
"359350", "Пещера\,\ Пазарджик",
"3595522", "Искра\,\ Бургас",
"3594511", "Сливенски\ минерални\ бани",
"3597158", "Доганово",
"35957308", "Чернооково\,\ Добр\.",
"3594564", "Новоселец",
"3595135", "Стефан\ Караджа\,\ Варна",
"3595915", "Българово",
"35941117", "Казанка",
"3593040", "Триград",
"359331", "Асеновград",
"3599525", "Долно\ Озирово",
"35963577", "Пелишат",
"3594368", "Търничени",
"3596540", "Асеново\,\ Плевен",
"3596077", "Стеврек",
"35961394", "Дъскот",
"3599132", "Кнежа",
"3593588", "Мененкьово",
"3593749", "Гарваново",
"3599740", "Септемврийци\,\ Монт\.",
"3596568", "Дъбован",
"3596028", "Вардун",
"3593765", "Иваново\,\ Хаск\.",
"3594340", "Паничерево",
"3593528", "Говедаре",
"3596725", "Гостилица",
"3596144", "Долна\ Липница",
"3593522", "Гелеменово",
"359550", "Созопол",
"3593135", "Кърнаре",
"3596562", "Гиген",
"3596022", "Пробуда\,\ Търг\.",
"3596155", "Константин",
"35947353", "Българска\ поляна",
"3598133", "Ряхово",
"35963562", "Комарево\,\ Плевен",
"3593582", "Момина\ клисура",
"3595324", "Хърсово\,\ Шумен",
"3599138", "Алтимир",
"3594796", "Генерал\ Тошево\,\ Ямбол",
"359579", "Албена",
"3594362", "Манолово",
"3596516", "Искър\,\ Плевен",
"3595765", "Ловчанци",
"35971304", "Липница\,\ София",
"3597549", "Долен\,\ Благ\.",
"35981264", "Пиперково",
"3595749", "Крапец\,\ Добр\.",
"3597152", "Горна\ Малина",
"3597728", "Друган",
"3595528", "Невестино\,\ Бургас",
"3596994", "Брестница\,\ Ловеч",
"3594142", "Трояново\,\ Ст\.\ Загора",
"35984", "Разград",
"3594778", "Победа\,\ Ямбол",
"35937423", "Големанци",
"3594727", "Малък\ манастир",
"3599313", "Капитановци",
"35961503", "Чакали",
"3598674", "Професор\ Иширково",
"35991180", "Лесура",
"3595577", "Подвис\,\ Бургас",
"3594730", "Княжево",
"35941358", "Опълченец",
"3599327", "Чупрене",
"3596359", "Глава",
"3594713", "Стара\ река\,\ Ямбол",
"3597926", "Коняво",
"35984727", "Каменово\,\ Разград",
"3599330", "Раброво",
"3596126", "Церова\ кория",
"3594751", "Войника",
"3593166", "Бяла\ река\,\ Пловдив",
"3597741", "Земен",
"35930415", "Девин",
"3595118", "Водица\,\ Варна",
"3599351", "Извор\,\ Видин",
"3593629", "Мост",
"35955502", "Суходол\,\ Бургас",
"35930256", "Гълъбово\,\ Смол\.",
"3596952", "Орешак\,\ Ловеч",
"3593932", "Бодрово",
"3595736", "Василево",
"3593112", "Марково\,\ Пловдив",
"35961104", "Водолей",
"3598184", "Глоджево",
"3595310", "Радко\ Димитриево",
"35941145", "Арнаутито",
"3595333", "Хан\ Крум",
"3597056", "Мурсалево",
"35967391", "Столът",
"3598124", "Новград",
"3593743", "Силен",
"3593346", "Мулдава",
"3598114", "Пиргово",
"3596770", "Плачковци",
"3594355", "Бузовград",
"3599174", "Горни\ Вадин",
"3593747", "Татарево\,\ Хаск\.",
"3598161", "Ветово",
"3593055", "Елховец",
"3595320", "Пет\ могили\,\ Шумен",
"3596035", "Паламарца",
"3594106", "Пъстрен",
"3595337", "Кочово",
"3593122", "Маноле",
"35963205", "Червена",
"3593758", "Йерусалимово",
"35974386", "Пирин",
"3596555", "Байкал",
"3593535", "Левски\,\ Пазарджик",
"35931604", "Драгойново",
"3596738", "Добромирка",
"3596990", "Малък\ извор\,\ Ловеч",
"3598638", "Богданци\,\ Силистра",
"35959406", "Разбойна\,\ Бургас",
"3597149", "Живково\,\ София",
"3595752", "Нова\ Камена",
"3597165", "Миланово\,\ София",
"3596116", "Големаните",
"3598670", "Силистра",
"3594734", "Срем",
"35957304", "Дъбовик",
"3597032", "Яхиново",
"35967393", "Душево",
"3595128", "Житница\,\ Варна",
"3599323", "Дреновец",
"3593925", "Крум",
"3597444", "Белица\,\ Благ\.",
"3595100", "Синдел",
"3594717", "Чарган",
"3594326", "Енина",
"3596586", "Белене",
"35984733", "Лудогорци",
"35931995", "Стрелци\,\ Пловдив",
"3596965", "Бели\ Осъм",
"3597916", "Багренци",
"3594723", "Бояново\,\ Ямбол",
"3599317", "Арчар",
"3599726", "Замфир",
"3595573", "Везенково",
"359677", "Трявна",
"3593672", "Чорбаджийско",
"35951538", "Изгрев\,\ Варна",
"359538", "Велики\ Преслав",
"3596526", "Върбица\,\ Плевен",
"3596066", "Буйново\,\ Търг\.",
"3595518", "Рудник\,\ Бургас",
"3597718", "Драгичево",
"3593026", "Смилян",
"3593566", "Бошуля",
"3595141", "Старо\ Оряхово",
"35974407", "Кремен\,\ Благ\.",
"35937421", "Долно\ поле",
"35941335", "Могилово",
"3595314", "Белокопитово",
"3595361", "Каолиново",
"3593512", "Хаджиево",
"3597136", "Новачене\,\ София",
"3598137", "Голямо\ Враново",
"35967309", "Агатово",
"35959694", "Габерово",
"35941276", "Могила\,\ Ст\.\ Загора",
"3593518", "Драгор",
"35961108", "Плаково",
"3596004", "Маково",
"359707", "Сапарева\ баня",
"35961302", "Батак\,\ В\.\ Търново",
"3599515", "Мадан\,\ Монт\.",
"3593696", "Пчеларово\,\ Кърдж\.",
"35951127", "Разделна\,\ Варна",
"3593100", "Белащица",
"35982", "Русе",
"3597712", "Батановци",
"35960380", "Дриново",
"359724", "Ихтиман",
"3595771", "Крушари",
"3593678", "Чакаларово",
"3596321", "Горна\ Студена",
"3597143", "Вакарел",
"3594153", "Мъдрец\,\ Ст\.\ Загора",
"3594595", "Сборище",
"3595122", "Славейково\,\ Варна",
"3593651", "Ардино",
"3593320", "Орешец\,\ Пловдив",
"3599329", "Рабиша",
"3596943", "Горско\ Сливово",
"3595535", "Лясково\,\ Бургас",
"3597735", "Лева\ река",
"3595579", "Ведрово",
"35991203", "Лик",
"3595758", "Кладенци",
"3594729", "Кирилово\,\ Ямбол",
"35981268", "Кривина\,\ Русе",
"3598632", "Зафирово",
"3594557", "Биково",
"35969242", "Пресяка",
"35937705", "Пъстрогор",
"3595747", "Ваклино",
"3597547", "Вълкосел",
"35936402", "Горна\ кула",
"35941354", "Малко\ Тръново",
"3593044", "Лясково\,\ Смол\.",
"3599185", "Бели\ Извор",
"3596732", "Сенник",
"3596168", "Сушица\,\ В\.\ Търново",
"3593752", "Малко\ градище",
"3596544", "Новачене\,\ Плевен",
"3593128", "Златитрап",
"3599125", "Горна\ Бешовица",
"3599744", "Вълчедръм",
"3593177", "Ново\ Железаре",
"35971587", "Голема\ Раковица",
"3594344", "Шаново",
"3597426", "Марикостиново",
"3595334", "Осмар",
"3599128", "Елисейна",
"3595941", "Скалак\,\ Бургас",
"3593191", "Брезово\,\ Пловдив",
"3594352", "Горно\ Черковище",
"35960458", "Веренци",
"35941275", "Лясково\,\ Ст\.\ Загора",
"3599188", "Горно\ Пещене",
"3597116", "Петърч",
"3596165", "Асеново\,\ В\.\ Търново",
"3593532", "Стрелча",
"3598117", "Мартен",
"3598475", "Лозница\,\ Разград",
"3596552", "Долна\ Митрополия",
"3596149", "Куцина",
"3593744", "Сърница\,\ Хаск\.",
"3596032", "Зараево",
"3593125", "Ръжево\ Конаре",
"3593646", "Токачка",
"3593052", "Лъки\,\ Пловдив",
"3598123", "Босилковци",
"3595570", "Манолич",
"3594737", "Синапово",
"35971398", "Осиковица",
"35953223", "Църквица",
"359619", "Лясковец\,\ В\.\ Търново",
"3599337", "Грамада",
"359910", "Мездра",
"35961603", "Лозен\,\ В\.\ Търново",
"359729", "Годеч",
"3597936", "Слокощица",
"3599320", "Стакевци",
"35935257", "Сарая",
"35969614", "Горно\ трапе",
"3597035", "Червен\ брег",
"3595538", "Караново\,\ Бургас",
"3597162", "Лакатник",
"3597193", "Голеш\,\ София",
"35974202", "Ключ",
"3595755", "Коларци",
"3596962", "Черни\ Осъм",
"359590", "Царево",
"3593922", "Брод",
"35974348", "Игралище",
"3596136", "Сухиндол",
"3594714", "Дражево",
"3593156", "Шишманци",
"3597447", "Добринище",
"3594761", "Стралджа",
"3599314", "Дунавци\,\ Видин",
"35967193", "Кметовци",
"35937706", "Чернодъб",
"3598673", "Алфатар",
"35984720", "Топчии",
"3593675", "Фотиново\,\ Кърдж\.",
"3593639", "Нановица\,\ Кърдж\.",
"3599518", "Мърчево",
"3598134", "Малко\ Враново",
"359478", "Елхово\,\ Ямбол",
"3599141", "Малорад",
"35974325", "Лиляново",
"359938", "Кула",
"3596916", "Брестово\,\ Ловеч",
"3597526", "Рибново",
"3595726", "Царичино",
"3595317", "Ивански",
"359777", "Радомир",
"3593515", "Калугерово\,\ Пазарджик",
"3596718", "Драгановци",
"3595323", "Плиска",
"3593109", "Лилково",
"35941110", "Старозагорски\ бани",
"3596571", "Лепица",
"35963564", "Биволаре",
"359361", "Кърджали",
"3596712", "Гъбене",
"35963570", "Староселци",
"3593071", "Златоград",
"3596143", "Масларево",
"35953434", "Ясенково",
"3598129", "Лом\ Черковна",
"35967399", "Малки\ Вършец",
"3598666", "Тутракан",
"3599512", "Бели\ брег",
"3596007", "Ралица",
"359357", "Панагюрище",
"3593726", "Клокотница",
"3593624", "Чифлик\,\ Кърдж\.",
"35971338", "Осиковска\ Лакавица",
"35969248", "Скобелево\,\ Ловеч",
"3593323", "Болярци\,\ Пловдив",
"35959405", "Зайчар",
"3595515", "Камено",
"3597715", "Студена\,\ Перник",
"3593928", "Долно\ Белево",
"35981262", "Бистренци",
"3594592", "Бяла\ паланка",
"3593786", "Навъсен",
"35971302", "Боженица",
"3596968", "Добродан",
"3596901", "Гложене\,\ Ловеч",
"35931707", "Черноземен",
"35955504", "Богданово\,\ Бургас",
"3594554", "Трапоклово",
"3597168", "Бов",
"35931996", "Свежен",
"3597732", "Вукан",
"3595532", "Тополица",
"35935393", "Смилец\,\ Пазарджик",
"3595125", "Градинарово",
"3597544", "Осина",
"35967303", "Батошево",
"35931387", "Пролом",
"3593633", "Рогозче",
"3598635", "Цар\ Самуил",
"3598679", "Кайнарджа",
"3593174", "Старо\ Железаре",
"35941336", "Яздач",
"3593058", "Мугла",
"3599747", "Мокреш\,\ Монт\.",
"3598424", "Цар\ Калоян\,\ Разград",
"3593755", "Белица\,\ Хаск\.",
"3596558", "Славовица\,\ Плевен",
"35971225", "Ново\ село\,\ София",
"3593538", "Елшица",
"3599182", "Девене",
"35961308", "Вишовград",
"3594347", "Розово\,\ Ст\.\ Загора",
"35961102", "Пчелище",
"3593103", "Милево",
"3594358", "Скобелево\,\ Ст\.\ Загора",
"3595329", "Мировци",
"3596547", "Драгаш\ войвода",
"3599122", "Зверино",
"35961393", "Горско\ Косово",
"3597528", "Хаджидимово",
"35969249", "Дойренци",
"35930410", "Брезе\,\ Смол\.",
"3596716", "Жълтеш",
"3596327", "Овча\ могила",
"3594134", "Братя\ Даскалови",
"3594587", "Ябланово",
"35935255", "Росен\,\ Пазарджик",
"3594513", "Гавраилово",
"3593695", "Комунига",
"3599516", "Лехчево",
"3598693", "Звенимир",
"3598662", "Добротица\,\ Силистра",
"35936702", "Горски\ извор\,\ Кърдж\.",
"3596918", "Дренов",
"3594527", "Загорци\,\ Сливен",
"3598448", "Тертер",
"3593074", "Ерма\ река",
"35937604", "Върбово\,\ Хаск\.",
"3596138", "Недан",
"35941277", "Загоре",
"3596574", "Чомаковци",
"359750", "Боровец\,\ София",
"3593722", "Минерални\ бани\,\ Хаск\.",
"359570", "Каварна",
"3593147", "Ново\ село\,\ Пловдив",
"359559", "Карнобат",
"35967398", "Дамяново",
"3593782", "Калугерово\,\ Хаск\.",
"35974203", "Рупите",
"35984738", "Китанчево",
"35974327", "Ново\ Делчево",
"35981466", "Помен",
"3595536", "Мъглен",
"359453", "Котел",
"35961309", "Горско\ Калугерово",
"3596043", "Долно\ Новково",
"35961602", "Царски\ извор",
"35977226", "Дебели\ лаг",
"3593543", "Дорково",
"3597938", "Долно\ Уйно",
"359335", "Карлово",
"35953222", "Марково\,\ Шумен",
"3597118", "Драговищица\,\ София",
"359727", "Сливница\,\ София",
"3597541", "Сатовча",
"3599186", "Згориград",
"3594551", "Бяла\,\ Сливен",
"3595590", "Житосвят",
"3593648", "Голямо\ Каменяне",
"3597104", "Лъга",
"3594123", "Богомилово",
"35991185", "Пудрия",
"3599126", "Камено\ поле",
"3593657", "Жълтуша",
"3597425", "Кулата",
"35941351", "Партизанин",
"3594753", "Зорница\,\ Ямбол",
"3599353", "Кошава",
"35961103", "Русаля",
"3597743", "Дивля",
"3596935", "Сопот\,\ Ловеч",
"35959407", "Сини\ рид",
"3594356", "Хаджидимитрово\,\ Ст\.\ Загора",
"35975214", "Гайтаниново",
"3598699", "Търновци\,\ Силистра",
"3596036", "Садина",
"3594105", "Бяло\ поле",
"3593642", "Поточница",
"3593056", "Чепинци\,\ Смол\.",
"3594519", "Самуилово\,\ Сливен",
"35976", "Перник",
"3593536", "Баня\,\ Пазарджик",
"3596556", "Горна\ Митрополия",
"3597932", "Шипочано",
"35967302", "Кръвеник",
"35974495", "Юруково",
"3593194", "Зелениково\,\ Пловдив",
"3595944", "Руен\,\ Бургас",
"3593700", "Тракиец",
"3598167", "Церовец",
"3593741", "Мандра",
"3596115", "Ресен",
"3597166", "Владо\ Тричков",
"35935392", "Дюлево\,\ Пазарджик",
"3598150", "Семерджиево",
"35974406", "Добърско",
"3599568", "Благово\,\ Монт\.",
"3596585", "Белене",
"3594325", "Кънчево",
"35937424", "Козлец",
"3593926", "Добрич\,\ Хаск\.",
"3598131", "Борисово\,\ Русе",
"3599725", "Комощица",
"3599144", "Нивянин",
"35984711", "Мортагоново",
"35971227", "Бели\ Искър",
"3593777", "Мезек",
"3596591", "Горник",
"3597915", "Невестино\,\ Кюст\.",
"3596966", "Шипково",
"3596525", "Бъркач",
"3595367", "Тодор\ Икономово",
"3596065", "Бистра\,\ Търг\.",
"3593728", "Славяново\,\ Хаск\.",
"35984760", "Трапище",
"3596049", "Камбурово",
"35984774", "Голям\ извор\,\ Разград",
"3599785", "Василовци\,\ Монт\.",
"3596132", "Караисен",
"3593025", "Баните",
"3593549", "Грашево",
"3599540", "Белотинци",
"3598442", "Завет\,\ Разград",
"35931705", "Горна\ махала",
"3595147", "Пчелник\,\ Варна",
"35947354", "Каменна\ река",
"3596912", "Баховица",
"3598668", "Попина",
"3595782", "Бенковски\,\ Добр\.",
"359359", "Велинград",
"3599311", "Кутово",
"3594764", "Маленово",
"3597179", "Големо\ Малово",
"3597135", "Трудовец",
"3594129", "Маджерито",
"3598640", "Правда\,\ Силистра",
"3597522", "Дъбница",
"3594711", "Безмер\,\ Ямбол",
"3597138", "Литаково",
"35960453", "Моравка",
"3596907", "Градежница",
"3594524", "Каменово\,\ Сливен",
"359650", "Левски\,\ Плевен",
"3595774", "Коритен",
"3594584", "Тича",
"3594137", "Верен",
"3596324", "Вардим",
"3598665", "Искра\,\ Силистра",
"3598649", "Яребица",
"35965165", "Писарово\,\ Плевен",
"3596528", "Вълчитрън",
"3596068", "Божурка",
"3596001", "Черковна\,\ Търг\.",
"35963561", "Гривица",
"3593725", "Стамболийски\,\ Хаск\.",
"3593028", "Арда",
"3593568", "Виноградец",
"35974496", "Филипово\,\ Благ\.",
"3595516", "Индже\ войвода",
"35961109", "Въглевци",
"35961608", "Горски\ Сеновец",
"3593785", "Дряново\,\ Хаск\.",
"35931394", "Васил\ Левски\,\ Пловдив",
"359697", "Луковит",
"3596588", "Деков",
"3599549", "Долна\ Рикса",
"3593077", "Средец\,\ Смол\.",
"359631", "Свищов",
"3599728", "Сливата",
"35984732", "Йонково",
"3596577", "Бресте",
"3597918", "Ябълково\,\ Кюст\.",
"35967392", "Яворец",
"3596541", "Никопол",
"3596118", "Вонеща\ вода",
"35974405", "Краище\,\ Благ\.",
"35941337", "Сърневец",
"3593709", "Караманци",
"3592", "София",
"3595126", "Черковна\,\ Варна",
"3596173", "Долна\ Оряховица",
"3595952", "Малко\ Търново",
"3594341", "Черганово",
"3598159", "Кошов",
"3598636", "Главиница\,\ Силистра",
"3599741", "Долни\ Цибър",
"359418", "Гълъбово\,\ Ст\.\ Загора",
"35931706", "Сухозем",
"3594108", "Васил\ Левски\,\ Ст\.\ Загора",
"35931997", "Златосел",
"3596736", "Градница\,\ Габр\.",
"35951104", "Долище\,\ Варна",
"3593756", "Вълче\ поле",
"3597422", "Тополница\,\ Благ\.",
"3597043", "Големо\ село",
"3598690", "Силистра",
"3596938", "Каленик\,\ Ловеч",
"3594510", "Желю\ войвода",
"3596932", "Микре",
"3595599", "Хаджиите",
"3597428", "Габрене",
"35935256", "Сбор\,\ Пазарджик",
"3596166", "Виноград",
"3598643", "Златоклас",
"3593126", "Труд",
"3593645", "Аврен\,\ Кърдж\.",
"3594102", "Ястребово\,\ Ст\.\ Загора",
"3599171", "Оряхово\,\ Враца",
"35969243", "Казачево",
"3598164", "Писанец",
"3597935", "Долно\ село",
"3595958", "Граматиково",
"3598111", "Щръклево",
"35935501", "Равногор",
"35991202", "Кунино",
"359554", "Слънчев\ бряг",
"3597036", "Баланово",
"35951125", "Константиново\,\ Варна",
"3595353", "Веселиново\,\ Шумен",
"3595947", "Просеник",
"3593197", "Тюркмен",
"3595756", "Божан",
"35966", "Габрово",
"3596112", "Самоводене",
"3593703", "Жълти\ бряг",
"3597912", "Горна\ Гращица",
"35984744", "Беловец",
"3599722", "Сталийска\ махала",
"3595311", "Градище\,\ Шумен",
"3596582", "Белене",
"3594322", "Ягода",
"35981465", "Батин",
"3593155", "Момино\ село",
"35960374", "Горско\ Абланово",
"3598445", "Юпер",
"3599782", "Буковец\,\ Монт\.",
"35967308", "Ловнидол",
"3596179", "Крушето",
"3593022", "Виево",
"3596135", "Върбовка",
"3593562", "Славовица\,\ Пазарджик",
"3593774", "Левка",
"3593676", "Бенковски\,\ Кърдж\.",
"3596522", "Згалево",
"3599147", "Борован",
"3596062", "Стража\,\ Търг\.",
"35931627", "Крушево\,\ Пловдив",
"3596915", "Смочан",
"35961303", "Горна\ Липница",
"35942", "Стара\ Загора",
"35951539", "Левски\,\ Варна",
"3597525", "Баничан",
"35991186", "Баурене",
"3595144", "Камчия",
"35937707", "Щит",
"35971504", "Белопопци",
"3593516", "Црънча\,\ Пазарджик",
"3597132", "Радотина",
"35951108", "Изворско",
"3596991", "Ябланица",
"3596566", "Долни\ Вит",
"3596026", "Макариополско",
"3595715", "Попгригорово",
"3593526", "Динката",
"3596985", "Румянцево",
"35941359", "Изворово\,\ Ст\.\ Загора",
"3593586", "Боримечково",
"3596925", "Владиня",
"3594792", "Ботево\,\ Ямбол",
"3594763", "Иречеково",
"3598671", "Силистра",
"3594146", "Диня",
"35961301", "Бяла\ река\,\ В\.\ Търново",
"3599143", "Еница",
"3595395", "Чернооково\,\ Шумен",
"3596512", "Горни\ Дъбник",
"3597156", "Равно\ поле",
"35971220", "Гуцал",
"35967194", "Гръблевци",
"35937602", "Черна\ могила\,\ Хаск\.",
"3597922", "Драговищица\,\ Кюст\.",
"3593707", "Николово\,\ Хаск\.",
"3595321", "Правенци",
"3598148", "Горно\ Абланово",
"35961604", "Мирово\,\ В\.\ Търново",
"3595943", "Вресово",
"3593193", "Борец",
"3593162", "Градина\,\ Пловдив",
"3596579", "Рупци\,\ Плевен",
"3596535", "Козар\ Белене",
"35941115", "Борилово",
"35963575", "Бохот",
"3593555", "Нова\ махала\,\ Пазарджик",
"3599547", "Винище",
"3593035", "Върбина",
"3596122", "Беляковец",
"3593079", "Козарка",
"3596956", "Ломец\,\ Ловеч",
"3594335", "Ръжена",
"35984466", "Звънарци",
"3593936", "Горски\ извор\,\ Хаск\.",
"3595348", "Трем",
"35931398", "Слатина\,\ Пловдив",
"35969613", "Чифлик\,\ Ловеч",
"3599558", "Гаврил\ Геново",
"3597125", "Говедарци",
"3598647", "Паисиево",
"3597744", "Еловдол\,\ Перник",
"3599354", "Антимово\,\ Видин",
"3597052", "Пастра",
"3594139", "Свобода\,\ Ст\.\ Загора",
"3595101", "Дъбравино",
"3597532", "Буково\,\ Благ\.",
"3595732", "Петлешково",
"3593116", "Крумово\,\ Пловдив",
"35936401", "Странджево",
"35969241", "Йоглав",
"3595168", "Петров\ дол\,\ Варна",
"35959400", "Дъскотна",
"3594754", "Каменец\,\ Ямбол",
"3597185", "Челопеч",
"3593342", "Нареченски\ бани",
"3595140", "Шкорпиловци",
"3596909", "Малка\ Желязна",
"35973", "Благоевград",
"35961405", "Петко\ Каравелово",
"35941018", "Княжевско",
"3597103", "Брусен\,\ София",
"3594520", "Коньово",
"3593348", "Добралък",
"3597047", "Усойка",
"3597755", "Велковци\,\ Перник",
"3595555", "Факия",
"359720", "Етрополе",
"3599345", "Винарово\,\ Видин",
"3595162", "Белоградец",
"3595738", "Спасово\,\ Добр\.",
"3597058", "Стоб",
"3594580", "Боринци",
"3597174", "Калотина",
"3594124", "Змейово",
"3593631", "Момчилград",
"359610", "Павликени\,\ В\.\ Търново",
"3594745", "Шарково",
"35984725", "Киченица",
"35984719", "Балкански",
"3599149", "Буковец\,\ Враца",
"3599552", "Белимел",
"3595342", "Капитан\ Петко",
"3599165", "Софрониево",
"35935394", "Оборище\,\ Пазарджик",
"3596177", "Янтра\,\ В\.\ Търново",
"3593544", "Костандово",
"3596128", "Хотница",
"35960378", "Цар\ Асен\,\ Търг\.",
"3595116", "Крумово\,\ Варна",
"3596044", "Долно\ Козарево",
"35967304", "Крамолин",
"3593101", "Войводиново",
"3593168", "Езерово\,\ Пловдив",
"35944", "Сливен",
"3598142", "Бъзовец\,\ Русе",
"359336", "Първомай\,\ Пловдив",
"3596573", "Койнаре",
"3595949", "Планиница\,\ Бургас",
"35941270", "Малка\ Верея",
"3597928", "Гърляно",
"35960451", "Обител",
"35961502", "Горско\ Ново\ Село",
"3593073", "Старцево",
"35937422", "Долни\ Главанак",
"3598431", "Исперих",
"3596518", "Рибен",
"3596141", "Полски\ Тръмбеш",
"35931108", "Богданица",
"3597726", "Дрен",
"3595526", "Кликач",
"35951429", "Солник",
"3594798", "Савино",
"3593667", "Покрован",
"3599136", "Галиче",
"35960386", "Водица\,\ Търг\.",
"3597435", "Склаве",
"35930417", "Грохотно",
"3593321", "Тополово\,\ Пловдив",
"35963563", "Борислав",
"35930476", "Селча",
"3598694", "Зебил",
"3594514", "Крушаре",
"35984713", "Благоево\,\ Разград",
"3596982", "Ъглен",
"35931620", "Добри\ дол\,\ Пловдив",
"3596156", "Родина",
"3595571", "Сунгурларе",
"3595712", "Стожер",
"3593136", "Розино\,\ Пловдив",
"3596922", "Лешница\,\ Ловеч",
"3594795", "Скалица",
"3595143", "Бяла\,\ Варна",
"3597438", "Катунци",
"35984726", "Ушинци",
"35931392", "Дъбене",
"3596515", "Славяново\,\ Плевен",
"3595766", "Методиево\,\ Добр\.",
"3593718", "Войводово\,\ Хаск\.",
"3595363", "Гусла",
"3595392", "Менгишево",
"359936", "Белоградчик",
"3593704", "Брягово\,\ Хаск\.",
"3593190", "Върбен\,\ Пловдив",
"35984734", "Тодорово\,\ Разград",
"3595968", "Каблешково\,\ Бургас",
"3593773", "Капитан\ Андреево",
"3597925", "Гюешево",
"3596125", "Пушево",
"3593032", "Средногорци",
"35961101", "Велчево\,\ В\.\ Търново",
"3593149", "Цалапица",
"3599140", "Габаре",
"3593552", "Брацигово",
"3598163", "Бъзън",
"3598192", "Хотанца",
"35963569", "Каменец\,\ Плевен",
"3593165", "Караджалово",
"3596532", "Българене\,\ Плевен",
"35967394", "Богатово",
"359747", "Разлог",
"3599168", "Бутан",
"3595354", "Риш",
"35930458", "Любча",
"3594332", "Ветрен\,\ Ст\.\ Загора",
"3599544", "Студено\ буче",
"3594529", "Съдиево\,\ Сливен",
"3595558", "Дебелт",
"3599348", "Неговановци",
"35960385", "Ломци",
"3595735", "Красен\,\ Добр\.",
"3594748", "Воден\,\ Ямбол",
"3596329", "Царевец\,\ В\.\ Търново",
"35984269", "Недоклан",
"3598644", "Чернолик",
"35931603", "Виница",
"35930475", "Стоманево",
"3594757", "Недялско",
"35930257", "Вишнево",
"3597182", "Мирково",
"3593345", "Лясково\,\ Пловдив",
"35961203", "Емен",
"3599116", "Костелево",
"3597188", "Петрич\,\ София",
"3593653", "Млечино",
"3594113", "Преславен",
"3596941", "Летница",
"35974201", "Капатово",
"3594130", "Спасово\,\ Ст\.\ Загора",
"3597415", "Селище\,\ Благ\.",
"3597177", "Алдомировци",
"3596900", "Васильово",
"3594742", "Стефан\ Караджово",
"3595165", "Невша",
"3599342", "Иново",
"3597044", "Бабино",
"3597752", "Режанци",
"3595552", "Дюлево\,\ Бургас",
"3595149", "Голица",
"35941330", "Ценово\,\ Ст\.\ Загора",
"3593547", "Сърница\,\ Пазарджик",
"3594338", "Крън",
"3599162", "Михайлово\,\ Враца",
"3596047", "Зелена\ морава",
"3596570", "Девенци",
"3595345", "Развигорово",
"359519", "Девня",
"3599555", "Копиловци\,\ Монт\.",
"3596538", "Обнова",
"3593779", "Сива\ река",
"35931308", "Богдан\,\ Пловдив",
"35941353", "Плодовитово",
"3593558", "Исперихово",
"3593038", "Чокманово",
"35984778", "Богданци\,\ Разград",
"3596174", "Драганово\,\ В\.\ Търново",
"35941116", "Сладък\ Кладенец",
"35960372", "Крепча",
"35963576", "Тученица",
"3598145", "Тръстеник\,\ Русе",
"3598626", "Средище\,\ Силистра",
"35961391", "Сломер",
"3593143", "Перущица",
"35984465", "Савин",
"3596071", "Антоново",
"3593712", "Малево\,\ Хаск\.",
"3595136", "Брестак",
"3595773", "Лозенец\,\ Добр\.",
"3599526", "Слатина\,\ Монт\.",
"3595916", "Росен\,\ Бургас",
"3594523", "Стоил\ войвода",
"3594517", "Ичера",
"35971502", "Елешница\,\ София",
"3596928", "Къкрина",
"3598697", "Сокол\,\ Силистра",
"3593766", "Бисер",
"3593664", "Плевун",
"3595718", "Смолница",
"3596323", "Българско\ сливово",
"3594583", "Кипилово",
"3596726", "Скалско",
"35961406", "Каранци",
"3596988", "Пещерна",};
my $timezones = {
               '' => [
                       'Europe/Sofia'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+359|\D)//g;
      my $self = bless({ country_code => '359', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '359', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;