#!/usr/bin/perl

package eBay::API::XML::DataType::CategoryItemSpecificsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CategoryItemSpecificsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::CategoryItemSpecificsType

=head1 DESCRIPTION

Defines details about recommended names and values for custom Item Specifics.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::CategoryItemSpecificsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::NameValueListArrayType;


my @gaProperties = ( [ 'CategoryID', 'xs:string', '', '', '' ]
	, [ 'ItemSpecifics', 'ns:NameValueListArrayType', ''
	     ,'eBay::API::XML::DataType::NameValueListArrayType', '1' ]
	, [ 'Updated', 'xs:boolean', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCategoryID()

The leaf category in which the associated Item Specifics are popular.
This is always a category that you specified in the request.<br>
<br>
Only returned for categories that have popular Item Specifics,
or when you also pass in the Name field.

MaxLength: 10

#    Argument: 'xs:string'

=cut

sub setCategoryID {
  my $self = shift;
  $self->{'CategoryID'} = shift
}

=head2 getCategoryID()

  Calls: GetCategorySpecifics
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getCategoryID {
  my $self = shift;
  return $self->{'CategoryID'};
}


=head2 setItemSpecifics()

Contains a list of Item Specifics that eBay recommends as most popular
within the specified category.<br>
<br>
Not returned when you pass LastUpdateTime in the request.

#    Argument: 'ns:NameValueListArrayType'

=cut

sub setItemSpecifics {
  my $self = shift;
  $self->{'ItemSpecifics'} = shift
}

=head2 getItemSpecifics()

  Calls: GetCategorySpecifics
  Returned: Conditionally

#    Returns: 'ns:NameValueListArrayType'

=cut

sub getItemSpecifics {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemSpecifics'
		,'eBay::API::XML::DataType::NameValueListArrayType');
}


=head2 setUpdated()

If true, the recommended Item Specifics for this category
have changed since the time you specified (in LastUpdateTime).
(In this case, we suggest you retrieve the latest data for
the category.)
If false, the recommended Item Specifics for this category
have not changed since the time you specified.<br>
<br>
Only returned when you pass LastUpdateTime in the request.

#    Argument: 'xs:boolean'

=cut

sub setUpdated {
  my $self = shift;
  $self->{'Updated'} = shift
}

=head2 isUpdated()

  Calls: GetCategorySpecifics
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isUpdated {
  my $self = shift;
  return $self->{'Updated'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
