# copied over from JSON::PC and modified to use JSON
# copied over from JSON::XS and modified to use JSON

use Test::More;
use strict;
BEGIN { plan tests => 8 + 2 };
BEGIN { $ENV{PERL_JSON_BACKEND} ||= "JSON::backportPP"; }

use JSON;

#########################
my ($js,$obj);
my $pc = new JSON;

$js  = q|[-12.34]|;
$obj = $pc->decode($js);
is($obj->[0], -12.34, 'digit -12.34');
$js = $pc->encode($obj);
is($js,'[-12.34]', 'digit -12.34');

$js  = q|[-1.234e5]|;
$obj = $pc->decode($js);
is($obj->[0], -123400, 'digit -1.234e5');
SKIP: { skip "not for $JSON::BackendModule", 1 if $JSON::BackendModule eq 'Cpanel::JSON::XS';
$js = $pc->encode($obj);
is($js,'[-123400]', 'digit -1.234e5');
}

$js  = q|[1.23E-4]|;
$obj = $pc->decode($js);
is($obj->[0], 0.000123, 'digit 1.23E-4');
$js = $pc->encode($obj);
is($js,'[0.000123]', 'digit 1.23E-4');


$js  = q|[1.01e+30]|;
$obj = $pc->decode($js);
is($obj->[0], 1.01e+30, 'digit 1.01e+30');
$js = $pc->encode($obj);
like($js,qr/\[1.01[Ee]\+0?30\]/, 'digit 1.01e+30');

my $vax_float = (pack("d",1) =~ /^[\x80\x10]\x40/);

if ($vax_float) {
    # VAX has smaller float range.
    $js  = q|[1.01e+37]|;
    $obj = $pc->decode($js);
    is($obj->[0], eval '1.01e+37', 'digit 1.01e+37');
    $js = $pc->encode($obj);
    like($js,qr/\[1.01[Ee]\+0?37\]/, 'digit 1.01e+37');
} else {
    $js  = q|[1.01e+67]|; # 30 -> 67 ... patched by H.Merijn Brand
    $obj = $pc->decode($js);
    is($obj->[0], eval '1.01e+67', 'digit 1.01e+67');
    $js = $pc->encode($obj);
    like($js,qr/\[1.01[Ee]\+0?67\]/, 'digit 1.01e+67');
}
