package Business::EDI::CodeList::ValidationValueQualifier;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {return "0563";}
my $usage       = 'B';

# 0563  Validation value, qualifier
# Desc: Identification of the type of validation value.
# Repr: an..3

my %code_hash = (
'1' => [ 'Unique validation value',
    'Specifies that this is the unique validation value. This code shall be used when the algorithm involved produces a single parameter result (one MAC with DES algorithm, or one digital signature with RSA algorithm, for instance).' ],
'2' => [ 'DSA algorithm r parameter',
    'Specifies that this is the r parameter, resulting of the use of DSA algorithm.' ],
'3' => [ 'DSA algorithm s parameter',
    'Specifies that this is the s parameter, resulting of the use of DSA algorithm.' ],
'4' => [ 'Random number for party A',
    'A random number generated by party A in a key agreement or entity authentication protocol.' ],
'5' => [ 'Random number for party B',
    'A random number generated by party B in a key agreement or entity authentication protocol.' ],
'6' => [ 'Enciphered block under a symmetric algorithm',
    'The result of the encipherment of data under a symmetric algorithm in an entity authentication protocol.' ],
'7' => [ 'Enciphered block under an asymmetric algorithm',
    'The result of the encipherment of data under an asymmetric algorithm in an entity authentication protocol.' ],
'8' => [ 'Key agreement value',
    'The value calculated in a key agreement protocol.' ],
);
sub get_codes { return \%code_hash; }

1;
