package Business::EDI::CodeList::SpecialServiceDescriptionCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {7161;}
my $usage       = 'C';

# *    7161  Special service description code                        [C]
# Desc: Code specifying a special service.
# Repr: an..3

my %code_hash = (
'AA' => [ 'Advertising',
    'The service of providing advertising.' ],
'AAA' => [ 'Telecommunication',
    'The service of providing telecommunication activities and/or faclities.' ],
'AAC' => [ 'Technical modification',
    'The service of making technical modifications to a product.' ],
'AAD' => [ 'Job-order production',
    'The service of producing to order.' ],
'AAE' => [ 'Outlays',
    'The service of providing money for outlays on behalf of a trading partner.' ],
'AAF' => [ 'Off-premises',
    'The service of providing services outside the premises of the provider.' ],
'AAH' => [ 'Additional processing',
    'The service of providing additional processing.' ],
'AAI' => [ 'Attesting',
    'The service of certifying validity.' ],
'AAS' => [ 'Acceptance',
    'The service of accepting goods or services.' ],
'AAT' => [ 'Rush delivery',
    'The service to provide a rush delivery.' ],
'AAV' => [ 'Special construction',
    'The service of providing special construction.' ],
'AAY' => [ 'Airport facilities',
    'The service of providing airport facilities.' ],
'AAZ' => [ 'Concession',
    "The service allowing a party to use another party's facilities." ],
'ABA' => [ 'Compulsory storage',
    'The service provided to hold a compulsory inventory.' ],
'ABB' => [ 'Fuel removal',
    'Remove or off-load fuel from vehicle, vessel or craft.' ],
'ABC' => [ 'Into plane',
    'Service of delivering goods to an aircraft from local storage.' ],
'ABD' => [ 'Overtime',
    'The service of providing labour beyond the established limit of working hours.' ],
'ABF' => [ 'Tooling',
    'The service of providing specific tooling.' ],
'ABK' => [ 'Miscellaneous',
    'Miscellaneous services.' ],
'ABL' => [ 'Additional packaging',
    'The service of providing  additional packaging.' ],
'ABN' => [ 'Dunnage',
    'The service of providing additional padding materials required to secure and protect a cargo within a shipping container.' ],
'ABR' => [ 'Containerisation',
    'The service of packing items into a container.' ],
'ABS' => [ 'Carton packing',
    'The service of packing items into a carton.' ],
'ABT' => [ 'Hessian wrapped',
    'The service of hessian wrapping.' ],
'ABU' => [ 'Polyethylene wrap packing',
    'The service of packing in polyethylene wrapping.' ],
'ACF' => [ 'Miscellaneous treatment',
    'Miscellaneous treatment service.' ],
'ACG' => [ 'Enamelling treatment',
    'The service of providing enamelling treatment.' ],
'ACH' => [ 'Heat treatment',
    'The service of treating with heat.' ],
'ACI' => [ 'Plating treatment',
    'The service of providing plating treatment.' ],
'ACJ' => [ 'Painting',
    'The service of painting.' ],
'ACK' => [ 'Polishing',
    'The service of polishing.' ],
'ACL' => [ 'Priming',
    'The service of priming.' ],
'ACM' => [ 'Preservation treatment',
    'The service of preservation treatment.' ],
'ACS' => [ 'Fitting',
    'Fitting service.' ],
'ADC' => [ 'Consolidation',
    'The service of consolidating multiple consignments into one shipment.' ],
'ADE' => [ 'Bill of lading',
    'The service of providing a bill of lading document.' ],
'ADJ' => [ 'Airbag',
    'The service of surrounding a product with an air bag.' ],
'ADK' => [ 'Transfer',
    'The service of transferring.' ],
'ADL' => [ 'Slipsheet',
    'The service of securing a stack of products on a slipsheet.' ],
'ADM' => [ 'Binding',
    'Binding service.' ],
'ADN' => [ 'Repair or replacement of broken returnable package',
    'The service of repairing or replacing a broken returnable package.' ],
'ADO' => [ 'Efficient logistics',
    'A code indicating efficient logistics services.' ],
'ADP' => [ 'Merchandising',
    'A code indicating that merchandising services are in operation.' ],
'ADQ' => [ 'Product mix',
    'A code indicating that product mixing services are in operation.' ],
'ADR' => [ 'Other services',
    'A code indicating that other non-specific services are in operation.' ],
'ADT' => [ 'Pick-up',
    'The service of picking up or collection of goods.' ],
'ADW' => [ 'Chronic illness',
    'The special services provided due to chronic illness.' ],
'ADY' => [ 'New product introduction',
    'A service provided by a buyer when introducing a new product from a suppliers range to the range traded by the buyer.' ],
'ADZ' => [ 'Direct delivery',
    'Direct delivery service.' ],
'AEA' => [ 'Diversion',
    'The service of diverting deliverables.' ],
'AEB' => [ 'Disconnect',
    'The service is a disconnection.' ],
'AEC' => [ 'Distribution',
    'Distribution service.' ],
'AED' => [ 'Handling of hazardous cargo',
    'A service for handling hazardous cargo.' ],
'AEF' => [ 'Rents and leases',
    'The service of renting and/or leasing.' ],
'AEH' => [ 'Location differential',
    'Delivery to a different location than previously contracted.' ],
'AEI' => [ 'Aircraft refueling',
    'Fuel being put into the aircraft.' ],
'AEJ' => [ 'Fuel shipped into storage',
    'Fuel being shipped into a storage system.' ],
'AEK' => [ 'Cash on delivery',
    'The provision of a cash on delivery (COD) service.' ],
'AEL' => [ 'Small order processing service',
    'A service related to the processing of small orders.' ],
'AEM' => [ 'Clerical or administrative services',
    'The provision of clerical or administrative services.' ],
'AEN' => [ 'Guarantee',
    'The service of providing a guarantee.' ],
'AEO' => [ 'Collection and recycling',
    'The service of collection and recycling products.' ],
'AEP' => [ 'Copyright fee collection',
    'The service of collecting copyright fees.' ],
'AES' => [ 'Veterinary inspection service',
    'The service of providing veterinary inspection.' ],
'AET' => [ 'Pensioner service',
    'Special service when the subject is a pensioner.' ],
'AEU' => [ 'Medicine free pass holder',
    'Special service when the subject holds a medicine free pass.' ],
'AEV' => [ 'Environmental protection service',
    'The provision of an environmental protection service.' ],
'AEW' => [ 'Environmental clean-up service',
    'The provision of an environmental clean-up service.' ],
'AEX' => [ 'National cheque processing service outside account area',
    "Service of processing a national cheque outside the ordering customer's bank trading area." ],
'AEY' => [ 'National payment service outside account area',
    "Service of processing a national payment to a beneficiary holding an account outside the trading area of the ordering customer's bank." ],
'AEZ' => [ 'National payment service within account area',
    "Service of processing a national payment to a beneficiary holding an account within the trading area of the ordering customer's bank." ],
'AJ' => [ 'Adjustments',
    'The service of making adjustments.' ],
'AU' => [ 'Authentication',
    'The service of authenticating.' ],
'CA' => [ 'Cataloguing',
    'The provision of cataloguing services.' ],
'CAB' => [ 'Cartage',
    'Movement of goods by heavy duty cart or vehicle.' ],
'CAD' => [ 'Certification',
    'The service of certifying.' ],
'CAE' => [ 'Certificate of conformance',
    'The service of providing a certificate of conformance.' ],
'CAF' => [ 'Certificate of origin',
    'The service of providing a certificate of origin.' ],
'CAI' => [ 'Cutting',
    'The service of cutting.' ],
'CAJ' => [ 'Consular service',
    'The service provided by consulates.' ],
'CAK' => [ 'Customer collection',
    'The service of collecting goods by the customer.' ],
'CAL' => [ 'Payroll payment service',
    'Provision of a payroll payment service.' ],
'CAM' => [ 'Cash transportation',
    'Provision of a cash transportation service.' ],
'CAN' => [ 'Home banking service',
    'Provision of a home banking service.' ],
'CAO' => [ 'Bilateral agreement service',
    'Provision of a service as specified in a bilateral special agreement.' ],
'CAP' => [ 'Insurance brokerage service',
    'Provision of an insurance brokerage service.' ],
'CAQ' => [ 'Cheque generation',
    'Provision of a cheque generation service.' ],
'CAR' => [ 'Preferential merchandising location',
    'Service of assigning a preferential location for merchandising.' ],
'CAS' => [ 'Crane',
    'The service of providing a crane.' ],
'CAT' => [ 'Special colour service',
    'Providing a colour which is different from the default colour.' ],
'CAU' => [ 'Sorting',
    'The provision of sorting services.' ],
'CAV' => [ 'Battery collection and recycling',
    'The service of collecting and recycling batteries.' ],
'CAW' => [ 'Product take back fee',
    'The fee the consumer must pay the manufacturer to take back the product.' ],
'CD' => [ 'Car loading',
    'Car loading service.' ],
'CG' => [ 'Cleaning',
    'Cleaning service.' ],
'CS' => [ 'Cigarette stamping',
    'The service of providing cigarette stamping.' ],
'CT' => [ 'Count and recount',
    'The service of doing a count and recount.' ],
'DAB' => [ 'Layout/design',
    'The service of providing layout/design.' ],
'DAD' => [ 'Driver assigned unloading',
    'The service of unloading by the driver.' ],
'DL' => [ 'Delivery',
    'The service of providing delivery.' ],
'EG' => [ 'Engraving',
    'The service of providing engraving.' ],
'EP' => [ 'Expediting',
    'The service of expediting.' ],
'ER' => [ 'Exchange rate guarantee',
    'The service of guaranteeing exchange rate.' ],
'FAA' => [ 'Fabrication',
    'The service of providing fabrication.' ],
'FAB' => [ 'Freight equalization',
    'The service of load balancing.' ],
'FAC' => [ 'Freight extraordinary handling',
    "The service of providing freight's extraordinary handling." ],
'FC' => [ 'Freight service',
    'The service of moving goods, by whatever means, from one place to another.' ],
'FH' => [ 'Filling/handling',
    'The service of providing filling/handling.' ],
'FI' => [ 'Financing',
    'The service of providing financing.' ],
'GAA' => [ 'Grinding',
    'The service of grinding.' ],
'HAA' => [ 'Hose',
    'The service of providing a hose.' ],
'HD' => [ 'Handling',
    'Handling service.' ],
'HH' => [ 'Hoisting and hauling',
    'The service of hoisting and hauling.' ],
'IAA' => [ 'Installation',
    'The service of installing.' ],
'IAB' => [ 'Installation and warranty',
    'The service of installing and providing warranty.' ],
'ID' => [ 'Inside delivery',
    'The service of providing delivery inside.' ],
'IF' => [ 'Inspection',
    'The service of inspection.' ],
'IR' => [ 'Installation and training',
    'The service of providing installation and training.' ],
'IS' => [ 'Invoicing',
    'The service of providing an invoice.' ],
'KO' => [ 'Koshering',
    'The service of preparing food in accordance with Jewish law.' ],
'L1' => [ 'Carrier count',
    'The service of counting by the carrier.' ],
'LA' => [ 'Labelling',
    'Labelling service.' ],
'LAA' => [ 'Labour',
    'The service to provide required labour.' ],
'LAB' => [ 'Repair and return',
    'The service of repairing and returning.' ],
'LF' => [ 'Legalisation',
    'The service of legalising.' ],
'MAE' => [ 'Mounting',
    'The service of mounting.' ],
'MI' => [ 'Mail invoice',
    'The service of mailing an invoice.' ],
'ML' => [ 'Mail invoice to each location',
    'The service of mailing an invoice to each location.' ],
'NAA' => [ 'Non-returnable containers',
    'The service of providing non-returnable containers.' ],
'OA' => [ 'Outside cable connectors',
    'The service of providing outside cable connectors.' ],
'PA' => [ 'Invoice with shipment',
    'The service of including the invoice with the shipment.' ],
'PAA' => [ 'Phosphatizing (steel treatment)',
    'The service of phosphatizing the steel.' ],
'PC' => [ 'Packing',
    'The service of packing.' ],
'PL' => [ 'Palletizing',
    'The service of palletizing.' ],
'RAB' => [ 'Repacking',
    'The service of repacking.' ],
'RAC' => [ 'Repair',
    'The service of repairing.' ],
'RAD' => [ 'Returnable container',
    'The service of providing returnable containers.' ],
'RAF' => [ 'Restocking',
    'The service of restocking.' ],
'RE' => [ 'Re-delivery',
    'The service of re-delivering.' ],
'RF' => [ 'Refurbishing',
    'The service of refurbishing.' ],
'RH' => [ 'Rail wagon hire',
    'The service of providing rail wagons for hire.' ],
'RV' => [ 'Loading',
    'The service of loading goods.' ],
'SA' => [ 'Salvaging',
    'The service of salvaging.' ],
'SAA' => [ 'Shipping and handling',
    'The service of shipping and handling.' ],
'SAD' => [ 'Special packaging',
    'The service of special packaging.' ],
'SAE' => [ 'Stamping',
    'The service of stamping.' ],
'SAI' => [ 'Consignee unload',
    'The service of unloading by the consignee.' ],
'SG' => [ 'Shrink-wrap',
    'The service of shrink-wrapping.' ],
'SH' => [ 'Special handling',
    'The service of special handling.' ],
'SM' => [ 'Special finish',
    'The service of providing a special finish.' ],
'SU' => [ 'Set-up',
    'The service of setting-up.' ],
'TAB' => [ 'Tank renting',
    'The service of providing tanks for hire.' ],
'TAC' => [ 'Testing',
    'The service of testing.' ],
'TT' => [ 'Transportation - third party billing',
    'The service of providing third party billing for transportation.' ],
'TV' => [ 'Transportation by vendor',
    'The service of providing transportation by the vendor.' ],
'V1' => [ 'Drop yard',
    'The service of delivering goods at the yard.' ],
'V2' => [ 'Drop dock',
    'The service of delivering goods at the dock.' ],
'WH' => [ 'Warehousing',
    'The service of storing and handling of goods in a warehouse.' ],
'XAA' => [ 'Combine all same day shipment',
    'The service of combining all shipments for the same day.' ],
'YY' => [ 'Split pick-up',
    'The service of providing split pick-up.' ],
'ZZZ' => [ 'Mutually defined',
    'A code assigned within a code list to be used on an interim basis and as defined among trading partners until a precise code can be assigned to the code list.' ],
);
sub get_codes { return \%code_hash; }

1;
