/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.remote.SessionId;

public class Command {
    private final SessionId sessionId;
    private final String name;
    private final Map<String, ?> parameters;

    public Command(SessionId sessionId, String name) {
        this(sessionId, name, new HashMap());
    }

    public Command(SessionId sessionId, String name, Map<String, ?> parameters) {
        this.sessionId = sessionId;
        this.name = name;
        this.parameters = parameters == null ? new HashMap() : parameters;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, ?> getParameters() {
        return this.parameters;
    }

    public String toString() {
        return "[" + this.sessionId + ", " + this.name + " " + this.parameters + "]";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Command)) {
            return false;
        }
        Command that = (Command)o;
        return Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.name, that.name) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.name, this.parameters);
    }
}

