/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.EnvironmentVariableResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentVariable
extends SystemFunction {
    @Override
    public ZeroOrOne<StringValue> call(XPathContext context, Sequence[] arguments) throws XPathException {
        return new ZeroOrOne<StringValue>(EnvironmentVariable.getVariable((StringValue)arguments[0].head(), context));
    }

    private static StringValue getVariable(StringValue environVar, XPathContext context) throws XPathException {
        String environValue;
        EnvironmentVariableResolver resolver = (EnvironmentVariableResolver)context.getConfiguration().getConfigurationProperty("http://saxon.sf.net/feature/environmentVariableResolver");
        String environVarName = environVar.getStringValue();
        try {
            environValue = resolver.getEnvironmentVariable(environVarName);
            if (environValue == null) {
                return null;
            }
        }
        catch (SecurityException e) {
            environValue = "";
        }
        catch (NullPointerException e) {
            environValue = "";
        }
        return new StringValue(environValue);
    }
}

