/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.openqa.selenium.grid.web.CommandHandler;
import org.openqa.selenium.grid.web.Routes;
import org.openqa.selenium.injector.Injector;
import org.openqa.selenium.remote.http.HttpRequest;

public abstract class Route<T extends Route> {
    private final List<Class<? extends CommandHandler>> decorators = new ArrayList<Class<? extends CommandHandler>>();
    private Function<Injector, CommandHandler> fallback;

    protected Route() {
    }

    protected abstract void validate();

    protected abstract CommandHandler newHandler(Injector var1, HttpRequest var2);

    public T decorateWith(Class<? extends CommandHandler> decorator) {
        Objects.requireNonNull(decorator);
        Constructor constructor = Arrays.stream(decorator.getDeclaredConstructors()).max(Comparator.comparing(Constructor::getParameterCount)).orElse(null);
        if (constructor == null) {
            throw new IllegalArgumentException("Unable to find a constructor for " + decorator);
        }
        Boolean hasHandlerArg = Arrays.stream(constructor.getParameterTypes()).map(CommandHandler.class::isAssignableFrom).reduce(Boolean::logicalOr).orElse(false);
        if (!hasHandlerArg.booleanValue()) {
            throw new IllegalArgumentException("Decorator must take a CommandHandler as a constructor arg in its longest constructor. " + decorator);
        }
        this.decorators.add(decorator);
        return (T)this;
    }

    public T fallbackTo(Class<? extends CommandHandler> fallback) {
        Objects.requireNonNull(fallback);
        this.fallback = inj -> (CommandHandler)inj.newInstance(fallback);
        return (T)this;
    }

    public T fallbackTo(CommandHandler fallback) {
        Objects.requireNonNull(fallback);
        this.fallback = inj -> fallback;
        return (T)this;
    }

    public Routes build() {
        this.validate();
        BiFunction<Injector, HttpRequest, CommandHandler> func = (inj, req) -> {
            CommandHandler handler = this.newHandler((Injector)inj, (HttpRequest)req);
            if (handler == null) {
                return this.getFallback((Injector)inj);
            }
            Injector injector = inj;
            for (Class<? extends CommandHandler> decorator : this.decorators) {
                injector = Injector.builder().parent(injector).register(handler).build();
                handler = injector.newInstance(decorator);
            }
            return handler;
        };
        return new Routes(func);
    }

    protected CommandHandler getFallback(Injector injector) {
        return this.fallback == null ? null : this.fallback.apply(injector);
    }
}

