/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSlot;
import org.openqa.grid.web.servlet.RegistryBasedServlet;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;

public class HubStatusServlet
extends RegistryBasedServlet {
    private static final String SUCCESS = "success";
    private static final String CONFIGURATION = "configuration";
    private static final String FREE = "free";
    private static final String BUSY = "busy";
    private static final String NEW_SESSION_REQUEST_COUNT = "newSessionRequestCount";
    private static final String SLOT_COUNTS = "slotCounts";
    private static final String NODES = "nodes";
    private static final String TOTAL = "total";
    private final Json json = new Json();

    public HubStatusServlet() {
        this(null);
    }

    public HubStatusServlet(GridRegistry registry) {
        super(registry);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.process(request, response, new HashMap<String, Object>());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getInputStream() != null) {
            Map<String, Object> json = this.getRequestJSON(req);
            this.process(req, resp, json);
        } else {
            this.process(req, resp, new HashMap<String, Object>());
        }
    }

    protected void process(HttpServletRequest request, HttpServletResponse response, Map<String, Object> requestJson) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        try (PrintWriter writer = response.getWriter();
             JsonOutput out = this.json.newOutput(writer);){
            Map<String, Object> res = this.getResponse(request, requestJson);
            out.write(res);
        }
    }

    private Map<String, Object> getResponse(HttpServletRequest request, Map<String, Object> requestJSON) {
        TreeMap<String, Object> res = new TreeMap<String, Object>();
        res.put(SUCCESS, true);
        try {
            List keysToReturn = null;
            String configuration = request.getParameter(CONFIGURATION);
            if (!Strings.isNullOrEmpty(configuration)) {
                keysToReturn = Splitter.on(",").omitEmptyStrings().splitToList(configuration);
            } else if (requestJSON.get(CONFIGURATION) instanceof List) {
                keysToReturn = (List)requestJSON.get(CONFIGURATION);
            }
            GridRegistry registry = this.getRegistry();
            Map<String, Object> config = registry.getHub().getConfiguration().toJson();
            for (Map.Entry<String, Object> entry : config.entrySet()) {
                if (!HubStatusServlet.isKeyPresentIn(keysToReturn, entry.getKey())) continue;
                res.put(entry.getKey(), entry.getValue());
            }
            if (HubStatusServlet.isKeyPresentIn(keysToReturn, NEW_SESSION_REQUEST_COUNT)) {
                res.put(NEW_SESSION_REQUEST_COUNT, registry.getNewSessionRequestCount());
            }
            if (HubStatusServlet.isKeyPresentIn(keysToReturn, SLOT_COUNTS)) {
                res.put(SLOT_COUNTS, this.getSlotCounts());
            }
            if (keysToReturn != null && keysToReturn.contains(NODES)) {
                res.put(NODES, this.getNodesInfo());
            }
        }
        catch (Exception e) {
            res.remove(SUCCESS);
            res.put(SUCCESS, false);
            res.put("msg", e.getMessage());
        }
        return res;
    }

    private Map<String, Object> getSlotCounts() {
        int totalSlots = 0;
        int usedSlots = 0;
        for (RemoteProxy proxy : this.getRegistry().getAllProxies()) {
            totalSlots += Math.min(proxy.getMaxNumberOfConcurrentTestSessions(), proxy.getTestSlots().size());
            usedSlots += proxy.getTotalUsed();
        }
        return ImmutableSortedMap.of(FREE, totalSlots - usedSlots, TOTAL, totalSlots);
    }

    /*
     * Exception decompiling
     */
    private Map<String, Object> getRequestJSON(HttpServletRequest request) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isKeyPresentIn(List<String> keys, String key) {
        return keys == null || keys.isEmpty() || keys.contains(key);
    }

    private List<Map<String, Object>> getNodesInfo() {
        List<RemoteProxy> proxies = this.getRegistry().getAllProxies().getSorted();
        return proxies.stream().map(this::getNodeInfo).collect(Collectors.toList());
    }

    private Map<String, Object> getNodeInfo(RemoteProxy remoteProxy) {
        return ImmutableSortedMap.of("id", remoteProxy.getId(), "browsers", this.getInfoFromAllSlotsInNode(remoteProxy.getTestSlots()));
    }

    private List<Map<String, Object>> getInfoFromAllSlotsInNode(List<TestSlot> slots) {
        ArrayList<Map<String, Object>> browsers = Lists.newArrayList();
        Map<String, List<TestSlot>> slotsInfo = slots.stream().collect(Collectors.groupingBy(HubStatusServlet::getBrowser));
        for (Map.Entry<String, List<TestSlot>> each : slotsInfo.entrySet()) {
            String key = each.getKey();
            Map<String, Object> value = this.getSlotInfoPerBrowserFlavor(each.getValue());
            browsers.add(ImmutableSortedMap.of("browser", key, "slots", value));
        }
        return browsers;
    }

    private Map<String, Object> getSlotInfoPerBrowserFlavor(List<TestSlot> slots) {
        Map<String, Integer> byStatus = slots.stream().collect(Collectors.groupingBy(this::status, HubStatusServlet.counting()));
        int busy = byStatus.computeIfAbsent(BUSY, status -> 0);
        int free = byStatus.computeIfAbsent(FREE, status -> 0);
        int total = busy + free;
        return ImmutableSortedMap.of(TOTAL, total, BUSY, busy);
    }

    private String status(TestSlot slot) {
        if (slot.getSession() == null) {
            return FREE;
        }
        return BUSY;
    }

    private static String getBrowser(TestSlot slot) {
        return slot.getCapabilities().get("browserName").toString();
    }

    private static <T> Collector<T, ?, Integer> counting() {
        return Collectors.reducing(0, e -> 1, Integer::sum);
    }
}

