/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.HashSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class DistinctValues
extends CollatingFunctionFixed {
    public String getStreamerName() {
        return "DistinctValues";
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringCollator collator = this.getStringCollator();
        return SequenceTool.toLazySequence(new DistinctIterator(arguments[0].iterate(), collator, context));
    }

    public static class DistinctIterator
    implements SequenceIterator {
        private SequenceIterator base;
        private StringCollator collator;
        private XPathContext context;
        private HashSet<Object> lookup = new HashSet(40);

        public DistinctIterator(SequenceIterator base, StringCollator collator, XPathContext context) {
            this.base = base;
            this.collator = collator;
            this.context = context;
        }

        public AtomicValue next() throws XPathException {
            AtomicValue nextBase;
            Object key;
            int implicitTimezone = this.context.getImplicitTimezone();
            do {
                if ((nextBase = (AtomicValue)this.base.next()) != null) continue;
                return null;
            } while (!this.lookup.add(key = nextBase.isNaN() ? DistinctValues.class : nextBase.getXPathComparable(false, this.collator, implicitTimezone)));
            return nextBase;
        }

        public void close() {
            this.base.close();
        }

        public int getProperties() {
            return 0;
        }
    }
}

