#!/usr/bin/perl -lw
use strict;

print <<END;
### Autogenerated httpd.conf
##
## Do not edit this file. All changes will be lost the next time the server
## starts, restarts, reloads, or is configtested
##
## If you need to make a change to this, please change conf.pl
##
END

die "\$HTTPD_ROOT not defined!" unless $ENV{HTTPD_ROOT};
print "ServerRoot $ENV{HTTPD_ROOT}";

die "\$HTTP_PORT not defined!" unless $ENV{HTTP_PORT};
die "\$HTTPS_PORT not defined!" unless $ENV{HTTPS_PORT};

#
# Discover the hostname and IP address of the server.
#
# look for the sdnfw.conf file in HTTPD_ROOT
# if it is not there they we can not do anything
unless(-f "$ENV{HTTPD_ROOT}/conf/sdnfw.conf") {
	die "$ENV{HTTPD_ROOT}/conf/sdnfw.conf file not found";
}
open F, "$ENV{HTTPD_ROOT}/conf/sdnfw.conf";
while (my $l = <F>) {
	chomp $l;
	next if ($l =~ m/^#/);
	my ($k,$v) = split '=', $l;
	$ENV{$k} = $v;
}
close F;

die "SERVER_NAME not defined in $ENV{HTTPD_ROOT}/conf/sdnfw.conf"
	unless($ENV{SERVER_NAME});
die "IP_ADDR not defined in $ENV{HTTPD_ROOT}/conf/sdnfw.conf"
	unless($ENV{IP_ADDR});

print "ServerName $ENV{SERVER_NAME}";

$ENV{APACHE_SERVER_NAME} = $ENV{SERVER_NAME};
#
# Obtain server-wide configuration items.
#
print 'ServerType standalone';
my $user = ($ENV{HTTPD_USER}) ? $ENV{HTTPD_USER} : 'apache';
my $group = ($ENV{HTTPD_GROUP}) ? $ENV{HTTPD_GROUP} : 'users';
print 'User '.$user;
print 'Group '.$group;
    
print 'MinSpareServers '.$ENV{APACHE_MIN_SERVERS} || '5';
print 'MaxSpareServers '.$ENV{APACHE_MAX_SERVERS} || '5';
print 'StartServers '.$ENV{APACHE_START_SERVERS} || '8';
print 'MaxClients '.$ENV{APACHE_MAX_CLIENTS} || '20';
print 'MaxRequestsPerChild '.$ENV{APACHE_MAX_REQUESTS} || '100';

print 'ServerAdmin "root"';

#
# pid/ directory
#
die "No log directory at $ENV{HTTPD_ROOT}/logs."
    unless -e "$ENV{HTTPD_ROOT}/logs";
print 'PidFile "logs/httpd.pid"';
print 'ScoreBoardFile "logs/httpd.scoreboard"';

print <<END;
ServerName "$ENV{SERVER_NAME}"
Listen $ENV{IP_ADDR}:$ENV{HTTP_PORT}
END

unless($ENV{NO_HTTPS}) {
	print <<END;
Listen $ENV{IP_ADDR}:$ENV{HTTPS_PORT}
END
}

print <<END;

ExtendedStatus On
KeepAlive Off
UseCanonicalName Off
TypesConfig /etc/mime.types
DefaultType text/plain
HostnameLookups Off
LogLevel warn
ErrorLog "logs/error_log"
LogFormat "\%h \%l \%u \%t \\"%r\\" \%>s \%b" common
LogFormat "\%h \%l \%u \%t \\"\%r\\" \%>s \%b \\"\%{Referer}i\\" \\"\%{User-Agent}i\\"" combined
CustomLog "logs/access_log" combined
LogFormat "\%h \%{LOCATION_ID}e \%{USER_ID}e \%t \\"\%r\\" \%>s \%b \\"\%{Referer}i\\" \\"\%{User-Agent}i\\" \\"\%{SID}e\\" \\"\%{DOMAIN_NAME}e\\" \\"\%{POST_DATA}e\\"" sdnfw

ServerSignature Off

BrowserMatch "Mozilla/2" nokeepalive
BrowserMatch "MSIE 4\.0b2;" nokeepalive downgrade-1.0 force-response-1.0
BrowserMatch "RealPlayer 4\.0" force-response-1.0
BrowserMatch "Java/1\.0" force-response-1.0
BrowserMatch "JDK/1\.0" force-response-1.0

AddType application/x-httpd-php .php

#SSLSessionCache dbm:/var/cache/httpd/ssl_cache
#SSLSessionCacheTimeout 300

#ProxyRequests Off

END

if ($ENV{PRELOAD_SDNFW}) {
	print <<END;

PerlRequire /code/sdnfw/startup.pl

END
}

#
# Virtual Hosts
#
print <<END;
<Location /server-status>
    SetHandler server-status
</Location>
END

if ($ENV{XML_STATUS}) {
print <<END;

<Location /server-status-xml>
	SetHandler server-status-xml
</Location>
END
}

print <<END;

NameVirtualHost $ENV{IP_ADDR}:$ENV{HTTP_PORT}
END

unless($ENV{NO_HTTPS}) {
	print <<END;
NameVirtualHost $ENV{IP_ADDR}:$ENV{HTTPS_PORT}
END
}


#
# Other projects as needed.
#
my $dir;
opendir $dir, "$ENV{HTTPD_ROOT}";
if ($ENV{LOAD}) {
	foreach my $d (split ' ', $ENV{LOAD}) {
		next if $d =~ m/^\./;
		next if $d eq 'conf';
		next unless -e "$ENV{HTTPD_ROOT}/$d/conf.pl";

		#print STDERR "Running $d/conf.pl" if ($ENV{HTTPD_DEV} || $ENV{HTTPD_LOCAL});
		require "$ENV{HTTPD_ROOT}/$d/conf.pl";
	}
} else {
	foreach my $d (readdir $dir) {
		next if $d =~ m/^\./;
		next if $d eq 'conf';
		next unless -e "$ENV{HTTPD_ROOT}/$d/conf.pl";

		#print STDERR "Running $d/conf.pl" if ($ENV{HTTPD_DEV} || $ENV{HTTPD_LOCAL});
		require "$ENV{HTTPD_ROOT}/$d/conf.pl";
	}
}

#print STDERR "Done loading conf.pl files" if ($ENV{HTTPD_DEV} || $ENV{HTTPD_LOCAL});

exit;
