#!/usr/bin/perl -w

my @ciphers =
(
	'Blowfish',
	'Blowfish_PP',
	'Camellia',
	'Camellia_PP',
	'CAST5',
	'CAST5_PP',
	'DES',
	'DES_EDE3',
	'DES_EEE3',
	'DES_PP',
	'IDEA',
	'NULL',
	'RC6',
	'Rijndael',
	'Rijndael_PP',
	'Skip32',
	'Twofish',
	'Twofish2',
	'XTEA',
	'XTEA_PP',
);

use Test::More tests => 9*20 + 4;

BEGIN { use_ok (Crypt::ECB) }

my $text = "This is just some dummy text!\n";
my $key  = "This is an at least 56 Byte long test key!!! It really is.";

my $crypt = Crypt::ECB->new(-key => $key);

# cipher loadable?
eval { $crypt->cipher('Unknown') };
ok($@ =~ /^Couldn't load/, 'cipher: module could not be loaded');

# custom padding without cipher specified?
eval { $crypt->padding(sub {}) };
ok($@ =~ /^Can't check/, 'padding: custom padding without cipher');

# check cipher is set
eval { $crypt->start('decryption') };
ok($@ =~ /^Can't start/, 'start: cipher not set');

foreach my $cipher (@ciphers)
{
	eval { $crypt->cipher($cipher) };
	SKIP: {	skip "$cipher not installed", 9 if $@;

		$crypt = Crypt::ECB->new(-cipher => $cipher);

		# custom padding works as expected?
		eval { $crypt->padding(sub {}) };
		ok($@ =~ /^Provided/, "custom padding not sensible ($cipher)");

		# check start is called before crypt
		eval { $crypt->crypt };
		ok($@ =~ /^You tried/, "crypt: start not called ($cipher)");

		# check start is called before finish
		eval { $crypt->finish };
		ok($@ =~ /^You tried/, "finish: start not called ($cipher)");

		# check mode is [^de]
		eval { $crypt->start('nonsense') };
		ok($@ =~ /^Mode has/, "start: mode not recognized ($cipher)");

		# check key is set
		eval { $crypt->start('decryption') };
		ok($@ =~ /^Key not set/, "start: key not set ($cipher)");

		# check start w/o finish before
		$crypt->key( substr($key, 0, $crypt->keysize || 56) );
		$crypt->start('encryption');
		$crypt->crypt($text);
		eval { $crypt->start('decryption') };
		ok($@ =~ /^Not yet/, "start: finish not called ($cipher)");
		$crypt->finish;

		# check padding is set when data % $bs
		$crypt->padding('none');
		eval { $crypt->encrypt($text) };
		ok($@ =~ /^Your message/, "_pad: no padding and no full block ($cipher)");

		# check padding is known
		$crypt->padding('unknown');
		eval { $crypt->encrypt($text) };
		ok($@ =~ /^Padding/, "_pad: padding not defined ($cipher)");

		#  same for truncating
		$crypt->padding('unknown');
		eval { $crypt->decrypt($text) };
		ok($@ =~ /^Padding/, "_truncate: padding not defined ($cipher)");
	}
}

#done_testing( 9*@ciphers + 4 );
