# Generated by default/object.tt
package Paws::LookoutEquipment::DataPreProcessingConfiguration;
  use Moose;
  has TargetSamplingRate => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutEquipment::DataPreProcessingConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutEquipment::DataPreProcessingConfiguration object:

  $service_obj->Method(Att1 => { TargetSamplingRate => $value, ..., TargetSamplingRate => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutEquipment::DataPreProcessingConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->TargetSamplingRate

=head1 DESCRIPTION

The configuration is the C<TargetSamplingRate>, which is the sampling
rate of the data after post processing by Amazon Lookout for Equipment.
For example, if you provide data that has been collected at a 1 second
level and you want the system to resample the data at a 1 minute rate
before training, the C<TargetSamplingRate> is 1 minute.

When providing a value for the C<TargetSamplingRate>, you must attach
the prefix "PT" to the rate you want. The value for a 1 second rate is
therefore I<PT1S>, the value for a 15 minute rate is I<PT15M>, and the
value for a 1 hour rate is I<PT1H>

=head1 ATTRIBUTES


=head2 TargetSamplingRate => Str

The sampling rate of the data after post processing by Amazon Lookout
for Equipment. For example, if you provide data that has been collected
at a 1 second level and you want the system to resample the data at a 1
minute rate before training, the C<TargetSamplingRate> is 1 minute.

When providing a value for the C<TargetSamplingRate>, you must attach
the prefix "PT" to the rate you want. The value for a 1 second rate is
therefore I<PT1S>, the value for a 15 minute rate is I<PT15M>, and the
value for a 1 hour rate is I<PT1H>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutEquipment>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

