package XML::CompareML::DTD::Generate;
$XML::CompareML::DTD::Generate::VERSION = '0.2.13';
use strict;
use warnings;


sub get_dtd
{
    return <<"EOF";
<!ELEMENT comparison (meta,contents)>
<!ELEMENT meta (implementations,timestamp?)>
<!ELEMENT implementations (impl+)>
<!ELEMENT impl (name,url?,fullname?,vendor?)>
<!ELEMENT name (#PCDATA)>
<!ELEMENT url (#PCDATA)>
<!ELEMENT fullname (#PCDATA)>
<!ELEMENT vendor (#PCDATA)>
<!ELEMENT contents (section)>
<!ELEMENT section (title,expl?,compare?,section*)>
<!ELEMENT title (#PCDATA)>
<!ELEMENT expl (#PCDATA|a|b)*>
<!ELEMENT compare (s+)>
<!ELEMENT s (#PCDATA|a|b)*>
<!ELEMENT a (#PCDATA|b)*>
<!ELEMENT timestamp (#PCDATA)>
<!ELEMENT b (#PCDATA)>
<!ATTLIST section id ID #REQUIRED>
<!ATTLIST a href CDATA #REQUIRED>
<!ATTLIST s id CDATA #REQUIRED>
<!ATTLIST impl id CDATA #REQUIRED>
EOF
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

XML::CompareML::DTD::Generate - generate the DTD for CompareML.

=head1 VERSION

version 0.2.13

=head1 SYNOPSIS

    use XML::CompareML::DTD::Generate;

    my $dtd_text = XML::CompareML::DTD::Generate::get_dtd();

=head1 FUNCTIONS

=head2 get_dtd()

Calculates and returns the DTD. Not exported.

=head1 AUTHOR

Shlomi Fish, L<http://www.shlomifish.org/>.

=head1 SEE ALSO

L<XML::CompareML>

=head1 COPYRIGHT AND LICENSE

Copyright 2004, Shlomi Fish. All rights reserved.

You can use, modify and distribute this module under the terms of the MIT X11
license. ( L<http://www.opensource.org/licenses/mit-license.php> ).

=for :stopwords cpan testmatrix url bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan

=head1 SUPPORT

=head2 Websites

The following websites have more information about this module, and may be of help to you. As always,
in addition to those websites please use your favorite search engine to discover more resources.

=over 4

=item *

MetaCPAN

A modern, open-source CPAN search engine, useful to view POD in HTML format.

L<https://metacpan.org/release/XML-CompareML>

=item *

RT: CPAN's Bug Tracker

The RT ( Request Tracker ) website is the default bug/issue tracking system for CPAN.

L<https://rt.cpan.org/Public/Dist/Display.html?Name=XML-CompareML>

=item *

CPANTS

The CPANTS is a website that analyzes the Kwalitee ( code metrics ) of a distribution.

L<http://cpants.cpanauthors.org/dist/XML-CompareML>

=item *

CPAN Testers

The CPAN Testers is a network of smoke testers who run automated tests on uploaded CPAN distributions.

L<http://www.cpantesters.org/distro/X/XML-CompareML>

=item *

CPAN Testers Matrix

The CPAN Testers Matrix is a website that provides a visual overview of the test results for a distribution on various Perls/platforms.

L<http://matrix.cpantesters.org/?dist=XML-CompareML>

=item *

CPAN Testers Dependencies

The CPAN Testers Dependencies is a website that shows a chart of the test results of all dependencies for a distribution.

L<http://deps.cpantesters.org/?module=XML::CompareML>

=back

=head2 Bugs / Feature Requests

Please report any bugs or feature requests by email to C<bug-xml-compareml at rt.cpan.org>, or through
the web interface at L<https://rt.cpan.org/Public/Bug/Report.html?Queue=XML-CompareML>. You will be automatically notified of any
progress on the request by the system.

=head2 Source Code

The code is open to the world, and available for you to hack on. Please feel free to browse it and play
with it, or whatever. If you want to contribute patches, please send me a diff or prod me to pull
from your repository :)

L<https://github.com/shlomif/xml-compareml>

  git clone git://github.com/shlomif/xml-compareml.git

=head1 AUTHOR

Shlomi Fish <shlomif@cpan.org>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/shlomif/xml-compareml/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by Shlomi Fish.

This is free software, licensed under:

  The MIT (X11) License

=cut
