package Daje::Database::Model::Super::Companies;
use Mojo::Base 'Daje::Database::Model::Super::Common::Base', -base, -signatures;

# Autogenerated class Thu Mar  6 17:15:18 2025
# Any manual changes to this class will be overwritten next time its generated

has 'fields' => "companies_pkey, editnum, insby, insdatetime, modby, moddatetime, company_type_fkey, homepage, name, phone, regno, vatno, workflow_fkey";
has 'primary_key_name' => "companies_pkey";
has 'table_name' => "companies";




sub load_pkey($self, $companies_pkey) {

    my $result = $self->load_pk(
        $self->table_name,
        $self->fields,
        $self->primary_key_name,
        $companies_pkey
    );
    return $result;
}


sub load_company_type_fkey($self, $company_type_fkey ) {

    my $result = $self->load_fkey(
        $self->table_name,
        $self->fields,
        'company_type_fkey',
        $company_type_fkey
    );
    return $result;
}



sub load_workflow_fkey($self, $workflow_fkey ) {

    my $result = $self->load_fkey(
        $self->table_name,
        $self->fields,
        'workflow_fkey',
        $workflow_fkey
    );
    return $result;
}




sub insert_companies($self, $data) {
    my $result = $self->insert($self->table_name, $data, $self->primary_key_name);
    return $result;
}


sub update_companies($self, $data, $keys) {
    my $result = $self->update($self->table_name, $data, $keys);
    return $result;
}


sub load_list($self, $key_value) {
    my $result = $self->load_a_list(
        $self->table_name,
        $self->fields,
        $key_value
    );
    return $result;
}




1;

