# Generated by default/object.tt
package Paws::IoTSiteWise::AccessPolicySummary;
  use Moose;
  has CreationDate => (is => 'ro', isa => 'Str', request_name => 'creationDate', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest'], required => 1);
  has Identity => (is => 'ro', isa => 'Paws::IoTSiteWise::Identity', request_name => 'identity', traits => ['NameInRequest'], required => 1);
  has LastUpdateDate => (is => 'ro', isa => 'Str', request_name => 'lastUpdateDate', traits => ['NameInRequest']);
  has Permission => (is => 'ro', isa => 'Str', request_name => 'permission', traits => ['NameInRequest'], required => 1);
  has Resource => (is => 'ro', isa => 'Paws::IoTSiteWise::Resource', request_name => 'resource', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::AccessPolicySummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::AccessPolicySummary object:

  $service_obj->Method(Att1 => { CreationDate => $value, ..., Resource => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::AccessPolicySummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationDate

=head1 DESCRIPTION

Contains an access policy that defines an identity's access to an AWS
IoT SiteWise Monitor resource.

=head1 ATTRIBUTES


=head2 CreationDate => Str

The date the access policy was created, in Unix epoch time.


=head2 B<REQUIRED> Id => Str

The ID of the access policy.


=head2 B<REQUIRED> Identity => L<Paws::IoTSiteWise::Identity>

The identity (an AWS SSO user, an AWS SSO group, or an IAM user).


=head2 LastUpdateDate => Str

The date the access policy was last updated, in Unix epoch time.


=head2 B<REQUIRED> Permission => Str

The permissions for the access policy. Note that a project
C<ADMINISTRATOR> is also known as a project owner.


=head2 B<REQUIRED> Resource => L<Paws::IoTSiteWise::Resource>

The AWS IoT SiteWise Monitor resource (a portal or project).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

