# Generated by default/object.tt
package Paws::Quicksight::Analysis;
  use Moose;
  has AnalysisId => (is => 'ro', isa => 'Str');
  has Arn => (is => 'ro', isa => 'Str');
  has CreatedTime => (is => 'ro', isa => 'Str');
  has DataSetArns => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Errors => (is => 'ro', isa => 'ArrayRef[Paws::Quicksight::AnalysisError]');
  has LastUpdatedTime => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has Sheets => (is => 'ro', isa => 'ArrayRef[Paws::Quicksight::Sheet]');
  has Status => (is => 'ro', isa => 'Str');
  has ThemeArn => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Quicksight::Analysis

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Quicksight::Analysis object:

  $service_obj->Method(Att1 => { AnalysisId => $value, ..., ThemeArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Quicksight::Analysis object:

  $result = $service_obj->Method(...);
  $result->Att1->AnalysisId

=head1 DESCRIPTION

Metadata structure for an analysis in Amazon QuickSight

=head1 ATTRIBUTES


=head2 AnalysisId => Str

The ID of the analysis.


=head2 Arn => Str

The Amazon Resource Name (ARN) of the analysis.


=head2 CreatedTime => Str

The time that the analysis was created.


=head2 DataSetArns => ArrayRef[Str|Undef]

The ARNs of the datasets of the analysis.


=head2 Errors => ArrayRef[L<Paws::Quicksight::AnalysisError>]

Errors associated with the analysis.


=head2 LastUpdatedTime => Str

The time that the analysis was last updated.


=head2 Name => Str

The descriptive name of the analysis.


=head2 Sheets => ArrayRef[L<Paws::Quicksight::Sheet>]

A list of the associated sheets with the unique identifier and name of
each sheet.


=head2 Status => Str

Status associated with the analysis.


=head2 ThemeArn => Str

The ARN of the theme of the analysis.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Quicksight>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

