package Net::Async::Spotify::Object::Generated::PlayHistory;

use strict;
use warnings;

our $VERSION = '0.002'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::PlayHistory - Package representing Spotify PlayHistory Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify PlayHistory Object attributes:

=over 4

=item context

Type:ContextObject
Description:The context the track was played from.

=item played_at

Type:Timestamp
Description:The date and time the track was played.

=item track

Type:SimplifiedTrackObject
Description:The track the user listened to.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        context => 'ContextObject',
        played_at => 'Timestamp',
        track => 'SimplifiedTrackObject',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
