package WebService::PayPal::PaymentsAdvanced::Role::HasTokens;
$WebService::PayPal::PaymentsAdvanced::Role::HasTokens::VERSION = '0.000008';
use Moo::Role;

use Types::Standard qw( Str );

has secure_token => (
    is       => 'lazy',
    isa      => Str,
    init_arg => undef,
);

has secure_token_id => (
    is       => 'lazy',
    isa      => Str,
    init_arg => undef,
);

sub _build_secure_token {
    my $self = shift;
    return $self->params->{SECURETOKEN};
}

sub _build_secure_token_id {
    my $self = shift;
    return $self->params->{SECURETOKENID};
}

1;

=pod

=encoding UTF-8

=head1 NAME

WebService::PayPal::PaymentsAdvanced::Role::HasTokens - Provides roles for dealing with secure tokens

=head1 VERSION

version 0.000008

=head2 secure_token

Returns C<SECURETOKEN> param

=head2 secure_token_id

Returns C<SECURETOKENID> param

=head1 AUTHOR

Olaf Alders <olaf@wundercounter.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by MaxMind, Inc..

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut

__END__

# ABSTRACT: Provides roles for dealing with secure tokens

