# --- Generated by classgen 3.03 on Fre Dez 29 21:56:52 MET 2000 ---

$VERSION=1.00;
	package Polygon;
	require 'Polygon_gs.pm';
	
	use Point;	# could have been specified in the control file as well

sub new {
	my ($self) = @_;

	# instance-variables:
	my @points;	# a list of Point-instances
	my $a_has;	# a 'has'-association

	$self=bless {
		_l_points		=>	\@points, @points,
		_a_has		=>	$a_has,
	}, ref($self)||$self;
	#$self->inherit_from($self->your_base::new());	# adapt when inheriting
	return $self;
}

# --- methods specific for this class ---------------------

sub specific {
	my ($self) = @_;
}

# --- added by the editor ;-) ------------------------------

sub add {		# add a new Point-instance
	my ($self, $x, $y) = @_;
	my $point=Point->new();		# alloc memory for new instance
	$point->set_x($x);			# init
	$point->set_y($y);			# init
	$point->set_a_belongs_to($self);	# associated with Polygon
	$self->push_points($point);	# new entry in internal list @points
}

sub delete {		# delete a Point-instance
	my ($self, $index) = @_;
	if($index<$self->get_N()) {
		my $rl=$self->get_rl_points();
		splice @$rl, $index, 1;	# remove
	}
}

sub get_N {		# returns the number of points of this Polygon
	my ($self) = @_;
	return scalar $self->get_l_points();
}

# --- inheritance methode -----------------------------------

sub inherit_from {
	my ($self, $base_blessed) = @_;
	my @l = keys %$base_blessed;
	foreach (@l) {
		$self->{$_} = $base_blessed->{$_};
	}
}

1;

__END__

=head1 NAME 

Polygon - A simple demo for a one-to-many association (/examples).

=head1 VERSION

1.00

=head1 SYNOPSIS

=head1 DESCRIPTION

This example is taken from Rumbaughs book, chapter 3.

A Polygon consist of at least 3 Points (many). In this simple demo there is no
checking on the minimum number of Points implemented.

The purpose is to show, how the one-to-many direction could be
implemented in  Perl. It turns out that there is no need to have an
explicit variable $a_has, like in the one-to-one case (cf
../one-to-one). 

Instead, the internal list @points takes this functionality. Each index
of this array is a unique identifier of an individual Point-instance.
See Polygon->add() for details.


You may think of further extensions of this simple Polygon class. E.g.
the Polygon could have a name. It could calculate its perimeter, area
etc.


=head1 ENVIRONMENT

=head1 DIAGNOSTICS

=head1 BUGS

=head1 FILES

=head1 SEE ALSO

	perldoc classgen
	perldoc many
	perldoc Point

=head1 AUTHOR

Name:  Michael Schlueter 

email: mschlue@cpan.org

=head1 COPYRIGHT

Copyright (c) 2000, Michael Schlueter. All Rights Reserved.
This module is free software. It may be used, redistributed
and/or modified under the same terms as Perl itself.
