# IUP::Gauge example

use strict;
use warnings;

use IUP ':all';

my $speed = 0.00001;

my $img_pause = IUP::Image->new( 1=>"0 0 0", 2=>"BGCOLOR", pixels=>[
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2],
 [2,2,2,2,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2] ]);

my $img_start = IUP::Image->new( 1=>"0 0 0", 2=>"BGCOLOR", pixels=>[
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,1,1,2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2],
 [2,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2],
 [2,2,2,2,1,1,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2],
 [2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2],
 [2,2,2,2,1,1,2,2,1,1,1,1,1,1,1,1,2,2,2,2,2,2],
 [2,2,2,2,1,1,2,2,2,2,1,1,1,1,1,1,2,2,2,2,2,2],
 [2,2,2,2,1,1,2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2],
 [2,2,2,2,1,1,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2] ]);

my $img_decelerate = IUP::Image->new( 1=>"0 0 0", 2=>"BGCOLOR", pixels=>[
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,1,2,2,2,2,1,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,1,1,2,2,2,1,1,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,1,1,1,2,2,1,1,1,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,1,1,1,1,2,1,1,1,1,2,2,2,2,2,2,2],
 [2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,1,1,1,1,2,1,1,1,1,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,1,1,1,2,2,1,1,1,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,1,1,2,2,2,1,1,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,1,2,2,2,2,1,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2] ]);

my $img_accelerate = IUP::Image->new( 1=>"0 0 0", 2=>"BGCOLOR", pixels=>[
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,1,2,2,2,2,1,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,1,1,2,2,2,1,1,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,1,1,1,2,2,1,1,1,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,1,1,1,1,2,1,1,1,1,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,2,2,2,2,2],
 [2,2,2,2,2,2,2,1,1,1,1,2,1,1,1,1,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,1,1,1,2,2,1,1,1,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,1,1,2,2,2,1,1,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,1,2,2,2,2,1,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2] ]);

my $img_show = IUP::Image->new( 1=>"0 0 0", 2=>"BGCOLOR", pixels=>[
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,1,1,2,2,2,2,1,1,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2],
 [2,2,2,2,2,1,2,2,2,1,1,1,2,2,2,2,1,2,2,2,2,2],
 [2,2,2,2,1,2,2,2,1,1,2,2,1,2,2,2,2,1,2,2,2,2],
 [2,2,2,1,2,2,2,2,1,1,1,2,1,2,2,2,2,2,1,2,2,2],
 [2,2,2,2,1,2,2,2,1,1,1,1,1,2,2,2,2,1,2,2,2,2],
 [2,2,2,2,2,1,2,2,2,1,1,1,2,2,2,2,1,2,2,2,2,2],
 [2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,1,1,2,2,2,2,1,1,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2],
 [2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2] ]);

my $gauge = IUP::Gauge->new(EXPAND=>"YES");
my $paused = 0;

sub idle_cb {
  my $value = $gauge->VALUE + $speed;
  $value = $gauge->MIN if $value > $gauge->MAX;
  $gauge->VALUE($value);
  return IUP_DEFAULT;
}

sub btn_start_cb {
  $gauge->VALUE($gauge->MIN);
  return IUP_DEFAULT;
}

sub btn_accelerate_cb {
  $speed *= 2;
  $speed = 1.0 if $speed > 1;
  return IUP_DEFAULT;
}

sub btn_decelerate_cb {
  $speed /= 2;
  return IUP_DEFAULT;
}

sub btn_show_cb {
  if ($gauge->SHOW_TEXT ne 'YES') {
    $gauge->SHOW_TEXT("YES");
    $gauge->DASHED("NO");
  }
  else {
    $gauge->SHOW_TEXT("NO");
    $gauge->DASHED("YES");
  }
  return IUP_DEFAULT;
}

sub btn_pause_cb {
  if ($paused) {
    IUP->SetIdle(\&idle_cb);
    $paused = 0;
  }
  else {
    IUP->SetIdle(undef);
    $paused = 1;
  }
  return IUP_DEFAULT;
}

my $hbox = IUP::Hbox->new(child=>[
        IUP::Fill->new(),
        IUP::Button->new(PADDING=>4, TITLE=>"pause", IMAGE=>$img_pause, TIP=>"Pause", ACTION=>\&btn_pause_cb),
        IUP::Button->new(PADDING=>4, TITLE=>"start", IMAGE=>$img_start, TIP=>"Start", ACTION=>\&btn_start_cb),
        IUP::Button->new(PADDING=>4, TITLE=>"decelerate", IMAGE=>$img_decelerate, TIP=>"Decelerate", ACTION=>\&btn_decelerate_cb),
        IUP::Button->new(PADDING=>4, TITLE=>"accelerate", IMAGE=>$img_accelerate, TIP=>"Accelerate", ACTION=>\&btn_accelerate_cb),
        IUP::Button->new(PADDING=>4, TITLE=>"show", IMAGE=>$img_show, TIP=>"Show", ACTION=>\&btn_show_cb),
        IUP::Fill->new(),
]);

my $vbox = IUP::Vbox->new(child=>[$gauge, $hbox], MARGIN=>"10x10", GAP=>5);

IUP->SetIdle(\&idle_cb);

# Shows dialog in the center of the screen
my $dlg  = IUP::Dialog->new( child=>$vbox, TITLE=>"IUP::Gauge Example" );
$dlg->ShowXY (IUP_CENTER, IUP_CENTER);
IUP->MainLoop;