# Generated by default/object.tt
package Paws::Pinpoint::CampaignSmsMessage;
  use Moose;
  has Body => (is => 'ro', isa => 'Str');
  has EntityId => (is => 'ro', isa => 'Str');
  has MessageType => (is => 'ro', isa => 'Str');
  has OriginationNumber => (is => 'ro', isa => 'Str');
  has SenderId => (is => 'ro', isa => 'Str');
  has TemplateId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Pinpoint::CampaignSmsMessage

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Pinpoint::CampaignSmsMessage object:

  $service_obj->Method(Att1 => { Body => $value, ..., TemplateId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Pinpoint::CampaignSmsMessage object:

  $result = $service_obj->Method(...);
  $result->Att1->Body

=head1 DESCRIPTION

Specifies the content and settings for an SMS message that's sent to
recipients of a campaign.

=head1 ATTRIBUTES


=head2 Body => Str

The body of the SMS message.


=head2 EntityId => Str

The entity ID or Principal Entity (PE) id received from the regulatory
body for sending SMS in your country.


=head2 MessageType => Str

The SMS message type. Valid values are TRANSACTIONAL (for messages that
are critical or time-sensitive, such as a one-time passwords) and
PROMOTIONAL (for messsages that aren't critical or time-sensitive, such
as marketing messages).


=head2 OriginationNumber => Str

The long code to send the SMS message from. This value should be one of
the dedicated long codes that's assigned to your AWS account. Although
it isn't required, we recommend that you specify the long code using an
E.164 format to ensure prompt and accurate delivery of the message. For
example, +12065550100.


=head2 SenderId => Str

The sender ID to display on recipients' devices when they receive the
SMS message.


=head2 TemplateId => Str

The template ID received from the regulatory body for sending SMS in
your country.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Pinpoint>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

