#!/usr/bin/perl -w
# based on he_free.bin
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 68) * 8 + 2;
BEGIN { use_ok("MPEG::Audio::Frame") };

$MPEG::Audio::Frame::free_bitrate = 120;

for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "frame is MPEG1");
	ok($frame->layer3, "frame is layer III");
	ok(!$frame->broken, "frame isn't broken");
	is($frame->sample, 44100, "sample rate");
	is($frame->bitrate, $MPEG::Audio::Frame::free_bitrate, "actual bitrate");
	ok($frame->free_bitrate, "free bitrate flag is true");
	ok($frame->stereo, "frame is stereo");
}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");

__DATA__
     :@CvHg, ]f5 ,y_kEc+s1,y_V27??,y_kEc+s1,y_V27??                  ,y_kEc+s1,y_V27??                                                                   :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                    :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                    :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                    :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                    :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                    :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                    :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                    :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                    :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                    :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                    :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                          ,y_kEc+s1,y_V27??                                                                  :@CvHg, ]f5                                                                                                                                                                                                         ,y_kEc+s1,y_V27??                                                                 
