#!/usr/bin/perl
#
# CC identification from
# http://www.mars-soft.net/downloads.htm
# http://en.wikipedia.org/wiki/List_of_Bank_Identification_Numbers#6270.2A.2A-6281.2A.2A

package Business::CCCheck::CardID;

use strict;
use warnings;

our $VERSION = '0.10';

use vars qw(
	@ISA
	@EXPORT
	%CCprimary
	%CCsecondary
	%enRoute
);
require Exporter;
@ISA = qw(Exporter);
@EXPORT = qw(
	%CCprimary
	%CCsecondary
	%enRoute
);

# hash's may contain ranges of the form 123-128
# use _re_range to expand ranges BELOW

%enRoute = (			# card that does not have parity
	2014	=> 'enRoute',
	2149	=> 'enRoute',
);

%CCprimary = (
	14983	=> 'UATP',
	20	=> 'Airlines',
	35	=> 'JCB',
	36	=> 'Diners Club International',
	37	=> 'American Express',
	4	=> 'VISA',
	5	=> 'MasterCard',
	6011	=> 'Discover',
	67	=> 'Maestro',
);

%CCsecondary = (
'100196'	=> 'ANA mileage card',
'1777'	=> 'PAG Airways UATP card',
'14653'	=> 'PAG Airways GOLD UATP card',
'201400'	=> 'Air Canada En Route',
'2018'	=> 'Canadian Pacific',
'2220'	=> 'Lufthansa Star Alliance GOLD',
'3560'	=> 'JCB Credit Card (Silver)',
'356210'	=> 'JCB Credit Card',
'356296'	=> 'Shinhan Card JCB Debit Card',
'356297'	=> 'Shinhan Card JCB URS Credit Card (Local)',
'3563'	=> 'JCB Credit Card (Gold)',
'356316'	=> 'JCB Credit Card (Silver)',
'356317'	=> 'JCB Credit Card (Gold)',
'3565'	=> 'JCB Credit Card (Corporate)',
'356800'	=> 'JCB Credit Card (Silver)',
'356801'	=> 'JCB Credit Card (Gold)',
'356803'	=> 'JCB Credit Card (Corporate, Silver)',
'356804'	=> 'JCB Credit Card (Corporate, Gold)',
'356820'	=> 'JCB Credit Card (Silver)',
'356895'	=> 'China UnionPay/JCB Credit Card',
'356900'	=> 'JCB Credit Card (Silver)',
'356901'	=> 'JCB Credit Card (Gold)',
'356902'	=> 'JCB Credit Card (Corporate)',
'356910'	=> 'JCB Credit Card (Corporate)',
'356911'	=> 'JCB Credit Card (Silver)',
'356912'	=> 'JCB Credit Card (Gold)',
'356914'	=> 'JCB Credit Card (Silver)',
'356915'	=> 'JCB Credit Card (Gold)',
'356916'	=> 'JCB Credit Card (Corporate)',
'3614'	=> 'Diners Club International',
'3616'	=> 'Diners Club International',
'3617'	=> 'Diners Club International',
'3633'	=> 'Diners Club International',
'3634'	=> 'Diners Club International',
'3635'	=> 'Diners Club International',
'3641'	=> 'Diners Club International',
'3643'	=> 'Diners Club International',
'3670'	=> 'Diners Club International',
'377750'	=> 'American Express Platinum LifeMiles',
'377753'	=> 'American Express Gold credit card',
'370244'	=> 'BANESCO (BancUnion) American Express Gold',
'370246'	=> 'Industrial and Commercial Bank of China',
'370285'	=> 'brooklyn Merchants Bank American Express Green Card',
'370286'	=> 'China Merchants Bank American Express Gold Card',
'3713'	=> 'American Express Costco Wholesale Card',
'3715'	=> 'American Express Centurion Card',
'3717'	=> 'American Express Platinum Card',
'3723'	=> 'American Express Costco Wholesale Card Platinum',
'372301'	=> 'American Express Gift Card (Canada)',
'372395'	=> 'Blue Cash American Express Card',
'372550'	=> 'Starwood Preferred Guest hotel loyalty credit card',
'372734'	=> 'Blue for Business credit (small business)',
'372888'	=> 'American Express Gold Card (USA)',
'3732'	=> 'American Express Blue Airmiles Cash Back Card (Canada)',
'3733'	=> 'American Express Blue Airmiles Card',
'3735'	=> 'American Express Gold Cash Back Card',
'3742'	=> 'Charge Card (UK)',
'374288'	=> 'Centurion Charge Card (UK)',
'374289'	=> 'Platinum Charge Card (UK)',
'3743'	=> 'American Express International Euro Charge Card (UK)',
'374328'	=> 'American Express Gift Card (Only at US merchants)',
'374345'	=> 'Citi American Express Cards (USA)',
'374350'	=> 'Citibank (American Airlines) American Express credit card',
'3745'	=> 'American Express International Dollar Charge Card (UK)',
'374614'	=> 'British Airways American Express Premium Plus Card',
'374622'	=> 'American Express Optima Credit Card (France)',
'374660'	=> 'American Express BMW Card',
'374661'	=> 'American Express BMW Card',
'374671'	=> 'Blue American Express Card',
'374691'	=> 'Platinum Credit Card (UK)',
'374693'	=> 'Platinum Credit Card (UK)',
'374801'	=> 'Platinum Charge Card (Finland)',
'374970'	=> 'Air France KLM Flying Blue co-branded Gold Charge Card',
'374996'	=> 'Corporate Card (France)',
'3750'	=> 'American Express Germany Products',
'3751'	=> 'American Express Finland',
'3752'	=> 'American Express Italy',
'3753'	=> 'American Express The Netherlands',
'3754150'	=> 'Commonwealth Bank of Australia Standard American Express',
'3754151'	=> 'Commonwealth Bank of Australia Gold American Express',
'3754155'	=> 'Commonwealth Bank of Australia Gold American Express',
'3754165'	=> 'Commonwealth Bank of Australia Platinum American Express',
'3755490'	=> 'American Express Blue Swedbank (Estonia)',
'3755492'	=> 'American Express Gold Swedbank (Estonia)',
'375622'	=> 'Garanti Bank American Express Green Card',
'375628'	=> 'Garanti Bank American Express Shop&Miles',
'375790'	=> 'American Express Sweden corporate card',
'3758'	=> 'American Express Switzerland corporate card',
'3759'	=> 'American Express Cathay Pacific Credit Card',
'3760'	=> 'American Express Card Australia',
'376211'	=> 'Singapore Airlines Krisflyer American Express',
'3763'	=> 'American Express Card (Hong Kong)',
'3764'	=> 'American Express Credit Card',
'3766'	=> 'Platinum Charge Card (Mexico)',
'3767'	=> 'Platinum Credit Card (Mexico)',
'376966'	=> 'China CITIC Bank American Express Card (PRC)',
'376968'	=> 'China CITIC Bank American Express Gold Card (PRC)',
'3770'	=> 'Lloyds TSB Airmiles Amex Card (UK)',
'377032'	=> 'American Express Corp-Banca',
'377064'	=> 'Lloyds TSB Airmiles Premier Amex Card',
'377100'	=> 'American Express Platinum Credit Card',
'3772'	=> 'Starwood Preferred Guest',
'377311'	=> 'MBNA Europe Bank',
'377311'	=> 'MBNA Europe Bank',
'377441'	=> 'American Express Black',
'377445'	=> 'BMW American Express',
'377481'	=> 'American Express',
'377662'	=> 'Swiss International Airlines Miles',
'3777'	=> 'ANZ American Express Frequent Flyer',
'377850'	=> 'Westpac American Express Card',
'377852'	=> 'Westpac American Express Platinum',
'337941'	=> 'Bank Millennium American Express Gold',
'377945'	=> 'American Express Corporate (Hungary)',
'377946'	=> 'American Express Corporate (Poland)',
'379108'	=> 'British Airways American Express Credit Card (UK)',
'379186'	=> 'Maybank American Express Credit Card (MY)',
'379196'	=> 'Blue Sky American Express Credit Card (UK)',
'379464'	=> 'Corporate card (US)',
'400115'	=> 'Visa Electron Barclays',
'400121'	=> 'Electron ROI',
'400344'	=> 'CapitalOne Platinum',
'400610'	=> 'META Bank, (Rewards 660 Visa)',
'402360'	=> 'Visa Electron from Poste Italiane',
'406366'	=> 'Guangdong Development Bank China Visa',
'40083739'	=> 'Electron GWK Bank NV',
'40093744'	=> 'Bank of China Great Wall Visa',
'400937'	=> 'CN BOC Great Wall International Card Corporate',
'400938'	=> 'CN BOC Great Wall International Card Corporate Gold',
'400941'	=> 'CN BOC Great Wall International Card',
'400942'	=> 'CN BOC Great Wall International Card Gold',
'400944'	=> 'Associated Bank (Citibank (South Dakota) N.A.)',
'401171'	=> 'Delta Community Credit Union Visa[1]',
'401106'	=> 'McCoy Federal Credit Union VISA debit',
'401180'	=> 'Suntrust Bank Debit Card[1]',
'4013'	=> 'Visa Debit Card',
'401343'	=> 'Tesco Bank Bonus Visa',
'401344'	=> 'Tesco Bank Clubcard Visa',
'4016'	=> 'Citybank (El Salvador)',
'401612'	=> 'Banco Tequendama Visa PLATINUM CARD',
'401773'	=> 'Electron ROI',
'401795'	=> 'NAB Visa Debit Card (Australia)',
'4018'	=> '1st Financial Bank USA',
'4019'	=> 'Wachovia Bank Visa',
'4026'	=> 'Nordea Bank, VISA Electron',
'4037'	=> 'US Bank Visa (USA)',
'404137'	=> 'Greater Building Society Visa Debit Card',
'404146'	=> 'National Development Bank Visa Classic',
'404527'	=> 'Cabelas Worlds Foremost Bank',
'404586'	=> 'Open Bank, Russia - Visa Platinum Transaero Card',
'404645'	=> 'US Bank Visa Debit Card (USA)',
'4028'	=> 'HSBC Philippine Airlines Mabuhay Miles',
'402802'	=> 'Handelsbanken Visa Credit/Debit Card',
'4029'	=> 'TD Bank Debit Card',
'403897'	=> 'Avangard Bank, Visa Credit/Debit Card',
'405670'	=> 'BRE Bank (mBank) Visa Electron Debit Card',
'4060'	=> 'CHASE Visa Debit/Credit',
'406774'	=> 'Visa Platinum',
'406742'	=> 'Entropay Virtual Visa Card USD',
'407220'	=> 'ANZ Frequent Flyer Gold Visa Card',
'407441'	=> 'CitiBank Patriot Memory Promo Debit Card',
'407444'	=> 'CSL Plasma',
'409311'	=> 'Branch Banking & Trust Classic',
'409617'	=> 'First Czech-Russian bank',
'41050406'	=> 'Bank Negara Indonesia (ID) Visa',
'41063539'	=> 'Aspire Visa Gold',
'410654'	=> 'Ithala Limited VISA Electron',
'410897'	=> 'The Golden 1 Credit Union (US) Visa Classic',
'411016'	=> 'BANESCO (former BancUnion Visa)',
'411298'	=> 'Lloyds TSB (UK) - Visa',
'411636'	=> 'Irish Life & Permanent PLC Visa',
'4117'	=> 'Bank of America VISA',
'411773'	=> 'Bank of America VISA',
'411911'	=> 'DBS (SG) VISA',
'411986'	=> 'Banca Transilvania Visa',
'411945'	=> 'Masterbank (Russia), Visa',
'412134'	=> '(PSECU) Credit Card',
'412266'	=> 'TD Bank Gift Card',
'4128'	=> 'Citibank (US) Platium Select Dividends VISA',
'41292123'	=> 'Visa Electron',
'412983'	=> 'MBNA University of Cambridge VISA',
'41298485'	=> 'Sovereign Bank - Visa',
'413433'	=> 'Sovereign Bank Business Check Card',
'414049'	=> 'Banca Transilvania - Visa Electron',
'414051'	=> 'Bank of Georgia (GE) - Visa Orange',
'414099'	=> 'Budapest Bank, Visa Electron',
'4143'	=> 'Capital One - Visa Card',
'414588'	=> 'Guaranty Bank Visa Debit card USA',
'4146'	=> 'Urban Trust Bank - Salute Visa Card',
'414711'	=> 'Citibank Visa Signature',
'414716'	=> 'Alaska Airlines Signature Visa',
'414720'	=> 'Chase VISA',
'4147463'	=> 'Citibank VISA',
'4147464'	=> 'Citibank VISA',
'4147808'	=> 'US Bank',
'414983'	=> 'Plumas Bank Visa Check Card',
'415045'	=> 'Kredyt Bank Visa Business Electron',
'415055'	=> 'Le Credit Lyonnais, France - Visa',
'415231'	=> 'Bancomer Debit Card',
'4153'	=> 'Visa Platinum Japan',
'415461'	=> 'Raiffeisen Bank (CZ) - Visa Debit',
'415874'	=> 'TD Bank (USA)',
'415929'	=> 'Cahoot (UK) - Visa Credit Card',
'415981'	=> 'Sovereign Bank - Visa Debit Card',
'416039'	=> 'ING Bank Sla;ski (PL) - Visa Electron',
'416451'	=> 'Fortis Bank (PL) - Visa Electron',
'416724'	=> 'Wells Fargo Bank Debit Visa USA',
'4166'	=> 'Kotak Mahindra Bank Gold Credit Card',
'416896'	=> 'Inteligo (PL) - Visa Electron',
'41700811'	=> 'Bank of America VISA',
'4172'	=> 'Credit Populaire d Algerie VISA',
'4177'	=> 'BC "Moldindconbank" S.A (Moldova)- Visa',
'417935'	=> 'Visa Electron',
'418122'	=> 'National Development Bank Visa prepaid',
'418221'	=> 'TD Bank in the United States',
'418224'	=> 'New Zealand Post (NZ) - Visa Loaded',
'418236'	=> 'Korea Exchange Bank - KEB VISA',
'418238'	=> 'UOB (SG) - Visa Platinum Debit Card',
'418307'	=> 'Green Dot Prepaid Visa debit card',
'4185'	=> 'Washington Mutual (US) - Visa Card',
'41900'	=> 'U.S. Bank (US) WorldPerks VISA',
'419661'	=> 'DongA Bank Vietnam - Visa credit Card',
'4197401'	=> 'Visa Electron',
'41977376'	=> 'Visa Electron',
'4241'	=> 'Visa Signature Scotiabank',
'420567'	=> 'Volkswagen Bank direct VISA',
'420571'	=> 'Forex Bank Visa Credit Card',
'420719'	=> 'US Bank debit card.',
'420767'	=> 'Chase VISA debit card',
'420796'	=> 'Banque Invik Everywhere VISA',
'420984'	=> 'Bank of Lees Summit, VISA',
'4213'	=> 'China Minsheng Bank VISA',
'421323'	=> 'ICICI Bank visa Gold',
'421324'	=> 'IndusInd Bank Visa',
'421325'	=> 'UTI Bank Prepaid Visa Card',
'421337'	=> 'Allahabad Bank Debit Card',
'421338'	=> 'Chequera Debit Card City',
'421355'	=> 'Interbank Visa',
'421402'	=> 'Citizens Bank of Canada Visa',
'421458'	=> 'Canara Bank',
'421494'	=> 'Asia Commercial Bank Vietnam - Visa',
'4216'	=> 'Debit Card Suruga bank (Japan)',
'4216'	=> 'Citizens Bank of Canada Visa',
'421630'	=> 'ICICI Bank Visa Gold',
'421689'	=> 'Commercial Bank, Sri Lanka - VISA',
'421764'	=> 'to 66 - Bank of America VISA',
'4218'	=> 'China Minsheng Banking Corporation VISA',
'422050'	=> 'SAMBIL MALL Servitebca Visa',
'422189'	=> 'GE Money (PL) - Visa',
'422287'	=> 'Raiffeisen bank Visa',
'4225842'	=> 'United Bank for Africa. Visa',
'4225846'	=> 'United Bank for Africa. Visa',
'422594'	=> 'United Bank for Africa. Visa',
'422629'	=> 'HSBC Bank (Turkey) VISA',
'422695'	=> 'Chase Bank (British Airways) Visa',
'422727'	=> 'Citibank Korea BC VISA Check Card',
'422793'	=> 'o2 money card (managed by Natwest)',
'4238'	=> 'Members Credit Union Visa Debit',
'42383701'	=> 'Sampopank (Estonia), Visa Premier',
'42383702'	=> 'Sampopank (Estonia), Visa Gold',
'4239'	=> 'St George Bank Visa Debit (Australia)',
'4241'	=> 'Silverton Bank (Gift Card)',
'424201'	=> 'Landesbank Baden-Wurttemberg',
'424327'	=> 'Skandiabanken Visa Credit Card',
'424631'	=> 'Chase Bank USA VISA',
'424339'	=> 'Skandiabanken Betal & Kreditkort Visa',
'424671'	=> 'Ing Bank Slaski SA (Poland)',
'4251'	=> 'Fidelity Debit Card issued by PNC',
'425435'	=> 'to 36 - Washington Mutual VISA',
'425522'	=> 'Columbus Bank and Trust',
'4256'	=> 'Bank of America GM Visa',
'425800'	=> 'M & T Bank Visa',
'425802'	=> 'M & T Bank Visa',
'425803'	=> 'M & T Bank Visa',
'425804'	=> 'M & T Bank Visa',
'425808'	=> 'M & T Bank Visa',
'425809'	=> 'M & T Bank Visa',
'425834'	=> 'M & T Bank Visa',
'425838'	=> 'M & T Bank Visa',
'425839'	=> 'M & T Bank Visa',
'4259'	=> 'Banco BICE (Chile) Gold Visa',
'425907'	=> 'Wells Fargo Business Platinum Check Visa',
'425914'	=> 'Compass Bank, Visa',
'426354'	=> 'Comdirect Bank (Germany) Visa',
'426376'	=> 'Standard Chartered Bank Bangladesh',
'426393'	=> 'Natwest UK Visa Credit card',
'426428-426429'	=> 'Bank of America Platinum Visa',
'426451-426452'	=> 'Bank of America Platinum Visa',
'426465'	=> 'Bank of America Platinum Visa',
'426488'	=> 'Code Credit Union (Dayton, Ohio)',
'426501'	=> 'HHonors Platinum Visa',
'426510'	=> 'Solutions Finance Credit Card (Barclaycard)',
'426534'	=> 'Citibank Australia Visa Platinum Card',
'426556-426558'	=> 'HSBC Bank VISA Credit Card',
'426588'	=> 'UOB Platinum Visa Credit Card (Singapore)',
'426569'	=> 'CitiBank Platinum Visa Credit Card (Singapore)',
'426655-426656'	=> 'Chase (formerly Bank One) Visa',
'426684'	=> 'Chase (formerly Bank One) Buy.com Visa Credit Card',
'426684'	=> 'Countrywide Visa Credit Card (2008)',
'426684'	=> 'Chase +1 Student Visa Card (2008)',
'426698'	=> 'First Command Financial Planning, Inc.',
'427010'	=> 'Industrial and Commercial Bank of China Visa',
'427019'	=> 'Industrial and Commercial Bank of China Visa',
'427020'	=> 'Industrial and Commercial Bank of China Visa',
'427028'	=> 'Industrial and Commercial Bank of China Visa',
'427029'	=> 'Industrial and Commercial Bank of China Visa',
'427030'	=> 'Industrial and Commercial Bank of China Visa',
'427038'	=> 'Industrial and Commercial Bank of China Visa',
'427039'	=> 'Industrial and Commercial Bank of China Visa',
'427062'	=> 'Industrial and Commercial Bank of China Visa',
'427064'	=> 'Industrial and Commercial Bank of China Visa',
'427085'	=> 'Industrial and Commercial Bank of China Visa',
'427208'	=> 'Mercedes Benz Bank',
'427229'	=> 'VTB24 (Russia), Visa Classic (Un)embossed',
'427342'	=> 'Lloyds TSB Business Debit Card',
'427557'	=> 'RBC Centura Bank Visa',
'4276'	=> 'Sberbank of Russia',
'427760'	=> 'Citibank, Russia',
'4279'	=> 'Sberbank of Russia, Visa Gold',
'4282'	=> 'Landesbank Berlin Visa Credit Card',
'428208'	=> 'Chase Debit Visa',
'4289150'	=> 'BRE Bank (MultiBank) Visa Platinum',
'4289151'	=> 'BRE Bank (MultiBank) Visa Aquarius',
'428333'	=> 'Prezzy card (New Zealand Post)',
'428418'	=> 'ASB Bank (New Zealand) Visa',
'428434'	=> 'Citizens Bank of Canada Prepaid Visa',
'428454'	=> 'Kiwibank (New Zealand) Visa Debit Card',
'429158'	=> 'Bank of Moscow (Russia) Visa Electron',
'429475'	=> 'Regions Bank Visa Debit Card[1]',
'429805'	=> 'First National Bank of Omaha Visa',
'429812'	=> 'First National Bank of Omaha Visa',
'430092'	=> 'Standard Chartered Platinum VISA',
'4301'	=> 'Chase Visa',
'430252'	=> 'Bank of Cyprus Greece Prepaid Visa',
'4304'	=> 'Barclays Bank Plc',
'430536'	=> 'Bank of America Visa',
'430544'	=> 'Bank of America Visa',
'430546'	=> 'Bank of America Visa',
'430550'	=> 'Bank of America Visa',
'430594'	=> 'Bank of America Visa',
'430552'	=> 'Summit Federal Credit Union Visa',
'430567'	=> 'Tesco Bank Classic Visa',
'430586'	=> 'Pennsylvania State Employees Credit Union Check Card',
'430605'	=> 'Affinity Plus Federal Credit Union Debit Card',
'4308'	=> 'Macys Visa',
'4311'	=> 'National City Bank Visa Credit Card',
'431170'	=> 'Rizal Commercial Banking Corporation Visa',
'4312'	=> 'Chase Leisure Rewards Visa',
'431239'	=> 'Citibank Australia VISA Debit Card',
'431261'	=> 'IWBank Visa',
'431262'	=> 'IWBank Visa Electron',
'431301'	=> 'to 05, 07, 08- Bank of America Preferred Visa',
'4315'	=> 'Silverton Bank NA',
'431732'	=> 'Plains Commerce Total Visa',
'4318'	=> 'S-Bank Visa',
'431930'	=> 'Halifax Ireland VISA Debit card',
'431931-431932'	=> 'Ulster Bank VISA Republic of Ireland',
'431935'	=> 'Permanent TSB VISA Republic of Ireland',
'4321'	=> 'Citizens Bank of Canada Visa',
'432158'	=> 'BA Finance/Credit Europe bank Visa',
'4323'	=> 'Wells Fargo Visa check card',
'432624-432630'	=> 'Bank of America Visa',
'4327'	=> 'North Carolina State Employees Credit Union VISA',
'432732'	=> 'Metabank Debit Card',
'432845'	=> 'Sovereign Bank Check Card',
'432919'	=> 'Cartasi Eura Visa Electron (Italy)',
'432901'	=> 'BRE Bank (MultiBank) Visa Classic Aquarius',
'432937'	=> 'BRE Bank (MultiBank) Visa Electron Aquarius',
'4329386'	=> 'BRE Bank (MultiBank) Visa Classic Aquarius',
'4329387'	=> 'BRE Bank (MultiBank) Visa Classic',
'432995'	=> 'TCF Visa Debit Card (USA)',
'4333'	=> 'Citibank Credit Card (Hong Kong)',
'433445'	=> 'BBVA Puerto Rico - Visa Electron',
'433507'	=> 'MBNA - Visa',
'433948'	=> 'Barclays & Times Card Visa Gold',
'433950'	=> 'Barclays & Yatra.com Platinum',
'433991'	=> 'Palm Desert National Bank as Cingular Wireless',
'4342'	=> 'Bank of America Classic Visa Credit Card',
'434254'	=> 'Best Bank',
'434256'	=> 'Wells Fargo Debit',
'434257'	=> 'Wells Fargo Debit',
'4343'	=> 'First Interstate Bank Visa Credit Card',
'4344'	=> 'Landesbank Berlin Holding Visa',
'4349'	=> 'Chase Card Services Canada Marriott Rewards Platinum Visa',
'435225'	=> 'Nordea Bank Visa Electron Debit Card (Poland)',
'4355'	=> 'U.S. Bank Premiere Line Visa Card',
'4356'	=> 'Target Corporation Visa Credit Card',
'4356'	=> 'Bank of America Visa Debit Card',
'435680-435690'	=> 'Bank of America Visa Platinum',
'435744'	=> 'ShenZhen Development Bank Visa',
'435760'	=> 'Compass Bank Visa',
'436338'	=> 'Landesbank Berlin AG (ADAC VISA Gold)',
'436618'	=> 'U.S. Bank Visa debit card',
'436610-436617'	=> '(formerly First USA)',
'436667'	=> 'Chase (formerly First USA)',
'4367'	=> 'China Construction Bank Credit Card',
'436742'	=> 'China Construction Bank Debit Card',
'436773'	=> 'National Bank of New Zealand Visa Credit Card',
'4377'	=> 'Panin Bank - Indonesia, Visa, Platinum Card',
'437737'	=> 'Barclay Debit Card (India)',
'4380'	=> 'Bank of China Olympics Visa Credit Card',
'438088'	=> 'Bank of China Visa Unionpay Gold Credit Card',
'4382'	=> 'UOB Campus Visa Debit Card (Singapore)',
'4384'	=> 'HSBC Visa Credit Card (India)',
'438617'	=> 'China Construction Bank (Asia) Finance Credit Card',
'438676'	=> 'Shinhan Card VISA Platinum Card',
'438755'	=> 'San Diego County Credit Union Visa Card',
'4388'	=> 'Capital One Visa Credit Card',
'438857'	=> 'Chase Bank (United Airlines) Visa credit card',
'4390'	=> 'ChequeMax (El Salvador)',
'4391'	=> 'Krungthai Bank - Platinum (Thailand)',
'439225-439227'	=> 'China Merchants Bank Visa Credit Card',
'440210'	=> 'Citibank Handlowy (PL) - Visa Silver',
'440211'	=> 'Citibank Handlowy (PL) - Visa Gold',
'440260'	=> 'Allied Irish Banks "Click" Visa Card',
'440319'	=> 'Schwab Bank Invest First Visa Signature',
'4404'	=> '(UBP-php)',
'4405'	=> 'Latvijas Kra-jbanka (LV)',
'440626'	=> 'Slovenska sporitel(n(a Visa Electron',
'440752'	=> 'C(SOB (CZ) - Visa Classic',
'440753'	=> 'C(SOB (CZ) - Visa Electron',
'4408'	=> 'Chase (AARP)',
'4412'	=> 'Deutsche Bank (DE) Gold Credit Card',
'441669'	=> 'MetaBank Visa Gift Card',
'441712'	=> 'First USA Bank, N.A.',
'442162'	=> 'British Telecom BT VISA',
'442518'	=> 'Wells Fargo Platinum Visa',
'442790'	=> 'Citizens Bank (RBS) Platinum Visa Debit Card',
'4428'	=> 'BECU Visa',
'4430'	=> 'PNC Bank (Debit Card)',
'4435'	=> 'Banner Bank VISA (Debit Card)',
'4432'	=> 'U.S. Bank',
'443233'	=> 'Shinhan Card (former LG Card)',
'443464'	=> 'Five Star Bank',
'4436'	=> 'PNC Bank Visa Points',
'444238'	=> 'SMP bank (Russia) Visa Classic',
'444400'	=> 'First US Bank',
'444512'	=> 'Fifth Third Bank',
'445093'	=> 'HSBC Vietnam - VISA Credit Card',
'445094'	=> 'HSBC Vietnam - VISA Credit Card',
'4451'	=> 'First Tennessee Bank (USA) VISA Debit Card',
'445479'	=> 'Keytrade Bank Visa Classic Credit Card',
'445480'	=> 'Keytrade Bank Visa Gold Credit Card',
'4458'	=> 'Nationwide Building Society (UK) - Plus',
'446053'	=> 'US Bank Visa Classic Debit Card USA',
'446155'	=> 'BRE Bank (CZ) - mBank Visa Electron',
'446157'	=> 'BRE Bank (PL) - mBank Visa Electron',
'446157'	=> 'BRE Bank (CZ) - mBank Visa Classic',
'446158'	=> 'BRE Bank (PL) - mBank Visa Electron',
'446153'	=> 'BRE Bank (CZ) - mBank Visa Gold',
'446261'	=> 'Lloyds TSB (UK) - Visa',
'446268'	=> 'Cahoot (UK) - Visa Debit',
'446272'	=> 'Lloyds TSB (UK) - Platinum Visa',
'446274'	=> 'Lloyds TSB (UK) - Premier Visa',
'446277'	=> 'Abbey (bank) - Business Banking Visa',
'446278'	=> 'Halifax (UK) - Visa debit card',
'446279'	=> 'Bank of Scotland (UK) - Visa',
'4465'	=> 'Wells Fargo (USA) - Visa Credit Card',
'4470'	=> 'M&I Marshall & Ilsley Bank (USA) - Visa',
'447320'	=> 'BC VISA Check Card issued by Woori Bank',
'447452'	=> 'Union Bank & Trust Company Visa',
'447692'	=> 'HSBC India Visa Silver',
'447747'	=> 'ICICI Bank Visa Gold',
'447817'	=> 'Promsvyazbank, Russia - Visa Gold',
'4479'	=> 'TCF Bank Debit Card',
'447935'	=> 'National City Bank Visa Debit Card',
'447995'	=> 'Old Navy Visa Credit Card',
'448156'	=> 'Chase Bank / MyECount.com Sprint Wireless',
'448336'	=> 'mBank (PL) - Visa credit card',
'448360'	=> 'Getin Noble Bank Visa Electron',
'448445'	=> 'Lloyds Bank - Visa Credit Card',
'4488'	=> 'Suntrust Bank - Visa Credit Card',
'4489'	=> 'National City Bank Visa',
'4492'	=> 'Vista Federal Credit Union Visa',
'449352'	=> 'Nationwide Building Society Visa',
'449364'	=> 'Valley Bank',
'449533'	=> 'Bank of America (USA) Visa',
'443438'	=> 'Credit Union Australia - Visa',
'4481'	=> 'BC Card VISA Check Card',
'4482'	=> 'TD Bank',
'448336'	=> 'BRE Bank (PL) - mBank Visa Classic',
'4490'	=> 'Community Trust Bank( Visa Debit Card)',
'4493'	=> 'Nicu Dinus Bank ( Cernavoda, Romania )',
'455788'	=> 'Visa BCP-Banco de Credito del Peru',
'4551'	=> 'Visa BBVA Banco Continental Peru',
'4500'	=> 'Canadian Imperial Bank of Commerce (CIBC) Visa',
'450003'	=> 'CIBC Infinite Aerogold VISA',
'450060'	=> 'CIBC Aerogold (VISA credit card)',
'450065'	=> 'CIBC Platinum (VISA credit card)',
'4502'	=> 'CIBC VISA',
'4503'	=> 'CIBC VISA',
'4504'	=> 'CIBC VISA',
'450405'	=> 'AEon Credit Service Credit Card',
'4505'	=> 'CIBC VISA',
'450605'	=> 'Bendigo Bank Visa Blue Debit Card',
'4506'	=> 'CIBC VISA Debit',
'4506'	=> 'Marfin Laiki Bank Visa Debit Card',
'4507'	=> 'St George Bank Visa Debit Card',
'4508'	=> 'Visa Electron - Popular Bank',
'450823'	=> 'Lloyds TSB VISA',
'450875'	=> 'Co-operative Bank Visa',
'450878'	=> 'Banco de Chile Visa',
'4509'	=> 'ANZ Bank Visa Credit Card',
'4510'	=> 'Royal Bank of Canada Visa',
'4511'	=> 'Seylan Bank, Sri Lanka',
'4512'	=> 'Royal Bank of Canada Visa',
'451291'	=> 'Bank of China - Visa Credit Card',
'4513'	=> 'Bancolombia (CB)',
'4514'	=> 'Royal Bank of Canada RBC AVION Visa',
'451503'	=> 'Royal Bank of Canada (CA) - VISA',
'4516'	=> 'RBC Banque Royale VISA',
'451834'	=> 'DBS Bank Credit Card (Hong Kong)',
'451845'	=> 'Shinhan Bank VISA Check Card',
'4519'	=> 'Royal Bank of Canada (ATM/INTERAC)',
'4520'	=> 'TD Bank CAD VISA',
'452088'	=> 'TD Bank CAD VISA infinite',
'4529'	=> 'MetaBank Visa',
'4530'	=> 'VISA Desjardins Group',
'453030'	=> 'NAB Gold Affinity',
'453231'	=> 'Banco Mercantil Venezuela Visa Card',
'4535'	=> 'Scotiabank - Visa Card',
'4536'	=> 'Scotiabank - Interac Debit Card',
'4537'	=> 'Scotiabank - Visa Card',
'4538'	=> 'Scotiabank - Visa Card',
'453801'	=> 'ScotiaBank - Visa Gold',
'453826'	=> 'ScotiaBank - Visa Infinite',
'453904'	=> 'Nordea (SE) - Visa Electron',
'453978'	=> 'Barclays Bank (UK) - Connect Visa',
'453979'	=> 'Barclays Bank (UK) - Connect Visa',
'453980'	=> 'permanent tsb Visa Credit Card',
'453997'	=> 'Friulcassa / CartaSi (IT) - Visa Card',
'453998'	=> 'CartaSi (IT) - Visa Card',
'4540'	=> 'Carte d acces Desjardins / VISA Desjardins',
'4541'	=> 'Standard Chartered Manhattan Platinum VISA',
'4542'	=> 'Rakuten Bank - Japan',
'4543'	=> 'Visa Debit UK',
'454305'	=> 'RBS Visa Credit Card',
'454312'	=> 'First Direct (UK) - Visa Credit Card',
'454313'	=> 'Nationwide Building Society (UK) - Visa',
'454361'	=> 'First Direct (a division of HSBC UK) Visa',
'454417'	=> 'Slovenska sporitel(n(a Visa',
'454434'	=> 'First Trust Bank (UK) - Visa Debit Card',
'454495'	=> 'Co-operative Bank (UK) - Visa Credit Card',
'4544'	=> 'Banque Laurentienne du Canada Visa',
'4545'	=> 'BANESCO Visa',
'454605'	=> 'Citibank Australia (AU) Visa Card',
'454718'	=> 'UOB (SG) ASTAR VISA Corporate Gold',
'454742'	=> 'Santander Visa Debit Card',
'454749'	=> 'BHW (DE) - Visa Charge Card',
'454867'	=> 'ASB Bank Visa Credit Card',
'454869'	=> 'Westpac New Zealand Visa',
'4549'	=> 'Banco Popular de Puerto Rico - Visa',
'455025'	=> 'Cooperative Bank (UK) - Visa',
'4551'	=> 'TD Bank/General Motors Corporation VISA',
'455121'	=> 'GM-Visa Card (CAD) issued by TDCanada Trust',
'4552'	=> 'Cooperative Bank (UK)',
'455271'	=> 'Bank of East Asia Classic Credit Card',
'455272'	=> 'Bank of East Asia Gold Credit Card',
'4553'	=> 'Wing Hang Bank Credit Card (Hong Kong)',
'455451'	=> 'ICICI Bank Visa Platinum Debit Card',
'4555'	=> 'Cooperative Bank Platinum VISA (UK)',
'4555'	=> 'Bank of Ceylon VISA Credit Card (UK)',
'455503'	=> 'Bancomer Azul Clasica Credit Card',
'4556'	=> 'Citibank Visa Vodafone (Greece)',
'4557'	=> 'Debit Card Bank of credit (PE)',
'455701'	=> 'National Australia Bank (AU) - GOLD VISA',
'455702'	=> 'National Australia Bank VISA (AU)',
'455707'	=> 'Hang Seng Bank Credit Card',
'4559'	=> 'CHASE Platinum VISA Credit Card',
'4560'	=> 'ANZ Visa Debit Card',
'4563'	=> 'BMW VISA ICS International',
'4563'	=> 'Citibank Malaysia (MY) - Visa',
'456351'	=> '(CN)Bank of China (China UnionPay)',
'456403'	=> 'Bank of Melbourne 1 (AU; now Westpac) - Visa',
'456406'	=> 'Challenge Bank (AU; now Westpac) - Visa',
'456413'	=> 'DEFENCE FORCE CREDIT UNION VISA',
'456414'	=> 'CREDIT UNION AUSTRALIA VISA',
'456432'	=> 'SUNCORP METWAY VISA',
'456443'	=> 'BENDIGO BANK LTD - BASIC BLACK VISA',
'456445'	=> 'STATE BANK VICTORIA - VISA',
'456448'	=> 'BANK OF QUEENSLAND VISA',
'456453'	=> 'ANZ Bank VISA Gift Card (Australia)',
'456462'	=> 'ANZ Bank VISA Credit Card (Australia)',
'456468'	=> 'ANZ Bank VISA Credit Card Frequent Flyer Platinum',
'456469'	=> 'ANZ Bank VISA Credit Card Gold (Australia)',
'456472'	=> 'Westpac Bank Altitude Visa Credit Card Platinum',
'456475'	=> 'Newcastle Permanent Building Society ltd VISA',
'456491'	=> 'ASB Bank (New Zealand)',
'4565'	=> 'ABSA VISA',
'456707'	=> 'Citibank (UK) Visa Prepaid card)',
'456735'	=> 'Alliance and Leicester VISA Debit Card (UK)',
'456738'	=> 'Citibank (UK) - Visa Debit Card (UK)',
'4568'	=> 'Berliner Bank (DE) - Visa Debit Card',
'4569'	=> 'Skandiabanken VISA Debit Card (NO)',
'4570'	=> 'DZ Bank VISA Credit Card (DE)',
'4571'	=> 'Danske Bank VISA Dankort',
'4579'	=> 'KB Card VISA Gold Card',
'4580'	=> '(IL) - Visa Card',
'458109'	=> 'Swedbank Visa Debit Card Sweden',
'458123'	=> 'Bank of Communications/HSBC (CN) Y-Power Visa',
'458440'	=> 'HSBC Vietnam - VISA Debit Card',
'4585'	=> 'HSBC Bank Australia VISA Debit Card',
'4587'	=> 'Peoples Trust Visa Gift Card',
'4599'	=> 'Caja Madrid (ES',
'4608'	=> 'Suncoast Schools Federal Credit Union',
'461983'	=> 'Best Buy Reward Zone/Chase (Canada)',
'465859'	=> 'Barclays Visa Debit (UK)',
'465904'	=> 'Santander Visa Debit (UK)',
'465942'	=> 'HSBC Visa Debit Card (UK)',
'468805'	=> 'Axis Bank Debit Card (India)',
'469568'	=> 'Dena Bank Debit Card (India)',
'467937'	=> 'Lakshmi Vilas Bank ( India)',
'470758'	=> 'US Bank, Visa Debit, USA',
'4715'	=> 'Wachovia VISA',
'4720'	=> 'HSBC VISA (Platinum?), Sri Lanka',
'472926'	=> 'Peoples Trust Vanilla Prepaid Visa Card',
'473099'	=> 'Wells Fargo Bank, Visa Debit, Iowa USA',
'473104'	=> 'Swiss International Airlines Miles & More Visa',
'4736'	=> '[GE Money Bank] Walmart Prepaid Visa',
'473702'	=> 'Wells Fargo, Visa card, USA',
'4744'	=> 'Bank of America Visa Debit',
'474480'	=> 'Bank of America Visa',
'475050'	=> 'JPMorgan Chase Visa Credit Card',
'475110'	=> 'Ulster Bank, Visa Debit, UK',
'475116'	=> 'RBS Royal Bank of Scotland, Visa Debit',
'475117'	=> 'RBS Royal Bank of Scotland, Visa Debit',
'475118'	=> 'RBS Royal Bank of Scotland, Visa Debit',
'475127'	=> 'to 30 Natwest Visa Debit',
'475131'	=> 'Nat West Visa Debit Card',
'475132'	=> 'Nat West Private Banking Visa Debit',
'475423'	=> 'MetaBank VISA TravelMoney, Debit',
'475427'	=> 'MetaBank Rebate Visa Card',
'475637'	=> 'WellsFargo Bank National Association Visa',
'475714'	=> 'Santander UK Visa Debit card',
'4757402'	=> 'Money Card (Ireland)',
'4758'	=> 'Oregon Community Credit Union',
'4760'	=> 'Bank Niaga (Indonesia) Visa',
'476072'	=> 'may be HR Block prepaid Visa',
'476164'	=> 'TCF Bank Saint Paul MN (USA) Visa',
'476515'	=> 'Venezolano de Credito Superefectiva Gold Visa',
'476559'	=> 'South Florida Educational Federal Credit Union Visa',
'4773'	=> 'Siam Commercial Bank - platinum (Thailand)',
'477361'	=> 'Big Sky Credit Union Visa (Australia)',
'477517'	=> 'JPMorgan Chase Bank N.A.',
'477548'	=> 'SEB - Visa debit (Estonia)',
'477596'	=> 'Sainsburys Bank (UK) - Visa Debit Card',
'4779'	=> 'Sainsburys Bank (UK) - Visa Debit Card',
'477915'	=> 'BZWBK (PL) - Visa Debit Card',
'478200'	=> 'BANK ONE - VISA CLASSIC -DEBIT',
'478825'	=> 'JPMorganChase Corporate Card',
'478880'	=> 'Umpqua Bank of Oregon Visa Debit Card',
'478901'	=> 'Vancity Visa credit card (Canada)',
'478907'	=> 'Vancity Visa credit card (Canada)',
'478986'	=> 'CIBC US Dollar Visa (Canada)',
'478992'	=> 'Heartland Credit Union (Springfield, IL)',
'479000'	=> 'Eurobank EFG (Bulgaria)VISA Credit card',
'479056'	=> 'First National Bank (South Africa) Visa Electron',
'479080'	=> 'Visa Credit card BZWBK Polish bank',
'479087'	=> 'Alfa bank (Russia), Visa Platinum',
'479144'	=> 'Georgia Federal Credit Union',
'479293'	=> 'Abbey International Visa Debit Card',
'479213'	=> 'TD Banknorth Visa Debit Card',
'479348'	=> 'Vision Banco Visa Debit Card (Paraguay)',
'4797'	=> 'SEB bankas Visa Debit Card (Lithuania)',
'479731'	=> 'Swedbank Visa Electron (Estonia)',
'479769'	=> '"Saint-Petersburg Bank", Russia',
'4798'	=> 'US Bank Visa Select Rewards Business Platinum',
'479884'	=> 'ETrade Visa Debit Card (U.S.)',
'4800'	=> 'MBNA Gold Visa Credit Card',
'480152'	=> 'Citigroup Inc. - MyECount.com Verizon Wireless',
'480183'	=> 'Community Business Bank',
'480213'	=> 'Capital ONE FSB Business',
'480641'	=> 'Commonwealth Credit Union Visa Debit Card',
'4807'	=> 'M&I Visa Credit Card',
'480801'	=> 'WellsOne Commercial Card',
'4809'	=> 'Charles Schwab Bank - Visa Platinum Check Card',
'4820'	=> 'Wings Financial FCU Credit Card',
'4824'	=> 'Wirecard Bank Visa Card',
'4828'	=> 'Wachovia Bank (US) - Visa Debit Card',
'482870'	=> 'Wachovia Bank (US) - Visa Debit Card',
'483542'	=> 'Standard Charterd Bank Vietnam - Visa',
'483561'	=> 'ANZ NATIONAL BANK LTD - Visa Debit Card',
'483583'	=> 'Sony Finance International Dual Currency (JPY/USD)',
'483585'	=> 'HSBC Revolution VISA Platinum Credit Card',
'483588'	=> 'Canada Post Visa Reloadable Prepaid Card',
'4841'	=> 'Old National Bank Commercial Debit Card',
'4842'	=> 'Maybank-issued Visa Credit Card (Malaysia)',
'4843'	=> 'Digital FCU Visa Gold Credit Card',
'484427'	=> 'Paypal (UK) - Top-up card (managed by RBS)',
'484432'	=> 'Bank Of Scotland (UK) - Visa Electron Card',
'4854'	=> 'Washington Mutual (US) - Visa Debit Card',
'4861'	=> 'Wings Financial FCU Check Card',
'4862'	=> 'Capital One Visa Credit Card',
'486236'	=> 'Capital One - Visa Platinum Credit Card',
'486269'	=> 'HSBC Platinum Visa Credit Card (India)',
'486430'	=> 'Lloyds TSB (UK) - Visa Card',
'486483'	=> 'HSBC (UK) - Commercial Visa credit Card',
'4867'	=> 'JP Morgan Chase Bank (US) - Visa Card',
'4868'	=> 'Wells Fargo (US) - Bank N.A. Check Card',
'486990'	=> 'Plumas Bank (California, US) - Visa',
'486993'	=> 'Umpqua Bank of Oregon (US) - Visa',
'4873'	=> 'Capital One Orbitz Visa Platinum',
'4888'	=> 'Bank of America (US) - Visa Credit Card',
'4892'	=> 'Columbus Bank and Trust Company Green dot NASCAR Visa',
'4893'	=> 'Nationwide Building Society (UK) Visa Select',
'488939'	=> 'Lakshmi Vilas Bank (India)',
'490115'	=> 'First National Bank VISA / Cedyna INC Visa',
'490220'	=> 'BC VISA Credit Card issued by Woori Bank',
'490292'	=> 'NAB VISA Gold Debit Card (Australia)',
'4903'	=> 'Switch (Debit Card)',
'4904'	=> 'Banner Bank VISA (Credit)',
'4905'	=> 'Switch (Debit Card)',
'4906'	=> 'Barclaycard VISA Credit Card (Germany)',
'4906'	=> 'BC VISA Credit Card (Korea)',
'490603'	=> 'BC VISA Credit Card Industrial Bank of Korea',
'490606'	=> 'BC VISA Credit Card Kookmin Bank',
'490611'	=> 'BC VISA Credit Card Nonghyup Central Bank',
'490612'	=> 'BC VISA Credit Card Nonghyup Local Banks',
'490620'	=> 'BC VISA Credit Card',
'490623'	=> 'BC VISA Credit Card SC First Bank',
'490625'	=> 'BC VISA Credit Card Hana Bank',
'490627'	=> 'BC VISA Credit Card Citibank in Korea',
'490678'	=> 'BC VISA Credit Card Shinhan Card',
'490696'	=> 'Citibank (Argentina)',
'490762'	=> 'Bayerische Landesbank VISA',
'4907'	=> 'Citibank Credit card (Japan)',
'490841'	=> 'Banco Espirito Santo Gold Visa',
'490847'	=> 'Parex Bank Visa Credit Card',
'4909'	=> 'Northern Rock - Building Society - Vida Debit Card',
'4910'	=> 'HSBC Bank VISA Credit Card (Sri Lanka)',
'491002'	=> 'Citibank (UK) AAdvantage Gold Visa Card',
'4911'	=> 'Switch (Debit Card)',
'4913'	=> 'Visa Electron',
'4914'	=> 'Banrisul Visa',
'4912'	=> 'HSBC UAE',
'4915'	=> 'Republic Bank Limited VISA (Trinidad & Tobago)',
'491611'	=> 'Halifax Ireland VISA Credit Card',
'4917'	=> 'Visa Electron',
'491731'	=> 'Abbey (bank) VISA Electron (UK)',
'491754'	=> 'Halifax VISA Electron (UK)',
'4918'	=> 'Caja Madrid VISA Business Credit Card',
'491859'	=> 'Danske Bank Privatkort Visa Electron',
'4919'	=> 'Charles Schwab Bank VISA Check Card',
'4920'	=> 'Luottokunta issued VISA - Citibank UAE Visa',
'492046'	=> 'Luottokunta issued VISA Gold (Finland)',
'4921'	=> 'Lloyds TSB Visa Debit Card',
'492111'	=> 'HSBC Visa Credit Card (Hong Kong)',
'492127'	=> 'HSBC Visa Credit Card (Bermuda)',
'492213'	=> 'Nedbank VISA Credit Card (ZA)',
'4925'	=> 'Visa Debit Card (Norway)',
'4929'	=> 'Visa Debit Card UK',
'492940'	=> 'Barclaycard Visa Credit Card',
'492942'	=> 'Barclaycard Premier and OnePulse Visa',
'492946'	=> 'Barclaycard Business Visa Credit Card',
'492949'	=> 'Barclaycard Visa Initial Credit Card',
'492160'	=> 'HSBC Visa Credit Card (Singapore)',
'4931'	=> 'Visa Citi AA - American Airlines (Dominican Republic)',
'493467'	=> 'Bank of China Olympics Visa Credit Card (Singapore)',
'493468'	=> 'Bank of China Platinum Visa Credit Card (Singapore)',
'4935'	=> 'Credito Siciliano Visa Electron (Italy)',
'4936'	=> 'Switch (Debit Card)',
'4937'	=> 'Standard Chartered Bank UAE issued Visa credit card',
'494053'	=> 'Commonwealth Bank VISA Credit Card (Gold)(Australia)',
'494052'	=> 'Commonwealth Bank VISA Credit Card (Australia)',
'494114'	=> 'National Bank of Abu Dhabi Cashplus Global Visa',
'494120'	=> 'HSBC Visa Gold Debit Card (United Kingdom)',
'4960'	=> 'Emporiki Bank Visa Credit Card (Greece)',
'496604'	=> 'HSBC Visa Credit Card (Hong Kong)',
'496645'	=> 'HSBC Visa Gold Credit Card (Singapore)',
'496696'	=> 'HSBC Visa Gold Credit Card (Bermuda)',
'497063'	=> 'La banque postale visa (France)',
'497128'	=> 'Natixis / Banque Populaire (France)',
'497160'	=> 'HSBC Visa Credit Card (France)',
'497164'	=> 'Banque Accord Visa Credit Card (France)',
'497251'	=> 'First Command Financial Planning, Inc.',
'497301'	=> 'Societe Generale CB Visa (France)',
'497302'	=> 'Societe Generale CB Visa (France)',
'4974'	=> 'BNP Paribas (France)',
'497543'	=> 'Natexis Banques Populaires Visa Credit Card (France)',
'497545'	=> 'Natexis Banques Populaires Visa Credit Card (France)',
'497618'	=> 'Boursorama Visa Credit Card (France)',
'497671'	=> 'Credit du Nord Visa Credit Card (France)',
'497652'	=> 'Barclays Bank PLC Visa Credit Card (France)',
'4978'	=> 'Caisse d Epargne VISA Credit Card (France)',
'497958'	=> 'Boursorama Banque VISA PREMIER credit card (France)',
'4984'	=> 'Banco do Brasil Ourocard Visa',
'498824'	=> 'The Co-operative Bank (incl Smile) Visa',
'499897'	=> 'DKB Deutsche Kreditbank AG Visa Charge Card (Germany)',
'499916'	=> 'Bank of New Zealand VISA Platinum Credit Card',
'499977'	=> 'Bank of New Zealand VISA Credit Card',
'500235'	=> 'National Bank of Canada ATM/Debit Card',
'500766'	=> 'Bank of Montreal ATM/Debit Card',
'501012'	=> 'Meridian Credit Union Debit and Exchange Network Card',
'502029'	=> 'ASPIDER Smartcards for Mobile Telecommunications',
'503615'	=> 'Standard Bank of South Africa Maestro Debit Card',
'504507'	=> 'Barnes & Noble Gift Card',
'504834'	=> 'ING Vysya Bank Maestro Debit/ATM Card',
'504837'	=> 'Fleet Bank ATM Only Card.',
'5049'	=> 'CitiBank Sears Card',
'510000'	=> 'Amro Bank',
'510001'	=> 'Agricultural Bank of Greece',
'510002'	=> 'Estonia Credit Bank',
'510003'	=> 'Samsung Card Co',
'510005'	=> 'HSBC',
'510008'	=> 'VSB International',
'510009'	=> 'Europay',
'510010'	=> 'Powszchny Bank Kredytowy Warsawie',
'510011'	=> 'Europay',
'510013'	=> '5100 14 SEMP',
'510015'	=> '5100 16 Agricultural Bank of Greece',
'510017'	=> 'Fimestic Bank',
'510018'	=> 'PKO Savings Bank',
'510019'	=> 'Budapest Bank Ltd Investment Card, embossed.',
'510021'	=> '5100 23 Europay',
'510024'	=> '5100 25 SEMP',
'510029'	=> 'VSB International',
'510030'	=> 'SEB Kort',
'510034'	=> 'Fimestic Bank',
'510035'	=> 'BY Belarus Bank',
'510036'	=> 'Sabadell Bank of Andorra',
'510037'	=> 'General Bank of Greece',
'510038'	=> '5100 39 Bank of Trade Unions Solidarity and Social Investment',
'510040'	=> '5-Star Bank',
'510060'	=> '5100 62 SEMP',
'510087'	=> 'Santander Bank Debit Card',
'510136'	=> 'CitiBank Gold Credit Card',
'510142'	=> 'CitiBank',
'510197'	=> 'UBS AG MasterCard',
'510241'	=> 'RBS',
'5108'	=> 'INGDirect Electric Orange Debit Card',
'510840'	=> 'The Bancorp Bank Higher One MasterCard Debit Card',
'510875'	=> 'Lake Michigan Credit Union MasterCard Debit Card',
'510982'	=> 'USAA USAA Cash Rewards Debit MasterCard',
'511000'	=> '5111 99 Chase Manhattan Bank USA',
'5112'	=> 'Chase Manhattan Bank USA',
'511300'	=> '5114 99 Chase Manhattan Bank USA',
'5115'	=> 'Chase Manhattan Bank USA',
'5116'	=> 'Chase Manhattan Bank USA',
'5117'	=> 'Chase Manhattan Bank USA',
'5118'	=> 'Chase Manhattan Bank USA',
'511810'	=> 'PayPal PayPal Secure Credit Card',
'5118'	=> 'Chase Manhattan Bank USA',
'5119'	=> 'Chase Manhattan Bank USA',
'512000'	=> 'Western States BankCard Association',
'512005'	=> 'Western States BankCard Association',
'512010'	=> 'Western States BankCard Association',
'512012'	=> 'Chase Manhattan Bank USA',
'512015'	=> 'Western States BankCard Association',
'512022'	=> 'Western States BankCard Association',
'512023'	=> 'International Card',
'512024'	=> 'Western States BankCard Association',
'512025'	=> '5120 27 Orchard Bank Credit Card HSBC',
'512105'	=> 'Western States BankCard Association',
'512106'	=> '5121 08 Sears National Bank Citi Sears MasterCard[1]',
'512109'	=> 'CL Corp Banca',
'512110'	=> '5121 11 Western States BankCard Association',
'512136'	=> 'Western States BankCard Association',
'5122'	=> 'Western States BankCard Association',
'5123'	=> 'Western States BankCard Association',
'512462'	=> 'Lotte Card MasterCard Gold Card',
'5125'	=> 'Western States BankCard Association',
'512551'	=> '5125 55 Europay 6000',
'512568'	=> 'Citi Gold MasterCard Citi Poland',
'512569'	=> 'Lloyds TSB',
'512607'	=> 'Continental Finance MasterCard $300 Limit',
'512622'	=> 'SBI Tata Card Mastercard Credit Card',
'512687'	=> 'Sainsbury Sainsbury Credit Card',
'5130'	=> 'Europay France',
'513100'	=> 'Europay France',
'513101'	=> 'Europay France Credit Agricole Gold MasterCard',
'5131'	=> 'Europay France',
'513141'	=> 'Europay France Credit Agricole MasterCard',
'513142'	=> 'Europay France',
'513143'	=> 'Europay France Advanzia Bank MasterCard',
'5131'	=> 'Europay France Advanzia Bank',
'5132'	=> 'Europay France',
'5133'	=> 'Europay France',
'5134'	=> 'Europay France',
'513453'	=> 'BNP Paribas MasterCard Credit Card',
'5135'	=> 'Europay France',
'513536'	=> 'Europay France BRED Banque Populaire Affinity MasterCard',
'5135'	=> 'Europay France',
'5136'	=> 'Europay France',
'513624'	=> 'Europay France - Barclays Bank PLC MasterCard Platinum',
'5136'	=> 'Europay France',
'513691'	=> 'Russian Standard Bank, Russia MasterCard Unembossed',
'5137'	=> 'Europay France',
'5138'	=> 'Europay France',
'513900'	=> 'Europay France',
'514011'	=> 'Integra Bank',
'514012'	=> 'CitiBank South Dakota',
'514013'	=> 'Elgin First Credit Union',
'514015'	=> 'Infibank',
'514016'	=> 'Miramar First Credit Union',
'514017'	=> 'Franklin Templeton Bank and Trust',
'514019'	=> '5140 20 Wells Fargo',
'514021'	=> 'Juniper Bank Now known as Barclays Bank PLC',
'514022'	=> 'Navy First Credit Union',
'514102'	=> 'Park National Bank',
'514108'	=> 'Paradigm Bank Texas',
'514253'	=> 'EDS Employees First Credit Union',
'514700'	=> 'Mascoma Savings Bank Business Mastercard Debit Card',
'514876'	=> 'CitiBank Platinum MasterCard',
'514889'	=> 'Juniper Bank Now known as Barclays Bank PLC',
'514923'	=> 'Chase Manhattan Bank USA',
'515854'	=> 'Citibank Citigold Debit Card',
'517644'	=> 'Miramar First Credit Union',
'516010'	=> 'Polbank EFG MasterCard Credit Card',
'516029'	=> 'CitiFinancial Shell/CitiFinancial Europe MasterCard',
'516300'	=> 'WestPac Banking Corporation',
'516310'	=> 'WestPac Banking Corporation',
'516315'	=> 'WestPac Banking Corporation',
'516319'	=> 'WestPac Banking Corporation Virgin MasterCard',
'516361'	=> 'Westpac Banking Corporation Visa Debit Card',
'516331'	=> 'Svyaznoy Bank',
'516335'	=> 'WestPac Banking Corporation',
'516337'	=> 'WestPac Banking Corporation Platinum MasterCard',
'5163'	=> 'WestPac Banking Corporation',
'517651'	=> '5-Star Bank',
'517652'	=> 'HDFC Bank MasterCard Gold Credit Card',
'517669'	=> 'HSBC MasterCard Credit Card',
'517805'	=> 'Capital One MasterCard',
'517869'	=> 'Union Bank MasterCard Debit Card',
'518126'	=> 'Utility Warehouse MasterCard PrePaid',
'518127'	=> 'Presidents Choice Financial MasterCard',
'518142'	=> 'MBNA MasterCard[citation needed]',
'518145'	=> 'Royal Bank of Scotland Tesco Bank Classic MasterCard',
'518152'	=> 'Tesco Bank ClubCard MasterCard Credit Card',
'518175'	=> 'MBNA British Midland Airways MasterCard',
'518176'	=> 'MBNA MBNA Ireland Platinum MasterCard',
'518791'	=> 'Lloyds TSB MasterCard CreditCard',
'519000'	=> 'Bank of Montreal',
'519113'	=> 'Bank of Montreal',
'519120'	=> '5191 23 Bank of Montreal',
'519129'	=> 'Bank of Montreal',
'519133'	=> 'Bank of Montreal',
'519140'	=> '5191 43 Bank of Montreal',
'519154'	=> 'Bank of Montreal',
'519161'	=> '5191 62 Bank of Montreal',
'519163'	=> 'NZ Kiwibank',
'519173'	=> 'Bank of Montreal',
'519180519183'	=> 'Bank of Montreal',
'519200519202'	=> 'Bank of Montreal',
'519220519223'	=> 'Bank of Montreal',
'519240519242'	=> 'Bank of Montreal',
'519244'	=> 'Bendigo Bank Business Blue Debit Mastercard',
'519259'	=> 'Bank of Montreal',
'519269'	=> 'Bank of Montreal USD Mastercard',
'519281'	=> 'Bank of Montreal',
'519283'	=> 'Bank of Montreal',
'519290'	=> 'Bank of Montreal',
'519293'	=> '5192 94 Bank of Montreal',
'519322'	=> '5193 23 Bank of Montreal',
'519332'	=> 'Bank of Montreal',
'519342'	=> 'Bank of Montreal',
'519371'	=> 'Bank of Montreal',
'519373'	=> 'Bank of Montreal',
'519381'	=> 'Bank of Montreal',
'519383'	=> 'Bank of Montreal',
'519390'	=> '5193 91 Bank of Montreal',
'519393'	=> '5193 95 Bank of Montreal',
'519400'	=> 'Bank of Montreal',
'519403'	=> 'Bank of Montreal',
'519409'	=> 'Bank of Montreal',
'519430519431'	=> 'Bank of Montreal',
'519433519434'	=> 'Bank of Montreal',
'519443'	=> 'Bank of Montreal',
'519463'	=> 'Banco De Oro MasterCard Debit Card',
'519490519491'	=> 'Bank of Montreal',
'519493519494'	=> 'Bank of Montreal',
'519520'	=> 'Altair Prepaid Cards',
'519525'	=> 'Contis Group & EZPay Prepaid Cards',
'519540519544'	=> 'Bank of Montreal',
'5122'	=> 'First Gulf Bank',
'5130'	=> 'Banque Postale (France)',
'5132'	=> 'Credit Mutuel MasterCard Credit Card (France)',
'5135'	=> 'BRED Banque Populaire MasterCard Credit Card',
'5141'	=> 'Banco Popular North America Mastercard Debit Card',
'5148'	=> 'US Airways Dividend Miles Platinum MasterCard',
'5150'	=> 'MetaBank MasterCard FSA debit card',
'5151'	=> 'OboPay Prepaid Debit Card Issued By First Premier',
'5155'	=> 'Orchard Bank HSBC',
'5156'	=> 'BestBuy MasterCard HSBC (previously Household Bank[3])',
'5176'	=> 'China Minsheng Bank MasterCard Credit Card',
'5177'	=> 'BANAMEX Debit Card',
'5179'	=> 'Bank Atlantic Mastercard Debit Card',
'5182'	=> 'Banco Nacional de Costa Rica Servibanca Debit Card',
'5185'	=> 'HONGKONG AND SHANGHAI BANKING CORPORATION, LTD., MasterCard',
'5187'	=> 'China Merchants Bank MasterCard Credit Card',
'518996'	=> 'UniCredit Bank, Russia',
'51639'	=> 'Westpac Australia Classic MasterCard[1]',
'5200'	=> 'MBNA Quantum MasterCard Credit Card',
'520169'	=> 'BestBuy MasterCard by Bank of Communications/HSBC',
'520306'	=> 'Citibank/Lufthansa Miles & More MasterCard',
'520641'	=> 'Tesco Bank Bonus Mastercard(UK)',
'520988'	=> 'Garanti Bank Shop&Miles MasterCard Credit Card',
'521324'	=> 'Tinkoff Credit Systems (Russia), MasterCard',
'521326'	=> 'SMP Bank (Russia), MasterCard Platinum Transaero Card',
'5217'	=> 'Commonwealth Bank of Australia Debit MasterCard',
'521804'	=> 'Tesco Bank Business Mastercard (UK)',
'521853'	=> 'PayPal MasterCard',
'5221'	=> 'MasterCard Credit Cards in South Africa',
'522182'	=> 'Peoples Trust (US)',
'522223'	=> 'Avangard Bank, Russia',
'522276'	=> 'Chase Manhattan Bank MasterCard Credit Card',
'5228'	=> 'Presidents Choice MasterCard Credit Card',
'5232'	=> 'Sparkasse Germany MasterCard Credit Card',
'5234'	=> 'Lufthansa Miles & More MasterCard Credit Card',
'523748'	=> 'Commonwealth Bank of Australia Mastercard',
'523911'	=> 'Affinity Bank',
'523912'	=> 'Affinity Bank',
'523951'	=> 'ICICI Bank MasterCard Credit Card',
'524040'	=> 'OCBC Bank BEST-OCBC MasterCard',
'5243'	=> 'Hudsons Bay Company MasterCard',
'525241'	=> 'Saison Card International United Airlines Mileage Plus',
'525405'	=> 'VuB Banka (Banca Intesa group) MasterCard',
'5255'	=> 'Mastercard CartaSi (Italy)',
'5256'	=> 'Sparda-Bank MasterCard Charge Card (Germany)',
'525678'	=> 'Banamex Debit card',
'5258'	=> 'Mastercard National Bank of Canada (Canada)',
'525896'	=> 'Mastercard Husky',
'5259'	=> 'Canadian Tire Bank Cash Advantage Platinum MasterCard',
'525995'	=> 'Canadian Tire Bank Gas Advantage MasterCard',
'5262'	=> 'Citibank MasterCard Debit Card',
'526219'	=> 'Citibank MasterCard American Airlines AAdvantage',
'526224'	=> 'Citibank MasterCard Debit Card',
'5264'	=> 'Bank Negara Indonesia MasterCard Debit Card',
'526418'	=> 'Vietcombank - Vietnam - MasterCard Debit Card',
'526468'	=> 'State Bank of India',
'526471'	=> 'POSBank MasterCard Debit/ATM Card (Singapore)',
'526495'	=> 'Bank of India MasterCard Debit/ATM Card',
'526702'	=> 'Yes Bank Mastercard Silver Debit Card (India)',
'526722'	=> 'Standard Bank South Africa MasterCard Credit Card (Gift Card)',
'526781'	=> 'VuB Banka (Banca Intesa group) - MasterCard',
'526790'	=> 'Asia Commercial Bank Vietnam - MasterCard Debit Card',
'5268'	=> 'Landesbank Berlin (Germany) MasterCard Credit Card',
'5268'	=> 'CitiBank Platinum Enrich (Canada) MasterCard Credit Card',
'527434'	=> 'Caixanova NovaXove (Spain) Mastecard Debit Card',
'527455'	=> 'Rubycard Pre-Paid Mastercard Newcastle Building Society',
'527456'	=> 'WireCard Bank (Germany)',
'5275'	=> 'Sampo Bank (Finland) MasterCard Debit Card',
'528013'	=> 'Bankwest Australia MasterCard Debit Card',
'528038'	=> 'ING Bank N.V. Amsterdam',
'528061'	=> 'BMO Bank of Montreal MasterCard Prepaid Travel',
'528093'	=> 'Banesto (Spain) Mastercard Prepaid Sevilla Futbol Club',
'528229'	=> 'Nexpay prepaid card',
'5286'	=> 'Santander Cards',
'5286'	=> 'ABSA MasterCard Credit Card',
'5286'	=> 'Virgin Money South Africa',
'528689'	=> 'Santander Zero MasterCard Credit Card UK',
'5287'	=> 'Washington Mutual Bank Debit card',
'5289'	=> 'ANZ Switch Platinum MasterCard',
'529480'	=> 'Santander [CONTIGO] Credit Card',
'529580'	=> '(Italy) Kalixa Prepaid MasterCard',
'529930'	=> 'Marks & Spencer Money MasterCard Credit Card',
'529962'	=> 'Prepaid MasterCards DCBANK. (MuchMusic)',
'529964'	=> 'Altair prepaid MasterCard',
'529965'	=> 'pre paid debit cards',
'529966'	=> 'pre paid debit cards',
'5301'	=> 'BarclayCard Mastercards.',
'5303'	=> 'BAC San Jose (Costa Rica) Debit card',
'530343'	=> 'Net1 Virtual Card Prepaid',
'530695'	=> 'Bancolombia Prepaid MasterCard',
'530785'	=> 'Sears MasterCard [Chase Cards Canada]',
'530831'	=> 'Orange Cash Prepaid MasterCard',
'531207'	=> 'Uralsib Bank (Russia), MasterCard',
'531306'	=> 'Moneybookers.com Prepaid Mastercard',
'531355'	=> 'National Bank MasterCard Credit Card',
'5316'	=> 'CUETS Financial Canada MasterCard Credit Card',
'5317'	=> 'CUETS Financial Canada Global Payment MasterCard',
'5322'	=> 'Washington Mutual Business Debit card',
'532450'	=> 'China Construction Bank Credit Card',
'532561'	=> 'HSBC Bank USA Premier Debit Mastercard with PayPass',
'5327'	=> 'Dexia banka Slovensko, a.s.; MasterCard credit PayPass',
'532700'	=> 'RBS Premium MasterCard Debit Card',
'5329'	=> 'MBNA Preferred MasterCard Credit Card',
'532902'	=> 'Wachovia Bank MasterCard Credit Card',
'533157'	=> 'RNKO, Euroset Kukuruza Bonus (Russia) Mastercard',
'533206'	=> 'Avangard Bank MasterCard Credit Card',
'533248'	=> 'Comerica Bank Mastercard prepaid',
'533838'	=> '[CBA] Prepaid Gift card as MasterCard',
'533846'	=> 'Kalixa Prepaid Mastercard UK Kalixa Prepaid MasterCard',
'533875'	=> 'Paypal Italy MasterCard Prepaid',
'533896'	=> 'Paypal Access Card (UK)',
'533908'	=> 'Bank Zachodni WBK Mastercard Premium',
'533936'	=> 'Kalixa Prepaid Mastercard DE Kalixa Prepaid MasterCard',
'535316'	=> 'Commonwealth Bank Standard MasterCard Credit Card',
'535317'	=> 'Commonwealth Bank Credit Card',
'535318'	=> 'Commonwealth Bank Gold MasterCard Credit Card',
'536386'	=> 'Barclaycard World Mastercard (UK)',
'537004'	=> 'RNKO, Russia, Svyaznoy MasterCard',
'538720'	=> 'BC Mastercard Woori Bank',
'538803'	=> 'BC Mastercard Industrial Bank of Korea',
'538806'	=> 'BC Mastercard Kookmin Bank',
'538811'	=> 'BC Mastercard Nonghyup Central Bank',
'538812'	=> 'BC Mastercard Nonghyup Local Banks',
'538820'	=> 'BC Mastercard',
'538823'	=> 'BC Mastercard SC First Bank',
'538825'	=> 'BC Mastercard Hana Bank',
'538827'	=> 'BC Mastercard Citibank in Korea',
'538878'	=> 'BC Mastercard Shinhan Bank',
'539028'	=> 'Citibank Mastercard (Brazil)',
'5396'	=> 'Saks Fifth Avenue World Elite MasterCard HSBC',
'539673'	=> 'Avangard Bank, MasterCard World Signia Card',
'5399'	=> 'ICICI Bank MasterCard debit Card',
'540034'	=> 'Standard Chartered Bank Titanium Credit Card (Hong Kong)',
'540002'	=> 'DBS (Esso co-branded) Singapore',
'5401'	=> 'Bank of America (formerly MBNA) MasterCard Gold Credit Card',
'540141'	=> 'BANESCO Classic Mastercard card (Venezuela).',
'540168'	=> 'Chase MasterCard Credit Card',
'540221'	=> 'ANZ National Bank ANZ MasterCard Credit Card',
'540223'	=> 'Westpac New Zealand MasterCard Credit Card',
'540207'	=> 'BNZ (Bank of New Zealand) Global Plus MasterCard Credit Card',
'5403'	=> 'Citibank MasterCard Credit Card ("Virtual Card" number)',
'5404'	=> 'Lloyds TSB Bank MasterCard Credit Card',
'540410'	=> 'Brown Thomas MasterCard (Issued by AIB)',
'540450'	=> 'Advanced Payment Solutions (APS)',
'540451'	=> 'Advanced Payment Solutions (APS)',
'5406'	=> 'Bancolombia MasterCard Credit Card (Colombia)',
'5407'	=> 'HSBC Bank GM Card',
'540758'	=> 'MBNA Bank UK bmi Blue Mastercard',
'5409'	=> 'HSBC Bank, Union Bank of California Pay Pass debit card',
'540801'	=> 'Household Bank USA MasterCard Credit Card',
'540806'	=> 'Hang Seng Bank Credit Card',
'540838'	=> 'BOC Great Wall Credit Card (CN)',
'540877'	=> 'Bank of China Platinum MasterCard Credit Card (SG)',
'541010'	=> 'Raiffeisen Zentralbank',
'541065'	=> 'Citibank MC',
'541142'	=> 'CIBC MasterCard',
'5412'	=> 'HSBC Malaysia issued Mastercard',
'541206'	=> 'USAA',
'54125602'	=> 'SEB Kort AB, Choice Club credit card (SE)',
'54125650'	=> 'SEB Kort AB, SJ Prio credit card (SE)',
'541277'	=> 'Nordea Finance/Valutakortet Valuta MasterCard',
'541330'	=> 'Mastercard test BIN for NIV, TIP certifiction',
'541592'	=> 'Neteller (UK) Mastercard debit card',
'5416'	=> 'Washington Mutual Platinum MasterCard',
'541606'	=> 'WestJet/RBC Royal Bank of Canada MasterCard',
'541657'	=> '(eBay MasterCard) via Providian',
'5417'	=> 'Chase Bank',
'5420'	=> 'MasterCard USAA, Mastercard John Lewis',
'5424'	=> 'Citibank MasterCard Credit Card',
'542418'	=> 'Citibank Platinum Select',
'5425'	=> 'Barclaycard MasterCard Credit Card (Germany)',
'542505'	=> 'RBS Gold Mastercard Credit Card (formerly ABN Amro Bank) (India)',
'542523'	=> 'Allied Irish Banks MasterCard Credit Card (Ireland)',
'54254200'	=> 'GE Money Bank Mastercard debit card (SE)',
'54254207'	=> 'GE Money Bank Mastercard credit card (SE)',
'542598'	=> 'Bank of Ireland Post Office Platinum Card (UK)',
'5426'	=> 'Alberta Treasury Branch',
'5430'	=> 'ANZ Bank MasterCard',
'5430'	=> 'Stockmann Department Store Mastercard, Nordea (Finland)',
'543034'	=> 'Stockmann Department Store Exclusive Mastercard',
'543122'	=> 'HSBC issued Mastercard (Hong Kong)',
'543250'	=> 'Bank of New Zealand MasterCard Credit Card',
'543267'	=> 'Bank of Ireland MasterCard Credit Card',
'5434'	=> 'MasterCard credit cards from UK and Irish banks',
'543429'	=> 'Halifax One Mastercard',
'543458'	=> 'HSBC UK Premier Credit Card',
'543460'	=> 'HSBC Mastercard Credit Card (UK)',
'543478'	=> 'National Irish Bank Mastercard',
'543479'	=> 'National Irish Bank Gold Mastercard',
'543556'	=> 'NatWest Mastercard Charge Card',
'543678'	=> 'Westpac New Zealand Mastercard Gold Credit Card',
'543482'	=> 'RBS Mastercard Credit Card',
'543696'	=> 'Itau Mastercard Credit Card',
'543699'	=> 'NatWest MasterCard Gold Credit Card',
'5437'	=> 'St George Bank Credit Card (Australia)',
'5438'	=> 'USAA Federal Savings Bank',
'5440'	=> 'Mastercard from MBF Malaysia',
'544156'	=> 'Allied Irish Banks Gold MasterCard Credit Card',
'5442'	=> 'HSBC Mastercard Credit Card (Singapore)',
'544258'	=> 'BRE Bank (MultiBank) Mastercard Aquarius',
'544291'	=> 'Kiwibank Go Fly MasterCard Standard (NZ)',
'5443'	=> 'HSBC MasterCard Debit Card with PayPass (USA)',
'5444'	=> 'Bangkok Bank (Thailand)',
'5444'	=> 'BHW MasterCard Charge Card (Germany)',
'544434'	=> 'Wizard Clear Advantage MasterCard (Australia)',
'544440'	=> 'Valovis Bank, Prepaid MasterCard Debit(Germany)',
'5446'	=> 'Canadian Tire MasterCard Credit Card',
'544748'	=> 'Chase SLATE MasterCard Credit Card',
'544917'	=> 'Citizens Bank (Personal Checking) Debit',
'545045'	=> 'Danske Bank Intercard MasterCard debit card (SE)',
'5451'	=> 'NatWest Mastercard Credit Card',
'545157'	=> 'Masterbank (Russia), MasterCard World Signia',
'5452'	=> 'MBNA Canada Mastercard',
'545250'	=> 'Maestro (debit card) BZWBK Poland',
'54546'	=> '- Natwest Student Mastercard (UK)',
'5455'	=> 'BancorpSouth Mastercard MasterMoney Debit Card',
'545511'	=> 'Masterbank (Russia) MasterCard Gold Debit Card',
'545578'	=> 'Halifax MasterCard (UK)',
'5457'	=> 'Capital One Canada Branch',
'5457'	=> 'Dexia banka Slovensko, a.s.; Mastercard Gold',
'5458'	=> 'USAA Credit Card',
'5459'	=> 'Harris Bank Debit Card',
'545955'	=> 'Mascoma Savings Bank Mastercard Consumer Debit Card',
'5460'	=> 'Berliner Bank (Germany),Mint MasterCard',
'546286'	=> 'Dexia banka Slovensko,a.s.; MasterCard Red',
'5466'	=> 'Citibank, MBNA & Chase World MasterCard',
'546604'	=> 'First USA Banke, N.A. Master Card',
'546641'	=> 'HSBC GM MasterCard Credit Card',
'546680'	=> 'HSBC GM MasterCard Credit Card',
'5469'	=> 'Sberbank of Russia',
'547046'	=> 'Santander Uni-k Credit Card (Mexico)',
'5471'	=> 'Davivienda MasterCard Credit Card (Colombia)',
'547343'	=> 'ANZ Business MasterCard (New Zealand)',
'547347'	=> 'HSBC Commercial Card (UK in L)',
'547356'	=> 'RBS Royal Bank of Scotland',
'547367'	=> 'NatWest (RBS)',
'547372'	=> 'Swedbank, Estonia, MasterCard Business Card',
'5474'	=> 'Wells Fargo Bank BusinessLine credit card (US)',
'548009'	=> 'Fifth Third Bank',
'548045'	=> 'BANCO BRADESCO S.A. (BRAZIL)',
'5483'	=> 'HypoVereinsbank (Germany)',
'548652'	=> 'Banco de Chile Master Card Credit Card',
'548653'	=> 'Banco de Chile Master Card Credit Card RUA',
'548673'	=> 'Alfa-Bank/Aeroflot-bonus, M-Video bonus debit Card',
'548674'	=> 'Alfa-Bank Credit Card (Russia)',
'548805'	=> 'Hatton National Bank, Sri Lanka RUA',
'548901'	=> 'Banco Santander MasterCard debit card',
'548912'	=> 'Banco Santander MasterCard debit card with chip (Spain)',
'548955'	=> 'HOUSEHOLD BANK',
'54896'	=> 'Industrial and Commercial Bank of China Peony American Express',
'5490'	=> 'MBNA & Chase Platinum MasterCard Credit Cards',
'549035'	=> 'MBNA American Bank',
'549099'	=> 'MBNA American Bank',
'5491'	=> 'AT&T Universal MasterCard',
'549104'	=> 'Chase Manhattan Bank USA, N.A.',
'549110'	=> 'HSBC Bank Nevada Platinum Mastercard',
'549113'	=> 'Citibank MC',
'549123'	=> 'USAA Federal Savings Bank Platinum',
'549409'	=> 'HSBC Bank Nevada, NA Premier World Mastercard',
'549471'	=> 'Qantas Woolworths Everyday Mastercard (HSBC)',
'540041'	=> 'HSBC Bank Gold Malaysia',
'550619'	=> '"Skycard" MasterCard',
'551128'	=> 'ITS Bank/SHAZAM (Interbank Network) Mastercard',
'551167'	=> 'ITS Bank/SHAZAM (Interbank Network) Mastercard',
'551445'	=> 'Cambridge Trust Company in Massachusetts, USA',
'5520'	=> 'DBS POSB Everyday Platinum Mastercard',
'552016'	=> 'Bank of China International MasterCard Platinum',
'552033'	=> 'Commonwealth Bank Platinum Awards MasterCard',
'552038'	=> 'POSB (DBS Bank) everyday Platinum MasterCard',
'552093'	=> 'Citibank Mastercard Platinum Credit Card',
'5521'	=> 'BC Platinum Mastercard',
'552157'	=> 'Lloyds TSB Platinum Mastercard',
'552188'	=> 'Tesco Bank Finest Platinum Mastercard (UK)',
'5522'	=> 'NatWest Platinum Mastercard',
'5523'	=> 'MBNA Smart Cash World MasterCard (Canada)',
'55456789020'	=> 'BC Card',
'552724'	=> 'Danske Bank MasterCard Direkt debit card (SE)',
'5528'	=> 'Diners Club',
'553421'	=> 'Bank of Scotland Mastercard',
'553823'	=> 'MIT Federal Credit Union Debit Mastercard',
'553877'	=> 'Star Processing PrePaid Mastercard',
'553985'	=> 'First National Bank in Edinburg, USA',
'554346'	=> 'Kookmin Bank Mastercard "Free Pass" Debit Card',
'554544'	=> 'Bank of Ireland',
'554564'	=> 'Onyxcard',
'554619'	=> 'Citibank Mastercard Silver Credit Card (India)',
'554641'	=> 'Euro Kartensysteme Eurocard und Eurocheque gmbh',
'554827'	=> 'POSBank MasterCard Debit Card (Singapore)',
'555005'	=> 'Commonwealth Bank of Australia Corporate Mastercard',
'556951'	=> 'Nat West Bank Mastercard',
'557098'	=> 'Aqua Card Mastercard (UK)',
'5573'	=> 'Metro Bank MasterCard Debit Card',
'557505'	=> 'Bank Handlowy Mastercard Electronic Pay Pass',
'557510'	=> 'BRE Bank Mastercard Aquarius PayPass',
'557513'	=> 'BRE Bank Mastercard PayPass',
'557552'	=> 'Ally Bank Platinum Debit Card',
'557843'	=> '"Goldfish" MasterCard',
'557892'	=> 'MasterCard Credit Card issued in Nordea Denmark',
'557905'	=> 'Santander Mexico Debit Card',
'557907'	=> 'Santander Mexico Debit Card',
'558108'	=> 'Citizens Bank',
'558158'	=> 'Paypal MasterCard',
'5588'	=> 'Citibank MasterCard',
'558818'	=> 'MasterCard Credit Card "Business Platinum" India',
'558846'	=> 'FIA',
'560017'	=> 'Comdata Card',
'560054'	=> 'HSBC Bank USA, N.A. Maestro card',
'560279'	=> 'Commonwealth Bank of Australia Key Card',
'560373'	=> 'Alliance and Leicester cash deposit card',
'561059'	=> 'Australian Bank Card',
'561066'	=> 'HSBC Bank Canada ATM Card',
'561150'	=> 'Chase (USA), ATM Card',
'564100'	=> 'Santander UK cash card',
'564104'	=> 'Nationwide',
'564120'	=> 'Nationwide Cashbuilder ATM card.',
'564182'	=> 'Switch (debit card) Debit Card',
'565659'	=> 'Banco Santander Ferrari MasterCard',
'574085'	=> 'Banco Santander Puerto Rico ATM/debit',
'581353'	=> 'Vancity ATM Card',
'581828'	=> 'Credit Union (Ontario) debit cards',
'585048'	=> 'Suntrust Banks - ATM Card',
'585210'	=> 'Citibank Greece ATM Card',
'586357'	=> 'Branch Banking and Trust (BB&T) ATM Card',
'587781'	=> 'Bank of America ATM Card',
'589297'	=> 'TD Canada Trust Interac/ATM Card',
'589562'	=> 'TARJETA NARANJA (Argentina)',
'588644'	=> 'Citibank Korea International ATM Card',
'589242'	=> 'National Bank of Greece Greece Debit Card',
'589261'	=> 'Maestro (debit card) Pekao',
'589460'	=> 'Choice Card, HSBC, for the Cold Storage chain',
'589732'	=> 'Digital TV Converter Box $40.00 Coupons',
'5898'	=> 'All Korean Banks ATM/DEBIT Card',
'589856'	=> 'Standard Chartered Bank ATM Card',
'5899'	=> 'MCB',
'600229'	=> 'Wegmans Shoppers Card',
'600292-600294'	=> 'Hudsons Bay Company',
'600315'	=> 'Safeway',
'600649'	=> 'Lowes Home Improvement Center gift card',
'601056'	=> 'ValueLink stored value (Starbucks, Borders Books, ...)',
'601021'	=> 'ARI Canada - Ontario government',
'6011'	=> 'Discover Card Credit Card',
'6012'	=> 'BANESCO (former BancUnion) Maestro Debit card',
'601382'	=> 'Bank of China Unionpay Debit card',
'6016'	=> 'Bancolombia',
'601725'	=> 'ING Direct Canada ATM Card',
'601859'	=> 'A GAP card - GE Money Bank.',
'601887'	=> 'Presidents Choice Financial Canada Debit Card',
'6019'	=> 'Brandsmart USA Credit Card',
'602700'	=> 'Wichita State University "Shocker Card"',
'602969'	=> 'CN Bank of Beijing Debit Card Visa',
'603207'	=> 'Shoppers Drug Mart Optimum Program',
'603220'	=> 'Walmart Credit Card',
'603367'	=> '(CN) Bank of Hangzhou Debit Card',
'603411'	=> 'Palm Desert National Bank',
'603450'	=> 'Starbucks Card (Starbucks Europe Ltd)',
'6035'	=> 'Citibank (Home Depot) Card',
'603528'	=> 'STAPLES Canada Enterprise Credit Card',
'603692'	=> 'Stockmann Card',
'603753'	=> 'McDonalds Gift Card (serviced by ValueLink)',
'603798'	=> 'KiwiBank Debit Card (Cirrus)',
'603948'	=> 'OBI Petrol Card',
'6041'	=> 'Walmart Canada Gift Card',
'6044'	=> 'Ikea Credit Card (Citi Cards Canada)',
'6045'	=> 'Lowes (Canada) (GE Money Canada)',
'604646'	=> 'Scene LP (Cineplex Entertainment)',
'604767'	=> 'More Rewards (Overwaitea Food Group loyalty card)',
'604809'	=> 'Svyaznoy Club loyalty card',
'604976'	=> 'Tim Hortons QuickPay Tim Card',
'6051'	=> 'Starbucks Card - USA & Canada',
'6060'	=> 'Shinhan Card',
'606095'	=> 'Starbucks Card - Europe',
'606172'	=> 'Club Sobeys (Canada)',
'606179'	=> 'Commonwealth Finance Solutions Ltd',
'606263'	=> 'MoneyTech Inc. - Brazil',
'606469'	=> 'Revolution MoneyExchange',
'606484'	=> 'PRJ Financial Services - Karum Group LLC',
'606934'	=> 'Starbucks Card - Korea',
'607120'	=> 'Starbucks Card - Korea',
'620013'	=> 'Bank of Communications Hong Kong China CUP Gift Card',
'620021'	=> 'Bank of Communications China Prepaid Card (China)',
'621019'	=> 'Zheshang Bank Debit Card (CN)',
'621041'	=> 'Bank of China (Hong Kong) BOC Card - Debit (HK)',
'621060'	=> 'Woori Bank UnionPay Shanghai Tourism Card (CN)',
'622141'	=> 'Zhejiang Tailong Commercial Bank Debit Card (CN)',
'622200'	=> 'CN ICBC Peony Money Link Card',
'622201'	=> 'CN ICBC Peony Money Link Card',
'622202'	=> 'CN ICBC Peony Money Link Card E-Age',
'622203'	=> 'CN ICBC Peony Money Link Card E-Age',
'622208'	=> 'CN ICBC Elite Club Account Card',
'622210'	=> 'CN ICBC Peony Quasi-Credit Card',
'622212'	=> 'Chong Hing Bank China Unionpay Gift Card (HK)',
'622226'	=> 'Bank of Communications Pacific Card Debit Card',
'622252'	=> 'BestBuy UnionPay Credit Card by Bank of Communications/HSBC',
'622260'	=> 'Bank of Communications China CUP Special Edition Debit',
'622372'	=> 'The Bank of East Asia UnionPay Dual Currency Platinum',
'622309'	=> 'Zheshang Bank Debit Card (CN)',
'622379'	=> 'Qilu Bank Debit Card (CN)',
'622381'	=> 'CCB (Asia) CUP Credit Card (HK)',
'622409'	=> 'Hang Seng Bank Green Banking Smart Card',
'622410'	=> 'Hang Seng Bank Hang Seng Card - Debit (HK)',
'622427'	=> 'Taizhou Bank DaTang Debit card (CN)',
'622492'	=> 'DBS Octopus ATM Card - Debit (HK)',
'6225'	=> 'Shanghai Pudong Development Bank UnionPay',
'622568'	=> 'Guangdong Development Bank Debit(China UnionPay)',
'622630-622633'	=> 'China Huaxia Bank Debit card, China Unionpay',
'622659'	=> 'CHINA EVERBRIGHT BANK Debit and Credit All in One Card',
'622700'	=> 'China Construction Bank Debit(China UnionPay) Card',
'622752'	=> 'Bank of China China UnionPay Credit Card (CN)',
'622789'	=> 'Bank of China China UnionPay Platinum Credit Card',
'622933'	=> 'Bank of East Asia UnionPay Debit Card (HK)',
'622942'	=> 'Standard Chartered UnionPay Debit Card (HK)',
'622974'	=> 'AEON Prepaid UnionPay Card (HK)',
'625008'	=> 'Chong Hing Bank UnionPay Dual Currency Credit Card (HK)',
'625028'	=> 'Bank of Communications Dual Currency Diamond Credit',
'625029'	=> 'Bank of Communications Dual Currency Gold Credit',
'625040'	=> 'Bank of China UnionPay Dual Currency Gold Credit',
'625041'	=> 'Bank of China UnionPay Dual Currency Gold Credit',
'625042'	=> 'Bank of China UnionPay Dual Currency Platinum',
'625043'	=> 'Bank of China UnionPay Dual Currency Platinum',
'625063'	=> 'Wing Lung Bank UnionPay Dual Currency Platinum',
'6253'	=> 'BC Card CUP Credit Card',
'627397'	=> 'Wild Oats Gift Card',
'627421'	=> 'Aeroplan (Air Canada)',
'627425'	=> 'Disney Rewards Card (Chase) 627692 - Dexit',
'6277'	=> 'iCard (ICICI Bank Canada)',
'627895'	=> 'virtual money inc',
'628181'	=> 'Sears Card (Chase Cards Canada)',
'630490'	=> 'Bank of Ireland Laser/Maestro debit card',
'630495'	=> 'National Irish Bank Laser/Maestro debit card',
'630499'	=> 'permanent tsb Laser/Maestro debit card',
'63191'	=> 'British Home Stores - Bhs credit card',
'633174'	=> 'Co-operative membership card',
'633300-633349'	=> 'Maestro Cards',
'633450-633499'	=> 'Solo Cards',
'633513'	=> 'Midlands Co-operative Society membership card',
'633540'	=> 'Argos Card',
'633625'	=> 'National Savings & Investments (UK)',
'633641'	=> 'Post Office Card Account card',
'633675'	=> 'G-T-P Group Ltd Payment Card',
'633676'	=> 'HMV Gift Card',
'633698'	=> 'G-T-P Group Ltd Prepaid Card',
'633791'	=> 'Commonwealth Finance Solutions Ltd',
'633834'	=> 'Debenhams Store Card by Santander Plc',
'633845'	=> 'Subway Subcard (UK)',
'634001'	=> 'Tesco Personal Finnace',
'634004'	=> 'Tesco Clubcard',
'634005'	=> 'Tesco Fuelcard',
'634008'	=> 'Tesco Personal Finnace',
'634009'	=> 'Tesco Tesco Clubcard (Poland)',
'635608'	=> 'Origin Compower',
'635629'	=> 'Origin Compower',
'63563'	=> 'Ventura',
'6356500'	=> 'Harrods',
'6360'	=> 'BC Card[6]',
'636325'	=> 'Sahand Samaneh Mahpa Co Loyalty Card (IR)',
'636587'	=> 'Worldstar Freedom Plus',
'639231'	=> 'Comprocard (Comprocard)',
'639300'	=> 'Malina loyalty card (RU)',
'6541'	=> 'BC Card BC Global',
'6556'	=> 'BC Card BC Global',
'6660'	=> 'Citibank ATM Card (Hong Kong)',
'670695'	=> 'Allied Irish Banks Maestro/Laser card (Ireland)',
'6709'	=> 'Laser Debit Card',
'6718'	=> 'RBS Cashline ATM Cards, Cirrus Branded',
'672'	=> 'girocard Debit Cards (Germany)',
'673'	=> 'Debit Cards (the Netherlands)',
'6759'	=> 'VARIOUS BANKS (UK) - Maestro (formerly Switch) debit cards',
'675922'	=> 'Clydesdale Bank Maestro debit card',
'675940'	=> 'HSBC (UK) Maestro Debit card',
'675964'	=> 'RBS Maestro Debit Card, with L100 Cheque Guarantee',
'675967'	=> 'NatWest Maestro Debit Card, with L100 Cheque Guarantee',
'675968'	=> 'NatWest Maestro Debit Card, with L250 Cheque Guarantee',
'6761'	=> 'Maestro debit card',
'676165'	=> 'Maestro debit card - CSOB Bank (CZ)',
'676280'	=> 'Maestro debit card - Sberbank (RU)',
'676378'	=> 'BZ-WBK (PL) - Maestro PayPass',
'676398'	=> 'ING Bank Slaski (PL) - Maestro PayPass',
'676481'	=> 'HSBC Bank (Turkey) - Maestro debit card',
'676509'	=> 'GENERALI BANK (IT) - Maestro debit card',
'676613'	=> 'Citibank (PL) - Maestro debit card',
'6767'	=> 'VARIOUS BANKS (UK) - Solo',
'676953'	=> 'Pekao (PL) - Maestro debit card',
'676969'	=> 'Eurobank EFG (GR) - Maestro debit card',
'6771'	=> 'VARIOUS BANKS - Laser debit card',
'677310'	=> 'Garantibank (RO)',
'677518'	=> 'SMP Bank (Russia) - Moscow Metro Express',
'677574'	=> 'Intesa SanPaolo - Maestro debit card',
'677594'	=> 'Alior Bank (PL) - Maestro debit card',
'690149'	=> 'IAPA Frequent Flyers Card',
'7001'	=> 'Best Buy Credit Card (HSBC Bank Nevada)',
'700247'	=> 'Priority Pass Passenger Card',
'7021'	=> 'Best Buy Credit Card (HSBC Bank Nevada)',
'7069'	=> 'Petro-Canada (Petro-Points loyalty program)',
'778900'	=> 'Perekrestok X5Club loyalty program, Russia',
'926366'	=> 'Kaubamaja/Selver Parnerkaart, Estonia',
'923362'	=> 'Swedbank, Estonia, Temporary (30 day) ATM Card',
'9280'	=> 'BSW Bonus Card (www.bsw.de)',
);

# expand ranges in hash
#
# input:	pointer to hash
# returns:	nothing
#
# expands keys of the form: 123-125 to 123, 124, 125 pointing to the same value


sub _re_range {
  my $hp = $_[0];
  my @ranges = grep { /\-/ } keys %$hp;
  foreach (@ranges) {
    my $val = delete $hp->{$_};
    my($n,$end) = split('-',$_);
    for (; $n <= $end; $n++) {
      $hp->{$n} = $val
	unless exists $hp->{$n};
    }
  }
}

# expand ranges in CCsecondary
#
_re_range(\%CCsecondary);

1;

__END__

=head1 NAME

Business::CCCheck::CardID - provides data structures with credit card issuer information

=head1 SYNOPSIS

  use Business::CCCheck::CardID;

=head1 DESCRIPTION

This module contains credit card prefixes and descriptions in three hashes.
The hashes are of the form:

  'credit card prefix' => 'description',
   ...

  i.e. '12345' => 'XYZ Bank Gold Card',


=head1 EXPORTS

Three (3) hashes:

 %CCprimary     a few short prefixes covering most issuers
 %CCsecondary   many prefixes covering detail of issuers
 %enRoute       card numbers that do not have parity

These three hashes do not completely overlap. The 'primary' hash usually
covers many issuers included in the 'secondary' hash. 

The 'secondary' hash will include some issuers not covered in 'primary'.

'enRoute' contains prefix's for cards that do not have parity

=head1 AUTHOR

Michael Robinton, E<lt>michael@bizsystems.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2012, Michael Robinton E<lt>michael@bizsystems.comE<gt>

This module is licensed under the "Creative Commons Attribution-ShareAlike
3.0 Unported License", a copy of which can be found in the file
"Creative-Commons" included with this distribution or at
http://creativecommons.org/licenses/by-sa/3.0/.

This module is also licensed under the terms of the GNU Free Documentation
License, Version 1.3 or any later version published by the Free Software
Foundation; with no Invariant Sections, no Front-Cover Texts, and no
Back-Cover Texts, a copy of which can be found in the file "GNU-Free" or at
http://http://www.gnu.org/copyleft/fdl.html

You may license this module under either or both of the above licenses.

=cut

1;
