/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.type;

import java.io.Serializable;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;

public abstract class Type
implements Serializable {
    public static final short ELEMENT = 1;
    public static final short ATTRIBUTE = 2;
    public static final short TEXT = 3;
    public static final short WHITESPACE_TEXT = 4;
    public static final short PROCESSING_INSTRUCTION = 7;
    public static final short COMMENT = 8;
    public static final short DOCUMENT = 9;
    public static final short NAMESPACE = 13;
    public static final short STOPPER = 11;
    public static final short PARENT_POINTER = 12;
    public static final short NODE = 0;
    public static final ItemType NODE_TYPE = AnyNodeTest.getInstance();
    public static final short ITEM = 88;
    public static final ItemType ITEM_TYPE = AnyItemType.getInstance();
    public static final short FUNCTION = 99;
    public static final short MAX_NODE_TYPE = 13;
    public static final short EMPTY = 15;

    private Type() {
    }

    public static boolean isNodeType(ItemType type) {
        return type instanceof NodeTest;
    }

    public static ItemType getItemType(Item item, TypeHierarchy th) {
        if (item instanceof AtomicValue) {
            return ((AtomicValue)item).getItemType(th);
        }
        if (item instanceof NodeInfo) {
            return NodeKindTest.makeNodeKindTest(((NodeInfo)item).getNodeKind());
        }
        return ((FunctionItem)item).getFunctionItemType(th);
    }

    public static String displayTypeName(Item item) {
        if (item instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)item;
            switch (node.getNodeKind()) {
                case 9: {
                    return "document-node()";
                }
                case 1: {
                    SchemaType annotation = node.getSchemaType();
                    return "element(" + ((NodeInfo)item).getDisplayName() + ", " + annotation.getDisplayName() + ')';
                }
                case 2: {
                    SchemaType annotation2 = node.getSchemaType();
                    return "attribute(" + ((NodeInfo)item).getDisplayName() + ", " + annotation2.getDisplayName() + ')';
                }
                case 3: {
                    return "text()";
                }
                case 8: {
                    return "comment()";
                }
                case 7: {
                    return "processing-instruction()";
                }
                case 13: {
                    return "namespace()";
                }
            }
            return "";
        }
        if (item instanceof ObjectValue) {
            return ((ObjectValue)item).displayTypeName();
        }
        return ((AtomicValue)item).getItemType(null).toString();
    }

    public static ItemType getBuiltInItemType(String namespace, String localName) {
        SchemaType t = BuiltInType.getSchemaType(StandardNames.getFingerprint(namespace, localName));
        if (t instanceof ItemType) {
            return (ItemType)((Object)t);
        }
        return null;
    }

    public static SimpleType getBuiltInSimpleType(String namespace, String localName) {
        SchemaType t = BuiltInType.getSchemaType(StandardNames.getFingerprint(namespace, localName));
        if (t instanceof SimpleType && ((SimpleType)t).isBuiltInType()) {
            return (SimpleType)t;
        }
        return null;
    }

    public static ItemType getCommonSuperType(ItemType t1, ItemType t2, TypeHierarchy th) {
        if (t1 == t2) {
            return t1;
        }
        if (t1 instanceof EmptySequenceTest) {
            return t2;
        }
        if (t2 instanceof EmptySequenceTest) {
            return t1;
        }
        int r = th.relationship(t1, t2);
        if (r == 0) {
            return t1;
        }
        if (r == 2) {
            return t2;
        }
        if (r == 1) {
            return t1;
        }
        ItemType st = t2.getSuperType(th);
        if (st == null) {
            return AnyItemType.getInstance();
        }
        return Type.getCommonSuperType(st, t1, th);
    }

    public static ItemType getCommonSuperType(ItemType t1, ItemType t2) {
        if (t1 == t2) {
            return t1;
        }
        if (t1 instanceof EmptySequenceTest) {
            return t2;
        }
        if (t2 instanceof EmptySequenceTest) {
            return t1;
        }
        if (t1 == AnyItemType.getInstance() || t2 == AnyItemType.getInstance()) {
            return AnyItemType.getInstance();
        }
        if (t1.getPrimitiveItemType() == t2.getPrimitiveItemType()) {
            return t1.getPrimitiveItemType();
        }
        if (t1.isAtomicType() && t2.isAtomicType()) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        if (t1 instanceof NodeTest && t2 instanceof NodeTest) {
            return AnyNodeTest.getInstance();
        }
        if (t1 instanceof FunctionItemType && t2 instanceof FunctionItemType) {
            return AnyFunctionType.getInstance();
        }
        return AnyItemType.getInstance();
    }

    public static boolean isPrimitiveType(int code) {
        return code >= 0 && (code <= 533 || code == 635 || code == 631 || code == 632 || code == 634 || code == 633 || code == 573);
    }

    public static boolean isComparable(BuiltInAtomicType t1, BuiltInAtomicType t2, boolean ordered) {
        if (t1 == t2) {
            return true;
        }
        if (t1.equals(BuiltInAtomicType.ANY_ATOMIC) || t2.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            return true;
        }
        if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            t1 = BuiltInAtomicType.STRING;
        }
        if (t2.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            t2 = BuiltInAtomicType.STRING;
        }
        if (t1.equals(BuiltInAtomicType.ANY_URI)) {
            t1 = BuiltInAtomicType.STRING;
        }
        if (t2.equals(BuiltInAtomicType.ANY_URI)) {
            t2 = BuiltInAtomicType.STRING;
        }
        if (t1.isPrimitiveNumeric()) {
            t1 = BuiltInAtomicType.NUMERIC;
        }
        if (t2.isPrimitiveNumeric()) {
            t2 = BuiltInAtomicType.NUMERIC;
        }
        if (!ordered) {
            if (t1.equals(BuiltInAtomicType.DAY_TIME_DURATION)) {
                t1 = BuiltInAtomicType.DURATION;
            }
            if (t2.equals(BuiltInAtomicType.DAY_TIME_DURATION)) {
                t2 = BuiltInAtomicType.DURATION;
            }
            if (t1.equals(BuiltInAtomicType.YEAR_MONTH_DURATION)) {
                t1 = BuiltInAtomicType.DURATION;
            }
            if (t2.equals(BuiltInAtomicType.YEAR_MONTH_DURATION)) {
                t2 = BuiltInAtomicType.DURATION;
            }
        }
        return t1 == t2;
    }

    public static boolean isGenerallyComparable(BuiltInAtomicType t1, BuiltInAtomicType t2, boolean ordered) {
        return t1.equals(BuiltInAtomicType.ANY_ATOMIC) || t2.equals(BuiltInAtomicType.ANY_ATOMIC) || t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || t2.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || Type.isComparable(t1, t2, ordered);
    }

    public static boolean isGuaranteedGenerallyComparable(BuiltInAtomicType t1, BuiltInAtomicType t2, boolean ordered) {
        return !t1.equals(BuiltInAtomicType.ANY_ATOMIC) && !t2.equals(BuiltInAtomicType.ANY_ATOMIC) && Type.isGenerallyComparable(t1, t2, ordered);
    }
}

